<?php
// This file was auto-generated from sdk-root/src/data/es/2015-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Elasticsearch Configuration Service</fullname> <p>Use the Amazon Elasticsearch Configuration API to create, configure, and manage Elasticsearch domains.</p> <p>For sample code that uses the Configuration API, see the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-samples.html">Amazon Elasticsearch Service Developer Guide</a>. The guide also contains <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-request-signing.html">sample code for sending signed HTTP requests to the Elasticsearch APIs</a>.</p> <p>The endpoint for configuration service requests is region-specific: es.<i>region</i>.amazonaws.com. For example, es.us-east-1.amazonaws.com. For a current list of supported regions and endpoints, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#elasticsearch-service-regions" target="_blank">Regions and Endpoints</a>.</p>', 'operations' => [ 'AcceptInboundCrossClusterSearchConnection' => '<p>Allows the destination domain owner to accept an inbound cross-cluster search connection request.</p>', 'AddTags' => '<p>Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging" target="_blank"> Tagging Amazon Elasticsearch Service Domains for more information.</a></p>', 'AssociatePackage' => '<p>Associates a package with an Amazon ES domain.</p>', 'CancelElasticsearchServiceSoftwareUpdate' => '<p>Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code> state.</p>', 'CreateElasticsearchDomain' => '<p>Creates a new Elasticsearch domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>', 'CreateOutboundCrossClusterSearchConnection' => '<p>Creates a new cross-cluster search connection from a source domain to a destination domain.</p>', 'CreatePackage' => '<p>Create a package for use with Amazon ES domains.</p>', 'DeleteElasticsearchDomain' => '<p>Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.</p>', 'DeleteElasticsearchServiceRole' => '<p>Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr" target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i>.</p>', 'DeleteInboundCrossClusterSearchConnection' => '<p>Allows the destination domain owner to delete an existing inbound cross-cluster search connection.</p>', 'DeleteOutboundCrossClusterSearchConnection' => '<p>Allows the source domain owner to delete an existing outbound cross-cluster search connection.</p>', 'DeletePackage' => '<p>Delete the package.</p>', 'DescribeDomainAutoTunes' => '<p>Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.</p>', 'DescribeElasticsearchDomain' => '<p>Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.</p>', 'DescribeElasticsearchDomainConfig' => '<p>Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.</p>', 'DescribeElasticsearchDomains' => '<p>Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.</p>', 'DescribeElasticsearchInstanceTypeLimits' => '<p> Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain, specify the <code> <a>DomainName</a> </code> to know what Limits are supported for modifying. </p>', 'DescribeInboundCrossClusterSearchConnections' => '<p>Lists all the inbound cross-cluster search connections for a destination domain.</p>', 'DescribeOutboundCrossClusterSearchConnections' => '<p>Lists all the outbound cross-cluster search connections for a source domain.</p>', 'DescribePackages' => '<p>Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results, and pagination.</p>', 'DescribeReservedElasticsearchInstanceOfferings' => '<p>Lists available reserved Elasticsearch instance offerings.</p>', 'DescribeReservedElasticsearchInstances' => '<p>Returns information about reserved Elasticsearch instances for this account.</p>', 'DissociatePackage' => '<p>Dissociates a package from the Amazon ES domain.</p>', 'GetCompatibleElasticsearchVersions' => '<p> Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a <code> <a>DomainName</a> </code> to get all upgrade compatible Elasticsearch versions for that specific domain. </p>', 'GetPackageVersionHistory' => '<p>Returns a list of versions of the package, along with their creation time and commit message.</p>', 'GetUpgradeHistory' => '<p>Retrieves the complete history of the last 10 upgrades that were performed on the domain.</p>', 'GetUpgradeStatus' => '<p>Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.</p>', 'ListDomainNames' => '<p>Returns the name of all Elasticsearch domains owned by the current user\'s account. </p>', 'ListDomainsForPackage' => '<p>Lists all Amazon ES domains associated with the package.</p>', 'ListElasticsearchInstanceTypes' => '<p>List all Elasticsearch instance types that are supported for given ElasticsearchVersion</p>', 'ListElasticsearchVersions' => '<p>List all supported Elasticsearch versions</p>', 'ListPackagesForDomain' => '<p>Lists all packages associated with the Amazon ES domain.</p>', 'ListTags' => '<p>Returns all tags for the given Elasticsearch domain.</p>', 'PurchaseReservedElasticsearchInstanceOffering' => '<p>Allows you to purchase reserved Elasticsearch instances.</p>', 'RejectInboundCrossClusterSearchConnection' => '<p>Allows the destination domain owner to reject an inbound cross-cluster search connection request.</p>', 'RemoveTags' => '<p>Removes the specified set of tags from the specified Elasticsearch domain.</p>', 'StartElasticsearchServiceSoftwareUpdate' => '<p>Schedules a service software update for an Amazon ES domain.</p>', 'UpdateElasticsearchDomainConfig' => '<p>Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances. </p>', 'UpdatePackage' => '<p>Updates a package for use with Amazon ES domains.</p>', 'UpgradeElasticsearchDomain' => '<p>Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch version.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the Elasticsearch domain. See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>', 'refs' => [ 'AddTagsRequest$ARN' => '<p> Specify the <code>ARN</code> for which you want to add the tags.</p>', 'DomainEndpointOptions$CustomEndpointCertificateArn' => '<p>Specify ACM certificate ARN for your custom endpoint.</p>', 'ElasticsearchDomainStatus$ARN' => '<p>The Amazon resource name (ARN) of an Elasticsearch domain. See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>', 'ListTagsRequest$ARN' => '<p> Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view.</p>', 'MasterUserOptions$MasterUserARN' => '<p>ARN for the master user (if IAM is enabled).</p>', 'RemoveTagsRequest$ARN' => '<p>Specifies the <code>ARN</code> for the Elasticsearch domain from which you want to delete the specified tags.</p>', ], ], 'AcceptInboundCrossClusterSearchConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>AcceptInboundCrossClusterSearchConnection</a></code> operation.</p>', 'refs' => [], ], 'AcceptInboundCrossClusterSearchConnectionResponse' => [ 'base' => '<p>The result of a <code><a>AcceptInboundCrossClusterSearchConnection</a></code> operation. Contains details of accepted inbound connection.</p>', 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>An error occurred because user does not have permissions to access the resource. Returns HTTP status code 403.</p>', 'refs' => [], ], 'AccessPoliciesStatus' => [ 'base' => '<p>The configured access rules for the domain\'s document and search endpoints, and the current status of those rules.</p>', 'refs' => [ 'ElasticsearchDomainConfig$AccessPolicies' => '<p>IAM access policy as a JSON-formatted string.</p>', ], ], 'AddTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>AddTags</a></code> operation. Specify the tags that you want to attach to the Elasticsearch domain.</p>', 'refs' => [], ], 'AdditionalLimit' => [ 'base' => '<p> List of limits that are specific to a given InstanceType and for each of it\'s <code> <a>InstanceRole</a> </code> . </p>', 'refs' => [ 'AdditionalLimitList$member' => NULL, ], ], 'AdditionalLimitList' => [ 'base' => NULL, 'refs' => [ 'Limits$AdditionalLimits' => '<p> List of additional limits that are specific to a given InstanceType and for each of it\'s <code> <a>InstanceRole</a> </code> . </p>', ], ], 'AdvancedOptions' => [ 'base' => '<p> Exposes select native Elasticsearch configuration values from <code>elasticsearch.yml</code>. Currently, the following advanced options are available:</p> <ul> <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</li> <li>Option to specify the percentage of heap space that is allocated to field data. By default, this setting is unbounded.</li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options">Configuring Advanced Options</a>.</p>', 'refs' => [ 'AdvancedOptionsStatus$Options' => '<p> Specifies the status of advanced options for the specified Elasticsearch domain.</p>', 'CreateElasticsearchDomainRequest$AdvancedOptions' => '<p> Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>', 'ElasticsearchDomainStatus$AdvancedOptions' => '<p>Specifies the status of the <code>AdvancedOptions</code></p>', 'UpdateElasticsearchDomainConfigRequest$AdvancedOptions' => '<p>Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</p>', ], ], 'AdvancedOptionsStatus' => [ 'base' => '<p> Status of the advanced options for the specified Elasticsearch domain. Currently, the following advanced options are available:</p> <ul> <li>Option to allow references to indices in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuration Advanced Options</a> for more information.</li> <li>Option to specify the percentage of heap space that is allocated to field data. By default, this setting is unbounded.</li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options">Configuring Advanced Options</a>.</p>', 'refs' => [ 'ElasticsearchDomainConfig$AdvancedOptions' => '<p>Specifies the <code>AdvancedOptions</code> for the domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options" target="_blank">Configuring Advanced Options</a> for more information.</p>', ], ], 'AdvancedSecurityOptions' => [ 'base' => '<p>Specifies the advanced security configuration: whether advanced security is enabled, whether the internal database option is enabled.</p>', 'refs' => [ 'AdvancedSecurityOptionsStatus$Options' => '<p> Specifies advanced security options for the specified Elasticsearch domain.</p>', 'ElasticsearchDomainStatus$AdvancedSecurityOptions' => '<p>The current status of the Elasticsearch domain\'s advanced security options.</p>', ], ], 'AdvancedSecurityOptionsInput' => [ 'base' => '<p>Specifies the advanced security configuration: whether advanced security is enabled, whether the internal database option is enabled, master username and password (if internal database is enabled), and master user ARN (if IAM is enabled).</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$AdvancedSecurityOptions' => '<p>Specifies advanced security options.</p>', 'UpdateElasticsearchDomainConfigRequest$AdvancedSecurityOptions' => '<p>Specifies advanced security options.</p>', ], ], 'AdvancedSecurityOptionsStatus' => [ 'base' => '<p> Specifies the status of advanced security options for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$AdvancedSecurityOptions' => '<p>Specifies <code>AdvancedSecurityOptions</code> for the domain. </p>', ], ], 'AssociatePackageRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>AssociatePackage</a> </code> operation. </p>', 'refs' => [], ], 'AssociatePackageResponse' => [ 'base' => '<p> Container for response returned by <code> <a>AssociatePackage</a> </code> operation. </p>', 'refs' => [], ], 'AutoTune' => [ 'base' => '<p>Specifies Auto-Tune type and Auto-Tune action details. </p>', 'refs' => [ 'AutoTuneList$member' => NULL, ], ], 'AutoTuneDate' => [ 'base' => '<p>Specifies timestamp for the Auto-Tune action scheduled for the domain. </p>', 'refs' => [ 'ScheduledAutoTuneDetails$Date' => '<p>Specifies timestamp for the Auto-Tune action scheduled for the domain. </p>', ], ], 'AutoTuneDesiredState' => [ 'base' => '<p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.</p>', 'refs' => [ 'AutoTuneOptions$DesiredState' => '<p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED. </p>', 'AutoTuneOptionsInput$DesiredState' => '<p>Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED. </p>', ], ], 'AutoTuneDetails' => [ 'base' => '<p>Specifies details of the Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>', 'refs' => [ 'AutoTune$AutoTuneDetails' => '<p>Specifies details of the Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>', ], ], 'AutoTuneList' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainAutoTunesResponse$AutoTunes' => '<p>Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', ], ], 'AutoTuneMaintenanceSchedule' => [ 'base' => '<p>Specifies Auto-Tune maitenance schedule. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', 'refs' => [ 'AutoTuneMaintenanceScheduleList$member' => NULL, ], ], 'AutoTuneMaintenanceScheduleList' => [ 'base' => NULL, 'refs' => [ 'AutoTuneOptions$MaintenanceSchedules' => '<p>Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', 'AutoTuneOptionsInput$MaintenanceSchedules' => '<p>Specifies list of maitenance schedules. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', ], ], 'AutoTuneOptions' => [ 'base' => '<p>Specifies the Auto-Tune options: the Auto-Tune desired state for the domain, rollback state when disabling Auto-Tune options and list of maintenance schedules.</p>', 'refs' => [ 'AutoTuneOptionsStatus$Options' => '<p> Specifies Auto-Tune options for the specified Elasticsearch domain.</p>', 'UpdateElasticsearchDomainConfigRequest$AutoTuneOptions' => '<p>Specifies Auto-Tune options.</p>', ], ], 'AutoTuneOptionsInput' => [ 'base' => '<p>Specifies the Auto-Tune options: the Auto-Tune desired state for the domain and list of maintenance schedules.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$AutoTuneOptions' => '<p>Specifies Auto-Tune options.</p>', ], ], 'AutoTuneOptionsOutput' => [ 'base' => '<p>Specifies the Auto-Tune options: the Auto-Tune desired state for the domain and list of maintenance schedules.</p>', 'refs' => [ 'ElasticsearchDomainStatus$AutoTuneOptions' => '<p>The current status of the Elasticsearch domain\'s Auto-Tune options.</p>', ], ], 'AutoTuneOptionsStatus' => [ 'base' => '<p> Specifies the status of Auto-Tune options for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$AutoTuneOptions' => '<p>Specifies <code>AutoTuneOptions</code> for the domain. </p>', ], ], 'AutoTuneState' => [ 'base' => '<p>Specifies the Auto-Tune state for the Elasticsearch domain. For valid states see the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a>.</p>', 'refs' => [ 'AutoTuneOptionsOutput$State' => '<p>Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.</p>', 'AutoTuneStatus$State' => '<p>Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.</p>', ], ], 'AutoTuneStatus' => [ 'base' => '<p>Provides the current status of the Auto-Tune options. </p>', 'refs' => [ 'AutoTuneOptionsStatus$Status' => '<p> Specifies Status of the Auto-Tune options for the specified Elasticsearch domain.</p>', ], ], 'AutoTuneType' => [ 'base' => '<p>Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION. </p>', 'refs' => [ 'AutoTune$AutoTuneType' => '<p>Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION. </p>', ], ], 'BackendRole' => [ 'base' => NULL, 'refs' => [ 'SAMLOptionsInput$MasterBackendRole' => '<p>The backend role to which the SAML master user is mapped to.</p>', ], ], 'BaseException' => [ 'base' => '<p>An error occurred while processing the request.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AdvancedSecurityOptions$Enabled' => '<p>True if advanced security is enabled.</p>', 'AdvancedSecurityOptions$InternalUserDatabaseEnabled' => '<p>True if the internal user database is enabled.</p>', 'AdvancedSecurityOptionsInput$Enabled' => '<p>True if advanced security is enabled.</p>', 'AdvancedSecurityOptionsInput$InternalUserDatabaseEnabled' => '<p>True if the internal user database is enabled.</p>', 'AutoTuneStatus$PendingDeletion' => '<p>Indicates whether the Elasticsearch domain is being deleted.</p>', 'CognitoOptions$Enabled' => '<p>Specifies the option to enable Cognito for Kibana authentication.</p>', 'ColdStorageOptions$Enabled' => '<p>True to enable cold storage for an Elasticsearch domain.</p>', 'DomainEndpointOptions$EnforceHTTPS' => '<p>Specify if only HTTPS endpoint should be enabled for the Elasticsearch domain.</p>', 'DomainEndpointOptions$CustomEndpointEnabled' => '<p>Specify if custom endpoint should be enabled for the Elasticsearch domain.</p>', 'EBSOptions$EBSEnabled' => '<p>Specifies whether EBS-based storage is enabled.</p>', 'ElasticsearchClusterConfig$DedicatedMasterEnabled' => '<p>A boolean value to indicate whether a dedicated master node is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes" target="_blank">About Dedicated Master Nodes</a> for more information.</p>', 'ElasticsearchClusterConfig$ZoneAwarenessEnabled' => '<p>A boolean value to indicate whether zone awareness is enabled. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness" target="_blank">About Zone Awareness</a> for more information.</p>', 'ElasticsearchClusterConfig$WarmEnabled' => '<p>True to enable warm storage.</p>', 'ElasticsearchDomainStatus$Created' => '<p>The domain creation status. <code>True</code> if the creation of an Elasticsearch domain is complete. <code>False</code> if domain creation is still in progress.</p>', 'ElasticsearchDomainStatus$Deleted' => '<p>The domain deletion status. <code>True</code> if a delete request has been received for the domain but resource cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once domain deletion is complete, the status of the domain is no longer returned.</p>', 'ElasticsearchDomainStatus$Processing' => '<p>The status of the Elasticsearch domain configuration. <code>True</code> if Amazon Elasticsearch Service is processing configuration changes. <code>False</code> if the configuration is active.</p>', 'ElasticsearchDomainStatus$UpgradeProcessing' => '<p>The status of an Elasticsearch domain version upgrade. <code>True</code> if Amazon Elasticsearch Service is undergoing a version upgrade. <code>False</code> if the configuration is active.</p>', 'EncryptionAtRestOptions$Enabled' => '<p>Specifies the option to enable Encryption At Rest.</p>', 'LogPublishingOption$Enabled' => '<p> Specifies whether given log publishing option is enabled or not.</p>', 'NodeToNodeEncryptionOptions$Enabled' => '<p>Specify true to enable node-to-node encryption.</p>', 'OptionStatus$PendingDeletion' => '<p>Indicates whether the Elasticsearch domain is being deleted.</p>', 'SAMLOptionsInput$Enabled' => '<p>True if SAML is enabled.</p>', 'SAMLOptionsOutput$Enabled' => '<p>True if SAML is enabled.</p>', 'ServiceSoftwareOptions$UpdateAvailable' => '<p><code>True</code> if you are able to update you service software version. <code>False</code> if you are not able to update your service software version. </p>', 'ServiceSoftwareOptions$Cancellable' => '<p><code>True</code> if you are able to cancel your service software version update. <code>False</code> if you are not able to cancel your service software version. </p>', 'ServiceSoftwareOptions$OptionalDeployment' => '<p><code>True</code> if a service software is never automatically updated. <code>False</code> if a service software is automatically updated after <code>AutomatedUpdateDate</code>. </p>', 'UpgradeElasticsearchDomainRequest$PerformCheckOnly' => '<p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>', 'UpgradeElasticsearchDomainResponse$PerformCheckOnly' => '<p> This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not actually perform the Upgrade. </p>', ], ], 'CancelElasticsearchServiceSoftwareUpdateRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>CancelElasticsearchServiceSoftwareUpdate</a></code> operation. Specifies the name of the Elasticsearch domain that you wish to cancel a service software update on.</p>', 'refs' => [], ], 'CancelElasticsearchServiceSoftwareUpdateResponse' => [ 'base' => '<p>The result of a <code>CancelElasticsearchServiceSoftwareUpdate</code> operation. Contains the status of the update.</p>', 'refs' => [], ], 'CloudWatchLogsLogGroupArn' => [ 'base' => '<p>ARN of the Cloudwatch log group to which log needs to be published.</p>', 'refs' => [ 'LogPublishingOption$CloudWatchLogsLogGroupArn' => NULL, ], ], 'CognitoOptions' => [ 'base' => '<p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>', 'refs' => [ 'CognitoOptionsStatus$Options' => '<p>Specifies the Cognito options for the specified Elasticsearch domain.</p>', 'CreateElasticsearchDomainRequest$CognitoOptions' => '<p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>', 'ElasticsearchDomainStatus$CognitoOptions' => '<p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>', 'UpdateElasticsearchDomainConfigRequest$CognitoOptions' => '<p>Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>', ], ], 'CognitoOptionsStatus' => [ 'base' => '<p>Status of the Cognito options for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$CognitoOptions' => '<p>The <code>CognitoOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html" target="_blank">Amazon Cognito Authentication for Kibana</a>.</p>', ], ], 'ColdStorageOptions' => [ 'base' => '<p>Specifies settings for cold storage.</p>', 'refs' => [ 'ElasticsearchClusterConfig$ColdStorageOptions' => '<p>Specifies the <code>ColdStorageOptions</code> configuration for an Elasticsearch domain.</p>', ], ], 'CommitMessage' => [ 'base' => NULL, 'refs' => [ 'PackageVersionHistory$CommitMessage' => '<p>A message associated with the version.</p>', 'UpdatePackageRequest$CommitMessage' => '<p>An info message for the new version which will be shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>', ], ], 'CompatibleElasticsearchVersionsList' => [ 'base' => NULL, 'refs' => [ 'GetCompatibleElasticsearchVersionsResponse$CompatibleElasticsearchVersions' => '<p> A map of compatible Elasticsearch versions returned as part of the <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation. </p>', ], ], 'CompatibleVersionsMap' => [ 'base' => '<p> A map from an <code> <a>ElasticsearchVersion</a> </code> to a list of compatible <code> <a>ElasticsearchVersion</a> </code> s to which the domain can be upgraded. </p>', 'refs' => [ 'CompatibleElasticsearchVersionsList$member' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP status code 409.</p>', 'refs' => [], ], 'ConnectionAlias' => [ 'base' => NULL, 'refs' => [ 'CreateOutboundCrossClusterSearchConnectionRequest$ConnectionAlias' => '<p>Specifies the connection alias that will be used by the customer for this connection.</p>', 'CreateOutboundCrossClusterSearchConnectionResponse$ConnectionAlias' => '<p>Specifies the connection alias provided during the create connection request.</p>', 'OutboundCrossClusterSearchConnection$ConnectionAlias' => '<p>Specifies the connection alias for the outbound cross-cluster search connection.</p>', ], ], 'CreateElasticsearchDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateElasticsearchDomainResponse' => [ 'base' => '<p>The result of a <code>CreateElasticsearchDomain</code> operation. Contains the status of the newly created Elasticsearch domain.</p>', 'refs' => [], ], 'CreateOutboundCrossClusterSearchConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>CreateOutboundCrossClusterSearchConnection</a></code> operation.</p>', 'refs' => [], ], 'CreateOutboundCrossClusterSearchConnectionResponse' => [ 'base' => '<p>The result of a <code><a>CreateOutboundCrossClusterSearchConnection</a></code> request. Contains the details of the newly created cross-cluster search connection.</p>', 'refs' => [], ], 'CreatePackageRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>CreatePackage</a> </code> operation. </p>', 'refs' => [], ], 'CreatePackageResponse' => [ 'base' => '<p> Container for response returned by <code> <a>CreatePackage</a> </code> operation. </p>', 'refs' => [], ], 'CreatedAt' => [ 'base' => NULL, 'refs' => [ 'PackageDetails$CreatedAt' => '<p>Timestamp which tells creation date of the package.</p>', 'PackageVersionHistory$CreatedAt' => '<p>Timestamp which tells creation time of the package version.</p>', ], ], 'CrossClusterSearchConnectionId' => [ 'base' => NULL, 'refs' => [ 'AcceptInboundCrossClusterSearchConnectionRequest$CrossClusterSearchConnectionId' => '<p>The id of the inbound connection that you want to accept.</p>', 'CreateOutboundCrossClusterSearchConnectionResponse$CrossClusterSearchConnectionId' => '<p>Unique id for the created outbound connection, which is used for subsequent operations on connection.</p>', 'DeleteInboundCrossClusterSearchConnectionRequest$CrossClusterSearchConnectionId' => '<p>The id of the inbound connection that you want to permanently delete.</p>', 'DeleteOutboundCrossClusterSearchConnectionRequest$CrossClusterSearchConnectionId' => '<p>The id of the outbound connection that you want to permanently delete.</p>', 'InboundCrossClusterSearchConnection$CrossClusterSearchConnectionId' => '<p>Specifies the connection id for the inbound cross-cluster search connection.</p>', 'OutboundCrossClusterSearchConnection$CrossClusterSearchConnectionId' => '<p>Specifies the connection id for the outbound cross-cluster search connection.</p>', 'RejectInboundCrossClusterSearchConnectionRequest$CrossClusterSearchConnectionId' => '<p>The id of the inbound connection that you want to reject.</p>', ], ], 'CrossClusterSearchConnectionStatusMessage' => [ 'base' => NULL, 'refs' => [ 'InboundCrossClusterSearchConnectionStatus$Message' => '<p>Specifies verbose information for the inbound connection status.</p>', 'OutboundCrossClusterSearchConnectionStatus$Message' => '<p>Specifies verbose information for the outbound connection status.</p>', ], ], 'DeleteElasticsearchDomainRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>DeleteElasticsearchDomain</a></code> operation. Specifies the name of the Elasticsearch domain that you want to delete.</p>', 'refs' => [], ], 'DeleteElasticsearchDomainResponse' => [ 'base' => '<p>The result of a <code>DeleteElasticsearchDomain</code> request. Contains the status of the pending deletion, or no status if the domain and all of its resources have been deleted.</p>', 'refs' => [], ], 'DeleteInboundCrossClusterSearchConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>DeleteInboundCrossClusterSearchConnection</a></code> operation.</p>', 'refs' => [], ], 'DeleteInboundCrossClusterSearchConnectionResponse' => [ 'base' => '<p>The result of a <code><a>DeleteInboundCrossClusterSearchConnection</a></code> operation. Contains details of deleted inbound connection.</p>', 'refs' => [], ], 'DeleteOutboundCrossClusterSearchConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>DeleteOutboundCrossClusterSearchConnection</a></code> operation.</p>', 'refs' => [], ], 'DeleteOutboundCrossClusterSearchConnectionResponse' => [ 'base' => '<p>The result of a <code><a>DeleteOutboundCrossClusterSearchConnection</a></code> operation. Contains details of deleted outbound connection.</p>', 'refs' => [], ], 'DeletePackageRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>DeletePackage</a> </code> operation. </p>', 'refs' => [], ], 'DeletePackageResponse' => [ 'base' => '<p> Container for response parameters to <code> <a>DeletePackage</a> </code> operation. </p>', 'refs' => [], ], 'DeploymentCloseDateTimeStamp' => [ 'base' => NULL, 'refs' => [ 'ServiceSoftwareOptions$AutomatedUpdateDate' => '<p>Timestamp, in Epoch time, until which you can manually request a service software update. After this date, we automatically update your service software.</p>', ], ], 'DeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'ServiceSoftwareOptions$UpdateStatus' => '<p>The status of your service software update. This field can take the following values: <code>ELIGIBLE</code>, <code>PENDING_UPDATE</code>, <code>IN_PROGRESS</code>, <code>COMPLETED</code>, and <code>NOT_ELIGIBLE</code>.</p>', ], ], 'DescribeDomainAutoTunesRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.</p>', 'refs' => [], ], 'DescribeDomainAutoTunesResponse' => [ 'base' => '<p>The result of <code>DescribeDomainAutoTunes</code> request. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>', 'refs' => [], ], 'DescribeElasticsearchDomainConfigRequest' => [ 'base' => '<p> Container for the parameters to the <code>DescribeElasticsearchDomainConfig</code> operation. Specifies the domain name for which you want configuration information.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainConfigResponse' => [ 'base' => '<p>The result of a <code>DescribeElasticsearchDomainConfig</code> request. Contains the configuration information of the requested domain.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>DescribeElasticsearchDomain</a></code> operation.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainResponse' => [ 'base' => '<p>The result of a <code>DescribeElasticsearchDomain</code> request. Contains the status of the domain specified in the request.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainsRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>DescribeElasticsearchDomains</a></code> operation. By default, the API returns the status of all Elasticsearch domains.</p>', 'refs' => [], ], 'DescribeElasticsearchDomainsResponse' => [ 'base' => '<p>The result of a <code>DescribeElasticsearchDomains</code> request. Contains the status of the specified domains or all domains owned by the account.</p>', 'refs' => [], ], 'DescribeElasticsearchInstanceTypeLimitsRequest' => [ 'base' => '<p> Container for the parameters to <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation. </p>', 'refs' => [], ], 'DescribeElasticsearchInstanceTypeLimitsResponse' => [ 'base' => '<p> Container for the parameters received from <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation. </p>', 'refs' => [], ], 'DescribeInboundCrossClusterSearchConnectionsRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>DescribeInboundCrossClusterSearchConnections</a></code> operation.</p>', 'refs' => [], ], 'DescribeInboundCrossClusterSearchConnectionsResponse' => [ 'base' => '<p>The result of a <code><a>DescribeInboundCrossClusterSearchConnections</a></code> request. Contains the list of connections matching the filter criteria.</p>', 'refs' => [], ], 'DescribeOutboundCrossClusterSearchConnectionsRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>DescribeOutboundCrossClusterSearchConnections</a></code> operation.</p>', 'refs' => [], ], 'DescribeOutboundCrossClusterSearchConnectionsResponse' => [ 'base' => '<p>The result of a <code><a>DescribeOutboundCrossClusterSearchConnections</a></code> request. Contains the list of connections matching the filter criteria.</p>', 'refs' => [], ], 'DescribePackagesFilter' => [ 'base' => '<p>Filter to apply in <code>DescribePackage</code> response.</p>', 'refs' => [ 'DescribePackagesFilterList$member' => NULL, ], ], 'DescribePackagesFilterList' => [ 'base' => '<p>A list of <code>DescribePackagesFilter</code> to filter the packages included in a <code>DescribePackages</code> response.</p>', 'refs' => [ 'DescribePackagesRequest$Filters' => '<p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>', ], ], 'DescribePackagesFilterName' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesFilter$Name' => '<p>Any field from <code>PackageDetails</code>.</p>', ], ], 'DescribePackagesFilterValue' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesFilterValues$member' => NULL, ], ], 'DescribePackagesFilterValues' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesFilter$Value' => '<p>A list of values for the specified field.</p>', ], ], 'DescribePackagesRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>DescribePackage</a> </code> operation. </p>', 'refs' => [], ], 'DescribePackagesResponse' => [ 'base' => '<p> Container for response returned by <code> <a>DescribePackages</a> </code> operation. </p>', 'refs' => [], ], 'DescribeReservedElasticsearchInstanceOfferingsRequest' => [ 'base' => '<p>Container for parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code></p>', 'refs' => [], ], 'DescribeReservedElasticsearchInstanceOfferingsResponse' => [ 'base' => '<p>Container for results from <code>DescribeReservedElasticsearchInstanceOfferings</code></p>', 'refs' => [], ], 'DescribeReservedElasticsearchInstancesRequest' => [ 'base' => '<p>Container for parameters to <code>DescribeReservedElasticsearchInstances</code></p>', 'refs' => [], ], 'DescribeReservedElasticsearchInstancesResponse' => [ 'base' => '<p>Container for results from <code>DescribeReservedElasticsearchInstances</code></p>', 'refs' => [], ], 'DisabledOperationException' => [ 'base' => '<p>An error occured because the client wanted to access a not supported operation. Gives http status code of 409.</p>', 'refs' => [], ], 'DissociatePackageRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>DissociatePackage</a> </code> operation. </p>', 'refs' => [], ], 'DissociatePackageResponse' => [ 'base' => '<p> Container for response returned by <code> <a>DissociatePackage</a> </code> operation. </p>', 'refs' => [], ], 'DomainEndpointOptions' => [ 'base' => '<p>Options to configure endpoint for the Elasticsearch domain.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$DomainEndpointOptions' => '<p>Options to specify configuration that will be applied to the domain endpoint.</p>', 'DomainEndpointOptionsStatus$Options' => '<p>Options to configure endpoint for the Elasticsearch domain.</p>', 'ElasticsearchDomainStatus$DomainEndpointOptions' => '<p>The current status of the Elasticsearch domain\'s endpoint options.</p>', 'UpdateElasticsearchDomainConfigRequest$DomainEndpointOptions' => '<p>Options to specify configuration that will be applied to the domain endpoint.</p>', ], ], 'DomainEndpointOptionsStatus' => [ 'base' => '<p>The configured endpoint options for the domain and their current status.</p>', 'refs' => [ 'ElasticsearchDomainConfig$DomainEndpointOptions' => '<p>Specifies the <code>DomainEndpointOptions</code> for the Elasticsearch domain.</p>', ], ], 'DomainId' => [ 'base' => '<p>Unique identifier for an Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainStatus$DomainId' => '<p>The unique identifier for the specified Elasticsearch domain.</p>', ], ], 'DomainInfo' => [ 'base' => NULL, 'refs' => [ 'DomainInfoList$member' => NULL, ], ], 'DomainInfoList' => [ 'base' => '<p> Contains the list of Elasticsearch domain information.</p>', 'refs' => [ 'ListDomainNamesResponse$DomainNames' => '<p>List of Elasticsearch domain names.</p>', ], ], 'DomainInformation' => [ 'base' => NULL, 'refs' => [ 'CreateOutboundCrossClusterSearchConnectionRequest$SourceDomainInfo' => '<p>Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.</p>', 'CreateOutboundCrossClusterSearchConnectionRequest$DestinationDomainInfo' => '<p>Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.</p>', 'CreateOutboundCrossClusterSearchConnectionResponse$SourceDomainInfo' => '<p>Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.</p>', 'CreateOutboundCrossClusterSearchConnectionResponse$DestinationDomainInfo' => '<p>Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.</p>', 'InboundCrossClusterSearchConnection$SourceDomainInfo' => '<p>Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.</p>', 'InboundCrossClusterSearchConnection$DestinationDomainInfo' => '<p>Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.</p>', 'OutboundCrossClusterSearchConnection$SourceDomainInfo' => '<p>Specifies the <code><a>DomainInformation</a></code> for the source Elasticsearch domain.</p>', 'OutboundCrossClusterSearchConnection$DestinationDomainInfo' => '<p>Specifies the <code><a>DomainInformation</a></code> for the destination Elasticsearch domain.</p>', ], ], 'DomainName' => [ 'base' => '<p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>', 'refs' => [ 'AssociatePackageRequest$DomainName' => '<p>Name of the domain that you want to associate the package with.</p>', 'CancelElasticsearchServiceSoftwareUpdateRequest$DomainName' => '<p>The name of the domain that you want to stop the latest service software update on.</p>', 'CreateElasticsearchDomainRequest$DomainName' => '<p>The name of the Elasticsearch domain that you are creating. Domain names are unique across the domains owned by an account within an AWS region. Domain names must start with a lowercase letter and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>', 'DeleteElasticsearchDomainRequest$DomainName' => '<p>The name of the Elasticsearch domain that you want to permanently delete.</p>', 'DescribeDomainAutoTunesRequest$DomainName' => '<p>Specifies the domain name for which you want Auto-Tune action details.</p>', 'DescribeElasticsearchDomainConfigRequest$DomainName' => '<p>The Elasticsearch domain that you want to get information about.</p>', 'DescribeElasticsearchDomainRequest$DomainName' => '<p>The name of the Elasticsearch domain for which you want information.</p>', 'DescribeElasticsearchInstanceTypeLimitsRequest$DomainName' => '<p> DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch <code> <a>Limits</a> </code> for existing domain. </p>', 'DissociatePackageRequest$DomainName' => '<p>Name of the domain that you want to associate the package with.</p>', 'DomainInfo$DomainName' => '<p> Specifies the <code>DomainName</code>.</p>', 'DomainInformation$DomainName' => NULL, 'DomainNameList$member' => NULL, 'DomainPackageDetails$DomainName' => '<p>Name of the domain you\'ve associated a package with.</p>', 'ElasticsearchDomainStatus$DomainName' => '<p>The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>', 'GetCompatibleElasticsearchVersionsRequest$DomainName' => NULL, 'GetUpgradeHistoryRequest$DomainName' => NULL, 'GetUpgradeStatusRequest$DomainName' => NULL, 'ListElasticsearchInstanceTypesRequest$DomainName' => '<p>DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. </p>', 'ListPackagesForDomainRequest$DomainName' => '<p>The name of the domain for which you want to list associated packages.</p>', 'StartElasticsearchServiceSoftwareUpdateRequest$DomainName' => '<p>The name of the domain that you want to update to the latest service software.</p>', 'UpdateElasticsearchDomainConfigRequest$DomainName' => '<p>The name of the Elasticsearch domain that you are updating. </p>', 'UpgradeElasticsearchDomainRequest$DomainName' => NULL, 'UpgradeElasticsearchDomainResponse$DomainName' => NULL, ], ], 'DomainNameFqdn' => [ 'base' => NULL, 'refs' => [ 'DomainEndpointOptions$CustomEndpoint' => '<p>Specify the fully qualified domain for your custom endpoint.</p>', ], ], 'DomainNameList' => [ 'base' => '<p>A list of Elasticsearch domain names.</p>', 'refs' => [ 'DescribeElasticsearchDomainsRequest$DomainNames' => '<p>The Elasticsearch domains for which you want information.</p>', ], ], 'DomainPackageDetails' => [ 'base' => '<p>Information on a package that is associated with a domain.</p>', 'refs' => [ 'AssociatePackageResponse$DomainPackageDetails' => '<p><code>DomainPackageDetails</code></p>', 'DissociatePackageResponse$DomainPackageDetails' => '<p><code>DomainPackageDetails</code></p>', 'DomainPackageDetailsList$member' => NULL, ], ], 'DomainPackageDetailsList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsForPackageResponse$DomainPackageDetailsList' => '<p>List of <code>DomainPackageDetails</code> objects.</p>', 'ListPackagesForDomainResponse$DomainPackageDetailsList' => '<p>List of <code>DomainPackageDetails</code> objects.</p>', ], ], 'DomainPackageStatus' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$DomainPackageStatus' => '<p>State of the association. Values are ASSOCIATING/ASSOCIATION_FAILED/ACTIVE/DISSOCIATING/DISSOCIATION_FAILED.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'RecurringCharge$RecurringChargeAmount' => '<p>The monetary amount of the recurring charge.</p>', 'ReservedElasticsearchInstance$FixedPrice' => '<p>The upfront fixed charge you will paid to purchase the specific reserved Elasticsearch instance offering. </p>', 'ReservedElasticsearchInstance$UsagePrice' => '<p>The rate you are charged for each hour for the domain that is using this reserved instance.</p>', 'ReservedElasticsearchInstanceOffering$FixedPrice' => '<p>The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance offering. </p>', 'ReservedElasticsearchInstanceOffering$UsagePrice' => '<p>The rate you are charged for each hour the domain that is using the offering is running.</p>', 'UpgradeStepItem$ProgressPercent' => '<p>The Floating point value representing progress percentage of a particular step.</p>', ], ], 'Duration' => [ 'base' => '<p>Specifies maintenance schedule duration: duration value and duration unit. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', 'refs' => [ 'AutoTuneMaintenanceSchedule$Duration' => '<p>Specifies maintenance schedule duration: duration value and duration unit. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', ], ], 'DurationValue' => [ 'base' => '<p> Integer to specify the value of a maintenance schedule duration. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', 'refs' => [ 'Duration$Value' => '<p> Integer to specify the value of a maintenance schedule duration. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', ], ], 'EBSOptions' => [ 'base' => '<p>Options to enable, disable, and specify the properties of EBS storage volumes. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank"> Configuring EBS-based Storage</a>.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$EBSOptions' => '<p>Options to enable, disable and specify the type and size of EBS storage volumes. </p>', 'EBSOptionsStatus$Options' => '<p> Specifies the EBS options for the specified Elasticsearch domain.</p>', 'ElasticsearchDomainStatus$EBSOptions' => '<p>The <code>EBSOptions</code> for the specified domain. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank">Configuring EBS-based Storage</a> for more information.</p>', 'UpdateElasticsearchDomainConfigRequest$EBSOptions' => '<p>Specify the type and size of the EBS volume that you want to use. </p>', ], ], 'EBSOptionsStatus' => [ 'base' => '<p> Status of the EBS options for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$EBSOptions' => '<p>Specifies the <code>EBSOptions</code> for the Elasticsearch domain.</p>', ], ], 'ESPartitionInstanceType' => [ 'base' => NULL, 'refs' => [ 'DescribeElasticsearchInstanceTypeLimitsRequest$InstanceType' => '<p> The instance type for an Elasticsearch cluster for which Elasticsearch <code> <a>Limits</a> </code> are needed. </p>', 'ElasticsearchClusterConfig$InstanceType' => '<p>The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data instances.</p>', 'ElasticsearchClusterConfig$DedicatedMasterType' => '<p>The instance type for a dedicated master node.</p>', 'ElasticsearchInstanceTypeList$member' => NULL, 'ReservedElasticsearchInstance$ElasticsearchInstanceType' => '<p>The Elasticsearch instance type offered by the reserved instance offering.</p>', 'ReservedElasticsearchInstanceOffering$ElasticsearchInstanceType' => '<p>The Elasticsearch instance type offered by the reserved instance offering.</p>', ], ], 'ESWarmPartitionInstanceType' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchClusterConfig$WarmType' => '<p>The instance type for the Elasticsearch cluster\'s warm nodes.</p>', ], ], 'ElasticsearchClusterConfig' => [ 'base' => '<p>Specifies the configuration for the domain cluster, such as the type and number of instances.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$ElasticsearchClusterConfig' => '<p>Configuration options for an Elasticsearch domain. Specifies the instance type and number of instances in the domain cluster. </p>', 'ElasticsearchClusterConfigStatus$Options' => '<p> Specifies the cluster configuration for the specified Elasticsearch domain.</p>', 'ElasticsearchDomainStatus$ElasticsearchClusterConfig' => '<p>The type and number of instances in the domain cluster.</p>', 'UpdateElasticsearchDomainConfigRequest$ElasticsearchClusterConfig' => '<p>The type and number of instances to instantiate for the domain cluster.</p>', ], ], 'ElasticsearchClusterConfigStatus' => [ 'base' => '<p> Specifies the configuration status for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$ElasticsearchClusterConfig' => '<p>Specifies the <code>ElasticsearchClusterConfig</code> for the Elasticsearch domain.</p>', ], ], 'ElasticsearchDomainConfig' => [ 'base' => '<p>The configuration of an Elasticsearch domain.</p>', 'refs' => [ 'DescribeElasticsearchDomainConfigResponse$DomainConfig' => '<p>The configuration information of the domain requested in the <code>DescribeElasticsearchDomainConfig</code> request.</p>', 'UpdateElasticsearchDomainConfigResponse$DomainConfig' => '<p>The status of the updated Elasticsearch domain. </p>', ], ], 'ElasticsearchDomainStatus' => [ 'base' => '<p>The current status of an Elasticsearch domain.</p>', 'refs' => [ 'CreateElasticsearchDomainResponse$DomainStatus' => '<p>The status of the newly created Elasticsearch domain. </p>', 'DeleteElasticsearchDomainResponse$DomainStatus' => '<p>The status of the Elasticsearch domain being deleted.</p>', 'DescribeElasticsearchDomainResponse$DomainStatus' => '<p>The current status of the Elasticsearch domain.</p>', 'ElasticsearchDomainStatusList$member' => NULL, ], ], 'ElasticsearchDomainStatusList' => [ 'base' => '<p>A list that contains the status of each requested Elasticsearch domain.</p>', 'refs' => [ 'DescribeElasticsearchDomainsResponse$DomainStatusList' => '<p>The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.</p>', ], ], 'ElasticsearchInstanceTypeList' => [ 'base' => '<p> List of instance types supported by Amazon Elasticsearch service. </p>', 'refs' => [ 'ListElasticsearchInstanceTypesResponse$ElasticsearchInstanceTypes' => '<p> List of instance types supported by Amazon Elasticsearch service for given <code> <a>ElasticsearchVersion</a> </code> </p>', ], ], 'ElasticsearchVersionList' => [ 'base' => '<p>List of supported elastic search versions. </p>', 'refs' => [ 'CompatibleVersionsMap$TargetVersions' => NULL, 'ListElasticsearchVersionsResponse$ElasticsearchVersions' => NULL, ], ], 'ElasticsearchVersionStatus' => [ 'base' => '<p> Status of the Elasticsearch version options for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$ElasticsearchVersion' => '<p>String of format X.Y to specify version for the Elasticsearch domain.</p>', ], ], 'ElasticsearchVersionString' => [ 'base' => NULL, 'refs' => [ 'CompatibleVersionsMap$SourceVersion' => '<p>The current version of Elasticsearch on which a domain is.</p>', 'CreateElasticsearchDomainRequest$ElasticsearchVersion' => '<p>String of format X.Y to specify version for the Elasticsearch domain eg. "1.5" or "2.3". For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.</p>', 'DescribeElasticsearchInstanceTypeLimitsRequest$ElasticsearchVersion' => '<p> Version of Elasticsearch for which <code> <a>Limits</a> </code> are needed. </p>', 'ElasticsearchDomainStatus$ElasticsearchVersion' => NULL, 'ElasticsearchVersionList$member' => NULL, 'ElasticsearchVersionStatus$Options' => '<p> Specifies the Elasticsearch version for the specified Elasticsearch domain.</p>', 'ListElasticsearchInstanceTypesRequest$ElasticsearchVersion' => '<p>Version of Elasticsearch for which list of supported elasticsearch instance types are needed. </p>', 'UpgradeElasticsearchDomainRequest$TargetVersion' => '<p>The version of Elasticsearch that you intend to upgrade the domain to.</p>', 'UpgradeElasticsearchDomainResponse$TargetVersion' => '<p>The version of Elasticsearch that you intend to upgrade the domain to.</p>', ], ], 'EncryptionAtRestOptions' => [ 'base' => '<p>Specifies the Encryption At Rest Options.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$EncryptionAtRestOptions' => '<p>Specifies the Encryption At Rest Options.</p>', 'ElasticsearchDomainStatus$EncryptionAtRestOptions' => '<p> Specifies the status of the <code>EncryptionAtRestOptions</code>.</p>', 'EncryptionAtRestOptionsStatus$Options' => '<p> Specifies the Encryption At Rest options for the specified Elasticsearch domain.</p>', 'UpdateElasticsearchDomainConfigRequest$EncryptionAtRestOptions' => '<p>Specifies the Encryption At Rest Options.</p>', ], ], 'EncryptionAtRestOptionsStatus' => [ 'base' => '<p> Status of the Encryption At Rest options for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$EncryptionAtRestOptions' => '<p>Specifies the <code>EncryptionAtRestOptions</code> for the Elasticsearch domain.</p>', ], ], 'EndpointsMap' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchDomainStatus$Endpoints' => '<p>Map containing the Elasticsearch domain endpoints used to submit index and search requests. Example <code>key, value</code>: <code>\'vpc\',\'vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com\'</code>.</p>', ], ], 'ErrorDetails' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$ErrorDetails' => '<p>Additional information if the package is in an error state. Null otherwise.</p>', 'PackageDetails$ErrorDetails' => '<p>Additional information if the package is in an error state. Null otherwise.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BaseException$message' => '<p>A description of the error.</p>', 'ErrorDetails$ErrorMessage' => NULL, ], ], 'ErrorType' => [ 'base' => NULL, 'refs' => [ 'ErrorDetails$ErrorType' => NULL, ], ], 'Filter' => [ 'base' => '<p> A filter used to limit results when describing inbound or outbound cross-cluster search connections. Multiple values can be specified per filter. A cross-cluster search connection must match at least one of the specified values for it to be returned from an operation. </p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInboundCrossClusterSearchConnectionsRequest$Filters' => '<p> A list of filters used to match properties for inbound cross-cluster search connection. Available <code><a>Filter</a></code> names for this operation are: <ul> <li>cross-cluster-search-connection-id</li> <li>source-domain-info.domain-name</li> <li>source-domain-info.owner-id</li> <li>source-domain-info.region</li> <li>destination-domain-info.domain-name</li> </ul> </p>', 'DescribeOutboundCrossClusterSearchConnectionsRequest$Filters' => '<p> A list of filters used to match properties for outbound cross-cluster search connection. Available <code><a>Filter</a></code> names for this operation are: <ul> <li>cross-cluster-search-connection-id</li> <li>destination-domain-info.domain-name</li> <li>destination-domain-info.owner-id</li> <li>destination-domain-info.region</li> <li>source-domain-info.domain-name</li> </ul> </p>', ], ], 'GUID' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedElasticsearchInstanceOfferingsRequest$ReservedElasticsearchInstanceOfferingId' => '<p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>', 'DescribeReservedElasticsearchInstancesRequest$ReservedElasticsearchInstanceId' => '<p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID.</p>', 'PurchaseReservedElasticsearchInstanceOfferingRequest$ReservedElasticsearchInstanceOfferingId' => '<p>The ID of the reserved Elasticsearch instance offering to purchase.</p>', 'PurchaseReservedElasticsearchInstanceOfferingResponse$ReservedElasticsearchInstanceId' => '<p>Details of the reserved Elasticsearch instance which was purchased.</p>', 'ReservedElasticsearchInstance$ReservedElasticsearchInstanceId' => '<p>The unique identifier for the reservation.</p>', 'ReservedElasticsearchInstanceOffering$ReservedElasticsearchInstanceOfferingId' => '<p>The Elasticsearch reserved instance offering identifier.</p>', ], ], 'GetCompatibleElasticsearchVersionsRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation. </p>', 'refs' => [], ], 'GetCompatibleElasticsearchVersionsResponse' => [ 'base' => '<p> Container for response returned by <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation. </p>', 'refs' => [], ], 'GetPackageVersionHistoryRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>GetPackageVersionHistory</a> </code> operation. </p>', 'refs' => [], ], 'GetPackageVersionHistoryResponse' => [ 'base' => '<p> Container for response returned by <code> <a>GetPackageVersionHistory</a> </code> operation. </p>', 'refs' => [], ], 'GetUpgradeHistoryRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation. </p>', 'refs' => [], ], 'GetUpgradeHistoryResponse' => [ 'base' => '<p> Container for response returned by <code> <a>GetUpgradeHistory</a> </code> operation. </p>', 'refs' => [], ], 'GetUpgradeStatusRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>GetUpgradeStatus</a> </code> operation. </p>', 'refs' => [], ], 'GetUpgradeStatusResponse' => [ 'base' => '<p> Container for response returned by <code> <a>GetUpgradeStatus</a> </code> operation. </p>', 'refs' => [], ], 'IdentityPoolId' => [ 'base' => NULL, 'refs' => [ 'CognitoOptions$IdentityPoolId' => '<p>Specifies the Cognito identity pool ID for Kibana authentication.</p>', ], ], 'InboundCrossClusterSearchConnection' => [ 'base' => '<p>Specifies details of an inbound connection.</p>', 'refs' => [ 'AcceptInboundCrossClusterSearchConnectionResponse$CrossClusterSearchConnection' => '<p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of accepted inbound connection. </p>', 'DeleteInboundCrossClusterSearchConnectionResponse$CrossClusterSearchConnection' => '<p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of deleted inbound connection. </p>', 'InboundCrossClusterSearchConnections$member' => NULL, 'RejectInboundCrossClusterSearchConnectionResponse$CrossClusterSearchConnection' => '<p>Specifies the <code><a>InboundCrossClusterSearchConnection</a></code> of rejected inbound connection. </p>', ], ], 'InboundCrossClusterSearchConnectionStatus' => [ 'base' => '<p>Specifies the coonection status of an inbound cross-cluster search connection.</p>', 'refs' => [ 'InboundCrossClusterSearchConnection$ConnectionStatus' => '<p>Specifies the <code><a>InboundCrossClusterSearchConnectionStatus</a></code> for the outbound connection.</p>', ], ], 'InboundCrossClusterSearchConnectionStatusCode' => [ 'base' => NULL, 'refs' => [ 'InboundCrossClusterSearchConnectionStatus$StatusCode' => '<p>The state code for inbound connection. This can be one of the following:</p> <ul> <li>PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination domain owner.</li> <li>APPROVED: Inbound connection is pending acceptance by destination domain owner.</li> <li>REJECTING: Inbound connection rejection is in process.</li> <li>REJECTED: Inbound connection is rejected.</li> <li>DELETING: Inbound connection deletion is in progress.</li> <li>DELETED: Inbound connection is deleted and cannot be used further.</li> </ul>', ], ], 'InboundCrossClusterSearchConnections' => [ 'base' => NULL, 'refs' => [ 'DescribeInboundCrossClusterSearchConnectionsResponse$CrossClusterSearchConnections' => '<p>Consists of list of <code><a>InboundCrossClusterSearchConnection</a></code> matching the specified filter criteria.</p>', ], ], 'InstanceCount' => [ 'base' => '<p>Specifies the number of EC2 instances in the Elasticsearch domain.</p>', 'refs' => [ 'PurchaseReservedElasticsearchInstanceOfferingRequest$InstanceCount' => '<p>The number of Elasticsearch instances to reserve.</p>', ], ], 'InstanceCountLimits' => [ 'base' => '<p> InstanceCountLimits represents the limits on number of instances that be created in Amazon Elasticsearch for given InstanceType. </p>', 'refs' => [ 'InstanceLimits$InstanceCountLimits' => NULL, ], ], 'InstanceLimits' => [ 'base' => '<p>InstanceLimits represents the list of instance related attributes that are available for given InstanceType. </p>', 'refs' => [ 'Limits$InstanceLimits' => NULL, ], ], 'InstanceRole' => [ 'base' => NULL, 'refs' => [ 'LimitsByRole$key' => NULL, ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ReservedElasticsearchInstance$Duration' => '<p>The duration, in seconds, for which the Elasticsearch instance is reserved.</p>', 'ReservedElasticsearchInstance$ElasticsearchInstanceCount' => '<p>The number of Elasticsearch instances that have been reserved.</p>', 'ReservedElasticsearchInstanceOffering$Duration' => '<p>The duration, in seconds, for which the offering will reserve the Elasticsearch instance.</p>', ], ], 'IntegerClass' => [ 'base' => NULL, 'refs' => [ 'EBSOptions$VolumeSize' => '<p> Integer to specify the size of an EBS volume.</p>', 'EBSOptions$Iops' => '<p>Specifies the IOPD for a Provisioned IOPS EBS volume (SSD).</p>', 'ElasticsearchClusterConfig$InstanceCount' => '<p>The number of instances in the specified domain cluster.</p>', 'ElasticsearchClusterConfig$DedicatedMasterCount' => '<p>Total number of dedicated master nodes, active and on standby, for the cluster.</p>', 'ElasticsearchClusterConfig$WarmCount' => '<p>The number of warm nodes in the cluster.</p>', 'SAMLOptionsInput$SessionTimeoutMinutes' => '<p>The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.</p>', 'SAMLOptionsOutput$SessionTimeoutMinutes' => '<p>The duration, in minutes, after which a user session becomes inactive.</p>', 'SnapshotOptions$AutomatedSnapshotStartHour' => '<p>Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified Elasticsearch domain. Default value is <code>0</code> hours.</p>', 'ZoneAwarenessConfig$AvailabilityZoneCount' => '<p>An integer value to indicate the number of availability zones for a domain when zone awareness is enabled. This should be equal to number of subnets if VPC endpoints is enabled</p>', ], ], 'InternalException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure (the failure is internal to the service) . Gives http status code of 500.</p>', 'refs' => [], ], 'InvalidPaginationTokenException' => [ 'base' => '<p>The request processing has failed because of invalid pagination token provided by customer. Returns an HTTP status code of 400. </p>', 'refs' => [], ], 'InvalidTypeException' => [ 'base' => '<p>An exception for trying to create or access sub-resource that is either invalid or not supported. Gives http status code of 409.</p>', 'refs' => [], ], 'Issue' => [ 'base' => NULL, 'refs' => [ 'Issues$member' => NULL, ], ], 'Issues' => [ 'base' => NULL, 'refs' => [ 'UpgradeStepItem$Issues' => '<p>A list of strings containing detailed information about the errors encountered in a particular step.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'EncryptionAtRestOptions$KmsKeyId' => '<p> Specifies the KMS Key ID for Encryption At Rest options.</p>', ], ], 'LastUpdated' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$LastUpdated' => '<p>Timestamp of the most-recent update to the association status.</p>', 'PackageDetails$LastUpdatedAt' => NULL, ], ], 'LimitExceededException' => [ 'base' => '<p>An exception for trying to create more than allowed resources or sub-resources. Gives http status code of 409.</p>', 'refs' => [], ], 'LimitName' => [ 'base' => NULL, 'refs' => [ 'AdditionalLimit$LimitName' => '<p> Name of Additional Limit is specific to a given InstanceType and for each of it\'s <code> <a>InstanceRole</a> </code> etc. <br/> Attributes and their details: <br/> <ul> <li>MaximumNumberOfDataNodesSupported</li> This attribute will be present in Master node only to specify how much data nodes upto which given <code> <a>ESPartitionInstanceType</a> </code> can support as master node. <li>MaximumNumberOfDataNodesWithoutMasterNode</li> This attribute will be present in Data node only to specify how much data nodes of given <code> <a>ESPartitionInstanceType</a> </code> upto which you don\'t need any master nodes to govern them. </ul> </p>', 'StorageTypeLimit$LimitName' => '<p> Name of storage limits that are applicable for given storage type. If <code> <a>StorageType</a> </code> is ebs, following storage options are applicable <ol> <li>MinimumVolumeSize</li> Minimum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable. <li>MaximumVolumeSize</li> Maximum amount of volume size that is applicable for given storage type.It can be empty if it is not applicable. <li>MaximumIops</li> Maximum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable. <li>MinimumIops</li> Minimum amount of Iops that is applicable for given storage type.It can be empty if it is not applicable. </ol> </p>', ], ], 'LimitValue' => [ 'base' => NULL, 'refs' => [ 'LimitValueList$member' => NULL, ], ], 'LimitValueList' => [ 'base' => NULL, 'refs' => [ 'AdditionalLimit$LimitValues' => '<p> Value for given <code> <a>AdditionalLimit$LimitName</a> </code> . </p>', 'StorageTypeLimit$LimitValues' => '<p> Values for the <code> <a>StorageTypeLimit$LimitName</a> </code> . </p>', ], ], 'Limits' => [ 'base' => '<p> Limits for given InstanceType and for each of it\'s role. <br/> Limits contains following <code> <a>StorageTypes,</a> </code> <code> <a>InstanceLimits</a> </code> and <code> <a>AdditionalLimits</a> </code> </p>', 'refs' => [ 'LimitsByRole$value' => NULL, ], ], 'LimitsByRole' => [ 'base' => '<p> Map of Role of the Instance and Limits that are applicable. Role performed by given Instance in Elasticsearch can be one of the following: <ul> <li>data: If the given InstanceType is used as data node</li> <li>master: If the given InstanceType is used as master node</li> <li>ultra_warm: If the given InstanceType is used as warm node</li> </ul> </p>', 'refs' => [ 'DescribeElasticsearchInstanceTypeLimitsResponse$LimitsByRole' => NULL, ], ], 'ListDomainNamesResponse' => [ 'base' => '<p>The result of a <code>ListDomainNames</code> operation. Contains the names of all Elasticsearch domains owned by this account.</p>', 'refs' => [], ], 'ListDomainsForPackageRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>ListDomainsForPackage</a> </code> operation. </p>', 'refs' => [], ], 'ListDomainsForPackageResponse' => [ 'base' => '<p> Container for response parameters to <code> <a>ListDomainsForPackage</a> </code> operation. </p>', 'refs' => [], ], 'ListElasticsearchInstanceTypesRequest' => [ 'base' => '<p> Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code> operation. </p>', 'refs' => [], ], 'ListElasticsearchInstanceTypesResponse' => [ 'base' => '<p> Container for the parameters returned by <code> <a>ListElasticsearchInstanceTypes</a> </code> operation. </p>', 'refs' => [], ], 'ListElasticsearchVersionsRequest' => [ 'base' => '<p> Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation. <p> Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single call. </p> <p> Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does not contain a NextToken, then there are no more results to retrieve. </p> </p>', 'refs' => [], ], 'ListElasticsearchVersionsResponse' => [ 'base' => '<p> Container for the parameters for response received from <code> <a>ListElasticsearchVersions</a> </code> operation. </p>', 'refs' => [], ], 'ListPackagesForDomainRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>ListPackagesForDomain</a> </code> operation. </p>', 'refs' => [], ], 'ListPackagesForDomainResponse' => [ 'base' => '<p> Container for response parameters to <code> <a>ListPackagesForDomain</a> </code> operation. </p>', 'refs' => [], ], 'ListTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>ListTags</a></code> operation. Specify the <code>ARN</code> for the Elasticsearch domain to which the tags are attached that you want to view are attached.</p>', 'refs' => [], ], 'ListTagsResponse' => [ 'base' => '<p>The result of a <code>ListTags</code> operation. Contains tags for all requested Elasticsearch domains.</p>', 'refs' => [], ], 'LogPublishingOption' => [ 'base' => '<p>Log Publishing option that is set for given domain. <br/>Attributes and their details: <ul> <li>CloudWatchLogsLogGroupArn: ARN of the Cloudwatch log group to which log needs to be published.</li> <li>Enabled: Whether the log publishing for given log type is enabled or not</li> </ul> </p>', 'refs' => [ 'LogPublishingOptions$value' => NULL, ], ], 'LogPublishingOptions' => [ 'base' => NULL, 'refs' => [ 'CreateElasticsearchDomainRequest$LogPublishingOptions' => '<p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>', 'ElasticsearchDomainStatus$LogPublishingOptions' => '<p>Log publishing options for the given domain.</p>', 'LogPublishingOptionsStatus$Options' => '<p>The log publishing options configured for the Elasticsearch domain.</p>', 'UpdateElasticsearchDomainConfigRequest$LogPublishingOptions' => '<p>Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type of Elasticsearch log.</p>', ], ], 'LogPublishingOptionsStatus' => [ 'base' => '<p>The configured log publishing options for the domain and their current status.</p>', 'refs' => [ 'ElasticsearchDomainConfig$LogPublishingOptions' => '<p>Log publishing options for the given domain.</p>', ], ], 'LogType' => [ 'base' => '<p>Type of Log File, it can be one of the following: <ul> <li>INDEX_SLOW_LOGS: Index slow logs contain insert requests that took more time than configured index query log threshold to execute.</li> <li>SEARCH_SLOW_LOGS: Search slow logs contain search queries that took more time than configured search query log threshold to execute.</li> <li>ES_APPLICATION_LOGS: Elasticsearch application logs contain information about errors and warnings raised during the operation of the service and can be useful for troubleshooting.</li> <li>AUDIT_LOGS: Audit logs contain records of user requests for access from the domain.</li> </ul> </p>', 'refs' => [ 'LogPublishingOptions$key' => NULL, ], ], 'MasterUserOptions' => [ 'base' => '<p>Credentials for the master user: username and password, ARN, or both.</p>', 'refs' => [ 'AdvancedSecurityOptionsInput$MasterUserOptions' => '<p>Credentials for the master user: username and password, ARN, or both.</p>', ], ], 'MaxResults' => [ 'base' => '<p> Set this value to limit the number of results returned. </p>', 'refs' => [ 'DescribeDomainAutoTunesRequest$MaxResults' => '<p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>', 'DescribeInboundCrossClusterSearchConnectionsRequest$MaxResults' => '<p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>', 'DescribeOutboundCrossClusterSearchConnectionsRequest$MaxResults' => '<p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>', 'DescribePackagesRequest$MaxResults' => '<p>Limits results to a maximum number of packages.</p>', 'DescribeReservedElasticsearchInstanceOfferingsRequest$MaxResults' => '<p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>', 'DescribeReservedElasticsearchInstancesRequest$MaxResults' => '<p>Set this value to limit the number of results returned. If not specified, defaults to 100.</p>', 'GetPackageVersionHistoryRequest$MaxResults' => '<p>Limits results to a maximum number of versions.</p>', 'GetUpgradeHistoryRequest$MaxResults' => NULL, 'ListDomainsForPackageRequest$MaxResults' => '<p>Limits results to a maximum number of domains.</p>', 'ListElasticsearchInstanceTypesRequest$MaxResults' => '<p> Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. </p>', 'ListElasticsearchVersionsRequest$MaxResults' => '<p> Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. </p>', 'ListPackagesForDomainRequest$MaxResults' => '<p>Limits results to a maximum number of packages.</p>', ], ], 'MaximumInstanceCount' => [ 'base' => '<p> Maximum number of Instances that can be instantiated for given InstanceType. </p>', 'refs' => [ 'InstanceCountLimits$MaximumInstanceCount' => NULL, ], ], 'MinimumInstanceCount' => [ 'base' => '<p> Minimum number of Instances that can be instantiated for given InstanceType. </p>', 'refs' => [ 'InstanceCountLimits$MinimumInstanceCount' => NULL, ], ], 'NextToken' => [ 'base' => '<p> Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. </p>', 'refs' => [ 'DescribeDomainAutoTunesRequest$NextToken' => '<p>NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>', 'DescribeDomainAutoTunesResponse$NextToken' => '<p>Specifies an identifier to allow retrieval of paginated results.</p>', 'DescribeInboundCrossClusterSearchConnectionsRequest$NextToken' => '<p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>', 'DescribeInboundCrossClusterSearchConnectionsResponse$NextToken' => '<p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results. </p>', 'DescribeOutboundCrossClusterSearchConnectionsRequest$NextToken' => '<p> NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination.</p>', 'DescribeOutboundCrossClusterSearchConnectionsResponse$NextToken' => '<p>If more results are available and NextToken is present, make the next request to the same API with the received NextToken to paginate the remaining results. </p>', 'DescribePackagesRequest$NextToken' => '<p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>', 'DescribeReservedElasticsearchInstanceOfferingsRequest$NextToken' => '<p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>', 'DescribeReservedElasticsearchInstanceOfferingsResponse$NextToken' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'DescribeReservedElasticsearchInstancesRequest$NextToken' => '<p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination.</p>', 'GetPackageVersionHistoryRequest$NextToken' => '<p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>', 'GetUpgradeHistoryRequest$NextToken' => NULL, 'ListDomainsForPackageRequest$NextToken' => '<p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>', 'ListElasticsearchInstanceTypesRequest$NextToken' => '<p>NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. </p>', 'ListElasticsearchInstanceTypesResponse$NextToken' => '<p>In case if there are more results available NextToken would be present, make further request to the same API with received NextToken to paginate remaining results. </p>', 'ListElasticsearchVersionsRequest$NextToken' => NULL, 'ListElasticsearchVersionsResponse$NextToken' => NULL, 'ListPackagesForDomainRequest$NextToken' => '<p>Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page.</p>', ], ], 'NodeToNodeEncryptionOptions' => [ 'base' => '<p>Specifies the node-to-node encryption options.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$NodeToNodeEncryptionOptions' => '<p>Specifies the NodeToNodeEncryptionOptions.</p>', 'ElasticsearchDomainStatus$NodeToNodeEncryptionOptions' => '<p>Specifies the status of the <code>NodeToNodeEncryptionOptions</code>.</p>', 'NodeToNodeEncryptionOptionsStatus$Options' => '<p>Specifies the node-to-node encryption options for the specified Elasticsearch domain.</p>', 'UpdateElasticsearchDomainConfigRequest$NodeToNodeEncryptionOptions' => '<p>Specifies the NodeToNodeEncryptionOptions.</p>', ], ], 'NodeToNodeEncryptionOptionsStatus' => [ 'base' => '<p>Status of the node-to-node encryption options for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$NodeToNodeEncryptionOptions' => '<p>Specifies the <code>NodeToNodeEncryptionOptions</code> for the Elasticsearch domain.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p> Specifies the name of the filter. </p>', 'ValueStringList$member' => NULL, ], ], 'OptionState' => [ 'base' => '<p>The state of a requested change. One of the following:</p> <ul> <li>Processing: The request change is still in-process.</li> <li>Active: The request change is processed and deployed to the Elasticsearch domain.</li> </ul>', 'refs' => [ 'OptionStatus$State' => '<p>Provides the <code>OptionState</code> for the Elasticsearch domain.</p>', ], ], 'OptionStatus' => [ 'base' => '<p>Provides the current status of the entity.</p>', 'refs' => [ 'AccessPoliciesStatus$Status' => '<p>The status of the access policy for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that\'s included. </p>', 'AdvancedOptionsStatus$Status' => '<p> Specifies the status of <code>OptionStatus</code> for advanced options for the specified Elasticsearch domain.</p>', 'AdvancedSecurityOptionsStatus$Status' => '<p> Status of the advanced security options for the specified Elasticsearch domain.</p>', 'CognitoOptionsStatus$Status' => '<p>Specifies the status of the Cognito options for the specified Elasticsearch domain.</p>', 'DomainEndpointOptionsStatus$Status' => '<p>The status of the endpoint options for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that\'s included. </p>', 'EBSOptionsStatus$Status' => '<p> Specifies the status of the EBS options for the specified Elasticsearch domain.</p>', 'ElasticsearchClusterConfigStatus$Status' => '<p> Specifies the status of the configuration for the specified Elasticsearch domain.</p>', 'ElasticsearchVersionStatus$Status' => '<p> Specifies the status of the Elasticsearch version options for the specified Elasticsearch domain.</p>', 'EncryptionAtRestOptionsStatus$Status' => '<p> Specifies the status of the Encryption At Rest options for the specified Elasticsearch domain.</p>', 'LogPublishingOptionsStatus$Status' => '<p>The status of the log publishing options for the Elasticsearch domain. See <code>OptionStatus</code> for the status information that\'s included. </p>', 'NodeToNodeEncryptionOptionsStatus$Status' => '<p>Specifies the status of the node-to-node encryption options for the specified Elasticsearch domain.</p>', 'SnapshotOptionsStatus$Status' => '<p>Specifies the status of a daily automated snapshot.</p>', 'VPCDerivedInfoStatus$Status' => '<p> Specifies the status of the VPC options for the specified Elasticsearch domain.</p>', ], ], 'OutboundCrossClusterSearchConnection' => [ 'base' => '<p>Specifies details of an outbound connection.</p>', 'refs' => [ 'DeleteOutboundCrossClusterSearchConnectionResponse$CrossClusterSearchConnection' => '<p>Specifies the <code><a>OutboundCrossClusterSearchConnection</a></code> of deleted outbound connection. </p>', 'OutboundCrossClusterSearchConnections$member' => NULL, ], ], 'OutboundCrossClusterSearchConnectionStatus' => [ 'base' => '<p>Specifies the connection status of an outbound cross-cluster search connection.</p>', 'refs' => [ 'CreateOutboundCrossClusterSearchConnectionResponse$ConnectionStatus' => '<p>Specifies the <code><a>OutboundCrossClusterSearchConnectionStatus</a></code> for the newly created connection.</p>', 'OutboundCrossClusterSearchConnection$ConnectionStatus' => '<p>Specifies the <code><a>OutboundCrossClusterSearchConnectionStatus</a></code> for the outbound connection.</p>', ], ], 'OutboundCrossClusterSearchConnectionStatusCode' => [ 'base' => NULL, 'refs' => [ 'OutboundCrossClusterSearchConnectionStatus$StatusCode' => '<p>The state code for outbound connection. This can be one of the following:</p> <ul> <li>VALIDATING: The outbound connection request is being validated.</li> <li>VALIDATION_FAILED: Validation failed for the connection request.</li> <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination domain owner.</li> <li>PROVISIONING: Outbound connection request is in process.</li> <li>ACTIVE: Outbound connection is active and ready to use.</li> <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li> <li>DELETING: Outbound connection deletion is in progress.</li> <li>DELETED: Outbound connection is deleted and cannot be used further.</li> </ul>', ], ], 'OutboundCrossClusterSearchConnections' => [ 'base' => NULL, 'refs' => [ 'DescribeOutboundCrossClusterSearchConnectionsResponse$CrossClusterSearchConnections' => '<p>Consists of list of <code><a>OutboundCrossClusterSearchConnection</a></code> matching the specified filter criteria.</p>', ], ], 'OwnerId' => [ 'base' => NULL, 'refs' => [ 'DomainInformation$OwnerId' => NULL, ], ], 'PackageDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePackageRequest$PackageDescription' => '<p>Description of the package.</p>', 'PackageDetails$PackageDescription' => '<p>User-specified description of the package.</p>', 'UpdatePackageRequest$PackageDescription' => '<p>New description of the package.</p>', ], ], 'PackageDetails' => [ 'base' => '<p>Basic information about a package.</p>', 'refs' => [ 'CreatePackageResponse$PackageDetails' => '<p>Information about the package <code>PackageDetails</code>.</p>', 'DeletePackageResponse$PackageDetails' => '<p><code>PackageDetails</code></p>', 'PackageDetailsList$member' => NULL, 'UpdatePackageResponse$PackageDetails' => '<p>Information about the package <code>PackageDetails</code>.</p>', ], ], 'PackageDetailsList' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesResponse$PackageDetailsList' => '<p>List of <code>PackageDetails</code> objects.</p>', ], ], 'PackageID' => [ 'base' => NULL, 'refs' => [ 'AssociatePackageRequest$PackageID' => '<p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>', 'DeletePackageRequest$PackageID' => '<p>Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.</p>', 'DissociatePackageRequest$PackageID' => '<p>Internal ID of the package that you want to associate with a domain. Use <code>DescribePackages</code> to find this value.</p>', 'DomainPackageDetails$PackageID' => '<p>Internal ID of the package.</p>', 'GetPackageVersionHistoryRequest$PackageID' => '<p>Returns an audit history of versions of the package.</p>', 'GetPackageVersionHistoryResponse$PackageID' => NULL, 'ListDomainsForPackageRequest$PackageID' => '<p>The package for which to list domains.</p>', 'PackageDetails$PackageID' => '<p>Internal ID of the package.</p>', 'UpdatePackageRequest$PackageID' => '<p>Unique identifier for the package.</p>', ], ], 'PackageName' => [ 'base' => NULL, 'refs' => [ 'CreatePackageRequest$PackageName' => '<p>Unique identifier for the package.</p>', 'DomainPackageDetails$PackageName' => '<p>User specified name of the package.</p>', 'PackageDetails$PackageName' => '<p>User specified name of the package.</p>', ], ], 'PackageSource' => [ 'base' => '<p>The S3 location for importing the package specified as <code>S3BucketName</code> and <code>S3Key</code></p>', 'refs' => [ 'CreatePackageRequest$PackageSource' => '<p>The customer S3 location <code>PackageSource</code> for importing the package.</p>', 'UpdatePackageRequest$PackageSource' => NULL, ], ], 'PackageStatus' => [ 'base' => NULL, 'refs' => [ 'PackageDetails$PackageStatus' => '<p>Current state of the package. Values are COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED</p>', ], ], 'PackageType' => [ 'base' => NULL, 'refs' => [ 'CreatePackageRequest$PackageType' => '<p>Type of package. Currently supports only TXT-DICTIONARY.</p>', 'DomainPackageDetails$PackageType' => '<p>Currently supports only TXT-DICTIONARY.</p>', 'PackageDetails$PackageType' => '<p>Currently supports only TXT-DICTIONARY.</p>', ], ], 'PackageVersion' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$PackageVersion' => NULL, 'PackageDetails$AvailablePackageVersion' => NULL, 'PackageVersionHistory$PackageVersion' => '<p>Version of the package.</p>', ], ], 'PackageVersionHistory' => [ 'base' => '<p>Details of a package version.</p>', 'refs' => [ 'PackageVersionHistoryList$member' => NULL, ], ], 'PackageVersionHistoryList' => [ 'base' => NULL, 'refs' => [ 'GetPackageVersionHistoryResponse$PackageVersionHistoryList' => '<p>List of <code>PackageVersionHistory</code> objects.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'MasterUserOptions$MasterUserPassword' => '<p>The master user\'s password, which is stored in the Amazon Elasticsearch Service domain\'s internal database.</p>', ], ], 'PolicyDocument' => [ 'base' => '<p>Access policy rules for an Elasticsearch domain service endpoints. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies" target="_blank">Configuring Access Policies</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>. The maximum size of a policy document is 100 KB.</p>', 'refs' => [ 'AccessPoliciesStatus$Options' => '<p>The access policy configured for the Elasticsearch domain. Access policies may be resource-based, IP-based, or IAM-based. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies" target="_blank"> Configuring Access Policies</a>for more information.</p>', 'CreateElasticsearchDomainRequest$AccessPolicies' => '<p> IAM access policy as a JSON-formatted string.</p>', 'ElasticsearchDomainStatus$AccessPolicies' => '<p> IAM access policy as a JSON-formatted string.</p>', 'UpdateElasticsearchDomainConfigRequest$AccessPolicies' => '<p>IAM access policy as a JSON-formatted string.</p>', ], ], 'PurchaseReservedElasticsearchInstanceOfferingRequest' => [ 'base' => '<p>Container for parameters to <code>PurchaseReservedElasticsearchInstanceOffering</code></p>', 'refs' => [], ], 'PurchaseReservedElasticsearchInstanceOfferingResponse' => [ 'base' => '<p>Represents the output of a <code>PurchaseReservedElasticsearchInstanceOffering</code> operation.</p>', 'refs' => [], ], 'RecurringCharge' => [ 'base' => '<p>Contains the specific price and frequency of a recurring charges for a reserved Elasticsearch instance, or for a reserved Elasticsearch instance offering.</p>', 'refs' => [ 'RecurringChargeList$member' => NULL, ], ], 'RecurringChargeList' => [ 'base' => NULL, 'refs' => [ 'ReservedElasticsearchInstance$RecurringCharges' => '<p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>', 'ReservedElasticsearchInstanceOffering$RecurringCharges' => '<p>The charge to your account regardless of whether you are creating any domains using the instance offering.</p>', ], ], 'ReferencePath' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$ReferencePath' => '<p>The relative path on Amazon ES nodes, which can be used as synonym_path when the package is synonym file.</p>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'DomainInformation$Region' => NULL, ], ], 'RejectInboundCrossClusterSearchConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>RejectInboundCrossClusterSearchConnection</a></code> operation.</p>', 'refs' => [], ], 'RejectInboundCrossClusterSearchConnectionResponse' => [ 'base' => '<p>The result of a <code><a>RejectInboundCrossClusterSearchConnection</a></code> operation. Contains details of rejected inbound connection.</p>', 'refs' => [], ], 'RemoveTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>RemoveTags</a></code> operation. Specify the <code>ARN</code> for the Elasticsearch domain from which you want to remove the specified <code>TagKey</code>.</p>', 'refs' => [], ], 'ReservationToken' => [ 'base' => NULL, 'refs' => [ 'PurchaseReservedElasticsearchInstanceOfferingRequest$ReservationName' => '<p>A customer-specified identifier to track this reservation.</p>', 'PurchaseReservedElasticsearchInstanceOfferingResponse$ReservationName' => '<p>The customer-specified identifier used to track this reservation.</p>', 'ReservedElasticsearchInstance$ReservationName' => '<p>The customer-specified identifier to track this reservation.</p>', ], ], 'ReservedElasticsearchInstance' => [ 'base' => '<p>Details of a reserved Elasticsearch instance.</p>', 'refs' => [ 'ReservedElasticsearchInstanceList$member' => NULL, ], ], 'ReservedElasticsearchInstanceList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedElasticsearchInstancesResponse$ReservedElasticsearchInstances' => '<p>List of reserved Elasticsearch instances.</p>', ], ], 'ReservedElasticsearchInstanceOffering' => [ 'base' => '<p>Details of a reserved Elasticsearch instance offering.</p>', 'refs' => [ 'ReservedElasticsearchInstanceOfferingList$member' => NULL, ], ], 'ReservedElasticsearchInstanceOfferingList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedElasticsearchInstanceOfferingsResponse$ReservedElasticsearchInstanceOfferings' => '<p>List of reserved Elasticsearch instance offerings</p>', ], ], 'ReservedElasticsearchInstancePaymentOption' => [ 'base' => NULL, 'refs' => [ 'ReservedElasticsearchInstance$PaymentOption' => '<p>The payment option as defined in the reserved Elasticsearch instance offering.</p>', 'ReservedElasticsearchInstanceOffering$PaymentOption' => '<p>Payment option for the reserved Elasticsearch instance offering</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>An exception for creating a resource that already exists. Gives http status code of 400.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CognitoOptions$RoleArn' => '<p>Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.</p>', ], ], 'RollbackOnDisable' => [ 'base' => '<p>Specifies the rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK, DEFAULT_ROLLBACK.</p>', 'refs' => [ 'AutoTuneOptions$RollbackOnDisable' => '<p>Specifies the rollback state while disabling Auto-Tune for the domain. Valid values are NO_ROLLBACK, DEFAULT_ROLLBACK. </p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'PackageSource$S3BucketName' => '<p>Name of the bucket containing the package.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'PackageSource$S3Key' => '<p>Key (file name) of the package.</p>', ], ], 'SAMLEntityId' => [ 'base' => NULL, 'refs' => [ 'SAMLIdp$EntityId' => '<p>The unique Entity ID of the application in SAML Identity Provider.</p>', ], ], 'SAMLIdp' => [ 'base' => '<p>Specifies the SAML Identity Provider\'s information.</p>', 'refs' => [ 'SAMLOptionsInput$Idp' => '<p>Specifies the SAML Identity Provider\'s information.</p>', 'SAMLOptionsOutput$Idp' => '<p>Describes the SAML Identity Provider\'s information.</p>', ], ], 'SAMLMetadata' => [ 'base' => NULL, 'refs' => [ 'SAMLIdp$MetadataContent' => '<p>The Metadata of the SAML application in xml format.</p>', ], ], 'SAMLOptionsInput' => [ 'base' => '<p>Specifies the SAML application configuration for the domain.</p>', 'refs' => [ 'AdvancedSecurityOptionsInput$SAMLOptions' => '<p>Specifies the SAML application configuration for the domain.</p>', ], ], 'SAMLOptionsOutput' => [ 'base' => '<p>Describes the SAML application configured for the domain.</p>', 'refs' => [ 'AdvancedSecurityOptions$SAMLOptions' => '<p>Describes the SAML application configured for a domain.</p>', ], ], 'ScheduledAutoTuneActionType' => [ 'base' => '<p>Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING. </p>', 'refs' => [ 'ScheduledAutoTuneDetails$ActionType' => '<p>Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING. </p>', ], ], 'ScheduledAutoTuneDescription' => [ 'base' => '<p>Specifies Auto-Tune action description. </p>', 'refs' => [ 'ScheduledAutoTuneDetails$Action' => '<p>Specifies Auto-Tune action description. </p>', ], ], 'ScheduledAutoTuneDetails' => [ 'base' => '<p>Specifies details of the scheduled Auto-Tune action. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information. </p>', 'refs' => [ 'AutoTuneDetails$ScheduledAutoTuneDetails' => NULL, ], ], 'ScheduledAutoTuneSeverityType' => [ 'base' => '<p>Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH. </p>', 'refs' => [ 'ScheduledAutoTuneDetails$Severity' => '<p>Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH. </p>', ], ], 'ServiceSoftwareOptions' => [ 'base' => '<p>The current options of an Elasticsearch domain service software options.</p>', 'refs' => [ 'CancelElasticsearchServiceSoftwareUpdateResponse$ServiceSoftwareOptions' => '<p>The current status of the Elasticsearch service software update.</p>', 'ElasticsearchDomainStatus$ServiceSoftwareOptions' => '<p>The current status of the Elasticsearch domain\'s service software.</p>', 'StartElasticsearchServiceSoftwareUpdateResponse$ServiceSoftwareOptions' => '<p>The current status of the Elasticsearch service software update.</p>', ], ], 'ServiceUrl' => [ 'base' => '<p>The endpoint to which service requests are submitted. For example, <code>search-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.es.amazonaws.com</code> or <code>doc-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.es.amazonaws.com</code>.</p>', 'refs' => [ 'ElasticsearchDomainStatus$Endpoint' => '<p>The Elasticsearch domain endpoint that you use to submit index and search requests.</p>', 'EndpointsMap$value' => NULL, ], ], 'SnapshotOptions' => [ 'base' => '<p>Specifies the time, in UTC format, when the service takes a daily automated snapshot of the specified Elasticsearch domain. Default value is <code>0</code> hours.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$SnapshotOptions' => '<p>Option to set time, in UTC format, of the daily automated snapshot. Default value is 0 hours. </p>', 'ElasticsearchDomainStatus$SnapshotOptions' => '<p>Specifies the status of the <code>SnapshotOptions</code></p>', 'SnapshotOptionsStatus$Options' => '<p>Specifies the daily snapshot options specified for the Elasticsearch domain.</p>', 'UpdateElasticsearchDomainConfigRequest$SnapshotOptions' => '<p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>', ], ], 'SnapshotOptionsStatus' => [ 'base' => '<p>Status of a daily automated snapshot.</p>', 'refs' => [ 'ElasticsearchDomainConfig$SnapshotOptions' => '<p>Specifies the <code>SnapshotOptions</code> for the Elasticsearch domain.</p>', ], ], 'StartAt' => [ 'base' => NULL, 'refs' => [ 'AutoTuneMaintenanceSchedule$StartAt' => '<p>Specifies timestamp at which Auto-Tune maintenance schedule start. </p>', ], ], 'StartElasticsearchServiceSoftwareUpdateRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>StartElasticsearchServiceSoftwareUpdate</a></code> operation. Specifies the name of the Elasticsearch domain that you wish to schedule a service software update on.</p>', 'refs' => [], ], 'StartElasticsearchServiceSoftwareUpdateResponse' => [ 'base' => '<p>The result of a <code>StartElasticsearchServiceSoftwareUpdate</code> operation. Contains the status of the update.</p>', 'refs' => [], ], 'StartTimestamp' => [ 'base' => NULL, 'refs' => [ 'UpgradeHistory$StartTimestamp' => '<p>UTC Timestamp at which the Upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ" format.</p>', ], ], 'StorageSubTypeName' => [ 'base' => '<p> SubType of the given storage type. List of available sub-storage options: For "instance" storageType we wont have any storageSubType, in case of "ebs" storageType we will have following valid storageSubTypes <ol> <li>standard</li> <li>gp2</li> <li>io1</li> </ol> Refer <code><a>VolumeType</a></code> for more information regarding above EBS storage options. </p>', 'refs' => [ 'StorageType$StorageSubTypeName' => NULL, ], ], 'StorageType' => [ 'base' => '<p>StorageTypes represents the list of storage related types and their attributes that are available for given InstanceType. </p>', 'refs' => [ 'StorageTypeList$member' => NULL, ], ], 'StorageTypeLimit' => [ 'base' => '<p>Limits that are applicable for given storage type. </p>', 'refs' => [ 'StorageTypeLimitList$member' => NULL, ], ], 'StorageTypeLimitList' => [ 'base' => NULL, 'refs' => [ 'StorageType$StorageTypeLimits' => '<p>List of limits that are applicable for given storage type. </p>', ], ], 'StorageTypeList' => [ 'base' => NULL, 'refs' => [ 'Limits$StorageTypes' => '<p>StorageType represents the list of storage related types and attributes that are available for given InstanceType. </p>', ], ], 'StorageTypeName' => [ 'base' => '<p> Type of the storage. List of available storage options: <ol> <li>instance</li> Inbuilt storage available for the given Instance <li>ebs</li> Elastic block storage that would be attached to the given Instance </ol> </p>', 'refs' => [ 'StorageType$StorageTypeName' => NULL, ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AdvancedOptions$key' => NULL, 'AdvancedOptions$value' => NULL, 'AutoTuneMaintenanceSchedule$CronExpressionForRecurrence' => '<p>Specifies cron expression for a recurring maintenance schedule. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', 'AutoTuneOptionsOutput$ErrorMessage' => '<p>Specifies the error message while enabling or disabling the Auto-Tune.</p>', 'AutoTuneStatus$ErrorMessage' => '<p>Specifies the error message while enabling or disabling the Auto-Tune options.</p>', 'DescribePackagesResponse$NextToken' => NULL, 'DescribeReservedElasticsearchInstancesResponse$NextToken' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'EndpointsMap$key' => NULL, 'GetPackageVersionHistoryResponse$NextToken' => NULL, 'GetUpgradeHistoryResponse$NextToken' => '<p>Pagination token that needs to be supplied to the next call to get the next page of results</p>', 'ListDomainsForPackageResponse$NextToken' => NULL, 'ListPackagesForDomainResponse$NextToken' => '<p>Pagination token that needs to be supplied to the next call to get the next page of results.</p>', 'RecurringCharge$RecurringChargeFrequency' => '<p>The frequency of the recurring charge.</p>', 'ReservedElasticsearchInstance$ReservedElasticsearchInstanceOfferingId' => '<p>The offering identifier.</p>', 'ReservedElasticsearchInstance$CurrencyCode' => '<p>The currency code for the reserved Elasticsearch instance offering.</p>', 'ReservedElasticsearchInstance$State' => '<p>The state of the reserved Elasticsearch instance.</p>', 'ReservedElasticsearchInstanceOffering$CurrencyCode' => '<p>The currency code for the reserved Elasticsearch instance offering.</p>', 'SAMLOptionsInput$SubjectKey' => '<p>The key to use for matching the SAML Subject attribute.</p>', 'SAMLOptionsInput$RolesKey' => '<p>The key to use for matching the SAML Roles attribute.</p>', 'SAMLOptionsOutput$SubjectKey' => '<p>The key used for matching the SAML Subject attribute.</p>', 'SAMLOptionsOutput$RolesKey' => '<p>The key used for matching the SAML Roles attribute.</p>', 'ServiceSoftwareOptions$CurrentVersion' => '<p>The current service software version that is present on the domain.</p>', 'ServiceSoftwareOptions$NewVersion' => '<p>The new service software version if one is available.</p>', 'ServiceSoftwareOptions$Description' => '<p>The description of the <code>UpdateStatus</code>.</p>', 'StringList$member' => NULL, 'VPCDerivedInfo$VPCId' => '<p>The VPC Id for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsRequest$TagKeys' => '<p>Specifies the <code>TagKey</code> list which you want to remove from the Elasticsearch domain.</p>', 'VPCDerivedInfo$SubnetIds' => '<p>Specifies the subnets for VPC endpoint.</p>', 'VPCDerivedInfo$AvailabilityZones' => '<p>The availability zones for the Elasticsearch domain. Exists only if the domain was created with VPCOptions.</p>', 'VPCDerivedInfo$SecurityGroupIds' => '<p>Specifies the security groups for VPC endpoint.</p>', 'VPCOptions$SubnetIds' => '<p>Specifies the subnets for VPC endpoint.</p>', 'VPCOptions$SecurityGroupIds' => '<p>Specifies the security groups for VPC endpoint.</p>', ], ], 'TLSSecurityPolicy' => [ 'base' => NULL, 'refs' => [ 'DomainEndpointOptions$TLSSecurityPolicy' => '<p>Specify the TLS security policy that needs to be applied to the HTTPS endpoint of Elasticsearch domain. <br/> It can be one of the following values: <ul> <li><b>Policy-Min-TLS-1-0-2019-07: </b> TLS security policy which supports TLSv1.0 and higher.</li> <li><b>Policy-Min-TLS-1-2-2019-07: </b> TLS security policy which supports only TLSv1.2</li> </ul> </p>', ], ], 'Tag' => [ 'base' => '<p>Specifies a key value pair for a resource tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => '<p>A string of length from 1 to 128 characters that specifies the key for a Tag. Tag keys must be unique for the Elasticsearch domain to which they are attached.</p>', 'refs' => [ 'Tag$Key' => '<p>Specifies the <code>TagKey</code>, the name of the tag. Tag keys must be unique for the Elasticsearch domain to which they are attached.</p>', ], ], 'TagList' => [ 'base' => '<p>A list of <code>Tag</code> </p>', 'refs' => [ 'AddTagsRequest$TagList' => '<p> List of <code>Tag</code> that need to be added for the Elasticsearch domain. </p>', 'CreateElasticsearchDomainRequest$TagList' => '<p>A list of <code>Tag</code> added during domain creation.</p>', 'ListTagsResponse$TagList' => '<p> List of <code>Tag</code> for the requested Elasticsearch domain.</p>', ], ], 'TagValue' => [ 'base' => '<p>A string of length from 0 to 256 characters that specifies the value for a Tag. Tag values can be null and do not have to be unique in a tag set.</p>', 'refs' => [ 'Tag$Value' => '<p>Specifies the <code>TagValue</code>, the value assigned to the corresponding tag key. Tag values can be null and do not have to be unique in a tag set. For example, you can have a key value pair in a tag set of <code>project : Trinity</code> and <code>cost-center : Trinity</code></p>', ], ], 'TimeUnit' => [ 'base' => '<p>Specifies the unit of a maintenance schedule duration. Valid value is HOUR. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', 'refs' => [ 'Duration$Unit' => '<p>Specifies the unit of a maintenance schedule duration. Valid value is HOURS. See the <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html" target="_blank">Developer Guide</a> for more information.</p>', ], ], 'UIntValue' => [ 'base' => NULL, 'refs' => [ 'AutoTuneStatus$UpdateVersion' => '<p>Specifies the Auto-Tune options latest version.</p>', 'OptionStatus$UpdateVersion' => '<p>Specifies the latest version for the entity.</p>', ], ], 'UpdateElasticsearchDomainConfigRequest' => [ 'base' => '<p>Container for the parameters to the <code><a>UpdateElasticsearchDomain</a></code> operation. Specifies the type and number of instances in the domain cluster.</p>', 'refs' => [], ], 'UpdateElasticsearchDomainConfigResponse' => [ 'base' => '<p>The result of an <code>UpdateElasticsearchDomain</code> request. Contains the status of the Elasticsearch domain being updated.</p>', 'refs' => [], ], 'UpdatePackageRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>UpdatePackage</a> </code> operation. </p>', 'refs' => [], ], 'UpdatePackageResponse' => [ 'base' => '<p> Container for response returned by <code> <a>UpdatePackage</a> </code> operation. </p>', 'refs' => [], ], 'UpdateTimestamp' => [ 'base' => NULL, 'refs' => [ 'AutoTuneStatus$CreationDate' => '<p>Timestamp which tells Auto-Tune options creation date .</p>', 'AutoTuneStatus$UpdateDate' => '<p>Timestamp which tells Auto-Tune options last updated time.</p>', 'OptionStatus$CreationDate' => '<p>Timestamp which tells the creation date for the entity.</p>', 'OptionStatus$UpdateDate' => '<p>Timestamp which tells the last updated time for the entity.</p>', 'ReservedElasticsearchInstance$StartTime' => '<p>The time the reservation started.</p>', ], ], 'UpgradeElasticsearchDomainRequest' => [ 'base' => '<p> Container for request parameters to <code> <a>UpgradeElasticsearchDomain</a> </code> operation. </p>', 'refs' => [], ], 'UpgradeElasticsearchDomainResponse' => [ 'base' => '<p> Container for response returned by <code> <a>UpgradeElasticsearchDomain</a> </code> operation. </p>', 'refs' => [], ], 'UpgradeHistory' => [ 'base' => '<p>History of the last 10 Upgrades and Upgrade Eligibility Checks.</p>', 'refs' => [ 'UpgradeHistoryList$member' => NULL, ], ], 'UpgradeHistoryList' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeHistoryResponse$UpgradeHistories' => '<p> A list of <code> <a>UpgradeHistory</a> </code> objects corresponding to each Upgrade or Upgrade Eligibility Check performed on a domain returned as part of <code> <a>GetUpgradeHistoryResponse</a> </code> object. </p>', ], ], 'UpgradeName' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeStatusResponse$UpgradeName' => '<p>A string that describes the update briefly</p>', 'UpgradeHistory$UpgradeName' => '<p>A string that describes the update briefly</p>', ], ], 'UpgradeStatus' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeStatusResponse$StepStatus' => '<p> One of 4 statuses that a step can go through returned as part of the <code> <a>GetUpgradeStatusResponse</a> </code> object. The status can take one of the following values: <ul> <li>In Progress</li> <li>Succeeded</li> <li>Succeeded with Issues</li> <li>Failed</li> </ul> </p>', 'UpgradeHistory$UpgradeStatus' => '<p> The overall status of the update. The status can take one of the following values: <ul> <li>In Progress</li> <li>Succeeded</li> <li>Succeeded with Issues</li> <li>Failed</li> </ul> </p>', 'UpgradeStepItem$UpgradeStepStatus' => '<p> The status of a particular step during an upgrade. The status can take one of the following values: <ul> <li>In Progress</li> <li>Succeeded</li> <li>Succeeded with Issues</li> <li>Failed</li> </ul> </p>', ], ], 'UpgradeStep' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeStatusResponse$UpgradeStep' => '<p> Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through: <ul> <li>PreUpgradeCheck</li> <li>Snapshot</li> <li>Upgrade</li> </ul> </p>', 'UpgradeStepItem$UpgradeStep' => '<p> Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does through: <ul> <li>PreUpgradeCheck</li> <li>Snapshot</li> <li>Upgrade</li> </ul> </p>', ], ], 'UpgradeStepItem' => [ 'base' => '<p>Represents a single step of the Upgrade or Upgrade Eligibility Check workflow.</p>', 'refs' => [ 'UpgradeStepsList$member' => NULL, ], ], 'UpgradeStepsList' => [ 'base' => NULL, 'refs' => [ 'UpgradeHistory$StepsList' => '<p> A list of <code> <a>UpgradeStepItem</a> </code> s representing information about each step performed as pard of a specific Upgrade or Upgrade Eligibility Check. </p>', ], ], 'UserPoolId' => [ 'base' => NULL, 'refs' => [ 'CognitoOptions$UserPoolId' => '<p>Specifies the Cognito user pool ID for Kibana authentication.</p>', ], ], 'Username' => [ 'base' => NULL, 'refs' => [ 'MasterUserOptions$MasterUserName' => '<p>The master user\'s username, which is stored in the Amazon Elasticsearch Service domain\'s internal database.</p>', 'SAMLOptionsInput$MasterUserName' => '<p>The SAML master username, which is stored in the Amazon Elasticsearch Service domain\'s internal database.</p>', ], ], 'VPCDerivedInfo' => [ 'base' => '<p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank"> VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>', 'refs' => [ 'ElasticsearchDomainStatus$VPCOptions' => '<p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>', 'VPCDerivedInfoStatus$Options' => '<p> Specifies the VPC options for the specified Elasticsearch domain.</p>', ], ], 'VPCDerivedInfoStatus' => [ 'base' => '<p> Status of the VPC options for the specified Elasticsearch domain.</p>', 'refs' => [ 'ElasticsearchDomainConfig$VPCOptions' => '<p>The <code>VPCOptions</code> for the specified domain. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank">VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>', ], ], 'VPCOptions' => [ 'base' => '<p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html" target="_blank"> VPC Endpoints for Amazon Elasticsearch Service Domains</a>.</p>', 'refs' => [ 'CreateElasticsearchDomainRequest$VPCOptions' => '<p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>', 'UpdateElasticsearchDomainConfigRequest$VPCOptions' => '<p>Options to specify the subnets and security groups for VPC endpoint. For more information, see <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc" target="_blank">Creating a VPC</a> in <i>VPC Endpoints for Amazon Elasticsearch Service Domains</i></p>', ], ], 'ValidationException' => [ 'base' => '<p>An exception for missing / invalid input fields. Gives http status code of 400.</p>', 'refs' => [], ], 'ValueStringList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p> Contains one or more values for the filter. </p>', ], ], 'VolumeType' => [ 'base' => '<p> The type of EBS volume, standard, gp2, or io1. See <a href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs" target="_blank">Configuring EBS-based Storage</a>for more information.</p>', 'refs' => [ 'EBSOptions$VolumeType' => '<p> Specifies the volume type for EBS-based storage.</p>', ], ], 'ZoneAwarenessConfig' => [ 'base' => '<p>Specifies the zone awareness configuration for the domain cluster, such as the number of availability zones.</p>', 'refs' => [ 'ElasticsearchClusterConfig$ZoneAwarenessConfig' => '<p>Specifies the zone awareness configuration for a domain when zone awareness is enabled.</p>', ], ], ],];
