<?php
// This file was auto-generated from sdk-root/src/data/dms/2016-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Database Migration Service</fullname> <p>Database Migration Service (DMS) can migrate your data to and from the most widely used commercial and open-source databases such as Oracle, PostgreSQL, Microsoft SQL Server, Amazon Redshift, MariaDB, Amazon Aurora, MySQL, and SAP Adaptive Server Enterprise (ASE). The service supports homogeneous migrations such as Oracle to Oracle, as well as heterogeneous migrations between different database platforms, such as Oracle to MySQL or SQL Server to PostgreSQL.</p> <p>For more information about DMS, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/Welcome.html">What Is Database Migration Service?</a> in the <i>Database Migration Service User Guide.</i> </p>', 'operations' => [ 'AddTagsToResource' => '<p>Adds metadata tags to an DMS resource, including replication instance, endpoint, security group, and migration task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or used in a Condition statement in an IAM policy for DMS. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type description.</p>', 'ApplyPendingMaintenanceAction' => '<p>Applies a pending maintenance action to a resource (for example, to a replication instance).</p>', 'CancelReplicationTaskAssessmentRun' => '<p>Cancels a single premigration assessment run.</p> <p>This operation prevents any individual assessments from running if they haven\'t started running. It also attempts to cancel any individual assessments that are currently running.</p>', 'CreateEndpoint' => '<p>Creates an endpoint using the provided settings.</p> <note> <p>For a MySQL source or target endpoint, don\'t explicitly specify the database using the <code>DatabaseName</code> request parameter on the <code>CreateEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.</p> </note>', 'CreateEventSubscription' => '<p> Creates an DMS event notification subscription. </p> <p>You can specify the type of source (<code>SourceType</code>) you want to be notified of, provide a list of DMS source IDs (<code>SourceIds</code>) that triggers the events, and provide a list of event categories (<code>EventCategories</code>) for events you want to be notified of. If you specify both the <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType = replication-instance</code> and <code>SourceIdentifier = my-replinstance</code>, you will be notified of all the replication instance events for the specified source. If you specify a <code>SourceType</code> but don\'t specify a <code>SourceIdentifier</code>, you receive notice of the events for that source type for all your DMS sources. If you don\'t specify either <code>SourceType</code> nor <code>SourceIdentifier</code>, you will be notified of events generated from all DMS sources belonging to your customer account.</p> <p>For more information about DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and Notifications</a> in the <i>Database Migration Service User Guide.</i> </p>', 'CreateReplicationInstance' => '<p>Creates the replication instance using the specified parameters.</p> <p>DMS requires that your account have certain roles with appropriate permissions before you can create a replication instance. For information on the required roles, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM Roles to Use With the CLI and DMS API</a>. For information on the required permissions, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM Permissions Needed to Use DMS</a>.</p>', 'CreateReplicationSubnetGroup' => '<p>Creates a replication subnet group given a list of the subnet IDs in a VPC.</p>', 'CreateReplicationTask' => '<p>Creates a replication task using the specified parameters.</p>', 'DeleteCertificate' => '<p>Deletes the specified certificate. </p>', 'DeleteConnection' => '<p>Deletes the connection between a replication instance and an endpoint.</p>', 'DeleteEndpoint' => '<p>Deletes the specified endpoint.</p> <note> <p>All tasks associated with the endpoint must be deleted before you can delete the endpoint.</p> </note> <p/>', 'DeleteEventSubscription' => '<p> Deletes an DMS event subscription. </p>', 'DeleteReplicationInstance' => '<p>Deletes the specified replication instance.</p> <note> <p>You must delete any migration tasks that are associated with the replication instance before you can delete it.</p> </note> <p/>', 'DeleteReplicationSubnetGroup' => '<p>Deletes a subnet group.</p>', 'DeleteReplicationTask' => '<p>Deletes the specified replication task.</p>', 'DeleteReplicationTaskAssessmentRun' => '<p>Deletes the record of a single premigration assessment run.</p> <p>This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves untouched all information about this assessment run that is stored in your Amazon S3 bucket.</p>', 'DescribeAccountAttributes' => '<p>Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by the account, such as the number of replication instances allowed. The description for each resource quota, includes the quota name, current usage toward that quota, and the quota\'s maximum value. DMS uses the unique account identifier to name each artifact used by DMS in the given region.</p> <p>This command does not take any parameters.</p>', 'DescribeApplicableIndividualAssessments' => '<p>Provides a list of individual assessments that you can specify for a new premigration assessment run, given one or more parameters.</p> <p>If you specify an existing migration task, this operation provides the default individual assessments you can specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which to base a premigration assessment run.</p> <p>To use these migration task modeling parameters, you must specify an existing replication instance, a source database engine, a target database engine, and a migration type. This combination of parameters potentially limits the default individual assessments available for an assessment run created for a corresponding migration task.</p> <p>If you specify no parameters, this operation provides a list of all possible individual assessments that you can specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of them or the operation cannot provide a list of individual assessments. The only parameter that you can specify alone is for an existing migration task. The specified task definition then determines the default list of individual assessments that you can specify in an assessment run for the task.</p>', 'DescribeCertificates' => '<p>Provides a description of the certificate.</p>', 'DescribeConnections' => '<p>Describes the status of the connections that have been made between the replication instance and an endpoint. Connections are created when you test an endpoint.</p>', 'DescribeEndpointSettings' => '<p>Returns information about the possible endpoint settings available when you create an endpoint for a specific database engine.</p>', 'DescribeEndpointTypes' => '<p>Returns information about the type of endpoints available.</p>', 'DescribeEndpoints' => '<p>Returns information about the endpoints for your account in the current region.</p>', 'DescribeEventCategories' => '<p>Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of the event categories and source types in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and Notifications</a> in the <i>Database Migration Service User Guide.</i> </p>', 'DescribeEventSubscriptions' => '<p>Lists all the event subscriptions for a customer account. The description of a subscription includes <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>, <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>. </p> <p>If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.</p>', 'DescribeEvents' => '<p> Lists events for a given source identifier and source type. You can also specify a start and end time. For more information on DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and Notifications</a> in the <i>Database Migration Service User Guide.</i> </p>', 'DescribeOrderableReplicationInstances' => '<p>Returns information about the replication instance types that can be created in the specified region.</p>', 'DescribePendingMaintenanceActions' => '<p>For internal use only</p>', 'DescribeRefreshSchemasStatus' => '<p>Returns the status of the RefreshSchemas operation.</p>', 'DescribeReplicationInstanceTaskLogs' => '<p>Returns information about the task logs for the specified task.</p>', 'DescribeReplicationInstances' => '<p>Returns information about replication instances for your account in the current region.</p>', 'DescribeReplicationSubnetGroups' => '<p>Returns information about the replication subnet groups.</p>', 'DescribeReplicationTaskAssessmentResults' => '<p>Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services account. This action always returns the latest results.</p> <p>For more information about DMS task assessments, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task assessment report</a> in the <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/Welcome.html"> Database Migration Service User Guide</a>.</p>', 'DescribeReplicationTaskAssessmentRuns' => '<p>Returns a paginated list of premigration assessment runs based on filter settings.</p> <p>These filter settings can specify a combination of premigration assessment runs, migration tasks, replication instances, and assessment run status values.</p> <note> <p>This operation doesn\'t return information about individual assessments. For this information, see the <code>DescribeReplicationTaskIndividualAssessments</code> operation. </p> </note>', 'DescribeReplicationTaskIndividualAssessments' => '<p>Returns a paginated list of individual assessments based on filter settings.</p> <p>These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment status values.</p>', 'DescribeReplicationTasks' => '<p>Returns information about replication tasks for your account in the current region.</p>', 'DescribeSchemas' => '<p>Returns information about the schema for the specified endpoint.</p> <p/>', 'DescribeTableStatistics' => '<p>Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and rows deleted.</p> <p>Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table statistics record for a table. It does not indicate the time of the last update to the table.</p>', 'ImportCertificate' => '<p>Uploads the specified certificate.</p>', 'ListTagsForResource' => '<p>Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, security group, and migration task. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type description.</p>', 'ModifyEndpoint' => '<p>Modifies the specified endpoint.</p> <note> <p>For a MySQL source or target endpoint, don\'t explicitly specify the database using the <code>DatabaseName</code> request parameter on the <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.</p> </note>', 'ModifyEventSubscription' => '<p>Modifies an existing DMS event notification subscription. </p>', 'ModifyReplicationInstance' => '<p>Modifies the replication instance to apply new settings. You can change one or more parameters by specifying these parameters and the new values in the request.</p> <p>Some settings are applied during the maintenance window.</p> <p/>', 'ModifyReplicationSubnetGroup' => '<p>Modifies the settings for the specified replication subnet group.</p>', 'ModifyReplicationTask' => '<p>Modifies the specified replication task.</p> <p>You can\'t modify the task endpoints. The task must be stopped before you can modify it. </p> <p>For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks</a> in the <i>Database Migration Service User Guide</i>.</p>', 'MoveReplicationTask' => '<p>Moves a replication task from its current replication instance to a different target replication instance using the specified parameters. The target replication instance must be created with the same or later DMS version as the current replication instance.</p>', 'RebootReplicationInstance' => '<p>Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes available again.</p>', 'RefreshSchemas' => '<p>Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes. You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.</p>', 'ReloadTables' => '<p>Reloads the target database table with the source data. </p>', 'RemoveTagsFromResource' => '<p>Removes metadata tags from an DMS resource, including replication instance, endpoint, security group, and migration task. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type description.</p>', 'StartReplicationTask' => '<p>Starts the replication task.</p> <p>For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks </a> in the <i>Database Migration Service User Guide.</i> </p>', 'StartReplicationTaskAssessment' => '<p> Starts the replication task assessment for unsupported data types in the source database. </p>', 'StartReplicationTaskAssessmentRun' => '<p>Starts a new premigration assessment run for one or more individual assessments of a migration task.</p> <p>The assessments that you can specify depend on the source and target database engine and the migration type defined for the given task. To run this operation, your migration task must already be created. After you run this operation, you can review the status of each individual assessment. You can also run the migration task manually after the assessment run and its individual assessments complete.</p>', 'StopReplicationTask' => '<p>Stops the replication task.</p>', 'TestConnection' => '<p>Tests the connection between the replication instance and the endpoint.</p>', ], 'shapes' => [ 'AccessDeniedFault' => [ 'base' => '<p>DMS was denied access to the endpoint. Check that the role is correctly configured.</p>', 'refs' => [], ], 'AccountQuota' => [ 'base' => '<p>Describes a quota for an Amazon Web Services account, for example the number of replication instances allowed.</p>', 'refs' => [ 'AccountQuotaList$member' => NULL, ], ], 'AccountQuotaList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesResponse$AccountQuotas' => '<p>Account quota information.</p>', ], ], 'AddTagsToResourceMessage' => [ 'base' => '<p>Associates a set of tags with an DMS resource.</p>', 'refs' => [], ], 'AddTagsToResourceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ApplyPendingMaintenanceActionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ApplyPendingMaintenanceActionResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceMessage$ResourceArnList' => '<p>List of ARNs that identify multiple DMS resources that you want to list tags for. This returns a list of keys (tag names) and their associated tag values. It also returns each tag\'s associated <code>ResourceArn</code> value, which is the ARN of the resource for which each listed tag is created. </p>', ], ], 'AuthMechanismValue' => [ 'base' => NULL, 'refs' => [ 'MongoDbSettings$AuthMechanism' => '<p> The authentication mechanism you use to access the MongoDB source endpoint.</p> <p>For the default value, in MongoDB version 2.x, <code>"default"</code> is <code>"mongodb_cr"</code>. For MongoDB version 3.x or later, <code>"default"</code> is <code>"scram_sha_1"</code>. This setting isn\'t used when <code>AuthType</code> is set to <code>"no"</code>.</p>', ], ], 'AuthTypeValue' => [ 'base' => NULL, 'refs' => [ 'MongoDbSettings$AuthType' => '<p> The authentication type you use to access the MongoDB source endpoint.</p> <p>When when set to <code>"no"</code>, user name and password parameters are not used and can be empty. </p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>The name of an Availability Zone for use during database migration. <code>AvailabilityZone</code> is an optional parameter to the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationInstance.html"> <code>CreateReplicationInstance</code> </a> operation, and it’s value relates to the Amazon Web Services Region of an endpoint. For example, the availability zone of an endpoint in the us-east-1 region might be us-east-1a, us-east-1b, us-east-1c, or us-east-1d.</p>', 'refs' => [ 'Subnet$SubnetAvailabilityZone' => '<p>The Availability Zone of the subnet.</p>', ], ], 'AvailabilityZonesList' => [ 'base' => NULL, 'refs' => [ 'OrderableReplicationInstance$AvailabilityZones' => '<p>List of Availability Zones for this replication instance.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'EventSubscription$Enabled' => '<p>Boolean value that indicates if the event subscription is enabled.</p>', 'ModifyReplicationInstanceMessage$ApplyImmediately' => '<p>Indicates whether the changes should be applied immediately or during the next maintenance window.</p>', 'ModifyReplicationInstanceMessage$AllowMajorVersionUpgrade' => '<p>Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage, and the change is asynchronously applied as soon as possible.</p> <p>This parameter must be set to <code>true</code> when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the replication instance\'s current version.</p>', 'ReplicationInstance$MultiAZ' => '<p> Specifies whether the replication instance is a Multi-AZ deployment. You can\'t set the <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>. </p>', 'ReplicationInstance$AutoMinorVersionUpgrade' => '<p>Boolean value indicating if minor version upgrades will be automatically applied to the instance.</p>', 'ReplicationInstance$PubliclyAccessible' => '<p> Specifies the accessibility options for the replication instance. A value of <code>true</code> represents an instance with a public IP address. A value of <code>false</code> represents an instance with a private IP address. The default value is <code>true</code>. </p>', 'SupportedEndpointType$SupportsCDC' => '<p>Indicates if change data capture (CDC) is supported.</p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$Enabled' => '<p> A Boolean value; set to <code>true</code> to activate the subscription, or set to <code>false</code> to create the subscription but not activate it. </p>', 'CreateReplicationInstanceMessage$MultiAZ' => '<p> Specifies whether the replication instance is a Multi-AZ deployment. You can\'t set the <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>. </p>', 'CreateReplicationInstanceMessage$AutoMinorVersionUpgrade' => '<p>A value that indicates whether minor engine upgrades are applied automatically to the replication instance during the maintenance window. This parameter defaults to <code>true</code>.</p> <p>Default: <code>true</code> </p>', 'CreateReplicationInstanceMessage$PubliclyAccessible' => '<p> Specifies the accessibility options for the replication instance. A value of <code>true</code> represents an instance with a public IP address. A value of <code>false</code> represents an instance with a private IP address. The default value is <code>true</code>. </p>', 'DescribeReplicationTasksMessage$WithoutSettings' => '<p>An option to set to avoid returning information about settings. Use this to reduce overhead when setting information is too large. To use this option, choose <code>true</code>; otherwise, choose <code>false</code> (the default).</p>', 'DocDbSettings$ExtractDocId' => '<p> Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to <code>"none"</code>. </p> <p>Default value is <code>"false"</code>. </p>', 'EndpointSetting$Sensitive' => '<p>A value that marks this endpoint setting as sensitive.</p>', 'IBMDb2Settings$SetDataCaptureChanges' => '<p>Enables ongoing replication (CDC) as a BOOLEAN value. The default is true.</p>', 'KafkaSettings$IncludeTransactionDetails' => '<p>Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for <code>transaction_id</code>, previous <code>transaction_id</code>, and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code>.</p>', 'KafkaSettings$IncludePartitionValue' => '<p>Shows the partition value within the Kafka message output unless the partition type is <code>schema-table-type</code>. The default is <code>false</code>.</p>', 'KafkaSettings$PartitionIncludeSchemaTable' => '<p>Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code>. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. The default is <code>false</code>.</p>', 'KafkaSettings$IncludeTableAlterOperations' => '<p>Includes any data definition language (DDL) operations that change the table in the control data, such as <code>rename-table</code>, <code>drop-table</code>, <code>add-column</code>, <code>drop-column</code>, and <code>rename-column</code>. The default is <code>false</code>.</p>', 'KafkaSettings$IncludeControlDetails' => '<p>Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. The default is <code>false</code>.</p>', 'KafkaSettings$IncludeNullAndEmpty' => '<p>Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.</p>', 'KafkaSettings$NoHexPrefix' => '<p>Set this optional parameter to <code>true</code> to avoid adding a \'0x\' prefix to raw data in hexadecimal format. For example, by default, DMS adds a \'0x\' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the \'0x\' prefix.</p>', 'KinesisSettings$IncludeTransactionDetails' => '<p>Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for <code>transaction_id</code>, previous <code>transaction_id</code>, and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code>.</p>', 'KinesisSettings$IncludePartitionValue' => '<p>Shows the partition value within the Kinesis message output, unless the partition type is <code>schema-table-type</code>. The default is <code>false</code>.</p>', 'KinesisSettings$PartitionIncludeSchemaTable' => '<p>Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code>. Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same shard, which causes throttling. The default is <code>false</code>.</p>', 'KinesisSettings$IncludeTableAlterOperations' => '<p>Includes any data definition language (DDL) operations that change the table in the control data, such as <code>rename-table</code>, <code>drop-table</code>, <code>add-column</code>, <code>drop-column</code>, and <code>rename-column</code>. The default is <code>false</code>.</p>', 'KinesisSettings$IncludeControlDetails' => '<p>Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. The default is <code>false</code>.</p>', 'KinesisSettings$IncludeNullAndEmpty' => '<p>Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.</p>', 'KinesisSettings$NoHexPrefix' => '<p>Set this optional parameter to <code>true</code> to avoid adding a \'0x\' prefix to raw data in hexadecimal format. For example, by default, DMS adds a \'0x\' prefix to the LOB column type in hexadecimal format moving from an Oracle source to an Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the \'0x\' prefix.</p>', 'MicrosoftSQLServerSettings$QuerySingleAlwaysOnNode' => '<p>Cleans and recreates table metadata information on the replication instance when a mismatch occurs. An example is a situation where running an alter DDL statement on a table might result in different information about the table cached in the replication instance.</p>', 'MicrosoftSQLServerSettings$ReadBackupOnly' => '<p>When this attribute is set to <code>Y</code>, DMS only reads changes from transaction log backups and doesn\'t read from the active transaction log file during ongoing replication. Setting this parameter to <code>Y</code> enables you to control active transaction log file growth during full load and ongoing replication tasks. However, it can add some source latency to ongoing replication.</p>', 'MicrosoftSQLServerSettings$UseBcpFullLoad' => '<p>Use this to attribute to transfer data for full-load operations using BCP. When the target table contains an identity column that does not exist in the source table, you must disable the use BCP for loading table option.</p>', 'MicrosoftSQLServerSettings$UseThirdPartyBackupDevice' => '<p>When this attribute is set to <code>Y</code>, DMS processes third-party transaction log backups if they are created in native format.</p>', 'ModifyEndpointMessage$ExactSettings' => '<p>If this attribute is Y, the current call to <code>ModifyEndpoint</code> replaces all existing endpoint settings with the exact settings that you specify in this call. If this attribute is N, the current call to <code>ModifyEndpoint</code> does two things: </p> <ul> <li> <p>It replaces any endpoint settings that already exist with new values, for settings with the same names.</p> </li> <li> <p>It creates new endpoint settings that you specify in the call, for settings with different names. </p> </li> </ul> <p>For example, if you call <code>create-endpoint ... --endpoint-settings \'{"a":1}\' ...</code>, the endpoint has the following endpoint settings: <code>\'{"a":1}\'</code>. If you then call <code>modify-endpoint ... --endpoint-settings \'{"b":2}\' ...</code> for the same endpoint, the endpoint has the following settings: <code>\'{"a":1,"b":2}\'</code>. </p> <p>However, suppose that you follow this with a call to <code>modify-endpoint ... --endpoint-settings \'{"b":2}\' --exact-settings ...</code> for that same endpoint again. Then the endpoint has the following settings: <code>\'{"b":2}\'</code>. All existing settings are replaced with the exact settings that you specify. </p>', 'ModifyEventSubscriptionMessage$Enabled' => '<p> A Boolean value; set to <b>true</b> to activate the subscription. </p>', 'ModifyReplicationInstanceMessage$MultiAZ' => '<p> Specifies whether the replication instance is a Multi-AZ deployment. You can\'t set the <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>. </p>', 'ModifyReplicationInstanceMessage$AutoMinorVersionUpgrade' => '<p>A value that indicates that minor version upgrades are applied automatically to the replication instance during the maintenance window. Changing this parameter doesn\'t result in an outage, except in the case described following. The change is asynchronously applied as soon as possible. </p> <p>An outage does result if these factors apply: </p> <ul> <li> <p>This parameter is set to <code>true</code> during the maintenance window.</p> </li> <li> <p>A newer minor version is available. </p> </li> <li> <p>DMS has enabled automatic patching for the given engine version. </p> </li> </ul>', 'MySQLSettings$CleanSourceMetadataOnMismatch' => '<p>Adjusts the behavior of DMS when migrating from an SQL Server source database that is hosted as part of an Always On availability group cluster. If you need DMS to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code>.</p>', 'NeptuneSettings$IamAuthEnabled' => '<p>If you want Identity and Access Management (IAM) authorization enabled for this endpoint, set this parameter to <code>true</code>. Then attach the appropriate IAM policy document to your service role specified by <code>ServiceAccessRoleArn</code>. The default is <code>false</code>.</p>', 'OracleSettings$AddSupplementalLogging' => '<p>Set this attribute to set up table-level supplemental logging for the Oracle database. This attribute enables PRIMARY KEY supplemental logging on all tables selected for a migration task.</p> <p>If you use this option, you still need to enable database-level supplemental logging.</p>', 'OracleSettings$AllowSelectNestedTables' => '<p>Set this attribute to <code>true</code> to enable replication of Oracle tables containing columns that are nested tables or defined types.</p>', 'OracleSettings$AccessAlternateDirectly' => '<p>Set this attribute to <code>false</code> in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This tells the DMS instance to not access redo logs through any specified path prefix replacement using direct file access.</p>', 'OracleSettings$UseAlternateFolderForOnline' => '<p>Set this attribute to <code>true</code> in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This tells the DMS instance to use any specified prefix replacement to access all online redo logs.</p>', 'OracleSettings$ReplacePathPrefix' => '<p>Set this attribute to true in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This setting tells DMS instance to replace the default Oracle root with the specified <code>usePathPrefix</code> setting to access the redo logs.</p>', 'OracleSettings$EnableHomogenousTablespace' => '<p>Set this attribute to enable homogenous tablespace replication and create existing tables or indexes under the same tablespace on the target.</p>', 'OracleSettings$DirectPathNoLog' => '<p>When set to <code>true</code>, this attribute helps to increase the commit rate on the Oracle target database by writing directly to tables and not writing a trail to database logs.</p>', 'OracleSettings$ArchivedLogsOnly' => '<p>When this field is set to <code>Y</code>, DMS only accesses the archived redo logs. If the archived redo logs are stored on Oracle ASM only, the DMS user account needs to be granted ASM privileges.</p>', 'OracleSettings$DirectPathParallelLoad' => '<p>When set to <code>true</code>, this attribute specifies a parallel load when <code>useDirectPathFullLoad</code> is set to <code>Y</code>. This attribute also only applies when you use the DMS parallel load feature. Note that the target table cannot have any constraints or indexes.</p>', 'OracleSettings$FailTasksOnLobTruncation' => '<p>When set to <code>true</code>, this attribute causes a task to fail if the actual size of an LOB column is greater than the specified <code>LobMaxSize</code>.</p> <p>If a task is set to limited LOB mode and this option is set to <code>true</code>, the task fails instead of truncating the LOB data.</p>', 'OracleSettings$ReadTableSpaceName' => '<p>When set to <code>true</code>, this attribute supports tablespace replication.</p>', 'OracleSettings$UseBFile' => '<p>Set this attribute to Y to capture change data using the Binary Reader utility. Set <code>UseLogminerReader</code> to N to set this attribute to Y. To use Binary Reader with Amazon RDS for Oracle as the source, you set additional attributes. For more information about using this setting with Oracle Automatic Storage Management (ASM), see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using Oracle LogMiner or DMS Binary Reader for CDC</a>.</p>', 'OracleSettings$UseDirectPathFullLoad' => '<p>Set this attribute to Y to have DMS use a direct path full load. Specify this value to use the direct path protocol in the Oracle Call Interface (OCI). By using this OCI protocol, you can bulk-load Oracle target tables during a full load.</p>', 'OracleSettings$UseLogminerReader' => '<p>Set this attribute to Y to capture change data using the Oracle LogMiner utility (the default). Set this attribute to N if you want to access the redo logs as a binary file. When you set <code>UseLogminerReader</code> to N, also set <code>UseBfile</code> to Y. For more information on this setting and using Oracle ASM, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using Oracle LogMiner or DMS Binary Reader for CDC</a> in the <i>DMS User Guide</i>.</p>', 'PostgreSQLSettings$CaptureDdls' => '<p>To capture DDL events, DMS creates various artifacts in the PostgreSQL database when the task starts. You can later remove these artifacts.</p> <p>If this value is set to <code>N</code>, you don\'t have to create tables or triggers on the source database.</p>', 'PostgreSQLSettings$FailTasksOnLobTruncation' => '<p>When set to <code>true</code>, this value causes a task to fail if the actual size of a LOB column is greater than the specified <code>LobMaxSize</code>.</p> <p>If task is set to Limited LOB mode and this option is set to true, the task fails instead of truncating the LOB data.</p>', 'PostgreSQLSettings$HeartbeatEnable' => '<p>The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this, it prevents idle logical replication slots from holding onto old WAL logs, which can result in storage full situations on the source. This heartbeat keeps <code>restart_lsn</code> moving and prevents storage full scenarios.</p>', 'RebootReplicationInstanceMessage$ForceFailover' => '<p>If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ failover. (If the instance isn\'t configured for Multi-AZ, then you can\'t specify <code>true</code>.)</p>', 'RedshiftSettings$AcceptAnyDate' => '<p>A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to be loaded without generating an error. You can choose <code>true</code> or <code>false</code> (the default).</p> <p>This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT parameter. If the date format for the data doesn\'t match the DATEFORMAT specification, Amazon Redshift inserts a NULL value into that field. </p>', 'RedshiftSettings$CaseSensitiveNames' => '<p>If Amazon Redshift is configured to support case sensitive schema names, set <code>CaseSensitiveNames</code> to <code>true</code>. The default is <code>false</code>.</p>', 'RedshiftSettings$CompUpdate' => '<p>If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies automatic compression if the table is empty. This applies even if the table columns already have encodings other than <code>RAW</code>. If you set <code>CompUpdate</code> to <code>false</code>, automatic compression is disabled and existing column encodings aren\'t changed. The default is <code>true</code>.</p>', 'RedshiftSettings$EmptyAsNull' => '<p>A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as NULL. A value of <code>true</code> sets empty CHAR and VARCHAR fields to null. The default is <code>false</code>.</p>', 'RedshiftSettings$ExplicitIds' => '<p>This setting is only valid for a full-load migration task. Set <code>ExplicitIds</code> to <code>true</code> to have tables with <code>IDENTITY</code> columns override their auto-generated values with explicit values loaded from the source data files used to populate the tables. The default is <code>false</code>.</p>', 'RedshiftSettings$RemoveQuotes' => '<p>A value that specifies to remove surrounding quotation marks from strings in the incoming data. All characters within the quotation marks, including delimiters, are retained. Choose <code>true</code> to remove quotation marks. The default is <code>false</code>.</p>', 'RedshiftSettings$TrimBlanks' => '<p>A value that specifies to remove the trailing white space characters from a VARCHAR string. This parameter applies only to columns with a VARCHAR data type. Choose <code>true</code> to remove unneeded white space. The default is <code>false</code>.</p>', 'RedshiftSettings$TruncateColumns' => '<p>A value that specifies to truncate data in columns to the appropriate number of characters, so that the data fits in the column. This parameter applies only to columns with a VARCHAR or CHAR data type, and rows with a size of 4 MB or less. Choose <code>true</code> to truncate data. The default is <code>false</code>.</p>', 'ReplicationPendingModifiedValues$MultiAZ' => '<p> Specifies whether the replication instance is a Multi-AZ deployment. You can\'t set the <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>. </p>', 'S3Settings$EnableStatistics' => '<p>A value that enables statistics for Parquet pages and row groups. Choose <code>true</code> to enable statistics, <code>false</code> to disable. Statistics include <code>NULL</code>, <code>DISTINCT</code>, <code>MAX</code>, and <code>MIN</code> values. This parameter defaults to <code>true</code>. This value is used for .parquet file format only.</p>', 'S3Settings$IncludeOpForFullLoad' => '<p>A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output files only to indicate how the rows were added to the source database.</p> <note> <p>DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.</p> </note> <p>For full load, records can only be inserted. By default (the <code>false</code> setting), no information is recorded in these output files for a full load to indicate that the rows were inserted at the source database. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> or <code>y</code>, the INSERT is recorded as an I annotation in the first field of the .csv file. This allows the format of your target records from a full load to be consistent with the target records from a CDC load.</p> <note> <p>This setting works together with the <code>CdcInsertsOnly</code> and the <code>CdcInsertsAndUpdates</code> parameters for output to .csv files only. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p> </note>', 'S3Settings$CdcInsertsOnly' => '<p>A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar storage (.parquet) output files. By default (the <code>false</code> setting), the first field in a .csv or .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was inserted, updated, or deleted at the source database for a CDC load to the target.</p> <p>If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only INSERTs from the source database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are recorded depends on the value of <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code> is set to <code>true</code>, the first field of every CDC record is set to I to indicate the INSERT operation at the source. If <code>IncludeOpForFullLoad</code> is set to <code>false</code>, every CDC record is written without a first field to indicate the INSERT operation at the source. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p> <note> <p>DMS supports the interaction described preceding between the <code>CdcInsertsOnly</code> and <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later. </p> <p> <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can\'t both be set to <code>true</code> for the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code> for the same endpoint, but not both.</p> </note>', 'S3Settings$ParquetTimestampInMillisecond' => '<p>A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to an Amazon S3 object file in .parquet format.</p> <note> <p>DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.</p> </note> <p>When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code>, DMS writes all <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision. Otherwise, DMS writes them with microsecond precision.</p> <p>Currently, Amazon Athena and Glue can handle only millisecond precision for <code>TIMESTAMP</code> values. Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet formatted only if you plan to query or process the data with Athena or Glue.</p> <note> <p>DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with microsecond precision.</p> <p>Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp column value that is inserted by setting the <code>TimestampColumnName</code> parameter.</p> </note>', 'S3Settings$CdcInsertsAndUpdates' => '<p>A value that enables a change data capture (CDC) load to write INSERT and UPDATE operations to .csv or .parquet (columnar storage) output files. The default setting is <code>false</code>, but when <code>CdcInsertsAndUpdates</code> is set to <code>true</code> or <code>y</code>, only INSERTs and UPDATEs from the source database are migrated to the .csv or .parquet file. </p> <p>For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the value of the <code>IncludeOpForFullLoad</code> parameter. If <code>IncludeOpForFullLoad</code> is set to <code>true</code>, the first field of every CDC record is set to either <code>I</code> or <code>U</code> to indicate INSERT and UPDATE operations at the source. But if <code>IncludeOpForFullLoad</code> is set to <code>false</code>, CDC records are written without an indication of INSERT or UPDATE operations at the source. For more information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p> <note> <p>DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in versions 3.3.1 and later.</p> <p> <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can\'t both be set to <code>true</code> for the same endpoint. Set either <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code> for the same endpoint, but not both.</p> </note>', 'S3Settings$DatePartitionEnabled' => '<p>When set to <code>true</code>, this parameter partitions S3 bucket folders based on transaction commit dates. The default value is <code>false</code>. For more information about date-based folder partitioning, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning">Using date-based folder partitioning</a>.</p>', 'S3Settings$UseCsvNoSupValue' => '<p>This setting applies if the S3 output files during a change data capture (CDC) load are written in .csv format. If set to <code>true</code> for columns not included in the supplemental log, DMS uses the value specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue"> <code>CsvNoSupValue</code> </a>. If not set or set to <code>false</code>, DMS uses the null value for these columns.</p> <note> <p>This setting is supported in DMS versions 3.4.1 and later.</p> </note>', 'S3Settings$PreserveTransactions' => '<p>If set to <code>true</code>, DMS saves the transaction order for a change data capture (CDC) load on the Amazon S3 target specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath"> <code>CdcPath</code> </a>. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3 target</a>.</p> <note> <p>This setting is supported in DMS versions 3.4.2 and later.</p> </note>', 'S3Settings$AddColumnName' => '<p>An optional parameter that, when set to <code>true</code> or <code>y</code>, you can use to add column name information to the .csv output file.</p> <p>The default value is <code>false</code>. Valid values are <code>true</code>, <code>false</code>, <code>y</code>, and <code>n</code>.</p>', 'S3Settings$Rfc4180' => '<p>For an S3 source, when this value is set to <code>true</code> or <code>y</code>, each leading double quotation mark has to be followed by an ending double quotation mark. This formatting complies with RFC 4180. When this value is set to <code>false</code> or <code>n</code>, string literals are copied to the target as is. In this case, a delimiter (row or column) signals the end of the field. Thus, you can\'t use a delimiter as part of the string, because it signals the end of the value.</p> <p>For an S3 target, an optional parameter used to set behavior to comply with RFC 4180 for data migrated to Amazon S3 using .csv file format only. When this value is set to <code>true</code> or <code>y</code> using Amazon S3 as a target, if the data has quotation marks or newline characters in it, DMS encloses the entire column with an additional pair of double quotation marks ("). Every quotation mark within the data is repeated twice.</p> <p>The default value is <code>true</code>. Valid values include <code>true</code>, <code>false</code>, <code>y</code>, and <code>n</code>.</p>', 'TableStatistics$FullLoadReloaded' => '<p>A value that indicates if the table was reloaded (<code>true</code>) or loaded as part of a new full load operation (<code>false</code>).</p>', ], ], 'CancelReplicationTaskAssessmentRunMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CancelReplicationTaskAssessmentRunResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'CannedAclForObjectsValue' => [ 'base' => NULL, 'refs' => [ 'S3Settings$CannedAclForObjects' => '<p>A value that enables DMS to specify a predefined (canned) access control list for objects created in an Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned ACL</a> in the <i>Amazon S3 Developer Guide.</i> </p> <p>The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE, AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.</p>', ], ], 'Certificate' => [ 'base' => '<p>The SSL certificate that can be used to encrypt connections between the endpoints and the replication instance.</p>', 'refs' => [ 'CertificateList$member' => NULL, 'DeleteCertificateResponse$Certificate' => '<p>The Secure Sockets Layer (SSL) certificate.</p>', 'ImportCertificateResponse$Certificate' => '<p>The certificate to be uploaded.</p>', ], ], 'CertificateList' => [ 'base' => NULL, 'refs' => [ 'DescribeCertificatesResponse$Certificates' => '<p>The Secure Sockets Layer (SSL) certificates associated with the replication instance.</p>', ], ], 'CertificateWallet' => [ 'base' => NULL, 'refs' => [ 'Certificate$CertificateWallet' => '<p>The location of an imported Oracle Wallet certificate for use with SSL.</p>', 'ImportCertificateMessage$CertificateWallet' => '<p>The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a <code>.sso</code> file using the <code>fileb://</code> prefix. You can\'t provide the certificate inline. </p>', ], ], 'CharLengthSemantics' => [ 'base' => NULL, 'refs' => [ 'OracleSettings$CharLengthSemantics' => '<p>Specifies whether the length of a character column is in bytes or in characters. To indicate that the character column length is in characters, set this attribute to <code>CHAR</code>. Otherwise, the character column length is in bytes.</p> <p>Example: <code>charLengthSemantics=CHAR;</code> </p>', ], ], 'CompressionTypeValue' => [ 'base' => NULL, 'refs' => [ 'S3Settings$CompressionType' => '<p>An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files. Either set this parameter to NONE (the default) or don\'t use it to leave the files uncompressed. This parameter applies to both .csv and .parquet file formats. </p>', ], ], 'Connection' => [ 'base' => '<p>Status of the connection between an endpoint and a replication instance, including Amazon Resource Names (ARNs) and the last error message issued.</p>', 'refs' => [ 'ConnectionList$member' => NULL, 'DeleteConnectionResponse$Connection' => '<p>The connection that is being deleted.</p>', 'TestConnectionResponse$Connection' => '<p>The connection tested.</p>', ], ], 'ConnectionList' => [ 'base' => NULL, 'refs' => [ 'DescribeConnectionsResponse$Connections' => '<p>A description of the connections.</p>', ], ], 'CreateEndpointMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateEndpointResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateEventSubscriptionResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateReplicationInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateReplicationInstanceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateReplicationSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateReplicationSubnetGroupResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateReplicationTaskMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateReplicationTaskResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DataFormatValue' => [ 'base' => NULL, 'refs' => [ 'S3Settings$DataFormat' => '<p>The format of the data that you want to use for output. You can choose one of the following: </p> <ul> <li> <p> <code>csv</code> : This is a row-based file format with comma-separated values (.csv). </p> </li> <li> <p> <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient compression and provides faster query response. </p> </li> </ul>', ], ], 'DatePartitionDelimiterValue' => [ 'base' => NULL, 'refs' => [ 'S3Settings$DatePartitionDelimiter' => '<p>Specifies a date separating delimiter to use during folder partitioning. The default value is <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.</p>', ], ], 'DatePartitionSequenceValue' => [ 'base' => NULL, 'refs' => [ 'S3Settings$DatePartitionSequence' => '<p>Identifies the sequence of the date format to use during folder partitioning. The default value is <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.</p>', ], ], 'DeleteCertificateMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteConnectionResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEndpointMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEndpointResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEventSubscriptionResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteReplicationInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteReplicationInstanceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteReplicationSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteReplicationSubnetGroupResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteReplicationTaskAssessmentRunMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteReplicationTaskAssessmentRunResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteReplicationTaskMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteReplicationTaskResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeAccountAttributesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeAccountAttributesResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeApplicableIndividualAssessmentsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeApplicableIndividualAssessmentsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeCertificatesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeConnectionsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEndpointSettingsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointTypesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEndpointTypesResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEndpointsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEndpointsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventCategoriesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventCategoriesResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventSubscriptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventSubscriptionsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeOrderableReplicationInstancesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeOrderableReplicationInstancesResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribePendingMaintenanceActionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribePendingMaintenanceActionsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeRefreshSchemasStatusMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeRefreshSchemasStatusResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationInstanceTaskLogsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplicationInstanceTaskLogsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplicationInstancesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationInstancesResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationSubnetGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationSubnetGroupsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationTaskAssessmentResultsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationTaskAssessmentResultsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationTaskAssessmentRunsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationTaskAssessmentRunsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationTaskIndividualAssessmentsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationTaskIndividualAssessmentsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationTasksMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReplicationTasksResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeSchemasMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeSchemasResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeTableStatisticsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeTableStatisticsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DmsSslModeValue' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointMessage$SslMode' => '<p>The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code> </p>', 'Endpoint$SslMode' => '<p>The SSL mode used to connect to the endpoint. The default value is <code>none</code>.</p>', 'ModifyEndpointMessage$SslMode' => '<p>The SSL mode used to connect to the endpoint. The default value is <code>none</code>.</p>', ], ], 'DmsTransferSettings' => [ 'base' => '<p> The settings in JSON format for the DMS Transfer type source endpoint. </p>', 'refs' => [ 'CreateEndpointMessage$DmsTransferSettings' => '<p>The settings in JSON format for the DMS transfer type of source endpoint. </p> <p>Possible settings include the following:</p> <ul> <li> <p> <code>ServiceAccessRoleArn</code> - The IAM role that has permission to access the Amazon S3 bucket. The role must allow the <code>iam:PassRole</code> action.</p> </li> <li> <p> <code>BucketName</code> - The name of the S3 bucket to use.</p> </li> </ul> <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string,BucketName=string</code> </p> <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string", } </code> </p>', 'Endpoint$DmsTransferSettings' => '<p>The settings in JSON format for the DMS transfer type of source endpoint. </p> <p>Possible settings include the following:</p> <ul> <li> <p> <code>ServiceAccessRoleArn</code> - The IAM role that has permission to access the Amazon S3 bucket. The role must allow the <code>iam:PassRole</code> action.</p> </li> <li> <p> <code>BucketName</code> - The name of the S3 bucket to use.</p> </li> </ul> <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string,BucketName=string,</code> </p> <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string"} </code> </p>', 'ModifyEndpointMessage$DmsTransferSettings' => '<p>The settings in JSON format for the DMS transfer type of source endpoint. </p> <p>Attributes include the following:</p> <ul> <li> <p>serviceAccessRoleArn - The Identity and Access Management (IAM) role that has permission to access the Amazon S3 bucket. The role must allow the <code>iam:PassRole</code> action.</p> </li> <li> <p>BucketName - The name of the S3 bucket to use.</p> </li> </ul> <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string ,BucketName=string</code> </p> <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string"} </code> </p>', ], ], 'DocDbSettings' => [ 'base' => '<p>Provides information that defines a DocumentDB endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$DocDbSettings' => NULL, 'Endpoint$DocDbSettings' => NULL, 'ModifyEndpointMessage$DocDbSettings' => '<p>Settings in JSON format for the source DocumentDB endpoint. For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service </a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'DynamoDbSettings' => [ 'base' => '<p>Provides the Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to define an Amazon DynamoDB target endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$DynamoDbSettings' => '<p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$DynamoDbSettings' => '<p>The settings for the DynamoDB target endpoint. For more information, see the <code>DynamoDBSettings</code> structure.</p>', 'ModifyEndpointMessage$DynamoDbSettings' => '<p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'ElasticsearchSettings' => [ 'base' => '<p>Provides information that defines an Elasticsearch endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$ElasticsearchSettings' => '<p>Settings in JSON format for the target Elasticsearch endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in the <i>Database Migration Service User Guide</i>.</p>', 'Endpoint$ElasticsearchSettings' => '<p>The settings for the Elasticsearch source endpoint. For more information, see the <code>ElasticsearchSettings</code> structure.</p>', 'ModifyEndpointMessage$ElasticsearchSettings' => '<p>Settings in JSON format for the target Elasticsearch endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'EncodingTypeValue' => [ 'base' => NULL, 'refs' => [ 'S3Settings$EncodingType' => '<p>The type of encoding you are using: </p> <ul> <li> <p> <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated values more efficiently. This is the default.</p> </li> <li> <p> <code>PLAIN</code> doesn\'t use encoding at all. Values are stored as they are.</p> </li> <li> <p> <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary is stored in a dictionary page for each column chunk.</p> </li> </ul>', ], ], 'EncryptionModeValue' => [ 'base' => NULL, 'refs' => [ 'RedshiftSettings$EncryptionMode' => '<p>The type of server-side encryption that you want to use for your data. This encryption type is part of the endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p> <note> <p>For the <code>ModifyEndpoint</code> operation, you can change the existing value of the <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.</p> </note> <p>To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with a policy that allows <code>"arn:aws:s3:::*"</code> to use the following actions: <code>"s3:PutObject", "s3:ListBucket"</code> </p>', 'S3Settings$EncryptionMode' => '<p>The type of server-side encryption that you want to use for your data. This encryption type is part of the endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p> <note> <p>For the <code>ModifyEndpoint</code> operation, you can change the existing value of the <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to <code>SSE_S3</code>. But you can’t change the existing value from <code>SSE_S3</code> to <code>SSE_KMS</code>.</p> </note> <p>To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use the following actions:</p> <ul> <li> <p> <code>s3:CreateBucket</code> </p> </li> <li> <p> <code>s3:ListBucket</code> </p> </li> <li> <p> <code>s3:DeleteBucket</code> </p> </li> <li> <p> <code>s3:GetBucketLocation</code> </p> </li> <li> <p> <code>s3:GetObject</code> </p> </li> <li> <p> <code>s3:PutObject</code> </p> </li> <li> <p> <code>s3:DeleteObject</code> </p> </li> <li> <p> <code>s3:GetObjectVersion</code> </p> </li> <li> <p> <code>s3:GetBucketPolicy</code> </p> </li> <li> <p> <code>s3:PutBucketPolicy</code> </p> </li> <li> <p> <code>s3:DeleteBucketPolicy</code> </p> </li> </ul>', ], ], 'Endpoint' => [ 'base' => '<p>Describes an endpoint of a database instance in response to operations such as the following:</p> <ul> <li> <p> <code>CreateEndpoint</code> </p> </li> <li> <p> <code>DescribeEndpoint</code> </p> </li> <li> <p> <code>ModifyEndpoint</code> </p> </li> </ul>', 'refs' => [ 'CreateEndpointResponse$Endpoint' => '<p>The endpoint that was created.</p>', 'DeleteEndpointResponse$Endpoint' => '<p>The endpoint that was deleted.</p>', 'EndpointList$member' => NULL, 'ModifyEndpointResponse$Endpoint' => '<p>The modified endpoint.</p>', ], ], 'EndpointList' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointsResponse$Endpoints' => '<p>Endpoint description.</p>', ], ], 'EndpointSetting' => [ 'base' => '<p>Endpoint settings.</p>', 'refs' => [ 'EndpointSettingsList$member' => NULL, ], ], 'EndpointSettingEnumValues' => [ 'base' => NULL, 'refs' => [ 'EndpointSetting$EnumValues' => '<p>Enumerated values to use for this endpoint.</p>', ], ], 'EndpointSettingTypeValue' => [ 'base' => NULL, 'refs' => [ 'EndpointSetting$Type' => '<p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>', ], ], 'EndpointSettingsList' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointSettingsResponse$EndpointSettings' => '<p>Descriptions of the endpoint settings available for your source or target database engine.</p>', ], ], 'Event' => [ 'base' => '<p>Describes an identifiable significant activity that affects a replication instance or task. This object can provide the message, the available event categories, the date and source of the event, and the DMS resource type.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventCategoriesList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$EventCategories' => '<p>A list of event categories for a source type that you want to subscribe to. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and Notifications</a> in the <i>Database Migration Service User Guide.</i> </p>', 'DescribeEventsMessage$EventCategories' => '<p>A list of event categories for the source type that you\'ve chosen.</p>', 'Event$EventCategories' => '<p>The event categories available for the specified source type.</p>', 'EventCategoryGroup$EventCategories' => '<p> A list of event categories from a source type that you\'ve chosen.</p>', 'EventSubscription$EventCategoriesList' => '<p>A lists of event categories.</p>', 'ModifyEventSubscriptionMessage$EventCategories' => '<p> A list of event categories for a source type that you want to subscribe to. Use the <code>DescribeEventCategories</code> action to see a list of event categories. </p>', ], ], 'EventCategoryGroup' => [ 'base' => '<p>Lists categories of events subscribed to, and generated by, the applicable DMS resource type. This data type appears in response to the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_EventCategoryGroup.html"> <code>DescribeEventCategories</code> </a> action.</p>', 'refs' => [ 'EventCategoryGroupList$member' => NULL, ], ], 'EventCategoryGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribeEventCategoriesResponse$EventCategoryGroupList' => '<p>A list of event categories.</p>', ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsResponse$Events' => '<p>The events described.</p>', ], ], 'EventSubscription' => [ 'base' => '<p>Describes an event notification subscription created by the <code>CreateEventSubscription</code> operation.</p>', 'refs' => [ 'CreateEventSubscriptionResponse$EventSubscription' => '<p>The event subscription that was created.</p>', 'DeleteEventSubscriptionResponse$EventSubscription' => '<p>The event subscription that was deleted.</p>', 'EventSubscriptionsList$member' => NULL, 'ModifyEventSubscriptionResponse$EventSubscription' => '<p>The modified event subscription.</p>', ], ], 'EventSubscriptionsList' => [ 'base' => NULL, 'refs' => [ 'DescribeEventSubscriptionsResponse$EventSubscriptionsList' => '<p>A list of event subscriptions.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedFault$message' => '<p/>', 'InsufficientResourceCapacityFault$message' => '<p/>', 'InvalidCertificateFault$message' => NULL, 'InvalidResourceStateFault$message' => '<p/>', 'InvalidSubnet$message' => '<p/>', 'KMSAccessDeniedFault$message' => NULL, 'KMSDisabledFault$message' => NULL, 'KMSFault$message' => NULL, 'KMSInvalidStateFault$message' => NULL, 'KMSKeyNotAccessibleFault$message' => '<p/>', 'KMSNotFoundFault$message' => NULL, 'KMSThrottlingFault$message' => NULL, 'ReplicationSubnetGroupDoesNotCoverEnoughAZs$message' => '<p/>', 'ResourceAlreadyExistsFault$message' => '<p/>', 'ResourceNotFoundFault$message' => '<p/>', 'ResourceQuotaExceededFault$message' => '<p/>', 'S3AccessDeniedFault$message' => NULL, 'S3ResourceNotFoundFault$message' => NULL, 'SNSInvalidTopicFault$message' => '<p/>', 'SNSNoAuthorizationFault$message' => '<p/>', 'StorageQuotaExceededFault$message' => '<p/>', 'SubnetAlreadyInUse$message' => '<p/>', 'UpgradeDependencyFailureFault$message' => '<p/>', ], ], 'ExcludeTestList' => [ 'base' => NULL, 'refs' => [ 'StartReplicationTaskAssessmentRunMessage$Exclude' => '<p>Space-separated list of names for specific individual assessments that you want to exclude. These names come from the default list of individual assessments that DMS supports for the associated migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note> <p>You can\'t set a value for <code>Exclude</code> if you also set a value for <code>IncludeOnly</code> in the API operation.</p> <p>To identify the names of the default individual assessments that DMS supports for the associated migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own <code>ReplicationTaskArn</code> request parameter.</p> </note>', ], ], 'Filter' => [ 'base' => '<p>Identifies the name and value of a filter object. This filter is used to limit the number and type of DMS objects that are returned for a particular <code>Describe*</code> call or similar operation. Filters are used as an optional parameter for certain API operations. </p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeCertificatesMessage$Filters' => '<p>Filters applied to the certificates described in the form of key-value pairs.</p>', 'DescribeConnectionsMessage$Filters' => '<p>The filters applied to the connection.</p> <p>Valid filter names: endpoint-arn | replication-instance-arn</p>', 'DescribeEndpointTypesMessage$Filters' => '<p>Filters applied to the endpoint types.</p> <p>Valid filter names: engine-name | endpoint-type</p>', 'DescribeEndpointsMessage$Filters' => '<p>Filters applied to the endpoints.</p> <p>Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name</p>', 'DescribeEventCategoriesMessage$Filters' => '<p>Filters applied to the event categories.</p>', 'DescribeEventSubscriptionsMessage$Filters' => '<p>Filters applied to event subscriptions.</p>', 'DescribeEventsMessage$Filters' => '<p>Filters applied to events.</p>', 'DescribePendingMaintenanceActionsMessage$Filters' => '<p/>', 'DescribeReplicationInstancesMessage$Filters' => '<p>Filters applied to replication instances.</p> <p>Valid filter names: replication-instance-arn | replication-instance-id | replication-instance-class | engine-version</p>', 'DescribeReplicationSubnetGroupsMessage$Filters' => '<p>Filters applied to replication subnet groups.</p> <p>Valid filter names: replication-subnet-group-id</p>', 'DescribeReplicationTaskAssessmentRunsMessage$Filters' => '<p>Filters applied to the premigration assessment runs described in the form of key-value pairs.</p> <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>, <code>replication-instance-arn</code>, <code>status</code> </p>', 'DescribeReplicationTaskIndividualAssessmentsMessage$Filters' => '<p>Filters applied to the individual assessments described in the form of key-value pairs.</p> <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>, <code>status</code> </p>', 'DescribeReplicationTasksMessage$Filters' => '<p>Filters applied to replication tasks.</p> <p>Valid filter names: replication-task-arn | replication-task-id | migration-type | endpoint-arn | replication-instance-arn</p>', 'DescribeTableStatisticsMessage$Filters' => '<p>Filters applied to table statistics.</p> <p>Valid filter names: schema-name | table-name | table-state</p> <p>A combination of filters creates an AND condition where each record matches all specified filters.</p>', ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>The filter value, which can specify one or more values used to narrow the returned results.</p>', ], ], 'IBMDb2Settings' => [ 'base' => '<p>Provides information that defines an IBM Db2 LUW endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$IBMDb2Settings' => '<p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$IBMDb2Settings' => '<p>The settings for the IBM Db2 LUW source endpoint. For more information, see the <code>IBMDb2Settings</code> structure. </p>', 'ModifyEndpointMessage$IBMDb2Settings' => '<p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'ImportCertificateMessage' => [ 'base' => NULL, 'refs' => [], ], 'ImportCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'IncludeTestList' => [ 'base' => NULL, 'refs' => [ 'StartReplicationTaskAssessmentRunMessage$IncludeOnly' => '<p>Space-separated list of names for specific individual assessments that you want to include. These names come from the default list of individual assessments that DMS supports for the associated migration task. This task is specified by <code>ReplicationTaskArn</code>.</p> <note> <p>You can\'t set a value for <code>IncludeOnly</code> if you also set a value for <code>Exclude</code> in the API operation. </p> <p>To identify the names of the default individual assessments that DMS supports for the associated migration task, run the <code>DescribeApplicableIndividualAssessments</code> operation using its own <code>ReplicationTaskArn</code> request parameter.</p> </note>', ], ], 'IndividualAssessmentNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeApplicableIndividualAssessmentsResponse$IndividualAssessmentNames' => '<p>List of names for the individual assessments supported by the premigration assessment run that you start based on the specified request parameters. For more information on the available individual assessments, including compatibility with different migration task configurations, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Working with premigration assessment runs</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'InsufficientResourceCapacityFault' => [ 'base' => '<p>There are not enough resources allocated to the database migration.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'IntegerList$member' => NULL, 'OrderableReplicationInstance$MinAllocatedStorage' => '<p>The minimum amount of storage (in gigabytes) that can be allocated for the replication instance.</p>', 'OrderableReplicationInstance$MaxAllocatedStorage' => '<p>The minimum amount of storage (in gigabytes) that can be allocated for the replication instance.</p>', 'OrderableReplicationInstance$DefaultAllocatedStorage' => '<p>The default amount of storage (in gigabytes) that is allocated for the replication instance.</p>', 'OrderableReplicationInstance$IncludedAllocatedStorage' => '<p>The amount of storage (in gigabytes) that is allocated for the replication instance.</p>', 'RedisSettings$Port' => '<p>Transmission Control Protocol (TCP) port for the endpoint.</p>', 'ReplicationInstance$AllocatedStorage' => '<p>The amount of storage (in gigabytes) that is allocated for the replication instance.</p>', 'ReplicationTaskAssessmentRunProgress$IndividualAssessmentCount' => '<p>The number of individual assessments that are specified to run.</p>', 'ReplicationTaskAssessmentRunProgress$IndividualAssessmentCompletedCount' => '<p>The number of individual assessments that have completed, successfully or not.</p>', 'ReplicationTaskStats$FullLoadProgressPercent' => '<p>The percent complete for the full load migration task.</p>', 'ReplicationTaskStats$TablesLoaded' => '<p>The number of tables loaded for this task.</p>', 'ReplicationTaskStats$TablesLoading' => '<p>The number of tables currently loading for this task.</p>', 'ReplicationTaskStats$TablesQueued' => '<p>The number of tables queued for this task.</p>', 'ReplicationTaskStats$TablesErrored' => '<p>The number of errors that have occurred during this task.</p>', ], ], 'IntegerList' => [ 'base' => NULL, 'refs' => [ 'OracleSettings$ExtraArchivedLogDestIds' => '<p>Specifies the IDs of one more destinations for one or more archived redo logs. These IDs are the values of the <code>dest_id</code> column in the <code>v$archived_log</code> view. Use this setting with the <code>archivedLogDestId</code> extra connection attribute in a primary-to-single setup or a primary-to-multiple-standby setup. </p> <p>This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this case, DMS needs information about what destination to get archive redo logs from to read changes. DMS needs this because after the switchover the previous primary is a standby instance. For example, in a primary-to-single standby setup you might apply the following settings. </p> <p> <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code> </p> <p>In a primary-to-multiple-standby setup, you might apply the following settings.</p> <p> <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code> </p> <p>Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use <code>RESETLOGS</code> unless it\'s necessary. For more information about <code>RESETLOGS</code>, see <a href="https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"> RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User\'s Guide</i>.</p>', ], ], 'IntegerOptional' => [ 'base' => NULL, 'refs' => [ 'Certificate$KeyLength' => '<p>The key length of the cryptographic algorithm being used.</p>', 'CreateEndpointMessage$Port' => '<p>The port used by the endpoint database.</p>', 'CreateReplicationInstanceMessage$AllocatedStorage' => '<p>The amount of storage (in gigabytes) to be initially allocated for the replication instance.</p>', 'DescribeApplicableIndividualAssessmentsMessage$MaxRecords' => '<p>Maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>', 'DescribeCertificatesMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 10</p>', 'DescribeConnectionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEndpointSettingsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>', 'DescribeEndpointTypesMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEndpointsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEventSubscriptionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEventsMessage$Duration' => '<p>The duration of the events to be listed.</p>', 'DescribeEventsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeOrderableReplicationInstancesMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribePendingMaintenanceActionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeReplicationInstanceTaskLogsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeReplicationInstancesMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeReplicationSubnetGroupsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeReplicationTaskAssessmentResultsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeReplicationTaskAssessmentRunsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>', 'DescribeReplicationTaskIndividualAssessmentsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>', 'DescribeReplicationTasksMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeSchemasMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeTableStatisticsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 500.</p>', 'DocDbSettings$Port' => '<p> The port value for the DocumentDB source endpoint. </p>', 'DocDbSettings$DocsToInvestigate' => '<p> Indicates the number of documents to preview to determine the document organization. Use this setting when <code>NestingLevel</code> is set to <code>"one"</code>. </p> <p>Must be a positive value greater than <code>0</code>. Default value is <code>1000</code>.</p>', 'ElasticsearchSettings$FullLoadErrorPercentage' => '<p>The maximum percentage of records that can fail to be written before a full load operation stops.</p> <p>To avoid early failure, this counter is only effective after 1000 records are transferred. Elasticsearch also has the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all records fail in the last 10 minutes, the full load operation stops. </p>', 'ElasticsearchSettings$ErrorRetryDuration' => '<p>The maximum number of seconds for which DMS retries failed API requests to the Elasticsearch cluster.</p>', 'Endpoint$Port' => '<p>The port value used to access the endpoint.</p>', 'EndpointSetting$IntValueMin' => '<p>The minimum value of an endpoint setting that is of type <code>int</code>.</p>', 'EndpointSetting$IntValueMax' => '<p>The maximum value of an endpoint setting that is of type <code>int</code>.</p>', 'IBMDb2Settings$Port' => '<p>Endpoint TCP port. The default value is 50000.</p>', 'IBMDb2Settings$MaxKBytesPerRead' => '<p>Maximum number of bytes per read, as a NUMBER value. The default is 64 KB.</p>', 'KafkaSettings$MessageMaxBytes' => '<p>The maximum size in bytes for records created on the endpoint The default is 1,000,000.</p>', 'MicrosoftSQLServerSettings$Port' => '<p>Endpoint TCP port.</p>', 'MicrosoftSQLServerSettings$BcpPacketSize' => '<p>The maximum size of the packets (in bytes) used to transfer data using BCP.</p>', 'ModifyEndpointMessage$Port' => '<p>The port used by the endpoint database.</p>', 'ModifyReplicationInstanceMessage$AllocatedStorage' => '<p>The amount of storage (in gigabytes) to be allocated for the replication instance.</p>', 'MongoDbSettings$Port' => '<p> The port value for the MongoDB source endpoint. </p>', 'MySQLSettings$EventsPollInterval' => '<p>Specifies how often to check the binary log for new changes/events when the database is idle.</p> <p>Example: <code>eventsPollInterval=5;</code> </p> <p>In the example, DMS checks for changes in the binary logs every five seconds.</p>', 'MySQLSettings$MaxFileSize' => '<p>Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.</p> <p>Example: <code>maxFileSize=512</code> </p>', 'MySQLSettings$ParallelLoadThreads' => '<p>Improves performance when loading data into the MySQL-compatible target database. Specifies how many threads to use to load the data into the MySQL-compatible target database. Setting a large number of threads can have an adverse effect on database performance, because a separate connection is required for each thread.</p> <p>Example: <code>parallelLoadThreads=1</code> </p>', 'MySQLSettings$Port' => '<p>Endpoint TCP port.</p>', 'NeptuneSettings$ErrorRetryDuration' => '<p>The number of milliseconds for DMS to wait to retry a bulk-load of migrated graph data to the Neptune target database before raising an error. The default is 250.</p>', 'NeptuneSettings$MaxFileSize' => '<p>The maximum size in kilobytes of migrated graph data stored in a .csv file before DMS bulk-loads the data to the Neptune target database. The default is 1,048,576 KB. If the bulk load is successful, DMS clears the bucket, ready to store the next batch of migrated graph data.</p>', 'NeptuneSettings$MaxRetryCount' => '<p>The number of times for DMS to retry a bulk load of migrated graph data to the Neptune target database before raising an error. The default is 5.</p>', 'OracleSettings$ArchivedLogDestId' => '<p>Specifies the ID of the destination for the archived redo logs. This value should be the same as a number in the dest_id column of the v$archived_log view. If you work with an additional redo log destination, use the <code>AdditionalArchivedLogDestId</code> option to specify the additional destination ID. Doing this improves performance by ensuring that the correct logs are accessed from the outset.</p>', 'OracleSettings$AdditionalArchivedLogDestId' => '<p>Set this attribute with <code>ArchivedLogDestId</code> in a primary/ standby setup. This attribute is useful in the case of a switchover. In this case, DMS needs to know which destination to get archive redo logs from to read changes. This need arises because the previous primary instance is now a standby instance after switchover.</p> <p>Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use <code>RESETLOGS</code> unless necessary. For additional information about <code>RESETLOGS</code>, see <a href="https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B">RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User\'s Guide</i>.</p>', 'OracleSettings$ParallelAsmReadThreads' => '<p>Set this attribute to change the number of threads that DMS configures to perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value between 2 (the default) and 8 (the maximum). Use this attribute together with the <code>readAheadBlocks</code> attribute.</p>', 'OracleSettings$ReadAheadBlocks' => '<p>Set this attribute to change the number of read-ahead blocks that DMS configures to perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value between 1000 (the default) and 200,000 (the maximum).</p>', 'OracleSettings$NumberDatatypeScale' => '<p>Specifies the number scale. You can select a scale up to 38, or you can select FLOAT. By default, the NUMBER data type is converted to precision 38, scale 10.</p> <p>Example: <code>numberDataTypeScale=12</code> </p>', 'OracleSettings$Port' => '<p>Endpoint TCP port.</p>', 'OracleSettings$RetryInterval' => '<p>Specifies the number of seconds that the system waits before resending a query.</p> <p>Example: <code>retryInterval=6;</code> </p>', 'OracleSettings$StandbyDelayTime' => '<p>Use this attribute to specify a time in minutes for the delay in standby sync. If the source is an Oracle Active Data Guard standby database, use this attribute to specify the time lag between primary and standby databases.</p> <p>In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby instance as a source for replicating ongoing changes. Doing this eliminates the need to connect to an active database that might be in production.</p>', 'PostgreSQLSettings$MaxFileSize' => '<p>Specifies the maximum size (in KB) of any .csv file used to transfer data to PostgreSQL.</p> <p>Example: <code>maxFileSize=512</code> </p>', 'PostgreSQLSettings$ExecuteTimeout' => '<p>Sets the client statement timeout for the PostgreSQL instance, in seconds. The default value is 60 seconds.</p> <p>Example: <code>executeTimeout=100;</code> </p>', 'PostgreSQLSettings$HeartbeatFrequency' => '<p>Sets the WAL heartbeat frequency (in minutes).</p>', 'PostgreSQLSettings$Port' => '<p>Endpoint TCP port.</p>', 'RedshiftSettings$ConnectionTimeout' => '<p>A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you initially establish a connection.</p>', 'RedshiftSettings$FileTransferUploadStreams' => '<p>The number of threads used to upload a single file. This parameter accepts a value from 1 through 64. It defaults to 10.</p> <p>The number of parallel streams used to upload a single .csv file to an S3 bucket using S3 Multipart Upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload overview</a>. </p> <p> <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It defaults to 10.</p>', 'RedshiftSettings$LoadTimeout' => '<p>The amount of time to wait (in milliseconds) before timing out of operations performed by DMS on a Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.</p>', 'RedshiftSettings$MaxFileSize' => '<p>The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer data to Amazon Redshift. It defaults to 1048576KB (1 GB).</p>', 'RedshiftSettings$Port' => '<p>The port number for Amazon Redshift. The default value is 5439.</p>', 'RedshiftSettings$WriteBufferSize' => '<p>The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk at the DMS replication instance. The default value is 1000 (buffer size is 1000KB).</p>', 'ReplicationPendingModifiedValues$AllocatedStorage' => '<p>The amount of storage (in gigabytes) that is allocated for the replication instance.</p>', 'S3Settings$DictPageSizeLimit' => '<p>The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this column is stored using an encoding type of <code>PLAIN</code>. This parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding. This size is used for .parquet file format only. </p>', 'S3Settings$RowGroupLength' => '<p>The number of rows in a row group. A smaller row group size provides faster reads. But as the number of row groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used for .parquet file format only. </p> <p>If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group length in bytes (64 * 1024 * 1024). </p>', 'S3Settings$DataPageSize' => '<p>The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is used for .parquet file format only. </p>', 'S3Settings$CdcMaxBatchInterval' => '<p>Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.</p> <p>When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the file write is triggered by whichever parameter condition is met first within an DMS CloudFormation template.</p> <p>The default value is 60 seconds.</p>', 'S3Settings$CdcMinFileSize' => '<p>Minimum file size, defined in megabytes, to reach for a file output to Amazon S3.</p> <p>When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file write is triggered by whichever parameter condition is met first within an DMS CloudFormation template.</p> <p>The default value is 32 MB.</p>', 'S3Settings$IgnoreHeaderRows' => '<p>When this value is set to 1, DMS ignores the first row header in a .csv file. A value of 1 turns on the feature; a value of 0 turns off the feature.</p> <p>The default is 0.</p>', 'S3Settings$MaxFileSize' => '<p>A value that specifies the maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load.</p> <p>The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.</p>', 'SybaseSettings$Port' => '<p>Endpoint TCP port.</p>', ], ], 'InvalidCertificateFault' => [ 'base' => '<p>The certificate was not valid.</p>', 'refs' => [], ], 'InvalidResourceStateFault' => [ 'base' => '<p>The resource is in a state that prevents it from being used for database migration.</p>', 'refs' => [], ], 'InvalidSubnet' => [ 'base' => '<p>The subnet provided is invalid.</p>', 'refs' => [], ], 'KMSAccessDeniedFault' => [ 'base' => '<p>The ciphertext references a key that doesn\'t exist or that the DMS account doesn\'t have access to.</p>', 'refs' => [], ], 'KMSDisabledFault' => [ 'base' => '<p>The specified master key (CMK) isn\'t enabled.</p>', 'refs' => [], ], 'KMSFault' => [ 'base' => '<p>An Key Management Service (KMS) error is preventing access to KMS.</p>', 'refs' => [], ], 'KMSInvalidStateFault' => [ 'base' => '<p>The state of the specified KMS resource isn\'t valid for this request.</p>', 'refs' => [], ], 'KMSKeyNotAccessibleFault' => [ 'base' => '<p>DMS cannot access the KMS key.</p>', 'refs' => [], ], 'KMSNotFoundFault' => [ 'base' => '<p>The specified KMS entity or resource can\'t be found.</p>', 'refs' => [], ], 'KMSThrottlingFault' => [ 'base' => '<p>This request triggered KMS request throttling.</p>', 'refs' => [], ], 'KafkaSecurityProtocol' => [ 'base' => NULL, 'refs' => [ 'KafkaSettings$SecurityProtocol' => '<p>Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include <code>ssl-encryption</code>, <code>ssl-authentication</code>, and <code>sasl-ssl</code>. <code>sasl-ssl</code> requires <code>SaslUsername</code> and <code>SaslPassword</code>.</p>', ], ], 'KafkaSettings' => [ 'base' => '<p>Provides information that describes an Apache Kafka endpoint. This information includes the output format of records applied to the endpoint and details of transaction and control table data information.</p>', 'refs' => [ 'CreateEndpointMessage$KafkaSettings' => '<p>Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$KafkaSettings' => '<p>The settings for the Apache Kafka target endpoint. For more information, see the <code>KafkaSettings</code> structure.</p>', 'ModifyEndpointMessage$KafkaSettings' => '<p>Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceMessage$TagKeys' => '<p>The tag key (name) of the tag to be removed.</p>', ], ], 'KinesisSettings' => [ 'base' => '<p>Provides information that describes an Amazon Kinesis Data Stream endpoint. This information includes the output format of records applied to the endpoint and details of transaction and control table data information.</p>', 'refs' => [ 'CreateEndpointMessage$KinesisSettings' => '<p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$KinesisSettings' => '<p>The settings for the Amazon Kinesis target endpoint. For more information, see the <code>KinesisSettings</code> structure.</p>', 'ModifyEndpointMessage$KinesisSettings' => '<p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'ListTagsForResourceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AccountQuota$Used' => '<p>The amount currently used toward the quota maximum.</p>', 'AccountQuota$Max' => '<p>The maximum allowed value for the quota.</p>', 'ReplicationInstanceTaskLog$ReplicationInstanceTaskLogSize' => '<p>The size, in bytes, of the replication task log.</p>', 'ReplicationTaskStats$ElapsedTimeMillis' => '<p>The elapsed time of the task, in milliseconds.</p>', 'TableStatistics$Inserts' => '<p>The number of insert actions performed on a table.</p>', 'TableStatistics$Deletes' => '<p>The number of delete actions performed on a table.</p>', 'TableStatistics$Updates' => '<p>The number of update actions performed on a table.</p>', 'TableStatistics$Ddls' => '<p>The data definition language (DDL) used to build and modify the structure of your tables.</p>', 'TableStatistics$FullLoadRows' => '<p>The number of rows added during the full load operation.</p>', 'TableStatistics$FullLoadCondtnlChkFailedRows' => '<p>The number of rows that failed conditional checks during the full load operation (valid only for migrations where DynamoDB is the target).</p>', 'TableStatistics$FullLoadErrorRows' => '<p>The number of rows that failed to load during the full load operation (valid only for migrations where DynamoDB is the target).</p>', 'TableStatistics$ValidationPendingRecords' => '<p>The number of records that have yet to be validated.</p>', 'TableStatistics$ValidationFailedRecords' => '<p>The number of records that failed validation.</p>', 'TableStatistics$ValidationSuspendedRecords' => '<p>The number of records that couldn\'t be validated.</p>', ], ], 'MessageFormatValue' => [ 'base' => NULL, 'refs' => [ 'KafkaSettings$MessageFormat' => '<p>The output format for the records created on the endpoint. The message format is <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).</p>', 'KinesisSettings$MessageFormat' => '<p>The output format for the records created on the endpoint. The message format is <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).</p>', ], ], 'MicrosoftSQLServerSettings' => [ 'base' => '<p>Provides information that defines a Microsoft SQL Server endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$MicrosoftSQLServerSettings' => '<p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib"> Extra connection attributes when using SQL Server as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$MicrosoftSQLServerSettings' => '<p>The settings for the Microsoft SQL Server source and target endpoint. For more information, see the <code>MicrosoftSQLServerSettings</code> structure.</p>', 'ModifyEndpointMessage$MicrosoftSQLServerSettings' => '<p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib"> Extra connection attributes when using SQL Server as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'MigrationTypeValue' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationTaskMessage$MigrationType' => '<p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code> </p>', 'DescribeApplicableIndividualAssessmentsMessage$MigrationType' => '<p>Name of the migration type that each provided individual assessment must support.</p>', 'ModifyReplicationTaskMessage$MigrationType' => '<p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code> </p>', 'ReplicationTask$MigrationType' => '<p>The type of migration.</p>', ], ], 'ModifyEndpointMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyEndpointResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyEventSubscriptionResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyReplicationInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyReplicationInstanceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyReplicationSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyReplicationSubnetGroupResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyReplicationTaskMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyReplicationTaskResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'MongoDbSettings' => [ 'base' => '<p>Provides information that defines a MongoDB endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$MongoDbSettings' => '<p>Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings when using MongoDB as a source for Database Migration Service</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$MongoDbSettings' => '<p>The settings for the MongoDB source endpoint. For more information, see the <code>MongoDbSettings</code> structure.</p>', 'ModifyEndpointMessage$MongoDbSettings' => '<p>Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings when using MongoDB as a source for Database Migration Service</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'MoveReplicationTaskMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'MoveReplicationTaskResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'MySQLSettings' => [ 'base' => '<p>Provides information that defines a MySQL endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$MySQLSettings' => '<p>Settings in JSON format for the source and target MySQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$MySQLSettings' => '<p>The settings for the MySQL source and target endpoint. For more information, see the <code>MySQLSettings</code> structure.</p>', 'ModifyEndpointMessage$MySQLSettings' => '<p>Settings in JSON format for the source and target MySQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'NeptuneSettings' => [ 'base' => '<p>Provides information that defines an Amazon Neptune endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$NeptuneSettings' => '<p>Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$NeptuneSettings' => '<p>The settings for the Amazon Neptune target endpoint. For more information, see the <code>NeptuneSettings</code> structure.</p>', 'ModifyEndpointMessage$NeptuneSettings' => '<p>Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'NestingLevelValue' => [ 'base' => NULL, 'refs' => [ 'DocDbSettings$NestingLevel' => '<p> Specifies either document or table mode. </p> <p>Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode. Specify <code>"one"</code> to use table mode.</p>', 'MongoDbSettings$NestingLevel' => '<p> Specifies either document or table mode. </p> <p>Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode. Specify <code>"one"</code> to use table mode.</p>', ], ], 'OracleSettings' => [ 'base' => '<p>Provides information that defines an Oracle endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$OracleSettings' => '<p>Settings in JSON format for the source and target Oracle endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib"> Extra connection attributes when using Oracle as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$OracleSettings' => '<p>The settings for the Oracle source and target endpoint. For more information, see the <code>OracleSettings</code> structure.</p>', 'ModifyEndpointMessage$OracleSettings' => '<p>Settings in JSON format for the source and target Oracle endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib"> Extra connection attributes when using Oracle as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'OrderableReplicationInstance' => [ 'base' => '<p>In response to the <code>DescribeOrderableReplicationInstances</code> operation, this object describes an available replication instance. This description includes the replication instance\'s type, engine version, and allocated storage.</p>', 'refs' => [ 'OrderableReplicationInstanceList$member' => NULL, ], ], 'OrderableReplicationInstanceList' => [ 'base' => NULL, 'refs' => [ 'DescribeOrderableReplicationInstancesResponse$OrderableReplicationInstances' => '<p>The order-able replication instances available.</p>', ], ], 'ParquetVersionValue' => [ 'base' => NULL, 'refs' => [ 'S3Settings$ParquetVersion' => '<p>The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or <code>parquet_2_0</code>.</p>', ], ], 'PendingMaintenanceAction' => [ 'base' => '<p>Describes a maintenance action pending for an DMS resource, including when and how it will be applied. This data type is a response element to the <code>DescribePendingMaintenanceActions</code> operation.</p>', 'refs' => [ 'PendingMaintenanceActionDetails$member' => NULL, ], ], 'PendingMaintenanceActionDetails' => [ 'base' => NULL, 'refs' => [ 'ResourcePendingMaintenanceActions$PendingMaintenanceActionDetails' => '<p>Detailed information about the pending maintenance action.</p>', ], ], 'PendingMaintenanceActions' => [ 'base' => NULL, 'refs' => [ 'DescribePendingMaintenanceActionsResponse$PendingMaintenanceActions' => '<p>The pending maintenance action.</p>', ], ], 'PluginNameValue' => [ 'base' => NULL, 'refs' => [ 'PostgreSQLSettings$PluginName' => '<p>Specifies the plugin to use to create a replication slot.</p>', ], ], 'PostgreSQLSettings' => [ 'base' => '<p>Provides information that defines a PostgreSQL endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$PostgreSQLSettings' => '<p>Settings in JSON format for the source and target PostgreSQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib"> Extra connection attributes when using PostgreSQL as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$PostgreSQLSettings' => '<p>The settings for the PostgreSQL source and target endpoint. For more information, see the <code>PostgreSQLSettings</code> structure.</p>', 'ModifyEndpointMessage$PostgreSQLSettings' => '<p>Settings in JSON format for the source and target PostgreSQL endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib"> Extra connection attributes when using PostgreSQL as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'RebootReplicationInstanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'RebootReplicationInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'RedisAuthTypeValue' => [ 'base' => NULL, 'refs' => [ 'RedisSettings$AuthType' => '<p>The type of authentication to perform when connecting to a Redis target. Options include <code>none</code>, <code>auth-token</code>, and <code>auth-role</code>. The <code>auth-token</code> option requires an <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option requires <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.</p>', ], ], 'RedisSettings' => [ 'base' => '<p>Provides information that defines a Redis target endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$RedisSettings' => '<p>Settings in JSON format for the target Redis endpoint.</p>', 'Endpoint$RedisSettings' => '<p>The settings for the Redis target endpoint. For more information, see the <code>RedisSettings</code> structure.</p>', 'ModifyEndpointMessage$RedisSettings' => '<p>Settings in JSON format for the Redis target endpoint.</p>', ], ], 'RedshiftSettings' => [ 'base' => '<p>Provides information that defines an Amazon Redshift endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$RedshiftSettings' => NULL, 'Endpoint$RedshiftSettings' => '<p>Settings for the Amazon Redshift endpoint.</p>', 'ModifyEndpointMessage$RedshiftSettings' => NULL, ], ], 'RefreshSchemasMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RefreshSchemasResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'RefreshSchemasStatus' => [ 'base' => '<p>Provides information that describes status of a schema at an endpoint specified by the <code>DescribeRefreshSchemaStatus</code> operation.</p>', 'refs' => [ 'DescribeRefreshSchemasStatusResponse$RefreshSchemasStatus' => '<p>The status of the schema.</p>', 'RefreshSchemasResponse$RefreshSchemasStatus' => '<p>The status of the refreshed schema.</p>', ], ], 'RefreshSchemasStatusTypeValue' => [ 'base' => NULL, 'refs' => [ 'RefreshSchemasStatus$Status' => '<p>The status of the schema.</p>', ], ], 'ReleaseStatusValues' => [ 'base' => NULL, 'refs' => [ 'OrderableReplicationInstance$ReleaseStatus' => '<p>The value returned when the specified <code>EngineVersion</code> of the replication instance is in Beta or test mode. This indicates some features might not work as expected.</p> <note> <p>DMS supports the <code>ReleaseStatus</code> parameter in versions 3.1.4 and later.</p> </note>', ], ], 'ReloadOptionValue' => [ 'base' => NULL, 'refs' => [ 'ReloadTablesMessage$ReloadOption' => '<p>Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when validation is enabled for the task. </p> <p>Valid values: data-reload, validate-only</p> <p>Default value is data-reload.</p>', ], ], 'ReloadTablesMessage' => [ 'base' => NULL, 'refs' => [], ], 'ReloadTablesResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsFromResourceMessage' => [ 'base' => '<p>Removes one or more tags from an DMS resource.</p>', 'refs' => [], ], 'RemoveTagsFromResourceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ReplicationEndpointTypeValue' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointMessage$EndpointType' => '<p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>', 'Endpoint$EndpointType' => '<p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>', 'ModifyEndpointMessage$EndpointType' => '<p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>', 'SupportedEndpointType$EndpointType' => '<p>The type of endpoint. Valid values are <code>source</code> and <code>target</code>.</p>', ], ], 'ReplicationInstance' => [ 'base' => '<p>Provides information that defines a replication instance.</p>', 'refs' => [ 'CreateReplicationInstanceResponse$ReplicationInstance' => '<p>The replication instance that was created.</p>', 'DeleteReplicationInstanceResponse$ReplicationInstance' => '<p>The replication instance that was deleted.</p>', 'ModifyReplicationInstanceResponse$ReplicationInstance' => '<p>The modified replication instance.</p>', 'RebootReplicationInstanceResponse$ReplicationInstance' => '<p>The replication instance that is being rebooted. </p>', 'ReplicationInstanceList$member' => NULL, ], ], 'ReplicationInstanceList' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationInstancesResponse$ReplicationInstances' => '<p>The replication instances described.</p>', ], ], 'ReplicationInstancePrivateIpAddressList' => [ 'base' => NULL, 'refs' => [ 'ReplicationInstance$ReplicationInstancePrivateIpAddresses' => '<p>One or more private IP addresses for the replication instance.</p>', ], ], 'ReplicationInstancePublicIpAddressList' => [ 'base' => NULL, 'refs' => [ 'ReplicationInstance$ReplicationInstancePublicIpAddresses' => '<p>One or more public IP addresses for the replication instance.</p>', ], ], 'ReplicationInstanceTaskLog' => [ 'base' => '<p>Contains metadata for a replication instance task log.</p>', 'refs' => [ 'ReplicationInstanceTaskLogsList$member' => NULL, ], ], 'ReplicationInstanceTaskLogsList' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationInstanceTaskLogsResponse$ReplicationInstanceTaskLogs' => '<p>An array of replication task log metadata. Each member of the array contains the replication task name, ARN, and task log size (in bytes). </p>', ], ], 'ReplicationPendingModifiedValues' => [ 'base' => '<p>Provides information about the values of pending modifications to a replication instance. This data type is an object of the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ReplicationInstance.html"> <code>ReplicationInstance</code> </a> user-defined data type. </p>', 'refs' => [ 'ReplicationInstance$PendingModifiedValues' => '<p>The pending modification values.</p>', ], ], 'ReplicationSubnetGroup' => [ 'base' => '<p>Describes a subnet group in response to a request by the <code>DescribeReplicationSubnetGroups</code> operation.</p>', 'refs' => [ 'CreateReplicationSubnetGroupResponse$ReplicationSubnetGroup' => '<p>The replication subnet group that was created.</p>', 'ModifyReplicationSubnetGroupResponse$ReplicationSubnetGroup' => '<p>The modified replication subnet group.</p>', 'ReplicationInstance$ReplicationSubnetGroup' => '<p>The subnet group for the replication instance.</p>', 'ReplicationSubnetGroups$member' => NULL, ], ], 'ReplicationSubnetGroupDoesNotCoverEnoughAZs' => [ 'base' => '<p>The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</p>', 'refs' => [], ], 'ReplicationSubnetGroups' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationSubnetGroupsResponse$ReplicationSubnetGroups' => '<p>A description of the replication subnet groups.</p>', ], ], 'ReplicationTask' => [ 'base' => '<p>Provides information that describes a replication task created by the <code>CreateReplicationTask</code> operation.</p>', 'refs' => [ 'CreateReplicationTaskResponse$ReplicationTask' => '<p>The replication task that was created.</p>', 'DeleteReplicationTaskResponse$ReplicationTask' => '<p>The deleted replication task.</p>', 'ModifyReplicationTaskResponse$ReplicationTask' => '<p>The replication task that was modified.</p>', 'MoveReplicationTaskResponse$ReplicationTask' => '<p>The replication task that was moved.</p>', 'ReplicationTaskList$member' => NULL, 'StartReplicationTaskAssessmentResponse$ReplicationTask' => '<p> The assessed replication task. </p>', 'StartReplicationTaskResponse$ReplicationTask' => '<p>The replication task started.</p>', 'StopReplicationTaskResponse$ReplicationTask' => '<p>The replication task stopped.</p>', ], ], 'ReplicationTaskAssessmentResult' => [ 'base' => '<p> The task assessment report in JSON format. </p>', 'refs' => [ 'ReplicationTaskAssessmentResultList$member' => NULL, ], ], 'ReplicationTaskAssessmentResultList' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationTaskAssessmentResultsResponse$ReplicationTaskAssessmentResults' => '<p> The task assessment report. </p>', ], ], 'ReplicationTaskAssessmentRun' => [ 'base' => '<p>Provides information that describes a premigration assessment run that you have started using the <code>StartReplicationTaskAssessmentRun</code> operation.</p> <p>Some of the information appears based on other operations that can return the <code>ReplicationTaskAssessmentRun</code> object.</p>', 'refs' => [ 'CancelReplicationTaskAssessmentRunResponse$ReplicationTaskAssessmentRun' => '<p>The <code>ReplicationTaskAssessmentRun</code> object for the canceled assessment run.</p>', 'DeleteReplicationTaskAssessmentRunResponse$ReplicationTaskAssessmentRun' => '<p>The <code>ReplicationTaskAssessmentRun</code> object for the deleted assessment run.</p>', 'ReplicationTaskAssessmentRunList$member' => NULL, 'StartReplicationTaskAssessmentRunResponse$ReplicationTaskAssessmentRun' => '<p>The premigration assessment run that was started.</p>', ], ], 'ReplicationTaskAssessmentRunList' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationTaskAssessmentRunsResponse$ReplicationTaskAssessmentRuns' => '<p>One or more premigration assessment runs as specified by <code>Filters</code>.</p>', ], ], 'ReplicationTaskAssessmentRunProgress' => [ 'base' => '<p>The progress values reported by the <code>AssessmentProgress</code> response element.</p>', 'refs' => [ 'ReplicationTaskAssessmentRun$AssessmentProgress' => '<p>Indication of the completion progress for the individual assessments specified to run.</p>', ], ], 'ReplicationTaskIndividualAssessment' => [ 'base' => '<p>Provides information that describes an individual assessment from a premigration assessment run.</p>', 'refs' => [ 'ReplicationTaskIndividualAssessmentList$member' => NULL, ], ], 'ReplicationTaskIndividualAssessmentList' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationTaskIndividualAssessmentsResponse$ReplicationTaskIndividualAssessments' => '<p>One or more individual assessments as specified by <code>Filters</code>.</p>', ], ], 'ReplicationTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationTasksResponse$ReplicationTasks' => '<p>A description of the replication tasks.</p>', ], ], 'ReplicationTaskStats' => [ 'base' => '<p>In response to a request by the <code>DescribeReplicationTasks</code> operation, this object provides a collection of statistics about a replication task.</p>', 'refs' => [ 'ReplicationTask$ReplicationTaskStats' => '<p>The statistics for the task, including elapsed time, tables loaded, and table errors.</p>', ], ], 'ResourceAlreadyExistsFault' => [ 'base' => '<p>The resource you are attempting to create already exists.</p>', 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ResourceAlreadyExistsFault$resourceArn' => NULL, ], ], 'ResourceNotFoundFault' => [ 'base' => '<p>The resource could not be found.</p>', 'refs' => [], ], 'ResourcePendingMaintenanceActions' => [ 'base' => '<p>Identifies an DMS resource and any pending actions for it.</p>', 'refs' => [ 'ApplyPendingMaintenanceActionResponse$ResourcePendingMaintenanceActions' => '<p>The DMS resource that the pending maintenance action will be applied to.</p>', 'PendingMaintenanceActions$member' => NULL, ], ], 'ResourceQuotaExceededFault' => [ 'base' => '<p>The quota for this resource quota has been exceeded.</p>', 'refs' => [], ], 'S3AccessDeniedFault' => [ 'base' => '<p>Insufficient privileges are preventing access to an Amazon S3 object.</p>', 'refs' => [], ], 'S3ResourceNotFoundFault' => [ 'base' => '<p>A specified Amazon S3 bucket, bucket folder, or other object can\'t be found.</p>', 'refs' => [], ], 'S3Settings' => [ 'base' => '<p>Settings for exporting data to Amazon S3. </p>', 'refs' => [ 'CreateEndpointMessage$S3Settings' => '<p>Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$S3Settings' => '<p>The settings for the S3 target endpoint. For more information, see the <code>S3Settings</code> structure.</p>', 'ModifyEndpointMessage$S3Settings' => '<p>Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'SNSInvalidTopicFault' => [ 'base' => '<p>The SNS topic is invalid.</p>', 'refs' => [], ], 'SNSNoAuthorizationFault' => [ 'base' => '<p>You are not authorized for the SNS subscription.</p>', 'refs' => [], ], 'SafeguardPolicy' => [ 'base' => NULL, 'refs' => [ 'MicrosoftSQLServerSettings$SafeguardPolicy' => '<p>Use this attribute to minimize the need to access the backup log and enable DMS to prevent truncation using one of the following two methods.</p> <p> <i>Start transactions in the database:</i> This is the default method. When this method is used, DMS prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open, changes that appear after the transaction started aren\'t truncated. If you need Microsoft Replication to be enabled in your database, then you must choose this method.</p> <p> <i>Exclusively use sp_repldone within a single task</i>: When this method is used, DMS reads the changes and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn\'t involve any transactional activities, it can only be used when Microsoft Replication isn\'t running. Also, when using this method, only one DMS task can access the database at any given time. Therefore, if you need to run parallel DMS tasks against the same database, use the default method.</p>', ], ], 'SchemaList' => [ 'base' => NULL, 'refs' => [ 'DescribeSchemasResponse$Schemas' => '<p>The described schema.</p>', ], ], 'SecretString' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointMessage$Password' => '<p>The password to be used to log in to the endpoint database.</p>', 'DocDbSettings$Password' => '<p> The password for the user account you use to access the DocumentDB source endpoint. </p>', 'IBMDb2Settings$Password' => '<p>Endpoint connection password.</p>', 'ImportCertificateMessage$CertificatePem' => '<p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>', 'KafkaSettings$SslClientKeyPassword' => '<p> The password for the client private key used to securely connect to a Kafka target endpoint.</p>', 'KafkaSettings$SaslPassword' => '<p>The secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.</p>', 'MicrosoftSQLServerSettings$Password' => '<p>Endpoint connection password.</p>', 'ModifyEndpointMessage$Password' => '<p>The password to be used to login to the endpoint database.</p>', 'MongoDbSettings$Password' => '<p> The password for the user account you use to access the MongoDB source endpoint. </p>', 'MySQLSettings$Password' => '<p>Endpoint connection password.</p>', 'OracleSettings$AsmPassword' => '<p>For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password. You can set this value from the <code> <i>asm_user_password</i> </code> value. You set this value as part of the comma-separated value that you set to the <code>Password</code> request parameter when you create the endpoint to access transaction logs using Binary Reader. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a>.</p>', 'OracleSettings$Password' => '<p>Endpoint connection password.</p>', 'OracleSettings$SecurityDbEncryption' => '<p>For an Oracle source endpoint, the transparent data encryption (TDE) password required by AWM DMS to access Oracle redo logs encrypted by TDE using Binary Reader. It is also the <code> <i>TDE_Password</i> </code> part of the comma-separated value you set to the <code>Password</code> request parameter when you create the endpoint. The <code>SecurityDbEncryptian</code> setting is related to this <code>SecurityDbEncryptionName</code> setting. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"> Supported encryption methods for using Oracle as a source for DMS </a> in the <i>Database Migration Service User Guide</i>. </p>', 'PostgreSQLSettings$Password' => '<p>Endpoint connection password.</p>', 'RedisSettings$AuthPassword' => '<p>The password provided with the <code>auth-role</code> and <code>auth-token</code> options of the <code>AuthType</code> setting for a Redis target endpoint.</p>', 'RedshiftSettings$Password' => '<p>The password for the user named in the <code>username</code> property.</p>', 'SybaseSettings$Password' => '<p>Endpoint connection password.</p>', ], ], 'SourceIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$SourceIds' => '<p>A list of identifiers for which DMS provides notification events.</p> <p>If you don\'t specify a value, notifications are provided for all sources.</p> <p>If you specify multiple values, they must be of the same type. For example, if you specify a database instance ID, then all of the other values must be database instance IDs.</p>', 'EventSubscription$SourceIdsList' => '<p>A list of source Ids for the event subscription.</p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsMessage$SourceType' => '<p>The type of DMS resource that generates events.</p> <p>Valid values: replication-instance | replication-task</p>', 'Event$SourceType' => '<p> The type of DMS resource that generates events. </p> <p>Valid values: replication-instance | endpoint | replication-task</p>', ], ], 'SslSecurityProtocolValue' => [ 'base' => NULL, 'refs' => [ 'RedisSettings$SslSecurityProtocol' => '<p>The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid values include <code>plaintext</code> and <code>ssl-encryption</code>. The default is <code>ssl-encryption</code>. The <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon Resource Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn </code>setting. If an ARN isn\'t given for a CA, DMS uses the Amazon root CA.</p> <p>The <code>plaintext</code> option doesn\'t provide Transport Layer Security (TLS) encryption for traffic between endpoint and database.</p>', ], ], 'StartReplicationTaskAssessmentMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'StartReplicationTaskAssessmentResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'StartReplicationTaskAssessmentRunMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'StartReplicationTaskAssessmentRunResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'StartReplicationTaskMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'StartReplicationTaskResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'StartReplicationTaskTypeValue' => [ 'base' => NULL, 'refs' => [ 'StartReplicationTaskMessage$StartReplicationTaskType' => '<p>A type of replication task.</p>', ], ], 'StopReplicationTaskMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'StopReplicationTaskResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'StorageQuotaExceededFault' => [ 'base' => '<p>The storage quota has been exceeded.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccountQuota$AccountQuotaName' => '<p>The name of the DMS quota for this Amazon Web Services account.</p>', 'AddTagsToResourceMessage$ResourceArn' => '<p>Identifies the DMS resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN).</p> <p>For DMS, you can tag a replication instance, an endpoint, or a replication task.</p>', 'ApplyPendingMaintenanceActionMessage$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action applies to.</p>', 'ApplyPendingMaintenanceActionMessage$ApplyAction' => '<p>The pending maintenance action to apply to this resource.</p>', 'ApplyPendingMaintenanceActionMessage$OptInType' => '<p>A value that specifies the type of opt-in request, or undoes an opt-in request. You can\'t undo an opt-in request of type <code>immediate</code>.</p> <p>Valid values:</p> <ul> <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li> <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li> <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li> </ul>', 'ArnList$member' => NULL, 'AvailabilityZone$Name' => '<p>The name of the Availability Zone.</p>', 'AvailabilityZonesList$member' => NULL, 'CancelReplicationTaskAssessmentRunMessage$ReplicationTaskAssessmentRunArn' => '<p>Amazon Resource Name (ARN) of the premigration assessment run to be canceled.</p>', 'Certificate$CertificateIdentifier' => '<p>A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can\'t end with a hyphen or contain two consecutive hyphens.</p>', 'Certificate$CertificatePem' => '<p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>', 'Certificate$CertificateArn' => '<p>The Amazon Resource Name (ARN) for the certificate.</p>', 'Certificate$CertificateOwner' => '<p>The owner of the certificate.</p>', 'Certificate$SigningAlgorithm' => '<p>The signing algorithm for the certificate.</p>', 'Connection$ReplicationInstanceArn' => '<p>The ARN of the replication instance.</p>', 'Connection$EndpointArn' => '<p>The ARN string that uniquely identifies the endpoint.</p>', 'Connection$Status' => '<p>The connection status. This parameter can return one of the following values:</p> <ul> <li> <p> <code>"successful"</code> </p> </li> <li> <p> <code>"testing"</code> </p> </li> <li> <p> <code>"failed"</code> </p> </li> <li> <p> <code>"deleting"</code> </p> </li> </ul>', 'Connection$LastFailureMessage' => '<p>The error message when the connection last failed.</p>', 'Connection$EndpointIdentifier' => '<p>The identifier of the endpoint. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can\'t end with a hyphen or contain two consecutive hyphens.</p>', 'Connection$ReplicationInstanceIdentifier' => '<p>The replication instance identifier. This parameter is stored as a lowercase string.</p>', 'CreateEndpointMessage$EndpointIdentifier' => '<p>The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can\'t end with a hyphen, or contain two consecutive hyphens.</p>', 'CreateEndpointMessage$EngineName' => '<p>The type of engine for the endpoint. Valid values, depending on the <code>EndpointType</code> value, include <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"docdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>', 'CreateEndpointMessage$Username' => '<p>The user name to be used to log in to the endpoint database.</p>', 'CreateEndpointMessage$ServerName' => '<p>The name of the server where the endpoint database resides.</p>', 'CreateEndpointMessage$DatabaseName' => '<p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>', 'CreateEndpointMessage$ExtraConnectionAttributes' => '<p>Additional attributes associated with the connection. Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with DMS Endpoints</a> in the <i>Database Migration Service User Guide.</i> </p>', 'CreateEndpointMessage$KmsKeyId' => '<p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p> <p>If you don\'t specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.</p> <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>', 'CreateEndpointMessage$CertificateArn' => '<p>The Amazon Resource Name (ARN) for the certificate.</p>', 'CreateEndpointMessage$ServiceAccessRoleArn' => '<p> The Amazon Resource Name (ARN) for the service access role that you want to use to create the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>', 'CreateEndpointMessage$ExternalTableDefinition' => '<p>The external table definition. </p>', 'CreateEndpointMessage$ResourceIdentifier' => '<p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen (\'-\'). Also, it can\'t end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don\'t specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>', 'CreateEventSubscriptionMessage$SubscriptionName' => '<p>The name of the DMS event notification subscription. This name must be less than 255 characters.</p>', 'CreateEventSubscriptionMessage$SnsTopicArn' => '<p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>', 'CreateEventSubscriptionMessage$SourceType' => '<p> The type of DMS resource that generates the events. For example, if you want to be notified of events generated by a replication instance, you set this parameter to <code>replication-instance</code>. If this value isn\'t specified, all events are returned. </p> <p>Valid values: <code>replication-instance</code> | <code>replication-task</code> </p>', 'CreateReplicationInstanceMessage$ReplicationInstanceIdentifier' => '<p>The replication instance identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1-63 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>myrepinstance</code> </p>', 'CreateReplicationInstanceMessage$ReplicationInstanceClass' => '<p>The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p> <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>', 'CreateReplicationInstanceMessage$AvailabilityZone' => '<p>The Availability Zone where the replication instance will be created. The default value is a random, system-chosen Availability Zone in the endpoint\'s Amazon Web Services Region, for example: <code>us-east-1d</code> </p>', 'CreateReplicationInstanceMessage$ReplicationSubnetGroupIdentifier' => '<p>A subnet group to associate with the replication instance.</p>', 'CreateReplicationInstanceMessage$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>Default: A 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region, occurring on a random day of the week.</p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p> <p>Constraints: Minimum 30-minute window.</p>', 'CreateReplicationInstanceMessage$EngineVersion' => '<p>The engine version number of the replication instance.</p> <p>If an engine version number is not specified when a replication instance is created, the default is the latest engine version available.</p>', 'CreateReplicationInstanceMessage$KmsKeyId' => '<p>An KMS key identifier that is used to encrypt the data on the replication instance.</p> <p>If you don\'t specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.</p> <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>', 'CreateReplicationInstanceMessage$DnsNameServers' => '<p>A list of custom DNS name servers supported for the replication instance to access your on-premise source or target database. This list overrides the default name servers supported by the replication instance. You can specify a comma-separated list of internet addresses for up to four on-premise DNS name servers. For example: <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code> </p>', 'CreateReplicationInstanceMessage$ResourceIdentifier' => '<p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen (\'-\'). Also, it can\'t end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don\'t specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>', 'CreateReplicationSubnetGroupMessage$ReplicationSubnetGroupIdentifier' => '<p>The name for the replication subnet group. This value is stored as a lowercase string.</p> <p>Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens. Must not be "default".</p> <p>Example: <code>mySubnetgroup</code> </p>', 'CreateReplicationSubnetGroupMessage$ReplicationSubnetGroupDescription' => '<p>The description for the subnet group.</p>', 'CreateReplicationTaskMessage$ReplicationTaskIdentifier' => '<p>An identifier for the replication task.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1-255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'CreateReplicationTaskMessage$SourceEndpointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.</p>', 'CreateReplicationTaskMessage$TargetEndpointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.</p>', 'CreateReplicationTaskMessage$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of a replication instance.</p>', 'CreateReplicationTaskMessage$TableMappings' => '<p>The table mappings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table Mapping to Specify Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>', 'CreateReplicationTaskMessage$ReplicationTaskSettings' => '<p>Overall settings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User Guide.</i> </p>', 'CreateReplicationTaskMessage$CdcStartPosition' => '<p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p> <p> The value can be in date, checkpoint, or LSN/SCN format.</p> <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p> <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p> <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note> <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p> </note>', 'CreateReplicationTaskMessage$CdcStopPosition' => '<p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p> <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p> <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>', 'CreateReplicationTaskMessage$TaskData' => '<p>Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>', 'CreateReplicationTaskMessage$ResourceIdentifier' => '<p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen (\'-\'). Also, it can\'t end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don\'t specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of <code>EndpointArn</code>.</p>', 'DeleteCertificateMessage$CertificateArn' => '<p>The Amazon Resource Name (ARN) of the deleted certificate.</p>', 'DeleteConnectionMessage$EndpointArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>', 'DeleteConnectionMessage$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance.</p>', 'DeleteEndpointMessage$EndpointArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>', 'DeleteEventSubscriptionMessage$SubscriptionName' => '<p>The name of the DMS event notification subscription to be deleted.</p>', 'DeleteReplicationInstanceMessage$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance to be deleted.</p>', 'DeleteReplicationSubnetGroupMessage$ReplicationSubnetGroupIdentifier' => '<p>The subnet group name of the replication instance.</p>', 'DeleteReplicationTaskAssessmentRunMessage$ReplicationTaskAssessmentRunArn' => '<p>Amazon Resource Name (ARN) of the premigration assessment run to be deleted.</p>', 'DeleteReplicationTaskMessage$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the replication task to be deleted.</p>', 'DescribeAccountAttributesResponse$UniqueAccountIdentifier' => '<p>A unique DMS identifier for an account in a particular Amazon Web Services Region. The value of this identifier has the following format: <code>c99999999999</code>. DMS uses this identifier to name artifacts. For example, DMS uses this identifier to name the default Amazon S3 bucket for storing task assessment reports in a given Amazon Web Services Region. The format of this S3 bucket name is the following: <code>dms-<i>AccountNumber</i>-<i>UniqueAccountIdentifier</i>.</code> Here is an example name for this default S3 bucket: <code>dms-111122223333-c44445555666</code>.</p> <note> <p>DMS supports the <code>UniqueAccountIdentifier</code> parameter in versions 3.1.4 and later.</p> </note>', 'DescribeApplicableIndividualAssessmentsMessage$ReplicationTaskArn' => '<p>Amazon Resource Name (ARN) of a migration task on which you want to base the default list of individual assessments.</p>', 'DescribeApplicableIndividualAssessmentsMessage$ReplicationInstanceArn' => '<p>ARN of a replication instance on which you want to base the default list of individual assessments.</p>', 'DescribeApplicableIndividualAssessmentsMessage$SourceEngineName' => '<p>Name of a database engine that the specified replication instance supports as a source.</p>', 'DescribeApplicableIndividualAssessmentsMessage$TargetEngineName' => '<p>Name of a database engine that the specified replication instance supports as a target.</p>', 'DescribeApplicableIndividualAssessmentsMessage$Marker' => '<p>Optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeApplicableIndividualAssessmentsResponse$Marker' => '<p>Pagination token returned for you to pass to a subsequent request. If you pass this token as the <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up to the value specified in the request by <code>MaxRecords</code>.</p>', 'DescribeCertificatesMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeCertificatesResponse$Marker' => '<p>The pagination token.</p>', 'DescribeConnectionsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeConnectionsResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEndpointSettingsMessage$EngineName' => '<p>The databse engine used for your source or target endpoint.</p>', 'DescribeEndpointSettingsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEndpointSettingsResponse$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEndpointTypesMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEndpointTypesResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEndpointsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEndpointsResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEventCategoriesMessage$SourceType' => '<p> The type of DMS resource that generates events. </p> <p>Valid values: replication-instance | replication-task</p>', 'DescribeEventSubscriptionsMessage$SubscriptionName' => '<p>The name of the DMS event subscription to be described.</p>', 'DescribeEventSubscriptionsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEventSubscriptionsResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEventsMessage$SourceIdentifier' => '<p> The identifier of an event source.</p>', 'DescribeEventsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEventsResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeOrderableReplicationInstancesMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeOrderableReplicationInstancesResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribePendingMaintenanceActionsMessage$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance.</p>', 'DescribePendingMaintenanceActionsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribePendingMaintenanceActionsResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeRefreshSchemasStatusMessage$EndpointArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>', 'DescribeReplicationInstanceTaskLogsMessage$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance.</p>', 'DescribeReplicationInstanceTaskLogsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeReplicationInstanceTaskLogsResponse$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance.</p>', 'DescribeReplicationInstanceTaskLogsResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeReplicationInstancesMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeReplicationInstancesResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeReplicationSubnetGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeReplicationSubnetGroupsResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the task. When this input parameter is specified, the API returns only one result and ignore the values of the <code>MaxRecords</code> and <code>Marker</code> parameters. </p>', 'DescribeReplicationTaskAssessmentResultsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeReplicationTaskAssessmentResultsResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeReplicationTaskAssessmentResultsResponse$BucketName' => '<p>- The Amazon S3 bucket where the task assessment report is located. </p>', 'DescribeReplicationTaskAssessmentRunsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeReplicationTaskAssessmentRunsResponse$Marker' => '<p>A pagination token returned for you to pass to a subsequent request. If you pass this token as the <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up to the value specified in the request by <code>MaxRecords</code>.</p>', 'DescribeReplicationTaskIndividualAssessmentsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeReplicationTaskIndividualAssessmentsResponse$Marker' => '<p>A pagination token returned for you to pass to a subsequent request. If you pass this token as the <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up to the value specified in the request by <code>MaxRecords</code>.</p>', 'DescribeReplicationTasksMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeReplicationTasksResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeSchemasMessage$EndpointArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>', 'DescribeSchemasMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeSchemasResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeTableStatisticsMessage$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the replication task.</p>', 'DescribeTableStatisticsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeTableStatisticsResponse$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the replication task.</p>', 'DescribeTableStatisticsResponse$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DmsTransferSettings$ServiceAccessRoleArn' => '<p> The IAM role that has permission to access the Amazon S3 bucket. When specified as part of request syntax, such as for the <code>CreateEndpoint</code> and <code>ModifyEndpoint</code> actions, the role must allow the <code>iam:PassRole</code> action.</p>', 'DmsTransferSettings$BucketName' => '<p> The name of the S3 bucket to use. </p>', 'DocDbSettings$Username' => '<p>The user name you use to access the DocumentDB source endpoint. </p>', 'DocDbSettings$ServerName' => '<p> The name of the server on the DocumentDB source endpoint. </p>', 'DocDbSettings$DatabaseName' => '<p> The database name on the DocumentDB source endpoint. </p>', 'DocDbSettings$KmsKeyId' => '<p>The KMS key identifier that is used to encrypt the content on the replication instance. If you don\'t specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key. KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>', 'DocDbSettings$SecretsManagerAccessRoleArn' => '<p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the DocumentDB endpoint.</p> <note> <p>You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can\'t specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.</p> </note>', 'DocDbSettings$SecretsManagerSecretId' => '<p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the DocumentDB endpoint connection details.</p>', 'DynamoDbSettings$ServiceAccessRoleArn' => '<p> The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the <code>iam:PassRole</code> action.</p>', 'ElasticsearchSettings$ServiceAccessRoleArn' => '<p>The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the <code>iam:PassRole</code> action.</p>', 'ElasticsearchSettings$EndpointUri' => '<p>The endpoint for the Elasticsearch cluster. DMS uses HTTPS if a transport protocol (http/https) is not specified.</p>', 'Endpoint$EndpointIdentifier' => '<p>The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can\'t end with a hyphen or contain two consecutive hyphens.</p>', 'Endpoint$EngineName' => '<p>The database engine name. Valid values, depending on the EndpointType, include <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>', 'Endpoint$EngineDisplayName' => '<p>The expanded name for the engine name. For example, if the <code>EngineName</code> parameter is "aurora," this value would be "Amazon Aurora MySQL."</p>', 'Endpoint$Username' => '<p>The user name used to connect to the endpoint.</p>', 'Endpoint$ServerName' => '<p>The name of the server at the endpoint.</p>', 'Endpoint$DatabaseName' => '<p>The name of the database at the endpoint.</p>', 'Endpoint$ExtraConnectionAttributes' => '<p>Additional connection attributes used to connect to the endpoint.</p>', 'Endpoint$Status' => '<p>The status of the endpoint.</p>', 'Endpoint$KmsKeyId' => '<p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p> <p>If you don\'t specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.</p> <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>', 'Endpoint$EndpointArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>', 'Endpoint$CertificateArn' => '<p>The Amazon Resource Name (ARN) used for SSL connection to the endpoint.</p>', 'Endpoint$ServiceAccessRoleArn' => '<p>The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the <code>iam:PassRole</code> action.</p>', 'Endpoint$ExternalTableDefinition' => '<p>The external table definition.</p>', 'Endpoint$ExternalId' => '<p> Value returned by a call to CreateEndpoint that can be used for cross-account validation. Use it on a subsequent call to CreateEndpoint to create the endpoint with a cross-account. </p>', 'EndpointSetting$Name' => '<p>The name that you want to give the endpoint settings.</p>', 'EndpointSetting$Units' => '<p>The unit of measure for this endpoint setting.</p>', 'EndpointSetting$Applicability' => '<p>The relevance or validity of an endpoint setting for an engine name and its endpoint type.</p>', 'EndpointSetting$DefaultValue' => '<p>The default value of the endpoint setting if no value is specified using <code>CreateEndpoint</code> or <code>ModifyEndpoint</code>.</p>', 'EndpointSettingEnumValues$member' => NULL, 'Event$SourceIdentifier' => '<p> The identifier of an event source.</p>', 'Event$Message' => '<p>The event message.</p>', 'EventCategoriesList$member' => NULL, 'EventCategoryGroup$SourceType' => '<p> The type of DMS resource that generates events. </p> <p>Valid values: replication-instance | replication-server | security-group | replication-task</p>', 'EventSubscription$CustomerAwsId' => '<p>The Amazon Web Services customer account associated with the DMS event notification subscription.</p>', 'EventSubscription$CustSubscriptionId' => '<p>The DMS event notification subscription Id.</p>', 'EventSubscription$SnsTopicArn' => '<p>The topic ARN of the DMS event notification subscription.</p>', 'EventSubscription$Status' => '<p>The status of the DMS event notification subscription.</p> <p>Constraints:</p> <p>Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist</p> <p>The status "no-permission" indicates that DMS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p>', 'EventSubscription$SubscriptionCreationTime' => '<p>The time the DMS event notification subscription was created.</p>', 'EventSubscription$SourceType' => '<p> The type of DMS resource that generates events. </p> <p>Valid values: replication-instance | replication-server | security-group | replication-task</p>', 'ExcludeTestList$member' => NULL, 'Filter$Name' => '<p>The name of the filter as specified for a <code>Describe*</code> or similar operation.</p>', 'FilterValueList$member' => NULL, 'IBMDb2Settings$DatabaseName' => '<p>Database name for the endpoint.</p>', 'IBMDb2Settings$ServerName' => '<p>Fully qualified domain name of the endpoint.</p>', 'IBMDb2Settings$CurrentLsn' => '<p>For ongoing replication (CDC), use CurrentLSN to specify a log sequence number (LSN) where you want the replication to start.</p>', 'IBMDb2Settings$Username' => '<p>Endpoint connection user name.</p>', 'IBMDb2Settings$SecretsManagerAccessRoleArn' => '<p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the Db2 LUW endpoint. </p> <note> <p>You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can\'t specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.</p> </note>', 'IBMDb2Settings$SecretsManagerSecretId' => '<p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Db2 LUW endpoint connection details.</p>', 'ImportCertificateMessage$CertificateIdentifier' => '<p>A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can\'t end with a hyphen or contain two consecutive hyphens.</p>', 'IncludeTestList$member' => NULL, 'IndividualAssessmentNameList$member' => NULL, 'KafkaSettings$Broker' => '<p>A comma-separated list of one or more broker locations in your Kafka cluster that host your Kafka instance. Specify each broker location in the form <code> <i>broker-hostname-or-ip</i>:<i>port</i> </code>. For example, <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code>. For more information and examples of specifying a list of broker locations, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using Apache Kafka as a target for Database Migration Service</a> in the <i>Database Migration Service User Guide</i>. </p>', 'KafkaSettings$Topic' => '<p>The topic to which you migrate the data. If you don\'t specify a topic, DMS specifies <code>"kafka-default-topic"</code> as the migration topic.</p>', 'KafkaSettings$SslClientCertificateArn' => '<p>The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.</p>', 'KafkaSettings$SslClientKeyArn' => '<p>The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.</p>', 'KafkaSettings$SslCaCertificateArn' => '<p> The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that DMS uses to securely connect to your Kafka target endpoint.</p>', 'KafkaSettings$SaslUsername' => '<p> The secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.</p>', 'KeyList$member' => NULL, 'KinesisSettings$StreamArn' => '<p>The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.</p>', 'KinesisSettings$ServiceAccessRoleArn' => '<p>The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to the Kinesis data stream. The role must allow the <code>iam:PassRole</code> action.</p>', 'ListTagsForResourceMessage$ResourceArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to list tags for. This returns a list of keys (names of tags) created for the resource and their associated tag values.</p>', 'MicrosoftSQLServerSettings$DatabaseName' => '<p>Database name for the endpoint.</p>', 'MicrosoftSQLServerSettings$ControlTablesFileGroup' => '<p>Specifies a file group for the DMS internal tables. When the replication task starts, all the internal DMS control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for the specified file group.</p>', 'MicrosoftSQLServerSettings$ServerName' => '<p>Fully qualified domain name of the endpoint.</p>', 'MicrosoftSQLServerSettings$Username' => '<p>Endpoint connection user name.</p>', 'MicrosoftSQLServerSettings$SecretsManagerAccessRoleArn' => '<p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the SQL Server endpoint.</p> <note> <p>You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can\'t specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.</p> </note>', 'MicrosoftSQLServerSettings$SecretsManagerSecretId' => '<p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SQL Server endpoint connection details.</p>', 'ModifyEndpointMessage$EndpointArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>', 'ModifyEndpointMessage$EndpointIdentifier' => '<p>The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can\'t end with a hyphen or contain two consecutive hyphens.</p>', 'ModifyEndpointMessage$EngineName' => '<p>The type of engine for the endpoint. Valid values, depending on the EndpointType, include <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>', 'ModifyEndpointMessage$Username' => '<p>The user name to be used to login to the endpoint database.</p>', 'ModifyEndpointMessage$ServerName' => '<p>The name of the server where the endpoint database resides.</p>', 'ModifyEndpointMessage$DatabaseName' => '<p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>', 'ModifyEndpointMessage$ExtraConnectionAttributes' => '<p>Additional attributes associated with the connection. To reset this parameter, pass the empty string ("") as an argument.</p>', 'ModifyEndpointMessage$CertificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate used for SSL connection.</p>', 'ModifyEndpointMessage$ServiceAccessRoleArn' => '<p> The Amazon Resource Name (ARN) for the IAM role you want to use to modify the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>', 'ModifyEndpointMessage$ExternalTableDefinition' => '<p>The external table definition.</p>', 'ModifyEventSubscriptionMessage$SubscriptionName' => '<p>The name of the DMS event notification subscription to be modified.</p>', 'ModifyEventSubscriptionMessage$SnsTopicArn' => '<p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>', 'ModifyEventSubscriptionMessage$SourceType' => '<p> The type of DMS resource that generates the events you want to subscribe to. </p> <p>Valid values: replication-instance | replication-task</p>', 'ModifyReplicationInstanceMessage$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance.</p>', 'ModifyReplicationInstanceMessage$ReplicationInstanceClass' => '<p>The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p> <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>', 'ModifyReplicationInstanceMessage$PreferredMaintenanceWindow' => '<p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter does not result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p> <p>Default: Uses existing setting</p> <p>Format: ddd:hh24:mi-ddd:hh24:mi</p> <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p> <p>Constraints: Must be at least 30 minutes</p>', 'ModifyReplicationInstanceMessage$EngineVersion' => '<p>The engine version number of the replication instance.</p> <p>When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>', 'ModifyReplicationInstanceMessage$ReplicationInstanceIdentifier' => '<p>The replication instance identifier. This parameter is stored as a lowercase string.</p>', 'ModifyReplicationSubnetGroupMessage$ReplicationSubnetGroupIdentifier' => '<p>The name of the replication instance subnet group.</p>', 'ModifyReplicationSubnetGroupMessage$ReplicationSubnetGroupDescription' => '<p>A description for the replication instance subnet group.</p>', 'ModifyReplicationTaskMessage$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the replication task.</p>', 'ModifyReplicationTaskMessage$ReplicationTaskIdentifier' => '<p>The replication task identifier.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1-255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'ModifyReplicationTaskMessage$TableMappings' => '<p>When using the CLI or boto3, provide the path of the JSON file that contains the table mappings. Precede the path with <code>file://</code>. For example, <code>--table-mappings file://mappingfile.json</code>. When working with the DMS API, provide the JSON as the parameter value. </p>', 'ModifyReplicationTaskMessage$ReplicationTaskSettings' => '<p>JSON file that contains settings for the task, such as task metadata settings.</p>', 'ModifyReplicationTaskMessage$CdcStartPosition' => '<p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p> <p> The value can be in date, checkpoint, or LSN/SCN format.</p> <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p> <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p> <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note> <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p> </note>', 'ModifyReplicationTaskMessage$CdcStopPosition' => '<p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p> <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p> <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>', 'ModifyReplicationTaskMessage$TaskData' => '<p>Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>', 'MongoDbSettings$Username' => '<p>The user name you use to access the MongoDB source endpoint. </p>', 'MongoDbSettings$ServerName' => '<p> The name of the server on the MongoDB source endpoint. </p>', 'MongoDbSettings$DatabaseName' => '<p> The database name on the MongoDB source endpoint. </p>', 'MongoDbSettings$ExtractDocId' => '<p> Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to <code>"none"</code>. </p> <p>Default value is <code>"false"</code>. </p>', 'MongoDbSettings$DocsToInvestigate' => '<p> Indicates the number of documents to preview to determine the document organization. Use this setting when <code>NestingLevel</code> is set to <code>"one"</code>. </p> <p>Must be a positive value greater than <code>0</code>. Default value is <code>1000</code>.</p>', 'MongoDbSettings$AuthSource' => '<p> The MongoDB database name. This setting isn\'t used when <code>AuthType</code> is set to <code>"no"</code>. </p> <p>The default is <code>"admin"</code>.</p>', 'MongoDbSettings$KmsKeyId' => '<p>The KMS key identifier that is used to encrypt the content on the replication instance. If you don\'t specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key. KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>', 'MongoDbSettings$SecretsManagerAccessRoleArn' => '<p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the MongoDB endpoint.</p> <note> <p>You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can\'t specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.</p> </note>', 'MongoDbSettings$SecretsManagerSecretId' => '<p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the MongoDB endpoint connection details.</p>', 'MoveReplicationTaskMessage$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the task that you want to move.</p>', 'MoveReplicationTaskMessage$TargetReplicationInstanceArn' => '<p>The ARN of the replication instance where you want to move the task to.</p>', 'MySQLSettings$AfterConnectScript' => '<p>Specifies a script to run immediately after DMS connects to the endpoint. The migration task continues running regardless if the SQL statement succeeds or fails.</p> <p>For this parameter, provide the code of the script itself, not the name of a file containing the script.</p>', 'MySQLSettings$DatabaseName' => '<p>Database name for the endpoint. For a MySQL source or target endpoint, don\'t explicitly specify the database using the <code>DatabaseName</code> request parameter on either the <code>CreateEndpoint</code> or <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create or modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.</p>', 'MySQLSettings$ServerName' => '<p>Fully qualified domain name of the endpoint.</p>', 'MySQLSettings$ServerTimezone' => '<p>Specifies the time zone for the source MySQL database.</p> <p>Example: <code>serverTimezone=US/Pacific;</code> </p> <p>Note: Do not enclose time zones in single quotes.</p>', 'MySQLSettings$Username' => '<p>Endpoint connection user name.</p>', 'MySQLSettings$SecretsManagerAccessRoleArn' => '<p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the MySQL endpoint.</p> <note> <p>You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can\'t specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.</p> </note>', 'MySQLSettings$SecretsManagerSecretId' => '<p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the MySQL endpoint connection details.</p>', 'NeptuneSettings$ServiceAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the service role that you created for the Neptune target endpoint. The role must allow the <code>iam:PassRole</code> action. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole">Creating an IAM Service Role for Accessing Amazon Neptune as a Target</a> in the <i>Database Migration Service User Guide. </i> </p>', 'NeptuneSettings$S3BucketName' => '<p>The name of the Amazon S3 bucket where DMS can temporarily store migrated graph data in .csv files before bulk-loading it to the Neptune target database. DMS maps the SQL source data to graph data before storing it in these .csv files.</p>', 'NeptuneSettings$S3BucketFolder' => '<p>A folder path where you want DMS to store migrated graph data in the S3 bucket specified by <code>S3BucketName</code> </p>', 'OracleSettings$OraclePathPrefix' => '<p>Set this string attribute to the required value in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This value specifies the default Oracle root used to access the redo logs.</p>', 'OracleSettings$UsePathPrefix' => '<p>Set this string attribute to the required value in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This value specifies the path prefix used to replace the default Oracle root to access the redo logs.</p>', 'OracleSettings$AsmServer' => '<p>For an Oracle source endpoint, your ASM server address. You can set this value from the <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a>.</p>', 'OracleSettings$AsmUser' => '<p>For an Oracle source endpoint, your ASM user name. You can set this value from the <code>asm_user</code> value. You set <code>asm_user</code> as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a>.</p>', 'OracleSettings$DatabaseName' => '<p>Database name for the endpoint.</p>', 'OracleSettings$SecurityDbEncryptionName' => '<p>For an Oracle source endpoint, the name of a key used for the transparent data encryption (TDE) of the columns and tablespaces in an Oracle source database that is encrypted using TDE. The key value is the value of the <code>SecurityDbEncryption</code> setting. For more information on setting the key name value of <code>SecurityDbEncryptionName</code>, see the information and example for setting the <code>securityDbEncryptionName</code> extra connection attribute in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"> Supported encryption methods for using Oracle as a source for DMS </a> in the <i>Database Migration Service User Guide</i>.</p>', 'OracleSettings$ServerName' => '<p>Fully qualified domain name of the endpoint.</p>', 'OracleSettings$SpatialDataOptionToGeoJsonFunctionName' => '<p>Use this attribute to convert <code>SDO_GEOMETRY</code> to <code>GEOJSON</code> format. By default, DMS calls the <code>SDO2GEOJSON</code> custom function if present and accessible. Or you can create your own custom function that mimics the operation of <code>SDOGEOJSON</code> and set <code>SpatialDataOptionToGeoJsonFunctionName</code> to call it instead. </p>', 'OracleSettings$Username' => '<p>Endpoint connection user name.</p>', 'OracleSettings$SecretsManagerAccessRoleArn' => '<p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the Oracle endpoint.</p> <note> <p>You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can\'t specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.</p> </note>', 'OracleSettings$SecretsManagerSecretId' => '<p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Oracle endpoint connection details.</p>', 'OracleSettings$SecretsManagerOracleAsmAccessRoleArn' => '<p>Required only if your Oracle endpoint uses Advanced Storage Manager (ASM). The full ARN of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the <code>SecretsManagerOracleAsmSecret</code>. This <code>SecretsManagerOracleAsmSecret</code> has the secret value that allows access to the Oracle ASM of the endpoint.</p> <note> <p>You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerOracleAsmSecretId</code>. Or you can specify clear-text values for <code>AsmUserName</code>, <code>AsmPassword</code>, and <code>AsmServerName</code>. You can\'t specify both. For more information on creating this <code>SecretsManagerOracleAsmSecret</code> and the <code>SecretsManagerOracleAsmAccessRoleArn</code> and <code>SecretsManagerOracleAsmSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.</p> </note>', 'OracleSettings$SecretsManagerOracleAsmSecretId' => '<p>Required only if your Oracle endpoint uses Advanced Storage Manager (ASM). The full ARN, partial ARN, or friendly name of the <code>SecretsManagerOracleAsmSecret</code> that contains the Oracle ASM connection details for the Oracle endpoint.</p>', 'OrderableReplicationInstance$EngineVersion' => '<p>The version of the replication engine.</p>', 'OrderableReplicationInstance$ReplicationInstanceClass' => '<p>The compute and memory capacity of the replication instance as defined for the specified replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p> <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>', 'OrderableReplicationInstance$StorageType' => '<p>The type of storage used by the replication instance.</p>', 'PendingMaintenanceAction$Action' => '<p>The type of pending maintenance action that is available for the resource.</p>', 'PendingMaintenanceAction$OptInStatus' => '<p>The type of opt-in request that has been received for the resource.</p>', 'PendingMaintenanceAction$Description' => '<p>A description providing more detail about the maintenance action.</p>', 'PostgreSQLSettings$AfterConnectScript' => '<p>For use with change data capture (CDC) only, this attribute has DMS bypass foreign keys and user triggers to reduce the time it takes to bulk load data.</p> <p>Example: <code>afterConnectScript=SET session_replication_role=\'replica\'</code> </p>', 'PostgreSQLSettings$DatabaseName' => '<p>Database name for the endpoint.</p>', 'PostgreSQLSettings$DdlArtifactsSchema' => '<p>The schema in which the operational DDL database artifacts are created.</p> <p>Example: <code>ddlArtifactsSchema=xyzddlschema;</code> </p>', 'PostgreSQLSettings$HeartbeatSchema' => '<p>Sets the schema in which the heartbeat artifacts are created.</p>', 'PostgreSQLSettings$ServerName' => '<p>Fully qualified domain name of the endpoint.</p>', 'PostgreSQLSettings$Username' => '<p>Endpoint connection user name.</p>', 'PostgreSQLSettings$SlotName' => '<p>Sets the name of a previously created logical replication slot for a change data capture (CDC) load of the PostgreSQL source instance. </p> <p>When used with the <code>CdcStartPosition</code> request parameter for the DMS API , this attribute also makes it possible to use native CDC start points. DMS verifies that the specified logical replication slot exists before starting the CDC load task. It also verifies that the task was created with a valid setting of <code>CdcStartPosition</code>. If the specified slot doesn\'t exist or the task doesn\'t have a valid <code>CdcStartPosition</code> setting, DMS raises an error.</p> <p>For more information about setting the <code>CdcStartPosition</code> request parameter, see <a href="dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native">Determining a CDC native start point</a> in the <i>Database Migration Service User Guide</i>. For more information about using <code>CdcStartPosition</code>, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">CreateReplicationTask</a>, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">StartReplicationTask</a>, and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">ModifyReplicationTask</a>.</p>', 'PostgreSQLSettings$SecretsManagerAccessRoleArn' => '<p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the PostgreSQL endpoint.</p> <note> <p>You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can\'t specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.</p> </note>', 'PostgreSQLSettings$SecretsManagerSecretId' => '<p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the PostgreSQL endpoint connection details.</p>', 'RebootReplicationInstanceMessage$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance.</p>', 'RedisSettings$ServerName' => '<p>Fully qualified domain name of the endpoint.</p>', 'RedisSettings$AuthUserName' => '<p>The user name provided with the <code>auth-role</code> option of the <code>AuthType</code> setting for a Redis target endpoint.</p>', 'RedisSettings$SslCaCertificateArn' => '<p>The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.</p>', 'RedshiftSettings$AfterConnectScript' => '<p>Code to run after connecting. This parameter should contain the code itself, not the name of a file containing the code.</p>', 'RedshiftSettings$BucketFolder' => '<p>An S3 folder where the comma-separated-value (.csv) files are stored before being uploaded to the target Redshift cluster. </p> <p>For full load mode, DMS converts source records into .csv files and loads them to the <i>BucketFolder/TableID</i> path. DMS uses the Redshift <code>COPY</code> command to upload the .csv files to the target table. The files are deleted once the <code>COPY</code> operation has finished. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in the <i>Amazon Redshift Database Developer Guide</i>.</p> <p>For change-data-capture (CDC) mode, DMS creates a <i>NetChanges</i> table, and loads the .csv files to this <i>BucketFolder/NetChangesTableID</i> path.</p>', 'RedshiftSettings$BucketName' => '<p>The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.</p>', 'RedshiftSettings$DatabaseName' => '<p>The name of the Amazon Redshift data warehouse (service) that you are working with.</p>', 'RedshiftSettings$DateFormat' => '<p>The date format that you are using. Valid values are <code>auto</code> (case-sensitive), your date format string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of \'YYYY-MM-DD\'. Using <code>auto</code> recognizes most strings, even some that aren\'t supported when you use a date format string. </p> <p>If your date and time values use formats different from each other, set this to <code>auto</code>. </p>', 'RedshiftSettings$ReplaceInvalidChars' => '<p>A list of characters that you want to replace. Use with <code>ReplaceChars</code>.</p>', 'RedshiftSettings$ReplaceChars' => '<p>A value that specifies to replaces the invalid characters specified in <code>ReplaceInvalidChars</code>, substituting the specified characters instead. The default is <code>"?"</code>.</p>', 'RedshiftSettings$ServerName' => '<p>The name of the Amazon Redshift cluster you are using.</p>', 'RedshiftSettings$ServiceAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service. The role must allow the <code>iam:PassRole</code> action.</p>', 'RedshiftSettings$ServerSideEncryptionKmsKeyId' => '<p>The KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide this key ID. The key that you use needs an attached policy that enables IAM user permissions and allows use of the key.</p>', 'RedshiftSettings$TimeFormat' => '<p>The time format that you want to use. Valid values are <code>auto</code> (case-sensitive), <code>\'timeformat_string\'</code>, <code>\'epochsecs\'</code>, or <code>\'epochmillisecs\'</code>. It defaults to 10. Using <code>auto</code> recognizes most strings, even some that aren\'t supported when you use a time format string. </p> <p>If your date and time values use formats different from each other, set this parameter to <code>auto</code>. </p>', 'RedshiftSettings$Username' => '<p>An Amazon Redshift user name for a registered user.</p>', 'RedshiftSettings$SecretsManagerAccessRoleArn' => '<p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the Amazon Redshift endpoint.</p> <note> <p>You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can\'t specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.</p> </note>', 'RedshiftSettings$SecretsManagerSecretId' => '<p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Amazon Redshift endpoint connection details.</p>', 'RefreshSchemasMessage$EndpointArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>', 'RefreshSchemasMessage$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance.</p>', 'RefreshSchemasStatus$EndpointArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>', 'RefreshSchemasStatus$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance.</p>', 'RefreshSchemasStatus$LastFailureMessage' => '<p>The last failure message for the schema.</p>', 'ReloadTablesMessage$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the replication task. </p>', 'ReloadTablesResponse$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the replication task. </p>', 'RemoveTagsFromResourceMessage$ResourceArn' => '<p>An DMS resource from which you want to remove tag(s). The value for this parameter is an Amazon Resource Name (ARN).</p>', 'ReplicationInstance$ReplicationInstanceIdentifier' => '<p>The replication instance identifier is a required parameter. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1-63 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>myrepinstance</code> </p>', 'ReplicationInstance$ReplicationInstanceClass' => '<p>The compute and memory capacity of the replication instance as defined for the specified replication instance class. It is a required parameter, although a default value is pre-selected in the DMS console.</p> <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>', 'ReplicationInstance$ReplicationInstanceStatus' => '<p>The status of the replication instance. The possible return values include:</p> <ul> <li> <p> <code>"available"</code> </p> </li> <li> <p> <code>"creating"</code> </p> </li> <li> <p> <code>"deleted"</code> </p> </li> <li> <p> <code>"deleting"</code> </p> </li> <li> <p> <code>"failed"</code> </p> </li> <li> <p> <code>"modifying"</code> </p> </li> <li> <p> <code>"upgrading"</code> </p> </li> <li> <p> <code>"rebooting"</code> </p> </li> <li> <p> <code>"resetting-master-credentials"</code> </p> </li> <li> <p> <code>"storage-full"</code> </p> </li> <li> <p> <code>"incompatible-credentials"</code> </p> </li> <li> <p> <code>"incompatible-network"</code> </p> </li> <li> <p> <code>"maintenance"</code> </p> </li> </ul>', 'ReplicationInstance$AvailabilityZone' => '<p>The Availability Zone for the instance.</p>', 'ReplicationInstance$PreferredMaintenanceWindow' => '<p>The maintenance window times for the replication instance. Any pending upgrades to the replication instance are performed during this time.</p>', 'ReplicationInstance$EngineVersion' => '<p>The engine version number of the replication instance.</p> <p>If an engine version number is not specified when a replication instance is created, the default is the latest engine version available.</p> <p>When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>', 'ReplicationInstance$KmsKeyId' => '<p>An KMS key identifier that is used to encrypt the data on the replication instance.</p> <p>If you don\'t specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.</p> <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>', 'ReplicationInstance$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance.</p>', 'ReplicationInstance$ReplicationInstancePublicIpAddress' => '<p>The public IP address of the replication instance.</p>', 'ReplicationInstance$ReplicationInstancePrivateIpAddress' => '<p>The private IP address of the replication instance.</p>', 'ReplicationInstance$SecondaryAvailabilityZone' => '<p>The Availability Zone of the standby replication instance in a Multi-AZ deployment.</p>', 'ReplicationInstance$DnsNameServers' => '<p>The DNS name servers supported for the replication instance to access your on-premise source or target database.</p>', 'ReplicationInstancePrivateIpAddressList$member' => NULL, 'ReplicationInstancePublicIpAddressList$member' => NULL, 'ReplicationInstanceTaskLog$ReplicationTaskName' => '<p>The name of the replication task.</p>', 'ReplicationInstanceTaskLog$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the replication task.</p>', 'ReplicationPendingModifiedValues$ReplicationInstanceClass' => '<p>The compute and memory capacity of the replication instance as defined for the specified replication instance class.</p> <p>For more information on the settings and capacities for the available replication instance classes, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"> Selecting the right DMS replication instance for your migration</a>. </p>', 'ReplicationPendingModifiedValues$EngineVersion' => '<p>The engine version number of the replication instance.</p>', 'ReplicationSubnetGroup$ReplicationSubnetGroupIdentifier' => '<p>The identifier of the replication instance subnet group.</p>', 'ReplicationSubnetGroup$ReplicationSubnetGroupDescription' => '<p>A description for the replication subnet group.</p>', 'ReplicationSubnetGroup$VpcId' => '<p>The ID of the VPC.</p>', 'ReplicationSubnetGroup$SubnetGroupStatus' => '<p>The status of the subnet group.</p>', 'ReplicationTask$ReplicationTaskIdentifier' => '<p>The user-assigned replication task identifier or name.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1-255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'ReplicationTask$SourceEndpointArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the endpoint.</p>', 'ReplicationTask$TargetEndpointArn' => '<p>The ARN that uniquely identifies the endpoint.</p>', 'ReplicationTask$ReplicationInstanceArn' => '<p>The ARN of the replication instance.</p>', 'ReplicationTask$TableMappings' => '<p>Table mappings specified in the task.</p>', 'ReplicationTask$ReplicationTaskSettings' => '<p>The settings for the replication task.</p>', 'ReplicationTask$Status' => '<p>The status of the replication task. This response parameter can return one of the following values:</p> <ul> <li> <p> <code>"moving"</code> – The task is being moved in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html"> <code>MoveReplicationTask</code> </a> operation.</p> </li> <li> <p> <code>"creating"</code> – The task is being created in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html"> <code>CreateReplicationTask</code> </a> operation.</p> </li> <li> <p> <code>"deleting"</code> – The task is being deleted in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html"> <code>DeleteReplicationTask</code> </a> operation.</p> </li> <li> <p> <code>"failed"</code> – The task failed to successfully complete the database migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html"> <code>StartReplicationTask</code> </a> operation.</p> </li> <li> <p> <code>"failed-move"</code> – The task failed to move in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html"> <code>MoveReplicationTask</code> </a> operation.</p> </li> <li> <p> <code>"modifying"</code> – The task definition is being modified in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html"> <code>ModifyReplicationTask</code> </a> operation.</p> </li> <li> <p> <code>"ready"</code> – The task is in a <code>ready</code> state where it can respond to other task operations, such as <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html"> <code>StartReplicationTask</code> </a> or <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html"> <code>DeleteReplicationTask</code> </a>. </p> </li> <li> <p> <code>"running"</code> – The task is performing a database migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html"> <code>StartReplicationTask</code> </a> operation.</p> </li> <li> <p> <code>"starting"</code> – The task is preparing to perform a database migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html"> <code>StartReplicationTask</code> </a> operation.</p> </li> <li> <p> <code>"stopped"</code> – The task has stopped in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html"> <code>StopReplicationTask</code> </a> operation.</p> </li> <li> <p> <code>"stopping"</code> – The task is preparing to stop in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html"> <code>StopReplicationTask</code> </a> operation.</p> </li> <li> <p> <code>"testing"</code> – The database migration specified for this task is being tested in response to running either the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html"> <code>StartReplicationTaskAssessmentRun</code> </a> or the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html"> <code>StartReplicationTaskAssessment</code> </a> operation.</p> <note> <p> <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html"> <code>StartReplicationTaskAssessmentRun</code> </a> is an improved premigration task assessment operation. The <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html"> <code>StartReplicationTaskAssessment</code> </a> operation assesses data type compatibility only between the source and target database of a given migration task. In contrast, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html"> <code>StartReplicationTaskAssessmentRun</code> </a> enables you to specify a variety of premigration task assessments in addition to data type compatibility. These assessments include ones for the validity of primary key definitions and likely issues with database migration performance, among others.</p> </note> </li> </ul>', 'ReplicationTask$LastFailureMessage' => '<p>The last error (failure) message generated for the replication task.</p>', 'ReplicationTask$StopReason' => '<p>The reason the replication task was stopped. This response parameter can return one of the following values:</p> <ul> <li> <p> <code>"STOP_REASON_FULL_LOAD_COMPLETED"</code> – Full-load migration completed.</p> </li> <li> <p> <code>"STOP_REASON_CACHED_CHANGES_APPLIED"</code> – Change data capture (CDC) load completed.</p> </li> <li> <p> <code>"STOP_REASON_CACHED_CHANGES_NOT_APPLIED"</code> – In a full-load and CDC migration, the full load stopped as specified before starting the CDC migration.</p> </li> <li> <p> <code>"STOP_REASON_SERVER_TIME"</code> – The migration stopped at the specified server time.</p> </li> </ul>', 'ReplicationTask$CdcStartPosition' => '<p>Indicates when you want a change data capture (CDC) operation to start. Use either <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want the CDC operation to start. Specifying both values results in an error.</p> <p>The value can be in date, checkpoint, or LSN/SCN format.</p> <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p> <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p> <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>', 'ReplicationTask$CdcStopPosition' => '<p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p> <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p> <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>', 'ReplicationTask$RecoveryCheckpoint' => '<p>Indicates the last checkpoint that occurred during a change data capture (CDC) operation. You can provide this value to the <code>CdcStartPosition</code> parameter to start a CDC operation that begins at that checkpoint.</p>', 'ReplicationTask$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the replication task.</p>', 'ReplicationTask$TaskData' => '<p>Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i> </p>', 'ReplicationTask$TargetReplicationInstanceArn' => '<p>The ARN of the replication instance to which this task is moved in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html"> <code>MoveReplicationTask</code> </a> operation. Otherwise, this response parameter isn\'t a member of the <code>ReplicationTask</code> object.</p>', 'ReplicationTaskAssessmentResult$ReplicationTaskIdentifier' => '<p> The replication task identifier of the task on which the task assessment was run. </p>', 'ReplicationTaskAssessmentResult$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the replication task. </p>', 'ReplicationTaskAssessmentResult$AssessmentStatus' => '<p> The status of the task assessment. </p>', 'ReplicationTaskAssessmentResult$AssessmentResultsFile' => '<p> The file containing the results of the task assessment. </p>', 'ReplicationTaskAssessmentResult$AssessmentResults' => '<p> The task assessment results in JSON format. </p> <p>The response object only contains this field if you provide <a>DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn</a> in the request.</p>', 'ReplicationTaskAssessmentResult$S3ObjectUrl' => '<p> The URL of the S3 object containing the task assessment results. </p> <p>The response object only contains this field if you provide <a>DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn</a> in the request.</p>', 'ReplicationTaskAssessmentRun$ReplicationTaskAssessmentRunArn' => '<p>Amazon Resource Name (ARN) of this assessment run.</p>', 'ReplicationTaskAssessmentRun$ReplicationTaskArn' => '<p>ARN of the migration task associated with this premigration assessment run.</p>', 'ReplicationTaskAssessmentRun$Status' => '<p>Assessment run status. </p> <p>This status can have one of the following values:</p> <ul> <li> <p> <code>"cancelling"</code> – The assessment run was canceled by the <code>CancelReplicationTaskAssessmentRun</code> operation.</p> </li> <li> <p> <code>"deleting"</code> – The assessment run was deleted by the <code>DeleteReplicationTaskAssessmentRun</code> operation.</p> </li> <li> <p> <code>"failed"</code> – At least one individual assessment completed with a <code>failed</code> status.</p> </li> <li> <p> <code>"error-provisioning"</code> – An internal error occurred while resources were provisioned (during <code>provisioning</code> status).</p> </li> <li> <p> <code>"error-executing"</code> – An internal error occurred while individual assessments ran (during <code>running</code> status).</p> </li> <li> <p> <code>"invalid state"</code> – The assessment run is in an unknown state.</p> </li> <li> <p> <code>"passed"</code> – All individual assessments have completed, and none has a <code>failed</code> status.</p> </li> <li> <p> <code>"provisioning"</code> – Resources required to run individual assessments are being provisioned.</p> </li> <li> <p> <code>"running"</code> – Individual assessments are being run.</p> </li> <li> <p> <code>"starting"</code> – The assessment run is starting, but resources are not yet being provisioned for individual assessments.</p> </li> </ul>', 'ReplicationTaskAssessmentRun$LastFailureMessage' => '<p>Last message generated by an individual assessment failure.</p>', 'ReplicationTaskAssessmentRun$ServiceAccessRoleArn' => '<p>ARN of the service role used to start the assessment run using the <code>StartReplicationTaskAssessmentRun</code> operation. The role must allow the <code>iam:PassRole</code> action.</p>', 'ReplicationTaskAssessmentRun$ResultLocationBucket' => '<p>Amazon S3 bucket where DMS stores the results of this assessment run.</p>', 'ReplicationTaskAssessmentRun$ResultLocationFolder' => '<p>Folder in an Amazon S3 bucket where DMS stores the results of this assessment run.</p>', 'ReplicationTaskAssessmentRun$ResultEncryptionMode' => '<p>Encryption mode used to encrypt the assessment run results.</p>', 'ReplicationTaskAssessmentRun$ResultKmsKeyArn' => '<p>ARN of the KMS encryption key used to encrypt the assessment run results.</p>', 'ReplicationTaskAssessmentRun$AssessmentRunName' => '<p>Unique name of the assessment run.</p>', 'ReplicationTaskIndividualAssessment$ReplicationTaskIndividualAssessmentArn' => '<p>Amazon Resource Name (ARN) of this individual assessment.</p>', 'ReplicationTaskIndividualAssessment$ReplicationTaskAssessmentRunArn' => '<p>ARN of the premigration assessment run that is created to run this individual assessment.</p>', 'ReplicationTaskIndividualAssessment$IndividualAssessmentName' => '<p>Name of this individual assessment.</p>', 'ReplicationTaskIndividualAssessment$Status' => '<p>Individual assessment status.</p> <p>This status can have one of the following values:</p> <ul> <li> <p> <code>"cancelled"</code> </p> </li> <li> <p> <code>"error"</code> </p> </li> <li> <p> <code>"failed"</code> </p> </li> <li> <p> <code>"passed"</code> </p> </li> <li> <p> <code>"pending"</code> </p> </li> <li> <p> <code>"running"</code> </p> </li> </ul>', 'ResourcePendingMaintenanceActions$ResourceIdentifier' => '<p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Introduction.AWS.ARN.html"> Constructing an Amazon Resource Name (ARN) for DMS</a> in the DMS documentation.</p>', 'S3Settings$ServiceAccessRoleArn' => '<p> The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the <code>iam:PassRole</code> action. It is a required parameter that enables DMS to write and read objects from an S3 bucket.</p>', 'S3Settings$ExternalTableDefinition' => '<p> Specifies how tables are defined in the S3 source files only. </p>', 'S3Settings$CsvRowDelimiter' => '<p> The delimiter used to separate rows in the .csv file for both source and target. The default is a carriage return (<code>\\n</code>). </p>', 'S3Settings$CsvDelimiter' => '<p> The delimiter used to separate columns in the .csv file for both source and target. The default is a comma. </p>', 'S3Settings$BucketFolder' => '<p> An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the path <code> <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>. If this parameter isn\'t specified, then the path used is <code> <i>schema_name</i>/<i>table_name</i>/</code>. </p>', 'S3Settings$BucketName' => '<p> The name of the S3 bucket. </p>', 'S3Settings$ServerSideEncryptionKmsKeyId' => '<p>If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the KMS key ID. The key that you use needs an attached policy that enables Identity and Access Management (IAM) user permissions and allows use of the key.</p> <p>Here is a CLI example: <code>aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> </code> </p>', 'S3Settings$TimestampColumnName' => '<p>A value that when nonblank causes DMS to add a column with timestamp information to the endpoint data for an Amazon S3 target.</p> <note> <p>DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.</p> </note> <p>DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your migrated data when you set <code>TimestampColumnName</code> to a nonblank value.</p> <p>For a full load, each row of this timestamp column contains a timestamp for when the data was transferred from the source to the target by DMS. </p> <p>For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the commit of that row in the source database.</p> <p>The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default, the precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on the commit timestamp supported by DMS for the source database.</p> <p>When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also includes a name for the timestamp column that you set with <code>TimestampColumnName</code>.</p>', 'S3Settings$CsvNoSupValue' => '<p>This setting only applies if your Amazon S3 output files during a change data capture (CDC) load are written in .csv format. If <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue"> <code>UseCsvNoSupValue</code> </a> is set to true, specify a string value that you want DMS to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of the <code>UseCsvNoSupValue</code> setting.</p> <note> <p>This setting is supported in DMS versions 3.4.1 and later.</p> </note>', 'S3Settings$CdcPath' => '<p>Specifies the folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it\'s optional. If <code>CdcPath</code> is set, DMS reads CDC files from this path and replicates the data changes to the target endpoint. For an S3 target if you set <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions"> <code>PreserveTransactions</code> </a> to <code>true</code>, DMS verifies that you have set this parameter to a folder path on your S3 target where DMS can save the transaction order for the CDC load. DMS creates this CDC folder path in either your S3 target working directory or the S3 target location specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder"> <code>BucketFolder</code> </a> and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName"> <code>BucketName</code> </a>.</p> <p>For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code>, and you specify <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify <code>BucketFolder</code>, DMS creates the CDC folder path following: <code>MyTargetBucket/MyChangedData</code>.</p> <p>If you specify the same <code>CdcPath</code>, and you specify <code>BucketName</code> as <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code>, DMS creates the CDC folder path following: <code>MyTargetBucket/MyTargetData/MyChangedData</code>.</p> <p>For more information on CDC including transaction order on an S3 target, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3 target</a>.</p> <note> <p>This setting is supported in DMS versions 3.4.2 and later.</p> </note>', 'S3Settings$CsvNullValue' => '<p>An optional parameter that specifies how DMS treats null values. While handling the null value, you can use this parameter to pass a user-defined string as null when writing to the target. For example, when target columns are not nullable, you can use this option to differentiate between the empty string value and the null value. So, if you set this parameter value to the empty string ("" or \'\'), DMS treats the empty string as the null value instead of <code>NULL</code>.</p> <p>The default value is <code>NULL</code>. Valid values include any valid string.</p>', 'SchemaList$member' => NULL, 'SourceIdsList$member' => NULL, 'StartReplicationTaskAssessmentMessage$ReplicationTaskArn' => '<p> The Amazon Resource Name (ARN) of the replication task. </p>', 'StartReplicationTaskAssessmentRunMessage$ReplicationTaskArn' => '<p>Amazon Resource Name (ARN) of the migration task associated with the premigration assessment run that you want to start.</p>', 'StartReplicationTaskAssessmentRunMessage$ServiceAccessRoleArn' => '<p>ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code> action.</p>', 'StartReplicationTaskAssessmentRunMessage$ResultLocationBucket' => '<p>Amazon S3 bucket where you want DMS to store the results of this assessment run.</p>', 'StartReplicationTaskAssessmentRunMessage$ResultLocationFolder' => '<p>Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment run.</p>', 'StartReplicationTaskAssessmentRunMessage$ResultEncryptionMode' => '<p>Encryption mode that you can specify to encrypt the results of this assessment run. If you don\'t specify this request parameter, DMS stores the assessment run results without encryption. You can specify one of the options following:</p> <ul> <li> <p> <code>"SSE_S3"</code> – The server-side encryption provided as a default by Amazon S3.</p> </li> <li> <p> <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption. This encryption can use either a custom KMS encryption key that you specify or the default KMS encryption key that DMS provides.</p> </li> </ul>', 'StartReplicationTaskAssessmentRunMessage$ResultKmsKeyArn' => '<p>ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to <code>"SSE_KMS</code>".</p>', 'StartReplicationTaskAssessmentRunMessage$AssessmentRunName' => '<p>Unique name to identify the assessment run.</p>', 'StartReplicationTaskMessage$ReplicationTaskArn' => '<p>The Amazon Resource Name (ARN) of the replication task to be started.</p>', 'StartReplicationTaskMessage$CdcStartPosition' => '<p>Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.</p> <p> The value can be in date, checkpoint, or LSN/SCN format.</p> <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p> <p>Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p> <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p> <note> <p>When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.</p> </note>', 'StartReplicationTaskMessage$CdcStopPosition' => '<p>Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.</p> <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p> <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>', 'StopReplicationTaskMessage$ReplicationTaskArn' => '<p>The Amazon Resource Name(ARN) of the replication task to be stopped.</p>', 'Subnet$SubnetIdentifier' => '<p>The subnet identifier.</p>', 'Subnet$SubnetStatus' => '<p>The status of the subnet.</p>', 'SubnetIdentifierList$member' => NULL, 'SupportedEndpointType$EngineName' => '<p>The database engine name. Valid values, depending on the EndpointType, include <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>', 'SupportedEndpointType$ReplicationInstanceEngineMinimumVersion' => '<p>The earliest DMS engine version that supports this endpoint engine. Note that endpoint engines released with DMS versions earlier than 3.1.1 do not return a value for this parameter.</p>', 'SupportedEndpointType$EngineDisplayName' => '<p>The expanded name for the engine name. For example, if the <code>EngineName</code> parameter is "aurora," this value would be "Amazon Aurora MySQL."</p>', 'SybaseSettings$DatabaseName' => '<p>Database name for the endpoint.</p>', 'SybaseSettings$ServerName' => '<p>Fully qualified domain name of the endpoint.</p>', 'SybaseSettings$Username' => '<p>Endpoint connection user name.</p>', 'SybaseSettings$SecretsManagerAccessRoleArn' => '<p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the SAP ASE endpoint.</p> <note> <p>You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can\'t specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.</p> </note>', 'SybaseSettings$SecretsManagerSecretId' => '<p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SAP SAE endpoint connection details.</p>', 'TableStatistics$SchemaName' => '<p>The schema name.</p>', 'TableStatistics$TableName' => '<p>The name of the table.</p>', 'TableStatistics$TableState' => '<p>The state of the tables described.</p> <p>Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled | Table error | Table all | Table updates | Table is being reloaded</p>', 'TableStatistics$ValidationState' => '<p>The validation state of the table.</p> <p>This parameter can have the following values:</p> <ul> <li> <p>Not enabled – Validation isn\'t enabled for the table in the migration task.</p> </li> <li> <p>Pending records – Some records in the table are waiting for validation.</p> </li> <li> <p>Mismatched records – Some records in the table don\'t match between the source and target.</p> </li> <li> <p>Suspended records – Some records in the table couldn\'t be validated.</p> </li> <li> <p>No primary key –The table couldn\'t be validated because it has no primary key.</p> </li> <li> <p>Table error – The table wasn\'t validated because it\'s in an error state and some data wasn\'t migrated.</p> </li> <li> <p>Validated – All rows in the table are validated. If the table is updated, the status can change from Validated.</p> </li> <li> <p>Error – The table couldn\'t be validated because of an unexpected error.</p> </li> <li> <p>Pending validation – The table is waiting validation.</p> </li> <li> <p>Preparing table – Preparing the table enabled in the migration task for validation.</p> </li> <li> <p>Pending revalidation – All rows in the table are pending validation after the table was updated.</p> </li> </ul>', 'TableStatistics$ValidationStateDetails' => '<p>Additional details about the state of validation.</p>', 'TableToReload$SchemaName' => '<p>The schema name of the table to be reloaded.</p>', 'TableToReload$TableName' => '<p>The table name of the table to be reloaded.</p>', 'Tag$Key' => '<p>A key is the required name of the tag. The string value can be 1-128 Unicode characters in length and can\'t be prefixed with "aws:" or "dms:". The string can only contain only the set of Unicode letters, digits, white-space, \'_\', \'.\', \'/\', \'=\', \'+\', \'-\' (Java regular expressions: "^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-]*)$").</p>', 'Tag$Value' => '<p>A value is the optional value of the tag. The string value can be 1-256 Unicode characters in length and can\'t be prefixed with "aws:" or "dms:". The string can only contain only the set of Unicode letters, digits, white-space, \'_\', \'.\', \'/\', \'=\', \'+\', \'-\' (Java regular expressions: "^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-]*)$").</p>', 'Tag$ResourceArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the resource for which the tag is created.</p>', 'TestConnectionMessage$ReplicationInstanceArn' => '<p>The Amazon Resource Name (ARN) of the replication instance.</p>', 'TestConnectionMessage$EndpointArn' => '<p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>', 'VpcSecurityGroupIdList$member' => NULL, 'VpcSecurityGroupMembership$VpcSecurityGroupId' => '<p>The VPC security group ID.</p>', 'VpcSecurityGroupMembership$Status' => '<p>The status of the VPC security group.</p>', ], ], 'Subnet' => [ 'base' => '<p>In response to a request by the <code>DescribeReplicationSubnetGroups</code> operation, this object identifies a subnet by its given Availability Zone, subnet identifier, and status.</p>', 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetAlreadyInUse' => [ 'base' => '<p>The specified subnet is already in use.</p>', 'refs' => [], ], 'SubnetIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationSubnetGroupMessage$SubnetIds' => '<p>One or more subnet IDs to be assigned to the subnet group.</p>', 'ModifyReplicationSubnetGroupMessage$SubnetIds' => '<p>A list of subnet IDs.</p>', ], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'ReplicationSubnetGroup$Subnets' => '<p>The subnets that are in the subnet group.</p>', ], ], 'SupportedEndpointType' => [ 'base' => '<p>Provides information about types of supported endpoints in response to a request by the <code>DescribeEndpointTypes</code> operation. This information includes the type of endpoint, the database engine name, and whether change data capture (CDC) is supported.</p>', 'refs' => [ 'SupportedEndpointTypeList$member' => NULL, ], ], 'SupportedEndpointTypeList' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointTypesResponse$SupportedEndpointTypes' => '<p>The types of endpoints that are supported.</p>', ], ], 'SybaseSettings' => [ 'base' => '<p>Provides information that defines a SAP ASE endpoint.</p>', 'refs' => [ 'CreateEndpointMessage$SybaseSettings' => '<p>Settings in JSON format for the source and target SAP ASE endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', 'Endpoint$SybaseSettings' => '<p>The settings for the SAP ASE source and target endpoint. For more information, see the <code>SybaseSettings</code> structure.</p>', 'ModifyEndpointMessage$SybaseSettings' => '<p>Settings in JSON format for the source and target SAP ASE endpoint. For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service User Guide.</i> </p>', ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'Certificate$CertificateCreationDate' => '<p>The date that the certificate was created.</p>', 'Certificate$ValidFromDate' => '<p>The beginning date that the certificate is valid.</p>', 'Certificate$ValidToDate' => '<p>The final date that the certificate is valid.</p>', 'CreateReplicationTaskMessage$CdcStartTime' => '<p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p> <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>', 'DescribeEventsMessage$StartTime' => '<p>The start time for the events to be listed.</p>', 'DescribeEventsMessage$EndTime' => '<p>The end time for the events to be listed.</p>', 'Event$Date' => '<p>The date of the event.</p>', 'ModifyReplicationTaskMessage$CdcStartTime' => '<p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p> <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>', 'PendingMaintenanceAction$AutoAppliedAfterDate' => '<p>The date of the maintenance window when the action is to be applied. The maintenance action is applied to the resource during its first maintenance window after this date. If this date is specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>', 'PendingMaintenanceAction$ForcedApplyDate' => '<p>The date when the maintenance action will be automatically applied. The maintenance action is applied to the resource on this date regardless of the maintenance window for the resource. If this date is specified, any <code>immediate</code> opt-in requests are ignored.</p>', 'PendingMaintenanceAction$CurrentApplyDate' => '<p>The effective date when the pending maintenance action will be applied to the resource. This date takes into account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API operation, and also the <code>AutoAppliedAfterDate</code> and <code>ForcedApplyDate</code> parameter values. This value is blank if an opt-in request has not been received and nothing has been specified for <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>', 'RefreshSchemasStatus$LastRefreshDate' => '<p>The date the schema was last refreshed.</p>', 'ReplicationInstance$InstanceCreateTime' => '<p>The time the replication instance was created.</p>', 'ReplicationInstance$FreeUntil' => '<p> The expiration date of the free replication instance that is part of the Free DMS program. </p>', 'ReplicationTask$ReplicationTaskCreationDate' => '<p>The date the replication task was created.</p>', 'ReplicationTask$ReplicationTaskStartDate' => '<p>The date the replication task is scheduled to start.</p>', 'ReplicationTaskAssessmentResult$ReplicationTaskLastAssessmentDate' => '<p>The date the task assessment was completed. </p>', 'ReplicationTaskAssessmentRun$ReplicationTaskAssessmentRunCreationDate' => '<p>Date on which the assessment run was created using the <code>StartReplicationTaskAssessmentRun</code> operation.</p>', 'ReplicationTaskIndividualAssessment$ReplicationTaskIndividualAssessmentStartDate' => '<p>Date when this individual assessment was started as part of running the <code>StartReplicationTaskAssessmentRun</code> operation.</p>', 'ReplicationTaskStats$FreshStartDate' => '<p>The date the replication task was started either with a fresh start or a target reload.</p>', 'ReplicationTaskStats$StartDate' => '<p>The date the replication task was started either with a fresh start or a resume. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType">StartReplicationTaskType</a>.</p>', 'ReplicationTaskStats$StopDate' => '<p>The date the replication task was stopped.</p>', 'ReplicationTaskStats$FullLoadStartDate' => '<p>The date the replication task full load was started.</p>', 'ReplicationTaskStats$FullLoadFinishDate' => '<p>The date the replication task full load was completed.</p>', 'StartReplicationTaskMessage$CdcStartTime' => '<p>Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.</p> <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>', 'TableStatistics$FullLoadStartTime' => '<p>The time when the full load operation started.</p>', 'TableStatistics$FullLoadEndTime' => '<p>The time when the full load operation completed.</p>', 'TableStatistics$LastUpdateTime' => '<p>The last time a table was updated.</p>', ], ], 'TableListToReload' => [ 'base' => NULL, 'refs' => [ 'ReloadTablesMessage$TablesToReload' => '<p>The name and schema of the table to be reloaded. </p>', ], ], 'TableStatistics' => [ 'base' => '<p>Provides a collection of table statistics in response to a request by the <code>DescribeTableStatistics</code> operation.</p>', 'refs' => [ 'TableStatisticsList$member' => NULL, ], ], 'TableStatisticsList' => [ 'base' => NULL, 'refs' => [ 'DescribeTableStatisticsResponse$TableStatistics' => '<p>The table statistics.</p>', ], ], 'TableToReload' => [ 'base' => '<p>Provides the name of the schema and table to be reloaded.</p>', 'refs' => [ 'TableListToReload$member' => NULL, ], ], 'Tag' => [ 'base' => '<p>A user-defined key-value pair that describes metadata added to an DMS resource and that is used by operations such as the following:</p> <ul> <li> <p> <code>AddTagsToResource</code> </p> </li> <li> <p> <code>ListTagsForResource</code> </p> </li> <li> <p> <code>RemoveTagsFromResource</code> </p> </li> </ul>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceMessage$Tags' => '<p>One or more tags to be assigned to the resource.</p>', 'CreateEndpointMessage$Tags' => '<p>One or more tags to be assigned to the endpoint.</p>', 'CreateEventSubscriptionMessage$Tags' => '<p>One or more tags to be assigned to the event subscription.</p>', 'CreateReplicationInstanceMessage$Tags' => '<p>One or more tags to be assigned to the replication instance.</p>', 'CreateReplicationSubnetGroupMessage$Tags' => '<p>One or more tags to be assigned to the subnet group.</p>', 'CreateReplicationTaskMessage$Tags' => '<p>One or more tags to be assigned to the replication task.</p>', 'ImportCertificateMessage$Tags' => '<p>The tags associated with the certificate.</p>', 'ListTagsForResourceResponse$TagList' => '<p>A list of tags for the resource.</p>', ], ], 'TargetDbType' => [ 'base' => NULL, 'refs' => [ 'MySQLSettings$TargetDbType' => '<p>Specifies where to migrate source tables on the target, either to a single database or multiple databases.</p> <p>Example: <code>targetDbType=MULTIPLE_DATABASES</code> </p>', ], ], 'TestConnectionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'TestConnectionResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'UpgradeDependencyFailureFault' => [ 'base' => '<p>An upgrade dependency is preventing the database migration.</p>', 'refs' => [], ], 'VpcSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationInstanceMessage$VpcSecurityGroupIds' => '<p> Specifies the VPC security group to be used with the replication instance. The VPC security group must work with the VPC containing the replication instance. </p>', 'ModifyReplicationInstanceMessage$VpcSecurityGroupIds' => '<p> Specifies the VPC security group to be used with the replication instance. The VPC security group must work with the VPC containing the replication instance. </p>', ], ], 'VpcSecurityGroupMembership' => [ 'base' => '<p>Describes the status of a security group associated with the virtual private cloud (VPC) hosting your replication and DB instances.</p>', 'refs' => [ 'VpcSecurityGroupMembershipList$member' => NULL, ], ], 'VpcSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'ReplicationInstance$VpcSecurityGroups' => '<p>The VPC security group for the instance.</p>', ], ], ],];
