<?php
// This file was auto-generated from sdk-root/src/data/devops-guru/2020-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> Amazon DevOps Guru is a fully managed service that helps you identify anomalous behavior in business critical operational applications. You specify the AWS resources that you want DevOps Guru to cover, then the Amazon CloudWatch metrics and AWS CloudTrail events related to those resources are analyzed. When anomalous behavior is detected, DevOps Guru creates an <i>insight</i> that includes recommendations, related events, and related metrics that can help you improve your operational applications. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html">What is Amazon DevOps Guru</a>. </p> <p> You can specify 1 or 2 Amazon Simple Notification Service topics so you are notified every time a new insight is created. You can also enable DevOps Guru to generate an OpsItem in AWS Systems Manager for each insight to help you manage and track your work addressing insights. </p> <p> To learn about the DevOps Guru workflow, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html#how-it-works">How DevOps Guru works</a>. To learn about DevOps Guru concepts, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/concepts.html">Concepts in DevOps Guru</a>. </p>', 'operations' => [ 'AddNotificationChannel' => '<p> Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps Guru events, such as when an insight is generated. </p> <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p> <p>If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for AWS KMS–encrypted Amazon SNS topics</a>.</p>', 'DescribeAccountHealth' => '<p> Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your AWS account. Use these numbers to gauge the health of operations in your AWS account. </p>', 'DescribeAccountOverview' => '<p> For the time range passed in, returns the number of open reactive insight that were created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights. </p>', 'DescribeAnomaly' => '<p> Returns details about an anomaly that you specify using its ID. </p>', 'DescribeFeedback' => '<p> Returns the most recent feedback submitted in the current AWS account and Region. </p>', 'DescribeInsight' => '<p> Returns details about an insight that you specify using its ID. </p>', 'DescribeResourceCollectionHealth' => '<p> Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for all closed insights in resource collections in your account. You specify the type of AWS resources collection. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks. </p>', 'DescribeServiceIntegration' => '<p> Returns the integration status of services that are integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is AWS Systems Manager, which can be used to create an OpsItem for each generated insight. </p>', 'GetCostEstimation' => '<p>Returns an estimate of the monthly cost for DevOps Guru to analyze your AWS resources. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>', 'GetResourceCollection' => '<p> Returns lists AWS resources that are of the specified resource collection type. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks. </p>', 'ListAnomaliesForInsight' => '<p> Returns a list of the anomalies that belong to an insight that you specify using its ID. </p>', 'ListEvents' => '<p> Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to specify which events are returned. </p>', 'ListInsights' => '<p> Returns a list of insights in your AWS account. You can specify which insights are returned by their start time and status (<code>ONGOING</code>, <code>CLOSED</code>, or <code>ANY</code>). </p>', 'ListNotificationChannels' => '<p> Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>', 'ListRecommendations' => '<p> Returns a list of a specified insight\'s recommendations. Each recommendation includes a list of related metrics and a list of related events. </p>', 'PutFeedback' => '<p> Collects customer feedback about the specified insight. </p>', 'RemoveNotificationChannel' => '<p> Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. </p>', 'SearchInsights' => '<p> Returns a list of insights in your AWS account. You can specify which insights are returned by their start time, one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p> <p> Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search. </p>', 'StartCostEstimation' => '<p>Starts the creation of an estimate of the monthly cost to analyze your AWS resources.</p>', 'UpdateResourceCollection' => '<p> Updates the collection of resources that DevOps Guru analyzes. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks. This method also creates the IAM role required for you to use DevOps Guru. </p>', 'UpdateServiceIntegration' => '<p> Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is AWS Systems Manager, which can be used to create an OpsItem for each generated insight. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p> You don\'t have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>', 'refs' => [], ], 'AddNotificationChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddNotificationChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'AnomalyId' => [ 'base' => NULL, 'refs' => [ 'DescribeAnomalyRequest$Id' => '<p> The ID of the anomaly. </p>', 'ProactiveAnomaly$Id' => '<p> The ID of a proactive anomaly. </p>', 'ProactiveAnomalySummary$Id' => '<p>The ID of the anomaly.</p>', 'ReactiveAnomaly$Id' => '<p>The ID of the reactive anomaly. </p>', 'ReactiveAnomalySummary$Id' => '<p> The ID of the reactive anomaly. </p>', ], ], 'AnomalyLimit' => [ 'base' => NULL, 'refs' => [ 'ProactiveAnomaly$Limit' => '<p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>', 'ProactiveAnomalySummary$Limit' => '<p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>', ], ], 'AnomalyReportedTimeRange' => [ 'base' => '<p> A time range that specifies when DevOps Guru opens and then closes an anomaly. This is different from <code>AnomalyTimeRange</code>, which specifies the time range when DevOps Guru actually observes the anomalous behavior. </p>', 'refs' => [ 'ProactiveAnomaly$AnomalyReportedTimeRange' => '<p> A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>', 'ProactiveAnomalySummary$AnomalyReportedTimeRange' => '<p> A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>', 'ReactiveAnomaly$AnomalyReportedTimeRange' => '<p> A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>', 'ReactiveAnomalySummary$AnomalyReportedTimeRange' => '<p> A <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>', ], ], 'AnomalySeverity' => [ 'base' => NULL, 'refs' => [ 'ProactiveAnomaly$Severity' => '<p> The severity of a proactive anomaly. </p>', 'ProactiveAnomalySummary$Severity' => '<p>The severity of the anomaly.</p>', 'ReactiveAnomaly$Severity' => '<p>The severity of the anomaly. </p>', 'ReactiveAnomalySummary$Severity' => '<p> The severity of the reactive anomaly. </p>', ], ], 'AnomalySourceDetails' => [ 'base' => '<p> Details about the source of the anomalous operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>', 'refs' => [ 'ProactiveAnomaly$SourceDetails' => '<p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>', 'ProactiveAnomalySummary$SourceDetails' => '<p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>', 'ReactiveAnomaly$SourceDetails' => '<p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>', 'ReactiveAnomalySummary$SourceDetails' => '<p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>', ], ], 'AnomalyStatus' => [ 'base' => NULL, 'refs' => [ 'ProactiveAnomaly$Status' => '<p> The status of a proactive anomaly. </p>', 'ProactiveAnomalySummary$Status' => '<p>The status of the anomaly.</p>', 'ReactiveAnomaly$Status' => '<p> The status of the anomaly. </p>', 'ReactiveAnomalySummary$Status' => '<p> The status of the reactive anomaly. </p>', ], ], 'AnomalyTimeRange' => [ 'base' => '<p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>', 'refs' => [ 'ProactiveAnomaly$AnomalyTimeRange' => NULL, 'ProactiveAnomalySummary$AnomalyTimeRange' => NULL, 'ReactiveAnomaly$AnomalyTimeRange' => NULL, 'ReactiveAnomalySummary$AnomalyTimeRange' => NULL, ], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'ListNotificationChannelsResponse$Channels' => '<p> An array that contains the requested notification channels. </p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'StartCostEstimationRequest$ClientToken' => '<p>The idempotency token used to identify each cost estimate request.</p>', ], ], 'CloudFormationCollection' => [ 'base' => '<p> Information about AWS CloudFormation stacks. You can use up to 500 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>AWS CloudFormation User Guide</i>. </p>', 'refs' => [ 'ResourceCollection$CloudFormation' => '<p> An array of the names of AWS CloudFormation stacks. The stacks define AWS resources that DevOps Guru analyzes. You can specify up to 500 AWS CloudFormation stacks. </p>', ], ], 'CloudFormationCollectionFilter' => [ 'base' => '<p> Information about AWS CloudFormation stacks. You can use up to 500 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>AWS CloudFormation User Guide</i>. </p>', 'refs' => [ 'ResourceCollectionFilter$CloudFormation' => '<p> Information about AWS CloudFormation stacks. You can use up to 500 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>AWS CloudFormation User Guide</i>. </p>', ], ], 'CloudFormationCostEstimationResourceCollectionFilter' => [ 'base' => '<p>Information about an AWS CloudFormation stack used to create a monthly cost estimate for DevOps Guru to analyze AWS resources. The maximum number of stacks you can specify for a cost estimate is one. The estimate created is for the cost to analyze the AWS resources defined by the stack. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'refs' => [ 'CostEstimationResourceCollectionFilter$CloudFormation' => '<p>An object that specifies the CloudFormation stack that defines the AWS resources used to create a monthly estimate for DevOps Guru.</p>', ], ], 'CloudFormationHealth' => [ 'base' => '<p> Information about the health of AWS resources in your account that are specified by an AWS CloudFormation stack. </p>', 'refs' => [ 'CloudFormationHealths$member' => NULL, ], ], 'CloudFormationHealths' => [ 'base' => NULL, 'refs' => [ 'DescribeResourceCollectionHealthResponse$CloudFormation' => '<p> The returned <code>CloudFormationHealthOverview</code> object that contains an <code>InsightHealthOverview</code> object with the requested system health information. </p>', ], ], 'CloudWatchMetricsDetail' => [ 'base' => '<p> Information about an Amazon CloudWatch metric. </p>', 'refs' => [ 'CloudWatchMetricsDetails$member' => NULL, ], ], 'CloudWatchMetricsDetails' => [ 'base' => NULL, 'refs' => [ 'AnomalySourceDetails$CloudWatchMetrics' => '<p> An array of <code>CloudWatchMetricsDetail</code> object that contains information about the analyzed metrics that displayed anomalous behavior. </p>', ], ], 'CloudWatchMetricsDimension' => [ 'base' => '<p> The dimension of a Amazon CloudWatch metric that is used when DevOps Guru analyzes the resources in your account for operational problems and anomalous behavior. A dimension is a name/value pair that is part of the identity of a metric. A metric can have up to 10 dimensions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension">Dimensions</a> in the <i>Amazon CloudWatch User Guide</i>. </p>', 'refs' => [ 'CloudWatchMetricsDimensions$member' => NULL, ], ], 'CloudWatchMetricsDimensionName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDimension$Name' => '<p> The name of the CloudWatch dimension. </p>', ], ], 'CloudWatchMetricsDimensionValue' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDimension$Value' => '<p> The value of the CloudWatch dimension. </p>', ], ], 'CloudWatchMetricsDimensions' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$Dimensions' => '<p> An array of CloudWatch dimensions associated with </p>', ], ], 'CloudWatchMetricsMetricName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$MetricName' => '<p> The name of the CloudWatch metric. </p>', ], ], 'CloudWatchMetricsNamespace' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$Namespace' => '<p> The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics. </p>', ], ], 'CloudWatchMetricsPeriod' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$Period' => '<p> The length of time associated with the CloudWatch metric in number of seconds. </p>', ], ], 'CloudWatchMetricsStat' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$Stat' => '<p> The type of statistic associated with the CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <i>Amazon CloudWatch User Guide</i>. </p>', ], ], 'CloudWatchMetricsUnit' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$Unit' => '<p> The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>, <code>Count</code>, and <code>Percent</code>. </p>', ], ], 'ConflictException' => [ 'base' => '<p> An exception that is thrown when a conflict occurs. </p>', 'refs' => [], ], 'Cost' => [ 'base' => NULL, 'refs' => [ 'GetCostEstimationResponse$TotalCost' => '<p>The estimated monthly cost to analyze the AWS resources. This value is the sum of the estimated costs to analyze each resource in the <code>Costs</code> object in this response.</p>', 'ServiceResourceCost$UnitCost' => '<p>The price per hour to analyze the resources in the service. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>', 'ServiceResourceCost$Cost' => '<p>The total estimated monthly cost to analyze the active resources for this resource.</p>', ], ], 'CostEstimationResourceCollectionFilter' => [ 'base' => '<p>Information about a filter used to specify which AWS resources are analyzed to create a monthly DevOps Guru cost estimate. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>. </p>', 'refs' => [ 'GetCostEstimationResponse$ResourceCollection' => '<p>The collection of the AWS resources used to create your monthly DevOps Guru cost estimate.</p>', 'StartCostEstimationRequest$ResourceCollection' => '<p>The collection of AWS resources used to create a monthly DevOps Guru cost estimate.</p>', ], ], 'CostEstimationServiceResourceCount' => [ 'base' => NULL, 'refs' => [ 'ServiceResourceCost$Count' => '<p>The number of active resources analyzed for this service to create a monthly cost estimate.</p>', ], ], 'CostEstimationServiceResourceState' => [ 'base' => NULL, 'refs' => [ 'ServiceResourceCost$State' => '<p>The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs within an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active AWS resource hours analyzed for each resource. Inactive resources are not charged. </p>', ], ], 'CostEstimationStackNames' => [ 'base' => NULL, 'refs' => [ 'CloudFormationCostEstimationResourceCollectionFilter$StackNames' => '<p>An array of CloudFormation stack names. Its size is fixed at 1 item.</p>', ], ], 'CostEstimationStatus' => [ 'base' => NULL, 'refs' => [ 'GetCostEstimationResponse$Status' => '<p>The status of creating this cost estimate. If it\'s still in progress, the status <code>ONGOING</code> is returned. If it is finished, the status <code>COMPLETED</code> is returned.</p>', ], ], 'CostEstimationTimeRange' => [ 'base' => '<p>The time range of a cost estimation.</p>', 'refs' => [ 'GetCostEstimationResponse$TimeRange' => '<p>The start and end time of the cost estimation.</p>', ], ], 'DescribeAccountHealthRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountHealthResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountOverviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountOverviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnomalyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnomalyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceCollectionHealthRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceCollectionHealthResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServiceIntegrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServiceIntegrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'EndTimeRange' => [ 'base' => '<p> A range of time that specifies when anomalous behavior in an anomaly or insight ended. </p>', 'refs' => [ 'ListInsightsClosedStatusFilter$EndTimeRange' => '<p> A time range used to specify when the behavior of the filtered insights ended. </p>', ], ], 'ErrorMessageString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => '<p> A message that describes the validation exception. </p>', 'ValidationExceptionField$Message' => '<p> The message associated with the validation exception with information to help determine its cause. </p>', ], ], 'ErrorNameString' => [ 'base' => NULL, 'refs' => [ 'ValidationExceptionField$Name' => '<p> The name of the field. </p>', ], ], 'ErrorQuotaCodeString' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$QuotaCode' => '<p> The code of the quota that was exceeded, causing the throttling exception. </p>', ], ], 'ErrorServiceCodeString' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$ServiceCode' => '<p> The code of the service that caused the throttling exception. </p>', ], ], 'Event' => [ 'base' => '<p> An AWS resource event. AWS resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and provide recommendations to improve your operational solutions. </p>', 'refs' => [ 'Events$member' => NULL, ], ], 'EventClass' => [ 'base' => NULL, 'refs' => [ 'Event$EventClass' => '<p> The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change. </p>', 'ListEventsFilters$EventClass' => '<p> The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change. </p>', ], ], 'EventDataSource' => [ 'base' => NULL, 'refs' => [ 'Event$DataSource' => '<p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the event. </p>', 'ListEventsFilters$DataSource' => '<p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned. </p>', ], ], 'EventId' => [ 'base' => NULL, 'refs' => [ 'Event$Id' => '<p> The ID of the event. </p>', ], ], 'EventName' => [ 'base' => NULL, 'refs' => [ 'Event$Name' => '<p> The name of the event. </p>', ], ], 'EventResource' => [ 'base' => '<p> The AWS resource that emitted an event. AWS resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and provide recommendations to improve your operational solutions. </p>', 'refs' => [ 'EventResources$member' => NULL, ], ], 'EventResourceArn' => [ 'base' => NULL, 'refs' => [ 'EventResource$Arn' => '<p> The Amazon Resource Name (ARN) of the resource that emitted an event. </p>', ], ], 'EventResourceName' => [ 'base' => NULL, 'refs' => [ 'EventResource$Name' => '<p> The name of the resource that emitted an event. </p>', ], ], 'EventResourceType' => [ 'base' => NULL, 'refs' => [ 'EventResource$Type' => '<p> The type of resource that emitted an event. </p>', ], ], 'EventResources' => [ 'base' => NULL, 'refs' => [ 'Event$Resources' => '<p> An <code>EventResource</code> object that contains information about the resource that emitted the event. </p>', ], ], 'EventSource' => [ 'base' => NULL, 'refs' => [ 'Event$EventSource' => '<p> The AWS source that emitted the event. </p>', 'ListEventsFilters$EventSource' => '<p> The AWS source that emitted the events you want to filter for. </p>', ], ], 'EventTimeRange' => [ 'base' => '<p> The time range during which an AWS event occurred. AWS resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and provide recommendations to improve your operational solutions. </p>', 'refs' => [ 'ListEventsFilters$EventTimeRange' => '<p> A time range during which you want the filtered events to have occurred. </p>', ], ], 'Events' => [ 'base' => NULL, 'refs' => [ 'ListEventsResponse$Events' => '<p> A list of the requested events. </p>', ], ], 'GetCostEstimationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCostEstimationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'InsightFeedback' => [ 'base' => '<p> Information about insight feedback received from a customer. </p>', 'refs' => [ 'DescribeFeedbackResponse$InsightFeedback' => NULL, 'PutFeedbackRequest$InsightFeedback' => '<p> The feedback from customers is about the recommendations in this insight. </p>', ], ], 'InsightFeedbackOption' => [ 'base' => NULL, 'refs' => [ 'InsightFeedback$Feedback' => '<p> The feedback provided by the customer. </p>', ], ], 'InsightHealth' => [ 'base' => '<p> Information about the number of open reactive and proactive insights that can be used to gauge the health of your system. </p>', 'refs' => [ 'CloudFormationHealth$Insight' => '<p> Information about the health of the AWS resources in your account that are specified by an AWS CloudFormation stack, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>', ], ], 'InsightId' => [ 'base' => NULL, 'refs' => [ 'DescribeFeedbackRequest$InsightId' => '<p> The ID of the insight for which the feedback was provided. </p>', 'DescribeInsightRequest$Id' => '<p> The ID of the insight. </p>', 'InsightFeedback$Id' => '<p> The insight feedback ID. </p>', 'ListAnomaliesForInsightRequest$InsightId' => '<p> The ID of the insight. The returned anomalies belong to this insight. </p>', 'ListEventsFilters$InsightId' => '<p> An ID of an insight that is related to the events you want to filter for. </p>', 'ListRecommendationsRequest$InsightId' => '<p> The ID of the requested insight. </p>', 'ProactiveAnomaly$AssociatedInsightId' => '<p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>', 'ProactiveAnomalySummary$AssociatedInsightId' => '<p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>', 'ProactiveInsight$Id' => '<p>The ID of the proactive insight. </p>', 'ProactiveInsightSummary$Id' => '<p>The ID of the proactive insight. </p>', 'ReactiveAnomaly$AssociatedInsightId' => '<p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>', 'ReactiveAnomalySummary$AssociatedInsightId' => '<p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>', 'ReactiveInsight$Id' => '<p> The ID of a reactive insight. </p>', 'ReactiveInsightSummary$Id' => '<p> The ID of a reactive summary. </p>', ], ], 'InsightName' => [ 'base' => NULL, 'refs' => [ 'ProactiveInsight$Name' => '<p>The name of the proactive insight. </p>', 'ProactiveInsightSummary$Name' => '<p>The name of the proactive insight. </p>', 'ReactiveInsight$Name' => '<p> The name of a reactive insight. </p>', 'ReactiveInsightSummary$Name' => '<p> The name of a reactive insight. </p>', ], ], 'InsightSeverities' => [ 'base' => NULL, 'refs' => [ 'SearchInsightsFilters$Severities' => '<p> An array of severity values used to search for insights. </p>', ], ], 'InsightSeverity' => [ 'base' => NULL, 'refs' => [ 'InsightSeverities$member' => NULL, 'ProactiveInsight$Severity' => '<p>The severity of the proactive insight. </p>', 'ProactiveInsightSummary$Severity' => '<p>The severity of the proactive insight. </p>', 'ReactiveInsight$Severity' => '<p> The severity of a reactive insight. </p>', 'ReactiveInsightSummary$Severity' => '<p> The severity of a reactive insight. </p>', ], ], 'InsightStatus' => [ 'base' => NULL, 'refs' => [ 'InsightStatuses$member' => NULL, 'ProactiveInsight$Status' => '<p>The status of the proactive insight. </p>', 'ProactiveInsightSummary$Status' => '<p>The status of the proactive insight. </p>', 'ReactiveInsight$Status' => '<p> The status of a reactive insight. </p>', 'ReactiveInsightSummary$Status' => '<p> The status of a reactive insight. </p>', ], ], 'InsightStatuses' => [ 'base' => NULL, 'refs' => [ 'SearchInsightsFilters$Statuses' => '<p> An array of status values used to search for insights. </p>', ], ], 'InsightTimeRange' => [ 'base' => '<p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>', 'refs' => [ 'ProactiveInsight$InsightTimeRange' => NULL, 'ProactiveInsightSummary$InsightTimeRange' => NULL, 'ReactiveInsight$InsightTimeRange' => NULL, 'ReactiveInsightSummary$InsightTimeRange' => NULL, ], ], 'InsightType' => [ 'base' => NULL, 'refs' => [ 'ListInsightsAnyStatusFilter$Type' => '<p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>', 'ListInsightsClosedStatusFilter$Type' => '<p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>', 'ListInsightsOngoingStatusFilter$Type' => '<p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>', 'SearchInsightsRequest$Type' => '<p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal failure in an Amazon service occurred.</p>', 'refs' => [], ], 'ListAnomaliesForInsightMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAnomaliesForInsightRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListAnomaliesForInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnomaliesForInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventsFilters' => [ 'base' => '<p> Filters you can use to specify which events are returned when <code>ListEvents</code> is called. </p>', 'refs' => [ 'ListEventsRequest$Filters' => '<p> A <code>ListEventsFilters</code> object used to specify which events to return. </p>', ], ], 'ListEventsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListEventsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInsightsAnyStatusFilter' => [ 'base' => '<p> Used to filter for insights that have any status. </p>', 'refs' => [ 'ListInsightsStatusFilter$Any' => '<p> A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>', ], ], 'ListInsightsClosedStatusFilter' => [ 'base' => '<p> Used to filter for insights that have the status <code>CLOSED</code>. </p>', 'refs' => [ 'ListInsightsStatusFilter$Closed' => '<p> A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>', ], ], 'ListInsightsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListInsightsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListInsightsOngoingStatusFilter' => [ 'base' => '<p> Used to filter for insights that have the status <code>ONGOING</code>. </p>', 'refs' => [ 'ListInsightsStatusFilter$Ongoing' => '<p> A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>', ], ], 'ListInsightsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInsightsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInsightsStatusFilter' => [ 'base' => '<p> A filter used by <code>ListInsights</code> to specify which insights to return. </p>', 'refs' => [ 'ListInsightsRequest$StatusFilter' => '<p> A filter used to filter the returned insights by their status. You can specify one status filter. </p>', ], ], 'ListNotificationChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNotificationChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Locale' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationsRequest$Locale' => '<p>A locale that specifies the language to use for recommendations.</p>', ], ], 'MeanTimeToRecoverInMilliseconds' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountOverviewResponse$MeanTimeToRecoverInMilliseconds' => '<p> The Mean Time to Recover (MTTR) for all closed insights that were created during the time range passed in. </p>', 'InsightHealth$MeanTimeToRecoverInMilliseconds' => '<p> The Meant Time to Recover (MTTR) for the insight. </p>', ], ], 'NotificationChannel' => [ 'base' => '<p> Information about a notification channel. A notification channel is used to notify you when DevOps Guru creates an insight. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p> <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p> <p>If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for AWS KMS–encrypted Amazon SNS topics</a>.</p>', 'refs' => [ 'Channels$member' => NULL, ], ], 'NotificationChannelConfig' => [ 'base' => '<p> Information about notification channels you have configured with DevOps Guru. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).</p>', 'refs' => [ 'AddNotificationChannelRequest$Config' => '<p> A <code>NotificationChannelConfig</code> object that specifies what type of notification channel to add. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>', 'NotificationChannel$Config' => '<p> A <code>NotificationChannelConfig</code> object that contains information about configured notification channels. </p>', ], ], 'NotificationChannelId' => [ 'base' => NULL, 'refs' => [ 'AddNotificationChannelResponse$Id' => '<p> The ID of the added notification channel. </p>', 'NotificationChannel$Id' => '<p> The ID of a notification channel. </p>', 'RemoveNotificationChannelRequest$Id' => '<p> The ID of the notification channel to be removed. </p>', ], ], 'NumMetricsAnalyzed' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountHealthResponse$MetricsAnalyzed' => '<p> An integer that specifies the number of metrics that have been analyzed in your AWS account. </p>', ], ], 'NumOpenProactiveInsights' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountHealthResponse$OpenProactiveInsights' => '<p> An integer that specifies the number of open proactive insights in your AWS account. </p>', 'InsightHealth$OpenProactiveInsights' => '<p> The number of open proactive insights. </p>', 'ServiceInsightHealth$OpenProactiveInsights' => '<p>The number of open proactive insights in the AWS service</p>', ], ], 'NumOpenReactiveInsights' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountHealthResponse$OpenReactiveInsights' => '<p> An integer that specifies the number of open reactive insights in your AWS account. </p>', 'InsightHealth$OpenReactiveInsights' => '<p> The number of open reactive insights. </p>', 'ServiceInsightHealth$OpenReactiveInsights' => '<p>The number of open reactive insights in the AWS service</p>', ], ], 'NumProactiveInsights' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountOverviewResponse$ProactiveInsights' => '<p> An integer that specifies the number of open proactive insights in your AWS account that were created during the time range passed in. </p>', ], ], 'NumReactiveInsights' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountOverviewResponse$ReactiveInsights' => '<p> An integer that specifies the number of open reactive insights in your AWS account that were created during the time range passed in. </p>', ], ], 'OpsCenterIntegration' => [ 'base' => '<p> Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. </p>', 'refs' => [ 'ServiceIntegrationConfig$OpsCenter' => '<p> Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. </p>', ], ], 'OpsCenterIntegrationConfig' => [ 'base' => '<p> Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. </p>', 'refs' => [ 'UpdateServiceIntegrationConfig$OpsCenter' => NULL, ], ], 'OptInStatus' => [ 'base' => '<p> Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight. </p>', 'refs' => [ 'OpsCenterIntegration$OptInStatus' => '<p> Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight. </p>', 'OpsCenterIntegrationConfig$OptInStatus' => '<p> Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight. </p>', ], ], 'PredictionTimeRange' => [ 'base' => '<p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>', 'refs' => [ 'ProactiveAnomaly$PredictionTimeRange' => NULL, 'ProactiveAnomalySummary$PredictionTimeRange' => NULL, 'ProactiveInsight$PredictionTimeRange' => NULL, 'ProactiveInsightSummary$PredictionTimeRange' => NULL, ], ], 'ProactiveAnomalies' => [ 'base' => NULL, 'refs' => [ 'ListAnomaliesForInsightResponse$ProactiveAnomalies' => '<p> An array of <code>ProactiveAnomalySummary</code> objects that represent the requested anomalies </p>', ], ], 'ProactiveAnomaly' => [ 'base' => '<p>Information about an anomaly. This object is returned by <code>ListAnomalies</code>.</p>', 'refs' => [ 'DescribeAnomalyResponse$ProactiveAnomaly' => '<p> A <code>ReactiveAnomaly</code> object that represents the requested anomaly. </p>', ], ], 'ProactiveAnomalySummary' => [ 'base' => '<p>Details about a proactive anomaly. This object is returned by <code>DescribeAnomaly.</code> </p>', 'refs' => [ 'ProactiveAnomalies$member' => NULL, ], ], 'ProactiveInsight' => [ 'base' => '<p>Details about a proactive insight. This object is returned by <code>ListInsights</code>.</p>', 'refs' => [ 'DescribeInsightResponse$ProactiveInsight' => '<p> A <code>ProactiveInsight</code> object that represents the requested insight. </p>', ], ], 'ProactiveInsightSummary' => [ 'base' => '<p>Details about a proactive insight. This object is returned by <code>DescribeInsight.</code> </p>', 'refs' => [ 'ProactiveInsights$member' => NULL, ], ], 'ProactiveInsights' => [ 'base' => NULL, 'refs' => [ 'ListInsightsResponse$ProactiveInsights' => '<p> The returned list of proactive insights. </p>', 'SearchInsightsResponse$ProactiveInsights' => '<p> The returned proactive insights. </p>', ], ], 'PutFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReactiveAnomalies' => [ 'base' => NULL, 'refs' => [ 'ListAnomaliesForInsightResponse$ReactiveAnomalies' => '<p> An array of <code>ReactiveAnomalySummary</code> objects that represent the requested anomalies </p>', ], ], 'ReactiveAnomaly' => [ 'base' => '<p>Details about a reactive anomaly. This object is returned by <code>ListAnomalies</code>.</p>', 'refs' => [ 'DescribeAnomalyResponse$ReactiveAnomaly' => '<p> A <code>ProactiveAnomaly</code> object that represents the requested anomaly. </p>', ], ], 'ReactiveAnomalySummary' => [ 'base' => '<p>Details about a reactive anomaly. This object is returned by <code>DescribeAnomaly.</code> </p>', 'refs' => [ 'ReactiveAnomalies$member' => NULL, ], ], 'ReactiveInsight' => [ 'base' => '<p> Information about a reactive insight. This object is returned by <code>ListInsights</code>. </p>', 'refs' => [ 'DescribeInsightResponse$ReactiveInsight' => '<p> A <code>ReactiveInsight</code> object that represents the requested insight. </p>', ], ], 'ReactiveInsightSummary' => [ 'base' => '<p> Information about a reactive insight. This object is returned by <code>DescribeInsight.</code> </p>', 'refs' => [ 'ReactiveInsights$member' => NULL, ], ], 'ReactiveInsights' => [ 'base' => NULL, 'refs' => [ 'ListInsightsResponse$ReactiveInsights' => '<p> The returned list of reactive insights. </p>', 'SearchInsightsResponse$ReactiveInsights' => '<p> The returned reactive insights. </p>', ], ], 'Recommendation' => [ 'base' => '<p> Recommendation information to help you remediate detected anomalous behavior that generated an insight. </p>', 'refs' => [ 'Recommendations$member' => NULL, ], ], 'RecommendationDescription' => [ 'base' => NULL, 'refs' => [ 'Recommendation$Description' => '<p> A description of the problem. </p>', ], ], 'RecommendationLink' => [ 'base' => NULL, 'refs' => [ 'Recommendation$Link' => '<p> A hyperlink to information to help you address the problem. </p>', ], ], 'RecommendationName' => [ 'base' => NULL, 'refs' => [ 'Recommendation$Name' => '<p> The name of the recommendation. </p>', ], ], 'RecommendationReason' => [ 'base' => NULL, 'refs' => [ 'Recommendation$Reason' => '<p> The reason DevOps Guru flagged the anomalous behavior as a problem. </p>', ], ], 'RecommendationRelatedAnomalies' => [ 'base' => NULL, 'refs' => [ 'Recommendation$RelatedAnomalies' => '<p> Anomalies that are related to the problem. Use these Anomalies to learn more about what\'s happening and to help address the issue. </p>', ], ], 'RecommendationRelatedAnomaly' => [ 'base' => '<p> Information about an anomaly that is related to a recommendation. </p>', 'refs' => [ 'RecommendationRelatedAnomalies$member' => NULL, ], ], 'RecommendationRelatedAnomalyResource' => [ 'base' => '<p> Information about a resource in which DevOps Guru detected anomalous behavior. </p>', 'refs' => [ 'RecommendationRelatedAnomalyResources$member' => NULL, ], ], 'RecommendationRelatedAnomalyResourceName' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedAnomalyResource$Name' => '<p> The name of the resource. </p>', ], ], 'RecommendationRelatedAnomalyResourceType' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedAnomalyResource$Type' => '<p> The type of the resource. </p>', ], ], 'RecommendationRelatedAnomalyResources' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedAnomaly$Resources' => '<p> An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name and type of the resource. </p>', ], ], 'RecommendationRelatedAnomalySourceDetail' => [ 'base' => '<p> Contains an array of <code>RecommendationRelatedCloudWatchMetricsSourceDetail</code> objects that contain the name and namespace of an Amazon CloudWatch metric. </p>', 'refs' => [ 'RelatedAnomalySourceDetails$member' => NULL, ], ], 'RecommendationRelatedCloudWatchMetricsSourceDetail' => [ 'base' => '<p> Information about an Amazon CloudWatch metric that is analyzed by DevOps Guru. It is one of many analyzed metrics that are used to generate insights. </p>', 'refs' => [ 'RecommendationRelatedCloudWatchMetricsSourceDetails$member' => NULL, ], ], 'RecommendationRelatedCloudWatchMetricsSourceDetails' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedAnomalySourceDetail$CloudWatchMetrics' => '<p> An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed metrics that displayed anomalous behavior. </p>', ], ], 'RecommendationRelatedCloudWatchMetricsSourceMetricName' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedCloudWatchMetricsSourceDetail$MetricName' => '<p>The name of the CloudWatch metric.</p>', ], ], 'RecommendationRelatedCloudWatchMetricsSourceNamespace' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedCloudWatchMetricsSourceDetail$Namespace' => '<p>The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.</p>', ], ], 'RecommendationRelatedEvent' => [ 'base' => '<p> Information about an event that is related to a recommendation. </p>', 'refs' => [ 'RecommendationRelatedEvents$member' => NULL, ], ], 'RecommendationRelatedEventName' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedEvent$Name' => '<p> The name of the event. This corresponds to the <code>Name</code> field in an <code>Event</code> object. </p>', ], ], 'RecommendationRelatedEventResource' => [ 'base' => '<p> Information about an AWS resource that emitted and event that is related to a recommendation in an insight. </p>', 'refs' => [ 'RecommendationRelatedEventResources$member' => NULL, ], ], 'RecommendationRelatedEventResourceName' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedEventResource$Name' => '<p> The name of the resource that emitted the event. This corresponds to the <code>Name</code> field in an <code>EventResource</code> object. </p>', ], ], 'RecommendationRelatedEventResourceType' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedEventResource$Type' => '<p> The type of the resource that emitted the event. This corresponds to the <code>Type</code> field in an <code>EventResource</code> object. </p>', ], ], 'RecommendationRelatedEventResources' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedEvent$Resources' => '<p> A <code>ResourceCollection</code> object that contains arrays of the names of AWS CloudFormation stacks. You can specify up to 500 AWS CloudFormation stacks. </p>', ], ], 'RecommendationRelatedEvents' => [ 'base' => NULL, 'refs' => [ 'Recommendation$RelatedEvents' => '<p> Events that are related to the problem. Use these events to learn more about what\'s happening and to help address the issue. </p>', ], ], 'Recommendations' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationsResponse$Recommendations' => '<p> An array of the requested recommendations. </p>', ], ], 'RelatedAnomalySourceDetails' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedAnomaly$SourceDetails' => '<p> Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics. </p>', ], ], 'RemoveNotificationChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveNotificationChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceCollection' => [ 'base' => '<p> A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks. </p>', 'refs' => [ 'Event$ResourceCollection' => NULL, 'ListEventsFilters$ResourceCollection' => NULL, 'ProactiveAnomaly$ResourceCollection' => NULL, 'ProactiveAnomalySummary$ResourceCollection' => NULL, 'ProactiveInsight$ResourceCollection' => NULL, 'ProactiveInsightSummary$ResourceCollection' => NULL, 'ReactiveAnomaly$ResourceCollection' => NULL, 'ReactiveAnomalySummary$ResourceCollection' => NULL, 'ReactiveInsight$ResourceCollection' => NULL, 'ReactiveInsightSummary$ResourceCollection' => NULL, 'SearchInsightsFilters$ResourceCollection' => NULL, ], ], 'ResourceCollectionFilter' => [ 'base' => '<p> Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru. </p>', 'refs' => [ 'GetResourceCollectionResponse$ResourceCollection' => '<p> The requested list of AWS resource collections. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks. </p>', ], ], 'ResourceCollectionType' => [ 'base' => NULL, 'refs' => [ 'DescribeResourceCollectionHealthRequest$ResourceCollectionType' => '<p> An AWS resource collection type. This type specifies how analyzed AWS resources are defined. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the stacks. You can specify up to 500 AWS CloudFormation stacks. </p>', 'GetResourceCollectionRequest$ResourceCollectionType' => '<p> The type of AWS resource collections to return. The one valid value is <code>CLOUD_FORMATION</code> for AWS CloudFormation stacks. </p>', ], ], 'ResourceHours' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountHealthResponse$ResourceHours' => '<p>The number of Amazon DevOps Guru resource analysis hours billed to the current AWS account in the last hour. </p>', ], ], 'ResourceIdString' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceId' => '<p> The ID of the AWS resource in which a conflict occurred. </p>', 'ResourceNotFoundException$ResourceId' => '<p> The ID of the AWS resource that could not be found. </p>', ], ], 'ResourceIdType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceType' => '<p> The type of the AWS resource in which a conflict occurred. </p>', 'ResourceNotFoundException$ResourceType' => '<p> The type of the AWS resource that could not be found. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A requested resource could not be found</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ServiceResourceCost$Type' => '<p>The type of the AWS resource.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$RetryAfterSeconds' => '<p> The number of seconds after which the action that caused the internal server exception can be retried. </p>', 'ThrottlingException$RetryAfterSeconds' => '<p> The number of seconds after which the action that caused the throttling exception can be retried. </p>', ], ], 'SearchInsightsFilters' => [ 'base' => '<p> Specifies one or more severity values and one or more status values that are used to search for insights. </p>', 'refs' => [ 'SearchInsightsRequest$Filters' => '<p> A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>', ], ], 'SearchInsightsMaxResults' => [ 'base' => NULL, 'refs' => [ 'SearchInsightsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'SearchInsightsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchInsightsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServiceCollection' => [ 'base' => '<p>A collection of the names of AWS services.</p>', 'refs' => [ 'ProactiveInsightSummary$ServiceCollection' => '<p>A collection of the names of AWS services.</p>', 'ReactiveInsightSummary$ServiceCollection' => '<p>A collection of the names of AWS services.</p>', 'SearchInsightsFilters$ServiceCollection' => '<p>A collection of the names of AWS services.</p>', ], ], 'ServiceHealth' => [ 'base' => '<p>Represents the health of an AWS service.</p>', 'refs' => [ 'ServiceHealths$member' => NULL, ], ], 'ServiceHealths' => [ 'base' => NULL, 'refs' => [ 'DescribeResourceCollectionHealthResponse$Service' => '<p>An array of <code>ServiceHealth</code> objects that describes the health of the AWS services associated with the resources in the collection.</p>', ], ], 'ServiceInsightHealth' => [ 'base' => '<p>Contains the number of open proactive and reactive insights in an analyzed AWS service.</p>', 'refs' => [ 'ServiceHealth$Insight' => '<p>Represents the health of an AWS service. This is a <code>ServiceInsightHealth</code> that contains the number of open proactive and reactive insights for this service.</p>', ], ], 'ServiceIntegrationConfig' => [ 'base' => '<p> Information about the integration of DevOps Guru with another AWS service, such as AWS Systems Manager. </p>', 'refs' => [ 'DescribeServiceIntegrationResponse$ServiceIntegration' => NULL, ], ], 'ServiceName' => [ 'base' => NULL, 'refs' => [ 'ServiceHealth$ServiceName' => '<p>The name of the AWS service.</p>', 'ServiceNames$member' => NULL, ], ], 'ServiceNames' => [ 'base' => NULL, 'refs' => [ 'ServiceCollection$ServiceNames' => '<p>An array of strings that each specifies the name of an AWS service.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request contains a value that exceeds a maximum quota.</p>', 'refs' => [], ], 'ServiceResourceCost' => [ 'base' => '<p>An object that contains information about the estimated monthly cost to analyze an AWS resource. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>', 'refs' => [ 'ServiceResourceCosts$member' => NULL, ], ], 'ServiceResourceCosts' => [ 'base' => NULL, 'refs' => [ 'GetCostEstimationResponse$Costs' => '<p>An array of <code>ResourceCost</code> objects that each contains details about the monthly cost estimate to analyze one of your AWS resources.</p>', ], ], 'SnsChannelConfig' => [ 'base' => '<p> Contains the Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p> <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p> <p>If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for AWS KMS–encrypted Amazon SNS topics</a>.</p>', 'refs' => [ 'NotificationChannelConfig$Sns' => '<p> Information about a notification channel configured in DevOps Guru to send notifications when insights are created. </p> <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p> <p>If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for AWS KMS–encrypted Amazon SNS topics</a>.</p>', ], ], 'SsmOpsItemId' => [ 'base' => NULL, 'refs' => [ 'ProactiveInsight$SsmOpsItemId' => '<p> The ID of the AWS System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>', 'ReactiveInsight$SsmOpsItemId' => '<p> The ID of the AWS System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>', ], ], 'StackName' => [ 'base' => NULL, 'refs' => [ 'CloudFormationHealth$StackName' => '<p> The name of the CloudFormation stack. </p>', 'CostEstimationStackNames$member' => NULL, 'StackNames$member' => NULL, 'UpdateStackNames$member' => NULL, ], ], 'StackNames' => [ 'base' => NULL, 'refs' => [ 'CloudFormationCollection$StackNames' => '<p> An array of CloudFormation stack names. </p>', 'CloudFormationCollectionFilter$StackNames' => '<p> An array of CloudFormation stack names. </p>', ], ], 'StartCostEstimationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCostEstimationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTimeRange' => [ 'base' => '<p> A time range used to specify when the behavior of an insight or anomaly started. </p>', 'refs' => [ 'ListAnomaliesForInsightRequest$StartTimeRange' => '<p> A time range used to specify when the requested anomalies started. All returned anomalies started during this time range. </p>', 'ListInsightsAnyStatusFilter$StartTimeRange' => '<p> A time range used to specify when the behavior of the filtered insights started. </p>', 'SearchInsightsRequest$StartTimeRange' => '<p> The start of the time range passed in. Returned insights occurred after this time. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to a request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AnomalyReportedTimeRange$OpenTime' => '<p> The time when an anomaly is opened. </p>', 'AnomalyReportedTimeRange$CloseTime' => '<p> The time when an anomaly is closed. </p>', 'AnomalyTimeRange$StartTime' => '<p> The time when the anomalous behavior started. </p>', 'AnomalyTimeRange$EndTime' => '<p> The time when the anomalous behavior ended. </p>', 'CostEstimationTimeRange$StartTime' => '<p>The start time of the cost estimation.</p>', 'CostEstimationTimeRange$EndTime' => '<p>The end time of the cost estimation.</p>', 'DescribeAccountOverviewRequest$FromTime' => '<p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>', 'DescribeAccountOverviewRequest$ToTime' => '<p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>', 'EndTimeRange$FromTime' => '<p> The earliest end time in the time range. </p>', 'EndTimeRange$ToTime' => '<p> The latest end time in the time range. </p>', 'Event$Time' => '<p> A <code>Timestamp</code> that specifies the time the event occurred. </p>', 'EventTimeRange$FromTime' => '<p> The time when the event started. </p>', 'EventTimeRange$ToTime' => '<p> The time when the event ended. </p>', 'InsightTimeRange$StartTime' => '<p> The time when the behavior described in an insight started. </p>', 'InsightTimeRange$EndTime' => '<p> The time when the behavior described in an insight ended. </p>', 'PredictionTimeRange$StartTime' => '<p> The time range during which a metric limit is expected to be exceeded. This applies to proactive insights only. </p>', 'PredictionTimeRange$EndTime' => '<p> The time when the behavior in a proactive insight is expected to end. </p>', 'ProactiveAnomaly$UpdateTime' => '<p> The time of the anomaly\'s most recent update. </p>', 'ProactiveAnomalySummary$UpdateTime' => '<p> The time of the anomaly\'s most recent update. </p>', 'StartTimeRange$FromTime' => '<p> The start time of the time range. </p>', 'StartTimeRange$ToTime' => '<p> The end time of the time range. </p>', ], ], 'TopicArn' => [ 'base' => NULL, 'refs' => [ 'SnsChannelConfig$TopicArn' => '<p> The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>', ], ], 'UpdateCloudFormationCollectionFilter' => [ 'base' => '<p> Contains the names of AWS CloudFormation stacks used to update a collection of stacks. You can specify up to 500 AWS CloudFormation stacks.</p>', 'refs' => [ 'UpdateResourceCollectionFilter$CloudFormation' => '<p> An collection of AWS CloudFormation stacks. You can specify up to 500 AWS CloudFormation stacks. </p>', ], ], 'UpdateResourceCollectionAction' => [ 'base' => NULL, 'refs' => [ 'UpdateResourceCollectionRequest$Action' => '<p> Specifies if the resource collection in the request is added or deleted to the resource collection. </p>', ], ], 'UpdateResourceCollectionFilter' => [ 'base' => '<p> Contains information used to update a collection of AWS resources. </p>', 'refs' => [ 'UpdateResourceCollectionRequest$ResourceCollection' => NULL, ], ], 'UpdateResourceCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceIntegrationConfig' => [ 'base' => '<p> Information about updating the integration status of an AWS service, such as AWS Systems Manager, with DevOps Guru. </p>', 'refs' => [ 'UpdateServiceIntegrationRequest$ServiceIntegration' => '<p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and whether you want to update it to enabled or disabled. </p>', ], ], 'UpdateServiceIntegrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceIntegrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackNames' => [ 'base' => NULL, 'refs' => [ 'UpdateCloudFormationCollectionFilter$StackNames' => '<p> An array of the names of the AWS CloudFormation stacks to update. You can specify up to 500 AWS CloudFormation stacks. </p>', ], ], 'UuidNextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeResourceCollectionHealthRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeResourceCollectionHealthResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'GetCostEstimationRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'GetCostEstimationResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'GetResourceCollectionRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'GetResourceCollectionResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListAnomaliesForInsightRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListAnomaliesForInsightResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListEventsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListEventsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListInsightsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListInsightsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListNotificationChannelsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListNotificationChannelsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListRecommendationsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListRecommendationsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'SearchInsightsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'SearchInsightsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', ], ], 'ValidationException' => [ 'base' => '<p> Contains information about data passed in to a field during a request that is not valid. </p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p> The field associated with the validation exception. </p>', 'refs' => [ 'ValidationExceptionFields$member' => NULL, ], ], 'ValidationExceptionFields' => [ 'base' => '<p> An array of fields that are associated with the validation exception. </p>', 'refs' => [ 'ValidationException$Fields' => NULL, ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p> The reason the validation exception was thrown. </p>', ], ], ],];
