<?php
// This file was auto-generated from sdk-root/src/data/appstream/2016-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon AppStream 2.0</fullname> <p>This is the <i>Amazon AppStream 2.0 API Reference</i>. This documentation provides descriptions and syntax for each of the actions and data types in AppStream 2.0. AppStream 2.0 is a fully managed, secure application streaming service that lets you stream desktop applications to users without rewriting applications. AppStream 2.0 manages the AWS resources that are required to host and run your applications, scales automatically, and provides access to your users on demand. </p> <note> <p>You can call the AppStream 2.0 API operations by using an interface VPC endpoint (interface endpoint). For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/access-api-cli-through-interface-vpc-endpoint.html">Access AppStream 2.0 API Operations and CLI Commands Through an Interface VPC Endpoint</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p> </note> <p>To learn more about AppStream 2.0, see the following resources:</p> <ul> <li> <p> <a href="http://aws.amazon.com/appstream2">Amazon AppStream 2.0 product page</a> </p> </li> <li> <p> <a href="http://aws.amazon.com/documentation/appstream2">Amazon AppStream 2.0 documentation</a> </p> </li> </ul>', 'operations' => [ 'AssociateFleet' => '<p>Associates the specified fleet with the specified stack.</p>', 'BatchAssociateUserStack' => '<p>Associates the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with fleets that are joined to an Active Directory domain.</p>', 'BatchDisassociateUserStack' => '<p>Disassociates the specified users from the specified stacks.</p>', 'CopyImage' => '<p>Copies the image within the same region or to a new region within the same AWS account. Note that any tags you added to the image will not be copied.</p>', 'CreateDirectoryConfig' => '<p>Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.</p>', 'CreateFleet' => '<p>Creates a fleet. A fleet consists of streaming instances that run a specified image.</p>', 'CreateImageBuilder' => '<p>Creates an image builder. An image builder is a virtual machine that is used to create an image.</p> <p>The initial state of the builder is <code>PENDING</code>. When it is ready, the state is <code>RUNNING</code>.</p>', 'CreateImageBuilderStreamingURL' => '<p>Creates a URL to start an image builder streaming session.</p>', 'CreateStack' => '<p>Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access policies, and storage configurations. </p>', 'CreateStreamingURL' => '<p>Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL enables application streaming to be tested without user setup. </p>', 'CreateUpdatedImage' => '<p>Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent software.</p> <p>For more information, see the "Update an Image by Using Managed AppStream 2.0 Image Updates" section in <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/administer-images.html">Administer Your AppStream 2.0 Images</a>, in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'CreateUsageReportSubscription' => '<p>Creates a usage report subscription. Usage reports are generated daily.</p>', 'CreateUser' => '<p>Creates a new user in the user pool.</p>', 'DeleteDirectoryConfig' => '<p>Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required to join streaming instances to an Active Directory domain.</p>', 'DeleteFleet' => '<p>Deletes the specified fleet.</p>', 'DeleteImage' => '<p>Deletes the specified image. You cannot delete an image when it is in use. After you delete an image, you cannot provision new capacity using the image.</p>', 'DeleteImageBuilder' => '<p>Deletes the specified image builder and releases the capacity.</p>', 'DeleteImagePermissions' => '<p>Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to which you previously granted these permissions can no longer use the image.</p>', 'DeleteStack' => '<p>Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the stack is no longer available to users. Also, any reservations made for application streaming sessions for the stack are released.</p>', 'DeleteUsageReportSubscription' => '<p>Disables usage report generation.</p>', 'DeleteUser' => '<p>Deletes a user from the user pool.</p>', 'DescribeDirectoryConfigs' => '<p>Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names for these objects are provided. Otherwise, all Directory Config objects in the account are described. These objects include the configuration information required to join fleets and image builders to Microsoft Active Directory domains. </p> <p>Although the response syntax in this topic includes the account password, this password is not returned in the actual response.</p>', 'DescribeFleets' => '<p>Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all fleets in the account are described.</p>', 'DescribeImageBuilders' => '<p>Retrieves a list that describes one or more specified image builders, if the image builder names are provided. Otherwise, all image builders in the account are described.</p>', 'DescribeImagePermissions' => '<p>Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own. </p>', 'DescribeImages' => '<p>Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided. Otherwise, all images in the account are described.</p>', 'DescribeSessions' => '<p>Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not provided, the default is to authenticate users using a streaming URL.</p>', 'DescribeStacks' => '<p>Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all stacks in the account are described.</p>', 'DescribeUsageReportSubscriptions' => '<p>Retrieves a list that describes one or more usage report subscriptions.</p>', 'DescribeUserStackAssociations' => '<p>Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the following:</p> <ul> <li> <p>The stack name</p> </li> <li> <p>The user name (email address of the user associated with the stack) and the authentication type for the user</p> </li> </ul>', 'DescribeUsers' => '<p>Retrieves a list that describes one or more specified users in the user pool.</p>', 'DisableUser' => '<p>Disables the specified user in the user pool. Users can\'t sign in to AppStream 2.0 until they are re-enabled. This action does not delete the user. </p>', 'DisassociateFleet' => '<p>Disassociates the specified fleet from the specified stack.</p>', 'EnableUser' => '<p>Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications from the stacks to which they are assigned.</p>', 'ExpireSession' => '<p>Immediately stops the specified streaming session.</p>', 'ListAssociatedFleets' => '<p>Retrieves the name of the fleet that is associated with the specified stack.</p>', 'ListAssociatedStacks' => '<p>Retrieves the name of the stack with which the specified fleet is associated.</p>', 'ListTagsForResource' => '<p>Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'StartFleet' => '<p>Starts the specified fleet.</p>', 'StartImageBuilder' => '<p>Starts the specified image builder.</p>', 'StopFleet' => '<p>Stops the specified fleet.</p>', 'StopImageBuilder' => '<p>Stops the specified image builder.</p>', 'TagResource' => '<p>Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.</p> <p>Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.</p> <p>To list the current tags for your resources, use <a>ListTagsForResource</a>. To disassociate tags from your resources, use <a>UntagResource</a>.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'UntagResource' => '<p>Disassociates one or more specified tags from the specified AppStream 2.0 resource.</p> <p>To list the current tags for your resources, use <a>ListTagsForResource</a>.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'UpdateDirectoryConfig' => '<p>Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.</p>', 'UpdateFleet' => '<p>Updates the specified fleet.</p> <p>If the fleet is in the <code>STOPPED</code> state, you can update any attribute except the fleet name. If the fleet is in the <code>RUNNING</code> state, you can update the <code>DisplayName</code>, <code>ComputeCapacity</code>, <code>ImageARN</code>, <code>ImageName</code>, <code>IdleDisconnectTimeoutInSeconds</code>, and <code>DisconnectTimeoutInSeconds</code> attributes. If the fleet is in the <code>STARTING</code> or <code>STOPPING</code> state, you can\'t update it.</p>', 'UpdateImagePermissions' => '<p>Adds or updates permissions for the specified private image. </p>', 'UpdateStack' => '<p>Updates the specified fields for the specified stack.</p>', ], 'shapes' => [ 'AccessEndpoint' => [ 'base' => '<p>Describes an interface VPC endpoint (interface endpoint) that lets you create a private connection between the virtual private cloud (VPC) that you specify and AppStream 2.0. When you specify an interface endpoint for a stack, users of the stack can connect to AppStream 2.0 only through that endpoint. When you specify an interface endpoint for an image builder, administrators can connect to the image builder only through that endpoint.</p>', 'refs' => [ 'AccessEndpointList$member' => NULL, ], ], 'AccessEndpointList' => [ 'base' => NULL, 'refs' => [ 'CreateImageBuilderRequest$AccessEndpoints' => '<p>The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.</p>', 'CreateStackRequest$AccessEndpoints' => '<p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>', 'ImageBuilder$AccessEndpoints' => '<p>The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.</p>', 'Stack$AccessEndpoints' => '<p>The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints. </p>', 'UpdateStackRequest$AccessEndpoints' => '<p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>', ], ], 'AccessEndpointType' => [ 'base' => NULL, 'refs' => [ 'AccessEndpoint$EndpointType' => '<p>The type of interface endpoint.</p>', ], ], 'AccountName' => [ 'base' => NULL, 'refs' => [ 'ServiceAccountCredentials$AccountName' => '<p>The user name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.</p>', ], ], 'AccountPassword' => [ 'base' => NULL, 'refs' => [ 'ServiceAccountCredentials$AccountPassword' => '<p>The password for the account.</p>', ], ], 'Action' => [ 'base' => NULL, 'refs' => [ 'UserSetting$Action' => '<p>The action that is enabled or disabled.</p>', ], ], 'Application' => [ 'base' => '<p>Describes an application in the application catalog.</p>', 'refs' => [ 'Applications$member' => NULL, ], ], 'ApplicationSettings' => [ 'base' => '<p>The persistent application settings for users of a stack.</p>', 'refs' => [ 'CreateStackRequest$ApplicationSettings' => '<p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>', 'UpdateStackRequest$ApplicationSettings' => '<p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>', ], ], 'ApplicationSettingsResponse' => [ 'base' => '<p>Describes the persistent application settings for users of a stack.</p>', 'refs' => [ 'Stack$ApplicationSettings' => '<p>The persistent application settings for users of the stack.</p>', ], ], 'Applications' => [ 'base' => NULL, 'refs' => [ 'Image$Applications' => '<p>The applications associated with the image.</p>', ], ], 'AppstreamAgentVersion' => [ 'base' => NULL, 'refs' => [ 'CreateImageBuilderRequest$AppstreamAgentVersion' => '<p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>', 'Image$AppstreamAgentVersion' => '<p>The version of the AppStream 2.0 agent to use for instances that are launched from this image. </p>', 'ImageBuilder$AppstreamAgentVersion' => '<p>The version of the AppStream 2.0 agent that is currently being used by the image builder. </p>', 'StartImageBuilderRequest$AppstreamAgentVersion' => '<p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ArnList$member' => NULL, 'CreateFleetRequest$ImageArn' => '<p>The ARN of the public, private, or shared image to use.</p>', 'CreateFleetRequest$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'CreateImageBuilderRequest$ImageArn' => '<p>The ARN of the public, private, or shared image to use.</p>', 'CreateImageBuilderRequest$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'Fleet$Arn' => '<p>The Amazon Resource Name (ARN) for the fleet.</p>', 'Fleet$ImageArn' => '<p>The ARN for the public, private, or shared image.</p>', 'Fleet$IamRoleArn' => '<p>The ARN of the IAM role that is applied to the fleet. To assume a role, the fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'Image$Arn' => '<p>The ARN of the image.</p>', 'Image$BaseImageArn' => '<p>The ARN of the image from which this image was created.</p>', 'ImageBuilder$Arn' => '<p>The ARN for the image builder.</p>', 'ImageBuilder$ImageArn' => '<p>The ARN of the image from which this builder was created.</p>', 'ImageBuilder$IamRoleArn' => '<p>The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'Stack$Arn' => '<p>The ARN of the stack.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UpdateFleetRequest$ImageArn' => '<p>The ARN of the public, private, or shared image to use.</p>', 'UpdateFleetRequest$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'User$Arn' => '<p>The ARN of the user.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesRequest$Arns' => '<p>The ARNs of the public, private, and shared images to describe.</p>', ], ], 'AssociateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'AuthenticationType' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$AuthenticationType' => '<p>The authentication type for the user. You must specify USERPOOL. </p>', 'DeleteUserRequest$AuthenticationType' => '<p>The authentication type for the user. You must specify USERPOOL.</p>', 'DescribeSessionsRequest$AuthenticationType' => '<p>The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.</p>', 'DescribeUserStackAssociationsRequest$AuthenticationType' => '<p>The authentication type for the user who is associated with the stack. You must specify USERPOOL.</p>', 'DescribeUsersRequest$AuthenticationType' => '<p>The authentication type for the users in the user pool to describe. You must specify USERPOOL.</p>', 'DisableUserRequest$AuthenticationType' => '<p>The authentication type for the user. You must specify USERPOOL.</p>', 'EnableUserRequest$AuthenticationType' => '<p>The authentication type for the user. You must specify USERPOOL.</p>', 'Session$AuthenticationType' => '<p>The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML 2.0 federation (<code>SAML</code>).</p>', 'User$AuthenticationType' => '<p>The authentication type for the user.</p>', 'UserStackAssociation$AuthenticationType' => '<p>The authentication type for the user.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'AwsAccountIdList$member' => NULL, 'DeleteImagePermissionsRequest$SharedAccountId' => '<p>The 12-digit identifier of the AWS account for which to delete image permissions.</p>', 'SharedImagePermissions$sharedAccountId' => '<p>The 12-digit identifier of the AWS account with which the image is shared.</p>', 'UpdateImagePermissionsRequest$SharedAccountId' => '<p>The 12-digit identifier of the AWS account for which you want add or update image permissions.</p>', ], ], 'AwsAccountIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagePermissionsRequest$SharedAwsAccountIds' => '<p>The 12-digit identifier of one or more AWS accounts with which the image is shared.</p>', ], ], 'BatchAssociateUserStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchAssociateUserStackResult' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateUserStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateUserStackResult' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Application$Enabled' => '<p>If there is a problem, the application can be disabled after image creation.</p>', 'ApplicationSettings$Enabled' => '<p>Enables or disables persistent application settings for users during their streaming sessions. </p>', 'ApplicationSettingsResponse$Enabled' => '<p>Specifies whether persistent application settings are enabled for users during their streaming sessions.</p>', 'CreateUpdatedImageRequest$dryRun' => '<p>Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available.</p>', 'CreateUpdatedImageResult$canUpdateImage' => '<p>Indicates whether a new image can be created.</p>', 'Image$ImageBuilderSupported' => '<p>Indicates whether an image builder can be launched from this image.</p>', 'UpdateFleetRequest$DeleteVpcConfig' => '<p>Deletes the VPC association for the specified fleet.</p>', 'UpdateStackRequest$DeleteStorageConnectors' => '<p>Deletes the storage connectors currently enabled for the stack.</p>', 'User$Enabled' => '<p>Specifies whether the user in the user pool is enabled.</p>', 'UserStackAssociation$SendEmailNotification' => '<p>Specifies whether a welcome email is sent to a user after the user is created in the user pool.</p>', ], ], 'BooleanObject' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$EnableDefaultInternetAccess' => '<p>Enables or disables default internet access for the fleet.</p>', 'CreateImageBuilderRequest$EnableDefaultInternetAccess' => '<p>Enables or disables default internet access for the image builder.</p>', 'Fleet$EnableDefaultInternetAccess' => '<p>Indicates whether default internet access is enabled for the fleet.</p>', 'ImageBuilder$EnableDefaultInternetAccess' => '<p>Enables or disables default internet access for the image builder.</p>', 'ImagePermissions$allowFleet' => '<p>Indicates whether the image can be used for a fleet.</p>', 'ImagePermissions$allowImageBuilder' => '<p>Indicates whether the image can be used for an image builder.</p>', 'UpdateFleetRequest$EnableDefaultInternetAccess' => '<p>Enables or disables default internet access for the fleet.</p>', ], ], 'ComputeCapacity' => [ 'base' => '<p>Describes the capacity for a fleet.</p>', 'refs' => [ 'CreateFleetRequest$ComputeCapacity' => '<p>The desired capacity for the fleet.</p>', 'UpdateFleetRequest$ComputeCapacity' => '<p>The desired capacity for the fleet.</p>', ], ], 'ComputeCapacityStatus' => [ 'base' => '<p>Describes the capacity status for a fleet.</p>', 'refs' => [ 'Fleet$ComputeCapacityStatus' => '<p>The capacity status for the fleet.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>An API error occurred. Wait a few minutes and try again.</p>', 'refs' => [], ], 'CopyImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopyImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDirectoryConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDirectoryConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageBuilderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageBuilderResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageBuilderStreamingURLRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageBuilderStreamingURLResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingURLRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingURLResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateUpdatedImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUpdatedImageResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateUsageReportSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUsageReportSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDirectoryConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDirectoryConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageBuilderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageBuilderResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImagePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImagePermissionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUsageReportSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUsageReportSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDirectoryConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDirectoryConfigsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageBuildersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageBuildersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagePermissionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesRequest$MaxResults' => '<p>The maximum size of each page of results.</p>', ], ], 'DescribeImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSessionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStacksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStacksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUsageReportSubscriptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUsageReportSubscriptionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserStackAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserStackAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUsersResult' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CopyImageRequest$DestinationImageDescription' => '<p>The description that the image will have when it is copied to the destination.</p>', 'CreateFleetRequest$Description' => '<p>The description to display.</p>', 'CreateImageBuilderRequest$Description' => '<p>The description to display.</p>', 'CreateStackRequest$Description' => '<p>The description to display.</p>', 'CreateUpdatedImageRequest$newImageDescription' => '<p>The description to display for the new image.</p>', 'UpdateFleetRequest$Description' => '<p>The description to display.</p>', 'UpdateStackRequest$Description' => '<p>The description to display.</p>', ], ], 'DirectoryConfig' => [ 'base' => '<p>Describes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.</p>', 'refs' => [ 'CreateDirectoryConfigResult$DirectoryConfig' => '<p>Information about the directory configuration.</p>', 'DirectoryConfigList$member' => NULL, 'UpdateDirectoryConfigResult$DirectoryConfig' => '<p>Information about the Directory Config object.</p>', ], ], 'DirectoryConfigList' => [ 'base' => NULL, 'refs' => [ 'DescribeDirectoryConfigsResult$DirectoryConfigs' => '<p>Information about the directory configurations. Note that although the response syntax in this topic includes the account password, this password is not returned in the actual response. </p>', ], ], 'DirectoryName' => [ 'base' => NULL, 'refs' => [ 'CreateDirectoryConfigRequest$DirectoryName' => '<p>The fully qualified name of the directory (for example, corp.example.com).</p>', 'DeleteDirectoryConfigRequest$DirectoryName' => '<p>The name of the directory configuration.</p>', 'DirectoryConfig$DirectoryName' => '<p>The fully qualified name of the directory (for example, corp.example.com).</p>', 'DirectoryNameList$member' => NULL, 'DomainJoinInfo$DirectoryName' => '<p>The fully qualified name of the directory (for example, corp.example.com).</p>', 'UpdateDirectoryConfigRequest$DirectoryName' => '<p>The name of the Directory Config object.</p>', ], ], 'DirectoryNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeDirectoryConfigsRequest$DirectoryNames' => '<p>The directory names.</p>', ], ], 'DisableUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableUserResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$DisplayName' => '<p>The fleet name to display.</p>', 'CreateImageBuilderRequest$DisplayName' => '<p>The image builder name to display.</p>', 'CreateStackRequest$DisplayName' => '<p>The stack name to display.</p>', 'CreateUpdatedImageRequest$newImageDisplayName' => '<p>The name to display for the new image.</p>', 'UpdateFleetRequest$DisplayName' => '<p>The fleet name to display.</p>', 'UpdateStackRequest$DisplayName' => '<p>The stack name to display.</p>', ], ], 'Domain' => [ 'base' => 'GSuite domain for GDrive integration.', 'refs' => [ 'DomainList$member' => NULL, ], ], 'DomainJoinInfo' => [ 'base' => '<p>Describes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.</p>', 'refs' => [ 'CreateFleetRequest$DomainJoinInfo' => '<p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>', 'CreateImageBuilderRequest$DomainJoinInfo' => '<p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>', 'Fleet$DomainJoinInfo' => '<p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>', 'ImageBuilder$DomainJoinInfo' => '<p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>', 'UpdateFleetRequest$DomainJoinInfo' => '<p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>', ], ], 'DomainList' => [ 'base' => NULL, 'refs' => [ 'StorageConnector$Domains' => '<p>The names of the domains for the account.</p>', ], ], 'EmbedHostDomain' => [ 'base' => 'Specifies a valid domain that can embed AppStream. Valid examples include: ["testorigin.tt--com", "testingorigin.com.us", "test.com.us"] Invalid examples include: ["test,com", ".com", "h*llo.com". ""]', 'refs' => [ 'EmbedHostDomains$member' => NULL, ], ], 'EmbedHostDomains' => [ 'base' => NULL, 'refs' => [ 'CreateStackRequest$EmbedHostDomains' => '<p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>', 'Stack$EmbedHostDomains' => '<p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.</p>', 'UpdateStackRequest$EmbedHostDomains' => '<p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>', ], ], 'EnableUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableUserResult' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => '<p>The error message in the exception.</p>', 'refs' => [ 'ConcurrentModificationException$Message' => NULL, 'IncompatibleImageException$Message' => NULL, 'InvalidAccountStatusException$Message' => NULL, 'InvalidParameterCombinationException$Message' => NULL, 'InvalidRoleException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'OperationNotPermittedException$Message' => NULL, 'RequestLimitExceededException$Message' => NULL, 'ResourceAlreadyExistsException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotAvailableException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, ], ], 'ExpireSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExpireSessionResult' => [ 'base' => NULL, 'refs' => [], ], 'FeedbackURL' => [ 'base' => NULL, 'refs' => [ 'CreateStackRequest$FeedbackURL' => '<p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>', 'Stack$FeedbackURL' => '<p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>', 'UpdateStackRequest$FeedbackURL' => '<p>The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>', ], ], 'Fleet' => [ 'base' => '<p>Describes a fleet.</p>', 'refs' => [ 'CreateFleetResult$Fleet' => '<p>Information about the fleet.</p>', 'FleetList$member' => NULL, 'UpdateFleetResult$Fleet' => '<p>Information about the fleet.</p>', ], ], 'FleetAttribute' => [ 'base' => '<p>The fleet attribute.</p>', 'refs' => [ 'FleetAttributes$member' => NULL, ], ], 'FleetAttributes' => [ 'base' => '<p>The fleet attributes.</p>', 'refs' => [ 'UpdateFleetRequest$AttributesToDelete' => '<p>The fleet attributes to delete.</p>', ], ], 'FleetError' => [ 'base' => '<p>Describes a fleet error.</p>', 'refs' => [ 'FleetErrors$member' => NULL, ], ], 'FleetErrorCode' => [ 'base' => NULL, 'refs' => [ 'FleetError$ErrorCode' => '<p>The error code.</p>', 'ResourceError$ErrorCode' => '<p>The error code.</p>', ], ], 'FleetErrors' => [ 'base' => NULL, 'refs' => [ 'Fleet$FleetErrors' => '<p>The fleet errors.</p>', ], ], 'FleetList' => [ 'base' => '<p>The fleets.</p>', 'refs' => [ 'DescribeFleetsResult$Fleets' => '<p>Information about the fleets.</p>', ], ], 'FleetState' => [ 'base' => NULL, 'refs' => [ 'Fleet$State' => '<p>The current state for the fleet.</p>', ], ], 'FleetType' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$FleetType' => '<p>The fleet type.</p> <dl> <dt>ALWAYS_ON</dt> <dd> <p>Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</p> </dd> <dt>ON_DEMAND</dt> <dd> <p>Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</p> </dd> </dl>', 'Fleet$FleetType' => '<p>The fleet type.</p> <dl> <dt>ALWAYS_ON</dt> <dd> <p>Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</p> </dd> <dt>ON_DEMAND</dt> <dd> <p>Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</p> </dd> </dl>', ], ], 'Image' => [ 'base' => '<p>Describes an image.</p>', 'refs' => [ 'CreateUpdatedImageResult$image' => NULL, 'DeleteImageResult$Image' => '<p>Information about the image.</p>', 'ImageList$member' => NULL, ], ], 'ImageBuilder' => [ 'base' => '<p>Describes a virtual machine that is used to create an image. </p>', 'refs' => [ 'CreateImageBuilderResult$ImageBuilder' => '<p>Information about the image builder.</p>', 'DeleteImageBuilderResult$ImageBuilder' => '<p>Information about the image builder.</p>', 'ImageBuilderList$member' => NULL, 'StartImageBuilderResult$ImageBuilder' => '<p>Information about the image builder.</p>', 'StopImageBuilderResult$ImageBuilder' => '<p>Information about the image builder.</p>', ], ], 'ImageBuilderList' => [ 'base' => NULL, 'refs' => [ 'DescribeImageBuildersResult$ImageBuilders' => '<p>Information about the image builders.</p>', ], ], 'ImageBuilderState' => [ 'base' => NULL, 'refs' => [ 'ImageBuilder$State' => '<p>The state of the image builder.</p>', ], ], 'ImageBuilderStateChangeReason' => [ 'base' => '<p>Describes the reason why the last image builder state change occurred.</p>', 'refs' => [ 'ImageBuilder$StateChangeReason' => '<p>The reason why the last state change occurred.</p>', ], ], 'ImageBuilderStateChangeReasonCode' => [ 'base' => NULL, 'refs' => [ 'ImageBuilderStateChangeReason$Code' => '<p>The state change reason code.</p>', ], ], 'ImageList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesResult$Images' => '<p>Information about the images.</p>', ], ], 'ImagePermissions' => [ 'base' => '<p>Describes the permissions for an image. </p>', 'refs' => [ 'Image$ImagePermissions' => '<p>The permissions to provide to the destination AWS account for the specified image.</p>', 'SharedImagePermissions$imagePermissions' => '<p>Describes the permissions for a shared image.</p>', 'UpdateImagePermissionsRequest$ImagePermissions' => '<p>The permissions for the image.</p>', ], ], 'ImageState' => [ 'base' => NULL, 'refs' => [ 'Image$State' => '<p>The image starts in the <code>PENDING</code> state. If image creation succeeds, the state is <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.</p>', ], ], 'ImageStateChangeReason' => [ 'base' => '<p>Describes the reason why the last image state change occurred.</p>', 'refs' => [ 'Image$StateChangeReason' => '<p>The reason why the last state change occurred.</p>', ], ], 'ImageStateChangeReasonCode' => [ 'base' => NULL, 'refs' => [ 'ImageStateChangeReason$Code' => '<p>The state change reason code.</p>', ], ], 'IncompatibleImageException' => [ 'base' => '<p>The image can\'t be updated because it\'s not compatible for updates.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ComputeCapacity$DesiredInstances' => '<p>The desired number of streaming instances.</p>', 'ComputeCapacityStatus$Desired' => '<p>The desired number of streaming instances.</p>', 'ComputeCapacityStatus$Running' => '<p>The total number of simultaneous streaming instances that are running.</p>', 'ComputeCapacityStatus$InUse' => '<p>The number of instances in use for streaming.</p>', 'ComputeCapacityStatus$Available' => '<p>The number of currently available instances that can be used to stream sessions.</p>', 'CreateFleetRequest$MaxUserDurationInSeconds' => '<p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p> <p>Specify a value between 600 and 360000.</p>', 'CreateFleetRequest$DisconnectTimeoutInSeconds' => '<p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p> <p>Specify a value between 60 and 360000.</p>', 'CreateFleetRequest$IdleDisconnectTimeoutInSeconds' => '<p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p> <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note> <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don\'t do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p> </note>', 'DescribeDirectoryConfigsRequest$MaxResults' => '<p>The maximum size of each page of results.</p>', 'DescribeImageBuildersRequest$MaxResults' => '<p>The maximum size of each page of results.</p>', 'DescribeSessionsRequest$Limit' => '<p>The size of each page of results. The default value is 20 and the maximum value is 50.</p>', 'DescribeUsageReportSubscriptionsRequest$MaxResults' => '<p>The maximum size of each page of results.</p>', 'DescribeUsersRequest$MaxResults' => '<p>The maximum size of each page of results.</p>', 'Fleet$MaxUserDurationInSeconds' => '<p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance. </p> <p>Specify a value between 600 and 360000.</p>', 'Fleet$DisconnectTimeoutInSeconds' => '<p>The amount of time that a streaming session remains active after users disconnect. If they try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.</p> <p>Specify a value between 60 and 360000.</p>', 'Fleet$IdleDisconnectTimeoutInSeconds' => '<p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p> <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note> <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don\'t do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p> </note>', 'UpdateFleetRequest$MaxUserDurationInSeconds' => '<p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p> <p>Specify a value between 600 and 360000.</p>', 'UpdateFleetRequest$DisconnectTimeoutInSeconds' => '<p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p> <p>Specify a value between 60 and 360000.</p>', 'UpdateFleetRequest$IdleDisconnectTimeoutInSeconds' => '<p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected. </p> <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note> <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don\'t do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p> </note>', ], ], 'InvalidAccountStatusException' => [ 'base' => '<p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>', 'refs' => [], ], 'InvalidParameterCombinationException' => [ 'base' => '<p>Indicates an incorrect combination of parameters, or a missing parameter.</p>', 'refs' => [], ], 'InvalidRoleException' => [ 'base' => '<p>The specified role is invalid.</p>', 'refs' => [], ], 'LastReportGenerationExecutionError' => [ 'base' => '<p>Describes the error that is returned when a usage report can\'t be generated.</p>', 'refs' => [ 'LastReportGenerationExecutionErrors$member' => NULL, ], ], 'LastReportGenerationExecutionErrors' => [ 'base' => NULL, 'refs' => [ 'UsageReportSubscription$SubscriptionErrors' => '<p>The errors that were returned if usage reports couldn\'t be generated.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The requested limit exceeds the permitted limit for an account.</p>', 'refs' => [], ], 'ListAssociatedFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedFleetsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedStacksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedStacksResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'CreateImageBuilderStreamingURLRequest$Validity' => '<p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 3600 seconds.</p>', 'CreateStreamingURLRequest$Validity' => '<p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeImagePermissionsRequest$MaxResults' => '<p>The maximum size of each page of results.</p>', 'DescribeUserStackAssociationsRequest$MaxResults' => '<p>The maximum size of each page of results.</p>', ], ], 'MessageAction' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$MessageAction' => '<p>The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent. </p> <note> <p>The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.</p> </note>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'Application$Metadata' => '<p>Additional attributes that describe the application.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CopyImageRequest$SourceImageName' => '<p>The name of the image to copy.</p>', 'CopyImageRequest$DestinationImageName' => '<p>The name that the image will have when it is copied to the destination.</p>', 'CopyImageResponse$DestinationImageName' => '<p>The name of the destination image.</p>', 'CreateFleetRequest$Name' => '<p>A unique name for the fleet.</p>', 'CreateImageBuilderRequest$Name' => '<p>A unique name for the image builder.</p>', 'CreateStackRequest$Name' => '<p>The name of the stack.</p>', 'CreateUpdatedImageRequest$existingImageName' => '<p>The name of the image to update.</p>', 'CreateUpdatedImageRequest$newImageName' => '<p>The name of the new image. The name must be unique within the AWS account and Region.</p>', 'DeleteImageBuilderRequest$Name' => '<p>The name of the image builder.</p>', 'DeleteImagePermissionsRequest$Name' => '<p>The name of the private image.</p>', 'DeleteImageRequest$Name' => '<p>The name of the image.</p>', 'DescribeImagePermissionsRequest$Name' => '<p>The name of the private image for which to describe permissions. The image must be one that you own. </p>', 'DescribeImagePermissionsResult$Name' => '<p>The name of the private image.</p>', 'UpdateImagePermissionsRequest$Name' => '<p>The name of the private image.</p>', ], ], 'NetworkAccessConfiguration' => [ 'base' => '<p>Describes the network details of the fleet or image builder instance.</p>', 'refs' => [ 'ImageBuilder$NetworkAccessConfiguration' => NULL, 'Session$NetworkAccessConfiguration' => '<p>The network details for the streaming session.</p>', ], ], 'OperationNotPermittedException' => [ 'base' => '<p>The attempted operation is not permitted.</p>', 'refs' => [], ], 'OrganizationalUnitDistinguishedName' => [ 'base' => NULL, 'refs' => [ 'DomainJoinInfo$OrganizationalUnitDistinguishedName' => '<p>The distinguished name of the organizational unit for computer accounts.</p>', 'OrganizationalUnitDistinguishedNamesList$member' => NULL, ], ], 'OrganizationalUnitDistinguishedNamesList' => [ 'base' => NULL, 'refs' => [ 'CreateDirectoryConfigRequest$OrganizationalUnitDistinguishedNames' => '<p>The distinguished names of the organizational units for computer accounts.</p>', 'DirectoryConfig$OrganizationalUnitDistinguishedNames' => '<p>The distinguished names of the organizational units for computer accounts.</p>', 'UpdateDirectoryConfigRequest$OrganizationalUnitDistinguishedNames' => '<p>The distinguished names of the organizational units for computer accounts.</p>', ], ], 'Permission' => [ 'base' => NULL, 'refs' => [ 'UserSetting$Permission' => '<p>Indicates whether the action is enabled or disabled.</p>', ], ], 'PlatformType' => [ 'base' => NULL, 'refs' => [ 'Image$Platform' => '<p>The operating system platform of the image.</p>', 'ImageBuilder$Platform' => '<p>The operating system platform of the image builder.</p>', ], ], 'RedirectURL' => [ 'base' => NULL, 'refs' => [ 'CreateStackRequest$RedirectURL' => '<p>The URL that users are redirected to after their streaming session ends.</p>', 'Stack$RedirectURL' => '<p>The URL that users are redirected to after their streaming session ends.</p>', 'UpdateStackRequest$RedirectURL' => '<p>The URL that users are redirected to after their streaming session ends.</p>', ], ], 'RegionName' => [ 'base' => NULL, 'refs' => [ 'CopyImageRequest$DestinationRegion' => '<p>The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.</p>', ], ], 'RequestLimitExceededException' => [ 'base' => '<p>AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are being throttled by Amazon EC2. Try again later.</p>', 'refs' => [], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The specified resource already exists.</p>', 'refs' => [], ], 'ResourceError' => [ 'base' => '<p>Describes a resource error.</p>', 'refs' => [ 'ResourceErrors$member' => NULL, ], ], 'ResourceErrors' => [ 'base' => NULL, 'refs' => [ 'Image$ImageErrors' => '<p>Describes the errors that are returned when a new image can\'t be created.</p>', 'ImageBuilder$ImageBuilderErrors' => '<p>The image builder errors.</p>', ], ], 'ResourceIdentifier' => [ 'base' => '<p>The ARN of the resource.</p>', 'refs' => [ 'StorageConnector$ResourceIdentifier' => '<p>The ARN of the storage connector.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource is in use.</p>', 'refs' => [], ], 'ResourceNotAvailableException' => [ 'base' => '<p>The specified resource exists and is not in use, but isn\'t available.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'SecurityGroupIdList' => [ 'base' => '<p>The security group identifiers.</p>', 'refs' => [ 'VpcConfig$SecurityGroupIds' => '<p>The identifiers of the security groups for the fleet or image builder.</p>', ], ], 'ServiceAccountCredentials' => [ 'base' => '<p>Describes the credentials for the service account used by the fleet or image builder to connect to the directory.</p>', 'refs' => [ 'CreateDirectoryConfigRequest$ServiceAccountCredentials' => '<p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>', 'DirectoryConfig$ServiceAccountCredentials' => '<p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>', 'UpdateDirectoryConfigRequest$ServiceAccountCredentials' => '<p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>', ], ], 'Session' => [ 'base' => '<p>Describes a streaming session.</p>', 'refs' => [ 'SessionList$member' => NULL, ], ], 'SessionConnectionState' => [ 'base' => NULL, 'refs' => [ 'Session$ConnectionState' => '<p>Specifies whether a user is connected to the streaming session.</p>', ], ], 'SessionList' => [ 'base' => '<p>List of sessions.</p>', 'refs' => [ 'DescribeSessionsResult$Sessions' => '<p>Information about the streaming sessions.</p>', ], ], 'SessionState' => [ 'base' => '<p>Possible values for the state of a streaming session.</p>', 'refs' => [ 'Session$State' => '<p>The current state of the streaming session.</p>', ], ], 'SettingsGroup' => [ 'base' => NULL, 'refs' => [ 'ApplicationSettings$SettingsGroup' => '<p>The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the same persistent application settings to be used across multiple stacks by specifying the same settings group for each stack. </p>', 'ApplicationSettingsResponse$SettingsGroup' => '<p>The path prefix for the S3 bucket where users’ persistent application settings are stored.</p>', ], ], 'SharedImagePermissions' => [ 'base' => '<p>Describes the permissions that are available to the specified AWS account for a shared image.</p>', 'refs' => [ 'SharedImagePermissionsList$member' => NULL, ], ], 'SharedImagePermissionsList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagePermissionsResult$SharedImagePermissionsList' => '<p>The permissions for a private image that you own. </p>', ], ], 'Stack' => [ 'base' => '<p>Describes a stack.</p>', 'refs' => [ 'CreateStackResult$Stack' => '<p>Information about the stack.</p>', 'StackList$member' => NULL, 'UpdateStackResult$Stack' => '<p>Information about the stack.</p>', ], ], 'StackAttribute' => [ 'base' => NULL, 'refs' => [ 'StackAttributes$member' => NULL, ], ], 'StackAttributes' => [ 'base' => NULL, 'refs' => [ 'UpdateStackRequest$AttributesToDelete' => '<p>The stack attributes to delete.</p>', ], ], 'StackError' => [ 'base' => '<p>Describes a stack error.</p>', 'refs' => [ 'StackErrors$member' => NULL, ], ], 'StackErrorCode' => [ 'base' => NULL, 'refs' => [ 'StackError$ErrorCode' => '<p>The error code.</p>', ], ], 'StackErrors' => [ 'base' => '<p>The stack errors.</p>', 'refs' => [ 'Stack$StackErrors' => '<p>The errors for the stack.</p>', ], ], 'StackList' => [ 'base' => '<p>The stacks.</p>', 'refs' => [ 'DescribeStacksResult$Stacks' => '<p>Information about the stacks.</p>', ], ], 'StartFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'StartImageBuilderRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImageBuilderResult' => [ 'base' => NULL, 'refs' => [], ], 'StopFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'StopImageBuilderRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopImageBuilderResult' => [ 'base' => NULL, 'refs' => [], ], 'StorageConnector' => [ 'base' => '<p>Describes a connector that enables persistent storage for users.</p>', 'refs' => [ 'StorageConnectorList$member' => NULL, ], ], 'StorageConnectorList' => [ 'base' => '<p>The storage connectors.</p>', 'refs' => [ 'CreateStackRequest$StorageConnectors' => '<p>The storage connectors to enable.</p>', 'Stack$StorageConnectors' => '<p>The storage connectors to enable.</p>', 'UpdateStackRequest$StorageConnectors' => '<p>The storage connectors to enable.</p>', ], ], 'StorageConnectorType' => [ 'base' => '<p>The type of storage connector.</p>', 'refs' => [ 'StorageConnector$ConnectorType' => '<p>The type of storage connector.</p>', ], ], 'StreamView' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$StreamView' => '<p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p> <p>The default value is <code>APP</code>.</p>', 'Fleet$StreamView' => '<p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p> <p>The default value is <code>APP</code>.</p>', 'UpdateFleetRequest$StreamView' => '<p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p> <p>The default value is <code>APP</code>.</p>', ], ], 'StreamingUrlUserId' => [ 'base' => NULL, 'refs' => [ 'CreateStreamingURLRequest$UserId' => '<p>The identifier of the user.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessEndpoint$VpceId' => '<p>The identifier (ID) of the VPC in which the interface endpoint is used.</p>', 'Application$Name' => '<p>The name of the application.</p>', 'Application$DisplayName' => '<p>The application name to display.</p>', 'Application$IconURL' => '<p>The URL for the application icon. This URL might be time-limited.</p>', 'Application$LaunchPath' => '<p>The path to the application executable in the instance.</p>', 'Application$LaunchParameters' => '<p>The arguments that are passed to the application at launch.</p>', 'ApplicationSettingsResponse$S3BucketName' => '<p>The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique to the AWS account and the Region. </p>', 'AssociateFleetRequest$FleetName' => '<p>The name of the fleet. </p>', 'AssociateFleetRequest$StackName' => '<p>The name of the stack.</p>', 'CreateFleetRequest$ImageName' => '<p>The name of the image used to create the fleet.</p>', 'CreateFleetRequest$InstanceType' => '<p>The instance type to use when launching fleet instances. The following instance types are available:</p> <ul> <li> <p>stream.standard.small</p> </li> <li> <p>stream.standard.medium</p> </li> <li> <p>stream.standard.large</p> </li> <li> <p>stream.compute.large</p> </li> <li> <p>stream.compute.xlarge</p> </li> <li> <p>stream.compute.2xlarge</p> </li> <li> <p>stream.compute.4xlarge</p> </li> <li> <p>stream.compute.8xlarge</p> </li> <li> <p>stream.memory.large</p> </li> <li> <p>stream.memory.xlarge</p> </li> <li> <p>stream.memory.2xlarge</p> </li> <li> <p>stream.memory.4xlarge</p> </li> <li> <p>stream.memory.8xlarge</p> </li> <li> <p>stream.memory.z1d.large</p> </li> <li> <p>stream.memory.z1d.xlarge</p> </li> <li> <p>stream.memory.z1d.2xlarge</p> </li> <li> <p>stream.memory.z1d.3xlarge</p> </li> <li> <p>stream.memory.z1d.6xlarge</p> </li> <li> <p>stream.memory.z1d.12xlarge</p> </li> <li> <p>stream.graphics-design.large</p> </li> <li> <p>stream.graphics-design.xlarge</p> </li> <li> <p>stream.graphics-design.2xlarge</p> </li> <li> <p>stream.graphics-design.4xlarge</p> </li> <li> <p>stream.graphics-desktop.2xlarge</p> </li> <li> <p>stream.graphics.g4dn.xlarge</p> </li> <li> <p>stream.graphics.g4dn.2xlarge</p> </li> <li> <p>stream.graphics.g4dn.4xlarge</p> </li> <li> <p>stream.graphics.g4dn.8xlarge</p> </li> <li> <p>stream.graphics.g4dn.12xlarge</p> </li> <li> <p>stream.graphics.g4dn.16xlarge</p> </li> <li> <p>stream.graphics-pro.4xlarge</p> </li> <li> <p>stream.graphics-pro.8xlarge</p> </li> <li> <p>stream.graphics-pro.16xlarge</p> </li> </ul>', 'CreateImageBuilderRequest$ImageName' => '<p>The name of the image used to create the image builder.</p>', 'CreateImageBuilderRequest$InstanceType' => '<p>The instance type to use when launching the image builder. The following instance types are available:</p> <ul> <li> <p>stream.standard.small</p> </li> <li> <p>stream.standard.medium</p> </li> <li> <p>stream.standard.large</p> </li> <li> <p>stream.compute.large</p> </li> <li> <p>stream.compute.xlarge</p> </li> <li> <p>stream.compute.2xlarge</p> </li> <li> <p>stream.compute.4xlarge</p> </li> <li> <p>stream.compute.8xlarge</p> </li> <li> <p>stream.memory.large</p> </li> <li> <p>stream.memory.xlarge</p> </li> <li> <p>stream.memory.2xlarge</p> </li> <li> <p>stream.memory.4xlarge</p> </li> <li> <p>stream.memory.8xlarge</p> </li> <li> <p>stream.memory.z1d.large</p> </li> <li> <p>stream.memory.z1d.xlarge</p> </li> <li> <p>stream.memory.z1d.2xlarge</p> </li> <li> <p>stream.memory.z1d.3xlarge</p> </li> <li> <p>stream.memory.z1d.6xlarge</p> </li> <li> <p>stream.memory.z1d.12xlarge</p> </li> <li> <p>stream.graphics-design.large</p> </li> <li> <p>stream.graphics-design.xlarge</p> </li> <li> <p>stream.graphics-design.2xlarge</p> </li> <li> <p>stream.graphics-design.4xlarge</p> </li> <li> <p>stream.graphics-desktop.2xlarge</p> </li> <li> <p>stream.graphics.g4dn.xlarge</p> </li> <li> <p>stream.graphics.g4dn.2xlarge</p> </li> <li> <p>stream.graphics.g4dn.4xlarge</p> </li> <li> <p>stream.graphics.g4dn.8xlarge</p> </li> <li> <p>stream.graphics.g4dn.12xlarge</p> </li> <li> <p>stream.graphics.g4dn.16xlarge</p> </li> <li> <p>stream.graphics-pro.4xlarge</p> </li> <li> <p>stream.graphics-pro.8xlarge</p> </li> <li> <p>stream.graphics-pro.16xlarge</p> </li> </ul>', 'CreateImageBuilderStreamingURLRequest$Name' => '<p>The name of the image builder.</p>', 'CreateImageBuilderStreamingURLResult$StreamingURL' => '<p>The URL to start the AppStream 2.0 streaming session.</p>', 'CreateStreamingURLRequest$StackName' => '<p>The name of the stack.</p>', 'CreateStreamingURLRequest$FleetName' => '<p>The name of the fleet.</p>', 'CreateStreamingURLRequest$ApplicationId' => '<p>The name of the application to launch after the session starts. This is the name that you specified as <b>Name</b> in the Image Assistant. If your fleet is enabled for the <b>Desktop</b> stream view, you can also choose to launch directly to the operating system desktop. To do so, specify <b>Desktop</b>.</p>', 'CreateStreamingURLRequest$SessionContext' => '<p>The session context. For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters">Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'CreateStreamingURLResult$StreamingURL' => '<p>The URL to start the AppStream 2.0 streaming session.</p>', 'CreateUsageReportSubscriptionResult$S3BucketName' => '<p>The Amazon S3 bucket where generated reports are stored.</p> <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your usage reports. If you haven\'t already enabled on-instance session scripts, when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>', 'DeleteFleetRequest$Name' => '<p>The name of the fleet.</p>', 'DeleteStackRequest$Name' => '<p>The name of the stack.</p>', 'DescribeDirectoryConfigsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeDirectoryConfigsResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeFleetsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeFleetsResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeImageBuildersRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeImageBuildersResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeImagePermissionsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeImagePermissionsResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeImagesRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeImagesResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeSessionsRequest$StackName' => '<p>The name of the stack. This value is case-sensitive.</p>', 'DescribeSessionsRequest$FleetName' => '<p>The name of the fleet. This value is case-sensitive.</p>', 'DescribeSessionsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeSessionsResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeStacksRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeStacksResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeUsageReportSubscriptionsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeUsageReportSubscriptionsResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeUserStackAssociationsRequest$StackName' => '<p>The name of the stack that is associated with the user.</p>', 'DescribeUserStackAssociationsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeUserStackAssociationsResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeUsersRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeUsersResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DisassociateFleetRequest$FleetName' => '<p>The name of the fleet.</p>', 'DisassociateFleetRequest$StackName' => '<p>The name of the stack.</p>', 'ExpireSessionRequest$SessionId' => '<p>The identifier of the streaming session.</p>', 'Fleet$Name' => '<p>The name of the fleet.</p>', 'Fleet$DisplayName' => '<p>The fleet name to display.</p>', 'Fleet$Description' => '<p>The description to display.</p>', 'Fleet$ImageName' => '<p>The name of the image used to create the fleet.</p>', 'Fleet$InstanceType' => '<p>The instance type to use when launching fleet instances. The following instance types are available:</p> <ul> <li> <p>stream.standard.small</p> </li> <li> <p>stream.standard.medium</p> </li> <li> <p>stream.standard.large</p> </li> <li> <p>stream.compute.large</p> </li> <li> <p>stream.compute.xlarge</p> </li> <li> <p>stream.compute.2xlarge</p> </li> <li> <p>stream.compute.4xlarge</p> </li> <li> <p>stream.compute.8xlarge</p> </li> <li> <p>stream.memory.large</p> </li> <li> <p>stream.memory.xlarge</p> </li> <li> <p>stream.memory.2xlarge</p> </li> <li> <p>stream.memory.4xlarge</p> </li> <li> <p>stream.memory.8xlarge</p> </li> <li> <p>stream.memory.z1d.large</p> </li> <li> <p>stream.memory.z1d.xlarge</p> </li> <li> <p>stream.memory.z1d.2xlarge</p> </li> <li> <p>stream.memory.z1d.3xlarge</p> </li> <li> <p>stream.memory.z1d.6xlarge</p> </li> <li> <p>stream.memory.z1d.12xlarge</p> </li> <li> <p>stream.graphics-design.large</p> </li> <li> <p>stream.graphics-design.xlarge</p> </li> <li> <p>stream.graphics-design.2xlarge</p> </li> <li> <p>stream.graphics-design.4xlarge</p> </li> <li> <p>stream.graphics-desktop.2xlarge</p> </li> <li> <p>stream.graphics.g4dn.xlarge</p> </li> <li> <p>stream.graphics.g4dn.2xlarge</p> </li> <li> <p>stream.graphics.g4dn.4xlarge</p> </li> <li> <p>stream.graphics.g4dn.8xlarge</p> </li> <li> <p>stream.graphics.g4dn.12xlarge</p> </li> <li> <p>stream.graphics.g4dn.16xlarge</p> </li> <li> <p>stream.graphics-pro.4xlarge</p> </li> <li> <p>stream.graphics-pro.8xlarge</p> </li> <li> <p>stream.graphics-pro.16xlarge</p> </li> </ul>', 'FleetError$ErrorMessage' => '<p>The error message.</p>', 'Image$Name' => '<p>The name of the image.</p>', 'Image$DisplayName' => '<p>The image name to display.</p>', 'Image$ImageBuilderName' => '<p>The name of the image builder that was used to create the private image. If the image is shared, this value is null.</p>', 'Image$Description' => '<p>The description to display.</p>', 'ImageBuilder$Name' => '<p>The name of the image builder.</p>', 'ImageBuilder$Description' => '<p>The description to display.</p>', 'ImageBuilder$DisplayName' => '<p>The image builder name to display.</p>', 'ImageBuilder$InstanceType' => '<p>The instance type for the image builder. The following instance types are available:</p> <ul> <li> <p>stream.standard.small</p> </li> <li> <p>stream.standard.medium</p> </li> <li> <p>stream.standard.large</p> </li> <li> <p>stream.compute.large</p> </li> <li> <p>stream.compute.xlarge</p> </li> <li> <p>stream.compute.2xlarge</p> </li> <li> <p>stream.compute.4xlarge</p> </li> <li> <p>stream.compute.8xlarge</p> </li> <li> <p>stream.memory.large</p> </li> <li> <p>stream.memory.xlarge</p> </li> <li> <p>stream.memory.2xlarge</p> </li> <li> <p>stream.memory.4xlarge</p> </li> <li> <p>stream.memory.8xlarge</p> </li> <li> <p>stream.memory.z1d.large</p> </li> <li> <p>stream.memory.z1d.xlarge</p> </li> <li> <p>stream.memory.z1d.2xlarge</p> </li> <li> <p>stream.memory.z1d.3xlarge</p> </li> <li> <p>stream.memory.z1d.6xlarge</p> </li> <li> <p>stream.memory.z1d.12xlarge</p> </li> <li> <p>stream.graphics-design.large</p> </li> <li> <p>stream.graphics-design.xlarge</p> </li> <li> <p>stream.graphics-design.2xlarge</p> </li> <li> <p>stream.graphics-design.4xlarge</p> </li> <li> <p>stream.graphics-desktop.2xlarge</p> </li> <li> <p>stream.graphics.g4dn.xlarge</p> </li> <li> <p>stream.graphics.g4dn.2xlarge</p> </li> <li> <p>stream.graphics.g4dn.4xlarge</p> </li> <li> <p>stream.graphics.g4dn.8xlarge</p> </li> <li> <p>stream.graphics.g4dn.12xlarge</p> </li> <li> <p>stream.graphics.g4dn.16xlarge</p> </li> <li> <p>stream.graphics-pro.4xlarge</p> </li> <li> <p>stream.graphics-pro.8xlarge</p> </li> <li> <p>stream.graphics-pro.16xlarge</p> </li> </ul>', 'ImageBuilderStateChangeReason$Message' => '<p>The state change reason message.</p>', 'ImageStateChangeReason$Message' => '<p>The state change reason message.</p>', 'LastReportGenerationExecutionError$ErrorMessage' => '<p>The error message for the error that is returned when a usage report can\'t be generated.</p>', 'ListAssociatedFleetsRequest$StackName' => '<p>The name of the stack.</p>', 'ListAssociatedFleetsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListAssociatedFleetsResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListAssociatedStacksRequest$FleetName' => '<p>The name of the fleet.</p>', 'ListAssociatedStacksRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListAssociatedStacksResult$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'Metadata$key' => NULL, 'Metadata$value' => NULL, 'NetworkAccessConfiguration$EniPrivateIpAddress' => '<p>The private IP address of the elastic network interface that is attached to instances in your VPC.</p>', 'NetworkAccessConfiguration$EniId' => '<p>The resource identifier of the elastic network interface that is attached to instances in your VPC. All network interfaces have the eni-xxxxxxxx resource identifier.</p>', 'ResourceError$ErrorMessage' => '<p>The error message.</p>', 'SecurityGroupIdList$member' => NULL, 'Session$Id' => '<p>The identifier of the streaming session.</p>', 'Session$StackName' => '<p>The name of the stack for the streaming session.</p>', 'Session$FleetName' => '<p>The name of the fleet for the streaming session.</p>', 'Stack$Name' => '<p>The name of the stack.</p>', 'Stack$Description' => '<p>The description to display.</p>', 'Stack$DisplayName' => '<p>The stack name to display.</p>', 'StackError$ErrorMessage' => '<p>The error message.</p>', 'StartFleetRequest$Name' => '<p>The name of the fleet.</p>', 'StartImageBuilderRequest$Name' => '<p>The name of the image builder.</p>', 'StopFleetRequest$Name' => '<p>The name of the fleet.</p>', 'StopImageBuilderRequest$Name' => '<p>The name of the image builder.</p>', 'StringList$member' => NULL, 'SubnetIdList$member' => NULL, 'UpdateFleetRequest$ImageName' => '<p>The name of the image used to create the fleet.</p>', 'UpdateFleetRequest$Name' => '<p>A unique name for the fleet.</p>', 'UpdateFleetRequest$InstanceType' => '<p>The instance type to use when launching fleet instances. The following instance types are available:</p> <ul> <li> <p>stream.standard.small</p> </li> <li> <p>stream.standard.medium</p> </li> <li> <p>stream.standard.large</p> </li> <li> <p>stream.compute.large</p> </li> <li> <p>stream.compute.xlarge</p> </li> <li> <p>stream.compute.2xlarge</p> </li> <li> <p>stream.compute.4xlarge</p> </li> <li> <p>stream.compute.8xlarge</p> </li> <li> <p>stream.memory.large</p> </li> <li> <p>stream.memory.xlarge</p> </li> <li> <p>stream.memory.2xlarge</p> </li> <li> <p>stream.memory.4xlarge</p> </li> <li> <p>stream.memory.8xlarge</p> </li> <li> <p>stream.memory.z1d.large</p> </li> <li> <p>stream.memory.z1d.xlarge</p> </li> <li> <p>stream.memory.z1d.2xlarge</p> </li> <li> <p>stream.memory.z1d.3xlarge</p> </li> <li> <p>stream.memory.z1d.6xlarge</p> </li> <li> <p>stream.memory.z1d.12xlarge</p> </li> <li> <p>stream.graphics-design.large</p> </li> <li> <p>stream.graphics-design.xlarge</p> </li> <li> <p>stream.graphics-design.2xlarge</p> </li> <li> <p>stream.graphics-design.4xlarge</p> </li> <li> <p>stream.graphics-desktop.2xlarge</p> </li> <li> <p>stream.graphics.g4dn.xlarge</p> </li> <li> <p>stream.graphics.g4dn.2xlarge</p> </li> <li> <p>stream.graphics.g4dn.4xlarge</p> </li> <li> <p>stream.graphics.g4dn.8xlarge</p> </li> <li> <p>stream.graphics.g4dn.12xlarge</p> </li> <li> <p>stream.graphics.g4dn.16xlarge</p> </li> <li> <p>stream.graphics-pro.4xlarge</p> </li> <li> <p>stream.graphics-pro.8xlarge</p> </li> <li> <p>stream.graphics-pro.16xlarge</p> </li> </ul>', 'UpdateStackRequest$Name' => '<p>The name of the stack.</p>', 'UsageReportSubscription$S3BucketName' => '<p>The Amazon S3 bucket where generated reports are stored.</p> <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your usage reports. If you haven\'t already enabled on-instance session scripts, when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>', 'User$Status' => '<p>The status of the user in the user pool. The status can be one of the following:</p> <ul> <li> <p>UNCONFIRMED – The user is created but not confirmed.</p> </li> <li> <p>CONFIRMED – The user is confirmed.</p> </li> <li> <p>ARCHIVED – The user is no longer active.</p> </li> <li> <p>COMPROMISED – The user is disabled because of a potential security threat.</p> </li> <li> <p>UNKNOWN – The user status is not known.</p> </li> </ul>', 'UserStackAssociation$StackName' => '<p>The name of the stack that is associated with the user.</p>', 'UserStackAssociationError$ErrorMessage' => '<p>The error message for the error that is returned when a user can’t be associated with or disassociated from a stack.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetsRequest$Names' => '<p>The names of the fleets to describe.</p>', 'DescribeImageBuildersRequest$Names' => '<p>The names of the image builders to describe.</p>', 'DescribeImagesRequest$Names' => '<p>The names of the public or private images to describe.</p>', 'DescribeStacksRequest$Names' => '<p>The names of the stacks to describe.</p>', 'ListAssociatedFleetsResult$Names' => '<p>The name of the fleet.</p>', 'ListAssociatedStacksResult$Names' => '<p>The name of the stack.</p>', ], ], 'SubnetIdList' => [ 'base' => '<p>The subnet identifiers.</p>', 'refs' => [ 'VpcConfig$SubnetIds' => '<p>The identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance. Fleet instances use one or more subnets. Image builder instances use one subnet.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys for the tags to disassociate.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$Tags' => '<p>The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p> <p>If you do not specify a value, the value is set to an empty string.</p> <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p> <p>_ . : / = + \\ - @</p> <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'CreateImageBuilderRequest$Tags' => '<p>The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p> <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p> <p>_ . : / = + \\ - @</p> <p>If you do not specify a value, the value is set to an empty string.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'CreateStackRequest$Tags' => '<p>The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p> <p>If you do not specify a value, the value is set to an empty string.</p> <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p> <p>_ . : / = + \\ - @</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'CreateUpdatedImageRequest$newImageTags' => '<p>The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p> <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p> <p>_ . : / = + \\ - @</p> <p>If you do not specify a value, the value is set to an empty string.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The information about the tags.</p>', 'TagResourceRequest$Tags' => '<p>The tags to associate. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p> <p>If you do not specify a value, the value is set to an empty string.</p> <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p> <p>_ . : / = + \\ - @</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateImageBuilderStreamingURLResult$Expires' => '<p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>', 'CreateStreamingURLResult$Expires' => '<p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>', 'DirectoryConfig$CreatedTime' => '<p>The time the directory configuration was created.</p>', 'Fleet$CreatedTime' => '<p>The time the fleet was created.</p>', 'Image$CreatedTime' => '<p>The time the image was created.</p>', 'Image$PublicBaseImageReleasedDate' => '<p>The release date of the public base image. For private images, this date is the release date of the base image from which the image was created.</p>', 'ImageBuilder$CreatedTime' => '<p>The time stamp when the image builder was created.</p>', 'ResourceError$ErrorTimestamp' => '<p>The time the error occurred.</p>', 'Session$StartTime' => '<p>The time when a streaming instance is dedicated for the user.</p>', 'Session$MaxExpirationTime' => '<p>The time when the streaming session is set to expire. This time is based on the <code>MaxUserDurationinSeconds</code> value, which determines the maximum length of time that a streaming session can run. A streaming session might end earlier than the time specified in <code>SessionMaxExpirationTime</code>, when the <code>DisconnectTimeOutInSeconds</code> elapses or the user chooses to end his or her session. If the <code>DisconnectTimeOutInSeconds</code> elapses, or the user chooses to end his or her session, the streaming instance is terminated and the streaming session ends.</p>', 'Stack$CreatedTime' => '<p>The time the stack was created.</p>', 'UsageReportSubscription$LastGeneratedReportDate' => '<p>The time when the last usage report was generated.</p>', 'User$CreatedTime' => '<p>The date and time the user was created in the user pool.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDirectoryConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDirectoryConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateImagePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateImagePermissionsResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackResult' => [ 'base' => NULL, 'refs' => [], ], 'UsageReportExecutionErrorCode' => [ 'base' => NULL, 'refs' => [ 'LastReportGenerationExecutionError$ErrorCode' => '<p>The error code for the error that is returned when a usage report can\'t be generated.</p>', ], ], 'UsageReportSchedule' => [ 'base' => NULL, 'refs' => [ 'CreateUsageReportSubscriptionResult$Schedule' => '<p>The schedule for generating usage reports.</p>', 'UsageReportSubscription$Schedule' => '<p>The schedule for generating usage reports.</p>', ], ], 'UsageReportSubscription' => [ 'base' => '<p>Describes information about the usage report subscription.</p>', 'refs' => [ 'UsageReportSubscriptionList$member' => NULL, ], ], 'UsageReportSubscriptionList' => [ 'base' => NULL, 'refs' => [ 'DescribeUsageReportSubscriptionsResult$UsageReportSubscriptions' => '<p>Information about the usage report subscription.</p>', ], ], 'User' => [ 'base' => '<p>Describes a user in the user pool.</p>', 'refs' => [ 'UserList$member' => NULL, ], ], 'UserAttributeValue' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$FirstName' => '<p>The first name, or given name, of the user.</p>', 'CreateUserRequest$LastName' => '<p>The last name, or surname, of the user.</p>', 'User$FirstName' => '<p>The first name, or given name, of the user.</p>', 'User$LastName' => '<p>The last name, or surname, of the user.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsRequest$UserId' => '<p>The user identifier (ID). If you specify a user ID, you must also specify the authentication type.</p>', 'Session$UserId' => '<p>The identifier of the user for whom the session was created.</p>', ], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'DescribeUsersResult$Users' => '<p>Information about users in the user pool.</p>', ], ], 'UserSetting' => [ 'base' => '<p>Describes an action and whether the action is enabled or disabled for users during their streaming sessions.</p>', 'refs' => [ 'UserSettingList$member' => NULL, ], ], 'UserSettingList' => [ 'base' => NULL, 'refs' => [ 'CreateStackRequest$UserSettings' => '<p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. </p>', 'Stack$UserSettings' => '<p>The actions that are enabled or disabled for users during their streaming sessions. By default these actions are enabled.</p>', 'UpdateStackRequest$UserSettings' => '<p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.</p>', ], ], 'UserStackAssociation' => [ 'base' => '<p>Describes a user in the user pool and the associated stack.</p>', 'refs' => [ 'UserStackAssociationError$UserStackAssociation' => '<p>Information about the user and associated stack.</p>', 'UserStackAssociationList$member' => NULL, ], ], 'UserStackAssociationError' => [ 'base' => '<p>Describes the error that is returned when a user can’t be associated with or disassociated from a stack. </p>', 'refs' => [ 'UserStackAssociationErrorList$member' => NULL, ], ], 'UserStackAssociationErrorCode' => [ 'base' => NULL, 'refs' => [ 'UserStackAssociationError$ErrorCode' => '<p>The error code for the error that is returned when a user can’t be associated with or disassociated from a stack.</p>', ], ], 'UserStackAssociationErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateUserStackResult$errors' => '<p>The list of UserStackAssociationError objects.</p>', 'BatchDisassociateUserStackResult$errors' => '<p>The list of UserStackAssociationError objects.</p>', ], ], 'UserStackAssociationList' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateUserStackRequest$UserStackAssociations' => '<p>The list of UserStackAssociation objects.</p>', 'BatchDisassociateUserStackRequest$UserStackAssociations' => '<p>The list of UserStackAssociation objects.</p>', 'DescribeUserStackAssociationsResult$UserStackAssociations' => '<p>The UserStackAssociation objects.</p>', ], ], 'Username' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$UserName' => '<p>The email address of the user.</p> <note> <p>Users\' email addresses are case-sensitive. During login, if they specify an email address that doesn\'t use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.</p> </note>', 'DeleteUserRequest$UserName' => '<p>The email address of the user.</p> <note> <p>Users\' email addresses are case-sensitive.</p> </note>', 'DescribeUserStackAssociationsRequest$UserName' => '<p>The email address of the user who is associated with the stack.</p> <note> <p>Users\' email addresses are case-sensitive.</p> </note>', 'DisableUserRequest$UserName' => '<p>The email address of the user.</p> <note> <p>Users\' email addresses are case-sensitive.</p> </note>', 'EnableUserRequest$UserName' => '<p>The email address of the user.</p> <note> <p>Users\' email addresses are case-sensitive. During login, if they specify an email address that doesn\'t use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. </p> </note>', 'User$UserName' => '<p>The email address of the user.</p> <note> <p>Users\' email addresses are case-sensitive.</p> </note>', 'UserStackAssociation$UserName' => '<p>The email address of the user who is associated with the stack.</p> <note> <p>Users\' email addresses are case-sensitive.</p> </note>', ], ], 'VisibilityType' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesRequest$Type' => '<p>The type of image (public, private, or shared) to describe. </p>', 'Image$Visibility' => '<p>Indicates whether the image is public or private.</p>', ], ], 'VpcConfig' => [ 'base' => '<p>Describes VPC configuration information for fleets and image builders.</p>', 'refs' => [ 'CreateFleetRequest$VpcConfig' => '<p>The VPC configuration for the fleet.</p>', 'CreateImageBuilderRequest$VpcConfig' => '<p>The VPC configuration for the image builder. You can specify only one subnet.</p>', 'Fleet$VpcConfig' => '<p>The VPC configuration for the fleet.</p>', 'ImageBuilder$VpcConfig' => '<p>The VPC configuration of the image builder.</p>', 'UpdateFleetRequest$VpcConfig' => '<p>The VPC configuration for the fleet.</p>', ], ], ],];
