<?php
// This file was auto-generated from sdk-root/src/data/redshift/2012-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Redshift</fullname> <p> <b>Overview</b> </p> <p>This is an interface reference for Amazon Redshift. It contains documentation for one of the programming or command line interfaces you can use to manage Amazon Redshift clusters. Note that Amazon Redshift is asynchronous, which means that some interfaces may require techniques, such as polling or asynchronous callback handlers, to determine when a command has been applied. In this reference, the parameter descriptions indicate whether a change is applied immediately, on the next instance reboot, or during the next maintenance window. For a summary of the Amazon Redshift cluster management interfaces, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/using-aws-sdk.html">Using the Amazon Redshift Management Interfaces</a>.</p> <p>Amazon Redshift manages all the work of setting up, operating, and scaling a data warehouse: provisioning capacity, monitoring and backing up the cluster, and applying patches and upgrades to the Amazon Redshift engine. You can focus on using your data to acquire new insights for your business and customers.</p> <p>If you are a first-time user of Amazon Redshift, we recommend that you begin by reading the <a href="https://docs.aws.amazon.com/redshift/latest/gsg/getting-started.html">Amazon Redshift Getting Started Guide</a>.</p> <p>If you are a database developer, the <a href="https://docs.aws.amazon.com/redshift/latest/dg/welcome.html">Amazon Redshift Database Developer Guide</a> explains how to design, build, query, and maintain the databases that make up your data warehouse. </p>', 'operations' => [ 'AcceptReservedNodeExchange' => '<p>Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type, or number of nodes) and no additional costs. </p>', 'AddPartner' => '<p>Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the specified database. To complete the integration, you also set up the integration on the partner website.</p>', 'AssociateDataShareConsumer' => '<p>From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.</p>', 'AuthorizeClusterSecurityGroupIngress' => '<p>Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many as 20 ingress rules to an Amazon Redshift security group.</p> <p>If you authorize access to an Amazon EC2 security group, specify <i>EC2SecurityGroupName</i> and <i>EC2SecurityGroupOwnerId</i>. The Amazon EC2 security group and Amazon Redshift cluster must be in the same Amazon Web Services Region. </p> <p>If you authorize access to a CIDR/IP address range, specify <i>CIDRIP</i>. For an overview of CIDR blocks, see the Wikipedia article on <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>. </p> <p>You must also associate the security group with a cluster so that clients running on these IP addresses or the EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Working with Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'AuthorizeDataShare' => '<p>From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or managing entities. To authorize a datashare for a data consumer, the producer account must have the correct access privileges.</p>', 'AuthorizeEndpointAccess' => '<p>Grants access to a cluster.</p>', 'AuthorizeSnapshotAccess' => '<p>Authorizes the specified Amazon Web Services account to restore the specified snapshot.</p> <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'BatchDeleteClusterSnapshots' => '<p>Deletes a set of cluster snapshots.</p>', 'BatchModifyClusterSnapshots' => '<p>Modifies the settings for a set of cluster snapshots.</p>', 'CancelResize' => '<p>Cancels a resize operation for a cluster.</p>', 'CopyClusterSnapshot' => '<p>Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated snapshot and it must be in the available state.</p> <p>When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained until you delete them.</p> <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'CreateAuthenticationProfile' => '<p>Creates an authentication profile with the specified parameters.</p>', 'CreateCluster' => '<p>Creates a new cluster with the specified parameters.</p> <p>To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'CreateClusterParameterGroup' => '<p>Creates an Amazon Redshift parameter group.</p> <p>Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster is created by using <a>ModifyCluster</a>. </p> <p>Parameters in the parameter group define specific behavior that applies to the databases you create on the cluster. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'CreateClusterSecurityGroup' => '<p>Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.</p> <p> For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'CreateClusterSnapshot' => '<p>Creates a manual snapshot of the specified cluster. The cluster must be in the <code>available</code> state. </p> <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'CreateClusterSubnetGroup' => '<p>Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.</p> <p> For information about subnet groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html">Amazon Redshift Cluster Subnet Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'CreateEndpointAccess' => '<p>Creates a Redshift-managed VPC endpoint.</p>', 'CreateEventSubscription' => '<p>Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.</p> <p>You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities. Notifications will be sent for all events you want that match those criteria. For example, you can specify source type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity = ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup categories for the specified clusters.</p> <p>If you specify both the source type and source IDs, such as source type = cluster and source identifier = my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source type but do not specify a source identifier, you will receive notice of the events for the objects of that type in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services account. You must specify a source type if you specify a source ID.</p>', 'CreateHsmClientCertificate' => '<p>Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client\'s HSM in order to store and retrieve the keys used to encrypt the cluster databases.</p> <p>The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate, you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and use encryption keys in the HSM. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM">Hardware Security Modules</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'CreateHsmConfiguration' => '<p>Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.</p> <p>In addition to creating an HSM configuration, you must also create an HSM client certificate. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware Security Modules</a> in the Amazon Redshift Cluster Management Guide.</p>', 'CreateScheduledAction' => '<p>Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the <code>ResizeCluster</code> API operation. </p>', 'CreateSnapshotCopyGrant' => '<p>Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management Service (KMS) to encrypt copied snapshots in a destination region.</p> <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'CreateSnapshotSchedule' => '<p>Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup schedule. </p>', 'CreateTags' => '<p>Adds tags to a cluster.</p> <p>A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an error and the attempt will fail.</p> <p>If you specify a key that already exists for the resource, the value for that key will be updated with the new value.</p>', 'CreateUsageLimit' => '<p>Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the returned usage limit identifier.</p>', 'DeauthorizeDataShare' => '<p>From the producer account, removes authorization from the specified datashare. </p>', 'DeleteAuthenticationProfile' => '<p>Deletes an authentication profile.</p>', 'DeleteCluster' => '<p>Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the web service indicates that the request was received correctly. Use <a>DescribeClusters</a> to monitor the status of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>If you want to shut down the cluster and retain it for future use, set <i>SkipFinalClusterSnapshot</i> to <code>false</code> and specify a name for <i>FinalClusterSnapshotIdentifier</i>. You can later restore this snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be "final-snapshot" while the snapshot is being taken, then it\'s "deleting" once Amazon Redshift begins deleting the cluster. </p> <p> For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'DeleteClusterParameterGroup' => '<p>Deletes a specified Amazon Redshift parameter group.</p> <note> <p>You cannot delete a parameter group if it is associated with a cluster.</p> </note>', 'DeleteClusterSecurityGroup' => '<p>Deletes an Amazon Redshift security group.</p> <note> <p>You cannot delete a security group that is associated with any clusters. You cannot delete the default security group.</p> </note> <p> For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'DeleteClusterSnapshot' => '<p>Deletes the specified manual snapshot. The snapshot must be in the <code>available</code> state, with no other users authorized to access the snapshot. </p> <p>Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can delete the snapshot.</p>', 'DeleteClusterSubnetGroup' => '<p>Deletes the specified cluster subnet group.</p>', 'DeleteEndpointAccess' => '<p>Deletes a Redshift-managed VPC endpoint.</p>', 'DeleteEventSubscription' => '<p>Deletes an Amazon Redshift event notification subscription.</p>', 'DeleteHsmClientCertificate' => '<p>Deletes the specified HSM client certificate.</p>', 'DeleteHsmConfiguration' => '<p>Deletes the specified Amazon Redshift HSM configuration.</p>', 'DeletePartner' => '<p>Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted at the partner\'s website.</p>', 'DeleteScheduledAction' => '<p>Deletes a scheduled action. </p>', 'DeleteSnapshotCopyGrant' => '<p>Deletes the specified snapshot copy grant.</p>', 'DeleteSnapshotSchedule' => '<p>Deletes a snapshot schedule.</p>', 'DeleteTags' => '<p>Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or tags.</p>', 'DeleteUsageLimit' => '<p>Deletes a usage limit from a cluster.</p>', 'DescribeAccountAttributes' => '<p>Returns a list of attributes attached to an account</p>', 'DescribeAuthenticationProfiles' => '<p>Describes an authentication profile.</p>', 'DescribeClusterDbRevisions' => '<p>Returns an array of <code>ClusterDbRevision</code> objects.</p>', 'DescribeClusterParameterGroups' => '<p>Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default parameter group. For each parameter group, the response includes the parameter group name, description, and parameter group family name. You can optionally specify a name to retrieve the description of a specific parameter group.</p> <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter groups that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether they have tag keys or values associated with them.</p>', 'DescribeClusterParameters' => '<p>Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each parameter the response includes information such as parameter name, description, data type, value, whether the parameter value is modifiable, and so on.</p> <p>You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify <i>source</i> equal to <i>user</i>.</p> <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'DescribeClusterSecurityGroups' => '<p>Returns information about Amazon Redshift security groups. If the name of a security group is specified, the response will contain only information about only that security group.</p> <p> For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security groups that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, security groups are returned regardless of whether they have tag keys or values associated with them.</p>', 'DescribeClusterSnapshots' => '<p>Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots that have any combination of those values are returned. Only snapshots that you own are returned in the response; shared snapshots are not returned with the tag key and tag value request parameters.</p> <p>If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have tag keys or values associated with them.</p>', 'DescribeClusterSubnetGroups' => '<p>Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web Services account.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet groups that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they have tag keys or values associated with them.</p>', 'DescribeClusterTracks' => '<p>Returns a list of all the available maintenance tracks.</p>', 'DescribeClusterVersions' => '<p>Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before creating any clusters to learn more about the Amazon Redshift versions. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'DescribeClusters' => '<p>Returns properties of provisioned clusters including general cluster properties, cluster database properties, maintenance and backup properties, and security and access properties. This operation supports pagination. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have tag keys or values associated with them.</p>', 'DescribeDataShares' => '<p>Shows the status of any inbound or outbound datashares available in the specified account.</p>', 'DescribeDataSharesForConsumer' => '<p>Returns a list of datashares where the account identifier being called is a consumer account identifier.</p>', 'DescribeDataSharesForProducer' => '<p>Returns a list of datashares when the account identifier being called is a producer account identifier.</p>', 'DescribeDefaultClusterParameters' => '<p>Returns a list of parameter settings for the specified parameter group family.</p> <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'DescribeEndpointAccess' => '<p>Describes a Redshift-managed VPC endpoint.</p>', 'DescribeEndpointAuthorization' => '<p>Describes an endpoint authorization.</p>', 'DescribeEventCategories' => '<p>Displays a list of event categories for all event source types, or for a specified source type. For a list of the event categories and source types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift Event Notifications</a>.</p>', 'DescribeEventSubscriptions' => '<p>Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you specify a subscription name, lists the description for that subscription.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification subscriptions that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subscriptions that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they have tag keys or values associated with them.</p>', 'DescribeEvents' => '<p>Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.</p>', 'DescribeHsmClientCertificates' => '<p>Returns information about the specified HSM client certificate. If no certificate ID is specified, returns information about all the HSM certificates owned by your Amazon Web Services account.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client certificates that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM client certificates that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of whether they have tag keys or values associated with them.</p>', 'DescribeHsmConfigurations' => '<p>Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified, returns information about all the HSM configurations owned by your Amazon Web Services account.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM connections that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they have tag keys or values associated with them.</p>', 'DescribeLoggingStatus' => '<p>Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon Redshift cluster.</p>', 'DescribeNodeConfigurationOptions' => '<p>Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.</p>', 'DescribeOrderableClusterOptions' => '<p>Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU and price. With the cost involved you might want to obtain a list of cluster options in the specific region and specify values when creating a cluster. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'DescribePartners' => '<p>Returns information about the partner integrations defined for a cluster.</p>', 'DescribeReservedNodeExchangeStatus' => '<p>Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such values as in progress and requested.</p>', 'DescribeReservedNodeOfferings' => '<p>Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you. These descriptions help you determine which reserve node offering you want to purchase. You then use the unique offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon Redshift cluster. </p> <p> For more information about reserved node offerings, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'DescribeReservedNodes' => '<p>Returns the descriptions of the reserved nodes.</p>', 'DescribeResize' => '<p>Returns information about the last resize operation for the specified cluster. If no resize operation has ever been initiated for the specified cluster, a <code>HTTP 404</code> error is returned. If a resize operation was initiated and completed, the status of the resize remains as <code>SUCCEEDED</code> until the next resize. </p> <p>A resize operation can be requested using <a>ModifyCluster</a> and specifying a different number or type of nodes for the cluster. </p>', 'DescribeScheduledActions' => '<p>Describes properties of scheduled actions. </p>', 'DescribeSnapshotCopyGrants' => '<p>Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.</p> <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'DescribeSnapshotSchedules' => '<p>Returns a list of snapshot schedules. </p>', 'DescribeStorage' => '<p>Returns account level backups storage size and provisional storage.</p>', 'DescribeTableRestoreStatus' => '<p>Lists the status of one or more table restore requests made using the <a>RestoreTableFromClusterSnapshot</a> API action. If you don\'t specify a value for the <code>TableRestoreRequestId</code> parameter, then <code>DescribeTableRestoreStatus</code> returns the status of all table restore requests ordered by the date and time of the request in ascending order. Otherwise <code>DescribeTableRestoreStatus</code> returns the status of the table specified by <code>TableRestoreRequestId</code>.</p>', 'DescribeTags' => '<p>Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all tags for a given type of resource, such as clusters, snapshots, and so on.</p> <p>The following are limitations for <code>DescribeTags</code>: </p> <ul> <li> <p>You cannot specify an ARN and a resource-type value together in the same request.</p> </li> <li> <p>You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.</p> </li> <li> <p>The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.</p> </li> </ul> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, resources are returned regardless of whether they have tag keys or values associated with them.</p>', 'DescribeUsageLimits' => '<p>Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier, cluster identifier, and feature type parameters:</p> <ul> <li> <p>If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects for the current account in the current region are returned.</p> </li> <li> <p>If usage limit identifier is provided, then the corresponding usage limit object is returned.</p> </li> <li> <p>If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.</p> </li> <li> <p>If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster and feature are returned.</p> </li> </ul>', 'DisableLogging' => '<p>Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.</p>', 'DisableSnapshotCopy' => '<p>Disables the automatic copying of snapshots from one region to another region for a specified cluster.</p> <p>If your cluster and its snapshots are encrypted using an encrypted symmetric key from Key Management Service, use <a>DeleteSnapshotCopyGrant</a> to delete the grant that grants Amazon Redshift permission to the key in the destination region. </p>', 'DisassociateDataShareConsumer' => '<p>From a consumer account, remove association for the specified datashare. </p>', 'EnableLogging' => '<p>Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.</p>', 'EnableSnapshotCopy' => '<p>Enables the automatic copy of snapshots from one region to another region for a specified cluster.</p>', 'GetClusterCredentials' => '<p>Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift database. The action returns the database user name prefixed with <code>IAM:</code> if <code>AutoCreate</code> is <code>False</code> or <code>IAMA:</code> if <code>AutoCreate</code> is <code>True</code>. You can optionally specify one or more database user groups that the user will join at log on. By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes). For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html">Using IAM Authentication to Generate Database User Credentials</a> in the Amazon Redshift Cluster Management Guide.</p> <p>The Identity and Access Management (IAM) user or role that runs GetClusterCredentials must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources">Resource Policies for GetClusterCredentials</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If the <code>DbGroups</code> parameter is specified, the IAM policy must allow the <code>redshift:JoinGroup</code> action with access to the listed <code>dbgroups</code>. </p> <p>In addition, if the <code>AutoCreate</code> parameter is set to <code>True</code>, then the policy must include the <code>redshift:CreateClusterUser</code> privilege.</p> <p>If the <code>DbName</code> parameter is specified, the IAM policy must allow access to the resource <code>dbname</code> for the specified database name. </p>', 'GetReservedNodeExchangeConfigurationOptions' => '<p>Gets the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node offering. Details include the node type, the price, the node count, and the offering type.</p>', 'GetReservedNodeExchangeOfferings' => '<p>Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given DC1 reserved node.</p>', 'ModifyAquaConfiguration' => '<p>Modifies whether a cluster can use AQUA (Advanced Query Accelerator). </p>', 'ModifyAuthenticationProfile' => '<p>Modifies an authentication profile.</p>', 'ModifyCluster' => '<p>Modifies the settings for a cluster.</p> <p>You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster, you must specify both the number of nodes and the node type even if one of the parameters does not change.</p> <p>You can add another security or parameter group, or change the admin user password. Resetting a cluster password or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter group requires a reboot for parameters to take effect. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'ModifyClusterDbRevision' => '<p>Modifies the database revision of a cluster. The database revision is a unique revision of the database running in a cluster.</p>', 'ModifyClusterIamRoles' => '<p>Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.</p> <p>The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'ModifyClusterMaintenance' => '<p>Modifies the maintenance settings of a cluster.</p>', 'ModifyClusterParameterGroup' => '<p>Modifies the parameters of a parameter group. For the parameters parameter, it can\'t contain ASCII characters.</p> <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'ModifyClusterSnapshot' => '<p>Modifies the settings for a snapshot.</p> <p>This exanmple modifies the manual retention period setting for a cluster snapshot.</p>', 'ModifyClusterSnapshotSchedule' => '<p>Modifies a snapshot schedule for a cluster.</p>', 'ModifyClusterSubnetGroup' => '<p>Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing list of subnets with the new list of subnets.</p>', 'ModifyEndpointAccess' => '<p>Modifies a Redshift-managed VPC endpoint.</p>', 'ModifyEventSubscription' => '<p>Modifies an existing Amazon Redshift event notification subscription.</p>', 'ModifyScheduledAction' => '<p>Modifies a scheduled action. </p>', 'ModifySnapshotCopyRetentionPeriod' => '<p>Modifies the number of days to retain snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. By default, this operation only changes the retention period of copied automated snapshots. The retention periods for both new and existing copied automated snapshots are updated with the new retention period. You can set the manual option to change only the retention periods of copied manual snapshots. If you set this option, only newly copied manual snapshots have the new retention period. </p>', 'ModifySnapshotSchedule' => '<p>Modifies a snapshot schedule. Any schedule associated with a cluster is modified asynchronously.</p>', 'ModifyUsageLimit' => '<p>Modifies a usage limit in a cluster. You can\'t modify the feature type or period of a usage limit.</p>', 'PauseCluster' => '<p>Pauses a cluster.</p>', 'PurchaseReservedNodeOffering' => '<p>Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved node offerings. You can purchase one or more of the offerings. You can call the <a>DescribeReservedNodeOfferings</a> API to obtain the available reserved node offerings. You can call this API by providing a specific reserved node offering and the number of nodes you want to reserve. </p> <p> For more information about reserved node offerings, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'RebootCluster' => '<p>Reboots a cluster. This action is taken as soon as possible. It results in a momentary outage to the cluster, during which the cluster status is set to <code>rebooting</code>. A cluster event is created when the reboot is completed. Any pending cluster modifications (see <a>ModifyCluster</a>) are applied at this reboot. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'RejectDataShare' => '<p>From the consumer account, rejects the specified datashare.</p>', 'ResetClusterParameterGroup' => '<p>Sets one or more parameters of the specified parameter group to their default values and sets the source values of the parameters to "engine-default". To reset the entire parameter group specify the <i>ResetAllParameters</i> parameter. For parameter changes to take effect you must reboot any associated clusters. </p>', 'ResizeCluster' => '<p>Changes the size of the cluster. You can change the cluster\'s type, or change the number or type of nodes. The default behavior is to use the elastic resize method. With an elastic resize, your cluster is available for read and write operations more quickly than with the classic resize method. </p> <p>Elastic resize operations have the following restrictions:</p> <ul> <li> <p>You can only resize clusters of the following types:</p> <ul> <li> <p>dc1.large (if your cluster is in a VPC)</p> </li> <li> <p>dc1.8xlarge (if your cluster is in a VPC)</p> </li> <li> <p>dc2.large</p> </li> <li> <p>dc2.8xlarge</p> </li> <li> <p>ds2.xlarge</p> </li> <li> <p>ds2.8xlarge</p> </li> <li> <p>ra3.xlplus</p> </li> <li> <p>ra3.4xlarge</p> </li> <li> <p>ra3.16xlarge</p> </li> </ul> </li> <li> <p>The type of nodes that you add must match the node type for the cluster.</p> </li> </ul>', 'RestoreFromClusterSnapshot' => '<p>Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same configuration as the original cluster from which the snapshot was created, except that the new cluster is created with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use the <a>ModifyCluster</a> API to associate a different security group and different parameter group with the restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the same size during restore.</p> <p>If you restore a cluster into a VPC, you must provide a cluster subnet group where you want the cluster restored.</p> <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'RestoreTableFromClusterSnapshot' => '<p>Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the Amazon Redshift cluster that the snapshot was taken from.</p> <p>You cannot use <code>RestoreTableFromClusterSnapshot</code> to restore a table with the same name as an existing table in an Amazon Redshift cluster. That is, you cannot overwrite an existing table in a cluster with a restored table. If you want to replace your original table with a new, restored table, then rename or drop your original table before you call <code>RestoreTableFromClusterSnapshot</code>. When you have renamed your original table, then you can pass the original name of the table as the <code>NewTableName</code> parameter value in the call to <code>RestoreTableFromClusterSnapshot</code>. This way, you can replace the original table with the table created from the snapshot.</p>', 'ResumeCluster' => '<p>Resumes a paused cluster.</p>', 'RevokeClusterSecurityGroupIngress' => '<p>Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2 security group. To add an ingress rule, see <a>AuthorizeClusterSecurityGroupIngress</a>. For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'RevokeEndpointAccess' => '<p>Revokes access to a cluster.</p>', 'RevokeSnapshotAccess' => '<p>Removes the ability of the specified Amazon Web Services account to restore the specified snapshot. If the account is currently restoring the snapshot, the restore will run to completion.</p> <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'RotateEncryptionKey' => '<p>Rotates the encryption keys for a cluster.</p>', 'UpdatePartnerStatus' => '<p>Updates the status of a partner integration.</p>', ], 'shapes' => [ 'AcceptReservedNodeExchangeInputMessage' => [ 'base' => NULL, 'refs' => [], ], 'AcceptReservedNodeExchangeOutputMessage' => [ 'base' => NULL, 'refs' => [], ], 'AccessToClusterDeniedFault' => [ 'base' => '<p>You are not authorized to access the cluster.</p>', 'refs' => [], ], 'AccessToSnapshotDeniedFault' => [ 'base' => '<p>The owner of the specified snapshot has not authorized your account to access the snapshot.</p>', 'refs' => [], ], 'AccountAttribute' => [ 'base' => '<p>A name value pair that describes an aspect of an account. </p>', 'refs' => [ 'AttributeList$member' => NULL, ], ], 'AccountAttributeList' => [ 'base' => NULL, 'refs' => [], ], 'AccountWithRestoreAccess' => [ 'base' => '<p>Describes an Amazon Web Services account authorized to restore a snapshot.</p>', 'refs' => [ 'AccountsWithRestoreAccessList$member' => NULL, ], ], 'AccountsWithRestoreAccessList' => [ 'base' => NULL, 'refs' => [ 'Snapshot$AccountsWithRestoreAccess' => '<p>A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns <code>null</code> if no accounts are authorized. Visible only to the snapshot owner. </p>', ], ], 'ActionType' => [ 'base' => NULL, 'refs' => [ 'DescribeNodeConfigurationOptionsMessage$ActionType' => '<p>The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster. </p>', ], ], 'AquaConfiguration' => [ 'base' => '<p>The AQUA (Advanced Query Accelerator) configuration of the cluster.</p>', 'refs' => [ 'Cluster$AquaConfiguration' => '<p>The AQUA (Advanced Query Accelerator) configuration of the cluster.</p>', 'ModifyAquaOutputMessage$AquaConfiguration' => '<p>The updated AQUA configuration of the cluster. </p>', ], ], 'AquaConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'AquaConfiguration$AquaConfigurationStatus' => '<p>The value represents how the cluster is configured to use AQUA. Possible values include the following.</p> <ul> <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li> <li> <p>disabled - Don\'t use AQUA. </p> </li> <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li> </ul>', 'CreateClusterMessage$AquaConfigurationStatus' => '<p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.</p> <ul> <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li> <li> <p>disabled - Don\'t use AQUA. </p> </li> <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li> </ul>', 'ModifyAquaInputMessage$AquaConfigurationStatus' => '<p>The new value of AQUA configuration status. Possible values include the following.</p> <ul> <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li> <li> <p>disabled - Don\'t use AQUA. </p> </li> <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li> </ul>', 'RestoreFromClusterSnapshotMessage$AquaConfigurationStatus' => '<p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.</p> <ul> <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li> <li> <p>disabled - Don\'t use AQUA. </p> </li> <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li> </ul>', ], ], 'AquaStatus' => [ 'base' => NULL, 'refs' => [ 'AquaConfiguration$AquaStatus' => '<p>The value indicates the status of AQUA on the cluster. Possible values include the following.</p> <ul> <li> <p>enabled - AQUA is enabled.</p> </li> <li> <p>disabled - AQUA is not enabled. </p> </li> <li> <p>applying - AQUA status is being applied. </p> </li> </ul>', ], ], 'AssociateDataShareConsumerMessage' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedClusterList' => [ 'base' => NULL, 'refs' => [ 'SnapshotSchedule$AssociatedClusters' => '<p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>', ], ], 'AttributeList' => [ 'base' => NULL, 'refs' => [ 'AccountAttributeList$AccountAttributes' => '<p>A list of attributes assigned to an account.</p>', ], ], 'AttributeNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesMessage$AttributeNames' => '<p>A list of attribute names.</p>', ], ], 'AttributeValueList' => [ 'base' => NULL, 'refs' => [ 'AccountAttribute$AttributeValues' => '<p>A list of attribute values.</p>', ], ], 'AttributeValueTarget' => [ 'base' => '<p>Describes an attribute value.</p>', 'refs' => [ 'AttributeValueList$member' => NULL, ], ], 'AuthenticationProfile' => [ 'base' => '<p>Describes an authentication profile.</p>', 'refs' => [ 'AuthenticationProfileList$member' => NULL, ], ], 'AuthenticationProfileAlreadyExistsFault' => [ 'base' => '<p>The authentication profile already exists.</p>', 'refs' => [], ], 'AuthenticationProfileList' => [ 'base' => NULL, 'refs' => [ 'DescribeAuthenticationProfilesResult$AuthenticationProfiles' => '<p>The list of authentication profiles.</p>', ], ], 'AuthenticationProfileNameString' => [ 'base' => NULL, 'refs' => [ 'AuthenticationProfile$AuthenticationProfileName' => '<p>The name of the authentication profile.</p>', 'CreateAuthenticationProfileMessage$AuthenticationProfileName' => '<p>The name of the authentication profile to be created.</p>', 'CreateAuthenticationProfileResult$AuthenticationProfileName' => '<p>The name of the authentication profile that was created.</p>', 'DeleteAuthenticationProfileMessage$AuthenticationProfileName' => '<p>The name of the authentication profile to delete.</p>', 'DeleteAuthenticationProfileResult$AuthenticationProfileName' => '<p>The name of the authentication profile that was deleted.</p>', 'DescribeAuthenticationProfilesMessage$AuthenticationProfileName' => '<p>The name of the authentication profile to describe. If not specified then all authentication profiles owned by the account are listed.</p>', 'ModifyAuthenticationProfileMessage$AuthenticationProfileName' => '<p>The name of the authentication profile to replace.</p>', 'ModifyAuthenticationProfileResult$AuthenticationProfileName' => '<p>The name of the authentication profile that was replaced.</p>', ], ], 'AuthenticationProfileNotFoundFault' => [ 'base' => '<p>The authentication profile can\'t be found.</p>', 'refs' => [], ], 'AuthenticationProfileQuotaExceededFault' => [ 'base' => '<p>The size or number of authentication profiles has exceeded the quota. The maximum length of the JSON string and maximum number of authentication profiles is determined by a quota for your account.</p>', 'refs' => [], ], 'AuthorizationAlreadyExistsFault' => [ 'base' => '<p>The specified CIDR block or EC2 security group is already authorized for the specified cluster security group.</p>', 'refs' => [], ], 'AuthorizationNotFoundFault' => [ 'base' => '<p>The specified CIDR IP range or EC2 security group is not authorized for the specified cluster security group.</p>', 'refs' => [], ], 'AuthorizationQuotaExceededFault' => [ 'base' => '<p>The authorization quota for the cluster security group has been reached.</p>', 'refs' => [], ], 'AuthorizationStatus' => [ 'base' => NULL, 'refs' => [ 'EndpointAuthorization$Status' => '<p>The status of the authorization action.</p>', ], ], 'AuthorizeClusterSecurityGroupIngressMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'AuthorizeClusterSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeDataShareMessage' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeEndpointAccessMessage' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeSnapshotAccessMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'AuthorizeSnapshotAccessResult' => [ 'base' => NULL, 'refs' => [], ], 'AvailabilityZone' => [ 'base' => '<p>Describes an availability zone.</p>', 'refs' => [ 'AvailabilityZoneList$member' => NULL, 'Subnet$SubnetAvailabilityZone' => '<p/>', ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'OrderableClusterOption$AvailabilityZones' => '<p>A list of availability zones for the orderable cluster.</p>', ], ], 'BatchDeleteClusterSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteClusterSnapshotsResult' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteRequestSizeExceededFault' => [ 'base' => '<p>The maximum number for a batch delete of snapshots has been reached. The limit is 100. </p>', 'refs' => [], ], 'BatchModifyClusterSnapshotsLimitExceededFault' => [ 'base' => '<p>The maximum number for snapshot identifiers has been reached. The limit is 100. </p>', 'refs' => [], ], 'BatchModifyClusterSnapshotsMessage' => [ 'base' => NULL, 'refs' => [], ], 'BatchModifyClusterSnapshotsOutputMessage' => [ 'base' => NULL, 'refs' => [], ], 'BatchSnapshotOperationErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteClusterSnapshotsResult$Errors' => '<p>A list of any errors returned.</p>', ], ], 'BatchSnapshotOperationErrors' => [ 'base' => NULL, 'refs' => [ 'BatchModifyClusterSnapshotsOutputMessage$Errors' => '<p>A list of any errors returned.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'BatchModifyClusterSnapshotsMessage$Force' => '<p>A boolean value indicating whether to override an exception if the retention period has passed. </p>', 'Cluster$AllowVersionUpgrade' => '<p>A boolean value that, if <code>true</code>, indicates that major version upgrades will be applied automatically to the cluster during the maintenance window. </p>', 'Cluster$PubliclyAccessible' => '<p>A boolean value that, if <code>true</code>, indicates that the cluster can be accessed from a public network.</p>', 'Cluster$Encrypted' => '<p>A boolean value that, if <code>true</code>, indicates that data in the cluster is encrypted at rest.</p>', 'Cluster$EnhancedVpcRouting' => '<p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>', 'DataShare$AllowPubliclyAccessibleConsumers' => '<p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>', 'DeleteClusterMessage$SkipFinalClusterSnapshot' => '<p>Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If <code>true</code>, a final cluster snapshot is not created. If <code>false</code>, a final cluster snapshot is created before the cluster is deleted. </p> <note> <p>The <i>FinalClusterSnapshotIdentifier</i> parameter must be specified if <i>SkipFinalClusterSnapshot</i> is <code>false</code>.</p> </note> <p>Default: <code>false</code> </p>', 'EndpointAuthorization$AllowedAllVPCs' => '<p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>', 'EventSubscription$Enabled' => '<p>A boolean value indicating whether the subscription is enabled; <code>true</code> indicates that the subscription is enabled.</p>', 'LoggingStatus$LoggingEnabled' => '<p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>', 'ModifyClusterSnapshotMessage$Force' => '<p>A Boolean option to override an exception if the retention period has already passed.</p>', 'ModifySnapshotCopyRetentionPeriodMessage$Manual' => '<p>Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.</p>', 'Parameter$IsModifiable' => '<p>If <code>true</code>, the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>', 'ResetClusterParameterGroupMessage$ResetAllParameters' => '<p>If <code>true</code>, all parameters in the specified parameter group will be reset to their default values. </p> <p>Default: <code>true</code> </p>', 'ResizeInfo$AllowCancelResize' => '<p>A boolean value indicating if the resize operation can be cancelled.</p>', 'RevokeEndpointAccessMessage$Force' => '<p>Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.</p>', 'Snapshot$Encrypted' => '<p>If <code>true</code>, the data in the snapshot is encrypted at rest.</p>', 'Snapshot$EncryptedWithHSM' => '<p>A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster. <code>true</code> indicates that the data is encrypted using HSM keys.</p>', 'Snapshot$EnhancedVpcRouting' => '<p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'AssociateDataShareConsumerMessage$AssociateEntireAccount' => '<p>A value that specifies whether the datashare is associated with the entire account.</p>', 'CreateClusterMessage$AllowVersionUpgrade' => '<p>If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.</p> <p>When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.</p> <p>Default: <code>true</code> </p>', 'CreateClusterMessage$PubliclyAccessible' => '<p>If <code>true</code>, the cluster can be accessed from a public network. </p>', 'CreateClusterMessage$Encrypted' => '<p>If <code>true</code>, the data in the cluster is encrypted at rest. </p> <p>Default: false</p>', 'CreateClusterMessage$EnhancedVpcRouting' => '<p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>', 'CreateClusterMessage$AvailabilityZoneRelocation' => '<p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.</p>', 'CreateEventSubscriptionMessage$Enabled' => '<p>A boolean value; set to <code>true</code> to activate the subscription, and set to <code>false</code> to create the subscription but not activate it. </p>', 'CreateScheduledActionMessage$Enable' => '<p>If true, the schedule is enabled. If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <a>ScheduledAction</a>. </p>', 'CreateSnapshotScheduleMessage$DryRun' => '<p/>', 'DescribeClusterSnapshotsMessage$ClusterExists' => '<p>A value that indicates whether to return snapshots only for an existing cluster. You can perform table-level restore only by using a snapshot of an existing cluster, that is, a cluster that has not been deleted. Values for this parameter work as follows: </p> <ul> <li> <p>If <code>ClusterExists</code> is set to <code>true</code>, <code>ClusterIdentifier</code> is required.</p> </li> <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> isn\'t specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned. </p> </li> <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for a deleted cluster, snapshots associated with that cluster are returned.</p> </li> <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for an existing cluster, no snapshots are returned. </p> </li> </ul>', 'DescribeEndpointAuthorizationMessage$Grantee' => '<p>Indicates whether to check authorization from a grantor or grantee point of view. If true, Amazon Redshift returns endpoint authorizations that you\'ve been granted. If false (default), checks authorization from a grantor point of view.</p>', 'DescribeScheduledActionsMessage$Active' => '<p>If true, retrieve only active scheduled actions. If false, retrieve only disabled scheduled actions. </p>', 'DisassociateDataShareConsumerMessage$DisassociateEntireAccount' => '<p>A value that specifies whether association for the datashare is removed from the entire account.</p>', 'GetClusterCredentialsMessage$AutoCreate' => '<p>Create a database user with the name specified for the user named in <code>DbUser</code> if one does not exist.</p>', 'ModifyClusterMaintenanceMessage$DeferMaintenance' => '<p>A boolean indicating whether to enable the deferred maintenance window. </p>', 'ModifyClusterMessage$AllowVersionUpgrade' => '<p>If <code>true</code>, major version upgrades will be applied automatically to the cluster during the maintenance window. </p> <p>Default: <code>false</code> </p>', 'ModifyClusterMessage$PubliclyAccessible' => '<p>If <code>true</code>, the cluster can be accessed from a public network. Only clusters in VPCs can be set to be publicly available.</p>', 'ModifyClusterMessage$EnhancedVpcRouting' => '<p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>', 'ModifyClusterMessage$Encrypted' => '<p>Indicates whether the cluster is encrypted. If the value is encrypted (true) and you provide a value for the <code>KmsKeyId</code> parameter, we encrypt the cluster with the provided <code>KmsKeyId</code>. If you don\'t provide a <code>KmsKeyId</code>, we encrypt with the default key. </p> <p>If the value is not encrypted (false), then the cluster is decrypted. </p>', 'ModifyClusterMessage$AvailabilityZoneRelocation' => '<p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.</p>', 'ModifyClusterSnapshotScheduleMessage$DisassociateSchedule' => '<p>A boolean to indicate whether to remove the assoiciation between the cluster and the schedule.</p>', 'ModifyEventSubscriptionMessage$Enabled' => '<p>A Boolean value indicating if the subscription is enabled. <code>true</code> indicates the subscription is enabled </p>', 'ModifyScheduledActionMessage$Enable' => '<p>A modified enable flag of the scheduled action. If true, the scheduled action is active. If false, the scheduled action is disabled. </p>', 'PendingModifiedValues$PubliclyAccessible' => '<p>The pending or in-progress change of the ability to connect to the cluster from the public network.</p>', 'PendingModifiedValues$EnhancedVpcRouting' => '<p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>', 'ResizeClusterMessage$Classic' => '<p>A boolean value indicating whether the resize operation is using the classic resize process. If you don\'t provide this parameter or set the value to <code>false</code>, the resize type is elastic. </p>', 'RestoreFromClusterSnapshotMessage$AllowVersionUpgrade' => '<p>If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. </p> <p>Default: <code>true</code> </p>', 'RestoreFromClusterSnapshotMessage$PubliclyAccessible' => '<p>If <code>true</code>, the cluster can be accessed from a public network. </p>', 'RestoreFromClusterSnapshotMessage$EnhancedVpcRouting' => '<p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>', 'RestoreFromClusterSnapshotMessage$AvailabilityZoneRelocation' => '<p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored.</p>', 'RestoreFromClusterSnapshotMessage$Encrypted' => '<p>Enables support for restoring an unencrypted snapshot to a cluster encrypted with Key Management Service (KMS) and a customer managed key.</p>', 'RestoreTableFromClusterSnapshotMessage$EnableCaseSensitiveIdentifier' => '<p>Indicates whether name identifiers for database, schema, and table are case sensitive. If <code>true</code>, the names are case sensitive. If <code>false</code> (default), the names are not case sensitive.</p>', ], ], 'BucketNotFoundFault' => [ 'base' => '<p>Could not find the specified S3 bucket.</p>', 'refs' => [], ], 'CancelResizeMessage' => [ 'base' => NULL, 'refs' => [], ], 'Cluster' => [ 'base' => '<p>Describes a cluster.</p>', 'refs' => [ 'ClusterList$member' => NULL, 'CreateClusterResult$Cluster' => NULL, 'DeleteClusterResult$Cluster' => NULL, 'DisableSnapshotCopyResult$Cluster' => NULL, 'EnableSnapshotCopyResult$Cluster' => NULL, 'ModifyClusterDbRevisionResult$Cluster' => NULL, 'ModifyClusterIamRolesResult$Cluster' => NULL, 'ModifyClusterMaintenanceResult$Cluster' => NULL, 'ModifyClusterResult$Cluster' => NULL, 'ModifySnapshotCopyRetentionPeriodResult$Cluster' => NULL, 'PauseClusterResult$Cluster' => NULL, 'RebootClusterResult$Cluster' => NULL, 'ResizeClusterResult$Cluster' => NULL, 'RestoreFromClusterSnapshotResult$Cluster' => NULL, 'ResumeClusterResult$Cluster' => NULL, 'RotateEncryptionKeyResult$Cluster' => NULL, ], ], 'ClusterAlreadyExistsFault' => [ 'base' => '<p>The account already has a cluster with the given identifier.</p>', 'refs' => [], ], 'ClusterAssociatedToSchedule' => [ 'base' => '<p/>', 'refs' => [ 'AssociatedClusterList$member' => NULL, ], ], 'ClusterCredentials' => [ 'base' => '<p>Temporary credentials with authorization to log on to an Amazon Redshift database. </p>', 'refs' => [], ], 'ClusterDbRevision' => [ 'base' => '<p>Describes a <code>ClusterDbRevision</code>.</p>', 'refs' => [ 'ClusterDbRevisionsList$member' => NULL, ], ], 'ClusterDbRevisionsList' => [ 'base' => NULL, 'refs' => [ 'ClusterDbRevisionsMessage$ClusterDbRevisions' => '<p>A list of revisions.</p>', ], ], 'ClusterDbRevisionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'ClusterIamRole' => [ 'base' => '<p>An Identity and Access Management (IAM) role that can be used by the associated Amazon Redshift cluster to access other Amazon Web Services services.</p>', 'refs' => [ 'ClusterIamRoleList$member' => NULL, ], ], 'ClusterIamRoleList' => [ 'base' => NULL, 'refs' => [ 'Cluster$IamRoles' => '<p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.</p>', ], ], 'ClusterList' => [ 'base' => NULL, 'refs' => [ 'ClustersMessage$Clusters' => '<p>A list of <code>Cluster</code> objects, where each object describes one cluster. </p>', ], ], 'ClusterNode' => [ 'base' => '<p>The identifier of a node in a cluster.</p>', 'refs' => [ 'ClusterNodesList$member' => NULL, ], ], 'ClusterNodesList' => [ 'base' => NULL, 'refs' => [ 'Cluster$ClusterNodes' => '<p>The nodes in the cluster.</p>', ], ], 'ClusterNotFoundFault' => [ 'base' => '<p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>', 'refs' => [], ], 'ClusterOnLatestRevisionFault' => [ 'base' => '<p>Cluster is already on the latest database revision.</p>', 'refs' => [], ], 'ClusterParameterGroup' => [ 'base' => '<p>Describes a parameter group.</p>', 'refs' => [ 'CreateClusterParameterGroupResult$ClusterParameterGroup' => NULL, 'ParameterGroupList$member' => NULL, ], ], 'ClusterParameterGroupAlreadyExistsFault' => [ 'base' => '<p>A cluster parameter group with the same name already exists.</p>', 'refs' => [], ], 'ClusterParameterGroupDetails' => [ 'base' => '<p>Contains the output from the <a>DescribeClusterParameters</a> action. </p>', 'refs' => [], ], 'ClusterParameterGroupNameMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ClusterParameterGroupNotFoundFault' => [ 'base' => '<p>The parameter group name does not refer to an existing parameter group.</p>', 'refs' => [], ], 'ClusterParameterGroupQuotaExceededFault' => [ 'base' => '<p>The request would result in the user exceeding the allowed number of cluster parameter groups. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [], ], 'ClusterParameterGroupStatus' => [ 'base' => '<p>Describes the status of a parameter group.</p>', 'refs' => [ 'ClusterParameterGroupStatusList$member' => NULL, ], ], 'ClusterParameterGroupStatusList' => [ 'base' => NULL, 'refs' => [ 'Cluster$ClusterParameterGroups' => '<p>The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list is returned with its status.</p>', ], ], 'ClusterParameterGroupsMessage' => [ 'base' => '<p>Contains the output from the <a>DescribeClusterParameterGroups</a> action. </p>', 'refs' => [], ], 'ClusterParameterStatus' => [ 'base' => '<p>Describes the status of a parameter group.</p>', 'refs' => [ 'ClusterParameterStatusList$member' => NULL, ], ], 'ClusterParameterStatusList' => [ 'base' => NULL, 'refs' => [ 'ClusterParameterGroupStatus$ClusterParameterStatusList' => '<p>The list of parameter statuses.</p> <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', ], ], 'ClusterQuotaExceededFault' => [ 'base' => '<p>The request would exceed the allowed number of cluster instances for this account. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [], ], 'ClusterSecurityGroup' => [ 'base' => '<p>Describes a security group.</p>', 'refs' => [ 'AuthorizeClusterSecurityGroupIngressResult$ClusterSecurityGroup' => NULL, 'ClusterSecurityGroups$member' => NULL, 'CreateClusterSecurityGroupResult$ClusterSecurityGroup' => NULL, 'RevokeClusterSecurityGroupIngressResult$ClusterSecurityGroup' => NULL, ], ], 'ClusterSecurityGroupAlreadyExistsFault' => [ 'base' => '<p>A cluster security group with the same name already exists.</p>', 'refs' => [], ], 'ClusterSecurityGroupMembership' => [ 'base' => '<p>Describes a cluster security group.</p>', 'refs' => [ 'ClusterSecurityGroupMembershipList$member' => NULL, ], ], 'ClusterSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'Cluster$ClusterSecurityGroups' => '<p>A list of cluster security group that are associated with the cluster. Each security group is represented by an element that contains <code>ClusterSecurityGroup.Name</code> and <code>ClusterSecurityGroup.Status</code> subelements. </p> <p>Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the <b>VpcSecurityGroups</b> parameter. </p>', ], ], 'ClusterSecurityGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ClusterSecurityGroupNameList' => [ 'base' => NULL, 'refs' => [ 'CreateClusterMessage$ClusterSecurityGroups' => '<p>A list of security groups to be associated with this cluster.</p> <p>Default: The default cluster security group for Amazon Redshift.</p>', 'ModifyClusterMessage$ClusterSecurityGroups' => '<p>A list of cluster security groups to be authorized on this cluster. This change is asynchronously applied as soon as possible.</p> <p>Security groups currently associated with the cluster, and not in the list of groups to apply, will be revoked from the cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul>', 'RestoreFromClusterSnapshotMessage$ClusterSecurityGroups' => '<p>A list of security groups to be associated with this cluster.</p> <p>Default: The default cluster security group for Amazon Redshift.</p> <p>Cluster security groups only apply to clusters outside of VPCs.</p>', ], ], 'ClusterSecurityGroupNotFoundFault' => [ 'base' => '<p>The cluster security group name does not refer to an existing cluster security group.</p>', 'refs' => [], ], 'ClusterSecurityGroupQuotaExceededFault' => [ 'base' => '<p>The request would result in the user exceeding the allowed number of cluster security groups. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [], ], 'ClusterSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'ClusterSecurityGroupMessage$ClusterSecurityGroups' => '<p>A list of <a>ClusterSecurityGroup</a> instances. </p>', ], ], 'ClusterSnapshotAlreadyExistsFault' => [ 'base' => '<p>The value specified as a snapshot identifier is already used by an existing snapshot.</p>', 'refs' => [], ], 'ClusterSnapshotCopyStatus' => [ 'base' => '<p>Returns the destination region and retention period that are configured for cross-region snapshot copy.</p>', 'refs' => [ 'Cluster$ClusterSnapshotCopyStatus' => '<p>A value that returns the destination region and retention period that are configured for cross-region snapshot copy.</p>', ], ], 'ClusterSnapshotNotFoundFault' => [ 'base' => '<p>The snapshot identifier does not refer to an existing cluster snapshot.</p>', 'refs' => [], ], 'ClusterSnapshotQuotaExceededFault' => [ 'base' => '<p>The request would result in the user exceeding the allowed number of cluster snapshots.</p>', 'refs' => [], ], 'ClusterSubnetGroup' => [ 'base' => '<p>Describes a subnet group.</p>', 'refs' => [ 'ClusterSubnetGroups$member' => NULL, 'CreateClusterSubnetGroupResult$ClusterSubnetGroup' => NULL, 'ModifyClusterSubnetGroupResult$ClusterSubnetGroup' => NULL, ], ], 'ClusterSubnetGroupAlreadyExistsFault' => [ 'base' => '<p>A <i>ClusterSubnetGroupName</i> is already used by an existing cluster subnet group. </p>', 'refs' => [], ], 'ClusterSubnetGroupMessage' => [ 'base' => '<p>Contains the output from the <a>DescribeClusterSubnetGroups</a> action. </p>', 'refs' => [], ], 'ClusterSubnetGroupNotFoundFault' => [ 'base' => '<p>The cluster subnet group name does not refer to an existing cluster subnet group.</p>', 'refs' => [], ], 'ClusterSubnetGroupQuotaExceededFault' => [ 'base' => '<p>The request would result in user exceeding the allowed number of cluster subnet groups. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [], ], 'ClusterSubnetGroups' => [ 'base' => NULL, 'refs' => [ 'ClusterSubnetGroupMessage$ClusterSubnetGroups' => '<p>A list of <a>ClusterSubnetGroup</a> instances. </p>', ], ], 'ClusterSubnetQuotaExceededFault' => [ 'base' => '<p>The request would result in user exceeding the allowed number of subnets in a cluster subnet groups. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [], ], 'ClusterVersion' => [ 'base' => '<p>Describes a cluster version, including the parameter group family and description of the version.</p>', 'refs' => [ 'ClusterVersionList$member' => NULL, ], ], 'ClusterVersionList' => [ 'base' => NULL, 'refs' => [ 'ClusterVersionsMessage$ClusterVersions' => '<p>A list of <code>Version</code> elements. </p>', ], ], 'ClusterVersionsMessage' => [ 'base' => '<p>Contains the output from the <a>DescribeClusterVersions</a> action. </p>', 'refs' => [], ], 'ClustersMessage' => [ 'base' => '<p>Contains the output from the <a>DescribeClusters</a> action. </p>', 'refs' => [], ], 'CopyClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CopyClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyToRegionDisabledFault' => [ 'base' => '<p>Cross-region snapshot copy was temporarily disabled. Try your request again.</p>', 'refs' => [], ], 'CreateAuthenticationProfileMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateAuthenticationProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateClusterParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterSecurityGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateClusterSecurityGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateClusterSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointAccessMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateHsmClientCertificateMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateHsmClientCertificateResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateHsmConfigurationMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateHsmConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateScheduledActionMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotCopyGrantMessage' => [ 'base' => '<p>The result of the <code>CreateSnapshotCopyGrant</code> action.</p>', 'refs' => [], ], 'CreateSnapshotCopyGrantResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotScheduleMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateTagsMessage' => [ 'base' => '<p>Contains the output from the <code>CreateTags</code> action. </p>', 'refs' => [], ], 'CreateUsageLimitMessage' => [ 'base' => NULL, 'refs' => [], ], 'CustomerStorageMessage' => [ 'base' => NULL, 'refs' => [], ], 'DataShare' => [ 'base' => NULL, 'refs' => [ 'DataShareList$member' => NULL, ], ], 'DataShareAssociation' => [ 'base' => '<p>The association of a datashare from a producer account with a data consumer. </p>', 'refs' => [ 'DataShareAssociationList$member' => NULL, ], ], 'DataShareAssociationList' => [ 'base' => NULL, 'refs' => [ 'DataShare$DataShareAssociations' => '<p>A value that specifies when the datashare has an association between a producer and data consumers.</p>', ], ], 'DataShareList' => [ 'base' => NULL, 'refs' => [ 'DescribeDataSharesForConsumerResult$DataShares' => '<p>Shows the results of datashares available for consumers.</p>', 'DescribeDataSharesForProducerResult$DataShares' => '<p>Shows the results of datashares available for producers.</p>', 'DescribeDataSharesResult$DataShares' => '<p>The results returned from describing datashares.</p>', ], ], 'DataShareStatus' => [ 'base' => NULL, 'refs' => [ 'DataShareAssociation$Status' => '<p>The status of the datashare that is associated.</p>', ], ], 'DataShareStatusForConsumer' => [ 'base' => NULL, 'refs' => [ 'DescribeDataSharesForConsumerMessage$Status' => '<p>An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon Redshift returns the list of datashares that have the specified status.</p>', ], ], 'DataShareStatusForProducer' => [ 'base' => NULL, 'refs' => [ 'DescribeDataSharesForProducerMessage$Status' => '<p>An identifier giving the status of a datashare in the producer. If this field is specified, Amazon Redshift returns the list of datashares that have the specified status.</p>', ], ], 'DataTransferProgress' => [ 'base' => '<p>Describes the status of a cluster while it is in the process of resizing with an incremental resize.</p>', 'refs' => [ 'Cluster$DataTransferProgress' => '<p/>', ], ], 'DbGroupList' => [ 'base' => NULL, 'refs' => [ 'GetClusterCredentialsMessage$DbGroups' => '<p>A list of the names of existing database groups that the user named in <code>DbUser</code> will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to PUBLIC.</p> <p>Database group name constraints</p> <ul> <li> <p>Must be 1 to 64 alphanumeric characters or hyphens</p> </li> <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li> <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li> </ul>', ], ], 'DeauthorizeDataShareMessage' => [ 'base' => NULL, 'refs' => [], ], 'DefaultClusterParameters' => [ 'base' => '<p>Describes the default cluster parameters for a parameter group family.</p>', 'refs' => [ 'DescribeDefaultClusterParametersResult$DefaultClusterParameters' => NULL, ], ], 'DeferredMaintenanceWindow' => [ 'base' => '<p>Describes a deferred maintenance window</p>', 'refs' => [ 'DeferredMaintenanceWindowsList$member' => NULL, ], ], 'DeferredMaintenanceWindowsList' => [ 'base' => NULL, 'refs' => [ 'Cluster$DeferredMaintenanceWindows' => '<p>Describes a group of <code>DeferredMaintenanceWindow</code> objects.</p>', ], ], 'DeleteAuthenticationProfileMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAuthenticationProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterSecurityGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [ 'DeleteClusterSnapshotMessageList$member' => NULL, ], ], 'DeleteClusterSnapshotMessageList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteClusterSnapshotsRequest$Identifiers' => '<p>A list of identifiers for the snapshots that you want to delete.</p>', ], ], 'DeleteClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEndpointAccessMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteHsmClientCertificateMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteHsmConfigurationMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteScheduledActionMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotCopyGrantMessage' => [ 'base' => '<p>The result of the <code>DeleteSnapshotCopyGrant</code> action.</p>', 'refs' => [], ], 'DeleteSnapshotScheduleMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsMessage' => [ 'base' => '<p>Contains the output from the <code>DeleteTags</code> action. </p>', 'refs' => [], ], 'DeleteUsageLimitMessage' => [ 'base' => NULL, 'refs' => [], ], 'DependentServiceRequestThrottlingFault' => [ 'base' => '<p>The request cannot be completed because a dependent service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</p>', 'refs' => [], ], 'DependentServiceUnavailableFault' => [ 'base' => '<p>Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30 to 60 seconds and try again.</p>', 'refs' => [], ], 'DescribeAccountAttributesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuthenticationProfilesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuthenticationProfilesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterDbRevisionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterParameterGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeClusterParametersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeClusterSecurityGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeClusterSnapshotsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeClusterSubnetGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeClusterTracksMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterVersionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeClustersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDataSharesForConsumerMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSharesForConsumerResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSharesForProducerMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSharesForProducerResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSharesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSharesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDefaultClusterParametersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDefaultClusterParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointAccessMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointAuthorizationMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventCategoriesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventSubscriptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeHsmClientCertificatesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeHsmConfigurationsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeLoggingStatusMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeNodeConfigurationOptionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrderableClusterOptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribePartnersInputMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribePartnersOutputMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReservedNodeExchangeStatusInputMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReservedNodeExchangeStatusOutputMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReservedNodeOfferingsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReservedNodesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeResizeMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeScheduledActionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotCopyGrantsMessage' => [ 'base' => '<p>The result of the <code>DescribeSnapshotCopyGrants</code> action.</p>', 'refs' => [], ], 'DescribeSnapshotSchedulesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotSchedulesOutputMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTableRestoreStatusMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeTagsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeUsageLimitsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DisableLoggingMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DisableSnapshotCopyMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DisableSnapshotCopyResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDataShareConsumerMessage' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'CustomerStorageMessage$TotalBackupSizeInMegaBytes' => '<p>The total amount of storage currently used for snapshots.</p>', 'CustomerStorageMessage$TotalProvisionedStorageInMegaBytes' => '<p>The total amount of storage currently provisioned.</p>', 'RecurringCharge$RecurringChargeAmount' => '<p>The amount charged per the period of time specified by the recurring charge frequency.</p>', 'ReservedNode$FixedPrice' => '<p>The fixed cost Amazon Redshift charges you for this reserved node.</p>', 'ReservedNode$UsagePrice' => '<p>The hourly rate Amazon Redshift charges you for this reserved node.</p>', 'ReservedNodeOffering$FixedPrice' => '<p>The upfront fixed charge you will pay to purchase the specific reserved node offering.</p>', 'ReservedNodeOffering$UsagePrice' => '<p>The rate you are charged for each hour the cluster that is using the offering is running.</p>', 'RestoreStatus$CurrentRestoreRateInMegaBytesPerSecond' => '<p>The number of megabytes per second being transferred from the backup storage. Returns the average rate for a completed backup. This field is only updated when you restore to DC2 and DS2 node types. </p>', 'Snapshot$TotalBackupSizeInMegaBytes' => '<p>The size of the complete set of backup data that would be used to restore the cluster.</p>', 'Snapshot$ActualIncrementalBackupSizeInMegaBytes' => '<p>The size of the incremental backup.</p>', 'Snapshot$BackupProgressInMegaBytes' => '<p>The number of megabytes that have been transferred to the snapshot backup.</p>', 'Snapshot$CurrentBackupRateInMegaBytesPerSecond' => '<p>The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a completed backup. </p>', ], ], 'DoubleOptional' => [ 'base' => NULL, 'refs' => [ 'DataTransferProgress$CurrentRateInMegaBytesPerSecond' => '<p>Describes the data transfer rate in MB\'s per second.</p>', 'NodeConfigurationOption$EstimatedDiskUtilizationPercent' => '<p>The estimated disk utilizaton percentage.</p>', 'ResizeProgressMessage$AvgResizeRateInMegaBytesPerSecond' => '<p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>', 'ResizeProgressMessage$DataTransferProgressPercent' => '<p>The percent of data transferred from source cluster to target cluster.</p>', ], ], 'EC2SecurityGroup' => [ 'base' => '<p>Describes an Amazon EC2 security group.</p>', 'refs' => [ 'EC2SecurityGroupList$member' => NULL, ], ], 'EC2SecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'ClusterSecurityGroup$EC2SecurityGroups' => '<p>A list of EC2 security groups that are permitted to access clusters associated with this cluster security group.</p>', ], ], 'ElasticIpStatus' => [ 'base' => '<p>Describes the status of the elastic IP (EIP) address.</p>', 'refs' => [ 'Cluster$ElasticIpStatus' => '<p>The status of the elastic IP (EIP) address.</p>', ], ], 'EligibleTracksToUpdateList' => [ 'base' => NULL, 'refs' => [ 'MaintenanceTrack$UpdateTargets' => '<p>An array of <a>UpdateTarget</a> objects to update with the maintenance track. </p>', ], ], 'EnableLoggingMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'EnableSnapshotCopyMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'EnableSnapshotCopyResult' => [ 'base' => NULL, 'refs' => [], ], 'Endpoint' => [ 'base' => '<p>Describes a connection endpoint.</p>', 'refs' => [ 'Cluster$Endpoint' => '<p>The connection endpoint.</p>', ], ], 'EndpointAccess' => [ 'base' => '<p>Describes a Redshift-managed VPC endpoint.</p>', 'refs' => [ 'EndpointAccesses$member' => NULL, ], ], 'EndpointAccessList' => [ 'base' => NULL, 'refs' => [], ], 'EndpointAccesses' => [ 'base' => NULL, 'refs' => [ 'EndpointAccessList$EndpointAccessList' => '<p>The list of endpoints with access to the cluster.</p>', ], ], 'EndpointAlreadyExistsFault' => [ 'base' => '<p>The account already has a Redshift-managed VPC endpoint with the given identifier.</p>', 'refs' => [], ], 'EndpointAuthorization' => [ 'base' => '<p>Describes an endpoint authorization for authorizing Redshift-managed VPC endpoint access to a cluster across Amazon Web Services accounts.</p>', 'refs' => [ 'EndpointAuthorizations$member' => NULL, ], ], 'EndpointAuthorizationAlreadyExistsFault' => [ 'base' => '<p>The authorization already exists for this endpoint.</p>', 'refs' => [], ], 'EndpointAuthorizationList' => [ 'base' => NULL, 'refs' => [], ], 'EndpointAuthorizationNotFoundFault' => [ 'base' => '<p>The authorization for this endpoint can\'t be found.</p>', 'refs' => [], ], 'EndpointAuthorizations' => [ 'base' => NULL, 'refs' => [ 'EndpointAuthorizationList$EndpointAuthorizationList' => '<p>The authorizations to an endpoint.</p>', ], ], 'EndpointAuthorizationsPerClusterLimitExceededFault' => [ 'base' => '<p>The number of endpoint authorizations per cluster has exceeded its limit.</p>', 'refs' => [], ], 'EndpointNotFoundFault' => [ 'base' => '<p>The endpoint name doesn\'t refer to an existing endpoint.</p>', 'refs' => [], ], 'EndpointsPerAuthorizationLimitExceededFault' => [ 'base' => '<p>The number of Redshift-managed VPC endpoints per authorization has exceeded its limit.</p>', 'refs' => [], ], 'EndpointsPerClusterLimitExceededFault' => [ 'base' => '<p>The number of Redshift-managed VPC endpoints per cluster has exceeded its limit.</p>', 'refs' => [], ], 'Event' => [ 'base' => '<p>Describes an event.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventCategoriesList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$EventCategories' => '<p>Specifies the Amazon Redshift event categories to be published by the event notification subscription.</p> <p>Values: configuration, management, monitoring, security, pending</p>', 'Event$EventCategories' => '<p>A list of the event categories.</p> <p>Values: Configuration, Management, Monitoring, Security, Pending</p>', 'EventInfoMap$EventCategories' => '<p>The category of an Amazon Redshift event.</p>', 'EventSubscription$EventCategoriesList' => '<p>The list of Amazon Redshift event categories specified in the event notification subscription.</p> <p>Values: Configuration, Management, Monitoring, Security, Pending</p>', 'ModifyEventSubscriptionMessage$EventCategories' => '<p>Specifies the Amazon Redshift event categories to be published by the event notification subscription.</p> <p>Values: configuration, management, monitoring, security, pending</p>', ], ], 'EventCategoriesMap' => [ 'base' => '<p>Describes event categories.</p>', 'refs' => [ 'EventCategoriesMapList$member' => NULL, ], ], 'EventCategoriesMapList' => [ 'base' => NULL, 'refs' => [ 'EventCategoriesMessage$EventCategoriesMapList' => '<p>A list of event categories descriptions.</p>', ], ], 'EventCategoriesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'EventInfoMap' => [ 'base' => '<p>Describes event information.</p>', 'refs' => [ 'EventInfoMapList$member' => NULL, ], ], 'EventInfoMapList' => [ 'base' => NULL, 'refs' => [ 'EventCategoriesMap$Events' => '<p>The events in the event category.</p>', ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'EventsMessage$Events' => '<p>A list of <code>Event</code> instances. </p>', ], ], 'EventSubscription' => [ 'base' => '<p>Describes event subscriptions.</p>', 'refs' => [ 'CreateEventSubscriptionResult$EventSubscription' => NULL, 'EventSubscriptionsList$member' => NULL, 'ModifyEventSubscriptionResult$EventSubscription' => NULL, ], ], 'EventSubscriptionQuotaExceededFault' => [ 'base' => '<p>The request would exceed the allowed number of event subscriptions for this account. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [], ], 'EventSubscriptionsList' => [ 'base' => NULL, 'refs' => [ 'EventSubscriptionsMessage$EventSubscriptionsList' => '<p>A list of event subscriptions.</p>', ], ], 'EventSubscriptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'EventsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'GetClusterCredentialsMessage' => [ 'base' => '<p>The request parameters to get cluster credentials.</p>', 'refs' => [], ], 'GetReservedNodeExchangeConfigurationOptionsInputMessage' => [ 'base' => NULL, 'refs' => [], ], 'GetReservedNodeExchangeConfigurationOptionsOutputMessage' => [ 'base' => NULL, 'refs' => [], ], 'GetReservedNodeExchangeOfferingsInputMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'GetReservedNodeExchangeOfferingsOutputMessage' => [ 'base' => NULL, 'refs' => [], ], 'HsmClientCertificate' => [ 'base' => '<p>Returns information about an HSM client certificate. The certificate is stored in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift cluster to encrypt data files.</p>', 'refs' => [ 'CreateHsmClientCertificateResult$HsmClientCertificate' => NULL, 'HsmClientCertificateList$member' => NULL, ], ], 'HsmClientCertificateAlreadyExistsFault' => [ 'base' => '<p>There is already an existing Amazon Redshift HSM client certificate with the specified identifier.</p>', 'refs' => [], ], 'HsmClientCertificateList' => [ 'base' => NULL, 'refs' => [ 'HsmClientCertificateMessage$HsmClientCertificates' => '<p>A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store and retrieve database encryption keys in an HSM.</p>', ], ], 'HsmClientCertificateMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'HsmClientCertificateNotFoundFault' => [ 'base' => '<p>There is no Amazon Redshift HSM client certificate with the specified identifier.</p>', 'refs' => [], ], 'HsmClientCertificateQuotaExceededFault' => [ 'base' => '<p>The quota for HSM client certificates has been reached. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [], ], 'HsmConfiguration' => [ 'base' => '<p>Returns information about an HSM configuration, which is an object that describes to Amazon Redshift clusters the information they require to connect to an HSM where they can store database encryption keys.</p>', 'refs' => [ 'CreateHsmConfigurationResult$HsmConfiguration' => NULL, 'HsmConfigurationList$member' => NULL, ], ], 'HsmConfigurationAlreadyExistsFault' => [ 'base' => '<p>There is already an existing Amazon Redshift HSM configuration with the specified identifier.</p>', 'refs' => [], ], 'HsmConfigurationList' => [ 'base' => NULL, 'refs' => [ 'HsmConfigurationMessage$HsmConfigurations' => '<p>A list of <code>HsmConfiguration</code> objects.</p>', ], ], 'HsmConfigurationMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'HsmConfigurationNotFoundFault' => [ 'base' => '<p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>', 'refs' => [], ], 'HsmConfigurationQuotaExceededFault' => [ 'base' => '<p>The quota for HSM configurations has been reached. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [], ], 'HsmStatus' => [ 'base' => '<p>Describes the status of changes to HSM settings.</p>', 'refs' => [ 'Cluster$HsmStatus' => '<p>A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module (HSM) settings changes specified in a modify cluster command.</p> <p>Values: active, applying</p>', ], ], 'IPRange' => [ 'base' => '<p>Describes an IP range used in a security group.</p>', 'refs' => [ 'IPRangeList$member' => NULL, ], ], 'IPRangeList' => [ 'base' => NULL, 'refs' => [ 'ClusterSecurityGroup$IPRanges' => '<p>A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster security group.</p>', ], ], 'IamRoleArnList' => [ 'base' => NULL, 'refs' => [ 'CreateClusterMessage$IamRoles' => '<p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. </p> <p>The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', 'ModifyClusterIamRolesMessage$AddIamRoles' => '<p>Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name (ARN) format. </p>', 'ModifyClusterIamRolesMessage$RemoveIamRoles' => '<p>Zero or more IAM roles in ARN format to disassociate from the cluster. </p>', 'RestoreFromClusterSnapshotMessage$IamRoles' => '<p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. </p> <p>The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', ], ], 'ImportTablesCompleted' => [ 'base' => NULL, 'refs' => [ 'ResizeProgressMessage$ImportTablesCompleted' => '<p>The names of tables that have been completely imported .</p> <p>Valid Values: List of table names.</p>', ], ], 'ImportTablesInProgress' => [ 'base' => NULL, 'refs' => [ 'ResizeProgressMessage$ImportTablesInProgress' => '<p>The names of tables that are being currently imported.</p> <p>Valid Values: List of table names.</p>', ], ], 'ImportTablesNotStarted' => [ 'base' => NULL, 'refs' => [ 'ResizeProgressMessage$ImportTablesNotStarted' => '<p>The names of tables that have not been yet imported.</p> <p>Valid Values: List of table names</p>', ], ], 'InProgressTableRestoreQuotaExceededFault' => [ 'base' => '<p>You have exceeded the allowed number of table restore requests. Wait for your current table restore requests to complete before making a new request.</p>', 'refs' => [], ], 'IncompatibleOrderableOptions' => [ 'base' => '<p>The specified options are incompatible.</p>', 'refs' => [], ], 'InsufficientClusterCapacityFault' => [ 'base' => '<p>The number of nodes specified exceeds the allotted capacity of the cluster.</p>', 'refs' => [], ], 'InsufficientS3BucketPolicyFault' => [ 'base' => '<p>The cluster does not have read bucket or put object permissions on the S3 bucket specified when enabling logging.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Cluster$AutomatedSnapshotRetentionPeriod' => '<p>The number of days that automatic cluster snapshots are retained.</p>', 'Cluster$ManualSnapshotRetentionPeriod' => '<p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn\'t change the retention period of existing snapshots.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>', 'Cluster$NumberOfNodes' => '<p>The number of compute nodes in the cluster.</p>', 'ClusterSnapshotCopyStatus$ManualSnapshotRetentionPeriod' => '<p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region. If the value is -1, the manual snapshot is retained indefinitely. </p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>', 'Endpoint$Port' => '<p>The port that the database engine is listening on.</p>', 'EndpointAccess$Port' => '<p>The port number on which the cluster accepts incoming connections.</p>', 'EndpointAuthorization$EndpointCount' => '<p>The number of Redshift-managed VPC endpoints created for the authorization.</p>', 'ModifySnapshotCopyRetentionPeriodMessage$RetentionPeriod' => '<p>The number of days to retain automated snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region.</p> <p>By default, this only changes the retention period of copied automated snapshots. </p> <p>If you decrease the retention period for automated snapshots that are copied to a destination Amazon Web Services Region, Amazon Redshift deletes any existing automated snapshots that were copied to the destination Amazon Web Services Region and that fall outside of the new retention period.</p> <p>Constraints: Must be at least 1 and no more than 35 for automated snapshots. </p> <p>If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new retention period. </p> <p>If you specify the value of -1 newly copied manual snapshots are retained indefinitely.</p> <p>Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.</p>', 'NodeConfigurationOption$NumberOfNodes' => '<p>The number of nodes.</p>', 'ReservedNode$Duration' => '<p>The duration of the node reservation in seconds.</p>', 'ReservedNode$NodeCount' => '<p>The number of reserved compute nodes.</p>', 'ReservedNodeConfigurationOption$TargetReservedNodeCount' => '<p>The target reserved-node count.</p>', 'ReservedNodeExchangeStatus$SourceReservedNodeCount' => '<p>The source reserved-node count in the cluster.</p>', 'ReservedNodeExchangeStatus$TargetReservedNodeCount' => '<p>The count of target reserved nodes in the cluster.</p>', 'ReservedNodeOffering$Duration' => '<p>The duration, in seconds, for which the offering will reserve the node.</p>', 'Snapshot$Port' => '<p>The port that the cluster is listening on.</p>', 'Snapshot$NumberOfNodes' => '<p>The number of nodes in the cluster.</p>', ], ], 'IntegerOptional' => [ 'base' => NULL, 'refs' => [ 'BatchModifyClusterSnapshotsMessage$ManualSnapshotRetentionPeriod' => '<p>The number of days that a manual snapshot is retained. If you specify the value -1, the manual snapshot is retained indefinitely.</p> <p>The number must be either -1 or an integer between 1 and 3,653.</p> <p>If you decrease the manual snapshot retention period from its current value, existing manual snapshots that fall outside of the new retention period will return an error. If you want to suppress the errors and delete the snapshots, use the force option. </p>', 'CopyClusterSnapshotMessage$ManualSnapshotRetentionPeriod' => '<p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p> <p>The value must be either -1 or an integer between 1 and 3,653.</p> <p>The default value is -1.</p>', 'CreateClusterMessage$AutomatedSnapshotRetentionPeriod' => '<p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p> <p>You can\'t disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p> <p>Default: <code>1</code> </p> <p>Constraints: Must be a value from 0 to 35.</p>', 'CreateClusterMessage$ManualSnapshotRetentionPeriod' => '<p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn\'t change the retention period of existing snapshots.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>', 'CreateClusterMessage$Port' => '<p>The port number on which the cluster accepts incoming connections.</p> <p>The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.</p> <p>Default: <code>5439</code> </p> <p>Valid Values: <code>1150-65535</code> </p>', 'CreateClusterMessage$NumberOfNodes' => '<p>The number of compute nodes in the cluster. This parameter is required when the <b>ClusterType</b> parameter is specified as <code>multi-node</code>. </p> <p>For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p> <p>If you don\'t specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.</p> <p>Default: <code>1</code> </p> <p>Constraints: Value must be at least 1 and no more than 100.</p>', 'CreateClusterSnapshotMessage$ManualSnapshotRetentionPeriod' => '<p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p> <p>The value must be either -1 or an integer between 1 and 3,653.</p> <p>The default value is -1.</p>', 'CreateSnapshotScheduleMessage$NextInvocations' => '<p/>', 'DeleteClusterMessage$FinalClusterSnapshotRetentionPeriod' => '<p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p> <p>The default value is -1.</p>', 'DescribeClusterDbRevisionsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in the <code>marker</code> field of the response. You can retrieve the next set of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p> <p>Default: 100</p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeClusterParameterGroupsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeClusterParametersMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeClusterSecurityGroupsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeClusterSnapshotsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeClusterSubnetGroupsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeClusterTracksMessage$MaxRecords' => '<p>An integer value for the maximum number of maintenance tracks to return.</p>', 'DescribeClusterVersionsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeClustersMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeDataSharesForConsumerMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>', 'DescribeDataSharesForProducerMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>', 'DescribeDataSharesMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>', 'DescribeDefaultClusterParametersMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeEndpointAccessMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so that the remaining results can be retrieved.</p>', 'DescribeEndpointAuthorizationMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so that the remaining results can be retrieved.</p>', 'DescribeEventSubscriptionsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeEventsMessage$Duration' => '<p>The number of minutes prior to the time of the request for which to retrieve events. For example, if the request is sent at 18:00 and you specify a duration of 60, then only events which have occurred after 17:00 will be returned.</p> <p>Default: <code>60</code> </p>', 'DescribeEventsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeHsmClientCertificatesMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeHsmConfigurationsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeNodeConfigurationOptionsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>500</code> </p> <p>Constraints: minimum 100, maximum 500.</p>', 'DescribeOrderableClusterOptionsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeReservedNodeExchangeStatusInputMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.</p>', 'DescribeReservedNodeOfferingsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeReservedNodesMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeScheduledActionsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeSnapshotCopyGrantsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'DescribeSnapshotSchedulesMessage$MaxRecords' => '<p>The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned <code>marker</code> value.</p>', 'DescribeTableRestoreStatusMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>', 'DescribeTagsMessage$MaxRecords' => '<p>The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned <code>marker</code> value. </p>', 'DescribeUsageLimitsMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>', 'EnableSnapshotCopyMessage$RetentionPeriod' => '<p>The number of days to retain automated snapshots in the destination region after they are copied from the source region.</p> <p>Default: 7.</p> <p>Constraints: Must be at least 1 and no more than 35.</p>', 'EnableSnapshotCopyMessage$ManualSnapshotRetentionPeriod' => '<p>The number of days to retain newly copied snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. If the value is -1, the manual snapshot is retained indefinitely. </p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>', 'GetClusterCredentialsMessage$DurationSeconds' => '<p>The number of seconds until the returned temporary password expires.</p> <p>Constraint: minimum 900, maximum 3600.</p> <p>Default: 900</p>', 'GetReservedNodeExchangeConfigurationOptionsInputMessage$MaxRecords' => '<p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.</p>', 'GetReservedNodeExchangeOfferingsInputMessage$MaxRecords' => '<p>An integer setting the maximum number of ReservedNodeOfferings to retrieve.</p>', 'ModifyClusterMaintenanceMessage$DeferMaintenanceDuration' => '<p>An integer indicating the duration of the maintenance window in days. If you specify a duration, you can\'t specify an end time. The duration must be 45 days or less.</p>', 'ModifyClusterMessage$NumberOfNodes' => '<p>The new number of nodes of the cluster. If you specify a new number of nodes, you must also specify the node type parameter.</p> <p> For more information about resizing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>Valid Values: Integer greater than <code>0</code>.</p>', 'ModifyClusterMessage$AutomatedSnapshotRetentionPeriod' => '<p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p> <p>If you decrease the automated snapshot retention period from its current value, existing automated snapshots that fall outside of the new retention period will be immediately deleted.</p> <p>You can\'t disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p> <p>Default: Uses existing setting.</p> <p>Constraints: Must be a value from 0 to 35.</p>', 'ModifyClusterMessage$ManualSnapshotRetentionPeriod' => '<p>The default for number of days that a newly created manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. This value doesn\'t retroactively change the retention periods of existing manual snapshots.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p> <p>The default value is -1.</p>', 'ModifyClusterMessage$Port' => '<p>The option to change the port of an Amazon Redshift cluster.</p>', 'ModifyClusterSnapshotMessage$ManualSnapshotRetentionPeriod' => '<p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.</p> <p>If the manual snapshot falls outside of the new retention period, you can specify the force option to immediately delete the snapshot.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>', 'PendingModifiedValues$NumberOfNodes' => '<p>The pending or in-progress change of the number of nodes in the cluster.</p>', 'PendingModifiedValues$AutomatedSnapshotRetentionPeriod' => '<p>The pending or in-progress change of the automated snapshot retention period.</p>', 'PurchaseReservedNodeOfferingMessage$NodeCount' => '<p>The number of reserved nodes that you want to purchase.</p> <p>Default: <code>1</code> </p>', 'ResizeClusterMessage$NumberOfNodes' => '<p>The new number of nodes for the cluster. If not specified, the cluster\'s current number of nodes is used.</p>', 'ResizeProgressMessage$TargetNumberOfNodes' => '<p>The number of nodes that the cluster will have after the resize operation is complete.</p>', 'RestoreFromClusterSnapshotMessage$Port' => '<p>The port number on which the cluster accepts connections.</p> <p>Default: The same port as the original cluster.</p> <p>Constraints: Must be between <code>1115</code> and <code>65535</code>.</p>', 'RestoreFromClusterSnapshotMessage$AutomatedSnapshotRetentionPeriod' => '<p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p> <p>You can\'t disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p> <p>Default: The value selected for the cluster from which the snapshot was taken.</p> <p>Constraints: Must be a value from 0 to 35.</p>', 'RestoreFromClusterSnapshotMessage$ManualSnapshotRetentionPeriod' => '<p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn\'t change the retention period of existing snapshots.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>', 'RestoreFromClusterSnapshotMessage$NumberOfNodes' => '<p>The number of nodes specified when provisioning the restored cluster.</p>', 'Snapshot$ManualSnapshotRetentionPeriod' => '<p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>', 'Snapshot$ManualSnapshotRemainingDays' => '<p>The number of days until a manual snapshot will pass its retention period.</p>', 'SnapshotSchedule$AssociatedClusterCount' => '<p>The number of clusters associated with the schedule.</p>', ], ], 'InvalidAuthenticationProfileRequestFault' => [ 'base' => '<p>The authentication profile request is not valid. The profile name can\'t be null or empty. The authentication profile API operation must be available in the Amazon Web Services Region.</p>', 'refs' => [], ], 'InvalidAuthorizationStateFault' => [ 'base' => '<p>The status of the authorization is not valid.</p>', 'refs' => [], ], 'InvalidClusterParameterGroupStateFault' => [ 'base' => '<p>The cluster parameter group action can not be completed because another task is in progress that involves the parameter group. Wait a few moments and try the operation again.</p>', 'refs' => [], ], 'InvalidClusterSecurityGroupStateFault' => [ 'base' => '<p>The state of the cluster security group is not <code>available</code>. </p>', 'refs' => [], ], 'InvalidClusterSnapshotScheduleStateFault' => [ 'base' => '<p>The cluster snapshot schedule state is not valid.</p>', 'refs' => [], ], 'InvalidClusterSnapshotStateFault' => [ 'base' => '<p>The specified cluster snapshot is not in the <code>available</code> state, or other accounts are authorized to access the snapshot. </p>', 'refs' => [], ], 'InvalidClusterStateFault' => [ 'base' => '<p>The specified cluster is not in the <code>available</code> state. </p>', 'refs' => [], ], 'InvalidClusterSubnetGroupStateFault' => [ 'base' => '<p>The cluster subnet group cannot be deleted because it is in use.</p>', 'refs' => [], ], 'InvalidClusterSubnetStateFault' => [ 'base' => '<p>The state of the subnet is invalid.</p>', 'refs' => [], ], 'InvalidClusterTrackFault' => [ 'base' => '<p>The provided cluster track name is not valid.</p>', 'refs' => [], ], 'InvalidDataShareFault' => [ 'base' => '<p>There is an error with the datashare.</p>', 'refs' => [], ], 'InvalidElasticIpFault' => [ 'base' => '<p>The Elastic IP (EIP) is invalid or cannot be found.</p>', 'refs' => [], ], 'InvalidEndpointStateFault' => [ 'base' => '<p>The status of the endpoint is not valid.</p>', 'refs' => [], ], 'InvalidHsmClientCertificateStateFault' => [ 'base' => '<p>The specified HSM client certificate is not in the <code>available</code> state, or it is still in use by one or more Amazon Redshift clusters.</p>', 'refs' => [], ], 'InvalidHsmConfigurationStateFault' => [ 'base' => '<p>The specified HSM configuration is not in the <code>available</code> state, or it is still in use by one or more Amazon Redshift clusters.</p>', 'refs' => [], ], 'InvalidNamespaceFault' => [ 'base' => '<p>The namespace isn\'t valid because the namespace doesn\'t exist. Provide a valid namespace.</p>', 'refs' => [], ], 'InvalidReservedNodeStateFault' => [ 'base' => '<p>Indicates that the Reserved Node being exchanged is not in an active state.</p>', 'refs' => [], ], 'InvalidRestoreFault' => [ 'base' => '<p>The restore is invalid.</p>', 'refs' => [], ], 'InvalidRetentionPeriodFault' => [ 'base' => '<p>The retention period specified is either in the past or is not a valid value.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>', 'refs' => [], ], 'InvalidS3BucketNameFault' => [ 'base' => '<p>The S3 bucket name is invalid. For more information about naming rules, go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and Limitations</a> in the Amazon Simple Storage Service (S3) Developer Guide.</p>', 'refs' => [], ], 'InvalidS3KeyPrefixFault' => [ 'base' => '<p>The string specified for the logging S3 key prefix does not comply with the documented constraints.</p>', 'refs' => [], ], 'InvalidScheduleFault' => [ 'base' => '<p>The schedule you submitted isn\'t valid.</p>', 'refs' => [], ], 'InvalidScheduledActionFault' => [ 'base' => '<p>The scheduled action is not valid. </p>', 'refs' => [], ], 'InvalidSnapshotCopyGrantStateFault' => [ 'base' => '<p>The snapshot copy grant can\'t be deleted because it is used by one or more clusters.</p>', 'refs' => [], ], 'InvalidSubnet' => [ 'base' => '<p>The requested subnet is not valid, or not all of the subnets are in the same VPC.</p>', 'refs' => [], ], 'InvalidSubscriptionStateFault' => [ 'base' => '<p>The subscription request is invalid because it is a duplicate request. This subscription request is already in progress.</p>', 'refs' => [], ], 'InvalidTableRestoreArgumentFault' => [ 'base' => '<p>The value specified for the <code>sourceDatabaseName</code>, <code>sourceSchemaName</code>, or <code>sourceTableName</code> parameter, or a combination of these, doesn\'t exist in the snapshot.</p>', 'refs' => [], ], 'InvalidTagFault' => [ 'base' => '<p>The tag is invalid.</p>', 'refs' => [], ], 'InvalidUsageLimitFault' => [ 'base' => '<p>The usage limit is not valid.</p>', 'refs' => [], ], 'InvalidVPCNetworkStateFault' => [ 'base' => '<p>The cluster subnet group does not cover all Availability Zones.</p>', 'refs' => [], ], 'LimitExceededFault' => [ 'base' => '<p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>', 'refs' => [], ], 'LogDestinationType' => [ 'base' => NULL, 'refs' => [ 'EnableLoggingMessage$LogDestinationType' => '<p>The log destination type. An enum with possible values of <code>s3</code> and <code>cloudwatch</code>.</p>', 'LoggingStatus$LogDestinationType' => '<p>The log destination type. An enum with possible values of <code>s3</code> and <code>cloudwatch</code>.</p>', ], ], 'LogTypeList' => [ 'base' => NULL, 'refs' => [ 'EnableLoggingMessage$LogExports' => '<p>The collection of exported log types. Log types include the connection log, user log and user activity log.</p>', 'LoggingStatus$LogExports' => '<p>The collection of exported log types. Log types include the connection log, user log and user activity log.</p>', ], ], 'LoggingStatus' => [ 'base' => '<p>Describes the status of logging for a cluster.</p>', 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ClusterSnapshotCopyStatus$RetentionPeriod' => '<p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region.</p>', 'CreateUsageLimitMessage$Amount' => '<p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number. </p>', 'DataTransferProgress$TotalDataInMegaBytes' => '<p>Describes the total amount of data to be transfered in megabytes.</p>', 'DataTransferProgress$DataTransferredInMegaBytes' => '<p>Describes the total amount of data that has been transfered in MB\'s.</p>', 'RestoreStatus$SnapshotSizeInMegaBytes' => '<p>The size of the set of snapshot data used to restore the cluster. This field is only updated when you restore to DC2 and DS2 node types. </p>', 'RestoreStatus$ProgressInMegaBytes' => '<p>The number of megabytes that have been transferred from snapshot storage. This field is only updated when you restore to DC2 and DS2 node types. </p>', 'RestoreStatus$ElapsedTimeInSeconds' => '<p>The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to finish. This field is only updated when you restore to DC2 and DS2 node types. </p>', 'RestoreStatus$EstimatedTimeToCompletionInSeconds' => '<p>The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore. This field is only updated when you restore to DC2 and DS2 node types. </p>', 'Snapshot$EstimatedSecondsToCompletion' => '<p>The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a completed backup. </p>', 'Snapshot$ElapsedTimeInSeconds' => '<p>The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed backup to finish.</p>', 'UsageLimit$Amount' => '<p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>', ], ], 'LongOptional' => [ 'base' => NULL, 'refs' => [ 'Cluster$TotalStorageCapacityInMegaBytes' => '<p>The total storage capacity of the cluster in megabytes. </p>', 'DataTransferProgress$EstimatedTimeToCompletionInSeconds' => '<p>Describes the estimated number of seconds remaining to complete the transfer.</p>', 'DataTransferProgress$ElapsedTimeInSeconds' => '<p>Describes the number of seconds that have elapsed during the data transfer.</p>', 'ModifyUsageLimitMessage$Amount' => '<p>The new limit amount. For more information about this parameter, see <a>UsageLimit</a>. </p>', 'ResizeProgressMessage$TotalResizeDataInMegaBytes' => '<p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>', 'ResizeProgressMessage$ProgressInMegaBytes' => '<p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>', 'ResizeProgressMessage$ElapsedTimeInSeconds' => '<p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>', 'ResizeProgressMessage$EstimatedTimeToCompletionInSeconds' => '<p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>', 'TableRestoreStatus$ProgressInMegaBytes' => '<p>The amount of data restored to the new table so far, in megabytes (MB).</p>', 'TableRestoreStatus$TotalDataInMegaBytes' => '<p>The total amount of data to restore to the new table, in megabytes (MB).</p>', ], ], 'MaintenanceTrack' => [ 'base' => '<p>Defines a maintenance track that determines which Amazon Redshift version to apply during a maintenance window. If the value for <code>MaintenanceTrack</code> is <code>current</code>, the cluster is updated to the most recently certified maintenance release. If the value is <code>trailing</code>, the cluster is updated to the previously certified maintenance release. </p>', 'refs' => [ 'TrackList$member' => NULL, ], ], 'Mode' => [ 'base' => NULL, 'refs' => [ 'NodeConfigurationOption$Mode' => '<p>The category of the node configuration recommendation.</p>', ], ], 'ModifyAquaInputMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyAquaOutputMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyAuthenticationProfileMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyAuthenticationProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterDbRevisionMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterDbRevisionResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterIamRolesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyClusterIamRolesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterMaintenanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterMaintenanceResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyClusterParameterGroupMessage' => [ 'base' => '<p>Describes a modify cluster parameter group operation. </p>', 'refs' => [], ], 'ModifyClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterSnapshotMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterSnapshotScheduleMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyClusterSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyEndpointAccessMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyScheduledActionMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifySnapshotCopyRetentionPeriodMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifySnapshotCopyRetentionPeriodResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifySnapshotScheduleMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyUsageLimitMessage' => [ 'base' => NULL, 'refs' => [], ], 'NetworkInterface' => [ 'base' => '<p>Describes a network interface. </p>', 'refs' => [ 'NetworkInterfaceList$member' => NULL, ], ], 'NetworkInterfaceList' => [ 'base' => NULL, 'refs' => [ 'VpcEndpoint$NetworkInterfaces' => '<p>One or more network interfaces of the endpoint. Also known as an interface endpoint. </p>', ], ], 'NodeConfigurationOption' => [ 'base' => '<p>A list of node configurations.</p>', 'refs' => [ 'NodeConfigurationOptionList$member' => NULL, ], ], 'NodeConfigurationOptionList' => [ 'base' => NULL, 'refs' => [ 'NodeConfigurationOptionsMessage$NodeConfigurationOptionList' => '<p>A list of valid node configurations.</p>', ], ], 'NodeConfigurationOptionsFilter' => [ 'base' => '<p>A set of elements to filter the returned node configurations.</p>', 'refs' => [ 'NodeConfigurationOptionsFilterList$member' => NULL, ], ], 'NodeConfigurationOptionsFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeNodeConfigurationOptionsMessage$Filters' => '<p>A set of name, operator, and value items to filter the results.</p>', ], ], 'NodeConfigurationOptionsFilterName' => [ 'base' => NULL, 'refs' => [ 'NodeConfigurationOptionsFilter$Name' => '<p>The name of the element to filter.</p>', ], ], 'NodeConfigurationOptionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'NumberOfNodesPerClusterLimitExceededFault' => [ 'base' => '<p>The operation would exceed the number of nodes allowed for a cluster.</p>', 'refs' => [], ], 'NumberOfNodesQuotaExceededFault' => [ 'base' => '<p>The operation would exceed the number of nodes allotted to the account. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [], ], 'OperatorType' => [ 'base' => NULL, 'refs' => [ 'NodeConfigurationOptionsFilter$Operator' => '<p>The filter operator. If filter Name is NodeType only the \'in\' operator is supported. Provide one value to evaluate for \'eq\', \'lt\', \'le\', \'gt\', and \'ge\'. Provide two values to evaluate for \'between\'. Provide a list of values for \'in\'.</p>', ], ], 'OrderableClusterOption' => [ 'base' => '<p>Describes an orderable cluster option.</p>', 'refs' => [ 'OrderableClusterOptionsList$member' => NULL, ], ], 'OrderableClusterOptionsList' => [ 'base' => NULL, 'refs' => [ 'OrderableClusterOptionsMessage$OrderableClusterOptions' => '<p>An <code>OrderableClusterOption</code> structure containing information about orderable options for the cluster.</p>', ], ], 'OrderableClusterOptionsMessage' => [ 'base' => '<p>Contains the output from the <a>DescribeOrderableClusterOptions</a> action. </p>', 'refs' => [], ], 'Parameter' => [ 'base' => '<p>Describes a parameter in a cluster parameter group.</p>', 'refs' => [ 'ParametersList$member' => NULL, ], ], 'ParameterApplyType' => [ 'base' => NULL, 'refs' => [ 'Parameter$ApplyType' => '<p>Specifies how to apply the WLM configuration parameter. Some properties can be applied dynamically, while other properties require that any associated clusters be rebooted for the configuration changes to be applied. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>', ], ], 'ParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'ClusterParameterGroupsMessage$ParameterGroups' => '<p>A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group. </p>', ], ], 'ParametersList' => [ 'base' => NULL, 'refs' => [ 'ClusterParameterGroupDetails$Parameters' => '<p>A list of <a>Parameter</a> instances. Each instance lists the parameters of one cluster parameter group. </p>', 'DefaultClusterParameters$Parameters' => '<p>The list of cluster default parameters.</p>', 'ModifyClusterParameterGroupMessage$Parameters' => '<p>An array of parameters to be modified. A maximum of 20 parameters can be modified in a single request.</p> <p>For each parameter to be modified, you must supply at least the parameter name and parameter value; other name-value pairs of the parameter are optional.</p> <p>For the workload management (WLM) configuration, you must supply all the name-value pairs in the wlm_json_configuration parameter.</p>', 'ResetClusterParameterGroupMessage$Parameters' => '<p>An array of names of parameters to be reset. If <i>ResetAllParameters</i> option is not used, then at least one parameter name must be supplied. </p> <p>Constraints: A maximum of 20 parameters can be reset in a single request.</p>', ], ], 'PartnerIntegrationAccountId' => [ 'base' => NULL, 'refs' => [ 'DescribePartnersInputMessage$AccountId' => '<p>The Amazon Web Services account ID that owns the cluster.</p>', 'PartnerIntegrationInputMessage$AccountId' => '<p>The Amazon Web Services account ID that owns the cluster.</p>', 'UpdatePartnerStatusInputMessage$AccountId' => '<p>The Amazon Web Services account ID that owns the cluster.</p>', ], ], 'PartnerIntegrationClusterIdentifier' => [ 'base' => NULL, 'refs' => [ 'DescribePartnersInputMessage$ClusterIdentifier' => '<p>The cluster identifier of the cluster whose partner integration is being described.</p>', 'PartnerIntegrationInputMessage$ClusterIdentifier' => '<p>The cluster identifier of the cluster that receives data from the partner.</p>', 'UpdatePartnerStatusInputMessage$ClusterIdentifier' => '<p>The cluster identifier of the cluster whose partner integration status is being updated.</p>', ], ], 'PartnerIntegrationDatabaseName' => [ 'base' => NULL, 'refs' => [ 'DescribePartnersInputMessage$DatabaseName' => '<p>The name of the database whose partner integration is being described. If database name is not specified, then all databases in the cluster are described.</p>', 'PartnerIntegrationInfo$DatabaseName' => '<p>The name of the database that receives data from a partner.</p>', 'PartnerIntegrationInputMessage$DatabaseName' => '<p>The name of the database that receives data from the partner.</p>', 'PartnerIntegrationOutputMessage$DatabaseName' => '<p>The name of the database that receives data from the partner.</p>', 'UpdatePartnerStatusInputMessage$DatabaseName' => '<p>The name of the database whose partner integration status is being updated.</p>', ], ], 'PartnerIntegrationInfo' => [ 'base' => '<p>Describes a partner integration.</p>', 'refs' => [ 'PartnerIntegrationInfoList$member' => NULL, ], ], 'PartnerIntegrationInfoList' => [ 'base' => NULL, 'refs' => [ 'DescribePartnersOutputMessage$PartnerIntegrationInfoList' => '<p>A list of partner integrations.</p>', ], ], 'PartnerIntegrationInputMessage' => [ 'base' => NULL, 'refs' => [], ], 'PartnerIntegrationOutputMessage' => [ 'base' => NULL, 'refs' => [], ], 'PartnerIntegrationPartnerName' => [ 'base' => NULL, 'refs' => [ 'DescribePartnersInputMessage$PartnerName' => '<p>The name of the partner that is being described. If partner name is not specified, then all partner integrations are described.</p>', 'PartnerIntegrationInfo$PartnerName' => '<p>The name of the partner.</p>', 'PartnerIntegrationInputMessage$PartnerName' => '<p>The name of the partner that is authorized to send data.</p>', 'PartnerIntegrationOutputMessage$PartnerName' => '<p>The name of the partner that is authorized to send data.</p>', 'UpdatePartnerStatusInputMessage$PartnerName' => '<p>The name of the partner whose integration status is being updated.</p>', ], ], 'PartnerIntegrationStatus' => [ 'base' => NULL, 'refs' => [ 'PartnerIntegrationInfo$Status' => '<p>The partner integration status.</p>', 'UpdatePartnerStatusInputMessage$Status' => '<p>The value of the updated status.</p>', ], ], 'PartnerIntegrationStatusMessage' => [ 'base' => NULL, 'refs' => [ 'PartnerIntegrationInfo$StatusMessage' => '<p>The status message provided by the partner.</p>', 'UpdatePartnerStatusInputMessage$StatusMessage' => '<p>The status message provided by the partner.</p>', ], ], 'PartnerNotFoundFault' => [ 'base' => '<p>The name of the partner was not found.</p>', 'refs' => [], ], 'PauseClusterMessage' => [ 'base' => '<p>Describes a pause cluster operation. For example, a scheduled action to run the <code>PauseCluster</code> API operation. </p>', 'refs' => [ 'ScheduledActionType$PauseCluster' => '<p>An action that runs a <code>PauseCluster</code> API operation. </p>', ], ], 'PauseClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'PendingActionsList' => [ 'base' => NULL, 'refs' => [ 'Cluster$PendingActions' => '<p>Cluster operations that are waiting to be started.</p>', ], ], 'PendingModifiedValues' => [ 'base' => '<p>Describes cluster attributes that are in a pending state. A change to one or more the attributes was requested and is in progress or will be applied.</p>', 'refs' => [ 'Cluster$PendingModifiedValues' => '<p>A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are identified by subelements.</p>', ], ], 'PurchaseReservedNodeOfferingMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'PurchaseReservedNodeOfferingResult' => [ 'base' => NULL, 'refs' => [], ], 'RebootClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RebootClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'RecurringCharge' => [ 'base' => '<p>Describes a recurring charge.</p>', 'refs' => [ 'RecurringChargeList$member' => NULL, ], ], 'RecurringChargeList' => [ 'base' => NULL, 'refs' => [ 'ReservedNode$RecurringCharges' => '<p>The recurring charges for the reserved node.</p>', 'ReservedNodeOffering$RecurringCharges' => '<p>The charge to your account regardless of whether you are creating any clusters using the node offering. Recurring charges are only in effect for heavy-utilization reserved nodes.</p>', ], ], 'RejectDataShareMessage' => [ 'base' => NULL, 'refs' => [], ], 'ReservedNode' => [ 'base' => '<p>Describes a reserved node. You can call the <a>DescribeReservedNodeOfferings</a> API to obtain the available reserved node offerings. </p>', 'refs' => [ 'AcceptReservedNodeExchangeOutputMessage$ExchangedReservedNode' => '<p/>', 'PurchaseReservedNodeOfferingResult$ReservedNode' => NULL, 'ReservedNodeConfigurationOption$SourceReservedNode' => NULL, 'ReservedNodeList$member' => NULL, ], ], 'ReservedNodeAlreadyExistsFault' => [ 'base' => '<p>User already has a reservation with the given identifier.</p>', 'refs' => [], ], 'ReservedNodeAlreadyMigratedFault' => [ 'base' => '<p>Indicates that the reserved node has already been exchanged.</p>', 'refs' => [], ], 'ReservedNodeConfigurationOption' => [ 'base' => '<p>Details for a reserved-node exchange. Examples include the node type for a reserved node, the price for a node, the node\'s state, and other details.</p>', 'refs' => [ 'ReservedNodeConfigurationOptionList$member' => NULL, ], ], 'ReservedNodeConfigurationOptionList' => [ 'base' => NULL, 'refs' => [ 'GetReservedNodeExchangeConfigurationOptionsOutputMessage$ReservedNodeConfigurationOptionList' => '<p>the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node. Details include the node type, the price, the node count, and the offering type.</p>', ], ], 'ReservedNodeExchangeActionType' => [ 'base' => NULL, 'refs' => [ 'GetReservedNodeExchangeConfigurationOptionsInputMessage$ActionType' => '<p>The action type of the reserved-node configuration. The action type can be an exchange initiated from either a snapshot or a resize.</p>', ], ], 'ReservedNodeExchangeNotFoundFault' => [ 'base' => '<p>The reserved-node exchange status wasn\'t found.</p>', 'refs' => [], ], 'ReservedNodeExchangeStatus' => [ 'base' => '<p>Reserved-node status details, such as the source reserved-node identifier, the target reserved-node identifier, the node type, the node count, and other details.</p>', 'refs' => [ 'Cluster$ReservedNodeExchangeStatus' => '<p>The status of the reserved-node exchange request. Statuses include in-progress and requested.</p>', 'ReservedNodeExchangeStatusList$member' => NULL, ], ], 'ReservedNodeExchangeStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedNodeExchangeStatusOutputMessage$ReservedNodeExchangeStatusDetails' => '<p>The details of the reserved-node exchange request, including the status, request time, source reserved-node identifier, and additional details.</p>', ], ], 'ReservedNodeExchangeStatusType' => [ 'base' => NULL, 'refs' => [ 'ReservedNodeExchangeStatus$Status' => '<p>The status of the reserved-node exchange request. Statuses include in-progress and requested.</p>', ], ], 'ReservedNodeList' => [ 'base' => NULL, 'refs' => [ 'ReservedNodesMessage$ReservedNodes' => '<p>The list of <code>ReservedNode</code> objects.</p>', ], ], 'ReservedNodeNotFoundFault' => [ 'base' => '<p>The specified reserved compute node not found.</p>', 'refs' => [], ], 'ReservedNodeOffering' => [ 'base' => '<p>Describes a reserved node offering.</p>', 'refs' => [ 'ReservedNodeConfigurationOption$TargetReservedNodeOffering' => NULL, 'ReservedNodeOfferingList$member' => NULL, ], ], 'ReservedNodeOfferingList' => [ 'base' => NULL, 'refs' => [ 'GetReservedNodeExchangeOfferingsOutputMessage$ReservedNodeOfferings' => '<p>Returns an array of <a>ReservedNodeOffering</a> objects.</p>', 'ReservedNodeOfferingsMessage$ReservedNodeOfferings' => '<p>A list of <code>ReservedNodeOffering</code> objects.</p>', ], ], 'ReservedNodeOfferingNotFoundFault' => [ 'base' => '<p>Specified offering does not exist.</p>', 'refs' => [], ], 'ReservedNodeOfferingType' => [ 'base' => NULL, 'refs' => [ 'ReservedNode$ReservedNodeOfferingType' => '<p/>', 'ReservedNodeOffering$ReservedNodeOfferingType' => '<p/>', ], ], 'ReservedNodeOfferingsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ReservedNodeQuotaExceededFault' => [ 'base' => '<p>Request would exceed the user\'s compute node quota. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [], ], 'ReservedNodesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ResetClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ResizeClusterMessage' => [ 'base' => '<p>Describes a resize cluster operation. For example, a scheduled action to run the <code>ResizeCluster</code> API operation. </p>', 'refs' => [ 'ScheduledActionType$ResizeCluster' => '<p>An action that runs a <code>ResizeCluster</code> API operation. </p>', ], ], 'ResizeClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'ResizeInfo' => [ 'base' => '<p>Describes a resize operation.</p>', 'refs' => [ 'Cluster$ResizeInfo' => '<p>Returns the following:</p> <ul> <li> <p>AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.</p> </li> <li> <p>ResizeType: Returns ClassicResize</p> </li> </ul>', ], ], 'ResizeNotFoundFault' => [ 'base' => '<p>A resize operation for the specified cluster is not found.</p>', 'refs' => [], ], 'ResizeProgressMessage' => [ 'base' => '<p>Describes the result of a cluster resize operation.</p>', 'refs' => [], ], 'ResourceNotFoundFault' => [ 'base' => '<p>The resource could not be found.</p>', 'refs' => [], ], 'RestorableNodeTypeList' => [ 'base' => NULL, 'refs' => [ 'Snapshot$RestorableNodeTypes' => '<p>The list of node types that this cluster snapshot is able to restore into.</p>', ], ], 'RestoreFromClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RestoreFromClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreStatus' => [ 'base' => '<p>Describes the status of a cluster restore action. Returns null if the cluster was not created by restoring a snapshot.</p>', 'refs' => [ 'Cluster$RestoreStatus' => '<p>A value that describes the status of a cluster restore action. This parameter returns null if the cluster was not created by restoring a snapshot.</p>', ], ], 'RestoreTableFromClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RestoreTableFromClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'ResumeClusterMessage' => [ 'base' => '<p>Describes a resume cluster operation. For example, a scheduled action to run the <code>ResumeCluster</code> API operation. </p>', 'refs' => [ 'ScheduledActionType$ResumeCluster' => '<p>An action that runs a <code>ResumeCluster</code> API operation. </p>', ], ], 'ResumeClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'RevisionTarget' => [ 'base' => '<p>Describes a <code>RevisionTarget</code>.</p>', 'refs' => [ 'RevisionTargetsList$member' => NULL, ], ], 'RevisionTargetsList' => [ 'base' => NULL, 'refs' => [ 'ClusterDbRevision$RevisionTargets' => '<p>A list of <code>RevisionTarget</code> objects, where each object describes the database revision that a cluster can be updated to.</p>', ], ], 'RevokeClusterSecurityGroupIngressMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RevokeClusterSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'RevokeEndpointAccessMessage' => [ 'base' => NULL, 'refs' => [], ], 'RevokeSnapshotAccessMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RevokeSnapshotAccessResult' => [ 'base' => NULL, 'refs' => [], ], 'RotateEncryptionKeyMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RotateEncryptionKeyResult' => [ 'base' => NULL, 'refs' => [], ], 'SNSInvalidTopicFault' => [ 'base' => '<p>Amazon SNS has responded that there is a problem with the specified Amazon SNS topic.</p>', 'refs' => [], ], 'SNSNoAuthorizationFault' => [ 'base' => '<p>You do not have permission to publish to the specified Amazon SNS topic.</p>', 'refs' => [], ], 'SNSTopicArnNotFoundFault' => [ 'base' => '<p>An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not exist.</p>', 'refs' => [], ], 'ScheduleDefinitionList' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotScheduleMessage$ScheduleDefinitions' => '<p>The definition of the snapshot schedule. The definition is made up of schedule expressions, for example "cron(30 12 *)" or "rate(12 hours)". </p>', 'ModifySnapshotScheduleMessage$ScheduleDefinitions' => '<p>An updated list of schedule definitions. A schedule definition is made up of schedule expressions, for example, "cron(30 12 *)" or "rate(12 hours)".</p>', 'SnapshotSchedule$ScheduleDefinitions' => '<p>A list of ScheduleDefinitions.</p>', ], ], 'ScheduleDefinitionTypeUnsupportedFault' => [ 'base' => '<p>The definition you submitted is not supported.</p>', 'refs' => [], ], 'ScheduleState' => [ 'base' => NULL, 'refs' => [ 'Cluster$SnapshotScheduleState' => '<p>The current state of the cluster snapshot schedule.</p>', 'ClusterAssociatedToSchedule$ScheduleAssociationState' => '<p/>', ], ], 'ScheduledAction' => [ 'base' => '<p>Describes a scheduled action. You can use a scheduled action to trigger some Amazon Redshift API operations on a schedule. For information about which API operations can be scheduled, see <a>ScheduledActionType</a>. </p>', 'refs' => [ 'ScheduledActionList$member' => NULL, ], ], 'ScheduledActionAlreadyExistsFault' => [ 'base' => '<p>The scheduled action already exists. </p>', 'refs' => [], ], 'ScheduledActionFilter' => [ 'base' => '<p>A set of elements to filter the returned scheduled actions. </p>', 'refs' => [ 'ScheduledActionFilterList$member' => NULL, ], ], 'ScheduledActionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledActionsMessage$Filters' => '<p>List of scheduled action filters. </p>', ], ], 'ScheduledActionFilterName' => [ 'base' => NULL, 'refs' => [ 'ScheduledActionFilter$Name' => '<p>The type of element to filter. </p>', ], ], 'ScheduledActionList' => [ 'base' => NULL, 'refs' => [ 'ScheduledActionsMessage$ScheduledActions' => '<p>List of retrieved scheduled actions. </p>', ], ], 'ScheduledActionNotFoundFault' => [ 'base' => '<p>The scheduled action cannot be found. </p>', 'refs' => [], ], 'ScheduledActionQuotaExceededFault' => [ 'base' => '<p>The quota for scheduled actions exceeded. </p>', 'refs' => [], ], 'ScheduledActionState' => [ 'base' => NULL, 'refs' => [ 'ScheduledAction$State' => '<p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>', ], ], 'ScheduledActionTimeList' => [ 'base' => NULL, 'refs' => [ 'ScheduledAction$NextInvocations' => '<p>List of times when the scheduled action will run. </p>', ], ], 'ScheduledActionType' => [ 'base' => '<p>The action type that specifies an Amazon Redshift API operation that is supported by the Amazon Redshift scheduler. </p>', 'refs' => [ 'CreateScheduledActionMessage$TargetAction' => '<p>A JSON format string of the Amazon Redshift API operation with input parameters. For more information about this parameter, see <a>ScheduledAction</a>. </p>', 'ModifyScheduledActionMessage$TargetAction' => '<p>A modified JSON format of the scheduled action. For more information about this parameter, see <a>ScheduledAction</a>. </p>', 'ScheduledAction$TargetAction' => '<p>A JSON format string of the Amazon Redshift API operation with input parameters. </p> <p>"<code>{\\"ResizeCluster\\":{\\"NodeType\\":\\"ds2.8xlarge\\",\\"ClusterIdentifier\\":\\"my-test-cluster\\",\\"NumberOfNodes\\":3}}</code>". </p>', ], ], 'ScheduledActionTypeUnsupportedFault' => [ 'base' => '<p>The action type specified for a scheduled action is not supported. </p>', 'refs' => [], ], 'ScheduledActionTypeValues' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledActionsMessage$TargetActionType' => '<p>The type of the scheduled actions to retrieve. </p>', ], ], 'ScheduledActionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'ScheduledSnapshotTimeList' => [ 'base' => NULL, 'refs' => [ 'SnapshotSchedule$NextInvocations' => '<p/>', ], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'ClusterCredentials$DbPassword' => '<p>A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database <code>DbName</code>. </p>', ], ], 'Snapshot' => [ 'base' => '<p>Describes a snapshot.</p>', 'refs' => [ 'AuthorizeSnapshotAccessResult$Snapshot' => NULL, 'CopyClusterSnapshotResult$Snapshot' => NULL, 'CreateClusterSnapshotResult$Snapshot' => NULL, 'DeleteClusterSnapshotResult$Snapshot' => NULL, 'ModifyClusterSnapshotResult$Snapshot' => NULL, 'RevokeSnapshotAccessResult$Snapshot' => NULL, 'SnapshotList$member' => NULL, ], ], 'SnapshotAttributeToSortBy' => [ 'base' => NULL, 'refs' => [ 'SnapshotSortingEntity$Attribute' => '<p>The category for sorting the snapshots.</p>', ], ], 'SnapshotCopyAlreadyDisabledFault' => [ 'base' => '<p>The cluster already has cross-region snapshot copy disabled.</p>', 'refs' => [], ], 'SnapshotCopyAlreadyEnabledFault' => [ 'base' => '<p>The cluster already has cross-region snapshot copy enabled.</p>', 'refs' => [], ], 'SnapshotCopyDisabledFault' => [ 'base' => '<p>Cross-region snapshot copy was temporarily disabled. Try your request again.</p>', 'refs' => [], ], 'SnapshotCopyGrant' => [ 'base' => '<p>The snapshot copy grant that grants Amazon Redshift permission to encrypt copied snapshots with the specified encrypted symmetric key from Amazon Web Services KMS in the destination region.</p> <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'refs' => [ 'CreateSnapshotCopyGrantResult$SnapshotCopyGrant' => NULL, 'SnapshotCopyGrantList$member' => NULL, ], ], 'SnapshotCopyGrantAlreadyExistsFault' => [ 'base' => '<p>The snapshot copy grant can\'t be created because a grant with the same name already exists.</p>', 'refs' => [], ], 'SnapshotCopyGrantList' => [ 'base' => NULL, 'refs' => [ 'SnapshotCopyGrantMessage$SnapshotCopyGrants' => '<p>The list of <code>SnapshotCopyGrant</code> objects.</p>', ], ], 'SnapshotCopyGrantMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'SnapshotCopyGrantNotFoundFault' => [ 'base' => '<p>The specified snapshot copy grant can\'t be found. Make sure that the name is typed correctly and that the grant exists in the destination region.</p>', 'refs' => [], ], 'SnapshotCopyGrantQuotaExceededFault' => [ 'base' => '<p>The Amazon Web Services account has exceeded the maximum number of snapshot copy grants in this region.</p>', 'refs' => [], ], 'SnapshotErrorMessage' => [ 'base' => '<p>Describes the errors returned by a snapshot.</p>', 'refs' => [ 'BatchSnapshotOperationErrorList$member' => NULL, 'BatchSnapshotOperationErrors$member' => NULL, ], ], 'SnapshotIdentifierList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteClusterSnapshotsResult$Resources' => '<p>A list of the snapshot identifiers that were deleted. </p>', 'BatchModifyClusterSnapshotsMessage$SnapshotIdentifierList' => '<p>A list of snapshot identifiers you want to modify.</p>', 'BatchModifyClusterSnapshotsOutputMessage$Resources' => '<p>A list of the snapshots that were modified.</p>', ], ], 'SnapshotList' => [ 'base' => NULL, 'refs' => [ 'SnapshotMessage$Snapshots' => '<p>A list of <a>Snapshot</a> instances. </p>', ], ], 'SnapshotMessage' => [ 'base' => '<p>Contains the output from the <a>DescribeClusterSnapshots</a> action. </p>', 'refs' => [], ], 'SnapshotSchedule' => [ 'base' => '<p>Describes a snapshot schedule. You can set a regular interval for creating snapshots of a cluster. You can also schedule snapshots for specific dates. </p>', 'refs' => [ 'SnapshotScheduleList$member' => NULL, ], ], 'SnapshotScheduleAlreadyExistsFault' => [ 'base' => '<p>The specified snapshot schedule already exists. </p>', 'refs' => [], ], 'SnapshotScheduleList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotSchedulesOutputMessage$SnapshotSchedules' => '<p>A list of SnapshotSchedules.</p>', ], ], 'SnapshotScheduleNotFoundFault' => [ 'base' => '<p>We could not find the specified snapshot schedule. </p>', 'refs' => [], ], 'SnapshotScheduleQuotaExceededFault' => [ 'base' => '<p>You have exceeded the quota of snapshot schedules. </p>', 'refs' => [], ], 'SnapshotScheduleUpdateInProgressFault' => [ 'base' => '<p>The specified snapshot schedule is already being updated.</p>', 'refs' => [], ], 'SnapshotSortingEntity' => [ 'base' => '<p>Describes a sorting entity</p>', 'refs' => [ 'SnapshotSortingEntityList$member' => NULL, ], ], 'SnapshotSortingEntityList' => [ 'base' => NULL, 'refs' => [ 'DescribeClusterSnapshotsMessage$SortingEntities' => '<p/>', ], ], 'SortByOrder' => [ 'base' => NULL, 'refs' => [ 'SnapshotSortingEntity$SortOrder' => '<p>The order for listing the attributes.</p>', ], ], 'SourceIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$SourceIds' => '<p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.</p> <p>Example: my-cluster-1, my-cluster-2</p> <p>Example: my-snapshot-20131010</p>', 'EventSubscription$SourceIdsList' => '<p>A list of the sources that publish events to the Amazon Redshift event notification subscription.</p>', 'ModifyEventSubscriptionMessage$SourceIds' => '<p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.</p> <p>Example: my-cluster-1, my-cluster-2</p> <p>Example: my-snapshot-20131010</p>', ], ], 'SourceNotFoundFault' => [ 'base' => '<p>The specified Amazon Redshift event source could not be found.</p>', 'refs' => [], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsMessage$SourceType' => '<p>The event source to retrieve events for. If no value is specified, all events are returned.</p> <p>Constraints:</p> <p>If <i>SourceType</i> is supplied, <i>SourceIdentifier</i> must also be provided.</p> <ul> <li> <p>Specify <code>cluster</code> when <i>SourceIdentifier</i> is a cluster identifier.</p> </li> <li> <p>Specify <code>cluster-security-group</code> when <i>SourceIdentifier</i> is a cluster security group name.</p> </li> <li> <p>Specify <code>cluster-parameter-group</code> when <i>SourceIdentifier</i> is a cluster parameter group name.</p> </li> <li> <p>Specify <code>cluster-snapshot</code> when <i>SourceIdentifier</i> is a cluster snapshot identifier.</p> </li> </ul>', 'Event$SourceType' => '<p>The source type for this event.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AcceptReservedNodeExchangeInputMessage$ReservedNodeId' => '<p>A string representing the node identifier of the DC1 Reserved Node to be exchanged.</p>', 'AcceptReservedNodeExchangeInputMessage$TargetReservedNodeOfferingId' => '<p>The unique identifier of the DC2 Reserved Node offering to be used for the exchange. You can obtain the value for the parameter by calling <a>GetReservedNodeExchangeOfferings</a> </p>', 'AccountAttribute$AttributeName' => '<p>The name of the attribute.</p>', 'AccountWithRestoreAccess$AccountId' => '<p>The identifier of an Amazon Web Services account authorized to restore a snapshot.</p>', 'AccountWithRestoreAccess$AccountAlias' => '<p>The identifier of an Amazon Web Services support account authorized to restore a snapshot. For Amazon Web Services Support, the identifier is <code>amazon-redshift-support</code>. </p>', 'AssociateDataShareConsumerMessage$DataShareArn' => '<p>The Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.</p>', 'AssociateDataShareConsumerMessage$ConsumerArn' => '<p>The Amazon Resource Name (ARN) of the consumer that is associated with the datashare.</p>', 'AssociateDataShareConsumerMessage$ConsumerRegion' => '<p>From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified Amazon Web Services Region.</p>', 'AttributeNameList$member' => NULL, 'AttributeValueTarget$AttributeValue' => '<p>The value of the attribute.</p>', 'AuthenticationProfile$AuthenticationProfileContent' => '<p>The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>', 'AuthorizeClusterSecurityGroupIngressMessage$ClusterSecurityGroupName' => '<p>The name of the security group to which the ingress rule is added.</p>', 'AuthorizeClusterSecurityGroupIngressMessage$CIDRIP' => '<p>The IP range to be added the Amazon Redshift security group.</p>', 'AuthorizeClusterSecurityGroupIngressMessage$EC2SecurityGroupName' => '<p>The EC2 security group to be added the Amazon Redshift security group.</p>', 'AuthorizeClusterSecurityGroupIngressMessage$EC2SecurityGroupOwnerId' => '<p>The Amazon Web Services account number of the owner of the security group specified by the <i>EC2SecurityGroupName</i> parameter. The Amazon Web Services Access Key ID is not an acceptable value. </p> <p>Example: <code>111122223333</code> </p>', 'AuthorizeDataShareMessage$DataShareArn' => '<p>The Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.</p>', 'AuthorizeDataShareMessage$ConsumerIdentifier' => '<p>The identifier of the data consumer that is authorized to access the datashare. This identifier is an Amazon Web Services account ID or a keyword, such as ADX.</p>', 'AuthorizeEndpointAccessMessage$ClusterIdentifier' => '<p>The cluster identifier of the cluster to grant access to.</p>', 'AuthorizeEndpointAccessMessage$Account' => '<p>The Amazon Web Services account ID to grant access to.</p>', 'AuthorizeSnapshotAccessMessage$SnapshotIdentifier' => '<p>The identifier of the snapshot the account is authorized to restore.</p>', 'AuthorizeSnapshotAccessMessage$SnapshotClusterIdentifier' => '<p>The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>', 'AuthorizeSnapshotAccessMessage$AccountWithRestoreAccess' => '<p>The identifier of the Amazon Web Services account authorized to restore the specified snapshot.</p> <p>To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.</p>', 'AvailabilityZone$Name' => '<p>The name of the availability zone.</p>', 'CancelResizeMessage$ClusterIdentifier' => '<p>The unique identifier for the cluster that you want to cancel a resize operation for.</p>', 'Cluster$ClusterIdentifier' => '<p>The unique identifier of the cluster.</p>', 'Cluster$NodeType' => '<p>The node type for the nodes in the cluster.</p>', 'Cluster$ClusterStatus' => '<p> The current state of the cluster. Possible values are the following:</p> <ul> <li> <p> <code>available</code> </p> </li> <li> <p> <code>available, prep-for-resize</code> </p> </li> <li> <p> <code>available, resize-cleanup</code> </p> </li> <li> <p> <code>cancelling-resize</code> </p> </li> <li> <p> <code>creating</code> </p> </li> <li> <p> <code>deleting</code> </p> </li> <li> <p> <code>final-snapshot</code> </p> </li> <li> <p> <code>hardware-failure</code> </p> </li> <li> <p> <code>incompatible-hsm</code> </p> </li> <li> <p> <code>incompatible-network</code> </p> </li> <li> <p> <code>incompatible-parameters</code> </p> </li> <li> <p> <code>incompatible-restore</code> </p> </li> <li> <p> <code>modifying</code> </p> </li> <li> <p> <code>paused</code> </p> </li> <li> <p> <code>rebooting</code> </p> </li> <li> <p> <code>renaming</code> </p> </li> <li> <p> <code>resizing</code> </p> </li> <li> <p> <code>rotating-keys</code> </p> </li> <li> <p> <code>storage-full</code> </p> </li> <li> <p> <code>updating-hsm</code> </p> </li> </ul>', 'Cluster$ClusterAvailabilityStatus' => '<p>The availability status of the cluster for queries. Possible values are the following:</p> <ul> <li> <p>Available - The cluster is available for queries. </p> </li> <li> <p>Unavailable - The cluster is not available for queries.</p> </li> <li> <p>Maintenance - The cluster is intermittently available for queries due to maintenance activities.</p> </li> <li> <p>Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.</p> </li> <li> <p>Failed - The cluster failed and is not available for queries.</p> </li> </ul>', 'Cluster$ModifyStatus' => '<p>The status of a modify operation, if any, initiated for the cluster.</p>', 'Cluster$MasterUsername' => '<p>The admin user name for the cluster. This name is used to connect to the database that is specified in the <b>DBName</b> parameter. </p>', 'Cluster$DBName' => '<p>The name of the initial database that was created when the cluster was created. This same name is returned for the life of the cluster. If an initial database was not specified, a database named <code>dev</code>dev was created by default. </p>', 'Cluster$ClusterSubnetGroupName' => '<p>The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.</p>', 'Cluster$VpcId' => '<p>The identifier of the VPC the cluster is in, if the cluster is in a VPC.</p>', 'Cluster$AvailabilityZone' => '<p>The name of the Availability Zone in which the cluster is located.</p>', 'Cluster$PreferredMaintenanceWindow' => '<p>The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.</p>', 'Cluster$ClusterVersion' => '<p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>', 'Cluster$ClusterPublicKey' => '<p>The public key for the cluster.</p>', 'Cluster$ClusterRevisionNumber' => '<p>The specific revision number of the database in the cluster.</p>', 'Cluster$KmsKeyId' => '<p>The Key Management Service (KMS) key ID of the encryption key used to encrypt data in the cluster.</p>', 'Cluster$MaintenanceTrackName' => '<p>The name of the maintenance track for the cluster.</p>', 'Cluster$ElasticResizeNumberOfNodeOptions' => '<p>The number of nodes that you can resize the cluster to with the elastic resize method. </p>', 'Cluster$SnapshotScheduleIdentifier' => '<p>A unique identifier for the cluster snapshot schedule.</p>', 'Cluster$ExpectedNextSnapshotScheduleTimeStatus' => '<p> The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled. Possible values are the following:</p> <ul> <li> <p>OnTrack - The next snapshot is expected to be taken on time. </p> </li> <li> <p>Pending - The next snapshot is pending to be taken. </p> </li> </ul>', 'Cluster$AvailabilityZoneRelocationStatus' => '<p>Describes the status of the Availability Zone relocation operation.</p>', 'Cluster$ClusterNamespaceArn' => '<p>The namespace Amazon Resource Name (ARN) of the cluster.</p>', 'Cluster$DefaultIamRoleArn' => '<p>The Amazon Resource Name (ARN) for the IAM role set as default for the cluster.</p>', 'ClusterAssociatedToSchedule$ClusterIdentifier' => '<p/>', 'ClusterCredentials$DbUser' => '<p>A database user name that is authorized to log on to the database <code>DbName</code> using the password <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name has the same database privileges as the the user named in DbUser. By default, the user is added to PUBLIC. If the <code>DbGroups</code> parameter is specifed, <code>DbUser</code> is added to the listed groups for any sessions created using these credentials.</p>', 'ClusterDbRevision$ClusterIdentifier' => '<p>The unique identifier of the cluster.</p>', 'ClusterDbRevision$CurrentDatabaseRevision' => '<p>A string representing the current cluster version.</p>', 'ClusterDbRevisionsMessage$Marker' => '<p>A string representing the starting point for the next set of revisions. If a value is returned in a response, you can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have already been returned.</p>', 'ClusterIamRole$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role, for example, <code>arn:aws:iam::123456789012:role/RedshiftCopyUnload</code>. </p>', 'ClusterIamRole$ApplyStatus' => '<p>A value that describes the status of the IAM role\'s association with an Amazon Redshift cluster.</p> <p>The following are possible statuses and descriptions.</p> <ul> <li> <p> <code>in-sync</code>: The role is available for use by the cluster.</p> </li> <li> <p> <code>adding</code>: The role is in the process of being associated with the cluster.</p> </li> <li> <p> <code>removing</code>: The role is in the process of being disassociated with the cluster.</p> </li> </ul>', 'ClusterNode$NodeRole' => '<p>Whether the node is a leader node or a compute node.</p>', 'ClusterNode$PrivateIPAddress' => '<p>The private IP address of a node within a cluster.</p>', 'ClusterNode$PublicIPAddress' => '<p>The public IP address of a node within a cluster.</p>', 'ClusterParameterGroup$ParameterGroupName' => '<p>The name of the cluster parameter group.</p>', 'ClusterParameterGroup$ParameterGroupFamily' => '<p>The name of the cluster parameter group family that this cluster parameter group is compatible with.</p>', 'ClusterParameterGroup$Description' => '<p>The description of the parameter group.</p>', 'ClusterParameterGroupDetails$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'ClusterParameterGroupNameMessage$ParameterGroupName' => '<p>The name of the cluster parameter group.</p>', 'ClusterParameterGroupNameMessage$ParameterGroupStatus' => '<p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>', 'ClusterParameterGroupStatus$ParameterGroupName' => '<p>The name of the cluster parameter group.</p>', 'ClusterParameterGroupStatus$ParameterApplyStatus' => '<p>The status of parameter updates.</p>', 'ClusterParameterGroupsMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'ClusterParameterStatus$ParameterName' => '<p>The name of the parameter.</p>', 'ClusterParameterStatus$ParameterApplyStatus' => '<p>The status of the parameter that indicates whether the parameter is in sync with the database, waiting for a cluster reboot, or encountered an error when being applied.</p> <p>The following are possible statuses and descriptions.</p> <ul> <li> <p> <code>in-sync</code>: The parameter value is in sync with the database.</p> </li> <li> <p> <code>pending-reboot</code>: The parameter value will be applied after the cluster reboots.</p> </li> <li> <p> <code>applying</code>: The parameter value is being applied to the database.</p> </li> <li> <p> <code>invalid-parameter</code>: Cannot apply the parameter value because it has an invalid value or syntax.</p> </li> <li> <p> <code>apply-deferred</code>: The parameter contains static property changes. The changes are deferred until the cluster reboots.</p> </li> <li> <p> <code>apply-error</code>: Cannot connect to the cluster. The parameter change will be applied after the cluster reboots.</p> </li> <li> <p> <code>unknown-error</code>: Cannot apply the parameter change right now. The change will be applied after the cluster reboots.</p> </li> </ul>', 'ClusterParameterStatus$ParameterApplyErrorDescription' => '<p>The error that prevented the parameter from being applied to the database.</p>', 'ClusterSecurityGroup$ClusterSecurityGroupName' => '<p>The name of the cluster security group to which the operation was applied.</p>', 'ClusterSecurityGroup$Description' => '<p>A description of the security group.</p>', 'ClusterSecurityGroupMembership$ClusterSecurityGroupName' => '<p>The name of the cluster security group.</p>', 'ClusterSecurityGroupMembership$Status' => '<p>The status of the cluster security group.</p>', 'ClusterSecurityGroupMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'ClusterSecurityGroupNameList$member' => NULL, 'ClusterSnapshotCopyStatus$DestinationRegion' => '<p>The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.</p>', 'ClusterSnapshotCopyStatus$SnapshotCopyGrantName' => '<p>The name of the snapshot copy grant.</p>', 'ClusterSubnetGroup$ClusterSubnetGroupName' => '<p>The name of the cluster subnet group.</p>', 'ClusterSubnetGroup$Description' => '<p>The description of the cluster subnet group.</p>', 'ClusterSubnetGroup$VpcId' => '<p>The VPC ID of the cluster subnet group.</p>', 'ClusterSubnetGroup$SubnetGroupStatus' => '<p>The status of the cluster subnet group. Possible values are <code>Complete</code>, <code>Incomplete</code> and <code>Invalid</code>. </p>', 'ClusterSubnetGroupMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'ClusterVersion$ClusterVersion' => '<p>The version number used by the cluster.</p>', 'ClusterVersion$ClusterParameterGroupFamily' => '<p>The name of the cluster parameter group family for the cluster.</p>', 'ClusterVersion$Description' => '<p>The description of the cluster version.</p>', 'ClusterVersionsMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'ClustersMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'CopyClusterSnapshotMessage$SourceSnapshotIdentifier' => '<p>The identifier for the source snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Must be the identifier for a valid automated snapshot whose state is <code>available</code>.</p> </li> </ul>', 'CopyClusterSnapshotMessage$SourceSnapshotClusterIdentifier' => '<p>The identifier of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p> <p>Constraints:</p> <ul> <li> <p>Must be the identifier for a valid cluster.</p> </li> </ul>', 'CopyClusterSnapshotMessage$TargetSnapshotIdentifier' => '<p>The identifier given to the new manual snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Cannot be null, empty, or blank.</p> </li> <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique for the Amazon Web Services account that is making the request.</p> </li> </ul>', 'CreateAuthenticationProfileMessage$AuthenticationProfileContent' => '<p>The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>', 'CreateAuthenticationProfileResult$AuthenticationProfileContent' => '<p>The content of the authentication profile in JSON format.</p>', 'CreateClusterMessage$DBName' => '<p>The name of the first database to be created when the cluster is created.</p> <p>To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create a Database</a> in the Amazon Redshift Database Developer Guide. </p> <p>Default: <code>dev</code> </p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 64 alphanumeric characters.</p> </li> <li> <p>Must contain only lowercase letters.</p> </li> <li> <p>Cannot be a word that is reserved by the service. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide. </p> </li> </ul>', 'CreateClusterMessage$ClusterIdentifier' => '<p>A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>Alphabetic characters must be lowercase.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li> </ul> <p>Example: <code>myexamplecluster</code> </p>', 'CreateClusterMessage$ClusterType' => '<p>The type of the cluster. When cluster type is specified as</p> <ul> <li> <p> <code>single-node</code>, the <b>NumberOfNodes</b> parameter is not required.</p> </li> <li> <p> <code>multi-node</code>, the <b>NumberOfNodes</b> parameter is required.</p> </li> </ul> <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p> <p>Default: <code>multi-node</code> </p>', 'CreateClusterMessage$NodeType' => '<p>The node type to be provisioned for the cluster. For information about node types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p> <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code> </p>', 'CreateClusterMessage$MasterUsername' => '<p>The user name associated with the admin user account for the cluster that is being created.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 - 128 alphanumeric characters. The user name can\'t be <code>PUBLIC</code>.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide. </p> </li> </ul>', 'CreateClusterMessage$MasterUserPassword' => '<p>The password associated with the admin user account for the cluster that is being created.</p> <p>Constraints:</p> <ul> <li> <p>Must be between 8 and 64 characters in length.</p> </li> <li> <p>Must contain at least one uppercase letter.</p> </li> <li> <p>Must contain at least one lowercase letter.</p> </li> <li> <p>Must contain one number.</p> </li> <li> <p>Can be any printable ASCII character (ASCII code 33-126) except \' (single quote), " (double quote), \\, /, or @.</p> </li> </ul>', 'CreateClusterMessage$ClusterSubnetGroupName' => '<p>The name of a cluster subnet group to be associated with this cluster.</p> <p>If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).</p>', 'CreateClusterMessage$AvailabilityZone' => '<p>The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.</p> <p>Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.</p> <p>Example: <code>us-east-2d</code> </p> <p>Constraint: The specified Availability Zone must be in the same region as the current endpoint.</p>', 'CreateClusterMessage$PreferredMaintenanceWindow' => '<p>The weekly time range (in UTC) during which automated cluster maintenance can occur.</p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p> Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.</p> <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p> <p>Constraints: Minimum 30-minute window.</p>', 'CreateClusterMessage$ClusterParameterGroupName' => '<p>The name of the parameter group to be associated with this cluster.</p> <p>Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a> </p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'CreateClusterMessage$ClusterVersion' => '<p>The version of the Amazon Redshift engine software that you want to deploy on the cluster.</p> <p>The version selected runs on all the nodes in the cluster.</p> <p>Constraints: Only version 1.0 is currently available.</p> <p>Example: <code>1.0</code> </p>', 'CreateClusterMessage$HsmClientCertificateIdentifier' => '<p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>', 'CreateClusterMessage$HsmConfigurationIdentifier' => '<p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>', 'CreateClusterMessage$ElasticIp' => '<p>The Elastic IP (EIP) address for the cluster.</p> <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>', 'CreateClusterMessage$KmsKeyId' => '<p>The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.</p>', 'CreateClusterMessage$AdditionalInfo' => '<p>Reserved.</p>', 'CreateClusterMessage$MaintenanceTrackName' => '<p>An optional parameter for the name of the maintenance track for the cluster. If you don\'t provide a maintenance track name, the cluster is assigned to the <code>current</code> track.</p>', 'CreateClusterMessage$SnapshotScheduleIdentifier' => '<p>A unique identifier for the snapshot schedule.</p>', 'CreateClusterMessage$DefaultIamRoleArn' => '<p>The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created. </p>', 'CreateClusterParameterGroupMessage$ParameterGroupName' => '<p>The name of the cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters or hyphens</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique withing your Amazon Web Services account.</p> </li> </ul> <note> <p>This value is stored as a lower-case string.</p> </note>', 'CreateClusterParameterGroupMessage$ParameterGroupFamily' => '<p>The Amazon Redshift engine version to which the cluster parameter group applies. The cluster engine version determines the set of parameters.</p> <p>To get a list of valid parameter group family names, you can call <a>DescribeClusterParameterGroups</a>. By default, Amazon Redshift returns a list of all the parameter groups that are owned by your Amazon Web Services account, including the default parameter groups for each Amazon Redshift engine version. The parameter group family names associated with the default parameter groups provide you the valid values. For example, a valid family name is "redshift-1.0". </p>', 'CreateClusterParameterGroupMessage$Description' => '<p>A description of the parameter group.</p>', 'CreateClusterSecurityGroupMessage$ClusterSecurityGroupName' => '<p>The name for the security group. Amazon Redshift stores the value as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain no more than 255 alphanumeric characters or hyphens.</p> </li> <li> <p>Must not be "Default".</p> </li> <li> <p>Must be unique for all security groups that are created by your Amazon Web Services account.</p> </li> </ul> <p>Example: <code>examplesecuritygroup</code> </p>', 'CreateClusterSecurityGroupMessage$Description' => '<p>A description for the security group.</p>', 'CreateClusterSnapshotMessage$SnapshotIdentifier' => '<p>A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.</p> <p>Constraints:</p> <ul> <li> <p>Cannot be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-snapshot-id</code> </p>', 'CreateClusterSnapshotMessage$ClusterIdentifier' => '<p>The cluster identifier for which you want a snapshot.</p>', 'CreateClusterSubnetGroupMessage$ClusterSubnetGroupName' => '<p>The name for the subnet group. Amazon Redshift stores the value as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain no more than 255 alphanumeric characters or hyphens.</p> </li> <li> <p>Must not be "Default".</p> </li> <li> <p>Must be unique for all subnet groups that are created by your Amazon Web Services account.</p> </li> </ul> <p>Example: <code>examplesubnetgroup</code> </p>', 'CreateClusterSubnetGroupMessage$Description' => '<p>A description for the subnet group.</p>', 'CreateEndpointAccessMessage$ClusterIdentifier' => '<p>The cluster identifier of the cluster to access.</p>', 'CreateEndpointAccessMessage$ResourceOwner' => '<p>The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.</p>', 'CreateEndpointAccessMessage$EndpointName' => '<p>The Redshift-managed VPC endpoint name.</p> <p>An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be a letter. The name can\'t contain two consecutive hyphens or end with a hyphen.</p>', 'CreateEndpointAccessMessage$SubnetGroupName' => '<p>The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.</p>', 'CreateEventSubscriptionMessage$SubscriptionName' => '<p>The name of the event subscription to be created.</p> <p>Constraints:</p> <ul> <li> <p>Cannot be null, empty, or blank.</p> </li> <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'CreateEventSubscriptionMessage$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>', 'CreateEventSubscriptionMessage$SourceType' => '<p>The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs.</p> <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>', 'CreateEventSubscriptionMessage$Severity' => '<p>Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p> <p>Values: ERROR, INFO</p>', 'CreateHsmClientCertificateMessage$HsmClientCertificateIdentifier' => '<p>The identifier to be assigned to the new HSM client certificate that the cluster will use to connect to the HSM to use the database encryption keys.</p>', 'CreateHsmConfigurationMessage$HsmConfigurationIdentifier' => '<p>The identifier to be assigned to the new Amazon Redshift HSM configuration.</p>', 'CreateHsmConfigurationMessage$Description' => '<p>A text description of the HSM configuration to be created.</p>', 'CreateHsmConfigurationMessage$HsmIpAddress' => '<p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>', 'CreateHsmConfigurationMessage$HsmPartitionName' => '<p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>', 'CreateHsmConfigurationMessage$HsmPartitionPassword' => '<p>The password required to access the HSM partition.</p>', 'CreateHsmConfigurationMessage$HsmServerPublicCertificate' => '<p>The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.</p>', 'CreateScheduledActionMessage$ScheduledActionName' => '<p>The name of the scheduled action. The name must be unique within an account. For more information about this parameter, see <a>ScheduledAction</a>. </p>', 'CreateScheduledActionMessage$Schedule' => '<p>The schedule in <code>at( )</code> or <code>cron( )</code> format. For more information about this parameter, see <a>ScheduledAction</a>.</p>', 'CreateScheduledActionMessage$IamRole' => '<p>The IAM role to assume to run the target action. For more information about this parameter, see <a>ScheduledAction</a>. </p>', 'CreateScheduledActionMessage$ScheduledActionDescription' => '<p>The description of the scheduled action. </p>', 'CreateSnapshotCopyGrantMessage$SnapshotCopyGrantName' => '<p>The name of the snapshot copy grant. This name must be unique in the region for the Amazon Web Services account.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>Alphabetic characters must be lowercase.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li> </ul>', 'CreateSnapshotCopyGrantMessage$KmsKeyId' => '<p>The unique identifier of the encrypted symmetric key to which to grant Amazon Redshift permission. If no key is specified, the default key is used.</p>', 'CreateSnapshotScheduleMessage$ScheduleIdentifier' => '<p>A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed for the identifier.</p>', 'CreateSnapshotScheduleMessage$ScheduleDescription' => '<p>The description of the snapshot schedule.</p>', 'CreateTagsMessage$ResourceName' => '<p>The Amazon Resource Name (ARN) to which you want to add the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>', 'CreateUsageLimitMessage$ClusterIdentifier' => '<p>The identifier of the cluster that you want to limit usage.</p>', 'DataShare$DataShareArn' => '<p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>', 'DataShare$ProducerArn' => '<p>The Amazon Resource Name (ARN) of the producer.</p>', 'DataShare$ManagedBy' => '<p>The identifier of a datashare to show its managing entity.</p>', 'DataShareAssociation$ConsumerIdentifier' => '<p>The name of the consumer accounts that have an association with a producer datashare.</p>', 'DataShareAssociation$ConsumerRegion' => '<p>The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.</p>', 'DataTransferProgress$Status' => '<p>Describes the status of the cluster. While the transfer is in progress the status is <code>transferringdata</code>.</p>', 'DbGroupList$member' => NULL, 'DeauthorizeDataShareMessage$DataShareArn' => '<p>The Amazon Resource Name (ARN) of the datashare to remove authorization from.</p>', 'DeauthorizeDataShareMessage$ConsumerIdentifier' => '<p>The identifier of the data consumer that is to have authorization removed from the datashare. This identifier is an Amazon Web Services account ID or a keyword, such as ADX.</p>', 'DefaultClusterParameters$ParameterGroupFamily' => '<p>The name of the cluster parameter group family to which the engine default parameters apply.</p>', 'DefaultClusterParameters$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'DeferredMaintenanceWindow$DeferMaintenanceIdentifier' => '<p>A unique identifier for the maintenance window.</p>', 'DeleteClusterMessage$ClusterIdentifier' => '<p>The identifier of the cluster to be deleted.</p> <p>Constraints:</p> <ul> <li> <p>Must contain lowercase characters.</p> </li> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'DeleteClusterMessage$FinalClusterSnapshotIdentifier' => '<p>The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'DeleteClusterParameterGroupMessage$ParameterGroupName' => '<p>The name of the parameter group to be deleted.</p> <p>Constraints:</p> <ul> <li> <p>Must be the name of an existing cluster parameter group.</p> </li> <li> <p>Cannot delete a default cluster parameter group.</p> </li> </ul>', 'DeleteClusterSecurityGroupMessage$ClusterSecurityGroupName' => '<p>The name of the cluster security group to be deleted.</p>', 'DeleteClusterSnapshotMessage$SnapshotIdentifier' => '<p>The unique identifier of the manual snapshot to be deleted.</p> <p>Constraints: Must be the name of an existing snapshot that is in the <code>available</code>, <code>failed</code>, or <code>cancelled</code> state.</p>', 'DeleteClusterSnapshotMessage$SnapshotClusterIdentifier' => '<p>The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p> <p>Constraints: Must be the name of valid cluster.</p>', 'DeleteClusterSubnetGroupMessage$ClusterSubnetGroupName' => '<p>The name of the cluster subnet group name to be deleted.</p>', 'DeleteEndpointAccessMessage$EndpointName' => '<p>The Redshift-managed VPC endpoint to delete.</p>', 'DeleteEventSubscriptionMessage$SubscriptionName' => '<p>The name of the Amazon Redshift event notification subscription to be deleted.</p>', 'DeleteHsmClientCertificateMessage$HsmClientCertificateIdentifier' => '<p>The identifier of the HSM client certificate to be deleted.</p>', 'DeleteHsmConfigurationMessage$HsmConfigurationIdentifier' => '<p>The identifier of the Amazon Redshift HSM configuration to be deleted.</p>', 'DeleteScheduledActionMessage$ScheduledActionName' => '<p>The name of the scheduled action to delete. </p>', 'DeleteSnapshotCopyGrantMessage$SnapshotCopyGrantName' => '<p>The name of the snapshot copy grant to delete.</p>', 'DeleteSnapshotScheduleMessage$ScheduleIdentifier' => '<p>A unique identifier of the snapshot schedule to delete.</p>', 'DeleteTagsMessage$ResourceName' => '<p>The Amazon Resource Name (ARN) from which you want to remove the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>', 'DeleteUsageLimitMessage$UsageLimitId' => '<p>The identifier of the usage limit to delete.</p>', 'DescribeClusterDbRevisionsMessage$ClusterIdentifier' => '<p>A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are requesting. This parameter is case sensitive. All clusters defined for an account are returned by default.</p>', 'DescribeClusterDbRevisionsMessage$Marker' => '<p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>DescribeClusterDbRevisions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>marker</code> field of the response. You can retrieve the next set of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p> <p>Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or the <code>marker</code> parameter, but not both.</p>', 'DescribeClusterParameterGroupsMessage$ParameterGroupName' => '<p>The name of a specific parameter group for which to return details. By default, details about all parameter groups and the default parameter group are returned.</p>', 'DescribeClusterParameterGroupsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterParameterGroups</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeClusterParametersMessage$ParameterGroupName' => '<p>The name of a cluster parameter group for which to return details.</p>', 'DescribeClusterParametersMessage$Source' => '<p>The parameter types to return. Specify <code>user</code> to show parameters that are different form the default. Similarly, specify <code>engine-default</code> to show parameters that are the same as the default parameter group. </p> <p>Default: All parameter types returned.</p> <p>Valid Values: <code>user</code> | <code>engine-default</code> </p>', 'DescribeClusterParametersMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterParameters</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeClusterSecurityGroupsMessage$ClusterSecurityGroupName' => '<p>The name of a cluster security group for which you are requesting details. You can specify either the <b>Marker</b> parameter or a <b>ClusterSecurityGroupName</b> parameter, but not both. </p> <p> Example: <code>securitygroup1</code> </p>', 'DescribeClusterSecurityGroupsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterSecurityGroups</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p> <p>Constraints: You can specify either the <b>ClusterSecurityGroupName</b> parameter or the <b>Marker</b> parameter, but not both. </p>', 'DescribeClusterSnapshotsMessage$ClusterIdentifier' => '<p>The identifier of the cluster which generated the requested snapshots.</p>', 'DescribeClusterSnapshotsMessage$SnapshotIdentifier' => '<p>The snapshot identifier of the snapshot about which to return information.</p>', 'DescribeClusterSnapshotsMessage$SnapshotType' => '<p>The type of snapshots for which you are requesting information. By default, snapshots of all types are returned.</p> <p>Valid Values: <code>automated</code> | <code>manual</code> </p>', 'DescribeClusterSnapshotsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterSnapshots</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeClusterSnapshotsMessage$OwnerAccount' => '<p>The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the results to snapshots owned by a particular account. To describe snapshots you own, either specify your Amazon Web Services account, or do not specify the parameter.</p>', 'DescribeClusterSubnetGroupsMessage$ClusterSubnetGroupName' => '<p>The name of the cluster subnet group for which information is requested.</p>', 'DescribeClusterSubnetGroupsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterSubnetGroups</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeClusterTracksMessage$MaintenanceTrackName' => '<p>The name of the maintenance track. </p>', 'DescribeClusterTracksMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterTracks</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeClusterVersionsMessage$ClusterVersion' => '<p>The specific cluster version to return.</p> <p>Example: <code>1.0</code> </p>', 'DescribeClusterVersionsMessage$ClusterParameterGroupFamily' => '<p>The name of a specific cluster parameter group family to return details for.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul>', 'DescribeClusterVersionsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterVersions</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeClustersMessage$ClusterIdentifier' => '<p>The unique identifier of a cluster whose properties you are requesting. This parameter is case sensitive.</p> <p>The default is that all clusters defined for an account are returned.</p>', 'DescribeClustersMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusters</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p> <p>Constraints: You can specify either the <b>ClusterIdentifier</b> parameter or the <b>Marker</b> parameter, but not both. </p>', 'DescribeDataSharesForConsumerMessage$ConsumerArn' => '<p>The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.</p>', 'DescribeDataSharesForConsumerMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDataSharesForConsumer</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeDataSharesForConsumerResult$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDataSharesForConsumer</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeDataSharesForProducerMessage$ProducerArn' => '<p>The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.</p>', 'DescribeDataSharesForProducerMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDataSharesForProducer</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeDataSharesForProducerResult$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDataSharesForProducer</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeDataSharesMessage$DataShareArn' => '<p>The identifier of the datashare to describe details of.</p>', 'DescribeDataSharesMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDataShares</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeDataSharesResult$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDataShares</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeDefaultClusterParametersMessage$ParameterGroupFamily' => '<p>The name of the cluster parameter group family.</p>', 'DescribeDefaultClusterParametersMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDefaultClusterParameters</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeEndpointAccessMessage$ClusterIdentifier' => '<p>The cluster identifier associated with the described endpoint.</p>', 'DescribeEndpointAccessMessage$ResourceOwner' => '<p>The Amazon Web Services account ID of the owner of the cluster.</p>', 'DescribeEndpointAccessMessage$EndpointName' => '<p>The name of the endpoint to be described.</p>', 'DescribeEndpointAccessMessage$VpcId' => '<p>The virtual private cloud (VPC) identifier with access to the cluster.</p>', 'DescribeEndpointAccessMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>', 'DescribeEndpointAuthorizationMessage$ClusterIdentifier' => '<p>The cluster identifier of the cluster to access.</p>', 'DescribeEndpointAuthorizationMessage$Account' => '<p>The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee. If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.</p>', 'DescribeEndpointAuthorizationMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>', 'DescribeEventCategoriesMessage$SourceType' => '<p>The source type, such as cluster or parameter group, to which the described event categories apply.</p> <p>Valid values: cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, and scheduled-action.</p>', 'DescribeEventSubscriptionsMessage$SubscriptionName' => '<p>The name of the Amazon Redshift event notification subscription to be described.</p>', 'DescribeEventSubscriptionsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeEventSubscriptions request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeEventsMessage$SourceIdentifier' => '<p>The identifier of the event source for which events will be returned. If this parameter is not specified, then all sources are included in the response.</p> <p>Constraints:</p> <p>If <i>SourceIdentifier</i> is supplied, <i>SourceType</i> must also be provided.</p> <ul> <li> <p>Specify a cluster identifier when <i>SourceType</i> is <code>cluster</code>.</p> </li> <li> <p>Specify a cluster security group name when <i>SourceType</i> is <code>cluster-security-group</code>.</p> </li> <li> <p>Specify a cluster parameter group name when <i>SourceType</i> is <code>cluster-parameter-group</code>.</p> </li> <li> <p>Specify a cluster snapshot identifier when <i>SourceType</i> is <code>cluster-snapshot</code>.</p> </li> </ul>', 'DescribeEventsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeEvents</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeHsmClientCertificatesMessage$HsmClientCertificateIdentifier' => '<p>The identifier of a specific HSM client certificate for which you want information. If no identifier is specified, information is returned for all HSM client certificates owned by your Amazon Web Services account.</p>', 'DescribeHsmClientCertificatesMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeHsmClientCertificates</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeHsmConfigurationsMessage$HsmConfigurationIdentifier' => '<p>The identifier of a specific Amazon Redshift HSM configuration to be described. If no identifier is specified, information is returned for all HSM configurations owned by your Amazon Web Services account.</p>', 'DescribeHsmConfigurationsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeHsmConfigurations</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeLoggingStatusMessage$ClusterIdentifier' => '<p>The identifier of the cluster from which to get the logging status.</p> <p>Example: <code>examplecluster</code> </p>', 'DescribeNodeConfigurationOptionsMessage$ClusterIdentifier' => '<p>The identifier of the cluster to evaluate for possible node configurations.</p>', 'DescribeNodeConfigurationOptionsMessage$SnapshotIdentifier' => '<p>The identifier of the snapshot to evaluate for possible node configurations.</p>', 'DescribeNodeConfigurationOptionsMessage$OwnerAccount' => '<p>The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.</p>', 'DescribeNodeConfigurationOptionsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeNodeConfigurationOptions</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeOrderableClusterOptionsMessage$ClusterVersion' => '<p>The version filter value. Specify this parameter to show only the available offerings matching the specified version.</p> <p>Default: All versions.</p> <p>Constraints: Must be one of the version returned from <a>DescribeClusterVersions</a>.</p>', 'DescribeOrderableClusterOptionsMessage$NodeType' => '<p>The node type filter value. Specify this parameter to show only the available offerings matching the specified node type.</p>', 'DescribeOrderableClusterOptionsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeOrderableClusterOptions</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeReservedNodeExchangeStatusInputMessage$ReservedNodeId' => '<p>The identifier of the source reserved node in a reserved-node exchange request.</p>', 'DescribeReservedNodeExchangeStatusInputMessage$ReservedNodeExchangeRequestId' => '<p>The identifier of the reserved-node exchange request.</p>', 'DescribeReservedNodeExchangeStatusInputMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>', 'DescribeReservedNodeExchangeStatusOutputMessage$Marker' => '<p>A pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.</p>', 'DescribeReservedNodeOfferingsMessage$ReservedNodeOfferingId' => '<p>The unique identifier for the offering.</p>', 'DescribeReservedNodeOfferingsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeReservedNodeOfferings</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeReservedNodesMessage$ReservedNodeId' => '<p>Identifier for the node reservation.</p>', 'DescribeReservedNodesMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeReservedNodes</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeResizeMessage$ClusterIdentifier' => '<p>The unique identifier of a cluster whose resize progress you are requesting. This parameter is case-sensitive.</p> <p>By default, resize operations for all clusters defined for an Amazon Web Services account are returned.</p>', 'DescribeScheduledActionsMessage$ScheduledActionName' => '<p>The name of the scheduled action to retrieve. </p>', 'DescribeScheduledActionsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeScheduledActions</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DescribeSnapshotCopyGrantsMessage$SnapshotCopyGrantName' => '<p>The name of the snapshot copy grant.</p>', 'DescribeSnapshotCopyGrantsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p> <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>', 'DescribeSnapshotSchedulesMessage$ClusterIdentifier' => '<p>The unique identifier for the cluster whose snapshot schedules you want to view.</p>', 'DescribeSnapshotSchedulesMessage$ScheduleIdentifier' => '<p>A unique identifier for a snapshot schedule.</p>', 'DescribeSnapshotSchedulesMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>', 'DescribeSnapshotSchedulesOutputMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>', 'DescribeTableRestoreStatusMessage$ClusterIdentifier' => '<p>The Amazon Redshift cluster that the table is being restored to.</p>', 'DescribeTableRestoreStatusMessage$TableRestoreRequestId' => '<p>The identifier of the table restore request to return status for. If you don\'t specify a <code>TableRestoreRequestId</code> value, then <code>DescribeTableRestoreStatus</code> returns the status of all in-progress table restore requests.</p>', 'DescribeTableRestoreStatusMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeTableRestoreStatus</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>', 'DescribeTagsMessage$ResourceName' => '<p>The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>', 'DescribeTagsMessage$ResourceType' => '<p>The type of resource with which you want to view tags. Valid resource types are: </p> <ul> <li> <p>Cluster</p> </li> <li> <p>CIDR/IP</p> </li> <li> <p>EC2 security group</p> </li> <li> <p>Snapshot</p> </li> <li> <p>Cluster security group</p> </li> <li> <p>Subnet group</p> </li> <li> <p>HSM connection</p> </li> <li> <p>HSM certificate</p> </li> <li> <p>Parameter group</p> </li> <li> <p>Snapshot copy grant</p> </li> </ul> <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals</a> in the Amazon Redshift Cluster Management Guide. </p>', 'DescribeTagsMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request. </p>', 'DescribeUsageLimitsMessage$UsageLimitId' => '<p>The identifier of the usage limit to describe.</p>', 'DescribeUsageLimitsMessage$ClusterIdentifier' => '<p>The identifier of the cluster for which you want to describe usage limits.</p>', 'DescribeUsageLimitsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeUsageLimits</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'DisableLoggingMessage$ClusterIdentifier' => '<p>The identifier of the cluster on which logging is to be stopped.</p> <p>Example: <code>examplecluster</code> </p>', 'DisableSnapshotCopyMessage$ClusterIdentifier' => '<p>The unique identifier of the source cluster that you want to disable copying of snapshots to a destination region.</p> <p>Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.</p>', 'DisassociateDataShareConsumerMessage$DataShareArn' => '<p>The Amazon Resource Name (ARN) of the datashare to remove association for. </p>', 'DisassociateDataShareConsumerMessage$ConsumerArn' => '<p>The Amazon Resource Name (ARN) of the consumer that association for the datashare is removed from.</p>', 'DisassociateDataShareConsumerMessage$ConsumerRegion' => '<p>From a datashare consumer account, removes association of a datashare from all the existing and future namespaces in the specified Amazon Web Services Region.</p>', 'EC2SecurityGroup$Status' => '<p>The status of the EC2 security group.</p>', 'EC2SecurityGroup$EC2SecurityGroupName' => '<p>The name of the EC2 Security Group.</p>', 'EC2SecurityGroup$EC2SecurityGroupOwnerId' => '<p>The Amazon Web Services account ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>', 'ElasticIpStatus$ElasticIp' => '<p>The elastic IP (EIP) address for the cluster.</p>', 'ElasticIpStatus$Status' => '<p>The status of the elastic IP (EIP) address.</p>', 'EnableLoggingMessage$ClusterIdentifier' => '<p>The identifier of the cluster on which logging is to be started.</p> <p>Example: <code>examplecluster</code> </p>', 'EnableLoggingMessage$BucketName' => '<p>The name of an existing S3 bucket where the log files are to be stored.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the same region as the cluster</p> </li> <li> <p>The cluster must have read bucket and put object permissions</p> </li> </ul>', 'EnableLoggingMessage$S3KeyPrefix' => '<p>The prefix applied to the log file names.</p> <p>Constraints:</p> <ul> <li> <p>Cannot exceed 512 characters</p> </li> <li> <p>Cannot contain spaces( ), double quotes ("), single quotes (\'), a backslash (\\), or control characters. The hexadecimal codes for invalid characters are: </p> <ul> <li> <p>x00 to x20</p> </li> <li> <p>x22</p> </li> <li> <p>x27</p> </li> <li> <p>x5c</p> </li> <li> <p>x7f or larger</p> </li> </ul> </li> </ul>', 'EnableSnapshotCopyMessage$ClusterIdentifier' => '<p>The unique identifier of the source cluster to copy snapshots from.</p> <p>Constraints: Must be the valid name of an existing cluster that does not already have cross-region snapshot copy enabled.</p>', 'EnableSnapshotCopyMessage$DestinationRegion' => '<p>The destination Amazon Web Services Region that you want to copy snapshots to.</p> <p>Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in the Amazon Web Services General Reference. </p>', 'EnableSnapshotCopyMessage$SnapshotCopyGrantName' => '<p>The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted cluster are copied to the destination region.</p>', 'Endpoint$Address' => '<p>The DNS address of the Cluster.</p>', 'EndpointAccess$ClusterIdentifier' => '<p>The cluster identifier of the cluster associated with the endpoint.</p>', 'EndpointAccess$ResourceOwner' => '<p>The Amazon Web Services account ID of the owner of the cluster.</p>', 'EndpointAccess$SubnetGroupName' => '<p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>', 'EndpointAccess$EndpointStatus' => '<p>The status of the endpoint.</p>', 'EndpointAccess$EndpointName' => '<p>The name of the endpoint.</p>', 'EndpointAccess$Address' => '<p>The DNS address of the endpoint.</p>', 'EndpointAccessList$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>', 'EndpointAuthorization$Grantor' => '<p>The Amazon Web Services account ID of the cluster owner.</p>', 'EndpointAuthorization$Grantee' => '<p>The Amazon Web Services account ID of the grantee of the cluster.</p>', 'EndpointAuthorization$ClusterIdentifier' => '<p>The cluster identifier.</p>', 'EndpointAuthorization$ClusterStatus' => '<p>The status of the cluster.</p>', 'EndpointAuthorizationList$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>', 'Event$SourceIdentifier' => '<p>The identifier for the source of the event.</p>', 'Event$Message' => '<p>The text of this event.</p>', 'Event$Severity' => '<p>The severity of the event.</p> <p>Values: ERROR, INFO</p>', 'Event$EventId' => '<p>The identifier of the event.</p>', 'EventCategoriesList$member' => NULL, 'EventCategoriesMap$SourceType' => '<p>The source type, such as cluster or cluster-snapshot, that the returned categories belong to.</p>', 'EventInfoMap$EventId' => '<p>The identifier of an Amazon Redshift event.</p>', 'EventInfoMap$EventDescription' => '<p>The description of an Amazon Redshift event.</p>', 'EventInfoMap$Severity' => '<p>The severity of the event.</p> <p>Values: ERROR, INFO</p>', 'EventSubscription$CustomerAwsId' => '<p>The Amazon Web Services account associated with the Amazon Redshift event notification subscription.</p>', 'EventSubscription$CustSubscriptionId' => '<p>The name of the Amazon Redshift event notification subscription.</p>', 'EventSubscription$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.</p>', 'EventSubscription$Status' => '<p>The status of the Amazon Redshift event notification subscription.</p> <p>Constraints:</p> <ul> <li> <p>Can be one of the following: active | no-permission | topic-not-exist</p> </li> <li> <p>The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p> </li> </ul>', 'EventSubscription$SourceType' => '<p>The source type of the events returned by the Amazon Redshift event notification, such as cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action. </p>', 'EventSubscription$Severity' => '<p>The event severity specified in the Amazon Redshift event notification subscription.</p> <p>Values: ERROR, INFO</p>', 'EventSubscriptionsMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'EventsMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'GetClusterCredentialsMessage$DbUser' => '<p>The name of a database user. If a user name matching <code>DbUser</code> exists in the database, the temporary user credentials have the same permissions as the existing user. If <code>DbUser</code> doesn\'t exist in the database and <code>Autocreate</code> is <code>True</code>, a new user is created using the value for <code>DbUser</code> with PUBLIC permissions. If a database user matching the value for <code>DbUser</code> doesn\'t exist and <code>Autocreate</code> is <code>False</code>, then the command succeeds but the connection attempt will fail because the user doesn\'t exist in the database.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER</a> in the Amazon Redshift Database Developer Guide. </p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 64 alphanumeric characters or hyphens. The user name can\'t be <code>PUBLIC</code>.</p> </li> <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li> <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li> </ul>', 'GetClusterCredentialsMessage$DbName' => '<p>The name of a database that <code>DbUser</code> is authorized to log on to. If <code>DbName</code> is not specified, <code>DbUser</code> can log on to any existing database.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 64 alphanumeric characters or hyphens</p> </li> <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li> <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li> </ul>', 'GetClusterCredentialsMessage$ClusterIdentifier' => '<p>The unique identifier of the cluster that contains the database for which your are requesting credentials. This parameter is case sensitive.</p>', 'GetReservedNodeExchangeConfigurationOptionsInputMessage$ClusterIdentifier' => '<p>The identifier for the cluster that is the source for a reserved-node exchange.</p>', 'GetReservedNodeExchangeConfigurationOptionsInputMessage$SnapshotIdentifier' => '<p>The identifier for the snapshot that is the source for the reserved-node exchange.</p>', 'GetReservedNodeExchangeConfigurationOptionsInputMessage$Marker' => '<p>An optional pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>', 'GetReservedNodeExchangeConfigurationOptionsOutputMessage$Marker' => '<p>A pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code> request.</p>', 'GetReservedNodeExchangeOfferingsInputMessage$ReservedNodeId' => '<p>A string representing the node identifier for the DC1 Reserved Node to be exchanged.</p>', 'GetReservedNodeExchangeOfferingsInputMessage$Marker' => '<p>A value that indicates the starting point for the next set of ReservedNodeOfferings.</p>', 'GetReservedNodeExchangeOfferingsOutputMessage$Marker' => '<p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in MaxRecords, Amazon Redshift returns a value in the marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the marker parameter and retrying the request. </p>', 'HsmClientCertificate$HsmClientCertificateIdentifier' => '<p>The identifier of the HSM client certificate.</p>', 'HsmClientCertificate$HsmClientCertificatePublicKey' => '<p>The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public key in the HSM.</p>', 'HsmClientCertificateMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'HsmConfiguration$HsmConfigurationIdentifier' => '<p>The name of the Amazon Redshift HSM configuration.</p>', 'HsmConfiguration$Description' => '<p>A text description of the HSM configuration.</p>', 'HsmConfiguration$HsmIpAddress' => '<p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>', 'HsmConfiguration$HsmPartitionName' => '<p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>', 'HsmConfigurationMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'HsmStatus$HsmClientCertificateIdentifier' => '<p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>', 'HsmStatus$HsmConfigurationIdentifier' => '<p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>', 'HsmStatus$Status' => '<p>Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a modify cluster command.</p> <p>Values: active, applying</p>', 'IPRange$Status' => '<p>The status of the IP range, for example, "authorized".</p>', 'IPRange$CIDRIP' => '<p>The IP range in Classless Inter-Domain Routing (CIDR) notation.</p>', 'IamRoleArnList$member' => NULL, 'ImportTablesCompleted$member' => NULL, 'ImportTablesInProgress$member' => NULL, 'ImportTablesNotStarted$member' => NULL, 'LogTypeList$member' => NULL, 'LoggingStatus$BucketName' => '<p>The name of the S3 bucket where the log files are stored.</p>', 'LoggingStatus$S3KeyPrefix' => '<p>The prefix applied to the log file names.</p>', 'LoggingStatus$LastFailureMessage' => '<p>The message indicating that logs failed to be delivered.</p>', 'MaintenanceTrack$MaintenanceTrackName' => '<p>The name of the maintenance track. Possible values are <code>current</code> and <code>trailing</code>.</p>', 'MaintenanceTrack$DatabaseVersion' => '<p>The version number for the cluster release.</p>', 'ModifyAquaInputMessage$ClusterIdentifier' => '<p>The identifier of the cluster to be modified.</p>', 'ModifyAuthenticationProfileMessage$AuthenticationProfileContent' => '<p>The new content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>', 'ModifyAuthenticationProfileResult$AuthenticationProfileContent' => '<p>The updated content of the authentication profile in JSON format.</p>', 'ModifyClusterDbRevisionMessage$ClusterIdentifier' => '<p>The unique identifier of a cluster whose database revision you want to modify. </p> <p>Example: <code>examplecluster</code> </p>', 'ModifyClusterDbRevisionMessage$RevisionTarget' => '<p>The identifier of the database revision. You can retrieve this value from the response to the <a>DescribeClusterDbRevisions</a> request.</p>', 'ModifyClusterIamRolesMessage$ClusterIdentifier' => '<p>The unique identifier of the cluster for which you want to associate or disassociate IAM roles.</p>', 'ModifyClusterIamRolesMessage$DefaultIamRoleArn' => '<p>The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was last modified.</p>', 'ModifyClusterMaintenanceMessage$ClusterIdentifier' => '<p>A unique identifier for the cluster.</p>', 'ModifyClusterMaintenanceMessage$DeferMaintenanceIdentifier' => '<p>A unique identifier for the deferred maintenance window.</p>', 'ModifyClusterMessage$ClusterIdentifier' => '<p>The unique identifier of the cluster to be modified.</p> <p>Example: <code>examplecluster</code> </p>', 'ModifyClusterMessage$ClusterType' => '<p>The new cluster type.</p> <p>When you submit your cluster resize request, your existing cluster goes into a read-only mode. After Amazon Redshift provisions a new cluster based on your resize requirements, there will be outage for a period while the old cluster is deleted and your connection is switched to the new cluster. You can use <a>DescribeResize</a> to track the progress of the resize request. </p> <p>Valid Values: <code> multi-node | single-node </code> </p>', 'ModifyClusterMessage$NodeType' => '<p>The new node type of the cluster. If you specify a new node type, you must also specify the number of nodes parameter.</p> <p> For more information about resizing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code> </p>', 'ModifyClusterMessage$MasterUserPassword' => '<p>The new password for the cluster admin user. This change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the operation response. </p> <note> <p>Operations never return the password, so this operation provides a way to regain access to the admin user account for a cluster if the password is lost.</p> </note> <p>Default: Uses existing setting.</p> <p>Constraints:</p> <ul> <li> <p>Must be between 8 and 64 characters in length.</p> </li> <li> <p>Must contain at least one uppercase letter.</p> </li> <li> <p>Must contain at least one lowercase letter.</p> </li> <li> <p>Must contain one number.</p> </li> <li> <p>Can be any printable ASCII character (ASCII code 33-126) except \' (single quote), " (double quote), \\, /, or @.</p> </li> </ul>', 'ModifyClusterMessage$ClusterParameterGroupName' => '<p>The name of the cluster parameter group to apply to this cluster. This change is applied only after the cluster is rebooted. To reboot a cluster use <a>RebootCluster</a>. </p> <p>Default: Uses existing setting.</p> <p>Constraints: The cluster parameter group must be in the same parameter group family that matches the cluster version.</p>', 'ModifyClusterMessage$PreferredMaintenanceWindow' => '<p>The weekly time range (in UTC) during which system maintenance can occur, if necessary. If system maintenance is necessary during the window, it may result in an outage.</p> <p>This maintenance window change is made immediately. If the new maintenance window indicates the current time, there must be at least 120 minutes between the current time and end of the window in order to ensure that pending changes are applied.</p> <p>Default: Uses existing setting.</p> <p>Format: ddd:hh24:mi-ddd:hh24:mi, for example <code>wed:07:30-wed:08:00</code>.</p> <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p> <p>Constraints: Must be at least 30 minutes.</p>', 'ModifyClusterMessage$ClusterVersion' => '<p>The new version number of the Amazon Redshift engine to upgrade to.</p> <p>For major version upgrades, if a non-default cluster parameter group is currently in use, a new cluster parameter group in the cluster parameter group family for the new version must be specified. The new cluster parameter group can be the default for that cluster parameter group family. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>Example: <code>1.0</code> </p>', 'ModifyClusterMessage$HsmClientCertificateIdentifier' => '<p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>', 'ModifyClusterMessage$HsmConfigurationIdentifier' => '<p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>', 'ModifyClusterMessage$NewClusterIdentifier' => '<p>The new identifier for the cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>Alphabetic characters must be lowercase.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li> </ul> <p>Example: <code>examplecluster</code> </p>', 'ModifyClusterMessage$ElasticIp' => '<p>The Elastic IP (EIP) address for the cluster.</p> <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>', 'ModifyClusterMessage$MaintenanceTrackName' => '<p>The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous. The new track name stays in the <code>PendingModifiedValues</code> for the cluster until the next maintenance window. When the maintenance track changes, the cluster is switched to the latest cluster release available for the maintenance track. At this point, the maintenance track name is applied.</p>', 'ModifyClusterMessage$KmsKeyId' => '<p>The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.</p>', 'ModifyClusterMessage$AvailabilityZone' => '<p>The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.</p>', 'ModifyClusterParameterGroupMessage$ParameterGroupName' => '<p>The name of the parameter group to be modified.</p>', 'ModifyClusterSnapshotMessage$SnapshotIdentifier' => '<p>The identifier of the snapshot whose setting you want to modify.</p>', 'ModifyClusterSnapshotScheduleMessage$ClusterIdentifier' => '<p>A unique identifier for the cluster whose snapshot schedule you want to modify. </p>', 'ModifyClusterSnapshotScheduleMessage$ScheduleIdentifier' => '<p>A unique alphanumeric identifier for the schedule that you want to associate with the cluster.</p>', 'ModifyClusterSubnetGroupMessage$ClusterSubnetGroupName' => '<p>The name of the subnet group to be modified.</p>', 'ModifyClusterSubnetGroupMessage$Description' => '<p>A text description of the subnet group to be modified.</p>', 'ModifyEndpointAccessMessage$EndpointName' => '<p>The endpoint to be modified.</p>', 'ModifyEventSubscriptionMessage$SubscriptionName' => '<p>The name of the modified Amazon Redshift event notification subscription.</p>', 'ModifyEventSubscriptionMessage$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS topic to be used by the event notification subscription.</p>', 'ModifyEventSubscriptionMessage$SourceType' => '<p>The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs.</p> <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>', 'ModifyEventSubscriptionMessage$Severity' => '<p>Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p> <p>Values: ERROR, INFO</p>', 'ModifyScheduledActionMessage$ScheduledActionName' => '<p>The name of the scheduled action to modify. </p>', 'ModifyScheduledActionMessage$Schedule' => '<p>A modified schedule in either <code>at( )</code> or <code>cron( )</code> format. For more information about this parameter, see <a>ScheduledAction</a>.</p>', 'ModifyScheduledActionMessage$IamRole' => '<p>A different IAM role to assume to run the target action. For more information about this parameter, see <a>ScheduledAction</a>.</p>', 'ModifyScheduledActionMessage$ScheduledActionDescription' => '<p>A modified description of the scheduled action. </p>', 'ModifySnapshotCopyRetentionPeriodMessage$ClusterIdentifier' => '<p>The unique identifier of the cluster for which you want to change the retention period for either automated or manual snapshots that are copied to a destination Amazon Web Services Region.</p> <p>Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.</p>', 'ModifySnapshotScheduleMessage$ScheduleIdentifier' => '<p>A unique alphanumeric identifier of the schedule to modify.</p>', 'ModifyUsageLimitMessage$UsageLimitId' => '<p>The identifier of the usage limit to modify.</p>', 'NetworkInterface$NetworkInterfaceId' => '<p>The network interface identifier. </p>', 'NetworkInterface$SubnetId' => '<p>The subnet identifier. </p>', 'NetworkInterface$PrivateIpAddress' => '<p>The IPv4 address of the network interface within the subnet. </p>', 'NetworkInterface$AvailabilityZone' => '<p>The Availability Zone. </p>', 'NodeConfigurationOption$NodeType' => '<p>The node type, such as, "ds2.8xlarge".</p>', 'NodeConfigurationOptionsMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'OrderableClusterOption$ClusterVersion' => '<p>The version of the orderable cluster.</p>', 'OrderableClusterOption$ClusterType' => '<p>The cluster type, for example <code>multi-node</code>. </p>', 'OrderableClusterOption$NodeType' => '<p>The node type for the orderable cluster.</p>', 'OrderableClusterOptionsMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'Parameter$ParameterName' => '<p>The name of the parameter.</p>', 'Parameter$ParameterValue' => '<p>The value of the parameter. If <code>ParameterName</code> is <code>wlm_json_configuration</code>, then the maximum size of <code>ParameterValue</code> is 8000 characters.</p>', 'Parameter$Description' => '<p>A description of the parameter.</p>', 'Parameter$Source' => '<p>The source of the parameter value, such as "engine-default" or "user".</p>', 'Parameter$DataType' => '<p>The data type of the parameter.</p>', 'Parameter$AllowedValues' => '<p>The valid range of values for the parameter.</p>', 'Parameter$MinimumEngineVersion' => '<p>The earliest engine version to which the parameter can apply.</p>', 'PauseClusterMessage$ClusterIdentifier' => '<p>The identifier of the cluster to be paused.</p>', 'PendingActionsList$member' => NULL, 'PendingModifiedValues$MasterUserPassword' => '<p>The pending or in-progress change of the admin user password for the cluster.</p>', 'PendingModifiedValues$NodeType' => '<p>The pending or in-progress change of the cluster\'s node type.</p>', 'PendingModifiedValues$ClusterType' => '<p>The pending or in-progress change of the cluster type.</p>', 'PendingModifiedValues$ClusterVersion' => '<p>The pending or in-progress change of the service version.</p>', 'PendingModifiedValues$ClusterIdentifier' => '<p>The pending or in-progress change of the new identifier for the cluster.</p>', 'PendingModifiedValues$MaintenanceTrackName' => '<p>The name of the maintenance track that the cluster will change to during the next maintenance window.</p>', 'PendingModifiedValues$EncryptionType' => '<p>The encryption type for a cluster. Possible values are: KMS and None. </p>', 'PurchaseReservedNodeOfferingMessage$ReservedNodeOfferingId' => '<p>The unique identifier of the reserved node offering you want to purchase.</p>', 'RebootClusterMessage$ClusterIdentifier' => '<p>The cluster identifier.</p>', 'RecurringCharge$RecurringChargeFrequency' => '<p>The frequency at which the recurring charge amount is applied.</p>', 'RejectDataShareMessage$DataShareArn' => '<p>The Amazon Resource Name (ARN) of the datashare to reject.</p>', 'ReservedNode$ReservedNodeId' => '<p>The unique identifier for the reservation.</p>', 'ReservedNode$ReservedNodeOfferingId' => '<p>The identifier for the reserved node offering.</p>', 'ReservedNode$NodeType' => '<p>The node type of the reserved node.</p>', 'ReservedNode$CurrencyCode' => '<p>The currency code for the reserved cluster.</p>', 'ReservedNode$State' => '<p>The state of the reserved compute node.</p> <p>Possible Values:</p> <ul> <li> <p>pending-payment-This reserved node has recently been purchased, and the sale has been approved, but payment has not yet been confirmed.</p> </li> <li> <p>active-This reserved node is owned by the caller and is available for use.</p> </li> <li> <p>payment-failed-Payment failed for the purchase attempt.</p> </li> <li> <p>retired-The reserved node is no longer available. </p> </li> <li> <p>exchanging-The owner is exchanging the reserved node for another reserved node.</p> </li> </ul>', 'ReservedNode$OfferingType' => '<p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>', 'ReservedNodeExchangeStatus$ReservedNodeExchangeRequestId' => '<p>The identifier of the reserved-node exchange request.</p>', 'ReservedNodeExchangeStatus$SourceReservedNodeId' => '<p>The identifier of the source reserved node.</p>', 'ReservedNodeExchangeStatus$SourceReservedNodeType' => '<p>The source reserved-node type, for example ds2.xlarge.</p>', 'ReservedNodeExchangeStatus$TargetReservedNodeOfferingId' => '<p>The identifier of the target reserved node offering.</p>', 'ReservedNodeExchangeStatus$TargetReservedNodeType' => '<p>The node type of the target reserved node, for example ra3.4xlarge.</p>', 'ReservedNodeOffering$ReservedNodeOfferingId' => '<p>The offering identifier.</p>', 'ReservedNodeOffering$NodeType' => '<p>The node type offered by the reserved node offering.</p>', 'ReservedNodeOffering$CurrencyCode' => '<p>The currency code for the compute nodes offering.</p>', 'ReservedNodeOffering$OfferingType' => '<p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>', 'ReservedNodeOfferingsMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'ReservedNodesMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'ResetClusterParameterGroupMessage$ParameterGroupName' => '<p>The name of the cluster parameter group to be reset.</p>', 'ResizeClusterMessage$ClusterIdentifier' => '<p>The unique identifier for the cluster to resize.</p>', 'ResizeClusterMessage$ClusterType' => '<p>The new cluster type for the specified cluster.</p>', 'ResizeClusterMessage$NodeType' => '<p>The new node type for the nodes you are adding. If not specified, the cluster\'s current node type is used.</p>', 'ResizeClusterMessage$ReservedNodeId' => '<p>The identifier of the reserved node.</p>', 'ResizeClusterMessage$TargetReservedNodeOfferingId' => '<p>The identifier of the target reserved node offering.</p>', 'ResizeInfo$ResizeType' => '<p>Returns the value <code>ClassicResize</code>.</p>', 'ResizeProgressMessage$TargetNodeType' => '<p>The node type that the cluster will have after the resize operation is complete.</p>', 'ResizeProgressMessage$TargetClusterType' => '<p>The cluster type after the resize operation is complete.</p> <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>', 'ResizeProgressMessage$Status' => '<p>The status of the resize operation.</p> <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>', 'ResizeProgressMessage$ResizeType' => '<p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>', 'ResizeProgressMessage$Message' => '<p>An optional string to provide additional details about the resize action.</p>', 'ResizeProgressMessage$TargetEncryptionType' => '<p>The type of encryption for the cluster after the resize is complete.</p> <p>Possible values are <code>KMS</code> and <code>None</code>. </p>', 'RestorableNodeTypeList$member' => NULL, 'RestoreFromClusterSnapshotMessage$ClusterIdentifier' => '<p>The identifier of the cluster that will be created from restoring the snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>Alphabetic characters must be lowercase.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li> </ul>', 'RestoreFromClusterSnapshotMessage$SnapshotIdentifier' => '<p>The name of the snapshot from which to create the new cluster. This parameter isn\'t case sensitive.</p> <p>Example: <code>my-snapshot-id</code> </p>', 'RestoreFromClusterSnapshotMessage$SnapshotClusterIdentifier' => '<p>The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>', 'RestoreFromClusterSnapshotMessage$AvailabilityZone' => '<p>The Amazon EC2 Availability Zone in which to restore the cluster.</p> <p>Default: A random, system-chosen Availability Zone.</p> <p>Example: <code>us-east-2a</code> </p>', 'RestoreFromClusterSnapshotMessage$ClusterSubnetGroupName' => '<p>The name of the subnet group where you want to cluster restored.</p> <p>A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name where you want the cluster restored.</p>', 'RestoreFromClusterSnapshotMessage$OwnerAccount' => '<p>The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.</p>', 'RestoreFromClusterSnapshotMessage$HsmClientCertificateIdentifier' => '<p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>', 'RestoreFromClusterSnapshotMessage$HsmConfigurationIdentifier' => '<p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>', 'RestoreFromClusterSnapshotMessage$ElasticIp' => '<p>The elastic IP (EIP) address for the cluster.</p>', 'RestoreFromClusterSnapshotMessage$ClusterParameterGroupName' => '<p>The name of the parameter group to be associated with this cluster.</p> <p>Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a>.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'RestoreFromClusterSnapshotMessage$PreferredMaintenanceWindow' => '<p>The weekly time range (in UTC) during which automated cluster maintenance can occur.</p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p> Default: The value selected for the cluster from which the snapshot was taken. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide. </p> <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p> <p>Constraints: Minimum 30-minute window.</p>', 'RestoreFromClusterSnapshotMessage$KmsKeyId' => '<p>The Key Management Service (KMS) key ID of the encryption key that encrypts data in the cluster restored from a shared snapshot. You can also provide the key ID when you restore from an unencrypted snapshot to an encrypted cluster in the same account. Additionally, you can specify a new KMS key ID when you restore from an encrypted snapshot in the same account in order to change it. In that case, the restored cluster is encrypted with the new KMS key ID.</p>', 'RestoreFromClusterSnapshotMessage$NodeType' => '<p>The node type that the restored cluster will be provisioned with.</p> <p>Default: The node type of the cluster from which the snapshot was taken. You can modify this if you are using any DS node type. In that case, you can choose to restore into another DS node type of the same size. For example, you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC instance type, you must restore into that same instance type and size. In other words, you can only restore a dc1.large instance type into another dc1.large instance type or dc2.large instance type. You can\'t restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge cluster, then resize to a dc2.8large cluster. For more information about node types, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes"> About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'RestoreFromClusterSnapshotMessage$AdditionalInfo' => '<p>Reserved.</p>', 'RestoreFromClusterSnapshotMessage$MaintenanceTrackName' => '<p>The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks.</p>', 'RestoreFromClusterSnapshotMessage$SnapshotScheduleIdentifier' => '<p>A unique identifier for the snapshot schedule.</p>', 'RestoreFromClusterSnapshotMessage$DefaultIamRoleArn' => '<p>The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was last modified while it was restored from a snapshot.</p>', 'RestoreFromClusterSnapshotMessage$ReservedNodeId' => '<p>The identifier of the target reserved node offering.</p>', 'RestoreFromClusterSnapshotMessage$TargetReservedNodeOfferingId' => '<p>The identifier of the target reserved node offering.</p>', 'RestoreStatus$Status' => '<p>The status of the restore action. Returns starting, restoring, completed, or failed.</p>', 'RestoreTableFromClusterSnapshotMessage$ClusterIdentifier' => '<p>The identifier of the Amazon Redshift cluster to restore the table to.</p>', 'RestoreTableFromClusterSnapshotMessage$SnapshotIdentifier' => '<p>The identifier of the snapshot to restore the table from. This snapshot must have been created from the Amazon Redshift cluster specified by the <code>ClusterIdentifier</code> parameter.</p>', 'RestoreTableFromClusterSnapshotMessage$SourceDatabaseName' => '<p>The name of the source database that contains the table to restore from.</p>', 'RestoreTableFromClusterSnapshotMessage$SourceSchemaName' => '<p>The name of the source schema that contains the table to restore from. If you do not specify a <code>SourceSchemaName</code> value, the default is <code>public</code>.</p>', 'RestoreTableFromClusterSnapshotMessage$SourceTableName' => '<p>The name of the source table to restore from.</p>', 'RestoreTableFromClusterSnapshotMessage$TargetDatabaseName' => '<p>The name of the database to restore the table to.</p>', 'RestoreTableFromClusterSnapshotMessage$TargetSchemaName' => '<p>The name of the schema to restore the table to.</p>', 'RestoreTableFromClusterSnapshotMessage$NewTableName' => '<p>The name of the table to create as a result of the current request.</p>', 'ResumeClusterMessage$ClusterIdentifier' => '<p>The identifier of the cluster to be resumed.</p>', 'RevisionTarget$DatabaseRevision' => '<p>A unique string that identifies the version to update the cluster to. You can use this value in <a>ModifyClusterDbRevision</a>.</p>', 'RevisionTarget$Description' => '<p>A string that describes the changes and features that will be applied to the cluster when it is updated to the corresponding <a>ClusterDbRevision</a>.</p>', 'RevokeClusterSecurityGroupIngressMessage$ClusterSecurityGroupName' => '<p>The name of the security Group from which to revoke the ingress rule.</p>', 'RevokeClusterSecurityGroupIngressMessage$CIDRIP' => '<p>The IP range for which to revoke access. This range must be a valid Classless Inter-Domain Routing (CIDR) block of IP addresses. If <code>CIDRIP</code> is specified, <code>EC2SecurityGroupName</code> and <code>EC2SecurityGroupOwnerId</code> cannot be provided. </p>', 'RevokeClusterSecurityGroupIngressMessage$EC2SecurityGroupName' => '<p>The name of the EC2 Security Group whose access is to be revoked. If <code>EC2SecurityGroupName</code> is specified, <code>EC2SecurityGroupOwnerId</code> must also be provided and <code>CIDRIP</code> cannot be provided. </p>', 'RevokeClusterSecurityGroupIngressMessage$EC2SecurityGroupOwnerId' => '<p>The Amazon Web Services account number of the owner of the security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID is not an acceptable value. If <code>EC2SecurityGroupOwnerId</code> is specified, <code>EC2SecurityGroupName</code> must also be provided. and <code>CIDRIP</code> cannot be provided. </p> <p>Example: <code>111122223333</code> </p>', 'RevokeEndpointAccessMessage$ClusterIdentifier' => '<p>The cluster to revoke access from.</p>', 'RevokeEndpointAccessMessage$Account' => '<p>The Amazon Web Services account ID whose access is to be revoked.</p>', 'RevokeSnapshotAccessMessage$SnapshotIdentifier' => '<p>The identifier of the snapshot that the account can no longer access.</p>', 'RevokeSnapshotAccessMessage$SnapshotClusterIdentifier' => '<p>The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>', 'RevokeSnapshotAccessMessage$AccountWithRestoreAccess' => '<p>The identifier of the Amazon Web Services account that can no longer restore the specified snapshot.</p>', 'RotateEncryptionKeyMessage$ClusterIdentifier' => '<p>The unique identifier of the cluster that you want to rotate the encryption keys for.</p> <p>Constraints: Must be the name of valid cluster that has encryption enabled.</p>', 'ScheduleDefinitionList$member' => NULL, 'ScheduledAction$ScheduledActionName' => '<p>The name of the scheduled action. </p>', 'ScheduledAction$Schedule' => '<p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p> <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p> <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>', 'ScheduledAction$IamRole' => '<p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>', 'ScheduledAction$ScheduledActionDescription' => '<p>The description of the scheduled action. </p>', 'ScheduledActionsMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeScheduledActions</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>', 'Snapshot$SnapshotIdentifier' => '<p>The snapshot identifier that is provided in the request.</p>', 'Snapshot$ClusterIdentifier' => '<p>The identifier of the cluster for which the snapshot was taken.</p>', 'Snapshot$Status' => '<p>The snapshot status. The value of the status depends on the API operation used: </p> <ul> <li> <p> <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> returns status as "creating". </p> </li> <li> <p> <a>DescribeClusterSnapshots</a> returns status as "creating", "available", "final snapshot", or "failed".</p> </li> <li> <p> <a>DeleteClusterSnapshot</a> returns status as "deleted".</p> </li> </ul>', 'Snapshot$AvailabilityZone' => '<p>The Availability Zone in which the cluster was created.</p>', 'Snapshot$MasterUsername' => '<p>The admin user name for the cluster.</p>', 'Snapshot$ClusterVersion' => '<p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>', 'Snapshot$EngineFullVersion' => '<p>The cluster version of the cluster used to create the snapshot. For example, 1.0.15503. </p>', 'Snapshot$SnapshotType' => '<p>The snapshot type. Snapshots created using <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> are of type "manual". </p>', 'Snapshot$NodeType' => '<p>The node type of the nodes in the cluster.</p>', 'Snapshot$DBName' => '<p>The name of the database that was created when the cluster was created.</p>', 'Snapshot$VpcId' => '<p>The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the output.</p>', 'Snapshot$KmsKeyId' => '<p>The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.</p>', 'Snapshot$OwnerAccount' => '<p>For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.</p>', 'Snapshot$SourceRegion' => '<p>The source region from which the snapshot was copied.</p>', 'Snapshot$MaintenanceTrackName' => '<p>The name of the maintenance track for the snapshot.</p>', 'SnapshotCopyGrant$SnapshotCopyGrantName' => '<p>The name of the snapshot copy grant.</p>', 'SnapshotCopyGrant$KmsKeyId' => '<p>The unique identifier of the encrypted symmetric key in Amazon Web Services KMS to which Amazon Redshift is granted permission.</p>', 'SnapshotCopyGrantMessage$Marker' => '<p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p> <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>', 'SnapshotErrorMessage$SnapshotIdentifier' => '<p>A unique identifier for the snapshot returning the error.</p>', 'SnapshotErrorMessage$SnapshotClusterIdentifier' => '<p>A unique identifier for the cluster.</p>', 'SnapshotErrorMessage$FailureCode' => '<p>The failure code for the error.</p>', 'SnapshotErrorMessage$FailureReason' => '<p>The text message describing the error.</p>', 'SnapshotIdentifierList$member' => NULL, 'SnapshotMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'SnapshotSchedule$ScheduleIdentifier' => '<p>A unique identifier for the schedule.</p>', 'SnapshotSchedule$ScheduleDescription' => '<p>The description of the schedule.</p>', 'SourceIdsList$member' => NULL, 'Subnet$SubnetIdentifier' => '<p>The identifier of the subnet.</p>', 'Subnet$SubnetStatus' => '<p>The status of the subnet.</p>', 'SubnetIdentifierList$member' => NULL, 'SupportedOperation$OperationName' => '<p>A list of the supported operations.</p>', 'SupportedPlatform$Name' => '<p/>', 'TableRestoreStatus$TableRestoreRequestId' => '<p>The unique identifier for the table restore request.</p>', 'TableRestoreStatus$Message' => '<p>A description of the status of the table restore request. Status values include <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>.</p>', 'TableRestoreStatus$ClusterIdentifier' => '<p>The identifier of the Amazon Redshift cluster that the table is being restored to.</p>', 'TableRestoreStatus$SnapshotIdentifier' => '<p>The identifier of the snapshot that the table is being restored from.</p>', 'TableRestoreStatus$SourceDatabaseName' => '<p>The name of the source database that contains the table being restored.</p>', 'TableRestoreStatus$SourceSchemaName' => '<p>The name of the source schema that contains the table being restored.</p>', 'TableRestoreStatus$SourceTableName' => '<p>The name of the source table being restored.</p>', 'TableRestoreStatus$TargetDatabaseName' => '<p>The name of the database to restore the table to.</p>', 'TableRestoreStatus$TargetSchemaName' => '<p>The name of the schema to restore the table to.</p>', 'TableRestoreStatus$NewTableName' => '<p>The name of the table to create as a result of the table restore request.</p>', 'TableRestoreStatusMessage$Marker' => '<p>A pagination token that can be used in a subsequent <a>DescribeTableRestoreStatus</a> request.</p>', 'Tag$Key' => '<p>The key, or name, for the resource tag.</p>', 'Tag$Value' => '<p>The value for the resource tag.</p>', 'TagKeyList$member' => NULL, 'TagValueList$member' => NULL, 'TaggedResource$ResourceName' => '<p>The Amazon Resource Name (ARN) with which the tag is associated, for example: <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>.</p>', 'TaggedResource$ResourceType' => '<p>The type of resource with which the tag is associated. Valid resource types are: </p> <ul> <li> <p>Cluster</p> </li> <li> <p>CIDR/IP</p> </li> <li> <p>EC2 security group</p> </li> <li> <p>Snapshot</p> </li> <li> <p>Cluster security group</p> </li> <li> <p>Subnet group</p> </li> <li> <p>HSM connection</p> </li> <li> <p>HSM certificate</p> </li> <li> <p>Parameter group</p> </li> </ul> <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Constructing an Amazon Redshift Amazon Resource Name (ARN)</a> in the Amazon Redshift Cluster Management Guide. </p>', 'TaggedResourceListMessage$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'TrackListMessage$Marker' => '<p>The starting point to return a set of response tracklist records. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>', 'UpdateTarget$MaintenanceTrackName' => '<p>The name of the new maintenance track.</p>', 'UpdateTarget$DatabaseVersion' => '<p>The cluster version for the new maintenance track.</p>', 'UsageLimit$UsageLimitId' => '<p>The identifier of the usage limit.</p>', 'UsageLimit$ClusterIdentifier' => '<p>The identifier of the cluster with a usage limit.</p>', 'UsageLimitList$Marker' => '<p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>', 'ValueStringList$member' => NULL, 'VpcEndpoint$VpcEndpointId' => '<p>The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.</p>', 'VpcEndpoint$VpcId' => '<p>The VPC identifier that the endpoint is associated. </p>', 'VpcIdentifierList$member' => NULL, 'VpcSecurityGroupIdList$member' => NULL, 'VpcSecurityGroupMembership$VpcSecurityGroupId' => '<p>The identifier of the VPC security group.</p>', 'VpcSecurityGroupMembership$Status' => '<p>The status of the VPC security group.</p>', ], ], 'Subnet' => [ 'base' => '<p>Describes a subnet.</p>', 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetAlreadyInUse' => [ 'base' => '<p>A specified subnet is already in use by another cluster.</p>', 'refs' => [], ], 'SubnetIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreateClusterSubnetGroupMessage$SubnetIds' => '<p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.</p>', 'ModifyClusterSubnetGroupMessage$SubnetIds' => '<p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.</p>', ], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'ClusterSubnetGroup$Subnets' => '<p>A list of the VPC <a>Subnet</a> elements. </p>', ], ], 'SubscriptionAlreadyExistFault' => [ 'base' => '<p>There is already an existing event notification subscription with the specified name.</p>', 'refs' => [], ], 'SubscriptionCategoryNotFoundFault' => [ 'base' => '<p>The value specified for the event category was not one of the allowed values, or it specified a category that does not apply to the specified source type. The allowed values are Configuration, Management, Monitoring, and Security.</p>', 'refs' => [], ], 'SubscriptionEventIdNotFoundFault' => [ 'base' => '<p>An Amazon Redshift event with the specified event ID does not exist.</p>', 'refs' => [], ], 'SubscriptionNotFoundFault' => [ 'base' => '<p>An Amazon Redshift event notification subscription with the specified name does not exist.</p>', 'refs' => [], ], 'SubscriptionSeverityNotFoundFault' => [ 'base' => '<p>The value specified for the event severity was not one of the allowed values, or it specified a severity that does not apply to the specified source type. The allowed values are ERROR and INFO.</p>', 'refs' => [], ], 'SupportedOperation' => [ 'base' => '<p>Describes the operations that are allowed on a maintenance track.</p>', 'refs' => [ 'SupportedOperationList$member' => NULL, ], ], 'SupportedOperationList' => [ 'base' => NULL, 'refs' => [ 'UpdateTarget$SupportedOperations' => '<p>A list of operations supported by the maintenance track.</p>', ], ], 'SupportedPlatform' => [ 'base' => '<p>A list of supported platforms for orderable clusters.</p>', 'refs' => [ 'SupportedPlatformsList$member' => NULL, ], ], 'SupportedPlatformsList' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$SupportedPlatforms' => '<p/>', ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'Cluster$ClusterCreateTime' => '<p>The date and time that the cluster was created.</p>', 'Cluster$ExpectedNextSnapshotScheduleTime' => '<p>The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled. </p>', 'Cluster$NextMaintenanceWindowStartTime' => '<p>The date and time in UTC when system maintenance can begin.</p>', 'ClusterCredentials$Expiration' => '<p>The date and time the password in <code>DbPassword</code> expires.</p>', 'ClusterDbRevision$DatabaseRevisionReleaseDate' => '<p>The date on which the database revision was released.</p>', 'CreateScheduledActionMessage$StartTime' => '<p>The start time in UTC of the scheduled action. Before this time, the scheduled action does not trigger. For more information about this parameter, see <a>ScheduledAction</a>.</p>', 'CreateScheduledActionMessage$EndTime' => '<p>The end time in UTC of the scheduled action. After this time, the scheduled action does not trigger. For more information about this parameter, see <a>ScheduledAction</a>. </p>', 'DataShareAssociation$CreatedDate' => '<p>The creation date of the datashare that is associated.</p>', 'DataShareAssociation$StatusChangeDate' => '<p>The status change data of the datashare that is associated.</p>', 'DeferredMaintenanceWindow$DeferMaintenanceStartTime' => '<p> A timestamp for the beginning of the time period when we defer maintenance.</p>', 'DeferredMaintenanceWindow$DeferMaintenanceEndTime' => '<p> A timestamp for the end of the time period when we defer maintenance.</p>', 'DescribeClusterSnapshotsMessage$StartTime' => '<p>A value that requests only snapshots created at or after the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: <code>2012-07-16T18:00:00Z</code> </p>', 'DescribeClusterSnapshotsMessage$EndTime' => '<p>A time value that requests only snapshots created at or before the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: <code>2012-07-16T18:00:00Z</code> </p>', 'DescribeEventsMessage$StartTime' => '<p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: <code>2009-07-08T18:00Z</code> </p>', 'DescribeEventsMessage$EndTime' => '<p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: <code>2009-07-08T18:00Z</code> </p>', 'DescribeScheduledActionsMessage$StartTime' => '<p>The start time in UTC of the scheduled actions to retrieve. Only active scheduled actions that have invocations after this time are retrieved.</p>', 'DescribeScheduledActionsMessage$EndTime' => '<p>The end time in UTC of the scheduled action to retrieve. Only active scheduled actions that have invocations before this time are retrieved.</p>', 'EndpointAccess$EndpointCreateTime' => '<p>The time (UTC) that the endpoint was created.</p>', 'EndpointAuthorization$AuthorizeTime' => '<p>The time (UTC) when the authorization was created.</p>', 'Event$Date' => '<p>The date and time of the event.</p>', 'EventSubscription$SubscriptionCreationTime' => '<p>The date and time the Amazon Redshift event notification subscription was created.</p>', 'LoggingStatus$LastSuccessfulDeliveryTime' => '<p>The last time that logs were delivered.</p>', 'LoggingStatus$LastFailureTime' => '<p>The last time when logs failed to be delivered.</p>', 'ModifyClusterMaintenanceMessage$DeferMaintenanceStartTime' => '<p>A timestamp indicating the start time for the deferred maintenance window.</p>', 'ModifyClusterMaintenanceMessage$DeferMaintenanceEndTime' => '<p>A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can\'t specify a duration.</p>', 'ModifyScheduledActionMessage$StartTime' => '<p>A modified start time of the scheduled action. For more information about this parameter, see <a>ScheduledAction</a>. </p>', 'ModifyScheduledActionMessage$EndTime' => '<p>A modified end time of the scheduled action. For more information about this parameter, see <a>ScheduledAction</a>. </p>', 'PartnerIntegrationInfo$CreatedAt' => '<p>The date (UTC) that the partner integration was created.</p>', 'PartnerIntegrationInfo$UpdatedAt' => '<p>The date (UTC) that the partner integration status was last updated by the partner.</p>', 'ReservedNode$StartTime' => '<p>The time the reservation started. You purchase a reserved node offering for a duration. This is the start time of that duration.</p>', 'ReservedNodeExchangeStatus$RequestTime' => '<p>A date and time that indicate when the reserved-node exchange was requested.</p>', 'RevisionTarget$DatabaseRevisionReleaseDate' => '<p>The date on which the database revision was released.</p>', 'ScheduledAction$StartTime' => '<p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>', 'ScheduledAction$EndTime' => '<p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>', 'ScheduledActionTimeList$member' => NULL, 'ScheduledSnapshotTimeList$member' => NULL, 'Snapshot$SnapshotCreateTime' => '<p>The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data as of this exact time.</p>', 'Snapshot$ClusterCreateTime' => '<p>The time (UTC) when the cluster was originally created.</p>', 'Snapshot$SnapshotRetentionStartTime' => '<p>A timestamp representing the start of the retention period for the snapshot.</p>', 'TableRestoreStatus$RequestTime' => '<p>The time that the table restore request was made, in Universal Coordinated Time (UTC).</p>', ], ], 'TableLimitExceededFault' => [ 'base' => '<p>The number of tables in the cluster exceeds the limit for the requested new cluster node type. </p>', 'refs' => [], ], 'TableRestoreNotFoundFault' => [ 'base' => '<p>The specified <code>TableRestoreRequestId</code> value was not found.</p>', 'refs' => [], ], 'TableRestoreStatus' => [ 'base' => '<p>Describes the status of a <a>RestoreTableFromClusterSnapshot</a> operation.</p>', 'refs' => [ 'RestoreTableFromClusterSnapshotResult$TableRestoreStatus' => NULL, 'TableRestoreStatusList$member' => NULL, ], ], 'TableRestoreStatusList' => [ 'base' => NULL, 'refs' => [ 'TableRestoreStatusMessage$TableRestoreStatusDetails' => '<p>A list of status details for one or more table restore requests.</p>', ], ], 'TableRestoreStatusMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'TableRestoreStatusType' => [ 'base' => NULL, 'refs' => [ 'TableRestoreStatus$Status' => '<p>A value that describes the current state of the table restore request.</p> <p>Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code> </p>', ], ], 'Tag' => [ 'base' => '<p>A tag consisting of a name/value pair for a resource.</p>', 'refs' => [ 'TagList$member' => NULL, 'TaggedResource$Tag' => '<p>The tag for the resource.</p>', ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'DeleteTagsMessage$TagKeys' => '<p>The tag key that you want to delete.</p>', 'DescribeClusterParameterGroupsMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching cluster parameter groups that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag keys associated with them.</p>', 'DescribeClusterSecurityGroupsMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching cluster security groups that are associated with the specified key or keys. For example, suppose that you have security groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag keys associated with them.</p>', 'DescribeClusterSnapshotsMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching cluster snapshots that are associated with the specified key or keys. For example, suppose that you have snapshots that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag keys associated with them.</p>', 'DescribeClusterSubnetGroupsMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching cluster subnet groups that are associated with the specified key or keys. For example, suppose that you have subnet groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag keys associated with them.</p>', 'DescribeClustersMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching clusters that are associated with the specified key or keys. For example, suppose that you have clusters that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the clusters that have either or both of these tag keys associated with them.</p>', 'DescribeEventSubscriptionsMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching event notification subscriptions that are associated with the specified key or keys. For example, suppose that you have subscriptions that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag keys associated with them.</p>', 'DescribeHsmClientCertificatesMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching HSM client certificates that are associated with the specified key or keys. For example, suppose that you have HSM client certificates that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM client certificates that have either or both of these tag keys associated with them.</p>', 'DescribeHsmConfigurationsMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching HSM configurations that are associated with the specified key or keys. For example, suppose that you have HSM configurations that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag keys associated with them.</p>', 'DescribeSnapshotCopyGrantsMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.</p>', 'DescribeSnapshotSchedulesMessage$TagKeys' => '<p>The key value for a snapshot schedule tag.</p>', 'DescribeTagsMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.</p>', 'DescribeUsageLimitsMessage$TagKeys' => '<p>A tag key or keys for which you want to return all matching usage limit objects that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the usage limit objects have either or both of these tag keys associated with them.</p>', ], ], 'TagLimitExceededFault' => [ 'base' => '<p>You have exceeded the number of tags allowed.</p>', 'refs' => [], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'Cluster$Tags' => '<p>The list of tags for the cluster.</p>', 'ClusterParameterGroup$Tags' => '<p>The list of tags for the cluster parameter group.</p>', 'ClusterSecurityGroup$Tags' => '<p>The list of tags for the cluster security group.</p>', 'ClusterSubnetGroup$Tags' => '<p>The list of tags for the cluster subnet group.</p>', 'CreateClusterMessage$Tags' => '<p>A list of tag instances.</p>', 'CreateClusterParameterGroupMessage$Tags' => '<p>A list of tag instances.</p>', 'CreateClusterSecurityGroupMessage$Tags' => '<p>A list of tag instances.</p>', 'CreateClusterSnapshotMessage$Tags' => '<p>A list of tag instances.</p>', 'CreateClusterSubnetGroupMessage$Tags' => '<p>A list of tag instances.</p>', 'CreateEventSubscriptionMessage$Tags' => '<p>A list of tag instances.</p>', 'CreateHsmClientCertificateMessage$Tags' => '<p>A list of tag instances.</p>', 'CreateHsmConfigurationMessage$Tags' => '<p>A list of tag instances.</p>', 'CreateSnapshotCopyGrantMessage$Tags' => '<p>A list of tag instances.</p>', 'CreateSnapshotScheduleMessage$Tags' => '<p>An optional set of tags you can use to search for the schedule.</p>', 'CreateTagsMessage$Tags' => '<p>One or more name/value pairs to add as tags to the specified resource. Each tag name is passed in with the parameter <code>Key</code> and the corresponding value is passed in with the parameter <code>Value</code>. The <code>Key</code> and <code>Value</code> parameters are separated by a comma (,). Separate multiple tags with a space. For example, <code>--tags "Key"="owner","Value"="admin" "Key"="environment","Value"="test" "Key"="version","Value"="1.0"</code>. </p>', 'CreateUsageLimitMessage$Tags' => '<p>A list of tag instances.</p>', 'EC2SecurityGroup$Tags' => '<p>The list of tags for the EC2 security group.</p>', 'EventSubscription$Tags' => '<p>The list of tags for the event subscription.</p>', 'HsmClientCertificate$Tags' => '<p>The list of tags for the HSM client certificate.</p>', 'HsmConfiguration$Tags' => '<p>The list of tags for the HSM configuration.</p>', 'IPRange$Tags' => '<p>The list of tags for the IP range.</p>', 'Snapshot$Tags' => '<p>The list of tags for the cluster snapshot.</p>', 'SnapshotCopyGrant$Tags' => '<p>A list of tag instances.</p>', 'SnapshotSchedule$Tags' => '<p>An optional set of tags describing the schedule.</p>', 'UsageLimit$Tags' => '<p>A list of tag instances.</p>', ], ], 'TagValueList' => [ 'base' => NULL, 'refs' => [ 'DescribeClusterParameterGroupsMessage$TagValues' => '<p>A tag value or values for which you want to return all matching cluster parameter groups that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag values associated with them.</p>', 'DescribeClusterSecurityGroupsMessage$TagValues' => '<p>A tag value or values for which you want to return all matching cluster security groups that are associated with the specified tag value or values. For example, suppose that you have security groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag values associated with them.</p>', 'DescribeClusterSnapshotsMessage$TagValues' => '<p>A tag value or values for which you want to return all matching cluster snapshots that are associated with the specified tag value or values. For example, suppose that you have snapshots that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag values associated with them.</p>', 'DescribeClusterSubnetGroupsMessage$TagValues' => '<p>A tag value or values for which you want to return all matching cluster subnet groups that are associated with the specified tag value or values. For example, suppose that you have subnet groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag values associated with them.</p>', 'DescribeClustersMessage$TagValues' => '<p>A tag value or values for which you want to return all matching clusters that are associated with the specified tag value or values. For example, suppose that you have clusters that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the clusters that have either or both of these tag values associated with them.</p>', 'DescribeEventSubscriptionsMessage$TagValues' => '<p>A tag value or values for which you want to return all matching event notification subscriptions that are associated with the specified tag value or values. For example, suppose that you have subscriptions that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag values associated with them.</p>', 'DescribeHsmClientCertificatesMessage$TagValues' => '<p>A tag value or values for which you want to return all matching HSM client certificates that are associated with the specified tag value or values. For example, suppose that you have HSM client certificates that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM client certificates that have either or both of these tag values associated with them.</p>', 'DescribeHsmConfigurationsMessage$TagValues' => '<p>A tag value or values for which you want to return all matching HSM configurations that are associated with the specified tag value or values. For example, suppose that you have HSM configurations that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag values associated with them.</p>', 'DescribeSnapshotCopyGrantsMessage$TagValues' => '<p>A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.</p>', 'DescribeSnapshotSchedulesMessage$TagValues' => '<p>The value corresponding to the key of the snapshot schedule tag.</p>', 'DescribeTagsMessage$TagValues' => '<p>A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.</p>', 'DescribeUsageLimitsMessage$TagValues' => '<p>A tag value or values for which you want to return all matching usage limit objects that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the usage limit objects that have either or both of these tag values associated with them.</p>', ], ], 'TaggedResource' => [ 'base' => '<p>A tag and its associated resource.</p>', 'refs' => [ 'TaggedResourceList$member' => NULL, ], ], 'TaggedResourceList' => [ 'base' => NULL, 'refs' => [ 'TaggedResourceListMessage$TaggedResources' => '<p>A list of tags with their associated resources.</p>', ], ], 'TaggedResourceListMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'TrackList' => [ 'base' => NULL, 'refs' => [ 'TrackListMessage$MaintenanceTracks' => '<p>A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation. </p>', ], ], 'TrackListMessage' => [ 'base' => NULL, 'refs' => [], ], 'UnauthorizedOperation' => [ 'base' => '<p>Your account is not authorized to perform the requested operation.</p>', 'refs' => [], ], 'UnauthorizedPartnerIntegrationFault' => [ 'base' => '<p>The partner integration is not authorized.</p>', 'refs' => [], ], 'UnknownSnapshotCopyRegionFault' => [ 'base' => '<p>The specified region is incorrect or does not exist.</p>', 'refs' => [], ], 'UnsupportedOperationFault' => [ 'base' => '<p>The requested operation isn\'t supported.</p>', 'refs' => [], ], 'UnsupportedOptionFault' => [ 'base' => '<p>A request option was specified that is not supported.</p>', 'refs' => [], ], 'UpdatePartnerStatusInputMessage' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTarget' => [ 'base' => '<p>A maintenance track that you can switch the current track to.</p>', 'refs' => [ 'EligibleTracksToUpdateList$member' => NULL, ], ], 'UsageLimit' => [ 'base' => '<p>Describes a usage limit object for a cluster. </p>', 'refs' => [ 'UsageLimits$member' => NULL, ], ], 'UsageLimitAlreadyExistsFault' => [ 'base' => '<p>The usage limit already exists. </p>', 'refs' => [], ], 'UsageLimitBreachAction' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitMessage$BreachAction' => '<p>The action that Amazon Redshift takes when the limit is reached. The default is log. For more information about this parameter, see <a>UsageLimit</a>.</p>', 'ModifyUsageLimitMessage$BreachAction' => '<p>The new action that Amazon Redshift takes when the limit is reached. For more information about this parameter, see <a>UsageLimit</a>. </p>', 'UsageLimit$BreachAction' => '<p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p> <ul> <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li> <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li> <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li> </ul>', ], ], 'UsageLimitFeatureType' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitMessage$FeatureType' => '<p>The Amazon Redshift feature that you want to limit.</p>', 'DescribeUsageLimitsMessage$FeatureType' => '<p>The feature type for which you want to describe usage limits.</p>', 'UsageLimit$FeatureType' => '<p>The Amazon Redshift feature to which the limit applies.</p>', ], ], 'UsageLimitLimitType' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitMessage$LimitType' => '<p>The type of limit. Depending on the feature type, this can be based on a time duration or data size. If <code>FeatureType</code> is <code>spectrum</code>, then <code>LimitType</code> must be <code>data-scanned</code>. If <code>FeatureType</code> is <code>concurrency-scaling</code>, then <code>LimitType</code> must be <code>time</code>. If <code>FeatureType</code> is <code>cross-region-datasharing</code>, then <code>LimitType</code> must be <code>data-scanned</code>. </p>', 'UsageLimit$LimitType' => '<p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>', ], ], 'UsageLimitList' => [ 'base' => NULL, 'refs' => [], ], 'UsageLimitNotFoundFault' => [ 'base' => '<p>The usage limit identifier can\'t be found.</p>', 'refs' => [], ], 'UsageLimitPeriod' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitMessage$Period' => '<p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>', 'UsageLimit$Period' => '<p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>', ], ], 'UsageLimits' => [ 'base' => NULL, 'refs' => [ 'UsageLimitList$UsageLimits' => '<p>Contains the output from the <a>DescribeUsageLimits</a> action. </p>', ], ], 'ValueStringList' => [ 'base' => NULL, 'refs' => [ 'NodeConfigurationOptionsFilter$Values' => '<p>List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values can range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100. For example, filter NumberOfNodes (name) GT (operator) 3 (values).</p>', 'ScheduledActionFilter$Values' => '<p>List of values. Compare if the value (of type defined by <code>Name</code>) equals an item in the list of scheduled actions. </p>', ], ], 'VpcEndpoint' => [ 'base' => '<p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>', 'refs' => [ 'EndpointAccess$VpcEndpoint' => NULL, 'VpcEndpointsList$member' => NULL, ], ], 'VpcEndpointsList' => [ 'base' => NULL, 'refs' => [ 'Endpoint$VpcEndpoints' => '<p>Describes a connection endpoint.</p>', ], ], 'VpcIdentifierList' => [ 'base' => NULL, 'refs' => [ 'AuthorizeEndpointAccessMessage$VpcIds' => '<p>The virtual private cloud (VPC) identifiers to grant access to.</p>', 'EndpointAuthorization$AllowedVPCs' => '<p>The VPCs allowed access to the cluster.</p>', 'RevokeEndpointAccessMessage$VpcIds' => '<p>The virtual private cloud (VPC) identifiers for which access is to be revoked.</p>', ], ], 'VpcSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateClusterMessage$VpcSecurityGroupIds' => '<p>A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p> <p>Default: The default VPC security group is associated with the cluster.</p>', 'CreateEndpointAccessMessage$VpcSecurityGroupIds' => '<p>The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>', 'ModifyClusterMessage$VpcSecurityGroupIds' => '<p>A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change is asynchronously applied as soon as possible.</p>', 'ModifyEndpointAccessMessage$VpcSecurityGroupIds' => '<p>The complete list of VPC security groups associated with the endpoint after the endpoint is modified.</p>', 'RestoreFromClusterSnapshotMessage$VpcSecurityGroupIds' => '<p>A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p> <p>Default: The default VPC security group is associated with the cluster.</p> <p>VPC security groups only apply to clusters in VPCs.</p>', ], ], 'VpcSecurityGroupMembership' => [ 'base' => '<p>Describes the members of a VPC security group.</p>', 'refs' => [ 'VpcSecurityGroupMembershipList$member' => NULL, ], ], 'VpcSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'Cluster$VpcSecurityGroups' => '<p>A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster. This parameter is returned only if the cluster is in a VPC.</p>', 'EndpointAccess$VpcSecurityGroups' => '<p>The security groups associated with the endpoint.</p>', ], ], ],];
