<?php
// This file was auto-generated from sdk-root/src/data/panorama/2019-07-24/docs-2.json
return [ 'version' => '2.0', 'service' => '<p><fullname>AWS Panorama</fullname> <p> <b>Overview</b> </p> <p>This is the <i>AWS Panorama API Reference</i>. For an introduction to the service, see <a href="https://docs.aws.amazon.com/panorama/latest/dev/panorama-welcome.html">What is AWS Panorama?</a> in the <i>AWS Panorama Developer Guide</i>.</p></p>', 'operations' => [ 'CreateApplicationInstance' => '<p>Creates an application instance and deploys it to a device.</p>', 'CreateJobForDevices' => '<p>Creates a job to run on one or more devices.</p>', 'CreateNodeFromTemplateJob' => '<p>Creates a camera stream node.</p>', 'CreatePackage' => '<p>Creates a package and storage location in an Amazon S3 access point.</p>', 'CreatePackageImportJob' => '<p>Imports a node package.</p>', 'DeleteDevice' => '<p>Deletes a device.</p>', 'DeletePackage' => '<p>Deletes a package.</p> <note> <p>To delete a package, you need permission to call <code>s3:DeleteObject</code> in addition to permissions for the AWS Panorama API.</p> </note>', 'DeregisterPackageVersion' => '<p>Deregisters a package version.</p>', 'DescribeApplicationInstance' => '<p>Returns information about an application instance on a device.</p>', 'DescribeApplicationInstanceDetails' => '<p>Returns information about an application instance\'s configuration manifest.</p>', 'DescribeDevice' => '<p>Returns information about a device.</p>', 'DescribeDeviceJob' => '<p>Returns information about a device job.</p>', 'DescribeNode' => '<p>Returns information about a node.</p>', 'DescribeNodeFromTemplateJob' => '<p>Returns information about a job to create a camera stream node.</p>', 'DescribePackage' => '<p>Returns information about a package.</p>', 'DescribePackageImportJob' => '<p>Returns information about a package import job.</p>', 'DescribePackageVersion' => '<p>Returns information about a package version.</p>', 'ListApplicationInstanceDependencies' => '<p>Returns a list of application instance dependencies.</p>', 'ListApplicationInstanceNodeInstances' => '<p>Returns a list of application node instances.</p>', 'ListApplicationInstances' => '<p>Returns a list of application instances.</p>', 'ListDevices' => '<p>Returns a list of devices.</p>', 'ListDevicesJobs' => '<p>Returns a list of jobs.</p>', 'ListNodeFromTemplateJobs' => '<p>Returns a list of camera stream node jobs.</p>', 'ListNodes' => '<p>Returns a list of nodes.</p>', 'ListPackageImportJobs' => '<p>Returns a list of package import jobs.</p>', 'ListPackages' => '<p>Returns a list of packages.</p>', 'ListTagsForResource' => '<p>Returns a list of tags for a resource.</p>', 'ProvisionDevice' => '<p>Creates a device and returns a configuration archive. The configuration archive is a ZIP file that contains a provisioning certificate that is valid for 5 minutes. Name the configuration archive <code>certificates-omni_<i>device-name</i>.zip</code> and transfer it to the device within 5 minutes. Use the included USB storage device and connect it to the USB 3.0 port next to the HDMI output.</p>', 'RegisterPackageVersion' => '<p>Registers a package version.</p>', 'RemoveApplicationInstance' => '<p>Removes an application instance.</p>', 'TagResource' => '<p>Tags a resource.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p>', 'UpdateDeviceMetadata' => '<p>Updates a device\'s metadata.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The requestor does not have permission to access the target action or resource.</p>', 'refs' => [], ], 'AlternateSoftwareMetadata' => [ 'base' => '<p>Details about a beta appliance software update.</p>', 'refs' => [ 'AlternateSoftwares$member' => NULL, ], ], 'AlternateSoftwares' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$AlternateSoftwares' => '<p>Beta software releases available for the device.</p>', ], ], 'ApplicationInstance' => [ 'base' => '<p>An application instance on a device.</p>', 'refs' => [ 'ApplicationInstances$member' => NULL, ], ], 'ApplicationInstanceArn' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$Arn' => '<p>The application instance\'s ARN.</p>', 'DescribeApplicationInstanceResponse$Arn' => '<p>The application instance\'s ARN.</p>', ], ], 'ApplicationInstanceHealthStatus' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$HealthStatus' => '<p>The application instance\'s health status.</p>', 'DescribeApplicationInstanceResponse$HealthStatus' => '<p>The application instance\'s health status.</p>', ], ], 'ApplicationInstanceId' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$ApplicationInstanceId' => '<p>The application instance\'s ID.</p>', 'CreateApplicationInstanceRequest$ApplicationInstanceIdToReplace' => '<p>The ID of an application instance to replace with the new instance.</p>', 'CreateApplicationInstanceResponse$ApplicationInstanceId' => '<p>The application instance\'s ID.</p>', 'DescribeApplicationInstanceDetailsRequest$ApplicationInstanceId' => '<p>The application instance\'s ID.</p>', 'DescribeApplicationInstanceDetailsResponse$ApplicationInstanceId' => '<p>The application instance\'s ID.</p>', 'DescribeApplicationInstanceDetailsResponse$ApplicationInstanceIdToReplace' => '<p>The ID of the application instance that this instance replaced.</p>', 'DescribeApplicationInstanceRequest$ApplicationInstanceId' => '<p>The application instance\'s ID.</p>', 'DescribeApplicationInstanceResponse$ApplicationInstanceId' => '<p>The application instance\'s ID.</p>', 'DescribeApplicationInstanceResponse$ApplicationInstanceIdToReplace' => '<p>The ID of the application instance that this instance replaced.</p>', 'ListApplicationInstanceDependenciesRequest$ApplicationInstanceId' => '<p>The application instance\'s ID.</p>', 'ListApplicationInstanceNodeInstancesRequest$ApplicationInstanceId' => '<p>The node instances\' application instance ID.</p>', 'RemoveApplicationInstanceRequest$ApplicationInstanceId' => '<p>An application instance ID.</p>', ], ], 'ApplicationInstanceName' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$Name' => '<p>The application instance\'s name.</p>', 'CreateApplicationInstanceRequest$Name' => '<p>A name for the application instance.</p>', 'DescribeApplicationInstanceDetailsResponse$Name' => '<p>The application instance\'s name.</p>', 'DescribeApplicationInstanceResponse$Name' => '<p>The application instance\'s name.</p>', ], ], 'ApplicationInstanceStatus' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$Status' => '<p>The application instance\'s status.</p>', 'DescribeApplicationInstanceResponse$Status' => '<p>The application instance\'s status.</p>', ], ], 'ApplicationInstanceStatusDescription' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$StatusDescription' => '<p>The application instance\'s status description.</p>', 'DescribeApplicationInstanceResponse$StatusDescription' => '<p>The application instance\'s status description.</p>', ], ], 'ApplicationInstances' => [ 'base' => NULL, 'refs' => [ 'ListApplicationInstancesResponse$ApplicationInstances' => '<p>A list of application instances.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'DeletePackageRequest$ForceDelete' => '<p>Delete the package even if it has artifacts stored in its access point. Deletes the package\'s artifacts from Amazon S3.</p>', 'DescribePackageVersionResponse$IsLatestPatch' => '<p>Whether the version is the latest available.</p>', ], ], 'Bucket' => [ 'base' => NULL, 'refs' => [ 'StorageLocation$Bucket' => '<p>The location\'s bucket.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'OutPutS3Location$BucketName' => '<p>The object\'s bucket.</p>', 'S3Location$BucketName' => '<p>A bucket name.</p>', ], ], 'Certificates' => [ 'base' => NULL, 'refs' => [ 'ProvisionDeviceResponse$Certificates' => '<p>The device\'s configuration bundle.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreatePackageImportJobRequest$ClientToken' => '<p>A client token for the package import job.</p>', 'DescribePackageImportJobResponse$ClientToken' => '<p>The job\'s client token.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The target resource is in use.</p>', 'refs' => [], ], 'ConflictExceptionErrorArgument' => [ 'base' => '<p>A conflict exception error argument.</p>', 'refs' => [ 'ConflictExceptionErrorArgumentList$member' => NULL, ], ], 'ConflictExceptionErrorArgumentList' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ErrorArguments' => '<p>A list of attributes that led to the exception and their values.</p>', ], ], 'ConnectionType' => [ 'base' => NULL, 'refs' => [ 'EthernetPayload$ConnectionType' => '<p>How the device gets an IP address.</p>', ], ], 'CreateApplicationInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobForDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobForDevicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNodeFromTemplateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNodeFromTemplateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePackageImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePackageImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePackageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePackageResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedTime' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$CreatedTime' => '<p>When the device was created.</p>', 'DescribeNodeFromTemplateJobResponse$CreatedTime' => '<p>When the job was created.</p>', 'DescribePackageImportJobResponse$CreatedTime' => '<p>When the job was created.</p>', 'Device$CreatedTime' => '<p>When the device was created.</p>', 'DeviceJob$CreatedTime' => '<p>When the job was created.</p>', 'NodeFromTemplateJob$CreatedTime' => '<p>When the job was created.</p>', 'PackageImportJob$CreatedTime' => '<p>When the job was created.</p>', ], ], 'CurrentSoftware' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$CurrentSoftware' => '<p>The device\'s current software version.</p>', ], ], 'DefaultGateway' => [ 'base' => NULL, 'refs' => [ 'StaticIpConnectionInfo$DefaultGateway' => '<p>The connection\'s default gateway.</p>', ], ], 'DefaultRuntimeContextDevice' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$DefaultRuntimeContextDevice' => '<p>The device\'s ID.</p>', 'CreateApplicationInstanceRequest$DefaultRuntimeContextDevice' => '<p>A device\'s ID.</p>', 'DescribeApplicationInstanceDetailsResponse$DefaultRuntimeContextDevice' => '<p>The application instance\'s default runtime context device.</p>', 'DescribeApplicationInstanceResponse$DefaultRuntimeContextDevice' => '<p>The device\'s ID.</p>', ], ], 'DeleteDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePackageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePackageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterPackageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterPackageVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationInstanceDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationInstanceDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNodeFromTemplateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNodeFromTemplateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNodeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePackageVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$Description' => '<p>The application instance\'s description.</p>', 'CreateApplicationInstanceRequest$Description' => '<p>A description for the application instance.</p>', 'CreateNodeFromTemplateJobRequest$NodeDescription' => '<p>A description for the node.</p>', 'DescribeApplicationInstanceDetailsResponse$Description' => '<p>The application instance\'s description.</p>', 'DescribeApplicationInstanceResponse$Description' => '<p>The application instance\'s description.</p>', 'DescribeDeviceResponse$Description' => '<p>The device\'s description.</p>', 'DescribeNodeFromTemplateJobResponse$NodeDescription' => '<p>The node\'s description.</p>', 'DescribeNodeResponse$Description' => '<p>The node\'s description.</p>', 'Node$Description' => '<p>The node\'s description.</p>', 'NodeInputPort$Description' => '<p>The input port\'s description.</p>', 'NodeOutputPort$Description' => '<p>The output port\'s description.</p>', 'ProvisionDeviceRequest$Description' => '<p>A description for the device.</p>', 'UpdateDeviceMetadataRequest$Description' => '<p>A description for the device.</p>', ], ], 'Device' => [ 'base' => '<p>A device.</p>', 'refs' => [ 'DeviceList$member' => NULL, ], ], 'DeviceArn' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceJobResponse$DeviceArn' => '<p>The device\'s ARN.</p>', 'DescribeDeviceResponse$Arn' => '<p>The device\'s ARN.</p>', 'ProvisionDeviceResponse$Arn' => '<p>The device\'s ARN.</p>', ], ], 'DeviceBrand' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$Brand' => '<p>The device\'s maker.</p>', 'Device$Brand' => '<p>The device\'s maker.</p>', ], ], 'DeviceConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$DeviceConnectionStatus' => '<p>The device\'s connection status.</p>', ], ], 'DeviceId' => [ 'base' => NULL, 'refs' => [ 'DeleteDeviceRequest$DeviceId' => '<p>The device\'s ID.</p>', 'DeleteDeviceResponse$DeviceId' => '<p>The device\'s ID.</p>', 'DescribeDeviceJobResponse$DeviceId' => '<p>The device\'s ID.</p>', 'DescribeDeviceRequest$DeviceId' => '<p>The device\'s ID.</p>', 'DescribeDeviceResponse$DeviceId' => '<p>The device\'s ID.</p>', 'Device$DeviceId' => '<p>The device\'s ID.</p>', 'DeviceIdList$member' => NULL, 'DeviceJob$DeviceId' => '<p>The ID of the target device.</p>', 'Job$DeviceId' => '<p>The target device\'s ID.</p>', 'ListApplicationInstancesRequest$DeviceId' => '<p>The application instances\' device ID.</p>', 'ListDevicesJobsRequest$DeviceId' => '<p>Filter results by the job\'s target device ID.</p>', 'ProvisionDeviceResponse$DeviceId' => '<p>The device\'s ID.</p>', 'UpdateDeviceMetadataRequest$DeviceId' => '<p>The device\'s ID.</p>', 'UpdateDeviceMetadataResponse$DeviceId' => '<p>The device\'s ID.</p>', ], ], 'DeviceIdList' => [ 'base' => NULL, 'refs' => [ 'CreateJobForDevicesRequest$DeviceIds' => '<p>IDs of target devices.</p>', ], ], 'DeviceJob' => [ 'base' => '<p>A job that runs on a device.</p>', 'refs' => [ 'DeviceJobList$member' => NULL, ], ], 'DeviceJobConfig' => [ 'base' => '<p>A job\'s configuration.</p>', 'refs' => [ 'CreateJobForDevicesRequest$DeviceJobConfig' => '<p>Configuration settings for the job.</p>', ], ], 'DeviceJobList' => [ 'base' => NULL, 'refs' => [ 'ListDevicesJobsResponse$DeviceJobs' => '<p>A list of jobs.</p>', ], ], 'DeviceList' => [ 'base' => NULL, 'refs' => [ 'ListDevicesResponse$Devices' => '<p>A list of devices.</p>', ], ], 'DeviceName' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$DefaultRuntimeContextDeviceName' => '<p>The device\'s name.</p>', 'DescribeApplicationInstanceResponse$DefaultRuntimeContextDeviceName' => '<p>The device\'s bane.</p>', 'DescribeDeviceJobResponse$DeviceName' => '<p>The device\'s name.</p>', 'DescribeDeviceResponse$Name' => '<p>The device\'s name.</p>', 'Device$Name' => '<p>The device\'s name.</p>', 'DeviceJob$DeviceName' => '<p>The name of the target device</p>', 'ProvisionDeviceRequest$Name' => '<p>A name for the device.</p>', ], ], 'DeviceSerialNumber' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$SerialNumber' => '<p>The device\'s serial number.</p>', ], ], 'DeviceStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$ProvisioningStatus' => '<p>The device\'s provisioning status.</p>', 'Device$ProvisioningStatus' => '<p>The device\'s provisioning status.</p>', 'ProvisionDeviceResponse$Status' => '<p>The device\'s status.</p>', ], ], 'DeviceType' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceJobResponse$DeviceType' => '<p>The device\'s type.</p>', 'DescribeDeviceResponse$Type' => '<p>The device\'s type.</p>', ], ], 'Dns' => [ 'base' => NULL, 'refs' => [ 'DnsList$member' => NULL, ], ], 'DnsList' => [ 'base' => NULL, 'refs' => [ 'StaticIpConnectionInfo$Dns' => '<p>The connection\'s DNS address.</p>', ], ], 'EthernetPayload' => [ 'base' => '<p>A device\'s network configuration.</p>', 'refs' => [ 'NetworkPayload$Ethernet0' => '<p>Settings for Ethernet port 0.</p>', 'NetworkPayload$Ethernet1' => '<p>Settings for Ethernet port 1.</p>', ], ], 'EthernetStatus' => [ 'base' => '<p>A device\'s Ethernet status.</p>', 'refs' => [ 'NetworkStatus$Ethernet0Status' => '<p>The status of Ethernet port 0.</p>', 'NetworkStatus$Ethernet1Status' => '<p>The status of Ethernet port 1.</p>', ], ], 'HwAddress' => [ 'base' => NULL, 'refs' => [ 'EthernetStatus$HwAddress' => '<p>The device\'s physical address.</p>', ], ], 'ImageVersion' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceJobResponse$ImageVersion' => '<p>For an OTA job, the target version of the device software.</p>', 'OTAJobConfig$ImageVersion' => '<p>The target version of the device software.</p>', ], ], 'InputPortList' => [ 'base' => NULL, 'refs' => [ 'NodeInterface$Inputs' => '<p>The node interface\'s inputs.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal error occurred.</p>', 'refs' => [], ], 'IotThingName' => [ 'base' => NULL, 'refs' => [ 'ProvisionDeviceResponse$IotThingName' => '<p>The device\'s IoT thing name.</p>', ], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'EthernetStatus$IpAddress' => '<p>The device\'s IP address.</p>', 'NtpStatus$IpAddress' => '<p>The IP address of the server.</p>', 'StaticIpConnectionInfo$IpAddress' => '<p>The connection\'s IP address.</p>', ], ], 'IpAddressOrServerName' => [ 'base' => NULL, 'refs' => [ 'NtpServerList$member' => NULL, ], ], 'Job' => [ 'base' => '<p>A job for a device.</p>', 'refs' => [ 'JobList$member' => NULL, ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'CreateNodeFromTemplateJobResponse$JobId' => '<p>The job\'s ID.</p>', 'CreatePackageImportJobResponse$JobId' => '<p>The job\'s ID.</p>', 'DescribeDeviceJobRequest$JobId' => '<p>The job\'s ID.</p>', 'DescribeDeviceJobResponse$JobId' => '<p>The job\'s ID.</p>', 'DescribeNodeFromTemplateJobRequest$JobId' => '<p>The job\'s ID.</p>', 'DescribeNodeFromTemplateJobResponse$JobId' => '<p>The job\'s ID.</p>', 'DescribePackageImportJobRequest$JobId' => '<p>The job\'s ID.</p>', 'DescribePackageImportJobResponse$JobId' => '<p>The job\'s ID.</p>', 'DeviceJob$JobId' => '<p>The job\'s ID.</p>', 'Job$JobId' => '<p>The job\'s ID.</p>', 'NodeFromTemplateJob$JobId' => '<p>The job\'s ID.</p>', 'PackageImportJob$JobId' => '<p>The job\'s ID.</p>', ], ], 'JobList' => [ 'base' => NULL, 'refs' => [ 'CreateJobForDevicesResponse$Jobs' => '<p>A list of jobs.</p>', ], ], 'JobResourceTags' => [ 'base' => '<p>Tags for a job.</p>', 'refs' => [ 'JobTagsList$member' => NULL, ], ], 'JobResourceType' => [ 'base' => NULL, 'refs' => [ 'JobResourceTags$ResourceType' => '<p>The job\'s type.</p>', ], ], 'JobTagsList' => [ 'base' => NULL, 'refs' => [ 'CreateNodeFromTemplateJobRequest$JobTags' => '<p>Tags for the job.</p>', 'CreatePackageImportJobRequest$JobTags' => '<p>Tags for the package import job.</p>', 'DescribeNodeFromTemplateJobResponse$JobTags' => '<p>The job\'s tags.</p>', 'DescribePackageImportJobResponse$JobTags' => '<p>The job\'s tags.</p>', ], ], 'JobType' => [ 'base' => NULL, 'refs' => [ 'CreateJobForDevicesRequest$JobType' => '<p>The type of job to run.</p>', ], ], 'LastUpdatedTime' => [ 'base' => NULL, 'refs' => [ 'DescribeNodeFromTemplateJobResponse$LastUpdatedTime' => '<p>When the job was updated.</p>', 'DescribePackageImportJobResponse$LastUpdatedTime' => '<p>When the job was updated.</p>', 'Device$LastUpdatedTime' => '<p>When the device was updated.</p>', 'NetworkStatus$LastUpdatedTime' => '<p>When the network status changed.</p>', 'PackageImportJob$LastUpdatedTime' => '<p>When the job was updated.</p>', ], ], 'LatestAlternateSoftware' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$LatestAlternateSoftware' => '<p>The most recent beta software release.</p>', ], ], 'LatestSoftware' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$LatestSoftware' => '<p>The latest software version available for the device.</p>', ], ], 'LeaseExpirationTime' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$LeaseExpirationTime' => '<p>The device\'s lease expiration time.</p>', 'Device$LeaseExpirationTime' => '<p>The device\'s lease expiration time.</p>', ], ], 'ListApplicationInstanceDependenciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationInstanceDependenciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationInstanceNodeInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationInstanceNodeInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDevicesJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDevicesJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDevicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNodeFromTemplateJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNodeFromTemplateJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNodesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNodesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPackageImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPackageImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPackagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPackagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ManifestOverridesPayload' => [ 'base' => '<p>Parameter overrides for an application instance. This is a JSON document that has a single key (<code>PayloadData</code>) where the value is an escaped string representation of the overrides document.</p>', 'refs' => [ 'CreateApplicationInstanceRequest$ManifestOverridesPayload' => '<p>Setting overrides for the application manifest.</p>', 'DescribeApplicationInstanceDetailsResponse$ManifestOverridesPayload' => '<p>Parameter overrides for the configuration manifest.</p>', ], ], 'ManifestOverridesPayloadData' => [ 'base' => NULL, 'refs' => [ 'ManifestOverridesPayload$PayloadData' => '<p>The overrides document.</p>', ], ], 'ManifestPayload' => [ 'base' => '<p>A application verion\'s manifest file. This is a JSON document that has a single key (<code>PayloadData</code>) where the value is an escaped string representation of the application manifest (<code>graph.json</code>). This file is located in the <code>graphs</code> folder in your application source.</p>', 'refs' => [ 'CreateApplicationInstanceRequest$ManifestPayload' => '<p>The application\'s manifest document.</p>', 'DescribeApplicationInstanceDetailsResponse$ManifestPayload' => '<p>The application instance\'s configuration manifest.</p>', ], ], 'ManifestPayloadData' => [ 'base' => NULL, 'refs' => [ 'ManifestPayload$PayloadData' => '<p>The application manifest.</p>', ], ], 'MarkLatestPatch' => [ 'base' => NULL, 'refs' => [ 'PackageVersionOutputConfig$MarkLatest' => '<p>Indicates that the version is recommended for all users.</p>', 'RegisterPackageVersionRequest$MarkLatest' => '<p>Whether to mark the new version as the latest version.</p>', ], ], 'Mask' => [ 'base' => NULL, 'refs' => [ 'StaticIpConnectionInfo$Mask' => '<p>The connection\'s DNS mask.</p>', ], ], 'MaxConnections' => [ 'base' => NULL, 'refs' => [ 'NodeInputPort$MaxConnections' => '<p>The input port\'s max connections.</p>', ], ], 'MaxSize25' => [ 'base' => NULL, 'refs' => [ 'ListApplicationInstanceDependenciesRequest$MaxResults' => '<p>The maximum number of application instance dependencies to return in one page of results.</p>', 'ListApplicationInstanceNodeInstancesRequest$MaxResults' => '<p>The maximum number of node instances to return in one page of results.</p>', 'ListApplicationInstancesRequest$MaxResults' => '<p>The maximum number of application instances to return in one page of results.</p>', 'ListDevicesJobsRequest$MaxResults' => '<p>The maximum number of device jobs to return in one page of results.</p>', 'ListDevicesRequest$MaxResults' => '<p>The maximum number of devices to return in one page of results.</p>', 'ListNodeFromTemplateJobsRequest$MaxResults' => '<p>The maximum number of node from template jobs to return in one page of results.</p>', 'ListNodesRequest$MaxResults' => '<p>The maximum number of nodes to return in one page of results.</p>', 'ListPackageImportJobsRequest$MaxResults' => '<p>The maximum number of package import jobs to return in one page of results.</p>', 'ListPackagesRequest$MaxResults' => '<p>The maximum number of packages to return in one page of results.</p>', ], ], 'NetworkConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'EthernetStatus$ConnectionStatus' => '<p>The device\'s connection status.</p>', 'NtpStatus$ConnectionStatus' => '<p>The connection\'s status.</p>', ], ], 'NetworkPayload' => [ 'base' => '<p>The network configuration for a device.</p>', 'refs' => [ 'DescribeDeviceResponse$NetworkingConfiguration' => '<p>The device\'s networking configuration.</p>', 'ProvisionDeviceRequest$NetworkingConfiguration' => '<p>A networking configuration for the device.</p>', ], ], 'NetworkStatus' => [ 'base' => '<p>The network status of a device.</p>', 'refs' => [ 'DescribeDeviceResponse$CurrentNetworkingStatus' => '<p>The device\'s networking status.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListApplicationInstanceDependenciesRequest$NextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListApplicationInstanceDependenciesResponse$NextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListApplicationInstanceNodeInstancesRequest$NextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListApplicationInstanceNodeInstancesResponse$NextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListApplicationInstancesRequest$NextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListApplicationInstancesResponse$NextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListDevicesJobsRequest$NextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListDevicesJobsResponse$NextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListDevicesRequest$NextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListDevicesResponse$NextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListNodeFromTemplateJobsRequest$NextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListNodeFromTemplateJobsResponse$NextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListPackageImportJobsRequest$NextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListPackageImportJobsResponse$NextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListPackagesResponse$NextToken' => '<p>A pagination token that\'s included if more results are available.</p>', ], ], 'Node' => [ 'base' => '<p>An application node that represents a camera stream, a model, code, or output.</p>', 'refs' => [ 'NodesList$member' => NULL, ], ], 'NodeAssetName' => [ 'base' => NULL, 'refs' => [ 'DescribeNodeResponse$AssetName' => '<p>The node\'s asset name.</p>', ], ], 'NodeCategory' => [ 'base' => NULL, 'refs' => [ 'DescribeNodeResponse$Category' => '<p>The node\'s category.</p>', 'ListNodesRequest$Category' => '<p>Search for nodes by category.</p>', 'Node$Category' => '<p>The node\'s category.</p>', ], ], 'NodeFromTemplateJob' => [ 'base' => '<p>A job to create a camera stream node.</p>', 'refs' => [ 'NodeFromTemplateJobList$member' => NULL, ], ], 'NodeFromTemplateJobList' => [ 'base' => NULL, 'refs' => [ 'ListNodeFromTemplateJobsResponse$NodeFromTemplateJobs' => '<p>A list of jobs.</p>', ], ], 'NodeFromTemplateJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeNodeFromTemplateJobResponse$Status' => '<p>The job\'s status.</p>', 'NodeFromTemplateJob$Status' => '<p>The job\'s status.</p>', ], ], 'NodeFromTemplateJobStatusMessage' => [ 'base' => NULL, 'refs' => [ 'DescribeNodeFromTemplateJobResponse$StatusMessage' => '<p>The job\'s status message.</p>', 'NodeFromTemplateJob$StatusMessage' => '<p>The job\'s status message.</p>', ], ], 'NodeId' => [ 'base' => NULL, 'refs' => [ 'DescribeNodeRequest$NodeId' => '<p>The node\'s ID.</p>', 'DescribeNodeResponse$NodeId' => '<p>The node\'s ID.</p>', 'Node$NodeId' => '<p>The node\'s ID.</p>', 'NodeInstance$NodeId' => '<p>The node\'s ID.</p>', ], ], 'NodeInputPort' => [ 'base' => '<p>A node input port.</p>', 'refs' => [ 'InputPortList$member' => NULL, ], ], 'NodeInstance' => [ 'base' => '<p>A node instance.</p>', 'refs' => [ 'NodeInstances$member' => NULL, ], ], 'NodeInstanceId' => [ 'base' => NULL, 'refs' => [ 'NodeInstance$NodeInstanceId' => '<p>The instance\'s ID.</p>', ], ], 'NodeInstanceStatus' => [ 'base' => NULL, 'refs' => [ 'NodeInstance$CurrentStatus' => '<p>The instance\'s current status.</p>', ], ], 'NodeInstances' => [ 'base' => NULL, 'refs' => [ 'ListApplicationInstanceNodeInstancesResponse$NodeInstances' => '<p>A list of node instances.</p>', ], ], 'NodeInterface' => [ 'base' => '<p>A node interface.</p>', 'refs' => [ 'DescribeNodeResponse$NodeInterface' => '<p>The node\'s interface.</p>', ], ], 'NodeName' => [ 'base' => NULL, 'refs' => [ 'CreateNodeFromTemplateJobRequest$NodeName' => '<p>A name for the node.</p>', 'DescribeNodeFromTemplateJobResponse$NodeName' => '<p>The node\'s name.</p>', 'DescribeNodeResponse$Name' => '<p>The node\'s name.</p>', 'Node$Name' => '<p>The node\'s name.</p>', 'NodeFromTemplateJob$NodeName' => '<p>The node\'s name.</p>', 'NodeInstance$NodeName' => '<p>The instance\'s name.</p>', ], ], 'NodeOutputPort' => [ 'base' => '<p>A node output port.</p>', 'refs' => [ 'OutputPortList$member' => NULL, ], ], 'NodePackageArn' => [ 'base' => NULL, 'refs' => [ 'CreatePackageResponse$Arn' => '<p>The package\'s ARN.</p>', 'DescribeNodeResponse$PackageArn' => '<p>The node\'s ARN.</p>', 'DescribePackageResponse$Arn' => '<p>The package\'s ARN.</p>', 'DescribePackageVersionResponse$PackageArn' => '<p>The ARN of the package.</p>', 'Node$PackageArn' => '<p>The node\'s ARN.</p>', 'PackageListItem$Arn' => '<p>The package\'s ARN.</p>', ], ], 'NodePackageId' => [ 'base' => NULL, 'refs' => [ 'CreatePackageResponse$PackageId' => '<p>The package\'s ID.</p>', 'DeletePackageRequest$PackageId' => '<p>The package\'s ID.</p>', 'DeregisterPackageVersionRequest$PackageId' => '<p>A package ID.</p>', 'DescribeNodeResponse$PackageId' => '<p>The node\'s package ID.</p>', 'DescribePackageRequest$PackageId' => '<p>The package\'s ID.</p>', 'DescribePackageResponse$PackageId' => '<p>The package\'s ID.</p>', 'DescribePackageVersionRequest$PackageId' => '<p>The version\'s ID.</p>', 'DescribePackageVersionResponse$PackageId' => '<p>The version\'s ID.</p>', 'Node$PackageId' => '<p>The node\'s package ID.</p>', 'PackageImportJobOutput$PackageId' => '<p>The package\'s ID.</p>', 'PackageListItem$PackageId' => '<p>The package\'s ID.</p>', 'RegisterPackageVersionRequest$PackageId' => '<p>A package ID.</p>', ], ], 'NodePackageName' => [ 'base' => NULL, 'refs' => [ 'CreateNodeFromTemplateJobRequest$OutputPackageName' => '<p>An output package name for the node.</p>', 'CreatePackageRequest$PackageName' => '<p>A name for the package.</p>', 'DescribeNodeFromTemplateJobResponse$OutputPackageName' => '<p>The job\'s output package name.</p>', 'DescribeNodeResponse$PackageName' => '<p>The node\'s package name.</p>', 'DescribePackageResponse$PackageName' => '<p>The package\'s name.</p>', 'DescribePackageVersionResponse$PackageName' => '<p>The version\'s name.</p>', 'ListNodesRequest$PackageName' => '<p>Search for nodes by name.</p>', 'Node$PackageName' => '<p>The node\'s package name.</p>', 'NodeInstance$PackageName' => '<p>The instance\'s package name.</p>', 'PackageListItem$PackageName' => '<p>The package\'s name.</p>', 'PackageObject$Name' => '<p>The object\'s name.</p>', 'PackageVersionOutputConfig$PackageName' => '<p>The output\'s package name.</p>', ], ], 'NodePackagePatchVersion' => [ 'base' => NULL, 'refs' => [ 'DeregisterPackageVersionRequest$PatchVersion' => '<p>A patch version.</p>', 'DeregisterPackageVersionRequest$UpdatedLatestPatchVersion' => '<p>If the version was marked latest, the new version to maker as latest.</p>', 'DescribeNodeResponse$PatchVersion' => '<p>The node\'s patch version.</p>', 'DescribePackageVersionRequest$PatchVersion' => '<p>The version\'s patch version.</p>', 'DescribePackageVersionResponse$PatchVersion' => '<p>The version\'s patch version.</p>', 'ListNodesRequest$PatchVersion' => '<p>Search for nodes by patch version.</p>', 'Node$PatchVersion' => '<p>The node\'s patch version.</p>', 'NodeInstance$PackagePatchVersion' => '<p>The instance\'s package patch version.</p>', 'PackageImportJobOutput$PatchVersion' => '<p>The package\'s patch version.</p>', 'PackageObject$PatchVersion' => '<p>The object\'s patch version.</p>', 'RegisterPackageVersionRequest$PatchVersion' => '<p>A patch version.</p>', ], ], 'NodePackageVersion' => [ 'base' => NULL, 'refs' => [ 'CreateNodeFromTemplateJobRequest$OutputPackageVersion' => '<p>An output package version for the node.</p>', 'DeregisterPackageVersionRequest$PackageVersion' => '<p>A package version.</p>', 'DescribeNodeFromTemplateJobResponse$OutputPackageVersion' => '<p>The job\'s output package version.</p>', 'DescribeNodeResponse$PackageVersion' => '<p>The node\'s package version.</p>', 'DescribePackageVersionRequest$PackageVersion' => '<p>The version\'s version.</p>', 'DescribePackageVersionResponse$PackageVersion' => '<p>The version\'s version.</p>', 'ListNodesRequest$PackageVersion' => '<p>Search for nodes by version.</p>', 'Node$PackageVersion' => '<p>The node\'s package version.</p>', 'NodeInstance$PackageVersion' => '<p>The instance\'s package version.</p>', 'PackageImportJobOutput$PackageVersion' => '<p>The package\'s version.</p>', 'PackageObject$PackageVersion' => '<p>The object\'s package version.</p>', 'PackageVersionOutputConfig$PackageVersion' => '<p>The output\'s package version.</p>', 'RegisterPackageVersionRequest$PackageVersion' => '<p>A package version.</p>', ], ], 'NodesList' => [ 'base' => NULL, 'refs' => [ 'ListNodesResponse$Nodes' => '<p>A list of nodes.</p>', ], ], 'NtpPayload' => [ 'base' => '<p>Network time protocol (NTP) server settings. Use this option to connect to local NTP servers instead of <code>pool.ntp.org</code>.</p>', 'refs' => [ 'NetworkPayload$Ntp' => '<p>Network time protocol (NTP) server settings.</p>', ], ], 'NtpServerList' => [ 'base' => NULL, 'refs' => [ 'NtpPayload$NtpServers' => '<p>NTP servers to use, in order of preference.</p>', ], ], 'NtpServerName' => [ 'base' => NULL, 'refs' => [ 'NtpStatus$NtpServerName' => '<p>The domain name of the server.</p>', ], ], 'NtpStatus' => [ 'base' => '<p>Details about an NTP server connection.</p>', 'refs' => [ 'NetworkStatus$NtpStatus' => '<p>Details about a network time protocol (NTP) server connection.</p>', ], ], 'OTAJobConfig' => [ 'base' => '<p>An over-the-air update (OTA) job configuration.</p>', 'refs' => [ 'DeviceJobConfig$OTAJobConfig' => '<p>A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.</p>', ], ], 'Object' => [ 'base' => NULL, 'refs' => [ 'StorageLocation$BinaryPrefixLocation' => '<p>The location\'s binary prefix.</p>', 'StorageLocation$GeneratedPrefixLocation' => '<p>The location\'s generated prefix.</p>', 'StorageLocation$ManifestPrefixLocation' => '<p>The location\'s manifest prefix.</p>', 'StorageLocation$RepoPrefixLocation' => '<p>The location\'s repo prefix.</p>', ], ], 'ObjectKey' => [ 'base' => NULL, 'refs' => [ 'OutPutS3Location$ObjectKey' => '<p>The object\'s key.</p>', 'S3Location$ObjectKey' => '<p>An object key.</p>', ], ], 'OutPutS3Location' => [ 'base' => '<p>The location of an output object in Amazon S3.</p>', 'refs' => [ 'PackageImportJobOutput$OutputS3Location' => '<p>The package\'s output location.</p>', ], ], 'OutputPortList' => [ 'base' => NULL, 'refs' => [ 'NodeInterface$Outputs' => '<p>The node interface\'s outputs.</p>', ], ], 'PackageImportJob' => [ 'base' => '<p>A job to import a package version.</p>', 'refs' => [ 'PackageImportJobList$member' => NULL, ], ], 'PackageImportJobInputConfig' => [ 'base' => '<p>A configuration for a package import job.</p>', 'refs' => [ 'CreatePackageImportJobRequest$InputConfig' => '<p>An input config for the package import job.</p>', 'DescribePackageImportJobResponse$InputConfig' => '<p>The job\'s input config.</p>', ], ], 'PackageImportJobList' => [ 'base' => NULL, 'refs' => [ 'ListPackageImportJobsResponse$PackageImportJobs' => '<p>A list of package import jobs.</p>', ], ], 'PackageImportJobOutput' => [ 'base' => '<p>Results of a package import job.</p>', 'refs' => [ 'DescribePackageImportJobResponse$Output' => '<p>The job\'s output.</p>', ], ], 'PackageImportJobOutputConfig' => [ 'base' => '<p>An output configuration for a package import job.</p>', 'refs' => [ 'CreatePackageImportJobRequest$OutputConfig' => '<p>An output config for the package import job.</p>', 'DescribePackageImportJobResponse$OutputConfig' => '<p>The job\'s output config.</p>', ], ], 'PackageImportJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribePackageImportJobResponse$Status' => '<p>The job\'s status.</p>', 'PackageImportJob$Status' => '<p>The job\'s status.</p>', ], ], 'PackageImportJobStatusMessage' => [ 'base' => NULL, 'refs' => [ 'DescribePackageImportJobResponse$StatusMessage' => '<p>The job\'s status message.</p>', 'PackageImportJob$StatusMessage' => '<p>The job\'s status message.</p>', ], ], 'PackageImportJobType' => [ 'base' => NULL, 'refs' => [ 'CreatePackageImportJobRequest$JobType' => '<p>A job type for the package import job.</p>', 'DescribePackageImportJobResponse$JobType' => '<p>The job\'s type.</p>', 'PackageImportJob$JobType' => '<p>The job\'s type.</p>', ], ], 'PackageList' => [ 'base' => NULL, 'refs' => [ 'ListPackagesResponse$Packages' => '<p>A list of packages.</p>', ], ], 'PackageListItem' => [ 'base' => '<p>A package summary.</p>', 'refs' => [ 'PackageList$member' => NULL, ], ], 'PackageObject' => [ 'base' => '<p>A package object.</p>', 'refs' => [ 'PackageObjects$member' => NULL, ], ], 'PackageObjects' => [ 'base' => NULL, 'refs' => [ 'ListApplicationInstanceDependenciesResponse$PackageObjects' => '<p>A list of package objects.</p>', ], ], 'PackageOwnerAccount' => [ 'base' => NULL, 'refs' => [ 'DeregisterPackageVersionRequest$OwnerAccount' => '<p>An owner account.</p>', 'DescribeNodeRequest$OwnerAccount' => '<p>The account ID of the node\'s owner.</p>', 'DescribeNodeResponse$OwnerAccount' => '<p>The account ID of the node\'s owner.</p>', 'DescribePackageVersionRequest$OwnerAccount' => '<p>The version\'s owner account.</p>', 'DescribePackageVersionResponse$OwnerAccount' => '<p>The account ID of the version\'s owner.</p>', 'ListNodesRequest$OwnerAccount' => '<p>Search for nodes by the account ID of the nodes\' owner.</p>', 'Node$OwnerAccount' => '<p>The account ID of the node\'s owner.</p>', 'RegisterPackageVersionRequest$OwnerAccount' => '<p>An owner account.</p>', ], ], 'PackageVersionInputConfig' => [ 'base' => '<p>A package version input configuration.</p>', 'refs' => [ 'PackageImportJobInputConfig$PackageVersionInputConfig' => '<p>The package version\'s input configuration.</p>', ], ], 'PackageVersionOutputConfig' => [ 'base' => '<p>A package version output configuration.</p>', 'refs' => [ 'PackageImportJobOutputConfig$PackageVersionOutputConfig' => '<p>The package version\'s output configuration.</p>', ], ], 'PackageVersionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribePackageVersionResponse$Status' => '<p>The version\'s status.</p>', ], ], 'PackageVersionStatusDescription' => [ 'base' => NULL, 'refs' => [ 'DescribePackageVersionResponse$StatusDescription' => '<p>The version\'s status description.</p>', ], ], 'PortDefaultValue' => [ 'base' => NULL, 'refs' => [ 'NodeInputPort$DefaultValue' => '<p>The input port\'s default value.</p>', ], ], 'PortName' => [ 'base' => NULL, 'refs' => [ 'NodeInputPort$Name' => '<p>The input port\'s name.</p>', 'NodeOutputPort$Name' => '<p>The output port\'s name.</p>', ], ], 'PortType' => [ 'base' => NULL, 'refs' => [ 'NodeInputPort$Type' => '<p>The input port\'s type.</p>', 'NodeOutputPort$Type' => '<p>The output port\'s type.</p>', ], ], 'PrincipalArn' => [ 'base' => NULL, 'refs' => [ 'PrincipalArnsList$member' => NULL, ], ], 'PrincipalArnsList' => [ 'base' => NULL, 'refs' => [ 'DescribePackageResponse$ReadAccessPrincipalArns' => '<p>ARNs of accounts that have read access to the package.</p>', 'DescribePackageResponse$WriteAccessPrincipalArns' => '<p>ARNs of accounts that have write access to the package.</p>', ], ], 'ProvisionDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'S3Location$Region' => '<p>The bucket\'s Region.</p>', ], ], 'RegisterPackageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterPackageVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveApplicationInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveApplicationInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The resource\'s ARN.</p>', 'TagResourceRequest$ResourceArn' => '<p>The resource\'s ARN.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The resource\'s ARN.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The target resource was not found.</p>', 'refs' => [], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$RetryAfterSeconds' => '<p>The number of seconds a client should wait before retrying the call.</p>', ], ], 'RuntimeRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationInstanceRequest$RuntimeRoleArn' => '<p>The ARN of a runtime role for the application instance.</p>', 'DescribeApplicationInstanceResponse$RuntimeRoleArn' => '<p>The application instance\'s runtime role ARN.</p>', ], ], 'S3Location' => [ 'base' => '<p>A location in Amazon S3.</p>', 'refs' => [ 'PackageVersionInputConfig$S3Location' => '<p>A location in Amazon S3.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a limit to be exceeded.</p>', 'refs' => [], ], 'StaticIpConnectionInfo' => [ 'base' => '<p>A static IP configuration.</p>', 'refs' => [ 'EthernetPayload$StaticIpConnectionInfo' => '<p>Network configuration for a static IP connection.</p>', ], ], 'StatusFilter' => [ 'base' => NULL, 'refs' => [ 'ListApplicationInstancesRequest$StatusFilter' => '<p>Only include instances with a specific status.</p>', ], ], 'StorageLocation' => [ 'base' => '<p>A storage location.</p>', 'refs' => [ 'CreatePackageResponse$StorageLocation' => '<p>The package\'s storage location.</p>', 'DescribePackageResponse$StorageLocation' => '<p>The package\'s storage location.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$ErrorId' => '<p>A unique ID for the error.</p>', 'ConflictException$Message' => NULL, 'ConflictException$ResourceId' => '<p>The resource\'s ID.</p>', 'ConflictException$ResourceType' => '<p>The resource\'s type.</p>', 'ConflictExceptionErrorArgument$Name' => '<p>The error argument\'s name.</p>', 'ConflictExceptionErrorArgument$Value' => '<p>The error argument\'s value.</p>', 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>The resource\'s ID.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The resource\'s type.</p>', 'ServiceQuotaExceededException$Message' => NULL, 'ServiceQuotaExceededException$QuotaCode' => '<p>The name of the limit.</p>', 'ServiceQuotaExceededException$ResourceId' => '<p>The target resource\'s ID.</p>', 'ServiceQuotaExceededException$ResourceType' => '<p>The target resource\'s type.</p>', 'ServiceQuotaExceededException$ServiceCode' => '<p>The name of the service.</p>', 'ValidationException$ErrorId' => '<p>A unique ID for the error.</p>', 'ValidationException$Message' => NULL, 'ValidationExceptionErrorArgument$Name' => '<p>The argument\'s name.</p>', 'ValidationExceptionErrorArgument$Value' => '<p>The argument\'s value.</p>', 'ValidationExceptionField$Message' => '<p>The field\'s message.</p>', 'ValidationExceptionField$Name' => '<p>The field\'s name.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Tag keys to remove.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$Tags' => '<p>The application instance\'s tags.</p>', 'CreateApplicationInstanceRequest$Tags' => '<p>Tags for the application instance.</p>', 'CreatePackageRequest$Tags' => '<p>Tags for the package.</p>', 'DescribeApplicationInstanceResponse$Tags' => '<p>The application instance\'s tags.</p>', 'DescribeDeviceResponse$Tags' => '<p>The device\'s tags.</p>', 'DescribePackageResponse$Tags' => '<p>The package\'s tags.</p>', 'JobResourceTags$Tags' => '<p>The job\'s tags.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A list of tags.</p>', 'PackageListItem$Tags' => '<p>The package\'s tags.</p>', 'ProvisionDeviceRequest$Tags' => '<p>Tags for the device.</p>', 'TagResourceRequest$Tags' => '<p>Tags for the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TemplateKey' => [ 'base' => NULL, 'refs' => [ 'TemplateParametersMap$key' => NULL, ], ], 'TemplateParametersMap' => [ 'base' => NULL, 'refs' => [ 'CreateNodeFromTemplateJobRequest$TemplateParameters' => '<p>Template parameters for the node.</p>', 'DescribeNodeFromTemplateJobResponse$TemplateParameters' => '<p>The job\'s template parameters.</p>', ], ], 'TemplateType' => [ 'base' => NULL, 'refs' => [ 'CreateNodeFromTemplateJobRequest$TemplateType' => '<p>The type of node.</p>', 'DescribeNodeFromTemplateJobResponse$TemplateType' => '<p>The job\'s template type.</p>', 'NodeFromTemplateJob$TemplateType' => '<p>The job\'s template type.</p>', ], ], 'TemplateValue' => [ 'base' => NULL, 'refs' => [ 'TemplateParametersMap$value' => NULL, ], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'ApplicationInstance$CreatedTime' => '<p>When the application instance was created.</p>', 'DescribeApplicationInstanceDetailsResponse$CreatedTime' => '<p>When the application instance was created.</p>', 'DescribeApplicationInstanceResponse$CreatedTime' => '<p>When the application instance was created.</p>', 'DescribeApplicationInstanceResponse$LastUpdatedTime' => '<p>The application instance was updated.</p>', 'DescribeNodeResponse$CreatedTime' => '<p>When the node was created.</p>', 'DescribeNodeResponse$LastUpdatedTime' => '<p>When the node was updated.</p>', 'DescribePackageResponse$CreatedTime' => '<p>When the package was created.</p>', 'DescribePackageVersionResponse$RegisteredTime' => '<p>The version\'s registered time.</p>', 'Node$CreatedTime' => '<p>When the node was created.</p>', 'PackageListItem$CreatedTime' => '<p>When the package was created.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ListNodesRequest$NextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListNodesResponse$NextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListPackagesRequest$NextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCreatedTime' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceJobResponse$CreatedTime' => '<p>When the job was created.</p>', ], ], 'UpdateDeviceMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeviceMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProgress' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceJobResponse$Status' => '<p>The job\'s status.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request contains an invalid parameter value.</p>', 'refs' => [], ], 'ValidationExceptionErrorArgument' => [ 'base' => '<p>A validation exception error argument.</p>', 'refs' => [ 'ValidationExceptionErrorArgumentList$member' => NULL, ], ], 'ValidationExceptionErrorArgumentList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$ErrorArguments' => '<p>A list of attributes that led to the exception and their values.</p>', ], ], 'ValidationExceptionField' => [ 'base' => '<p>A validation exception field.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Fields' => '<p>A list of request parameters that failed validation.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p>The reason that validation failed.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'AlternateSoftwareMetadata$Version' => '<p>The appliance software version.</p>', ], ], ],];
