<?php
// This file was auto-generated from sdk-root/src/data/location/2020-11-19/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Suite of geospatial services including Maps, Places, Routes, Tracking, and Geofencing</p>', 'operations' => [ 'AssociateTrackerConsumer' => '<p>Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection. </p> <p>You can associate up to five geofence collections to each tracker resource.</p> <note> <p>Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.</p> </note>', 'BatchDeleteDevicePositionHistory' => '<p>Deletes the position history of one or more devices from a tracker resource.</p>', 'BatchDeleteGeofence' => '<p>Deletes a batch of geofences from a geofence collection.</p> <note> <p>This operation deletes the resource permanently.</p> </note>', 'BatchEvaluateGeofences' => '<p>Evaluates device positions against the geofence geometries from a given geofence collection.</p> <p>This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation determines if the device has entered or exited a geofenced area, and then publishes one of the following events to Amazon EventBridge:</p> <ul> <li> <p> <code>ENTER</code> if Amazon Location determines that the tracked device has entered a geofenced area.</p> </li> <li> <p> <code>EXIT</code> if Amazon Location determines that the tracked device has exited a geofenced area.</p> </li> </ul> <note> <p>The last geofence that a device was observed within is tracked for 30 days after the most recent device position update.</p> </note> <note> <p>Geofence evaluation uses the given device position. It does not account for the optional <code>Accuracy</code> of a <code>DevicePositionUpdate</code>.</p> </note>', 'BatchGetDevicePosition' => '<p>Lists the latest device positions for requested devices.</p>', 'BatchPutGeofence' => '<p>A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.</p>', 'BatchUpdateDevicePosition' => '<p>Uploads position update data for one or more devices to a tracker resource. Amazon Location uses the data when it reports the last known device position and position history. Amazon Location retains location data for 30 days.</p> <note> <p>Position updates are handled based on the <code>PositionFiltering</code> property of the tracker. When <code>PositionFiltering</code> is set to <code>TimeBased</code>, updates are evaluated against linked geofence collections, and location data is stored at a maximum of one position per 30 second interval. If your update frequency is more often than every 30 seconds, only one update per 30 seconds is stored for each unique device ID.</p> <p>When <code>PositionFiltering</code> is set to <code>DistanceBased</code> filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than 30 m (98.4 ft).</p> <p>When <code>PositionFiltering</code> is set to <code>AccuracyBased</code> filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than the measured accuracy. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is neither stored or evaluated if the device has moved less than 15 m. If <code>PositionFiltering</code> is set to <code>AccuracyBased</code> filtering, Amazon Location uses the default value <code>{ "Horizontal": 0}</code> when accuracy is not provided on a <code>DevicePositionUpdate</code>.</p> </note>', 'CalculateRoute' => '<p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html">Calculates a route</a> given the following required parameters: <code>DeparturePosition</code> and <code>DestinationPosition</code>. Requires that you first <a href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a route calculator resource</a>.</p> <p>By default, a request that doesn\'t specify a departure time uses the best time of day to travel with the best traffic conditions when calculating the route.</p> <p>Additional options include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html">Specifying a departure time</a> using either <code>DepartureTime</code> or <code>DepartNow</code>. This calculates a route based on predictive traffic data at the given time. </p> <note> <p>You can\'t specify both <code>DepartureTime</code> and <code>DepartNow</code> in a single request. Specifying both parameters returns a validation error.</p> </note> </li> <li> <p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html">Specifying a travel mode</a> using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in <code>CarModeOptions</code> if traveling by <code>Car</code>, or <code>TruckModeOptions</code> if traveling by <code>Truck</code>.</p> </li> </ul>', 'CalculateRouteMatrix' => '<p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html"> Calculates a route matrix</a> given the following required parameters: <code>DeparturePositions</code> and <code>DestinationPositions</code>. <code>CalculateRouteMatrix</code> calculates routes and returns the travel time and travel distance from each departure position to each destination position in the request. For example, given departure positions A and B, and destination positions X and Y, <code>CalculateRouteMatrix</code> will return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of results returned (and routes calculated) will be the number of <code>DeparturePositions</code> times the number of <code>DestinationPositions</code>.</p> <note> <p>Your account is charged for each route calculated, not the number of requests.</p> </note> <p>Requires that you first <a href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a route calculator resource</a>.</p> <p>By default, a request that doesn\'t specify a departure time uses the best time of day to travel with the best traffic conditions when calculating routes.</p> <p>Additional options include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html"> Specifying a departure time</a> using either <code>DepartureTime</code> or <code>DepartNow</code>. This calculates routes based on predictive traffic data at the given time. </p> <note> <p>You can\'t specify both <code>DepartureTime</code> and <code>DepartNow</code> in a single request. Specifying both parameters returns a validation error.</p> </note> </li> <li> <p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html">Specifying a travel mode</a> using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in <code>CarModeOptions</code> if traveling by <code>Car</code>, or <code>TruckModeOptions</code> if traveling by <code>Truck</code>.</p> </li> </ul>', 'CreateGeofenceCollection' => '<p>Creates a geofence collection, which manages and stores geofences.</p>', 'CreateMap' => '<p>Creates a map resource in your AWS account, which provides map tiles of different styles sourced from global location data providers.</p> <note> <p>If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the <a href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.</p> </note>', 'CreatePlaceIndex' => '<p>Creates a place index resource in your AWS account. Use a place index resource to geocode addresses and other text queries by using the <code>SearchPlaceIndexForText</code> operation, and reverse geocode coordinates by using the <code>SearchPlaceIndexForPosition</code> operation, and enable autosuggestions by using the <code>SearchPlaceIndexForSuggestions</code> operation.</p> <note> <p>If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the <a href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.</p> </note>', 'CreateRouteCalculator' => '<p>Creates a route calculator resource in your AWS account.</p> <p>You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.</p> <note> <p>If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the <a href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.</p> </note>', 'CreateTracker' => '<p>Creates a tracker resource in your AWS account, which lets you retrieve current and historical location of devices.</p>', 'DeleteGeofenceCollection' => '<p>Deletes a geofence collection from your AWS account.</p> <note> <p>This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource, the devices will no longer be monitored.</p> </note>', 'DeleteMap' => '<p>Deletes a map resource from your AWS account.</p> <note> <p>This operation deletes the resource permanently. If the map is being used in an application, the map may not render.</p> </note>', 'DeletePlaceIndex' => '<p>Deletes a place index resource from your AWS account.</p> <note> <p>This operation deletes the resource permanently.</p> </note>', 'DeleteRouteCalculator' => '<p>Deletes a route calculator resource from your AWS account.</p> <note> <p>This operation deletes the resource permanently.</p> </note>', 'DeleteTracker' => '<p>Deletes a tracker resource from your AWS account.</p> <note> <p>This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error. Make sure that the target resource isn\'t a dependency for your applications.</p> </note>', 'DescribeGeofenceCollection' => '<p>Retrieves the geofence collection details.</p>', 'DescribeMap' => '<p>Retrieves the map resource details.</p>', 'DescribePlaceIndex' => '<p>Retrieves the place index resource details.</p>', 'DescribeRouteCalculator' => '<p>Retrieves the route calculator resource details.</p>', 'DescribeTracker' => '<p>Retrieves the tracker resource details.</p>', 'DisassociateTrackerConsumer' => '<p>Removes the association between a tracker resource and a geofence collection.</p> <note> <p>Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be automatically evaluated against geofences.</p> </note>', 'GetDevicePosition' => '<p>Retrieves a device\'s most recent position according to its sample time.</p> <note> <p>Device positions are deleted after 30 days.</p> </note>', 'GetDevicePositionHistory' => '<p>Retrieves the device position history from a tracker resource within a specified range of time.</p> <note> <p>Device positions are deleted after 30 days.</p> </note>', 'GetGeofence' => '<p>Retrieves the geofence details from a geofence collection.</p>', 'GetMapGlyphs' => '<p>Retrieves glyphs used to display labels on a map.</p>', 'GetMapSprites' => '<p>Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON document describing the offsets of individual icons that will be displayed on a rendered map.</p>', 'GetMapStyleDescriptor' => '<p>Retrieves the map style descriptor from a map resource. </p> <p>The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display, what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style Specification.</p>', 'GetMapTile' => '<p>Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they\'re addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level. </p> <p>The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions, so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1, 1/1/0, 1/1/1).</p>', 'ListDevicePositions' => '<p>A batch request to retrieve all device positions.</p>', 'ListGeofenceCollections' => '<p>Lists geofence collections in your AWS account.</p>', 'ListGeofences' => '<p>Lists geofences stored in a given geofence collection.</p>', 'ListMaps' => '<p>Lists map resources in your AWS account.</p>', 'ListPlaceIndexes' => '<p>Lists place index resources in your AWS account.</p>', 'ListRouteCalculators' => '<p>Lists route calculator resources in your AWS account.</p>', 'ListTagsForResource' => '<p>Returns a list of tags that are applied to the specified Amazon Location resource.</p>', 'ListTrackerConsumers' => '<p>Lists geofence collections currently associated to the given tracker resource.</p>', 'ListTrackers' => '<p>Lists tracker resources in your AWS account.</p>', 'PutGeofence' => '<p>Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request. </p>', 'SearchPlaceIndexForPosition' => '<p>Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of interest near a given position.</p>', 'SearchPlaceIndexForSuggestions' => '<p>Generates suggestions for addresses and points of interest based on partial or misspelled free-form text. This operation is also known as autocomplete, autosuggest, or fuzzy matching.</p> <p>Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.</p> <note> <p>You can search for suggested place names near a specified position by using <code>BiasPosition</code>, or filter results within a bounding box by using <code>FilterBBox</code>. These parameters are mutually exclusive; using both <code>BiasPosition</code> and <code>FilterBBox</code> in the same command returns an error.</p> </note>', 'SearchPlaceIndexForText' => '<p>Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of interest. </p> <p>Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.</p> <note> <p>You can search for places near a given position using <code>BiasPosition</code>, or filter results within a bounding box using <code>FilterBBox</code>. Providing both parameters simultaneously returns an error.</p> </note> <p>Search results are returned in order of highest to lowest relevance.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.</p> <pre><code> &lt;p&gt;Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.&lt;/p&gt; &lt;p&gt;You can use the &lt;code&gt;TagResource&lt;/code&gt; operation with an Amazon Location Service resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the resource. If you specify a tag key that\'s already associated with the resource, the new tag value that you specify replaces the previous value for that tag. &lt;/p&gt; &lt;p&gt;You can associate up to 50 tags with a resource.&lt;/p&gt; </code></pre>', 'UntagResource' => '<p>Removes one or more tags from the specified Amazon Location resource.</p>', 'UpdateGeofenceCollection' => '<p>Updates the specified properties of a given geofence collection.</p>', 'UpdateMap' => '<p>Updates the specified properties of a given map resource.</p>', 'UpdatePlaceIndex' => '<p>Updates the specified properties of a given place index resource.</p>', 'UpdateRouteCalculator' => '<p>Updates the specified properties for a given route calculator resource.</p>', 'UpdateTracker' => '<p>Updates the specified properties of a given tracker resource.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The request was denied because of insufficient access or permissions. Check with an administrator to verify your permissions.</p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ArnList$member' => NULL, 'AssociateTrackerConsumerRequest$ConsumerArn' => '<p>The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li> </ul>', 'CreateGeofenceCollectionResponse$CollectionArn' => '<p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li> </ul>', 'CreateMapResponse$MapArn' => '<p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li> </ul>', 'CreatePlaceIndexResponse$IndexArn' => '<p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li> </ul>', 'CreateRouteCalculatorResponse$CalculatorArn' => '<p>The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li> </ul>', 'CreateTrackerResponse$TrackerArn' => '<p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li> </ul>', 'DescribeGeofenceCollectionResponse$CollectionArn' => '<p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li> </ul>', 'DescribeMapResponse$MapArn' => '<p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li> </ul>', 'DescribePlaceIndexResponse$IndexArn' => '<p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li> </ul>', 'DescribeRouteCalculatorResponse$CalculatorArn' => '<p>The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li> </ul>', 'DescribeTrackerResponse$TrackerArn' => '<p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li> </ul>', 'DisassociateTrackerConsumerRequest$ConsumerArn' => '<p>The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource. Used when you need to specify a resource across all AWS. </p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li> </ul>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li> </ul>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource whose tags you want to update.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li> </ul>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li> </ul>', 'UpdateGeofenceCollectionResponse$CollectionArn' => '<p>The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li> </ul>', 'UpdateMapResponse$MapArn' => '<p>The Amazon Resource Name (ARN) of the updated map resource. Used to specify a resource across AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li> </ul>', 'UpdatePlaceIndexResponse$IndexArn' => '<p>The Amazon Resource Name (ARN) of the upated place index resource. Used to specify a resource across AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:place- index/ExamplePlaceIndex</code> </p> </li> </ul>', 'UpdateRouteCalculatorResponse$CalculatorArn' => '<p>The Amazon Resource Name (ARN) of the updated route calculator resource. Used to specify a resource across AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:route- calculator/ExampleCalculator</code> </p> </li> </ul>', 'UpdateTrackerResponse$TrackerArn' => '<p>The Amazon Resource Name (ARN) of the updated tracker resource. Used to specify a resource across AWS.</p> <ul> <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li> </ul>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'ListTrackerConsumersResponse$ConsumerArns' => '<p>Contains the list of geofence collection ARNs associated to the tracker resource.</p>', ], ], 'AssociateTrackerConsumerRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTrackerConsumerResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteDevicePositionHistoryError' => [ 'base' => '<p>Contains the tracker resource details.</p>', 'refs' => [ 'BatchDeleteDevicePositionHistoryErrorList$member' => NULL, ], ], 'BatchDeleteDevicePositionHistoryErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDevicePositionHistoryResponse$Errors' => '<p>Contains error details for each device history that failed to delete.</p>', ], ], 'BatchDeleteDevicePositionHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteDevicePositionHistoryRequestDeviceIdsList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDevicePositionHistoryRequest$DeviceIds' => '<p>Devices whose position history you want to delete.</p> <ul> <li> <p>For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code> </p> </li> </ul>', ], ], 'BatchDeleteDevicePositionHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteGeofenceError' => [ 'base' => '<p>Contains error details for each geofence that failed to delete from the geofence collection.</p>', 'refs' => [ 'BatchDeleteGeofenceErrorList$member' => NULL, ], ], 'BatchDeleteGeofenceErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteGeofenceResponse$Errors' => '<p>Contains error details for each geofence that failed to delete.</p>', ], ], 'BatchDeleteGeofenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteGeofenceRequestGeofenceIdsList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteGeofenceRequest$GeofenceIds' => '<p>The batch of geofences to be deleted.</p>', ], ], 'BatchDeleteGeofenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchEvaluateGeofencesError' => [ 'base' => '<p>Contains error details for each device that failed to evaluate its position against the geofences in a given geofence collection.</p>', 'refs' => [ 'BatchEvaluateGeofencesErrorList$member' => NULL, ], ], 'BatchEvaluateGeofencesErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchEvaluateGeofencesResponse$Errors' => '<p>Contains error details for each device that failed to evaluate its position against the given geofence collection.</p>', ], ], 'BatchEvaluateGeofencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchEvaluateGeofencesRequestDevicePositionUpdatesList' => [ 'base' => NULL, 'refs' => [ 'BatchEvaluateGeofencesRequest$DevicePositionUpdates' => '<p>Contains device details for each device to be evaluated against the given geofence collection.</p>', ], ], 'BatchEvaluateGeofencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDevicePositionError' => [ 'base' => '<p>Contains error details for each device that didn\'t return a position.</p>', 'refs' => [ 'BatchGetDevicePositionErrorList$member' => NULL, ], ], 'BatchGetDevicePositionErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDevicePositionResponse$Errors' => '<p>Contains error details for each device that failed to send its position to the tracker resource.</p>', ], ], 'BatchGetDevicePositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDevicePositionRequestDeviceIdsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDevicePositionRequest$DeviceIds' => '<p>Devices whose position you want to retrieve.</p> <ul> <li> <p>For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code> </p> </li> </ul>', ], ], 'BatchGetDevicePositionRequestTrackerNameString' => [ 'base' => NULL, 'refs' => [ 'BatchGetDevicePositionRequest$TrackerName' => '<p>The tracker resource retrieving the device position.</p>', ], ], 'BatchGetDevicePositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchItemError' => [ 'base' => '<p>Contains the batch request error details associated with the request.</p>', 'refs' => [ 'BatchDeleteDevicePositionHistoryError$Error' => NULL, 'BatchDeleteGeofenceError$Error' => '<p>Contains details associated to the batch error.</p>', 'BatchEvaluateGeofencesError$Error' => '<p>Contains details associated to the batch error.</p>', 'BatchGetDevicePositionError$Error' => '<p>Contains details related to the error code.</p>', 'BatchPutGeofenceError$Error' => '<p>Contains details associated to the batch error.</p>', 'BatchUpdateDevicePositionError$Error' => '<p>Contains details related to the error code such as the error code and error message.</p>', ], ], 'BatchItemErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchItemError$Code' => '<p>The error code associated with the batch request error.</p>', ], ], 'BatchPutGeofenceError' => [ 'base' => '<p>Contains error details for each geofence that failed to be stored in a given geofence collection.</p>', 'refs' => [ 'BatchPutGeofenceErrorList$member' => NULL, ], ], 'BatchPutGeofenceErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchPutGeofenceResponse$Errors' => '<p>Contains additional error details for each geofence that failed to be stored in a geofence collection.</p>', ], ], 'BatchPutGeofenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutGeofenceRequestEntriesList' => [ 'base' => NULL, 'refs' => [ 'BatchPutGeofenceRequest$Entries' => '<p>The batch of geofences to be stored in a geofence collection.</p>', ], ], 'BatchPutGeofenceRequestEntry' => [ 'base' => '<p>Contains geofence geometry details. </p>', 'refs' => [ 'BatchPutGeofenceRequestEntriesList$member' => NULL, ], ], 'BatchPutGeofenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutGeofenceSuccess' => [ 'base' => '<p>Contains a summary of each geofence that was successfully stored in a given geofence collection.</p>', 'refs' => [ 'BatchPutGeofenceSuccessList$member' => NULL, ], ], 'BatchPutGeofenceSuccessList' => [ 'base' => NULL, 'refs' => [ 'BatchPutGeofenceResponse$Successes' => '<p>Contains each geofence that was successfully stored in a geofence collection.</p>', ], ], 'BatchUpdateDevicePositionError' => [ 'base' => '<p>Contains error details for each device that failed to update its position.</p>', 'refs' => [ 'BatchUpdateDevicePositionErrorList$member' => NULL, ], ], 'BatchUpdateDevicePositionErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateDevicePositionResponse$Errors' => '<p>Contains error details for each device that failed to update its position.</p>', ], ], 'BatchUpdateDevicePositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateDevicePositionRequestUpdatesList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateDevicePositionRequest$Updates' => '<p>Contains the position update details for each device.</p>', ], ], 'BatchUpdateDevicePositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'GetMapGlyphsResponse$Blob' => '<p>The blob\'s content type.</p>', 'GetMapSpritesResponse$Blob' => '<p>Contains the body of the sprite sheet or JSON offset ﬁle.</p>', 'GetMapStyleDescriptorResponse$Blob' => '<p>Contains the body of the style descriptor.</p>', 'GetMapTileResponse$Blob' => '<p>Contains Mapbox Vector Tile (MVT) data.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteCarModeOptions$AvoidFerries' => '<p>Avoids ferries when calculating routes.</p> <p>Default Value: <code>false</code> </p> <p>Valid Values: <code>false</code> | <code>true</code> </p>', 'CalculateRouteCarModeOptions$AvoidTolls' => '<p>Avoids tolls when calculating routes.</p> <p>Default Value: <code>false</code> </p> <p>Valid Values: <code>false</code> | <code>true</code> </p>', 'CalculateRouteMatrixRequest$DepartNow' => '<p>Sets the time of departure as the current time. Uses the current time to calculate the route matrix. You can\'t set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p> <p>Default Value: <code>false</code> </p> <p>Valid Values: <code>false</code> | <code>true</code> </p>', 'CalculateRouteRequest$DepartNow' => '<p>Sets the time of departure as the current time. Uses the current time to calculate a route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p> <p>Default Value: <code>false</code> </p> <p>Valid Values: <code>false</code> | <code>true</code> </p>', 'CalculateRouteRequest$IncludeLegGeometry' => '<p>Set to include the geometry details in the result for each path between a pair of positions.</p> <p>Default Value: <code>false</code> </p> <p>Valid Values: <code>false</code> | <code>true</code> </p>', 'CalculateRouteTruckModeOptions$AvoidFerries' => '<p>Avoids ferries when calculating routes.</p> <p>Default Value: <code>false</code> </p> <p>Valid Values: <code>false</code> | <code>true</code> </p>', 'CalculateRouteTruckModeOptions$AvoidTolls' => '<p>Avoids tolls when calculating routes.</p> <p>Default Value: <code>false</code> </p> <p>Valid Values: <code>false</code> | <code>true</code> </p>', 'Place$Interpolated' => '<p> <code>True</code> if the result is interpolated from other known places.</p> <p> <code>False</code> if the Place is a known place.</p> <p>Not returned when the partner does not provide the information.</p> <p>For example, returns <code>False</code> for an address location that is found in the partner data, but returns <code>True</code> if an address does not exist in the partner data and its location is calculated by interpolating between other known addresses. </p>', ], ], 'BoundingBox' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteSummary$RouteBBox' => '<p>Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map. For example, <code>[min x, min y, max x, max y]</code>.</p> <p>The first 2 <code>bbox</code> parameters describe the lower southwest corner: </p> <ul> <li> <p>The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner. </p> </li> <li> <p>The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner. </p> </li> </ul> <p>The next 2 <code>bbox</code> parameters describe the upper northeast corner: </p> <ul> <li> <p>The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner. </p> </li> <li> <p>The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner. </p> </li> </ul>', 'SearchPlaceIndexForSuggestionsRequest$FilterBBox' => '<p>An optional parameter that limits the search results by returning only suggestions within a specified bounding box.</p> <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p> <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note> <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p> </note>', 'SearchPlaceIndexForSuggestionsSummary$FilterBBox' => '<p>Contains the coordinates for the optional bounding box specified in the request.</p>', 'SearchPlaceIndexForTextRequest$FilterBBox' => '<p>An optional parameter that limits the search results by returning only places that are within the provided bounding box.</p> <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p> <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note> <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p> </note>', 'SearchPlaceIndexForTextSummary$FilterBBox' => '<p>Contains the coordinates for the optional bounding box specified in the request.</p>', 'SearchPlaceIndexForTextSummary$ResultBBox' => '<p>The bounding box that fully contains all search results.</p> <note> <p>If you specified the optional <code>FilterBBox</code> parameter in the request, <code>ResultBBox</code> is contained within <code>FilterBBox</code>.</p> </note>', ], ], 'CalculateRouteCarModeOptions' => [ 'base' => '<p>Contains details about additional route preferences for requests that specify <code>TravelMode</code> as <code>Car</code>.</p>', 'refs' => [ 'CalculateRouteMatrixRequest$CarModeOptions' => '<p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p> <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>', 'CalculateRouteRequest$CarModeOptions' => '<p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p> <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>', ], ], 'CalculateRouteMatrixRequest' => [ 'base' => NULL, 'refs' => [], ], 'CalculateRouteMatrixRequestDeparturePositionsList' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteMatrixRequest$DeparturePositions' => '<p>The list of departure (origin) positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-123.115, 49.285]</code>.</p> <important> <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p> </important> <note> <p>For route calculators that use Esri as the data provider, if you specify a departure that\'s not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDeparturePositions</code>.</p> </note> <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>', ], ], 'CalculateRouteMatrixRequestDestinationPositionsList' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteMatrixRequest$DestinationPositions' => '<p>The list of destination positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-122.339, 47.615]</code> </p> <important> <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p> </important> <note> <p>For route calculators that use Esri as the data provider, if you specify a destination that\'s not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDestinationPositions</code>.</p> </note> <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>', ], ], 'CalculateRouteMatrixResponse' => [ 'base' => '<p>Returns the result of the route matrix calculation.</p>', 'refs' => [], ], 'CalculateRouteMatrixResponseSnappedDeparturePositionsList' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteMatrixResponse$SnappedDeparturePositions' => '<p>For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest road. For Esri route calculator resources, this returns the list of departure/origin positions used for calculation of the <code>RouteMatrix</code>.</p>', ], ], 'CalculateRouteMatrixResponseSnappedDestinationPositionsList' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteMatrixResponse$SnappedDestinationPositions' => '<p>The list of destination positions for the route matrix used for calculation of the <code>RouteMatrix</code>.</p>', ], ], 'CalculateRouteMatrixSummary' => [ 'base' => '<p>A summary of the calculated route matrix.</p>', 'refs' => [ 'CalculateRouteMatrixResponse$Summary' => '<p>Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>, <code>RouteCount</code> and <code>ErrorCount</code>.</p>', ], ], 'CalculateRouteMatrixSummaryErrorCountInteger' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteMatrixSummary$ErrorCount' => '<p>The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.</p>', ], ], 'CalculateRouteMatrixSummaryRouteCountInteger' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteMatrixSummary$RouteCount' => '<p>The count of cells in the route matrix. Equal to the number of <code>DeparturePositions</code> multiplied by the number of <code>DestinationPositions</code>.</p>', ], ], 'CalculateRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CalculateRouteRequestWaypointPositionsList' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteRequest$WaypointPositions' => '<p>Specifies an ordered list of up to 23 intermediate positions to include along a route between the departure position and destination position. </p> <ul> <li> <p>For example, from the <code>DeparturePosition</code> <code>[-123.115, 49.285]</code>, the route follows the order that the waypoint positions are given <code>[[-122.757, 49.0021],[-122.349, 47.620]]</code> </p> </li> </ul> <note> <p>If you specify a waypoint position that\'s not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p> <p>Specifying more than 23 waypoints returns a <code>400 ValidationException</code> error.</p> <p>If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p> </note> <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>', ], ], 'CalculateRouteResponse' => [ 'base' => '<p>Returns the result of the route calculation. Metadata includes legs and route summary.</p>', 'refs' => [], ], 'CalculateRouteSummary' => [ 'base' => '<p>A summary of the calculated route.</p>', 'refs' => [ 'CalculateRouteResponse$Summary' => '<p>Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>, <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.</p>', ], ], 'CalculateRouteSummaryDistanceDouble' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteSummary$Distance' => '<p>The total distance covered by the route. The sum of the distance travelled between every stop on the route.</p> <note> <p>If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km. If the route exceeds 400 km, the response is a <code>400 RoutesValidationException</code> error.</p> </note>', ], ], 'CalculateRouteSummaryDurationSecondsDouble' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteSummary$DurationSeconds' => '<p>The total travel time for the route measured in seconds. The sum of the travel time between every stop on the route.</p>', ], ], 'CalculateRouteTruckModeOptions' => [ 'base' => '<p>Contains details about additional route preferences for requests that specify <code>TravelMode</code> as <code>Truck</code>.</p>', 'refs' => [ 'CalculateRouteMatrixRequest$TruckModeOptions' => '<p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p> <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>', 'CalculateRouteRequest$TruckModeOptions' => '<p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p> <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request was unsuccessful because of a conflict.</p>', 'refs' => [], ], 'CountryCode' => [ 'base' => NULL, 'refs' => [ 'CountryCodeList$member' => NULL, ], ], 'CountryCodeList' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForSuggestionsRequest$FilterCountries' => '<p>An optional parameter that limits the search results by returning only suggestions within the provided list of countries.</p> <ul> <li> <p>Use the <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country code. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li> </ul>', 'SearchPlaceIndexForSuggestionsSummary$FilterCountries' => '<p>Contains the optional country filter specified in the request.</p>', 'SearchPlaceIndexForTextRequest$FilterCountries' => '<p>An optional parameter that limits the search results by returning only places that are in a specified list of countries.</p> <ul> <li> <p>Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li> </ul>', 'SearchPlaceIndexForTextSummary$FilterCountries' => '<p>Contains the optional country filter specified in the request.</p>', ], ], 'CreateGeofenceCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGeofenceCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMapRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMapResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePlaceIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePlaceIndexResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteCalculatorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteCalculatorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrackerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrackerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataSourceConfiguration' => [ 'base' => '<p>Specifies the data storage option chosen for requesting Places.</p> <important> <p>When using Amazon Location Places:</p> <ul> <li> <p>If using HERE Technologies as a data provider, you can\'t store results for locations in Japan by setting <code>IntendedUse</code> to <code>Storage</code>. parameter.</p> </li> <li> <p>Under the <code>MobileAssetTracking</code> or <code>MobilAssetManagement</code> pricing plan, you can\'t store results from your place index resources by setting <code>IntendedUse</code> to <code>Storage</code>. This returns a validation exception error.</p> </li> </ul> <p>For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p> </important>', 'refs' => [ 'CreatePlaceIndexRequest$DataSourceConfiguration' => '<p>Specifies the data storage option requesting Places.</p>', 'DescribePlaceIndexResponse$DataSourceConfiguration' => '<p>The specified data storage option for requesting Places.</p>', 'UpdatePlaceIndexRequest$DataSourceConfiguration' => '<p>Updates the data storage option for the place index resource.</p>', ], ], 'DeleteGeofenceCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGeofenceCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMapRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMapResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePlaceIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePlaceIndexResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRouteCalculatorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRouteCalculatorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrackerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrackerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGeofenceCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGeofenceCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMapRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMapResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePlaceIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePlaceIndexResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRouteCalculatorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRouteCalculatorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrackerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrackerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DevicePosition' => [ 'base' => '<p>Contains the device position details.</p>', 'refs' => [ 'DevicePositionList$member' => NULL, ], ], 'DevicePositionList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDevicePositionResponse$DevicePositions' => '<p>Contains device position details such as the device ID, position, and timestamps for when the position was received and sampled.</p>', 'GetDevicePositionHistoryResponse$DevicePositions' => '<p>Contains the position history details for the requested device.</p>', ], ], 'DevicePositionUpdate' => [ 'base' => '<p>Contains the position update details for a device.</p>', 'refs' => [ 'BatchEvaluateGeofencesRequestDevicePositionUpdatesList$member' => NULL, 'BatchUpdateDevicePositionRequestUpdatesList$member' => NULL, ], ], 'DimensionUnit' => [ 'base' => NULL, 'refs' => [ 'TruckDimensions$Unit' => '<p> Specifies the unit of measurement for the truck dimensions.</p> <p>Default Value: <code>Meters</code> </p>', ], ], 'DisassociateTrackerConsumerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTrackerConsumerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DistanceUnit' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteMatrixRequest$DistanceUnit' => '<p>Set the unit system to specify the distance.</p> <p>Default Value: <code>Kilometers</code> </p>', 'CalculateRouteMatrixSummary$DistanceUnit' => '<p>The unit of measurement for route distances.</p>', 'CalculateRouteRequest$DistanceUnit' => '<p>Set the unit system to specify the distance.</p> <p>Default Value: <code>Kilometers</code> </p>', 'CalculateRouteSummary$DistanceUnit' => '<p>The unit of measurement for route distances.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'BoundingBox$member' => NULL, 'Position$member' => NULL, ], ], 'GeofenceGeometry' => [ 'base' => '<p>Contains the geofence geometry details.</p> <note> <p>Amazon Location doesn\'t currently support polygons with holes, multipolygons, polygons that are wound clockwise, or that cross the antimeridian. </p> </note>', 'refs' => [ 'BatchPutGeofenceRequestEntry$Geometry' => '<p>Contains the polygon details to specify the position of the geofence.</p> <note> <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p> </note>', 'GetGeofenceResponse$Geometry' => '<p>Contains the geofence geometry details describing a polygon.</p>', 'ListGeofenceResponseEntry$Geometry' => '<p>Contains the geofence geometry details describing a polygon.</p>', 'PutGeofenceRequest$Geometry' => '<p>Contains the polygon details to specify the position of the geofence.</p> <note> <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p> </note>', ], ], 'GetDevicePositionHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDevicePositionHistoryRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'GetDevicePositionHistoryRequest$MaxResults' => '<p>An optional limit for the number of device positions returned in a single call.</p> <p>Default value: <code>100</code> </p>', ], ], 'GetDevicePositionHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDevicePositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDevicePositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetGeofenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGeofenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMapGlyphsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMapGlyphsRequestFontUnicodeRangeString' => [ 'base' => NULL, 'refs' => [ 'GetMapGlyphsRequest$FontUnicodeRange' => '<p>A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be aligned to multiples of 256.</p>', ], ], 'GetMapGlyphsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMapSpritesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMapSpritesRequestFileNameString' => [ 'base' => NULL, 'refs' => [ 'GetMapSpritesRequest$FileName' => '<p>The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p> <ul> <li> <p> <code>sprites.png</code> </p> </li> <li> <p> <code>sprites@2x.png</code> for high pixel density displays</p> </li> </ul> <p>For the JSON document contain image offsets. Use the following ﬁle names:</p> <ul> <li> <p> <code>sprites.json</code> </p> </li> <li> <p> <code>sprites@2x.json</code> for high pixel density displays</p> </li> </ul>', ], ], 'GetMapSpritesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMapStyleDescriptorRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMapStyleDescriptorResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMapTileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMapTileRequestXString' => [ 'base' => NULL, 'refs' => [ 'GetMapTileRequest$X' => '<p>The X axis value for the map tile.</p>', ], ], 'GetMapTileRequestYString' => [ 'base' => NULL, 'refs' => [ 'GetMapTileRequest$Y' => '<p>The Y axis value for the map tile. </p>', ], ], 'GetMapTileRequestZString' => [ 'base' => NULL, 'refs' => [ 'GetMapTileRequest$Z' => '<p>The zoom value for the map tile.</p>', ], ], 'GetMapTileResponse' => [ 'base' => NULL, 'refs' => [], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDevicePositionHistoryError$DeviceId' => '<p>The ID of the device for this position.</p>', 'BatchDeleteDevicePositionHistoryRequestDeviceIdsList$member' => NULL, 'BatchDeleteGeofenceError$GeofenceId' => '<p>The geofence associated with the error message.</p>', 'BatchDeleteGeofenceRequestGeofenceIdsList$member' => NULL, 'BatchEvaluateGeofencesError$DeviceId' => '<p>The device associated with the position evaluation error.</p>', 'BatchGetDevicePositionError$DeviceId' => '<p>The ID of the device that didn\'t return a position.</p>', 'BatchGetDevicePositionRequestDeviceIdsList$member' => NULL, 'BatchPutGeofenceError$GeofenceId' => '<p>The geofence associated with the error message.</p>', 'BatchPutGeofenceRequestEntry$GeofenceId' => '<p>The identifier for the geofence to be stored in a given geofence collection.</p>', 'BatchPutGeofenceSuccess$GeofenceId' => '<p>The geofence successfully stored in a geofence collection.</p>', 'BatchUpdateDevicePositionError$DeviceId' => '<p>The device associated with the failed location update.</p>', 'DevicePosition$DeviceId' => '<p>The device whose position you retrieved.</p>', 'DevicePositionUpdate$DeviceId' => '<p>The device associated to the position update.</p>', 'GetDevicePositionHistoryRequest$DeviceId' => '<p>The device whose position history you want to retrieve.</p>', 'GetDevicePositionRequest$DeviceId' => '<p>The device whose position you want to retrieve.</p>', 'GetDevicePositionResponse$DeviceId' => '<p>The device whose position you retrieved.</p>', 'GetGeofenceRequest$GeofenceId' => '<p>The geofence you\'re retrieving details for.</p>', 'GetGeofenceResponse$GeofenceId' => '<p>The geofence identifier.</p>', 'ListDevicePositionsResponseEntry$DeviceId' => '<p>The ID of the device for this position.</p>', 'ListGeofenceResponseEntry$GeofenceId' => '<p>The geofence identifier.</p>', 'PutGeofenceRequest$GeofenceId' => '<p>An identifier for the geofence. For example, <code>ExampleGeofence-1</code>.</p>', 'PutGeofenceResponse$GeofenceId' => '<p>The geofence identifier entered in the request.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForSuggestionsSummary$MaxResults' => '<p>Contains the optional result count limit specified in the request.</p>', 'TimeZone$Offset' => '<p>The time zone\'s offset, in seconds, from UTC.</p>', ], ], 'IntendedUse' => [ 'base' => NULL, 'refs' => [ 'DataSourceConfiguration$IntendedUse' => '<p>Specifies how the results of an operation will be stored by the caller. </p> <p>Valid values include:</p> <ul> <li> <p> <code>SingleUse</code> specifies that the results won\'t be stored. </p> </li> <li> <p> <code>Storage</code> specifies that the result can be cached or stored in a database.</p> </li> </ul> <p>Default value: <code>SingleUse</code> </p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request has failed to process because of an unknown server error, exception, or failure.</p>', 'refs' => [], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateGeofenceCollectionRequest$KmsKeyId' => '<p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN. </p>', 'CreateTrackerRequest$KmsKeyId' => '<p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.</p>', 'DescribeGeofenceCollectionResponse$KmsKeyId' => '<p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource</p>', 'DescribeTrackerResponse$KmsKeyId' => '<p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource.</p>', ], ], 'LanguageTag' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForPositionRequest$Language' => '<p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p> <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>', 'SearchPlaceIndexForPositionSummary$Language' => '<p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>', 'SearchPlaceIndexForSuggestionsRequest$Language' => '<p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p> <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p> <p>Used only when the partner selected is Here.</p>', 'SearchPlaceIndexForSuggestionsSummary$Language' => '<p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>', 'SearchPlaceIndexForTextRequest$Language' => '<p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p> <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>', 'SearchPlaceIndexForTextSummary$Language' => '<p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>', ], ], 'Leg' => [ 'base' => '<p>Contains the calculated route\'s details for each path between a pair of positions. The number of legs returned corresponds to one fewer than the total number of positions in the request. </p> <p>For example, a route with a departure position and destination position returns one leg with the positions <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>:</p> <ul> <li> <p>The <code>StartPosition</code> is the departure position.</p> </li> <li> <p>The <code>EndPosition</code> is the destination position.</p> </li> </ul> <p>A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:</p> <ul> <li> <p>Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the waypoint positon.</p> </li> <li> <p>Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the destination position.</p> </li> </ul>', 'refs' => [ 'LegList$member' => NULL, ], ], 'LegDistanceDouble' => [ 'base' => NULL, 'refs' => [ 'Leg$Distance' => '<p>The distance between the leg\'s <code>StartPosition</code> and <code>EndPosition</code> along a calculated route. </p> <ul> <li> <p>The default measurement is <code>Kilometers</code> unless the request specifies a <code>DistanceUnit</code> of <code>Miles</code>.</p> </li> </ul>', ], ], 'LegDurationSecondsDouble' => [ 'base' => NULL, 'refs' => [ 'Leg$DurationSeconds' => '<p>The estimated travel time between the leg\'s <code>StartPosition</code> and <code>EndPosition</code>. The travel mode and departure time that you specify in the request determines the calculated time.</p>', ], ], 'LegGeometry' => [ 'base' => '<p>Contains the geometry details for each path between a pair of positions. Used in plotting a route leg on a map.</p>', 'refs' => [ 'Leg$Geometry' => '<p>Contains the calculated route\'s path as a linestring geometry.</p>', ], ], 'LegList' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteResponse$Legs' => '<p>Contains details about each path between a pair of positions included along a route such as: <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>, <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer than the total number of positions in the request. </p> <p>For example, a route with a departure position and destination position returns one leg with the positions <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>:</p> <ul> <li> <p>The <code>StartPosition</code> is the departure position.</p> </li> <li> <p>The <code>EndPosition</code> is the destination position.</p> </li> </ul> <p>A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:</p> <ul> <li> <p>Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the waypoint positon.</p> </li> <li> <p>Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the destination position.</p> </li> </ul>', ], ], 'LineString' => [ 'base' => NULL, 'refs' => [ 'LegGeometry$LineString' => '<p>An ordered list of positions used to plot a route on a map. </p> <p>The first position is closest to the start position for the leg, and the last position is the closest to the end position for the leg.</p> <ul> <li> <p>For example, <code>[[-123.117, 49.284],[-123.115, 49.285],[-123.115, 49.285]]</code> </p> </li> </ul>', ], ], 'LinearRing' => [ 'base' => NULL, 'refs' => [ 'LinearRings$member' => NULL, ], ], 'LinearRings' => [ 'base' => NULL, 'refs' => [ 'GeofenceGeometry$Polygon' => '<p>An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first and last vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the form: <code>[longitude, latitude]</code>. </p> <p>The first linear ring is an outer ring, describing the polygon\'s boundary. Subsequent linear rings may be inner or outer rings to describe holes and islands. Outer rings must list their vertices in counter-clockwise order around the ring\'s center, where the left side is the polygon\'s exterior. Inner rings must list their vertices in clockwise order, where the left side is the polygon\'s interior.</p>', ], ], 'ListDevicePositionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDevicePositionsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListDevicePositionsRequest$MaxResults' => '<p>An optional limit for the number of entries returned in a single call.</p> <p>Default value: <code>100</code> </p>', ], ], 'ListDevicePositionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDevicePositionsResponseEntry' => [ 'base' => '<p>Contains the tracker resource details.</p>', 'refs' => [ 'ListDevicePositionsResponseEntryList$member' => NULL, ], ], 'ListDevicePositionsResponseEntryList' => [ 'base' => NULL, 'refs' => [ 'ListDevicePositionsResponse$Entries' => '<p>Contains details about each device\'s last known position. These details includes the device ID, the time when the position was sampled on the device, the time that the service received the update, and the most recent coordinates.</p>', ], ], 'ListGeofenceCollectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGeofenceCollectionsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListGeofenceCollectionsRequest$MaxResults' => '<p>An optional limit for the number of resources returned in a single call. </p> <p>Default value: <code>100</code> </p>', ], ], 'ListGeofenceCollectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGeofenceCollectionsResponseEntry' => [ 'base' => '<p>Contains the geofence collection details.</p>', 'refs' => [ 'ListGeofenceCollectionsResponseEntryList$member' => NULL, ], ], 'ListGeofenceCollectionsResponseEntryList' => [ 'base' => NULL, 'refs' => [ 'ListGeofenceCollectionsResponse$Entries' => '<p>Lists the geofence collections that exist in your AWS account.</p>', ], ], 'ListGeofenceResponseEntry' => [ 'base' => '<p>Contains a list of geofences stored in a given geofence collection.</p>', 'refs' => [ 'ListGeofenceResponseEntryList$member' => NULL, ], ], 'ListGeofenceResponseEntryList' => [ 'base' => NULL, 'refs' => [ 'ListGeofencesResponse$Entries' => '<p>Contains a list of geofences stored in the geofence collection.</p>', ], ], 'ListGeofencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGeofencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMapsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMapsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListMapsRequest$MaxResults' => '<p>An optional limit for the number of resources returned in a single call. </p> <p>Default value: <code>100</code> </p>', ], ], 'ListMapsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMapsResponseEntry' => [ 'base' => '<p>Contains details of an existing map resource in your AWS account.</p>', 'refs' => [ 'ListMapsResponseEntryList$member' => NULL, ], ], 'ListMapsResponseEntryList' => [ 'base' => NULL, 'refs' => [ 'ListMapsResponse$Entries' => '<p>Contains a list of maps in your AWS account</p>', ], ], 'ListPlaceIndexesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPlaceIndexesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListPlaceIndexesRequest$MaxResults' => '<p>An optional limit for the maximum number of results returned in a single call.</p> <p>Default value: <code>100</code> </p>', ], ], 'ListPlaceIndexesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPlaceIndexesResponseEntry' => [ 'base' => '<p>A place index resource listed in your AWS account.</p>', 'refs' => [ 'ListPlaceIndexesResponseEntryList$member' => NULL, ], ], 'ListPlaceIndexesResponseEntryList' => [ 'base' => NULL, 'refs' => [ 'ListPlaceIndexesResponse$Entries' => '<p>Lists the place index resources that exist in your AWS account</p>', ], ], 'ListRouteCalculatorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRouteCalculatorsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRouteCalculatorsRequest$MaxResults' => '<p>An optional maximum number of results returned in a single call.</p> <p>Default Value: <code>100</code> </p>', ], ], 'ListRouteCalculatorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRouteCalculatorsResponseEntry' => [ 'base' => '<p>A route calculator resource listed in your AWS account.</p>', 'refs' => [ 'ListRouteCalculatorsResponseEntryList$member' => NULL, ], ], 'ListRouteCalculatorsResponseEntryList' => [ 'base' => NULL, 'refs' => [ 'ListRouteCalculatorsResponse$Entries' => '<p>Lists the route calculator resources that exist in your AWS account</p>', ], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrackerConsumersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrackerConsumersRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListTrackerConsumersRequest$MaxResults' => '<p>An optional limit for the number of resources returned in a single call. </p> <p>Default value: <code>100</code> </p>', ], ], 'ListTrackerConsumersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrackersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrackersRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListTrackersRequest$MaxResults' => '<p>An optional limit for the number of resources returned in a single call. </p> <p>Default value: <code>100</code> </p>', ], ], 'ListTrackersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrackersResponseEntry' => [ 'base' => '<p>Contains the tracker resource details.</p>', 'refs' => [ 'ListTrackersResponseEntryList$member' => NULL, ], ], 'ListTrackersResponseEntryList' => [ 'base' => NULL, 'refs' => [ 'ListTrackersResponse$Entries' => '<p>Contains tracker resources in your AWS account. Details include tracker name, description and timestamps for when the tracker was created and last updated.</p>', ], ], 'MapConfiguration' => [ 'base' => '<p>Specifies the map tile style selected from an available provider.</p>', 'refs' => [ 'CreateMapRequest$Configuration' => '<p>Specifies the map style selected from an available data provider.</p>', 'DescribeMapResponse$Configuration' => '<p>Specifies the map tile style selected from a partner data provider.</p>', ], ], 'MapStyle' => [ 'base' => NULL, 'refs' => [ 'MapConfiguration$Style' => '<p>Specifies the map style selected from an available data provider.</p> <p>Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map styles</a>:</p> <ul> <li> <p> <code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that\'s designed to draw attention to your thematic content. </p> </li> <li> <p> <code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide. </p> </li> <li> <p> <code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that\'s designed to draw attention to your thematic content. </p> </li> <li> <p> <code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.</p> </li> <li> <p> <code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.</p> </li> <li> <p> <code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that\'s designed for use during the day in mobile devices.</p> </li> </ul> <p>Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies map styles</a>:</p> <ul> <li> <p> <code>VectorHereBerlin</code> – The HERE Berlin map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.</p> </li> <li> <p> <code>VectorHereExplore</code> – A default HERE map style containing a neutral, global map and its features including roads, buildings, landmarks, and water features. It also now includes a fully designed map of Japan.</p> </li> <li> <p> <code>VectorHereExploreTruck</code> – A global map containing truck restrictions and attributes (e.g. width / height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to support use cases within transport and logistics.</p> </li> </ul>', ], ], 'Place' => [ 'base' => '<p>Contains details about addresses or points of interest that match the search criteria.</p>', 'refs' => [ 'SearchForPositionResult$Place' => '<p>Details about the search result, such as its address and position.</p>', 'SearchForTextResult$Place' => '<p>Details about the search result, such as its address and position.</p>', ], ], 'PlaceGeometry' => [ 'base' => '<p>Places uses a point geometry to specify a location or a Place.</p>', 'refs' => [ 'Place$Geometry' => NULL, ], ], 'PlaceIndexSearchResultLimit' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForPositionRequest$MaxResults' => '<p>An optional parameter. The maximum number of results returned per request.</p> <p>Default value: <code>50</code> </p>', 'SearchPlaceIndexForPositionSummary$MaxResults' => '<p>Contains the optional result count limit that is specified in the request.</p> <p>Default value: <code>50</code> </p>', 'SearchPlaceIndexForTextRequest$MaxResults' => '<p>An optional parameter. The maximum number of results returned per request. </p> <p>The default: <code>50</code> </p>', 'SearchPlaceIndexForTextSummary$MaxResults' => '<p>Contains the optional result count limit specified in the request.</p>', ], ], 'Position' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteMatrixRequestDeparturePositionsList$member' => NULL, 'CalculateRouteMatrixRequestDestinationPositionsList$member' => NULL, 'CalculateRouteMatrixResponseSnappedDeparturePositionsList$member' => NULL, 'CalculateRouteMatrixResponseSnappedDestinationPositionsList$member' => NULL, 'CalculateRouteRequest$DeparturePosition' => '<p>The start position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p> <ul> <li> <p>For example, <code>[-123.115, 49.285]</code> </p> </li> </ul> <note> <p>If you specify a departure that\'s not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p> </note> <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>', 'CalculateRouteRequest$DestinationPosition' => '<p>The finish position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p> <ul> <li> <p> For example, <code>[-122.339, 47.615]</code> </p> </li> </ul> <note> <p>If you specify a destination that\'s not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p> </note> <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>', 'CalculateRouteRequestWaypointPositionsList$member' => NULL, 'DevicePosition$Position' => '<p>The last known device position.</p>', 'DevicePositionUpdate$Position' => '<p>The latest device position defined in <a href="https://earth-info.nga.mil/index.php?dir=wgs84&amp;action=wgs84">WGS 84</a> format: <code>[X or longitude, Y or latitude]</code>.</p>', 'GetDevicePositionResponse$Position' => '<p>The last known device position.</p>', 'Leg$EndPosition' => '<p>The terminating position of the leg. Follows the format <code>[longitude,latitude]</code>.</p> <note> <p>If the <code>EndPosition</code> isn\'t located on a road, it\'s <a href="https://docs.aws.amazon.com/location/latest/developerguide/nap-to-nearby-road.html">snapped to a nearby road</a>. </p> </note>', 'Leg$StartPosition' => '<p>The starting position of the leg. Follows the format <code>[longitude,latitude]</code>.</p> <note> <p>If the <code>StartPosition</code> isn\'t located on a road, it\'s <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>. </p> </note>', 'LineString$member' => NULL, 'LinearRing$member' => NULL, 'ListDevicePositionsResponseEntry$Position' => '<p>The last known device position. Empty if no positions currently stored.</p>', 'PlaceGeometry$Point' => '<p>A single point geometry specifies a location for a Place using <a href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:</p> <ul> <li> <p> <i>x</i> — Specifies the x coordinate or longitude. </p> </li> <li> <p> <i>y</i> — Specifies the y coordinate or latitude. </p> </li> </ul>', 'SearchPlaceIndexForPositionRequest$Position' => '<p>Specifies the longitude and latitude of the position to query.</p> <p> This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p> <p>For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>', 'SearchPlaceIndexForPositionSummary$Position' => '<p>The position specified in the request.</p>', 'SearchPlaceIndexForSuggestionsRequest$BiasPosition' => '<p>An optional parameter that indicates a preference for place suggestions that are closer to a specified position.</p> <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p> <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note> <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p> </note>', 'SearchPlaceIndexForSuggestionsSummary$BiasPosition' => '<p>Contains the coordinates for the optional bias position specified in the request.</p> <p>This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p> <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>', 'SearchPlaceIndexForTextRequest$BiasPosition' => '<p>An optional parameter that indicates a preference for places that are closer to a specified position.</p> <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p> <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note> <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p> </note>', 'SearchPlaceIndexForTextSummary$BiasPosition' => '<p>Contains the coordinates for the optional bias position specified in the request.</p> <p>This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p> <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>', 'Step$EndPosition' => '<p>The end position of a step. If the position the last step in the leg, this position is the same as the end position of the leg.</p>', 'Step$StartPosition' => '<p>The starting position of a step. If the position is the first step in the leg, this position is the same as the start position of the leg.</p>', ], ], 'PositionFiltering' => [ 'base' => NULL, 'refs' => [ 'CreateTrackerRequest$PositionFiltering' => '<p>Specifies the position filtering for the tracker resource.</p> <p>Valid values:</p> <ul> <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li> <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li> <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations. </p> </li> </ul> <p>This field is optional. If not specified, the default value is <code>TimeBased</code>.</p>', 'DescribeTrackerResponse$PositionFiltering' => '<p>The position filtering method of the tracker resource.</p>', 'UpdateTrackerRequest$PositionFiltering' => '<p>Updates the position filtering for the tracker resource.</p> <p>Valid values:</p> <ul> <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li> <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li> <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device trajectories on a map, and can help control costs by reducing the number of geofence evaluations. </p> </li> </ul>', ], ], 'PositionalAccuracy' => [ 'base' => '<p>Defines the level of certainty of the position.</p>', 'refs' => [ 'DevicePosition$Accuracy' => '<p>The accuracy of the device position.</p>', 'DevicePositionUpdate$Accuracy' => '<p>The accuracy of the device position.</p>', 'GetDevicePositionResponse$Accuracy' => '<p>The accuracy of the device position.</p>', 'ListDevicePositionsResponseEntry$Accuracy' => '<p>The accuracy of the device position.</p>', ], ], 'PositionalAccuracyHorizontalDouble' => [ 'base' => NULL, 'refs' => [ 'PositionalAccuracy$Horizontal' => '<p>Estimated maximum distance, in meters, between the measured position and the true position of a device, along the Earth\'s surface.</p>', ], ], 'PricingPlan' => [ 'base' => NULL, 'refs' => [ 'CreateGeofenceCollectionRequest$PricingPlan' => '<p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>', 'CreateMapRequest$PricingPlan' => '<p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>', 'CreatePlaceIndexRequest$PricingPlan' => '<p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>', 'CreateRouteCalculatorRequest$PricingPlan' => '<p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>', 'CreateTrackerRequest$PricingPlan' => '<p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>', 'DescribeGeofenceCollectionResponse$PricingPlan' => '<p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>', 'DescribeMapResponse$PricingPlan' => '<p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>', 'DescribePlaceIndexResponse$PricingPlan' => '<p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>', 'DescribeRouteCalculatorResponse$PricingPlan' => '<p>Always returns <code>RequestBasedUsage</code>.</p>', 'DescribeTrackerResponse$PricingPlan' => '<p>Always returns <code>RequestBasedUsage</code>.</p>', 'ListGeofenceCollectionsResponseEntry$PricingPlan' => '<p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>', 'ListMapsResponseEntry$PricingPlan' => '<p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>', 'ListPlaceIndexesResponseEntry$PricingPlan' => '<p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>', 'ListRouteCalculatorsResponseEntry$PricingPlan' => '<p>Always returns <code>RequestBasedUsage</code>.</p>', 'ListTrackersResponseEntry$PricingPlan' => '<p>Always returns <code>RequestBasedUsage</code>.</p>', 'UpdateGeofenceCollectionRequest$PricingPlan' => '<p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>', 'UpdateMapRequest$PricingPlan' => '<p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>', 'UpdatePlaceIndexRequest$PricingPlan' => '<p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>', 'UpdateRouteCalculatorRequest$PricingPlan' => '<p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>', 'UpdateTrackerRequest$PricingPlan' => '<p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>', ], ], 'PropertyMap' => [ 'base' => NULL, 'refs' => [ 'DevicePosition$PositionProperties' => '<p>The properties associated with the position.</p>', 'DevicePositionUpdate$PositionProperties' => '<p>Associates one of more properties with the position update. A property is a key-value pair stored with the position update and added to any geofence event the update may trigger.</p> <p>Format: <code>"key" : "value"</code> </p>', 'GetDevicePositionResponse$PositionProperties' => '<p>The properties associated with the position.</p>', 'ListDevicePositionsResponseEntry$PositionProperties' => '<p>The properties associated with the position.</p>', ], ], 'PropertyMapKeyString' => [ 'base' => NULL, 'refs' => [ 'PropertyMap$key' => NULL, ], ], 'PropertyMapValueString' => [ 'base' => NULL, 'refs' => [ 'PropertyMap$value' => NULL, ], ], 'PutGeofenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutGeofenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceDescription' => [ 'base' => NULL, 'refs' => [ 'CreateGeofenceCollectionRequest$Description' => '<p>An optional description for the geofence collection.</p>', 'CreateMapRequest$Description' => '<p>An optional description for the map resource.</p>', 'CreatePlaceIndexRequest$Description' => '<p>The optional description for the place index resource.</p>', 'CreateRouteCalculatorRequest$Description' => '<p>The optional description for the route calculator resource.</p>', 'CreateTrackerRequest$Description' => '<p>An optional description for the tracker resource.</p>', 'DescribeGeofenceCollectionResponse$Description' => '<p>The optional description for the geofence collection.</p>', 'DescribeMapResponse$Description' => '<p>The optional description for the map resource.</p>', 'DescribePlaceIndexResponse$Description' => '<p>The optional description for the place index resource.</p>', 'DescribeRouteCalculatorResponse$Description' => '<p>The optional description of the route calculator resource.</p>', 'DescribeTrackerResponse$Description' => '<p>The optional description for the tracker resource.</p>', 'ListGeofenceCollectionsResponseEntry$Description' => '<p>The description for the geofence collection</p>', 'ListMapsResponseEntry$Description' => '<p>The description for the map resource.</p>', 'ListPlaceIndexesResponseEntry$Description' => '<p>The optional description for the place index resource.</p>', 'ListRouteCalculatorsResponseEntry$Description' => '<p>The optional description of the route calculator resource.</p>', 'ListTrackersResponseEntry$Description' => '<p>The description for the tracker resource.</p>', 'UpdateGeofenceCollectionRequest$Description' => '<p>Updates the description for the geofence collection.</p>', 'UpdateMapRequest$Description' => '<p>Updates the description for the map resource.</p>', 'UpdatePlaceIndexRequest$Description' => '<p>Updates the description for the place index resource.</p>', 'UpdateRouteCalculatorRequest$Description' => '<p>Updates the description for the route calculator resource.</p>', 'UpdateTrackerRequest$Description' => '<p>Updates the description for the tracker resource.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'AssociateTrackerConsumerRequest$TrackerName' => '<p>The name of the tracker resource to be associated with a geofence collection.</p>', 'BatchDeleteDevicePositionHistoryRequest$TrackerName' => '<p>The name of the tracker resource to delete the device position history from.</p>', 'BatchDeleteGeofenceRequest$CollectionName' => '<p>The geofence collection storing the geofences to be deleted.</p>', 'BatchEvaluateGeofencesRequest$CollectionName' => '<p>The geofence collection used in evaluating the position of devices against its geofences.</p>', 'BatchPutGeofenceRequest$CollectionName' => '<p>The geofence collection storing the geofences.</p>', 'BatchUpdateDevicePositionRequest$TrackerName' => '<p>The name of the tracker resource to update.</p>', 'CalculateRouteMatrixRequest$CalculatorName' => '<p>The name of the route calculator resource that you want to use to calculate the route matrix. </p>', 'CalculateRouteRequest$CalculatorName' => '<p>The name of the route calculator resource that you want to use to calculate the route. </p>', 'CreateGeofenceCollectionRequest$CollectionName' => '<p>A custom name for the geofence collection.</p> <p>Requirements:</p> <ul> <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li> <li> <p>Must be a unique geofence collection name.</p> </li> <li> <p>No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.</p> </li> </ul>', 'CreateGeofenceCollectionResponse$CollectionName' => '<p>The name for the geofence collection.</p>', 'CreateMapRequest$MapName' => '<p>The name for the map resource.</p> <p>Requirements:</p> <ul> <li> <p>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li> <li> <p>Must be a unique map resource name. </p> </li> <li> <p>No spaces allowed. For example, <code>ExampleMap</code>.</p> </li> </ul>', 'CreateMapResponse$MapName' => '<p>The name of the map resource.</p>', 'CreatePlaceIndexRequest$IndexName' => '<p>The name of the place index resource. </p> <p>Requirements:</p> <ul> <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</p> </li> <li> <p>Must be a unique place index resource name.</p> </li> <li> <p>No spaces allowed. For example, <code>ExamplePlaceIndex</code>.</p> </li> </ul>', 'CreatePlaceIndexResponse$IndexName' => '<p>The name for the place index resource.</p>', 'CreateRouteCalculatorRequest$CalculatorName' => '<p>The name of the route calculator resource. </p> <p>Requirements:</p> <ul> <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</p> </li> <li> <p>Must be a unique Route calculator resource name.</p> </li> <li> <p>No spaces allowed. For example, <code>ExampleRouteCalculator</code>.</p> </li> </ul>', 'CreateRouteCalculatorResponse$CalculatorName' => '<p>The name of the route calculator resource. </p> <ul> <li> <p>For example, <code>ExampleRouteCalculator</code>.</p> </li> </ul>', 'CreateTrackerRequest$TrackerName' => '<p>The name for the tracker resource.</p> <p>Requirements:</p> <ul> <li> <p>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</p> </li> <li> <p>Must be a unique tracker resource name.</p> </li> <li> <p>No spaces allowed. For example, <code>ExampleTracker</code>.</p> </li> </ul>', 'CreateTrackerResponse$TrackerName' => '<p>The name of the tracker resource.</p>', 'DeleteGeofenceCollectionRequest$CollectionName' => '<p>The name of the geofence collection to be deleted.</p>', 'DeleteMapRequest$MapName' => '<p>The name of the map resource to be deleted.</p>', 'DeletePlaceIndexRequest$IndexName' => '<p>The name of the place index resource to be deleted.</p>', 'DeleteRouteCalculatorRequest$CalculatorName' => '<p>The name of the route calculator resource to be deleted.</p>', 'DeleteTrackerRequest$TrackerName' => '<p>The name of the tracker resource to be deleted.</p>', 'DescribeGeofenceCollectionRequest$CollectionName' => '<p>The name of the geofence collection.</p>', 'DescribeGeofenceCollectionResponse$CollectionName' => '<p>The name of the geofence collection.</p>', 'DescribeMapRequest$MapName' => '<p>The name of the map resource.</p>', 'DescribeMapResponse$MapName' => '<p>The map style selected from an available provider.</p>', 'DescribePlaceIndexRequest$IndexName' => '<p>The name of the place index resource.</p>', 'DescribePlaceIndexResponse$IndexName' => '<p>The name of the place index resource being described.</p>', 'DescribeRouteCalculatorRequest$CalculatorName' => '<p>The name of the route calculator resource.</p>', 'DescribeRouteCalculatorResponse$CalculatorName' => '<p>The name of the route calculator resource being described.</p>', 'DescribeTrackerRequest$TrackerName' => '<p>The name of the tracker resource.</p>', 'DescribeTrackerResponse$TrackerName' => '<p>The name of the tracker resource.</p>', 'DisassociateTrackerConsumerRequest$TrackerName' => '<p>The name of the tracker resource to be dissociated from the consumer.</p>', 'GetDevicePositionHistoryRequest$TrackerName' => '<p>The tracker resource receiving the request for the device position history.</p>', 'GetDevicePositionRequest$TrackerName' => '<p>The tracker resource receiving the position update.</p>', 'GetGeofenceRequest$CollectionName' => '<p>The geofence collection storing the target geofence.</p>', 'GetMapGlyphsRequest$MapName' => '<p>The map resource associated with the glyph ﬁle.</p>', 'GetMapSpritesRequest$MapName' => '<p>The map resource associated with the sprite ﬁle.</p>', 'GetMapStyleDescriptorRequest$MapName' => '<p>The map resource to retrieve the style descriptor from.</p>', 'GetMapTileRequest$MapName' => '<p>The map resource to retrieve the map tiles from.</p>', 'ListDevicePositionsRequest$TrackerName' => '<p>The tracker resource containing the requested devices.</p>', 'ListGeofenceCollectionsResponseEntry$CollectionName' => '<p>The name of the geofence collection.</p>', 'ListGeofencesRequest$CollectionName' => '<p>The name of the geofence collection storing the list of geofences.</p>', 'ListMapsResponseEntry$MapName' => '<p>The name of the associated map resource.</p>', 'ListPlaceIndexesResponseEntry$IndexName' => '<p>The name of the place index resource.</p>', 'ListRouteCalculatorsResponseEntry$CalculatorName' => '<p>The name of the route calculator resource.</p>', 'ListTrackerConsumersRequest$TrackerName' => '<p>The tracker resource whose associated geofence collections you want to list.</p>', 'ListTrackersResponseEntry$TrackerName' => '<p>The name of the tracker resource.</p>', 'PutGeofenceRequest$CollectionName' => '<p>The geofence collection to store the geofence in.</p>', 'SearchPlaceIndexForPositionRequest$IndexName' => '<p>The name of the place index resource you want to use for the search.</p>', 'SearchPlaceIndexForSuggestionsRequest$IndexName' => '<p>The name of the place index resource you want to use for the search.</p>', 'SearchPlaceIndexForTextRequest$IndexName' => '<p>The name of the place index resource you want to use for the search.</p>', 'UpdateGeofenceCollectionRequest$CollectionName' => '<p>The name of the geofence collection to update.</p>', 'UpdateGeofenceCollectionResponse$CollectionName' => '<p>The name of the updated geofence collection.</p>', 'UpdateMapRequest$MapName' => '<p>The name of the map resource to update.</p>', 'UpdateMapResponse$MapName' => '<p>The name of the updated map resource.</p>', 'UpdatePlaceIndexRequest$IndexName' => '<p>The name of the place index resource to update.</p>', 'UpdatePlaceIndexResponse$IndexName' => '<p>The name of the updated place index resource.</p>', 'UpdateRouteCalculatorRequest$CalculatorName' => '<p>The name of the route calculator resource to update.</p>', 'UpdateRouteCalculatorResponse$CalculatorName' => '<p>The name of the updated route calculator resource.</p>', 'UpdateTrackerRequest$TrackerName' => '<p>The name of the tracker resource to update.</p>', 'UpdateTrackerResponse$TrackerName' => '<p>The name of the updated tracker resource.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource that you\'ve entered was not found in your AWS account.</p>', 'refs' => [], ], 'RouteMatrix' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteMatrixResponse$RouteMatrix' => '<p>The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to <code>DestinationPositions</code>. Each row corresponds to one entry in <code>DeparturePositions</code>. Each entry in the row corresponds to the route from that entry in <code>DeparturePositions</code> to an entry in <code>DestinationPositions</code>. </p>', ], ], 'RouteMatrixEntry' => [ 'base' => '<p>The result for the calculated route of one <code>DeparturePosition</code> <code>DestinationPosition</code> pair.</p>', 'refs' => [ 'RouteMatrixRow$member' => NULL, ], ], 'RouteMatrixEntryDistanceDouble' => [ 'base' => NULL, 'refs' => [ 'RouteMatrixEntry$Distance' => '<p>The total distance of travel for the route.</p>', ], ], 'RouteMatrixEntryDurationSecondsDouble' => [ 'base' => NULL, 'refs' => [ 'RouteMatrixEntry$DurationSeconds' => '<p>The expected duration of travel for the route.</p>', ], ], 'RouteMatrixEntryError' => [ 'base' => '<p>An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and <code>DestinationPosition</code>.</p> <p>The error code can be one of the following:</p> <ul> <li> <p> <code>RouteNotFound</code> - Unable to find a valid route with the given parameters.</p> </li> </ul> <ul> <li> <p> <code>RouteTooLong</code> - Route calculation went beyond the maximum size of a route and was terminated before completion.</p> </li> </ul> <ul> <li> <p> <code>PositionsNotFound</code> - One or more of the input positions were not found on the route network.</p> </li> </ul> <ul> <li> <p> <code>DestinationPositionNotFound</code> - The destination position was not found on the route network.</p> </li> </ul> <ul> <li> <p> <code>DeparturePositionNotFound</code> - The departure position was not found on the route network.</p> </li> </ul> <ul> <li> <p> <code>OtherValidationError</code> - The given inputs were not valid or a route was not found. More information is given in the error <code>Message</code> </p> </li> </ul>', 'refs' => [ 'RouteMatrixEntry$Error' => '<p>An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and <code>DestinationPosition</code>.</p>', ], ], 'RouteMatrixErrorCode' => [ 'base' => NULL, 'refs' => [ 'RouteMatrixEntryError$Code' => '<p>The type of error which occurred for the route calculation.</p>', ], ], 'RouteMatrixRow' => [ 'base' => NULL, 'refs' => [ 'RouteMatrix$member' => NULL, ], ], 'SearchForPositionResult' => [ 'base' => '<p>Contains a search result from a position search query that is run on a place index resource.</p>', 'refs' => [ 'SearchForPositionResultList$member' => NULL, ], ], 'SearchForPositionResultDistanceDouble' => [ 'base' => NULL, 'refs' => [ 'SearchForPositionResult$Distance' => '<p>The distance in meters of a great-circle arc between the query position and the result.</p> <note> <p>A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.</p> </note>', ], ], 'SearchForPositionResultList' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForPositionResponse$Results' => '<p>Returns a list of Places closest to the specified position. Each result contains additional information about the Places returned.</p>', ], ], 'SearchForSuggestionsResult' => [ 'base' => '<p>Contains a place suggestion resulting from a place suggestion query that is run on a place index resource.</p>', 'refs' => [ 'SearchForSuggestionsResultList$member' => NULL, ], ], 'SearchForSuggestionsResultList' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForSuggestionsResponse$Results' => '<p>A list of place suggestions that best match the search text.</p>', ], ], 'SearchForTextResult' => [ 'base' => '<p>Contains a search result from a text search query that is run on a place index resource.</p>', 'refs' => [ 'SearchForTextResultList$member' => NULL, ], ], 'SearchForTextResultDistanceDouble' => [ 'base' => NULL, 'refs' => [ 'SearchForTextResult$Distance' => '<p>The distance in meters of a great-circle arc between the bias position specified and the result. <code>Distance</code> will be returned only if a bias position was specified in the query.</p> <note> <p>A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.</p> </note>', ], ], 'SearchForTextResultList' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForTextResponse$Results' => '<p>A list of Places matching the input text. Each result contains additional information about the specific point of interest. </p>', ], ], 'SearchForTextResultRelevanceDouble' => [ 'base' => NULL, 'refs' => [ 'SearchForTextResult$Relevance' => '<p>The relative confidence in the match for a result among the results returned. For example, if more fields for an address match (including house number, street, city, country/region, and postal code), the relevance score is closer to 1.</p> <p>Returned only when the partner selected is Esri.</p>', ], ], 'SearchPlaceIndexForPositionRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchPlaceIndexForPositionResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchPlaceIndexForPositionSummary' => [ 'base' => '<p>A summary of the request sent by using <code>SearchPlaceIndexForPosition</code>.</p>', 'refs' => [ 'SearchPlaceIndexForPositionResponse$Summary' => '<p>Contains a summary of the request. Echoes the input values for <code>Position</code>, <code>Language</code>, <code>MaxResults</code>, and the <code>DataSource</code> of the place index. </p>', ], ], 'SearchPlaceIndexForSuggestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchPlaceIndexForSuggestionsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForSuggestionsRequest$MaxResults' => '<p>An optional parameter. The maximum number of results returned per request. </p> <p>The default: <code>5</code> </p>', ], ], 'SearchPlaceIndexForSuggestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchPlaceIndexForSuggestionsSummary' => [ 'base' => '<p>A summary of the request sent by using <code>SearchPlaceIndexForSuggestions</code>.</p>', 'refs' => [ 'SearchPlaceIndexForSuggestionsResponse$Summary' => '<p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index. </p>', ], ], 'SearchPlaceIndexForTextRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchPlaceIndexForTextResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchPlaceIndexForTextSummary' => [ 'base' => '<p>A summary of the request sent by using <code>SearchPlaceIndexForText</code>.</p>', 'refs' => [ 'SearchPlaceIndexForTextResponse$Summary' => '<p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index and the bounding box, <code>ResultBBox</code>, which surrounds the search results. </p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The operation was denied because the request would exceed the maximum <a href="https://docs.aws.amazon.com/location/latest/developerguide/location-quotas.html">quota</a> set for Amazon Location Service.</p>', 'refs' => [], ], 'Step' => [ 'base' => '<p> Represents an element of a leg within a route. A step contains instructions for how to move to the next step in the leg. </p>', 'refs' => [ 'StepList$member' => NULL, ], ], 'StepDistanceDouble' => [ 'base' => NULL, 'refs' => [ 'Step$Distance' => '<p>The travel distance between the step\'s <code>StartPosition</code> and <code>EndPosition</code>.</p>', ], ], 'StepDurationSecondsDouble' => [ 'base' => NULL, 'refs' => [ 'Step$DurationSeconds' => '<p>The estimated travel time, in seconds, from the step\'s <code>StartPosition</code> to the <code>EndPosition</code>. . The travel mode and departure time that you specify in the request determines the calculated time.</p>', ], ], 'StepGeometryOffsetInteger' => [ 'base' => NULL, 'refs' => [ 'Step$GeometryOffset' => '<p>Represents the start position, or index, in a sequence of steps within the leg\'s line string geometry. For example, the index of the first step in a leg geometry is <code>0</code>. </p> <p>Included in the response for queries that set <code>IncludeLegGeometry</code> to <code>True</code>. </p>', ], ], 'StepList' => [ 'base' => NULL, 'refs' => [ 'Leg$Steps' => '<p>Contains a list of steps, which represent subsections of a leg. Each step provides instructions for how to move to the next step in the leg such as the step\'s start position, end position, travel distance, travel duration, and geometry offset.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'BatchItemError$Message' => '<p>A message with the reason for the batch request error.</p>', 'CalculateRouteMatrixSummary$DataSource' => '<p>The data provider of traffic and road network data used to calculate the routes. Indicates one of the available providers:</p> <ul> <li> <p> <code>Esri</code> </p> </li> <li> <p> <code>Here</code> </p> </li> </ul> <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>', 'CalculateRouteSummary$DataSource' => '<p>The data provider of traffic and road network data used to calculate the route. Indicates one of the available providers:</p> <ul> <li> <p> <code>Esri</code> </p> </li> <li> <p> <code>Here</code> </p> </li> </ul> <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>', 'ConflictException$Message' => NULL, 'CreateGeofenceCollectionRequest$PricingPlanDataSource' => '<p>This parameter is no longer used.</p>', 'CreatePlaceIndexRequest$DataSource' => '<p>Specifies the geospatial data provider for the new place index.</p> <note> <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.</p> </note> <p>Valid values include:</p> <ul> <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>\'s coverage in your region of interest, see <a href="https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm">Esri details on geocoding coverage</a>.</p> </li> <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>\' coverage in your region of interest, see <a href="https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html">HERE details on goecoding coverage</a>.</p> <important> <p>If you specify HERE Technologies (<code>Here</code>) as the data provider, you may not <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store results</a> for locations in Japan. For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p> </important> </li> </ul> <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>', 'CreateRouteCalculatorRequest$DataSource' => '<p>Specifies the data provider of traffic and road network data.</p> <note> <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error. Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.</p> </note> <p>Valid values include:</p> <ul> <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>\'s coverage in your region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street networks and traffic coverage</a>.</p> </li> <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>\' coverage in your region of interest, see <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car routing coverage</a> and <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE truck routing coverage</a>.</p> </li> </ul> <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>', 'CreateTrackerRequest$PricingPlanDataSource' => '<p>This parameter is no longer used.</p>', 'DescribeGeofenceCollectionResponse$PricingPlanDataSource' => '<p>No longer used. Always returns an empty string.</p>', 'DescribeMapResponse$DataSource' => '<p>Specifies the data provider for the associated map tiles.</p>', 'DescribePlaceIndexResponse$DataSource' => '<p>The data provider of geospatial data. Values can be one of the following:</p> <ul> <li> <p> <code>Esri</code> </p> </li> <li> <p> <code>Here</code> </p> </li> </ul> <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>', 'DescribeRouteCalculatorResponse$DataSource' => '<p>The data provider of traffic and road network data. Indicates one of the available providers:</p> <ul> <li> <p> <code>Esri</code> </p> </li> <li> <p> <code>Here</code> </p> </li> </ul> <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>', 'DescribeTrackerResponse$PricingPlanDataSource' => '<p>No longer used. Always returns an empty string.</p>', 'GetGeofenceResponse$Status' => '<p>Identifies the state of the geofence. A geofence will hold one of the following states:</p> <ul> <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li> <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li> <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li> <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li> <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li> </ul>', 'GetMapGlyphsRequest$FontStack' => '<p>A comma-separated list of fonts to load glyphs from in order of preference. For example, <code>Noto Sans Regular, Arial Unicode</code>.</p> <p>Valid fonts stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a> styles: </p> <ul> <li> <p>VectorEsriDarkGrayCanvas – <code>Ubuntu Medium Italic</code> | <code>Ubuntu Medium</code> | <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Bold</code> </p> </li> <li> <p>VectorEsriLightGrayCanvas – <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Light</code> | <code>Ubuntu Bold</code> </p> </li> <li> <p>VectorEsriTopographic – <code>Noto Sans Italic</code> | <code>Noto Sans Regular</code> | <code>Noto Sans Bold</code> | <code>Noto Serif Regular</code> | <code>Roboto Condensed Light Italic</code> </p> </li> <li> <p>VectorEsriStreets – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li> <li> <p>VectorEsriNavigation – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li> </ul> <p>Valid font stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a> styles: </p> <ul> <li> <p>VectorHereBerlin – <code>Fira GO Regular</code> | <code>Fira GO Bold</code> </p> </li> <li> <p>VectorHereExplore, VectorHereExploreTruck – <code>Firo GO Italic</code> | <code>Fira GO Map</code> | <code>Fira GO Map Bold</code> | <code>Noto Sans CJK JP Bold</code> | <code>Noto Sans CJK JP Light</code> | <code>Noto Sans CJK JP Regular</code> </p> </li> </ul>', 'GetMapGlyphsResponse$ContentType' => '<p>The map glyph content type. For example, <code>application/octet-stream</code>.</p>', 'GetMapSpritesResponse$ContentType' => '<p>The content type of the sprite sheet and offsets. For example, the sprite sheet content type is <code>image/png</code>, and the sprite offset JSON document is <code>application/json</code>. </p>', 'GetMapStyleDescriptorResponse$ContentType' => '<p>The style descriptor\'s content type. For example, <code>application/json</code>.</p>', 'GetMapTileResponse$ContentType' => '<p>The map tile\'s content type. For example, <code>application/vnd.mapbox-vector-tile</code>.</p>', 'InternalServerException$Message' => NULL, 'ListGeofenceCollectionsResponseEntry$PricingPlanDataSource' => '<p>No longer used. Always returns an empty string.</p>', 'ListGeofenceResponseEntry$Status' => '<p>Identifies the state of the geofence. A geofence will hold one of the following states:</p> <ul> <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li> <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li> <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li> <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li> <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li> </ul>', 'ListMapsResponseEntry$DataSource' => '<p>Specifies the data provider for the associated map tiles.</p>', 'ListPlaceIndexesResponseEntry$DataSource' => '<p>The data provider of geospatial data. Values can be one of the following:</p> <ul> <li> <p> <code>Esri</code> </p> </li> <li> <p> <code>Here</code> </p> </li> </ul> <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>', 'ListRouteCalculatorsResponseEntry$DataSource' => '<p>The data provider of traffic and road network data. Indicates one of the available providers:</p> <ul> <li> <p> <code>Esri</code> </p> </li> <li> <p> <code>Here</code> </p> </li> </ul> <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>', 'ListTrackersResponseEntry$PricingPlanDataSource' => '<p>No longer used. Always returns an empty string.</p>', 'Place$AddressNumber' => '<p>The numerical portion of an address, such as a building number. </p>', 'Place$Country' => '<p>A country/region specified using <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country/region code. For example, <code>CAN</code>.</p>', 'Place$Label' => '<p>The full name and address of the point of interest such as a city, region, or country. For example, <code>123 Any Street, Any Town, USA</code>.</p>', 'Place$Municipality' => '<p>A name for a local area, such as a city or town name. For example, <code>Toronto</code>.</p>', 'Place$Neighborhood' => '<p>The name of a community district. For example, <code>Downtown</code>.</p>', 'Place$PostalCode' => '<p>A group of numbers and letters in a country-specific format, which accompanies the address for the purpose of identifying a location. </p>', 'Place$Region' => '<p>A name for an area or geographical division, such as a province or state name. For example, <code>British Columbia</code>.</p>', 'Place$Street' => '<p>The name for a street or a road to identify a location. For example, <code>Main Street</code>.</p>', 'Place$SubRegion' => '<p>A country, or an area that\'s part of a larger region. For example, <code>Metro Vancouver</code>.</p>', 'ResourceNotFoundException$Message' => NULL, 'RouteMatrixEntryError$Message' => '<p>A message about the error that occurred for the route calculation.</p>', 'SearchForSuggestionsResult$Text' => '<p>The text of the place suggestion, typically formatted as an address string.</p>', 'SearchPlaceIndexForPositionSummary$DataSource' => '<p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p> <ul> <li> <p>Esri</p> </li> <li> <p>Here</p> </li> </ul> <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>', 'SearchPlaceIndexForSuggestionsSummary$DataSource' => '<p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p> <ul> <li> <p>Esri</p> </li> <li> <p>Here</p> </li> </ul> <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>', 'SearchPlaceIndexForTextSummary$DataSource' => '<p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p> <ul> <li> <p>Esri</p> </li> <li> <p>Here</p> </li> </ul> <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>', 'ServiceQuotaExceededException$Message' => '<p>A message with the reason for the service quota exceeded exception error.</p>', 'TagKeys$member' => NULL, 'ThrottlingException$Message' => NULL, 'TimeZone$Name' => '<p>The name of the time zone, following the <a href="https://www.iana.org/time-zones"> IANA time zone standard</a>. For example, <code>America/Los_Angeles</code>.</p>', 'UpdateGeofenceCollectionRequest$PricingPlanDataSource' => '<p>This parameter is no longer used.</p>', 'UpdateTrackerRequest$PricingPlanDataSource' => '<p>This parameter is no longer used.</p>', 'ValidationException$Message' => NULL, 'ValidationExceptionField$Message' => '<p>A message with the reason for the validation exception error.</p>', 'ValidationExceptionField$Name' => '<p>The field name where the invalid entry was detected.</p>', ], ], 'SyntheticSearchPlaceIndexForSuggestionsRequestString' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForSuggestionsRequest$Text' => '<p>The free-form partial text to use to generate place suggestions. For example, <code>eiffel tow</code>.</p>', ], ], 'SyntheticSearchPlaceIndexForSuggestionsSummaryString' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForSuggestionsSummary$Text' => '<p>The free-form partial text input specified in the request.</p>', ], ], 'SyntheticSearchPlaceIndexForTextRequestString' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForTextRequest$Text' => '<p>The address, name, city, or region to be used in the search in free-form text format. For example, <code>123 Any Street</code>.</p>', ], ], 'SyntheticSearchPlaceIndexForTextSummaryString' => [ 'base' => NULL, 'refs' => [ 'SearchPlaceIndexForTextSummary$Text' => '<p>The search text specified in the request.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagMap$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of tag keys to remove from the specified resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateGeofenceCollectionRequest$Tags' => '<p>Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p> <p>Format: <code>"key" : "value"</code> </p> <p>Restrictions:</p> <ul> <li> <p>Maximum 50 tags per resource</p> </li> <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li> <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li> <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li> <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li> <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li> </ul>', 'CreateMapRequest$Tags' => '<p>Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p> <p>Format: <code>"key" : "value"</code> </p> <p>Restrictions:</p> <ul> <li> <p>Maximum 50 tags per resource</p> </li> <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li> <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li> <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li> <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li> <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li> </ul>', 'CreatePlaceIndexRequest$Tags' => '<p>Applies one or more tags to the place index resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p> <p>Format: <code>"key" : "value"</code> </p> <p>Restrictions:</p> <ul> <li> <p>Maximum 50 tags per resource.</p> </li> <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li> <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li> <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li> <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li> </ul>', 'CreateRouteCalculatorRequest$Tags' => '<p>Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p> <ul> <li> <p>For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>}</p> </li> </ul> <p>Format: <code>"key" : "value"</code> </p> <p>Restrictions:</p> <ul> <li> <p>Maximum 50 tags per resource</p> </li> <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li> <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li> <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li> <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li> <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li> </ul>', 'CreateTrackerRequest$Tags' => '<p>Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p> <p>Format: <code>"key" : "value"</code> </p> <p>Restrictions:</p> <ul> <li> <p>Maximum 50 tags per resource</p> </li> <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li> <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li> <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li> <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li> <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li> </ul>', 'DescribeGeofenceCollectionResponse$Tags' => '<p>Displays the key, value pairs of tags associated with this resource.</p>', 'DescribeMapResponse$Tags' => '<p>Tags associated with the map resource.</p>', 'DescribePlaceIndexResponse$Tags' => '<p>Tags associated with place index resource.</p>', 'DescribeRouteCalculatorResponse$Tags' => '<p>Tags associated with route calculator resource.</p>', 'DescribeTrackerResponse$Tags' => '<p>The tags associated with the tracker resource.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Tags that have been applied to the specified resource. Tags are mapped from the tag key to the tag value: <code>"TagKey" : "TagValue"</code>.</p> <ul> <li> <p>Format example: <code>{"tag1" : "value1", "tag2" : "value2"} </code> </p> </li> </ul>', 'TagResourceRequest$Tags' => '<p>Applies one or more tags to specific resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p> <p>Format: <code>"key" : "value"</code> </p> <p>Restrictions:</p> <ul> <li> <p>Maximum 50 tags per resource.</p> </li> <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li> <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li> <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li> <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li> </ul>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied because of request throttling.</p>', 'refs' => [], ], 'TimeZone' => [ 'base' => '<p>Information about a time zone. Includes the name of the time zone and the offset from UTC in seconds.</p>', 'refs' => [ 'Place$TimeZone' => '<p>The time zone in which the <code>Place</code> is located. Returned only when using Here as the selected partner.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'BatchEvaluateGeofencesError$SampleTime' => '<p>Specifies a timestamp for when the error occurred in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'BatchPutGeofenceSuccess$CreateTime' => '<p>The timestamp for when the geofence was stored in a geofence collection in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'BatchPutGeofenceSuccess$UpdateTime' => '<p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'BatchUpdateDevicePositionError$SampleTime' => '<p>The timestamp at which the device position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'CalculateRouteMatrixRequest$DepartureTime' => '<p>Specifies the desired time of departure. Uses the given time to calculate the route matrix. You can\'t set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p> <note> <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p> </note> <ul> <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li> </ul>', 'CalculateRouteRequest$DepartureTime' => '<p>Specifies the desired time of departure. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p> <note> <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p> </note> <ul> <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li> </ul>', 'CreateGeofenceCollectionResponse$CreateTime' => '<p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'CreateMapResponse$CreateTime' => '<p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>', 'CreatePlaceIndexResponse$CreateTime' => '<p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'CreateRouteCalculatorResponse$CreateTime' => '<p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p> <ul> <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li> </ul>', 'CreateTrackerResponse$CreateTime' => '<p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'DescribeGeofenceCollectionResponse$CreateTime' => '<p>The timestamp for when the geofence resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'DescribeGeofenceCollectionResponse$UpdateTime' => '<p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'DescribeMapResponse$CreateTime' => '<p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>', 'DescribeMapResponse$UpdateTime' => '<p>The timestamp for when the map resource was last update in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>', 'DescribePlaceIndexResponse$CreateTime' => '<p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'DescribePlaceIndexResponse$UpdateTime' => '<p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'DescribeRouteCalculatorResponse$CreateTime' => '<p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p> <ul> <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li> </ul>', 'DescribeRouteCalculatorResponse$UpdateTime' => '<p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p> <ul> <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li> </ul>', 'DescribeTrackerResponse$CreateTime' => '<p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'DescribeTrackerResponse$UpdateTime' => '<p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'DevicePosition$ReceivedTime' => '<p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'DevicePosition$SampleTime' => '<p>The timestamp at which the device\'s position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'DevicePositionUpdate$SampleTime' => '<p>The timestamp at which the device\'s position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'GetDevicePositionHistoryRequest$EndTimeExclusive' => '<p>Specify the end time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is made.</p> <p>Requirement:</p> <ul> <li> <p>The time specified for <code>EndTimeExclusive</code> must be after the time for <code>StartTimeInclusive</code>.</p> </li> </ul>', 'GetDevicePositionHistoryRequest$StartTimeInclusive' => '<p>Specify the start time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the request is made.</p> <p>Requirement:</p> <ul> <li> <p>The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.</p> </li> </ul>', 'GetDevicePositionResponse$ReceivedTime' => '<p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'GetDevicePositionResponse$SampleTime' => '<p>The timestamp at which the device\'s position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'GetGeofenceResponse$CreateTime' => '<p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'GetGeofenceResponse$UpdateTime' => '<p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'ListDevicePositionsResponseEntry$SampleTime' => '<p>The timestamp at which the device position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>', 'ListGeofenceCollectionsResponseEntry$CreateTime' => '<p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'ListGeofenceCollectionsResponseEntry$UpdateTime' => '<p>Specifies a timestamp for when the resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'ListGeofenceResponseEntry$CreateTime' => '<p>The timestamp for when the geofence was stored in a geofence collection in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'ListGeofenceResponseEntry$UpdateTime' => '<p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'ListMapsResponseEntry$CreateTime' => '<p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>', 'ListMapsResponseEntry$UpdateTime' => '<p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>', 'ListPlaceIndexesResponseEntry$CreateTime' => '<p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'ListPlaceIndexesResponseEntry$UpdateTime' => '<p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'ListRouteCalculatorsResponseEntry$CreateTime' => '<p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p> <ul> <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li> </ul>', 'ListRouteCalculatorsResponseEntry$UpdateTime' => '<p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p> <ul> <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li> </ul>', 'ListTrackersResponseEntry$CreateTime' => '<p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'ListTrackersResponseEntry$UpdateTime' => '<p>The timestamp at which the device\'s position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'PutGeofenceResponse$CreateTime' => '<p>The timestamp for when the geofence was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'PutGeofenceResponse$UpdateTime' => '<p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'UpdateGeofenceCollectionResponse$UpdateTime' => '<p>The time when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>', 'UpdateMapResponse$UpdateTime' => '<p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'UpdatePlaceIndexResponse$UpdateTime' => '<p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'UpdateRouteCalculatorResponse$UpdateTime' => '<p>The timestamp for when the route calculator was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', 'UpdateTrackerResponse$UpdateTime' => '<p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'GetDevicePositionHistoryRequest$NextToken' => '<p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p> <p>Default value: <code>null</code> </p>', 'GetDevicePositionHistoryResponse$NextToken' => '<p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>', 'ListDevicePositionsRequest$NextToken' => '<p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p> <p>Default value: <code>null</code> </p>', 'ListDevicePositionsResponse$NextToken' => '<p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>', 'ListGeofenceCollectionsRequest$NextToken' => '<p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p> <p>Default value: <code>null</code> </p>', 'ListGeofenceCollectionsResponse$NextToken' => '<p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>', 'ListGeofencesRequest$NextToken' => '<p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p> <p>Default value: <code>null</code> </p>', 'ListGeofencesResponse$NextToken' => '<p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>', 'ListMapsRequest$NextToken' => '<p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p> <p>Default value: <code>null</code> </p>', 'ListMapsResponse$NextToken' => '<p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>', 'ListPlaceIndexesRequest$NextToken' => '<p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p> <p>Default value: <code>null</code> </p>', 'ListPlaceIndexesResponse$NextToken' => '<p>A pagination token indicating that there are additional pages available. You can use the token in a new request to fetch the next page of results.</p>', 'ListRouteCalculatorsRequest$NextToken' => '<p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p> <p>Default Value: <code>null</code> </p>', 'ListRouteCalculatorsResponse$NextToken' => '<p>A pagination token indicating there are additional pages available. You can use the token in a subsequent request to fetch the next set of results.</p>', 'ListTrackerConsumersRequest$NextToken' => '<p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p> <p>Default value: <code>null</code> </p>', 'ListTrackerConsumersResponse$NextToken' => '<p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>', 'ListTrackersRequest$NextToken' => '<p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p> <p>Default value: <code>null</code> </p>', 'ListTrackersResponse$NextToken' => '<p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>', ], ], 'TravelMode' => [ 'base' => NULL, 'refs' => [ 'CalculateRouteMatrixRequest$TravelMode' => '<p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p> <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p> <ul> <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li> <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li> </ul> <p>Default Value: <code>Car</code> </p>', 'CalculateRouteRequest$TravelMode' => '<p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p> <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p> <ul> <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li> <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li> </ul> <p>Default Value: <code>Car</code> </p>', ], ], 'TruckDimensions' => [ 'base' => '<p>Contains details about the truck dimensions in the unit of measurement that you specify. Used to filter out roads that can\'t support or allow the specified dimensions for requests that specify <code>TravelMode</code> as <code>Truck</code>.</p>', 'refs' => [ 'CalculateRouteTruckModeOptions$Dimensions' => '<p>Specifies the truck\'s dimension specifications including length, height, width, and unit of measurement. Used to avoid roads that can\'t support the truck\'s dimensions.</p>', ], ], 'TruckDimensionsHeightDouble' => [ 'base' => NULL, 'refs' => [ 'TruckDimensions$Height' => '<p>The height of the truck.</p> <ul> <li> <p>For example, <code>4.5</code>.</p> </li> </ul>', ], ], 'TruckDimensionsLengthDouble' => [ 'base' => NULL, 'refs' => [ 'TruckDimensions$Length' => '<p>The length of the truck.</p> <ul> <li> <p>For example, <code>15.5</code>.</p> </li> </ul>', ], ], 'TruckDimensionsWidthDouble' => [ 'base' => NULL, 'refs' => [ 'TruckDimensions$Width' => '<p>The width of the truck.</p> <ul> <li> <p>For example, <code>4.5</code>.</p> </li> </ul>', ], ], 'TruckWeight' => [ 'base' => '<p>Contains details about the truck\'s weight specifications. Used to avoid roads that can\'t support or allow the total weight for requests that specify <code>TravelMode</code> as <code>Truck</code>.</p>', 'refs' => [ 'CalculateRouteTruckModeOptions$Weight' => '<p>Specifies the truck\'s weight specifications including total weight and unit of measurement. Used to avoid roads that can\'t support the truck\'s weight.</p>', ], ], 'TruckWeightTotalDouble' => [ 'base' => NULL, 'refs' => [ 'TruckWeight$Total' => '<p>The total weight of the truck. </p> <ul> <li> <p>For example, <code>3500</code>.</p> </li> </ul>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGeofenceCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGeofenceCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMapRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMapResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePlaceIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePlaceIndexResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRouteCalculatorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRouteCalculatorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrackerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrackerResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input failed to meet the constraints specified by the AWS service. </p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>The input failed to meet the constraints specified by the AWS service in a specified field. </p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$FieldList' => '<p>The field where the invalid entry was detected.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p>A message with the reason for the validation exception error.</p>', ], ], 'VehicleWeightUnit' => [ 'base' => NULL, 'refs' => [ 'TruckWeight$Unit' => '<p>The unit of measurement to use for the truck weight.</p> <p>Default Value: <code>Kilograms</code> </p>', ], ], ],];
