<?php
// This file was auto-generated from sdk-root/src/data/inspector2/2020-06-08/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Inspector is a vulnerability discovery service that automates continuous scanning for security vulnerabilities within your Amazon EC2 and Amazon ECR environments.</p>', 'operations' => [ 'AssociateMember' => '<p>Associates an Amazon Web Services account with an Amazon Inspector delegated administrator.</p>', 'BatchGetAccountStatus' => '<p>Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.</p>', 'BatchGetFreeTrialInfo' => '<p>Gets free trial status for multiple Amazon Web Services accounts.</p>', 'CancelFindingsReport' => '<p>Cancels the given findings report.</p>', 'CreateFilter' => '<p>Creates a filter resource using specified filter criteria.</p>', 'CreateFindingsReport' => '<p>Creates a finding report.</p>', 'DeleteFilter' => '<p>Deletes a filter resource.</p>', 'DescribeOrganizationConfiguration' => '<p>Describe Amazon Inspector configuration settings for an Amazon Web Services organization</p>', 'Disable' => '<p>Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.</p>', 'DisableDelegatedAdminAccount' => '<p>Disables the Amazon Inspector delegated administrator for your organization.</p>', 'DisassociateMember' => '<p>Disassociates a member account from an Amazon Inspector delegated administrator.</p>', 'Enable' => '<p>Enables Amazon Inspector scans for one or more Amazon Web Services accounts.</p>', 'EnableDelegatedAdminAccount' => '<p>Enables the Amazon Inspector delegated administrator for your Organizations organization.</p>', 'GetDelegatedAdminAccount' => '<p>Retrieves information about the Amazon Inspector delegated administrator for your organization.</p>', 'GetFindingsReportStatus' => '<p>Gets the status of a findings report.</p>', 'GetMember' => '<p>Gets member information for your organization.</p>', 'ListAccountPermissions' => '<p>Lists the permissions an account has to configure Amazon Inspector.</p>', 'ListCoverage' => '<p>Lists coverage details for you environment.</p>', 'ListCoverageStatistics' => '<p>Lists Amazon Inspector coverage statistics for your environment.</p>', 'ListDelegatedAdminAccounts' => '<p>Lists information about the Amazon Inspector delegated administrator of your organization.</p>', 'ListFilters' => '<p>Lists the filters associated with your account.</p>', 'ListFindingAggregations' => '<p>Lists aggregated finding data for your environment based on specific criteria.</p>', 'ListFindings' => '<p>Lists findings for your environment.</p>', 'ListMembers' => '<p>List members associated with the Amazon Inspector delegated administrator for your organization.</p>', 'ListTagsForResource' => '<p>Lists all tags attached to a given resource.</p>', 'ListUsageTotals' => '<p>Lists the Amazon Inspector usage totals over the last 30 days.</p>', 'TagResource' => '<p>Adds tags to a resource.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p>', 'UpdateFilter' => '<p>Specifies the action that is to be applied to the findings that match the filter.</p>', 'UpdateOrganizationConfiguration' => '<p>Updates the configurations for your Amazon Inspector organization.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'Account' => [ 'base' => '<p>An Amazon Web Services account within your environment that Amazon Inspector has been enabled for.</p>', 'refs' => [ 'AccountList$member' => NULL, ], ], 'AccountAggregation' => [ 'base' => '<p>An object that contains details about an aggregation response based on Amazon Web Services accounts.</p>', 'refs' => [ 'AggregationRequest$accountAggregation' => '<p>An object that contains details about an aggregation request based on Amazon Web Services account IDs.</p>', ], ], 'AccountAggregationResponse' => [ 'base' => '<p>An aggregation of findings by Amazon Web Services account ID.</p>', 'refs' => [ 'AggregationResponse$accountAggregation' => '<p>An object that contains details about an aggregation response based on Amazon Web Services account IDs.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'Account$accountId' => '<p>The ID of the Amazon Web Services account.</p>', 'AccountAggregationResponse$accountId' => '<p>The Amazon Web Services account ID.</p>', 'AccountIdSet$member' => NULL, 'AccountState$accountId' => '<p>The Amazon Web Services account ID.</p>', 'AmiAggregationResponse$accountId' => '<p>The Amazon Web Services account ID that the AMI belongs.</p>', 'AssociateMemberRequest$accountId' => '<p>The Amazon Web Services account ID of the member account to be associated.</p>', 'AssociateMemberResponse$accountId' => '<p>The Amazon Web Services account ID of the successfully associated member account.</p>', 'AwsEcrContainerAggregationResponse$accountId' => '<p>The Amazon Web Services account ID of the account that owns the container.</p>', 'CoveredResource$accountId' => '<p>The Amazon Web Services account ID of the covered resource.</p>', 'DelegatedAdmin$accountId' => '<p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>', 'DelegatedAdminAccount$accountId' => '<p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>', 'DisableDelegatedAdminAccountRequest$delegatedAdminAccountId' => '<p>The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.</p>', 'DisableDelegatedAdminAccountResponse$delegatedAdminAccountId' => '<p>The Amazon Web Services account ID of the successfully disabled delegated administrator.</p>', 'DisassociateMemberRequest$accountId' => '<p>The Amazon Web Services account ID of the member account to disassociate.</p>', 'DisassociateMemberResponse$accountId' => '<p>The Amazon Web Services account ID of the successfully disassociated member.</p>', 'EnableDelegatedAdminAccountRequest$delegatedAdminAccountId' => '<p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>', 'EnableDelegatedAdminAccountResponse$delegatedAdminAccountId' => '<p>The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.</p>', 'FailedAccount$accountId' => '<p>The Amazon Web Services account ID.</p>', 'Finding$awsAccountId' => '<p>The Amazon Web Services account ID associated with the finding.</p>', 'FindingTypeAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account associated with the findings.</p>', 'GetMemberRequest$accountId' => '<p>The Amazon Web Services account ID of the member account to retrieve information on.</p>', 'ImageLayerAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account that owns the container image hosting the layer image.</p>', 'Member$accountId' => '<p>The Amazon Web Services account ID of the member account.</p>', 'Member$delegatedAdminAccountId' => '<p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for this member account.</p>', 'PackageAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account associated with the findings.</p>', 'RepositoryAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account associated with the findings.</p>', 'TitleAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account associated with the findings.</p>', ], ], 'AccountIdSet' => [ 'base' => NULL, 'refs' => [ 'BatchGetAccountStatusRequest$accountIds' => '<p>The 12-digit Amazon Web Services account IDs of the accounts to retrieve Amazon Inspector status for.</p>', 'DisableRequest$accountIds' => '<p>An array of account IDs you want to disable Amazon Inspector scans for.</p>', 'EnableRequest$accountIds' => '<p>A list of account IDs you want to enable Amazon Inspector scans for.</p>', ], ], 'AccountList' => [ 'base' => NULL, 'refs' => [ 'DisableResponse$accounts' => '<p>Information on the accounts that have had Amazon Inspector scans successfully disabled. Details are provided for each account.</p>', 'EnableResponse$accounts' => '<p>Information on the accounts that have had Amazon Inspector scans successfully enabled. Details are provided for each account.</p>', ], ], 'AccountSortBy' => [ 'base' => NULL, 'refs' => [ 'AccountAggregation$sortBy' => '<p>The value to sort by.</p>', ], ], 'AccountState' => [ 'base' => '<p>An object with details the status of an Amazon Web Services account within your Amazon Inspector environment</p>', 'refs' => [ 'AccountStateList$member' => NULL, ], ], 'AccountStateList' => [ 'base' => NULL, 'refs' => [ 'BatchGetAccountStatusResponse$accounts' => '<p>An array of objects that provide details on the status of Amazon Inspector for each of the requested accounts.</p>', ], ], 'AggCounts' => [ 'base' => NULL, 'refs' => [ 'Counts$count' => '<p>The number of resources.</p>', ], ], 'AggregationFindingType' => [ 'base' => NULL, 'refs' => [ 'AccountAggregation$findingType' => '<p>The type of finding.</p>', 'FindingTypeAggregation$findingType' => '<p>The finding type to aggregate.</p>', ], ], 'AggregationRequest' => [ 'base' => '<p>Contains details about an aggregation request.</p>', 'refs' => [ 'ListFindingAggregationsRequest$aggregationRequest' => '<p>Details of the aggregation request that is used to filter your aggregation results.</p>', ], ], 'AggregationResourceType' => [ 'base' => NULL, 'refs' => [ 'AccountAggregation$resourceType' => '<p>The type of resource.</p>', 'FindingTypeAggregation$resourceType' => '<p>The resource type to aggregate.</p>', 'TitleAggregation$resourceType' => '<p>The resource type to aggregate on.</p>', ], ], 'AggregationResponse' => [ 'base' => '<p>A structure that contains details about the results of an aggregation type.</p>', 'refs' => [ 'AggregationResponseList$member' => NULL, ], ], 'AggregationResponseList' => [ 'base' => NULL, 'refs' => [ 'ListFindingAggregationsResponse$responses' => '<p>Objects that contain the results of an aggregation operation.</p>', ], ], 'AggregationType' => [ 'base' => NULL, 'refs' => [ 'ListFindingAggregationsRequest$aggregationType' => '<p>The type of the aggregation request.</p>', 'ListFindingAggregationsResponse$aggregationType' => '<p>The type of aggregation to perform.</p>', ], ], 'AmiAggregation' => [ 'base' => '<p>The details that define an aggregation based on Amazon machine images (AMIs).</p>', 'refs' => [ 'AggregationRequest$amiAggregation' => '<p>An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).</p>', ], ], 'AmiAggregationResponse' => [ 'base' => '<p>A response that contains the results of a finding aggregation by AMI.</p>', 'refs' => [ 'AggregationResponse$amiAggregation' => '<p>An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).</p>', ], ], 'AmiId' => [ 'base' => NULL, 'refs' => [ 'AmiAggregationResponse$ami' => '<p>The ID of the AMI that findings were aggregated for.</p>', 'Ec2InstanceAggregationResponse$ami' => '<p>The Amazon Machine Image (AMI) of the Amazon EC2 instance.</p>', 'Ec2Metadata$amiId' => '<p>The ID of the Amazon Machine Image (AMI) used to launch the instance.</p>', ], ], 'AmiSortBy' => [ 'base' => NULL, 'refs' => [ 'AmiAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon resource number (ARN) of the resource to list tags of.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to apply a tag to.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>', ], ], 'AssociateMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'AutoEnable' => [ 'base' => '<p>Represents which scan types are automatically enabled for new members of your Amazon Inspector organization.</p>', 'refs' => [ 'DescribeOrganizationConfigurationResponse$autoEnable' => '<p>The scan types are automatically enabled for new members of your organization.</p>', 'UpdateOrganizationConfigurationRequest$autoEnable' => '<p>Defines which scan types are enabled automatically for new members of your Amazon Inspector organization.</p>', 'UpdateOrganizationConfigurationResponse$autoEnable' => '<p>The updated status of scan types automatically enabled for new members of your Amazon Inspector organization.</p>', ], ], 'AwsEc2InstanceDetails' => [ 'base' => '<p>Details of the Amazon EC2 instance involved in a finding.</p>', 'refs' => [ 'ResourceDetails$awsEc2Instance' => '<p>An object that contains details about the Amazon EC2 instance involved in the finding.</p>', ], ], 'AwsEcrContainerAggregation' => [ 'base' => '<p>An aggregation of information about Amazon ECR containers.</p>', 'refs' => [ 'AggregationRequest$awsEcrContainerAggregation' => '<p>An object that contains details about an aggregation request based on Amazon ECR container images.</p>', ], ], 'AwsEcrContainerAggregationResponse' => [ 'base' => '<p>An aggregation of information about Amazon ECR containers.</p>', 'refs' => [ 'AggregationResponse$awsEcrContainerAggregation' => '<p>An object that contains details about an aggregation response based on Amazon ECR container images.</p>', ], ], 'AwsEcrContainerImageDetails' => [ 'base' => '<p>The image details of the Amazon ECR container image.</p>', 'refs' => [ 'ResourceDetails$awsEcrContainerImage' => '<p>An object that contains details about the Amazon ECR container image involved in the finding.</p>', ], ], 'AwsEcrContainerSortBy' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerAggregation$sortBy' => '<p>The value to sort by.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>One or more tags submitted as part of the request is not valid.</p>', 'refs' => [], ], 'BatchGetAccountStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAccountStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFreeTrialInfoRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFreeTrialInfoRequestAccountIdsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFreeTrialInfoRequest$accountIds' => '<p>The account IDs to get free trial status for.</p>', ], ], 'BatchGetFreeTrialInfoResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AutoEnable$ec2' => '<p>Represents whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector organization.</p>', 'AutoEnable$ecr' => '<p>Represents whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector organization.</p>', 'DescribeOrganizationConfigurationResponse$maxAccountLimitReached' => '<p>Represents whether your organization has reached the maximum Amazon Web Services account limit for Amazon Inspector.</p>', 'ListMembersRequest$onlyAssociated' => '<p>Specifies whether to list only currently associated members if <code>True</code> or to list all members within the organization if <code>False</code>.</p>', ], ], 'CancelFindingsReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelFindingsReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'EnableDelegatedAdminAccountRequest$clientToken' => '<p>The idempotency token for the request.</p>', 'EnableRequest$clientToken' => '<p>The idempotency token for the request.</p>', ], ], 'Component' => [ 'base' => NULL, 'refs' => [ 'Step$componentId' => '<p>The component ID.</p>', ], ], 'ComponentType' => [ 'base' => NULL, 'refs' => [ 'Step$componentType' => '<p>The component type.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A conflict occurred.</p>', 'refs' => [], ], 'Counts' => [ 'base' => '<p>a structure that contains information on the count of resources within a group.</p>', 'refs' => [ 'CountsList$member' => NULL, ], ], 'CountsList' => [ 'base' => NULL, 'refs' => [ 'ListCoverageStatisticsResponse$countsByGroup' => '<p>An array with the number for each group.</p>', ], ], 'CoverageFilterCriteria' => [ 'base' => '<p>A structure that identifies filter criteria for <code>GetCoverageStatistics</code>.</p>', 'refs' => [ 'ListCoverageRequest$filterCriteria' => '<p>An object that contains details on the filters to apply to the coverage data for your environment.</p>', 'ListCoverageStatisticsRequest$filterCriteria' => '<p>An object that contains details on the filters to apply to the coverage data for your environment.</p>', ], ], 'CoverageMapComparison' => [ 'base' => NULL, 'refs' => [ 'CoverageMapFilter$comparison' => '<p>The operator to compare coverage on.</p>', ], ], 'CoverageMapFilter' => [ 'base' => '<p>Contains details of a coverage map filter.</p>', 'refs' => [ 'CoverageMapFilterList$member' => NULL, ], ], 'CoverageMapFilterList' => [ 'base' => NULL, 'refs' => [ 'CoverageFilterCriteria$ec2InstanceTags' => '<p>The Amazon EC2 instance tags to filter on.</p>', ], ], 'CoverageResourceType' => [ 'base' => NULL, 'refs' => [ 'CoveredResource$resourceType' => '<p>The type of the covered resource.</p>', ], ], 'CoverageStringComparison' => [ 'base' => NULL, 'refs' => [ 'CoverageStringFilter$comparison' => '<p>The operator to compare strings on.</p>', ], ], 'CoverageStringFilter' => [ 'base' => '<p>Contains details of a coverage string filter.</p>', 'refs' => [ 'CoverageStringFilterList$member' => NULL, ], ], 'CoverageStringFilterList' => [ 'base' => NULL, 'refs' => [ 'CoverageFilterCriteria$accountId' => '<p>An array of Amazon Web Services account IDs to return coverage statistics for.</p>', 'CoverageFilterCriteria$ecrImageTags' => '<p>The Amazon ECR image tags to filter on.</p>', 'CoverageFilterCriteria$ecrRepositoryName' => '<p>The Amazon ECR repository name to filter on.</p>', 'CoverageFilterCriteria$resourceId' => '<p>An array of Amazon Web Services resource IDs to return coverage statistics for.</p>', 'CoverageFilterCriteria$resourceType' => '<p>An array of Amazon Web Services resource types to return coverage statistics for.</p>', 'CoverageFilterCriteria$scanStatusCode' => '<p>The scan status code to filter on.</p>', 'CoverageFilterCriteria$scanStatusReason' => '<p>The scan status reason to filter on.</p>', 'CoverageFilterCriteria$scanType' => '<p>An array of Amazon Inspector scan types to return coverage statistics for.</p>', ], ], 'CoverageStringInput' => [ 'base' => NULL, 'refs' => [ 'CoverageStringFilter$value' => '<p>The value to compare strings on.</p>', ], ], 'CoveredResource' => [ 'base' => '<p>An object that contains details about a resource covered by Amazon Inspector.</p>', 'refs' => [ 'CoveredResources$member' => NULL, ], ], 'CoveredResources' => [ 'base' => NULL, 'refs' => [ 'ListCoverageResponse$coveredResources' => '<p>An object that contains details on the covered resources in your environment.</p>', ], ], 'CreateFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFindingsReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFindingsReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'Currency' => [ 'base' => NULL, 'refs' => [ 'Usage$currency' => '<p>The currency type used when calculating usage data.</p>', ], ], 'CvssScore' => [ 'base' => '<p>The CVSS score for a finding.</p>', 'refs' => [ 'CvssScoreList$member' => NULL, ], ], 'CvssScoreAdjustment' => [ 'base' => '<p>Details on adjustments Amazon Inspector made to the CVSS score for a finding.</p>', 'refs' => [ 'CvssScoreAdjustmentList$member' => NULL, ], ], 'CvssScoreAdjustmentList' => [ 'base' => NULL, 'refs' => [ 'CvssScoreDetails$adjustments' => '<p>An object that contains details about adjustment Amazon Inspector made to the CVSS score.</p>', ], ], 'CvssScoreDetails' => [ 'base' => '<p>Information about the CVSS score.</p>', 'refs' => [ 'InspectorScoreDetails$adjustedCvss' => '<p>An object that contains details about the CVSS score given to a finding.</p>', ], ], 'CvssScoreList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$cvss' => '<p>An object that contains details about the CVSS score of a finding.</p>', ], ], 'DateFilter' => [ 'base' => '<p>Contains details on the time range used to filter findings.</p>', 'refs' => [ 'DateFilterList$member' => NULL, ], ], 'DateFilterList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$ecrImagePushedAt' => '<p>Details on the Amazon ECR image push date and time used to filter findings.</p>', 'FilterCriteria$firstObservedAt' => '<p>Details on the date and time a finding was first seen used to filter findings.</p>', 'FilterCriteria$lastObservedAt' => '<p>Details on the date and time a finding was last seen used to filter findings.</p>', 'FilterCriteria$updatedAt' => '<p>Details on the date and time a finding was last updated at used to filter findings.</p>', ], ], 'DateTimeTimestamp' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$launchedAt' => '<p>The date and time the Amazon EC2 instance was launched at.</p>', 'AwsEcrContainerImageDetails$pushedAt' => '<p>The date and time the Amazon ECR container image was pushed.</p>', 'Filter$createdAt' => '<p>The date and time this filter was created at.</p>', 'Filter$updatedAt' => '<p>The date and time the filter was last updated at.</p>', 'Finding$firstObservedAt' => '<p>The date and time that the finding was first observed.</p>', 'Finding$lastObservedAt' => '<p>The date and time that the finding was last observed.</p>', 'Finding$updatedAt' => '<p>The date and time the finding was last updated at.</p>', 'Member$updatedAt' => '<p>A timestamp showing when the status of this member was last updated.</p>', 'PackageVulnerabilityDetails$vendorCreatedAt' => '<p>The date and time that this vulnerability was first added to the vendor\'s database.</p>', 'PackageVulnerabilityDetails$vendorUpdatedAt' => '<p>The date and time the vendor last updated this vulnerability in their database.</p>', ], ], 'DelegatedAdmin' => [ 'base' => '<p>Details of the Amazon Inspector delegated administrator for your organization.</p>', 'refs' => [ 'GetDelegatedAdminAccountResponse$delegatedAdmin' => '<p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>', ], ], 'DelegatedAdminAccount' => [ 'base' => '<p>Details of the Amazon Inspector delegated administrator for your organization.</p>', 'refs' => [ 'DelegatedAdminAccountList$member' => NULL, ], ], 'DelegatedAdminAccountList' => [ 'base' => NULL, 'refs' => [ 'ListDelegatedAdminAccountsResponse$delegatedAdminAccounts' => '<p>Details of the Amazon Inspector delegated administrator of your organization.</p>', ], ], 'DelegatedAdminStatus' => [ 'base' => NULL, 'refs' => [ 'DelegatedAdminAccount$status' => '<p>The status of the Amazon Inspector delegated administrator.</p>', ], ], 'DeleteFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Destination' => [ 'base' => '<p>Contains details of the Amazon S3 bucket and KMS key used to export findings.</p>', 'refs' => [ 'CreateFindingsReportRequest$s3Destination' => '<p>The Amazon S3 export destination for the report.</p>', 'GetFindingsReportStatusResponse$destination' => '<p>The destination of the report.</p>', ], ], 'DisableDelegatedAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableDelegatedAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'DisableRequest$resourceTypes' => '<p>The resource scan types you want to disable.</p>', ], ], 'DisableResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'CvssScore$baseScore' => '<p>The base CVSS score used for the finding.</p>', 'CvssScoreDetails$score' => '<p>The CVSS score.</p>', 'Finding$inspectorScore' => '<p>The Amazon Inspector score given to the finding.</p>', 'NumberFilter$lowerInclusive' => '<p>The lowest number to be included in the filter.</p>', 'NumberFilter$upperInclusive' => '<p>The highest number to be included in the filter.</p>', ], ], 'Ec2InstanceAggregation' => [ 'base' => '<p>The details that define an aggregation based on Amazon EC2 instances.</p>', 'refs' => [ 'AggregationRequest$ec2InstanceAggregation' => '<p>An object that contains details about an aggregation request based on Amazon EC2 instances.</p>', ], ], 'Ec2InstanceAggregationResponse' => [ 'base' => '<p>A response that contains the results of a finding aggregation by Amazon EC2 instance.</p>', 'refs' => [ 'AggregationResponse$ec2InstanceAggregation' => '<p>An object that contains details about an aggregation response based on Amazon EC2 instances.</p>', ], ], 'Ec2InstanceSortBy' => [ 'base' => NULL, 'refs' => [ 'Ec2InstanceAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'Ec2Metadata' => [ 'base' => '<p>Meta data details of an Amazon EC2 instance.</p>', 'refs' => [ 'ResourceScanMetadata$ec2' => '<p>An object that contains metadata details for an Amazon EC2 instance.</p>', ], ], 'Ec2Platform' => [ 'base' => NULL, 'refs' => [ 'Ec2Metadata$platform' => '<p>The platform of the instance.</p>', ], ], 'EcrContainerImageMetadata' => [ 'base' => '<p>Information on the Amazon ECR image metadata associated with a finding.</p>', 'refs' => [ 'ResourceScanMetadata$ecrImage' => '<p>An object that contains details about the container metadata for an Amazon ECR image.</p>', ], ], 'EcrRepositoryMetadata' => [ 'base' => '<p>Information on the Amazon ECR repository metadata associated with a finding.</p>', 'refs' => [ 'ResourceScanMetadata$ecrRepository' => '<p>An object that contains details about the repository an Amazon ECR image resides in.</p>', ], ], 'EcrScanFrequency' => [ 'base' => NULL, 'refs' => [ 'EcrRepositoryMetadata$scanFrequency' => '<p>The frequency of scans.</p>', ], ], 'EnableDelegatedAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableDelegatedAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnableRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'EnableRequest$resourceTypes' => '<p>The resource scan types you want to enable.</p>', ], ], 'EnableResponse' => [ 'base' => NULL, 'refs' => [], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'FailedAccount$errorCode' => '<p>The error code explaining why the account failed to enable Amazon Inspector.</p>', 'State$errorCode' => '<p>The error code explaining why the account failed to enable Amazon Inspector.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'GetFindingsReportStatusResponse$errorMessage' => '<p>The error message of the report.</p>', ], ], 'ExternalReportStatus' => [ 'base' => NULL, 'refs' => [ 'GetFindingsReportStatusResponse$status' => '<p>The status of the report.</p>', ], ], 'FailedAccount' => [ 'base' => '<p>An object with details on why an account failed to enable Amazon Inspector.</p>', 'refs' => [ 'FailedAccountList$member' => NULL, ], ], 'FailedAccountList' => [ 'base' => NULL, 'refs' => [ 'BatchGetAccountStatusResponse$failedAccounts' => '<p>An array of objects detailing any accounts that failed to enable Amazon Inspector and why.</p>', 'DisableResponse$failedAccounts' => '<p>Information on any accounts for which Amazon Inspector scans could not be disabled. Details are provided for each account.</p>', 'EnableResponse$failedAccounts' => '<p>Information on any accounts for which Amazon Inspector scans could not be enabled. Details are provided for each account.</p>', ], ], 'FilePath' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$filePath' => '<p>The file path of the vulnerable package.</p>', ], ], 'Filter' => [ 'base' => '<p>Details about a filter.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterAction' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$action' => '<p>Defines the action that is to be applied to the findings that match the filter.</p>', 'Filter$action' => '<p>The action that is to be applied to the findings that match the filter.</p>', 'ListFiltersRequest$action' => '<p>The action the filter applies to matched findings.</p>', 'UpdateFilterRequest$action' => '<p>Specifies the action that is to be applied to the findings that match the filter.</p>', ], ], 'FilterArn' => [ 'base' => NULL, 'refs' => [ 'CreateFilterResponse$arn' => '<p>The Amazon Resource Number (ARN) of the successfully created filter.</p>', 'DeleteFilterRequest$arn' => '<p>The Amazon Resource Number (ARN) of the filter to be deleted.</p>', 'DeleteFilterResponse$arn' => '<p>The Amazon Resource Number (ARN) of the filter that has been deleted.</p>', 'Filter$arn' => '<p>The Amazon Resource Number (ARN) associated with this filter.</p>', 'FilterArnList$member' => NULL, 'UpdateFilterRequest$filterArn' => '<p>The Amazon Resource Number (ARN) of the filter to update.</p>', 'UpdateFilterResponse$arn' => '<p>The Amazon Resource Number (ARN) of the successfully updated filter.</p>', ], ], 'FilterArnList' => [ 'base' => NULL, 'refs' => [ 'ListFiltersRequest$arns' => '<p>The Amazon resource number (ARN) of the filter.</p>', ], ], 'FilterCriteria' => [ 'base' => '<p>Details on the criteria used to define the filter.</p>', 'refs' => [ 'CreateFilterRequest$filterCriteria' => '<p>Defines the criteria to be used in the filter for querying findings.</p>', 'CreateFindingsReportRequest$filterCriteria' => '<p>The filter criteria to apply to the results of the finding report.</p>', 'Filter$criteria' => '<p>Details on the filter criteria associated with this filter.</p>', 'GetFindingsReportStatusResponse$filterCriteria' => '<p>The filter criteria associated with the report.</p>', 'ListFindingsRequest$filterCriteria' => '<p>Details on the filters to apply to your finding results.</p>', 'UpdateFilterRequest$filterCriteria' => '<p>Defines the criteria to be update in the filter.</p>', ], ], 'FilterDescription' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$description' => '<p>A description of the filter.</p>', 'Filter$description' => '<p>A description of the filter.</p>', 'UpdateFilterRequest$description' => '<p>A description of the filter.</p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'ListFiltersResponse$filters' => '<p>Contains details on the filters associated with your account.</p>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$name' => '<p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>', 'Filter$name' => '<p>The name of the filter.</p>', 'UpdateFilterRequest$name' => '<p>The name of the filter.</p>', ], ], 'FilterReason' => [ 'base' => NULL, 'refs' => [ 'Filter$reason' => '<p>The reason for the filter.</p>', ], ], 'Finding' => [ 'base' => '<p>Details about an Amazon Inspector finding.</p>', 'refs' => [ 'FindingList$member' => NULL, ], ], 'FindingArn' => [ 'base' => NULL, 'refs' => [ 'Finding$findingArn' => '<p>The Amazon Resource Number (ARN) of the finding.</p>', ], ], 'FindingDescription' => [ 'base' => NULL, 'refs' => [ 'Finding$description' => '<p>The description of the finding.</p>', ], ], 'FindingList' => [ 'base' => NULL, 'refs' => [ 'ListFindingsResponse$findings' => '<p>Contains details on the findings in your environment.</p>', ], ], 'FindingStatus' => [ 'base' => NULL, 'refs' => [ 'Finding$status' => '<p>The status of the finding.</p>', ], ], 'FindingTitle' => [ 'base' => NULL, 'refs' => [ 'Finding$title' => '<p>The title of the finding.</p>', ], ], 'FindingType' => [ 'base' => NULL, 'refs' => [ 'Finding$type' => '<p>The type of the finding.</p>', ], ], 'FindingTypeAggregation' => [ 'base' => '<p>The details that define an aggregation based on finding type.</p>', 'refs' => [ 'AggregationRequest$findingTypeAggregation' => '<p>An object that contains details about an aggregation request based on finding types.</p>', ], ], 'FindingTypeAggregationResponse' => [ 'base' => '<p>A response that contains the results of a finding type aggregation.</p>', 'refs' => [ 'AggregationResponse$findingTypeAggregation' => '<p>An object that contains details about an aggregation response based on finding types.</p>', ], ], 'FindingTypeSortBy' => [ 'base' => NULL, 'refs' => [ 'FindingTypeAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'FreeTrialAccountInfo' => [ 'base' => '<p>Information about the Amazon Inspector free trial for an account.</p>', 'refs' => [ 'FreeTrialAccountInfoList$member' => NULL, ], ], 'FreeTrialAccountInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFreeTrialInfoResponse$accounts' => '<p>An array of objects that provide Amazon Inspector free trial details for each of the requested accounts. </p>', ], ], 'FreeTrialInfo' => [ 'base' => '<p>An object that contains information about the Amazon Inspector free trial for an account.</p>', 'refs' => [ 'FreeTrialInfoList$member' => NULL, ], ], 'FreeTrialInfoError' => [ 'base' => '<p>Information about an error received while accessing free trail data for an account.</p>', 'refs' => [ 'FreeTrialInfoErrorList$member' => NULL, ], ], 'FreeTrialInfoErrorCode' => [ 'base' => NULL, 'refs' => [ 'FreeTrialInfoError$code' => '<p>The error code.</p>', ], ], 'FreeTrialInfoErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFreeTrialInfoResponse$failedAccounts' => '<p>An array of objects detailing any accounts that free trial data could not be returned for.</p>', ], ], 'FreeTrialInfoList' => [ 'base' => NULL, 'refs' => [ 'FreeTrialAccountInfo$freeTrialInfo' => '<p>Contains information about the Amazon Inspector free trial for an account.</p>', ], ], 'FreeTrialStatus' => [ 'base' => NULL, 'refs' => [ 'FreeTrialInfo$status' => '<p>The order to sort results by.</p>', ], ], 'FreeTrialType' => [ 'base' => NULL, 'refs' => [ 'FreeTrialInfo$type' => '<p>The type of scan covered by the Amazon Inspector free trail.</p>', ], ], 'GetDelegatedAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDelegatedAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsReportStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsReportStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroupKey' => [ 'base' => NULL, 'refs' => [ 'Counts$groupKey' => '<p>The key associated with this group</p>', 'ListCoverageStatisticsRequest$groupBy' => '<p>The value to group the results by.</p>', ], ], 'ImageHash' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$imageHash' => '<p>The image hash of the Amazon ECR container image.</p>', ], ], 'ImageLayerAggregation' => [ 'base' => '<p>The details that define an aggregation based on container image layers.</p>', 'refs' => [ 'AggregationRequest$imageLayerAggregation' => '<p>An object that contains details about an aggregation request based on container image layers.</p>', ], ], 'ImageLayerAggregationResponse' => [ 'base' => '<p>A response that contains the results of a finding aggregation by image layer.</p>', 'refs' => [ 'AggregationResponse$imageLayerAggregation' => '<p>An object that contains details about an aggregation response based on container image layers.</p>', ], ], 'ImageLayerSortBy' => [ 'base' => NULL, 'refs' => [ 'ImageLayerAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'ImageTagList' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$imageTags' => '<p>The image tags attached to the Amazon ECR container image.</p>', ], ], 'InspectorScoreDetails' => [ 'base' => '<p>Information about the Amazon Inspector score given to a finding.</p>', 'refs' => [ 'Finding$inspectorScoreDetails' => '<p>An object that contains details of the Amazon Inspector score.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the request.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request has failed due to an internal failure of the Amazon Inspector service.</p>', 'refs' => [], ], 'IpV4Address' => [ 'base' => NULL, 'refs' => [ 'IpV4AddressList$member' => NULL, ], ], 'IpV4AddressList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$ipV4Addresses' => '<p>The IPv4 addresses of the Amazon EC2 instance.</p>', ], ], 'IpV6Address' => [ 'base' => NULL, 'refs' => [ 'IpV6AddressList$member' => NULL, ], ], 'IpV6AddressList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$ipV6Addresses' => '<p>The IPv6 addresses of the Amazon EC2 instance.</p>', ], ], 'ListAccountPermissionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccountPermissionsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'ListAccountPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCoverageMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCoverageRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'ListCoverageRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCoverageResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCoverageStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCoverageStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDelegatedAdminAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDelegatedAdminAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDelegatedAdminMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDelegatedAdminAccountsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'ListFilterMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFiltersRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'ListFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFiltersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingAggregationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFindingAggregationsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'ListFindingAggregationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingAggregationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFindingsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'ListFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListMembersRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'ListMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsageTotalsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListUsageTotalsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', ], ], 'ListUsageTotalsNextToken' => [ 'base' => NULL, 'refs' => [ 'ListUsageTotalsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListUsageTotalsResponse$nextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', ], ], 'ListUsageTotalsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsageTotalsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AmiAggregationResponse$affectedInstances' => '<p>The IDs of Amazon EC2 instances using this AMI.</p>', 'Ec2InstanceAggregationResponse$networkFindings' => '<p>The number of network findings for the Amazon EC2 instance.</p>', 'ListCoverageStatisticsResponse$totalCounts' => '<p>The total number for all groups.</p>', 'RepositoryAggregationResponse$affectedImages' => '<p>The number of container images impacted by the findings.</p>', 'SeverityCounts$all' => '<p>The total count of findings from all severities.</p>', 'SeverityCounts$critical' => '<p>The total count of critical severity findings.</p>', 'SeverityCounts$high' => '<p>The total count of high severity findings.</p>', 'SeverityCounts$medium' => '<p>The total count of medium severity findings.</p>', ], ], 'MapComparison' => [ 'base' => NULL, 'refs' => [ 'MapFilter$comparison' => '<p>The operator to use when comparing values in the filter.</p>', ], ], 'MapFilter' => [ 'base' => '<p>An object that describes details of a map filter.</p>', 'refs' => [ 'MapFilterList$member' => NULL, ], ], 'MapFilterList' => [ 'base' => NULL, 'refs' => [ 'Ec2InstanceAggregation$instanceTags' => '<p>The Amazon EC2 instance tags to aggregate findings for.</p>', 'FilterCriteria$resourceTags' => '<p>Details on the resource tags used to filter findings.</p>', ], ], 'MapKey' => [ 'base' => NULL, 'refs' => [ 'MapFilter$key' => '<p>The tag key used in the filter.</p>', 'TagMap$key' => NULL, ], ], 'MapValue' => [ 'base' => NULL, 'refs' => [ 'MapFilter$value' => '<p>The tag value used in the filter.</p>', 'TagMap$value' => NULL, ], ], 'Member' => [ 'base' => '<p>Details on a member account in your organization.</p>', 'refs' => [ 'GetMemberResponse$member' => '<p>Details of the retrieved member account.</p>', 'MemberList$member' => NULL, ], ], 'MemberList' => [ 'base' => NULL, 'refs' => [ 'ListMembersResponse$members' => '<p>An object that contains details for each member account.</p>', ], ], 'MeteringAccountId' => [ 'base' => NULL, 'refs' => [ 'BatchGetFreeTrialInfoRequestAccountIdsList$member' => NULL, 'FreeTrialAccountInfo$accountId' => '<p>The account associated with the Amazon Inspector free trial information.</p>', 'FreeTrialInfoError$accountId' => '<p>The account associated with the Amazon Inspector free trial information.</p>', 'UsageTotal$accountId' => '<p>The account ID of the account that usage data was retrieved for.</p>', ], ], 'MonthlyCostEstimate' => [ 'base' => NULL, 'refs' => [ 'Usage$estimatedMonthlyCost' => '<p>The estimated monthly cost of Amazon Inspector.</p>', ], ], 'NetworkPath' => [ 'base' => '<p>Information on the network path associated with a finding.</p>', 'refs' => [ 'NetworkReachabilityDetails$networkPath' => '<p>An object that contains details about a network path associated with a finding.</p>', ], ], 'NetworkProtocol' => [ 'base' => NULL, 'refs' => [ 'NetworkReachabilityDetails$protocol' => '<p>The protocol associated with a finding.</p>', ], ], 'NetworkReachabilityDetails' => [ 'base' => '<p>Contains the details of a network reachability finding.</p>', 'refs' => [ 'Finding$networkReachabilityDetails' => '<p>An object that contains the details of a network reachability finding.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAccountPermissionsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListAccountPermissionsResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListCoverageRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListCoverageResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListCoverageStatisticsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListCoverageStatisticsResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListDelegatedAdminAccountsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListDelegatedAdminAccountsResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFiltersRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFiltersResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFindingAggregationsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFindingAggregationsResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFindingsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFindingsResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListMembersRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListMembersResponse$nextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$iamInstanceProfileArn' => '<p>The IAM instance profile ARN of the Amazon EC2 instance.</p>', 'AwsEc2InstanceDetails$imageId' => '<p>The image ID of the Amazon EC2 instance.</p>', 'AwsEc2InstanceDetails$keyName' => '<p>The name of the key pair used to launch the Amazon EC2 instance.</p>', 'AwsEc2InstanceDetails$subnetId' => '<p>The subnet ID of the Amazon EC2 instance.</p>', 'AwsEc2InstanceDetails$type' => '<p>The type of the Amazon EC2 instance.</p>', 'AwsEc2InstanceDetails$vpcId' => '<p>The VPC ID of the Amazon EC2 instance.</p>', 'AwsEcrContainerAggregationResponse$resourceId' => '<p>The resource ID of the container.</p>', 'AwsEcrContainerImageDetails$architecture' => '<p>The architecture of the Amazon ECR container image.</p>', 'AwsEcrContainerImageDetails$registry' => '<p>The registry the Amazon ECR container image belongs to.</p>', 'AwsEcrContainerImageDetails$repositoryName' => '<p>The name of the repository the Amazon ECR container image resides in.</p>', 'CoverageMapFilter$key' => '<p>The tag key associated with the coverage map filter.</p>', 'CoverageMapFilter$value' => '<p>The tag value associated with the coverage map filter.</p>', 'CvssScore$scoringVector' => '<p>The vector string of the CVSS score.</p>', 'CvssScore$source' => '<p>The source of the CVSS score.</p>', 'CvssScore$version' => '<p>The version of CVSS used for the score.</p>', 'CvssScoreAdjustment$metric' => '<p>The metric used to adjust the CVSS score.</p>', 'CvssScoreAdjustment$reason' => '<p>The reason the CVSS score has been adjustment.</p>', 'CvssScoreDetails$cvssSource' => '<p>The source of the CVSS data.</p>', 'CvssScoreDetails$scoreSource' => '<p>The source for the CVSS score.</p>', 'CvssScoreDetails$scoringVector' => '<p>The vector for the CVSS score.</p>', 'CvssScoreDetails$version' => '<p>The CVSS version used in scoring.</p>', 'Ec2InstanceAggregationResponse$instanceId' => '<p>The Amazon EC2 instance ID.</p>', 'FailedAccount$errorMessage' => '<p>The error message received when the account failed to enable Amazon Inspector.</p>', 'ImageLayerAggregationResponse$layerHash' => '<p>The layer hash.</p>', 'ImageLayerAggregationResponse$repository' => '<p>The repository the layer resides in.</p>', 'ImageLayerAggregationResponse$resourceId' => '<p>The resource ID of the container image layer.</p>', 'ImageTagList$member' => NULL, 'NonEmptyStringList$member' => NULL, 'PackageAggregationResponse$packageName' => '<p>The name of the operating system package.</p>', 'PackageVulnerabilityDetails$source' => '<p>The source of the vulnerability information.</p>', 'PackageVulnerabilityDetails$sourceUrl' => '<p>A URL to the source of the vulnerability information.</p>', 'PackageVulnerabilityDetails$vendorSeverity' => '<p>The severity the vendor has given to this vulnerability type.</p>', 'Recommendation$Url' => '<p>The URL address to the CVE remediation recommendations.</p>', 'Recommendation$text' => '<p>The recommended course of action to remediate the finding.</p>', 'RepositoryAggregationResponse$repository' => '<p>The name of the repository associated with the findings.</p>', 'Resource$id' => '<p>The ID of the resource.</p>', 'Resource$partition' => '<p>The partition of the resource.</p>', 'Resource$region' => '<p>The Amazon Web Services Region the impacted resource is located in.</p>', 'State$errorMessage' => '<p>The error message received when the account failed to enable Amazon Inspector.</p>', 'StringList$member' => NULL, 'TitleAggregationResponse$title' => '<p>The title that the findings were aggregated on.</p>', ], ], 'NonEmptyStringList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$referenceUrls' => '<p>One or more URLs that contain details about this vulnerability type.</p>', ], ], 'NumberFilter' => [ 'base' => '<p>An object that describes the details of a number filter.</p>', 'refs' => [ 'NumberFilterList$member' => NULL, 'PackageFilter$epoch' => '<p>An object that contains details on the package epoch to filter on.</p>', ], ], 'NumberFilterList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$inspectorScore' => '<p>The Amazon Inspector score to filter on.</p>', ], ], 'Operation' => [ 'base' => NULL, 'refs' => [ 'Permission$operation' => '<p>The operations that can be performed with the given permissions.</p>', ], ], 'OwnerId' => [ 'base' => NULL, 'refs' => [ 'Filter$ownerId' => '<p>The Amazon Web Services account ID of the account that created the filter.</p>', ], ], 'PackageAggregation' => [ 'base' => '<p>The details that define an aggregation based on operating system package type.</p>', 'refs' => [ 'AggregationRequest$packageAggregation' => '<p>An object that contains details about an aggregation request based on operating system package type.</p>', ], ], 'PackageAggregationResponse' => [ 'base' => '<p>A response that contains the results of a finding aggregation by image layer.</p>', 'refs' => [ 'AggregationResponse$packageAggregation' => '<p>An object that contains details about an aggregation response based on operating system package type.</p>', ], ], 'PackageArchitecture' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$arch' => '<p>The architecture of the vulnerable package.</p>', ], ], 'PackageEpoch' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$epoch' => '<p>The epoch of the vulnerable package.</p>', ], ], 'PackageFilter' => [ 'base' => '<p>Contains information on the details of a package filter.</p>', 'refs' => [ 'PackageFilterList$member' => NULL, ], ], 'PackageFilterList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$vulnerablePackages' => '<p>Details on the vulnerable packages used to filter findings.</p>', ], ], 'PackageManager' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$packageManager' => '<p>The package manager of the vulnerable package.</p>', ], ], 'PackageName' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$name' => '<p>The name of the vulnerable package.</p>', ], ], 'PackageRelease' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$release' => '<p>The release of the vulnerable package.</p>', ], ], 'PackageSortBy' => [ 'base' => NULL, 'refs' => [ 'PackageAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'PackageVersion' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$fixedInVersion' => '<p>The version of the package that contains the vulnerability fix.</p>', 'VulnerablePackage$version' => '<p>The version of the vulnerable package.</p>', ], ], 'PackageVulnerabilityDetails' => [ 'base' => '<p>Information about a package vulnerability finding.</p>', 'refs' => [ 'Finding$packageVulnerabilityDetails' => '<p>An object that contains the details of a package vulnerability finding.</p>', ], ], 'Permission' => [ 'base' => '<p>Contains information on the permissions an account has within Amazon Inspector.</p>', 'refs' => [ 'Permissions$member' => NULL, ], ], 'Permissions' => [ 'base' => NULL, 'refs' => [ 'ListAccountPermissionsResponse$permissions' => '<p>Contains details on the permissions an account has to configure Amazon Inspector.</p>', ], ], 'Platform' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$platform' => '<p>The platform of the Amazon EC2 instance.</p>', 'AwsEcrContainerImageDetails$platform' => '<p>The platform of the Amazon ECR container image.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'PortRange$begin' => '<p>The beginning port in a port range.</p>', 'PortRange$end' => '<p>The ending port in a port range.</p>', 'PortRangeFilter$beginInclusive' => '<p>The port number the port range begins at.</p>', 'PortRangeFilter$endInclusive' => '<p>The port number the port range ends at.</p>', ], ], 'PortRange' => [ 'base' => '<p>Details about the port range associated with a finding.</p>', 'refs' => [ 'NetworkReachabilityDetails$openPortRange' => '<p>An object that contains details about the open port range associated with a finding.</p>', ], ], 'PortRangeFilter' => [ 'base' => '<p>An object that describes the details of a port range filter.</p>', 'refs' => [ 'PortRangeFilterList$member' => NULL, ], ], 'PortRangeFilterList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$portRange' => '<p>Details on the port ranges used to filter findings.</p>', ], ], 'Recommendation' => [ 'base' => '<p>Details about the recommended course of action to remediate the finding.</p>', 'refs' => [ 'Remediation$recommendation' => '<p>An object that contains information about the recommended course of action to remediate the finding.</p>', ], ], 'RelationshipStatus' => [ 'base' => NULL, 'refs' => [ 'DelegatedAdmin$relationshipStatus' => '<p>The status of the Amazon Inspector delegated administrator.</p>', 'Member$relationshipStatus' => '<p>The status of the member account.</p>', ], ], 'Remediation' => [ 'base' => '<p>Information on how to remediate a finding.</p>', 'refs' => [ 'Finding$remediation' => '<p>An object that contains the details about how to remediate a finding.</p>', ], ], 'ReportFormat' => [ 'base' => NULL, 'refs' => [ 'CreateFindingsReportRequest$reportFormat' => '<p>The format to generate the report in.</p>', ], ], 'ReportId' => [ 'base' => NULL, 'refs' => [ 'CancelFindingsReportRequest$reportId' => '<p>The ID of the report to be canceled.</p>', 'CancelFindingsReportResponse$reportId' => '<p>The ID of the canceled report.</p>', 'CreateFindingsReportResponse$reportId' => '<p>The ID of the report.</p>', 'GetFindingsReportStatusRequest$reportId' => '<p>The ID of the report to retrieve the status of.</p>', 'GetFindingsReportStatusResponse$reportId' => '<p>The ID of the report.</p>', ], ], 'ReportingErrorCode' => [ 'base' => NULL, 'refs' => [ 'GetFindingsReportStatusResponse$errorCode' => '<p>The error code of the report.</p>', ], ], 'RepositoryAggregation' => [ 'base' => '<p>The details that define an aggregation based on repository.</p>', 'refs' => [ 'AggregationRequest$repositoryAggregation' => '<p>An object that contains details about an aggregation request based on Amazon ECR repositories.</p>', ], ], 'RepositoryAggregationResponse' => [ 'base' => '<p>A response that contains details on the results of a finding aggregation by repository.</p>', 'refs' => [ 'AggregationResponse$repositoryAggregation' => '<p>An object that contains details about an aggregation response based on Amazon ECR repositories.</p>', ], ], 'RepositorySortBy' => [ 'base' => NULL, 'refs' => [ 'RepositoryAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'Resource' => [ 'base' => '<p>Details about the resource involved in a finding.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceDetails' => [ 'base' => '<p>Contains details about the resource involved in the finding.</p>', 'refs' => [ 'Resource$details' => '<p>An object that contains details about the resource involved in a finding.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'CoveredResource$resourceId' => '<p>The ID of the covered resource.</p>', ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'Finding$resources' => '<p>Contains information on the resources involved in a finding.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>', 'refs' => [], ], 'ResourceScanMetadata' => [ 'base' => '<p>An object that contains details about the metadata for an Amazon ECR resource.</p>', 'refs' => [ 'CoveredResource$resourceMetadata' => '<p>An object that contains details about the metadata.</p>', ], ], 'ResourceScanType' => [ 'base' => NULL, 'refs' => [ 'DisableResourceTypeList$member' => NULL, 'EnableResourceTypeList$member' => NULL, ], ], 'ResourceState' => [ 'base' => '<p>Details the state of Amazon Inspector for each resource type Amazon Inspector scans.</p>', 'refs' => [ 'AccountState$resourceState' => '<p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>', ], ], 'ResourceStatus' => [ 'base' => '<p>Details the status of Amazon Inspector for each resource type Amazon Inspector scans.</p>', 'refs' => [ 'Account$resourceStatus' => '<p>Details of the status of Amazon Inspector scans by resource type.</p>', 'FailedAccount$resourceStatus' => '<p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'Resource$type' => '<p>The type of resource.</p>', ], ], 'ScanStatus' => [ 'base' => '<p>The status of the scan.</p>', 'refs' => [ 'CoveredResource$scanStatus' => '<p>The status of the scan covering the resource.</p>', ], ], 'ScanStatusCode' => [ 'base' => NULL, 'refs' => [ 'ScanStatus$statusCode' => '<p>The status code of the scan.</p>', ], ], 'ScanStatusReason' => [ 'base' => NULL, 'refs' => [ 'ScanStatus$reason' => '<p>The reason for the scan.</p>', ], ], 'ScanType' => [ 'base' => NULL, 'refs' => [ 'CoveredResource$scanType' => '<p>The Amazon Inspector scan type covering the resource.</p>', ], ], 'Service' => [ 'base' => NULL, 'refs' => [ 'ListAccountPermissionsRequest$service' => '<p>The service scan type to check permissions for.</p>', 'Permission$service' => '<p>The services that the permissions allow an account to perform the given operations for.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use Service Quotas to request a service quota increase.</p>', 'refs' => [], ], 'Severity' => [ 'base' => NULL, 'refs' => [ 'Finding$severity' => '<p>The severity of the finding.</p>', ], ], 'SeverityCounts' => [ 'base' => '<p>An object that contains the counts of aggregated finding per severity.</p>', 'refs' => [ 'AccountAggregationResponse$severityCounts' => '<p>The number of findings by severity.</p>', 'AmiAggregationResponse$severityCounts' => '<p>An object that contains the count of matched findings per severity.</p>', 'AwsEcrContainerAggregationResponse$severityCounts' => '<p>The number of finding by severity.</p>', 'Ec2InstanceAggregationResponse$severityCounts' => '<p>An object that contains the count of matched findings per severity.</p>', 'FindingTypeAggregationResponse$severityCounts' => '<p>The value to sort results by.</p>', 'ImageLayerAggregationResponse$severityCounts' => '<p>An object that represents the count of matched findings per severity.</p>', 'PackageAggregationResponse$severityCounts' => '<p>An object that contains the count of matched findings per severity.</p>', 'RepositoryAggregationResponse$severityCounts' => '<p>An object that represent the count of matched findings per severity.</p>', 'TitleAggregationResponse$severityCounts' => '<p>An object that represent the count of matched findings per severity.</p>', ], ], 'SortCriteria' => [ 'base' => '<p>Details about the criteria used to sort finding results.</p>', 'refs' => [ 'ListFindingsRequest$sortCriteria' => '<p>Details on the sort criteria to apply to your finding results.</p>', ], ], 'SortField' => [ 'base' => NULL, 'refs' => [ 'SortCriteria$field' => '<p>The finding detail field by which results are sorted.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'AccountAggregation$sortOrder' => '<p>The sort order (ascending or descending).</p>', 'AmiAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'AwsEcrContainerAggregation$sortOrder' => '<p>The sort order (ascending or descending).</p>', 'Ec2InstanceAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'FindingTypeAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'ImageLayerAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'PackageAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'RepositoryAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'SortCriteria$sortOrder' => '<p>The order by which findings are sorted.</p>', 'TitleAggregation$sortOrder' => '<p>The order to sort results by.</p>', ], ], 'SourceLayerHash' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$sourceLayerHash' => '<p>The source layer hash of the vulnerable package.</p>', ], ], 'State' => [ 'base' => '<p>An object that described the state of Amazon Inspector scans for an account.</p>', 'refs' => [ 'AccountState$state' => '<p>An object detailing the status of Amazon Inspector for the account.</p>', 'ResourceState$ec2' => '<p>An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.</p>', 'ResourceState$ecr' => '<p>An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'Account$status' => '<p>The status of Amazon Inspector for the account.</p>', 'FailedAccount$status' => '<p>The status of Amazon Inspector for the account.</p>', 'ResourceStatus$ec2' => '<p>The status of Amazon Inspector scanning for Amazon EC2 resources.</p>', 'ResourceStatus$ecr' => '<p>The status of Amazon Inspector scanning for Amazon ECR resources.</p>', 'State$status' => '<p>The status of Amazon Inspector for the account.</p>', ], ], 'Step' => [ 'base' => '<p>Details about the step associated with a finding.</p>', 'refs' => [ 'StepList$member' => NULL, ], ], 'StepList' => [ 'base' => NULL, 'refs' => [ 'NetworkPath$steps' => '<p>The details on the steps in the network path.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AwsEcrContainerAggregationResponse$architecture' => '<p>The architecture of the container.</p>', 'AwsEcrContainerAggregationResponse$imageSha' => '<p>The SHA value of the container image.</p>', 'AwsEcrContainerAggregationResponse$repository' => '<p>The container repository.</p>', 'AwsEcrContainerImageDetails$author' => '<p>The image author of the Amazon ECR container image.</p>', 'BadRequestException$message' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the conflicting resource.</p>', 'ConflictException$resourceType' => '<p>The type of the conflicting resource.</p>', 'Destination$bucketName' => '<p>The name of the Amazon S3 bucket to export findings to.</p>', 'Destination$keyPrefix' => '<p>The prefix of the KMS key used to export findings.</p>', 'Destination$kmsKeyArn' => '<p>The ARN of the KMS key used to encrypt data when exporting findings.</p>', 'Ec2InstanceAggregationResponse$accountId' => '<p>The Amazon Web Services account the Amazon EC2 instance belongs to.</p>', 'Ec2InstanceAggregationResponse$operatingSystem' => '<p>The operating system of the Amazon EC2 instance.</p>', 'EcrRepositoryMetadata$name' => '<p>The name of the Amazon ECR repository.</p>', 'FreeTrialInfoError$message' => '<p>The error message returned.</p>', 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$resourceId' => '<p>The ID of the resource that exceeds a service quota.</p>', 'TagList$member' => NULL, 'ThrottlingException$message' => NULL, 'TitleAggregationResponse$vulnerabilityId' => '<p>The vulnerability ID of the finding.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>The validation exception message.</p>', 'ValidationExceptionField$name' => '<p>The name of the validation exception.</p>', ], ], 'StringComparison' => [ 'base' => NULL, 'refs' => [ 'StringFilter$comparison' => '<p>The operator to use when comparing values in the filter</p>', ], ], 'StringFilter' => [ 'base' => '<p>An object that describes the details of a string filter.</p>', 'refs' => [ 'PackageFilter$architecture' => '<p>An object that contains details on the package architecture type to filter on.</p>', 'PackageFilter$name' => '<p>An object that contains details on the name of the package to filter on.</p>', 'PackageFilter$release' => '<p>An object that contains details on the package release to filter on.</p>', 'PackageFilter$sourceLayerHash' => '<p>An object that contains details on the source layer hash to filter on.</p>', 'PackageFilter$version' => '<p>The package version to filter on.</p>', 'StringFilterList$member' => NULL, ], ], 'StringFilterList' => [ 'base' => NULL, 'refs' => [ 'AmiAggregation$amis' => '<p>The IDs of AMIs to aggregate findings for.</p>', 'AwsEcrContainerAggregation$architectures' => '<p>The architecture of the containers.</p>', 'AwsEcrContainerAggregation$imageShas' => '<p>The image SHA values.</p>', 'AwsEcrContainerAggregation$imageTags' => '<p>The image tags.</p>', 'AwsEcrContainerAggregation$repositories' => '<p>The container repositories.</p>', 'AwsEcrContainerAggregation$resourceIds' => '<p>The container resource IDs.</p>', 'Ec2InstanceAggregation$amis' => '<p>The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.</p>', 'Ec2InstanceAggregation$instanceIds' => '<p>The Amazon EC2 instance IDs to aggregate findings for.</p>', 'Ec2InstanceAggregation$operatingSystems' => '<p>The operating system types to aggregate findings for. Valid values must be uppercase and underscore separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.</p>', 'FilterCriteria$awsAccountId' => '<p>Details of the Amazon Web Services account IDs used to filter findings.</p>', 'FilterCriteria$componentId' => '<p>Details of the component IDs used to filter findings.</p>', 'FilterCriteria$componentType' => '<p>Details of the component types used to filter findings.</p>', 'FilterCriteria$ec2InstanceImageId' => '<p>Details of the Amazon EC2 instance image IDs used to filter findings.</p>', 'FilterCriteria$ec2InstanceSubnetId' => '<p>Details of the Amazon EC2 instance subnet IDs used to filter findings.</p>', 'FilterCriteria$ec2InstanceVpcId' => '<p>Details of the Amazon EC2 instance VPC IDs used to filter findings.</p>', 'FilterCriteria$ecrImageArchitecture' => '<p>Details of the Amazon ECR image architecture types used to filter findings.</p>', 'FilterCriteria$ecrImageHash' => '<p>Details of the Amazon ECR image hashes used to filter findings.</p>', 'FilterCriteria$ecrImageRegistry' => '<p>Details on the Amazon ECR registry used to filter findings.</p>', 'FilterCriteria$ecrImageRepositoryName' => '<p>Details on the name of the Amazon ECR repository used to filter findings.</p>', 'FilterCriteria$ecrImageTags' => '<p>The tags attached to the Amazon ECR container image.</p>', 'FilterCriteria$findingArn' => '<p>Details on the finding ARNs used to filter findings.</p>', 'FilterCriteria$findingStatus' => '<p>Details on the finding status types used to filter findings.</p>', 'FilterCriteria$findingType' => '<p>Details on the finding types used to filter findings.</p>', 'FilterCriteria$networkProtocol' => '<p>Details on the ingress source addresses used to filter findings.</p>', 'FilterCriteria$relatedVulnerabilities' => '<p>Details on the related vulnerabilities used to filter findings.</p>', 'FilterCriteria$resourceId' => '<p>Details on the resource IDs used to filter findings.</p>', 'FilterCriteria$resourceType' => '<p>Details on the resource types used to filter findings.</p>', 'FilterCriteria$severity' => '<p>Details on the severity used to filter findings.</p>', 'FilterCriteria$title' => '<p>Details on the finding title used to filter findings.</p>', 'FilterCriteria$vendorSeverity' => '<p>Details on the vendor severity used to filter findings.</p>', 'FilterCriteria$vulnerabilityId' => '<p>Details on the vulnerability ID used to filter findings.</p>', 'FilterCriteria$vulnerabilitySource' => '<p>Details on the vulnerability type used to filter findings.</p>', 'ImageLayerAggregation$layerHashes' => '<p>The hashes associated with the layers.</p>', 'ImageLayerAggregation$repositories' => '<p>The repository associated with the container image hosting the layers.</p>', 'ImageLayerAggregation$resourceIds' => '<p>The ID of the container image layer.</p>', 'ListFindingAggregationsRequest$accountIds' => '<p>The Amazon Web Services account IDs to retrieve finding aggregation data for.</p>', 'PackageAggregation$packageNames' => '<p>The names of packages to aggregate findings on.</p>', 'RepositoryAggregation$repositories' => '<p>The names of repositories to aggregate findings on.</p>', 'TitleAggregation$titles' => '<p>The finding titles to aggregate on.</p>', 'TitleAggregation$vulnerabilityIds' => '<p>The vulnerability IDs of the findings.</p>', ], ], 'StringInput' => [ 'base' => NULL, 'refs' => [ 'StringFilter$value' => '<p>The value to filter on.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerAggregationResponse$imageTags' => '<p>The container image stags.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'EcrContainerImageMetadata$tags' => '<p>Tags associated with the Amazon ECR image metadata.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$tags' => '<p>A list of tags for the filter.</p>', 'Ec2InstanceAggregationResponse$instanceTags' => '<p>The tags attached to the instance.</p>', 'Ec2Metadata$tags' => '<p>The tags attached to the instance.</p>', 'Filter$tags' => '<p>The tags attached to the filter.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags associated with the resource.</p>', 'Resource$tags' => '<p>The tags attached to the resource.</p>', 'TagResourceRequest$tags' => '<p>The tags to be added to a resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>The limit on the number of requests per second was exceeded.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DateFilter$endInclusive' => '<p>A timestamp representing the end of the time period filtered on.</p>', 'DateFilter$startInclusive' => '<p>A timestamp representing the start of the time period filtered on.</p>', 'FreeTrialInfo$end' => '<p>The date and time that the Amazon Inspector free trail ends for a given account.</p>', 'FreeTrialInfo$start' => '<p>The date and time that the Amazon Inspector free trail started for a given account.</p>', ], ], 'TitleAggregation' => [ 'base' => '<p>The details that define an aggregation based on finding title.</p>', 'refs' => [ 'AggregationRequest$titleAggregation' => '<p>An object that contains details about an aggregation request based on finding title.</p>', ], ], 'TitleAggregationResponse' => [ 'base' => '<p>A response that contains details on the results of a finding aggregation by title.</p>', 'refs' => [ 'AggregationResponse$titleAggregation' => '<p>An object that contains details about an aggregation response based on finding title.</p>', ], ], 'TitleSortBy' => [ 'base' => NULL, 'refs' => [ 'TitleAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Usage' => [ 'base' => '<p>Contains usage information about the cost of Amazon Inspector operation.</p>', 'refs' => [ 'UsageList$member' => NULL, ], ], 'UsageAccountId' => [ 'base' => NULL, 'refs' => [ 'UsageAccountIdList$member' => NULL, ], ], 'UsageAccountIdList' => [ 'base' => NULL, 'refs' => [ 'ListUsageTotalsRequest$accountIds' => '<p>The Amazon Web Services account IDs to retrieve usage totals for.</p>', ], ], 'UsageList' => [ 'base' => NULL, 'refs' => [ 'UsageTotal$usage' => '<p>An object representing the total usage for an account.</p>', ], ], 'UsageTotal' => [ 'base' => '<p>The total of usage for an account ID.</p>', 'refs' => [ 'UsageTotalList$member' => NULL, ], ], 'UsageTotalList' => [ 'base' => NULL, 'refs' => [ 'ListUsageTotalsResponse$totals' => '<p>An object with details on the total usage for the requested account.</p>', ], ], 'UsageType' => [ 'base' => NULL, 'refs' => [ 'Usage$type' => '<p>The type scan.</p>', ], ], 'UsageValue' => [ 'base' => NULL, 'refs' => [ 'Usage$total' => '<p>The total of usage.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request has failed validation due to missing required fields or having invalid inputs.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>An object that describes a validation exception.</p>', 'refs' => [ 'ValidationExceptionFields$member' => NULL, ], ], 'ValidationExceptionFields' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fields' => '<p>The fields that failed validation.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason for the validation failure.</p>', ], ], 'VulnerabilityId' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$vulnerabilityId' => '<p>The ID given to this vulnerability.</p>', 'VulnerabilityIdList$member' => NULL, ], ], 'VulnerabilityIdList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$relatedVulnerabilities' => '<p>One or more vulnerabilities related to the one identified in this finding.</p>', ], ], 'VulnerablePackage' => [ 'base' => '<p>Information on the vulnerable package identified by a finding.</p>', 'refs' => [ 'VulnerablePackageList$member' => NULL, ], ], 'VulnerablePackageList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$vulnerablePackages' => '<p>The packages impacted by this vulnerability.</p>', ], ], ],];
