<?php
// This file was auto-generated from sdk-root/src/data/fis/2020-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Fault Injection Simulator is a managed service that enables you to perform fault injection experiments on your Amazon Web Services workloads. For more information, see the <a href="https://docs.aws.amazon.com/fis/latest/userguide/">Fault Injection Simulator User Guide</a>.</p>', 'operations' => [ 'CreateExperimentTemplate' => '<p>Creates an experiment template. </p> <p>An experiment template includes the following components:</p> <ul> <li> <p> <b>Targets</b>: A target can be a specific resource in your Amazon Web Services environment, or one or more resources that match criteria that you specify, for example, resources that have specific tags.</p> </li> <li> <p> <b>Actions</b>: The actions to carry out on the target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.</p> </li> <li> <p> <b>Stop conditions</b>: If a stop condition is triggered while an experiment is running, the experiment is automatically stopped. You can define a stop condition as a CloudWatch alarm.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">Experiment templates</a> in the <i>Fault Injection Simulator User Guide</i>.</p>', 'DeleteExperimentTemplate' => '<p>Deletes the specified experiment template.</p>', 'GetAction' => '<p>Gets information about the specified FIS action.</p>', 'GetExperiment' => '<p>Gets information about the specified experiment.</p>', 'GetExperimentTemplate' => '<p>Gets information about the specified experiment template.</p>', 'ListActions' => '<p>Lists the available FIS actions.</p>', 'ListExperimentTemplates' => '<p>Lists your experiment templates.</p>', 'ListExperiments' => '<p>Lists your experiments.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p>', 'StartExperiment' => '<p>Starts running an experiment from the specified experiment template.</p>', 'StopExperiment' => '<p>Stops the specified experiment.</p>', 'TagResource' => '<p>Applies the specified tags to the specified resource.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified resource.</p>', 'UpdateExperimentTemplate' => '<p>Updates the specified experiment template.</p>', ], 'shapes' => [ 'Action' => [ 'base' => '<p>Describes an action. For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html">FIS actions</a> in the <i>Fault Injection Simulator User Guide</i>.</p>', 'refs' => [ 'GetActionResponse$action' => '<p>Information about the action.</p>', ], ], 'ActionDescription' => [ 'base' => NULL, 'refs' => [ 'Action$description' => '<p>The description for the action.</p>', 'ActionSummary$description' => '<p>The description for the action.</p>', ], ], 'ActionId' => [ 'base' => NULL, 'refs' => [ 'Action$id' => '<p>The ID of the action.</p>', 'ActionSummary$id' => '<p>The ID of the action.</p>', 'CreateExperimentTemplateActionInput$actionId' => '<p>The ID of the action. The format of the action ID is: aws:<i>service-name</i>:<i>action-type</i>.</p>', 'ExperimentAction$actionId' => '<p>The ID of the action.</p>', 'ExperimentTemplateAction$actionId' => '<p>The ID of the action.</p>', 'GetActionRequest$id' => '<p>The ID of the action.</p>', 'UpdateExperimentTemplateActionInputItem$actionId' => '<p>The ID of the action.</p>', ], ], 'ActionParameter' => [ 'base' => '<p>Describes a parameter for an action.</p>', 'refs' => [ 'ActionParameterMap$value' => NULL, ], ], 'ActionParameterDescription' => [ 'base' => NULL, 'refs' => [ 'ActionParameter$description' => '<p>The parameter description.</p>', ], ], 'ActionParameterMap' => [ 'base' => NULL, 'refs' => [ 'Action$parameters' => '<p>The action parameters, if applicable.</p>', ], ], 'ActionParameterName' => [ 'base' => NULL, 'refs' => [ 'ActionParameterMap$key' => NULL, ], ], 'ActionParameterRequired' => [ 'base' => NULL, 'refs' => [ 'ActionParameter$required' => '<p>Indicates whether the parameter is required.</p>', ], ], 'ActionSummary' => [ 'base' => '<p>Provides a summary of an action.</p>', 'refs' => [ 'ActionSummaryList$member' => NULL, ], ], 'ActionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListActionsResponse$actions' => '<p>The actions.</p>', ], ], 'ActionTarget' => [ 'base' => '<p>Describes a target for an action.</p>', 'refs' => [ 'ActionTargetMap$value' => NULL, ], ], 'ActionTargetMap' => [ 'base' => NULL, 'refs' => [ 'Action$targets' => '<p>The supported targets for the action.</p>', 'ActionSummary$targets' => '<p>The targets for the action.</p>', ], ], 'ActionTargetName' => [ 'base' => NULL, 'refs' => [ 'ActionTargetMap$key' => NULL, ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'StartExperimentRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of a conflict.</p>', 'refs' => [], ], 'CreateExperimentTemplateActionInput' => [ 'base' => '<p>Specifies an action for an experiment template.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/actions.html">Actions</a> in the <i>Fault Injection Simulator User Guide</i>.</p>', 'refs' => [ 'CreateExperimentTemplateActionInputMap$value' => NULL, ], ], 'CreateExperimentTemplateActionInputMap' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$actions' => '<p>The actions for the experiment.</p>', ], ], 'CreateExperimentTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentTemplateStopConditionInput' => [ 'base' => '<p>Specifies a stop condition for an experiment template.</p>', 'refs' => [ 'CreateExperimentTemplateStopConditionInputList$member' => NULL, ], ], 'CreateExperimentTemplateStopConditionInputList' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$stopConditions' => '<p>The stop conditions.</p>', ], ], 'CreateExperimentTemplateTargetInput' => [ 'base' => '<p>Specifies a target for an experiment. You must specify at least one Amazon Resource Name (ARN) or at least one resource tag. You cannot specify both ARNs and tags.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/targets.html">Targets</a> in the <i>Fault Injection Simulator User Guide</i>.</p>', 'refs' => [ 'CreateExperimentTemplateTargetInputMap$value' => NULL, ], ], 'CreateExperimentTemplateTargetInputMap' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$targets' => '<p>The targets for the experiment.</p>', ], ], 'CreationTime' => [ 'base' => NULL, 'refs' => [ 'Experiment$creationTime' => '<p>The time that the experiment was created.</p>', 'ExperimentSummary$creationTime' => '<p>The time that the experiment was created.</p>', 'ExperimentTemplate$creationTime' => '<p>The time the experiment template was created.</p>', 'ExperimentTemplateSummary$creationTime' => '<p>The time that the experiment template was created.</p>', ], ], 'DeleteExperimentTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperimentTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ConflictException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'Experiment' => [ 'base' => '<p>Describes an experiment.</p>', 'refs' => [ 'GetExperimentResponse$experiment' => '<p>Information about the experiment.</p>', 'StartExperimentResponse$experiment' => '<p>Information about the experiment.</p>', 'StopExperimentResponse$experiment' => '<p>Information about the experiment.</p>', ], ], 'ExperimentAction' => [ 'base' => '<p>Describes the action for an experiment.</p>', 'refs' => [ 'ExperimentActionMap$value' => NULL, ], ], 'ExperimentActionDescription' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$description' => '<p>The description for the action.</p>', ], ], 'ExperimentActionEndTime' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$endTime' => '<p>The time that the action ended.</p>', ], ], 'ExperimentActionMap' => [ 'base' => NULL, 'refs' => [ 'Experiment$actions' => '<p>The actions for the experiment.</p>', ], ], 'ExperimentActionName' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionMap$key' => NULL, ], ], 'ExperimentActionParameter' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionParameterMap$value' => NULL, ], ], 'ExperimentActionParameterMap' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$parameters' => '<p>The parameters for the action.</p>', ], ], 'ExperimentActionParameterName' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionParameterMap$key' => NULL, ], ], 'ExperimentActionStartAfter' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionStartAfterList$member' => NULL, ], ], 'ExperimentActionStartAfterList' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$startAfter' => '<p>The name of the action that must be completed before this action starts.</p>', ], ], 'ExperimentActionStartTime' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$startTime' => '<p>The time that the action started.</p>', ], ], 'ExperimentActionState' => [ 'base' => '<p>Describes the state of an action.</p>', 'refs' => [ 'ExperimentAction$state' => '<p>The state of the action.</p>', ], ], 'ExperimentActionStatus' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionState$status' => '<p>The state of the action.</p>', ], ], 'ExperimentActionStatusReason' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionState$reason' => '<p>The reason for the state.</p>', ], ], 'ExperimentActionTargetMap' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$targets' => '<p>The targets for the action.</p>', ], ], 'ExperimentActionTargetName' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionTargetMap$key' => NULL, ], ], 'ExperimentEndTime' => [ 'base' => NULL, 'refs' => [ 'Experiment$endTime' => '<p>The time that the experiment ended.</p>', ], ], 'ExperimentId' => [ 'base' => NULL, 'refs' => [ 'Experiment$id' => '<p>The ID of the experiment.</p>', 'ExperimentSummary$id' => '<p>The ID of the experiment.</p>', 'GetExperimentRequest$id' => '<p>The ID of the experiment.</p>', 'StopExperimentRequest$id' => '<p>The ID of the experiment.</p>', ], ], 'ExperimentStartTime' => [ 'base' => NULL, 'refs' => [ 'Experiment$startTime' => '<p>The time that the experiment started.</p>', ], ], 'ExperimentState' => [ 'base' => '<p>Describes the state of an experiment.</p>', 'refs' => [ 'Experiment$state' => '<p>The state of the experiment.</p>', 'ExperimentSummary$state' => '<p>The state of the experiment.</p>', ], ], 'ExperimentStatus' => [ 'base' => NULL, 'refs' => [ 'ExperimentState$status' => '<p>The state of the experiment.</p>', ], ], 'ExperimentStatusReason' => [ 'base' => NULL, 'refs' => [ 'ExperimentState$reason' => '<p>The reason for the state.</p>', ], ], 'ExperimentStopCondition' => [ 'base' => '<p>Describes the stop condition for an experiment.</p>', 'refs' => [ 'ExperimentStopConditionList$member' => NULL, ], ], 'ExperimentStopConditionList' => [ 'base' => NULL, 'refs' => [ 'Experiment$stopConditions' => '<p>The stop conditions for the experiment.</p>', ], ], 'ExperimentSummary' => [ 'base' => '<p>Provides a summary of an experiment.</p>', 'refs' => [ 'ExperimentSummaryList$member' => NULL, ], ], 'ExperimentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsResponse$experiments' => '<p>The experiments.</p>', ], ], 'ExperimentTarget' => [ 'base' => '<p>Describes a target for an experiment.</p>', 'refs' => [ 'ExperimentTargetMap$value' => NULL, ], ], 'ExperimentTargetFilter' => [ 'base' => '<p>Describes a filter used for the target resources in an experiment.</p>', 'refs' => [ 'ExperimentTargetFilterList$member' => NULL, ], ], 'ExperimentTargetFilterList' => [ 'base' => NULL, 'refs' => [ 'ExperimentTarget$filters' => '<p>The filters to apply to identify target resources using specific attributes.</p>', ], ], 'ExperimentTargetFilterPath' => [ 'base' => NULL, 'refs' => [ 'ExperimentTargetFilter$path' => '<p>The attribute path for the filter.</p>', ], ], 'ExperimentTargetFilterValue' => [ 'base' => NULL, 'refs' => [ 'ExperimentTargetFilterValues$member' => NULL, ], ], 'ExperimentTargetFilterValues' => [ 'base' => NULL, 'refs' => [ 'ExperimentTargetFilter$values' => '<p>The attribute values for the filter.</p>', ], ], 'ExperimentTargetMap' => [ 'base' => NULL, 'refs' => [ 'Experiment$targets' => '<p>The targets for the experiment.</p>', ], ], 'ExperimentTargetName' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionTargetMap$value' => NULL, 'ExperimentTargetMap$key' => NULL, ], ], 'ExperimentTargetSelectionMode' => [ 'base' => NULL, 'refs' => [ 'ExperimentTarget$selectionMode' => '<p>Scopes the identified resources to a specific count or percentage.</p>', ], ], 'ExperimentTemplate' => [ 'base' => '<p>Describes an experiment template.</p>', 'refs' => [ 'CreateExperimentTemplateResponse$experimentTemplate' => '<p>Information about the experiment template.</p>', 'DeleteExperimentTemplateResponse$experimentTemplate' => '<p>Information about the experiment template.</p>', 'GetExperimentTemplateResponse$experimentTemplate' => '<p>Information about the experiment template.</p>', 'UpdateExperimentTemplateResponse$experimentTemplate' => '<p>Information about the experiment template.</p>', ], ], 'ExperimentTemplateAction' => [ 'base' => '<p>Describes an action for an experiment template.</p>', 'refs' => [ 'ExperimentTemplateActionMap$value' => NULL, ], ], 'ExperimentTemplateActionDescription' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateActionInput$description' => '<p>A description for the action.</p>', 'ExperimentTemplateAction$description' => '<p>A description for the action.</p>', 'UpdateExperimentTemplateActionInputItem$description' => '<p>A description for the action.</p>', ], ], 'ExperimentTemplateActionMap' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplate$actions' => '<p>The actions for the experiment.</p>', ], ], 'ExperimentTemplateActionName' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateActionInputMap$key' => NULL, 'ExperimentTemplateActionMap$key' => NULL, 'UpdateExperimentTemplateActionInputMap$key' => NULL, ], ], 'ExperimentTemplateActionParameter' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateActionParameterMap$value' => NULL, ], ], 'ExperimentTemplateActionParameterMap' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateActionInput$parameters' => '<p>The parameters for the action, if applicable.</p>', 'ExperimentTemplateAction$parameters' => '<p>The parameters for the action.</p>', 'UpdateExperimentTemplateActionInputItem$parameters' => '<p>The parameters for the action, if applicable.</p>', ], ], 'ExperimentTemplateActionParameterName' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateActionParameterMap$key' => NULL, ], ], 'ExperimentTemplateActionStartAfter' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateActionStartAfterList$member' => NULL, ], ], 'ExperimentTemplateActionStartAfterList' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateActionInput$startAfter' => '<p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>', 'ExperimentTemplateAction$startAfter' => '<p>The name of the action that must be completed before the current action starts.</p>', 'UpdateExperimentTemplateActionInputItem$startAfter' => '<p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>', ], ], 'ExperimentTemplateActionTargetMap' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateActionInput$targets' => '<p>The targets for the action.</p>', 'ExperimentTemplateAction$targets' => '<p>The targets for the action.</p>', 'UpdateExperimentTemplateActionInputItem$targets' => '<p>The targets for the action.</p>', ], ], 'ExperimentTemplateActionTargetName' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateActionTargetMap$key' => NULL, ], ], 'ExperimentTemplateDescription' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$description' => '<p>A description for the experiment template.</p>', 'ExperimentTemplate$description' => '<p>The description for the experiment template.</p>', 'ExperimentTemplateSummary$description' => '<p>The description of the experiment template.</p>', 'UpdateExperimentTemplateRequest$description' => '<p>A description for the template.</p>', ], ], 'ExperimentTemplateId' => [ 'base' => NULL, 'refs' => [ 'DeleteExperimentTemplateRequest$id' => '<p>The ID of the experiment template.</p>', 'Experiment$experimentTemplateId' => '<p>The ID of the experiment template.</p>', 'ExperimentSummary$experimentTemplateId' => '<p>The ID of the experiment template.</p>', 'ExperimentTemplate$id' => '<p>The ID of the experiment template.</p>', 'ExperimentTemplateSummary$id' => '<p>The ID of the experiment template.</p>', 'GetExperimentTemplateRequest$id' => '<p>The ID of the experiment template.</p>', 'StartExperimentRequest$experimentTemplateId' => '<p>The ID of the experiment template.</p>', 'UpdateExperimentTemplateRequest$id' => '<p>The ID of the experiment template.</p>', ], ], 'ExperimentTemplateStopCondition' => [ 'base' => '<p>Describes a stop condition for an experiment template.</p>', 'refs' => [ 'ExperimentTemplateStopConditionList$member' => NULL, ], ], 'ExperimentTemplateStopConditionList' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplate$stopConditions' => '<p>The stop conditions for the experiment.</p>', ], ], 'ExperimentTemplateSummary' => [ 'base' => '<p>Provides a summary of an experiment template.</p>', 'refs' => [ 'ExperimentTemplateSummaryList$member' => NULL, ], ], 'ExperimentTemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListExperimentTemplatesResponse$experimentTemplates' => '<p>The experiment templates.</p>', ], ], 'ExperimentTemplateTarget' => [ 'base' => '<p>Describes a target for an experiment template.</p>', 'refs' => [ 'ExperimentTemplateTargetMap$value' => NULL, ], ], 'ExperimentTemplateTargetFilter' => [ 'base' => '<p>Describes a filter used for the target resources in an experiment template.</p>', 'refs' => [ 'ExperimentTemplateTargetFilterList$member' => NULL, ], ], 'ExperimentTemplateTargetFilterInputList' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateTargetInput$filters' => '<p>The filters to apply to identify target resources using specific attributes.</p>', 'UpdateExperimentTemplateTargetInput$filters' => '<p>The filters to apply to identify target resources using specific attributes.</p>', ], ], 'ExperimentTemplateTargetFilterList' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateTarget$filters' => '<p>The filters to apply to identify target resources using specific attributes.</p>', ], ], 'ExperimentTemplateTargetFilterPath' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateTargetFilter$path' => '<p>The attribute path for the filter.</p>', 'ExperimentTemplateTargetInputFilter$path' => '<p>The attribute path for the filter.</p>', ], ], 'ExperimentTemplateTargetFilterValue' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateTargetFilterValues$member' => NULL, ], ], 'ExperimentTemplateTargetFilterValues' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateTargetFilter$values' => '<p>The attribute values for the filter.</p>', 'ExperimentTemplateTargetInputFilter$values' => '<p>The attribute values for the filter.</p>', ], ], 'ExperimentTemplateTargetInputFilter' => [ 'base' => '<p>Specifies a filter used for the target resource input in an experiment template.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters">Resource filters</a> in the <i>Fault Injection Simulator User Guide</i>.</p>', 'refs' => [ 'ExperimentTemplateTargetFilterInputList$member' => NULL, ], ], 'ExperimentTemplateTargetMap' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplate$targets' => '<p>The targets for the experiment.</p>', ], ], 'ExperimentTemplateTargetName' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateTargetInputMap$key' => NULL, 'ExperimentTemplateActionTargetMap$value' => NULL, 'ExperimentTemplateTargetMap$key' => NULL, 'UpdateExperimentTemplateTargetInputMap$key' => NULL, ], ], 'ExperimentTemplateTargetSelectionMode' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateTargetInput$selectionMode' => '<p>Scopes the identified resources to a specific count of the resources at random, or a percentage of the resources. All identified resources are included in the target.</p> <ul> <li> <p>ALL - Run the action on all identified targets. This is the default.</p> </li> <li> <p>COUNT(n) - Run the action on the specified number of targets, chosen from the identified targets at random. For example, COUNT(1) selects one of the targets.</p> </li> <li> <p>PERCENT(n) - Run the action on the specified percentage of targets, chosen from the identified targets at random. For example, PERCENT(25) selects 25% of the targets.</p> </li> </ul>', 'ExperimentTemplateTarget$selectionMode' => '<p>Scopes the identified resources to a specific count or percentage.</p>', 'UpdateExperimentTemplateTargetInput$selectionMode' => '<p>Scopes the identified resources to a specific count or percentage.</p>', ], ], 'GetActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'LastUpdateTime' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplate$lastUpdateTime' => '<p>The time the experiment template was last updated.</p>', 'ExperimentTemplateSummary$lastUpdateTime' => '<p>The time that the experiment template was last updated.</p>', ], ], 'ListActionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListActionsRequest$maxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentTemplatesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListExperimentTemplatesRequest$maxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListExperimentTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsRequest$maxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListExperimentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListActionsRequest$nextToken' => '<p>The token for the next page of results.</p>', 'ListActionsResponse$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListExperimentTemplatesRequest$nextToken' => '<p>The token for the next page of results.</p>', 'ListExperimentTemplatesResponse$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListExperimentsRequest$nextToken' => '<p>The token for the next page of results.</p>', 'ListExperimentsResponse$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ResourceArnList$member' => NULL, 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'ResourceArnList' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateTargetInput$resourceArns' => '<p>The Amazon Resource Names (ARNs) of the resources.</p>', 'ExperimentTarget$resourceArns' => '<p>The Amazon Resource Names (ARNs) of the resources.</p>', 'ExperimentTemplateTarget$resourceArns' => '<p>The Amazon Resource Names (ARNs) of the targets.</p>', 'UpdateExperimentTemplateTargetInput$resourceArns' => '<p>The Amazon Resource Names (ARNs) of the targets.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource cannot be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateTargetInput$resourceType' => '<p>The Amazon Web Services resource type. The resource type must be supported for the specified action.</p>', 'ExperimentTarget$resourceType' => '<p>The resource type.</p>', 'ExperimentTemplateTarget$resourceType' => '<p>The resource type.</p>', 'UpdateExperimentTemplateTargetInput$resourceType' => '<p>The Amazon Web Services resource type. The resource type must be supported for the specified action.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>', 'Experiment$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>', 'ExperimentTemplate$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role.</p>', 'UpdateExperimentTemplateRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded your service quota.</p>', 'refs' => [], ], 'StartExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopConditionSource' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateStopConditionInput$source' => '<p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop condition.</p>', 'ExperimentStopCondition$source' => '<p>The source for the stop condition.</p>', 'ExperimentTemplateStopCondition$source' => '<p>The source for the stop condition.</p>', 'UpdateExperimentTemplateStopConditionInput$source' => '<p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop condition.</p>', ], ], 'StopConditionValue' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateStopConditionInput$value' => '<p>The Amazon Resource Name (ARN) of the CloudWatch alarm. This is required if the source is a CloudWatch alarm.</p>', 'ExperimentStopCondition$value' => '<p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>', 'ExperimentTemplateStopCondition$value' => '<p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>', 'UpdateExperimentTemplateStopConditionInput$value' => '<p>The Amazon Resource Name (ARN) of the CloudWatch alarm.</p>', ], ], 'StopExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys to remove.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'Action$tags' => '<p>The tags for the action.</p>', 'ActionSummary$tags' => '<p>The tags for the action.</p>', 'CreateExperimentTemplateRequest$tags' => '<p>The tags to apply to the experiment template.</p>', 'CreateExperimentTemplateTargetInput$resourceTags' => '<p>The tags for the target resources.</p>', 'Experiment$tags' => '<p>The tags for the experiment.</p>', 'ExperimentSummary$tags' => '<p>The tags for the experiment.</p>', 'ExperimentTarget$resourceTags' => '<p>The tags for the target resources.</p>', 'ExperimentTemplate$tags' => '<p>The tags for the experiment template.</p>', 'ExperimentTemplateSummary$tags' => '<p>The tags for the experiment template.</p>', 'ExperimentTemplateTarget$resourceTags' => '<p>The tags for the target resources.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags for the resource.</p>', 'StartExperimentRequest$tags' => '<p>The tags to apply to the experiment.</p>', 'TagResourceRequest$tags' => '<p>The tags for the resource.</p>', 'UpdateExperimentTemplateTargetInput$resourceTags' => '<p>The tags for the target resources.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TargetResourceType' => [ 'base' => NULL, 'refs' => [ 'ActionTarget$resourceType' => '<p>The resource type of the target.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentTemplateActionInputItem' => [ 'base' => '<p>Specifies an action for an experiment template.</p>', 'refs' => [ 'UpdateExperimentTemplateActionInputMap$value' => NULL, ], ], 'UpdateExperimentTemplateActionInputMap' => [ 'base' => NULL, 'refs' => [ 'UpdateExperimentTemplateRequest$actions' => '<p>The actions for the experiment.</p>', ], ], 'UpdateExperimentTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentTemplateStopConditionInput' => [ 'base' => '<p>Specifies a stop condition for an experiment. You can define a stop condition as a CloudWatch alarm.</p>', 'refs' => [ 'UpdateExperimentTemplateStopConditionInputList$member' => NULL, ], ], 'UpdateExperimentTemplateStopConditionInputList' => [ 'base' => NULL, 'refs' => [ 'UpdateExperimentTemplateRequest$stopConditions' => '<p>The stop conditions for the experiment.</p>', ], ], 'UpdateExperimentTemplateTargetInput' => [ 'base' => '<p>Specifies a target for an experiment. You must specify at least one Amazon Resource Name (ARN) or at least one resource tag. You cannot specify both.</p>', 'refs' => [ 'UpdateExperimentTemplateTargetInputMap$value' => NULL, ], ], 'UpdateExperimentTemplateTargetInputMap' => [ 'base' => NULL, 'refs' => [ 'UpdateExperimentTemplateRequest$targets' => '<p>The targets for the experiment.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The specified input is not valid, or fails to satisfy the constraints for the request.</p>', 'refs' => [], ], ],];
