<?php
// This file was auto-generated from sdk-root/src/data/wisdom/2020-10-19/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2020-10-19', 'endpointPrefix' => 'wisdom', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'Amazon Connect Wisdom Service', 'serviceId' => 'Wisdom', 'signatureVersion' => 'v4', 'signingName' => 'wisdom', 'uid' => 'wisdom-2020-10-19', ], 'operations' => [ 'CreateAssistant' => [ 'name' => 'CreateAssistant', 'http' => [ 'method' => 'POST', 'requestUri' => '/assistants', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateAssistantRequest', ], 'output' => [ 'shape' => 'CreateAssistantResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'CreateAssistantAssociation' => [ 'name' => 'CreateAssistantAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/assistants/{assistantId}/associations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateAssistantAssociationRequest', ], 'output' => [ 'shape' => 'CreateAssistantAssociationResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateContent' => [ 'name' => 'CreateContent', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}/contents', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateContentRequest', ], 'output' => [ 'shape' => 'CreateContentResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateKnowledgeBase' => [ 'name' => 'CreateKnowledgeBase', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgeBases', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'CreateKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'CreateSession' => [ 'name' => 'CreateSession', 'http' => [ 'method' => 'POST', 'requestUri' => '/assistants/{assistantId}/sessions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSessionRequest', ], 'output' => [ 'shape' => 'CreateSessionResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteAssistant' => [ 'name' => 'DeleteAssistant', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/assistants/{assistantId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteAssistantRequest', ], 'output' => [ 'shape' => 'DeleteAssistantResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteAssistantAssociation' => [ 'name' => 'DeleteAssistantAssociation', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/assistants/{assistantId}/associations/{assistantAssociationId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteAssistantAssociationRequest', ], 'output' => [ 'shape' => 'DeleteAssistantAssociationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteContent' => [ 'name' => 'DeleteContent', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}/contents/{contentId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteContentRequest', ], 'output' => [ 'shape' => 'DeleteContentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteKnowledgeBase' => [ 'name' => 'DeleteKnowledgeBase', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'DeleteKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'GetAssistant' => [ 'name' => 'GetAssistant', 'http' => [ 'method' => 'GET', 'requestUri' => '/assistants/{assistantId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAssistantRequest', ], 'output' => [ 'shape' => 'GetAssistantResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetAssistantAssociation' => [ 'name' => 'GetAssistantAssociation', 'http' => [ 'method' => 'GET', 'requestUri' => '/assistants/{assistantId}/associations/{assistantAssociationId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAssistantAssociationRequest', ], 'output' => [ 'shape' => 'GetAssistantAssociationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetContent' => [ 'name' => 'GetContent', 'http' => [ 'method' => 'GET', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}/contents/{contentId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetContentRequest', ], 'output' => [ 'shape' => 'GetContentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetContentSummary' => [ 'name' => 'GetContentSummary', 'http' => [ 'method' => 'GET', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}/contents/{contentId}/summary', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetContentSummaryRequest', ], 'output' => [ 'shape' => 'GetContentSummaryResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetKnowledgeBase' => [ 'name' => 'GetKnowledgeBase', 'http' => [ 'method' => 'GET', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetKnowledgeBaseRequest', ], 'output' => [ 'shape' => 'GetKnowledgeBaseResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetRecommendations' => [ 'name' => 'GetRecommendations', 'http' => [ 'method' => 'GET', 'requestUri' => '/assistants/{assistantId}/sessions/{sessionId}/recommendations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetRecommendationsRequest', ], 'output' => [ 'shape' => 'GetRecommendationsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetSession' => [ 'name' => 'GetSession', 'http' => [ 'method' => 'GET', 'requestUri' => '/assistants/{assistantId}/sessions/{sessionId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSessionRequest', ], 'output' => [ 'shape' => 'GetSessionResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListAssistantAssociations' => [ 'name' => 'ListAssistantAssociations', 'http' => [ 'method' => 'GET', 'requestUri' => '/assistants/{assistantId}/associations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAssistantAssociationsRequest', ], 'output' => [ 'shape' => 'ListAssistantAssociationsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListAssistants' => [ 'name' => 'ListAssistants', 'http' => [ 'method' => 'GET', 'requestUri' => '/assistants', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAssistantsRequest', ], 'output' => [ 'shape' => 'ListAssistantsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListContents' => [ 'name' => 'ListContents', 'http' => [ 'method' => 'GET', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}/contents', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListContentsRequest', ], 'output' => [ 'shape' => 'ListContentsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListKnowledgeBases' => [ 'name' => 'ListKnowledgeBases', 'http' => [ 'method' => 'GET', 'requestUri' => '/knowledgeBases', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListKnowledgeBasesRequest', ], 'output' => [ 'shape' => 'ListKnowledgeBasesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], ], ], 'NotifyRecommendationsReceived' => [ 'name' => 'NotifyRecommendationsReceived', 'http' => [ 'method' => 'POST', 'requestUri' => '/assistants/{assistantId}/sessions/{sessionId}/recommendations/notify', 'responseCode' => 200, ], 'input' => [ 'shape' => 'NotifyRecommendationsReceivedRequest', ], 'output' => [ 'shape' => 'NotifyRecommendationsReceivedResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'PutFeedback' => [ 'name' => 'PutFeedback', 'http' => [ 'method' => 'PUT', 'requestUri' => '/assistants/{assistantId}/feedback', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutFeedbackRequest', ], 'output' => [ 'shape' => 'PutFeedbackResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'QueryAssistant' => [ 'name' => 'QueryAssistant', 'http' => [ 'method' => 'POST', 'requestUri' => '/assistants/{assistantId}/query', 'responseCode' => 200, ], 'input' => [ 'shape' => 'QueryAssistantRequest', ], 'output' => [ 'shape' => 'QueryAssistantResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'RemoveKnowledgeBaseTemplateUri' => [ 'name' => 'RemoveKnowledgeBaseTemplateUri', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}/templateUri', 'responseCode' => 204, ], 'input' => [ 'shape' => 'RemoveKnowledgeBaseTemplateUriRequest', ], 'output' => [ 'shape' => 'RemoveKnowledgeBaseTemplateUriResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'SearchContent' => [ 'name' => 'SearchContent', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}/search', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SearchContentRequest', ], 'output' => [ 'shape' => 'SearchContentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'SearchSessions' => [ 'name' => 'SearchSessions', 'http' => [ 'method' => 'POST', 'requestUri' => '/assistants/{assistantId}/searchSessions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SearchSessionsRequest', ], 'output' => [ 'shape' => 'SearchSessionsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'StartContentUpload' => [ 'name' => 'StartContentUpload', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}/upload', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartContentUploadRequest', ], 'output' => [ 'shape' => 'StartContentUploadResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'TooManyTagsException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateContent' => [ 'name' => 'UpdateContent', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}/contents/{contentId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateContentRequest', ], 'output' => [ 'shape' => 'UpdateContentResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'PreconditionFailedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateKnowledgeBaseTemplateUri' => [ 'name' => 'UpdateKnowledgeBaseTemplateUri', 'http' => [ 'method' => 'POST', 'requestUri' => '/knowledgeBases/{knowledgeBaseId}/templateUri', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateKnowledgeBaseTemplateUriRequest', ], 'output' => [ 'shape' => 'UpdateKnowledgeBaseTemplateUriResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AppIntegrationsConfiguration' => [ 'type' => 'structure', 'required' => [ 'appIntegrationArn', 'objectFields', ], 'members' => [ 'appIntegrationArn' => [ 'shape' => 'GenericArn', ], 'objectFields' => [ 'shape' => 'ObjectFieldsList', ], ], ], 'Arn' => [ 'type' => 'string', 'pattern' => '^arn:[a-z-]*?:wisdom:[a-z0-9-]*?:[0-9]{12}:[a-z-]*?/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}(?:/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})?$', ], 'AssistantAssociationData' => [ 'type' => 'structure', 'required' => [ 'assistantArn', 'assistantAssociationArn', 'assistantAssociationId', 'assistantId', 'associationData', 'associationType', ], 'members' => [ 'assistantArn' => [ 'shape' => 'Arn', ], 'assistantAssociationArn' => [ 'shape' => 'Arn', ], 'assistantAssociationId' => [ 'shape' => 'Uuid', ], 'assistantId' => [ 'shape' => 'Uuid', ], 'associationData' => [ 'shape' => 'AssistantAssociationOutputData', ], 'associationType' => [ 'shape' => 'AssociationType', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'AssistantAssociationInputData' => [ 'type' => 'structure', 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'Uuid', ], ], 'union' => true, ], 'AssistantAssociationOutputData' => [ 'type' => 'structure', 'members' => [ 'knowledgeBaseAssociation' => [ 'shape' => 'KnowledgeBaseAssociationData', ], ], 'union' => true, ], 'AssistantAssociationSummary' => [ 'type' => 'structure', 'required' => [ 'assistantArn', 'assistantAssociationArn', 'assistantAssociationId', 'assistantId', 'associationData', 'associationType', ], 'members' => [ 'assistantArn' => [ 'shape' => 'Arn', ], 'assistantAssociationArn' => [ 'shape' => 'Arn', ], 'assistantAssociationId' => [ 'shape' => 'Uuid', ], 'assistantId' => [ 'shape' => 'Uuid', ], 'associationData' => [ 'shape' => 'AssistantAssociationOutputData', ], 'associationType' => [ 'shape' => 'AssociationType', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'AssistantAssociationSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssistantAssociationSummary', ], ], 'AssistantData' => [ 'type' => 'structure', 'required' => [ 'assistantArn', 'assistantId', 'name', 'status', 'type', ], 'members' => [ 'assistantArn' => [ 'shape' => 'Arn', ], 'assistantId' => [ 'shape' => 'Uuid', ], 'description' => [ 'shape' => 'Description', ], 'name' => [ 'shape' => 'Name', ], 'serverSideEncryptionConfiguration' => [ 'shape' => 'ServerSideEncryptionConfiguration', ], 'status' => [ 'shape' => 'AssistantStatus', ], 'tags' => [ 'shape' => 'Tags', ], 'type' => [ 'shape' => 'AssistantType', ], ], ], 'AssistantList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssistantSummary', ], ], 'AssistantStatus' => [ 'type' => 'string', 'enum' => [ 'CREATE_IN_PROGRESS', 'CREATE_FAILED', 'ACTIVE', 'DELETE_IN_PROGRESS', 'DELETE_FAILED', 'DELETED', ], ], 'AssistantSummary' => [ 'type' => 'structure', 'required' => [ 'assistantArn', 'assistantId', 'name', 'status', 'type', ], 'members' => [ 'assistantArn' => [ 'shape' => 'Arn', ], 'assistantId' => [ 'shape' => 'Uuid', ], 'description' => [ 'shape' => 'Description', ], 'name' => [ 'shape' => 'Name', ], 'serverSideEncryptionConfiguration' => [ 'shape' => 'ServerSideEncryptionConfiguration', ], 'status' => [ 'shape' => 'AssistantStatus', ], 'tags' => [ 'shape' => 'Tags', ], 'type' => [ 'shape' => 'AssistantType', ], ], ], 'AssistantType' => [ 'type' => 'string', 'enum' => [ 'AGENT', ], ], 'AssociationType' => [ 'type' => 'string', 'enum' => [ 'KNOWLEDGE_BASE', ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'ClientToken' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ContentData' => [ 'type' => 'structure', 'required' => [ 'contentArn', 'contentId', 'contentType', 'knowledgeBaseArn', 'knowledgeBaseId', 'metadata', 'name', 'revisionId', 'status', 'title', 'url', 'urlExpiry', ], 'members' => [ 'contentArn' => [ 'shape' => 'Arn', ], 'contentId' => [ 'shape' => 'Uuid', ], 'contentType' => [ 'shape' => 'ContentType', ], 'knowledgeBaseArn' => [ 'shape' => 'Arn', ], 'knowledgeBaseId' => [ 'shape' => 'Uuid', ], 'linkOutUri' => [ 'shape' => 'Uri', ], 'metadata' => [ 'shape' => 'ContentMetadata', ], 'name' => [ 'shape' => 'Name', ], 'revisionId' => [ 'shape' => 'NonEmptyString', ], 'status' => [ 'shape' => 'ContentStatus', ], 'tags' => [ 'shape' => 'Tags', ], 'title' => [ 'shape' => 'ContentTitle', ], 'url' => [ 'shape' => 'Url', ], 'urlExpiry' => [ 'shape' => 'SyntheticTimestamp_epoch_seconds', ], ], ], 'ContentMetadata' => [ 'type' => 'map', 'key' => [ 'shape' => 'NonEmptyString', ], 'value' => [ 'shape' => 'NonEmptyString', ], 'max' => 10, 'min' => 0, ], 'ContentReference' => [ 'type' => 'structure', 'members' => [ 'contentArn' => [ 'shape' => 'Arn', ], 'contentId' => [ 'shape' => 'Uuid', ], 'knowledgeBaseArn' => [ 'shape' => 'Arn', ], 'knowledgeBaseId' => [ 'shape' => 'Uuid', ], ], ], 'ContentStatus' => [ 'type' => 'string', 'enum' => [ 'CREATE_IN_PROGRESS', 'CREATE_FAILED', 'ACTIVE', 'DELETE_IN_PROGRESS', 'DELETE_FAILED', 'DELETED', 'UPDATE_FAILED', ], ], 'ContentSummary' => [ 'type' => 'structure', 'required' => [ 'contentArn', 'contentId', 'contentType', 'knowledgeBaseArn', 'knowledgeBaseId', 'metadata', 'name', 'revisionId', 'status', 'title', ], 'members' => [ 'contentArn' => [ 'shape' => 'Arn', ], 'contentId' => [ 'shape' => 'Uuid', ], 'contentType' => [ 'shape' => 'ContentType', ], 'knowledgeBaseArn' => [ 'shape' => 'Arn', ], 'knowledgeBaseId' => [ 'shape' => 'Uuid', ], 'metadata' => [ 'shape' => 'ContentMetadata', ], 'name' => [ 'shape' => 'Name', ], 'revisionId' => [ 'shape' => 'NonEmptyString', ], 'status' => [ 'shape' => 'ContentStatus', ], 'tags' => [ 'shape' => 'Tags', ], 'title' => [ 'shape' => 'ContentTitle', ], ], ], 'ContentSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContentSummary', ], ], 'ContentTitle' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'ContentType' => [ 'type' => 'string', 'pattern' => '^(text/(plain|html))|(application/x\\.wisdom-json;source=(salesforce|servicenow|zendesk))$', ], 'CreateAssistantAssociationRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', 'association', 'associationType', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], 'association' => [ 'shape' => 'AssistantAssociationInputData', ], 'associationType' => [ 'shape' => 'AssociationType', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateAssistantAssociationResponse' => [ 'type' => 'structure', 'members' => [ 'assistantAssociation' => [ 'shape' => 'AssistantAssociationData', ], ], ], 'CreateAssistantRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'type', ], 'members' => [ 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'Description', ], 'name' => [ 'shape' => 'Name', ], 'serverSideEncryptionConfiguration' => [ 'shape' => 'ServerSideEncryptionConfiguration', ], 'tags' => [ 'shape' => 'Tags', ], 'type' => [ 'shape' => 'AssistantType', ], ], ], 'CreateAssistantResponse' => [ 'type' => 'structure', 'members' => [ 'assistant' => [ 'shape' => 'AssistantData', ], ], ], 'CreateContentRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'name', 'uploadId', ], 'members' => [ 'clientToken' => [ 'shape' => 'NonEmptyString', 'idempotencyToken' => true, ], 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'metadata' => [ 'shape' => 'ContentMetadata', ], 'name' => [ 'shape' => 'Name', ], 'overrideLinkOutUri' => [ 'shape' => 'Uri', ], 'tags' => [ 'shape' => 'Tags', ], 'title' => [ 'shape' => 'ContentTitle', ], 'uploadId' => [ 'shape' => 'NonEmptyString', ], ], ], 'CreateContentResponse' => [ 'type' => 'structure', 'members' => [ 'content' => [ 'shape' => 'ContentData', ], ], ], 'CreateKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseType', 'name', ], 'members' => [ 'clientToken' => [ 'shape' => 'NonEmptyString', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'Description', ], 'knowledgeBaseType' => [ 'shape' => 'KnowledgeBaseType', ], 'name' => [ 'shape' => 'Name', ], 'renderingConfiguration' => [ 'shape' => 'RenderingConfiguration', ], 'serverSideEncryptionConfiguration' => [ 'shape' => 'ServerSideEncryptionConfiguration', ], 'sourceConfiguration' => [ 'shape' => 'SourceConfiguration', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateKnowledgeBaseResponse' => [ 'type' => 'structure', 'members' => [ 'knowledgeBase' => [ 'shape' => 'KnowledgeBaseData', ], ], ], 'CreateSessionRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', 'name', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'Description', ], 'name' => [ 'shape' => 'Name', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateSessionResponse' => [ 'type' => 'structure', 'members' => [ 'session' => [ 'shape' => 'SessionData', ], ], ], 'DeleteAssistantAssociationRequest' => [ 'type' => 'structure', 'required' => [ 'assistantAssociationId', 'assistantId', ], 'members' => [ 'assistantAssociationId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantAssociationId', ], 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], ], ], 'DeleteAssistantAssociationResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteAssistantRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], ], ], 'DeleteAssistantResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteContentRequest' => [ 'type' => 'structure', 'required' => [ 'contentId', 'knowledgeBaseId', ], 'members' => [ 'contentId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'contentId', ], 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'DeleteContentResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'DeleteKnowledgeBaseResponse' => [ 'type' => 'structure', 'members' => [], ], 'Description' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^[a-zA-Z0-9\\s_.,-]+', ], 'Document' => [ 'type' => 'structure', 'required' => [ 'contentReference', ], 'members' => [ 'contentReference' => [ 'shape' => 'ContentReference', ], 'excerpt' => [ 'shape' => 'DocumentText', ], 'title' => [ 'shape' => 'DocumentText', ], ], ], 'DocumentText' => [ 'type' => 'structure', 'members' => [ 'highlights' => [ 'shape' => 'Highlights', ], 'text' => [ 'shape' => 'SensitiveString', ], ], ], 'FeedbackData' => [ 'type' => 'structure', 'required' => [ 'relevance', ], 'members' => [ 'relevance' => [ 'shape' => 'Relevance', ], ], ], 'Filter' => [ 'type' => 'structure', 'required' => [ 'field', 'operator', 'value', ], 'members' => [ 'field' => [ 'shape' => 'FilterField', ], 'operator' => [ 'shape' => 'FilterOperator', ], 'value' => [ 'shape' => 'NonEmptyString', ], ], ], 'FilterField' => [ 'type' => 'string', 'enum' => [ 'NAME', ], ], 'FilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Filter', ], ], 'FilterOperator' => [ 'type' => 'string', 'enum' => [ 'EQUALS', ], ], 'GenericArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '^arn:[a-z-]+?:[a-z-]+?:[a-z0-9-]*?:([0-9]{12})?:[a-zA-Z0-9-:/]+$', ], 'GetAssistantAssociationRequest' => [ 'type' => 'structure', 'required' => [ 'assistantAssociationId', 'assistantId', ], 'members' => [ 'assistantAssociationId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantAssociationId', ], 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], ], ], 'GetAssistantAssociationResponse' => [ 'type' => 'structure', 'members' => [ 'assistantAssociation' => [ 'shape' => 'AssistantAssociationData', ], ], ], 'GetAssistantRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], ], ], 'GetAssistantResponse' => [ 'type' => 'structure', 'members' => [ 'assistant' => [ 'shape' => 'AssistantData', ], ], ], 'GetContentRequest' => [ 'type' => 'structure', 'required' => [ 'contentId', 'knowledgeBaseId', ], 'members' => [ 'contentId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'contentId', ], 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'GetContentResponse' => [ 'type' => 'structure', 'members' => [ 'content' => [ 'shape' => 'ContentData', ], ], ], 'GetContentSummaryRequest' => [ 'type' => 'structure', 'required' => [ 'contentId', 'knowledgeBaseId', ], 'members' => [ 'contentId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'contentId', ], 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'GetContentSummaryResponse' => [ 'type' => 'structure', 'members' => [ 'contentSummary' => [ 'shape' => 'ContentSummary', ], ], ], 'GetKnowledgeBaseRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'GetKnowledgeBaseResponse' => [ 'type' => 'structure', 'members' => [ 'knowledgeBase' => [ 'shape' => 'KnowledgeBaseData', ], ], ], 'GetRecommendationsRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', 'sessionId', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sessionId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'sessionId', ], 'waitTimeSeconds' => [ 'shape' => 'WaitTimeSeconds', 'location' => 'querystring', 'locationName' => 'waitTimeSeconds', ], ], ], 'GetRecommendationsResponse' => [ 'type' => 'structure', 'required' => [ 'recommendations', ], 'members' => [ 'recommendations' => [ 'shape' => 'RecommendationList', ], 'triggers' => [ 'shape' => 'RecommendationTriggerList', ], ], ], 'GetSessionRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', 'sessionId', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], 'sessionId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'sessionId', ], ], ], 'GetSessionResponse' => [ 'type' => 'structure', 'members' => [ 'session' => [ 'shape' => 'SessionData', ], ], ], 'Headers' => [ 'type' => 'map', 'key' => [ 'shape' => 'NonEmptyString', ], 'value' => [ 'shape' => 'NonEmptyString', ], ], 'Highlight' => [ 'type' => 'structure', 'members' => [ 'beginOffsetInclusive' => [ 'shape' => 'HighlightOffset', ], 'endOffsetExclusive' => [ 'shape' => 'HighlightOffset', ], ], ], 'HighlightOffset' => [ 'type' => 'integer', ], 'Highlights' => [ 'type' => 'list', 'member' => [ 'shape' => 'Highlight', ], ], 'KnowledgeBaseAssociationData' => [ 'type' => 'structure', 'members' => [ 'knowledgeBaseArn' => [ 'shape' => 'Arn', ], 'knowledgeBaseId' => [ 'shape' => 'Uuid', ], ], ], 'KnowledgeBaseData' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseArn', 'knowledgeBaseId', 'knowledgeBaseType', 'name', 'status', ], 'members' => [ 'description' => [ 'shape' => 'Description', ], 'knowledgeBaseArn' => [ 'shape' => 'Arn', ], 'knowledgeBaseId' => [ 'shape' => 'Uuid', ], 'knowledgeBaseType' => [ 'shape' => 'KnowledgeBaseType', ], 'lastContentModificationTime' => [ 'shape' => 'SyntheticTimestamp_epoch_seconds', ], 'name' => [ 'shape' => 'Name', ], 'renderingConfiguration' => [ 'shape' => 'RenderingConfiguration', ], 'serverSideEncryptionConfiguration' => [ 'shape' => 'ServerSideEncryptionConfiguration', ], 'sourceConfiguration' => [ 'shape' => 'SourceConfiguration', ], 'status' => [ 'shape' => 'KnowledgeBaseStatus', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'KnowledgeBaseList' => [ 'type' => 'list', 'member' => [ 'shape' => 'KnowledgeBaseSummary', ], ], 'KnowledgeBaseStatus' => [ 'type' => 'string', 'enum' => [ 'CREATE_IN_PROGRESS', 'CREATE_FAILED', 'ACTIVE', 'DELETE_IN_PROGRESS', 'DELETE_FAILED', 'DELETED', ], ], 'KnowledgeBaseSummary' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseArn', 'knowledgeBaseId', 'knowledgeBaseType', 'name', 'status', ], 'members' => [ 'description' => [ 'shape' => 'Description', ], 'knowledgeBaseArn' => [ 'shape' => 'Arn', ], 'knowledgeBaseId' => [ 'shape' => 'Uuid', ], 'knowledgeBaseType' => [ 'shape' => 'KnowledgeBaseType', ], 'name' => [ 'shape' => 'Name', ], 'renderingConfiguration' => [ 'shape' => 'RenderingConfiguration', ], 'serverSideEncryptionConfiguration' => [ 'shape' => 'ServerSideEncryptionConfiguration', ], 'sourceConfiguration' => [ 'shape' => 'SourceConfiguration', ], 'status' => [ 'shape' => 'KnowledgeBaseStatus', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'KnowledgeBaseType' => [ 'type' => 'string', 'enum' => [ 'EXTERNAL', 'CUSTOM', ], ], 'ListAssistantAssociationsRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListAssistantAssociationsResponse' => [ 'type' => 'structure', 'required' => [ 'assistantAssociationSummaries', ], 'members' => [ 'assistantAssociationSummaries' => [ 'shape' => 'AssistantAssociationSummaryList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAssistantsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListAssistantsResponse' => [ 'type' => 'structure', 'required' => [ 'assistantSummaries', ], 'members' => [ 'assistantSummaries' => [ 'shape' => 'AssistantList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListContentsRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListContentsResponse' => [ 'type' => 'structure', 'required' => [ 'contentSummaries', ], 'members' => [ 'contentSummaries' => [ 'shape' => 'ContentSummaryList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListKnowledgeBasesRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NonEmptyString', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListKnowledgeBasesResponse' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseSummaries', ], 'members' => [ 'knowledgeBaseSummaries' => [ 'shape' => 'KnowledgeBaseList', ], 'nextToken' => [ 'shape' => 'NonEmptyString', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'Arn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'Tags', ], ], ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'Name' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^[a-zA-Z0-9\\s_.,-]+', ], 'NextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'NonEmptyString' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, ], 'NotifyRecommendationsReceivedError' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NotifyRecommendationsReceivedErrorMessage', ], 'recommendationId' => [ 'shape' => 'String', ], ], ], 'NotifyRecommendationsReceivedErrorList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NotifyRecommendationsReceivedError', ], ], 'NotifyRecommendationsReceivedErrorMessage' => [ 'type' => 'string', ], 'NotifyRecommendationsReceivedRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', 'recommendationIds', 'sessionId', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], 'recommendationIds' => [ 'shape' => 'RecommendationIdList', ], 'sessionId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'sessionId', ], ], ], 'NotifyRecommendationsReceivedResponse' => [ 'type' => 'structure', 'members' => [ 'errors' => [ 'shape' => 'NotifyRecommendationsReceivedErrorList', ], 'recommendationIds' => [ 'shape' => 'RecommendationIdList', ], ], ], 'ObjectFieldsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NonEmptyString', ], 'max' => 100, 'min' => 1, ], 'PreconditionFailedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 412, 'senderFault' => true, ], 'exception' => true, ], 'PutFeedbackRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', 'feedback', 'targetId', 'targetType', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], 'feedback' => [ 'shape' => 'FeedbackData', ], 'targetId' => [ 'shape' => 'String', ], 'targetType' => [ 'shape' => 'TargetType', ], ], ], 'PutFeedbackResponse' => [ 'type' => 'structure', 'required' => [ 'assistantArn', 'assistantId', 'feedback', 'targetId', 'targetType', ], 'members' => [ 'assistantArn' => [ 'shape' => 'UuidOrArn', ], 'assistantId' => [ 'shape' => 'Uuid', ], 'feedback' => [ 'shape' => 'FeedbackData', ], 'targetId' => [ 'shape' => 'Uuid', ], 'targetType' => [ 'shape' => 'TargetType', ], ], ], 'QueryAssistantRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', 'queryText', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], 'queryText' => [ 'shape' => 'QueryText', ], ], ], 'QueryAssistantResponse' => [ 'type' => 'structure', 'required' => [ 'results', ], 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', ], 'results' => [ 'shape' => 'QueryResultsList', ], ], ], 'QueryRecommendationTriggerData' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'QueryText', ], ], ], 'QueryResultsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResultData', ], ], 'QueryText' => [ 'type' => 'string', 'sensitive' => true, ], 'RecommendationData' => [ 'type' => 'structure', 'required' => [ 'document', 'recommendationId', ], 'members' => [ 'document' => [ 'shape' => 'Document', ], 'recommendationId' => [ 'shape' => 'String', ], 'relevanceLevel' => [ 'shape' => 'RelevanceLevel', ], 'relevanceScore' => [ 'shape' => 'RelevanceScore', ], 'type' => [ 'shape' => 'RecommendationType', ], ], ], 'RecommendationIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'RecommendationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RecommendationData', ], ], 'RecommendationSourceType' => [ 'type' => 'string', 'enum' => [ 'ISSUE_DETECTION', 'RULE_EVALUATION', 'OTHER', ], ], 'RecommendationTrigger' => [ 'type' => 'structure', 'required' => [ 'data', 'id', 'recommendationIds', 'source', 'type', ], 'members' => [ 'data' => [ 'shape' => 'RecommendationTriggerData', ], 'id' => [ 'shape' => 'Uuid', ], 'recommendationIds' => [ 'shape' => 'RecommendationIdList', ], 'source' => [ 'shape' => 'RecommendationSourceType', ], 'type' => [ 'shape' => 'RecommendationTriggerType', ], ], ], 'RecommendationTriggerData' => [ 'type' => 'structure', 'members' => [ 'query' => [ 'shape' => 'QueryRecommendationTriggerData', ], ], 'union' => true, ], 'RecommendationTriggerList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RecommendationTrigger', ], ], 'RecommendationTriggerType' => [ 'type' => 'string', 'enum' => [ 'QUERY', ], ], 'RecommendationType' => [ 'type' => 'string', 'enum' => [ 'KNOWLEDGE_CONTENT', ], ], 'Relevance' => [ 'type' => 'string', 'enum' => [ 'HELPFUL', 'NOT_HELPFUL', ], ], 'RelevanceLevel' => [ 'type' => 'string', 'enum' => [ 'HIGH', 'MEDIUM', 'LOW', ], ], 'RelevanceScore' => [ 'type' => 'double', 'min' => 0, ], 'RemoveKnowledgeBaseTemplateUriRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'RemoveKnowledgeBaseTemplateUriResponse' => [ 'type' => 'structure', 'members' => [], ], 'RenderingConfiguration' => [ 'type' => 'structure', 'members' => [ 'templateUri' => [ 'shape' => 'Uri', ], ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceName' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResultData' => [ 'type' => 'structure', 'required' => [ 'document', 'resultId', ], 'members' => [ 'document' => [ 'shape' => 'Document', ], 'relevanceScore' => [ 'shape' => 'RelevanceScore', ], 'resultId' => [ 'shape' => 'Uuid', ], ], ], 'SearchContentRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'searchExpression', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'searchExpression' => [ 'shape' => 'SearchExpression', ], ], ], 'SearchContentResponse' => [ 'type' => 'structure', 'required' => [ 'contentSummaries', ], 'members' => [ 'contentSummaries' => [ 'shape' => 'ContentSummaryList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'SearchExpression' => [ 'type' => 'structure', 'required' => [ 'filters', ], 'members' => [ 'filters' => [ 'shape' => 'FilterList', ], ], ], 'SearchSessionsRequest' => [ 'type' => 'structure', 'required' => [ 'assistantId', 'searchExpression', ], 'members' => [ 'assistantId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'assistantId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'searchExpression' => [ 'shape' => 'SearchExpression', ], ], ], 'SearchSessionsResponse' => [ 'type' => 'structure', 'required' => [ 'sessionSummaries', ], 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', ], 'sessionSummaries' => [ 'shape' => 'SessionSummaries', ], ], ], 'SensitiveString' => [ 'type' => 'string', 'sensitive' => true, ], 'ServerSideEncryptionConfiguration' => [ 'type' => 'structure', 'members' => [ 'kmsKeyId' => [ 'shape' => 'NonEmptyString', ], ], ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SessionData' => [ 'type' => 'structure', 'required' => [ 'name', 'sessionArn', 'sessionId', ], 'members' => [ 'description' => [ 'shape' => 'Description', ], 'name' => [ 'shape' => 'Name', ], 'sessionArn' => [ 'shape' => 'Arn', ], 'sessionId' => [ 'shape' => 'Uuid', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'SessionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'SessionSummary', ], ], 'SessionSummary' => [ 'type' => 'structure', 'required' => [ 'assistantArn', 'assistantId', 'sessionArn', 'sessionId', ], 'members' => [ 'assistantArn' => [ 'shape' => 'Arn', ], 'assistantId' => [ 'shape' => 'Uuid', ], 'sessionArn' => [ 'shape' => 'Arn', ], 'sessionId' => [ 'shape' => 'Uuid', ], ], ], 'SourceConfiguration' => [ 'type' => 'structure', 'members' => [ 'appIntegrations' => [ 'shape' => 'AppIntegrationsConfiguration', ], ], 'union' => true, ], 'StartContentUploadRequest' => [ 'type' => 'structure', 'required' => [ 'contentType', 'knowledgeBaseId', ], 'members' => [ 'contentType' => [ 'shape' => 'ContentType', ], 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], ], ], 'StartContentUploadResponse' => [ 'type' => 'structure', 'required' => [ 'headersToInclude', 'uploadId', 'url', 'urlExpiry', ], 'members' => [ 'headersToInclude' => [ 'shape' => 'Headers', ], 'uploadId' => [ 'shape' => 'NonEmptyString', ], 'url' => [ 'shape' => 'Url', ], 'urlExpiry' => [ 'shape' => 'SyntheticTimestamp_epoch_seconds', ], ], ], 'String' => [ 'type' => 'string', ], 'SyntheticTimestamp_epoch_seconds' => [ 'type' => 'timestamp', 'timestampFormat' => 'unixTimestamp', ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!aws:)[a-zA-Z+-=._:/]+$', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 50, 'min' => 1, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'Arn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'Tags' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], ], 'TargetType' => [ 'type' => 'string', 'enum' => [ 'RECOMMENDATION', 'RESULT', ], ], 'TooManyTagsException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceName' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'Arn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateContentRequest' => [ 'type' => 'structure', 'required' => [ 'contentId', 'knowledgeBaseId', ], 'members' => [ 'contentId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'contentId', ], 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'metadata' => [ 'shape' => 'ContentMetadata', ], 'overrideLinkOutUri' => [ 'shape' => 'Uri', ], 'removeOverrideLinkOutUri' => [ 'shape' => 'Boolean', ], 'revisionId' => [ 'shape' => 'NonEmptyString', ], 'title' => [ 'shape' => 'ContentTitle', ], 'uploadId' => [ 'shape' => 'NonEmptyString', ], ], ], 'UpdateContentResponse' => [ 'type' => 'structure', 'members' => [ 'content' => [ 'shape' => 'ContentData', ], ], ], 'UpdateKnowledgeBaseTemplateUriRequest' => [ 'type' => 'structure', 'required' => [ 'knowledgeBaseId', 'templateUri', ], 'members' => [ 'knowledgeBaseId' => [ 'shape' => 'UuidOrArn', 'location' => 'uri', 'locationName' => 'knowledgeBaseId', ], 'templateUri' => [ 'shape' => 'Uri', ], ], ], 'UpdateKnowledgeBaseTemplateUriResponse' => [ 'type' => 'structure', 'members' => [ 'knowledgeBase' => [ 'shape' => 'KnowledgeBaseData', ], ], ], 'Uri' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, ], 'Url' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, 'sensitive' => true, ], 'Uuid' => [ 'type' => 'string', 'pattern' => '^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$', ], 'UuidOrArn' => [ 'type' => 'string', 'pattern' => '^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$|^arn:[a-z-]*?:wisdom:[a-z0-9-]*?:[0-9]{12}:[a-z-]*?/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}(?:/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})?$', ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'WaitTimeSeconds' => [ 'type' => 'integer', 'max' => 20, 'min' => 0, ], ],];
