<?php
// This file was auto-generated from sdk-root/src/data/wafv2/2019-07-29/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>WAF</fullname> <note> <p>This is the latest version of the <b>WAF</b> API, released in November, 2019. The names of the entities that you use to access this API, like endpoints and namespaces, all have the versioning information added, like "V2" or "v2", to distinguish from the prior version. We recommend migrating your resources to this version, because it has a number of significant improvements.</p> <p>If you used WAF prior to this release, you can\'t use this WAFV2 API to access any WAF resources that you created before. You can access your old rules, web ACLs, and other WAF resources only through the WAF Classic APIs. The WAF Classic APIs have retained the prior names, endpoints, and namespaces. </p> <p>For information, including how to migrate your WAF resources to this version, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p> </note> <p>WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to Amazon CloudFront, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API. WAF also lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, the Amazon API Gateway REST API, CloudFront distribution, the Application Load Balancer, or the AppSync GraphQL API responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You also can configure CloudFront to return a custom error page when a request is blocked.</p> <p>This API guide is for developers who need detailed information about WAF API actions, data types, and errors. For detailed information about WAF features and an overview of how to use WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF Developer Guide</a>.</p> <p>You can make calls using the endpoints listed in <a href="https://docs.aws.amazon.com/general/latest/gr/waf.html">WAF endpoints and quotas</a>. </p> <ul> <li> <p>For regional applications, you can use any of the endpoints in the list. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> </li> <li> <p>For Amazon CloudFront applications, you must use the API endpoint listed for US East (N. Virginia): us-east-1.</p> </li> </ul> <p>Alternatively, you can use one of the Amazon Web Services SDKs to access an API that\'s tailored to the programming language or platform that you\'re using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">Amazon Web Services SDKs</a>.</p> <p>We currently provide two versions of the WAF API: this API and the prior versions, the classic WAF APIs. This new API provides the same functionality as the older versions, with the following major improvements:</p> <ul> <li> <p>You use one API for both global and regional applications. Where you need to distinguish the scope, you specify a <code>Scope</code> parameter and set it to <code>CLOUDFRONT</code> or <code>REGIONAL</code>. </p> </li> <li> <p>You can define a web ACL or rule group with a single call, and update it with a single call. You define all rule specifications in JSON format, and pass them to your rule group or web ACL calls.</p> </li> <li> <p>The limits WAF places on the use of rules more closely reflects the cost of running each type of rule. Rule groups include capacity settings, so you know the maximum cost of a rule group when you use it.</p> </li> </ul>', 'operations' => [ 'AssociateWebACL' => '<p>Associates a web ACL with a regional application resource, to protect the resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>For Amazon CloudFront, don\'t use this call. Instead, use your CloudFront distribution configuration. To associate a web ACL, in the CloudFront call <code>UpdateDistribution</code>, set the web ACL ID to the Amazon Resource Name (ARN) of the web ACL. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a>.</p>', 'CheckCapacity' => '<p>Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to check the capacity requirements for the rules you want to use in a <a>RuleGroup</a> or <a>WebACL</a>. </p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>', 'CreateIPSet' => '<p>Creates an <a>IPSet</a>, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you\'re receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses. </p>', 'CreateRegexPatternSet' => '<p>Creates a <a>RegexPatternSet</a>, which you reference in a <a>RegexPatternSetReferenceStatement</a>, to have WAF inspect a web request component for the specified patterns.</p>', 'CreateRuleGroup' => '<p>Creates a <a>RuleGroup</a> per the specifications provided. </p> <p> A rule group defines a collection of rules to inspect and control web requests that you can use in a <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements. </p>', 'CreateWebACL' => '<p>Creates a <a>WebACL</a> per the specifications provided.</p> <p> A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API. </p>', 'DeleteFirewallManagerRuleGroups' => '<p>Deletes all rule groups that are managed by Firewall Manager for the specified web ACL. </p> <p>You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>. </p>', 'DeleteIPSet' => '<p>Deletes the specified <a>IPSet</a>. </p>', 'DeleteLoggingConfiguration' => '<p>Deletes the <a>LoggingConfiguration</a> from the specified web ACL.</p>', 'DeletePermissionPolicy' => '<p>Permanently deletes an IAM policy from the specified rule group.</p> <p>You must be the owner of the rule group to perform this operation.</p>', 'DeleteRegexPatternSet' => '<p>Deletes the specified <a>RegexPatternSet</a>.</p>', 'DeleteRuleGroup' => '<p>Deletes the specified <a>RuleGroup</a>.</p>', 'DeleteWebACL' => '<p>Deletes the specified <a>WebACL</a>.</p> <p>You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>. </p>', 'DescribeManagedRuleGroup' => '<p>Provides high-level information for a managed rule group, including descriptions of the rules. </p>', 'DisassociateWebACL' => '<p>Disassociates a web ACL from a regional application resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>For Amazon CloudFront, don\'t use this call. Instead, use your CloudFront distribution configuration. To disassociate a web ACL, provide an empty web ACL ID in the CloudFront call <code>UpdateDistribution</code>. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a>.</p>', 'GenerateMobileSdkReleaseUrl' => '<p>Generates a presigned download URL for the specified release of the mobile SDK.</p> <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. </p>', 'GetIPSet' => '<p>Retrieves the specified <a>IPSet</a>.</p>', 'GetLoggingConfiguration' => '<p>Returns the <a>LoggingConfiguration</a> for the specified web ACL.</p>', 'GetManagedRuleSet' => '<p>Retrieves the specified managed rule set. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'GetMobileSdkRelease' => '<p>Retrieves information for the specified mobile SDK release, including release notes and tags.</p> <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. </p>', 'GetPermissionPolicy' => '<p>Returns the IAM policy that is attached to the specified rule group.</p> <p>You must be the owner of the rule group to perform this operation.</p>', 'GetRateBasedStatementManagedKeys' => '<p>Retrieves the keys that are currently blocked by a rate-based rule instance. The maximum number of managed keys that can be blocked for a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, those with the highest rates are blocked.</p> <p>For a rate-based rule that you\'ve defined inside a rule group, provide the name of the rule group reference statement in your request, in addition to the rate-based rule name and the web ACL name. </p> <p>WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web requests and manages keys for this second usage completely independent of your first. </p>', 'GetRegexPatternSet' => '<p>Retrieves the specified <a>RegexPatternSet</a>.</p>', 'GetRuleGroup' => '<p>Retrieves the specified <a>RuleGroup</a>.</p>', 'GetSampledRequests' => '<p>Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.</p> <p> <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the actual period during which WAF selected the requests in the sample.</p>', 'GetWebACL' => '<p>Retrieves the specified <a>WebACL</a>.</p>', 'GetWebACLForResource' => '<p>Retrieves the <a>WebACL</a> for the specified resource. </p>', 'ListAvailableManagedRuleGroupVersions' => '<p>Returns a list of the available versions for the specified managed rule group. </p>', 'ListAvailableManagedRuleGroups' => '<p>Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you\'re subscribed to.</p>', 'ListIPSets' => '<p>Retrieves an array of <a>IPSetSummary</a> objects for the IP sets that you manage.</p>', 'ListLoggingConfigurations' => '<p>Retrieves an array of your <a>LoggingConfiguration</a> objects.</p>', 'ListManagedRuleSets' => '<p>Retrieves the managed rule sets that you own. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'ListMobileSdkReleases' => '<p>Retrieves a list of the available releases for the mobile SDK and the specified device platform. </p> <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. </p>', 'ListRegexPatternSets' => '<p>Retrieves an array of <a>RegexPatternSetSummary</a> objects for the regex pattern sets that you manage.</p>', 'ListResourcesForWebACL' => '<p>Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call <code>ListDistributionsByWebACLId</code>. </p>', 'ListRuleGroups' => '<p>Retrieves an array of <a>RuleGroupSummary</a> objects for the rule groups that you manage. </p>', 'ListTagsForResource' => '<p>Retrieves the <a>TagInfoForResource</a> for the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can\'t manage or view tags through the WAF console. </p>', 'ListWebACLs' => '<p>Retrieves an array of <a>WebACLSummary</a> objects for the web ACLs that you manage.</p>', 'PutLoggingConfiguration' => '<p>Enables the specified <a>LoggingConfiguration</a>, to start logging from a web ACL, according to the configuration provided.</p> <p>You can access information about all traffic that WAF inspects using the following steps:</p> <ol> <li> <p>Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose. For information about configuring logging destinations and the permissions that are required for each, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p> </li> <li> <p>Associate your logging destination to your web ACL using a <code>PutLoggingConfiguration</code> request.</p> </li> </ol> <p>When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.</p> <note> <p>This operation completely replaces the mutable specifications that you already have for the logging configuration with the ones that you provide to this call. To modify the logging configuration, retrieve it by calling <a>GetLoggingConfiguration</a>, update the settings as needed, and then provide the complete logging configuration specification to this call.</p> </note>', 'PutManagedRuleSetVersions' => '<p>Defines the versions of your managed rule set that you are offering to the customers. Customers see your offerings as managed rule groups with versioning.</p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note> <p>Customers retrieve their managed rule group list by calling <a>ListAvailableManagedRuleGroups</a>. The name that you provide here for your managed rule set is the name the customer sees for the corresponding managed rule group. Customers can retrieve the available versions for a managed rule group by calling <a>ListAvailableManagedRuleGroupVersions</a>. You provide a rule group specification for each version. For each managed rule set, you must specify a version that you recommend using. </p> <p>To initiate the expiration of a managed rule group version, use <a>UpdateManagedRuleSetVersionExpiryDate</a>.</p>', 'PutPermissionPolicy' => '<p>Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.</p> <p>You must be the owner of the rule group to perform this operation.</p> <p>This action is subject to the following restrictions:</p> <ul> <li> <p>You can attach only one policy with each <code>PutPermissionPolicy</code> request.</p> </li> <li> <p>The ARN in the request must be a valid WAF <a>RuleGroup</a> ARN and the rule group must exist in the same Region.</p> </li> <li> <p>The user making the request must be the owner of the rule group.</p> </li> </ul>', 'TagResource' => '<p>Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can\'t manage or view tags through the WAF console. </p>', 'UntagResource' => '<p>Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon Web Services resource.</p>', 'UpdateIPSet' => '<p>Updates the specified <a>IPSet</a>. </p> <note> <p>This operation completely replaces the mutable specifications that you already have for the IP set with the ones that you provide to this call. To modify the IP set, retrieve it by calling <a>GetIPSet</a>, update the settings as needed, and then provide the complete IP set specification to this call.</p> </note>', 'UpdateManagedRuleSetVersionExpiryDate' => '<p>Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed rule group version. After you initiate expiration for a version, WAF excludes it from the reponse to <a>ListAvailableManagedRuleGroupVersions</a> for the managed rule group. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'UpdateRegexPatternSet' => '<p>Updates the specified <a>RegexPatternSet</a>.</p> <note> <p>This operation completely replaces the mutable specifications that you already have for the regex pattern set with the ones that you provide to this call. To modify the regex pattern set, retrieve it by calling <a>GetRegexPatternSet</a>, update the settings as needed, and then provide the complete regex pattern set specification to this call.</p> </note>', 'UpdateRuleGroup' => '<p>Updates the specified <a>RuleGroup</a>.</p> <note> <p>This operation completely replaces the mutable specifications that you already have for the rule group with the ones that you provide to this call. To modify the rule group, retrieve it by calling <a>GetRuleGroup</a>, update the settings as needed, and then provide the complete rule group specification to this call.</p> </note> <p> A rule group defines a collection of rules to inspect and control web requests that you can use in a <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements. </p>', 'UpdateWebACL' => '<p>Updates the specified <a>WebACL</a>.</p> <note> <p>This operation completely replaces the mutable specifications that you already have for the web ACL with the ones that you provide to this call. To modify the web ACL, retrieve it by calling <a>GetWebACL</a>, update the settings as needed, and then provide the complete web ACL specification to this call.</p> </note> <p> A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API. </p>', ], 'shapes' => [ 'Action' => [ 'base' => NULL, 'refs' => [ 'SampledHTTPRequest$Action' => '<p>The action for the <code>Rule</code> that the request matched: <code>Allow</code>, <code>Block</code>, or <code>Count</code>.</p>', ], ], 'ActionCondition' => [ 'base' => '<p>A single action condition for a <a>Condition</a> in a logging filter.</p>', 'refs' => [ 'Condition$ActionCondition' => '<p>A single action condition.</p>', ], ], 'ActionValue' => [ 'base' => NULL, 'refs' => [ 'ActionCondition$Action' => '<p>The action setting that a log record must contain in order to meet the condition. </p>', ], ], 'All' => [ 'base' => '<p>Inspect all of the elements that WAF has parsed and extracted from the web request JSON body that are within the <a>JsonBody</a> <code>MatchScope</code>. This is used with the <a>FieldToMatch</a> option <code>JsonBody</code>. </p> <p>This is used only to indicate the web request component for WAF to inspect, in the <a>FieldToMatch</a> specification. </p> <p>JSON specification: <code>"All": {}</code> </p>', 'refs' => [ 'JsonMatchPattern$All' => '<p>Match all of the elements. See also <code>MatchScope</code> in <a>JsonBody</a>. </p> <p>You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.</p>', ], ], 'AllQueryArguments' => [ 'base' => '<p>All query arguments of a web request. </p> <p>This is used only to indicate the web request component for WAF to inspect, in the <a>FieldToMatch</a> specification. </p> <p>JSON specification: <code>"AllQueryArguments": {}</code> </p>', 'refs' => [ 'FieldToMatch$AllQueryArguments' => '<p>Inspect all query arguments. </p>', ], ], 'AllowAction' => [ 'base' => '<p>Specifies that WAF should allow the request and optionally defines additional custom handling for the request.</p> <p>This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL <a>DefaultAction</a>. </p>', 'refs' => [ 'DefaultAction$Allow' => '<p>Specifies that WAF should allow requests by default.</p>', 'RuleAction$Allow' => '<p>Instructs WAF to allow the web request.</p>', ], ], 'AndStatement' => [ 'base' => '<p>A logical rule statement used to combine other rule statements with AND logic. You provide more than one <a>Statement</a> within the <code>AndStatement</code>. </p>', 'refs' => [ 'Statement$AndStatement' => '<p>A logical rule statement used to combine other rule statements with AND logic. You provide more than one <a>Statement</a> within the <code>AndStatement</code>. </p>', ], ], 'AssociateWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'BlockAction' => [ 'base' => '<p>Specifies that WAF should block the request and optionally defines additional custom handling for the response to the web request.</p> <p>This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL <a>DefaultAction</a>. </p>', 'refs' => [ 'DefaultAction$Block' => '<p>Specifies that WAF should block requests by default. </p>', 'RuleAction$Block' => '<p>Instructs WAF to block the web request.</p>', ], ], 'Body' => [ 'base' => '<p>The body of a web request. This immediately follows the request headers.</p> <p>This is used only to indicate the web request component for WAF to inspect, in the <a>FieldToMatch</a> specification. </p> <p>JSON specification: <code>"Body": {}</code> </p>', 'refs' => [ 'FieldToMatch$Body' => '<p>Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. </p> <p>Note that only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying host service. If you don\'t need to inspect more than 8 KB, you can guarantee that you don\'t allow additional bytes in by combining a statement that inspects the body of the web request, such as <a>ByteMatchStatement</a> or <a>RegexPatternSetReferenceStatement</a>, with a <a>SizeConstraintStatement</a> that enforces an 8 KB size limit on the body of the request. WAF doesn\'t support inspecting the entire contents of web requests whose bodies exceed the 8 KB limit.</p>', ], ], 'BodyParsingFallbackBehavior' => [ 'base' => NULL, 'refs' => [ 'JsonBody$InvalidFallbackBehavior' => '<p>What WAF should do if it fails to completely parse the JSON body. The options are the following:</p> <ul> <li> <p> <code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.</p> </li> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul> <p>If you don\'t provide this setting, WAF parses and evaluates the content only up to the first parsing failure that it encounters. </p> <p>WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn\'t an object or an array. </p> <p>WAF parses the JSON in the following examples as two valid key, value pairs: </p> <ul> <li> <p>Missing comma: <code>{"key1":"value1""key2":"value2"}</code> </p> </li> <li> <p>Missing colon: <code>{"key1":"value1","key2""value2"}</code> </p> </li> <li> <p>Extra colons: <code>{"key1"::"value1","key2""value2"}</code> </p> </li> </ul>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$ManagedByFirewallManager' => '<p>Indicates whether the logging configuration was created by Firewall Manager, as part of an WAF policy configuration. If true, only Firewall Manager can modify or delete the configuration. </p>', 'VisibilityConfig$SampledRequestsEnabled' => '<p>A boolean indicating whether WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the WAF console. </p>', 'VisibilityConfig$CloudWatchMetricsEnabled' => '<p>A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. For the list of available metrics, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">WAF Metrics</a>.</p>', 'WebACL$ManagedByFirewallManager' => '<p>Indicates whether this web ACL is managed by Firewall Manager. If true, then only Firewall Manager can delete the web ACL or any Firewall Manager rule groups in the web ACL. </p>', ], ], 'ByteMatchStatement' => [ 'base' => '<p>A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the developer guide, this is refered to as a string match statement.</p>', 'refs' => [ 'Statement$ByteMatchStatement' => '<p>A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the developer guide, this is refered to as a string match statement.</p>', ], ], 'CapacityUnit' => [ 'base' => NULL, 'refs' => [ 'CreateRuleGroupRequest$Capacity' => '<p>The web ACL capacity units (WCUs) required for this rule group.</p> <p>When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using <a>CheckCapacity</a>.</p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>', 'DescribeManagedRuleGroupResponse$Capacity' => '<p>The web ACL capacity units (WCUs) required for this rule group. WAF uses web ACL capacity units (WCU) to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect each rule\'s relative cost. Rule group capacity is fixed at creation, so users can plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>', 'ManagedRuleSetVersion$Capacity' => '<p>The web ACL capacity units (WCUs) required for this rule group.</p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>', 'RuleGroup$Capacity' => '<p>The web ACL capacity units (WCUs) required for this rule group.</p> <p>When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using <a>CheckCapacity</a>.</p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>', ], ], 'CaptchaAction' => [ 'base' => '<p>Specifies that WAF should run a <code>CAPTCHA</code> check against the request: </p> <ul> <li> <p>If the request includes a valid, unexpired <code>CAPTCHA</code> token, WAF allows the web request inspection to proceed to the next rule, similar to a <code>CountAction</code>. </p> </li> <li> <p>If the request doesn\'t include a valid, unexpired <code>CAPTCHA</code> token, WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.</p> <p>WAF generates a response that it sends back to the client, which includes the following: </p> <ul> <li> <p>The header <code>x-amzn-waf-action</code> with a value of <code>captcha</code>. </p> </li> <li> <p>The HTTP status code <code>405 Method Not Allowed</code>. </p> </li> <li> <p>If the request contains an <code>Accept</code> header with a value of <code>text/html</code>, the response includes a <code>CAPTCHA</code> challenge. </p> </li> </ul> </li> </ul> <p>You can configure the expiration time in the <code>CaptchaConfig</code> <code>ImmunityTimeProperty</code> setting at the rule and web ACL level. The rule setting overrides the web ACL setting. </p> <p>This action option is available for rules. It isn\'t available for web ACL default actions. </p> <p>This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL <a>DefaultAction</a>. </p>', 'refs' => [ 'RuleAction$Captcha' => '<p>Instructs WAF to run a <code>CAPTCHA</code> check against the web request.</p>', ], ], 'CaptchaConfig' => [ 'base' => '<p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations. This is available at the web ACL level and in each rule. </p>', 'refs' => [ 'CreateWebACLRequest$CaptchaConfig' => '<p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don\'t have their own <code>CaptchaConfig</code> settings. If you don\'t specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>', 'Rule$CaptchaConfig' => '<p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations. If you don\'t specify this, WAF uses the <code>CAPTCHA</code> configuration that\'s defined for the web ACL. </p>', 'UpdateWebACLRequest$CaptchaConfig' => '<p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don\'t have their own <code>CaptchaConfig</code> settings. If you don\'t specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>', 'WebACL$CaptchaConfig' => '<p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don\'t have their own <code>CaptchaConfig</code> settings. If you don\'t specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>', ], ], 'CaptchaResponse' => [ 'base' => '<p>The result from the inspection of the web request for a valid <code>CAPTCHA</code> token. </p>', 'refs' => [ 'SampledHTTPRequest$CaptchaResponse' => '<p>The <code>CAPTCHA</code> response for the request.</p>', ], ], 'CheckCapacityRequest' => [ 'base' => NULL, 'refs' => [], ], 'CheckCapacityResponse' => [ 'base' => NULL, 'refs' => [], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'SizeConstraintStatement$ComparisonOperator' => '<p>The operator to use to compare the request part to the size setting. </p>', ], ], 'Condition' => [ 'base' => '<p>A single match condition for a <a>Filter</a>.</p>', 'refs' => [ 'Conditions$member' => NULL, ], ], 'Conditions' => [ 'base' => NULL, 'refs' => [ 'Filter$Conditions' => '<p>Match conditions for the filter.</p>', ], ], 'ConsumedCapacity' => [ 'base' => NULL, 'refs' => [ 'CheckCapacityResponse$Capacity' => '<p>The capacity required by the rules and scope.</p>', 'WebACL$Capacity' => '<p>The web ACL capacity units (WCUs) currently being used by this web ACL. </p> <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>', ], ], 'CountAction' => [ 'base' => '<p>Specifies that WAF should count the request. Optionally defines additional custom handling for the request.</p> <p>This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL <a>DefaultAction</a>. </p>', 'refs' => [ 'OverrideAction$Count' => '<p>Override the rule group evaluation result to count only. </p> <note> <p>This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead exclude those rules in your rule group reference statement settings. </p> </note>', 'RuleAction$Count' => '<p>Instructs WAF to count the web request and allow it.</p>', ], ], 'Country' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$Country' => '<p>The two-letter country code for the country that the request originated from. For a current list of country codes, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a>.</p>', ], ], 'CountryCode' => [ 'base' => NULL, 'refs' => [ 'CountryCodes$member' => NULL, ], ], 'CountryCodes' => [ 'base' => NULL, 'refs' => [ 'GeoMatchStatement$CountryCodes' => '<p>An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country ISO codes of the ISO 3166 international standard. </p>', ], ], 'CreateIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegexPatternSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRegexPatternSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomHTTPHeader' => [ 'base' => '<p>A custom header for custom request and response handling. This is used in <a>CustomResponse</a> and <a>CustomRequestHandling</a>.</p>', 'refs' => [ 'CustomHTTPHeaders$member' => NULL, ], ], 'CustomHTTPHeaderName' => [ 'base' => NULL, 'refs' => [ 'CustomHTTPHeader$Name' => '<p>The name of the custom header. </p> <p>For custom request header insertion, when WAF inserts the header into the request, it prefixes this name <code>x-amzn-waf-</code>, to avoid confusion with the headers that are already in the request. For example, for the header name <code>sample</code>, WAF inserts the header <code>x-amzn-waf-sample</code>.</p>', ], ], 'CustomHTTPHeaderValue' => [ 'base' => NULL, 'refs' => [ 'CustomHTTPHeader$Value' => '<p>The value of the custom header.</p>', ], ], 'CustomHTTPHeaders' => [ 'base' => NULL, 'refs' => [ 'CustomRequestHandling$InsertHeaders' => '<p>The HTTP headers to insert into the request. Duplicate header names are not allowed. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'CustomResponse$ResponseHeaders' => '<p>The HTTP headers to use in the response. Duplicate header names are not allowed. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', ], ], 'CustomRequestHandling' => [ 'base' => '<p>Custom request handling behavior that inserts custom headers into a web request. You can add custom request handling for the rule actions allow and count. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'refs' => [ 'AllowAction$CustomRequestHandling' => '<p>Defines custom handling for the web request.</p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'CaptchaAction$CustomRequestHandling' => '<p>Defines custom handling for the web request.</p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'CountAction$CustomRequestHandling' => '<p>Defines custom handling for the web request.</p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', ], ], 'CustomResponse' => [ 'base' => '<p>A custom response to send to the client. You can define a custom response for rule actions and default web ACL actions that are set to <a>BlockAction</a>. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'refs' => [ 'BlockAction$CustomResponse' => '<p>Defines a custom response for the web request.</p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', ], ], 'CustomResponseBodies' => [ 'base' => NULL, 'refs' => [ 'CreateRuleGroupRequest$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'CreateWebACLRequest$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'RuleGroup$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'UpdateRuleGroupRequest$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'UpdateWebACLRequest$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'WebACL$CustomResponseBodies' => '<p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p> <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', ], ], 'CustomResponseBody' => [ 'base' => '<p>The response body to use in a custom response to a web request. This is referenced by key from <a>CustomResponse</a> <code>CustomResponseBodyKey</code>.</p>', 'refs' => [ 'CustomResponseBodies$value' => NULL, ], ], 'DefaultAction' => [ 'base' => '<p>In a <a>WebACL</a>, this is the action that you want WAF to perform when a web request doesn\'t match any of the rules in the <code>WebACL</code>. The default action must be a terminating action, so you can\'t use count.</p>', 'refs' => [ 'CreateWebACLRequest$DefaultAction' => '<p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>', 'UpdateWebACLRequest$DefaultAction' => '<p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>', 'WebACL$DefaultAction' => '<p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>', ], ], 'DeleteFirewallManagerRuleGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFirewallManagerRuleGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegexPatternSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegexPatternSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'DownloadUrl' => [ 'base' => NULL, 'refs' => [ 'GenerateMobileSdkReleaseUrlResponse$Url' => '<p>The presigned download URL for the specified SDK release.</p>', ], ], 'EntityDescription' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Description' => '<p>A description of the IP set that helps with identification. </p>', 'CreateRegexPatternSetRequest$Description' => '<p>A description of the set that helps with identification. </p>', 'CreateRuleGroupRequest$Description' => '<p>A description of the rule group that helps with identification. </p>', 'CreateWebACLRequest$Description' => '<p>A description of the web ACL that helps with identification. </p>', 'IPSet$Description' => '<p>A description of the IP set that helps with identification. </p>', 'IPSetSummary$Description' => '<p>A description of the IP set that helps with identification. </p>', 'ManagedRuleGroupSummary$Description' => '<p>The description of the managed rule group, provided by Amazon Web Services Managed Rules or the Amazon Web Services Marketplace seller who manages it.</p>', 'ManagedRuleSet$Description' => '<p>A description of the set that helps with identification. </p>', 'ManagedRuleSetSummary$Description' => '<p>A description of the set that helps with identification. </p>', 'RegexPatternSet$Description' => '<p>A description of the set that helps with identification. </p>', 'RegexPatternSetSummary$Description' => '<p>A description of the set that helps with identification. </p>', 'RuleGroup$Description' => '<p>A description of the rule group that helps with identification. </p>', 'RuleGroupSummary$Description' => '<p>A description of the rule group that helps with identification. </p>', 'UpdateIPSetRequest$Description' => '<p>A description of the IP set that helps with identification. </p>', 'UpdateRegexPatternSetRequest$Description' => '<p>A description of the set that helps with identification. </p>', 'UpdateRuleGroupRequest$Description' => '<p>A description of the rule group that helps with identification. </p>', 'UpdateWebACLRequest$Description' => '<p>A description of the web ACL that helps with identification. </p>', 'WebACL$Description' => '<p>A description of the web ACL that helps with identification. </p>', 'WebACLSummary$Description' => '<p>A description of the web ACL that helps with identification. </p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'DeleteIPSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'DeleteRegexPatternSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'DeleteRuleGroupRequest$Id' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'DeleteWebACLRequest$Id' => '<p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'GetIPSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'GetManagedRuleSetRequest$Id' => '<p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>', 'GetRateBasedStatementManagedKeysRequest$WebACLId' => '<p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'GetRegexPatternSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'GetRuleGroupRequest$Id' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'GetWebACLRequest$Id' => '<p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'IPSet$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'IPSetSummary$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'ManagedRuleSet$Id' => '<p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>', 'ManagedRuleSetSummary$Id' => '<p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>', 'PutManagedRuleSetVersionsRequest$Id' => '<p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>', 'RegexPatternSet$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'RegexPatternSetSummary$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'RuleGroup$Id' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'RuleGroupSummary$Id' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'UpdateIPSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'UpdateManagedRuleSetVersionExpiryDateRequest$Id' => '<p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>', 'UpdateRegexPatternSetRequest$Id' => '<p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'UpdateRuleGroupRequest$Id' => '<p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'UpdateWebACLRequest$Id' => '<p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', 'WebACL$Id' => '<p>A unique identifier for the <code>WebACL</code>. This ID is returned in the responses to create and list commands. You use this ID to do things like get, update, and delete a <code>WebACL</code>.</p>', 'WebACLSummary$Id' => '<p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'CreateRegexPatternSetRequest$Name' => '<p>The name of the set. You cannot change the name after you create the set.</p>', 'CreateRuleGroupRequest$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'CreateWebACLRequest$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'CustomResponse$CustomResponseBodyKey' => '<p>References the response body that you want WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the <code>CustomResponseBodies</code> setting for the <a>WebACL</a> or <a>RuleGroup</a> where you want to use it. Then, in the rule action or web ACL default action <code>BlockAction</code> setting, you reference the response body using this key. </p>', 'CustomResponseBodies$key' => NULL, 'DeleteIPSetRequest$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'DeleteRegexPatternSetRequest$Name' => '<p>The name of the set. You cannot change the name after you create the set.</p>', 'DeleteRuleGroupRequest$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'DeleteWebACLRequest$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'DescribeManagedRuleGroupRequest$Name' => '<p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>', 'ExcludedRule$Name' => '<p>The name of the rule whose action you want to override to <code>Count</code>.</p>', 'FirewallManagerRuleGroup$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'GetIPSetRequest$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'GetManagedRuleSetRequest$Name' => '<p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p> <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>', 'GetRateBasedStatementManagedKeysRequest$WebACLName' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'GetRateBasedStatementManagedKeysRequest$RuleGroupRuleName' => '<p>The name of the rule group reference statement in your web ACL. This is required only when you have the rate-based rule nested inside a rule group. </p>', 'GetRateBasedStatementManagedKeysRequest$RuleName' => '<p>The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that you\'re using in your web ACL, also provide the name of the rule group reference statement in the request parameter <code>RuleGroupRuleName</code>.</p>', 'GetRegexPatternSetRequest$Name' => '<p>The name of the set. You cannot change the name after you create the set.</p>', 'GetRuleGroupRequest$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'GetWebACLRequest$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'IPSet$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'IPSetSummary$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'ListAvailableManagedRuleGroupVersionsRequest$Name' => '<p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>', 'ManagedRuleGroupStatement$Name' => '<p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>', 'ManagedRuleGroupSummary$Name' => '<p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>', 'ManagedRuleSet$Name' => '<p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p> <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>', 'ManagedRuleSetSummary$Name' => '<p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p> <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>', 'PutManagedRuleSetVersionsRequest$Name' => '<p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p> <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>', 'RegexPatternSet$Name' => '<p>The name of the set. You cannot change the name after you create the set.</p>', 'RegexPatternSetSummary$Name' => '<p>The name of the data type instance. You cannot change the name after you create the instance.</p>', 'Rule$Name' => '<p>The name of the rule. You can\'t change the name of a <code>Rule</code> after you create it. </p>', 'RuleGroup$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'RuleGroupSummary$Name' => '<p>The name of the data type instance. You cannot change the name after you create the instance.</p>', 'RuleSummary$Name' => '<p>The name of the rule. </p>', 'SampledHTTPRequest$RuleNameWithinRuleGroup' => '<p>The name of the <code>Rule</code> that the request matched. For managed rule groups, the format for this name is <code>&lt;vendor name&gt;#&lt;managed rule group name&gt;#&lt;rule name&gt;</code>. For your own rule groups, the format for this name is <code>&lt;rule group name&gt;#&lt;rule name&gt;</code>. If the rule is not in a rule group, this field is absent. </p>', 'UpdateIPSetRequest$Name' => '<p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>', 'UpdateManagedRuleSetVersionExpiryDateRequest$Name' => '<p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p> <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>', 'UpdateRegexPatternSetRequest$Name' => '<p>The name of the set. You cannot change the name after you create the set.</p>', 'UpdateRuleGroupRequest$Name' => '<p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>', 'UpdateWebACLRequest$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'WebACL$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', 'WebACLSummary$Name' => '<p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'WAFAssociatedItemException$Message' => NULL, 'WAFDuplicateItemException$Message' => NULL, 'WAFExpiredManagedRuleGroupVersionException$Message' => NULL, 'WAFInternalErrorException$Message' => NULL, 'WAFInvalidOperationException$Message' => NULL, 'WAFInvalidParameterException$message' => NULL, 'WAFInvalidPermissionPolicyException$Message' => NULL, 'WAFInvalidResourceException$Message' => NULL, 'WAFLimitsExceededException$Message' => NULL, 'WAFLogDestinationPermissionIssueException$Message' => NULL, 'WAFNonexistentItemException$Message' => NULL, 'WAFOptimisticLockException$Message' => NULL, 'WAFServiceLinkedRoleErrorException$message' => NULL, 'WAFSubscriptionNotFoundException$Message' => NULL, 'WAFTagOperationException$Message' => NULL, 'WAFTagOperationInternalErrorException$Message' => NULL, 'WAFUnavailableEntityException$Message' => NULL, ], ], 'ErrorReason' => [ 'base' => NULL, 'refs' => [ 'WAFInvalidParameterException$Reason' => '<p>Additional information about the exception.</p>', ], ], 'ExcludedRule' => [ 'base' => '<p>Specifies a single rule in a rule group whose action you want to override to <code>Count</code>. When you exclude a rule, WAF evaluates it exactly as it would if the rule action setting were <code>Count</code>. This is a useful option for testing the rules in a rule group without modifying how they handle your web traffic. </p>', 'refs' => [ 'ExcludedRules$member' => NULL, ], ], 'ExcludedRules' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleGroupStatement$ExcludedRules' => '<p>The rules in the referenced rule group whose actions are set to <code>Count</code>. When you exclude a rule, WAF evaluates it exactly as it would if the rule action setting were <code>Count</code>. This is a useful option for testing the rules in a rule group without modifying how they handle your web traffic.</p>', 'RuleGroupReferenceStatement$ExcludedRules' => '<p>The rules in the referenced rule group whose actions are set to <code>Count</code>. When you exclude a rule, WAF evaluates it exactly as it would if the rule action setting were <code>Count</code>. This is a useful option for testing the rules in a rule group without modifying how they handle your web traffic.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'CaptchaResponse$FailureReason' => '<p>The reason for failure, populated when the evaluation of the token fails.</p>', ], ], 'FallbackBehavior' => [ 'base' => NULL, 'refs' => [ 'ForwardedIPConfig$FallbackBehavior' => '<p>The match status to assign to the web request if the request doesn\'t have a valid IP address in the specified position.</p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note> <p>You can specify the following fallback behaviors:</p> <ul> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul>', 'IPSetForwardedIPConfig$FallbackBehavior' => '<p>The match status to assign to the web request if the request doesn\'t have a valid IP address in the specified position.</p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note> <p>You can specify the following fallback behaviors:</p> <ul> <li> <p> <code>MATCH</code> - Treat the web request as matching the rule statement. WAF applies the rule action to the request.</p> </li> <li> <p> <code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</p> </li> </ul>', ], ], 'FieldIdentifier' => [ 'base' => NULL, 'refs' => [ 'PasswordField$Identifier' => '<p>The name of the password field. For example <code>/form/password</code>.</p>', 'UsernameField$Identifier' => '<p>The name of the username field. For example <code>/form/username</code>.</p>', ], ], 'FieldToMatch' => [ 'base' => '<p>The part of a web request that you want WAF to inspect. Include the single <code>FieldToMatch</code> type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in <code>FieldToMatch</code> for each rule statement that requires it. To inspect more than one component of a web request, create a separate rule statement for each component.</p> <p>JSON specification for a <code>QueryString</code> field to match: </p> <p> <code> "FieldToMatch": { "QueryString": {} }</code> </p> <p>Example JSON for a <code>Method</code> field to match specification:</p> <p> <code> "FieldToMatch": { "Method": { "Name": "DELETE" } }</code> </p>', 'refs' => [ 'ByteMatchStatement$FieldToMatch' => '<p>The part of a web request that you want WAF to inspect. For more information, see <a>FieldToMatch</a>. </p>', 'RedactedFields$member' => NULL, 'RegexMatchStatement$FieldToMatch' => '<p>The part of a web request that you want WAF to inspect. For more information, see <a>FieldToMatch</a>. </p>', 'RegexPatternSetReferenceStatement$FieldToMatch' => '<p>The part of a web request that you want WAF to inspect. For more information, see <a>FieldToMatch</a>. </p>', 'SizeConstraintStatement$FieldToMatch' => '<p>The part of a web request that you want WAF to inspect. For more information, see <a>FieldToMatch</a>. </p>', 'SqliMatchStatement$FieldToMatch' => '<p>The part of a web request that you want WAF to inspect. For more information, see <a>FieldToMatch</a>. </p>', 'XssMatchStatement$FieldToMatch' => '<p>The part of a web request that you want WAF to inspect. For more information, see <a>FieldToMatch</a>. </p>', ], ], 'FieldToMatchData' => [ 'base' => NULL, 'refs' => [ 'SingleHeader$Name' => '<p>The name of the query header to inspect.</p>', 'SingleQueryArgument$Name' => '<p>The name of the query argument to inspect.</p>', ], ], 'Filter' => [ 'base' => '<p>A single logging filter, used in <a>LoggingFilter</a>. </p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'FilterBehavior' => [ 'base' => NULL, 'refs' => [ 'Filter$Behavior' => '<p>How to handle logs that satisfy the filter\'s conditions and requirement. </p>', 'LoggingFilter$DefaultBehavior' => '<p>Default handling for logs that don\'t match any of the specified filtering conditions. </p>', ], ], 'FilterRequirement' => [ 'base' => NULL, 'refs' => [ 'Filter$Requirement' => '<p>Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.</p>', ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'LoggingFilter$Filters' => '<p>The filters that you want to apply to the logs. </p>', ], ], 'FirewallManagerRuleGroup' => [ 'base' => '<p>A rule group that\'s defined for an Firewall Manager WAF policy.</p>', 'refs' => [ 'FirewallManagerRuleGroups$member' => NULL, ], ], 'FirewallManagerRuleGroups' => [ 'base' => NULL, 'refs' => [ 'WebACL$PreProcessFirewallManagerRuleGroups' => '<p>The first set of rules for WAF to process in the web ACL. This is defined in an Firewall Manager WAF policy and contains only rule group references. You can\'t alter these. Any rules and rule groups that you define for the web ACL are prioritized after these. </p> <p>In the Firewall Manager WAF policy, the Firewall Manager administrator can define a set of rule groups to run first in the web ACL and a set of rule groups to run last. Within each set, the administrator prioritizes the rule groups, to determine their relative processing order.</p>', 'WebACL$PostProcessFirewallManagerRuleGroups' => '<p>The last set of rules for WAF to process in the web ACL. This is defined in an Firewall Manager WAF policy and contains only rule group references. You can\'t alter these. Any rules and rule groups that you define for the web ACL are prioritized before these. </p> <p>In the Firewall Manager WAF policy, the Firewall Manager administrator can define a set of rule groups to run first in the web ACL and a set of rule groups to run last. Within each set, the administrator prioritizes the rule groups, to determine their relative processing order.</p>', ], ], 'FirewallManagerStatement' => [ 'base' => '<p>The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>, but it can only contain a rule group reference.</p>', 'refs' => [ 'FirewallManagerRuleGroup$FirewallManagerStatement' => '<p>The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>, but it can only contain a rule group reference.</p>', ], ], 'ForwardedIPConfig' => [ 'base' => '<p>The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that\'s reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. </p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note> <p>This configuration is used for <a>GeoMatchStatement</a> and <a>RateBasedStatement</a>. For <a>IPSetReferenceStatement</a>, use <a>IPSetForwardedIPConfig</a> instead. </p> <p>WAF only evaluates the first IP address found in the specified HTTP header. </p>', 'refs' => [ 'GeoMatchStatement$ForwardedIPConfig' => '<p>The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that\'s reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. </p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note>', 'RateBasedStatement$ForwardedIPConfig' => '<p>The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that\'s reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. </p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note> <p>This is required if <code>AggregateKeyType</code> is set to <code>FORWARDED_IP</code>.</p>', ], ], 'ForwardedIPHeaderName' => [ 'base' => NULL, 'refs' => [ 'ForwardedIPConfig$HeaderName' => '<p>The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code>.</p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note>', 'IPSetForwardedIPConfig$HeaderName' => '<p>The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code>.</p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note>', ], ], 'ForwardedIPPosition' => [ 'base' => NULL, 'refs' => [ 'IPSetForwardedIPConfig$Position' => '<p>The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original client and the rest identify proxies that the request went through. </p> <p>The options for this setting are the following: </p> <ul> <li> <p>FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client\'s original IP.</p> </li> <li> <p>LAST - Inspect the last IP address in the list of IP addresses in the header.</p> </li> <li> <p>ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, WAF inspects the last 10.</p> </li> </ul>', ], ], 'GenerateMobileSdkReleaseUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateMobileSdkReleaseUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'GeoMatchStatement' => [ 'base' => '<p>A rule statement used to identify web requests based on country of origin. </p>', 'refs' => [ 'Statement$GeoMatchStatement' => '<p>A rule statement used to identify web requests based on country of origin. </p>', ], ], 'GetIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedRuleSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedRuleSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMobileSdkReleaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMobileSdkReleaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPermissionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPermissionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRateBasedStatementManagedKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRateBasedStatementManagedKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRegexPatternSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRegexPatternSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSampledRequestsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSampledRequestsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWebACLForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWebACLForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'HTTPHeader' => [ 'base' => '<p>Part of the response from <a>GetSampledRequests</a>. This is a complex type that appears as <code>Headers</code> in the response syntax. <code>HTTPHeader</code> contains the names and values of all of the headers that appear in one of the web requests. </p>', 'refs' => [ 'HTTPHeaders$member' => NULL, ], ], 'HTTPHeaders' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$Headers' => '<p>A complex type that contains the name and value for each header in the sampled web request.</p>', 'SampledHTTPRequest$RequestHeadersInserted' => '<p>Custom request headers inserted by WAF into the request, according to the custom request configuration for the matching rule action.</p>', ], ], 'HTTPMethod' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$Method' => '<p>The HTTP method specified in the sampled web request. </p>', ], ], 'HTTPRequest' => [ 'base' => '<p>Part of the response from <a>GetSampledRequests</a>. This is a complex type that appears as <code>Request</code> in the response syntax. <code>HTTPRequest</code> contains information about one of the web requests. </p>', 'refs' => [ 'SampledHTTPRequest$Request' => '<p>A complex type that contains detailed information about the request.</p>', ], ], 'HTTPVersion' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$HTTPVersion' => '<p>The HTTP version specified in the sampled web request, for example, <code>HTTP/1.1</code>.</p>', ], ], 'HeaderName' => [ 'base' => NULL, 'refs' => [ 'HTTPHeader$Name' => '<p>The name of the HTTP header.</p>', ], ], 'HeaderValue' => [ 'base' => NULL, 'refs' => [ 'HTTPHeader$Value' => '<p>The value of the HTTP header.</p>', ], ], 'IPAddress' => [ 'base' => NULL, 'refs' => [ 'IPAddresses$member' => NULL, ], ], 'IPAddressVersion' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$IPAddressVersion' => '<p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>', 'IPSet$IPAddressVersion' => '<p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>', 'RateBasedStatementManagedKeysIPSet$IPAddressVersion' => '<p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>', ], ], 'IPAddresses' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Addresses' => '<p>Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p> <p>Examples: </p> <ul> <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li> <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li> <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li> <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li> </ul> <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>', 'IPSet$Addresses' => '<p>Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p> <p>Examples: </p> <ul> <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li> <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li> <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li> <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li> </ul> <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>', 'RateBasedStatementManagedKeysIPSet$Addresses' => '<p>The IP addresses that are currently blocked.</p>', 'UpdateIPSetRequest$Addresses' => '<p>Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p> <p>Examples: </p> <ul> <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li> <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li> <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li> <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li> </ul> <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>', ], ], 'IPSet' => [ 'base' => '<p>Contains one or more IP addresses or blocks of IP addresses specified in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. For information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>. </p> <p>WAF assigns an ARN to each <code>IPSet</code> that you create. To use an IP set in a rule, you provide the ARN to the <a>Rule</a> statement <a>IPSetReferenceStatement</a>. </p>', 'refs' => [ 'GetIPSetResponse$IPSet' => '<p/>', ], ], 'IPSetForwardedIPConfig' => [ 'base' => '<p>The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that\'s reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. </p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note> <p>This configuration is used only for <a>IPSetReferenceStatement</a>. For <a>GeoMatchStatement</a> and <a>RateBasedStatement</a>, use <a>ForwardedIPConfig</a> instead. </p>', 'refs' => [ 'IPSetReferenceStatement$IPSetForwardedIPConfig' => '<p>The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that\'s reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. </p> <note> <p>If the specified header isn\'t present in the request, WAF doesn\'t apply the rule to the web request at all.</p> </note>', ], ], 'IPSetReferenceStatement' => [ 'base' => '<p>A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an <a>IPSet</a> that specifies the addresses you want to detect, then use the ARN of that set in this statement. To create an IP set, see <a>CreateIPSet</a>.</p> <p>Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.</p>', 'refs' => [ 'Statement$IPSetReferenceStatement' => '<p>A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an <a>IPSet</a> that specifies the addresses you want to detect, then use the ARN of that set in this statement. To create an IP set, see <a>CreateIPSet</a>.</p> <p>Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.</p>', ], ], 'IPSetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListIPSetsResponse$IPSets' => '<p>Array of IPSets. This may not be the full list of IPSets that you have defined. See the <code>Limit</code> specification for this request.</p>', ], ], 'IPSetSummary' => [ 'base' => '<p>High-level information about an <a>IPSet</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage an <code>IPSet</code>, and the ARN, that you provide to the <a>IPSetReferenceStatement</a> to use the address set in a <a>Rule</a>.</p>', 'refs' => [ 'CreateIPSetResponse$Summary' => '<p>High-level information about an <a>IPSet</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage an <code>IPSet</code>, and the ARN, that you provide to the <a>IPSetReferenceStatement</a> to use the address set in a <a>Rule</a>.</p>', 'IPSetSummaries$member' => NULL, ], ], 'IPString' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$ClientIP' => '<p>The IP address that the request originated from. If the web ACL is associated with a CloudFront distribution, this is the value of one of the following fields in CloudFront access logs:</p> <ul> <li> <p> <code>c-ip</code>, if the viewer did not use an HTTP proxy or a load balancer to send the request</p> </li> <li> <p> <code>x-forwarded-for</code>, if the viewer did use an HTTP proxy or a load balancer to send the request</p> </li> </ul>', ], ], 'ImmunityTimeProperty' => [ 'base' => '<p>Determines how long a <code>CAPTCHA</code> token remains valid after the client successfully solves a <code>CAPTCHA</code> puzzle. </p>', 'refs' => [ 'CaptchaConfig$ImmunityTimeProperty' => '<p>Determines how long a <code>CAPTCHA</code> token remains valid after the client successfully solves a <code>CAPTCHA</code> puzzle. </p>', ], ], 'JsonBody' => [ 'base' => '<p>The body of a web request, inspected as JSON. The body immediately follows the request headers. This is used in the <a>FieldToMatch</a> specification.</p> <p>Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule\'s inspection criteria. WAF inspects only the parts of the JSON that result from the matches that you indicate. </p> <p>Example JSON: <code>"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }</code> </p>', 'refs' => [ 'FieldToMatch$JsonBody' => '<p>Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. </p> <p>Note that only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying host service. If you don\'t need to inspect more than 8 KB, you can guarantee that you don\'t allow additional bytes in by combining a statement that inspects the body of the web request, such as <a>ByteMatchStatement</a> or <a>RegexPatternSetReferenceStatement</a>, with a <a>SizeConstraintStatement</a> that enforces an 8 KB size limit on the body of the request. WAF doesn\'t support inspecting the entire contents of web requests whose bodies exceed the 8 KB limit.</p>', ], ], 'JsonMatchPattern' => [ 'base' => '<p>The patterns to look for in the JSON body. WAF inspects the results of these pattern matches against the rule inspection criteria. This is used with the <a>FieldToMatch</a> option <code>JsonBody</code>. </p>', 'refs' => [ 'JsonBody$MatchPattern' => '<p>The patterns to look for in the JSON body. WAF inspects the results of these pattern matches against the rule inspection criteria. </p>', ], ], 'JsonMatchScope' => [ 'base' => NULL, 'refs' => [ 'JsonBody$MatchScope' => '<p>The parts of the JSON to match against using the <code>MatchPattern</code>. If you specify <code>All</code>, WAF matches against keys and values. </p>', ], ], 'JsonPointerPath' => [ 'base' => NULL, 'refs' => [ 'JsonPointerPaths$member' => NULL, ], ], 'JsonPointerPaths' => [ 'base' => NULL, 'refs' => [ 'JsonMatchPattern$IncludedPaths' => '<p>Match only the specified include paths. See also <code>MatchScope</code> in <a>JsonBody</a>. </p> <p>Provide the include paths using JSON Pointer syntax. For example, <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code>. For information about this syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a>. </p> <p>You must specify either this setting or the <code>All</code> setting, but not both.</p> <note> <p>Don\'t use this option to include all paths. Instead, use the <code>All</code> setting. </p> </note>', ], ], 'Label' => [ 'base' => '<p>A single label container. This is used as an element of a label array in multiple contexts, for example, in <code>RuleLabels</code> inside a <a>Rule</a> and in <code>Labels</code> inside a <a>SampledHTTPRequest</a>. </p>', 'refs' => [ 'Labels$member' => NULL, ], ], 'LabelMatchKey' => [ 'base' => NULL, 'refs' => [ 'LabelMatchStatement$Key' => '<p>The string to match against. The setting you provide for this depends on the match statement\'s <code>Scope</code> setting: </p> <ul> <li> <p>If the <code>Scope</code> indicates <code>LABEL</code>, then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name. </p> </li> <li> <p>If the <code>Scope</code> indicates <code>NAMESPACE</code>, then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.</p> </li> </ul> <p>Labels are case sensitive and components of a label must be separated by colon, for example <code>NS1:NS2:name</code>.</p>', ], ], 'LabelMatchScope' => [ 'base' => NULL, 'refs' => [ 'LabelMatchStatement$Scope' => '<p>Specify whether you want to match using the label name or just the namespace. </p>', ], ], 'LabelMatchStatement' => [ 'base' => '<p>A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. </p> <p>The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, WAF performs the search for labels that were added in the same context as the label match statement. </p>', 'refs' => [ 'Statement$LabelMatchStatement' => '<p>A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. </p> <p>The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, WAF performs the search for labels that were added in the same context as the label match statement. </p>', ], ], 'LabelName' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedRuleGroupResponse$LabelNamespace' => '<p>The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix. </p> <ul> <li> <p>The syntax for the label namespace prefix for a managed rule group is the following: </p> <p> <code>awswaf:managed:&lt;vendor&gt;:&lt;rule group name&gt;</code>:</p> </li> <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code> </p> </li> </ul>', 'Label$Name' => '<p>The label string. </p>', 'LabelNameCondition$LabelName' => '<p>The label name that a log record must contain in order to meet the condition. This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. </p>', 'LabelSummary$Name' => '<p>An individual label specification.</p>', 'ManagedRuleSet$LabelNamespace' => '<p>The label namespace prefix for the managed rule groups that are offered to customers from this managed rule set. All labels that are added by rules in the managed rule group have this prefix. </p> <ul> <li> <p>The syntax for the label namespace prefix for a managed rule group is the following: </p> <p> <code>awswaf:managed:&lt;vendor&gt;:&lt;rule group name&gt;</code>:</p> </li> <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code> </p> </li> </ul>', 'ManagedRuleSetSummary$LabelNamespace' => '<p>The label namespace prefix for the managed rule groups that are offered to customers from this managed rule set. All labels that are added by rules in the managed rule group have this prefix. </p> <ul> <li> <p>The syntax for the label namespace prefix for a managed rule group is the following: </p> <p> <code>awswaf:managed:&lt;vendor&gt;:&lt;rule group name&gt;</code>:</p> </li> <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code> </p> </li> </ul>', 'RuleGroup$LabelNamespace' => '<p>The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix. </p> <ul> <li> <p>The syntax for the label namespace prefix for your rule groups is the following: </p> <p> <code>awswaf:&lt;account ID&gt;:rulegroup:&lt;rule group name&gt;:</code> </p> </li> <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code> </p> </li> </ul>', 'WebACL$LabelNamespace' => '<p>The label namespace prefix for this web ACL. All labels added by rules in this web ACL have this prefix. </p> <ul> <li> <p>The syntax for the label namespace prefix for a web ACL is the following: </p> <p> <code>awswaf:&lt;account ID&gt;:webacl:&lt;web ACL name&gt;:</code> </p> </li> <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code> </p> </li> </ul>', ], ], 'LabelNameCondition' => [ 'base' => '<p>A single label name condition for a <a>Condition</a> in a logging filter.</p>', 'refs' => [ 'Condition$LabelNameCondition' => '<p>A single label name condition.</p>', ], ], 'LabelSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedRuleGroupResponse$AvailableLabels' => '<p>The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the <code>RuleLabels</code> for a <a>Rule</a>.</p>', 'DescribeManagedRuleGroupResponse$ConsumedLabels' => '<p>The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a> definition of a rule. </p>', 'RuleGroup$AvailableLabels' => '<p>The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the <code>RuleLabels</code> for a <a>Rule</a>.</p>', 'RuleGroup$ConsumedLabels' => '<p>The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a> definition of a rule. </p>', ], ], 'LabelSummary' => [ 'base' => '<p>List of labels used by one or more of the rules of a <a>RuleGroup</a>. This summary object is used for the following rule group lists: </p> <ul> <li> <p> <code>AvailableLabels</code> - Labels that rules add to matching requests. These labels are defined in the <code>RuleLabels</code> for a <a>Rule</a>. </p> </li> <li> <p> <code>ConsumedLabels</code> - Labels that rules match against. These labels are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a> definition of a rule. </p> </li> </ul>', 'refs' => [ 'LabelSummaries$member' => NULL, ], ], 'Labels' => [ 'base' => NULL, 'refs' => [ 'Rule$RuleLabels' => '<p>Labels to apply to web requests that match the rule match statement. WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule\'s rule group or web ACL defines the label namespace. </p> <p>Rules that run after this rule in the web ACL can match against these labels using a <code>LabelMatchStatement</code>.</p> <p>For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:</p> <ul> <li> <p>Separate each component of the label with a colon. </p> </li> <li> <p>Each namespace or name can have up to 128 characters.</p> </li> <li> <p>You can specify up to 5 namespaces in a label.</p> </li> <li> <p>Don\'t use the following reserved words in your label specification: <code>aws</code>, <code>waf</code>, <code>managed</code>, <code>rulegroup</code>, <code>webacl</code>, <code>regexpatternset</code>, or <code>ipset</code>.</p> </li> </ul> <p>For example, <code>myLabelName</code> or <code>nameSpace1:nameSpace2:myLabelName</code>. </p>', 'SampledHTTPRequest$Labels' => '<p>Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule\'s rule group or web ACL defines the label namespace. </p> <p>For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>. </p>', ], ], 'ListAvailableManagedRuleGroupVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailableManagedRuleGroupVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailableManagedRuleGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailableManagedRuleGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIPSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIPSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLoggingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLoggingConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedRuleSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedRuleSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMaxItems' => [ 'base' => NULL, 'refs' => [ 'GetSampledRequestsRequest$MaxItems' => '<p>The number of requests that you want WAF to return from among the first 5,000 requests that your Amazon Web Services resource received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them. </p>', ], ], 'ListMobileSdkReleasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMobileSdkReleasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRegexPatternSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRegexPatternSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesForWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesForWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRuleGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRuleGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWebACLsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWebACLsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LockToken' => [ 'base' => NULL, 'refs' => [ 'DeleteFirewallManagerRuleGroupsRequest$WebACLLockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'DeleteFirewallManagerRuleGroupsResponse$NextWebACLLockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'DeleteIPSetRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'DeleteRegexPatternSetRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'DeleteRuleGroupRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'DeleteWebACLRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'GetIPSetResponse$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'GetManagedRuleSetResponse$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'GetRegexPatternSetResponse$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'GetRuleGroupResponse$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'GetWebACLResponse$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'IPSetSummary$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'ManagedRuleSetSummary$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'PutManagedRuleSetVersionsRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'PutManagedRuleSetVersionsResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'RegexPatternSetSummary$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'RuleGroupSummary$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateIPSetRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateIPSetResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>', 'UpdateManagedRuleSetVersionExpiryDateRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateManagedRuleSetVersionExpiryDateResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateRegexPatternSetRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateRegexPatternSetResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>', 'UpdateRuleGroupRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateRuleGroupResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>', 'UpdateWebACLRequest$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', 'UpdateWebACLResponse$NextLockToken' => '<p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>', 'WebACLSummary$LockToken' => '<p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>', ], ], 'LogDestinationConfigs' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$LogDestinationConfigs' => '<p>The Amazon Resource Names (ARNs) of the logging destinations that you want to associate with the web ACL.</p>', ], ], 'LoggingConfiguration' => [ 'base' => '<p>Defines an association between logging destinations and a web ACL resource, for logging from WAF. As part of the association, you can specify parts of the standard logging fields to keep out of the logs and you can specify filters so that you log only a subset of the logging records. </p> <p>For information about configuring web ACL logging destinations, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [ 'GetLoggingConfigurationResponse$LoggingConfiguration' => '<p>The <a>LoggingConfiguration</a> for the specified web ACL.</p>', 'LoggingConfigurations$member' => NULL, 'PutLoggingConfigurationRequest$LoggingConfiguration' => '<p/>', 'PutLoggingConfigurationResponse$LoggingConfiguration' => '<p/>', ], ], 'LoggingConfigurations' => [ 'base' => NULL, 'refs' => [ 'ListLoggingConfigurationsResponse$LoggingConfigurations' => '<p/>', ], ], 'LoggingFilter' => [ 'base' => '<p>Filtering that specifies which web requests are kept in the logs and which are dropped, defined for a web ACL\'s <a>LoggingConfiguration</a>. </p> <p>You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation. </p>', 'refs' => [ 'LoggingConfiguration$LoggingFilter' => '<p>Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation. </p>', ], ], 'LoginPathString' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleGroupConfig$LoginPath' => '<p>The login endpoint for your application. For example <code>https://example.com/web/login</code>.</p>', ], ], 'ManagedRuleGroupConfig' => [ 'base' => '<p>Additional information that\'s used by a managed rule group. Most managed rule groups don\'t require this.</p> <p>Use this for the account takeover prevention managed rule group <code>AWSManagedRulesATPRuleSet</code>, to provide information about the sign-in page of your application. </p>', 'refs' => [ 'ManagedRuleGroupConfigs$member' => NULL, ], ], 'ManagedRuleGroupConfigs' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleGroupStatement$ManagedRuleGroupConfigs' => '<p>Additional information that\'s used by a managed rule group. Most managed rule groups don\'t require this.</p> <p>Use this for the account takeover prevention managed rule group <code>AWSManagedRulesATPRuleSet</code>, to provide information about the sign-in page of your application. </p>', ], ], 'ManagedRuleGroupStatement' => [ 'base' => '<p>A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling <a>ListAvailableManagedRuleGroups</a>.</p> <p>You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level statement within a rule.</p>', 'refs' => [ 'FirewallManagerStatement$ManagedRuleGroupStatement' => '<p>A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling <a>ListAvailableManagedRuleGroups</a>.</p> <p>You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level statement within a rule.</p>', 'Statement$ManagedRuleGroupStatement' => '<p>A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling <a>ListAvailableManagedRuleGroups</a>.</p> <p>You cannot nest a <code>ManagedRuleGroupStatement</code>, for example for use inside a <code>NotStatement</code> or <code>OrStatement</code>. It can only be referenced as a top-level statement within a rule.</p>', ], ], 'ManagedRuleGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAvailableManagedRuleGroupsResponse$ManagedRuleGroups' => '<p/>', ], ], 'ManagedRuleGroupSummary' => [ 'base' => '<p>High-level information about a managed rule group, returned by <a>ListAvailableManagedRuleGroups</a>. This provides information like the name and vendor name, that you provide when you add a <a>ManagedRuleGroupStatement</a> to a web ACL. Managed rule groups include Amazon Web Services Managed Rules rule groups, which are free of charge to WAF customers, and Amazon Web Services Marketplace managed rule groups, which you can subscribe to through Amazon Web Services Marketplace. </p>', 'refs' => [ 'ManagedRuleGroupSummaries$member' => NULL, ], ], 'ManagedRuleGroupVersion' => [ 'base' => '<p>Describes a single version of a managed rule group. </p>', 'refs' => [ 'ManagedRuleGroupVersions$member' => NULL, ], ], 'ManagedRuleGroupVersions' => [ 'base' => NULL, 'refs' => [ 'ListAvailableManagedRuleGroupVersionsResponse$Versions' => '<p>The versions that are currently available for the specified managed rule group. </p>', ], ], 'ManagedRuleSet' => [ 'base' => '<p>A set of rules that is managed by Amazon Web Services and Amazon Web Services Marketplace sellers to provide versioned managed rule groups for customers of WAF.</p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'refs' => [ 'GetManagedRuleSetResponse$ManagedRuleSet' => '<p>The managed rule set that you requested. </p>', ], ], 'ManagedRuleSetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListManagedRuleSetsResponse$ManagedRuleSets' => '<p>Your managed rule sets. </p>', ], ], 'ManagedRuleSetSummary' => [ 'base' => '<p>High-level information for a managed rule set. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'refs' => [ 'ManagedRuleSetSummaries$member' => NULL, ], ], 'ManagedRuleSetVersion' => [ 'base' => '<p>Information for a single version of a managed rule set. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'refs' => [ 'PublishedVersions$value' => NULL, ], ], 'Method' => [ 'base' => '<p>The HTTP method of a web request. The method indicates the type of operation that the request is asking the origin to perform. </p> <p>This is used only to indicate the web request component for WAF to inspect, in the <a>FieldToMatch</a> specification. </p> <p>JSON specification: <code>"Method": {}</code> </p>', 'refs' => [ 'FieldToMatch$Method' => '<p>Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform. </p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'GetSampledRequestsRequest$RuleMetricName' => '<p>The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> for which you want a sample of requests.</p>', 'VisibilityConfig$MetricName' => '<p>A name of the Amazon CloudWatch metric. The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can\'t contain whitespace or metric names reserved for WAF, for example "All" and "Default_Action." </p>', ], ], 'MobileSdkRelease' => [ 'base' => '<p>Information for a release of the mobile SDK, including release notes and tags.</p> <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. </p>', 'refs' => [ 'GetMobileSdkReleaseResponse$MobileSdkRelease' => '<p>Information for a specified SDK release, including release notes and tags.</p>', ], ], 'NextMarker' => [ 'base' => NULL, 'refs' => [ 'ListAvailableManagedRuleGroupVersionsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListAvailableManagedRuleGroupVersionsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListAvailableManagedRuleGroupsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListAvailableManagedRuleGroupsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListIPSetsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListIPSetsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListLoggingConfigurationsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListLoggingConfigurationsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListManagedRuleSetsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListManagedRuleSetsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListMobileSdkReleasesRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListMobileSdkReleasesResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListRegexPatternSetsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListRegexPatternSetsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListRuleGroupsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListRuleGroupsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListTagsForResourceRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListTagsForResourceResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListWebACLsRequest$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', 'ListWebACLsResponse$NextMarker' => '<p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>', ], ], 'NoneAction' => [ 'base' => '<p>Specifies that WAF should do nothing. This is used for the <code>OverrideAction</code> setting on a <a>Rule</a> when the rule uses a rule group reference statement. </p> <p>This is used in the context of other settings, for example to specify values for <a>RuleAction</a> and web ACL <a>DefaultAction</a>. </p> <p>JSON specification: <code>"None": {}</code> </p>', 'refs' => [ 'OverrideAction$None' => '<p>Don\'t override the rule group evaluation result. This is the most common setting.</p>', ], ], 'NotStatement' => [ 'base' => '<p>A logical rule statement used to negate the results of another rule statement. You provide one <a>Statement</a> within the <code>NotStatement</code>.</p>', 'refs' => [ 'Statement$NotStatement' => '<p>A logical rule statement used to negate the results of another rule statement. You provide one <a>Statement</a> within the <code>NotStatement</code>.</p>', ], ], 'OrStatement' => [ 'base' => '<p>A logical rule statement used to combine other rule statements with OR logic. You provide more than one <a>Statement</a> within the <code>OrStatement</code>. </p>', 'refs' => [ 'Statement$OrStatement' => '<p>A logical rule statement used to combine other rule statements with OR logic. You provide more than one <a>Statement</a> within the <code>OrStatement</code>. </p>', ], ], 'OutputUrl' => [ 'base' => NULL, 'refs' => [ 'GetWebACLResponse$ApplicationIntegrationURL' => '<p>The URL to use in SDK integrations with Amazon Web Services managed rule groups. For example, you can use the integration SDKs with the account takeover prevention managed rule group <code>AWSManagedRulesATPRuleSet</code>. This is only populated if you are using a rule group in your web ACL that integrates with your applications in this way. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF application integration</a> in the <i>WAF Developer Guide</i>.</p>', ], ], 'OverrideAction' => [ 'base' => '<p>The action to use in the place of the action that results from the rule group evaluation. Set the override action to none to leave the result of the rule group alone. Set it to count to override the result to count only. </p> <p>You can only use this for rule statements that reference a rule group, like <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>. </p> <note> <p>This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead exclude those rules in your rule group reference statement settings. </p> </note>', 'refs' => [ 'FirewallManagerRuleGroup$OverrideAction' => '<p>The action to use in the place of the action that results from the rule group evaluation. Set the override action to none to leave the result of the rule group alone. Set it to count to override the result to count only. </p> <p>You can only use this for rule statements that reference a rule group, like <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>. </p> <note> <p>This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead exclude those rules in your rule group reference statement settings. </p> </note>', 'Rule$OverrideAction' => '<p>The action to use in the place of the action that results from the rule group evaluation. Set the override action to none to leave the result of the rule group alone. Set it to count to override the result to count only. </p> <p>You can only use this for rule statements that reference a rule group, like <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>. </p> <note> <p>This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead exclude those rules in your rule group reference statement settings. </p> </note>', ], ], 'PaginationLimit' => [ 'base' => NULL, 'refs' => [ 'ListAvailableManagedRuleGroupVersionsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListAvailableManagedRuleGroupsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListIPSetsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListLoggingConfigurationsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListManagedRuleSetsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListMobileSdkReleasesRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListRegexPatternSetsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListRuleGroupsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListTagsForResourceRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', 'ListWebACLsRequest$Limit' => '<p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>', ], ], 'ParameterExceptionField' => [ 'base' => NULL, 'refs' => [ 'WAFInvalidParameterException$Field' => '<p>The settings where the invalid parameter was found. </p>', ], ], 'ParameterExceptionParameter' => [ 'base' => NULL, 'refs' => [ 'WAFInvalidParameterException$Parameter' => '<p>The invalid parameter that resulted in the exception. </p>', ], ], 'PasswordField' => [ 'base' => '<p>Details about your login page password field, used in a <code>ManagedRuleGroupConfig</code>. </p>', 'refs' => [ 'ManagedRuleGroupConfig$PasswordField' => '<p>Details about your login page password field. </p>', ], ], 'PayloadType' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleGroupConfig$PayloadType' => '<p>The payload type for your login endpoint, either JSON or form encoded.</p>', ], ], 'Platform' => [ 'base' => NULL, 'refs' => [ 'GenerateMobileSdkReleaseUrlRequest$Platform' => '<p>The device platform.</p>', 'GetMobileSdkReleaseRequest$Platform' => '<p>The device platform.</p>', 'ListMobileSdkReleasesRequest$Platform' => '<p>The device platform to retrieve the list for.</p>', ], ], 'PolicyString' => [ 'base' => NULL, 'refs' => [ 'GetPermissionPolicyResponse$Policy' => '<p>The IAM policy that is attached to the specified rule group.</p>', 'PutPermissionPolicyRequest$Policy' => '<p>The policy to attach to the specified rule group. </p> <p>The policy specifications must conform to the following:</p> <ul> <li> <p>The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.</p> </li> <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li> <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li> <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li> <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>', ], ], 'PopulationSize' => [ 'base' => NULL, 'refs' => [ 'GetSampledRequestsResponse$PopulationSize' => '<p>The total number of requests from which <code>GetSampledRequests</code> got a sample of <code>MaxItems</code> requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the sample includes every request that your Amazon Web Services resource received during the specified time range.</p>', ], ], 'PositionalConstraint' => [ 'base' => NULL, 'refs' => [ 'ByteMatchStatement$PositionalConstraint' => '<p>The area within the portion of a web request that you want WAF to search for <code>SearchString</code>. Valid values include the following:</p> <p> <b>CONTAINS</b> </p> <p>The specified part of the web request must include the value of <code>SearchString</code>, but the location doesn\'t matter.</p> <p> <b>CONTAINS_WORD</b> </p> <p>The specified part of the web request must include the value of <code>SearchString</code>, and <code>SearchString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>SearchString</code> must be a word, which means that both of the following are true:</p> <ul> <li> <p> <code>SearchString</code> is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and <code>;BadBot</code>.</p> </li> <li> <p> <code>SearchString</code> is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code> and <code>-BadBot;</code>.</p> </li> </ul> <p> <b>EXACTLY</b> </p> <p>The value of the specified part of the web request must exactly match the value of <code>SearchString</code>.</p> <p> <b>STARTS_WITH</b> </p> <p>The value of <code>SearchString</code> must appear at the beginning of the specified part of the web request.</p> <p> <b>ENDS_WITH</b> </p> <p>The value of <code>SearchString</code> must appear at the end of the specified part of the web request.</p>', ], ], 'PublishedVersions' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleSet$PublishedVersions' => '<p>The versions of this managed rule set that are available for use by customers. </p>', ], ], 'PutLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutManagedRuleSetVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutManagedRuleSetVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutPermissionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPermissionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueryString' => [ 'base' => '<p>The query string of a web request. This is the part of a URL that appears after a <code>?</code> character, if any.</p> <p>This is used only to indicate the web request component for WAF to inspect, in the <a>FieldToMatch</a> specification. </p> <p>JSON specification: <code>"QueryString": {}</code> </p>', 'refs' => [ 'FieldToMatch$QueryString' => '<p>Inspect the query string. This is the part of a URL that appears after a <code>?</code> character, if any.</p>', ], ], 'RateBasedStatement' => [ 'base' => '<p>A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span. You can use this to put a temporary block on requests from an IP address that is sending excessive requests. </p> <p>WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by WAF. </p> <p>When the rule action triggers, WAF blocks additional requests from the IP address until the request rate falls below the limit.</p> <p>You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:</p> <ul> <li> <p>An IP match statement with an IP set that specified the address 192.0.2.44.</p> </li> <li> <p>A string match statement that searches in the User-Agent header for the string BadBot.</p> </li> </ul> <p>In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet both of the conditions in the statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet both conditions are not counted towards the rate limit and are not affected by this rule.</p> <p>You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a <code>NotStatement</code> or <code>OrStatement</code>. You can define a <code>RateBasedStatement</code> inside a web ACL and inside a rule group. </p>', 'refs' => [ 'Statement$RateBasedStatement' => '<p>A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span. You can use this to put a temporary block on requests from an IP address that is sending excessive requests. </p> <p>WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by WAF. </p> <p>When the rule action triggers, WAF blocks additional requests from the IP address until the request rate falls below the limit.</p> <p>You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:</p> <ul> <li> <p>An IP match statement with an IP set that specified the address 192.0.2.44.</p> </li> <li> <p>A string match statement that searches in the User-Agent header for the string BadBot.</p> </li> </ul> <p>In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet both of the conditions in the statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet both conditions are not counted towards the rate limit and are not affected by this rule.</p> <p>You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a <code>NotStatement</code> or <code>OrStatement</code>. You can define a <code>RateBasedStatement</code> inside a web ACL and inside a rule group. </p>', ], ], 'RateBasedStatementAggregateKeyType' => [ 'base' => NULL, 'refs' => [ 'RateBasedStatement$AggregateKeyType' => '<p>Setting that indicates how to aggregate the request counts. The options are the following:</p> <ul> <li> <p>IP - Aggregate the request counts on the IP address from the web request origin.</p> </li> <li> <p>FORWARDED_IP - Aggregate the request counts on the first IP address in an HTTP header. If you use this, configure the <code>ForwardedIPConfig</code>, to specify the header to use. </p> </li> </ul>', ], ], 'RateBasedStatementManagedKeysIPSet' => [ 'base' => '<p>The set of IP addresses that are currently blocked for a <a>RateBasedStatement</a>.</p>', 'refs' => [ 'GetRateBasedStatementManagedKeysResponse$ManagedKeysIPV4' => '<p>The keys that are of Internet Protocol version 4 (IPv4). </p>', 'GetRateBasedStatementManagedKeysResponse$ManagedKeysIPV6' => '<p>The keys that are of Internet Protocol version 6 (IPv6). </p>', ], ], 'RateLimit' => [ 'base' => NULL, 'refs' => [ 'RateBasedStatement$Limit' => '<p>The limit on requests per 5-minute period for a single originating IP address. If the statement includes a <code>ScopeDownStatement</code>, this limit is applied only to the requests that match the statement.</p>', ], ], 'RedactedFields' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$RedactedFields' => '<p>The parts of the request that you want to keep out of the logs. For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the logs will be <code>xxx</code>. </p> <note> <p>You can specify only the following fields for redaction: <code>UriPath</code>, <code>QueryString</code>, <code>SingleHeader</code>, <code>Method</code>, and <code>JsonBody</code>.</p> </note>', ], ], 'Regex' => [ 'base' => '<p>A single regular expression. This is used in a <a>RegexPatternSet</a>.</p>', 'refs' => [ 'RegularExpressionList$member' => NULL, ], ], 'RegexMatchStatement' => [ 'base' => '<p>A rule statement used to search web request components for a match against a single regular expression. </p>', 'refs' => [ 'Statement$RegexMatchStatement' => '<p>A rule statement used to search web request components for a match against a single regular expression. </p>', ], ], 'RegexPatternSet' => [ 'base' => '<p>Contains one or more regular expressions. </p> <p>WAF assigns an ARN to each <code>RegexPatternSet</code> that you create. To use a set in a rule, you provide the ARN to the <a>Rule</a> statement <a>RegexPatternSetReferenceStatement</a>. </p>', 'refs' => [ 'GetRegexPatternSetResponse$RegexPatternSet' => '<p/>', ], ], 'RegexPatternSetReferenceStatement' => [ 'base' => '<p>A rule statement used to search web request components for matches with regular expressions. To use this, create a <a>RegexPatternSet</a> that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. To create a regex pattern set, see <a>CreateRegexPatternSet</a>.</p> <p>Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.</p>', 'refs' => [ 'Statement$RegexPatternSetReferenceStatement' => '<p>A rule statement used to search web request components for matches with regular expressions. To use this, create a <a>RegexPatternSet</a> that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. To create a regex pattern set, see <a>CreateRegexPatternSet</a>.</p> <p>Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.</p>', ], ], 'RegexPatternSetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListRegexPatternSetsResponse$RegexPatternSets' => '<p/>', ], ], 'RegexPatternSetSummary' => [ 'base' => '<p>High-level information about a <a>RegexPatternSet</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>RegexPatternSet</code>, and the ARN, that you provide to the <a>RegexPatternSetReferenceStatement</a> to use the pattern set in a <a>Rule</a>.</p>', 'refs' => [ 'CreateRegexPatternSetResponse$Summary' => '<p>High-level information about a <a>RegexPatternSet</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>RegexPatternSet</code>, and the ARN, that you provide to the <a>RegexPatternSetReferenceStatement</a> to use the pattern set in a <a>Rule</a>.</p>', 'RegexPatternSetSummaries$member' => NULL, ], ], 'RegexPatternString' => [ 'base' => NULL, 'refs' => [ 'Regex$RegexString' => '<p>The string representing the regular expression.</p>', 'RegexMatchStatement$RegexString' => '<p>The string representing the regular expression.</p>', ], ], 'RegularExpressionList' => [ 'base' => NULL, 'refs' => [ 'CreateRegexPatternSetRequest$RegularExpressionList' => '<p>Array of regular expression strings. </p>', 'RegexPatternSet$RegularExpressionList' => '<p>The regular expression patterns in the set.</p>', 'UpdateRegexPatternSetRequest$RegularExpressionList' => '<p/>', ], ], 'ReleaseNotes' => [ 'base' => NULL, 'refs' => [ 'MobileSdkRelease$ReleaseNotes' => '<p>Notes describing the release.</p>', ], ], 'ReleaseSummaries' => [ 'base' => NULL, 'refs' => [ 'ListMobileSdkReleasesResponse$ReleaseSummaries' => '<p>High level information for the available SDK releases. </p>', ], ], 'ReleaseSummary' => [ 'base' => '<p>High level information for an SDK release. </p>', 'refs' => [ 'ReleaseSummaries$member' => NULL, ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AssociateWebACLRequest$WebACLArn' => '<p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.</p>', 'AssociateWebACLRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to associate with the web ACL. </p> <p>The ARN must be in one of the following formats:</p> <ul> <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li> <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li> <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li> </ul>', 'DeleteFirewallManagerRuleGroupsRequest$WebACLArn' => '<p>The Amazon Resource Name (ARN) of the web ACL.</p>', 'DeleteLoggingConfigurationRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <a>LoggingConfiguration</a>.</p>', 'DeletePermissionPolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the rule group from which you want to delete the policy.</p> <p>You must be the owner of the rule group to perform this operation.</p>', 'DescribeManagedRuleGroupResponse$SnsTopicArn' => '<p>The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that\'s used to record changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple Notification Service Developer Guide</a>.</p>', 'DisassociateWebACLRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to disassociate from the web ACL. </p> <p>The ARN must be in one of the following formats:</p> <ul> <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li> <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li> <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li> </ul>', 'GetLoggingConfigurationRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <a>LoggingConfiguration</a>.</p>', 'GetPermissionPolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the rule group for which you want to get the policy.</p>', 'GetRuleGroupRequest$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'GetSampledRequestsRequest$WebAclArn' => '<p>The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.</p>', 'GetWebACLForResourceRequest$ResourceArn' => '<p>The ARN (Amazon Resource Name) of the resource.</p>', 'IPSet$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'IPSetReferenceStatement$ARN' => '<p>The Amazon Resource Name (ARN) of the <a>IPSet</a> that this statement references.</p>', 'IPSetSummary$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'ListResourcesForWebACLRequest$WebACLArn' => '<p>The Amazon Resource Name (ARN) of the web ACL.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'LogDestinationConfigs$member' => NULL, 'LoggingConfiguration$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code>.</p>', 'ManagedRuleSet$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'ManagedRuleSetSummary$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'ManagedRuleSetVersion$AssociatedRuleGroupArn' => '<p>The Amazon Resource Name (ARN) of the vendor rule group that\'s used to define the published version of your managed rule group. </p>', 'PutPermissionPolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the <a>RuleGroup</a> to which you want to attach the policy.</p>', 'RegexPatternSet$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'RegexPatternSetReferenceStatement$ARN' => '<p>The Amazon Resource Name (ARN) of the <a>RegexPatternSet</a> that this statement references.</p>', 'RegexPatternSetSummary$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'ResourceArns$member' => NULL, 'RuleGroup$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'RuleGroupReferenceStatement$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'RuleGroupSummary$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', 'TagInfoForResource$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'VersionToPublish$AssociatedRuleGroupArn' => '<p>The Amazon Resource Name (ARN) of the vendor\'s rule group that\'s used in the published managed rule group version. </p>', 'WebACL$ARN' => '<p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.</p>', 'WebACLSummary$ARN' => '<p>The Amazon Resource Name (ARN) of the entity.</p>', ], ], 'ResourceArns' => [ 'base' => NULL, 'refs' => [ 'ListResourcesForWebACLResponse$ResourceArns' => '<p>The array of Amazon Resource Names (ARNs) of the associated resources.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ListResourcesForWebACLRequest$ResourceType' => '<p>Used for web ACLs that are scoped for regional applications. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>', ], ], 'ResponseCode' => [ 'base' => NULL, 'refs' => [ 'CaptchaResponse$ResponseCode' => '<p>The HTTP response code indicating the status of the <code>CAPTCHA</code> token in the web request. If the token is missing, invalid, or expired, this code is <code>405 Method Not Allowed</code>.</p>', ], ], 'ResponseContent' => [ 'base' => NULL, 'refs' => [ 'CustomResponseBody$Content' => '<p>The payload of the custom response. </p> <p>You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the <code>ContentType</code> setting. </p> <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', ], ], 'ResponseContentType' => [ 'base' => NULL, 'refs' => [ 'CustomResponseBody$ContentType' => '<p>The type of content in the payload that you are defining in the <code>Content</code> string.</p>', ], ], 'ResponseStatusCode' => [ 'base' => NULL, 'refs' => [ 'CustomResponse$ResponseCode' => '<p>The HTTP status code to return to the client. </p> <p>For a list of status codes that you can use in your custom reqponses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html">Supported status codes for custom response</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>', 'SampledHTTPRequest$ResponseCodeSent' => '<p>The response code that was sent for the request.</p>', ], ], 'Rule' => [ 'base' => '<p>A single rule, which you can use in a <a>WebACL</a> or <a>RuleGroup</a> to identify web requests that you want to allow, block, or count. Each rule includes one top-level <a>Statement</a> that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'refs' => [ 'Rules$member' => NULL, ], ], 'RuleAction' => [ 'base' => '<p>The action that WAF should take on a web request when it matches a rule\'s statement. Settings at the web ACL level can override the rule action setting. </p>', 'refs' => [ 'Rule$Action' => '<p>The action that WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting. </p> <p>This is used only for rules whose statements do not reference a rule group. Rule statements that reference a rule group include <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>. </p> <p>You must specify either this <code>Action</code> setting or the rule <code>OverrideAction</code> setting, but not both:</p> <ul> <li> <p>If the rule statement does not reference a rule group, use this rule action setting and not the rule override action setting. </p> </li> <li> <p>If the rule statement references a rule group, use the override action setting and not this action setting. </p> </li> </ul>', 'RuleSummary$Action' => '<p>The action that WAF should take on a web request when it matches a rule\'s statement. Settings at the web ACL level can override the rule action setting. </p>', ], ], 'RuleGroup' => [ 'base' => '<p> A rule group defines a collection of rules to inspect and control web requests that you can use in a <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements. </p>', 'refs' => [ 'GetRuleGroupResponse$RuleGroup' => '<p/>', ], ], 'RuleGroupReferenceStatement' => [ 'base' => '<p>A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.</p> <p>You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement at the top level inside a web ACL. </p>', 'refs' => [ 'FirewallManagerStatement$RuleGroupReferenceStatement' => '<p>A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.</p> <p>You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement at the top level inside a web ACL. </p>', 'Statement$RuleGroupReferenceStatement' => '<p>A rule statement used to run the rules that are defined in a <a>RuleGroup</a>. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.</p> <p>You cannot nest a <code>RuleGroupReferenceStatement</code>, for example for use inside a <code>NotStatement</code> or <code>OrStatement</code>. You can only use a rule group reference statement at the top level inside a web ACL. </p>', ], ], 'RuleGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListRuleGroupsResponse$RuleGroups' => '<p/>', ], ], 'RuleGroupSummary' => [ 'base' => '<p>High-level information about a <a>RuleGroup</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that you provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a <a>Rule</a>.</p>', 'refs' => [ 'CreateRuleGroupResponse$Summary' => '<p>High-level information about a <a>RuleGroup</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that you provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a <a>Rule</a>.</p>', 'RuleGroupSummaries$member' => NULL, ], ], 'RulePriority' => [ 'base' => NULL, 'refs' => [ 'FirewallManagerRuleGroup$Priority' => '<p>If you define more than one rule group in the first or last Firewall Manager rule groups, WAF evaluates each request against the rule groups in order, starting from the lowest priority setting. The priorities don\'t need to be consecutive, but they must all be different.</p>', 'Rule$Priority' => '<p>If you define more than one <code>Rule</code> in a <code>WebACL</code>, WAF evaluates each request against the <code>Rules</code> in order based on the value of <code>Priority</code>. WAF processes rules with lower priority first. The priorities don\'t need to be consecutive, but they must all be different.</p>', ], ], 'RuleSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedRuleGroupResponse$Rules' => '<p/>', ], ], 'RuleSummary' => [ 'base' => '<p>High-level information about a <a>Rule</a>, returned by operations like <a>DescribeManagedRuleGroup</a>. This provides information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that you provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a <a>Rule</a>.</p>', 'refs' => [ 'RuleSummaries$member' => NULL, ], ], 'Rules' => [ 'base' => NULL, 'refs' => [ 'CheckCapacityRequest$Rules' => '<p>An array of <a>Rule</a> that you\'re configuring to use in a rule group or web ACL. </p>', 'CreateRuleGroupRequest$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'CreateWebACLRequest$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'RuleGroup$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'UpdateRuleGroupRequest$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'UpdateWebACLRequest$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', 'WebACL$Rules' => '<p>The <a>Rule</a> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>', ], ], 'SampleWeight' => [ 'base' => NULL, 'refs' => [ 'SampledHTTPRequest$Weight' => '<p>A value that indicates how one result in the response relates proportionally to other results in the response. For example, a result that has a weight of <code>2</code> represents roughly twice as many web requests as a result that has a weight of <code>1</code>.</p>', ], ], 'SampledHTTPRequest' => [ 'base' => '<p>Represents a single sampled web request. The response from <a>GetSampledRequests</a> includes a <code>SampledHTTPRequests</code> complex type that appears as <code>SampledRequests</code> in the response syntax. <code>SampledHTTPRequests</code> contains an array of <code>SampledHTTPRequest</code> objects.</p>', 'refs' => [ 'SampledHTTPRequests$member' => NULL, ], ], 'SampledHTTPRequests' => [ 'base' => NULL, 'refs' => [ 'GetSampledRequestsResponse$SampledRequests' => '<p>A complex type that contains detailed information about each of the requests in the sample.</p>', ], ], 'Scope' => [ 'base' => NULL, 'refs' => [ 'CheckCapacityRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'CreateIPSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'CreateRegexPatternSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'CreateRuleGroupRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'CreateWebACLRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DeleteIPSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DeleteRegexPatternSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DeleteRuleGroupRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DeleteWebACLRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'DescribeManagedRuleGroupRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetIPSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetManagedRuleSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetRateBasedStatementManagedKeysRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetRegexPatternSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetRuleGroupRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetSampledRequestsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'GetWebACLRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListAvailableManagedRuleGroupVersionsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListAvailableManagedRuleGroupsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListIPSetsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListLoggingConfigurationsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListManagedRuleSetsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListRegexPatternSetsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListRuleGroupsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'ListWebACLsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'PutManagedRuleSetVersionsRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'UpdateIPSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'UpdateManagedRuleSetVersionExpiryDateRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'UpdateRegexPatternSetRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'UpdateRuleGroupRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', 'UpdateWebACLRequest$Scope' => '<p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p> <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p> <ul> <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li> <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li> </ul>', ], ], 'SearchString' => [ 'base' => NULL, 'refs' => [ 'ByteMatchStatement$SearchString' => '<p>A string value that you want WAF to search for. WAF searches only in the part of web requests that you designate for inspection in <a>FieldToMatch</a>. The maximum length of the value is 50 bytes.</p> <p>Valid values depend on the component that you specify for inspection in <code>FieldToMatch</code>:</p> <ul> <li> <p> <code>Method</code>: The HTTP method that you want WAF to search for. This indicates the type of operation specified in the request. </p> </li> <li> <p> <code>UriPath</code>: The value that you want WAF to search for in the URI path, for example, <code>/images/daily-ad.jpg</code>. </p> </li> </ul> <p>If <code>SearchString</code> includes alphabetic characters A-Z and a-z, note that the value is case sensitive.</p> <p> <b>If you\'re using the WAF API</b> </p> <p>Specify a base64-encoded version of the value. The maximum length of the value before you base64-encode it is 50 bytes.</p> <p>For example, suppose the value of <code>Type</code> is <code>HEADER</code> and the value of <code>Data</code> is <code>User-Agent</code>. If you want to search the <code>User-Agent</code> header for the value <code>BadBot</code>, you base64-encode <code>BadBot</code> using MIME base64-encoding and include the resulting value, <code>QmFkQm90</code>, in the value of <code>SearchString</code>.</p> <p> <b>If you\'re using the CLI or one of the Amazon Web Services SDKs</b> </p> <p>The value that you want WAF to search for. The SDK automatically base64 encodes the value.</p>', ], ], 'SingleHeader' => [ 'base' => '<p>One of the headers in a web request, identified by name, for example, <code>User-Agent</code> or <code>Referer</code>. This setting isn\'t case sensitive.</p> <p>This is used only to indicate the web request component for WAF to inspect, in the <a>FieldToMatch</a> specification. </p> <p>Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code> </p>', 'refs' => [ 'FieldToMatch$SingleHeader' => '<p>Inspect a single header. Provide the name of the header to inspect, for example, <code>User-Agent</code> or <code>Referer</code>. This setting isn\'t case sensitive.</p> <p>Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code> </p>', ], ], 'SingleQueryArgument' => [ 'base' => '<p>One query argument in a web request, identified by name, for example <i>UserName</i> or <i>SalesRegion</i>. The name can be up to 30 characters long and isn\'t case sensitive. </p> <p>Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code> </p>', 'refs' => [ 'FieldToMatch$SingleQueryArgument' => '<p>Inspect a single query argument. Provide the name of the query argument to inspect, such as <i>UserName</i> or <i>SalesRegion</i>. The name can be up to 30 characters long and isn\'t case sensitive. </p> <p>This is used only to indicate the web request component for WAF to inspect, in the <a>FieldToMatch</a> specification. </p> <p>Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code> </p>', ], ], 'Size' => [ 'base' => NULL, 'refs' => [ 'SizeConstraintStatement$Size' => '<p>The size, in byte, to compare to the request part, after any transformations.</p>', ], ], 'SizeConstraintStatement' => [ 'base' => '<p>A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (&gt;) or less than (&lt;). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes. </p> <p>If you configure WAF to inspect the request body, WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you can create a size constraint condition and block requests that have a request body greater than 8192 bytes.</p> <p>If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.</p>', 'refs' => [ 'Statement$SizeConstraintStatement' => '<p>A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (&gt;) or less than (&lt;). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes. </p> <p>If you configure WAF to inspect the request body, WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you can create a size constraint condition and block requests that have a request body greater than 8192 bytes.</p> <p>If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.</p>', ], ], 'SolveTimestamp' => [ 'base' => NULL, 'refs' => [ 'CaptchaResponse$SolveTimestamp' => '<p>The time that the <code>CAPTCHA</code> puzzle was solved for the supplied token. </p>', ], ], 'SqliMatchStatement' => [ 'base' => '<p>Attackers sometimes insert malicious SQL code into web requests in an effort to extract data from your database. To allow or block web requests that appear to contain malicious SQL code, create one or more SQL injection match conditions. An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want WAF to inspect. Later in the process, when you create a web ACL, you specify whether to allow or block requests that appear to contain malicious SQL code.</p>', 'refs' => [ 'Statement$SqliMatchStatement' => '<p>Attackers sometimes insert malicious SQL code into web requests in an effort to extract data from your database. To allow or block web requests that appear to contain malicious SQL code, create one or more SQL injection match conditions. An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want WAF to inspect. Later in the process, when you create a web ACL, you specify whether to allow or block requests that appear to contain malicious SQL code.</p>', ], ], 'Statement' => [ 'base' => '<p>The processing guidance for a <a>Rule</a>, used by WAF to determine whether a web request matches the rule. </p>', 'refs' => [ 'ManagedRuleGroupStatement$ScopeDownStatement' => '<p>An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group. Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable <a>Statement</a> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement. </p>', 'NotStatement$Statement' => '<p>The statement to negate. You can use any statement that can be nested.</p>', 'RateBasedStatement$ScopeDownStatement' => '<p>An optional nested statement that narrows the scope of the web requests that are evaluated by the rate-based statement. Requests are only tracked by the rate-based statement if they match the scope-down statement. You can use any nestable <a>Statement</a> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement. </p>', 'Rule$Statement' => '<p>The WAF processing statement for the rule, for example <a>ByteMatchStatement</a> or <a>SizeConstraintStatement</a>. </p>', 'Statements$member' => NULL, ], ], 'Statements' => [ 'base' => NULL, 'refs' => [ 'AndStatement$Statements' => '<p>The statements to combine with AND logic. You can use any statements that can be nested. </p>', 'OrStatement$Statements' => '<p>The statements to combine with OR logic. You can use any statements that can be nested.</p>', ], ], 'Tag' => [ 'base' => '<p>A tag associated with an Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing or other management. Typically, the tag key represents a category, such as "environment", and the tag value represents a specific value within that category, such as "test," "development," or "production". Or you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can\'t manage or view tags through the WAF console. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagInfoForResource' => [ 'base' => '<p>The collection of tagging definitions for an Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing or other management. Typically, the tag key represents a category, such as "environment", and the tag value represents a specific value within that category, such as "test," "development," or "production". Or you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p> <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can\'t manage or view tags through the WAF console. </p>', 'refs' => [ 'ListTagsForResourceResponse$TagInfoForResource' => '<p>The collection of tagging definitions for the resource. </p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>An array of keys identifying the tags to disassociate from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateIPSetRequest$Tags' => '<p>An array of key:value pairs to associate with the resource.</p>', 'CreateRegexPatternSetRequest$Tags' => '<p>An array of key:value pairs to associate with the resource.</p>', 'CreateRuleGroupRequest$Tags' => '<p>An array of key:value pairs to associate with the resource.</p>', 'CreateWebACLRequest$Tags' => '<p>An array of key:value pairs to associate with the resource.</p>', 'MobileSdkRelease$Tags' => '<p>Tags that are associated with the release. </p>', 'TagInfoForResource$TagList' => '<p>The array of <a>Tag</a> objects defined for the resource. </p>', 'TagResourceRequest$Tags' => '<p>An array of key:value pairs to associate with the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>', ], ], 'TextTransformation' => [ 'base' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. </p>', 'refs' => [ 'TextTransformations$member' => NULL, ], ], 'TextTransformationPriority' => [ 'base' => NULL, 'refs' => [ 'TextTransformation$Priority' => '<p>Sets the relative processing order for multiple transformations that are defined for a rule statement. WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don\'t need to be consecutive, but they must all be different. </p>', ], ], 'TextTransformationType' => [ 'base' => NULL, 'refs' => [ 'TextTransformation$Type' => '<p>You can specify the following transformation types:</p> <p> <b>BASE64_DECODE</b> - Decode a <code>Base64</code>-encoded string.</p> <p> <b>BASE64_DECODE_EXT</b> - Decode a <code>Base64</code>-encoded string, but use a forgiving implementation that ignores characters that aren\'t valid.</p> <p> <b>CMD_LINE</b> - Command-line transformations. These are helpful in reducing effectiveness of attackers who inject an operating system command-line command and use unusual formatting to disguise some or all of the command. </p> <ul> <li> <p>Delete the following characters: <code>\\ " \' ^</code> </p> </li> <li> <p>Delete spaces before the following characters: <code>/ (</code> </p> </li> <li> <p>Replace the following characters with a space: <code>, ;</code> </p> </li> <li> <p>Replace multiple spaces with one space</p> </li> <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li> </ul> <p> <b>COMPRESS_WHITE_SPACE</b> - Replace these characters with a space character (decimal 32): </p> <ul> <li> <p> <code>\\f</code>, formfeed, decimal 12</p> </li> <li> <p> <code>\\t</code>, tab, decimal 9</p> </li> <li> <p> <code>\\n</code>, newline, decimal 10</p> </li> <li> <p> <code>\\r</code>, carriage return, decimal 13</p> </li> <li> <p> <code>\\v</code>, vertical tab, decimal 11</p> </li> <li> <p>Non-breaking space, decimal 160</p> </li> </ul> <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p> <p> <b>CSS_DECODE</b> - Decode characters that were encoded using CSS 2.x escape rules <code>syndata.html#characters</code>. This function uses up to two bytes in the decoding process, so it can help to uncover ASCII characters that were encoded using CSS encoding that wouldn’t typically be encoded. It\'s also useful in countering evasion, which is a combination of a backslash and non-hexadecimal characters. For example, <code>ja\\vascript</code> for javascript. </p> <p> <b>ESCAPE_SEQ_DECODE</b> - Decode the following ANSI C escape sequences: <code>\\a</code>, <code>\\b</code>, <code>\\f</code>, <code>\\n</code>, <code>\\r</code>, <code>\\t</code>, <code>\\v</code>, <code>\\\\</code>, <code>\\?</code>, <code>\\\'</code>, <code>\\"</code>, <code>\\xHH</code> (hexadecimal), <code>\\0OOO</code> (octal). Encodings that aren\'t valid remain in the output. </p> <p> <b>HEX_DECODE</b> - Decode a string of hexadecimal characters into a binary.</p> <p> <b>HTML_ENTITY_DECODE</b> - Replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs these operations: </p> <ul> <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li> <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li> <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li> <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li> <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li> <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li> </ul> <p> <b>JS_DECODE</b> - Decode JavaScript escape sequences. If a <code>\\</code> <code>u</code> <code>HHHH</code> code is in the full-width ASCII code range of <code>FF01-FF5E</code>, then the higher byte is used to detect and adjust the lower byte. If not, only the lower byte is used and the higher byte is zeroed, causing a possible loss of information. </p> <p> <b>LOWERCASE</b> - Convert uppercase letters (A-Z) to lowercase (a-z). </p> <p> <b>MD5</b> - Calculate an MD5 hash from the data in the input. The computed hash is in a raw binary form. </p> <p> <b>NONE</b> - Specify <code>NONE</code> if you don\'t want any text transformations. </p> <p> <b>NORMALIZE_PATH</b> - Remove multiple slashes, directory self-references, and directory back-references that are not at the beginning of the input from an input string. </p> <p> <b>NORMALIZE_PATH_WIN</b> - This is the same as <code>NORMALIZE_PATH</code>, but first converts backslash characters to forward slashes. </p> <p> <b>REMOVE_NULLS</b> - Remove all <code>NULL</code> bytes from the input. </p> <p> <b>REPLACE_COMMENTS</b> - Replace each occurrence of a C-style comment (<code>/* ... */</code>) with a single space. Multiple consecutive occurrences are not compressed. Unterminated comments are also replaced with a space (ASCII 0x20). However, a standalone termination of a comment (<code>*/</code>) is not acted upon. </p> <p> <b>REPLACE_NULLS</b> - Replace NULL bytes in the input with space characters (ASCII <code>0x20</code>). </p> <p> <b>SQL_HEX_DECODE</b> - Decode SQL hex data. Example (<code>0x414243</code>) will be decoded to (<code>ABC</code>).</p> <p> <b>URL_DECODE</b> - Decode a URL-encoded value. </p> <p> <b>URL_DECODE_UNI</b> - Like <code>URL_DECODE</code>, but with support for Microsoft-specific <code>%u</code> encoding. If the code is in the full-width ASCII code range of <code>FF01-FF5E</code>, the higher byte is used to detect and adjust the lower byte. Otherwise, only the lower byte is used and the higher byte is zeroed. </p> <p> <b>UTF8_TO_UNICODE</b> - Convert all UTF-8 character sequences to Unicode. This helps input normalization, and minimizing false-positives and false-negatives for non-English languages.</p>', ], ], 'TextTransformations' => [ 'base' => NULL, 'refs' => [ 'ByteMatchStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code>, starting from the lowest priority setting, before inspecting the content for a match.</p>', 'RegexMatchStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code>, starting from the lowest priority setting, before inspecting the content for a match.</p>', 'RegexPatternSetReferenceStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code>, starting from the lowest priority setting, before inspecting the content for a match.</p>', 'SizeConstraintStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code>, starting from the lowest priority setting, before inspecting the content for a match.</p>', 'SqliMatchStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code>, starting from the lowest priority setting, before inspecting the content for a match.</p>', 'XssMatchStatement$TextTransformations' => '<p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code>, starting from the lowest priority setting, before inspecting the content for a match.</p>', ], ], 'TimeWindow' => [ 'base' => '<p>In a <a>GetSampledRequests</a> request, the <code>StartTime</code> and <code>EndTime</code> objects specify the time range for which you want WAF to return a sample of web requests.</p> <p>You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p> <p>In a <a>GetSampledRequests</a> response, the <code>StartTime</code> and <code>EndTime</code> objects specify the time range for which WAF actually returned a sample of web requests. WAF gets the specified number of requests from among the first 5,000 requests that your Amazon Web Services resource receives during the specified time period. If your resource receives more than 5,000 requests during that period, WAF stops sampling after the 5,000th request. In that case, <code>EndTime</code> is the time that WAF received the 5,000th request.</p>', 'refs' => [ 'GetSampledRequestsRequest$TimeWindow' => '<p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours. If you specify a start time that\'s earlier than three hours ago, WAF sets it to three hours ago.</p>', 'GetSampledRequestsResponse$TimeWindow' => '<p>Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code> request. However, if your Amazon Web Services resource received more than 5,000 requests during the time range that you specified in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000 requests. Times are in Coordinated Universal Time (UTC) format.</p>', ], ], 'TimeWindowDay' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleSetVersion$ForecastedLifetime' => '<p>The amount of time you expect this version of your managed rule group to last, in days. </p>', 'VersionToPublish$ForecastedLifetime' => '<p>The amount of time the vendor expects this version of the managed rule group to last, in days. </p>', ], ], 'TimeWindowSecond' => [ 'base' => NULL, 'refs' => [ 'ImmunityTimeProperty$ImmunityTime' => '<p>The amount of time, in seconds, that a <code>CAPTCHA</code> token is valid. The default setting is 300.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ManagedRuleGroupVersion$LastUpdateTimestamp' => '<p>The date and time that the managed rule group owner updated the rule group version information. </p>', 'ManagedRuleSetVersion$PublishTimestamp' => '<p>The time that you first published this version. </p> <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>', 'ManagedRuleSetVersion$LastUpdateTimestamp' => '<p>The last time that you updated this version. </p> <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>', 'ManagedRuleSetVersion$ExpiryTimestamp' => '<p>The time that this version is set to expire.</p> <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>', 'MobileSdkRelease$Timestamp' => '<p>The timestamp of the release. </p>', 'ReleaseSummary$Timestamp' => '<p>The timestamp of the release. </p>', 'SampledHTTPRequest$Timestamp' => '<p>The time at which WAF received the request from your Amazon Web Services resource, in Unix time format (in seconds).</p>', 'TimeWindow$StartTime' => '<p>The beginning of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your Amazon Web Services resource received. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>', 'TimeWindow$EndTime' => '<p>The end of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your Amazon Web Services resource received. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>', 'UpdateManagedRuleSetVersionExpiryDateRequest$ExpiryTimestamp' => '<p>The time that you want the version to expire.</p> <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>', 'UpdateManagedRuleSetVersionExpiryDateResponse$ExpiryTimestamp' => '<p>The time that the version will expire. </p> <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>', ], ], 'URIString' => [ 'base' => NULL, 'refs' => [ 'HTTPRequest$URI' => '<p>The URI path of the request, which identifies the resource, for example, <code>/images/daily-ad.jpg</code>.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIPSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIPSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateManagedRuleSetVersionExpiryDateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateManagedRuleSetVersionExpiryDateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRegexPatternSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRegexPatternSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWebACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWebACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'UriPath' => [ 'base' => '<p>The path component of the URI of a web request. This is the part of a web request that identifies a resource. For example, <code>/images/daily-ad.jpg</code>.</p> <p>This is used only to indicate the web request component for WAF to inspect, in the <a>FieldToMatch</a> specification. </p> <p>JSON specification: <code>"UriPath": {}</code> </p>', 'refs' => [ 'FieldToMatch$UriPath' => '<p>Inspect the request URI path. This is the part of a web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code>.</p>', ], ], 'UsernameField' => [ 'base' => '<p>Details about your login page username field, used in a <code>ManagedRuleGroupConfig</code>. </p>', 'refs' => [ 'ManagedRuleGroupConfig$UsernameField' => '<p>Details about your login page username field. </p>', ], ], 'VendorName' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedRuleGroupRequest$VendorName' => '<p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>', 'ListAvailableManagedRuleGroupVersionsRequest$VendorName' => '<p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>', 'ManagedRuleGroupStatement$VendorName' => '<p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>', 'ManagedRuleGroupSummary$VendorName' => '<p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>', ], ], 'VersionKeyString' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedRuleGroupRequest$VersionName' => '<p>The version of the rule group. You can only use a version that is not scheduled for expiration. If you don\'t provide this, WAF uses the vendor\'s default version. </p>', 'DescribeManagedRuleGroupResponse$VersionName' => '<p>The managed rule group\'s version. </p>', 'GenerateMobileSdkReleaseUrlRequest$ReleaseVersion' => '<p>The release version. For the latest available version, specify <code>LATEST</code>.</p>', 'GetMobileSdkReleaseRequest$ReleaseVersion' => '<p>The release version. For the latest available version, specify <code>LATEST</code>.</p>', 'ManagedRuleGroupStatement$Version' => '<p>The version of the managed rule group to use. If you specify this, the version setting is fixed until you change it. If you don\'t specify this, WAF uses the vendor\'s default version, and then keeps the version at the vendor\'s default when the vendor updates the managed rule group settings. </p>', 'ManagedRuleGroupVersion$Name' => '<p>The version name. </p>', 'ManagedRuleSet$RecommendedVersion' => '<p>The version that you would like your customers to use.</p>', 'MobileSdkRelease$ReleaseVersion' => '<p>The release version. </p>', 'PublishedVersions$key' => NULL, 'PutManagedRuleSetVersionsRequest$RecommendedVersion' => '<p>The version of the named managed rule group that you\'d like your customers to choose, from among your version offerings. </p>', 'ReleaseSummary$ReleaseVersion' => '<p>The release version. </p>', 'UpdateManagedRuleSetVersionExpiryDateRequest$VersionToExpire' => '<p>The version that you want to remove from your list of offerings for the named managed rule group. </p>', 'UpdateManagedRuleSetVersionExpiryDateResponse$ExpiringVersion' => '<p>The version that is set to expire. </p>', 'VersionsToPublish$key' => NULL, ], ], 'VersionToPublish' => [ 'base' => '<p>A version of the named managed rule group, that the rule group\'s vendor publishes for use by customers. </p> <note> <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p> <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p> </note>', 'refs' => [ 'VersionsToPublish$value' => NULL, ], ], 'VersionsToPublish' => [ 'base' => NULL, 'refs' => [ 'PutManagedRuleSetVersionsRequest$VersionsToPublish' => '<p>The versions of the named managed rule group that you want to offer to your customers. </p>', ], ], 'VisibilityConfig' => [ 'base' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'refs' => [ 'CreateRuleGroupRequest$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'CreateWebACLRequest$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'FirewallManagerRuleGroup$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'Rule$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'RuleGroup$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'UpdateRuleGroupRequest$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'UpdateWebACLRequest$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', 'WebACL$VisibilityConfig' => '<p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>', ], ], 'WAFAssociatedItemException' => [ 'base' => '<p>WAF couldn’t perform the operation because your resource is being used by another resource or it’s associated with another resource. </p>', 'refs' => [], ], 'WAFDuplicateItemException' => [ 'base' => '<p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>', 'refs' => [], ], 'WAFExpiredManagedRuleGroupVersionException' => [ 'base' => '<p>The operation failed because the specified version for the managed rule group has expired. You can retrieve the available versions for the managed rule group by calling <a>ListAvailableManagedRuleGroupVersions</a>.</p>', 'refs' => [], ], 'WAFInternalErrorException' => [ 'base' => '<p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>', 'refs' => [], ], 'WAFInvalidOperationException' => [ 'base' => '<p>The operation isn\'t valid. </p>', 'refs' => [], ], 'WAFInvalidParameterException' => [ 'base' => '<p>The operation failed because WAF didn\'t recognize a parameter in the request. For example: </p> <ul> <li> <p>You specified a parameter name or value that isn\'t valid.</p> </li> <li> <p>Your nested statement isn\'t valid. You might have tried to nest a statement that can’t be nested. </p> </li> <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn\'t among the types available at <a>DefaultAction</a>.</p> </li> <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can\'t be associated.</p> </li> </ul>', 'refs' => [], ], 'WAFInvalidPermissionPolicyException' => [ 'base' => '<p>The operation failed because the specified policy isn\'t in the proper format. </p> <p>The policy specifications must conform to the following:</p> <ul> <li> <p>The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.</p> </li> <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li> <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li> <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li> <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>', 'refs' => [], ], 'WAFInvalidResourceException' => [ 'base' => '<p>WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the resource, and try again.</p>', 'refs' => [], ], 'WAFLimitsExceededException' => [ 'base' => '<p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [], ], 'WAFLogDestinationPermissionIssueException' => [ 'base' => '<p>The operation failed because you don\'t have the permissions that your logging configuration requires. For information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p>', 'refs' => [], ], 'WAFNonexistentItemException' => [ 'base' => '<p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>', 'refs' => [], ], 'WAFOptimisticLockException' => [ 'base' => '<p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>', 'refs' => [], ], 'WAFServiceLinkedRoleErrorException' => [ 'base' => '<p>WAF is not able to access the service linked role. This can be caused by a previous <code>PutLoggingConfiguration</code> request, which can lock the service linked role for about 20 seconds. Please try your request again. The service linked role can also be locked by a previous <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If you recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the request again. If you receive this same exception again, you will have to wait additional time until the role is unlocked.</p>', 'refs' => [], ], 'WAFSubscriptionNotFoundException' => [ 'base' => '<p>You tried to use a managed rule group that\'s available by subscription, but you aren\'t subscribed to it yet. </p>', 'refs' => [], ], 'WAFTagOperationException' => [ 'base' => '<p>An error occurred during the tagging operation. Retry your request.</p>', 'refs' => [], ], 'WAFTagOperationInternalErrorException' => [ 'base' => '<p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>', 'refs' => [], ], 'WAFUnavailableEntityException' => [ 'base' => '<p>WAF couldn’t retrieve the resource that you requested. Retry your request.</p>', 'refs' => [], ], 'WebACL' => [ 'base' => '<p> A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API. </p>', 'refs' => [ 'GetWebACLForResourceResponse$WebACL' => '<p>The web ACL that is associated with the resource. If there is no associated resource, WAF returns a null web ACL.</p>', 'GetWebACLResponse$WebACL' => '<p>The web ACL specification. You can modify the settings in this web ACL and use it to update this web ACL or create a new one.</p>', ], ], 'WebACLSummaries' => [ 'base' => NULL, 'refs' => [ 'ListWebACLsResponse$WebACLs' => '<p/>', ], ], 'WebACLSummary' => [ 'base' => '<p>High-level information about a <a>WebACL</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>WebACL</code>, and the ARN, that you provide to operations like <a>AssociateWebACL</a>.</p>', 'refs' => [ 'CreateWebACLResponse$Summary' => '<p>High-level information about a <a>WebACL</a>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>WebACL</code>, and the ARN, that you provide to operations like <a>AssociateWebACL</a>.</p>', 'WebACLSummaries$member' => NULL, ], ], 'XssMatchStatement' => [ 'base' => '<p>A rule statement that defines a cross-site scripting (XSS) match search for WAF to apply to web requests. XSS attacks are those where the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers. The XSS match statement provides the location in requests that you want WAF to search and text transformations to use on the search area before WAF searches for character sequences that are likely to be malicious strings. </p>', 'refs' => [ 'Statement$XssMatchStatement' => '<p>A rule statement that defines a cross-site scripting (XSS) match search for WAF to apply to web requests. XSS attacks are those where the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers. The XSS match statement provides the location in requests that you want WAF to search and text transformations to use on the search area before WAF searches for character sequences that are likely to be malicious strings. </p>', ], ], ],];
