<?php
// This file was auto-generated from sdk-root/src/data/gamelift/2015-10-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>GameLift Service</fullname> <p>Amazon Web Services provides solutions for hosting session-based multiplayer game servers in the cloud, including tools for deploying, operating, and scaling game servers. Built on Amazon Web Services global computing infrastructure, GameLift helps you deliver high-performance, high-reliability, low-cost game servers while dynamically scaling your resource usage to meet player demand. </p> <p> <b>About GameLift solutions</b> </p> <p>Get more information on these GameLift solutions in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/">GameLift Developer Guide</a>.</p> <ul> <li> <p>GameLift managed hosting -- GameLift offers a fully managed service to set up and maintain computing machines for hosting, manage game session and player session life cycle, and handle security, storage, and performance tracking. You can use automatic scaling tools to balance player demand and hosting costs, configure your game session management to minimize player latency, and add FlexMatch for matchmaking.</p> </li> <li> <p>Managed hosting with Realtime Servers -- With GameLift Realtime Servers, you can quickly configure and set up ready-to-go game servers for your game. Realtime Servers provides a game server framework with core GameLift infrastructure already built in. Then use the full range of GameLift managed hosting features, including FlexMatch, for your game.</p> </li> <li> <p>GameLift FleetIQ -- Use GameLift FleetIQ as a standalone service while hosting your games using EC2 instances and Auto Scaling groups. GameLift FleetIQ provides optimizations for game hosting, including boosting the viability of low-cost Spot Instances gaming. For a complete solution, pair the GameLift FleetIQ and FlexMatch standalone services.</p> </li> <li> <p>GameLift FlexMatch -- Add matchmaking to your game hosting solution. FlexMatch is a customizable matchmaking service for multiplayer games. Use FlexMatch as integrated with GameLift managed hosting or incorporate FlexMatch as a standalone service into your own hosting solution.</p> </li> </ul> <p> <b>About this API Reference</b> </p> <p>This reference guide describes the low-level service API for Amazon Web Services. With each topic in this guide, you can find links to language-specific SDK guides and the Amazon Web Services CLI reference. Useful links:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html">GameLift API operations listed by tasks</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-components.html"> GameLift tools and resources</a> </p> </li> </ul>', 'operations' => [ 'AcceptMatch' => '<p>Registers a player\'s acceptance or rejection of a proposed FlexMatch match. A matchmaking configuration may require player acceptance; if so, then matches built with that configuration cannot be completed unless all players accept the proposed match within a specified time limit. </p> <p>When FlexMatch builds a match, all the matchmaking tickets involved in the proposed match are placed into status <code>REQUIRES_ACCEPTANCE</code>. This is a trigger for your game to get acceptance from all players in the ticket. Acceptances are only valid for tickets when they are in this status; all other acceptances result in an error.</p> <p>To register acceptance, specify the ticket ID, a response, and one or more players. Once all players have registered acceptance, the matchmaking tickets advance to status <code>PLACING</code>, where a new game session is created for the match. </p> <p>If any player rejects the match, or if acceptances are not received before a specified timeout, the proposed match is dropped. The matchmaking tickets are then handled in one of two ways: For tickets where one or more players rejected the match, the ticket status is returned to <code>SEARCHING</code> to find a new match. For tickets where one or more players failed to respond, the ticket status is set to <code>CANCELLED</code>, and processing is terminated. A new matchmaking request for these players can be submitted as needed. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game client</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html"> FlexMatch events</a> (reference)</p> <p> <b>Related actions</b> </p> <p> <a>StartMatchmaking</a> | <a>DescribeMatchmaking</a> | <a>StopMatchmaking</a> | <a>AcceptMatch</a> | <a>StartMatchBackfill</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'ClaimGameServer' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Locates an available game server and temporarily reserves it to host gameplay and players. This operation is called from a game client or client service (such as a matchmaker) to request hosting resources for a new game session. In response, GameLift FleetIQ locates an available game server, places it in <code>CLAIMED</code> status for 60 seconds, and returns connection information that players can use to connect to the game server. </p> <p>To claim a game server, identify a game server group. You can also specify a game server ID, although this approach bypasses GameLift FleetIQ placement optimization. Optionally, include game data to pass to the game server at the start of a game session, such as a game map or player information. </p> <p>When a game server is successfully claimed, connection information is returned. A claimed game server\'s utilization status remains <code>AVAILABLE</code> while the claim status is set to <code>CLAIMED</code> for up to 60 seconds. This time period gives the game server time to update its status to <code>UTILIZED</code> (using <a>UpdateGameServer</a>) once players join. If the game server\'s status is not updated within 60 seconds, the game server reverts to unclaimed status and is available to be claimed by another request. The claim time period is a fixed value and is not configurable.</p> <p>If you try to claim a specific game server, this request will fail in the following cases:</p> <ul> <li> <p>If the game server utilization status is <code>UTILIZED</code>.</p> </li> <li> <p>If the game server claim status is <code>CLAIMED</code>.</p> </li> </ul> <note> <p>When claiming a specific game server, this request will succeed even if the game server is running on an instance in <code>DRAINING</code> status. To avoid this, first check the instance status by calling <a>DescribeGameServerInstances</a>.</p> </note> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>RegisterGameServer</a> | <a>ListGameServers</a> | <a>ClaimGameServer</a> | <a>DescribeGameServer</a> | <a>UpdateGameServer</a> | <a>DeregisterGameServer</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'CreateAlias' => '<p>Creates an alias for a fleet. In most situations, you can use an alias ID in place of a fleet ID. An alias provides a level of abstraction for a fleet that is useful when redirecting player traffic from one fleet to another, such as when updating your game build. </p> <p>Amazon Web Services supports two types of routing strategies for aliases: simple and terminal. A simple alias points to an active fleet. A terminal alias is used to display messaging or link to a URL instead of routing players to an active fleet. For example, you might use a terminal alias when a game version is no longer supported and you want to direct players to an upgrade site. </p> <p>To create a fleet alias, specify an alias name, routing strategy, and optional description. Each simple alias can point to only one fleet, but a fleet can have multiple aliases. If successful, a new alias record is returned, including an alias ID and an ARN. You can reassign an alias to another fleet by calling <code>UpdateAlias</code>.</p> <p> <b>Related actions</b> </p> <p> <a>CreateAlias</a> | <a>ListAliases</a> | <a>DescribeAlias</a> | <a>UpdateAlias</a> | <a>DeleteAlias</a> | <a>ResolveAlias</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreateBuild' => '<p>Creates a new Amazon Web Services build resource for your game server binary files. Game server binaries must be combined into a zip file for use with Amazon Web Services. </p> <important> <p>When setting up a new game build for GameLift, we recommend using the Amazon Web Services CLI command <b> <a href="https://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html">upload-build</a> </b>. This helper command combines two tasks: (1) it uploads your build files from a file directory to a GameLift Amazon S3 location, and (2) it creates a new build resource. </p> </important> <p>The <code>CreateBuild</code> operation can used in the following scenarios:</p> <ul> <li> <p>To create a new game build with build files that are in an Amazon S3 location under an Amazon Web Services account that you control. To use this option, you must first give Amazon Web Services access to the Amazon S3 bucket. With permissions in place, call <code>CreateBuild</code> and specify a build name, operating system, and the Amazon S3 storage location of your game build.</p> </li> <li> <p>To directly upload your build files to a GameLift Amazon S3 location. To use this option, first call <code>CreateBuild</code> and specify a build name and operating system. This operation creates a new build resource and also returns an Amazon S3 location with temporary access credentials. Use the credentials to manually upload your build files to the specified Amazon S3 location. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html">Uploading Objects</a> in the <i>Amazon S3 Developer Guide</i>. Build files can be uploaded to the GameLift Amazon S3 location once only; that can\'t be updated. </p> </li> </ul> <p>If successful, this operation creates a new build resource with a unique build ID and places it in <code>INITIALIZED</code> status. A build must be in <code>READY</code> status before you can create fleets with it.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html">Uploading Your Game</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"> Create a Build with Files in Amazon S3</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateBuild</a> | <a>ListBuilds</a> | <a>DescribeBuild</a> | <a>UpdateBuild</a> | <a>DeleteBuild</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreateFleet' => '<p>Creates a fleet of Amazon Elastic Compute Cloud (Amazon Elastic Compute Cloud) instances to host your custom game server or Realtime Servers. Use this operation to configure the computing resources for your fleet and provide instructions for running game servers on each instance.</p> <p>Most GameLift fleets can deploy instances to multiple locations, including the home Region (where the fleet is created) and an optional set of remote locations. Fleets that are created in the following Amazon Web Services Regions support multiple locations: us-east-1 (N. Virginia), us-west-2 (Oregon), eu-central-1 (Frankfurt), eu-west-1 (Ireland), ap-southeast-2 (Sydney), ap-northeast-1 (Tokyo), and ap-northeast-2 (Seoul). Fleets that are created in other GameLift Regions can deploy instances in the fleet\'s home Region only. All fleet instances use the same configuration regardless of location; however, you can adjust capacity settings and turn auto-scaling on/off for each location.</p> <p>To create a fleet, choose the hardware for your instances, specify a game server build or Realtime script to deploy, and provide a runtime configuration to direct GameLift how to start and run game servers on each instance in the fleet. Set permissions for inbound traffic to your game servers, and enable optional features as needed. When creating a multi-location fleet, provide a list of additional remote locations.</p> <p>If you need to debug your fleet, fetch logs, view performance metrics or other actions on the fleet, create the development fleet with port 22/3389 open. As a best practice, we recommend opening ports for remote access only when you need them and closing them when you\'re finished. </p> <p>If successful, this operation creates a new Fleet resource and places it in <code>NEW</code> status, which prompts GameLift to initiate the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creation-workflow.html">fleet creation workflow</a>. You can track fleet creation by checking fleet status using <a>DescribeFleetAttributes</a> and <a>DescribeFleetLocationAttributes</a>/, or by monitoring fleet creation events using <a>DescribeFleetEvents</a>. As soon as the fleet status changes to <code>ACTIVE</code>, you can enable automatic scaling for the fleet with <a>PutScalingPolicy</a> and set capacity for the home Region with <a>UpdateFleetCapacity</a>. When the status of each remote location reaches <code>ACTIVE</code>, you can set capacity by location using <a>UpdateFleetCapacity</a>.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation">Debug fleet creation issues</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Multi-location fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleet</a> | <a>UpdateFleetCapacity</a> | <a>PutScalingPolicy</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetLocationAttributes</a> | <a>UpdateFleetAttributes</a> | <a>StopFleetActions</a> | <a>DeleteFleet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreateFleetLocations' => '<p>Adds remote locations to a fleet and begins populating the new locations with EC2 instances. The new instances conform to the fleet\'s instance type, auto-scaling, and other configuration settings. </p> <note> <p>This operation cannot be used with fleets that don\'t support remote locations. Fleets can have multiple locations only if they reside in Amazon Web Services Regions that support this feature (see <a>CreateFleet</a> for the complete list) and were created after the feature was released in March 2021.</p> </note> <p>To add fleet locations, specify the fleet to be updated and provide a list of one or more locations. </p> <p>If successful, this operation returns the list of added locations with their status set to <code>NEW</code>. GameLift initiates the process of starting an instance in each added location. You can track the status of each new location by monitoring location creation events using <a>DescribeFleetEvents</a>. Alternatively, you can poll location status by calling <a>DescribeFleetLocationAttributes</a>. After a location status becomes <code>ACTIVE</code>, you can adjust the location\'s capacity as needed with <a>UpdateFleetCapacity</a>.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Multi-location fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleetLocations</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetLocationCapacity</a> | <a>DescribeFleetLocationUtilization</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetUtilization</a> | <a>UpdateFleetCapacity</a> | <a>StopFleetActions</a> | <a>DeleteFleetLocations</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreateGameServerGroup' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Creates a GameLift FleetIQ game server group for managing game hosting on a collection of Amazon Elastic Compute Cloud instances for game hosting. This operation creates the game server group, creates an Auto Scaling group in your Amazon Web Services account, and establishes a link between the two groups. You can view the status of your game server groups in the GameLift console. Game server group metrics and events are emitted to Amazon CloudWatch.</p> <p>Before creating a new game server group, you must have the following: </p> <ul> <li> <p>An Amazon Elastic Compute Cloud launch template that specifies how to launch Amazon Elastic Compute Cloud instances with your game server build. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html"> Launching an Instance from a Launch Template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p> </li> <li> <p>An IAM role that extends limited access to your Amazon Web Services account to allow GameLift FleetIQ to create and interact with the Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html">Create IAM roles for cross-service interaction</a> in the <i>GameLift FleetIQ Developer Guide</i>.</p> </li> </ul> <p>To create a new game server group, specify a unique group name, IAM role and Amazon Elastic Compute Cloud launch template, and provide a list of instance types that can be used in the group. You must also set initial maximum and minimum limits on the group\'s instance count. You can optionally set an Auto Scaling policy with target tracking based on a GameLift FleetIQ metric.</p> <p>Once the game server group and corresponding Auto Scaling group are created, you have full access to change the Auto Scaling group\'s configuration as needed. Several properties that are set when creating a game server group, including maximum/minimum size and auto-scaling policy settings, must be updated directly in the Auto Scaling group. Keep in mind that some Auto Scaling group properties are periodically updated by GameLift FleetIQ as part of its balancing activities to optimize for availability and cost.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameServerGroup</a> | <a>ListGameServerGroups</a> | <a>DescribeGameServerGroup</a> | <a>UpdateGameServerGroup</a> | <a>DeleteGameServerGroup</a> | <a>ResumeGameServerGroup</a> | <a>SuspendGameServerGroup</a> | <a>DescribeGameServerInstances</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'CreateGameSession' => '<p>Creates a multiplayer game session for players in a specific fleet location. This operation prompts an available server process to start a game session and retrieves connection information for the new game session. As an alternative, consider using the GameLift game session placement feature with </p> <p>with <a>StartGameSessionPlacement</a>, which uses FleetIQ algorithms and queues to optimize the placement process.</p> <p>When creating a game session, you specify exactly where you want to place it and provide a set of game session configuration settings. The fleet must be in <code>ACTIVE</code> status before a game session can be created in it. </p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To create a game session on an instance in a fleet\'s home Region, provide a fleet or alias ID along with your game session configuration. </p> </li> <li> <p>To create a game session on an instance in a fleet\'s remote location, provide a fleet or alias ID and a location name, along with your game session configuration. </p> </li> </ul> <p>If successful, a workflow is initiated to start a new game session. A <code>GameSession</code> object is returned containing the game session configuration and status. When the status is <code>ACTIVE</code>, game session connection information is provided and player sessions can be created for the game session. By default, newly created game sessions are open to new players. You can restrict new player access by using <a>UpdateGameSession</a> to change the game session\'s player session creation policy.</p> <p>Game session logs are retained for all active game sessions for 14 days. To access the logs, call <a>GetGameSessionLogUrl</a> to download the log files.</p> <p> <i>Available in Amazon Web Services Local.</i> </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a game session</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameSession</a> | <a>DescribeGameSessions</a> | <a>DescribeGameSessionDetails</a> | <a>SearchGameSessions</a> | <a>UpdateGameSession</a> | <a>GetGameSessionLogUrl</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreateGameSessionQueue' => '<p>Creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to determine the best placement locations and find an available game server there, then prompts the game server process to start a new game session. </p> <p>A game session queue is configured with a set of destinations (GameLift fleets or aliases), which determine the locations where the queue can place new game sessions. These destinations can span multiple fleet types (Spot and On-Demand), instance types, and Amazon Web Services Regions. If the queue includes multi-location fleets, the queue is able to place game sessions in all of a fleet\'s remote locations. You can opt to filter out individual locations if needed.</p> <p>The queue configuration also determines how FleetIQ selects the best available placement for a new game session. Before searching for an available game server, FleetIQ first prioritizes the queue\'s destinations and locations, with the best placement locations on top. You can set up the queue to use the FleetIQ default prioritization or provide an alternate set of priorities.</p> <p>To create a new queue, provide a name, timeout value, and a list of destinations. Optionally, specify a sort configuration and/or a filter, and define a set of latency cap policies. You can also include the ARN for an Amazon Simple Notification Service (SNS) topic to receive notifications of game session placement activity. Notifications using SNS or CloudWatch events is the preferred way to track placement activity.</p> <p>If successful, a new <code>GameSessionQueue</code> object is returned with an assigned queue ARN. New game session requests, which are submitted to queue with <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html">StartGameSessionPlacement</a> or <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html">StartMatchmaking</a>, reference a queue\'s name or ARN. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-design.html"> Design a game session queue</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-creating.html"> Create a game session queue</a> </p> <p> <b>Related actions</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">CreateGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html">DescribeGameSessionQueues</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html">UpdateGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html">DeleteGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreateMatchmakingConfiguration' => '<p>Defines a new matchmaking configuration for use with FlexMatch. Whether your are using FlexMatch with GameLift hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for matching players and forming teams. If you\'re also using GameLift hosting, it defines how to start game sessions for each match. Your matchmaking system can use multiple configurations to handle different game scenarios. All matchmaking requests (<a>StartMatchmaking</a> or <a>StartMatchBackfill</a>) identify the matchmaking configuration to use and provide player attributes consistent with that configuration. </p> <p>To create a matchmaking configuration, you must provide the following: configuration name and FlexMatch mode (with or without GameLift hosting); a rule set that specifies how to evaluate players and find acceptable matches; whether player acceptance is required; and the maximum time allowed for a matchmaking attempt. When using FlexMatch with GameLift hosting, you also need to identify the game session queue to use when starting a game session for the match.</p> <p>In addition, you must set up an Amazon Simple Notification Service topic to receive matchmaking notifications. Provide the topic ARN in the matchmaking configuration. An alternative method, continuously polling ticket status with <a>DescribeMatchmaking</a>, is only suitable for games in development with low matchmaking usage.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html"> Design a FlexMatch matchmaker</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set up FlexMatch event notification</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateMatchmakingConfiguration</a> | <a>DescribeMatchmakingConfigurations</a> | <a>UpdateMatchmakingConfiguration</a> | <a>DeleteMatchmakingConfiguration</a> | <a>CreateMatchmakingRuleSet</a> | <a>DescribeMatchmakingRuleSets</a> | <a>ValidateMatchmakingRuleSet</a> | <a>DeleteMatchmakingRuleSet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreateMatchmakingRuleSet' => '<p>Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the number and size of teams. It also sets the parameters for acceptable player matches, such as minimum skill level or character type. A rule set is used by a <a>MatchmakingConfiguration</a>. </p> <p>To create a matchmaking rule set, provide unique rule set name and the rule set body in JSON format. Rule sets must be defined in the same Region as the matchmaking configuration they are used with.</p> <p>Since matchmaking rule sets cannot be edited, it is a good idea to check the rule set syntax using <a>ValidateMatchmakingRuleSet</a> before creating a new rule set.</p> <p> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html">Design a matchmaker</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html">Matchmaking with FlexMatch</a> </p> </li> </ul> <p> <b>Related actions</b> </p> <p> <a>CreateMatchmakingConfiguration</a> | <a>DescribeMatchmakingConfigurations</a> | <a>UpdateMatchmakingConfiguration</a> | <a>DeleteMatchmakingConfiguration</a> | <a>CreateMatchmakingRuleSet</a> | <a>DescribeMatchmakingRuleSets</a> | <a>ValidateMatchmakingRuleSet</a> | <a>DeleteMatchmakingRuleSet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreatePlayerSession' => '<p>Reserves an open player slot in a game session for a player. New player sessions can be created in any game session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of <code>ACCEPT_ALL</code>. You can add a group of players to a game session with <a>CreatePlayerSessions</a>. </p> <p>To create a player session, specify a game session ID, player ID, and optionally a set of player data. </p> <p>If successful, a slot is reserved in the game session for the player and a new <a>PlayerSession</a> object is returned with a player session ID. The player references the player session ID when sending a connection request to the game session, and the game server can use it to validate the player reservation with the GameLift service. Player sessions cannot be updated. </p> <p>The maximum number of players per game session is 200. It is not adjustable. </p> <p> <i>Available in Amazon Web Services Local.</i> </p> <p> <b>Related actions</b> </p> <p> <a>CreatePlayerSession</a> | <a>CreatePlayerSessions</a> | <a>DescribePlayerSessions</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreatePlayerSessions' => '<p>Reserves open slots in a game session for a group of players. New player sessions can be created in any game session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of <code>ACCEPT_ALL</code>. To add a single player to a game session, use <a>CreatePlayerSession</a>. </p> <p>To create player sessions, specify a game session ID and a list of player IDs. Optionally, provide a set of player data for each player ID. </p> <p>If successful, a slot is reserved in the game session for each player, and new <a>PlayerSession</a> objects are returned with player session IDs. Each player references their player session ID when sending a connection request to the game session, and the game server can use it to validate the player reservation with the GameLift service. Player sessions cannot be updated.</p> <p>The maximum number of players per game session is 200. It is not adjustable. </p> <p> <i>Available in Amazon Web Services Local.</i> </p> <p> <b>Related actions</b> </p> <p> <a>CreatePlayerSession</a> | <a>CreatePlayerSessions</a> | <a>DescribePlayerSessions</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreateScript' => '<p>Creates a new script record for your Realtime Servers script. Realtime scripts are JavaScript that provide configuration settings and optional custom game logic for your game. The script is deployed when you create a Realtime Servers fleet to host your game sessions. Script logic is executed during an active game session. </p> <p>To create a new script record, specify a script name and provide the script file(s). The script files and all dependencies must be zipped into a single file. You can pull the zip file from either of these locations: </p> <ul> <li> <p>A locally available directory. Use the <i>ZipFile</i> parameter for this option.</p> </li> <li> <p>An Amazon Simple Storage Service (Amazon S3) bucket under your Amazon Web Services account. Use the <i>StorageLocation</i> parameter for this option. You\'ll need to have an Identity Access Management (IAM) role that allows the Amazon Web Services service to access your S3 bucket. </p> </li> </ul> <p>If the call is successful, a new script record is created with a unique script ID. If the script file is provided as a local file, the file is uploaded to an Amazon Web Services-owned S3 bucket and the script record\'s storage location reflects this location. If the script file is provided as an S3 bucket, Amazon Web Services accesses the file at this storage location as needed for deployment.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon Web Services Realtime Servers</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set Up a Role for Amazon Web Services Access</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateScript</a> | <a>ListScripts</a> | <a>DescribeScript</a> | <a>UpdateScript</a> | <a>DeleteScript</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreateVpcPeeringAuthorization' => '<p>Requests authorization to create or delete a peer connection between the VPC for your Amazon Web Services fleet and a virtual private cloud (VPC) in your Amazon Web Services account. VPC peering enables the game servers on your fleet to communicate directly with other Amazon Web Services resources. Once you\'ve received authorization, call <a>CreateVpcPeeringConnection</a> to establish the peering connection. For more information, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon Web Services Fleets</a>.</p> <p>You can peer with VPCs that are owned by any Amazon Web Services account you have access to, including the account that you use to manage your Amazon Web Services fleets. You cannot peer with VPCs that are in different Regions.</p> <p>To request authorization to create a connection, call this operation from the Amazon Web Services account with the VPC that you want to peer to your Amazon Web Services fleet. For example, to enable your game servers to retrieve data from a DynamoDB table, use the account that manages that DynamoDB resource. Identify the following values: (1) The ID of the VPC that you want to peer with, and (2) the ID of the Amazon Web Services account that you use to manage Amazon Web Services. If successful, VPC peering is authorized for the specified VPC. </p> <p>To request authorization to delete a connection, call this operation from the Amazon Web Services account with the VPC that is peered with your Amazon Web Services fleet. Identify the following values: (1) VPC ID that you want to delete the peering connection for, and (2) ID of the Amazon Web Services account that you use to manage Amazon Web Services. </p> <p>The authorization remains valid for 24 hours unless it is canceled by a call to <a>DeleteVpcPeeringAuthorization</a>. You must create or delete the peering connection while the authorization is valid. </p> <p> <b>Related actions</b> </p> <p> <a>CreateVpcPeeringAuthorization</a> | <a>DescribeVpcPeeringAuthorizations</a> | <a>DeleteVpcPeeringAuthorization</a> | <a>CreateVpcPeeringConnection</a> | <a>DescribeVpcPeeringConnections</a> | <a>DeleteVpcPeeringConnection</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'CreateVpcPeeringConnection' => '<p>Establishes a VPC peering connection between a virtual private cloud (VPC) in an Amazon Web Services account with the VPC for your Amazon Web Services fleet. VPC peering enables the game servers on your fleet to communicate directly with other Amazon Web Services resources. You can peer with VPCs in any Amazon Web Services account that you have access to, including the account that you use to manage your Amazon Web Services fleets. You cannot peer with VPCs that are in different Regions. For more information, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon Web Services Fleets</a>.</p> <p>Before calling this operation to establish the peering connection, you first need to call <a>CreateVpcPeeringAuthorization</a> and identify the VPC you want to peer with. Once the authorization for the specified VPC is issued, you have 24 hours to establish the connection. These two operations handle all tasks necessary to peer the two VPCs, including acceptance, updating routing tables, etc. </p> <p>To establish the connection, call this operation from the Amazon Web Services account that is used to manage the Amazon Web Services fleets. Identify the following values: (1) The ID of the fleet you want to be enable a VPC peering connection for; (2) The Amazon Web Services account with the VPC that you want to peer with; and (3) The ID of the VPC you want to peer with. This operation is asynchronous. If successful, a <a>VpcPeeringConnection</a> request is created. You can use continuous polling to track the request\'s status using <a>DescribeVpcPeeringConnections</a>, or by monitoring fleet events for success or failure using <a>DescribeFleetEvents</a>. </p> <p> <b>Related actions</b> </p> <p> <a>CreateVpcPeeringAuthorization</a> | <a>DescribeVpcPeeringAuthorizations</a> | <a>DeleteVpcPeeringAuthorization</a> | <a>CreateVpcPeeringConnection</a> | <a>DescribeVpcPeeringConnections</a> | <a>DeleteVpcPeeringConnection</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteAlias' => '<p>Deletes an alias. This operation removes all record of the alias. Game clients attempting to access a server process using the deleted alias receive an error. To delete an alias, specify the alias ID to be deleted.</p> <p> <b>Related actions</b> </p> <p> <a>CreateAlias</a> | <a>ListAliases</a> | <a>DescribeAlias</a> | <a>UpdateAlias</a> | <a>DeleteAlias</a> | <a>ResolveAlias</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteBuild' => '<p>Deletes a build. This operation permanently deletes the build resource and any uploaded build files. Deleting a build does not affect the status of any active fleets using the build, but you can no longer create new fleets with the deleted build.</p> <p>To delete a build, specify the build ID. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom Server Build</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateBuild</a> | <a>ListBuilds</a> | <a>DescribeBuild</a> | <a>UpdateBuild</a> | <a>DeleteBuild</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteFleet' => '<p>Deletes all resources and information related a fleet. Any current fleet instances, including those in remote locations, are shut down. You don\'t need to call <code>DeleteFleetLocations</code> separately.</p> <note> <p>If the fleet being deleted has a VPC peering connection, you first need to get a valid authorization (good for 24 hours) by calling <a>CreateVpcPeeringAuthorization</a>. You do not need to explicitly delete the VPC peering connection--this is done as part of the delete fleet process.</p> </note> <p>To delete a fleet, specify the fleet ID to be terminated. During the deletion process the fleet status is changed to <code>DELETING</code>. When completed, the status switches to <code>TERMINATED</code> and the fleet event <code>FLEET_DELETED</code> is sent.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift Fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleetLocations</a> | <a>UpdateFleetAttributes</a> | <a>UpdateFleetCapacity</a> | <a>UpdateFleetPortSettings</a> | <a>UpdateRuntimeConfiguration</a> | <a>StopFleetActions</a> | <a>StartFleetActions</a> | <a>PutScalingPolicy</a> | <a>DeleteFleet</a> | <a>DeleteFleetLocations</a> | <a>DeleteScalingPolicy</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteFleetLocations' => '<p>Removes locations from a multi-location fleet. When deleting a location, all game server process and all instances that are still active in the location are shut down. </p> <p>To delete fleet locations, identify the fleet ID and provide a list of the locations to be deleted. </p> <p>If successful, GameLift sets the location status to <code>DELETING</code>, and begins to shut down existing server processes and terminate instances in each location being deleted. When completed, the location status changes to <code>TERMINATED</code>.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleetLocations</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetLocationCapacity</a> | <a>DescribeFleetLocationUtilization</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetUtilization</a> | <a>UpdateFleetCapacity</a> | <a>StopFleetActions</a> | <a>DeleteFleetLocations</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteGameServerGroup' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Terminates a game server group and permanently deletes the game server group record. You have several options for how these resources are impacted when deleting the game server group. Depending on the type of delete operation selected, this operation might affect these resources:</p> <ul> <li> <p>The game server group</p> </li> <li> <p>The corresponding Auto Scaling group</p> </li> <li> <p>All game servers that are currently running in the group</p> </li> </ul> <p>To delete a game server group, identify the game server group to delete and specify the type of delete operation to initiate. Game server groups can only be deleted if they are in <code>ACTIVE</code> or <code>ERROR</code> status.</p> <p>If the delete request is successful, a series of operations are kicked off. The game server group status is changed to <code>DELETE_SCHEDULED</code>, which prevents new game servers from being registered and stops automatic scaling activity. Once all game servers in the game server group are deregistered, GameLift FleetIQ can begin deleting resources. If any of the delete operations fail, the game server group is placed in <code>ERROR</code> status.</p> <p>GameLift FleetIQ emits delete events to Amazon CloudWatch.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameServerGroup</a> | <a>ListGameServerGroups</a> | <a>DescribeGameServerGroup</a> | <a>UpdateGameServerGroup</a> | <a>DeleteGameServerGroup</a> | <a>ResumeGameServerGroup</a> | <a>SuspendGameServerGroup</a> | <a>DescribeGameServerInstances</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'DeleteGameSessionQueue' => '<p>Deletes a game session queue. Once a queue is successfully deleted, unfulfilled <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html">StartGameSessionPlacement</a> requests that reference the queue will fail. To delete a queue, specify the queue name.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html"> Using Multi-Region Queues</a> </p> <p> <b>Related actions</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">CreateGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html">DescribeGameSessionQueues</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html">UpdateGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html">DeleteGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteMatchmakingConfiguration' => '<p>Permanently removes a FlexMatch matchmaking configuration. To delete, specify the configuration name. A matchmaking configuration cannot be deleted if it is being used in any active matchmaking tickets.</p> <p> <b>Related actions</b> </p> <p> <a>CreateMatchmakingConfiguration</a> | <a>DescribeMatchmakingConfigurations</a> | <a>UpdateMatchmakingConfiguration</a> | <a>DeleteMatchmakingConfiguration</a> | <a>CreateMatchmakingRuleSet</a> | <a>DescribeMatchmakingRuleSets</a> | <a>ValidateMatchmakingRuleSet</a> | <a>DeleteMatchmakingRuleSet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteMatchmakingRuleSet' => '<p>Deletes an existing matchmaking rule set. To delete the rule set, provide the rule set name. Rule sets cannot be deleted if they are currently being used by a matchmaking configuration. </p> <p> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a> </p> </li> </ul> <p> <b>Related actions</b> </p> <p> <a>CreateMatchmakingConfiguration</a> | <a>DescribeMatchmakingConfigurations</a> | <a>UpdateMatchmakingConfiguration</a> | <a>DeleteMatchmakingConfiguration</a> | <a>CreateMatchmakingRuleSet</a> | <a>DescribeMatchmakingRuleSets</a> | <a>ValidateMatchmakingRuleSet</a> | <a>DeleteMatchmakingRuleSet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteScalingPolicy' => '<p>Deletes a fleet scaling policy. Once deleted, the policy is no longer in force and GameLift removes all record of it. To delete a scaling policy, specify both the scaling policy name and the fleet ID it is associated with.</p> <p>To temporarily suspend scaling policies, call <a>StopFleetActions</a>. This operation suspends all policies for the fleet.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeFleetCapacity</a> | <a>UpdateFleetCapacity</a> | <a>DescribeEC2InstanceLimits</a> | <a>PutScalingPolicy</a> | <a>DescribeScalingPolicies</a> | <a>DeleteScalingPolicy</a> | <a>StopFleetActions</a> | <a>StartFleetActions</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteScript' => '<p>Deletes a Realtime script. This operation permanently deletes the script record. If script files were uploaded, they are also deleted (files stored in an S3 bucket are not deleted). </p> <p>To delete a script, specify the script ID. Before deleting a script, be sure to terminate all fleets that are deployed with the script being deleted. Fleet instances periodically check for script updates, and if the script record no longer exists, the instance will go into an error state and be unable to host game sessions.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon Web Services Realtime Servers</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateScript</a> | <a>ListScripts</a> | <a>DescribeScript</a> | <a>UpdateScript</a> | <a>DeleteScript</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteVpcPeeringAuthorization' => '<p>Cancels a pending VPC peering authorization for the specified VPC. If you need to delete an existing VPC peering connection, call <a>DeleteVpcPeeringConnection</a>. </p> <p> <b>Related actions</b> </p> <p> <a>CreateVpcPeeringAuthorization</a> | <a>DescribeVpcPeeringAuthorizations</a> | <a>DeleteVpcPeeringAuthorization</a> | <a>CreateVpcPeeringConnection</a> | <a>DescribeVpcPeeringConnections</a> | <a>DeleteVpcPeeringConnection</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeleteVpcPeeringConnection' => '<p>Removes a VPC peering connection. To delete the connection, you must have a valid authorization for the VPC peering connection that you want to delete. You can check for an authorization by calling <a>DescribeVpcPeeringAuthorizations</a> or request a new one using <a>CreateVpcPeeringAuthorization</a>. </p> <p>Once a valid authorization exists, call this operation from the Amazon Web Services account that is used to manage the Amazon Web Services fleets. Identify the connection to delete by the connection ID and fleet ID. If successful, the connection is removed. </p> <p> <b>Related actions</b> </p> <p> <a>CreateVpcPeeringAuthorization</a> | <a>DescribeVpcPeeringAuthorizations</a> | <a>DeleteVpcPeeringAuthorization</a> | <a>CreateVpcPeeringConnection</a> | <a>DescribeVpcPeeringConnections</a> | <a>DeleteVpcPeeringConnection</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DeregisterGameServer' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Removes the game server from a game server group. As a result of this operation, the deregistered game server can no longer be claimed and will not be returned in a list of active game servers. </p> <p>To deregister a game server, specify the game server group and game server ID. If successful, this operation emits a CloudWatch event with termination timestamp and reason.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>RegisterGameServer</a> | <a>ListGameServers</a> | <a>ClaimGameServer</a> | <a>DescribeGameServer</a> | <a>UpdateGameServer</a> | <a>DeregisterGameServer</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'DescribeAlias' => '<p>Retrieves properties for an alias. This operation returns all alias metadata and settings. To get an alias\'s target fleet ID only, use <code>ResolveAlias</code>. </p> <p>To get alias properties, specify the alias ID. If successful, the requested alias record is returned.</p> <p> <b>Related actions</b> </p> <p> <a>CreateAlias</a> | <a>ListAliases</a> | <a>DescribeAlias</a> | <a>UpdateAlias</a> | <a>DeleteAlias</a> | <a>ResolveAlias</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeBuild' => '<p>Retrieves properties for a custom game build. To request a build resource, specify a build ID. If successful, an object containing the build properties is returned.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom Server Build</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateBuild</a> | <a>ListBuilds</a> | <a>DescribeBuild</a> | <a>UpdateBuild</a> | <a>DeleteBuild</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeEC2InstanceLimits' => '<p>The GameLift service limits and current utilization for an Amazon Web Services Region or location. Instance limits control the number of instances, per instance type, per location, that your Amazon Web Services account can use. Learn more at <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>. The information returned includes the maximum number of instances allowed and your account\'s current usage across all fleets. This information can affect your ability to scale your GameLift fleets. You can request a limit increase for your account by using the <b>Service limits</b> page in the GameLift console.</p> <p>Instance limits differ based on whether the instances are deployed in a fleet\'s home Region or in a remote location. For remote locations, limits also differ based on the combination of home Region and remote location. All requests must specify an Amazon Web Services Region (either explicitly or as your default settings). To get the limit for a remote location, you must also specify the location. For example, the following requests all return different results: </p> <ul> <li> <p>Request specifies the Region <code>ap-northeast-1</code> with no location. The result is limits and usage data on all instance types that are deployed in <code>us-east-2</code>, by all of the fleets that reside in <code>ap-northeast-1</code>. </p> </li> <li> <p>Request specifies the Region <code>us-east-1</code> with location <code>ca-central-1</code>. The result is limits and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that reside in <code>us-east-2</code>. These limits do not affect fleets in any other Regions that deploy instances to <code>ca-central-1</code>.</p> </li> <li> <p>Request specifies the Region <code>eu-west-1</code> with location <code>ca-central-1</code>. The result is limits and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that reside in <code>eu-west-1</code>.</p> </li> </ul> <p>This operation can be used in the following ways:</p> <ul> <li> <p>To get limit and usage data for all instance types that are deployed in an Amazon Web Services Region by fleets that reside in the same Region: Specify the Region only. Optionally, specify a single instance type to retrieve information for.</p> </li> <li> <p>To get limit and usage data for all instance types that are deployed to a remote location by fleets that reside in different Amazon Web Services Region: Provide both the Amazon Web Services Region and the remote location. Optionally, specify a single instance type to retrieve information for.</p> </li> </ul> <p>If successful, an <code>EC2InstanceLimits</code> object is returned with limits and usage data for each requested instance type.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleet</a> | <a>UpdateFleetCapacity</a> | <a>PutScalingPolicy</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetLocationAttributes</a> | <a>UpdateFleetAttributes</a> | <a>StopFleetActions</a> | <a>DeleteFleet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeFleetAttributes' => '<p>Retrieves core fleet-wide properties, including the computing hardware and deployment configuration for all instances in the fleet.</p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To get attributes for one or more specific fleets, provide a list of fleet IDs or fleet ARNs. </p> </li> <li> <p>To get attributes for all fleets, do not provide a fleet identifier. </p> </li> </ul> <p>When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet identifier is not found. </p> <note> <p>Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit, the request fails and the error message contains the maximum allowed number.</p> </note> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>ListFleets</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetEvents</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetPortSettings</a> | <a>DescribeFleetUtilization</a> | <a>DescribeRuntimeConfiguration</a> | <a>DescribeScalingPolicies</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeFleetCapacity' => '<p>Retrieves the resource capacity settings for one or more fleets. The data returned includes the current fleet capacity (number of EC2 instances), and settings that can control how capacity scaling. For fleets with remote locations, this operation retrieves data for the fleet\'s home Region only. See <a>DescribeFleetLocationCapacity</a> to get capacity settings for a fleet\'s remote locations.</p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs. </p> </li> <li> <p>To get capacity data for all fleets, do not provide a fleet identifier. </p> </li> </ul> <p>When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a <a>FleetCapacity</a> object is returned for each requested fleet ID. Each FleetCapacity object includes a <code>Location</code> property, which is set to the fleet\'s home Region. When a list of fleet IDs is provided, attribute objects are returned only for fleets that currently exist.</p> <note> <p>Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this limit, the request fails and the error message includes the maximum allowed.</p> </note> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet">GameLift metrics for fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>ListFleets</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetEvents</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetPortSettings</a> | <a>DescribeFleetUtilization</a> | <a>DescribeRuntimeConfiguration</a> | <a>DescribeScalingPolicies</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeFleetEvents' => '<p>Retrieves entries from a fleet\'s event log. Fleet events are initiated by changes in status, such as during fleet creation and termination, changes in capacity, etc. If a fleet has multiple locations, events are also initiated by changes to status and capacity in remote locations. </p> <p>You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a collection of event log entries matching the request are returned.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>ListFleets</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetEvents</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetPortSettings</a> | <a>DescribeFleetUtilization</a> | <a>DescribeRuntimeConfiguration</a> | <a>DescribeScalingPolicies</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeFleetLocationAttributes' => '<p>Retrieves information on a fleet\'s remote locations, including life-cycle status and any suspended fleet activity. </p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To get data for specific locations, provide a fleet identifier and a list of locations. Location data is returned in the order that it is requested. </p> </li> <li> <p>To get data for all locations, provide a fleet identifier only. Location data is returned in no particular order. </p> </li> </ul> <p>When requesting attributes for multiple locations, use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a <code>LocationAttributes</code> object is returned for each requested location. If the fleet does not have a requested location, no information is returned. This operation does not return the home Region. To get information on a fleet\'s home Region, call <code>DescribeFleetAttributes</code>.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleetLocations</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetLocationCapacity</a> | <a>DescribeFleetLocationUtilization</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetUtilization</a> | <a>UpdateFleetCapacity</a> | <a>StopFleetActions</a> | <a>DeleteFleetLocations</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeFleetLocationCapacity' => '<p>Retrieves the resource capacity settings for a fleet location. The data returned includes the current capacity (number of EC2 instances) and some scaling settings for the requested fleet location. Use this operation to retrieve capacity information for a fleet\'s remote location or home Region (you can also retrieve home Region capacity by calling <code>DescribeFleetCapacity</code>).</p> <p>To retrieve capacity data, identify a fleet and location. </p> <p>If successful, a <code>FleetCapacity</code> object is returned for the requested fleet location. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet">GameLift metrics for fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleetLocations</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetLocationCapacity</a> | <a>DescribeFleetLocationUtilization</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetUtilization</a> | <a>UpdateFleetCapacity</a> | <a>StopFleetActions</a> | <a>DeleteFleetLocations</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeFleetLocationUtilization' => '<p>Retrieves current usage data for a fleet location. Utilization data provides a snapshot of current game hosting activity at the requested location. Use this operation to retrieve utilization information for a fleet\'s remote location or home Region (you can also retrieve home Region utilization by calling <code>DescribeFleetUtilization</code>).</p> <p>To retrieve utilization data, identify a fleet and location. </p> <p>If successful, a <code>FleetUtilization</code> object is returned for the requested fleet location. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet">GameLift metrics for fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleetLocations</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetLocationCapacity</a> | <a>DescribeFleetLocationUtilization</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetUtilization</a> | <a>UpdateFleetCapacity</a> | <a>StopFleetActions</a> | <a>DeleteFleetLocations</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeFleetPortSettings' => '<p>Retrieves a fleet\'s inbound connection permissions. Connection permissions specify the range of IP addresses and port settings that incoming traffic can use to access server processes in the fleet. Game sessions that are running on instances in the fleet must use connections that fall in this range.</p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To retrieve the inbound connection permissions for a fleet, identify the fleet\'s unique identifier. </p> </li> <li> <p>To check the status of recent updates to a fleet remote location, specify the fleet ID and a location. Port setting updates can take time to propagate across all locations. </p> </li> </ul> <p>If successful, a set of <a>IpPermission</a> objects is returned for the requested fleet ID. When a location is specified, a pending status is included. If the requested fleet has been deleted, the result set is empty.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>ListFleets</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetEvents</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetPortSettings</a> | <a>DescribeFleetUtilization</a> | <a>DescribeRuntimeConfiguration</a> | <a>DescribeScalingPolicies</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeFleetUtilization' => '<p>Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet\'s hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for the fleet\'s home Region only. See <a>DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet\'s remote locations.</p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs. </p> </li> <li> <p>To get utilization data for all fleets, do not provide a fleet identifier. </p> </li> </ul> <p>When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a <a>FleetUtilization</a> object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization object includes a <code>Location</code> property, which is set to the fleet\'s home Region. </p> <note> <p>Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit, the request fails and the error message includes the maximum allowed.</p> </note> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift Fleets</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet">GameLift Metrics for Fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>ListFleets</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetEvents</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetPortSettings</a> | <a>DescribeFleetUtilization</a> | <a>DescribeRuntimeConfiguration</a> | <a>DescribeScalingPolicies</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeGameServer' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Retrieves information for a registered game server. Information includes game server status, health check info, and the instance that the game server is running on. </p> <p>To retrieve game server information, specify the game server ID. If successful, the requested game server object is returned. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>RegisterGameServer</a> | <a>ListGameServers</a> | <a>ClaimGameServer</a> | <a>DescribeGameServer</a> | <a>UpdateGameServer</a> | <a>DeregisterGameServer</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'DescribeGameServerGroup' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Retrieves information on a game server group. This operation returns only properties related to GameLift FleetIQ. To view or update properties for the corresponding Auto Scaling group, such as launch template, auto scaling policies, and maximum/minimum group size, access the Auto Scaling group directly.</p> <p>To get attributes for a game server group, provide a group name or ARN value. If successful, a <a>GameServerGroup</a> object is returned.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameServerGroup</a> | <a>ListGameServerGroups</a> | <a>DescribeGameServerGroup</a> | <a>UpdateGameServerGroup</a> | <a>DeleteGameServerGroup</a> | <a>ResumeGameServerGroup</a> | <a>SuspendGameServerGroup</a> | <a>DescribeGameServerInstances</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'DescribeGameServerInstances' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Retrieves status information about the Amazon EC2 instances associated with a GameLift FleetIQ game server group. Use this operation to detect when instances are active or not available to host new game servers. If you are looking for instance configuration information, call <a>DescribeGameServerGroup</a> or access the corresponding Auto Scaling group properties.</p> <p>To request status for all instances in the game server group, provide a game server group ID only. To request status for specific instances, provide the game server group ID and one or more instance IDs. Use the pagination parameters to retrieve results in sequential segments. If successful, a collection of <code>GameServerInstance</code> objects is returned. </p> <p>This operation is not designed to be called with every game server claim request; this practice can cause you to exceed your API limit, which results in errors. Instead, as a best practice, cache the results and refresh your cache no more than once every 10 seconds.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameServerGroup</a> | <a>ListGameServerGroups</a> | <a>DescribeGameServerGroup</a> | <a>UpdateGameServerGroup</a> | <a>DeleteGameServerGroup</a> | <a>ResumeGameServerGroup</a> | <a>SuspendGameServerGroup</a> | <a>DescribeGameServerInstances</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'DescribeGameSessionDetails' => '<p>Retrieves additional game session properties, including the game session protection policy in force, a set of one or more game sessions in a specific fleet location. You can optionally filter the results by current game session status. Alternatively, use <a>SearchGameSessions</a> to request a set of active game sessions that are filtered by certain criteria. To retrieve all game session properties, use <a>DescribeGameSessions</a>. </p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To retrieve details for all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID, with an optional status filter. This approach returns details from the fleet\'s home Region and all remote locations.</p> </li> <li> <p>To retrieve details for all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name, with optional status filter. The location can be the fleet\'s home Region or any remote location.</p> </li> <li> <p>To retrieve details for a specific game session, provide the game session ID. This approach looks for the game session ID in all fleets that reside in the Amazon Web Services Region defined in the request.</p> </li> </ul> <p>Use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a <code>GameSessionDetail</code> object is returned for each game session that matches the request.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find">Find a game session</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameSession</a> | <a>DescribeGameSessions</a> | <a>DescribeGameSessionDetails</a> | <a>SearchGameSessions</a> | <a>UpdateGameSession</a> | <a>GetGameSessionLogUrl</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeGameSessionPlacement' => '<p>Retrieves information, including current status, about a game session placement request. </p> <p>To get game session placement details, specify the placement ID.</p> <p>This operation is not designed to be continually called to track game session status. This practice can cause you to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with <code>DescribeGameSessionPlacement</code> should only be used for games in development with low game session usage. </p> <p>If successful, a <a>GameSessionPlacement</a> object is returned.</p> <p> <b>Related actions</b> </p> <p> <a>CreateGameSession</a> | <a>DescribeGameSessions</a> | <a>DescribeGameSessionDetails</a> | <a>SearchGameSessions</a> | <a>UpdateGameSession</a> | <a>GetGameSessionLogUrl</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeGameSessionQueues' => '<p>Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a <a>GameSessionQueue</a> object is returned for each requested queue. When specifying a list of queues, objects are returned only for queues that currently exist in the Region.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a> </p> <p> <b>Related actions</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">CreateGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html">DescribeGameSessionQueues</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html">UpdateGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html">DeleteGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeGameSessions' => '<p>Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results by current game session status. Alternatively, use <a>SearchGameSessions</a> to request a set of active game sessions that are filtered by certain criteria. To retrieve the protection policy for game sessions, use <a>DescribeGameSessionDetails</a>.</p> <p>This operation is not designed to be continually called to track game session status. This practice can cause you to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with <code>DescribeGameSessions</code> should only be used for games in development with low game session usage. </p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID, with an optional status filter. This approach returns all game sessions in the fleet\'s home Region and all remote locations.</p> </li> <li> <p>To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name, with optional status filter. The location can be the fleet\'s home Region or any remote location.</p> </li> <li> <p>To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in all fleets that reside in the Amazon Web Services Region defined in the request.</p> </li> </ul> <p>Use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a <code>GameSession</code> object is returned for each game session that matches the request.</p> <p>This operation is not designed to be continually called to track matchmaking ticket status. This practice can cause you to exceed your API limit, which results in errors. Instead, as a best practice, set up an Amazon Simple Notification Service to receive notifications, and provide the topic ARN in the matchmaking configuration. Continuously poling ticket status with <a>DescribeGameSessions</a> should only be used for games in development with low matchmaking usage.</p> <p> <i>Available in Amazon Web Services Local.</i> </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find">Find a game session</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameSession</a> | <a>DescribeGameSessions</a> | <a>DescribeGameSessionDetails</a> | <a>SearchGameSessions</a> | <a>UpdateGameSession</a> | <a>GetGameSessionLogUrl</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeInstances' => '<p>Retrieves information about a fleet\'s instances, including instance IDs, connection data, and status. </p> <p>This operation can be used in the following ways:</p> <ul> <li> <p>To get information on all instances that are deployed to a fleet\'s home Region, provide the fleet ID.</p> </li> <li> <p>To get information on all instances that are deployed to a fleet\'s remote location, provide the fleet ID and location name.</p> </li> <li> <p>To get information on a specific instance in a fleet, provide the fleet ID and instance ID.</p> </li> </ul> <p>Use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, an <code>Instance</code> object is returned for each requested instance. Instances are not returned in any particular order. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Access Fleet Instances</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug Fleet Issues</a> </p> <p> <b>Related actions</b> </p> <p> <a>DescribeInstances</a> | <a>GetInstanceAccess</a> | <a>DescribeEC2InstanceLimits</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeMatchmaking' => '<p>Retrieves one or more matchmaking tickets. Use this operation to retrieve ticket information, including--after a successful match is made--connection information for the resulting new game session. </p> <p>To request matchmaking tickets, provide a list of up to 10 ticket IDs. If the request is successful, a ticket object is returned for each requested ID that currently exists.</p> <p>This operation is not designed to be continually called to track matchmaking ticket status. This practice can cause you to exceed your API limit, which results in errors. Instead, as a best practice, set up an Amazon Simple Notification Service to receive notifications, and provide the topic ARN in the matchmaking configuration. Continuously poling ticket status with <a>DescribeMatchmaking</a> should only be used for games in development with low matchmaking usage.</p> <p/> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game client</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set Up FlexMatch event notification</a> </p> <p> <b>Related actions</b> </p> <p> <a>StartMatchmaking</a> | <a>DescribeMatchmaking</a> | <a>StopMatchmaking</a> | <a>AcceptMatch</a> | <a>StartMatchBackfill</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeMatchmakingConfigurations' => '<p>Retrieves the details of FlexMatch matchmaking configurations. </p> <p>This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a configuration is returned for each requested name. When specifying a list of names, only configurations that currently exist are returned. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch matchmakers</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateMatchmakingConfiguration</a> | <a>DescribeMatchmakingConfigurations</a> | <a>UpdateMatchmakingConfiguration</a> | <a>DeleteMatchmakingConfiguration</a> | <a>CreateMatchmakingRuleSet</a> | <a>DescribeMatchmakingRuleSets</a> | <a>ValidateMatchmakingRuleSet</a> | <a>DeleteMatchmakingRuleSet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeMatchmakingRuleSets' => '<p>Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region, or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name. </p> <p> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a> </p> </li> </ul> <p> <b>Related actions</b> </p> <p> <a>CreateMatchmakingConfiguration</a> | <a>DescribeMatchmakingConfigurations</a> | <a>UpdateMatchmakingConfiguration</a> | <a>DeleteMatchmakingConfiguration</a> | <a>CreateMatchmakingRuleSet</a> | <a>DescribeMatchmakingRuleSets</a> | <a>ValidateMatchmakingRuleSet</a> | <a>DeleteMatchmakingRuleSet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribePlayerSessions' => '<p>Retrieves properties for one or more player sessions. </p> <p>This action can be used in the following ways: </p> <ul> <li> <p>To retrieve a specific player session, provide the player session ID only.</p> </li> <li> <p>To retrieve all player sessions in a game session, provide the game session ID only.</p> </li> <li> <p>To retrieve all player sessions for a specific player, provide a player ID only.</p> </li> </ul> <p>To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter this request by player session status. Use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a <code>PlayerSession</code> object is returned for each session that matches the request.</p> <p> <i>Available in Amazon Web Services Local.</i> </p> <p> <b>Related actions</b> </p> <p> <a>CreatePlayerSession</a> | <a>CreatePlayerSessions</a> | <a>DescribePlayerSessions</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeRuntimeConfiguration' => '<p>Retrieves a fleet\'s runtime configuration settings. The runtime configuration tells GameLift which server processes to run (and how) on each instance in the fleet.</p> <p>To get the runtime configuration that is currently in forces for a fleet, provide the fleet ID. </p> <p>If successful, a <a>RuntimeConfiguration</a> object is returned for the requested fleet. If the requested fleet has been deleted, the result set is empty.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html">Running multiple processes on a fleet</a> </p> <p> <b>Related actions</b> </p> <p> <a>ListFleets</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetCapacity</a> | <a>DescribeFleetEvents</a> | <a>DescribeFleetLocationAttributes</a> | <a>DescribeFleetPortSettings</a> | <a>DescribeFleetUtilization</a> | <a>DescribeRuntimeConfiguration</a> | <a>DescribeScalingPolicies</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeScalingPolicies' => '<p>Retrieves all scaling policies applied to a fleet.</p> <p>To get a fleet\'s scaling policies, specify the fleet ID. You can filter this request by policy status, such as to retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential pages. If successful, set of <a>ScalingPolicy</a> objects is returned for the fleet.</p> <p>A fleet may have all of its scaling policies suspended (<a>StopFleetActions</a>). This operation does not affect the status of the scaling policies, which remains ACTIVE. To see whether a fleet\'s scaling policies are in force or suspended, call <a>DescribeFleetAttributes</a> and check the stopped actions.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeFleetCapacity</a> | <a>UpdateFleetCapacity</a> | <a>DescribeEC2InstanceLimits</a> | <a>PutScalingPolicy</a> | <a>DescribeScalingPolicies</a> | <a>DeleteScalingPolicy</a> | <a>StopFleetActions</a> | <a>StartFleetActions</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeScript' => '<p>Retrieves properties for a Realtime script. </p> <p>To request a script record, specify the script ID. If successful, an object containing the script properties is returned.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon Web Services Realtime Servers</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateScript</a> | <a>ListScripts</a> | <a>DescribeScript</a> | <a>UpdateScript</a> | <a>DeleteScript</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeVpcPeeringAuthorizations' => '<p>Retrieves valid VPC peering authorizations that are pending for the Amazon Web Services account. This operation returns all VPC peering authorizations and requests for peering. This includes those initiated and received by this account. </p> <p> <b>Related actions</b> </p> <p> <a>CreateVpcPeeringAuthorization</a> | <a>DescribeVpcPeeringAuthorizations</a> | <a>DeleteVpcPeeringAuthorization</a> | <a>CreateVpcPeeringConnection</a> | <a>DescribeVpcPeeringConnections</a> | <a>DeleteVpcPeeringConnection</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'DescribeVpcPeeringConnections' => '<p>Retrieves information on VPC peering connections. Use this operation to get peering information for all fleets or for one specific fleet ID. </p> <p>To retrieve connection information, call this operation from the Amazon Web Services account that is used to manage the Amazon Web Services fleets. Specify a fleet ID or leave the parameter empty to retrieve all connection records. If successful, the retrieved information includes both active and pending connections. Active connections identify the IpV4 CIDR block that the VPC uses to connect. </p> <p> <b>Related actions</b> </p> <p> <a>CreateVpcPeeringAuthorization</a> | <a>DescribeVpcPeeringAuthorizations</a> | <a>DeleteVpcPeeringAuthorization</a> | <a>CreateVpcPeeringConnection</a> | <a>DescribeVpcPeeringConnections</a> | <a>DeleteVpcPeeringConnection</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'GetGameSessionLogUrl' => '<p>Retrieves the location of stored game session logs for a specified game session. When a game session is terminated, GameLift automatically stores the logs in Amazon S3 and retains them for 14 days. Use this URL to download the logs.</p> <note> <p>See the <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift">Amazon Web Services Service Limits</a> page for maximum log file sizes. Log files that exceed this limit are not saved.</p> </note> <p> <b>Related actions</b> </p> <p> <a>CreateGameSession</a> | <a>DescribeGameSessions</a> | <a>DescribeGameSessionDetails</a> | <a>SearchGameSessions</a> | <a>UpdateGameSession</a> | <a>GetGameSessionLogUrl</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'GetInstanceAccess' => '<p>Requests remote access to a fleet instance. Remote access is useful for debugging, gathering benchmarking data, or observing activity in real time. </p> <p>To remotely access an instance, you need credentials that match the operating system of the instance. For a Windows instance, GameLift returns a user name and password as strings for use with a Windows Remote Desktop client. For a Linux instance, GameLift returns a user name and RSA private key, also as strings, for use with an SSH client. The private key must be saved in the proper format to a <code>.pem</code> file before using. If you\'re making this request using the CLI, saving the secret can be handled as part of the <code>GetInstanceAccess</code> request, as shown in one of the examples for this operation. </p> <p>To request access to a specific instance, specify the IDs of both the instance and the fleet it belongs to. You can retrieve a fleet\'s instance IDs by calling <a>DescribeInstances</a>. If successful, an <a>InstanceAccess</a> object is returned that contains the instance\'s IP address and a set of credentials.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely Access Fleet Instances</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug Fleet Issues</a> </p> <p> <b>Related actions</b> </p> <p> <a>DescribeInstances</a> | <a>GetInstanceAccess</a> | <a>DescribeEC2InstanceLimits</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'ListAliases' => '<p>Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or routing strategy type. Use the pagination parameters to retrieve results in sequential pages.</p> <note> <p>Returned aliases are not listed in any particular order.</p> </note> <p> <b>Related actions</b> </p> <p> <a>CreateAlias</a> | <a>ListAliases</a> | <a>DescribeAlias</a> | <a>UpdateAlias</a> | <a>DeleteAlias</a> | <a>ResolveAlias</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'ListBuilds' => '<p>Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination parameters to retrieve results in a set of sequential pages. </p> <note> <p>Build resources are not listed in any particular order.</p> </note> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom Server Build</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateBuild</a> | <a>ListBuilds</a> | <a>DescribeBuild</a> | <a>UpdateBuild</a> | <a>DeleteBuild</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'ListFleets' => '<p>Retrieves a collection of fleet resources in an Amazon Web Services Region. You can call this operation to get fleets in a previously selected default Region (see <a href="https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html">https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html</a>or specify a Region in your request. You can filter the result set to find only those fleets that are deployed with a specific build or script. For fleets that have multiple locations, this operation retrieves fleets based on their home Region only.</p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To get a list of all fleets in a Region, don\'t provide a build or script identifier. </p> </li> <li> <p>To get a list of all fleets where a specific custom game build is deployed, provide the build ID.</p> </li> <li> <p>To get a list of all Realtime Servers fleets with a specific configuration script, provide the script ID. </p> </li> </ul> <p>Use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a list of fleet IDs that match the request parameters is returned. A NextToken value is also returned if there are more result pages to retrieve.</p> <note> <p>Fleet resources are not listed in a particular order.</p> </note> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleet</a> | <a>UpdateFleetCapacity</a> | <a>PutScalingPolicy</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetLocationAttributes</a> | <a>UpdateFleetAttributes</a> | <a>StopFleetActions</a> | <a>DeleteFleet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'ListGameServerGroups' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Retrieves information on all game servers groups that exist in the current Amazon Web Services account for the selected Region. Use the pagination parameters to retrieve results in a set of sequential segments. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameServerGroup</a> | <a>ListGameServerGroups</a> | <a>DescribeGameServerGroup</a> | <a>UpdateGameServerGroup</a> | <a>DeleteGameServerGroup</a> | <a>ResumeGameServerGroup</a> | <a>SuspendGameServerGroup</a> | <a>DescribeGameServerInstances</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'ListGameServers' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Retrieves information on all game servers that are currently active in a specified game server group. You can opt to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential segments. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>RegisterGameServer</a> | <a>ListGameServers</a> | <a>ClaimGameServer</a> | <a>DescribeGameServer</a> | <a>UpdateGameServer</a> | <a>DeregisterGameServer</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'ListScripts' => '<p>Retrieves script records for all Realtime scripts that are associated with the Amazon Web Services account in use. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon Web Services Realtime Servers</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateScript</a> | <a>ListScripts</a> | <a>DescribeScript</a> | <a>UpdateScript</a> | <a>DeleteScript</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'ListTagsForResource' => '<p> Retrieves all tags that are assigned to a GameLift resource. Resource tags are used to organize Amazon Web Services resources for a range of purposes. This operation handles the permissions necessary to manage tags for the following GameLift resource types:</p> <ul> <li> <p>Build</p> </li> <li> <p>Script</p> </li> <li> <p>Fleet</p> </li> <li> <p>Alias</p> </li> <li> <p>GameSessionQueue</p> </li> <li> <p>MatchmakingConfiguration</p> </li> <li> <p>MatchmakingRuleSet</p> </li> </ul> <p>To list tags for a resource, specify the unique ARN value for the resource.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i> </p> <p> <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging Strategies</a> </p> <p> <b>Related actions</b> </p> <p> <a>TagResource</a> | <a>UntagResource</a> | <a>ListTagsForResource</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'PutScalingPolicy' => '<p>Creates or updates a scaling policy for a fleet. Scaling policies are used to automatically scale a fleet\'s hosting capacity to meet player demand. An active scaling policy instructs Amazon Web Services to track a fleet metric and automatically change the fleet\'s capacity when a certain threshold is reached. There are two types of scaling policies: target-based and rule-based. Use a target-based policy to quickly and efficiently manage fleet scaling; this option is the most commonly used. Use rule-based policies when you need to exert fine-grained control over auto-scaling. </p> <p>Fleets can have multiple scaling policies of each type in force at the same time; you can have one target-based policy, one or multiple rule-based scaling policies, or both. We recommend caution, however, because multiple auto-scaling policies can have unintended consequences.</p> <p>You can temporarily suspend all scaling policies for a fleet by calling <a>StopFleetActions</a> with the fleet action AUTO_SCALING. To resume scaling policies, call <a>StartFleetActions</a> with the same fleet action. To stop just one scaling policy--or to permanently remove it, you must delete the policy with <a>DeleteScalingPolicy</a>.</p> <p>Learn more about how to work with auto-scaling in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-autoscaling.html">Set Up Fleet Automatic Scaling</a>.</p> <p> <b>Target-based policy</b> </p> <p>A target-based policy tracks a single metric: PercentAvailableGameSessions. This metric tells us how much of a fleet\'s hosting capacity is ready to host game sessions but is not currently in use. This is the fleet\'s buffer; it measures the additional player demand that the fleet could handle at current capacity. With a target-based policy, you set your ideal buffer size and leave it to Amazon Web Services to take whatever action is needed to maintain that target. </p> <p>For example, you might choose to maintain a 10% buffer for a fleet that has the capacity to host 100 simultaneous game sessions. This policy tells Amazon Web Services to take action whenever the fleet\'s available capacity falls below or rises above 10 game sessions. Amazon Web Services will start new instances or stop unused instances in order to return to the 10% buffer. </p> <p>To create or update a target-based policy, specify a fleet ID and name, and set the policy type to "TargetBased". Specify the metric to track (PercentAvailableGameSessions) and reference a <a>TargetConfiguration</a> object with your desired buffer value. Exclude all other parameters. On a successful request, the policy name is returned. The scaling policy is automatically in force as soon as it\'s successfully created. If the fleet\'s auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are restarted.</p> <p> <b>Rule-based policy</b> </p> <p>A rule-based policy tracks specified fleet metric, sets a threshold value, and specifies the type of action to initiate when triggered. With a rule-based policy, you can select from several available fleet metrics. Each policy specifies whether to scale up or scale down (and by how much), so you need one policy for each type of action. </p> <p>For example, a policy may make the following statement: "If the percentage of idle instances is greater than 20% for more than 15 minutes, then reduce the fleet capacity by 10%."</p> <p>A policy\'s rule statement has the following structure:</p> <p>If <code>[MetricName]</code> is <code>[ComparisonOperator]</code> <code>[Threshold]</code> for <code>[EvaluationPeriods]</code> minutes, then <code>[ScalingAdjustmentType]</code> to/by <code>[ScalingAdjustment]</code>.</p> <p>To implement the example, the rule statement would look like this:</p> <p>If <code>[PercentIdleInstances]</code> is <code>[GreaterThanThreshold]</code> <code>[20]</code> for <code>[15]</code> minutes, then <code>[PercentChangeInCapacity]</code> to/by <code>[10]</code>.</p> <p>To create or update a scaling policy, specify a unique combination of name and fleet ID, and set the policy type to "RuleBased". Specify the parameter values for a policy rule statement. On a successful request, the policy name is returned. Scaling policies are automatically in force as soon as they\'re successfully created. If the fleet\'s auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are restarted.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeFleetCapacity</a> | <a>UpdateFleetCapacity</a> | <a>DescribeEC2InstanceLimits</a> | <a>PutScalingPolicy</a> | <a>DescribeScalingPolicies</a> | <a>DeleteScalingPolicy</a> | <a>StopFleetActions</a> | <a>StartFleetActions</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'RegisterGameServer' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Creates a new game server resource and notifies GameLift FleetIQ that the game server is ready to host gameplay and players. This operation is called by a game server process that is running on an instance in a game server group. Registering game servers enables GameLift FleetIQ to track available game servers and enables game clients and services to claim a game server for a new game session. </p> <p>To register a game server, identify the game server group and instance where the game server is running, and provide a unique identifier for the game server. You can also include connection and game server data. When a game client or service requests a game server by calling <a>ClaimGameServer</a>, this information is returned in the response.</p> <p>Once a game server is successfully registered, it is put in status <code>AVAILABLE</code>. A request to register a game server may fail if the instance it is running on is in the process of shutting down as part of instance balancing or scale-down activity. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>RegisterGameServer</a> | <a>ListGameServers</a> | <a>ClaimGameServer</a> | <a>DescribeGameServer</a> | <a>UpdateGameServer</a> | <a>DeregisterGameServer</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'RequestUploadCredentials' => '<p>Retrieves a fresh set of credentials for use when uploading a new set of game build files to Amazon Web Services\'s Amazon S3. This is done as part of the build creation process; see <a>CreateBuild</a>.</p> <p>To request new credentials, specify the build ID as returned with an initial <code>CreateBuild</code> request. If successful, a new set of credentials are returned, along with the S3 storage location associated with the build ID.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"> Create a Build with Files in S3</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateBuild</a> | <a>ListBuilds</a> | <a>DescribeBuild</a> | <a>UpdateBuild</a> | <a>DeleteBuild</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'ResolveAlias' => '<p>Retrieves the fleet ID that an alias is currently pointing to.</p> <p> <b>Related actions</b> </p> <p> <a>CreateAlias</a> | <a>ListAliases</a> | <a>DescribeAlias</a> | <a>UpdateAlias</a> | <a>DeleteAlias</a> | <a>ResolveAlias</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'ResumeGameServerGroup' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Reinstates activity on a game server group after it has been suspended. A game server group might be suspended by the<a>SuspendGameServerGroup</a> operation, or it might be suspended involuntarily due to a configuration problem. In the second case, you can manually resume activity on the group once the configuration problem has been resolved. Refer to the game server group status and status reason for more information on why group activity is suspended.</p> <p>To resume activity, specify a game server group ARN and the type of activity to be resumed. If successful, a <a>GameServerGroup</a> object is returned showing that the resumed activity is no longer listed in <code>SuspendedActions</code>. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameServerGroup</a> | <a>ListGameServerGroups</a> | <a>DescribeGameServerGroup</a> | <a>UpdateGameServerGroup</a> | <a>DeleteGameServerGroup</a> | <a>ResumeGameServerGroup</a> | <a>SuspendGameServerGroup</a> | <a>DescribeGameServerInstances</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'SearchGameSessions' => '<p>Retrieves all active game sessions that match a set of search criteria and sorts them into a specified order. </p> <p>This operation is not designed to be continually called to track game session status. This practice can cause you to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling game session status with <code>DescribeGameSessions</code> should only be used for games in development with low game session usage. </p> <p>When searching for game sessions, you specify exactly where you want to search and provide a search filter expression, a sort expression, or both. A search request can search only one fleet, but it can search all of a fleet\'s locations. </p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To search all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID. This approach returns game sessions in the fleet\'s home Region and all remote locations that fit the search criteria.</p> </li> <li> <p>To search all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name. For location, you can specify a fleet\'s home Region or any remote location.</p> </li> </ul> <p>Use the pagination parameters to retrieve results as a set of sequential pages. </p> <p>If successful, a <code>GameSession</code> object is returned for each game session that matches the request. Search finds game sessions that are in <code>ACTIVE</code> status only. To retrieve information on game sessions in other statuses, use <a>DescribeGameSessions</a>.</p> <p>You can search or sort by the following game session attributes:</p> <ul> <li> <p> <b>gameSessionId</b> -- A unique identifier for the game session. You can use either a <code>GameSessionId</code> or <code>GameSessionArn</code> value. </p> </li> <li> <p> <b>gameSessionName</b> -- Name assigned to a game session. This value is set when requesting a new game session with <a>CreateGameSession</a> or updating with <a>UpdateGameSession</a>. Game session names do not need to be unique to a game session.</p> </li> <li> <p> <b>gameSessionProperties</b> -- Custom data defined in a game session\'s <code>GameProperty</code> parameter. <code>GameProperty</code> values are stored as key:value pairs; the filter expression must indicate the key and a string to search the data values for. For example, to search for game sessions with custom data containing the key:value pair "gameMode:brawl", specify the following: <code>gameSessionProperties.gameMode = "brawl"</code>. All custom data values are searched as strings.</p> </li> <li> <p> <b>maximumSessions</b> -- Maximum number of player sessions allowed for a game session. This value is set when requesting a new game session with <a>CreateGameSession</a> or updating with <a>UpdateGameSession</a>.</p> </li> <li> <p> <b>creationTimeMillis</b> -- Value indicating when a game session was created. It is expressed in Unix time as milliseconds.</p> </li> <li> <p> <b>playerSessionCount</b> -- Number of players currently connected to a game session. This value changes rapidly as players join the session or drop out.</p> </li> <li> <p> <b>hasAvailablePlayerSessions</b> -- Boolean value indicating whether a game session has reached its maximum number of players. It is highly recommended that all search requests include this filter attribute to optimize search performance and return only sessions that players can join. </p> </li> </ul> <note> <p>Returned values for <code>playerSessionCount</code> and <code>hasAvailablePlayerSessions</code> change quickly as players join sessions and others drop out. Results should be considered a snapshot in time. Be sure to refresh search results often, and handle sessions that fill up before a player can join. </p> </note> <p> <b>Related actions</b> </p> <p> <a>CreateGameSession</a> | <a>DescribeGameSessions</a> | <a>DescribeGameSessionDetails</a> | <a>SearchGameSessions</a> | <a>UpdateGameSession</a> | <a>GetGameSessionLogUrl</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'StartFleetActions' => '<p>Resumes certain types of activity on fleet instances that were suspended with <a>StopFleetActions</a>. For multi-location fleets, fleet actions are managed separately for each location. Currently, this operation is used to restart a fleet\'s auto-scaling activity.</p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To restart actions on instances in the fleet\'s home Region, provide a fleet ID and the type of actions to resume. </p> </li> <li> <p>To restart actions on instances in one of the fleet\'s remote locations, provide a fleet ID, a location name, and the type of actions to resume. </p> </li> </ul> <p>If successful, GameLift once again initiates scaling events as triggered by the fleet\'s scaling policies. If actions on the fleet location were never stopped, this operation will have no effect. You can view a fleet\'s stopped actions using <a>DescribeFleetAttributes</a> or <a>DescribeFleetLocationAttributes</a>.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleet</a> | <a>UpdateFleetCapacity</a> | <a>PutScalingPolicy</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetLocationAttributes</a> | <a>UpdateFleetAttributes</a> | <a>StopFleetActions</a> | <a>DeleteFleet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'StartGameSessionPlacement' => '<p>Places a request for a new game session in a queue (see <a>CreateGameSessionQueue</a>). When processing a placement request, Amazon Web Services searches for available resources on the queue\'s destinations, scanning each until it finds resources or the placement request times out.</p> <p>A game session placement request can also request player sessions. When a new game session is successfully created, Amazon Web Services creates a player session for each player included in the request.</p> <p>When placing a game session, by default Amazon Web Services tries each fleet in the order they are listed in the queue configuration. Ideally, a queue\'s destinations are listed in preference order.</p> <p>Alternatively, when requesting a game session with players, you can also provide latency data for each player in relevant Regions. Latency data indicates the performance lag a player experiences when connected to a fleet in the Region. Amazon Web Services uses latency data to reorder the list of destinations to place the game session in a Region with minimal lag. If latency data is provided for multiple players, Amazon Web Services calculates each Region\'s average lag for all players and reorders to get the best game play across all players. </p> <p>To place a new game session request, specify the following:</p> <ul> <li> <p>The queue name and a set of game session properties and settings</p> </li> <li> <p>A unique ID (such as a UUID) for the placement. You use this ID to track the status of the placement request</p> </li> <li> <p>(Optional) A set of player data and a unique player ID for each player that you are joining to the new game session (player data is optional, but if you include it, you must also provide a unique ID for each player)</p> </li> <li> <p>Latency data for all players (if you want to optimize game play for the players)</p> </li> </ul> <p>If successful, a new game session placement is created.</p> <p>To track the status of a placement request, call <a>DescribeGameSessionPlacement</a> and check the request\'s status. If the status is <code>FULFILLED</code>, a new game session has been created and a game session ARN and Region are referenced. If the placement request times out, you can resubmit the request or retry it with a different queue. </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameSession</a> | <a>DescribeGameSessions</a> | <a>DescribeGameSessionDetails</a> | <a>SearchGameSessions</a> | <a>UpdateGameSession</a> | <a>GetGameSessionLogUrl</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'StartMatchBackfill' => '<p>Finds new players to fill open slots in currently running game sessions. The backfill match process is essentially identical to the process of forming new matches. Backfill requests use the same matchmaker that was used to make the original match, and they provide matchmaking data for all players currently in the game session. FlexMatch uses this information to select new players so that backfilled match continues to meet the original match requirements. </p> <p>When using FlexMatch with GameLift managed hosting, you can request a backfill match from a client service by calling this operation with a <a>GameSession</a> identifier. You also have the option of making backfill requests directly from your game server. In response to a request, FlexMatch creates player sessions for the new players, updates the <code>GameSession</code> resource, and sends updated matchmaking data to the game server. You can request a backfill match at any point after a game session is started. Each game session can have only one active backfill request at a time; a subsequent request automatically replaces the earlier request.</p> <p>When using FlexMatch as a standalone component, request a backfill match by calling this operation without a game session identifier. As with newly formed matches, matchmaking results are returned in a matchmaking event so that your game can update the game session that is being backfilled.</p> <p>To request a backfill match, specify a unique ticket ID, the original matchmaking configuration, and matchmaking data for all current players in the game session being backfilled. Optionally, specify the <code>GameSession</code> ARN. If successful, a match backfill ticket is created and returned with status set to QUEUED. Track the status of backfill tickets using the same method for tracking tickets for new matches.</p> <p>Only game sessions created by FlexMatch are supported for match backfill.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill existing games with FlexMatch</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html"> Matchmaking events</a> (reference)</p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html"> How GameLift FlexMatch works</a> </p> <p> <b>Related actions</b> </p> <p> <a>StartMatchmaking</a> | <a>DescribeMatchmaking</a> | <a>StopMatchmaking</a> | <a>AcceptMatch</a> | <a>StartMatchBackfill</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'StartMatchmaking' => '<p>Uses FlexMatch to create a game match for a group of players based on custom matchmaking rules. With games that use GameLift managed hosting, this operation also triggers GameLift to find hosting resources and start a new game session for the new match. Each matchmaking request includes information on one or more players and specifies the FlexMatch matchmaker to use. When a request is for multiple players, FlexMatch attempts to build a match that includes all players in the request, placing them in the same team and finding additional players as needed to fill the match. </p> <p>To start matchmaking, provide a unique ticket ID, specify a matchmaking configuration, and include the players to be matched. You must also include any player attributes that are required by the matchmaking configuration\'s rule set. If successful, a matchmaking ticket is returned with status set to <code>QUEUED</code>. </p> <p>Track matchmaking events to respond as needed and acquire game session connection information for successfully completed matches. Ticket status updates are tracked using event notification through Amazon Simple Notification Service, which is defined in the matchmaking configuration.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game client</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set Up FlexMatch event notification</a> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html"> How GameLift FlexMatch works</a> </p> <p> <b>Related actions</b> </p> <p> <a>StartMatchmaking</a> | <a>DescribeMatchmaking</a> | <a>StopMatchmaking</a> | <a>AcceptMatch</a> | <a>StartMatchBackfill</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'StopFleetActions' => '<p>Suspends certain types of activity in a fleet location. Currently, this operation is used to stop auto-scaling activity. For multi-location fleets, fleet actions are managed separately for each location. </p> <p>Stopping fleet actions has several potential purposes. It allows you to temporarily stop auto-scaling activity but retain your scaling policies for use in the future. For multi-location fleets, you can set up fleet-wide auto-scaling, and then opt out of it for certain locations. </p> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To stop actions on instances in the fleet\'s home Region, provide a fleet ID and the type of actions to suspend. </p> </li> <li> <p>To stop actions on instances in one of the fleet\'s remote locations, provide a fleet ID, a location name, and the type of actions to suspend. </p> </li> </ul> <p>If successful, GameLift no longer initiates scaling events except in response to manual changes using <a>UpdateFleetCapacity</a>. You can view a fleet\'s stopped actions using <a>DescribeFleetAttributes</a> or <a>DescribeFleetLocationAttributes</a>. Suspended activity can be restarted using <a>StartFleetActions</a>.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift Fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleet</a> | <a>UpdateFleetCapacity</a> | <a>PutScalingPolicy</a> | <a>DescribeEC2InstanceLimits</a> | <a>DescribeFleetAttributes</a> | <a>DescribeFleetLocationAttributes</a> | <a>UpdateFleetAttributes</a> | <a>StopFleetActions</a> | <a>DeleteFleet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'StopGameSessionPlacement' => '<p>Cancels a game session placement that is in <code>PENDING</code> status. To stop a placement, provide the placement ID values. If successful, the placement is moved to <code>CANCELLED</code> status.</p> <p> <b>Related actions</b> </p> <p> <a>CreateGameSession</a> | <a>DescribeGameSessions</a> | <a>DescribeGameSessionDetails</a> | <a>SearchGameSessions</a> | <a>UpdateGameSession</a> | <a>GetGameSessionLogUrl</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'StopMatchmaking' => '<p>Cancels a matchmaking ticket or match backfill ticket that is currently being processed. To stop the matchmaking operation, specify the ticket ID. If successful, work on the ticket is stopped, and the ticket status is changed to <code>CANCELLED</code>.</p> <p>This call is also used to turn off automatic backfill for an individual game session. This is for game sessions that are created with a matchmaking configuration that has automatic backfill enabled. The ticket ID is included in the <code>MatchmakerData</code> of an updated game session object, which is provided to the game server.</p> <note> <p>If the operation is successful, the service sends back an empty JSON struct with the HTTP 200 response (not an empty HTTP body).</p> </note> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game client</a> </p> <p> <b>Related actions</b> </p> <p> <a>StartMatchmaking</a> | <a>DescribeMatchmaking</a> | <a>StopMatchmaking</a> | <a>AcceptMatch</a> | <a>StartMatchBackfill</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'SuspendGameServerGroup' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Temporarily stops activity on a game server group without terminating instances or the game server group. You can restart activity by calling <a>ResumeGameServerGroup</a>. You can suspend the following activity:</p> <ul> <li> <p> <b>Instance type replacement</b> - This activity evaluates the current game hosting viability of all Spot instance types that are defined for the game server group. It updates the Auto Scaling group to remove nonviable Spot Instance types, which have a higher chance of game server interruptions. It then balances capacity across the remaining viable Spot Instance types. When this activity is suspended, the Auto Scaling group continues with its current balance, regardless of viability. Instance protection, utilization metrics, and capacity scaling activities continue to be active. </p> </li> </ul> <p>To suspend activity, specify a game server group ARN and the type of activity to be suspended. If successful, a <a>GameServerGroup</a> object is returned showing that the activity is listed in <code>SuspendedActions</code>.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameServerGroup</a> | <a>ListGameServerGroups</a> | <a>DescribeGameServerGroup</a> | <a>UpdateGameServerGroup</a> | <a>DeleteGameServerGroup</a> | <a>ResumeGameServerGroup</a> | <a>SuspendGameServerGroup</a> | <a>DescribeGameServerInstances</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'TagResource' => '<p> Assigns a tag to a GameLift resource. Amazon Web Services resource tags provide an additional management tool set. You can use tags to organize resources, create IAM permissions policies to manage access to groups of resources, customize Amazon Web Services cost breakdowns, etc. This operation handles the permissions necessary to manage tags for the following GameLift resource types:</p> <ul> <li> <p>Build</p> </li> <li> <p>Script</p> </li> <li> <p>Fleet</p> </li> <li> <p>Alias</p> </li> <li> <p>GameSessionQueue</p> </li> <li> <p>MatchmakingConfiguration</p> </li> <li> <p>MatchmakingRuleSet</p> </li> </ul> <p>To add a tag to a resource, specify the unique ARN value for the resource and provide a tag list containing one or more tags. The operation succeeds even if the list includes tags that are already assigned to the specified resource. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i> </p> <p> <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging Strategies</a> </p> <p> <b>Related actions</b> </p> <p> <a>TagResource</a> | <a>UntagResource</a> | <a>ListTagsForResource</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UntagResource' => '<p>Removes a tag that is assigned to a GameLift resource. Resource tags are used to organize Amazon Web Services resources for a range of purposes. This operation handles the permissions necessary to manage tags for the following GameLift resource types:</p> <ul> <li> <p>Build</p> </li> <li> <p>Script</p> </li> <li> <p>Fleet</p> </li> <li> <p>Alias</p> </li> <li> <p>GameSessionQueue</p> </li> <li> <p>MatchmakingConfiguration</p> </li> <li> <p>MatchmakingRuleSet</p> </li> </ul> <p>To remove a tag from a resource, specify the unique ARN value for the resource and provide a string list containing one or more tags to be removed. This operation succeeds even if the list includes tags that are not currently assigned to the specified resource.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i> </p> <p> <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging Strategies</a> </p> <p> <b>Related actions</b> </p> <p> <a>TagResource</a> | <a>UntagResource</a> | <a>ListTagsForResource</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UpdateAlias' => '<p>Updates properties for an alias. To update properties, specify the alias ID to be updated and provide the information to be changed. To reassign an alias to another fleet, provide an updated routing strategy. If successful, the updated alias record is returned.</p> <p> <b>Related actions</b> </p> <p> <a>CreateAlias</a> | <a>ListAliases</a> | <a>DescribeAlias</a> | <a>UpdateAlias</a> | <a>DeleteAlias</a> | <a>ResolveAlias</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UpdateBuild' => '<p>Updates metadata in a build resource, including the build name and version. To update the metadata, specify the build ID to update and provide the new values. If successful, a build object containing the updated metadata is returned.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom Server Build</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateBuild</a> | <a>ListBuilds</a> | <a>DescribeBuild</a> | <a>UpdateBuild</a> | <a>DeleteBuild</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UpdateFleetAttributes' => '<p>Updates a fleet\'s mutable attributes, including game session protection and resource creation limits.</p> <p>To update fleet attributes, specify the fleet ID and the property values that you want to change. </p> <p>If successful, an updated <code>FleetAttributes</code> object is returned.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleetLocations</a> | <a>UpdateFleetAttributes</a> | <a>UpdateFleetCapacity</a> | <a>UpdateFleetPortSettings</a> | <a>UpdateRuntimeConfiguration</a> | <a>StopFleetActions</a> | <a>StartFleetActions</a> | <a>PutScalingPolicy</a> | <a>DeleteFleet</a> | <a>DeleteFleetLocations</a> | <a>DeleteScalingPolicy</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UpdateFleetCapacity' => '<p>Updates capacity settings for a fleet. For fleets with multiple locations, use this operation to manage capacity settings in each location individually. Fleet capacity determines the number of game sessions and players that can be hosted based on the fleet configuration. Use this operation to set the following fleet capacity properties: </p> <ul> <li> <p>Minimum/maximum size: Set hard limits on fleet capacity. GameLift cannot set the fleet\'s capacity to a value outside of this range, whether the capacity is changed manually or through automatic scaling. </p> </li> <li> <p>Desired capacity: Manually set the number of Amazon EC2 instances to be maintained in a fleet location. Before changing a fleet\'s desired capacity, you may want to call <a>DescribeEC2InstanceLimits</a> to get the maximum capacity of the fleet\'s Amazon EC2 instance type. Alternatively, consider using automatic scaling to adjust capacity based on player demand.</p> </li> </ul> <p>This operation can be used in the following ways: </p> <ul> <li> <p>To update capacity for a fleet\'s home Region, or if the fleet has no remote locations, omit the <code>Location</code> parameter. The fleet must be in <code>ACTIVE</code> status. </p> </li> <li> <p>To update capacity for a fleet\'s remote location, include the <code>Location</code> parameter set to the location to be updated. The location must be in <code>ACTIVE</code> status.</p> </li> </ul> <p>If successful, capacity settings are updated immediately. In response a change in desired capacity, GameLift initiates steps to start new instances or terminate existing instances in the requested fleet location. This continues until the location\'s active instance count matches the new desired instance count. You can track a fleet\'s current capacity by calling <a>DescribeFleetCapacity</a> or <a>DescribeFleetLocationCapacity</a>. If the requested desired instance count is higher than the instance type\'s limit, the <code>LimitExceeded</code> exception occurs.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-manage-capacity.html">Scaling fleet capacity</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleetLocations</a> | <a>UpdateFleetAttributes</a> | <a>UpdateFleetCapacity</a> | <a>UpdateFleetPortSettings</a> | <a>UpdateRuntimeConfiguration</a> | <a>StopFleetActions</a> | <a>StartFleetActions</a> | <a>PutScalingPolicy</a> | <a>DeleteFleet</a> | <a>DeleteFleetLocations</a> | <a>DeleteScalingPolicy</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UpdateFleetPortSettings' => '<p>Updates permissions that allow inbound traffic to connect to game sessions that are being hosted on instances in the fleet. </p> <p>To update settings, specify the fleet ID to be updated and specify the changes to be made. List the permissions you want to add in <code>InboundPermissionAuthorizations</code>, and permissions you want to remove in <code>InboundPermissionRevocations</code>. Permissions to be removed must match existing fleet permissions. </p> <p>If successful, the fleet ID for the updated fleet is returned. For fleets with remote locations, port setting updates can take time to propagate across all locations. You can check the status of updates in each location by calling <code>DescribeFleetPortSettings</code> with a location name.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleetLocations</a> | <a>UpdateFleetAttributes</a> | <a>UpdateFleetCapacity</a> | <a>UpdateFleetPortSettings</a> | <a>UpdateRuntimeConfiguration</a> | <a>StopFleetActions</a> | <a>StartFleetActions</a> | <a>PutScalingPolicy</a> | <a>DeleteFleet</a> | <a>DeleteFleetLocations</a> | <a>DeleteScalingPolicy</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UpdateGameServer' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Updates information about a registered game server to help GameLift FleetIQ to track game server availability. This operation is called by a game server process that is running on an instance in a game server group. </p> <p>Use this operation to update the following types of game server information. You can make all three types of updates in the same request:</p> <ul> <li> <p>To update the game server\'s utilization status, identify the game server and game server group and specify the current utilization status. Use this status to identify when game servers are currently hosting games and when they are available to be claimed.</p> </li> <li> <p>To report health status, identify the game server and game server group and set health check to <code>HEALTHY</code>. If a game server does not report health status for a certain length of time, the game server is no longer considered healthy. As a result, it will be eventually deregistered from the game server group to avoid affecting utilization metrics. The best practice is to report health every 60 seconds.</p> </li> <li> <p>To change game server metadata, provide updated game server data.</p> </li> </ul> <p>Once a game server is successfully updated, the relevant statuses and timestamps are updated.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>RegisterGameServer</a> | <a>ListGameServers</a> | <a>ClaimGameServer</a> | <a>DescribeGameServer</a> | <a>UpdateGameServer</a> | <a>DeregisterGameServer</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'UpdateGameServerGroup' => '<p> <b>This operation is used with the GameLift FleetIQ solution and game server groups.</b> </p> <p>Updates GameLift FleetIQ-specific properties for a game server group. Many Auto Scaling group properties are updated on the Auto Scaling group directly, including the launch template, Auto Scaling policies, and maximum/minimum/desired instance counts.</p> <p>To update the game server group, specify the game server group ID and provide the updated values. Before applying the updates, the new values are validated to ensure that GameLift FleetIQ can continue to perform instance balancing activity. If successful, a <a>GameServerGroup</a> object is returned.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">GameLift FleetIQ Guide</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameServerGroup</a> | <a>ListGameServerGroups</a> | <a>DescribeGameServerGroup</a> | <a>UpdateGameServerGroup</a> | <a>DeleteGameServerGroup</a> | <a>ResumeGameServerGroup</a> | <a>SuspendGameServerGroup</a> | <a>DescribeGameServerInstances</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'UpdateGameSession' => '<p>Updates the mutable properties of a game session. </p> <p>To update a game session, specify the game session ID and the values you want to change. </p> <p>If successful, the updated <code>GameSession</code> object is returned. </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameSession</a> | <a>DescribeGameSessions</a> | <a>DescribeGameSessionDetails</a> | <a>SearchGameSessions</a> | <a>UpdateGameSession</a> | <a>GetGameSessionLogUrl</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UpdateGameSessionQueue' => '<p>Updates the configuration of a game session queue, which determines how the queue processes new game session requests. To update settings, specify the queue name to be updated and provide the new settings. When updating destinations, provide a complete list of destinations. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html"> Using Multi-Region Queues</a> </p> <p> <b>Related actions</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">CreateGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html">DescribeGameSessionQueues</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html">UpdateGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html">DeleteGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UpdateMatchmakingConfiguration' => '<p>Updates settings for a FlexMatch matchmaking configuration. These changes affect all matches and game sessions that are created after the update. To update settings, specify the configuration name to be updated and provide the new settings. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html"> Design a FlexMatch matchmaker</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateMatchmakingConfiguration</a> | <a>DescribeMatchmakingConfigurations</a> | <a>UpdateMatchmakingConfiguration</a> | <a>DeleteMatchmakingConfiguration</a> | <a>CreateMatchmakingRuleSet</a> | <a>DescribeMatchmakingRuleSets</a> | <a>ValidateMatchmakingRuleSet</a> | <a>DeleteMatchmakingRuleSet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UpdateRuntimeConfiguration' => '<p>Updates the current runtime configuration for the specified fleet, which tells GameLift how to launch server processes on all instances in the fleet. You can update a fleet\'s runtime configuration at any time after the fleet is created; it does not need to be in <code>ACTIVE</code> status.</p> <p>To update runtime configuration, specify the fleet ID and provide a <code>RuntimeConfiguration</code> with an updated set of server process configurations.</p> <p>If successful, the fleet\'s runtime configuration settings are updated. Each instance in the fleet regularly checks for and retrieves updated runtime configurations. Instances immediately begin complying with the new configuration by launching new server processes or not replacing existing processes when they shut down. Updating a fleet\'s runtime configuration never affects existing server processes.</p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up GameLift fleets</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateFleetLocations</a> | <a>UpdateFleetAttributes</a> | <a>UpdateFleetCapacity</a> | <a>UpdateFleetPortSettings</a> | <a>UpdateRuntimeConfiguration</a> | <a>StopFleetActions</a> | <a>StartFleetActions</a> | <a>PutScalingPolicy</a> | <a>DeleteFleet</a> | <a>DeleteFleetLocations</a> | <a>DeleteScalingPolicy</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'UpdateScript' => '<p>Updates Realtime script metadata and content.</p> <p>To update script metadata, specify the script ID and provide updated name and/or version values. </p> <p>To update script content, provide an updated zip file by pointing to either a local file or an Amazon S3 bucket location. You can use either method regardless of how the original script was uploaded. Use the <i>Version</i> parameter to track updates to the script.</p> <p>If the call is successful, the updated metadata is stored in the script record and a revised script is uploaded to the Amazon Web Services service. Once the script is updated and acquired by a fleet instance, the new version is used for all new game sessions. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon Web Services Realtime Servers</a> </p> <p> <b>Related actions</b> </p> <p> <a>CreateScript</a> | <a>ListScripts</a> | <a>DescribeScript</a> | <a>UpdateScript</a> | <a>DeleteScript</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'ValidateMatchmakingRuleSet' => '<p>Validates the syntax of a matchmaking rule or rule set. This operation checks that the rule set is using syntactically correct JSON and that it conforms to allowed property expressions. To validate syntax, provide a rule set JSON string.</p> <p> <b>Learn more</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a> </p> </li> </ul> <p> <b>Related actions</b> </p> <p> <a>CreateMatchmakingConfiguration</a> | <a>DescribeMatchmakingConfigurations</a> | <a>UpdateMatchmakingConfiguration</a> | <a>DeleteMatchmakingConfiguration</a> | <a>CreateMatchmakingRuleSet</a> | <a>DescribeMatchmakingRuleSets</a> | <a>ValidateMatchmakingRuleSet</a> | <a>DeleteMatchmakingRuleSet</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', ], 'shapes' => [ 'AcceptMatchInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'AcceptMatchOutput' => [ 'base' => NULL, 'refs' => [], ], 'AcceptanceType' => [ 'base' => NULL, 'refs' => [ 'AcceptMatchInput$AcceptanceType' => '<p>Player response to the proposed match.</p>', ], ], 'Alias' => [ 'base' => '<p>Properties that describe an alias resource.</p> <p> <b>Related actions</b> </p> <p> <a>CreateAlias</a> | <a>ListAliases</a> | <a>DescribeAlias</a> | <a>UpdateAlias</a> | <a>DeleteAlias</a> | <a>ResolveAlias</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'AliasList$member' => NULL, 'CreateAliasOutput$Alias' => '<p>The newly created alias resource.</p>', 'DescribeAliasOutput$Alias' => '<p>The requested alias resource.</p>', 'UpdateAliasOutput$Alias' => '<p>The updated alias resource.</p>', ], ], 'AliasArn' => [ 'base' => NULL, 'refs' => [ 'Alias$AliasArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift alias resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::alias/alias-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>. In a GameLift alias ARN, the resource ID matches the alias ID value.</p>', ], ], 'AliasId' => [ 'base' => NULL, 'refs' => [ 'Alias$AliasId' => '<p>A unique identifier for the alias. Alias IDs are unique within a Region.</p>', ], ], 'AliasIdOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionInput$AliasId' => '<p>A unique identifier for the alias associated with the fleet to create a game session in. You can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>', 'DeleteAliasInput$AliasId' => '<p>A unique identifier of the alias that you want to delete. You can use either the alias ID or ARN value.</p>', 'DescribeAliasInput$AliasId' => '<p>The unique identifier for the fleet alias that you want to retrieve. You can use either the alias ID or ARN value. </p>', 'DescribeGameSessionDetailsInput$AliasId' => '<p>A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can use either the alias ID or ARN value.</p>', 'DescribeGameSessionsInput$AliasId' => '<p>A unique identifier for the alias associated with the fleet to retrieve game sessions for. You can use either the alias ID or ARN value.</p>', 'ResolveAliasInput$AliasId' => '<p>The unique identifier of the alias that you want to retrieve a fleet ID for. You can use either the alias ID or ARN value.</p>', 'SearchGameSessionsInput$AliasId' => '<p>A unique identifier for the alias associated with the fleet to search for active game sessions. You can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>', 'UpdateAliasInput$AliasId' => '<p>A unique identifier for the alias that you want to update. You can use either the alias ID or ARN value.</p>', ], ], 'AliasList' => [ 'base' => NULL, 'refs' => [ 'ListAliasesOutput$Aliases' => '<p>A collection of alias resources that match the request parameters.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to retrieve tags for. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>', 'TagResourceRequest$ResourceARN' => '<p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to assign tags to. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>', 'UntagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to and uniquely identifies the GameLift resource that you want to remove tags from. GameLift resource ARNs are included in the data object for the resource, which can be retrieved by calling a List or Describe operation for the resource type. </p>', ], ], 'ArnStringModel' => [ 'base' => NULL, 'refs' => [ 'CreatePlayerSessionInput$GameSessionId' => '<p>A unique identifier for the game session to add a player to.</p>', 'CreatePlayerSessionsInput$GameSessionId' => '<p>A unique identifier for the game session to add players to.</p>', 'DescribeGameSessionDetailsInput$GameSessionId' => '<p>A unique identifier for the game session to retrieve. </p>', 'DescribeGameSessionsInput$GameSessionId' => '<p>A unique identifier for the game session to retrieve. </p>', 'DescribePlayerSessionsInput$GameSessionId' => '<p>A unique identifier for the game session to retrieve player sessions for.</p>', 'GameSessionConnectionInfo$GameSessionArn' => '<p>A unique identifier for the game session. Use the game session ID.</p>', 'GameSessionQueueDestination$DestinationArn' => '<p>The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions. </p>', 'GetGameSessionLogUrlInput$GameSessionId' => '<p>A unique identifier for the game session to get logs for. </p>', 'QueueArnsList$member' => NULL, 'StartMatchBackfillInput$GameSessionArn' => '<p>A unique identifier for the game session. Use the game session ID. When using FlexMatch as a standalone matchmaking solution, this parameter is not needed. </p>', 'UpdateGameSessionInput$GameSessionId' => '<p>A unique identifier for the game session to update. </p>', ], ], 'AttributeValue' => [ 'base' => '<p>Values for use in <a>Player</a> attribute key-value pairs. This object lets you specify an attribute value using any of the valid data types: string, number, string array, or data map. Each <code>AttributeValue</code> object can use only one of the available properties.</p>', 'refs' => [ 'PlayerAttributeMap$value' => NULL, ], ], 'AutoScalingGroupArn' => [ 'base' => NULL, 'refs' => [ 'GameServerGroup$AutoScalingGroupArn' => '<p>A generated unique ID for the Amazon EC2 Auto Scaling group that is associated with this game server group.</p>', ], ], 'AwsCredentials' => [ 'base' => '<p>Temporary access credentials used for uploading game build files to Amazon Web Services. They are valid for a limited time. If they expire before you upload your game build, get a new set by calling <a>RequestUploadCredentials</a>.</p>', 'refs' => [ 'CreateBuildOutput$UploadCredentials' => '<p>This element is returned only when the operation is called without a storage location. It contains credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon Web Services. Credentials have a limited life span. To refresh these credentials, call <a>RequestUploadCredentials</a>. </p>', 'RequestUploadCredentialsOutput$UploadCredentials' => '<p>Amazon Web Services credentials required when uploading a game build to the storage location. These credentials have a limited lifespan and are valid only for the build they were issued for.</p>', ], ], 'BackfillMode' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$BackfillMode' => '<p>The method used to backfill game sessions that are created with this matchmaking configuration. Specify <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill feature. Specify <code>AUTOMATIC</code> to have GameLift create a <a>StartMatchBackfill</a> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', 'MatchmakingConfiguration$BackfillMode' => '<p>The method used to backfill game sessions created with this matchmaking configuration. MANUAL indicates that the game makes backfill requests or does not use the match backfill feature. AUTOMATIC indicates that GameLift creates <a>StartMatchBackfill</a> requests whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill existing games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', 'UpdateMatchmakingConfigurationInput$BackfillMode' => '<p>The method that is used to backfill game sessions created with this matchmaking configuration. Specify MANUAL when your game manages backfill requests manually or does not use the match backfill feature. Specify AUTOMATIC to have GameLift create a <a>StartMatchBackfill</a> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill Existing Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', ], ], 'BalancingStrategy' => [ 'base' => NULL, 'refs' => [ 'CreateGameServerGroupInput$BalancingStrategy' => '<p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p> <ul> <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li> <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li> <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li> </ul>', 'GameServerGroup$BalancingStrategy' => '<p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p> <ul> <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li> <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li> <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li> </ul>', 'UpdateGameServerGroupInput$BalancingStrategy' => '<p>Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:</p> <ul> <li> <p> <code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</p> </li> <li> <p> <code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</p> </li> <li> <p> <code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</p> </li> </ul>', ], ], 'BooleanModel' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$AcceptanceRequired' => '<p>A flag that determines whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to <code>TRUE</code>. With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance. </p>', 'MatchmakingConfiguration$AcceptanceRequired' => '<p>A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. When this option is enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.</p>', 'UpdateMatchmakingConfigurationInput$AcceptanceRequired' => '<p>A flag that indicates whether a match that was created with this configuration must be accepted by the matched players. To require acceptance, set to TRUE. With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance. </p>', 'ValidateMatchmakingRuleSetOutput$Valid' => '<p>A response indicating whether the rule set is valid.</p>', ], ], 'Build' => [ 'base' => '<p>Properties describing a custom game build.</p> <p> <b>Related actions</b> </p> <p> <a>CreateBuild</a> | <a>ListBuilds</a> | <a>DescribeBuild</a> | <a>UpdateBuild</a> | <a>DeleteBuild</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'BuildList$member' => NULL, 'CreateBuildOutput$Build' => '<p>The newly created build resource, including a unique build IDs and status. </p>', 'DescribeBuildOutput$Build' => '<p>Set of properties describing the requested build.</p>', 'UpdateBuildOutput$Build' => '<p>The updated build resource.</p>', ], ], 'BuildArn' => [ 'base' => NULL, 'refs' => [ 'Build$BuildArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift build resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>. In a GameLift build ARN, the resource ID matches the <i>BuildId</i> value.</p>', 'FleetAttributes$BuildArn' => '<p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift build resource that is deployed on instances in this fleet. In a GameLift build ARN, the resource ID matches the <code>BuildId</code> value.</p>', ], ], 'BuildId' => [ 'base' => NULL, 'refs' => [ 'Build$BuildId' => '<p>A unique identifier for the build.</p>', 'FleetAttributes$BuildId' => '<p>A unique identifier for the build resource that is deployed on instances in this fleet.</p>', ], ], 'BuildIdOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$BuildId' => '<p>The unique identifier for a custom game server build to be deployed on fleet instances. You can use either the build ID or ARN. The build must be uploaded to GameLift and in <code>READY</code> status. This fleet property cannot be changed later.</p>', 'DeleteBuildInput$BuildId' => '<p>A unique identifier for the build to delete. You can use either the build ID or ARN value. </p>', 'DescribeBuildInput$BuildId' => '<p>A unique identifier for the build to retrieve properties for. You can use either the build ID or ARN value. </p>', 'ListFleetsInput$BuildId' => '<p>A unique identifier for the build to request fleets for. Use this parameter to return only fleets using a specified build. Use either the build ID or ARN value.</p>', 'RequestUploadCredentialsInput$BuildId' => '<p>A unique identifier for the build to get credentials for. You can use either the build ID or ARN value. </p>', 'UpdateBuildInput$BuildId' => '<p>A unique identifier for the build to update. You can use either the build ID or ARN value. </p>', ], ], 'BuildList' => [ 'base' => NULL, 'refs' => [ 'ListBuildsOutput$Builds' => '<p>A collection of build resources that match the request.</p>', ], ], 'BuildStatus' => [ 'base' => NULL, 'refs' => [ 'Build$Status' => '<p>Current status of the build.</p> <p>Possible build statuses include the following:</p> <ul> <li> <p> <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value. </p> </li> <li> <p> <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.</p> </li> <li> <p> <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build. </p> </li> </ul>', 'ListBuildsInput$Status' => '<p>Build status to filter results by. To retrieve all builds, leave this parameter empty.</p> <p>Possible build statuses include the following:</p> <ul> <li> <p> <b>INITIALIZED</b> -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value. </p> </li> <li> <p> <b>READY</b> -- The game build has been successfully uploaded. You can now create new fleets for this build.</p> </li> <li> <p> <b>FAILED</b> -- The game build upload failed. You cannot create new fleets for this build. </p> </li> </ul>', ], ], 'CertificateConfiguration' => [ 'base' => '<p>Determines whether a TLS/SSL certificate is generated for a fleet. This feature must be enabled when creating the fleet. All instances in a fleet share the same certificate. The certificate can be retrieved by calling the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html">GameLift Server SDK</a> operation <code>GetInstanceCertificate</code>. </p> <p>A fleet\'s certificate configuration is part of <a>FleetAttributes</a>.</p>', 'refs' => [ 'CreateFleetInput$CertificateConfiguration' => '<p>Prompts GameLift to generate a TLS/SSL certificate for the fleet. TLS certificates are used for encrypting traffic between game clients and the game servers that are running on GameLift. By default, the <code>CertificateConfiguration</code> is set to <code>DISABLED</code>. This property cannot be changed after the fleet is created. </p> <p>Note: This feature requires the Amazon Web Services Certificate Manager (ACM) service, which is not available in all Amazon Web Services regions. When working in a region that does not support this feature, a fleet creation request with certificate generation fails with a 4xx error.</p>', 'FleetAttributes$CertificateConfiguration' => '<p>Indicates whether a TLS/SSL certificate was generated for the fleet. </p>', ], ], 'CertificateType' => [ 'base' => NULL, 'refs' => [ 'CertificateConfiguration$CertificateType' => '<p>Indicates whether a TLS/SSL certificate is generated for a fleet. </p> <p>Valid values include: </p> <ul> <li> <p> <b>GENERATED</b> - Generate a TLS/SSL certificate for this fleet.</p> </li> <li> <p> <b>DISABLED</b> - (default) Do not generate a TLS/SSL certificate for this fleet. </p> </li> </ul> <p> </p>', ], ], 'ClaimGameServerInput' => [ 'base' => NULL, 'refs' => [], ], 'ClaimGameServerOutput' => [ 'base' => NULL, 'refs' => [], ], 'ComparisonOperatorType' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$ComparisonOperator' => '<p>Comparison operator to use when measuring the metric against the threshold value.</p>', 'ScalingPolicy$ComparisonOperator' => '<p>Comparison operator to use when measuring a metric against the threshold value.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>', 'refs' => [], ], 'CreateAliasInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreateAliasOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'CreateBuildInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreateBuildOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'CreateFleetInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreateFleetLocationsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreateFleetLocationsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation. </p>', 'refs' => [], ], 'CreateFleetOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'CreateGameServerGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGameServerGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGameSessionInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreateGameSessionOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'CreateGameSessionQueueInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreateGameSessionQueueOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'CreateMatchmakingConfigurationInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreateMatchmakingConfigurationOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'CreateMatchmakingRuleSetInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreateMatchmakingRuleSetOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'CreatePlayerSessionInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreatePlayerSessionOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'CreatePlayerSessionsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreatePlayerSessionsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'CreateScriptInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateScriptOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcPeeringAuthorizationInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreateVpcPeeringAuthorizationOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'CreateVpcPeeringConnectionInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'CreateVpcPeeringConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CustomEventData' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$CustomEventData' => '<p>Information to be added to all events related to this matchmaking configuration. </p>', 'MatchmakingConfiguration$CustomEventData' => '<p>Information to attach to all events related to the matchmaking configuration. </p>', 'UpdateMatchmakingConfigurationInput$CustomEventData' => '<p>Information to add to all events related to the matchmaking configuration. </p>', ], ], 'DeleteAliasInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DeleteBuildInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DeleteFleetInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DeleteFleetLocationsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DeleteFleetLocationsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DeleteGameServerGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGameServerGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGameSessionQueueInput' => [ 'base' => '<p>Represents the input for a request operation. </p>', 'refs' => [], ], 'DeleteGameSessionQueueOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMatchmakingConfigurationInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DeleteMatchmakingConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMatchmakingRuleSetInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DeleteMatchmakingRuleSetOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DeleteScalingPolicyInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DeleteScriptInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcPeeringAuthorizationInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DeleteVpcPeeringAuthorizationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcPeeringConnectionInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DeleteVpcPeeringConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterGameServerInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAliasInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeAliasOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeBuildInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeBuildOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeEC2InstanceLimitsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeEC2InstanceLimitsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeFleetAttributesInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeFleetAttributesOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeFleetCapacityInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeFleetCapacityOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeFleetEventsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeFleetEventsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeFleetLocationAttributesInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeFleetLocationAttributesOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation. </p>', 'refs' => [], ], 'DescribeFleetLocationCapacityInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeFleetLocationCapacityOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeFleetLocationUtilizationInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeFleetLocationUtilizationOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeFleetPortSettingsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeFleetPortSettingsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeFleetUtilizationInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeFleetUtilizationOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeGameServerGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGameServerGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGameServerInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGameServerInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGameServerInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGameServerOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGameSessionDetailsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeGameSessionDetailsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeGameSessionPlacementInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeGameSessionPlacementOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeGameSessionQueuesInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeGameSessionQueuesOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeGameSessionsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeGameSessionsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeInstancesInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeInstancesOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeMatchmakingConfigurationsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeMatchmakingConfigurationsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeMatchmakingInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeMatchmakingOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeMatchmakingRuleSetsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeMatchmakingRuleSetsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribePlayerSessionsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribePlayerSessionsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeRuntimeConfigurationInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeRuntimeConfigurationOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeScalingPoliciesInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeScalingPoliciesOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DescribeScriptInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeScriptOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcPeeringAuthorizationsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcPeeringAuthorizationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcPeeringConnectionsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'DescribeVpcPeeringConnectionsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'DesiredPlayerSession' => [ 'base' => '<p>Player information for use when creating player sessions using a game session placement request with <a>StartGameSessionPlacement</a>.</p>', 'refs' => [ 'DesiredPlayerSessionList$member' => NULL, ], ], 'DesiredPlayerSessionList' => [ 'base' => NULL, 'refs' => [ 'StartGameSessionPlacementInput$DesiredPlayerSessions' => '<p>Set of information on each player to create a player session for.</p>', ], ], 'DnsName' => [ 'base' => NULL, 'refs' => [ 'GameSession$DnsName' => '<p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p> <ul> <li> <p>TLS-enabled fleets: <code>&lt;unique identifier&gt;.&lt;region identifier&gt;.amazongamelift.com</code>.</p> </li> <li> <p>Non-TLS-enabled fleets: <code>ec2-&lt;unique identifier&gt;.compute.amazonaws.com</code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li> </ul> <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>', 'GameSessionConnectionInfo$DnsName' => '<p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p> <ul> <li> <p>TLS-enabled fleets: <code>&lt;unique identifier&gt;.&lt;region identifier&gt;.amazongamelift.com</code>.</p> </li> <li> <p>Non-TLS-enabled fleets: <code>ec2-&lt;unique identifier&gt;.compute.amazonaws.com</code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li> </ul> <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>', 'GameSessionPlacement$DnsName' => '<p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p> <ul> <li> <p>TLS-enabled fleets: <code>&lt;unique identifier&gt;.&lt;region identifier&gt;.amazongamelift.com</code>.</p> </li> <li> <p>Non-TLS-enabled fleets: <code>ec2-&lt;unique identifier&gt;.compute.amazonaws.com</code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li> </ul> <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>', 'Instance$DnsName' => '<p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p> <ul> <li> <p>TLS-enabled fleets: <code>&lt;unique identifier&gt;.&lt;region identifier&gt;.amazongamelift.com</code>.</p> </li> <li> <p>Non-TLS-enabled fleets: <code>ec2-&lt;unique identifier&gt;.compute.amazonaws.com</code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li> </ul> <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>', 'PlayerSession$DnsName' => '<p>The DNS identifier assigned to the instance that is running the game session. Values have the following format:</p> <ul> <li> <p>TLS-enabled fleets: <code>&lt;unique identifier&gt;.&lt;region identifier&gt;.amazongamelift.com</code>.</p> </li> <li> <p>Non-TLS-enabled fleets: <code>ec2-&lt;unique identifier&gt;.compute.amazonaws.com</code>. (See <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing</a>.)</p> </li> </ul> <p>When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$Threshold' => '<p>Metric value used to trigger a scaling event.</p>', 'ScalingPolicy$Threshold' => '<p>Metric value used to trigger a scaling event.</p>', 'TargetConfiguration$TargetValue' => '<p>Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet\'s buffer (the percent of capacity that should be idle and ready for new game sessions).</p>', ], ], 'DoubleObject' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$N' => '<p>For number values, expressed as double.</p>', 'StringDoubleMap$value' => NULL, ], ], 'EC2InstanceCounts' => [ 'base' => '<p>Resource capacity settings. Fleet capacity is measured in Amazon EC2 instances. Pending and terminating counts are non-zero when the fleet capacity is adjusting to a scaling event or if access to resources is temporarily affected.</p> <p>EC2 instance counts are part of <a>FleetCapacity</a>.</p>', 'refs' => [ 'FleetCapacity$InstanceCounts' => '<p>The current instance count and capacity settings for the fleet location. </p>', ], ], 'EC2InstanceLimit' => [ 'base' => '<p>The GameLift service limits for an Amazon EC2 instance type and current utilization. GameLift allows Amazon Web Services accounts a maximum number of instances, per instance type, per Amazon Web Services Region or location, for use with GameLift. You can request an limit increase for your account by using the <b>Service limits</b> page in the GameLift console.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeEC2InstanceLimits</a> </p>', 'refs' => [ 'EC2InstanceLimitList$member' => NULL, ], ], 'EC2InstanceLimitList' => [ 'base' => NULL, 'refs' => [ 'DescribeEC2InstanceLimitsOutput$EC2InstanceLimits' => '<p>The maximum number of instances for the specified instance type.</p>', ], ], 'EC2InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$EC2InstanceType' => '<p>The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type determines the computing resources that will be used to host your game servers, including CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions of Amazon EC2 instance types.</p>', 'DescribeEC2InstanceLimitsInput$EC2InstanceType' => '<p>Name of an Amazon EC2 instance type that is supported in GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Do not specify a value for this parameter to retrieve limits for all instance types.</p>', 'EC2InstanceLimit$EC2InstanceType' => '<p>The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions. </p>', 'FleetAttributes$InstanceType' => '<p>The Amazon EC2 instance type that determines the computing resources of each instance in the fleet. Instance type defines the CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions.</p>', 'FleetCapacity$InstanceType' => '<p>The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the computing resources in use, including CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions.</p>', 'Instance$Type' => '<p>Amazon EC2 instance type that defines the computing resources of this instance. </p>', ], ], 'Event' => [ 'base' => '<p>Log entry describing an event that involves GameLift resources (such as a fleet). In addition to tracking activity, event codes and messages can provide additional information for troubleshooting and debugging problems.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeFleetEvents</a> </p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventCode' => [ 'base' => NULL, 'refs' => [ 'Event$EventCode' => '<p>The type of event being logged. </p> <p> <b>Fleet state transition events:</b> </p> <ul> <li> <p>FLEET_CREATED -- A fleet resource was successfully created with a status of <code>NEW</code>. Event messaging includes the fleet ID.</p> </li> <li> <p>FLEET_STATE_DOWNLOADING -- Fleet status changed from <code>NEW</code> to <code>DOWNLOADING</code>. The compressed build has started downloading to a fleet instance for installation.</p> </li> <li> <p>FLEET_STATE_VALIDATING -- Fleet status changed from <code>DOWNLOADING</code> to <code>VALIDATING</code>. GameLift has successfully downloaded the build and is now validating the build files.</p> </li> <li> <p>FLEET_STATE_BUILDING -- Fleet status changed from <code>VALIDATING</code> to <code>BUILDING</code>. GameLift has successfully verified the build files and is now running the installation scripts.</p> </li> <li> <p>FLEET_STATE_ACTIVATING -- Fleet status changed from <code>BUILDING</code> to <code>ACTIVATING</code>. GameLift is trying to launch an instance and test the connectivity between the build and the GameLift Service via the Server SDK.</p> </li> <li> <p>FLEET_STATE_ACTIVE -- The fleet\'s status changed from <code>ACTIVATING</code> to <code>ACTIVE</code>. The fleet is now ready to host game sessions.</p> </li> <li> <p>FLEET_STATE_ERROR -- The Fleet\'s status changed to <code>ERROR</code>. Describe the fleet event message for more details.</p> </li> </ul> <p> <b>Fleet creation events (ordered by fleet creation activity):</b> </p> <ul> <li> <p>FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the fleet instance.</p> </li> <li> <p>FLEET_CREATION_EXTRACTING_BUILD -- The game server build was successfully downloaded to an instance, and the build files are now being extracted from the uploaded build and saved to an instance. Failure at this stage prevents a fleet from moving to ACTIVE status. Logs for this stage display a list of the files that are extracted and saved on the instance. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li> <li> <p>FLEET_CREATION_RUNNING_INSTALLER -- The game server build files were successfully extracted, and the GameLift is now running the build\'s install script (if one is included). Failure in this stage prevents a fleet from moving to ACTIVE status. Logs for this stage list the installation steps and whether or not the install completed successfully. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li> <li> <p>FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful, and the GameLift is now verifying that the game server launch paths, which are specified in the fleet\'s runtime configuration, exist. If any listed launch path exists, GameLift tries to launch a game server process and waits for the process to report ready. Failures in this stage prevent a fleet from moving to <code>ACTIVE</code> status. Logs for this stage list the launch paths in the runtime configuration and indicate whether each is found. Access the logs by using the URL in <i>PreSignedLogUrl</i>.</p> </li> <li> <p>FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND -- Validation of the runtime configuration failed because the executable specified in a launch path does not exist on the instance.</p> </li> <li> <p>FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the runtime configuration failed because the executable specified in a launch path failed to run on the fleet instance.</p> </li> <li> <p>FLEET_VALIDATION_TIMED_OUT -- Validation of the fleet at the end of creation timed out. Try fleet creation again.</p> </li> <li> <p>FLEET_ACTIVATION_FAILED -- The fleet failed to successfully complete one of the steps in the fleet activation process. This event code indicates that the game build was successfully downloaded to a fleet instance, built, and validated, but was not able to start a server process. For more information, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation">Debug Fleet Creation Issues</a>.</p> </li> <li> <p>FLEET_ACTIVATION_FAILED_NO_INSTANCES -- Fleet creation was not able to obtain any instances based on the input fleet attributes. Try again at a different time or choose a different combination of fleet attributes such as fleet type, instance type, etc.</p> </li> <li> <p>FLEET_INITIALIZATION_FAILED -- A generic exception occurred during fleet creation. Describe the fleet event message for more details.</p> </li> </ul> <p> <b>VPC peering events:</b> </p> <ul> <li> <p>FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been established between the VPC for an GameLift fleet and a VPC in your Amazon Web Services account.</p> </li> <li> <p>FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed. Event details and status information (see <a>DescribeVpcPeeringConnections</a>) provide additional detail. A common reason for peering failure is that the two VPCs have overlapping CIDR blocks of IPv4 addresses. To resolve this, change the CIDR block for the VPC in your Amazon Web Services account. For more information on VPC peering failures, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html">https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html</a> </p> </li> <li> <p>FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully deleted.</p> </li> </ul> <p> <b>Spot instance events:</b> </p> <ul> <li> <p> INSTANCE_INTERRUPTED -- A spot instance was interrupted by EC2 with a two-minute notification.</p> </li> </ul> <p> <b>Spot process events:</b> </p> <ul> <li> <p>SERVER_PROCESS_INVALID_PATH -- The game server executable or script could not be found based on the Fleet runtime configuration. Check that the launch path is correct based on the operating system of the Fleet.</p> </li> <li> <p>SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT -- The server process did not call InitSDK() within the time expected. Check your game session log to see why InitSDK() was not called in time.</p> </li> <li> <p>SERVER_PROCESS_PROCESS_READY_TIMEOUT -- The server process did not call ProcessReady() within the time expected after calling InitSDK(). Check your game session log to see why ProcessReady() was not called in time.</p> </li> <li> <p>SERVER_PROCESS_CRASHED -- The server process exited without calling ProcessEnding(). Check your game session log to see why ProcessEnding() was not called.</p> </li> <li> <p>SERVER_PROCESS_TERMINATED_UNHEALTHY -- The server process did not report a valid health check for too long and was therefore terminated by GameLift. Check your game session log to see if the thread became stuck processing a synchronous task for too long.</p> </li> <li> <p>SERVER_PROCESS_FORCE_TERMINATED -- The server process did not exit cleanly after OnProcessTerminate() was sent within the time expected. Check your game session log to see why termination took longer than expected.</p> </li> <li> <p>SERVER_PROCESS_PROCESS_EXIT_TIMEOUT -- The server process did not exit cleanly within the time expected after calling ProcessEnding(). Check your game session log to see why termination took longer than expected.</p> </li> </ul> <p> <b>Game session events:</b> </p> <ul> <li> <p>GAME_SESSION_ACTIVATION_TIMEOUT -- GameSession failed to activate within the expected time. Check your game session log to see why ActivateGameSession() took longer to complete than expected.</p> </li> </ul> <p> <b>Other fleet events:</b> </p> <ul> <li> <p>FLEET_SCALING_EVENT -- A change was made to the fleet\'s capacity settings (desired instances, minimum/maximum scaling limits). Event messaging includes the new capacity settings.</p> </li> <li> <p>FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED -- A change was made to the fleet\'s game session protection policy setting. Event messaging includes both the old and new policy setting. </p> </li> <li> <p>FLEET_DELETED -- A request to delete a fleet was initiated.</p> </li> <li> <p> GENERIC_EVENT -- An unspecified event has occurred.</p> </li> </ul>', ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetEventsOutput$Events' => '<p>A collection of objects containing event log entries for the specified fleet.</p>', ], ], 'FilterConfiguration' => [ 'base' => '<p>A list of fleet locations where a game session queue can place new game sessions. You can use a filter to temporarily turn off placements for specific locations. For queues that have multi-location fleets, you can use a filter configuration allow placement with some, but not all of these locations.</p> <p>Filter configurations are part of a <a>GameSessionQueue</a>.</p>', 'refs' => [ 'CreateGameSessionQueueInput$FilterConfiguration' => '<p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of Amazon Web Services Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. </p>', 'GameSessionQueue$FilterConfiguration' => '<p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of Amazon Web Services Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. </p>', 'UpdateGameSessionQueueInput$FilterConfiguration' => '<p>A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of Amazon Web Services Region codes, such as <code>us-west-2</code>. If this parameter is not set, game sessions can be placed in any queue location. To remove an existing filter configuration, pass in an empty set.</p>', ], ], 'FleetAction' => [ 'base' => NULL, 'refs' => [ 'FleetActionList$member' => NULL, ], ], 'FleetActionList' => [ 'base' => NULL, 'refs' => [ 'FleetAttributes$StoppedActions' => '<p>A list of fleet activity that has been suspended using <a>StopFleetActions</a>. This includes fleet auto-scaling.</p>', 'LocationAttributes$StoppedActions' => '<p>A list of fleet actions that have been suspended in the fleet location.</p>', 'StartFleetActionsInput$Actions' => '<p>List of actions to restart on the fleet.</p>', 'StopFleetActionsInput$Actions' => '<p>List of actions to suspend on the fleet. </p>', ], ], 'FleetArn' => [ 'base' => NULL, 'refs' => [ 'CreateFleetLocationsOutput$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>. </p>', 'DeleteFleetLocationsOutput$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.</p>', 'DescribeFleetLocationAttributesOutput$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>. </p>', 'DescribeFleetPortSettingsOutput$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.</p>', 'FleetAttributes$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>. In a GameLift fleet ARN, the resource ID matches the <code>FleetId</code> value.</p>', 'FleetCapacity$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.</p>', 'FleetUtilization$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.</p>', 'GameSession$FleetArn' => '<p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet that this game session is running on. </p>', 'Instance$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.</p>', 'PlayerSession$FleetArn' => '<p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet that the player\'s game session is running on. </p>', 'ResolveAliasOutput$FleetArn' => '<p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet resource that this alias points to. </p>', 'ScalingPolicy$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.</p>', 'StartFleetActionsOutput$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.</p>', 'StopFleetActionsOutput$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.</p>', 'UpdateFleetCapacityOutput$FleetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>. </p>', 'VpcPeeringConnection$FleetArn' => '<p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift fleet resource for this connection. </p>', ], ], 'FleetAttributes' => [ 'base' => '<p>Describes a GameLift fleet of game hosting resources.</p> <p> <b>Related actions</b> </p> <p> <a>CreateFleet</a> | <a>DescribeFleetAttributes</a> </p>', 'refs' => [ 'CreateFleetOutput$FleetAttributes' => '<p>The properties for the new fleet, including the current status. All fleets are placed in <code>NEW</code> status on creation. </p>', 'FleetAttributesList$member' => NULL, ], ], 'FleetAttributesList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetAttributesOutput$FleetAttributes' => '<p>A collection of objects containing attribute metadata for each requested fleet ID. Attribute objects are returned only for fleets that currently exist.</p>', ], ], 'FleetCapacity' => [ 'base' => '<p>Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet\'s remote location or its home Region. </p> <p> <b>Related actions</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html">DescribeFleetCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html">DescribeFleetLocationCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html">UpdateFleetCapacity</a> </p>', 'refs' => [ 'DescribeFleetLocationCapacityOutput$FleetCapacity' => '<p>Resource capacity information for the requested fleet location. Capacity objects are returned only for fleets and locations that currently exist.</p>', 'FleetCapacityList$member' => NULL, ], ], 'FleetCapacityExceededException' => [ 'base' => '<p>The specified fleet has no available instances to fulfill a <code>CreateGameSession</code> request. Clients can retry such requests immediately or after a waiting period.</p>', 'refs' => [], ], 'FleetCapacityList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetCapacityOutput$FleetCapacity' => '<p>A collection of objects that contains capacity information for each requested fleet ID. Capacity objects are returned only for fleets that currently exist.</p>', ], ], 'FleetId' => [ 'base' => NULL, 'refs' => [ 'CreateVpcPeeringConnectionInput$FleetId' => '<p>A unique identifier for the fleet. You can use either the fleet ID or ARN value. This tells Amazon Web Services which GameLift VPC to peer with. </p>', 'DeleteVpcPeeringConnectionInput$FleetId' => '<p>A unique identifier for the fleet. This fleet specified must match the fleet referenced in the VPC peering connection record. You can use either the fleet ID or ARN value.</p>', 'DescribeFleetPortSettingsOutput$FleetId' => '<p>A unique identifier for the fleet that was requested. </p>', 'DescribeVpcPeeringConnectionsInput$FleetId' => '<p>A unique identifier for the fleet. You can use either the fleet ID or ARN value.</p>', 'FleetAttributes$FleetId' => '<p>A unique identifier for the fleet.</p>', 'FleetCapacity$FleetId' => '<p>A unique identifier for the fleet associated with the location.</p>', 'FleetIdList$member' => NULL, 'FleetUtilization$FleetId' => '<p>A unique identifier for the fleet associated with the location.</p>', 'GameSession$FleetId' => '<p>A unique identifier for the fleet that the game session is running on.</p>', 'Instance$FleetId' => '<p>A unique identifier for the fleet that the instance is in.</p>', 'InstanceAccess$FleetId' => '<p>A unique identifier for the fleet containing the instance being accessed.</p>', 'PlayerSession$FleetId' => '<p>A unique identifier for the fleet that the player\'s game session is running on.</p>', 'ResolveAliasOutput$FleetId' => '<p>The fleet identifier that the alias is pointing to.</p>', 'RoutingStrategy$FleetId' => '<p>A unique identifier for the fleet that the alias points to. This value is the fleet ID, not the fleet ARN.</p>', 'ScalingPolicy$FleetId' => '<p>A unique identifier for the fleet that is associated with this scaling policy.</p>', 'StartFleetActionsOutput$FleetId' => '<p>A unique identifier for the fleet to restart actions on.</p>', 'StopFleetActionsOutput$FleetId' => '<p>A unique identifier for the fleet to stop actions on.</p>', 'UpdateFleetAttributesOutput$FleetId' => '<p>A unique identifier for the fleet that was updated.</p>', 'UpdateFleetCapacityOutput$FleetId' => '<p>A unique identifier for the fleet that was updated.</p>', 'UpdateFleetPortSettingsOutput$FleetId' => '<p>A unique identifier for the fleet that was updated.</p>', 'VpcPeeringConnection$FleetId' => '<p>A unique identifier for the fleet. This ID determines the ID of the Amazon Web Services VPC for your fleet.</p>', ], ], 'FleetIdList' => [ 'base' => NULL, 'refs' => [ 'ListFleetsOutput$FleetIds' => '<p>A set of fleet IDs that match the list request. You can retrieve additional information about all returned fleets by passing this result set to a <a>DescribeFleetAttributes</a>, <a>DescribeFleetCapacity</a>, or <a>DescribeFleetUtilization</a> call.</p>', ], ], 'FleetIdOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateFleetLocationsInput$FleetId' => '<p>A unique identifier for the fleet to add locations to. You can use either the fleet ID or ARN value.</p>', 'CreateFleetLocationsOutput$FleetId' => '<p>A unique identifier for the fleet that was updated with new locations.</p>', 'CreateGameSessionInput$FleetId' => '<p>A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>', 'DeleteFleetInput$FleetId' => '<p>A unique identifier for the fleet to be deleted. You can use either the fleet ID or ARN value.</p>', 'DeleteFleetLocationsInput$FleetId' => '<p>A unique identifier for the fleet to delete locations for. You can use either the fleet ID or ARN value.</p>', 'DeleteFleetLocationsOutput$FleetId' => '<p>A unique identifier for the fleet that location attributes are being deleted for.</p>', 'DeleteScalingPolicyInput$FleetId' => '<p>A unique identifier for the fleet to be deleted. You can use either the fleet ID or ARN value.</p>', 'DescribeFleetEventsInput$FleetId' => '<p>A unique identifier for the fleet to get event logs for. You can use either the fleet ID or ARN value.</p>', 'DescribeFleetLocationAttributesInput$FleetId' => '<p>A unique identifier for the fleet to retrieve remote locations for. You can use either the fleet ID or ARN value.</p>', 'DescribeFleetLocationAttributesOutput$FleetId' => '<p>A unique identifier for the fleet that location attributes were requested for.</p>', 'DescribeFleetLocationCapacityInput$FleetId' => '<p>A unique identifier for the fleet to request location capacity for. You can use either the fleet ID or ARN value.</p>', 'DescribeFleetLocationUtilizationInput$FleetId' => '<p>A unique identifier for the fleet to request location utilization for. You can use either the fleet ID or ARN value.</p>', 'DescribeFleetPortSettingsInput$FleetId' => '<p>A unique identifier for the fleet to retrieve port settings for. You can use either the fleet ID or ARN value.</p>', 'DescribeGameSessionDetailsInput$FleetId' => '<p>A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use either the fleet ID or ARN value.</p>', 'DescribeGameSessionsInput$FleetId' => '<p>A unique identifier for the fleet to retrieve game sessions for. You can use either the fleet ID or ARN value. </p>', 'DescribeInstancesInput$FleetId' => '<p>A unique identifier for the fleet to retrieve instance information for. You can use either the fleet ID or ARN value.</p>', 'DescribeRuntimeConfigurationInput$FleetId' => '<p>A unique identifier for the fleet to get the runtime configuration for. You can use either the fleet ID or ARN value.</p>', 'DescribeScalingPoliciesInput$FleetId' => '<p>A unique identifier for the fleet for which to retrieve scaling policies. You can use either the fleet ID or ARN value.</p>', 'FleetIdOrArnList$member' => NULL, 'GetInstanceAccessInput$FleetId' => '<p>A unique identifier for the fleet that contains the instance you want access to. You can use either the fleet ID or ARN value. The fleet can be in any of the following statuses: <code>ACTIVATING</code>, <code>ACTIVE</code>, or <code>ERROR</code>. Fleets with an <code>ERROR</code> status may be accessible for a short time before they are deleted.</p>', 'PutScalingPolicyInput$FleetId' => '<p>A unique identifier for the fleet to apply this policy to. You can use either the fleet ID or ARN value. The fleet cannot be in any of the following statuses: ERROR or DELETING.</p>', 'SearchGameSessionsInput$FleetId' => '<p>A unique identifier for the fleet to search for active game sessions. You can use either the fleet ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.</p>', 'StartFleetActionsInput$FleetId' => '<p>A unique identifier for the fleet to restart actions on. You can use either the fleet ID or ARN value.</p>', 'StopFleetActionsInput$FleetId' => '<p>A unique identifier for the fleet to stop actions on. You can use either the fleet ID or ARN value.</p>', 'UpdateFleetAttributesInput$FleetId' => '<p>A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or ARN value.</p>', 'UpdateFleetCapacityInput$FleetId' => '<p>A unique identifier for the fleet to update capacity settings for. You can use either the fleet ID or ARN value.</p>', 'UpdateFleetPortSettingsInput$FleetId' => '<p>A unique identifier for the fleet to update port settings for. You can use either the fleet ID or ARN value.</p>', 'UpdateRuntimeConfigurationInput$FleetId' => '<p>A unique identifier for the fleet to update runtime configuration for. You can use either the fleet ID or ARN value.</p>', ], ], 'FleetIdOrArnList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetAttributesInput$FleetIds' => '<p>A list of unique fleet identifiers to retrieve attributes for. You can use either the fleet ID or ARN value. To retrieve attributes for all current fleets, do not include this parameter. </p>', 'DescribeFleetCapacityInput$FleetIds' => '<p>A unique identifier for the fleet(s) to retrieve capacity information for. You can use either the fleet ID or ARN value. Leave this parameter empty to retrieve capacity information for all fleets.</p>', 'DescribeFleetUtilizationInput$FleetIds' => '<p>A unique identifier for the fleet(s) to retrieve utilization data for. You can use either the fleet ID or ARN value. To retrieve attributes for all current fleets, do not include this parameter. </p>', ], ], 'FleetStatus' => [ 'base' => NULL, 'refs' => [ 'FleetAttributes$Status' => '<p>Current status of the fleet. Possible fleet statuses include the following:</p> <ul> <li> <p> <b>NEW</b> -- A new fleet has been defined and desired instances is set to 1. </p> </li> <li> <p> <b>DOWNLOADING/VALIDATING/BUILDING/ACTIVATING</b> -- GameLift is setting up the new fleet, creating new instances with the game build or Realtime script and starting server processes.</p> </li> <li> <p> <b>ACTIVE</b> -- Hosts can now accept game sessions.</p> </li> <li> <p> <b>ERROR</b> -- An error occurred when downloading, validating, building, or activating the fleet.</p> </li> <li> <p> <b>DELETING</b> -- Hosts are responding to a delete fleet request.</p> </li> <li> <p> <b>TERMINATED</b> -- The fleet no longer exists.</p> </li> </ul>', 'LocationState$Status' => '<p>The life-cycle status of a fleet location. </p>', ], ], 'FleetType' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$FleetType' => '<p>Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to <code>ON_DEMAND</code>. Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"> On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.</p>', 'FleetAttributes$FleetType' => '<p>The kind of instances, On-Demand or Spot, that this fleet uses.</p>', ], ], 'FleetUtilization' => [ 'base' => '<p>Current resource utilization statistics in a specified fleet or location. The location value might refer to a fleet\'s remote location or its home Region.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeFleetUtilization</a> | <a>DescribeFleetLocationUtilization</a> </p>', 'refs' => [ 'DescribeFleetLocationUtilizationOutput$FleetUtilization' => '<p>Utilization information for the requested fleet location. Utilization objects are returned only for fleets and locations that currently exist.</p>', 'FleetUtilizationList$member' => NULL, ], ], 'FleetUtilizationList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetUtilizationOutput$FleetUtilization' => '<p>A collection of objects containing utilization information for each requested fleet ID. Utilization objects are returned only for fleets that currently exist.</p>', ], ], 'FlexMatchMode' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$FlexMatchMode' => '<p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p> <ul> <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li> <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li> </ul>', 'MatchmakingConfiguration$FlexMatchMode' => '<p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p> <ul> <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li> <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li> </ul>', 'UpdateMatchmakingConfigurationInput$FlexMatchMode' => '<p>Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. </p> <ul> <li> <p> <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"> MatchmakingSucceeded</a> event.</p> </li> <li> <p> <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match. </p> </li> </ul>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'PlayerLatency$LatencyInMilliseconds' => '<p>Amount of time that represents the time lag experienced by the player when connected to the specified Region.</p>', ], ], 'FreeText' => [ 'base' => NULL, 'refs' => [ 'Alias$Description' => '<p>A human-readable description of an alias.</p>', 'Build$Name' => '<p>A descriptive label that is associated with a build. Build names do not need to be unique. It can be set using <a>CreateBuild</a> or <a>UpdateBuild</a>.</p>', 'Build$Version' => '<p>Version information that is associated with a build or script. Version strings do not need to be unique. This value can be set using <a>CreateBuild</a> or <a>UpdateBuild</a>.</p>', 'RoutingStrategy$Message' => '<p>The message text to be used with a terminal routing strategy.</p>', ], ], 'GameProperty' => [ 'base' => '<p>Set of key-value pairs that contain information about a game session. When included in a game session request, these properties communicate details to be used when setting up the new game session. For example, a game property might specify a game mode, level, or map. Game properties are passed to the game server process when initiating a new game session. For more information, see the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-create"> GameLift Developer Guide</a>.</p>', 'refs' => [ 'GamePropertyList$member' => NULL, ], ], 'GamePropertyKey' => [ 'base' => NULL, 'refs' => [ 'GameProperty$Key' => '<p>The game property identifier.</p>', ], ], 'GamePropertyList' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionInput$GameProperties' => '<p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'CreateMatchmakingConfigurationInput$GameProperties' => '<p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', 'GameSession$GameProperties' => '<p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). You can search for active game sessions based on this custom data with <a>SearchGameSessions</a>.</p>', 'GameSessionPlacement$GameProperties' => '<p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'MatchmakingConfiguration$GameProperties' => '<p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', 'StartGameSessionPlacementInput$GameProperties' => '<p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'UpdateMatchmakingConfigurationInput$GameProperties' => '<p>A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', ], ], 'GamePropertyValue' => [ 'base' => NULL, 'refs' => [ 'GameProperty$Value' => '<p>The game property value.</p>', ], ], 'GameServer' => [ 'base' => '<p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p> <p>Properties describing a game server that is running on an instance in a <a>GameServerGroup</a>. </p> <p>A game server is created by a successful call to <code>RegisterGameServer</code> and deleted by calling <code>DeregisterGameServer</code>. A game server is claimed to host a game session by calling <code>ClaimGameServer</code>. </p> <p> <b>Related actions</b> </p> <p> <a>RegisterGameServer</a> | <a>ListGameServers</a> | <a>ClaimGameServer</a> | <a>DescribeGameServer</a> | <a>UpdateGameServer</a> | <a>DeregisterGameServer</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'refs' => [ 'ClaimGameServerOutput$GameServer' => '<p>Object that describes the newly claimed game server.</p>', 'DescribeGameServerOutput$GameServer' => '<p>Object that describes the requested game server.</p>', 'GameServers$member' => NULL, 'RegisterGameServerOutput$GameServer' => '<p>Object that describes the newly registered game server.</p>', 'UpdateGameServerOutput$GameServer' => '<p>Object that describes the newly updated game server.</p>', ], ], 'GameServerClaimStatus' => [ 'base' => NULL, 'refs' => [ 'GameServer$ClaimStatus' => '<p>Indicates when an available game server has been reserved for gameplay but has not yet started hosting a game. Once it is claimed, the game server remains in <code>CLAIMED</code> status for a maximum of one minute. During this time, game clients connect to the game server to start the game and trigger the game server to update its utilization status. After one minute, the game server claim status reverts to null.</p>', ], ], 'GameServerConnectionInfo' => [ 'base' => NULL, 'refs' => [ 'GameServer$ConnectionInfo' => '<p>The port and IP address that must be used to establish a client connection to the game server.</p>', 'RegisterGameServerInput$ConnectionInfo' => '<p>Information that is needed to make inbound client connections to the game server. This might include the IP address and port, DNS name, and other information.</p>', ], ], 'GameServerData' => [ 'base' => NULL, 'refs' => [ 'ClaimGameServerInput$GameServerData' => '<p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <a>ListGameServers</a> or <a>ClaimGameServer</a>. </p>', 'GameServer$GameServerData' => '<p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <a>ListGameServers</a> or <a>ClaimGameServer</a>.</p>', 'RegisterGameServerInput$GameServerData' => '<p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <a>ListGameServers</a> or <a>ClaimGameServer</a>. </p>', 'UpdateGameServerInput$GameServerData' => '<p>A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using <a>ListGameServers</a> or <a>ClaimGameServer</a>. </p>', ], ], 'GameServerGroup' => [ 'base' => '<p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p> <p>Properties that describe a game server group resource. A game server group manages certain properties related to a corresponding Amazon EC2 Auto Scaling group. </p> <p>A game server group is created by a successful call to <code>CreateGameServerGroup</code> and deleted by calling <code>DeleteGameServerGroup</code>. Game server group activity can be temporarily suspended and resumed by calling <code>SuspendGameServerGroup</code> and <code>ResumeGameServerGroup</code>, respectively. </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameServerGroup</a> | <a>ListGameServerGroups</a> | <a>DescribeGameServerGroup</a> | <a>UpdateGameServerGroup</a> | <a>DeleteGameServerGroup</a> | <a>ResumeGameServerGroup</a> | <a>SuspendGameServerGroup</a> | <a>DescribeGameServerInstances</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'refs' => [ 'CreateGameServerGroupOutput$GameServerGroup' => '<p>The newly created game server group object, including the new ARN value for the GameLift FleetIQ game server group and the object\'s status. The Amazon EC2 Auto Scaling group ARN is initially null, since the group has not yet been created. This value is added once the game server group status reaches <code>ACTIVE</code>. </p>', 'DeleteGameServerGroupOutput$GameServerGroup' => '<p>An object that describes the deleted game server group resource, with status updated to <code>DELETE_SCHEDULED</code>. </p>', 'DescribeGameServerGroupOutput$GameServerGroup' => '<p>An object with the property settings for the requested game server group resource. </p>', 'GameServerGroups$member' => NULL, 'ResumeGameServerGroupOutput$GameServerGroup' => '<p>An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated to reflect the resumed activity.</p>', 'SuspendGameServerGroupOutput$GameServerGroup' => '<p>An object that describes the game server group resource, with the <code>SuspendedActions</code> property updated to reflect the suspended activity.</p>', 'UpdateGameServerGroupOutput$GameServerGroup' => '<p>An object that describes the game server group resource with updated properties. </p>', ], ], 'GameServerGroupAction' => [ 'base' => NULL, 'refs' => [ 'GameServerGroupActions$member' => NULL, ], ], 'GameServerGroupActions' => [ 'base' => NULL, 'refs' => [ 'GameServerGroup$SuspendedActions' => '<p>A list of activities that are currently suspended for this game server group. If this property is empty, all activities are occurring.</p>', 'ResumeGameServerGroupInput$ResumeActions' => '<p>The activity to resume for this game server group.</p>', 'SuspendGameServerGroupInput$SuspendActions' => '<p>The activity to suspend for this game server group.</p>', ], ], 'GameServerGroupArn' => [ 'base' => NULL, 'refs' => [ 'GameServer$GameServerGroupArn' => '<p>The ARN identifier for the game server group where the game server is located.</p>', 'GameServerGroup$GameServerGroupArn' => '<p>A generated unique ID for the game server group.</p>', 'GameServerInstance$GameServerGroupArn' => '<p>A generated unique identifier for the game server group that includes the game server instance. </p>', ], ], 'GameServerGroupAutoScalingPolicy' => [ 'base' => '<p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p> <p>Configuration settings for intelligent automatic scaling that uses target tracking. These settings are used to add an Auto Scaling policy when creating the corresponding Auto Scaling group with <a>CreateGameServerGroup</a>. After the Auto Scaling group is created, all updates to Auto Scaling policies, including changing this policy and adding or removing other policies, is done directly on the Auto Scaling group. </p>', 'refs' => [ 'CreateGameServerGroupInput$AutoScalingPolicy' => '<p>Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. The scaling policy uses the metric <code>"PercentUtilizedGameServers"</code> to maintain a buffer of idle game servers that can immediately accommodate new games and players. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.</p>', ], ], 'GameServerGroupDeleteOption' => [ 'base' => NULL, 'refs' => [ 'DeleteGameServerGroupInput$DeleteOption' => '<p>The type of delete to perform. Options include the following:</p> <ul> <li> <p> <code>SAFE_DELETE</code> – (default) Terminates the game server group and Amazon EC2 Auto Scaling group only when it has no game servers that are in <code>UTILIZED</code> status.</p> </li> <li> <p> <code>FORCE_DELETE</code> – Terminates the game server group, including all active game servers regardless of their utilization status, and the Amazon EC2 Auto Scaling group. </p> </li> <li> <p> <code>RETAIN</code> – Does a safe delete of the game server group but retains the Amazon EC2 Auto Scaling group as is.</p> </li> </ul>', ], ], 'GameServerGroupInstanceType' => [ 'base' => NULL, 'refs' => [ 'InstanceDefinition$InstanceType' => '<p>An Amazon EC2 instance type designation.</p>', ], ], 'GameServerGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateGameServerGroupInput$GameServerGroupName' => '<p>An identifier for the new game server group. This value is used to generate unique ARN identifiers for the Amazon EC2 Auto Scaling group and the GameLift FleetIQ game server group. The name must be unique per Region per Amazon Web Services account.</p>', 'GameServer$GameServerGroupName' => '<p>A unique identifier for the game server group where the game server is running. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'GameServerGroup$GameServerGroupName' => '<p>A developer-defined identifier for the game server group. The name is unique for each Region in each Amazon Web Services account.</p>', 'GameServerInstance$GameServerGroupName' => '<p>A developer-defined identifier for the game server group that includes the game server instance. The name is unique for each Region in each Amazon Web Services account.</p>', ], ], 'GameServerGroupNameOrArn' => [ 'base' => NULL, 'refs' => [ 'ClaimGameServerInput$GameServerGroupName' => '<p>A unique identifier for the game server group where the game server is running. Use either the <a>GameServerGroup</a> name or ARN value. If you are not specifying a game server to claim, this value identifies where you want GameLift FleetIQ to look for an available game server to claim. </p>', 'DeleteGameServerGroupInput$GameServerGroupName' => '<p>A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'DeregisterGameServerInput$GameServerGroupName' => '<p>A unique identifier for the game server group where the game server is running. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'DescribeGameServerGroupInput$GameServerGroupName' => '<p>A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'DescribeGameServerInput$GameServerGroupName' => '<p>A unique identifier for the game server group where the game server is running. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'DescribeGameServerInstancesInput$GameServerGroupName' => '<p>A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'ListGameServersInput$GameServerGroupName' => '<p>An identifier for the game server group to retrieve a list of game servers from. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'RegisterGameServerInput$GameServerGroupName' => '<p>A unique identifier for the game server group where the game server is running. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'ResumeGameServerGroupInput$GameServerGroupName' => '<p>A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'SuspendGameServerGroupInput$GameServerGroupName' => '<p>A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'UpdateGameServerGroupInput$GameServerGroupName' => '<p>A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.</p>', 'UpdateGameServerInput$GameServerGroupName' => '<p>A unique identifier for the game server group where the game server is running. Use either the <a>GameServerGroup</a> name or ARN value.</p>', ], ], 'GameServerGroupStatus' => [ 'base' => NULL, 'refs' => [ 'GameServerGroup$Status' => '<p>The current status of the game server group. Possible statuses include:</p> <ul> <li> <p> <code>NEW</code> - GameLift FleetIQ has validated the <code>CreateGameServerGroup()</code> request. </p> </li> <li> <p> <code>ACTIVATING</code> - GameLift FleetIQ is setting up a game server group, which includes creating an Auto Scaling group in your Amazon Web Services account. </p> </li> <li> <p> <code>ACTIVE</code> - The game server group has been successfully created. </p> </li> <li> <p> <code>DELETE_SCHEDULED</code> - A request to delete the game server group has been received. </p> </li> <li> <p> <code>DELETING</code> - GameLift FleetIQ has received a valid <code>DeleteGameServerGroup()</code> request and is processing it. GameLift FleetIQ must first complete and release hosts before it deletes the Auto Scaling group and the game server group. </p> </li> <li> <p> <code>DELETED</code> - The game server group has been successfully deleted. </p> </li> <li> <p> <code>ERROR</code> - The asynchronous processes of activating or deleting a game server group has failed, resulting in an error state.</p> </li> </ul>', ], ], 'GameServerGroups' => [ 'base' => NULL, 'refs' => [ 'ListGameServerGroupsOutput$GameServerGroups' => '<p>A collection of game server group objects that match the request.</p>', ], ], 'GameServerHealthCheck' => [ 'base' => NULL, 'refs' => [ 'UpdateGameServerInput$HealthCheck' => '<p>Indicates health status of the game server. A request that includes this parameter updates the game server\'s <i>LastHealthCheckTime</i> timestamp. </p>', ], ], 'GameServerId' => [ 'base' => NULL, 'refs' => [ 'ClaimGameServerInput$GameServerId' => '<p>A custom string that uniquely identifies the game server to claim. If this parameter is left empty, GameLift FleetIQ searches for an available game server in the specified game server group.</p>', 'DeregisterGameServerInput$GameServerId' => '<p>A custom string that uniquely identifies the game server to deregister.</p>', 'DescribeGameServerInput$GameServerId' => '<p>A custom string that uniquely identifies the game server information to be retrieved.</p>', 'GameServer$GameServerId' => '<p>A custom string that uniquely identifies the game server. Game server IDs are developer-defined and are unique across all game server groups in an Amazon Web Services account.</p>', 'RegisterGameServerInput$GameServerId' => '<p>A custom string that uniquely identifies the game server to register. Game server IDs are developer-defined and must be unique across all game server groups in your Amazon Web Services account.</p>', 'UpdateGameServerInput$GameServerId' => '<p>A custom string that uniquely identifies the game server to update.</p>', ], ], 'GameServerInstance' => [ 'base' => '<p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p> <p> Additional properties, including status, that describe an EC2 instance in a game server group. Instance configurations are set with game server group properties (see <code>DescribeGameServerGroup</code> and with the EC2 launch template that was used when creating the game server group. </p> <p>Retrieve game server instances for a game server group by calling <code>DescribeGameServerInstances</code>. </p> <p> <b>Related actions</b> </p> <p> <a>CreateGameServerGroup</a> | <a>ListGameServerGroups</a> | <a>DescribeGameServerGroup</a> | <a>UpdateGameServerGroup</a> | <a>DeleteGameServerGroup</a> | <a>ResumeGameServerGroup</a> | <a>SuspendGameServerGroup</a> | <a>DescribeGameServerInstances</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task</a> </p>', 'refs' => [ 'GameServerInstances$member' => NULL, ], ], 'GameServerInstanceId' => [ 'base' => NULL, 'refs' => [ 'GameServer$InstanceId' => '<p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>', 'GameServerInstance$InstanceId' => '<p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>', 'GameServerInstanceIds$member' => NULL, 'RegisterGameServerInput$InstanceId' => '<p>The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>.</p>', ], ], 'GameServerInstanceIds' => [ 'base' => NULL, 'refs' => [ 'DescribeGameServerInstancesInput$InstanceIds' => '<p>The Amazon EC2 instance IDs that you want to retrieve status on. Amazon EC2 instance IDs use a 17-character format, for example: <code>i-1234567890abcdef0</code>. To retrieve all instances in the game server group, leave this parameter empty. </p>', ], ], 'GameServerInstanceStatus' => [ 'base' => NULL, 'refs' => [ 'GameServerInstance$InstanceStatus' => '<p> Current status of the game server instance. </p> <ul> <li> <p> <b>ACTIVE</b> -- The instance is viable for hosting game servers. </p> </li> <li> <p> <b>DRAINING</b> -- The instance is not viable for hosting game servers. Existing game servers are in the process of ending, and new game servers are not started on this instance unless no other resources are available. When the instance is put in DRAINING, a new instance is started up to replace it. Once the instance has no UTILIZED game servers, it will be terminated in favor of the new instance.</p> </li> <li> <p> <b>SPOT_TERMINATING</b> -- The instance is in the process of shutting down due to a Spot instance interruption. No new game servers are started on this instance.</p> </li> </ul>', ], ], 'GameServerInstances' => [ 'base' => NULL, 'refs' => [ 'DescribeGameServerInstancesOutput$GameServerInstances' => '<p> The collection of requested game server instances. </p>', ], ], 'GameServerProtectionPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateGameServerGroupInput$GameServerProtectionPolicy' => '<p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.</p>', 'GameServerGroup$GameServerProtectionPolicy' => '<p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. </p>', 'UpdateGameServerGroupInput$GameServerProtectionPolicy' => '<p>A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This property is set to <code>NO_PROTECTION</code> by default.</p>', ], ], 'GameServerUtilizationStatus' => [ 'base' => NULL, 'refs' => [ 'GameServer$UtilizationStatus' => '<p>Indicates whether the game server is currently available for new games or is busy. Possible statuses include:</p> <ul> <li> <p> <code>AVAILABLE</code> - The game server is available to be claimed. A game server that has been claimed remains in this status until it reports game hosting activity. </p> </li> <li> <p> <code>UTILIZED</code> - The game server is currently hosting a game session with players. </p> </li> </ul>', 'UpdateGameServerInput$UtilizationStatus' => '<p>Indicates whether the game server is available or is currently hosting gameplay.</p>', ], ], 'GameServers' => [ 'base' => NULL, 'refs' => [ 'ListGameServersOutput$GameServers' => '<p>A collection of game server objects that match the request.</p>', ], ], 'GameSession' => [ 'base' => '<p>Properties describing a game session.</p> <p>A game session in ACTIVE status can host players. When a game session ends, its status is set to <code>TERMINATED</code>. </p> <p>Once the session ends, the game session object is retained for 30 days. This means you can reuse idempotency token values after this time. Game session logs are retained for 14 days.</p> <p> <b>Related actions</b> </p> <p> <a>CreateGameSession</a> | <a>DescribeGameSessions</a> | <a>DescribeGameSessionDetails</a> | <a>SearchGameSessions</a> | <a>UpdateGameSession</a> | <a>GetGameSessionLogUrl</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'CreateGameSessionOutput$GameSession' => '<p>Object that describes the newly created game session record.</p>', 'GameSessionDetail$GameSession' => '<p>Object that describes a game session.</p>', 'GameSessionList$member' => NULL, 'UpdateGameSessionOutput$GameSession' => '<p>The updated game session properties.</p>', ], ], 'GameSessionActivationTimeoutSeconds' => [ 'base' => NULL, 'refs' => [ 'RuntimeConfiguration$GameSessionActivationTimeoutSeconds' => '<p>The maximum amount of time (in seconds) allowed to launch a new game session and have it report ready to host players. During this time, the game session is in status <code>ACTIVATING</code>. If the game session does not become active before the timeout, it is ended and the game session status is changed to <code>TERMINATED</code>.</p>', ], ], 'GameSessionConnectionInfo' => [ 'base' => '<p>Connection information for a new game session that is created in response to a <a>StartMatchmaking</a> request. Once a match is made, the FlexMatch engine creates a new game session for it. This information, including the game session endpoint and player sessions for each player in the original matchmaking request, is added to the <a>MatchmakingTicket</a>, which can be retrieved by calling <a>DescribeMatchmaking</a>.</p>', 'refs' => [ 'MatchmakingTicket$GameSessionConnectionInfo' => '<p>Identifier and connection information of the game session created for the match. This information is added to the ticket only after the matchmaking request has been successfully completed. This parameter is not set when FlexMatch is being used without GameLift hosting.</p>', ], ], 'GameSessionData' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$GameSessionData' => '<p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', 'MatchmakingConfiguration$GameSessionData' => '<p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', 'UpdateMatchmakingConfigurationInput$GameSessionData' => '<p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>). This information is added to the new <a>GameSession</a> object that is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', ], ], 'GameSessionDetail' => [ 'base' => '<p>A game session\'s properties plus the protection policy currently in force.</p>', 'refs' => [ 'GameSessionDetailList$member' => NULL, ], ], 'GameSessionDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeGameSessionDetailsOutput$GameSessionDetails' => '<p>A collection of properties for each game session that matches the request.</p>', ], ], 'GameSessionFullException' => [ 'base' => '<p>The game instance is currently full and cannot allow the requested player(s) to join. Clients can retry such requests immediately or after a waiting period.</p>', 'refs' => [], ], 'GameSessionList' => [ 'base' => NULL, 'refs' => [ 'DescribeGameSessionsOutput$GameSessions' => '<p>A collection of properties for each game session that matches the request.</p>', 'SearchGameSessionsOutput$GameSessions' => '<p>A collection of objects containing game session properties for each session that matches the request.</p>', ], ], 'GameSessionPlacement' => [ 'base' => '<p>Object that describes a <a>StartGameSessionPlacement</a> request. This object includes the full details of the original request plus the current status and start/end time stamps.</p> <p>Game session placement-related operations include:</p> <ul> <li> <p> <a>StartGameSessionPlacement</a> </p> </li> <li> <p> <a>DescribeGameSessionPlacement</a> </p> </li> <li> <p> <a>StopGameSessionPlacement</a> </p> </li> </ul>', 'refs' => [ 'DescribeGameSessionPlacementOutput$GameSessionPlacement' => '<p>Object that describes the requested game session placement.</p>', 'StartGameSessionPlacementOutput$GameSessionPlacement' => '<p>Object that describes the newly created game session placement. This object includes all the information provided in the request, as well as start/end time stamps and placement status. </p>', 'StopGameSessionPlacementOutput$GameSessionPlacement' => '<p>Object that describes the canceled game session placement, with <code>CANCELLED</code> status and an end time stamp. </p>', ], ], 'GameSessionPlacementState' => [ 'base' => NULL, 'refs' => [ 'GameSessionPlacement$Status' => '<p>Current status of the game session placement request.</p> <ul> <li> <p> <b>PENDING</b> -- The placement request is currently in the queue waiting to be processed.</p> </li> <li> <p> <b>FULFILLED</b> -- A new game session and player sessions (if requested) have been successfully created. Values for <i>GameSessionArn</i> and <i>GameSessionRegion</i> are available. </p> </li> <li> <p> <b>CANCELLED</b> -- The placement request was canceled with a call to <a>StopGameSessionPlacement</a>.</p> </li> <li> <p> <b>TIMED_OUT</b> -- A new game session was not successfully created before the time limit expired. You can resubmit the placement request as needed.</p> </li> <li> <p> <b>FAILED</b> -- GameLift is not able to complete the process of placing the game session. Common reasons are the game session terminated before the placement process was completed, or an unexpected internal error.</p> </li> </ul>', ], ], 'GameSessionQueue' => [ 'base' => '<p>Configuration for a game session placement mechanism that processes requests for new game sessions. A queue can be used on its own or as part of a matchmaking solution.</p> <p> <b>Related actions</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">CreateGameSessionQueue</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html">DescribeGameSessionQueues</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html">UpdateGameSessionQueue</a> </p>', 'refs' => [ 'CreateGameSessionQueueOutput$GameSessionQueue' => '<p>An object that describes the newly created game session queue.</p>', 'GameSessionQueueList$member' => NULL, 'UpdateGameSessionQueueOutput$GameSessionQueue' => '<p>An object that describes the newly updated game session queue.</p>', ], ], 'GameSessionQueueArn' => [ 'base' => NULL, 'refs' => [ 'GameSessionQueue$GameSessionQueueArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code>. In a GameLift game session queue ARN, the resource ID matches the <i>Name</i> value.</p>', ], ], 'GameSessionQueueDestination' => [ 'base' => '<p>A fleet or alias designated in a game session queue. Queues fulfill requests for new game sessions by placing a new game session on any of the queue\'s destinations. </p> <p>Destinations are part of a <a>GameSessionQueue</a>.</p>', 'refs' => [ 'GameSessionQueueDestinationList$member' => NULL, ], ], 'GameSessionQueueDestinationList' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionQueueInput$Destinations' => '<p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.</p>', 'GameSessionQueue$Destinations' => '<p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference.</p>', 'UpdateGameSessionQueueInput$Destinations' => '<p>A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference. When updating this list, provide a complete list of destinations.</p>', ], ], 'GameSessionQueueList' => [ 'base' => NULL, 'refs' => [ 'DescribeGameSessionQueuesOutput$GameSessionQueues' => '<p>A collection of objects that describe the requested game session queues.</p>', ], ], 'GameSessionQueueName' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionQueueInput$Name' => '<p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>', 'GameSessionPlacement$GameSessionQueueName' => '<p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>', 'GameSessionQueue$Name' => '<p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region.</p>', ], ], 'GameSessionQueueNameOrArn' => [ 'base' => NULL, 'refs' => [ 'DeleteGameSessionQueueInput$Name' => '<p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value. </p>', 'GameSessionQueueNameOrArnList$member' => NULL, 'StartGameSessionPlacementInput$GameSessionQueueName' => '<p>Name of the queue to use to place the new game session. You can use either the queue name or ARN value. </p>', 'UpdateGameSessionQueueInput$Name' => '<p>A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value. </p>', ], ], 'GameSessionQueueNameOrArnList' => [ 'base' => NULL, 'refs' => [ 'DescribeGameSessionQueuesInput$Names' => '<p>A list of queue names to retrieve information for. You can use either the queue ID or ARN value. To request settings for all queues, leave this parameter empty. </p>', ], ], 'GameSessionStatus' => [ 'base' => NULL, 'refs' => [ 'GameSession$Status' => '<p>Current status of the game session. A game session must have an <code>ACTIVE</code> status to have player sessions.</p>', ], ], 'GameSessionStatusReason' => [ 'base' => NULL, 'refs' => [ 'GameSession$StatusReason' => '<p>Provides additional information about game session status. <code>INTERRUPTED</code> indicates that the game session was hosted on a spot instance that was reclaimed, causing the active game session to be terminated.</p>', ], ], 'GetGameSessionLogUrlInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'GetGameSessionLogUrlOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'GetInstanceAccessInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'GetInstanceAccessOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateGameServerGroupInput$RoleArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon Web Services to access your Amazon EC2 Auto Scaling groups.</p>', 'GameServerGroup$RoleArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon Web Services to access your Amazon EC2 Auto Scaling groups.</p>', 'UpdateGameServerGroupInput$RoleArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon Web Services to access your Amazon EC2 Auto Scaling groups.</p>', ], ], 'IdStringModel' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionInput$GameSessionId' => '<p> <i>This parameter is no longer preferred. Please use <code>IdempotencyToken</code> instead.</i> Custom string that uniquely identifies a request for a new game session. Maximum token length is 48 characters. If provided, this string is included in the new game session\'s ID.</p>', 'CreateGameSessionInput$IdempotencyToken' => '<p>Custom string that uniquely identifies the new game session request. This is useful for ensuring that game session requests with the same idempotency token are processed only once. Subsequent requests with the same string return the original <code>GameSession</code> object, with an updated status. Maximum token length is 48 characters. If provided, this string is included in the new game session\'s ID. A game session ARN has the following format: <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>. Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are retained for this time period and then deleted.</p>', 'DescribeGameSessionPlacementInput$PlacementId' => '<p>A unique identifier for a game session placement to retrieve.</p>', 'GameSessionPlacement$PlacementId' => '<p>A unique identifier for a game session placement.</p>', 'StartGameSessionPlacementInput$PlacementId' => '<p>A unique identifier to assign to the new game session placement. This value is developer-defined. The value must be unique across all Regions and cannot be reused unless you are resubmitting a canceled or timed-out placement request.</p>', 'StopGameSessionPlacementInput$PlacementId' => '<p>A unique identifier for a game session placement to cancel.</p>', ], ], 'IdempotentParameterMismatchException' => [ 'base' => '<p>A game session with this custom ID string already exists in this fleet. Resolve this conflict before retrying this request.</p>', 'refs' => [], ], 'Instance' => [ 'base' => '<p>Represents an EC2 instance of virtual computing resources that hosts one or more game servers. In GameLift, a fleet can contain zero or more instances.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeInstances</a> </p>', 'refs' => [ 'InstanceList$member' => NULL, ], ], 'InstanceAccess' => [ 'base' => '<p>Information required to remotely connect to a fleet instance. Access is requested by calling <a>GetInstanceAccess</a>. </p>', 'refs' => [ 'GetInstanceAccessOutput$InstanceAccess' => '<p>The connection information for a fleet instance, including IP address and access credentials.</p>', ], ], 'InstanceCredentials' => [ 'base' => '<p>Set of credentials required to remotely access a fleet instance. Access credentials are requested by calling <a>GetInstanceAccess</a> and returned in an <a>InstanceAccess</a> object.</p>', 'refs' => [ 'InstanceAccess$Credentials' => '<p>Credentials required to access the instance.</p>', ], ], 'InstanceDefinition' => [ 'base' => '<p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p> <p>An allowed instance type for a <a>GameServerGroup</a>. All game server groups must have at least two instance types defined for it. GameLift FleetIQ periodically evaluates each defined instance type for viability. It then updates the Auto Scaling group with the list of viable instance types.</p>', 'refs' => [ 'InstanceDefinitions$member' => NULL, ], ], 'InstanceDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateGameServerGroupInput$InstanceDefinitions' => '<p>The Amazon EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify at least two different instance types that are supported by GameLift FleetIQ. For more information on instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. You can optionally specify capacity weighting for each instance type. If no weight value is specified for an instance type, it is set to the default value "1". For more information about capacity weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.</p>', 'GameServerGroup$InstanceDefinitions' => '<p>The set of Amazon EC2 instance types that GameLift FleetIQ can use when balancing and automatically scaling instances in the corresponding Auto Scaling group. </p>', 'UpdateGameServerGroupInput$InstanceDefinitions' => '<p>An updated list of Amazon EC2 instance types to use in the Auto Scaling group. The instance definitions must specify at least two different instance types that are supported by GameLift FleetIQ. This updated list replaces the entire current list of instance definitions for the game server group. For more information on instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">EC2 Instance Types</a> in the <i>Amazon EC2 User Guide</i>. You can optionally specify capacity weighting for each instance type. If no weight value is specified for an instance type, it is set to the default value "1". For more information about capacity weighting, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html"> Instance Weighting for Amazon EC2 Auto Scaling</a> in the Amazon EC2 Auto Scaling User Guide.</p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancesInput$InstanceId' => '<p>A unique identifier for an instance to retrieve. Specify an instance ID or leave blank to retrieve all instances in the fleet.</p>', 'GetInstanceAccessInput$InstanceId' => '<p>A unique identifier for the instance you want to get access to. You can access an instance in any status.</p>', 'Instance$InstanceId' => '<p>A unique identifier for the instance.</p>', 'InstanceAccess$InstanceId' => '<p>A unique identifier for the instance being accessed.</p>', ], ], 'InstanceList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancesOutput$Instances' => '<p>A collection of objects containing properties for each instance returned.</p>', ], ], 'InstanceStatus' => [ 'base' => NULL, 'refs' => [ 'Instance$Status' => '<p>Current status of the instance. Possible statuses include the following:</p> <ul> <li> <p> <b>PENDING</b> -- The instance is in the process of being created and launching server processes as defined in the fleet\'s run-time configuration. </p> </li> <li> <p> <b>ACTIVE</b> -- The instance has been successfully created and at least one server process has successfully launched and reported back to GameLift that it is ready to host a game session. The instance is now considered ready to host game sessions. </p> </li> <li> <p> <b>TERMINATING</b> -- The instance is in the process of shutting down. This may happen to reduce capacity during a scaling down event or to recycle resources in the event of a problem.</p> </li> </ul>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$ScalingAdjustment' => '<p>Amount of adjustment to make, based on the scaling adjustment type.</p>', 'ScalingPolicy$ScalingAdjustment' => '<p>Amount of adjustment to make, based on the scaling adjustment type.</p>', ], ], 'InternalServiceException' => [ 'base' => '<p>The service encountered an unrecoverable internal failure while processing the request. Clients can retry such requests immediately or after a waiting period.</p>', 'refs' => [], ], 'InvalidFleetStatusException' => [ 'base' => '<p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</p>', 'refs' => [], ], 'InvalidGameSessionStatusException' => [ 'base' => '<p>The requested operation would cause a conflict with the current state of a resource associated with the request and/or the game instance. Resolve the conflict before retrying.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>One or more parameter values in the request are invalid. Correct the invalid parameter values before retrying.</p>', 'refs' => [], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'GameSession$IpAddress' => '<p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>', 'GameSessionPlacement$IpAddress' => '<p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). </p>', 'Instance$IpAddress' => '<p>IP address that is assigned to the instance.</p>', 'InstanceAccess$IpAddress' => '<p>IP address that is assigned to the instance.</p>', 'PlayerSession$IpAddress' => '<p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>', ], ], 'IpPermission' => [ 'base' => '<p>A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an instance in a fleet. New game sessions are assigned an IP address/port number combination, which must fall into the fleet\'s allowed ranges. Fleets with custom game builds must have permissions explicitly set. For Realtime Servers fleets, GameLift automatically opens two port ranges, one for TCP messaging and one for UDP.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeFleetPortSettings</a> </p>', 'refs' => [ 'IpPermissionsList$member' => NULL, ], ], 'IpPermissionsList' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$EC2InboundPermissions' => '<p>The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet. If the fleet is hosting a custom game build, this property must be set before players can connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges. </p>', 'DescribeFleetPortSettingsOutput$InboundPermissions' => '<p>The port settings for the requested fleet ID.</p>', 'UpdateFleetPortSettingsInput$InboundPermissionAuthorizations' => '<p>A collection of port settings to be added to the fleet resource.</p>', 'UpdateFleetPortSettingsInput$InboundPermissionRevocations' => '<p>A collection of port settings to be removed from the fleet resource.</p>', ], ], 'IpProtocol' => [ 'base' => NULL, 'refs' => [ 'IpPermission$Protocol' => '<p>The network communication protocol used by the fleet.</p>', ], ], 'LargeGameSessionData' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionInput$GameSessionData' => '<p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'GameSession$GameSessionData' => '<p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'GameSessionPlacement$GameSessionData' => '<p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', 'StartGameSessionPlacementInput$GameSessionData' => '<p>A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a>).</p>', ], ], 'LatencyMap' => [ 'base' => NULL, 'refs' => [ 'Player$LatencyInMs' => '<p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions. If this property is present, FlexMatch considers placing the match only in Regions for which latency is reported. </p> <p>If a matchmaker has a rule that evaluates player latency, players must report latency in order to be matched. If no latency is reported in this scenario, FlexMatch assumes that no Regions are available to the player and the ticket is not matchable. </p>', ], ], 'LaunchParametersStringModel' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$ServerLaunchParameters' => '<p> <b>This parameter is no longer used.</b> Specify server launch parameters using the <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>', 'FleetAttributes$ServerLaunchParameters' => '<p> <b>This parameter is no longer used.</b> Server launch parameters are now defined using the fleet\'s <a>RuntimeConfiguration</a> parameter. Requests that use this parameter instead continue to be valid.</p>', 'ServerProcess$Parameters' => '<p>An optional list of parameters to pass to the server executable or Realtime script on launch.</p>', ], ], 'LaunchPathStringModel' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$ServerLaunchPath' => '<p> <b>This parameter is no longer used.</b> Specify a server launch path using the <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.</p>', 'FleetAttributes$ServerLaunchPath' => '<p> <b>This parameter is no longer used.</b> Server launch paths are now defined using the fleet\'s <a>RuntimeConfiguration</a> parameter. Requests that use this parameter instead continue to be valid.</p>', 'ServerProcess$LaunchPath' => '<p>The location of a game build executable or the Realtime script file that contains the <code>Init()</code> function. Game builds and Realtime scripts are installed on instances at the root: </p> <ul> <li> <p>Windows (custom game builds only): <code>C:\\game</code>. Example: "<code>C:\\game\\MyGame\\server.exe</code>" </p> </li> <li> <p>Linux: <code>/local/game</code>. Examples: "<code>/local/game/MyGame/server.exe</code>" or "<code>/local/game/MyRealtimeScript.js</code>"</p> </li> </ul>', ], ], 'LaunchTemplateId' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateSpecification$LaunchTemplateId' => '<p>A unique identifier for an existing Amazon EC2 launch template.</p>', ], ], 'LaunchTemplateName' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateSpecification$LaunchTemplateName' => '<p>A readable identifier for an existing Amazon EC2 launch template. </p>', ], ], 'LaunchTemplateSpecification' => [ 'base' => '<p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p> <p>An Amazon EC2 launch template that contains configuration settings and game server code to be deployed to all instances in a game server group. The launch template is specified when creating a new game server group with <a>CreateGameServerGroup</a>. </p>', 'refs' => [ 'CreateGameServerGroupInput$LaunchTemplate' => '<p>The Amazon EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. You can specify the template using either the template name or ID. For help with creating a launch template, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a Launch Template for an Auto Scaling Group</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User Guide</i>. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.</p> <note> <p>If you specify network interfaces in your launch template, you must explicitly set the property <code>AssociatePublicIpAddress</code> to "true". If no network interface is specified in the launch template, GameLift FleetIQ uses your account\'s default VPC.</p> </note>', ], ], 'LaunchTemplateVersion' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateSpecification$Version' => '<p>The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon Elastic Compute Cloud, you can specify a default version for a launch template. If none is set, the default is the first version created.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The requested operation would cause the resource to exceed the allowed service limit. Resolve the issue before retrying.</p>', 'refs' => [], ], 'ListAliasesInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'ListAliasesOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'ListBuildsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'ListBuildsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'ListFleetsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'ListFleetsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'ListGameServerGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListGameServerGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListGameServersInput' => [ 'base' => NULL, 'refs' => [], ], 'ListGameServersOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListScriptsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListScriptsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LocationAttributes' => [ 'base' => '<p>Represents a location in a multi-location fleet.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeFleetLocationAttributes</a> </p>', 'refs' => [ 'LocationAttributesList$member' => NULL, ], ], 'LocationAttributesList' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetLocationAttributesOutput$LocationAttributes' => '<p> Location-specific information on the requested fleet\'s remote locations. </p>', ], ], 'LocationConfiguration' => [ 'base' => '<p>A remote location where a multi-location fleet can deploy EC2 instances for game hosting. </p> <p> <b>Related actions</b> </p> <p> <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateFleet.html">CreateFleet</a> </p>', 'refs' => [ 'LocationConfigurationList$member' => NULL, ], ], 'LocationConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$Locations' => '<p>A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter can only be used when creating fleets in Amazon Web Services Regions that support multiple locations. You can add any GameLift-supported Amazon Web Services Region as a remote location, in the form of an Amazon Web Services Region code such as <code>us-west-2</code>. To create a fleet with instances in the home Region only, omit this parameter. </p>', 'CreateFleetLocationsInput$Locations' => '<p>A list of locations to deploy additional instances to and manage as part of the fleet. You can add any GameLift-supported Amazon Web Services Region as a remote location, in the form of an Amazon Web Services Region code such as <code>us-west-2</code>. </p>', ], ], 'LocationList' => [ 'base' => NULL, 'refs' => [ 'DeleteFleetLocationsInput$Locations' => '<p>The list of fleet locations to delete. Specify locations in the form of an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>', 'DescribeFleetLocationAttributesInput$Locations' => '<p>A list of fleet locations to retrieve information for. Specify locations in the form of an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>', 'FilterConfiguration$AllowedLocations' => '<p> A list of locations to allow game session placement in, in the form of Amazon Web Services Region codes such as <code>us-west-2</code>. </p>', 'PriorityConfiguration$LocationOrder' => '<p>The prioritization order to use for fleet locations, when the <code>PriorityOrder</code> property includes <code>LOCATION</code>. Locations are identified by Amazon Web Services Region codes such as <code>us-west-2</code>. Each location can only be listed once. </p>', ], ], 'LocationState' => [ 'base' => '<p>A fleet location and its life-cycle state. A location state object might be used to describe a fleet\'s remote location or home Region. Life-cycle state tracks the progress of launching the first instance in a new location and preparing it for game hosting, and then removing all instances and deleting the location from the fleet.</p> <p> <b>Related actions</b> </p> <p> <a>CreateFleet</a> | <a>CreateFleetLocations</a> | <a>DeleteFleetLocations</a> </p>', 'refs' => [ 'LocationAttributes$LocationState' => '<p>A fleet location and its current life-cycle state.</p>', 'LocationStateList$member' => NULL, ], ], 'LocationStateList' => [ 'base' => NULL, 'refs' => [ 'CreateFleetLocationsOutput$LocationStates' => '<p>The remote locations that are being added to the fleet, and the life-cycle status of each location. For new locations, the status is set to <code>NEW</code>. During location creation, GameLift updates each location\'s status as instances are deployed there and prepared for game hosting. This list does not include the fleet home Region or any remote locations that were already added to the fleet.</p>', 'CreateFleetOutput$LocationStates' => '<p>The fleet\'s locations and life-cycle status of each location. For new fleets, the status of all locations is set to <code>NEW</code>. During fleet creation, GameLift updates each location status as instances are deployed there and prepared for game hosting. This list includes an entry for the fleet\'s home Region. For fleets with no remote locations, only one entry, representing the home Region, is returned.</p>', 'DeleteFleetLocationsOutput$LocationStates' => '<p>The remote locations that are being deleted, with each location status set to <code>DELETING</code>.</p>', ], ], 'LocationStringModel' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionInput$Location' => '<p>A fleet\'s remote location to place the new game session in. If this parameter is not set, the new game session is placed in the fleet\'s home Region. Specify a remote location with an Amazon Web Services Region code such as <code>us-west-2</code>. </p>', 'DescribeEC2InstanceLimitsInput$Location' => '<p>The name of a remote location to request instance limits for, in the form of an Amazon Web Services Region code such as <code>us-west-2</code>.</p>', 'DescribeFleetLocationCapacityInput$Location' => '<p>The fleet location to retrieve capacity information for. Specify a location in the form of an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>', 'DescribeFleetLocationUtilizationInput$Location' => '<p>The fleet location to retrieve utilization information for. Specify a location in the form of an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>', 'DescribeFleetPortSettingsInput$Location' => '<p>A remote location to check for status of port setting updates. Use the Amazon Web Services Region code format, such as <code>us-west-2</code>.</p>', 'DescribeFleetPortSettingsOutput$Location' => '<p>The requested fleet location, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>', 'DescribeGameSessionDetailsInput$Location' => '<p>A fleet location to get game sessions for. You can specify a fleet\'s home Region or a remote location. Use the Amazon Web Services Region code format, such as <code>us-west-2</code>. </p>', 'DescribeGameSessionsInput$Location' => '<p>A fleet location to get game session details for. You can specify a fleet\'s home Region or a remote location. Use the Amazon Web Services Region code format, such as <code>us-west-2</code>. </p>', 'DescribeInstancesInput$Location' => '<p>The name of a location to retrieve instance information for, in the form of an Amazon Web Services Region code such as <code>us-west-2</code>. </p>', 'DescribeScalingPoliciesInput$Location' => '<p> The fleet location. If you don\'t specify this value, the response contains the scaling policies of every location in the fleet. </p>', 'EC2InstanceLimit$Location' => '<p>An Amazon Web Services Region code, such as <code>us-west-2</code>. </p>', 'FleetCapacity$Location' => '<p>The fleet location for the instance count information, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>', 'FleetUtilization$Location' => '<p>The fleet location for the fleet utilization information, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>', 'GameSession$Location' => '<p>The fleet location where the game session is running. This value might specify the fleet\'s home Region or a remote location. Location is expressed as an Amazon Web Services Region code such as <code>us-west-2</code>. </p>', 'Instance$Location' => '<p>The fleet location of the instance, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>. </p>', 'LocationConfiguration$Location' => '<p>An Amazon Web Services Region code, such as <code>us-west-2</code>. </p>', 'LocationList$member' => NULL, 'LocationState$Location' => '<p>The fleet location, expressed as an Amazon Web Services Region code such as <code>us-west-2</code>. </p>', 'ScalingPolicy$Location' => '<p> The fleet location. </p>', 'SearchGameSessionsInput$Location' => '<p>A fleet location to search for game sessions. You can specify a fleet\'s home Region or a remote location. Use the Amazon Web Services Region code format, such as <code>us-west-2</code>. </p> <p> </p>', 'StartFleetActionsInput$Location' => '<p>The fleet location to restart fleet actions for. Specify a location in the form of an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>', 'StopFleetActionsInput$Location' => '<p>The fleet location to stop fleet actions for. Specify a location in the form of an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>', 'UpdateFleetCapacityInput$Location' => '<p>The name of a remote location to update fleet capacity settings for, in the form of an Amazon Web Services Region code such as <code>us-west-2</code>.</p>', 'UpdateFleetCapacityOutput$Location' => '<p>The remote location being updated, expressed as an Amazon Web Services Region code, such as <code>us-west-2</code>.</p>', ], ], 'LocationUpdateStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetPortSettingsOutput$UpdateStatus' => '<p>The current status of updates to the fleet\'s port settings in the requested fleet location. A status of <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.</p>', 'LocationAttributes$UpdateStatus' => '<p>The status of fleet activity updates to the location. The status <code>PENDING_UPDATE</code> indicates that <a>StopFleetActions</a> or <a>StartFleetActions</a> has been requested but the update has not yet been completed for the location.</p>', 'ScalingPolicy$UpdateStatus' => '<p>The current status of the fleet\'s scaling policies in a requested fleet location. The status <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.</p>', ], ], 'MatchedPlayerSession' => [ 'base' => '<p>Represents a new player session that is created as a result of a successful FlexMatch match. A successful match automatically creates new player sessions for every player ID in the original matchmaking request. </p> <p>When players connect to the match\'s game session, they must include both player ID and player session ID in order to claim their assigned player slot.</p>', 'refs' => [ 'MatchedPlayerSessionList$member' => NULL, ], ], 'MatchedPlayerSessionList' => [ 'base' => NULL, 'refs' => [ 'GameSessionConnectionInfo$MatchedPlayerSessions' => '<p>A collection of player session IDs, one for each player ID that was included in the original matchmaking request. </p>', ], ], 'MatchmakerData' => [ 'base' => NULL, 'refs' => [ 'GameSession$MatchmakerData' => '<p>Information about the matchmaking process that was used to create the game session. It is in JSON syntax, formatted as a string. In addition the matchmaking configuration used, it contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">Match Data</a>. Matchmaker data is useful when requesting match backfills, and is updated whenever new players are added during a successful backfill (see <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchBackfill.html">StartMatchBackfill</a>). </p>', 'GameSessionPlacement$MatchmakerData' => '<p>Information on the matchmaking process for this game. Data is in JSON syntax, formatted as a string. It identifies the matchmaking configuration used to create the match, and contains data on all players assigned to the match, including player attributes and team assignments. For more details on matchmaker data, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">Match Data</a>.</p>', ], ], 'MatchmakingAcceptanceTimeoutInteger' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$AcceptanceTimeoutSeconds' => '<p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. </p>', 'MatchmakingConfiguration$AcceptanceTimeoutSeconds' => '<p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. If any player rejects the match or fails to accept before the timeout, the ticket continues to look for an acceptable match.</p>', 'UpdateMatchmakingConfigurationInput$AcceptanceTimeoutSeconds' => '<p>The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.</p>', ], ], 'MatchmakingConfiguration' => [ 'base' => '<p>Guidelines for use with FlexMatch to match players into games. All matchmaking requests must specify a matchmaking configuration.</p>', 'refs' => [ 'CreateMatchmakingConfigurationOutput$Configuration' => '<p>Object that describes the newly created matchmaking configuration.</p>', 'MatchmakingConfigurationList$member' => NULL, 'UpdateMatchmakingConfigurationOutput$Configuration' => '<p>The updated matchmaking configuration.</p>', ], ], 'MatchmakingConfigurationArn' => [ 'base' => 'Data type used for Matchmaking Configuration ARN.', 'refs' => [ 'MatchmakingConfiguration$ConfigurationArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift matchmaking configuration resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::matchmakingconfiguration/&lt;matchmaking configuration name&gt;</code>. In a GameLift configuration ARN, the resource ID matches the <i>Name</i> value.</p>', 'MatchmakingTicket$ConfigurationArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift matchmaking configuration resource that is used with this ticket.</p>', ], ], 'MatchmakingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingConfigurationsOutput$Configurations' => '<p>A collection of requested matchmaking configurations.</p>', ], ], 'MatchmakingConfigurationName' => [ 'base' => NULL, 'refs' => [ 'DeleteMatchmakingConfigurationInput$Name' => '<p>A unique identifier for the matchmaking configuration. You can use either the configuration name or ARN value.</p>', 'MatchmakingConfigurationNameList$member' => NULL, 'StartMatchBackfillInput$ConfigurationName' => '<p>Name of the matchmaker to use for this request. You can use either the configuration name or ARN value. The ARN of the matchmaker that was used with the original game session is listed in the <a>GameSession</a> object, <code>MatchmakerData</code> property.</p>', 'StartMatchmakingInput$ConfigurationName' => '<p>Name of the matchmaking configuration to use for this request. Matchmaking configurations must exist in the same Region as this request. You can use either the configuration name or ARN value.</p>', 'UpdateMatchmakingConfigurationInput$Name' => '<p>A unique identifier for the matchmaking configuration to update. You can use either the configuration name or ARN value. </p>', ], ], 'MatchmakingConfigurationNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingConfigurationsInput$Names' => '<p>A unique identifier for the matchmaking configuration(s) to retrieve. You can use either the configuration name or ARN value. To request all existing configurations, leave this parameter empty.</p>', ], ], 'MatchmakingConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'MatchmakingTicket$Status' => '<p>Current status of the matchmaking request.</p> <ul> <li> <p> <b>QUEUED</b> -- The matchmaking request has been received and is currently waiting to be processed.</p> </li> <li> <p> <b>SEARCHING</b> -- The matchmaking request is currently being processed. </p> </li> <li> <p> <b>REQUIRES_ACCEPTANCE</b> -- A match has been proposed and the players must accept the match (see <a>AcceptMatch</a>). This status is used only with requests that use a matchmaking configuration with a player acceptance requirement.</p> </li> <li> <p> <b>PLACING</b> -- The FlexMatch engine has matched players and is in the process of placing a new game session for the match.</p> </li> <li> <p> <b>COMPLETED</b> -- Players have been matched and a game session is ready to host the players. A ticket in this state contains the necessary connection information for players.</p> </li> <li> <p> <b>FAILED</b> -- The matchmaking request was not completed.</p> </li> <li> <p> <b>CANCELLED</b> -- The matchmaking request was canceled. This may be the result of a call to <a>StopMatchmaking</a> or a proposed match that one or more players failed to accept.</p> </li> <li> <p> <b>TIMED_OUT</b> -- The matchmaking request was not successful within the duration specified in the matchmaking configuration. </p> </li> </ul> <note> <p>Matchmaking requests that fail to successfully complete (statuses FAILED, CANCELLED, TIMED_OUT) can be resubmitted as new requests with new ticket IDs.</p> </note>', ], ], 'MatchmakingIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingInput$TicketIds' => '<p>A unique identifier for a matchmaking ticket. You can include up to 10 ID values. </p>', ], ], 'MatchmakingIdStringModel' => [ 'base' => NULL, 'refs' => [ 'AcceptMatchInput$TicketId' => '<p>A unique identifier for a matchmaking ticket. The ticket must be in status <code>REQUIRES_ACCEPTANCE</code>; otherwise this request will fail.</p>', 'CreateMatchmakingConfigurationInput$Name' => '<p>A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.</p>', 'CreateMatchmakingRuleSetInput$Name' => '<p>A unique identifier for the matchmaking rule set. A matchmaking configuration identifies the rule set it uses by this name value. Note that the rule set name is different from the optional <code>name</code> field in the rule set body.</p>', 'MatchmakingConfiguration$Name' => '<p>A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a matchmaking request or ticket.</p>', 'MatchmakingConfiguration$RuleSetName' => '<p>A unique identifier for the matchmaking rule set to use with this configuration. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>', 'MatchmakingIdList$member' => NULL, 'MatchmakingRuleSet$RuleSetName' => '<p>A unique identifier for the matchmaking rule set</p>', 'MatchmakingTicket$TicketId' => '<p>A unique identifier for a matchmaking ticket.</p>', 'MatchmakingTicket$ConfigurationName' => '<p>Name of the <a>MatchmakingConfiguration</a> that is used with this ticket. Matchmaking configurations determine how players are grouped into a match and how a new game session is created for the match.</p>', 'StartMatchBackfillInput$TicketId' => '<p>A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon Web Services will generate one in the form of a UUID. Use this identifier to track the match backfill ticket status and retrieve match results.</p>', 'StartMatchmakingInput$TicketId' => '<p>A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon Web Services will generate one in the form of a UUID. Use this identifier to track the matchmaking ticket status and retrieve match results.</p>', 'StopMatchmakingInput$TicketId' => '<p>A unique identifier for a matchmaking ticket.</p>', ], ], 'MatchmakingRequestTimeoutInteger' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$RequestTimeoutSeconds' => '<p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>', 'MatchmakingConfiguration$RequestTimeoutSeconds' => '<p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>', 'UpdateMatchmakingConfigurationInput$RequestTimeoutSeconds' => '<p>The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests that fail due to timing out can be resubmitted as needed.</p>', ], ], 'MatchmakingRuleSet' => [ 'base' => '<p>Set of rule statements, used with FlexMatch, that determine how to build your player matches. Each rule set describes a type of group to be created and defines the parameters for acceptable player matches. Rule sets are used in <a>MatchmakingConfiguration</a> objects.</p> <p>A rule set may define the following elements for a match. For detailed information and examples showing how to construct a rule set, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a FlexMatch rule set</a>. </p> <ul> <li> <p>Teams -- Required. A rule set must define one or multiple teams for the match and set minimum and maximum team sizes. For example, a rule set might describe a 4x4 match that requires all eight slots to be filled. </p> </li> <li> <p>Player attributes -- Optional. These attributes specify a set of player characteristics to evaluate when looking for a match. Matchmaking requests that use a rule set with player attributes must provide the corresponding attribute values. For example, an attribute might specify a player\'s skill or level.</p> </li> <li> <p>Rules -- Optional. Rules define how to evaluate potential players for a match based on player attributes. A rule might specify minimum requirements for individual players, teams, or entire matches. For example, a rule might require each player to meet a certain skill level, each team to have at least one player in a certain role, or the match to have a minimum average skill level. or may describe an entire group--such as all teams must be evenly matched or have at least one player in a certain role. </p> </li> <li> <p>Expansions -- Optional. Expansions allow you to relax the rules after a period of time when no acceptable matches are found. This feature lets you balance getting players into games in a reasonable amount of time instead of making them wait indefinitely for the best possible match. For example, you might use an expansion to increase the maximum skill variance between players after 30 seconds.</p> </li> </ul>', 'refs' => [ 'CreateMatchmakingRuleSetOutput$RuleSet' => '<p>The newly created matchmaking rule set.</p>', 'MatchmakingRuleSetList$member' => NULL, ], ], 'MatchmakingRuleSetArn' => [ 'base' => 'Data type used for Matchmaking RuleSet ARN.', 'refs' => [ 'MatchmakingConfiguration$RuleSetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift matchmaking rule set resource that this configuration uses.</p>', 'MatchmakingRuleSet$RuleSetArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift matchmaking rule set resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::matchmakingruleset/&lt;ruleset name&gt;</code>. In a GameLift rule set ARN, the resource ID matches the <i>RuleSetName</i> value.</p>', ], ], 'MatchmakingRuleSetList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingRuleSetsOutput$RuleSets' => '<p>A collection of requested matchmaking rule set objects. </p>', ], ], 'MatchmakingRuleSetName' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$RuleSetName' => '<p>A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>', 'DeleteMatchmakingRuleSetInput$Name' => '<p>A unique identifier for the matchmaking rule set to be deleted. (Note: The rule set name is different from the optional "name" field in the rule set body.) You can use either the rule set name or ARN value.</p>', 'DescribeMatchmakingConfigurationsInput$RuleSetName' => '<p>A unique identifier for the matchmaking rule set. You can use either the rule set name or ARN value. Use this parameter to retrieve all matchmaking configurations that use this rule set.</p>', 'MatchmakingRuleSetNameList$member' => NULL, 'UpdateMatchmakingConfigurationInput$RuleSetName' => '<p>A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.</p>', ], ], 'MatchmakingRuleSetNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingRuleSetsInput$Names' => '<p>A list of one or more matchmaking rule set names to retrieve details for. (Note: The rule set name is different from the optional "name" field in the rule set body.) You can use either the rule set name or ARN value. </p>', ], ], 'MatchmakingTicket' => [ 'base' => '<p>Ticket generated to track the progress of a matchmaking request. Each ticket is uniquely identified by a ticket ID, supplied by the requester, when creating a matchmaking request with <a>StartMatchmaking</a>. Tickets can be retrieved by calling <a>DescribeMatchmaking</a> with the ticket ID.</p>', 'refs' => [ 'MatchmakingTicketList$member' => NULL, 'StartMatchBackfillOutput$MatchmakingTicket' => '<p>Ticket representing the backfill matchmaking request. This object includes the information in the request, ticket status, and match results as generated during the matchmaking process.</p>', 'StartMatchmakingOutput$MatchmakingTicket' => '<p>Ticket representing the matchmaking request. This object include the information included in the request, ticket status, and match results as generated during the matchmaking process.</p>', ], ], 'MatchmakingTicketList' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingOutput$TicketList' => '<p>A collection of existing matchmaking ticket objects matching the request.</p>', ], ], 'MaxConcurrentGameSessionActivations' => [ 'base' => NULL, 'refs' => [ 'RuntimeConfiguration$MaxConcurrentGameSessionActivations' => '<p>The number of game sessions in status <code>ACTIVATING</code> to allow on an instance. This setting limits the instance resources that can be used for new game activations at any one time.</p>', ], ], 'MetricGroup' => [ 'base' => NULL, 'refs' => [ 'MetricGroupList$member' => NULL, ], ], 'MetricGroupList' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$MetricGroups' => '<p>The name of an Amazon Web Services CloudWatch metric group to add this fleet to. A metric group is used to aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to create a new metric group. A fleet can be included in only one metric group at a time. </p>', 'FleetAttributes$MetricGroups' => '<p>Name of a metric group that metrics for this fleet are added to. In Amazon CloudWatch, you can view aggregated metrics for fleets that are in a metric group. A fleet can be included in only one metric group at a time.</p>', 'UpdateFleetAttributesInput$MetricGroups' => '<p>The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by providing a new name. A fleet can only be in one metric group at a time.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$MetricName' => '<p>Name of the Amazon Web Services-defined metric that is used to trigger a scaling adjustment. For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon Web Services with Amazon CloudWatch</a>. </p> <ul> <li> <p> <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.</p> </li> <li> <p> <b>ActiveGameSessions</b> -- Game sessions that are currently running.</p> </li> <li> <p> <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.</p> </li> <li> <p> <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current capacity.</p> </li> <li> <p> <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</p> </li> <li> <p> <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are reserved for a player. </p> </li> <li> <p> <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions. </p> </li> <li> <p> <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</p> </li> <li> <p> <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game sessions.</p> </li> <li> <p> <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</p> </li> <li> <p> <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination. </p> </li> </ul>', 'ScalingPolicy$MetricName' => '<p>Name of the Amazon Web Services-defined metric that is used to trigger a scaling adjustment. For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon Web Services with Amazon CloudWatch</a>. </p> <ul> <li> <p> <b>ActivatingGameSessions</b> -- Game sessions in the process of being created.</p> </li> <li> <p> <b>ActiveGameSessions</b> -- Game sessions that are currently running.</p> </li> <li> <p> <b>ActiveInstances</b> -- Fleet instances that are currently running at least one game session.</p> </li> <li> <p> <b>AvailableGameSessions</b> -- Additional game sessions that fleet could host simultaneously, given current capacity.</p> </li> <li> <p> <b>AvailablePlayerSessions</b> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</p> </li> <li> <p> <b>CurrentPlayerSessions</b> -- Player slots in active game sessions that are being used by a player or are reserved for a player. </p> </li> <li> <p> <b>IdleInstances</b> -- Active instances that are currently hosting zero game sessions. </p> </li> <li> <p> <b>PercentAvailableGameSessions</b> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</p> </li> <li> <p> <b>PercentIdleInstances</b> -- Percentage of the total number of active instances that are hosting zero game sessions.</p> </li> <li> <p> <b>QueueDepth</b> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</p> </li> <li> <p> <b>WaitTime</b> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination. </p> </li> </ul>', ], ], 'NonBlankAndLengthConstraintString' => [ 'base' => NULL, 'refs' => [ 'Alias$Name' => '<p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>', 'CreateAliasInput$Name' => '<p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>', 'UpdateAliasInput$Name' => '<p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>', ], ], 'NonBlankString' => [ 'base' => NULL, 'refs' => [ 'IpPermission$IpRange' => '<p>A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "<code>000.000.000.000/[subnet mask]</code>" or optionally the shortened version "<code>0.0.0.0/[subnet mask]</code>".</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AwsCredentials$AccessKeyId' => '<p>Temporary key allowing access to the Amazon Web Services S3 account.</p>', 'AwsCredentials$SecretAccessKey' => '<p>Temporary secret key allowing access to the Amazon Web Services S3 account.</p>', 'AwsCredentials$SessionToken' => '<p>Token used to associate a specific build ID with the files uploaded using these credentials.</p>', 'ConflictException$Message' => NULL, 'CreateFleetInput$InstanceRoleArn' => '<p>A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role\'s ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the Amazon Web Services Management Console. Learn more about using on-box credentials for your game servers at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access external resources from a game server</a>. This property cannot be changed after the fleet is created.</p>', 'Event$Message' => '<p>Additional information related to the event.</p>', 'FleetAttributes$InstanceRoleArn' => '<p>A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role\'s ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the Amazon Web Services Management Console. Learn more about using on-box credentials for your game servers at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access external resources from a game server</a>.</p>', 'FleetCapacityExceededException$Message' => NULL, 'GameSessionFullException$Message' => NULL, 'IdempotentParameterMismatchException$Message' => NULL, 'InstanceCredentials$UserName' => '<p>User login string.</p>', 'InstanceCredentials$Secret' => '<p>Secret string. For Windows instances, the secret is a password for use with Windows Remote Desktop. For Linux instances, it is a private key (which must be saved as a <code>.pem</code> file) for use with SSH.</p>', 'InternalServiceException$Message' => NULL, 'InvalidFleetStatusException$Message' => NULL, 'InvalidGameSessionStatusException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'LatencyMap$key' => NULL, 'LimitExceededException$Message' => NULL, 'ListAliasesInput$Name' => '<p>A descriptive label that is associated with an alias. Alias names do not need to be unique.</p>', 'ListAliasesInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'ListAliasesOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'ListBuildsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'ListBuildsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'ListScriptsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'ListScriptsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'NotFoundException$Message' => NULL, 'OutOfCapacityException$Message' => NULL, 'S3Location$Bucket' => '<p>An Amazon S3 bucket identifier. This is the name of the S3 bucket.</p> <note> <p>GameLift currently does not support uploading from Amazon S3 buckets with names that contain a dot (.).</p> </note>', 'S3Location$Key' => '<p>The name of the zip file that contains the build files or script files. </p>', 'S3Location$RoleArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) for an IAM role that allows Amazon Web Services to access the S3 bucket.</p>', 'S3Location$ObjectVersion' => '<p>The version of the file, if object versioning is turned on for the bucket. Amazon Web Services uses this information when retrieving files from an S3 bucket that you own. Use this parameter to specify a specific version of the file. If not set, the latest version of the file is retrieved. </p>', 'TaggingFailedException$Message' => NULL, 'TerminalRoutingStrategyException$Message' => NULL, 'UnauthorizedException$Message' => NULL, 'UnsupportedRegionException$Message' => NULL, ], ], 'NonNegativeDouble' => [ 'base' => NULL, 'refs' => [ 'TargetTrackingConfiguration$TargetValue' => '<p>Desired value to use with a game server group target-based scaling policy. </p>', ], ], 'NonZeroAndMaxString' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$S' => '<p>For single string values. Maximum string length is 100 characters.</p>', 'CreateAliasInput$Description' => '<p>A human-readable description of the alias.</p>', 'CreateBuildInput$Name' => '<p>A descriptive label that is associated with a build. Build names do not need to be unique. You can use <a>UpdateBuild</a> to change this value later. </p>', 'CreateBuildInput$Version' => '<p>Version information that is associated with a build or script. Version strings do not need to be unique. You can use <a>UpdateBuild</a> to change this value later. </p>', 'CreateFleetInput$Name' => '<p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>', 'CreateFleetInput$Description' => '<p>A human-readable description of the fleet.</p>', 'CreateFleetInput$PeerVpcAwsAccountId' => '<p>Used when peering your GameLift fleet with a VPC, the unique identifier for the Amazon Web Services account that owns the VPC. You can find your account ID in the Amazon Web Services Management Console under account settings. </p>', 'CreateFleetInput$PeerVpcId' => '<p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>. </p>', 'CreateGameSessionInput$Name' => '<p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>', 'CreateGameSessionInput$CreatorId' => '<p>A unique identifier for a player or entity creating the game session. This parameter is required when requesting a new game session on a fleet with a resource creation limit policy. This type of policy limits the number of concurrent active game sessions that one player can create within a certain time span. GameLift uses the CreatorId to evaluate the new request against the policy.</p>', 'CreateMatchmakingConfigurationInput$Description' => '<p>A human-readable description of the matchmaking configuration. </p>', 'CreatePlayerSessionInput$PlayerId' => '<p>A unique identifier for a player. Player IDs are developer-defined.</p>', 'CreateScriptInput$Name' => '<p>A descriptive label that is associated with a script. Script names do not need to be unique. You can use <a>UpdateScript</a> to change this value later. </p>', 'CreateScriptInput$Version' => '<p>Version information that is associated with a build or script. Version strings do not need to be unique. You can use <a>UpdateScript</a> to change this value later. </p>', 'CreateVpcPeeringAuthorizationInput$GameLiftAwsAccountId' => '<p>A unique identifier for the Amazon Web Services account that you use to manage your GameLift fleet. You can find your Account ID in the Amazon Web Services Management Console under account settings.</p>', 'CreateVpcPeeringAuthorizationInput$PeerVpcId' => '<p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>', 'CreateVpcPeeringConnectionInput$PeerVpcAwsAccountId' => '<p>A unique identifier for the Amazon Web Services account with the VPC that you want to peer your Amazon Web Services fleet with. You can find your Account ID in the Amazon Web Services Management Console under account settings.</p>', 'CreateVpcPeeringConnectionInput$PeerVpcId' => '<p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>', 'DeleteScalingPolicyInput$Name' => '<p>A descriptive label that is associated with a fleet\'s scaling policy. Policy names do not need to be unique.</p>', 'DeleteVpcPeeringAuthorizationInput$GameLiftAwsAccountId' => '<p>A unique identifier for the Amazon Web Services account that you use to manage your GameLift fleet. You can find your Account ID in the Amazon Web Services Management Console under account settings.</p>', 'DeleteVpcPeeringAuthorizationInput$PeerVpcId' => '<p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>', 'DeleteVpcPeeringConnectionInput$VpcPeeringConnectionId' => '<p>A unique identifier for a VPC peering connection. This value is included in the <a>VpcPeeringConnection</a> object, which can be retrieved by calling <a>DescribeVpcPeeringConnections</a>.</p>', 'DescribeFleetAttributesInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeFleetAttributesOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeFleetCapacityInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeFleetCapacityOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeFleetEventsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeFleetEventsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeFleetLocationAttributesInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeFleetLocationAttributesOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeFleetUtilizationInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeFleetUtilizationOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeGameServerInstancesInput$NextToken' => '<p> A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. </p>', 'DescribeGameServerInstancesOutput$NextToken' => '<p> A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list. </p>', 'DescribeGameSessionDetailsInput$StatusFilter' => '<p>Game session status to filter results on. Possible game session statuses include <code>ACTIVE</code>, <code>TERMINATED</code>, <code>ACTIVATING</code> and <code>TERMINATING</code> (the last two are transitory). </p>', 'DescribeGameSessionDetailsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeGameSessionDetailsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeGameSessionQueuesInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeGameSessionQueuesOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeGameSessionsInput$StatusFilter' => '<p>Game session status to filter results on. You can filter on the following states: <code>ACTIVE</code>, <code>TERMINATED</code>, <code>ACTIVATING</code>, and <code>TERMINATING</code>. The last two are transitory and used for only very brief periods of time. </p>', 'DescribeGameSessionsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeGameSessionsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeInstancesInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeInstancesOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeMatchmakingConfigurationsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeMatchmakingConfigurationsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeMatchmakingRuleSetsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeMatchmakingRuleSetsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribePlayerSessionsInput$PlayerId' => '<p>A unique identifier for a player to retrieve player sessions for.</p>', 'DescribePlayerSessionsInput$PlayerSessionStatusFilter' => '<p>Player session status to filter results on.</p> <p>Possible player session statuses include the following:</p> <ul> <li> <p> <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to the server process and/or been validated. </p> </li> <li> <p> <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.</p> </li> <li> <p> <b>COMPLETED</b> -- The player connection has been dropped.</p> </li> <li> <p> <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not validated within the timeout limit (60 seconds).</p> </li> </ul>', 'DescribePlayerSessionsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. If a player session ID is specified, this parameter is ignored.</p>', 'DescribePlayerSessionsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DescribeScalingPoliciesInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'DescribeScalingPoliciesOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'DesiredPlayerSession$PlayerId' => '<p>A unique identifier for a player to associate with the player session.</p>', 'Event$EventId' => '<p>A unique identifier for a fleet event.</p>', 'Event$ResourceId' => '<p>A unique identifier for an event resource, such as a fleet ID.</p>', 'Event$PreSignedLogUrl' => '<p>Location of stored logs with additional detail that is related to the event. This is useful for debugging issues. The URL is valid for 15 minutes. You can also access fleet creation logs through the GameLift console.</p>', 'FleetAttributes$Description' => '<p>A human-readable description of the fleet.</p>', 'FleetAttributes$Name' => '<p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>', 'GameServerGroup$StatusReason' => '<p>Additional information about the current game server group status. This information might provide additional insight on groups that are in <code>ERROR</code> status.</p>', 'GameSession$GameSessionId' => '<p>A unique identifier for the game session. A game session ARN has the following format: <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>.</p>', 'GameSession$Name' => '<p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>', 'GameSession$CreatorId' => '<p>A unique identifier for a player. This ID is used to enforce a resource protection policy (if one exists), that limits the number of game sessions a player can create.</p>', 'GameSessionPlacement$GameSessionName' => '<p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>', 'GameSessionPlacement$GameSessionId' => '<p>A unique identifier for the game session. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>', 'GameSessionPlacement$GameSessionArn' => '<p>Identifier for the game session created by this placement request. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>). This identifier is unique across all Regions. You can use this value as a <code>GameSessionId</code> value as needed.</p>', 'GameSessionPlacement$GameSessionRegion' => '<p>Name of the Region where the game session created by this placement request is running. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>', 'GetGameSessionLogUrlOutput$PreSignedUrl' => '<p>Location of the requested game session logs, available for download. This URL is valid for 15 minutes, after which S3 will reject any download request using this URL. You can request a new URL any time within the 14-day period that the logs are retained.</p>', 'ListFleetsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'ListFleetsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'ListGameServerGroupsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'ListGameServerGroupsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'ListGameServersInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'ListGameServersOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'MatchedPlayerSession$PlayerId' => '<p>A unique identifier for a player </p>', 'MatchmakingConfiguration$Description' => '<p>A descriptive label that is associated with matchmaking configuration.</p>', 'PlacedPlayerSession$PlayerId' => '<p>A unique identifier for a player that is associated with this player session.</p>', 'Player$PlayerId' => '<p>A unique identifier for a player</p>', 'Player$Team' => '<p>Name of the team that the player is assigned to in a match. Team names are defined in a matchmaking rule set.</p>', 'PlayerAttributeMap$key' => NULL, 'PlayerDataMap$key' => NULL, 'PlayerIdList$member' => NULL, 'PlayerLatency$PlayerId' => '<p>A unique identifier for a player associated with the latency data.</p>', 'PlayerLatency$RegionIdentifier' => '<p>Name of the Region that is associated with the latency value.</p>', 'PlayerSession$PlayerId' => '<p>A unique identifier for a player that is associated with this player session.</p>', 'PlayerSession$GameSessionId' => '<p>A unique identifier for the game session that the player session is connected to.</p>', 'PutScalingPolicyInput$Name' => '<p>A descriptive label that is associated with a fleet\'s scaling policy. Policy names do not need to be unique. A fleet can have only one scaling policy with the same name.</p>', 'PutScalingPolicyOutput$Name' => '<p>A descriptive label that is associated with a fleet\'s scaling policy. Policy names do not need to be unique.</p>', 'ScalingPolicy$Name' => '<p>A descriptive label that is associated with a fleet\'s scaling policy. Policy names do not need to be unique.</p>', 'Script$Name' => '<p>A descriptive label that is associated with a script. Script names do not need to be unique.</p>', 'Script$Version' => '<p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>', 'SearchGameSessionsInput$FilterExpression' => '<p>String containing the search criteria for the session search. If no filter expression is included, the request returns results for all game sessions in the fleet that are in <code>ACTIVE</code> status.</p> <p>A filter expression can contain one or multiple conditions. Each condition consists of the following:</p> <ul> <li> <p> <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>, <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>, <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>.</p> </li> <li> <p> <b>Comparator</b> -- Valid comparators are: <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code>. </p> </li> <li> <p> <b>Value</b> -- Value to be searched for. Values may be numbers, boolean values (true/false) or strings depending on the operand. String values are case sensitive and must be enclosed in single quotes. Special characters must be escaped. Boolean and string values can only be used with the comparators <code>=</code> and <code>&lt;&gt;</code>. For example, the following filter expression searches on <code>gameSessionName</code>: "<code>FilterExpression": "gameSessionName = \'Matt\\\\\'s Awesome Game 1\'"</code>. </p> </li> </ul> <p>To chain multiple conditions in a single expression, use the logical keywords <code>AND</code>, <code>OR</code>, and <code>NOT</code> and parentheses as needed. For example: <code>x AND y AND NOT z</code>, <code>NOT (x OR y)</code>.</p> <p>Session search evaluates conditions from left to right using the following precedence rules:</p> <ol> <li> <p> <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code> </p> </li> <li> <p>Parentheses</p> </li> <li> <p>NOT</p> </li> <li> <p>AND</p> </li> <li> <p>OR</p> </li> </ol> <p>For example, this filter expression retrieves game sessions hosting at least ten players that have an open player slot: <code>"maximumSessions&gt;=10 AND hasAvailablePlayerSessions=true"</code>. </p>', 'SearchGameSessionsInput$SortExpression' => '<p>Instructions on how to sort the search results. If no sort expression is included, the request returns results in random order. A sort expression consists of the following elements:</p> <ul> <li> <p> <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>, <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>, <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>.</p> </li> <li> <p> <b>Order</b> -- Valid sort orders are <code>ASC</code> (ascending) and <code>DESC</code> (descending).</p> </li> </ul> <p>For example, this sort expression returns the oldest active sessions first: <code>"SortExpression": "creationTimeMillis ASC"</code>. Results with a null value for the sort operand are returned at the end of the list.</p>', 'SearchGameSessionsInput$NextToken' => '<p>A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.</p>', 'SearchGameSessionsOutput$NextToken' => '<p>A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.</p>', 'StartGameSessionPlacementInput$GameSessionName' => '<p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>', 'StringDoubleMap$key' => NULL, 'StringList$member' => NULL, 'UpdateAliasInput$Description' => '<p>A human-readable description of the alias.</p>', 'UpdateBuildInput$Name' => '<p>A descriptive label that is associated with a build. Build names do not need to be unique. </p>', 'UpdateBuildInput$Version' => '<p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>', 'UpdateFleetAttributesInput$Name' => '<p>A descriptive label that is associated with a fleet. Fleet names do not need to be unique.</p>', 'UpdateFleetAttributesInput$Description' => '<p>A human-readable description of a fleet.</p>', 'UpdateGameSessionInput$Name' => '<p>A descriptive label that is associated with a game session. Session names do not need to be unique.</p>', 'UpdateMatchmakingConfigurationInput$Description' => '<p>A descriptive label that is associated with matchmaking configuration.</p>', 'UpdateScriptInput$Name' => '<p>A descriptive label that is associated with a script. Script names do not need to be unique.</p>', 'UpdateScriptInput$Version' => '<p>Version information that is associated with a build or script. Version strings do not need to be unique.</p>', 'VpcPeeringAuthorization$GameLiftAwsAccountId' => '<p>A unique identifier for the Amazon Web Services account that you use to manage your GameLift fleet. You can find your Account ID in the Amazon Web Services Management Console under account settings.</p>', 'VpcPeeringAuthorization$PeerVpcAwsAccountId' => '<p/>', 'VpcPeeringAuthorization$PeerVpcId' => '<p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>', 'VpcPeeringConnection$IpV4CidrBlock' => '<p>CIDR block of IPv4 addresses assigned to the VPC peering connection for the GameLift VPC. The peered VPC also has an IPv4 CIDR block associated with it; these blocks cannot overlap or the peering connection cannot be created. </p>', 'VpcPeeringConnection$VpcPeeringConnectionId' => '<p>A unique identifier that is automatically assigned to the connection record. This ID is referenced in VPC peering connection events, and is used when deleting a connection with <a>DeleteVpcPeeringConnection</a>. </p>', 'VpcPeeringConnection$PeerVpcId' => '<p>A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a>.</p>', 'VpcPeeringConnection$GameLiftVpcId' => '<p>A unique identifier for the VPC that contains the Amazon Web Services fleet for this connection. This VPC is managed by Amazon Web Services and does not appear in your Amazon Web Services account. </p>', 'VpcPeeringConnectionStatus$Code' => '<p>Code indicating the status of a VPC peering connection.</p>', 'VpcPeeringConnectionStatus$Message' => '<p>Additional messaging associated with the connection status. </p>', ], ], 'NotFoundException' => [ 'base' => '<p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>', 'refs' => [], ], 'OperatingSystem' => [ 'base' => NULL, 'refs' => [ 'Build$OperatingSystem' => '<p>Operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build.</p>', 'CreateBuildInput$OperatingSystem' => '<p>The operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build. If your game build contains multiple executables, they all must run on the same operating system. If an operating system is not specified when creating a build, Amazon GameLift uses the default value (WINDOWS_2012). This value cannot be changed later.</p>', 'FleetAttributes$OperatingSystem' => '<p>The operating system of the fleet\'s computing resources. A fleet\'s operating system is determined by the OS of the build or script that is deployed on this fleet.</p>', 'Instance$OperatingSystem' => '<p>Operating system that is running on this instance. </p>', 'InstanceAccess$OperatingSystem' => '<p>Operating system that is running on the instance.</p>', ], ], 'OutOfCapacityException' => [ 'base' => '<p>The specified game server group has no available game servers to fulfill a <code>ClaimGameServer</code> request. Clients can retry such requests immediately or after a waiting period. </p>', 'refs' => [], ], 'PlacedPlayerSession' => [ 'base' => '<p>Information about a player session that was created as part of a <a>StartGameSessionPlacement</a> request. This object contains only the player ID and player session ID. To retrieve full details on a player session, call <a>DescribePlayerSessions</a> with the player session ID.</p> <p> <b>Related actions</b> </p> <p> <a>CreatePlayerSession</a> | <a>CreatePlayerSessions</a> | <a>DescribePlayerSessions</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a>StopGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'PlacedPlayerSessionList$member' => NULL, ], ], 'PlacedPlayerSessionList' => [ 'base' => NULL, 'refs' => [ 'GameSessionPlacement$PlacedPlayerSessions' => '<p>A collection of information on player sessions created in response to the game session placement request. These player sessions are created only once a new game session is successfully placed (placement status is <code>FULFILLED</code>). This information includes the player ID (as provided in the placement request) and the corresponding player session ID. Retrieve full player sessions by calling <a>DescribePlayerSessions</a> with the player session ID.</p>', ], ], 'Player' => [ 'base' => '<p>Represents a player in matchmaking. When starting a matchmaking request, a player has a player ID, attributes, and may have latency data. Team information is added after a match has been successfully completed.</p>', 'refs' => [ 'PlayerList$member' => NULL, ], ], 'PlayerAttributeMap' => [ 'base' => NULL, 'refs' => [ 'Player$PlayerAttributes' => '<p>A collection of key:value pairs containing player information for use in matchmaking. Player attribute keys must match the <i>playerAttributes</i> used in a matchmaking rule set. Example: <code>"PlayerAttributes": {"skill": {"N": "23"}, "gameMode": {"S": "deathmatch"}}</code>.</p>', ], ], 'PlayerData' => [ 'base' => NULL, 'refs' => [ 'CreatePlayerSessionInput$PlayerData' => '<p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game.</p>', 'DesiredPlayerSession$PlayerData' => '<p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game.</p>', 'PlayerDataMap$value' => NULL, 'PlayerSession$PlayerData' => '<p>Developer-defined information related to a player. GameLift does not use this data, so it can be formatted as needed for use in the game. </p>', ], ], 'PlayerDataMap' => [ 'base' => NULL, 'refs' => [ 'CreatePlayerSessionsInput$PlayerDataMap' => '<p>Map of string pairs, each specifying a player ID and a set of developer-defined information related to the player. Amazon Web Services does not use this data, so it can be formatted as needed for use in the game. Any player data strings for player IDs that are not included in the <code>PlayerIds</code> parameter are ignored. </p>', ], ], 'PlayerIdList' => [ 'base' => NULL, 'refs' => [ 'CreatePlayerSessionsInput$PlayerIds' => '<p>List of unique identifiers for the players to be added.</p>', ], ], 'PlayerLatency' => [ 'base' => '<p>Regional latency information for a player, used when requesting a new game session with <a>StartGameSessionPlacement</a>. This value indicates the amount of time lag that exists when the player is connected to a fleet in the specified Region. The relative difference between a player\'s latency values for multiple Regions are used to determine which fleets are best suited to place a new game session for the player. </p>', 'refs' => [ 'PlayerLatencyList$member' => NULL, ], ], 'PlayerLatencyList' => [ 'base' => NULL, 'refs' => [ 'GameSessionPlacement$PlayerLatencies' => '<p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions.</p>', 'StartGameSessionPlacementInput$PlayerLatencies' => '<p>A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions. This information is used to try to place the new game session where it can offer the best possible gameplay experience for the players. </p>', ], ], 'PlayerLatencyPolicy' => [ 'base' => '<p>Sets a latency cap for individual players when placing a game session. With a latency policy in force, a game session cannot be placed in a fleet location where a player reports latency higher than the cap. Latency policies are used only with placement request that provide player latency information. Player latency policies can be stacked to gradually relax latency requirements over time. </p> <p>Latency policies are part of a <a>GameSessionQueue</a>.</p>', 'refs' => [ 'PlayerLatencyPolicyList$member' => NULL, ], ], 'PlayerLatencyPolicyList' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionQueueInput$PlayerLatencyPolicies' => '<p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value.</p>', 'GameSessionQueue$PlayerLatencyPolicies' => '<p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. </p>', 'UpdateGameSessionQueueInput$PlayerLatencyPolicies' => '<p>A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. When updating policies, provide a complete collection of policies.</p>', ], ], 'PlayerList' => [ 'base' => NULL, 'refs' => [ 'MatchmakingTicket$Players' => '<p>A set of <code>Player</code> objects, each representing a player to find matches for. Players are identified by a unique player ID and may include latency data for use during matchmaking. If the ticket is in status <code>COMPLETED</code>, the <code>Player</code> objects include the team the players were assigned to in the resulting match.</p>', 'StartMatchBackfillInput$Players' => '<p>Match information on all players that are currently assigned to the game session. This information is used by the matchmaker to find new players and add them to the existing game.</p> <ul> <li> <p>PlayerID, PlayerAttributes, Team -- This information is maintained in the <a>GameSession</a> object, <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The matchmaker data is in JSON syntax, formatted as a string. For more details, see <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data"> Match Data</a>. </p> <p>The backfill request must specify the team membership for every player. Do not specify team if you are not using backfill.</p> </li> <li> <p>LatencyInMs -- If the matchmaker uses player latency, include a latency value, in milliseconds, for the Region that the game session is currently in. Do not include latency values for any other Region.</p> </li> </ul>', 'StartMatchmakingInput$Players' => '<p>Information on each player to be matched. This information must include a player ID, and may contain player attributes and latency data to be used in the matchmaking process. After a successful match, <code>Player</code> objects contain the name of the team the player is assigned to.</p>', ], ], 'PlayerSession' => [ 'base' => '<p>Represents a player session. Player sessions are created either for a specific game session, or as part of a game session placement or matchmaking request. A player session can represents a reserved player slot in a game session (when status is <code>RESERVED</code>) or actual player activity in a game session (when status is <code>ACTIVE</code>). A player session object, including player data, is automatically passed to a game session when the player connects to the game session and is validated. After the game session ends, player sessions information is retained for 30 days and then removed.</p> <p> <b>Related actions</b> </p> <p> <a>CreatePlayerSession</a> | <a>CreatePlayerSessions</a> | <a>DescribePlayerSessions</a> | <a>StartGameSessionPlacement</a> | <a>DescribeGameSessionPlacement</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'CreatePlayerSessionOutput$PlayerSession' => '<p>Object that describes the newly created player session record.</p>', 'PlayerSessionList$member' => NULL, ], ], 'PlayerSessionCreationPolicy' => [ 'base' => NULL, 'refs' => [ 'GameSession$PlayerSessionCreationPolicy' => '<p>Indicates whether or not the game session is accepting new players.</p>', 'UpdateGameSessionInput$PlayerSessionCreationPolicy' => '<p>A policy that determines whether the game session is accepting new players.</p>', ], ], 'PlayerSessionId' => [ 'base' => NULL, 'refs' => [ 'DescribePlayerSessionsInput$PlayerSessionId' => '<p>A unique identifier for a player session to retrieve.</p>', 'MatchedPlayerSession$PlayerSessionId' => '<p>A unique identifier for a player session</p>', 'PlacedPlayerSession$PlayerSessionId' => '<p>A unique identifier for a player session.</p>', 'PlayerSession$PlayerSessionId' => '<p>A unique identifier for a player session.</p>', ], ], 'PlayerSessionList' => [ 'base' => NULL, 'refs' => [ 'CreatePlayerSessionsOutput$PlayerSessions' => '<p>A collection of player session objects created for the added players.</p>', 'DescribePlayerSessionsOutput$PlayerSessions' => '<p>A collection of objects containing properties for each player session that matches the request.</p>', ], ], 'PlayerSessionStatus' => [ 'base' => NULL, 'refs' => [ 'PlayerSession$Status' => '<p>Current status of the player session.</p> <p>Possible player session statuses include the following:</p> <ul> <li> <p> <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to the server process and/or been validated. </p> </li> <li> <p> <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.</p> </li> <li> <p> <b>COMPLETED</b> -- The player connection has been dropped.</p> </li> <li> <p> <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not validated within the timeout limit (60 seconds).</p> </li> </ul>', ], ], 'PolicyType' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$PolicyType' => '<p>The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to \'PercentAvailableGameSessions\' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>, <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.</p>', 'ScalingPolicy$PolicyType' => '<p>The type of scaling policy to create. For a target-based policy, set the parameter <i>MetricName</i> to \'PercentAvailableGameSessions\' and specify a <i>TargetConfiguration</i>. For a rule-based policy set the following parameters: <i>MetricName</i>, <i>ComparisonOperator</i>, <i>Threshold</i>, <i>EvaluationPeriods</i>, <i>ScalingAdjustmentType</i>, and <i>ScalingAdjustment</i>.</p>', ], ], 'PortNumber' => [ 'base' => NULL, 'refs' => [ 'GameSession$Port' => '<p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>', 'GameSessionPlacement$Port' => '<p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number. This value is set once the new game session is placed (placement status is <code>FULFILLED</code>).</p>', 'IpPermission$FromPort' => '<p>A starting value for a range of allowed port numbers.</p> <p>For fleets using Linux builds, only port 22, 443, 1026-60000 are valid. For fleets using Windows builds, only port 443, 1026-60000 are valid.</p>', 'IpPermission$ToPort' => '<p>An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than <code>FromPort</code>.</p> <p>For fleets using Linux builds, only port 22, 443, 1026-60000 are valid. For fleets using Windows builds, only port 443, 1026-60000 are valid.</p>', 'PlayerSession$Port' => '<p>Port number for the game session. To connect to a Amazon Web Services server process, an app needs both the IP address and port number.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'CreateGameServerGroupInput$MaxSize' => '<p>The maximum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.</p>', 'DescribeFleetAttributesInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeFleetCapacityInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeFleetEventsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'DescribeFleetLocationAttributesInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This limit is not currently enforced. </p>', 'DescribeFleetUtilizationInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs.</p>', 'DescribeGameServerInstancesInput$Limit' => '<p> The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. </p>', 'DescribeGameSessionDetailsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'DescribeGameSessionQueuesInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. You can request up to 50 results.</p>', 'DescribeGameSessionsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'DescribeInstancesInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'DescribeMatchmakingConfigurationsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. This parameter is limited to 10.</p>', 'DescribePlayerSessionsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. If a player session ID is specified, this parameter is ignored.</p>', 'DescribeScalingPoliciesInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'GameServerGroupAutoScalingPolicy$EstimatedInstanceWarmup' => '<p>Length of time, in seconds, it takes for a new instance to start new game server processes and register with GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances. </p>', 'GameSessionConnectionInfo$Port' => '<p>The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>', 'LatencyMap$value' => NULL, 'ListAliasesInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListBuildsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListFleetsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListGameServerGroupsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListGameServersInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'ListScriptsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', 'PutScalingPolicyInput$EvaluationPeriods' => '<p>Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.</p>', 'ScalingPolicy$EvaluationPeriods' => '<p>Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.</p>', 'SearchGameSessionsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages. The maximum number of results returned is 20, even if this value is not set or is set higher than 20. </p>', 'ServerProcess$ConcurrentExecutions' => '<p>The number of server processes using this configuration that run concurrently on each instance.</p>', ], ], 'PositiveLong' => [ 'base' => NULL, 'refs' => [ 'Build$SizeOnDisk' => '<p>File size of the uploaded game build, expressed in bytes. When the build status is <code>INITIALIZED</code> or when using a custom Amazon S3 storage location, this value is 0.</p>', 'Script$SizeOnDisk' => '<p>The file size of the uploaded Realtime script, expressed in bytes. When files are uploaded from an S3 location, this value remains at "0".</p>', ], ], 'PriorityConfiguration' => [ 'base' => '<p>Custom prioritization settings for use by a game session queue when placing new game sessions with available game servers. When defined, this configuration replaces the default FleetIQ prioritization process, which is as follows:</p> <ul> <li> <p>If player latency data is included in a game session request, destinations and locations are prioritized first based on lowest average latency (1), then on lowest hosting cost (2), then on destination list order (3), and finally on location (alphabetical) (4). This approach ensures that the queue\'s top priority is to place game sessions where average player latency is lowest, and--if latency is the same--where the hosting cost is less, etc.</p> </li> <li> <p>If player latency data is not included, destinations and locations are prioritized first on destination list order (1), and then on location (alphabetical) (2). This approach ensures that the queue\'s top priority is to place game sessions on the first destination fleet listed. If that fleet has multiple locations, the game session is placed on the first location (when listed alphabetically).</p> </li> </ul> <p>Changing the priority order will affect how game sessions are placed.</p> <p>Priority configurations are part of a <a>GameSessionQueue</a>.</p>', 'refs' => [ 'CreateGameSessionQueueInput$PriorityConfiguration' => '<p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. </p>', 'GameSessionQueue$PriorityConfiguration' => '<p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. </p>', 'UpdateGameSessionQueueInput$PriorityConfiguration' => '<p>Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. To remove an existing priority configuration, pass in an empty set.</p>', ], ], 'PriorityType' => [ 'base' => NULL, 'refs' => [ 'PriorityTypeList$member' => NULL, ], ], 'PriorityTypeList' => [ 'base' => NULL, 'refs' => [ 'PriorityConfiguration$PriorityOrder' => '<p>The recommended sequence to use when prioritizing where to place new game sessions. Each type can only be listed once.</p> <ul> <li> <p> <code>LATENCY</code> -- FleetIQ prioritizes locations where the average player latency (provided in each game session request) is lowest. </p> </li> <li> <p> <code>COST</code> -- FleetIQ prioritizes destinations with the lowest current hosting costs. Cost is evaluated based on the location, instance type, and fleet type (Spot or On-Demand) for each destination in the queue.</p> </li> <li> <p> <code>DESTINATION</code> -- FleetIQ prioritizes based on the order that destinations are listed in the queue configuration.</p> </li> <li> <p> <code>LOCATION</code> -- FleetIQ prioritizes based on the provided order of locations, as defined in <code>LocationOrder</code>. </p> </li> </ul>', ], ], 'ProtectionPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$NewGameSessionProtectionPolicy' => '<p>The status of termination protection for active game sessions on the fleet. By default, this property is set to <code>NoProtection</code>. You can also set game session protection for an individual game session by calling <a>UpdateGameSession</a>.</p> <ul> <li> <p> <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a scale-down event. </p> </li> <li> <p> <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a scale-down event.</p> </li> </ul>', 'FleetAttributes$NewGameSessionProtectionPolicy' => '<p>The type of game session protection to set on all new instances that are started in the fleet.</p> <ul> <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li> <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li> </ul>', 'GameSessionDetail$ProtectionPolicy' => '<p>Current status of protection for the game session.</p> <ul> <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li> <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li> </ul>', 'UpdateFleetAttributesInput$NewGameSessionProtectionPolicy' => '<p>The game session protection policy to apply to all new instances created in this fleet. Instances that already exist are not affected. You can set protection for individual instances using <a>UpdateGameSession</a>.</p> <ul> <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li> <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li> </ul>', 'UpdateGameSessionInput$ProtectionPolicy' => '<p>Game session protection policy to apply to this game session only.</p> <ul> <li> <p> <b>NoProtection</b> -- The game session can be terminated during a scale-down event.</p> </li> <li> <p> <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during a scale-down event.</p> </li> </ul>', ], ], 'PutScalingPolicyInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'PutScalingPolicyOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'QueueArnsList' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$GameSessionQueueArns' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code>, do not set this parameter. </p>', 'MatchmakingConfiguration$GameSessionQueueArns' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. This property is not set when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', 'UpdateMatchmakingConfigurationInput$GameSessionQueueArns' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code>. Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code>, do not set this parameter.</p>', ], ], 'QueueCustomEventData' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionQueueInput$CustomEventData' => '<p> Information to be added to all events that are related to this game session queue. </p>', 'GameSessionQueue$CustomEventData' => '<p> Information that is added to all events that are related to this game session queue. </p>', 'UpdateGameSessionQueueInput$CustomEventData' => '<p> Information to be added to all events that are related to this game session queue. </p>', ], ], 'QueueSnsArnStringModel' => [ 'base' => NULL, 'refs' => [ 'CreateGameSessionQueueInput$NotificationTarget' => '<p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>', 'GameSessionQueue$NotificationTarget' => '<p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>', 'UpdateGameSessionQueueInput$NotificationTarget' => '<p>An SNS topic ARN that is set up to receive game session placement notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html"> Setting up notifications for game session placement</a>.</p>', ], ], 'RegisterGameServerInput' => [ 'base' => NULL, 'refs' => [], ], 'RegisterGameServerOutput' => [ 'base' => NULL, 'refs' => [], ], 'RequestUploadCredentialsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'RequestUploadCredentialsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'ResolveAliasInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'ResolveAliasOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'ResourceCreationLimitPolicy' => [ 'base' => '<p>A policy that puts limits on the number of game sessions that a player can create within a specified span of time. With this policy, you can control players\' ability to consume available resources.</p> <p>The policy is evaluated when a player tries to create a new game session. On receiving a <code>CreateGameSession</code> request, GameLift checks that the player (identified by <code>CreatorId</code>) has created fewer than game session limit in the specified time period.</p> <p>The resource creation limit policy is included in <a>FleetAttributes</a>.</p>', 'refs' => [ 'CreateFleetInput$ResourceCreationLimitPolicy' => '<p>A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.</p>', 'FleetAttributes$ResourceCreationLimitPolicy' => '<p>The fleet policy that limits the number of game sessions an individual player can create over a span of time.</p>', 'UpdateFleetAttributesInput$ResourceCreationLimitPolicy' => '<p>Policy settings that limit the number of game sessions an individual player can create over a span of time. </p>', ], ], 'ResumeGameServerGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'ResumeGameServerGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'RoutingStrategy' => [ 'base' => '<p>The routing configuration for a fleet alias.</p> <p> <b>Related actions</b> </p> <p> <a>CreateAlias</a> | <a>ListAliases</a> | <a>DescribeAlias</a> | <a>UpdateAlias</a> | <a>DeleteAlias</a> | <a>ResolveAlias</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'Alias$RoutingStrategy' => '<p>The routing configuration, including routing type and fleet target, for the alias. </p>', 'CreateAliasInput$RoutingStrategy' => '<p>The routing configuration, including routing type and fleet target, for the alias. </p>', 'UpdateAliasInput$RoutingStrategy' => '<p>The routing configuration, including routing type and fleet target, for the alias.</p>', ], ], 'RoutingStrategyType' => [ 'base' => NULL, 'refs' => [ 'ListAliasesInput$RoutingStrategyType' => '<p>The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing type. To retrieve all aliases, leave this parameter empty.</p> <p>Possible routing types include the following:</p> <ul> <li> <p> <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active fleets.</p> </li> <li> <p> <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message embedded.</p> </li> </ul>', 'RoutingStrategy$Type' => '<p>The type of routing strategy for the alias.</p> <p>Possible routing types include the following:</p> <ul> <li> <p> <b>SIMPLE</b> - The alias resolves to one specific fleet. Use this type when routing to active fleets.</p> </li> <li> <p> <b>TERMINAL</b> - The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message embedded.</p> </li> </ul>', ], ], 'RuleSetBody' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingRuleSetInput$RuleSetBody' => '<p>A collection of matchmaking rules, formatted as a JSON string. Comments are not allowed in JSON, but most elements support a description field.</p>', 'MatchmakingRuleSet$RuleSetBody' => '<p>A collection of matchmaking rules, formatted as a JSON string. Comments are not allowed in JSON, but most elements support a description field.</p>', 'ValidateMatchmakingRuleSetInput$RuleSetBody' => '<p>A collection of matchmaking rules to validate, formatted as a JSON string.</p>', ], ], 'RuleSetLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeMatchmakingRuleSetsInput$Limit' => '<p>The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set of sequential pages.</p>', ], ], 'RuntimeConfiguration' => [ 'base' => '<p>A collection of server process configurations that describe the set of processes to run on each instance in a fleet. Server processes run either an executable in a custom game build or a Realtime Servers script. GameLift launches the configured processes, manages their life cycle, and replaces them as needed. Each instance checks regularly for an updated runtime configuration. </p> <p>A GameLift instance is limited to 50 processes running concurrently. To calculate the total number of processes in a runtime configuration, add the values of the <code>ConcurrentExecutions</code> parameter for each <a>ServerProcess</a>. Learn more about <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html"> Running Multiple Processes on a Fleet</a>.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeRuntimeConfiguration</a> | <a>UpdateRuntimeConfiguration</a> </p>', 'refs' => [ 'CreateFleetInput$RuntimeConfiguration' => '<p>Instructions for how to launch and maintain server processes on instances in the fleet. The runtime configuration defines one or more server process configurations, each identifying a build executable or Realtime script file and the number of processes of that type to run concurrently. </p> <note> <p>The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, which are still supported for backward compatibility.</p> </note>', 'DescribeRuntimeConfigurationOutput$RuntimeConfiguration' => '<p>Instructions that describe how server processes should be launched and maintained on each instance in the fleet.</p>', 'UpdateRuntimeConfigurationInput$RuntimeConfiguration' => '<p>Instructions for launching server processes on each instance in the fleet. Server processes run either a custom game build executable or a Realtime Servers script. The runtime configuration lists the types of server processes to run on an instance, how to launch them, and the number of processes to run concurrently.</p>', 'UpdateRuntimeConfigurationOutput$RuntimeConfiguration' => '<p>The runtime configuration currently in use by all instances in the fleet. If the update was successful, all property changes are shown. </p>', ], ], 'S3Location' => [ 'base' => '<p>The location in Amazon S3 where build or script files are stored for access by Amazon Web Services. This location is specified in <a>CreateBuild</a>, <a>CreateScript</a>, and <a>UpdateScript</a> requests. </p>', 'refs' => [ 'CreateBuildInput$StorageLocation' => '<p>Information indicating where your game build files are stored. Use this parameter only when creating a build with files stored in an Amazon S3 bucket that you own. The storage location must specify an Amazon S3 bucket name and key. The location must also specify a role ARN that you set up to allow Amazon Web Services to access your Amazon S3 bucket. The S3 bucket and your new build must be in the same Region.</p> <p>If a <code>StorageLocation</code> is specified, the size of your file can be found in your Amazon S3 bucket. Amazon Web Services will report a <code>SizeOnDisk</code> of 0. </p>', 'CreateBuildOutput$StorageLocation' => '<p>Amazon S3 location for your game build file, including bucket name and key.</p>', 'CreateScriptInput$StorageLocation' => '<p>The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon Web Services to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon Web Services uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code> parameter to specify an earlier version. </p>', 'RequestUploadCredentialsOutput$StorageLocation' => '<p>Amazon S3 path and key, identifying where the game build files are stored.</p>', 'Script$StorageLocation' => NULL, 'UpdateScriptInput$StorageLocation' => '<p>The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon Web Services to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon Web Services uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code> parameter to specify an earlier version. </p>', ], ], 'ScalingAdjustmentType' => [ 'base' => NULL, 'refs' => [ 'PutScalingPolicyInput$ScalingAdjustmentType' => '<p>The type of adjustment to make to a fleet\'s instance count (see <a>FleetCapacity</a>):</p> <ul> <li> <p> <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</p> </li> <li> <p> <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.</p> </li> <li> <p> <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down; for example, a value of "-10" scales the fleet down by 10%.</p> </li> </ul>', 'ScalingPolicy$ScalingAdjustmentType' => '<p>The type of adjustment to make to a fleet\'s instance count (see <a>FleetCapacity</a>):</p> <ul> <li> <p> <b>ChangeInCapacity</b> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</p> </li> <li> <p> <b>ExactCapacity</b> -- set the instance count to the scaling adjustment value.</p> </li> <li> <p> <b>PercentChangeInCapacity</b> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down.</p> </li> </ul>', ], ], 'ScalingPolicy' => [ 'base' => '<p>Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.</p> <p> <b>Related actions</b> </p> <p> <a>DescribeFleetCapacity</a> | <a>UpdateFleetCapacity</a> | <a>DescribeEC2InstanceLimits</a> | <a>PutScalingPolicy</a> | <a>DescribeScalingPolicies</a> | <a>DeleteScalingPolicy</a> | <a>StopFleetActions</a> | <a>StartFleetActions</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'ScalingPolicyList$member' => NULL, ], ], 'ScalingPolicyList' => [ 'base' => NULL, 'refs' => [ 'DescribeScalingPoliciesOutput$ScalingPolicies' => '<p>A collection of objects containing the scaling policies matching the request.</p>', ], ], 'ScalingStatusType' => [ 'base' => NULL, 'refs' => [ 'DescribeScalingPoliciesInput$StatusFilter' => '<p>Scaling policy status to filter results on. A scaling policy is only in force when in an <code>ACTIVE</code> status.</p> <ul> <li> <p> <b>ACTIVE</b> -- The scaling policy is currently in force.</p> </li> <li> <p> <b>UPDATEREQUESTED</b> -- A request to update the scaling policy has been received.</p> </li> <li> <p> <b>UPDATING</b> -- A change is being made to the scaling policy.</p> </li> <li> <p> <b>DELETEREQUESTED</b> -- A request to delete the scaling policy has been received.</p> </li> <li> <p> <b>DELETING</b> -- The scaling policy is being deleted.</p> </li> <li> <p> <b>DELETED</b> -- The scaling policy has been deleted.</p> </li> <li> <p> <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.</p> </li> </ul>', 'ScalingPolicy$Status' => '<p>Current status of the scaling policy. The scaling policy can be in force only when in an <code>ACTIVE</code> status. Scaling policies can be suspended for individual fleets (see <a>StopFleetActions</a>; if suspended for a fleet, the policy status does not change. View a fleet\'s stopped actions by calling <a>DescribeFleetCapacity</a>.</p> <ul> <li> <p> <b>ACTIVE</b> -- The scaling policy can be used for auto-scaling a fleet.</p> </li> <li> <p> <b>UPDATE_REQUESTED</b> -- A request to update the scaling policy has been received.</p> </li> <li> <p> <b>UPDATING</b> -- A change is being made to the scaling policy.</p> </li> <li> <p> <b>DELETE_REQUESTED</b> -- A request to delete the scaling policy has been received.</p> </li> <li> <p> <b>DELETING</b> -- The scaling policy is being deleted.</p> </li> <li> <p> <b>DELETED</b> -- The scaling policy has been deleted.</p> </li> <li> <p> <b>ERROR</b> -- An error occurred in creating the policy. It should be removed and recreated.</p> </li> </ul>', ], ], 'Script' => [ 'base' => '<p>Properties describing a Realtime script.</p> <p> <b>Related actions</b> </p> <p> <a>CreateScript</a> | <a>ListScripts</a> | <a>DescribeScript</a> | <a>UpdateScript</a> | <a>DeleteScript</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'CreateScriptOutput$Script' => '<p>The newly created script record with a unique script ID and ARN. The new script\'s storage location reflects an Amazon S3 location: (1) If the script was uploaded from an S3 bucket under your account, the storage location reflects the information that was provided in the <i>CreateScript</i> request; (2) If the script file was uploaded from a local zip file, the storage location reflects an S3 location controls by the Amazon Web Services service.</p>', 'DescribeScriptOutput$Script' => '<p>A set of properties describing the requested script.</p>', 'ScriptList$member' => NULL, 'UpdateScriptOutput$Script' => '<p>The newly created script record with a unique script ID. The new script\'s storage location reflects an Amazon S3 location: (1) If the script was uploaded from an S3 bucket under your account, the storage location reflects the information that was provided in the <i>CreateScript</i> request; (2) If the script file was uploaded from a local zip file, the storage location reflects an S3 location controls by the Amazon Web Services service.</p>', ], ], 'ScriptArn' => [ 'base' => NULL, 'refs' => [ 'FleetAttributes$ScriptArn' => '<p> The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) associated with the GameLift script resource that is deployed on instances in this fleet. In a GameLift script ARN, the resource ID matches the <code>ScriptId</code> value.</p>', 'Script$ScriptArn' => '<p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a GameLift script resource and uniquely identifies it. ARNs are unique across all Regions. In a GameLift script ARN, the resource ID matches the <i>ScriptId</i> value.</p>', ], ], 'ScriptId' => [ 'base' => NULL, 'refs' => [ 'FleetAttributes$ScriptId' => '<p>A unique identifier for the Realtime script resource that is deployed on instances in this fleet.</p>', 'Script$ScriptId' => '<p>A unique identifier for the Realtime script</p>', ], ], 'ScriptIdOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInput$ScriptId' => '<p>The unique identifier for a Realtime configuration script to be deployed on fleet instances. You can use either the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet. This fleet property cannot be changed later.</p>', 'DeleteScriptInput$ScriptId' => '<p>A unique identifier for the Realtime script to delete. You can use either the script ID or ARN value.</p>', 'DescribeScriptInput$ScriptId' => '<p>A unique identifier for the Realtime script to retrieve properties for. You can use either the script ID or ARN value.</p>', 'ListFleetsInput$ScriptId' => '<p>A unique identifier for the Realtime script to request fleets for. Use this parameter to return only fleets using a specified script. Use either the script ID or ARN value.</p>', 'UpdateScriptInput$ScriptId' => '<p>A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.</p>', ], ], 'ScriptList' => [ 'base' => NULL, 'refs' => [ 'ListScriptsOutput$Scripts' => '<p>A set of properties describing the requested script.</p>', ], ], 'SearchGameSessionsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'SearchGameSessionsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'ServerProcess' => [ 'base' => '<p>A set of instructions for launching server processes on each instance in a fleet. Server processes run either an executable in a custom game build or a Realtime Servers script. Server process configurations are part of a fleet\'s <a>RuntimeConfiguration</a>.</p>', 'refs' => [ 'ServerProcessList$member' => NULL, ], ], 'ServerProcessList' => [ 'base' => NULL, 'refs' => [ 'RuntimeConfiguration$ServerProcesses' => '<p>A collection of server process configurations that identify what server processes to run on each instance in a fleet.</p>', ], ], 'SnsArnStringModel' => [ 'base' => NULL, 'refs' => [ 'CreateMatchmakingConfigurationInput$NotificationTarget' => '<p>An SNS topic ARN that is set up to receive matchmaking notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up notifications for matchmaking</a> for more information.</p>', 'MatchmakingConfiguration$NotificationTarget' => '<p>An SNS topic ARN that is set up to receive matchmaking notifications.</p>', 'UpdateMatchmakingConfigurationInput$NotificationTarget' => '<p>An SNS topic ARN that is set up to receive matchmaking notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up notifications for matchmaking</a> for more information.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListGameServersInput$SortOrder' => '<p>Indicates how to sort the returned data based on game server registration timestamp. Use <code>ASCENDING</code> to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve newest game servers first. If this parameter is left empty, game servers are returned in no particular order.</p>', ], ], 'StartFleetActionsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'StartFleetActionsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'StartGameSessionPlacementInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'StartGameSessionPlacementOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'StartMatchBackfillInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'StartMatchBackfillOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'StartMatchmakingInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'StartMatchmakingOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'StopFleetActionsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'StopFleetActionsOutput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'StopGameSessionPlacementInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'StopGameSessionPlacementOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'StopMatchmakingInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'StopMatchmakingOutput' => [ 'base' => NULL, 'refs' => [], ], 'StringDoubleMap' => [ 'base' => NULL, 'refs' => [ 'AttributeValue$SDM' => '<p>For a map of up to 10 data type:value pairs. Maximum length for each string value is 100 characters. </p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'AcceptMatchInput$PlayerIds' => '<p>A unique identifier for a player delivering the response. This parameter can include one or multiple player IDs.</p>', 'AttributeValue$SL' => '<p>For a list of up to 100 strings. Maximum length for each string is 100 characters. Duplicate values are not recognized; all occurrences of the repeated value after the first of a repeated value are ignored.</p>', 'CreateFleetInput$LogPaths' => '<p> <b>This parameter is no longer used.</b> To specify where GameLift should store log files once a server process shuts down, use the GameLift server API <code>ProcessReady()</code> and specify one or more directory paths in <code>logParameters</code>. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference</a>. </p>', 'FleetAttributes$LogPaths' => '<p> <b>This parameter is no longer used.</b> Game session log paths are now defined using the GameLift server API <code>ProcessReady()</code> <code>logParameters</code>. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference</a>. </p>', ], ], 'StringModel' => [ 'base' => NULL, 'refs' => [ 'GameSessionConnectionInfo$IpAddress' => '<p>The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.</p>', 'MatchmakingTicket$StatusReason' => '<p>Code to explain the current status. For example, a status reason may indicate when a ticket has returned to <code>SEARCHING</code> status after a proposed match fails to receive player acceptances.</p>', 'MatchmakingTicket$StatusMessage' => '<p>Additional information about the current status.</p>', ], ], 'SuspendGameServerGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'SuspendGameServerGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p> A label that can be assigned to a GameLift resource. </p> <p> <b>Learn more</b> </p> <p> <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i> </p> <p> <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging Strategies</a> </p> <p> <b>Related actions</b> </p> <p> <a>TagResource</a> | <a>UntagResource</a> | <a>ListTagsForResource</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p> The key for a developer-defined key:value pair for tagging an Amazon Web Services resource. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of one or more tag keys to remove from the specified GameLift resource. An Amazon Web Services resource can have only one tag with a specific tag key, so specifying the tag key identifies which tag to remove. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAliasInput$Tags' => '<p>A list of labels to assign to the new alias resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>. Once the resource is created, you can use <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.</p>', 'CreateBuildInput$Tags' => '<p>A list of labels to assign to the new build resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>. Once the resource is created, you can use <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.</p>', 'CreateFleetInput$Tags' => '<p>A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>. Once the fleet is created, you can use <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the <i>Amazon Web Services General Reference</i> for actual tagging limits.</p>', 'CreateGameServerGroupInput$Tags' => '<p>A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources is useful for resource management, access management, and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>. Once the resource is created, you can use <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags, respectively. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.</p>', 'CreateGameSessionQueueInput$Tags' => '<p>A list of labels to assign to the new game session queue resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>. Once the resource is created, you can use <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.</p>', 'CreateMatchmakingConfigurationInput$Tags' => '<p>A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>. Once the resource is created, you can use <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.</p>', 'CreateMatchmakingRuleSetInput$Tags' => '<p>A list of labels to assign to the new matchmaking rule set resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>. Once the resource is created, you can use <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.</p>', 'CreateScriptInput$Tags' => '<p>A list of labels to assign to the new script resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>. Once the resource is created, you can use <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a> to add, remove, and view tags. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.</p>', 'ListTagsForResourceResponse$Tags' => '<p> The collection of tags that have been assigned to the specified resource. </p>', 'TagResourceRequest$Tags' => '<p>A list of one or more tags to assign to the specified GameLift resource. Tags are developer-defined and structured as key-value pairs. The maximum tag limit may be lower than stated. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services Resources</a> for actual tagging limits.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p> The value for a developer-defined key:value pair for tagging an Amazon Web Services resource. </p>', ], ], 'TaggingFailedException' => [ 'base' => '<p> The requested tagging operation did not succeed. This may be due to invalid tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying. </p>', 'refs' => [], ], 'TargetConfiguration' => [ 'base' => '<p>Settings for a target-based scaling policy (see <a>ScalingPolicy</a>. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon Web Services to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value. </p> <p> <b>Related actions</b> </p> <p> <a>DescribeFleetCapacity</a> | <a>UpdateFleetCapacity</a> | <a>DescribeEC2InstanceLimits</a> | <a>PutScalingPolicy</a> | <a>DescribeScalingPolicies</a> | <a>DeleteScalingPolicy</a> | <a>StopFleetActions</a> | <a>StartFleetActions</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'PutScalingPolicyInput$TargetConfiguration' => '<p>An object that contains settings for a target-based scaling policy.</p>', 'ScalingPolicy$TargetConfiguration' => '<p>An object that contains settings for a target-based scaling policy.</p>', ], ], 'TargetTrackingConfiguration' => [ 'base' => '<p> <b>This data type is used with the GameLift FleetIQ and game server groups.</b> </p> <p>Settings for a target-based scaling policy as part of a <a>GameServerGroupAutoScalingPolicy</a>. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric <code>"PercentUtilizedGameServers"</code> and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value. </p>', 'refs' => [ 'GameServerGroupAutoScalingPolicy$TargetTrackingConfiguration' => '<p>Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric <code>"PercentUtilizedGameServers"</code> and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value. </p>', ], ], 'TerminalRoutingStrategyException' => [ 'base' => '<p>The service is unable to resolve the routing for a particular alias because it has a terminal <a>RoutingStrategy</a> associated with it. The message returned in this exception is the message defined in the routing strategy itself. Such requests should only be retried if the routing strategy for the specified alias is modified. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Alias$CreationTime' => '<p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'Alias$LastUpdatedTime' => '<p>The time that this data object was last modified. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'Build$CreationTime' => '<p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'DescribeFleetEventsInput$StartTime' => '<p>The earliest date to retrieve event logs for. If no start time is specified, this call returns entries starting from when the fleet was created to the specified end time. Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").</p>', 'DescribeFleetEventsInput$EndTime' => '<p>The most recent date to retrieve event logs for. If no end time is specified, this call returns entries from the specified start time up to the present. Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").</p>', 'Event$EventTime' => '<p>Time stamp indicating when this event occurred. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'FleetAttributes$CreationTime' => '<p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'FleetAttributes$TerminationTime' => '<p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'GameServer$RegistrationTime' => '<p>Timestamp that indicates when the game server was created with a <a>RegisterGameServer</a> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'GameServer$LastClaimTime' => '<p>Timestamp that indicates the last time the game server was claimed with a <a>ClaimGameServer</a> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>). This value is used to calculate when a claimed game server\'s status should revert to null.</p>', 'GameServer$LastHealthCheckTime' => '<p>Timestamp that indicates the last time the game server was updated with health status using an <a>UpdateGameServer</a> request. The format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>). After game server registration, this property is only changed when a game server update specifies a health check value.</p>', 'GameServerGroup$CreationTime' => '<p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'GameServerGroup$LastUpdatedTime' => '<p>A timestamp that indicates when this game server group was last updated.</p>', 'GameSession$CreationTime' => '<p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'GameSession$TerminationTime' => '<p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'GameSessionPlacement$StartTime' => '<p>Time stamp indicating when this request was placed in the queue. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'GameSessionPlacement$EndTime' => '<p>Time stamp indicating when this request was completed, canceled, or timed out.</p>', 'Instance$CreationTime' => '<p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'MatchmakingConfiguration$CreationTime' => '<p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'MatchmakingRuleSet$CreationTime' => '<p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'MatchmakingTicket$StartTime' => '<p>Time stamp indicating when this matchmaking request was received. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'MatchmakingTicket$EndTime' => '<p>Time stamp indicating when this matchmaking request stopped being processed due to success, failure, or cancellation. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'PlayerSession$CreationTime' => '<p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'PlayerSession$TerminationTime' => '<p>A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'Script$CreationTime' => '<p>A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'VpcPeeringAuthorization$CreationTime' => '<p>Time stamp indicating when this authorization was issued. Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', 'VpcPeeringAuthorization$ExpirationTime' => '<p>Time stamp indicating when this authorization expires (24 hours after issuance). Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code>).</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>The client failed authentication. Clients should not retry such requests.</p>', 'refs' => [], ], 'UnsupportedRegionException' => [ 'base' => '<p>The requested operation is not supported in the Region specified.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAliasInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'UpdateAliasOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'UpdateBuildInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'UpdateBuildOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'UpdateFleetAttributesInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'UpdateFleetAttributesOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'UpdateFleetCapacityInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'UpdateFleetCapacityOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'UpdateFleetPortSettingsInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'UpdateFleetPortSettingsOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'UpdateGameServerGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGameServerGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGameServerInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGameServerOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGameSessionInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'UpdateGameSessionOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'UpdateGameSessionQueueInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'UpdateGameSessionQueueOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'UpdateMatchmakingConfigurationInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'UpdateMatchmakingConfigurationOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'UpdateRuntimeConfigurationInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'UpdateRuntimeConfigurationOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'UpdateScriptInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateScriptOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidateMatchmakingRuleSetInput' => [ 'base' => '<p>Represents the input for a request operation.</p>', 'refs' => [], ], 'ValidateMatchmakingRuleSetOutput' => [ 'base' => '<p>Represents the returned data in response to a request operation.</p>', 'refs' => [], ], 'VpcPeeringAuthorization' => [ 'base' => '<p>Represents an authorization for a VPC peering connection between the VPC for an Amazon Web Services fleet and another VPC on an account you have access to. This authorization must exist and be valid for the peering connection to be established. Authorizations are valid for 24 hours after they are issued.</p> <p> <b>Related actions</b> </p> <p> <a>CreateVpcPeeringAuthorization</a> | <a>DescribeVpcPeeringAuthorizations</a> | <a>DeleteVpcPeeringAuthorization</a> | <a>CreateVpcPeeringConnection</a> | <a>DescribeVpcPeeringConnections</a> | <a>DeleteVpcPeeringConnection</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'CreateVpcPeeringAuthorizationOutput$VpcPeeringAuthorization' => '<p>Details on the requested VPC peering authorization, including expiration.</p>', 'VpcPeeringAuthorizationList$member' => NULL, ], ], 'VpcPeeringAuthorizationList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcPeeringAuthorizationsOutput$VpcPeeringAuthorizations' => '<p>A collection of objects that describe all valid VPC peering operations for the current Amazon Web Services account.</p>', ], ], 'VpcPeeringConnection' => [ 'base' => '<p>Represents a peering connection between a VPC on one of your Amazon Web Services accounts and the VPC for your Amazon Web Services fleets. This record may be for an active peering connection or a pending connection that has not yet been established.</p> <p> <b>Related actions</b> </p> <p> <a>CreateVpcPeeringAuthorization</a> | <a>DescribeVpcPeeringAuthorizations</a> | <a>DeleteVpcPeeringAuthorization</a> | <a>CreateVpcPeeringConnection</a> | <a>DescribeVpcPeeringConnections</a> | <a>DeleteVpcPeeringConnection</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task</a> </p>', 'refs' => [ 'VpcPeeringConnectionList$member' => NULL, ], ], 'VpcPeeringConnectionList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcPeeringConnectionsOutput$VpcPeeringConnections' => '<p>A collection of VPC peering connection records that match the request.</p>', ], ], 'VpcPeeringConnectionStatus' => [ 'base' => '<p>Represents status information for a VPC peering connection. Status is associated with a <a>VpcPeeringConnection</a> object. Status codes and messages are provided from EC2 (see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpcPeeringConnectionStateReason.html">VpcPeeringConnectionStateReason</a>). Connection status information is also communicated as a fleet <a>Event</a>.</p>', 'refs' => [ 'VpcPeeringConnection$Status' => '<p>The status information about the connection. Status indicates if a connection is pending, successful, or failed.</p>', ], ], 'VpcSubnet' => [ 'base' => NULL, 'refs' => [ 'VpcSubnets$member' => NULL, ], ], 'VpcSubnets' => [ 'base' => NULL, 'refs' => [ 'CreateGameServerGroupInput$VpcSubnets' => '<p>A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs that you\'ve set up. This property cannot be updated after the game server group is created, and the corresponding Auto Scaling group will always use the property value that is set with this request, even if the Auto Scaling group is updated directly.</p>', ], ], 'WeightedCapacity' => [ 'base' => NULL, 'refs' => [ 'InstanceDefinition$WeightedCapacity' => '<p>Instance weighting that indicates how much this instance type contributes to the total capacity of a game server group. Instance weights are used by GameLift FleetIQ to calculate the instance type\'s cost per unit hour and better identify the most cost-effective options. For detailed information on weighting instance capacity, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance Weighting</a> in the <i>Amazon Elastic Compute Cloud Auto Scaling User Guide</i>. Default value is "1".</p>', ], ], 'WholeNumber' => [ 'base' => NULL, 'refs' => [ 'CreateGameServerGroupInput$MinSize' => '<p>The minimum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling events, GameLift FleetIQ and Amazon EC2 do not scale down the group below this minimum. In production, this value should be set to at least 1. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.</p>', 'CreateGameSessionInput$MaximumPlayerSessionCount' => '<p>The maximum number of players that can be connected simultaneously to the game session.</p>', 'CreateGameSessionQueueInput$TimeoutInSeconds' => '<p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>', 'CreateMatchmakingConfigurationInput$AdditionalPlayerCount' => '<p>The number of player slots in a match to keep open for future players. For example, if the configuration\'s rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', 'EC2InstanceCounts$DESIRED' => '<p>Ideal number of active instances. GameLift will always try to maintain the desired number of instances. Capacity is scaled up or down by changing the desired instances. </p>', 'EC2InstanceCounts$MINIMUM' => '<p>The minimum instance count value allowed.</p>', 'EC2InstanceCounts$MAXIMUM' => '<p>The maximum instance count value allowed.</p>', 'EC2InstanceCounts$PENDING' => '<p>Number of instances that are starting but not yet active.</p>', 'EC2InstanceCounts$ACTIVE' => '<p>Actual number of instances that are ready to host game sessions.</p>', 'EC2InstanceCounts$IDLE' => '<p>Number of active instances that are not currently hosting a game session.</p>', 'EC2InstanceCounts$TERMINATING' => '<p>Number of instances that are no longer active but haven\'t yet been terminated.</p>', 'EC2InstanceLimit$CurrentInstances' => '<p>The number of instances for the specified type and location that are currently being used by the Amazon Web Services account. </p>', 'EC2InstanceLimit$InstanceLimit' => '<p>The number of instances that is allowed for the specified instance type and location.</p>', 'FleetUtilization$ActiveServerProcessCount' => '<p>The number of server processes in <code>ACTIVE</code> status that are currently running across all instances in the fleet location. </p>', 'FleetUtilization$ActiveGameSessionCount' => '<p>The number of active game sessions that are currently being hosted across all instances in the fleet location.</p>', 'FleetUtilization$CurrentPlayerSessionCount' => '<p>The number of active player sessions that are currently being hosted across all instances in the fleet location.</p>', 'FleetUtilization$MaximumPlayerSessionCount' => '<p>The maximum number of players allowed across all game sessions that are currently being hosted across all instances in the fleet location.</p>', 'GameSession$CurrentPlayerSessionCount' => '<p>Number of players currently in the game session.</p>', 'GameSession$MaximumPlayerSessionCount' => '<p>The maximum number of players that can be connected simultaneously to the game session.</p>', 'GameSessionPlacement$MaximumPlayerSessionCount' => '<p>The maximum number of players that can be connected simultaneously to the game session.</p>', 'GameSessionQueue$TimeoutInSeconds' => '<p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>', 'MatchmakingConfiguration$AdditionalPlayerCount' => '<p>The number of player slots in a match to keep open for future players. For example, if the configuration\'s rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used when <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', 'MatchmakingTicket$EstimatedWaitTime' => '<p>Average amount of time (in seconds) that players are currently waiting for a match. If there is not enough recent data, this property may be empty.</p>', 'PlayerLatencyPolicy$MaximumIndividualPlayerLatencyMilliseconds' => '<p>The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.</p>', 'PlayerLatencyPolicy$PolicyDurationSeconds' => '<p>The length of time, in seconds, that the policy is enforced while placing a new game session. A null value for this property means that the policy is enforced until the queue times out.</p>', 'ResourceCreationLimitPolicy$NewGameSessionsPerCreator' => '<p>The maximum number of game sessions that an individual can create during the policy period. </p>', 'ResourceCreationLimitPolicy$PolicyPeriodInMinutes' => '<p>The time span used in evaluating the resource creation limit policy. </p>', 'StartGameSessionPlacementInput$MaximumPlayerSessionCount' => '<p>The maximum number of players that can be connected simultaneously to the game session.</p>', 'UpdateFleetCapacityInput$DesiredInstances' => '<p>The number of Amazon EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.</p>', 'UpdateFleetCapacityInput$MinSize' => '<p>The minimum number of instances that are allowed in the specified fleet location. If this parameter is not set, the default is 0.</p>', 'UpdateFleetCapacityInput$MaxSize' => '<p>The maximum number of instances that are allowed in the specified fleet location. If this parameter is not set, the default is 1.</p>', 'UpdateGameSessionInput$MaximumPlayerSessionCount' => '<p>The maximum number of players that can be connected simultaneously to the game session.</p>', 'UpdateGameSessionQueueInput$TimeoutInSeconds' => '<p>The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a <code>TIMED_OUT</code> status.</p>', 'UpdateMatchmakingConfigurationInput$AdditionalPlayerCount' => '<p>The number of player slots in a match to keep open for future players. For example, if the configuration\'s rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.</p>', ], ], 'ZipBlob' => [ 'base' => NULL, 'refs' => [ 'CreateScriptInput$ZipFile' => '<p>A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.</p> <p>When using the Amazon Web Services CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: <code>--zip-file fileb://myRealtimeScript.zip</code>.</p>', 'UpdateScriptInput$ZipFile' => '<p>A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.</p> <p>When using the Amazon Web Services CLI tool to create a script, this parameter is set to the zip file name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example: <code>--zip-file fileb://myRealtimeScript.zip</code>.</p>', ], ], ],];
