<?php
// This file was auto-generated from sdk-root/src/data/apprunner/2020-05-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>App Runner</fullname> <p>App Runner is an application service that provides a fast, simple, and cost-effective way to go directly from an existing container image or source code to a running service in the Amazon Web Services Cloud in seconds. You don\'t need to learn new technologies, decide which compute service to use, or understand how to provision and configure Amazon Web Services resources.</p> <p>App Runner connects directly to your container registry or source code repository. It provides an automatic delivery pipeline with fully managed operations, high performance, scalability, and security.</p> <p>For more information about App Runner, see the <a href="https://docs.aws.amazon.com/apprunner/latest/dg/">App Runner Developer Guide</a>. For release information, see the <a href="https://docs.aws.amazon.com/apprunner/latest/relnotes/">App Runner Release Notes</a>.</p> <p> To install the Software Development Kits (SDKs), Integrated Development Environment (IDE) Toolkits, and command line tools that you can use to access the API, see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.</p> <p> <b>Endpoints</b> </p> <p>For a list of Region-specific endpoints that App Runner supports, see <a href="https://docs.aws.amazon.com/general/latest/gr/apprunner.html">App Runner endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'operations' => [ 'AssociateCustomDomain' => '<p>Associate your own domain name with the App Runner subdomain URL of your App Runner service.</p> <p>After you call <code>AssociateCustomDomain</code> and receive a successful response, use the information in the <a>CustomDomain</a> record that\'s returned to add CNAME records to your Domain Name System (DNS). For each mapped domain name, add a mapping to the target App Runner subdomain and one or more certificate validation records. App Runner then performs DNS validation to verify that you own or control the domain name that you associated. App Runner tracks domain validity in a certificate stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide">AWS Certificate Manager (ACM)</a>.</p>', 'CreateAutoScalingConfiguration' => '<p>Create an App Runner automatic scaling configuration resource. App Runner requires this resource when you create App Runner services that require non-default auto scaling settings. You can share an auto scaling configuration across multiple services.</p> <p>Create multiple revisions of a configuration by calling this action multiple times using the same <code>AutoScalingConfigurationName</code>. The call returns incremental <code>AutoScalingConfigurationRevision</code> values. When you create a service, you can set it to use the latest active revision of an auto scaling configuration or a specific revision.</p> <p>Configure a higher <code>MinSize</code> to increase the spread of your App Runner service over more Availability Zones in the Amazon Web Services Region. The tradeoff is a higher minimal cost.</p> <p>Configure a lower <code>MaxSize</code> to control your cost. The tradeoff is lower responsiveness during peak demand.</p>', 'CreateConnection' => '<p>Create an App Runner connection resource. App Runner requires a connection resource when you create App Runner services that access private repositories from certain third-party providers. You can share a connection across multiple services.</p> <p>A connection resource is needed to access GitHub repositories. GitHub requires a user interface approval process through the App Runner console before you can use the connection.</p>', 'CreateService' => '<p>Create an App Runner service. After the service is created, the action also automatically starts a deployment.</p> <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html">ListOperations</a> call to track the operation\'s progress.</p>', 'CreateVpcConnector' => '<p>Create an App Runner VPC connector resource. App Runner requires this resource when you want to associate your App Runner service to a custom Amazon Virtual Private Cloud (Amazon VPC).</p>', 'DeleteAutoScalingConfiguration' => '<p>Delete an App Runner automatic scaling configuration resource. You can delete a specific revision or the latest active revision. You can\'t delete a configuration that\'s used by one or more App Runner services.</p>', 'DeleteConnection' => '<p>Delete an App Runner connection. You must first ensure that there are no running App Runner services that use this connection. If there are any, the <code>DeleteConnection</code> action fails.</p>', 'DeleteService' => '<p>Delete an App Runner service.</p> <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a>ListOperations</a> call to track the operation\'s progress.</p>', 'DeleteVpcConnector' => '<p>Delete an App Runner VPC connector resource. You can\'t delete a connector that\'s used by one or more App Runner services.</p>', 'DescribeAutoScalingConfiguration' => '<p>Return a full description of an App Runner automatic scaling configuration resource.</p>', 'DescribeCustomDomains' => '<p>Return a description of custom domain names that are associated with an App Runner service.</p>', 'DescribeService' => '<p>Return a full description of an App Runner service.</p>', 'DescribeVpcConnector' => '<p>Return a description of an App Runner VPC connector resource.</p>', 'DisassociateCustomDomain' => '<p>Disassociate a custom domain name from an App Runner service.</p> <p>Certificates tracking domain validity are associated with a custom domain and are stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide">AWS Certificate Manager (ACM)</a>. These certificates aren\'t deleted as part of this action. App Runner delays certificate deletion for 30 days after a domain is disassociated from your service.</p>', 'ListAutoScalingConfigurations' => '<p>Returns a list of App Runner automatic scaling configurations in your Amazon Web Services account. You can query the revisions for a specific configuration name or the revisions for all configurations in your account. You can optionally query only the latest revision of each requested name.</p>', 'ListConnections' => '<p>Returns a list of App Runner connections that are associated with your Amazon Web Services account.</p>', 'ListOperations' => '<p>Return a list of operations that occurred on an App Runner service.</p> <p>The resulting list of <a>OperationSummary</a> objects is sorted in reverse chronological order. The first object on the list represents the last started operation.</p>', 'ListServices' => '<p>Returns a list of running App Runner services in your Amazon Web Services account.</p>', 'ListTagsForResource' => '<p>List tags that are associated with for an App Runner resource. The response contains a list of tag key-value pairs.</p>', 'ListVpcConnectors' => '<p>Returns a list of App Runner VPC connectors in your Amazon Web Services account.</p>', 'PauseService' => '<p>Pause an active App Runner service. App Runner reduces compute capacity for the service to zero and loses state (for example, ephemeral storage is removed).</p> <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a>ListOperations</a> call to track the operation\'s progress.</p>', 'ResumeService' => '<p>Resume an active App Runner service. App Runner provisions compute capacity for the service.</p> <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a>ListOperations</a> call to track the operation\'s progress.</p>', 'StartDeployment' => '<p>Initiate a manual deployment of the latest commit in a source code repository or the latest image in a source image repository to an App Runner service.</p> <p>For a source code repository, App Runner retrieves the commit and builds a Docker image. For a source image repository, App Runner retrieves the latest Docker image. In both cases, App Runner then deploys the new image to your service and starts a new container instance.</p> <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a>ListOperations</a> call to track the operation\'s progress.</p>', 'TagResource' => '<p>Add tags to, or update the tag values of, an App Runner resource. A tag is a key-value pair.</p>', 'UntagResource' => '<p>Remove tags from an App Runner resource.</p>', 'UpdateService' => '<p>Update an App Runner service. You can update the source configuration and instance configuration of the service. You can also update the ARN of the auto scaling configuration resource that\'s associated with the service. However, you can\'t change the name or the encryption configuration of the service. These can be set only when you create the service.</p> <p>To update the tags applied to your service, use the separate actions <a>TagResource</a> and <a>UntagResource</a>.</p> <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a>ListOperations</a> call to track the operation\'s progress.</p>', ], 'shapes' => [ 'ASConfigMaxConcurrency' => [ 'base' => NULL, 'refs' => [ 'CreateAutoScalingConfigurationRequest$MaxConcurrency' => '<p>The maximum number of concurrent requests that you want an instance to process. If the number of concurrent requests exceeds this limit, App Runner scales up your service.</p> <p>Default: <code>100</code> </p>', ], ], 'ASConfigMaxSize' => [ 'base' => NULL, 'refs' => [ 'CreateAutoScalingConfigurationRequest$MaxSize' => '<p>The maximum number of instances that your service scales up to. At most <code>MaxSize</code> instances actively serve traffic for your service.</p> <p>Default: <code>25</code> </p>', ], ], 'ASConfigMinSize' => [ 'base' => NULL, 'refs' => [ 'CreateAutoScalingConfigurationRequest$MinSize' => '<p>The minimum number of instances that App Runner provisions for your service. The service always has at least <code>MinSize</code> provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.</p> <p>App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.</p> <p>Default: <code>1</code> </p>', ], ], 'AppRunnerResourceArn' => [ 'base' => NULL, 'refs' => [ 'AssociateCustomDomainRequest$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that you want to associate a custom domain name with.</p>', 'AssociateCustomDomainResponse$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service with which a custom domain name is associated.</p>', 'AuthenticationConfiguration$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a source repository. It\'s required for GitHub code repositories.</p>', 'AutoScalingConfiguration$AutoScalingConfigurationArn' => '<p>The Amazon Resource Name (ARN) of this auto scaling configuration.</p>', 'AutoScalingConfigurationSummary$AutoScalingConfigurationArn' => '<p>The Amazon Resource Name (ARN) of this auto scaling configuration.</p>', 'Connection$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of this connection.</p>', 'ConnectionSummary$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of this connection.</p>', 'CreateServiceRequest$AutoScalingConfigurationArn' => '<p>The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with the App Runner service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.</p>', 'DeleteAutoScalingConfigurationRequest$AutoScalingConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want to delete.</p> <p>The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either <code>.../<i>name</i> </code> or <code>.../<i>name</i>/<i>revision</i> </code>. If a revision isn\'t specified, the latest active revision is deleted.</p>', 'DeleteConnectionRequest$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the App Runner connection that you want to delete.</p>', 'DeleteServiceRequest$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that you want to delete.</p>', 'DeleteVpcConnectorRequest$VpcConnectorArn' => '<p>The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to delete.</p> <p>The ARN must be a full VPC connector ARN.</p>', 'DescribeAutoScalingConfigurationRequest$AutoScalingConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want a description for.</p> <p>The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either <code>.../<i>name</i> </code> or <code>.../<i>name</i>/<i>revision</i> </code>. If a revision isn\'t specified, the latest active revision is described.</p>', 'DescribeCustomDomainsRequest$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that you want associated custom domain names to be described for.</p>', 'DescribeCustomDomainsResponse$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service whose associated custom domain names you want to describe.</p>', 'DescribeServiceRequest$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that you want a description for.</p>', 'DescribeVpcConnectorRequest$VpcConnectorArn' => '<p>The Amazon Resource Name (ARN) of the App Runner VPC connector that you want a description for.</p> <p>The ARN must be a full VPC connector ARN.</p>', 'DisassociateCustomDomainRequest$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that you want to disassociate a custom domain name from.</p>', 'DisassociateCustomDomainResponse$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that a custom domain name is disassociated from.</p>', 'EgressConfiguration$VpcConnectorArn' => '<p>The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when <code>EgressType = VPC</code>.</p>', 'ListOperationsRequest$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that you want a list of operations for.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that a tag list is requested for.</p> <p>It must be the ARN of an App Runner resource.</p>', 'OperationSummary$TargetArn' => '<p>The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner service).</p>', 'PauseServiceRequest$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that you want to pause.</p>', 'ResumeServiceRequest$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that you want to resume.</p>', 'Service$ServiceArn' => '<p>The Amazon Resource Name (ARN) of this service.</p>', 'ServiceSummary$ServiceArn' => '<p>The Amazon Resource Name (ARN) of this service.</p>', 'StartDeploymentRequest$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that you want to manually deploy to.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to update tags for.</p> <p>It must be the ARN of an App Runner resource.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p> <p>It must be the ARN of an App Runner resource.</p>', 'UpdateServiceRequest$ServiceArn' => '<p>The Amazon Resource Name (ARN) of the App Runner service that you want to update.</p>', 'UpdateServiceRequest$AutoScalingConfigurationArn' => '<p>The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with the App Runner service.</p>', 'VpcConnector$VpcConnectorArn' => '<p>The Amazon Resource Name (ARN) of this VPC connector.</p>', ], ], 'AssociateCustomDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateCustomDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'AuthenticationConfiguration' => [ 'base' => '<p>Describes resources needed to authenticate access to some source repositories. The specific resource depends on the repository provider.</p>', 'refs' => [ 'SourceConfiguration$AuthenticationConfiguration' => '<p>Describes the resources that are needed to authenticate access to some source repositories.</p>', ], ], 'AutoScalingConfiguration' => [ 'base' => '<p>Describes an App Runner automatic scaling configuration resource.</p> <p>A higher <code>MinSize</code> increases the spread of your App Runner service over more Availability Zones in the Amazon Web Services Region. The tradeoff is a higher minimal cost.</p> <p>A lower <code>MaxSize</code> controls your cost. The tradeoff is lower responsiveness during peak demand.</p> <p>Multiple revisions of a configuration might have the same <code>AutoScalingConfigurationName</code> and different <code>AutoScalingConfigurationRevision</code> values.</p>', 'refs' => [ 'CreateAutoScalingConfigurationResponse$AutoScalingConfiguration' => '<p>A description of the App Runner auto scaling configuration that\'s created by this request.</p>', 'DeleteAutoScalingConfigurationResponse$AutoScalingConfiguration' => '<p>A description of the App Runner auto scaling configuration that this request just deleted.</p>', 'DescribeAutoScalingConfigurationResponse$AutoScalingConfiguration' => '<p>A full description of the App Runner auto scaling configuration that you specified in this request.</p>', ], ], 'AutoScalingConfigurationName' => [ 'base' => NULL, 'refs' => [ 'AutoScalingConfiguration$AutoScalingConfigurationName' => '<p>The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.</p>', 'AutoScalingConfigurationSummary$AutoScalingConfigurationName' => '<p>The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.</p>', 'CreateAutoScalingConfigurationRequest$AutoScalingConfigurationName' => '<p>A name for the auto scaling configuration. When you use it for the first time in an Amazon Web Services Region, App Runner creates revision number <code>1</code> of this name. When you use the same name in subsequent calls, App Runner creates incremental revisions of the configuration.</p> <note> <p>The name <code>DefaultConfiguration</code> is reserved (it\'s the configuration that App Runner uses if you don\'t provide a custome one). You can\'t use it to create a new auto scaling configuration, and you can\'t create a revision of it.</p> <p>When you want to use your own auto scaling configuration for your App Runner service, <i>create a configuration with a different name</i>, and then provide it when you create or update your service.</p> </note>', 'ListAutoScalingConfigurationsRequest$AutoScalingConfigurationName' => '<p>The name of the App Runner auto scaling configuration that you want to list. If specified, App Runner lists revisions that share this name. If not specified, App Runner returns revisions of all configurations.</p>', ], ], 'AutoScalingConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'AutoScalingConfiguration$Status' => '<p>The current state of the auto scaling configuration. If the status of a configuration revision is <code>INACTIVE</code>, it was deleted and can\'t be used. Inactive configuration revisions are permanently removed some time after they are deleted.</p>', ], ], 'AutoScalingConfigurationSummary' => [ 'base' => '<p>Provides summary information about an App Runner automatic scaling configuration resource.</p> <p>This type contains limited information about an auto scaling configuration. It includes only identification information, without configuration details. It\'s returned by the <a>ListAutoScalingConfigurations</a> action. Complete configuration information is returned by the <a>CreateAutoScalingConfiguration</a>, <a>DescribeAutoScalingConfiguration</a>, and <a>DeleteAutoScalingConfiguration</a> actions using the <a>AutoScalingConfiguration</a> type.</p>', 'refs' => [ 'AutoScalingConfigurationSummaryList$member' => NULL, 'Service$AutoScalingConfigurationSummary' => '<p>Summary information for the App Runner automatic scaling configuration resource that\'s associated with this service.</p>', ], ], 'AutoScalingConfigurationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAutoScalingConfigurationsResponse$AutoScalingConfigurationSummaryList' => '<p>A list of summary information records for auto scaling configurations. In a paginated request, the request returns up to <code>MaxResults</code> records for each call.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AutoScalingConfiguration$Latest' => '<p>It\'s set to <code>true</code> for the configuration with the highest <code>Revision</code> among all configurations that share the same <code>Name</code>. It\'s set to <code>false</code> otherwise.</p>', 'ListAutoScalingConfigurationsRequest$LatestOnly' => '<p>Set to <code>true</code> to list only the latest revision for each requested configuration name.</p> <p>Keep as <code>false</code> to list all revisions for each requested configuration name.</p> <p>Default: <code>false</code> </p>', ], ], 'BuildCommand' => [ 'base' => NULL, 'refs' => [ 'CodeConfigurationValues$BuildCommand' => '<p>The command App Runner runs to build your application.</p>', ], ], 'CertificateValidationRecord' => [ 'base' => '<p>Describes a certificate CNAME record to add to your DNS. For more information, see <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_AssociateCustomDomain.html">AssociateCustomDomain</a>.</p>', 'refs' => [ 'CertificateValidationRecordList$member' => NULL, ], ], 'CertificateValidationRecordList' => [ 'base' => NULL, 'refs' => [ 'CustomDomain$CertificateValidationRecords' => '<p>A list of certificate CNAME records that\'s used for this domain name.</p>', ], ], 'CertificateValidationRecordStatus' => [ 'base' => NULL, 'refs' => [ 'CertificateValidationRecord$Status' => '<p>The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code> after App Runner completes validation with your DNS.</p>', ], ], 'CodeConfiguration' => [ 'base' => '<p>Describes the configuration that App Runner uses to build and run an App Runner service from a source code repository.</p>', 'refs' => [ 'CodeRepository$CodeConfiguration' => '<p>Configuration for building and running the service from a source code repository.</p>', ], ], 'CodeConfigurationValues' => [ 'base' => '<p>Describes the basic configuration needed for building and running an App Runner service. This type doesn\'t support the full set of possible configuration options. Fur full configuration capabilities, use a <code>apprunner.yaml</code> file in the source code repository.</p>', 'refs' => [ 'CodeConfiguration$CodeConfigurationValues' => '<p>The basic configuration for building and running the App Runner service. Use it to quickly launch an App Runner service without providing a <code>apprunner.yaml</code> file in the source code repository (or ignoring the file if it exists).</p>', ], ], 'CodeRepository' => [ 'base' => '<p>Describes a source code repository.</p>', 'refs' => [ 'SourceConfiguration$CodeRepository' => '<p>The description of a source code repository.</p> <p>You must provide either this member or <code>ImageRepository</code> (but not both).</p>', ], ], 'ConfigurationSource' => [ 'base' => NULL, 'refs' => [ 'CodeConfiguration$ConfigurationSource' => '<p>The source of the App Runner configuration. Values are interpreted as follows:</p> <ul> <li> <p> <code>REPOSITORY</code> – App Runner reads configuration values from the <code>apprunner.yaml</code> file in the source code repository and ignores <code>CodeConfigurationValues</code>.</p> </li> <li> <p> <code>API</code> – App Runner uses configuration values provided in <code>CodeConfigurationValues</code> and ignores the <code>apprunner.yaml</code> file in the source code repository.</p> </li> </ul>', ], ], 'Connection' => [ 'base' => '<p>Describes an App Runner connection resource.</p>', 'refs' => [ 'CreateConnectionResponse$Connection' => '<p>A description of the App Runner connection that\'s created by this request.</p>', 'DeleteConnectionResponse$Connection' => '<p>A description of the App Runner connection that this request just deleted.</p>', ], ], 'ConnectionName' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionName' => '<p>The customer-provided connection name.</p>', 'ConnectionSummary$ConnectionName' => '<p>The customer-provided connection name.</p>', 'CreateConnectionRequest$ConnectionName' => '<p>A name for the new connection. It must be unique across all App Runner connections for the Amazon Web Services account in the Amazon Web Services Region.</p>', 'ListConnectionsRequest$ConnectionName' => '<p>If specified, only this connection is returned. If not specified, the result isn\'t filtered by name.</p>', ], ], 'ConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'Connection$Status' => '<p>The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the connection to create an App Runner service.</p>', 'ConnectionSummary$Status' => '<p>The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the connection to create an App Runner service.</p>', ], ], 'ConnectionSummary' => [ 'base' => '<p>Provides summary information about an App Runner connection resource.</p>', 'refs' => [ 'ConnectionSummaryList$member' => NULL, ], ], 'ConnectionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListConnectionsResponse$ConnectionSummaryList' => '<p>A list of summary information records for connections. In a paginated request, the request returns up to <code>MaxResults</code> records for each call.</p>', ], ], 'Cpu' => [ 'base' => NULL, 'refs' => [ 'InstanceConfiguration$Cpu' => '<p>The number of CPU units reserved for each instance of your App Runner service.</p> <p>Default: <code>1 vCPU</code> </p>', ], ], 'CreateAutoScalingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutoScalingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomDomain' => [ 'base' => '<p>Describes a custom domain that\'s associated with an App Runner service.</p>', 'refs' => [ 'AssociateCustomDomainResponse$CustomDomain' => '<p>A description of the domain name that\'s being associated.</p>', 'CustomDomainList$member' => NULL, 'DisassociateCustomDomainResponse$CustomDomain' => '<p>A description of the domain name that\'s being disassociated.</p>', ], ], 'CustomDomainAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'CustomDomain$Status' => '<p>The current state of the domain name association.</p>', ], ], 'CustomDomainList' => [ 'base' => NULL, 'refs' => [ 'DescribeCustomDomainsResponse$CustomDomains' => '<p>A list of descriptions of custom domain names that are associated with the service. In a paginated request, the request returns up to <code>MaxResults</code> records per call.</p>', ], ], 'DeleteAutoScalingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAutoScalingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoScalingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoScalingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomDomainsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeCustomDomainsRequest$MaxResults' => '<p>The maximum number of results that each response (result page) can include. It\'s used for a paginated request.</p> <p>If you don\'t specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>', ], ], 'DescribeCustomDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateCustomDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateCustomDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'AssociateCustomDomainRequest$DomainName' => '<p>A custom domain endpoint to associate. Specify a root domain (for example, <code>example.com</code>), a subdomain (for example, <code>login.example.com</code> or <code>admin.login.example.com</code>), or a wildcard (for example, <code>*.example.com</code>).</p>', 'CustomDomain$DomainName' => '<p>An associated custom domain endpoint. It can be a root domain (for example, <code>example.com</code>), a subdomain (for example, <code>login.example.com</code> or <code>admin.login.example.com</code>), or a wildcard (for example, <code>*.example.com</code>).</p>', 'DisassociateCustomDomainRequest$DomainName' => '<p>The domain name that you want to disassociate from the App Runner service.</p>', ], ], 'EgressConfiguration' => [ 'base' => '<p>Describes configuration settings related to outbound network traffic of an App Runner service.</p>', 'refs' => [ 'NetworkConfiguration$EgressConfiguration' => '<p>Network configuration settings for outbound message traffic.</p>', ], ], 'EgressType' => [ 'base' => NULL, 'refs' => [ 'EgressConfiguration$EgressType' => '<p>The type of egress configuration.</p> <p>Set to <code>DEFAULT</code> for access to resources hosted on public networks.</p> <p>Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code>.</p>', ], ], 'EncryptionConfiguration' => [ 'base' => '<p>Describes a custom encryption key that App Runner uses to encrypt copies of the source repository and service logs.</p>', 'refs' => [ 'CreateServiceRequest$EncryptionConfiguration' => '<p>An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an Amazon Web Services managed key.</p>', 'Service$EncryptionConfiguration' => '<p>The encryption key that App Runner uses to encrypt the service logs and the copy of the source repository that App Runner maintains for the service. It can be either a customer-provided encryption key or an Amazon Web Services managed key.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServiceErrorException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'InvalidStateException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, ], ], 'HealthCheckConfiguration' => [ 'base' => '<p>Describes the settings for the health check that App Runner performs to monitor the health of a service.</p>', 'refs' => [ 'CreateServiceRequest$HealthCheckConfiguration' => '<p>The settings for the health check that App Runner performs to monitor the health of the App Runner service.</p>', 'Service$HealthCheckConfiguration' => '<p>The settings for the health check that App Runner performs to monitor the health of this service.</p>', 'UpdateServiceRequest$HealthCheckConfiguration' => '<p>The settings for the health check that App Runner performs to monitor the health of the App Runner service.</p>', ], ], 'HealthCheckHealthyThreshold' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfiguration$HealthyThreshold' => '<p>The number of consecutive checks that must succeed before App Runner decides that the service is healthy.</p> <p>Default: <code>1</code> </p>', ], ], 'HealthCheckInterval' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfiguration$Interval' => '<p>The time interval, in seconds, between health checks.</p> <p>Default: <code>5</code> </p>', ], ], 'HealthCheckPath' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfiguration$Path' => '<p>The URL that health check requests are sent to.</p> <p> <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code>.</p> <p>Default: <code>"/"</code> </p>', ], ], 'HealthCheckProtocol' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfiguration$Protocol' => '<p>The IP protocol that App Runner uses to perform health checks for your service.</p> <p>If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP path specified by <code>Path</code>.</p> <p>Default: <code>TCP</code> </p>', ], ], 'HealthCheckTimeout' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfiguration$Timeout' => '<p>The time, in seconds, to wait for a health check response before deciding it failed.</p> <p>Default: <code>2</code> </p>', ], ], 'HealthCheckUnhealthyThreshold' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfiguration$UnhealthyThreshold' => '<p>The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.</p> <p>Default: <code>5</code> </p>', ], ], 'ImageConfiguration' => [ 'base' => '<p>Describes the configuration that App Runner uses to run an App Runner service using an image pulled from a source image repository.</p>', 'refs' => [ 'ImageRepository$ImageConfiguration' => '<p>Configuration for running the identified image.</p>', ], ], 'ImageIdentifier' => [ 'base' => NULL, 'refs' => [ 'ImageRepository$ImageIdentifier' => '<p>The identifier of an image.</p> <p>For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the image name format, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an image</a> in the <i>Amazon ECR User Guide</i>.</p>', ], ], 'ImageRepository' => [ 'base' => '<p>Describes a source image repository.</p>', 'refs' => [ 'SourceConfiguration$ImageRepository' => '<p>The description of a source image repository.</p> <p>You must provide either this member or <code>CodeRepository</code> (but not both).</p>', ], ], 'ImageRepositoryType' => [ 'base' => NULL, 'refs' => [ 'ImageRepository$ImageRepositoryType' => '<p>The type of the image repository. This reflects the repository provider and whether the repository is private or public.</p>', ], ], 'InstanceConfiguration' => [ 'base' => '<p>Describes the runtime configuration of an App Runner service instance (scaling unit).</p>', 'refs' => [ 'CreateServiceRequest$InstanceConfiguration' => '<p>The runtime configuration of instances (scaling units) of the App Runner service.</p>', 'Service$InstanceConfiguration' => '<p>The runtime configuration of instances (scaling units) of this service.</p>', 'UpdateServiceRequest$InstanceConfiguration' => '<p>The runtime configuration to apply to instances (scaling units) of the App Runner service.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AutoScalingConfiguration$AutoScalingConfigurationRevision' => '<p>The revision of this auto scaling configuration. It\'s unique among all the active configurations (<code>"Status": "ACTIVE"</code>) that share the same <code>AutoScalingConfigurationName</code>.</p>', 'AutoScalingConfiguration$MaxConcurrency' => '<p>The maximum number of concurrent requests that an instance processes. If the number of concurrent requests exceeds this limit, App Runner scales the service up.</p>', 'AutoScalingConfiguration$MinSize' => '<p>The minimum number of instances that App Runner provisions for a service. The service always has at least <code>MinSize</code> provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.</p> <p>App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.</p>', 'AutoScalingConfiguration$MaxSize' => '<p>The maximum number of instances that a service scales up to. At most <code>MaxSize</code> instances actively serve traffic for your service.</p>', 'AutoScalingConfigurationSummary$AutoScalingConfigurationRevision' => '<p>The revision of this auto scaling configuration. It\'s unique among all the active configurations (<code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.</p>', 'VpcConnector$VpcConnectorRevision' => '<p>The revision of this VPC connector. It\'s unique among all the active connectors (<code>"Status": "ACTIVE"</code>) that share the same <code>Name</code>.</p> <note> <p>At this time, App Runner supports only one revision per name.</p> </note>', ], ], 'InternalServiceErrorException' => [ 'base' => '<p>An unexpected service exception occurred.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>One or more input parameters aren\'t valid. Refer to the API action\'s document page, correct the input parameters, and try the action again.</p>', 'refs' => [], ], 'InvalidStateException' => [ 'base' => '<p>You can\'t perform this action when the resource is in its current state.</p>', 'refs' => [], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$KmsKey' => '<p>The ARN of the KMS key that\'s used for encryption.</p>', ], ], 'ListAutoScalingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAutoScalingConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConnectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOperationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListOperationsRequest$MaxResults' => '<p>The maximum number of results to include in each response (result page). It\'s used for a paginated request.</p> <p>If you don\'t specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>', ], ], 'ListOperationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOperationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVpcConnectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVpcConnectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAutoScalingConfigurationsRequest$MaxResults' => '<p>The maximum number of results to include in each response (result page). It\'s used for a paginated request.</p> <p>If you don\'t specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>', 'ListConnectionsRequest$MaxResults' => '<p>The maximum number of results to include in each response (result page). Used for a paginated request.</p> <p>If you don\'t specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>', 'ListVpcConnectorsRequest$MaxResults' => '<p>The maximum number of results to include in each response (result page). It\'s used for a paginated request.</p> <p>If you don\'t specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>', ], ], 'Memory' => [ 'base' => NULL, 'refs' => [ 'InstanceConfiguration$Memory' => '<p>The amount of memory, in MB or GB, reserved for each instance of your App Runner service.</p> <p>Default: <code>2 GB</code> </p>', ], ], 'NetworkConfiguration' => [ 'base' => '<p>Describes configuration settings related to network traffic of an App Runner service. Consists of embedded objects for each configurable network feature.</p>', 'refs' => [ 'CreateServiceRequest$NetworkConfiguration' => '<p>Configuration settings related to network traffic of the web application that the App Runner service runs.</p>', 'Service$NetworkConfiguration' => '<p>Configuration settings related to network traffic of the web application that this service runs.</p>', 'UpdateServiceRequest$NetworkConfiguration' => '<p>Configuration settings related to network traffic of the web application that the App Runner service runs.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAutoScalingConfigurationsRequest$NextToken' => '<p>A token from a previous result page. It\'s used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones that are specified in the initial request.</p> <p>If you don\'t specify <code>NextToken</code>, the request retrieves the first result page.</p>', 'ListAutoScalingConfigurationsResponse$NextToken' => '<p>The token that you can pass in a subsequent request to get the next result page. It\'s returned in a paginated request.</p>', 'ListConnectionsRequest$NextToken' => '<p>A token from a previous result page. Used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones specified in the initial request.</p> <p>If you don\'t specify <code>NextToken</code>, the request retrieves the first result page.</p>', 'ListConnectionsResponse$NextToken' => '<p>The token that you can pass in a subsequent request to get the next result page. Returned in a paginated request.</p>', 'ListVpcConnectorsRequest$NextToken' => '<p>A token from a previous result page. It\'s used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones that are specified in the initial request.</p> <p>If you don\'t specify <code>NextToken</code>, the request retrieves the first result page.</p>', 'ListVpcConnectorsResponse$NextToken' => '<p>The token that you can pass in a subsequent request to get the next result page. It\'s returned in a paginated request.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'AssociateCustomDomainRequest$EnableWWWSubdomain' => '<p>Set to <code>true</code> to associate the subdomain <code>www.<i>DomainName</i> </code> with the App Runner service in addition to the base domain.</p> <p>Default: <code>true</code> </p>', 'CustomDomain$EnableWWWSubdomain' => '<p>When <code>true</code>, the subdomain <code>www.<i>DomainName</i> </code> is associated with the App Runner service in addition to the base domain.</p>', 'SourceConfiguration$AutoDeploymentsEnabled' => '<p>If <code>true</code>, continuous integration from the source repository is enabled for the App Runner service. Each repository change (including any source code commit or new image version) starts a deployment.</p> <p>Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or an ECR repository that\'s in an Amazon Web Services account other than the one that the service is in. App Runner sets to <code>true</code> in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).</p>', ], ], 'OperationStatus' => [ 'base' => NULL, 'refs' => [ 'OperationSummary$Status' => '<p>The current state of the operation.</p>', ], ], 'OperationSummary' => [ 'base' => '<p>Provides summary information for an operation that occurred on an App Runner service.</p>', 'refs' => [ 'OperationSummaryList$member' => NULL, ], ], 'OperationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListOperationsResponse$OperationSummaryList' => '<p>A list of operation summary information records. In a paginated request, the request returns up to <code>MaxResults</code> records for each call.</p>', ], ], 'OperationType' => [ 'base' => NULL, 'refs' => [ 'OperationSummary$Type' => '<p>The type of operation. It indicates a specific action that occured.</p>', ], ], 'PauseServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'PauseServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ProviderType' => [ 'base' => NULL, 'refs' => [ 'Connection$ProviderType' => '<p>The source repository provider.</p>', 'ConnectionSummary$ProviderType' => '<p>The source repository provider.</p>', 'CreateConnectionRequest$ProviderType' => '<p>The source repository provider.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource doesn\'t exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>', 'refs' => [], ], 'ResumeServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResumeServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'AuthenticationConfiguration$AccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository. It\'s required for ECR image repositories (but not for ECR Public repositories).</p>', 'InstanceConfiguration$InstanceRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any Amazon Web Services APIs.</p>', ], ], 'Runtime' => [ 'base' => NULL, 'refs' => [ 'CodeConfigurationValues$Runtime' => '<p>A runtime environment type for building and running an App Runner service. It represents a programming language runtime.</p>', ], ], 'RuntimeEnvironmentVariables' => [ 'base' => NULL, 'refs' => [ 'CodeConfigurationValues$RuntimeEnvironmentVariables' => '<p>The environment variables that are available to your running App Runner service. An array of key-value pairs. Keys with a prefix of <code>AWSAPPRUNNER</code> are reserved for system use and aren\'t valid.</p>', 'ImageConfiguration$RuntimeEnvironmentVariables' => '<p>Environment variables that are available to your running App Runner service. An array of key-value pairs. Keys with a prefix of <code>AWSAPPRUNNER</code> are reserved for system use and aren\'t valid.</p>', ], ], 'RuntimeEnvironmentVariablesKey' => [ 'base' => NULL, 'refs' => [ 'RuntimeEnvironmentVariables$key' => NULL, ], ], 'RuntimeEnvironmentVariablesValue' => [ 'base' => NULL, 'refs' => [ 'RuntimeEnvironmentVariables$value' => NULL, ], ], 'Service' => [ 'base' => '<p>Describes an App Runner service. It can describe a service in any state, including deleted services.</p> <p>This type contains the full information about a service, including configuration details. It\'s returned by the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html">CreateService</a>, <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html">DescribeService</a>, and <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html">DeleteService</a> actions. A subset of this information is returned by the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html">ListServices</a> action using the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ServiceSummary.html">ServiceSummary</a> type.</p>', 'refs' => [ 'CreateServiceResponse$Service' => '<p>A description of the App Runner service that\'s created by this request.</p>', 'DeleteServiceResponse$Service' => '<p>A description of the App Runner service that this request just deleted.</p>', 'DescribeServiceResponse$Service' => '<p>A full description of the App Runner service that you specified in this request.</p>', 'PauseServiceResponse$Service' => '<p>A description of the App Runner service that this request just paused.</p>', 'ResumeServiceResponse$Service' => '<p>A description of the App Runner service that this request just resumed.</p>', 'UpdateServiceResponse$Service' => '<p>A description of the App Runner service updated by this request. All configuration values in the returned <code>Service</code> structure reflect configuration changes that are being applied by this request.</p>', ], ], 'ServiceId' => [ 'base' => NULL, 'refs' => [ 'Service$ServiceId' => '<p>An ID that App Runner generated for this service. It\'s unique within the Amazon Web Services Region.</p>', 'ServiceSummary$ServiceId' => '<p>An ID that App Runner generated for this service. It\'s unique within the Amazon Web Services Region.</p>', ], ], 'ServiceMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListServicesRequest$MaxResults' => '<p>The maximum number of results to include in each response (result page). It\'s used for a paginated request.</p> <p>If you don\'t specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>', ], ], 'ServiceName' => [ 'base' => NULL, 'refs' => [ 'CreateServiceRequest$ServiceName' => '<p>A name for the App Runner service. It must be unique across all the running App Runner services in your Amazon Web Services account in the Amazon Web Services Region.</p>', 'Service$ServiceName' => '<p>The customer-provided service name.</p>', 'ServiceSummary$ServiceName' => '<p>The customer-provided service name.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>App Runner can\'t create this resource. You\'ve reached your account quota for this resource type.</p> <p>For App Runner per-resource quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/apprunner.html">App Runner endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'refs' => [], ], 'ServiceStatus' => [ 'base' => NULL, 'refs' => [ 'Service$Status' => '<p>The current state of the App Runner service. These particular values mean the following.</p> <ul> <li> <p> <code>CREATE_FAILED</code> – The service failed to create. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.</p> <p>The failed service isn\'t usable, and still counts towards your service quota. When you\'re done analyzing the failure, delete the service.</p> </li> <li> <p> <code>DELETE_FAILED</code> – The service failed to delete and can\'t be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</p> </li> </ul>', 'ServiceSummary$Status' => '<p>The current state of the App Runner service. These particular values mean the following.</p> <ul> <li> <p> <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.</p> <p>The failed service isn\'t usable, and still counts towards your service quota. When you\'re done analyzing the failure, delete the service.</p> </li> <li> <p> <code>DELETE_FAILED</code> – The service failed to delete and can\'t be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</p> </li> </ul>', ], ], 'ServiceSummary' => [ 'base' => '<p>Provides summary information for an App Runner service.</p> <p>This type contains limited information about a service. It doesn\'t include configuration details. It\'s returned by the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html">ListServices</a> action. Complete service information is returned by the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html">CreateService</a>, <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html">DescribeService</a>, and <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html">DeleteService</a> actions using the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_Service.html">Service</a> type.</p>', 'refs' => [ 'ServiceSummaryList$member' => NULL, ], ], 'ServiceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListServicesResponse$ServiceSummaryList' => '<p>A list of service summary information records. In a paginated request, the request returns up to <code>MaxResults</code> records for each call.</p>', ], ], 'SourceCodeVersion' => [ 'base' => '<p>Identifies a version of code that App Runner refers to within a source code repository.</p>', 'refs' => [ 'CodeRepository$SourceCodeVersion' => '<p>The version that should be used within the source code repository.</p>', ], ], 'SourceCodeVersionType' => [ 'base' => NULL, 'refs' => [ 'SourceCodeVersion$Type' => '<p>The type of version identifier.</p> <p>For a git-based repository, branches represent versions.</p>', ], ], 'SourceConfiguration' => [ 'base' => '<p>Describes the source deployed to an App Runner service. It can be a code or an image repository.</p>', 'refs' => [ 'CreateServiceRequest$SourceConfiguration' => '<p>The source to deploy to the App Runner service. It can be a code or an image repository.</p>', 'Service$SourceConfiguration' => '<p>The source deployed to the App Runner service. It can be a code or an image repository.</p>', 'UpdateServiceRequest$SourceConfiguration' => '<p>The source configuration to apply to the App Runner service.</p> <p>You can change the configuration of the code or image repository that the service uses. However, you can\'t switch from code to image or the other way around. This means that you must provide the same structure member of <code>SourceConfiguration</code> that you originally included when you created the service. Specifically, you can include either <code>CodeRepository</code> or <code>ImageRepository</code>. To update the source configuration, set the values to members of the structure that you include.</p>', ], ], 'StartCommand' => [ 'base' => NULL, 'refs' => [ 'CodeConfigurationValues$StartCommand' => '<p>The command App Runner runs to start your application.</p>', 'ImageConfiguration$StartCommand' => '<p>An optional command that App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.</p>', ], ], 'StartDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDeploymentResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AssociateCustomDomainResponse$DNSTarget' => '<p>The App Runner subdomain of the App Runner service. The custom domain name is mapped to this target name.</p>', 'CertificateValidationRecord$Name' => '<p>The certificate CNAME record name.</p>', 'CertificateValidationRecord$Type' => '<p>The record type, always <code>CNAME</code>.</p>', 'CertificateValidationRecord$Value' => '<p>The certificate CNAME record value.</p>', 'CodeConfigurationValues$Port' => '<p>The port that your application listens to in the container.</p> <p>Default: <code>8080</code> </p>', 'CodeRepository$RepositoryUrl' => '<p>The location of the repository that contains the source code.</p>', 'DescribeCustomDomainsRequest$NextToken' => '<p>A token from a previous result page. It\'s used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones that are specified in the initial request.</p> <p>If you don\'t specify <code>NextToken</code>, the request retrieves the first result page.</p>', 'DescribeCustomDomainsResponse$DNSTarget' => '<p>The App Runner subdomain of the App Runner service. The associated custom domain names are mapped to this target name.</p>', 'DescribeCustomDomainsResponse$NextToken' => '<p>The token that you can pass in a subsequent request to get the next result page. It\'s returned in a paginated request.</p>', 'DisassociateCustomDomainResponse$DNSTarget' => '<p>The App Runner subdomain of the App Runner service. The disassociated custom domain name was mapped to this target name.</p>', 'ImageConfiguration$Port' => '<p>The port that your application listens to in the container.</p> <p>Default: <code>8080</code> </p>', 'ListOperationsRequest$NextToken' => '<p>A token from a previous result page. It\'s used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones specified in the initial request.</p> <p>If you don\'t specify <code>NextToken</code>, the request retrieves the first result page.</p>', 'ListOperationsResponse$NextToken' => '<p>The token that you can pass in a subsequent request to get the next result page. It\'s returned in a paginated request.</p>', 'ListServicesRequest$NextToken' => '<p>A token from a previous result page. Used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones specified in the initial request.</p> <p>If you don\'t specify <code>NextToken</code>, the request retrieves the first result page.</p>', 'ListServicesResponse$NextToken' => '<p>The token that you can pass in a subsequent request to get the next result page. It\'s returned in a paginated request.</p>', 'Service$ServiceUrl' => '<p>A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.</p>', 'ServiceSummary$ServiceUrl' => '<p>A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.</p>', 'SourceCodeVersion$Value' => '<p>A source code version.</p> <p>For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.</p>', 'StringList$member' => NULL, ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'CreateVpcConnectorRequest$Subnets' => '<p>A list of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC. Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.</p>', 'CreateVpcConnectorRequest$SecurityGroups' => '<p>A list of IDs of security groups that App Runner should use for access to Amazon Web Services resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.</p>', 'VpcConnector$Subnets' => '<p>A list of IDs of subnets that App Runner uses for your service. All IDs are of subnets of a single Amazon VPC.</p>', 'VpcConnector$SecurityGroups' => '<p>A list of IDs of security groups that App Runner uses for access to Amazon Web Services resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag that is applied to an App Runner resource. A tag is a metadata item consisting of a key-value pair.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of tag keys that you want to remove.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAutoScalingConfigurationRequest$Tags' => '<p>A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a key-value pair.</p>', 'CreateConnectionRequest$Tags' => '<p>A list of metadata items that you can associate with your connection resource. A tag is a key-value pair.</p>', 'CreateServiceRequest$Tags' => '<p>An optional list of metadata items that you can associate with the App Runner service resource. A tag is a key-value pair.</p>', 'CreateVpcConnectorRequest$Tags' => '<p>A list of metadata items that you can associate with your VPC connector resource. A tag is a key-value pair.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A list of the tag key-value pairs that are associated with the resource.</p>', 'TagResourceRequest$Tags' => '<p>A list of tag key-value pairs to add or update. If a key is new to the resource, the tag is added with the provided value. If a key is already associated with the resource, the value of the tag is updated.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AutoScalingConfiguration$CreatedAt' => '<p>The time when the auto scaling configuration was created. It\'s in Unix time stamp format.</p>', 'AutoScalingConfiguration$DeletedAt' => '<p>The time when the auto scaling configuration was deleted. It\'s in Unix time stamp format.</p>', 'Connection$CreatedAt' => '<p>The App Runner connection creation time, expressed as a Unix time stamp.</p>', 'ConnectionSummary$CreatedAt' => '<p>The App Runner connection creation time, expressed as a Unix time stamp.</p>', 'OperationSummary$StartedAt' => '<p>The time when the operation started. It\'s in the Unix time stamp format.</p>', 'OperationSummary$EndedAt' => '<p>The time when the operation ended. It\'s in the Unix time stamp format.</p>', 'OperationSummary$UpdatedAt' => '<p>The time when the operation was last updated. It\'s in the Unix time stamp format.</p>', 'Service$CreatedAt' => '<p>The time when the App Runner service was created. It\'s in the Unix time stamp format.</p>', 'Service$UpdatedAt' => '<p>The time when the App Runner service was last updated at. It\'s in the Unix time stamp format.</p>', 'Service$DeletedAt' => '<p>The time when the App Runner service was deleted. It\'s in the Unix time stamp format.</p>', 'ServiceSummary$CreatedAt' => '<p>The time when the App Runner service was created. It\'s in the Unix time stamp format.</p>', 'ServiceSummary$UpdatedAt' => '<p>The time when the App Runner service was last updated. It\'s in theUnix time stamp format.</p>', 'VpcConnector$CreatedAt' => '<p>The time when the VPC connector was created. It\'s in Unix time stamp format.</p>', 'VpcConnector$DeletedAt' => '<p>The time when the VPC connector was deleted. It\'s in Unix time stamp format.</p>', ], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'CreateServiceResponse$OperationId' => '<p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html">ListOperations</a> call to track the operation\'s progress.</p>', 'DeleteServiceResponse$OperationId' => '<p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track the operation\'s progress.</p>', 'OperationSummary$Id' => '<p>A unique ID of this operation. It\'s unique in the scope of the App Runner service.</p>', 'PauseServiceResponse$OperationId' => '<p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track the operation\'s progress.</p>', 'ResumeServiceResponse$OperationId' => '<p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track the operation\'s progress.</p>', 'StartDeploymentResponse$OperationId' => '<p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track the operation\'s progress.</p>', 'UpdateServiceResponse$OperationId' => '<p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track the operation\'s progress.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'VpcConnector' => [ 'base' => '<p>Describes an App Runner VPC connector resource. A VPC connector describes the Amazon Virtual Private Cloud (Amazon VPC) that an App Runner service is associated with, and the subnets and security group that are used.</p> <p>Multiple revisions of a connector might have the same <code>Name</code> and different <code>Revision</code> values.</p> <note> <p>At this time, App Runner supports only one revision per name.</p> </note>', 'refs' => [ 'CreateVpcConnectorResponse$VpcConnector' => '<p>A description of the App Runner VPC connector that\'s created by this request.</p>', 'DeleteVpcConnectorResponse$VpcConnector' => '<p>A description of the App Runner VPC connector that this request just deleted.</p>', 'DescribeVpcConnectorResponse$VpcConnector' => '<p>A description of the App Runner VPC connector that you specified in this request.</p>', 'VpcConnectors$member' => NULL, ], ], 'VpcConnectorName' => [ 'base' => NULL, 'refs' => [ 'CreateVpcConnectorRequest$VpcConnectorName' => '<p>A name for the VPC connector.</p>', 'VpcConnector$VpcConnectorName' => '<p>The customer-provided VPC connector name.</p>', ], ], 'VpcConnectorStatus' => [ 'base' => NULL, 'refs' => [ 'VpcConnector$Status' => '<p>The current state of the VPC connector. If the status of a connector revision is <code>INACTIVE</code>, it was deleted and can\'t be used. Inactive connector revisions are permanently removed some time after they are deleted.</p>', ], ], 'VpcConnectors' => [ 'base' => NULL, 'refs' => [ 'ListVpcConnectorsResponse$VpcConnectors' => '<p>A list of information records for VPC connectors. In a paginated request, the request returns up to <code>MaxResults</code> records for each call.</p>', ], ], ],];
