<?php
// This file was auto-generated from sdk-root/src/data/ssm-incidents/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Systems Manager Incident Manager is an incident management console designed to help users mitigate and recover from incidents affecting their Amazon Web Services-hosted applications. An incident is any unplanned interruption or reduction in quality of services. </p> <p>Incident Manager increases incident resolution by notifying responders of impact, highlighting relevant troubleshooting data, and providing collaboration tools to get services back up and running. To achieve the primary goal of reducing the time-to-resolution of critical incidents, Incident Manager automates response plans and enables responder team escalation. </p>', 'operations' => [ 'CreateReplicationSet' => '<p>A replication set replicates and encrypts your data to the provided Regions with the provided KMS key. </p>', 'CreateResponsePlan' => '<p>Creates a response plan that automates the initial response to incidents. A response plan engages contacts, starts chat channel collaboration, and initiates runbooks at the beginning of an incident.</p>', 'CreateTimelineEvent' => '<p>Creates a custom timeline event on the incident details page of an incident record. Timeline events are automatically created by Incident Manager, marking key moment during an incident. You can create custom timeline events to mark important events that are automatically detected by Incident Manager.</p>', 'DeleteIncidentRecord' => '<p>Delete an incident record from Incident Manager. </p>', 'DeleteReplicationSet' => '<p>Deletes all Regions in your replication set. Deleting the replication set deletes all Incident Manager data.</p>', 'DeleteResourcePolicy' => '<p>Deletes the resource policy that Resource Access Manager uses to share your Incident Manager resource.</p>', 'DeleteResponsePlan' => '<p>Deletes the specified response plan. Deleting a response plan stops all linked CloudWatch alarms and EventBridge events from creating an incident with this response plan.</p>', 'DeleteTimelineEvent' => '<p>Deletes a timeline event from an incident.</p>', 'GetIncidentRecord' => '<p>Returns the details for the specified incident record.</p>', 'GetReplicationSet' => '<p>Retrieve your Incident Manager replication set.</p>', 'GetResourcePolicies' => '<p>Retrieves the resource policies attached to the specified response plan.</p>', 'GetResponsePlan' => '<p>Retrieves the details of the specified response plan.</p>', 'GetTimelineEvent' => '<p>Retrieves a timeline event based on its ID and incident record.</p>', 'ListIncidentRecords' => '<p>Lists all incident records in your account. Use this command to retrieve the Amazon Resource Name (ARN) of the incident record you want to update. </p>', 'ListRelatedItems' => '<p>List all related items for an incident record.</p>', 'ListReplicationSets' => '<p>Lists details about the replication set configured in your account. </p>', 'ListResponsePlans' => '<p>Lists all response plans in your account.</p>', 'ListTagsForResource' => '<p>Lists the tags that are attached to the specified response plan.</p>', 'ListTimelineEvents' => '<p>Lists timeline events for the specified incident record.</p>', 'PutResourcePolicy' => '<p>Adds a resource policy to the specified response plan. The resource policy is used to share the response plan using Resource Access Manager (RAM). For more information about cross-account sharing, see <a href="https://docs.aws.amazon.com/incident-manager/latest/userguide/xa.html">Setting up cross-account functionality</a>.</p>', 'StartIncident' => '<p>Used to start an incident from CloudWatch alarms, EventBridge events, or manually. </p>', 'TagResource' => '<p>Adds a tag to a response plan.</p>', 'UntagResource' => '<p>Removes a tag from a resource.</p>', 'UpdateDeletionProtection' => '<p>Update deletion protection to either allow or deny deletion of the final Region in a replication set.</p>', 'UpdateIncidentRecord' => '<p>Update the details of an incident record. You can use this operation to update an incident record from the defined chat channel. For more information about using actions in chat channels, see <a href="https://docs.aws.amazon.com/incident-manager/latest/userguide/chat.html#chat-interact">Interacting through chat</a>.</p>', 'UpdateRelatedItems' => '<p>Add or remove related items from the related items tab of an incident record.</p>', 'UpdateReplicationSet' => '<p>Add or delete Regions from your replication set.</p>', 'UpdateResponsePlan' => '<p>Updates the specified response plan.</p>', 'UpdateTimelineEvent' => '<p>Updates a timeline event. You can update events of type <code>Custom Event</code>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient access to perform this operation.</p>', 'refs' => [], ], 'Action' => [ 'base' => '<p>The action that starts at the beginning of an incident. The response plan defines the action.</p>', 'refs' => [ 'ActionsList$member' => NULL, ], ], 'ActionsList' => [ 'base' => NULL, 'refs' => [ 'CreateResponsePlanInput$actions' => '<p>The actions that the response plan starts at the beginning of an incident.</p>', 'GetResponsePlanOutput$actions' => '<p>The actions that this response plan takes at the beginning of the incident.</p>', 'UpdateResponsePlanInput$actions' => '<p>The actions that this response plan takes at the beginning of an incident.</p>', ], ], 'AddRegionAction' => [ 'base' => '<p>Defines the Amazon Web Services Region and KMS key to add to the replication set. </p>', 'refs' => [ 'UpdateReplicationSetAction$addRegionAction' => '<p>Details about the Amazon Web Services Region that you\'re adding to the replication set.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$ssmExecutionArn' => '<p>The Amazon Resource Name (ARN) of the automation process.</p>', 'CreateReplicationSetOutput$arn' => '<p>The Amazon Resource Name (ARN) of the replication set. </p>', 'CreateResponsePlanOutput$arn' => '<p>The Amazon Resource Name (ARN) of the response plan.</p>', 'CreateTimelineEventInput$incidentRecordArn' => '<p>The Amazon Resource Name (ARN) of the incident record to which the event will be added.</p>', 'CreateTimelineEventOutput$incidentRecordArn' => '<p>The ARN of the incident record that you added the event to.</p>', 'DeleteIncidentRecordInput$arn' => '<p>The Amazon Resource Name (ARN) of the incident record you are deleting.</p>', 'DeleteReplicationSetInput$arn' => '<p>The Amazon Resource Name (ARN) of the replication set you\'re deleting.</p>', 'DeleteResourcePolicyInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource you\'re deleting the policy from.</p>', 'DeleteResponsePlanInput$arn' => '<p>The Amazon Resource Name (ARN) of the response plan.</p>', 'DeleteTimelineEventInput$incidentRecordArn' => '<p>The Amazon Resource Name (ARN) of the incident that includes the timeline event.</p>', 'EventSummary$incidentRecordArn' => '<p>The Amazon Resource Name (ARN) of the incident that the event happened during.</p>', 'GetIncidentRecordInput$arn' => '<p>The Amazon Resource Name (ARN) of the incident record.</p>', 'GetReplicationSetInput$arn' => '<p>The Amazon Resource Name (ARN) of the replication set you want to retrieve.</p>', 'GetResourcePoliciesInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the response plan with the attached resource policy. </p>', 'GetResponsePlanInput$arn' => '<p>The Amazon Resource Name (ARN) of the response plan.</p>', 'GetResponsePlanOutput$arn' => '<p>The ARN of the response plan.</p>', 'GetTimelineEventInput$incidentRecordArn' => '<p>The Amazon Resource Name (ARN) of the incident that includes the timeline event.</p>', 'IncidentRecord$arn' => '<p>The Amazon Resource Name (ARN) of the incident record.</p>', 'IncidentRecord$lastModifiedBy' => '<p>Who modified the incident most recently.</p>', 'IncidentRecordSource$createdBy' => '<p>The principal that started the incident.</p>', 'IncidentRecordSource$resourceArn' => '<p>The resource that caused the incident to be created.</p>', 'IncidentRecordSummary$arn' => '<p>The Amazon Resource Name (ARN) of the incident.</p>', 'ItemValue$arn' => '<p>The Amazon Resource Name (ARN) of the related item, if the related item is an Amazon resource.</p>', 'ListRelatedItemsInput$incidentRecordArn' => '<p>The Amazon Resource Name (ARN) of the incident record containing the listed related items.</p>', 'ListTimelineEventsInput$incidentRecordArn' => '<p>The Amazon Resource Name (ARN) of the incident that includes the timeline event.</p>', 'NotificationTargetItem$snsTopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS topic.</p>', 'PutResourcePolicyInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the response plan you\'re adding the resource policy to.</p>', 'ReplicationSet$arn' => '<p>The Amazon Resource Name (ARN) of the replication set.</p>', 'ReplicationSet$createdBy' => '<p>Details about who created the replication set.</p>', 'ReplicationSet$lastModifiedBy' => '<p>Who last modified the replication set.</p>', 'ReplicationSetArnList$member' => NULL, 'ResponsePlanSummary$arn' => '<p>The Amazon Resource Name (ARN) of the response plan.</p>', 'StartIncidentInput$responsePlanArn' => '<p>The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat channels, Amazon SNS topics, runbooks, title, and impact of the incident. </p>', 'StartIncidentOutput$incidentRecordArn' => '<p>The ARN of the newly created incident record.</p>', 'TimelineEvent$incidentRecordArn' => '<p>The Amazon Resource Name (ARN) of the incident that the event occurred during.</p>', 'TriggerDetails$triggerArn' => '<p>The Amazon Resource Name (ARN) of the source that detected the incident.</p>', 'UpdateDeletionProtectionInput$arn' => '<p>The Amazon Resource Name (ARN) of the replication set you\'re updating.</p>', 'UpdateIncidentRecordInput$arn' => '<p>The Amazon Resource Name (ARN) of the incident record you are updating.</p>', 'UpdateRelatedItemsInput$incidentRecordArn' => '<p>The Amazon Resource Name (ARN) of the incident record containing the related items you are updating.</p>', 'UpdateReplicationSetInput$arn' => '<p>The Amazon Resource Name (ARN) of the replication set you\'re updating.</p>', 'UpdateResponsePlanInput$arn' => '<p>The Amazon Resource Name (ARN) of the response plan.</p>', 'UpdateTimelineEventInput$incidentRecordArn' => '<p>The Amazon Resource Name (ARN) of the incident that includes the timeline event.</p>', ], ], 'AttributeValueList' => [ 'base' => '<p>Use the AttributeValueList to filter by string or integer values.</p>', 'refs' => [ 'Condition$equals' => '<p>The value is equal to the provided string or integer. </p>', ], ], 'AutomationExecution' => [ 'base' => '<p>The Systems Manager automation document process to start as the runbook at the beginning of the incident.</p>', 'refs' => [ 'AutomationExecutionSet$member' => NULL, ], ], 'AutomationExecutionSet' => [ 'base' => NULL, 'refs' => [ 'IncidentRecord$automationExecutions' => '<p>The runbook, or automation document, that\'s run at the beginning of the incident.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ReplicationSet$deletionProtected' => '<p>Determines if the replication set deletion protection is enabled or not. If deletion protection is enabled, you can\'t delete the last Amazon Web Services Region in the replication set. </p>', 'UpdateDeletionProtectionInput$deletionProtected' => '<p>Details if deletion protection is enabled or disabled in your account.</p>', ], ], 'ChatChannel' => [ 'base' => '<p>The Chatbot chat channel used for collaboration during an incident.</p>', 'refs' => [ 'CreateResponsePlanInput$chatChannel' => '<p>The Chatbot chat channel used for collaboration during an incident.</p>', 'GetResponsePlanOutput$chatChannel' => '<p>The Chatbot chat channel used for collaboration during an incident.</p>', 'IncidentRecord$chatChannel' => '<p>The chat channel used for collaboration during an incident.</p>', 'UpdateIncidentRecordInput$chatChannel' => '<p>The Chatbot chat channel where responders can collaborate.</p>', 'UpdateResponsePlanInput$chatChannel' => '<p>The Chatbot chat channel used for collaboration during an incident.</p> <p>Use the empty structure to remove the chat channel from the response plan.</p>', ], ], 'ChatbotSnsConfigurationSet' => [ 'base' => NULL, 'refs' => [ 'ChatChannel$chatbotSns' => '<p>The Amazon SNS targets that Chatbot uses to notify the chat channel of updates to an incident. You can also make updates to the incident through the chat channel by using the Amazon SNS topics. </p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationSetInput$clientToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', 'CreateResponsePlanInput$clientToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', 'CreateTimelineEventInput$clientToken' => '<p>A token ensuring that the action is called only once with the specified details.</p>', 'StartIncidentInput$clientToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', 'UpdateDeletionProtectionInput$clientToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', 'UpdateIncidentRecordInput$clientToken' => '<p>A token that ensures that the operation is called only once with the specified details.</p>', 'UpdateRelatedItemsInput$clientToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', 'UpdateReplicationSetInput$clientToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', 'UpdateResponsePlanInput$clientToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', 'UpdateTimelineEventInput$clientToken' => '<p>A token ensuring that the operation is called only once with the specified details.</p>', ], ], 'Condition' => [ 'base' => '<p>A conditional statement with which to compare a value, after a timestamp, before a timestamp, or equal to a string or integer. If multiple conditions are specified, the conditionals become an <code>AND</code>ed statement. If multiple values are specified for a conditional, the values are <code>OR</code>d.</p>', 'refs' => [ 'Filter$condition' => '<p>The condition accepts before or after a specified time, equal to a string, or equal to an integer.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting a resource causes an inconsistent state.</p>', 'refs' => [], ], 'CreateReplicationSetInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateReplicationSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateResponsePlanInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateResponsePlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTimelineEventInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTimelineEventOutput' => [ 'base' => NULL, 'refs' => [], ], 'DedupeString' => [ 'base' => NULL, 'refs' => [ 'IncidentRecord$dedupeString' => '<p>The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the same account.</p>', 'IncidentTemplate$dedupeString' => '<p>Used to stop Incident Manager from creating multiple incident records for the same incident. </p>', 'UpdateResponsePlanInput$incidentTemplateDedupeString' => '<p>The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the same account.</p>', ], ], 'DeleteIncidentRecordInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIncidentRecordOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegionAction' => [ 'base' => '<p>Defines the information about the Amazon Web Services Region you\'re deleting from your replication set.</p>', 'refs' => [ 'UpdateReplicationSetAction$deleteRegionAction' => '<p>Details about the Amazon Web Services Region that you\'re deleting to the replication set.</p>', ], ], 'DeleteReplicationSetInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResponsePlanInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResponsePlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTimelineEventInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTimelineEventOutput' => [ 'base' => NULL, 'refs' => [], ], 'DynamicSsmParameterValue' => [ 'base' => '<p>The dynamic SSM parameter value.</p>', 'refs' => [ 'DynamicSsmParameters$value' => NULL, ], ], 'DynamicSsmParameters' => [ 'base' => NULL, 'refs' => [ 'SsmAutomation$dynamicParameters' => '<p>The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.</p>', ], ], 'DynamicSsmParametersKeyString' => [ 'base' => NULL, 'refs' => [ 'DynamicSsmParameters$key' => NULL, ], ], 'EmptyChatChannel' => [ 'base' => '<p>Used to remove the chat channel from an incident record or response plan.</p>', 'refs' => [ 'ChatChannel$empty' => '<p>Used to remove the chat channel from an incident record or response plan.</p>', ], ], 'EngagementSet' => [ 'base' => NULL, 'refs' => [ 'CreateResponsePlanInput$engagements' => '<p>The contacts and escalation plans that the response plan engages during an incident.</p>', 'GetResponsePlanOutput$engagements' => '<p>The contacts and escalation plans that the response plan engages during an incident.</p>', 'UpdateResponsePlanInput$engagements' => '<p>The contacts and escalation plans that Incident Manager engages at the start of the incident.</p>', ], ], 'EventData' => [ 'base' => NULL, 'refs' => [ 'CreateTimelineEventInput$eventData' => '<p>A short description of the event.</p>', 'TimelineEvent$eventData' => '<p>A short description of the event.</p>', 'UpdateTimelineEventInput$eventData' => '<p>A short description of the event.</p>', ], ], 'EventSummary' => [ 'base' => '<p>Details about a timeline event during an incident.</p>', 'refs' => [ 'EventSummaryList$member' => NULL, ], ], 'EventSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTimelineEventsOutput$eventSummaries' => '<p>Details about each event that occurred during the incident.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'Filter' => [ 'base' => '<p>Filter the selection by using a condition.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterKeyString' => [ 'base' => NULL, 'refs' => [ 'Filter$key' => '<p>The key that you\'re filtering on.</p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'ListIncidentRecordsInput$filters' => '<p>Filters the list of incident records through which you are searching. You can filter on the following keys:</p> <ul> <li> <p> <code>creationTime</code> </p> </li> <li> <p> <code>impact</code> </p> </li> <li> <p> <code>status</code> </p> </li> <li> <p> <code>createdBy</code> </p> </li> </ul> <p>Note the following when deciding how to use Filters:</p> <ul> <li> <p>If you don\'t specify a Filter, the response includes all incident records.</p> </li> <li> <p>If you specify more than one filter in a single request, the response returns incident records that match all filters.</p> </li> <li> <p>If you specify a filter with more than one value, the response returns incident records that match any of the values provided.</p> </li> </ul>', 'ListTimelineEventsInput$filters' => '<p>Filters the timeline events based on the provided conditional values. You can filter timeline events using the following keys:</p> <ul> <li> <p> <code>eventTime</code> </p> </li> <li> <p> <code>eventType</code> </p> </li> </ul> <p>Note the following when deciding how to use Filters:</p> <ul> <li> <p>If you don\'t specify a Filter, the response includes all timeline events.</p> </li> <li> <p>If you specify more than one filter in a single request, the response returns timeline events that match all filters.</p> </li> <li> <p>If you specify a filter with more than one value, the response returns timeline events that match any of the values provided.</p> </li> </ul>', ], ], 'GetIncidentRecordInput' => [ 'base' => NULL, 'refs' => [], ], 'GetIncidentRecordOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationSetInput' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePoliciesInput' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePoliciesOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetResponsePlanInput' => [ 'base' => NULL, 'refs' => [], ], 'GetResponsePlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTimelineEventInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTimelineEventOutput' => [ 'base' => NULL, 'refs' => [], ], 'Impact' => [ 'base' => NULL, 'refs' => [ 'IncidentRecord$impact' => '<p>The impact of the incident on customers and applications.</p>', 'IncidentRecordSummary$impact' => '<p>Defines the impact to customers and applications.</p>', 'IncidentTemplate$impact' => '<p>The impact of the incident on your customers and applications. </p>', 'StartIncidentInput$impact' => '<p>Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.</p> <p class="title"> <b>Possible impacts:</b> </p> <ul> <li> <p> <code>1</code> - Critical impact, this typically relates to full application failure that impacts many to all customers. </p> </li> <li> <p> <code>2</code> - High impact, partial application failure with impact to many customers.</p> </li> <li> <p> <code>3</code> - Medium impact, the application is providing reduced service to customers.</p> </li> <li> <p> <code>4</code> - Low impact, customer might aren\'t impacted by the problem yet.</p> </li> <li> <p> <code>5</code> - No impact, customers aren\'t currently impacted but urgent action is needed to avoid impact.</p> </li> </ul>', 'UpdateIncidentRecordInput$impact' => '<p>Defines the impact of the incident to customers and applications. Providing an impact overwrites the impact provided by the response plan.</p> <p class="title"> <b>Possible impacts:</b> </p> <ul> <li> <p> <code>1</code> - Critical impact, full application failure that impacts many to all customers. </p> </li> <li> <p> <code>2</code> - High impact, partial application failure with impact to many customers.</p> </li> <li> <p> <code>3</code> - Medium impact, the application is providing reduced service to customers.</p> </li> <li> <p> <code>4</code> - Low impact, customer aren\'t impacted by the problem yet.</p> </li> <li> <p> <code>5</code> - No impact, customers aren\'t currently impacted but urgent action is needed to avoid impact.</p> </li> </ul>', 'UpdateResponsePlanInput$incidentTemplateImpact' => '<p>Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.</p> <p class="title"> <b>Possible impacts:</b> </p> <ul> <li> <p> <code>5</code> - Severe impact</p> </li> <li> <p> <code>4</code> - High impact</p> </li> <li> <p> <code>3</code> - Medium impact</p> </li> <li> <p> <code>2</code> - Low impact</p> </li> <li> <p> <code>1</code> - No impact</p> </li> </ul>', ], ], 'IncidentRecord' => [ 'base' => '<p>The record of the incident that\'s created when an incident occurs.</p>', 'refs' => [ 'GetIncidentRecordOutput$incidentRecord' => '<p>Details the structure of the incident record.</p>', ], ], 'IncidentRecordSource' => [ 'base' => '<p>Details about what created the incident record and when it was created.</p>', 'refs' => [ 'IncidentRecord$incidentRecordSource' => '<p>Details about the action that started the incident.</p>', 'IncidentRecordSummary$incidentRecordSource' => '<p>What caused Incident Manager to create the incident.</p>', ], ], 'IncidentRecordStatus' => [ 'base' => NULL, 'refs' => [ 'IncidentRecord$status' => '<p>The current status of the incident.</p>', 'IncidentRecordSummary$status' => '<p>The current status of the incident.</p>', 'UpdateIncidentRecordInput$status' => '<p>The status of the incident. An incident can be <code>Open</code> or <code>Resolved</code>.</p>', ], ], 'IncidentRecordSummary' => [ 'base' => '<p>Details describing an incident record.</p>', 'refs' => [ 'IncidentRecordSummaryList$member' => NULL, ], ], 'IncidentRecordSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListIncidentRecordsOutput$incidentRecordSummaries' => '<p>The details of each listed incident record.</p>', ], ], 'IncidentSource' => [ 'base' => NULL, 'refs' => [ 'IncidentRecordSource$source' => '<p>The service that started the incident. This can be manually created from Incident Manager, automatically created using an Amazon CloudWatch alarm, or Amazon EventBridge event.</p>', 'TriggerDetails$source' => '<p>Identifies the service that sourced the event. All events sourced from within Amazon Web Services begin with "<code>aws.</code>" Customer-generated events can have any value here, as long as it doesn\'t begin with "<code>aws.</code>" We recommend the use of Java package-name style reverse domain-name strings. </p>', ], ], 'IncidentSummary' => [ 'base' => NULL, 'refs' => [ 'IncidentRecord$summary' => '<p>The summary of the incident. The summary is a brief synopsis of what occurred, what\'s currently happening, and context of the incident.</p>', 'IncidentTemplate$summary' => '<p>The summary of the incident. The summary is a brief synopsis of what occurred, what\'s currently happening, and context.</p>', 'UpdateIncidentRecordInput$summary' => '<p>A longer description of what occurred during the incident.</p>', 'UpdateResponsePlanInput$incidentTemplateSummary' => '<p>A brief summary of the incident. This typically contains what has happened, what\'s currently happening, and next steps.</p>', ], ], 'IncidentTemplate' => [ 'base' => '<p>Basic details used in creating a response plan. The response plan is then used to create an incident record.</p>', 'refs' => [ 'CreateResponsePlanInput$incidentTemplate' => '<p>Details used to create an incident when using this response plan.</p>', 'GetResponsePlanOutput$incidentTemplate' => '<p>Details used to create the incident when using this response plan.</p>', ], ], 'IncidentTitle' => [ 'base' => NULL, 'refs' => [ 'IncidentRecord$title' => '<p>The title of the incident.</p>', 'IncidentRecordSummary$title' => '<p>The title of the incident. This value is either provided by the response plan or overwritten on creation.</p>', 'IncidentTemplate$title' => '<p>The title of the incident. </p>', 'StartIncidentInput$title' => '<p>Provide a title for the incident. Providing a title overwrites the title provided by the response plan. </p>', 'UpdateIncidentRecordInput$title' => '<p>A brief description of the incident.</p>', 'UpdateResponsePlanInput$incidentTemplateTitle' => '<p>The short format name of the incident. The title can\'t contain spaces.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'IntegerList$member' => NULL, ], ], 'IntegerList' => [ 'base' => NULL, 'refs' => [ 'AttributeValueList$integerValues' => '<p>The list of integer values that the filter matches.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'ItemIdentifier' => [ 'base' => '<p>Details and type of a related item.</p>', 'refs' => [ 'RelatedItem$identifier' => '<p>Details about the related item.</p>', 'RelatedItemsUpdate$itemToRemove' => '<p>Details about the related item you\'re deleting.</p>', ], ], 'ItemType' => [ 'base' => NULL, 'refs' => [ 'ItemIdentifier$type' => '<p>The type of related item. </p>', ], ], 'ItemValue' => [ 'base' => '<p>Describes a related item.</p>', 'refs' => [ 'ItemIdentifier$value' => '<p>Details about the related item.</p>', ], ], 'ListIncidentRecordsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListIncidentRecordsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRelatedItemsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRelatedItemsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListReplicationSetsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListReplicationSetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListResponsePlansInput' => [ 'base' => NULL, 'refs' => [], ], 'ListResponsePlansOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTimelineEventsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTimelineEventsOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetResourcePoliciesInput$maxResults' => '<p>The maximum number of resource policies to display per page of results.</p>', 'ListIncidentRecordsInput$maxResults' => '<p>The maximum number of results per page.</p>', 'ListRelatedItemsInput$maxResults' => '<p>The maximum number of related items per page.</p>', 'ListReplicationSetsInput$maxResults' => '<p>The maximum number of results per page. </p>', 'ListResponsePlansInput$maxResults' => '<p>The maximum number of response plans per page.</p>', 'ListTimelineEventsInput$maxResults' => '<p>The maximum number of results per page.</p>', ], ], 'MetricDefinition' => [ 'base' => NULL, 'refs' => [ 'ItemValue$metricDefinition' => '<p>The metric definition, if the related item is a metric in Amazon CloudWatch.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetResourcePoliciesInput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'GetResourcePoliciesOutput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListIncidentRecordsInput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListIncidentRecordsOutput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListRelatedItemsInput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListRelatedItemsOutput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListReplicationSetsInput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListReplicationSetsOutput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListResponsePlansInput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListResponsePlansOutput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListTimelineEventsInput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', 'ListTimelineEventsOutput$nextToken' => '<p>The pagination token to continue to the next page of results.</p>', ], ], 'NotificationTargetItem' => [ 'base' => '<p>The SNS targets that are notified when updates are made to an incident.</p>', 'refs' => [ 'NotificationTargetSet$member' => NULL, ], ], 'NotificationTargetSet' => [ 'base' => NULL, 'refs' => [ 'IncidentRecord$notificationTargets' => '<p>The Amazon SNS targets that are notified when updates are made to an incident.</p>', 'IncidentTemplate$notificationTargets' => '<p>The Amazon SNS targets that are notified when updates are made to an incident.</p>', 'UpdateIncidentRecordInput$notificationTargets' => '<p>The Amazon SNS targets that are notified when updates are made to an incident.</p> <p>Using multiple SNS topics creates redundancy in the event that a Region is down during the incident.</p>', 'UpdateResponsePlanInput$incidentTemplateNotificationTargets' => '<p>The Amazon SNS targets that are notified when updates are made to an incident.</p>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'PutResourcePolicyInput$policy' => '<p>Details of the resource policy.</p>', 'ResourcePolicy$policyDocument' => '<p>The JSON blob that describes the policy.</p>', ], ], 'PolicyId' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcePolicyInput$policyId' => '<p>The ID of the resource policy you\'re deleting.</p>', 'PutResourcePolicyOutput$policyId' => '<p>The ID of the resource policy.</p>', 'ResourcePolicy$policyId' => '<p>The ID of the resource policy.</p>', ], ], 'PutResourcePolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'RawData' => [ 'base' => NULL, 'refs' => [ 'TriggerDetails$rawData' => '<p>Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an incident is created.</p>', ], ], 'RegionInfo' => [ 'base' => '<p>Information about a Amazon Web Services Region in your replication set.</p>', 'refs' => [ 'RegionInfoMap$value' => NULL, ], ], 'RegionInfoMap' => [ 'base' => NULL, 'refs' => [ 'ReplicationSet$regionMap' => '<p>The map between each Amazon Web Services Region in your replication set and the KMS key that\'s used to encrypt the data in that Region.</p>', ], ], 'RegionMapInput' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationSetInput$regions' => '<p>The Regions that Incident Manager replicates your data to. You can have up to three Regions in your replication set.</p>', ], ], 'RegionMapInputValue' => [ 'base' => '<p>The mapping between a Amazon Web Services Region and the key that\'s used to encrypt the data.</p>', 'refs' => [ 'RegionMapInput$value' => NULL, ], ], 'RegionName' => [ 'base' => NULL, 'refs' => [ 'AddRegionAction$regionName' => '<p>The Amazon Web Services Region name to add to the replication set.</p>', 'DeleteRegionAction$regionName' => '<p>The name of the Amazon Web Services Region you\'re deleting from the replication set.</p>', 'RegionInfoMap$key' => NULL, 'RegionMapInput$key' => NULL, ], ], 'RegionStatus' => [ 'base' => NULL, 'refs' => [ 'RegionInfo$status' => '<p>The status of the Amazon Web Services Region in the replication set.</p>', ], ], 'RelatedItem' => [ 'base' => '<p>Resources that responders use to triage and mitigate the incident.</p>', 'refs' => [ 'RelatedItemList$member' => NULL, 'RelatedItemsUpdate$itemToAdd' => '<p>Details about the related item you\'re adding.</p>', ], ], 'RelatedItemList' => [ 'base' => NULL, 'refs' => [ 'ListRelatedItemsOutput$relatedItems' => '<p>Details about each related item.</p>', 'StartIncidentInput$relatedItems' => '<p>Add related items to the incident for other responders to use. Related items are AWS resources, external links, or files uploaded to an Amazon S3 bucket. </p>', ], ], 'RelatedItemTitleString' => [ 'base' => NULL, 'refs' => [ 'RelatedItem$title' => '<p>The title of the related item.</p>', ], ], 'RelatedItemsUpdate' => [ 'base' => '<p>Details about the related item you\'re adding.</p>', 'refs' => [ 'UpdateRelatedItemsInput$relatedItemsUpdate' => '<p>Details about the item you are adding or deleting.</p>', ], ], 'ReplicationSet' => [ 'base' => '<p>The set of Amazon Web Services Region that your Incident Manager data will be replicated to and the KMS key used to encrypt the data. </p>', 'refs' => [ 'GetReplicationSetOutput$replicationSet' => '<p>Details of the replication set.</p>', ], ], 'ReplicationSetArnList' => [ 'base' => NULL, 'refs' => [ 'ListReplicationSetsOutput$replicationSetArns' => '<p>The Amazon Resource Name (ARN) of the list replication set.</p>', ], ], 'ReplicationSetStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationSet$status' => '<p>The status of the replication set. If the replication set is still pending, you can\'t use Incident Manager functionality.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Request references a resource which doesn\'t exist. </p>', 'refs' => [], ], 'ResourcePolicy' => [ 'base' => '<p>The resource policy that allows Incident Manager to perform actions on resources on your behalf.</p>', 'refs' => [ 'ResourcePolicyList$member' => NULL, ], ], 'ResourcePolicyList' => [ 'base' => NULL, 'refs' => [ 'GetResourcePoliciesOutput$resourcePolicies' => '<p>Details about the resource policy attached to the response plan.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceType' => '<p>The resource type</p>', 'ResourceNotFoundException$resourceType' => '<p>The resource type</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The resource type</p>', ], ], 'ResponsePlanDisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateResponsePlanInput$displayName' => '<p>The long format of the response plan name. This field can contain spaces.</p>', 'GetResponsePlanOutput$displayName' => '<p>The long format name of the response plan. Can contain spaces.</p>', 'ResponsePlanSummary$displayName' => '<p>The human readable name of the response plan. This can include spaces.</p>', 'UpdateResponsePlanInput$displayName' => '<p>The long format name of the response plan. The display name can\'t contain spaces.</p>', ], ], 'ResponsePlanName' => [ 'base' => NULL, 'refs' => [ 'CreateResponsePlanInput$name' => '<p>The short format name of the response plan. Can\'t include spaces.</p>', 'GetResponsePlanOutput$name' => '<p>The short format name of the response plan. The name can\'t contain spaces.</p>', 'ResponsePlanSummary$name' => '<p>The name of the response plan. This can\'t include spaces.</p>', ], ], 'ResponsePlanSummary' => [ 'base' => '<p>Details of the response plan that are used when creating an incident.</p>', 'refs' => [ 'ResponsePlanSummaryList$member' => NULL, ], ], 'ResponsePlanSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListResponsePlansOutput$responsePlanSummaries' => '<p>Details of each response plan.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'SsmAutomation$roleArn' => '<p>The Amazon Resource Name (ARN) of the role that the automation document will assume when running commands.</p>', ], ], 'ServiceCode' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$serviceCode' => '<p>Originating service code</p>', 'ThrottlingException$serviceCode' => '<p>Originating service code</p>', ], ], 'ServicePrincipal' => [ 'base' => NULL, 'refs' => [ 'IncidentRecordSource$invokedBy' => '<p>The service principal that assumed the role specified in <code>createdBy</code>. If no service principal assumed the role this will be left blank.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'SnsArn' => [ 'base' => NULL, 'refs' => [ 'ChatbotSnsConfigurationSet$member' => NULL, ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListTimelineEventsInput$sortOrder' => '<p>Sorts the order of timeline events by the value specified in the <code>sortBy</code> field.</p>', ], ], 'SseKmsKey' => [ 'base' => NULL, 'refs' => [ 'AddRegionAction$sseKmsKeyId' => '<p>The KMS key ID to use to encrypt your replication set.</p>', 'RegionInfo$sseKmsKeyId' => '<p>The ID of the KMS key used to encrypt the data in this Amazon Web Services Region.</p>', 'RegionMapInputValue$sseKmsKeyId' => '<p>The KMS key used to encrypt the data in your replication set.</p>', ], ], 'SsmAutomation' => [ 'base' => '<p>Details about the Systems Manager automation document that will be used as a runbook during an incident.</p>', 'refs' => [ 'Action$ssmAutomation' => '<p>The Systems Manager automation document to start as the runbook at the beginning of the incident.</p>', ], ], 'SsmAutomationDocumentNameString' => [ 'base' => NULL, 'refs' => [ 'SsmAutomation$documentName' => '<p>The automation document\'s name.</p>', ], ], 'SsmAutomationDocumentVersionString' => [ 'base' => NULL, 'refs' => [ 'SsmAutomation$documentVersion' => '<p>The automation document\'s version to use when running.</p>', ], ], 'SsmContactsArn' => [ 'base' => NULL, 'refs' => [ 'EngagementSet$member' => NULL, ], ], 'SsmParameterValues' => [ 'base' => NULL, 'refs' => [ 'SsmParameters$value' => NULL, ], ], 'SsmParameterValuesMemberString' => [ 'base' => NULL, 'refs' => [ 'SsmParameterValues$member' => NULL, ], ], 'SsmParameters' => [ 'base' => NULL, 'refs' => [ 'SsmAutomation$parameters' => '<p>The key-value pair parameters to use when running the automation document.</p>', ], ], 'SsmParametersKeyString' => [ 'base' => NULL, 'refs' => [ 'SsmParameters$key' => NULL, ], ], 'SsmTargetAccount' => [ 'base' => NULL, 'refs' => [ 'SsmAutomation$targetAccount' => '<p>The account that the automation document will be run in. This can be in either the management account or an application account.</p>', ], ], 'StartIncidentInput' => [ 'base' => NULL, 'refs' => [], ], 'StartIncidentOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceIdentifier' => '<p>The identifier of the requested resource</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the response plan.</p>', 'RegionInfo$statusMessage' => '<p>Information displayed about the status of the Amazon Web Services Region.</p>', 'ResourceNotFoundException$resourceIdentifier' => '<p>The identifier for the requested resource</p>', 'ResourcePolicy$ramResourceShareRegion' => '<p>The Amazon Web Services Region that policy allows resources to be used in.</p>', 'ServiceQuotaExceededException$quotaCode' => '<p>Originating quota code</p>', 'ServiceQuotaExceededException$resourceIdentifier' => '<p>The identifier for the requested resource</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the response plan you\'re adding the tags to.</p>', 'ThrottlingException$quotaCode' => '<p>Originating quota code</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the response plan you\'re removing a tag from.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'AttributeValueList$stringValues' => '<p>The list of string values that the filter matches.</p>', ], ], 'StringListMemberString' => [ 'base' => NULL, 'refs' => [ 'StringList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The name of the tag you\'re removing from the response plan.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateResponsePlanInput$tags' => '<p>A list of tags that you are adding to the response plan.</p>', 'ListTagsForResourceResponse$tags' => '<p>A list of tags for the response plan.</p>', 'TagResourceRequest$tags' => '<p>A list of tags that you are adding to the response plan.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TimelineEvent' => [ 'base' => '<p>A significant event that happened during the incident. </p>', 'refs' => [ 'GetTimelineEventOutput$event' => '<p>Details about the timeline event.</p>', ], ], 'TimelineEventSort' => [ 'base' => NULL, 'refs' => [ 'ListTimelineEventsInput$sortBy' => '<p>Sort by the specified key value pair.</p>', ], ], 'TimelineEventType' => [ 'base' => NULL, 'refs' => [ 'CreateTimelineEventInput$eventType' => '<p>The type of the event. You can create timeline events of type <code>Custom Event</code>.</p>', 'EventSummary$eventType' => '<p>The type of event. The timeline event must be <code>Custom Event</code>.</p>', 'TimelineEvent$eventType' => '<p>The type of event that occurred. Currently Incident Manager supports only the <code>Custom Event</code> type.</p>', 'UpdateTimelineEventInput$eventType' => '<p>The type of the event. You can update events of type <code>Custom Event</code>.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Condition$after' => '<p>After the specified timestamp.</p>', 'Condition$before' => '<p>Before the specified timestamp</p>', 'ConflictException$retryAfter' => '<p>If present in the output, the operation can be retried after this time</p>', 'CreateTimelineEventInput$eventTime' => '<p>The time that the event occurred.</p>', 'EventSummary$eventTime' => '<p>The time that the event occurred.</p>', 'EventSummary$eventUpdatedTime' => '<p>The time that the timeline event was last updated.</p>', 'IncidentRecord$creationTime' => '<p>The time that Incident Manager created the incident record.</p>', 'IncidentRecord$lastModifiedTime' => '<p>The time at which the incident was most recently modified.</p>', 'IncidentRecord$resolvedTime' => '<p>The time at which the incident was resolved. This appears as a timeline event.</p>', 'IncidentRecordSummary$creationTime' => '<p>The time the incident was created.</p>', 'IncidentRecordSummary$resolvedTime' => '<p>The time the incident was resolved.</p>', 'RegionInfo$statusUpdateDateTime' => '<p>The most recent date and time that Incident Manager updated the Amazon Web Services Region\'s status.</p>', 'ReplicationSet$createdTime' => '<p>When the replication set was created.</p>', 'ReplicationSet$lastModifiedTime' => '<p>When the replication set was last updated.</p>', 'TimelineEvent$eventTime' => '<p>The time that the event occurred.</p>', 'TimelineEvent$eventUpdatedTime' => '<p>The time that the timeline event was last updated.</p>', 'TriggerDetails$timestamp' => '<p>The time that the incident was detected.</p>', 'UpdateTimelineEventInput$eventTime' => '<p>The time that the event occurred.</p>', ], ], 'TriggerDetails' => [ 'base' => '<p>Details about what caused the incident to be created in Incident Manager.</p>', 'refs' => [ 'StartIncidentInput$triggerDetails' => '<p>Details of what created the incident record in Incident Manager.</p>', ], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'CreateTimelineEventOutput$eventId' => '<p>The ID of the event for easy reference later. </p>', 'DeleteTimelineEventInput$eventId' => '<p>The ID of the event you are updating. You can find this by using <code>ListTimelineEvents</code>.</p>', 'EventSummary$eventId' => '<p>The timeline event ID.</p>', 'GetTimelineEventInput$eventId' => '<p>The ID of the event. You can get an event\'s ID when you create it, or by using <code>ListTimelineEvents</code>.</p>', 'TimelineEvent$eventId' => '<p>The ID of the timeline event.</p>', 'UpdateTimelineEventInput$eventId' => '<p>The ID of the event you are updating. You can find this by using <code>ListTimelineEvents</code>.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeletionProtectionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeletionProtectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIncidentRecordInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIncidentRecordOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRelatedItemsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRelatedItemsOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationSetAction' => [ 'base' => '<p>Details used when updating the replication set.</p>', 'refs' => [ 'UpdateReplicationSetInputActionsList$member' => NULL, ], ], 'UpdateReplicationSetInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationSetInputActionsList' => [ 'base' => NULL, 'refs' => [ 'UpdateReplicationSetInput$actions' => '<p>An action to add or delete a Region.</p>', ], ], 'UpdateReplicationSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResponsePlanInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResponsePlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTimelineEventInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTimelineEventOutput' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'ItemValue$url' => '<p>The URL, if the related item is a non-Amazon Web Services resource.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', 'refs' => [], ], 'VariableType' => [ 'base' => NULL, 'refs' => [ 'DynamicSsmParameterValue$variable' => '<p>Variable dynamic parameters. A parameter value is determined when an incident is created.</p>', ], ], ],];
