<?php
// This file was auto-generated from sdk-root/src/data/signer/2017-08-25/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS Signer is a fully managed code signing service to help you ensure the trust and integrity of your code. </p> <p>AWS Signer supports the following applications:</p> <p>With <i>code signing for AWS Lambda</i>, you can sign AWS Lambda deployment packages. Integrated support is provided for Amazon S3, Amazon CloudWatch, and AWS CloudTrail. In order to sign code, you create a signing profile and then use Signer to sign Lambda zip files in S3. </p> <p>With <i>code signing for IoT</i>, you can sign code for any IoT device that is supported by AWS. IoT code signing is available for <a href="http://docs.aws.amazon.com/freertos/latest/userguide/">Amazon FreeRTOS</a> and <a href="http://docs.aws.amazon.com/iot/latest/developerguide/">AWS IoT Device Management</a>, and is integrated with <a href="http://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager (ACM)</a>. In order to sign code, you import a third-party code signing certificate using ACM, and use that to sign updates in Amazon FreeRTOS and AWS IoT Device Management. </p> <p>For more information about AWS Signer, see the <a href="http://docs.aws.amazon.com/signer/latest/developerguide/Welcome.html">AWS Signer Developer Guide</a>.</p> <p/>', 'operations' => [ 'AddProfilePermission' => '<p>Adds cross-account permissions to a signing profile.</p>', 'CancelSigningProfile' => '<p>Changes the state of an <code>ACTIVE</code> signing profile to <code>CANCELED</code>. A canceled profile is still viewable with the <code>ListSigningProfiles</code> operation, but it cannot perform new signing jobs, and is deleted two years after cancelation.</p>', 'DescribeSigningJob' => '<p>Returns information about a specific code signing job. You specify the job by using the <code>jobId</code> value that is returned by the <a>StartSigningJob</a> operation. </p>', 'GetSigningPlatform' => '<p>Returns information on a specific signing platform.</p>', 'GetSigningProfile' => '<p>Returns information on a specific signing profile.</p>', 'ListProfilePermissions' => '<p>Lists the cross-account permissions associated with a signing profile.</p>', 'ListSigningJobs' => '<p>Lists all your signing jobs. You can use the <code>maxResults</code> parameter to limit the number of signing jobs that are returned in the response. If additional jobs remain to be listed, code signing returns a <code>nextToken</code> value. Use this value in subsequent calls to <code>ListSigningJobs</code> to fetch the remaining values. You can continue calling <code>ListSigningJobs</code> with your <code>maxResults</code> parameter and with new values that code signing returns in the <code>nextToken</code> parameter until all of your signing jobs have been returned. </p>', 'ListSigningPlatforms' => '<p>Lists all signing platforms available in code signing that match the request parameters. If additional jobs remain to be listed, code signing returns a <code>nextToken</code> value. Use this value in subsequent calls to <code>ListSigningJobs</code> to fetch the remaining values. You can continue calling <code>ListSigningJobs</code> with your <code>maxResults</code> parameter and with new values that code signing returns in the <code>nextToken</code> parameter until all of your signing jobs have been returned.</p>', 'ListSigningProfiles' => '<p>Lists all available signing profiles in your AWS account. Returns only profiles with an <code>ACTIVE</code> status unless the <code>includeCanceled</code> request field is set to <code>true</code>. If additional jobs remain to be listed, code signing returns a <code>nextToken</code> value. Use this value in subsequent calls to <code>ListSigningJobs</code> to fetch the remaining values. You can continue calling <code>ListSigningJobs</code> with your <code>maxResults</code> parameter and with new values that code signing returns in the <code>nextToken</code> parameter until all of your signing jobs have been returned.</p>', 'ListTagsForResource' => '<p>Returns a list of the tags associated with a signing profile resource.</p>', 'PutSigningProfile' => '<p>Creates a signing profile. A signing profile is a code signing template that can be used to carry out a pre-defined signing job. For more information, see <a href="http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html">http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html</a> </p>', 'RemoveProfilePermission' => '<p>Removes cross-account permissions from a signing profile.</p>', 'RevokeSignature' => '<p>Changes the state of a signing job to REVOKED. This indicates that the signature is no longer valid.</p>', 'RevokeSigningProfile' => '<p>Changes the state of a signing profile to REVOKED. This indicates that signatures generated using the signing profile after an effective start date are no longer valid.</p>', 'StartSigningJob' => '<p>Initiates a signing job to be performed on the code provided. Signing jobs are viewable by the <code>ListSigningJobs</code> operation for two years after they are performed. Note the following requirements: </p> <ul> <li> <p> You must create an Amazon S3 source bucket. For more information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/gsg/CreatingABucket.html">Create a Bucket</a> in the <i>Amazon S3 Getting Started Guide</i>. </p> </li> <li> <p>Your S3 source bucket must be version enabled.</p> </li> <li> <p>You must create an S3 destination bucket. Code signing uses your S3 destination bucket to write your signed code.</p> </li> <li> <p>You specify the name of the source and destination buckets when calling the <code>StartSigningJob</code> operation.</p> </li> <li> <p>You must also specify a request token that identifies your request to code signing.</p> </li> </ul> <p>You can call the <a>DescribeSigningJob</a> and the <a>ListSigningJobs</a> actions after you call <code>StartSigningJob</code>.</p> <p>For a Java example that shows how to use this action, see <a href="http://docs.aws.amazon.com/acm/latest/userguide/">http://docs.aws.amazon.com/acm/latest/userguide/</a> </p>', 'TagResource' => '<p>Adds one or more tags to a signing profile. Tags are labels that you can use to identify and organize your AWS resources. Each tag consists of a key and an optional value. To specify the signing profile, use its Amazon Resource Name (ARN). To specify the tag, use a key-value pair.</p>', 'UntagResource' => '<p>Removes one or more tags from a signing profile. To remove the tags, specify a list of tag keys.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'DescribeSigningJobResponse$jobOwner' => '<p>The AWS account ID of the job owner.</p>', 'DescribeSigningJobResponse$jobInvoker' => '<p>The IAM entity that initiated the signing job.</p>', 'GetSigningProfileRequest$profileOwner' => '<p>The AWS account ID of the profile owner.</p>', 'ListSigningJobsRequest$jobInvoker' => '<p>Filters results to return only signing jobs initiated by a specified IAM entity.</p>', 'RevokeSignatureRequest$jobOwner' => '<p>AWS account ID of the job owner.</p>', 'SigningJob$jobOwner' => '<p>The AWS account ID of the job owner.</p>', 'SigningJob$jobInvoker' => '<p>The AWS account ID of the job invoker.</p>', 'StartSigningJobRequest$profileOwner' => '<p>The AWS account ID of the signing profile owner.</p>', 'StartSigningJobResponse$jobOwner' => '<p>The AWS account ID of the signing job owner.</p>', ], ], 'AddProfilePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddProfilePermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'GetSigningProfileResponse$profileVersionArn' => '<p>The signing profile ARN, including the profile version.</p>', 'PutSigningProfileResponse$profileVersionArn' => '<p>The signing profile ARN, including the profile version.</p>', 'SigningProfile$profileVersionArn' => '<p>The ARN of a signing profile, including the profile version.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>The request contains invalid parameters for the ARN or tags. This exception also occurs when you call a tagging API on a cancelled signing profile.</p>', 'refs' => [], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Destination$bucketName' => '<p>Name of the S3 bucket.</p>', 'S3SignedObject$bucketName' => '<p>Name of the S3 bucket.</p>', 'S3Source$bucketName' => '<p>Name of the S3 bucket.</p>', ], ], 'CancelSigningProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'Category' => [ 'base' => NULL, 'refs' => [ 'GetSigningPlatformResponse$category' => '<p>The category type of the target signing platform.</p>', 'SigningPlatform$category' => '<p>The category of a code signing platform.</p>', ], ], 'CertificateArn' => [ 'base' => NULL, 'refs' => [ 'SigningMaterial$certificateArn' => '<p>The Amazon Resource Name (ARN) of the certificates that is used to sign your code.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'StartSigningJobRequest$clientRequestToken' => '<p>String that identifies the signing request. All calls after the first that use this token return the same response as the first call.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The resource encountered a conflicting state.</p>', 'refs' => [], ], 'DescribeSigningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSigningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'Destination' => [ 'base' => '<p>Points to an <code>S3Destination</code> object that contains information about your S3 bucket.</p>', 'refs' => [ 'StartSigningJobRequest$destination' => '<p>The S3 bucket in which to save your signed object. The destination contains the name of your bucket and an optional prefix.</p>', ], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'DescribeSigningJobResponse$platformDisplayName' => '<p>A human-readable name for the signing platform associated with the signing job.</p>', 'GetSigningPlatformResponse$displayName' => '<p>The display name of the target signing platform.</p>', 'GetSigningProfileResponse$platformDisplayName' => '<p>A human-readable name for the signing platform associated with the signing profile.</p>', 'SigningJob$platformDisplayName' => '<p>The name of a signing platform.</p>', 'SigningProfile$platformDisplayName' => '<p>The name of the signing platform.</p>', ], ], 'EncryptionAlgorithm' => [ 'base' => NULL, 'refs' => [ 'EncryptionAlgorithmOptions$defaultValue' => '<p>The default encryption algorithm that is used by a code signing job.</p>', 'EncryptionAlgorithms$member' => NULL, 'SigningConfigurationOverrides$encryptionAlgorithm' => '<p>A specified override of the default encryption algorithm that is used in a code signing job.</p>', ], ], 'EncryptionAlgorithmOptions' => [ 'base' => '<p>The encryption algorithm options that are available to a code signing job.</p>', 'refs' => [ 'SigningConfiguration$encryptionAlgorithmOptions' => '<p>The encryption algorithm options that are available for a code signing job.</p>', ], ], 'EncryptionAlgorithms' => [ 'base' => NULL, 'refs' => [ 'EncryptionAlgorithmOptions$allowedValues' => '<p>The set of accepted encryption algorithms that are allowed in a code signing job.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$code' => NULL, 'BadRequestException$code' => NULL, 'ConflictException$code' => NULL, 'InternalServiceErrorException$code' => NULL, 'NotFoundException$code' => NULL, 'ResourceNotFoundException$code' => NULL, 'ServiceLimitExceededException$code' => NULL, 'ThrottlingException$code' => NULL, 'TooManyRequestsException$code' => NULL, 'ValidationException$code' => NULL, ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'BadRequestException$message' => NULL, 'ConflictException$message' => NULL, 'InternalServiceErrorException$message' => NULL, 'NotFoundException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceLimitExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'TooManyRequestsException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'GetSigningPlatformRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSigningPlatformResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSigningProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSigningProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'HashAlgorithm' => [ 'base' => NULL, 'refs' => [ 'HashAlgorithmOptions$defaultValue' => '<p>The default hash algorithm that is used in a code signing job.</p>', 'HashAlgorithms$member' => NULL, 'SigningConfigurationOverrides$hashAlgorithm' => '<p>A specified override of the default hash algorithm that is used in a code signing job.</p>', ], ], 'HashAlgorithmOptions' => [ 'base' => '<p>The hash algorithms that are available to a code signing job.</p>', 'refs' => [ 'SigningConfiguration$hashAlgorithmOptions' => '<p>The hash algorithm options that are available for a code signing job.</p>', ], ], 'HashAlgorithms' => [ 'base' => NULL, 'refs' => [ 'HashAlgorithmOptions$allowedValues' => '<p>The set of accepted hash algorithms allowed in a code signing job.</p>', ], ], 'ImageFormat' => [ 'base' => NULL, 'refs' => [ 'ImageFormats$member' => NULL, 'SigningImageFormat$defaultFormat' => '<p>The default format of a code signing image.</p>', 'SigningPlatformOverrides$signingImageFormat' => '<p>A signed image is a JSON object. When overriding the default signing platform configuration, a customer can select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A third format value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the signing image has the payload embedded in it. With <code>JSONDetached</code>, the payload is not be embedded in the signing image.</p>', ], ], 'ImageFormats' => [ 'base' => NULL, 'refs' => [ 'SigningImageFormat$supportedFormats' => '<p>The supported formats of a code signing image.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'SignatureValidityPeriod$value' => '<p>The numerical value of the time unit for signature validity.</p>', ], ], 'InternalServiceErrorException' => [ 'base' => '<p>An internal error occurred.</p>', 'refs' => [], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'DescribeSigningJobRequest$jobId' => '<p>The ID of the signing job on input.</p>', 'DescribeSigningJobResponse$jobId' => '<p>The ID of the signing job on output.</p>', 'RevokeSignatureRequest$jobId' => '<p>ID of the signing job to be revoked.</p>', 'SigningJob$jobId' => '<p>The ID of the signing job.</p>', 'StartSigningJobResponse$jobId' => '<p>The ID of your signing job.</p>', ], ], 'Key' => [ 'base' => NULL, 'refs' => [ 'S3SignedObject$key' => '<p>Key name that uniquely identifies a signed code image in your bucket.</p>', 'S3Source$key' => '<p>Key name of the bucket object that contains your unsigned code.</p>', ], ], 'ListProfilePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProfilePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSigningJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSigningJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSigningPlatformsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSigningPlatformsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSigningProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSigningProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListSigningJobsRequest$maxResults' => '<p>Specifies the maximum number of items to return in the response. Use this parameter when paginating results. If additional items exist beyond the number you specify, the <code>nextToken</code> element is set in the response. Use the <code>nextToken</code> value in a subsequent request to retrieve additional items. </p>', 'ListSigningPlatformsRequest$maxResults' => '<p>The maximum number of results to be returned by this operation.</p>', 'ListSigningProfilesRequest$maxResults' => '<p>The maximum number of profiles to be returned.</p>', ], ], 'MaxSizeInMB' => [ 'base' => NULL, 'refs' => [ 'GetSigningPlatformResponse$maxSizeInMB' => '<p>The maximum size (in MB) of the payload that can be signed by the target platform.</p>', 'SigningPlatform$maxSizeInMB' => '<p>The maximum size (in MB) of code that can be signed by a code signing platform.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListSigningJobsRequest$nextToken' => '<p>String for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>', 'ListSigningJobsResponse$nextToken' => '<p>String for specifying the next set of paginated results.</p>', 'ListSigningProfilesRequest$nextToken' => '<p>Value for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>', 'ListSigningProfilesResponse$nextToken' => '<p>Value for specifying the next set of paginated results to return.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>The signing profile was not found.</p>', 'refs' => [], ], 'Permission' => [ 'base' => '<p>A cross-account permission for a signing profile.</p>', 'refs' => [ 'Permissions$member' => NULL, ], ], 'Permissions' => [ 'base' => NULL, 'refs' => [ 'ListProfilePermissionsResponse$permissions' => '<p>List of permissions associated with the Signing Profile.</p>', ], ], 'PlatformId' => [ 'base' => NULL, 'refs' => [ 'DescribeSigningJobResponse$platformId' => '<p>The microcontroller platform to which your signed code image will be distributed.</p>', 'GetSigningPlatformRequest$platformId' => '<p>The ID of the target signing platform.</p>', 'GetSigningPlatformResponse$platformId' => '<p>The ID of the target signing platform.</p>', 'GetSigningProfileResponse$platformId' => '<p>The ID of the platform that is used by the target signing profile.</p>', 'ListSigningJobsRequest$platformId' => '<p>The ID of microcontroller platform that you specified for the distribution of your code image.</p>', 'ListSigningProfilesRequest$platformId' => '<p>Filters results to return only signing jobs initiated for a specified signing platform.</p>', 'PutSigningProfileRequest$platformId' => '<p>The ID of the signing platform to be created.</p>', 'SigningJob$platformId' => '<p>The unique identifier for a signing platform.</p>', 'SigningProfile$platformId' => '<p>The ID of a platform that is available for use by a signing profile.</p>', ], ], 'PolicySizeBytes' => [ 'base' => NULL, 'refs' => [ 'ListProfilePermissionsResponse$policySizeBytes' => '<p>Total size of the policy associated with the Signing Profile in bytes.</p>', ], ], 'Prefix' => [ 'base' => NULL, 'refs' => [ 'S3Destination$prefix' => '<p>An Amazon S3 prefix that you can use to limit responses to those that begin with the specified prefix.</p>', ], ], 'ProfileName' => [ 'base' => NULL, 'refs' => [ 'AddProfilePermissionRequest$profileName' => '<p>The human-readable name of the signing profile.</p>', 'CancelSigningProfileRequest$profileName' => '<p>The name of the signing profile to be canceled.</p>', 'DescribeSigningJobResponse$profileName' => '<p>The name of the profile that initiated the signing operation.</p>', 'GetSigningProfileRequest$profileName' => '<p>The name of the target signing profile.</p>', 'GetSigningProfileResponse$profileName' => '<p>The name of the target signing profile.</p>', 'ListProfilePermissionsRequest$profileName' => '<p>Name of the signing profile containing the cross-account permissions.</p>', 'PutSigningProfileRequest$profileName' => '<p>The name of the signing profile to be created.</p>', 'RemoveProfilePermissionRequest$profileName' => '<p>A human-readable name for the signing profile with permissions to be removed.</p>', 'RevokeSigningProfileRequest$profileName' => '<p>The name of the signing profile to be revoked.</p>', 'SigningJob$profileName' => '<p>The name of the signing profile that created a signing job.</p>', 'SigningProfile$profileName' => '<p>The name of the signing profile.</p>', 'StartSigningJobRequest$profileName' => '<p>The name of the signing profile.</p>', ], ], 'ProfileVersion' => [ 'base' => NULL, 'refs' => [ 'AddProfilePermissionRequest$profileVersion' => '<p>The version of the signing profile.</p>', 'DescribeSigningJobResponse$profileVersion' => '<p>The version of the signing profile used to initiate the signing job.</p>', 'GetSigningProfileResponse$profileVersion' => '<p>The current version of the signing profile.</p>', 'Permission$profileVersion' => '<p>The signing profile version that a permission applies to.</p>', 'PutSigningProfileResponse$profileVersion' => '<p>The version of the signing profile being created.</p>', 'RevokeSigningProfileRequest$profileVersion' => '<p>The version of the signing profile to be revoked.</p>', 'SigningJob$profileVersion' => '<p>The version of the signing profile that created a signing job.</p>', 'SigningProfile$profileVersion' => '<p>The version of a signing profile.</p>', ], ], 'PutSigningProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutSigningProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveProfilePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveProfilePermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'RequestedBy' => [ 'base' => NULL, 'refs' => [ 'DescribeSigningJobResponse$requestedBy' => '<p>The IAM principal that requested the signing job.</p>', 'ListSigningJobsRequest$requestedBy' => '<p>The IAM principal that requested the signing job.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A specified resource could not be found.</p>', 'refs' => [], ], 'RevocationReasonString' => [ 'base' => NULL, 'refs' => [ 'RevokeSignatureRequest$reason' => '<p>The reason for revoking the signing job.</p>', 'RevokeSigningProfileRequest$reason' => '<p>The reason for revoking a signing profile.</p>', ], ], 'RevokeSignatureRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokeSigningProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'S3Destination' => [ 'base' => '<p>The name and prefix of the S3 bucket where code signing saves your signed objects.</p>', 'refs' => [ 'Destination$s3' => '<p>The <code>S3Destination</code> object.</p>', ], ], 'S3SignedObject' => [ 'base' => '<p>The S3 bucket name and key where code signing saved your signed code image.</p>', 'refs' => [ 'SignedObject$s3' => '<p>The <code>S3SignedObject</code>.</p>', ], ], 'S3Source' => [ 'base' => '<p>Information about the S3 bucket where you saved your unsigned code.</p>', 'refs' => [ 'Source$s3' => '<p>The <code>S3Source</code> object.</p>', ], ], 'ServiceLimitExceededException' => [ 'base' => '<p>The client is making a request that exceeds service limits.</p>', 'refs' => [], ], 'SignatureValidityPeriod' => [ 'base' => '<p>The validity period for a signing job.</p>', 'refs' => [ 'GetSigningProfileResponse$signatureValidityPeriod' => NULL, 'PutSigningProfileRequest$signatureValidityPeriod' => '<p>The default validity period override for any signature generated using this signing profile. If unspecified, the default is 135 months.</p>', 'SigningProfile$signatureValidityPeriod' => '<p>The validity period for a signing job created using this signing profile.</p>', ], ], 'SignedObject' => [ 'base' => '<p>Points to an <code>S3SignedObject</code> object that contains information about your signed code image.</p>', 'refs' => [ 'DescribeSigningJobResponse$signedObject' => '<p>Name of the S3 bucket where the signed code image is saved by code signing.</p>', 'SigningJob$signedObject' => '<p>A <code>SignedObject</code> structure that contains information about a signing job\'s signed code image.</p>', ], ], 'SigningConfiguration' => [ 'base' => '<p>The configuration of a code signing operation.</p>', 'refs' => [ 'GetSigningPlatformResponse$signingConfiguration' => '<p>A list of configurations applied to the target platform at signing.</p>', 'SigningPlatform$signingConfiguration' => '<p>The configuration of a code signing platform. This includes the designated hash algorithm and encryption algorithm of a signing platform.</p>', ], ], 'SigningConfigurationOverrides' => [ 'base' => '<p>A signing configuration that overrides the default encryption or hash algorithm of a signing job.</p>', 'refs' => [ 'SigningPlatformOverrides$signingConfiguration' => '<p>A signing configuration that overrides the default encryption or hash algorithm of a signing job.</p>', ], ], 'SigningImageFormat' => [ 'base' => '<p>The image format of a code signing platform or profile.</p>', 'refs' => [ 'GetSigningPlatformResponse$signingImageFormat' => '<p>The format of the target platform\'s signing image.</p>', 'SigningPlatform$signingImageFormat' => NULL, ], ], 'SigningJob' => [ 'base' => '<p>Contains information about a signing job.</p>', 'refs' => [ 'SigningJobs$member' => NULL, ], ], 'SigningJobRevocationRecord' => [ 'base' => '<p>Revocation information for a signing job.</p>', 'refs' => [ 'DescribeSigningJobResponse$revocationRecord' => '<p>A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.</p>', ], ], 'SigningJobs' => [ 'base' => NULL, 'refs' => [ 'ListSigningJobsResponse$jobs' => '<p>A list of your signing jobs.</p>', ], ], 'SigningMaterial' => [ 'base' => '<p>The ACM certificate that is used to sign your code.</p>', 'refs' => [ 'DescribeSigningJobResponse$signingMaterial' => '<p>The Amazon Resource Name (ARN) of your code signing certificate.</p>', 'GetSigningProfileResponse$signingMaterial' => '<p>The ARN of the certificate that the target profile uses for signing operations.</p>', 'PutSigningProfileRequest$signingMaterial' => '<p>The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.</p>', 'SigningJob$signingMaterial' => '<p>A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used for the signing job.</p>', 'SigningProfile$signingMaterial' => '<p>The ACM certificate that is available for use by a signing profile.</p>', ], ], 'SigningParameterKey' => [ 'base' => NULL, 'refs' => [ 'SigningParameters$key' => NULL, ], ], 'SigningParameterValue' => [ 'base' => NULL, 'refs' => [ 'SigningParameters$value' => NULL, ], ], 'SigningParameters' => [ 'base' => NULL, 'refs' => [ 'DescribeSigningJobResponse$signingParameters' => '<p>Map of user-assigned key-value pairs used during signing. These values contain any information that you specified for use in your signing job. </p>', 'GetSigningProfileResponse$signingParameters' => '<p>A map of key-value pairs for signing operations that is attached to the target signing profile.</p>', 'PutSigningProfileRequest$signingParameters' => '<p>Map of key-value pairs for signing. These can include any information that you want to use during signing.</p>', 'SigningProfile$signingParameters' => '<p>The parameters that are available for use by a code signing user.</p>', ], ], 'SigningPlatform' => [ 'base' => '<p>Contains information about the signing configurations and parameters that are used to perform a code signing job.</p>', 'refs' => [ 'SigningPlatforms$member' => NULL, ], ], 'SigningPlatformOverrides' => [ 'base' => '<p>Any overrides that are applied to the signing configuration of a code signing platform.</p>', 'refs' => [ 'DescribeSigningJobResponse$overrides' => '<p>A list of any overrides that were applied to the signing operation.</p>', 'GetSigningProfileResponse$overrides' => '<p>A list of overrides applied by the target signing profile for signing operations.</p>', 'PutSigningProfileRequest$overrides' => '<p>A subfield of <code>platform</code>. This specifies any different configuration options that you want to apply to the chosen platform (such as a different <code>hash-algorithm</code> or <code>signing-algorithm</code>).</p>', ], ], 'SigningPlatforms' => [ 'base' => NULL, 'refs' => [ 'ListSigningPlatformsResponse$platforms' => '<p>A list of all platforms that match the request parameters.</p>', ], ], 'SigningProfile' => [ 'base' => '<p>Contains information about the ACM certificates and code signing configuration parameters that can be used by a given code signing user.</p>', 'refs' => [ 'SigningProfiles$member' => NULL, ], ], 'SigningProfileRevocationRecord' => [ 'base' => '<p>Revocation information for a signing profile.</p>', 'refs' => [ 'GetSigningProfileResponse$revocationRecord' => NULL, ], ], 'SigningProfileStatus' => [ 'base' => NULL, 'refs' => [ 'GetSigningProfileResponse$status' => '<p>The status of the target signing profile.</p>', 'SigningProfile$status' => '<p>The status of a code signing profile.</p>', 'Statuses$member' => NULL, ], ], 'SigningProfiles' => [ 'base' => NULL, 'refs' => [ 'ListSigningProfilesResponse$profiles' => '<p>A list of profiles that are available in the AWS account. This includes profiles with the status of <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set to <code>true</code>.</p>', ], ], 'SigningStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeSigningJobResponse$status' => '<p>Status of the signing job.</p>', 'ListSigningJobsRequest$status' => '<p>A status value with which to filter your results.</p>', 'SigningJob$status' => '<p>The status of the signing job.</p>', ], ], 'Source' => [ 'base' => '<p>An <code>S3Source</code> object that contains information about the S3 bucket where you saved your unsigned code.</p>', 'refs' => [ 'DescribeSigningJobResponse$source' => '<p>The object that contains the name of your S3 bucket or your raw code.</p>', 'SigningJob$source' => '<p>A <code>Source</code> that contains information about a signing job\'s code image source.</p>', 'StartSigningJobRequest$source' => '<p>The S3 bucket that contains the object to sign or a BLOB that contains your raw code.</p>', ], ], 'StartSigningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSigningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatusReason' => [ 'base' => NULL, 'refs' => [ 'DescribeSigningJobResponse$statusReason' => '<p>String value that contains the status reason.</p>', ], ], 'Statuses' => [ 'base' => NULL, 'refs' => [ 'ListSigningProfilesRequest$statuses' => '<p>Filters results to return only signing jobs with statuses in the specified list.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddProfilePermissionRequest$action' => '<p>The AWS Signer action permitted as part of cross-account permissions.</p>', 'AddProfilePermissionRequest$principal' => '<p>The AWS principal receiving cross-account permissions. This may be an IAM role or another AWS account ID.</p>', 'AddProfilePermissionRequest$revisionId' => '<p>A unique identifier for the current profile revision.</p>', 'AddProfilePermissionRequest$statementId' => '<p>A unique identifier for the cross-account permission statement.</p>', 'AddProfilePermissionResponse$revisionId' => '<p>A unique identifier for the current profile revision.</p>', 'GetSigningPlatformResponse$partner' => '<p>A list of partner entities that use the target signing platform.</p>', 'GetSigningPlatformResponse$target' => '<p>The validation template that is used by the target signing platform.</p>', 'GetSigningProfileResponse$statusReason' => '<p>Reason for the status of the target signing profile.</p>', 'ListProfilePermissionsRequest$nextToken' => '<p>String for specifying the next set of paginated results.</p>', 'ListProfilePermissionsResponse$revisionId' => '<p>The identifier for the current revision of profile permissions.</p>', 'ListProfilePermissionsResponse$nextToken' => '<p>String for specifying the next set of paginated results.</p>', 'ListSigningPlatformsRequest$category' => '<p>The category type of a signing platform.</p>', 'ListSigningPlatformsRequest$partner' => '<p>Any partner entities connected to a signing platform.</p>', 'ListSigningPlatformsRequest$target' => '<p>The validation template that is used by the target signing platform.</p>', 'ListSigningPlatformsRequest$nextToken' => '<p>Value for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>', 'ListSigningPlatformsResponse$nextToken' => '<p>Value for specifying the next set of paginated results to return.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) for the signing profile.</p>', 'Permission$action' => '<p>An AWS Signer action permitted as part of cross-account permissions.</p>', 'Permission$principal' => '<p>The AWS principal that has been granted a cross-account permission.</p>', 'Permission$statementId' => '<p>A unique identifier for a cross-account permission statement.</p>', 'RemoveProfilePermissionRequest$revisionId' => '<p>An identifier for the current revision of the signing profile permissions.</p>', 'RemoveProfilePermissionRequest$statementId' => '<p>A unique identifier for the cross-account permissions statement.</p>', 'RemoveProfilePermissionResponse$revisionId' => '<p>An identifier for the current revision of the profile permissions.</p>', 'SigningJobRevocationRecord$reason' => '<p>A caller-supplied reason for revocation.</p>', 'SigningJobRevocationRecord$revokedBy' => '<p>The identity of the revoker.</p>', 'SigningPlatform$platformId' => '<p>The ID of a code signing; platform.</p>', 'SigningPlatform$displayName' => '<p>The display name of a code signing platform.</p>', 'SigningPlatform$partner' => '<p>Any partner entities linked to a code signing platform.</p>', 'SigningPlatform$target' => '<p>The types of targets that can be signed by a code signing platform.</p>', 'SigningProfileRevocationRecord$revokedBy' => '<p>The identity of the revoker.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) for the signing profile.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) for the signing profile.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of tag keys to be removed from the signing profile.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'GetSigningProfileResponse$tags' => '<p>A list of tags associated with the signing profile.</p>', 'ListTagsForResourceResponse$tags' => '<p>A list of tags associated with the signing profile.</p>', 'PutSigningProfileRequest$tags' => '<p>Tags to be associated with the signing profile that is being created.</p>', 'SigningProfile$tags' => '<p>A list of tags associated with the signing profile.</p>', 'TagResourceRequest$tags' => '<p>One or more tags to be associated with the signing profile.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p> <p>Instead of this error, <code>TooManyRequestsException</code> should be used.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DescribeSigningJobResponse$createdAt' => '<p>Date and time that the signing job was created.</p>', 'DescribeSigningJobResponse$completedAt' => '<p>Date and time that the signing job was completed.</p>', 'DescribeSigningJobResponse$signatureExpiresAt' => '<p>Thr expiration timestamp for the signature generated by the signing job.</p>', 'ListSigningJobsRequest$signatureExpiresBefore' => '<p>Filters results to return only signing jobs with signatures expiring before a specified timestamp.</p>', 'ListSigningJobsRequest$signatureExpiresAfter' => '<p>Filters results to return only signing jobs with signatures expiring after a specified timestamp.</p>', 'RevokeSigningProfileRequest$effectiveTime' => '<p>A timestamp for when revocation of a Signing Profile should become effective. Signatures generated using the signing profile after this timestamp are not trusted.</p>', 'SigningJob$createdAt' => '<p>The date and time that the signing job was created.</p>', 'SigningJob$signatureExpiresAt' => '<p>The time when the signature of a signing job expires.</p>', 'SigningJobRevocationRecord$revokedAt' => '<p>The time of revocation.</p>', 'SigningProfileRevocationRecord$revocationEffectiveFrom' => '<p>The time when revocation becomes effective.</p>', 'SigningProfileRevocationRecord$revokedAt' => '<p>The time when the signing profile was revoked.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>The allowed number of job-signing requests has been exceeded.</p> <p>This error supersedes the error <code>ThrottlingException</code>.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>You signing certificate could not be validated.</p>', 'refs' => [], ], 'ValidityType' => [ 'base' => NULL, 'refs' => [ 'SignatureValidityPeriod$type' => '<p>The time unit for signature validity.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'S3Source$version' => '<p>Version of your source image in your version enabled S3 bucket.</p>', ], ], 'bool' => [ 'base' => NULL, 'refs' => [ 'GetSigningPlatformResponse$revocationSupported' => '<p>A flag indicating whether signatures generated for the signing platform can be revoked.</p>', 'ListSigningJobsRequest$isRevoked' => '<p>Filters results to return only signing jobs with revoked signatures.</p>', 'ListSigningProfilesRequest$includeCanceled' => '<p>Designates whether to include profiles with the status of <code>CANCELED</code>.</p>', 'SigningJob$isRevoked' => '<p>Indicates whether the signing job is revoked.</p>', 'SigningPlatform$revocationSupported' => '<p>Indicates whether revocation is supported for the platform.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'GetSigningProfileResponse$arn' => '<p>The Amazon Resource Name (ARN) for the signing profile.</p>', 'PutSigningProfileResponse$arn' => '<p>The Amazon Resource Name (ARN) of the signing profile created.</p>', 'SigningProfile$arn' => '<p>The Amazon Resource Name (ARN) for the signing profile.</p>', ], ], ],];
