<?php
// This file was auto-generated from sdk-root/src/data/organizations/2016-11-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Organizations is a web service that enables you to consolidate your multiple Amazon Web Services accounts into an <i>organization</i> and centrally manage your accounts and their resources.</p> <p>This guide provides descriptions of the Organizations operations. For more information about using this service, see the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">Organizations User Guide</a>.</p> <p> <b>Support and feedback for Organizations</b> </p> <p>We welcome your feedback. Send your comments to <a href="mailto:feedback-awsorganizations@amazon.com">feedback-awsorganizations@amazon.com</a> or post your feedback and questions in the <a href="http://forums.aws.amazon.com/forum.jspa?forumID=219">Organizations support forum</a>. For more information about the Amazon Web Services support forums, see <a href="http://forums.aws.amazon.com/help.jspa">Forums Help</a>.</p> <p> <b>Endpoint to call When using the CLI or the Amazon Web Services SDK</b> </p> <p>For the current release of Organizations, specify the <code>us-east-1</code> region for all Amazon Web Services API and CLI calls made from the commercial Amazon Web Services Regions outside of China. If calling from one of the Amazon Web Services Regions in China, then specify <code>cn-northwest-1</code>. You can do this in the CLI by using these parameters and commands:</p> <ul> <li> <p>Use the following parameter with each command to specify both the endpoint and its region:</p> <p> <code>--endpoint-url https://organizations.us-east-1.amazonaws.com</code> <i>(from commercial Amazon Web Services Regions outside of China)</i> </p> <p>or</p> <p> <code>--endpoint-url https://organizations.cn-northwest-1.amazonaws.com.cn</code> <i>(from Amazon Web Services Regions in China)</i> </p> </li> <li> <p>Use the default endpoint, but configure your default region with this command:</p> <p> <code>aws configure set default.region us-east-1</code> <i>(from commercial Amazon Web Services Regions outside of China)</i> </p> <p>or</p> <p> <code>aws configure set default.region cn-northwest-1</code> <i>(from Amazon Web Services Regions in China)</i> </p> </li> <li> <p>Use the following parameter with each command to specify the endpoint:</p> <p> <code>--region us-east-1</code> <i>(from commercial Amazon Web Services Regions outside of China)</i> </p> <p>or</p> <p> <code>--region cn-northwest-1</code> <i>(from Amazon Web Services Regions in China)</i> </p> </li> </ul> <p> <b>Recording API Requests</b> </p> <p>Organizations supports CloudTrail, a service that records Amazon Web Services API calls for your Amazon Web Services account and delivers log files to an Amazon S3 bucket. By using information collected by CloudTrail, you can determine which requests the Organizations service received, who made the request and when, and so on. For more about Organizations and its support for CloudTrail, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_incident-response.html#orgs_cloudtrail-integration">Logging Organizations Events with CloudTrail</a> in the <i>Organizations User Guide</i>. To learn more about CloudTrail, including how to turn it on and find your log files, see the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">CloudTrail User Guide</a>.</p>', 'operations' => [ 'AcceptHandshake' => '<p>Sends a response to the originator of a handshake agreeing to the action proposed by the handshake request.</p> <p>This operation can be called only by the following principals when they also have the relevant IAM permissions:</p> <ul> <li> <p> <b>Invitation to join</b> or <b>Approve all features request</b> handshakes: only a principal from the member account.</p> <p>The user who calls the API for an invitation to join must have the <code>organizations:AcceptHandshake</code> permission. If you enabled all features in the organization, the user must also have the <code>iam:CreateServiceLinkedRole</code> permission so that Organizations can create the required service-linked role named <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integration_services.html#orgs_integration_service-linked-roles">Organizations and Service-Linked Roles</a> in the <i>Organizations User Guide</i>.</p> </li> <li> <p> <b>Enable all features final confirmation</b> handshake: only a principal from the management account.</p> <p>For more information about invitations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_invites.html">Inviting an Amazon Web Services account to join your organization</a> in the <i>Organizations User Guide.</i> For more information about requests to enable all features in the organization, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling all features in your organization</a> in the <i>Organizations User Guide.</i> </p> </li> </ul> <p>After you accept a handshake, it continues to appear in the results of relevant APIs for only 30 days. After that, it\'s deleted.</p>', 'AttachPolicy' => '<p>Attaches a policy to a root, an organizational unit (OU), or an individual account. How the policy affects accounts depends on the type of policy. Refer to the <i>Organizations User Guide</i> for information about each policy type:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li> </ul> <p>This operation can be called only from the organization\'s management account.</p>', 'CancelHandshake' => '<p>Cancels a handshake. Canceling a handshake sets the handshake state to <code>CANCELED</code>.</p> <p>This operation can be called only from the account that originated the handshake. The recipient of the handshake can\'t cancel it, but can use <a>DeclineHandshake</a> instead. After a handshake is canceled, the recipient can no longer respond to that handshake.</p> <p>After you cancel a handshake, it continues to appear in the results of relevant APIs for only 30 days. After that, it\'s deleted.</p>', 'CloseAccount' => '<p>Closes an Amazon Web Services member account within an organization. You can\'t close the management account with this API. This is an asynchronous request that Amazon Web Services performs in the background. Because <code>CloseAccount</code> operates asynchronously, it can return a successful completion message even though account closure might still be in progress. You need to wait a few minutes before the account is fully closed. To check the status of the request, do one of the following:</p> <ul> <li> <p>Use the <code>AccountId</code> that you sent in the <code>CloseAccount</code> request to provide as a parameter to the <a>DescribeAccount</a> operation. </p> <p>While the close account request is in progress, Account status will indicate PENDING_CLOSURE. When the close account request completes, the status will change to SUSPENDED. </p> </li> <li> <p>Check the CloudTrail log for the <code>CloseAccountResult</code> event that gets published after the account closes successfully. For information on using CloudTrail with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html#orgs_cloudtrail-integration">Logging and monitoring in Organizations</a> in the <i>Organizations User Guide.</i> </p> </li> </ul> <note> <ul> <li> <p>You can only close 10% of active member accounts within a rolling 30 day period. This quota is not bound by a calendar month, but starts when you close an account. Within 30 days of that initial account closure, you can\'t exceed the 10% account closure limit.</p> </li> <li> <p>To reinstate a closed account, contact Amazon Web Services Support within the 90-day grace period while the account is in SUSPENDED status. </p> </li> <li> <p>If the Amazon Web Services account you attempt to close is linked to an Amazon Web Services GovCloud (US) account, the <code>CloseAccount</code> request will close both accounts. To learn important pre-closure details, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/Closing-govcloud-account.html"> Closing an Amazon Web Services GovCloud (US) account</a> in the <i> Amazon Web Services GovCloud User Guide</i>.</p> </li> </ul> </note> <p>For more information about closing accounts, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing an Amazon Web Services account</a> in the <i>Organizations User Guide.</i> </p>', 'CreateAccount' => '<p>Creates an Amazon Web Services account that is automatically a member of the organization whose credentials made the request. This is an asynchronous request that Amazon Web Services performs in the background. Because <code>CreateAccount</code> operates asynchronously, it can return a successful completion message even though account initialization might still be in progress. You might need to wait a few minutes before you can successfully access the account. To check the status of the request, do one of the following:</p> <ul> <li> <p>Use the <code>Id</code> member of the <code>CreateAccountStatus</code> response element from this operation to provide as a parameter to the <a>DescribeCreateAccountStatus</a> operation.</p> </li> <li> <p>Check the CloudTrail log for the <code>CreateAccountResult</code> event. For information on using CloudTrail with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_security_incident-response.html#orgs_cloudtrail-integration">Logging and monitoring in Organizations</a> in the <i>Organizations User Guide.</i> </p> </li> </ul> <p>The user who calls the API to create an account must have the <code>organizations:CreateAccount</code> permission. If you enabled all features in the organization, Organizations creates the required service-linked role named <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs">Organizations and Service-Linked Roles</a> in the <i>Organizations User Guide</i>.</p> <p>If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.</p> <p>Organizations preconfigures the new member account with a role (named <code>OrganizationAccountAccessRole</code> by default) that grants users in the management account administrator permissions in the new member account. Principals in the management account can assume the role. Organizations clones the company name and address information for the new account from the organization\'s management account.</p> <p>This operation can be called only from the organization\'s management account.</p> <p>For more information about creating accounts, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating an Amazon Web Services account in Your Organization</a> in the <i>Organizations User Guide.</i> </p> <important> <ul> <li> <p>When you create an account in an organization using the Organizations console, API, or CLI commands, the information required for the account to operate as a standalone account, such as a payment method and signing the end user license agreement (EULA) is <i>not</i> automatically collected. If you must remove an account from your organization later, you can do so only after you provide the missing information. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization as a member account</a> in the <i>Organizations User Guide</i>.</p> </li> <li> <p>If you get an exception that indicates that you exceeded your account limits for the organization, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </li> <li> <p>If you get an exception that indicates that the operation failed because your organization is still initializing, wait one hour and then try again. If the error persists, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </li> <li> <p>Using <code>CreateAccount</code> to create multiple temporary accounts isn\'t recommended. You can only close an account from the Billing and Cost Management console, and you must be signed in as the root user. For information on the requirements and process for closing an account, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing an Amazon Web Services account</a> in the <i>Organizations User Guide</i>.</p> </li> </ul> </important> <note> <p>When you create a member account with this operation, you can choose whether to create the account with the <b>IAM User and Role Access to Billing Information</b> switch enabled. If you enable it, IAM users and roles that have appropriate permissions can view billing information for the account. If you disable it, only the account root user can access billing information. For information about how to disable this switch for an account, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html">Granting Access to Your Billing Information and Tools</a>.</p> </note>', 'CreateGovCloudAccount' => '<p>This action is available if all of the following are true:</p> <ul> <li> <p>You\'re authorized to create accounts in the Amazon Web Services GovCloud (US) Region. For more information on the Amazon Web Services GovCloud (US) Region, see the <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/welcome.html"> <i>Amazon Web Services GovCloud User Guide</i>.</a> </p> </li> <li> <p>You already have an account in the Amazon Web Services GovCloud (US) Region that is paired with a management account of an organization in the commercial Region.</p> </li> <li> <p>You call this action from the management account of your organization in the commercial Region.</p> </li> <li> <p>You have the <code>organizations:CreateGovCloudAccount</code> permission. </p> </li> </ul> <p>Organizations automatically creates the required service-linked role named <code>AWSServiceRoleForOrganizations</code>. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs">Organizations and Service-Linked Roles</a> in the <i>Organizations User Guide.</i> </p> <p>Amazon Web Services automatically enables CloudTrail for Amazon Web Services GovCloud (US) accounts, but you should also do the following:</p> <ul> <li> <p>Verify that CloudTrail is enabled to store logs.</p> </li> <li> <p>Create an Amazon S3 bucket for CloudTrail log storage.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/verifying-cloudtrail.html">Verifying CloudTrail Is Enabled</a> in the <i>Amazon Web Services GovCloud User Guide</i>. </p> </li> </ul> <p>If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission. The tags are attached to the commercial account associated with the GovCloud account, rather than the GovCloud account itself. To add tags to the GovCloud account, call the <a>TagResource</a> operation in the GovCloud Region after the new GovCloud account exists.</p> <p>You call this action from the management account of your organization in the commercial Region to create a standalone Amazon Web Services account in the Amazon Web Services GovCloud (US) Region. After the account is created, the management account of an organization in the Amazon Web Services GovCloud (US) Region can invite it to that organization. For more information on inviting standalone accounts in the Amazon Web Services GovCloud (US) to join an organization, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> <p>Calling <code>CreateGovCloudAccount</code> is an asynchronous request that Amazon Web Services performs in the background. Because <code>CreateGovCloudAccount</code> operates asynchronously, it can return a successful completion message even though account initialization might still be in progress. You might need to wait a few minutes before you can successfully access the account. To check the status of the request, do one of the following:</p> <ul> <li> <p>Use the <code>OperationId</code> response element from this operation to provide as a parameter to the <a>DescribeCreateAccountStatus</a> operation.</p> </li> <li> <p>Check the CloudTrail log for the <code>CreateAccountResult</code> event. For information on using CloudTrail with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html">Monitoring the Activity in Your Organization</a> in the <i>Organizations User Guide.</i> </p> </li> </ul> <p/> <p>When you call the <code>CreateGovCloudAccount</code> action, you create two accounts: a standalone account in the Amazon Web Services GovCloud (US) Region and an associated account in the commercial Region for billing and support purposes. The account in the commercial Region is automatically a member of the organization whose credentials made the request. Both accounts are associated with the same email address.</p> <p>A role is created in the new account in the commercial Region that allows the management account in the organization in the commercial Region to assume it. An Amazon Web Services GovCloud (US) account is then created and associated with the commercial account that you just created. A role is also created in the new Amazon Web Services GovCloud (US) account that can be assumed by the Amazon Web Services GovCloud (US) account that is associated with the management account of the commercial organization. For more information and to view a diagram that explains how account access works, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> <p>For more information about creating accounts, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html">Creating an Amazon Web Services account in Your Organization</a> in the <i>Organizations User Guide.</i> </p> <important> <ul> <li> <p>When you create an account in an organization using the Organizations console, API, or CLI commands, the information required for the account to operate as a standalone account is <i>not</i> automatically collected. This includes a payment method and signing the end user license agreement (EULA). If you must remove an account from your organization later, you can do so only after you provide the missing information. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization as a member account</a> in the <i>Organizations User Guide.</i> </p> </li> <li> <p>If you get an exception that indicates that you exceeded your account limits for the organization, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </li> <li> <p>If you get an exception that indicates that the operation failed because your organization is still initializing, wait one hour and then try again. If the error persists, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </li> <li> <p>Using <code>CreateGovCloudAccount</code> to create multiple temporary accounts isn\'t recommended. You can only close an account from the Amazon Web Services Billing and Cost Management console, and you must be signed in as the root user. For information on the requirements and process for closing an account, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html">Closing an Amazon Web Services account</a> in the <i>Organizations User Guide</i>.</p> </li> </ul> </important> <note> <p>When you create a member account with this operation, you can choose whether to create the account with the <b>IAM User and Role Access to Billing Information</b> switch enabled. If you enable it, IAM users and roles that have appropriate permissions can view billing information for the account. If you disable it, only the account root user can access billing information. For information about how to disable this switch for an account, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html">Granting Access to Your Billing Information and Tools</a>.</p> </note>', 'CreateOrganization' => '<p>Creates an Amazon Web Services organization. The account whose user is calling the <code>CreateOrganization</code> operation automatically becomes the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">management account</a> of the new organization.</p> <p>This operation must be called using credentials from the account that is to become the new organization\'s management account. The principal must also have the relevant IAM permissions.</p> <p>By default (or if you set the <code>FeatureSet</code> parameter to <code>ALL</code>), the new organization is created with all features enabled and service control policies automatically enabled in the root. If you instead choose to create the organization supporting only the consolidated billing features by setting the <code>FeatureSet</code> parameter to <code>CONSOLIDATED_BILLING"</code>, no policy types are enabled by default, and you can\'t use organization policies</p>', 'CreateOrganizationalUnit' => '<p>Creates an organizational unit (OU) within a root or parent OU. An OU is a container for accounts that enables you to organize your accounts to apply policies according to your business requirements. The number of levels deep that you can nest OUs is dependent upon the policy types enabled for that root. For service control policies, the limit is five.</p> <p>For more information about OUs, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing Organizational Units</a> in the <i>Organizations User Guide.</i> </p> <p>If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.</p> <p>This operation can be called only from the organization\'s management account.</p>', 'CreatePolicy' => '<p>Creates a policy of a specified type that you can attach to a root, an organizational unit (OU), or an individual Amazon Web Services account.</p> <p>For more information about policies and their use, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">Managing Organization Policies</a>.</p> <p>If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.</p> <p>This operation can be called only from the organization\'s management account.</p>', 'DeclineHandshake' => '<p>Declines a handshake request. This sets the handshake state to <code>DECLINED</code> and effectively deactivates the request.</p> <p>This operation can be called only from the account that received the handshake. The originator of the handshake can use <a>CancelHandshake</a> instead. The originator can\'t reactivate a declined request, but can reinitiate the process with a new handshake request.</p> <p>After you decline a handshake, it continues to appear in the results of relevant APIs for only 30 days. After that, it\'s deleted.</p>', 'DeleteOrganization' => '<p>Deletes the organization. You can delete an organization only by using credentials from the management account. The organization must be empty of member accounts.</p>', 'DeleteOrganizationalUnit' => '<p>Deletes an organizational unit (OU) from a root or another OU. You must first remove all accounts and child OUs from the OU that you want to delete.</p> <p>This operation can be called only from the organization\'s management account.</p>', 'DeletePolicy' => '<p>Deletes the specified policy from your organization. Before you perform this operation, you must first detach the policy from all organizational units (OUs), roots, and accounts.</p> <p>This operation can be called only from the organization\'s management account.</p>', 'DeregisterDelegatedAdministrator' => '<p>Removes the specified member Amazon Web Services account as a delegated administrator for the specified Amazon Web Services service.</p> <important> <p>Deregistering a delegated administrator can have unintended impacts on the functionality of the enabled Amazon Web Services service. See the documentation for the enabled service before you deregister a delegated administrator so that you understand any potential impacts.</p> </important> <p>You can run this action only for Amazon Web Services services that support this feature. For a current list of services that support it, see the column <i>Supports Delegated Administrator</i> in the table at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">Amazon Web Services Services that you can use with Organizations</a> in the <i>Organizations User Guide.</i> </p> <p>This operation can be called only from the organization\'s management account.</p>', 'DescribeAccount' => '<p>Retrieves Organizations-related information about the specified account.</p> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'DescribeCreateAccountStatus' => '<p>Retrieves the current status of an asynchronous request to create an account.</p> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'DescribeEffectivePolicy' => '<p>Returns the contents of the effective policy for specified policy type and account. The effective policy is the aggregation of any policies of the specified type that the account inherits, plus any policy of that type that is directly attached to the account.</p> <p>This operation applies only to policy types <i>other</i> than service control policies (SCPs).</p> <p>For more information about policy inheritance, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies-inheritance.html">How Policy Inheritance Works</a> in the <i>Organizations User Guide</i>.</p> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'DescribeHandshake' => '<p>Retrieves information about a previously requested handshake. The handshake ID comes from the response to the original <a>InviteAccountToOrganization</a> operation that generated the handshake.</p> <p>You can access handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, or <code>CANCELED</code> for only 30 days after they change to that state. They\'re then deleted and no longer accessible.</p> <p>This operation can be called from any account in the organization.</p>', 'DescribeOrganization' => '<p>Retrieves information about the organization that the user\'s account belongs to.</p> <p>This operation can be called from any account in the organization.</p> <note> <p>Even if a policy type is shown as available in the organization, you can disable it separately at the root level with <a>DisablePolicyType</a>. Use <a>ListRoots</a> to see the status of policy types for a specified root.</p> </note>', 'DescribeOrganizationalUnit' => '<p>Retrieves information about an organizational unit (OU).</p> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'DescribePolicy' => '<p>Retrieves information about a policy.</p> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'DetachPolicy' => '<p>Detaches a policy from a target root, organizational unit (OU), or account.</p> <important> <p>If the policy being detached is a service control policy (SCP), the changes to permissions for Identity and Access Management (IAM) users and roles in affected accounts are immediate.</p> </important> <p>Every root, OU, and account must have at least one SCP attached. If you want to replace the default <code>FullAWSAccess</code> policy with an SCP that limits the permissions that can be delegated, you must attach the replacement SCP before you can remove the default SCP. This is the authorization strategy of an "<a href="https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies.html#orgs_policies_allowlist">allow list</a>". If you instead attach a second SCP and leave the <code>FullAWSAccess</code> SCP still attached, and specify <code>"Effect": "Deny"</code> in the second SCP to override the <code>"Effect": "Allow"</code> in the <code>FullAWSAccess</code> policy (or any other attached SCP), you\'re using the authorization strategy of a "<a href="https://docs.aws.amazon.com/organizations/latest/userguide/SCP_strategies.html#orgs_policies_denylist">deny list</a>".</p> <p>This operation can be called only from the organization\'s management account.</p>', 'DisableAWSServiceAccess' => '<p>Disables the integration of an Amazon Web Services service (the service that is specified by <code>ServicePrincipal</code>) with Organizations. When you disable integration, the specified service no longer can create a <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">service-linked role</a> in <i>new</i> accounts in your organization. This means the service can\'t perform operations on your behalf on any new accounts in your organization. The service can still perform operations in older accounts until the service completes its clean-up from Organizations.</p> <important> <p>We <b> <i>strongly recommend</i> </b> that you don\'t use this command to disable integration between Organizations and the specified Amazon Web Services service. Instead, use the console or commands that are provided by the specified service. This lets the trusted service perform any required initialization when enabling trusted access, such as creating any required resources and any required clean up of resources when disabling trusted access. </p> <p>For information about how to disable trusted service access to your organization using the trusted service, see the <b>Learn more</b> link under the <b>Supports Trusted Access</b> column at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">Amazon Web Services services that you can use with Organizations</a>. on this page.</p> <p>If you disable access by using this command, it causes the following actions to occur:</p> <ul> <li> <p>The service can no longer create a service-linked role in the accounts in your organization. This means that the service can\'t perform operations on your behalf on any new accounts in your organization. The service can still perform operations in older accounts until the service completes its clean-up from Organizations. </p> </li> <li> <p>The service can no longer perform tasks in the member accounts in the organization, unless those operations are explicitly permitted by the IAM policies that are attached to your roles. This includes any data aggregation from the member accounts to the management account, or to a delegated administrator account, where relevant.</p> </li> <li> <p>Some services detect this and clean up any remaining data or resources related to the integration, while other services stop accessing the organization but leave any historical data and configuration in place to support a possible re-enabling of the integration.</p> </li> </ul> <p>Using the other service\'s console or commands to disable the integration ensures that the other service is aware that it can clean up any resources that are required only for the integration. How the service cleans up its resources in the organization\'s accounts depends on that service. For more information, see the documentation for the other Amazon Web Services service. </p> </important> <p>After you perform the <code>DisableAWSServiceAccess</code> operation, the specified service can no longer perform operations in your organization\'s accounts </p> <p>For more information about integrating other services with Organizations, including the list of services that work with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Integrating Organizations with Other Amazon Web Services Services</a> in the <i>Organizations User Guide.</i> </p> <p>This operation can be called only from the organization\'s management account.</p>', 'DisablePolicyType' => '<p>Disables an organizational policy type in a root. A policy of a certain type can be attached to entities in a root only if that type is enabled in the root. After you perform this operation, you no longer can attach policies of the specified type to that root or to any organizational unit (OU) or account in that root. You can undo this by using the <a>EnablePolicyType</a> operation.</p> <p>This is an asynchronous request that Amazon Web Services performs in the background. If you disable a policy type for a root, it still appears enabled for the organization if <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all features</a> are enabled for the organization. Amazon Web Services recommends that you first use <a>ListRoots</a> to see the status of policy types for a specified root, and then use this operation.</p> <p>This operation can be called only from the organization\'s management account.</p> <p> To view the status of available policy types in the organization, use <a>DescribeOrganization</a>.</p>', 'EnableAWSServiceAccess' => '<p>Enables the integration of an Amazon Web Services service (the service that is specified by <code>ServicePrincipal</code>) with Organizations. When you enable integration, you allow the specified service to create a <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">service-linked role</a> in all the accounts in your organization. This allows the service to perform operations on your behalf in your organization and its accounts.</p> <important> <p>We recommend that you enable integration between Organizations and the specified Amazon Web Services service by using the console or commands that are provided by the specified service. Doing so ensures that the service is aware that it can create the resources that are required for the integration. How the service creates those resources in the organization\'s accounts depends on that service. For more information, see the documentation for the other Amazon Web Services service.</p> </important> <p>For more information about enabling services to integrate with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Integrating Organizations with Other Amazon Web Services Services</a> in the <i>Organizations User Guide.</i> </p> <p>This operation can be called only from the organization\'s management account and only if the organization has <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">enabled all features</a>.</p>', 'EnableAllFeatures' => '<p>Enables all features in an organization. This enables the use of organization policies that can restrict the services and actions that can be called in each account. Until you enable all features, you have access only to consolidated billing, and you can\'t use any of the advanced account administration features that Organizations supports. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide.</i> </p> <important> <p>This operation is required only for organizations that were created explicitly with only the consolidated billing features enabled. Calling this operation sends a handshake to every invited account in the organization. The feature set change can be finalized and the additional features enabled only after all administrators in the invited accounts approve the change by accepting the handshake.</p> </important> <p>After you enable all features, you can separately enable or disable individual policy types in a root using <a>EnablePolicyType</a> and <a>DisablePolicyType</a>. To see the status of policy types in a root, use <a>ListRoots</a>.</p> <p>After all invited member accounts accept the handshake, you finalize the feature set change by accepting the handshake that contains <code>"Action": "ENABLE_ALL_FEATURES"</code>. This completes the change.</p> <p>After you enable all features in your organization, the management account in the organization can apply policies on all member accounts. These policies can restrict what users and even administrators in those accounts can do. The management account can apply policies that prevent accounts from leaving the organization. Ensure that your account administrators are aware of this.</p> <p>This operation can be called only from the organization\'s management account.</p>', 'EnablePolicyType' => '<p>Enables a policy type in a root. After you enable a policy type in a root, you can attach policies of that type to the root, any organizational unit (OU), or account in that root. You can undo this by using the <a>DisablePolicyType</a> operation.</p> <p>This is an asynchronous request that Amazon Web Services performs in the background. Amazon Web Services recommends that you first use <a>ListRoots</a> to see the status of policy types for a specified root, and then use this operation.</p> <p>This operation can be called only from the organization\'s management account.</p> <p>You can enable a policy type in a root only if that policy type is available in the organization. To view the status of available policy types in the organization, use <a>DescribeOrganization</a>.</p>', 'InviteAccountToOrganization' => '<p>Sends an invitation to another account to join your organization as a member account. Organizations sends email on your behalf to the email address that is associated with the other account\'s owner. The invitation is implemented as a <a>Handshake</a> whose details are in the response.</p> <important> <ul> <li> <p>You can invite Amazon Web Services accounts only from the same seller as the management account. For example, if your organization\'s management account was created by Amazon Internet Services Pvt. Ltd (AISPL), an Amazon Web Services seller in India, you can invite only other AISPL accounts to your organization. You can\'t combine accounts from AISPL and Amazon Web Services or from any other Amazon Web Services seller. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/useconsolidatedbilliing-India.html">Consolidated Billing in India</a>.</p> </li> <li> <p>If you receive an exception that indicates that you exceeded your account limits for the organization or that the operation failed because your organization is still initializing, wait one hour and then try again. If the error persists after an hour, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </li> </ul> </important> <p>If the request includes tags, then the requester must have the <code>organizations:TagResource</code> permission.</p> <p>This operation can be called only from the organization\'s management account.</p>', 'LeaveOrganization' => '<p>Removes a member account from its parent organization. This version of the operation is performed by the account that wants to leave. To remove a member account as a user in the management account, use <a>RemoveAccountFromOrganization</a> instead.</p> <p>This operation can be called only from a member account in the organization.</p> <important> <ul> <li> <p>The management account in an organization with all features enabled can set service control policies (SCPs) that can restrict what administrators of member accounts can do. This includes preventing them from successfully calling <code>LeaveOrganization</code> and leaving the organization.</p> </li> <li> <p>You can leave an organization as a member account only if the account is configured with the information required to operate as a standalone account. When you create an account in an organization using the Organizations console, API, or CLI commands, the information required of standalone accounts is <i>not</i> automatically collected. For each account that you want to make standalone, you must perform the following steps. If any of the steps are already completed for this account, that step doesn\'t appear.</p> <ul> <li> <p>Choose a support plan</p> </li> <li> <p>Provide and verify the required contact information</p> </li> <li> <p>Provide a current payment method</p> </li> </ul> <p>Amazon Web Services uses the payment method to charge for any billable (not free tier) Amazon Web Services activity that occurs while the account isn\'t attached to an organization. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li> <li> <p>The account that you want to leave must not be a delegated administrator account for any Amazon Web Services service enabled for your organization. If the account is a delegated administrator, you must first change the delegated administrator account to another account that is remaining in the organization.</p> </li> <li> <p>You can leave an organization only after you enable IAM user access to billing in your account. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost Management User Guide.</i> </p> </li> <li> <p>After the account leaves the organization, all tags that were attached to the account object in the organization are deleted. Amazon Web Services accounts outside of an organization do not support tags.</p> </li> <li> <p>A newly created account has a waiting period before it can be removed from its organization. If you get an error that indicates that a wait period is required, then try again in a few days.</p> </li> </ul> </important>', 'ListAWSServiceAccessForOrganization' => '<p>Returns a list of the Amazon Web Services services that you enabled to integrate with your organization. After a service on this list creates the resources that it requires for the integration, it can perform operations on your organization and its accounts.</p> <p>For more information about integrating other services with Organizations, including the list of services that currently work with Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Integrating Organizations with Other Amazon Web Services Services</a> in the <i>Organizations User Guide.</i> </p> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListAccounts' => '<p>Lists all the accounts in the organization. To request only the accounts in a specified root or organizational unit (OU), use the <a>ListAccountsForParent</a> operation instead.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListAccountsForParent' => '<p>Lists the accounts in an organization that are contained by the specified target root or organizational unit (OU). If you specify the root, you get a list of all the accounts that aren\'t in any OU. If you specify an OU, you get a list of all the accounts in only that OU and not in any child OUs. To get a list of all accounts in the organization, use the <a>ListAccounts</a> operation.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListChildren' => '<p>Lists all of the organizational units (OUs) or accounts that are contained in the specified parent OU or root. This operation, along with <a>ListParents</a> enables you to traverse the tree structure that makes up this root.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListCreateAccountStatus' => '<p>Lists the account creation requests that match the specified status that is currently being tracked for the organization.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListDelegatedAdministrators' => '<p>Lists the Amazon Web Services accounts that are designated as delegated administrators in this organization.</p> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListDelegatedServicesForAccount' => '<p>List the Amazon Web Services services for which the specified account is a delegated administrator.</p> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListHandshakesForAccount' => '<p>Lists the current handshakes that are associated with the account of the requesting user.</p> <p>Handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, <code>CANCELED</code>, or <code>EXPIRED</code> appear in the results of this API for only 30 days after changing to that state. After that, they\'re deleted and no longer accessible.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called from any account in the organization.</p>', 'ListHandshakesForOrganization' => '<p>Lists the handshakes that are associated with the organization that the requesting user is part of. The <code>ListHandshakesForOrganization</code> operation returns a list of handshake structures. Each structure contains details and status about a handshake.</p> <p>Handshakes that are <code>ACCEPTED</code>, <code>DECLINED</code>, <code>CANCELED</code>, or <code>EXPIRED</code> appear in the results of this API for only 30 days after changing to that state. After that, they\'re deleted and no longer accessible.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListOrganizationalUnitsForParent' => '<p>Lists the organizational units (OUs) in a parent organizational unit or root.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListParents' => '<p>Lists the root or organizational units (OUs) that serve as the immediate parent of the specified child OU or account. This operation, along with <a>ListChildren</a> enables you to traverse the tree structure that makes up this root.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p> <note> <p>In the current release, a child can have only a single parent.</p> </note>', 'ListPolicies' => '<p>Retrieves the list of all policies in an organization of a specified type.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListPoliciesForTarget' => '<p>Lists the policies that are directly attached to the specified target root, organizational unit (OU), or account. You must specify the policy type that you want included in the returned list.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListRoots' => '<p>Lists the roots that are defined in the current organization.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p> <note> <p>Policy types can be enabled and disabled in roots. This is distinct from whether they\'re available in the organization. When you enable all features, you make policy types available for use in that organization. Individual policy types can then be enabled and disabled in a root. To see the availability of a policy type in an organization, use <a>DescribeOrganization</a>.</p> </note>', 'ListTagsForResource' => '<p>Lists tags that are attached to the specified resource.</p> <p>You can attach tags to the following resources in Organizations.</p> <ul> <li> <p>Amazon Web Services account</p> </li> <li> <p>Organization root</p> </li> <li> <p>Organizational unit (OU)</p> </li> <li> <p>Policy (any type)</p> </li> </ul> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'ListTargetsForPolicy' => '<p>Lists all the roots, organizational units (OUs), and accounts that the specified policy is attached to.</p> <note> <p>Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a <code>List*</code> operation. These operations can occasionally return an empty set of results even when there are more results available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no more results to display.</p> </note> <p>This operation can be called only from the organization\'s management account or by a member account that is a delegated administrator for an Amazon Web Services service.</p>', 'MoveAccount' => '<p>Moves an account from its current source parent root or organizational unit (OU) to the specified destination parent root or OU.</p> <p>This operation can be called only from the organization\'s management account.</p>', 'RegisterDelegatedAdministrator' => '<p>Enables the specified member account to administer the Organizations features of the specified Amazon Web Services service. It grants read-only access to Organizations service data. The account still requires IAM permissions to access and administer the Amazon Web Services service.</p> <p>You can run this action only for Amazon Web Services services that support this feature. For a current list of services that support it, see the column <i>Supports Delegated Administrator</i> in the table at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">Amazon Web Services Services that you can use with Organizations</a> in the <i>Organizations User Guide.</i> </p> <p>This operation can be called only from the organization\'s management account.</p>', 'RemoveAccountFromOrganization' => '<p>Removes the specified account from the organization.</p> <p>The removed account becomes a standalone account that isn\'t a member of any organization. It\'s no longer subject to any policies and is responsible for its own bill payments. The organization\'s management account is no longer charged for any expenses accrued by the member account after it\'s removed from the organization.</p> <p>This operation can be called only from the organization\'s management account. Member accounts can remove themselves with <a>LeaveOrganization</a> instead.</p> <important> <ul> <li> <p>You can remove an account from your organization only if the account is configured with the information required to operate as a standalone account. When you create an account in an organization using the Organizations console, API, or CLI commands, the information required of standalone accounts is <i>not</i> automatically collected. For an account that you want to make standalone, you must choose a support plan, provide and verify the required contact information, and provide a current payment method. Amazon Web Services uses the payment method to charge for any billable (not free tier) Amazon Web Services activity that occurs while the account isn\'t attached to an organization. To remove an account that doesn\'t yet have this information, you must sign in as the member account and follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info"> To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li> <li> <p>The account that you want to leave must not be a delegated administrator account for any Amazon Web Services service enabled for your organization. If the account is a delegated administrator, you must first change the delegated administrator account to another account that is remaining in the organization.</p> </li> <li> <p>After the account leaves the organization, all tags that were attached to the account object in the organization are deleted. Amazon Web Services accounts outside of an organization do not support tags.</p> </li> </ul> </important>', 'TagResource' => '<p>Adds one or more tags to the specified resource.</p> <p>Currently, you can attach tags to the following resources in Organizations.</p> <ul> <li> <p>Amazon Web Services account</p> </li> <li> <p>Organization root</p> </li> <li> <p>Organizational unit (OU)</p> </li> <li> <p>Policy (any type)</p> </li> </ul> <p>This operation can be called only from the organization\'s management account.</p>', 'UntagResource' => '<p>Removes any tags with the specified keys from the specified resource.</p> <p>You can attach tags to the following resources in Organizations.</p> <ul> <li> <p>Amazon Web Services account</p> </li> <li> <p>Organization root</p> </li> <li> <p>Organizational unit (OU)</p> </li> <li> <p>Policy (any type)</p> </li> </ul> <p>This operation can be called only from the organization\'s management account.</p>', 'UpdateOrganizationalUnit' => '<p>Renames the specified organizational unit (OU). The ID and ARN don\'t change. The child OUs and accounts remain in place, and any attached policies of the OU remain attached.</p> <p>This operation can be called only from the organization\'s management account.</p>', 'UpdatePolicy' => '<p>Updates an existing policy with a new name, description, or content. If you don\'t supply any parameter, that value remains unchanged. You can\'t change a policy\'s type.</p> <p>This operation can be called only from the organization\'s management account.</p>', ], 'shapes' => [ 'AWSOrganizationsNotInUseException' => [ 'base' => '<p>Your account isn\'t a member of an organization. To make this request, you must use the credentials of an account that belongs to an organization.</p>', 'refs' => [], ], 'AcceptHandshakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptHandshakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide.</i> </p>', 'refs' => [], ], 'AccessDeniedForDependencyException' => [ 'base' => '<p>The operation that you attempted requires you to have the <code>iam:CreateServiceLinkedRole</code> for <code>organizations.amazonaws.com</code> permission so that Organizations can create the required service-linked role. You don\'t have that permission.</p>', 'refs' => [], ], 'AccessDeniedForDependencyExceptionReason' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedForDependencyException$Reason' => NULL, ], ], 'Account' => [ 'base' => '<p>Contains information about an Amazon Web Services account that is a member of an organization.</p>', 'refs' => [ 'Accounts$member' => NULL, 'DescribeAccountResponse$Account' => '<p>A structure that contains information about the requested account.</p>', ], ], 'AccountAlreadyClosedException' => [ 'base' => '<p>You attempted to close an account that is already closed.</p>', 'refs' => [], ], 'AccountAlreadyRegisteredException' => [ 'base' => '<p>The specified account is already a delegated administrator for this Amazon Web Services service.</p>', 'refs' => [], ], 'AccountArn' => [ 'base' => NULL, 'refs' => [ 'Account$Arn' => '<p>The Amazon Resource Name (ARN) of the account.</p> <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>', 'DelegatedAdministrator$Arn' => '<p>The Amazon Resource Name (ARN) of the delegated administrator\'s account.</p>', 'Organization$MasterAccountArn' => '<p>The Amazon Resource Name (ARN) of the account that is designated as the management account for the organization.</p> <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'Account$Id' => '<p>The unique identifier (ID) of the account.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', 'CloseAccountRequest$AccountId' => '<p>Retrieves the Amazon Web Services account Id for the current <code>CloseAccount</code> API request. </p>', 'CreateAccountStatus$AccountId' => '<p>If the account was created successfully, the unique identifier (ID) of the new account.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', 'CreateAccountStatus$GovCloudAccountId' => '<p>If the account was created successfully, the unique identifier (ID) of the new account in the Amazon Web Services GovCloud (US) Region.</p>', 'DelegatedAdministrator$Id' => '<p>The unique identifier (ID) of the delegated administrator\'s account.</p>', 'DeregisterDelegatedAdministratorRequest$AccountId' => '<p>The account ID number of the member account in the organization that you want to deregister as a delegated administrator.</p>', 'DescribeAccountRequest$AccountId' => '<p>The unique identifier (ID) of the Amazon Web Services account that you want information about. You can get the ID from the <a>ListAccounts</a> or <a>ListAccountsForParent</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', 'ListDelegatedServicesForAccountRequest$AccountId' => '<p>The account ID number of a delegated administrator account in the organization.</p>', 'MoveAccountRequest$AccountId' => '<p>The unique identifier (ID) of the account that you want to move.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', 'Organization$MasterAccountId' => '<p>The unique identifier (ID) of the management account of an organization.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', 'RegisterDelegatedAdministratorRequest$AccountId' => '<p>The account ID number of the member account in the organization to register as a delegated administrator.</p>', 'RemoveAccountFromOrganizationRequest$AccountId' => '<p>The unique identifier (ID) of the member account that you want to remove from the organization.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an account ID string requires exactly 12 digits.</p>', ], ], 'AccountJoinedMethod' => [ 'base' => NULL, 'refs' => [ 'Account$JoinedMethod' => '<p>The method by which the account joined the organization.</p>', 'DelegatedAdministrator$JoinedMethod' => '<p>The method by which the delegated administrator\'s account joined the organization.</p>', ], ], 'AccountName' => [ 'base' => NULL, 'refs' => [ 'Account$Name' => '<p>The friendly name of the account.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', 'DelegatedAdministrator$Name' => '<p>The friendly name of the delegated administrator\'s account.</p>', ], ], 'AccountNotFoundException' => [ 'base' => '<p> We can\'t find an Amazon Web Services account with the <code>AccountId</code> that you specified, or the account whose credentials you used to make this request isn\'t a member of an organization.</p>', 'refs' => [], ], 'AccountNotRegisteredException' => [ 'base' => '<p>The specified account is not a delegated administrator for this Amazon Web Services service. </p>', 'refs' => [], ], 'AccountOwnerNotVerifiedException' => [ 'base' => '<p>You can\'t invite an existing account to your organization until you verify that you own the email address associated with the management account. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_create.html#about-email-verification">Email Address Verification</a> in the <i>Organizations User Guide.</i> </p>', 'refs' => [], ], 'AccountStatus' => [ 'base' => NULL, 'refs' => [ 'Account$Status' => '<p>The status of the account in the organization.</p>', 'DelegatedAdministrator$Status' => '<p>The status of the delegated administrator\'s account in the organization.</p>', ], ], 'Accounts' => [ 'base' => NULL, 'refs' => [ 'ListAccountsForParentResponse$Accounts' => '<p>A list of the accounts in the specified root or OU.</p>', 'ListAccountsResponse$Accounts' => '<p>A list of objects in the organization.</p>', ], ], 'ActionType' => [ 'base' => NULL, 'refs' => [ 'Handshake$Action' => '<p>The type of handshake, indicating what action occurs when the recipient accepts the handshake. The following handshake types are supported:</p> <ul> <li> <p> <b>INVITE</b>: This type of handshake represents a request to join an organization. It is always sent from the management account to only non-member accounts.</p> </li> <li> <p> <b>ENABLE_ALL_FEATURES</b>: This type of handshake represents a request to enable all features in an organization. It is always sent from the management account to only <i>invited</i> member accounts. Created accounts do not receive this because those accounts were created by the organization\'s management account and approval is inferred.</p> </li> <li> <p> <b>APPROVE_ALL_FEATURES</b>: This type of handshake is sent from the Organizations service when all member accounts have approved the <code>ENABLE_ALL_FEATURES</code> invitation. It is sent only to the management account and signals the master that it can finalize the process to enable all features.</p> </li> </ul>', 'HandshakeFilter$ActionType' => '<p>Specifies the type of handshake action.</p> <p>If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.</p>', ], ], 'AlreadyInOrganizationException' => [ 'base' => '<p>This account is already a member of an organization. An account can belong to only one organization at a time.</p>', 'refs' => [], ], 'AttachPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AwsManagedPolicy' => [ 'base' => NULL, 'refs' => [ 'PolicySummary$AwsManaged' => '<p>A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy. If true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.</p>', ], ], 'CancelHandshakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelHandshakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'Child' => [ 'base' => '<p>Contains a list of child entities, either OUs or accounts.</p>', 'refs' => [ 'Children$member' => NULL, ], ], 'ChildId' => [ 'base' => NULL, 'refs' => [ 'Child$Id' => '<p>The unique identifier (ID) of this child entity.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p> <ul> <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', 'ListParentsRequest$ChildId' => '<p>The unique identifier (ID) of the OU or account whose parent containers you want to list. Don\'t specify a root.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a child ID string requires one of the following:</p> <ul> <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', ], ], 'ChildNotFoundException' => [ 'base' => '<p>We can\'t find an organizational unit (OU) or Amazon Web Services account with the <code>ChildId</code> that you specified.</p>', 'refs' => [], ], 'ChildType' => [ 'base' => NULL, 'refs' => [ 'Child$Type' => '<p>The type of this child entity.</p>', 'ListChildrenRequest$ChildType' => '<p>Filters the output to include only the specified child type.</p>', ], ], 'Children' => [ 'base' => NULL, 'refs' => [ 'ListChildrenResponse$Children' => '<p>The list of children of the specified parent container.</p>', ], ], 'CloseAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConcurrentModificationException' => [ 'base' => '<p>The target of the operation is currently being modified by a different request. Try again later.</p>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>The request failed because it conflicts with the current state of the specified resource.</p>', 'refs' => [], ], 'ConstraintViolationException' => [ 'base' => '<p>Performing this operation violates a minimum or maximum value limit. For example, attempting to remove the last service control policy (SCP) from an OU or root, inviting or creating too many accounts to the organization, or attaching too many policies to an account, OU, or root. This exception includes a reason that contains additional information about the violated limit:</p> <note> <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p> </note> <ul> <li> <p>ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management account from the organization. You can\'t remove the management account. Instead, after you remove all member accounts, delete the organization itself.</p> </li> <li> <p>ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an account from the organization that doesn\'t yet have enough information to exist as a standalone account. This account requires you to first complete phone verification. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master">Removing a member account from your organization</a> in the <i>Organizations User Guide.</i> </p> </li> <li> <p>ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can create in one day.</p> </li> <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. If you need more accounts, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a> to request an increase in your limit. </p> <p>Or the number of invitations that you tried to send would cause you to exceed the limit of accounts in your organization. Send fewer invitations or contact Amazon Web Services Support to request an increase in the number of accounts.</p> <note> <p>Deleted and closed accounts still count toward your limit.</p> </note> <important> <p>If you get this exception when running a command immediately after creating the organization, wait one hour and try again. After an hour, if the command continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </important> </li> <li> <p>CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to register the management account of the organization as a delegated administrator for an Amazon Web Services service integrated with Organizations. You can designate only a member account as a delegated administrator.</p> </li> <li> <p>CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management account. To close the management account for the organization, you must first either remove or close all member accounts in the organization. Follow standard account closure process using root credentials.​ </p> </li> <li> <p>CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an account that is registered as a delegated administrator for a service integrated with your organization. To complete this operation, you must first deregister this account as a delegated administrator. </p> </li> <li> <p>CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the past 30 days. </p> </li> <li> <p>CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number of accounts that you can close at a time. ​ </p> </li> <li> <p>CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an organization in the specified region, you must enable all features mode.</p> </li> <li> <p>DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register an Amazon Web Services account as a delegated administrator for an Amazon Web Services service that already has a delegated administrator. To complete this operation, you must first deregister any existing delegated administrators for this service.</p> </li> <li> <p>EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid for a limited period of time. You must resubmit the request and generate a new verfication code.</p> </li> <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li> <li> <p>INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no supported payment method is associated with the account. Amazon Web Services does not support cards issued by financial institutions in Russia or Belarus. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your Amazon Web Services payments</a>.</p> </li> <li> <p>MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in this organization, you first must migrate the organization\'s management account to the marketplace that corresponds to the management account\'s address. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be associated with the same marketplace.</p> </li> <li> <p>MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web Services /&gt; Regions in China. To create an organization, the master must have a valid business license. For more information, contact customer support.</p> </li> <li> <p>MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must first provide a valid contact address and phone number for the management account. Then try the operation again.</p> </li> <li> <p>MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the management account must have an associated account in the Amazon Web Services GovCloud (US-West) Region. For more information, see <a href="https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html">Organizations</a> in the <i>Amazon Web Services GovCloud User Guide.</i> </p> </li> <li> <p>MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with this management account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li> <li> <p>MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to register more delegated administrators than allowed for the service principal. </p> </li> <li> <p>MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the number of policies of a certain type that can be attached to an entity at one time.</p> </li> <li> <p>MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on this resource. </p> </li> <li> <p>MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with this member account, you first must associate a valid payment instrument, such as a credit card, with the account. Follow the steps at <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info">To leave an organization when all required account information has not yet been provided</a> in the <i>Organizations User Guide.</i> </p> </li> <li> <p>MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy from an entity that would cause the entity to have fewer than the minimum number of policies of a certain type required.</p> </li> <li> <p>ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an operation that requires the organization to be configured to support all features. An organization that supports only consolidated billing features can\'t perform this operation.</p> </li> <li> <p>OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too many levels deep.</p> </li> <li> <p>OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that you can have in an organization.</p> </li> <li> <p>POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is larger than the maximum size.</p> </li> <li> <p>POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of policies that you can have in an organization.</p> </li> <li> <p>SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated administrator before you enabled service access. Call the <code>EnableAWSServiceAccess</code> API first.</p> </li> <li> <p>TAG_POLICY_VIOLATION: You attempted to create or update a resource with tags that are not compliant with the tag policy requirements for this account.</p> </li> <li> <p>WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there is a waiting period before you can remove it from the organization. If you get an error that indicates that a wait period is required, try again in a few days.</p> </li> </ul>', 'refs' => [], ], 'ConstraintViolationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ConstraintViolationException$Reason' => NULL, ], ], 'CreateAccountFailureReason' => [ 'base' => NULL, 'refs' => [ 'CreateAccountStatus$FailureReason' => '<p>If the request failed, a description of the reason for the failure.</p> <ul> <li> <p>ACCOUNT_LIMIT_EXCEEDED: The account couldn\'t be created because you reached the limit on the number of accounts in your organization.</p> </li> <li> <p>CONCURRENT_ACCOUNT_MODIFICATION: You already submitted a request with the same information.</p> </li> <li> <p>EMAIL_ALREADY_EXISTS: The account could not be created because another Amazon Web Services account with that email address already exists.</p> </li> <li> <p>FAILED_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization failed to receive business license validation.</p> </li> <li> <p>GOVCLOUD_ACCOUNT_ALREADY_EXISTS: The account in the Amazon Web Services GovCloud (US) Region could not be created because this Region already includes an account with that email address.</p> </li> <li> <p>IDENTITY_INVALID_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization can\'t complete business license validation because it doesn\'t have valid identity data.</p> </li> <li> <p>INVALID_ADDRESS: The account could not be created because the address you provided is not valid.</p> </li> <li> <p>INVALID_EMAIL: The account could not be created because the email address you provided is not valid.</p> </li> <li> <p>INVALID_PAYMENT_INSTRUMENT: The Amazon Web Services account that owns your organization does not have a supported payment method associated with the account. Amazon Web Services does not support cards issued by financial institutions in Russia or Belarus. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html">Managing your Amazon Web Services payments</a>.</p> </li> <li> <p>INTERNAL_FAILURE: The account could not be created because of an internal failure. Try again later. If the problem persists, contact Amazon Web Services Customer Support.</p> </li> <li> <p>MISSING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has not received Business Validation.</p> </li> <li> <p> MISSING_PAYMENT_INSTRUMENT: You must configure the management account with a valid payment method, such as a credit card.</p> </li> <li> <p>PENDING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization is still in the process of completing business license validation.</p> </li> <li> <p>UNKNOWN_BUSINESS_VALIDATION: The Amazon Web Services account that owns your organization has an unknown issue with business license validation.</p> </li> </ul>', ], ], 'CreateAccountName' => [ 'base' => NULL, 'refs' => [ 'CreateAccountRequest$AccountName' => '<p>The friendly name of the member account.</p>', 'CreateAccountStatus$AccountName' => '<p>The account name given to the account when it was created.</p>', 'CreateGovCloudAccountRequest$AccountName' => '<p>The friendly name of the member account. </p> <p>The account name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.) You can\'t separate characters with a dash (–).</p>', ], ], 'CreateAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountRequestId' => [ 'base' => NULL, 'refs' => [ 'CreateAccountStatus$Id' => '<p>The unique identifier (ID) that references this request. You get this value from the response of the initial <a>CreateAccount</a> request to create the account.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>', 'DescribeCreateAccountStatusRequest$CreateAccountRequestId' => '<p>Specifies the <code>Id</code> value that uniquely identifies the <code>CreateAccount</code> request. You can get the value from the <code>CreateAccountStatus.Id</code> response in an earlier <a>CreateAccount</a> request, or from the <a>ListCreateAccountStatus</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a create account request ID string requires "car-" followed by from 8 to 32 lowercase letters or digits.</p>', ], ], 'CreateAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountState' => [ 'base' => NULL, 'refs' => [ 'CreateAccountStates$member' => NULL, 'CreateAccountStatus$State' => '<p>The status of the asynchronous request to create an Amazon Web Services account.</p>', ], ], 'CreateAccountStates' => [ 'base' => NULL, 'refs' => [ 'ListCreateAccountStatusRequest$States' => '<p>A list of one or more states that you want included in the response. If this parameter isn\'t present, all requests are included in the response.</p>', ], ], 'CreateAccountStatus' => [ 'base' => '<p>Contains the status about a <a>CreateAccount</a> or <a>CreateGovCloudAccount</a> request to create an Amazon Web Services account or an Amazon Web Services GovCloud (US) account in an organization.</p>', 'refs' => [ 'CreateAccountResponse$CreateAccountStatus' => '<p>A structure that contains details about the request to create an account. This response structure might not be fully populated when you first receive it because account creation is an asynchronous process. You can pass the returned <code>CreateAccountStatus</code> ID as a parameter to <a>DescribeCreateAccountStatus</a> to get status about the progress of the request at later times. You can also check the CloudTrail log for the <code>CreateAccountResult</code> event. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html">Monitoring the Activity in Your Organization</a> in the <i>Organizations User Guide</i>.</p>', 'CreateAccountStatuses$member' => NULL, 'CreateGovCloudAccountResponse$CreateAccountStatus' => NULL, 'DescribeCreateAccountStatusResponse$CreateAccountStatus' => '<p>A structure that contains the current status of an account creation request.</p>', ], ], 'CreateAccountStatusNotFoundException' => [ 'base' => '<p>We can\'t find an create account request with the <code>CreateAccountRequestId</code> that you specified.</p>', 'refs' => [], ], 'CreateAccountStatuses' => [ 'base' => NULL, 'refs' => [ 'ListCreateAccountStatusResponse$CreateAccountStatuses' => '<p>A list of objects with details about the requests. Certain elements, such as the accountId number, are present in the output only after the account has been successfully created.</p>', ], ], 'CreateGovCloudAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGovCloudAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrganizationalUnitRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrganizationalUnitResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeclineHandshakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeclineHandshakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DelegatedAdministrator' => [ 'base' => '<p>Contains information about the delegated administrator.</p>', 'refs' => [ 'DelegatedAdministrators$member' => NULL, ], ], 'DelegatedAdministrators' => [ 'base' => NULL, 'refs' => [ 'ListDelegatedAdministratorsResponse$DelegatedAdministrators' => '<p>The list of delegated administrators in your organization.</p>', ], ], 'DelegatedService' => [ 'base' => '<p>Contains information about the Amazon Web Services service for which the account is a delegated administrator.</p>', 'refs' => [ 'DelegatedServices$member' => NULL, ], ], 'DelegatedServices' => [ 'base' => NULL, 'refs' => [ 'ListDelegatedServicesForAccountResponse$DelegatedServices' => '<p>The services for which the account is a delegated administrator.</p>', ], ], 'DeleteOrganizationalUnitRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterDelegatedAdministratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCreateAccountStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCreateAccountStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectivePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectivePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHandshakeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHandshakeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationalUnitRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationalUnitResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DestinationParentNotFoundException' => [ 'base' => '<p>We can\'t find the destination container (a root or OU) with the <code>ParentId</code> that you specified.</p>', 'refs' => [], ], 'DetachPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableAWSServiceAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisablePolicyTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisablePolicyTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DuplicateAccountException' => [ 'base' => '<p>That account is already present in the specified destination.</p>', 'refs' => [], ], 'DuplicateHandshakeException' => [ 'base' => '<p>A handshake with the same action and target already exists. For example, if you invited an account to join your organization, the invited account might already have a pending invitation from this organization. If you intend to resend an invitation to an account, ensure that existing handshakes that might be considered duplicates are canceled or declined.</p>', 'refs' => [], ], 'DuplicateOrganizationalUnitException' => [ 'base' => '<p>An OU with the same name already exists.</p>', 'refs' => [], ], 'DuplicatePolicyAttachmentException' => [ 'base' => '<p>The selected policy is already attached to the specified target.</p>', 'refs' => [], ], 'DuplicatePolicyException' => [ 'base' => '<p>A policy with the same name already exists.</p>', 'refs' => [], ], 'EffectivePolicy' => [ 'base' => '<p>Contains rules to be applied to the affected accounts. The effective policy is the aggregation of any policies the account inherits, plus any policy directly attached to the account.</p>', 'refs' => [ 'DescribeEffectivePolicyResponse$EffectivePolicy' => '<p>The contents of the effective policy.</p>', ], ], 'EffectivePolicyNotFoundException' => [ 'base' => '<p>If you ran this action on the management account, this policy type is not enabled. If you ran the action on a member account, the account doesn\'t have an effective policy of this type. Contact the administrator of your organization about attaching a policy of this type to the account. </p>', 'refs' => [], ], 'EffectivePolicyType' => [ 'base' => NULL, 'refs' => [ 'DescribeEffectivePolicyRequest$PolicyType' => '<p>The type of policy that you want information about. You can specify one of the following values:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li> </ul>', 'EffectivePolicy$PolicyType' => '<p>The policy type.</p>', ], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'Account$Email' => '<p>The email address associated with the Amazon Web Services account.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for this parameter is a string of characters that represents a standard internet email address.</p>', 'CreateAccountRequest$Email' => '<p>The email address of the owner to assign to the new member account. This email address must not already be associated with another Amazon Web Services account. You must use a valid email address to complete account creation.</p> <p>The rules for a valid email address:</p> <ul> <li> <p>The address must be a minimum of 6 and a maximum of 64 characters long.</p> </li> <li> <p>All characters must be 7-bit ASCII characters.</p> </li> <li> <p>There must be one and only one @ symbol, which separates the local name from the domain name.</p> </li> <li> <p>The local name can\'t contain any of the following characters:</p> <p>whitespace, " \' ( ) &lt; &gt; [ ] : ; , \\ | % &amp;</p> </li> <li> <p>The local name can\'t begin with a dot (.)</p> </li> <li> <p>The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)</p> </li> <li> <p>The domain name can\'t begin or end with a hyphen (-) or dot (.)</p> </li> <li> <p>The domain name must contain at least one dot</p> </li> </ul> <p>You can\'t access the root user of the account or remove an account that was created with an invalid email address.</p>', 'CreateGovCloudAccountRequest$Email' => '<p>Specifies the email address of the owner to assign to the new member account in the commercial Region. This email address must not already be associated with another Amazon Web Services account. You must use a valid email address to complete account creation.</p> <p>The rules for a valid email address:</p> <ul> <li> <p>The address must be a minimum of 6 and a maximum of 64 characters long.</p> </li> <li> <p>All characters must be 7-bit ASCII characters.</p> </li> <li> <p>There must be one and only one @ symbol, which separates the local name from the domain name.</p> </li> <li> <p>The local name can\'t contain any of the following characters:</p> <p>whitespace, " \' ( ) &lt; &gt; [ ] : ; , \\ | % &amp;</p> </li> <li> <p>The local name can\'t begin with a dot (.)</p> </li> <li> <p>The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)</p> </li> <li> <p>The domain name can\'t begin or end with a hyphen (-) or dot (.)</p> </li> <li> <p>The domain name must contain at least one dot</p> </li> </ul> <p>You can\'t access the root user of the account or remove an account that was created with an invalid email address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email address for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from the Amazon Web Services GovCloud (US) Region.</p>', 'DelegatedAdministrator$Email' => '<p>The email address that is associated with the delegated administrator\'s Amazon Web Services account.</p>', 'Organization$MasterAccountEmail' => '<p>The email address that is associated with the Amazon Web Services account that is designated as the management account for the organization.</p>', ], ], 'EnableAWSServiceAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableAllFeaturesRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableAllFeaturesResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnablePolicyTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnablePolicyTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnabledServicePrincipal' => [ 'base' => '<p>A structure that contains details of a service principal that represents an Amazon Web Services service that is enabled to integrate with Organizations.</p>', 'refs' => [ 'EnabledServicePrincipals$member' => NULL, ], ], 'EnabledServicePrincipals' => [ 'base' => NULL, 'refs' => [ 'ListAWSServiceAccessForOrganizationResponse$EnabledServicePrincipals' => '<p>A list of the service principals for the services that are enabled to integrate with your organization. Each principal is a structure that includes the name and the date that it was enabled for integration with Organizations.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AWSOrganizationsNotInUseException$Message' => NULL, 'AccessDeniedException$Message' => NULL, 'AccessDeniedForDependencyException$Message' => NULL, 'AccountAlreadyClosedException$Message' => NULL, 'AccountAlreadyRegisteredException$Message' => NULL, 'AccountNotFoundException$Message' => NULL, 'AccountNotRegisteredException$Message' => NULL, 'AccountOwnerNotVerifiedException$Message' => NULL, 'AlreadyInOrganizationException$Message' => NULL, 'ChildNotFoundException$Message' => NULL, 'ConcurrentModificationException$Message' => NULL, 'ConflictException$Message' => NULL, 'ConstraintViolationException$Message' => NULL, 'CreateAccountStatusNotFoundException$Message' => NULL, 'DestinationParentNotFoundException$Message' => NULL, 'DuplicateAccountException$Message' => NULL, 'DuplicateHandshakeException$Message' => NULL, 'DuplicateOrganizationalUnitException$Message' => NULL, 'DuplicatePolicyAttachmentException$Message' => NULL, 'DuplicatePolicyException$Message' => NULL, 'EffectivePolicyNotFoundException$Message' => NULL, 'FinalizingOrganizationException$Message' => NULL, 'HandshakeAlreadyInStateException$Message' => NULL, 'HandshakeConstraintViolationException$Message' => NULL, 'HandshakeNotFoundException$Message' => NULL, 'InvalidHandshakeTransitionException$Message' => NULL, 'InvalidInputException$Message' => NULL, 'MalformedPolicyDocumentException$Message' => NULL, 'MasterCannotLeaveOrganizationException$Message' => NULL, 'OrganizationNotEmptyException$Message' => NULL, 'OrganizationalUnitNotEmptyException$Message' => NULL, 'OrganizationalUnitNotFoundException$Message' => NULL, 'ParentNotFoundException$Message' => NULL, 'PolicyChangesInProgressException$Message' => NULL, 'PolicyInUseException$Message' => NULL, 'PolicyNotAttachedException$Message' => NULL, 'PolicyNotFoundException$Message' => NULL, 'PolicyTypeAlreadyEnabledException$Message' => NULL, 'PolicyTypeNotAvailableForOrganizationException$Message' => NULL, 'PolicyTypeNotEnabledException$Message' => NULL, 'RootNotFoundException$Message' => NULL, 'ServiceException$Message' => NULL, 'SourceParentNotFoundException$Message' => NULL, 'TargetNotFoundException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'UnsupportedAPIEndpointException$Message' => NULL, ], ], 'ExceptionType' => [ 'base' => NULL, 'refs' => [ 'TooManyRequestsException$Type' => NULL, ], ], 'FinalizingOrganizationException' => [ 'base' => '<p>Organizations couldn\'t perform the operation because your organization hasn\'t finished initializing. This can take up to an hour. Try again later. If after one hour you continue to receive this error, contact <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p>', 'refs' => [], ], 'GenericArn' => [ 'base' => NULL, 'refs' => [ 'PolicyTargetSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the policy target.</p> <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>', ], ], 'Handshake' => [ 'base' => '<p>Contains information that must be exchanged to securely establish a relationship between two accounts (an <i>originator</i> and a <i>recipient</i>). For example, when a management account (the originator) invites another account (the recipient) to join its organization, the two accounts exchange information as a series of handshake requests and responses.</p> <p> <b>Note:</b> Handshakes that are <code>CANCELED</code>, <code>ACCEPTED</code>, <code>DECLINED</code>, or <code>EXPIRED</code> show up in lists for only 30 days after entering that state After that they are deleted.</p>', 'refs' => [ 'AcceptHandshakeResponse$Handshake' => '<p>A structure that contains details about the accepted handshake.</p>', 'CancelHandshakeResponse$Handshake' => '<p>A structure that contains details about the handshake that you canceled.</p>', 'DeclineHandshakeResponse$Handshake' => '<p>A structure that contains details about the declined handshake. The state is updated to show the value <code>DECLINED</code>.</p>', 'DescribeHandshakeResponse$Handshake' => '<p>A structure that contains information about the specified handshake.</p>', 'EnableAllFeaturesResponse$Handshake' => '<p>A structure that contains details about the handshake created to support this request to enable all features in the organization.</p>', 'Handshakes$member' => NULL, 'InviteAccountToOrganizationResponse$Handshake' => '<p>A structure that contains details about the handshake that is created to support this invitation request.</p>', ], ], 'HandshakeAlreadyInStateException' => [ 'base' => '<p>The specified handshake is already in the requested state. For example, you can\'t accept a handshake that was already accepted.</p>', 'refs' => [], ], 'HandshakeArn' => [ 'base' => NULL, 'refs' => [ 'Handshake$Arn' => '<p>The Amazon Resource Name (ARN) of a handshake.</p> <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>', ], ], 'HandshakeConstraintViolationException' => [ 'base' => '<p>The requested operation would violate the constraint identified in the reason code.</p> <note> <p>Some of the reasons in the following list might not be applicable to this specific API or operation:</p> </note> <ul> <li> <p>ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. Note that deleted and closed accounts still count toward your limit.</p> <important> <p>If you get this exception immediately after creating the organization, wait one hour and try again. If after an hour it continues to fail with this error, contact <a href="https://docs.aws.amazon.com/support/home#/">Amazon Web Services Support</a>.</p> </important> </li> <li> <p>ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the invited account is already a member of an organization.</p> </li> <li> <p>HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.</p> </li> <li> <p>INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can\'t issue new invitations to join an organization while it\'s in the process of enabling all features. You can resume inviting accounts after you finalize the process when all accounts have agreed to the change.</p> </li> <li> <p>ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid because the organization has already enabled all features.</p> </li> <li> <p>ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION: The handshake request is invalid because the organization has already started the process to enable all features.</p> </li> <li> <p>ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because the account is from a different marketplace than the accounts in the organization. For example, accounts with India addresses must be associated with the AISPL marketplace. All accounts in an organization must be from the same marketplace.</p> </li> <li> <p>ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change the membership of an account too quickly after its previous change.</p> </li> <li> <p>PAYMENT_INSTRUMENT_REQUIRED: You can\'t complete the operation with an account that doesn\'t have a payment instrument, such as a credit card, associated with it.</p> </li> </ul>', 'refs' => [], ], 'HandshakeConstraintViolationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'HandshakeConstraintViolationException$Reason' => NULL, ], ], 'HandshakeFilter' => [ 'base' => '<p>Specifies the criteria that are used to select the handshakes for the operation.</p>', 'refs' => [ 'ListHandshakesForAccountRequest$Filter' => '<p>Filters the handshakes that you want included in the response. The default is all types. Use the <code>ActionType</code> element to limit the output to only a specified type, such as <code>INVITE</code>, <code>ENABLE_ALL_FEATURES</code>, or <code>APPROVE_ALL_FEATURES</code>. Alternatively, for the <code>ENABLE_ALL_FEATURES</code> handshake that generates a separate child handshake for each member account, you can specify <code>ParentHandshakeId</code> to see only the handshakes that were generated by that parent request.</p>', 'ListHandshakesForOrganizationRequest$Filter' => '<p>A filter of the handshakes that you want included in the response. The default is all types. Use the <code>ActionType</code> element to limit the output to only a specified type, such as <code>INVITE</code>, <code>ENABLE-ALL-FEATURES</code>, or <code>APPROVE-ALL-FEATURES</code>. Alternatively, for the <code>ENABLE-ALL-FEATURES</code> handshake that generates a separate child handshake for each member account, you can specify the <code>ParentHandshakeId</code> to see only the handshakes that were generated by that parent request.</p>', ], ], 'HandshakeId' => [ 'base' => NULL, 'refs' => [ 'AcceptHandshakeRequest$HandshakeId' => '<p>The unique identifier (ID) of the handshake that you want to accept.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>', 'CancelHandshakeRequest$HandshakeId' => '<p>The unique identifier (ID) of the handshake that you want to cancel. You can get the ID from the <a>ListHandshakesForOrganization</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>', 'DeclineHandshakeRequest$HandshakeId' => '<p>The unique identifier (ID) of the handshake that you want to decline. You can get the ID from the <a>ListHandshakesForAccount</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>', 'DescribeHandshakeRequest$HandshakeId' => '<p>The unique identifier (ID) of the handshake that you want information about. You can get the ID from the original call to <a>InviteAccountToOrganization</a>, or from a call to <a>ListHandshakesForAccount</a> or <a>ListHandshakesForOrganization</a>.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>', 'Handshake$Id' => '<p>The unique identifier (ID) of a handshake. The originating account creates the ID when it initiates the handshake.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>', 'HandshakeFilter$ParentHandshakeId' => '<p>Specifies the parent handshake. Only used for handshake types that are a child of another type.</p> <p>If you specify <code>ParentHandshakeId</code>, you cannot also specify <code>ActionType</code>.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>', ], ], 'HandshakeNotFoundException' => [ 'base' => '<p>We can\'t find a handshake with the <code>HandshakeId</code> that you specified.</p>', 'refs' => [], ], 'HandshakeNotes' => [ 'base' => NULL, 'refs' => [ 'InviteAccountToOrganizationRequest$Notes' => '<p>Additional information that you want to include in the generated email to the recipient account owner.</p>', ], ], 'HandshakeParties' => [ 'base' => NULL, 'refs' => [ 'Handshake$Parties' => '<p>Information about the two accounts that are participating in the handshake.</p>', ], ], 'HandshakeParty' => [ 'base' => '<p>Identifies a participant in a handshake.</p>', 'refs' => [ 'HandshakeParties$member' => NULL, 'InviteAccountToOrganizationRequest$Target' => '<p>The identifier (ID) of the Amazon Web Services account that you want to invite to join your organization. This is a JSON object that contains the following elements:</p> <p> <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code> </p> <p>If you use the CLI, you can submit this as a single string, similar to the following example:</p> <p> <code>--target Id=123456789012,Type=ACCOUNT</code> </p> <p>If you specify <code>"Type": "ACCOUNT"</code>, you must provide the Amazon Web Services account ID number as the <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is associated with the account.</p> <p> <code>--target Id=diego@example.com,Type=EMAIL</code> </p>', ], ], 'HandshakePartyId' => [ 'base' => NULL, 'refs' => [ 'HandshakeParty$Id' => '<p>The unique identifier (ID) for the party.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by from 8 to 32 lowercase letters or digits.</p>', ], ], 'HandshakePartyType' => [ 'base' => NULL, 'refs' => [ 'HandshakeParty$Type' => '<p>The type of party.</p>', ], ], 'HandshakeResource' => [ 'base' => '<p>Contains additional data that is needed to process a handshake.</p>', 'refs' => [ 'HandshakeResources$member' => NULL, ], ], 'HandshakeResourceType' => [ 'base' => NULL, 'refs' => [ 'HandshakeResource$Type' => '<p>The type of information being passed, specifying how the value is to be interpreted by the other party:</p> <ul> <li> <p> <code>ACCOUNT</code> - Specifies an Amazon Web Services account ID number.</p> </li> <li> <p> <code>ORGANIZATION</code> - Specifies an organization ID number.</p> </li> <li> <p> <code>EMAIL</code> - Specifies the email address that is associated with the account that receives the handshake. </p> </li> <li> <p> <code>OWNER_EMAIL</code> - Specifies the email address associated with the management account. Included as information about an organization. </p> </li> <li> <p> <code>OWNER_NAME</code> - Specifies the name associated with the management account. Included as information about an organization. </p> </li> <li> <p> <code>NOTES</code> - Additional text provided by the handshake initiator and intended for the recipient to read.</p> </li> </ul>', ], ], 'HandshakeResourceValue' => [ 'base' => NULL, 'refs' => [ 'HandshakeResource$Value' => '<p>The information that is passed to the other party in the handshake. The format of the value string must match the requirements of the specified type.</p>', ], ], 'HandshakeResources' => [ 'base' => NULL, 'refs' => [ 'Handshake$Resources' => '<p>Additional information that is needed to process the handshake.</p>', 'HandshakeResource$Resources' => '<p>When needed, contains an additional array of <code>HandshakeResource</code> objects.</p>', ], ], 'HandshakeState' => [ 'base' => NULL, 'refs' => [ 'Handshake$State' => '<p>The current state of the handshake. Use the state to trace the flow of the handshake through the process from its creation to its acceptance. The meaning of each of the valid values is as follows:</p> <ul> <li> <p> <b>REQUESTED</b>: This handshake was sent to multiple recipients (applicable to only some handshake types) and not all recipients have responded yet. The request stays in this state until all recipients respond.</p> </li> <li> <p> <b>OPEN</b>: This handshake was sent to multiple recipients (applicable to only some policy types) and all recipients have responded, allowing the originator to complete the handshake action.</p> </li> <li> <p> <b>CANCELED</b>: This handshake is no longer active because it was canceled by the originating account.</p> </li> <li> <p> <b>ACCEPTED</b>: This handshake is complete because it has been accepted by the recipient.</p> </li> <li> <p> <b>DECLINED</b>: This handshake is no longer active because it was declined by the recipient account.</p> </li> <li> <p> <b>EXPIRED</b>: This handshake is no longer active because the originator did not receive a response of any kind from the recipient before the expiration time (15 days).</p> </li> </ul>', ], ], 'Handshakes' => [ 'base' => NULL, 'refs' => [ 'ListHandshakesForAccountResponse$Handshakes' => '<p>A list of <a>Handshake</a> objects with details about each of the handshakes that is associated with the specified account.</p>', 'ListHandshakesForOrganizationResponse$Handshakes' => '<p>A list of <a>Handshake</a> objects with details about each of the handshakes that are associated with an organization.</p>', ], ], 'IAMUserAccessToBilling' => [ 'base' => NULL, 'refs' => [ 'CreateAccountRequest$IamUserAccessToBilling' => '<p>If set to <code>ALLOW</code>, the new account enables IAM users to access account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user of the new account can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p> <p>If you don\'t specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the required permissions can access billing information for the new account.</p>', 'CreateGovCloudAccountRequest$IamUserAccessToBilling' => '<p>If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user of the new account can access account billing information. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate">Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost Management User Guide.</i> </p> <p>If you don\'t specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the required permissions can access billing information for the new account.</p>', ], ], 'InvalidHandshakeTransitionException' => [ 'base' => '<p>You can\'t perform the operation on the handshake in its current state. For example, you can\'t cancel a handshake that was already accepted or accept a handshake that was already declined.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The requested operation failed because you provided invalid values for one or more of the request parameters. This exception includes a reason that contains additional information about the violated limit:</p> <note> <p>Some of the reasons in the following list might not be applicable to this specific API or operation.</p> </note> <ul> <li> <p>DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the same entity.</p> </li> <li> <p>IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web Services and can\'t be modified.</p> </li> <li> <p>INPUT_REQUIRED: You must include a value for all required parameters.</p> </li> <li> <p>INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for the invited account owner.</p> </li> <li> <p>INVALID_ENUM: You specified an invalid value.</p> </li> <li> <p>INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.</p> </li> <li> <p>INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid characters.</p> </li> <li> <p>INVALID_LIST_MEMBER: You provided a list to a parameter that contains at least one invalid value.</p> </li> <li> <p>INVALID_PAGINATION_TOKEN: Get the value for the <code>NextToken</code> parameter from the response to a previous call of the operation.</p> </li> <li> <p>INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account, organization, or email) as a party.</p> </li> <li> <p>INVALID_PATTERN: You provided a value that doesn\'t match the required pattern.</p> </li> <li> <p>INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn\'t match the required pattern.</p> </li> <li> <p>INVALID_ROLE_NAME: You provided a role name that isn\'t valid. A role name can\'t begin with the reserved prefix <code>AWSServiceRoleFor</code>.</p> </li> <li> <p>INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource Name (ARN) for the organization.</p> </li> <li> <p>INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID. </p> </li> <li> <p>INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system tag. You can’t add, edit, or delete system tag keys because they\'re reserved for Amazon Web Services use. System tags don’t count against your tags per resource limit.</p> </li> <li> <p>MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for the operation.</p> </li> <li> <p>MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than allowed.</p> </li> <li> <p>MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger value than allowed.</p> </li> <li> <p>MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than allowed.</p> </li> <li> <p>MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller value than allowed.</p> </li> <li> <p>MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only between entities in the same root.</p> </li> <li> <p>TARGET_NOT_SUPPORTED: You can\'t perform the specified operation on that target entity.</p> </li> <li> <p>UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that isn\'t recognized.</p> </li> </ul>', 'refs' => [], ], 'InvalidInputExceptionReason' => [ 'base' => NULL, 'refs' => [ 'InvalidInputException$Reason' => NULL, ], ], 'InviteAccountToOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'InviteAccountToOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAWSServiceAccessForOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAWSServiceAccessForOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsForParentRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsForParentResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChildrenRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChildrenResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCreateAccountStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCreateAccountStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDelegatedAdministratorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDelegatedAdministratorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDelegatedServicesForAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDelegatedServicesForAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHandshakesForAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHandshakesForAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHandshakesForOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHandshakesForOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationalUnitsForParentRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationalUnitsForParentResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListParentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListParentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesForTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesForTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRootsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRootsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsForPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsForPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'MalformedPolicyDocumentException' => [ 'base' => '<p>The provided policy document doesn\'t meet the requirements of the specified policy type. For example, the syntax might be incorrect. For details about service control policy syntax, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>Organizations User Guide.</i> </p>', 'refs' => [], ], 'MasterCannotLeaveOrganizationException' => [ 'base' => '<p>You can\'t remove a management account from an organization. If you want the management account to become a member account in another organization, you must first delete the current organization of the management account.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAWSServiceAccessForOrganizationRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListAccountsForParentRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListAccountsRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListChildrenRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListCreateAccountStatusRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListDelegatedAdministratorsRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListDelegatedServicesForAccountRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListHandshakesForAccountRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListHandshakesForOrganizationRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListOrganizationalUnitsForParentRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListParentsRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListPoliciesForTargetRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListPoliciesRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListRootsRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListTargetsForPolicyRequest$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that Organizations might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', ], ], 'MoveAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAWSServiceAccessForOrganizationRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListAWSServiceAccessForOrganizationResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListAccountsForParentRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListAccountsForParentResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListAccountsRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListAccountsResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListChildrenRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListChildrenResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListCreateAccountStatusRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListCreateAccountStatusResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListDelegatedAdministratorsRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListDelegatedAdministratorsResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListDelegatedServicesForAccountRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListDelegatedServicesForAccountResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListHandshakesForAccountRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListHandshakesForAccountResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListHandshakesForOrganizationRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListHandshakesForOrganizationResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListOrganizationalUnitsForParentRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListOrganizationalUnitsForParentResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListParentsRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListParentsResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListPoliciesForTargetRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListPoliciesForTargetResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListPoliciesRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListPoliciesResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListRootsRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListRootsResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListTagsForResourceRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListTagsForResourceResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListTargetsForPolicyRequest$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListTargetsForPolicyResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', ], ], 'Organization' => [ 'base' => '<p>Contains details about an organization. An organization is a collection of accounts that are centrally managed together using consolidated billing, organized hierarchically with organizational units (OUs), and controlled with policies .</p>', 'refs' => [ 'CreateOrganizationResponse$Organization' => '<p>A structure that contains details about the newly created organization.</p>', 'DescribeOrganizationResponse$Organization' => '<p>A structure that contains information about the organization.</p> <important> <p>The <code>AvailablePolicyTypes</code> part of the response is deprecated, and you shouldn\'t use it in your apps. It doesn\'t include any policy type supported by Organizations other than SCPs. To determine which policy types are enabled in your organization, use the <code> <a>ListRoots</a> </code> operation.</p> </important>', ], ], 'OrganizationArn' => [ 'base' => NULL, 'refs' => [ 'Organization$Arn' => '<p>The Amazon Resource Name (ARN) of an organization.</p> <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>', ], ], 'OrganizationFeatureSet' => [ 'base' => NULL, 'refs' => [ 'CreateOrganizationRequest$FeatureSet' => '<p>Specifies the feature set supported by the new organization. Each feature set supports different levels of functionality.</p> <ul> <li> <p> <code>CONSOLIDATED_BILLING</code>: All member accounts have their bills consolidated to and paid by the management account. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the <i>Organizations User Guide.</i> </p> <p> The consolidated billing feature subset isn\'t available for organizations in the Amazon Web Services GovCloud (US) Region.</p> </li> <li> <p> <code>ALL</code>: In addition to all the features supported by the consolidated billing feature set, the management account can also apply any policy type to any member account in the organization. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All features</a> in the <i>Organizations User Guide.</i> </p> </li> </ul>', 'Organization$FeatureSet' => '<p>Specifies the functionality that currently is available to the organization. If set to "ALL", then all features are enabled and policies can be applied to accounts in the organization. If set to "CONSOLIDATED_BILLING", then only consolidated billing functionality is available. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide</i>.</p>', ], ], 'OrganizationId' => [ 'base' => NULL, 'refs' => [ 'Organization$Id' => '<p>The unique identifier (ID) of an organization.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organization ID string requires "o-" followed by from 10 to 32 lowercase letters or digits.</p>', ], ], 'OrganizationNotEmptyException' => [ 'base' => '<p>The organization isn\'t empty. To delete an organization, you must first remove all accounts except the management account, delete all OUs, and delete all policies.</p>', 'refs' => [], ], 'OrganizationalUnit' => [ 'base' => '<p>Contains details about an organizational unit (OU). An OU is a container of Amazon Web Services accounts within a root of an organization. Policies that are attached to an OU apply to all accounts contained in that OU and in any child OUs.</p>', 'refs' => [ 'CreateOrganizationalUnitResponse$OrganizationalUnit' => '<p>A structure that contains details about the newly created OU.</p>', 'DescribeOrganizationalUnitResponse$OrganizationalUnit' => '<p>A structure that contains details about the specified OU.</p>', 'OrganizationalUnits$member' => NULL, 'UpdateOrganizationalUnitResponse$OrganizationalUnit' => '<p>A structure that contains the details about the specified OU, including its new name.</p>', ], ], 'OrganizationalUnitArn' => [ 'base' => NULL, 'refs' => [ 'OrganizationalUnit$Arn' => '<p>The Amazon Resource Name (ARN) of this OU.</p> <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>', ], ], 'OrganizationalUnitId' => [ 'base' => NULL, 'refs' => [ 'DeleteOrganizationalUnitRequest$OrganizationalUnitId' => '<p>The unique identifier (ID) of the organizational unit that you want to delete. You can get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>', 'DescribeOrganizationalUnitRequest$OrganizationalUnitId' => '<p>The unique identifier (ID) of the organizational unit that you want details about. You can get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>', 'OrganizationalUnit$Id' => '<p>The unique identifier (ID) associated with this OU.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>', 'UpdateOrganizationalUnitRequest$OrganizationalUnitId' => '<p>The unique identifier (ID) of the OU that you want to rename. You can get the ID from the <a>ListOrganizationalUnitsForParent</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for an organizational unit ID string requires "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p>', ], ], 'OrganizationalUnitName' => [ 'base' => NULL, 'refs' => [ 'CreateOrganizationalUnitRequest$Name' => '<p>The friendly name to assign to the new OU.</p>', 'OrganizationalUnit$Name' => '<p>The friendly name of this OU.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', 'UpdateOrganizationalUnitRequest$Name' => '<p>The new name that you want to assign to the OU.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', ], ], 'OrganizationalUnitNotEmptyException' => [ 'base' => '<p>The specified OU is not empty. Move all accounts to another root or to other OUs, remove all child OUs, and try the operation again.</p>', 'refs' => [], ], 'OrganizationalUnitNotFoundException' => [ 'base' => '<p>We can\'t find an OU with the <code>OrganizationalUnitId</code> that you specified.</p>', 'refs' => [], ], 'OrganizationalUnits' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationalUnitsForParentResponse$OrganizationalUnits' => '<p>A list of the OUs in the specified root or parent OU.</p>', ], ], 'Parent' => [ 'base' => '<p>Contains information about either a root or an organizational unit (OU) that can contain OUs or accounts in an organization.</p>', 'refs' => [ 'Parents$member' => NULL, ], ], 'ParentId' => [ 'base' => NULL, 'refs' => [ 'CreateOrganizationalUnitRequest$ParentId' => '<p>The unique identifier (ID) of the parent root or OU that you want to create the new OU in.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', 'ListAccountsForParentRequest$ParentId' => '<p>The unique identifier (ID) for the parent root or organization unit (OU) whose accounts you want to list.</p>', 'ListChildrenRequest$ParentId' => '<p>The unique identifier (ID) for the parent root or OU whose children you want to list.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', 'ListOrganizationalUnitsForParentRequest$ParentId' => '<p>The unique identifier (ID) of the root or OU whose child OUs you want to list.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', 'MoveAccountRequest$SourceParentId' => '<p>The unique identifier (ID) of the root or organizational unit that you want to move the account from.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', 'MoveAccountRequest$DestinationParentId' => '<p>The unique identifier (ID) of the root or organizational unit that you want to move the account to.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', 'Parent$Id' => '<p>The unique identifier (ID) of the parent entity.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a parent ID string requires one of the following:</p> <ul> <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', ], ], 'ParentNotFoundException' => [ 'base' => '<p>We can\'t find a root or OU with the <code>ParentId</code> that you specified.</p>', 'refs' => [], ], 'ParentType' => [ 'base' => NULL, 'refs' => [ 'Parent$Type' => '<p>The type of the parent entity.</p>', ], ], 'Parents' => [ 'base' => NULL, 'refs' => [ 'ListParentsResponse$Parents' => '<p>A list of parents for the specified child account or OU.</p>', ], ], 'Policies' => [ 'base' => NULL, 'refs' => [ 'ListPoliciesForTargetResponse$Policies' => '<p>The list of policies that match the criteria in the request.</p>', 'ListPoliciesResponse$Policies' => '<p>A list of policies that match the filter criteria in the request. The output list doesn\'t include the policy contents. To see the content for a policy, see <a>DescribePolicy</a>.</p>', ], ], 'Policy' => [ 'base' => '<p>Contains rules to be applied to the affected accounts. Policies can be attached directly to accounts, or to roots and OUs to affect all accounts in those hierarchies.</p>', 'refs' => [ 'CreatePolicyResponse$Policy' => '<p>A structure that contains details about the newly created policy.</p>', 'DescribePolicyResponse$Policy' => '<p>A structure that contains details about the specified policy.</p>', 'UpdatePolicyResponse$Policy' => '<p>A structure that contains details about the updated policy, showing the requested changes.</p>', ], ], 'PolicyArn' => [ 'base' => NULL, 'refs' => [ 'PolicySummary$Arn' => '<p>The Amazon Resource Name (ARN) of the policy.</p> <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>', ], ], 'PolicyChangesInProgressException' => [ 'base' => '<p>Changes to the effective policy are in progress, and its contents can\'t be returned. Try the operation again later. </p>', 'refs' => [], ], 'PolicyContent' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$Content' => '<p>The policy text content to add to the new policy. The text that you supply must adhere to the rules of the policy type you specify in the <code>Type</code> parameter.</p>', 'EffectivePolicy$PolicyContent' => '<p>The text content of the policy.</p>', 'Policy$Content' => '<p>The text content of the policy.</p>', 'UpdatePolicyRequest$Content' => '<p>If provided, the new content for the policy. The text must be correctly formatted JSON that complies with the syntax for the policy\'s type. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html">Service Control Policy Syntax</a> in the <i>Organizations User Guide.</i> </p>', ], ], 'PolicyDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$Description' => '<p>An optional description to assign to the policy.</p>', 'PolicySummary$Description' => '<p>The description of the policy.</p>', 'UpdatePolicyRequest$Description' => '<p>If provided, the new description for the policy.</p>', ], ], 'PolicyId' => [ 'base' => NULL, 'refs' => [ 'AttachPolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy that you want to attach to the target. You can get the ID for the policy by calling the <a>ListPolicies</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>', 'DeletePolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy that you want to delete. You can get the ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>', 'DescribePolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy that you want details about. You can get the ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>', 'DetachPolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy you want to detach. You can get the ID from the <a>ListPolicies</a> or <a>ListPoliciesForTarget</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>', 'ListTargetsForPolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy whose attachments you want to know.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>', 'PolicySummary$Id' => '<p>The unique identifier (ID) of the policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>', 'UpdatePolicyRequest$PolicyId' => '<p>The unique identifier (ID) of the policy that you want to update.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).</p>', ], ], 'PolicyInUseException' => [ 'base' => '<p>The policy is attached to one or more entities. You must detach it from all roots, OUs, and accounts before performing this operation.</p>', 'refs' => [], ], 'PolicyName' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$Name' => '<p>The friendly name to assign to the policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', 'PolicySummary$Name' => '<p>The friendly name of the policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', 'UpdatePolicyRequest$Name' => '<p>If provided, the new name for the policy.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', ], ], 'PolicyNotAttachedException' => [ 'base' => '<p>The policy isn\'t attached to the specified target in the specified root.</p>', 'refs' => [], ], 'PolicyNotFoundException' => [ 'base' => '<p>We can\'t find a policy with the <code>PolicyId</code> that you specified.</p>', 'refs' => [], ], 'PolicySummary' => [ 'base' => '<p>Contains information about a policy, but does not include the content. To see the content of a policy, see <a>DescribePolicy</a>.</p>', 'refs' => [ 'Policies$member' => NULL, 'Policy$PolicySummary' => '<p>A structure that contains additional details about the policy.</p>', ], ], 'PolicyTargetId' => [ 'base' => NULL, 'refs' => [ 'AttachPolicyRequest$TargetId' => '<p>The unique identifier (ID) of the root, OU, or account that you want to attach the policy to. You can get the ID by calling the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p> <ul> <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li> <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', 'DescribeEffectivePolicyRequest$TargetId' => '<p>When you\'re signed in as the management account, specify the ID of the account that you want details about. Specifying an organization root or organizational unit (OU) as the target is not supported.</p>', 'DetachPolicyRequest$TargetId' => '<p>The unique identifier (ID) of the root, OU, or account that you want to detach the policy from. You can get the ID from the <a>ListRoots</a>, <a>ListOrganizationalUnitsForParent</a>, or <a>ListAccounts</a> operations.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p> <ul> <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li> <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', 'EffectivePolicy$TargetId' => '<p>The account ID of the policy target. </p>', 'ListPoliciesForTargetRequest$TargetId' => '<p>The unique identifier (ID) of the root, organizational unit, or account whose policies you want to list.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p> <ul> <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li> <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', 'PolicyTargetSummary$TargetId' => '<p>The unique identifier (ID) of the policy target.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a target ID string requires one of the following:</p> <ul> <li> <p> <b>Root</b> - A string that begins with "r-" followed by from 4 to 32 lowercase letters or digits.</p> </li> <li> <p> <b>Account</b> - A string that consists of exactly 12 digits.</p> </li> <li> <p> <b>Organizational unit (OU)</b> - A string that begins with "ou-" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is followed by a second "-" dash and from 8 to 32 additional lowercase letters or digits.</p> </li> </ul>', ], ], 'PolicyTargetSummary' => [ 'base' => '<p>Contains information about a root, OU, or account that a policy is attached to.</p>', 'refs' => [ 'PolicyTargets$member' => NULL, ], ], 'PolicyTargets' => [ 'base' => NULL, 'refs' => [ 'ListTargetsForPolicyResponse$Targets' => '<p>A list of structures, each of which contains details about one of the entities to which the specified policy is attached.</p>', ], ], 'PolicyType' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$Type' => '<p>The type of policy to create. You can specify one of the following values:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li> </ul>', 'DisablePolicyTypeRequest$PolicyType' => '<p>The policy type that you want to disable in this root. You can specify one of the following values:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li> </ul>', 'EnablePolicyTypeRequest$PolicyType' => '<p>The policy type that you want to enable. You can specify one of the following values:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li> </ul>', 'ListPoliciesForTargetRequest$Filter' => '<p>The type of policy that you want to include in the returned list. You must specify one of the following values:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li> </ul>', 'ListPoliciesRequest$Filter' => '<p>Specifies the type of policy that you want to include in the response. You must specify one of the following values:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html">AISERVICES_OPT_OUT_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html">BACKUP_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html">SERVICE_CONTROL_POLICY</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html">TAG_POLICY</a> </p> </li> </ul>', 'PolicySummary$Type' => '<p>The type of policy.</p>', 'PolicyTypeSummary$Type' => '<p>The name of the policy type.</p>', ], ], 'PolicyTypeAlreadyEnabledException' => [ 'base' => '<p>The specified policy type is already enabled in the specified root.</p>', 'refs' => [], ], 'PolicyTypeNotAvailableForOrganizationException' => [ 'base' => '<p>You can\'t use the specified policy type with the feature set currently enabled for this organization. For example, you can enable SCPs only after you enable all features in the organization. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root">Managing Organizations Policies</a>in the <i>Organizations User Guide.</i> </p>', 'refs' => [], ], 'PolicyTypeNotEnabledException' => [ 'base' => '<p>The specified policy type isn\'t currently enabled in this root. You can\'t attach policies of the specified type to entities in a root until you enable that type in the root. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">Enabling All Features in Your Organization</a> in the <i>Organizations User Guide.</i> </p>', 'refs' => [], ], 'PolicyTypeStatus' => [ 'base' => NULL, 'refs' => [ 'PolicyTypeSummary$Status' => '<p>The status of the policy type as it relates to the associated root. To attach a policy of the specified type to a root or to an OU or account in that root, it must be available in the organization and enabled for that root.</p>', ], ], 'PolicyTypeSummary' => [ 'base' => '<p>Contains information about a policy type and its status in the associated root.</p>', 'refs' => [ 'PolicyTypes$member' => NULL, ], ], 'PolicyTypes' => [ 'base' => NULL, 'refs' => [ 'Organization$AvailablePolicyTypes' => '<important> <p>Do not use. This field is deprecated and doesn\'t provide complete information about the policies in your organization.</p> </important> <p>To determine the policies that are enabled and available for use in your organization, use the <a>ListRoots</a> operation instead.</p>', 'Root$PolicyTypes' => '<p>The types of policies that are currently enabled for the root and therefore can be attached to the root or to its OUs or accounts.</p> <note> <p>Even if a policy type is shown as available in the organization, you can separately enable and disable them at the root level by using <a>EnablePolicyType</a> and <a>DisablePolicyType</a>. Use <a>DescribeOrganization</a> to see the availability of the policy types in that organization.</p> </note>', ], ], 'RegisterDelegatedAdministratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveAccountFromOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'RoleName' => [ 'base' => NULL, 'refs' => [ 'CreateAccountRequest$RoleName' => '<p>(Optional)</p> <p>The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the management account, allowing users in the management account to assume the role, as permitted by the management account administrator. The role has administrator permissions in the new member account.</p> <p>If you don\'t specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.</p> <p>For more information about how to use this role to access the member account, see the following links:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i> </p> </li> <li> <p>Steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide</i> </p> </li> </ul> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>', 'CreateGovCloudAccountRequest$RoleName' => '<p>(Optional)</p> <p>The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both the Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the management account, allowing users in the management account to assume the role, as permitted by the management account administrator. The role has administrator permissions in the new member account.</p> <p>If you don\'t specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.</p> <p>For more information about how to use this role to access the member account, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role">Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i> and steps 2 and 3 in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i> </p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following characters: =,.@-</p>', ], ], 'Root' => [ 'base' => '<p>Contains details about a root. A root is a top-level parent node in the hierarchy of an organization that can contain organizational units (OUs) and accounts. The root contains every Amazon Web Services account in the organization.</p>', 'refs' => [ 'DisablePolicyTypeResponse$Root' => '<p>A structure that shows the root with the updated list of enabled policy types.</p>', 'EnablePolicyTypeResponse$Root' => '<p>A structure that shows the root with the updated list of enabled policy types.</p>', 'Roots$member' => NULL, ], ], 'RootArn' => [ 'base' => NULL, 'refs' => [ 'Root$Arn' => '<p>The Amazon Resource Name (ARN) of the root.</p> <p>For more information about ARNs in Organizations, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies">ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.</p>', ], ], 'RootId' => [ 'base' => NULL, 'refs' => [ 'DisablePolicyTypeRequest$RootId' => '<p>The unique identifier (ID) of the root in which you want to disable a policy type. You can get the ID from the <a>ListRoots</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>', 'EnablePolicyTypeRequest$RootId' => '<p>The unique identifier (ID) of the root in which you want to enable a policy type. You can get the ID from the <a>ListRoots</a> operation.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>', 'Root$Id' => '<p>The unique identifier (ID) for the root.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by from 4 to 32 lowercase letters or digits.</p>', ], ], 'RootName' => [ 'base' => NULL, 'refs' => [ 'Root$Name' => '<p>The friendly name of the root.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', ], ], 'RootNotFoundException' => [ 'base' => '<p>We can\'t find a root with the <code>RootId</code> that you specified.</p>', 'refs' => [], ], 'Roots' => [ 'base' => NULL, 'refs' => [ 'ListRootsResponse$Roots' => '<p>A list of roots that are defined in an organization.</p>', ], ], 'ServiceException' => [ 'base' => '<p>Organizations can\'t complete your request because of an internal service error. Try again later.</p>', 'refs' => [], ], 'ServicePrincipal' => [ 'base' => NULL, 'refs' => [ 'DelegatedService$ServicePrincipal' => '<p>The name of an Amazon Web Services service that can request an operation for the specified service. This is typically in the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.</p>', 'DeregisterDelegatedAdministratorRequest$ServicePrincipal' => '<p>The service principal name of an Amazon Web Services service for which the account is a delegated administrator.</p> <p>Delegated administrator privileges are revoked for only the specified Amazon Web Services service from the member account. If the specified service is the only service for which the member account is a delegated administrator, the operation also revokes Organizations read action permissions.</p>', 'DisableAWSServiceAccessRequest$ServicePrincipal' => '<p>The service principal name of the Amazon Web Services service for which you want to disable integration with your organization. This is typically in the form of a URL, such as <code> <i>service-abbreviation</i>.amazonaws.com</code>.</p>', 'EnableAWSServiceAccessRequest$ServicePrincipal' => '<p>The service principal name of the Amazon Web Services service for which you want to enable integration with your organization. This is typically in the form of a URL, such as <code> <i>service-abbreviation</i>.amazonaws.com</code>.</p>', 'EnabledServicePrincipal$ServicePrincipal' => '<p>The name of the service principal. This is typically in the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.</p>', 'ListDelegatedAdministratorsRequest$ServicePrincipal' => '<p>Specifies a service principal name. If specified, then the operation lists the delegated administrators only for the specified service.</p> <p>If you don\'t specify a service principal, the operation lists all delegated administrators for all services in your organization.</p>', 'RegisterDelegatedAdministratorRequest$ServicePrincipal' => '<p>The service principal of the Amazon Web Services service for which you want to make the member account a delegated administrator.</p>', ], ], 'SourceParentNotFoundException' => [ 'base' => '<p>We can\'t find a source root or OU with the <code>ParentId</code> that you specified.</p>', 'refs' => [], ], 'Tag' => [ 'base' => '<p>A custom key-value pair associated with a resource within your organization.</p> <p>You can attach tags to any of the following organization resources.</p> <ul> <li> <p>Amazon Web Services account</p> </li> <li> <p>Organizational unit (OU)</p> </li> <li> <p>Organization root</p> </li> <li> <p>Policy</p> </li> </ul>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key identifier, or name, of the tag.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of keys for tags to remove from the specified resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The string value that\'s associated with the key of the tag. You can set the value of a tag to an empty string, but you can\'t set the value of a tag to null.</p>', ], ], 'TaggableResourceId' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceId' => '<p>The ID of the resource with the tags to list.</p> <p>You can specify any of the following taggable resources.</p> <ul> <li> <p>Amazon Web Services account – specify the account ID number.</p> </li> <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li> <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li> <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li> </ul>', 'TagResourceRequest$ResourceId' => '<p>The ID of the resource to add a tag to.</p> <p>You can specify any of the following taggable resources.</p> <ul> <li> <p>Amazon Web Services account – specify the account ID number.</p> </li> <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li> <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li> <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li> </ul>', 'UntagResourceRequest$ResourceId' => '<p>The ID of the resource to remove a tag from.</p> <p>You can specify any of the following taggable resources.</p> <ul> <li> <p>Amazon Web Services account – specify the account ID number.</p> </li> <li> <p>Organizational unit – specify the OU ID that begins with <code>ou-</code> and looks similar to: <code>ou-<i>1a2b-34uvwxyz</i> </code> </p> </li> <li> <p>Root – specify the root ID that begins with <code>r-</code> and looks similar to: <code>r-<i>1a2b</i> </code> </p> </li> <li> <p>Policy – specify the policy ID that begins with <code>p-</code> andlooks similar to: <code>p-<i>12abcdefg3</i> </code> </p> </li> </ul>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateAccountRequest$Tags' => '<p>A list of tags that you want to attach to the newly created account. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can\'t set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note> <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for an account, then the entire request fails and the account is not created.</p> </note>', 'CreateGovCloudAccountRequest$Tags' => '<p>A list of tags that you want to attach to the newly created account. These tags are attached to the commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud account exists.</p> <p>For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can\'t set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note> <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for an account, then the entire request fails and the account is not created.</p> </note>', 'CreateOrganizationalUnitRequest$Tags' => '<p>A list of tags that you want to attach to the newly created OU. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can\'t set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note> <p>If any one of the tags is invalid or if you exceed the allowed number of tags for an OU, then the entire request fails and the OU is not created.</p> </note>', 'CreatePolicyRequest$Tags' => '<p>A list of tags that you want to attach to the newly created policy. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can\'t set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <note> <p>If any one of the tags is invalid or if you exceed the allowed number of tags for a policy, then the entire request fails and the policy is not created.</p> </note>', 'InviteAccountToOrganizationRequest$Tags' => '<p>A list of tags that you want to attach to the account when it becomes a member of the organization. For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string, but you can\'t set it to <code>null</code>. For more information about tagging, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations resources</a> in the Organizations User Guide.</p> <important> <p>Any tags in the request are checked for compliance with any applicable tag policies when the request is made. The request is rejected if the tags in the request don\'t match the requirements of the policy at that time. Tag policy compliance is <i> <b>not</b> </i> checked again when the invitation is accepted and the tags are actually attached to the account. That means that if the tag policy changes between the invitation and the acceptance, then that tags could potentially be non-compliant.</p> </important> <note> <p>If any one of the tags is invalid or if you exceed the allowed number of tags for an account, then the entire request fails and invitations are not sent.</p> </note>', 'ListTagsForResourceResponse$Tags' => '<p>The tags that are assigned to the resource.</p>', 'TagResourceRequest$Tags' => '<p>A list of tags to add to the specified resource.</p> <p>For each tag in the list, you must specify both a tag key and a value. The value can be an empty string, but you can\'t set it to <code>null</code>.</p> <note> <p>If any one of the tags is invalid or if you exceed the maximum allowed number of tags for a resource, then the entire request fails.</p> </note>', ], ], 'TargetName' => [ 'base' => NULL, 'refs' => [ 'PolicyTargetSummary$Name' => '<p>The friendly name of the policy target.</p> <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a string of any of the characters in the ASCII character range.</p>', ], ], 'TargetNotFoundException' => [ 'base' => '<p>We can\'t find a root, OU, account, or policy with the <code>TargetId</code> that you specified.</p>', 'refs' => [], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'PolicyTargetSummary$Type' => '<p>The type of the policy target.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Account$JoinedTimestamp' => '<p>The date the account became a part of the organization.</p>', 'CreateAccountStatus$RequestedTimestamp' => '<p>The date and time that the request was made for the account creation.</p>', 'CreateAccountStatus$CompletedTimestamp' => '<p>The date and time that the account was created and the request completed.</p>', 'DelegatedAdministrator$JoinedTimestamp' => '<p>The date when the delegated administrator\'s account became a part of the organization.</p>', 'DelegatedAdministrator$DelegationEnabledDate' => '<p>The date when the account was made a delegated administrator.</p>', 'DelegatedService$DelegationEnabledDate' => '<p>The date that the account became a delegated administrator for this service. </p>', 'EffectivePolicy$LastUpdatedTimestamp' => '<p>The time of the last update to this policy.</p>', 'EnabledServicePrincipal$DateEnabled' => '<p>The date that the service principal was enabled for integration with Organizations.</p>', 'Handshake$RequestedTimestamp' => '<p>The date and time that the handshake request was made.</p>', 'Handshake$ExpirationTimestamp' => '<p>The date and time that the handshake expires. If the recipient of the handshake request fails to respond before the specified date and time, the handshake becomes inactive and is no longer valid.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>You have sent too many requests in too short a period of time. The quota helps protect against denial-of-service attacks. Try again later.</p> <p>For information about quotas that affect Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html">Quotas for Organizations</a>in the <i>Organizations User Guide.</i> </p>', 'refs' => [], ], 'UnsupportedAPIEndpointException' => [ 'base' => '<p>This action isn\'t available in the current Amazon Web Services Region.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationalUnitRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationalUnitResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
