<?php
// This file was auto-generated from sdk-root/src/data/migration-hub-refactor-spaces/2021-10-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p><fullname>Amazon Web Services Migration Hub Refactor Spaces</fullname></p> <pre><code> &lt;p&gt;This API reference provides descriptions, syntax, and other details about each of the actions and data types for Amazon Web Services Migration Hub Refactor Spaces (Refactor Spaces). The topic for each action shows the API request parameters and the response. Alternatively, you can use one of the Amazon Web Services SDKs to access an API that is tailored to the programming language or platform that you\'re using. For more information, see &lt;a href=&quot;https://aws.amazon.com/tools/#SDKs&quot;&gt;Amazon Web Services SDKs&lt;/a&gt;.&lt;/p&gt; &lt;p&gt;To share Refactor Spaces environments with other Amazon Web Services accounts or with Organizations and their OUs, use Resource Access Manager\'s &lt;code&gt;CreateResourceShare&lt;/code&gt; API. See &lt;a href=&quot;https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html&quot;&gt;CreateResourceShare&lt;/a&gt; in the &lt;i&gt;Amazon Web Services RAM API Reference&lt;/i&gt;.&lt;/p&gt; </code></pre>', 'operations' => [ 'CreateApplication' => '<p>Creates an Amazon Web Services Migration Hub Refactor Spaces application. The account that owns the environment also owns the applications created inside the environment, regardless of the account that creates the application. Refactor Spaces provisions an Amazon API Gateway, API Gateway VPC link, and Network Load Balancer for the application proxy inside your account.</p>', 'CreateEnvironment' => '<p>Creates an Amazon Web Services Migration Hub Refactor Spaces environment. The caller owns the environment resource, and all Refactor Spaces applications, services, and routes created within the environment. They are referred to as the <i>environment owner</i>. The environment owner has cross-account visibility and control of Refactor Spaces resources that are added to the environment by other accounts that the environment is shared with. When creating an environment, Refactor Spaces provisions a transit gateway in your account.</p>', 'CreateRoute' => '<p>Creates an Amazon Web Services Migration Hub Refactor Spaces route. The account owner of the service resource is always the environment owner, regardless of which account creates the route. Routes target a service in the application. If an application does not have any routes, then the first route must be created as a <code>DEFAULT</code> <code>RouteType</code>.</p> <p>When you create a route, Refactor Spaces configures the Amazon API Gateway to send traffic to the target service as follows:</p> <ul> <li> <p>If the service has a URL endpoint, and the endpoint resolves to a private IP address, Refactor Spaces routes traffic using the API Gateway VPC link. </p> </li> <li> <p>If the service has a URL endpoint, and the endpoint resolves to a public IP address, Refactor Spaces routes traffic over the public internet.</p> </li> <li> <p>If the service has an Lambda function endpoint, then Refactor Spaces configures the Lambda function\'s resource policy to allow the application\'s API Gateway to invoke the function.</p> </li> </ul> <p>A one-time health check is performed on the service when the route is created. If the health check fails, the route transitions to <code>FAILED</code>, and no traffic is sent to the service.</p> <p>For Lambda functions, the Lambda function state is checked. If the function is not active, the function configuration is updated so that Lambda resources are provisioned. If the Lambda state is <code>Failed</code>, then the route creation fails. For more information, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html#SSS-GetFunctionConfiguration-response-State">GetFunctionConfiguration\'s State response parameter</a> in the <i>Lambda Developer Guide</i>.</p> <p>For public URLs, a connection is opened to the public endpoint. If the URL is not reachable, the health check fails. For private URLs, a target group is created and the target group health check is run.</p> <p>The <code>HealthCheckProtocol</code>, <code>HealthCheckPort</code>, and <code>HealthCheckPath</code> are the same protocol, port, and path specified in the URL or health URL, if used. All other settings use the default values, as described in <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-health-checks.html">Health checks for your target groups</a>. The health check is considered successful if at least one target within the target group transitions to a healthy state.</p> <p>Services can have HTTP or HTTPS URL endpoints. For HTTPS URLs, publicly-signed certificates are supported. Private Certificate Authorities (CAs) are permitted only if the CA\'s domain is publicly resolvable.</p>', 'CreateService' => '<p>Creates an Amazon Web Services Migration Hub Refactor Spaces service. The account owner of the service is always the environment owner, regardless of which account in the environment creates the service. Services have either a URL endpoint in a virtual private cloud (VPC), or a Lambda function endpoint.</p> <important> <p>If an Amazon Web Services resource is launched in a service VPC, and you want it to be accessible to all of an environment’s services with VPCs and routes, apply the <code>RefactorSpacesSecurityGroup</code> to the resource. Alternatively, to add more cross-account constraints, apply your own security group.</p> </important>', 'DeleteApplication' => '<p>Deletes an Amazon Web Services Migration Hub Refactor Spaces application. Before you can delete an application, you must first delete any services or routes within the application.</p>', 'DeleteEnvironment' => '<p>Deletes an Amazon Web Services Migration Hub Refactor Spaces environment. Before you can delete an environment, you must first delete any applications and services within the environment.</p>', 'DeleteResourcePolicy' => '<p>Deletes the resource policy set for the environment. </p>', 'DeleteRoute' => '<p>Deletes an Amazon Web Services Migration Hub Refactor Spaces route.</p>', 'DeleteService' => '<p>Deletes an Amazon Web Services Migration Hub Refactor Spaces service. </p>', 'GetApplication' => '<p>Gets an Amazon Web Services Migration Hub Refactor Spaces application.</p>', 'GetEnvironment' => '<p>Gets an Amazon Web Services Migration Hub Refactor Spaces environment.</p>', 'GetResourcePolicy' => '<p>Gets the resource-based permission policy that is set for the given environment. </p>', 'GetRoute' => '<p>Gets an Amazon Web Services Migration Hub Refactor Spaces route.</p>', 'GetService' => '<p>Gets an Amazon Web Services Migration Hub Refactor Spaces service. </p>', 'ListApplications' => '<p>Lists all the Amazon Web Services Migration Hub Refactor Spaces applications within an environment. </p>', 'ListEnvironmentVpcs' => '<p>Lists all Amazon Web Services Migration Hub Refactor Spaces service virtual private clouds (VPCs) that are part of the environment. </p>', 'ListEnvironments' => '<p>Lists Amazon Web Services Migration Hub Refactor Spaces environments owned by a caller account or shared with the caller account. </p>', 'ListRoutes' => '<p>Lists all the Amazon Web Services Migration Hub Refactor Spaces routes within an application. </p>', 'ListServices' => '<p>Lists all the Amazon Web Services Migration Hub Refactor Spaces services within an application. </p>', 'ListTagsForResource' => '<p>Lists the tags of a resource. The caller account must be the same as the resource’s <code>OwnerAccountId</code>. Listing tags in other accounts is not supported. </p>', 'PutResourcePolicy' => '<p>Attaches a resource-based permission policy to the Amazon Web Services Migration Hub Refactor Spaces environment. The policy must contain the same actions and condition statements as the <code>arn:aws:ram::aws:permission/AWSRAMDefaultPermissionRefactorSpacesEnvironment</code> permission in Resource Access Manager. The policy must not contain new lines or blank lines. </p>', 'TagResource' => '<p>Removes the tags of a given resource. Tags are metadata which can be used to manage a resource. To tag a resource, the caller account must be the same as the resource’s <code>OwnerAccountId</code>. Tagging resources in other accounts is not supported.</p> <note> <p>Amazon Web Services Migration Hub Refactor Spaces does not propagate tags to orchestrated resources, such as an environment’s transit gateway.</p> </note>', 'UntagResource' => '<p>Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource. To untag a resource, the caller account must be the same as the resource’s <code>OwnerAccountId</code>. Untagging resources across accounts is not supported. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The user does not have sufficient access to perform this action. </p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$CreatedByAccountId' => '<p>The Amazon Web Services account ID of the application creator. </p>', 'ApplicationSummary$OwnerAccountId' => '<p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>', 'CreateApplicationResponse$CreatedByAccountId' => '<p>The Amazon Web Services account ID of application creator.</p>', 'CreateApplicationResponse$OwnerAccountId' => '<p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>', 'CreateEnvironmentResponse$OwnerAccountId' => '<p>The Amazon Web Services account ID of environment owner.</p>', 'CreateRouteResponse$CreatedByAccountId' => '<p>The Amazon Web Services account ID of the route creator.</p>', 'CreateRouteResponse$OwnerAccountId' => '<p>The Amazon Web Services account ID of the route owner.</p>', 'CreateServiceResponse$CreatedByAccountId' => '<p>The Amazon Web Services account ID of the service creator.</p>', 'CreateServiceResponse$OwnerAccountId' => '<p>The Amazon Web Services account ID of the service owner.</p>', 'EnvironmentSummary$OwnerAccountId' => '<p>The Amazon Web Services account ID of the environment owner.</p>', 'EnvironmentVpc$AccountId' => '<p>The Amazon Web Services account ID of the virtual private cloud (VPC) owner. </p>', 'ErrorResponse$AccountId' => '<p>The Amazon Web Services account ID of the resource owner. </p>', 'GetApplicationResponse$CreatedByAccountId' => '<p>The Amazon Web Services account ID of the application creator. </p>', 'GetApplicationResponse$OwnerAccountId' => '<p>The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).</p>', 'GetEnvironmentResponse$OwnerAccountId' => '<p>The Amazon Web Services account ID of the environment owner.</p>', 'GetRouteResponse$CreatedByAccountId' => '<p>The Amazon Web Services account ID of the route creator.</p>', 'GetRouteResponse$OwnerAccountId' => '<p>The Amazon Web Services account ID of the route owner.</p>', 'GetServiceResponse$CreatedByAccountId' => '<p>The Amazon Web Services account ID of the service creator.</p>', 'GetServiceResponse$OwnerAccountId' => '<p>The Amazon Web Services account ID of the service owner.</p>', 'RouteSummary$CreatedByAccountId' => '<p>The Amazon Web Services account ID of the route creator. </p>', 'RouteSummary$OwnerAccountId' => '<p>The Amazon Web Services account ID of the route owner.</p>', 'ServiceSummary$CreatedByAccountId' => '<p>The Amazon Web Services account ID of the service creator. </p>', 'ServiceSummary$OwnerAccountId' => '<p>The Amazon Web Services account ID of the service owner.</p>', ], ], 'AdditionalDetails' => [ 'base' => NULL, 'refs' => [ 'ErrorResponse$AdditionalDetails' => '<p>Additional details about the error. </p>', ], ], 'AdditionalDetailsKey' => [ 'base' => NULL, 'refs' => [ 'AdditionalDetails$key' => NULL, ], ], 'AdditionalDetailsValue' => [ 'base' => NULL, 'refs' => [ 'AdditionalDetails$value' => NULL, ], ], 'ApiGatewayEndpointType' => [ 'base' => NULL, 'refs' => [ 'ApiGatewayProxyConfig$EndpointType' => '<p>The type of API Gateway endpoint created. </p>', 'ApiGatewayProxyInput$EndpointType' => '<p>The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set to <code>REGIONAL</code> by default.</p> <p>If the value is set to <code>PRIVATE</code> in the request, this creates a private API endpoint that is isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) endpoints for Amazon API Gateway that have been granted access. </p>', 'ApiGatewayProxySummary$EndpointType' => '<p>The type of API Gateway endpoint created. </p>', ], ], 'ApiGatewayId' => [ 'base' => NULL, 'refs' => [ 'ApiGatewayProxyConfig$ApiGatewayId' => '<p>The resource ID of the API Gateway for the proxy. </p>', 'ApiGatewayProxySummary$ApiGatewayId' => '<p>The resource ID of the API Gateway for the proxy. </p>', ], ], 'ApiGatewayProxyConfig' => [ 'base' => '<p>A wrapper object holding the Amazon API Gateway proxy configuration. </p>', 'refs' => [ 'GetApplicationResponse$ApiGatewayProxy' => '<p>The endpoint URL of the API Gateway proxy. </p>', ], ], 'ApiGatewayProxyInput' => [ 'base' => '<p>A wrapper object holding the Amazon API Gateway endpoint input. </p>', 'refs' => [ 'CreateApplicationRequest$ApiGatewayProxy' => '<p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>', 'CreateApplicationResponse$ApiGatewayProxy' => '<p>A wrapper object holding the API Gateway endpoint type and stage name for the proxy. </p>', ], ], 'ApiGatewayProxySummary' => [ 'base' => '<p>A wrapper object holding the Amazon API Gateway proxy summary. </p>', 'refs' => [ 'ApplicationSummary$ApiGatewayProxy' => '<p>The endpoint URL of the Amazon API Gateway proxy. </p>', ], ], 'ApplicationId' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$ApplicationId' => '<p>The unique identifier of the application. </p>', 'CreateApplicationResponse$ApplicationId' => '<p>The unique identifier of the application.</p>', 'CreateRouteRequest$ApplicationIdentifier' => '<p>The ID of the application within which the route is being created.</p>', 'CreateRouteResponse$ApplicationId' => '<p>The ID of the application in which the route is created.</p>', 'CreateServiceRequest$ApplicationIdentifier' => '<p>The ID of the application which the service is created.</p>', 'CreateServiceResponse$ApplicationId' => '<p>The ID of the application that the created service belongs to. </p>', 'DeleteApplicationRequest$ApplicationIdentifier' => '<p>The ID of the application.</p>', 'DeleteApplicationResponse$ApplicationId' => '<p>The ID of the application.</p>', 'DeleteRouteRequest$ApplicationIdentifier' => '<p>The ID of the application to delete the route from.</p>', 'DeleteRouteResponse$ApplicationId' => '<p>The ID of the application that the route belongs to.</p>', 'DeleteServiceRequest$ApplicationIdentifier' => '<p>Deletes a Refactor Spaces service.</p> <note> <p>The <code>RefactorSpacesSecurityGroup</code> security group must be removed from all Amazon Web Services resources in the virtual private cloud (VPC) prior to deleting a service with a URL endpoint in a VPC.</p> </note>', 'DeleteServiceResponse$ApplicationId' => '<p>The ID of the application that the service is in.</p>', 'GetApplicationRequest$ApplicationIdentifier' => '<p>The ID of the application.</p>', 'GetApplicationResponse$ApplicationId' => '<p>The unique identifier of the application.</p>', 'GetRouteRequest$ApplicationIdentifier' => '<p>The ID of the application. </p>', 'GetRouteResponse$ApplicationId' => '<p>The ID of the application that the route belongs to. </p>', 'GetServiceRequest$ApplicationIdentifier' => '<p>The ID of the application.</p>', 'GetServiceResponse$ApplicationId' => '<p>The ID of the application.</p>', 'ListRoutesRequest$ApplicationIdentifier' => '<p>The ID of the application. </p>', 'ListServicesRequest$ApplicationIdentifier' => '<p>The ID of the application. </p>', 'RouteSummary$ApplicationId' => '<p>The unique identifier of the application. </p>', 'ServiceSummary$ApplicationId' => '<p>The unique identifier of the application. </p>', ], ], 'ApplicationName' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$Name' => '<p>The name of the application. </p>', 'CreateApplicationRequest$Name' => '<p>The name to use for the application. </p>', 'CreateApplicationResponse$Name' => '<p>The name of the application.</p>', 'DeleteApplicationResponse$Name' => '<p>The name of the application.</p>', 'GetApplicationResponse$Name' => '<p>The name of the application.</p>', ], ], 'ApplicationState' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$State' => '<p>The current state of the application. </p>', 'CreateApplicationResponse$State' => '<p>The current state of the application. </p>', 'DeleteApplicationResponse$State' => '<p>The current state of the application. </p>', 'GetApplicationResponse$State' => '<p>The current state of the application. </p>', ], ], 'ApplicationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsResponse$ApplicationSummaryList' => '<p>The list of <code>ApplicationSummary</code> objects. </p>', ], ], 'ApplicationSummary' => [ 'base' => '<p>The list of <code>ApplicationSummary</code> objects. </p>', 'refs' => [ 'ApplicationSummaries$member' => NULL, ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'GetRouteResponse$IncludeChildPaths' => '<p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route\'s service. </p>', 'RouteSummary$IncludeChildPaths' => '<p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route\'s service.</p>', 'UriPathRouteInput$IncludeChildPaths' => '<p>Indicates whether to match all subpaths of the given source path. If this value is <code>false</code>, requests must match the source path exactly before they are forwarded to this route\'s service. </p>', ], ], 'CidrBlock' => [ 'base' => NULL, 'refs' => [ 'CidrBlocks$member' => NULL, ], ], 'CidrBlocks' => [ 'base' => NULL, 'refs' => [ 'EnvironmentVpc$CidrBlocks' => '<p>The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks. </p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateEnvironmentRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateRouteRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateServiceRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting a resource can cause an inconsistent state.</p>', 'refs' => [], ], 'CreateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRouteResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$Description' => '<p>The description of the environment.</p>', 'CreateEnvironmentResponse$Description' => '<p>A description of the environment.</p>', 'CreateServiceRequest$Description' => '<p>The description of the service.</p>', 'CreateServiceResponse$Description' => '<p>The description of the created service.</p>', 'EnvironmentSummary$Description' => '<p>A description of the environment. </p>', 'GetEnvironmentResponse$Description' => '<p>The description of the environment. </p>', 'GetServiceResponse$Description' => '<p>The description of the service. </p>', 'ServiceSummary$Description' => '<p>A description of the service. </p>', ], ], 'Ec2TagValue' => [ 'base' => NULL, 'refs' => [ 'EnvironmentVpc$VpcName' => '<p>The name of the VPC at the time it is added to the environment. </p>', ], ], 'EnvironmentId' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$EnvironmentId' => '<p>The unique identifier of the environment. </p>', 'CreateApplicationRequest$EnvironmentIdentifier' => '<p>The unique identifier of the environment.</p>', 'CreateApplicationResponse$EnvironmentId' => '<p>The ID of the environment in which the application is created.</p>', 'CreateEnvironmentResponse$EnvironmentId' => '<p>The unique identifier of the environment.</p>', 'CreateRouteRequest$EnvironmentIdentifier' => '<p>The ID of the environment in which the route is created.</p>', 'CreateServiceRequest$EnvironmentIdentifier' => '<p>The ID of the environment in which the service is created.</p>', 'CreateServiceResponse$EnvironmentId' => '<p>The unique identifier of the environment.</p>', 'DeleteApplicationRequest$EnvironmentIdentifier' => '<p>The ID of the environment. </p>', 'DeleteApplicationResponse$EnvironmentId' => '<p>The unique identifier of the application’s environment.</p>', 'DeleteEnvironmentRequest$EnvironmentIdentifier' => '<p>The ID of the environment. </p>', 'DeleteEnvironmentResponse$EnvironmentId' => '<p>The unique identifier of the environment.</p>', 'DeleteRouteRequest$EnvironmentIdentifier' => '<p>The ID of the environment to delete the route from.</p>', 'DeleteServiceRequest$EnvironmentIdentifier' => '<p>The ID of the environment that the service is in.</p>', 'DeleteServiceResponse$EnvironmentId' => '<p>The unique identifier of the environment.</p>', 'EnvironmentSummary$EnvironmentId' => '<p>The unique identifier of the environment. </p>', 'EnvironmentVpc$EnvironmentId' => '<p>The unique identifier of the environment. </p>', 'GetApplicationRequest$EnvironmentIdentifier' => '<p>The ID of the environment. </p>', 'GetApplicationResponse$EnvironmentId' => '<p>The unique identifier of the environment.</p>', 'GetEnvironmentRequest$EnvironmentIdentifier' => '<p>The ID of the environment.</p>', 'GetEnvironmentResponse$EnvironmentId' => '<p>The unique identifier of the environment. </p>', 'GetRouteRequest$EnvironmentIdentifier' => '<p>The ID of the environment.</p>', 'GetRouteResponse$EnvironmentId' => '<p>Unique identifier of the environment.</p>', 'GetServiceRequest$EnvironmentIdentifier' => '<p>The ID of the environment.</p>', 'GetServiceResponse$EnvironmentId' => '<p>The unique identifier of the environment.</p>', 'ListApplicationsRequest$EnvironmentIdentifier' => '<p>The ID of the environment. </p>', 'ListEnvironmentVpcsRequest$EnvironmentIdentifier' => '<p>The ID of the environment. </p>', 'ListRoutesRequest$EnvironmentIdentifier' => '<p>The ID of the environment. </p>', 'ListServicesRequest$EnvironmentIdentifier' => '<p>The ID of the environment. </p>', 'RouteSummary$EnvironmentId' => '<p>The unique identifier of the environment. </p>', 'ServiceSummary$EnvironmentId' => '<p>The unique identifier of the environment. </p>', ], ], 'EnvironmentName' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$Name' => '<p>The name of the environment.</p>', 'CreateEnvironmentResponse$Name' => '<p>The name of the environment.</p>', 'DeleteEnvironmentResponse$Name' => '<p>The name of the environment.</p>', 'EnvironmentSummary$Name' => '<p>The name of the environment. </p>', 'GetEnvironmentResponse$Name' => '<p>The name of the environment.</p>', ], ], 'EnvironmentState' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentResponse$State' => '<p>The current state of the environment. </p>', 'DeleteEnvironmentResponse$State' => '<p>The current state of the environment. </p>', 'EnvironmentSummary$State' => '<p>The current state of the environment. </p>', 'GetEnvironmentResponse$State' => '<p>The current state of the environment. </p>', ], ], 'EnvironmentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsResponse$EnvironmentSummaryList' => '<p>The list of <code>EnvironmentSummary</code> objects. </p>', ], ], 'EnvironmentSummary' => [ 'base' => '<p>The summary information for environments as a response to <code>ListEnvironments</code>. </p>', 'refs' => [ 'EnvironmentSummaries$member' => NULL, ], ], 'EnvironmentVpc' => [ 'base' => '<p>Provides summary information for the <code>EnvironmentVpc</code> resource as a response to <code>ListEnvironmentVpc</code>.</p>', 'refs' => [ 'EnvironmentVpcs$member' => NULL, ], ], 'EnvironmentVpcs' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentVpcsResponse$EnvironmentVpcList' => '<p>The list of <code>EnvironmentVpc</code> objects. </p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ErrorResponse$Code' => '<p>The error code associated with the error. </p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ErrorResponse$Message' => '<p>The message associated with the error. </p>', ], ], 'ErrorResourceType' => [ 'base' => NULL, 'refs' => [ 'ErrorResponse$ResourceType' => '<p>The type of resource. </p>', ], ], 'ErrorResponse' => [ 'base' => '<p>Error associated with a resource returned for a Get or List resource response. </p>', 'refs' => [ 'ApplicationSummary$Error' => '<p>Any error associated with the application resource. </p>', 'EnvironmentSummary$Error' => '<p>Any error associated with the environment resource. </p>', 'GetApplicationResponse$Error' => '<p>Any error associated with the application resource. </p>', 'GetEnvironmentResponse$Error' => '<p>Any error associated with the environment resource. </p>', 'GetRouteResponse$Error' => '<p>Any error associated with the route resource. </p>', 'GetServiceResponse$Error' => '<p>Any error associated with the service resource. </p>', 'RouteSummary$Error' => '<p>Any error associated with the route resource. </p>', 'ServiceSummary$Error' => '<p>Any error associated with the service resource. </p>', ], ], 'GetApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRouteResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'HttpMethod' => [ 'base' => NULL, 'refs' => [ 'HttpMethods$member' => NULL, ], ], 'HttpMethods' => [ 'base' => NULL, 'refs' => [ 'GetRouteResponse$Methods' => '<p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>', 'RouteSummary$Methods' => '<p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>', 'UriPathRouteInput$Methods' => '<p>A list of HTTP methods to match. An empty list matches all values. If a method is present, only HTTP requests using that method are forwarded to this route’s service. </p>', ], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error occurred while processing the request.</p>', 'refs' => [], ], 'InvalidResourcePolicyException' => [ 'base' => '<p>The resource policy is not valid.</p>', 'refs' => [], ], 'LambdaArn' => [ 'base' => NULL, 'refs' => [ 'LambdaEndpointConfig$Arn' => '<p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>', 'LambdaEndpointInput$Arn' => '<p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>', 'LambdaEndpointSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the Lambda endpoint. </p>', ], ], 'LambdaEndpointConfig' => [ 'base' => '<p>The configuration for the Lambda endpoint type. </p>', 'refs' => [ 'GetServiceResponse$LambdaEndpoint' => '<p>The configuration for the Lambda endpoint type.</p> <p>The <b>Arn</b> is the Amazon Resource Name (ARN) of the Lambda function associated with this service. </p>', ], ], 'LambdaEndpointInput' => [ 'base' => '<p>The input for the Lambda endpoint type. </p>', 'refs' => [ 'CreateServiceRequest$LambdaEndpoint' => '<p>The configuration for the Lambda endpoint type.</p>', 'CreateServiceResponse$LambdaEndpoint' => '<p>The configuration for the Lambda endpoint type.</p>', ], ], 'LambdaEndpointSummary' => [ 'base' => '<p>The summary for the Lambda endpoint type. </p>', 'refs' => [ 'ServiceSummary$LambdaEndpoint' => '<p>A summary of the configuration for the Lambda endpoint type. </p>', ], ], 'ListApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentVpcsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentVpcsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'ListEnvironmentVpcsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'ListEnvironmentsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'ListRoutesRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'ListServicesRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'NetworkFabricType' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$NetworkFabricType' => '<p>The network fabric type of the environment.</p>', 'CreateEnvironmentResponse$NetworkFabricType' => '<p>The network fabric type of the environment.</p>', 'EnvironmentSummary$NetworkFabricType' => '<p>The network fabric type of the environment. </p>', 'GetEnvironmentResponse$NetworkFabricType' => '<p>The network fabric type of the environment. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'ListApplicationsResponse$NextToken' => '<p>The token for the next page of results.</p>', 'ListEnvironmentVpcsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'ListEnvironmentVpcsResponse$NextToken' => '<p>The token for the next page of results.</p>', 'ListEnvironmentsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'ListEnvironmentsResponse$NextToken' => '<p>The token for the next page of results.</p>', 'ListRoutesRequest$NextToken' => '<p>The token for the next page of results.</p>', 'ListRoutesResponse$NextToken' => '<p>The token for the next page of results.</p>', 'ListServicesRequest$NextToken' => '<p>The token for the next page of results.</p>', 'ListServicesResponse$NextToken' => '<p>The token for the next page of results.</p>', ], ], 'NlbArn' => [ 'base' => NULL, 'refs' => [ 'ApiGatewayProxyConfig$NlbArn' => '<p>The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy. </p>', 'ApiGatewayProxySummary$NlbArn' => '<p>The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy. </p>', ], ], 'NlbName' => [ 'base' => NULL, 'refs' => [ 'ApiGatewayProxyConfig$NlbName' => '<p>The name of the Network Load Balancer that is configured by the API Gateway proxy. </p>', 'ApiGatewayProxySummary$NlbName' => '<p>The name of the Network Load Balancer that is configured by the API Gateway proxy. </p>', ], ], 'PathResourceToId' => [ 'base' => NULL, 'refs' => [ 'GetRouteResponse$PathResourceToId' => '<p>A mapping of Amazon API Gateway path resources to resource IDs. </p>', 'RouteSummary$PathResourceToId' => '<p>A mapping of Amazon API Gateway path resources to resource IDs. </p>', ], ], 'PathResourceToIdKey' => [ 'base' => NULL, 'refs' => [ 'PathResourceToId$key' => NULL, ], ], 'PathResourceToIdValue' => [ 'base' => NULL, 'refs' => [ 'PathResourceToId$value' => NULL, ], ], 'PolicyString' => [ 'base' => NULL, 'refs' => [ 'GetResourcePolicyResponse$Policy' => '<p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>', 'PutResourcePolicyRequest$Policy' => '<p>A JSON-formatted string for an Amazon Web Services resource-based policy. </p>', ], ], 'ProxyType' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$ProxyType' => '<p>The proxy type of the proxy created within the application. </p>', 'CreateApplicationRequest$ProxyType' => '<p>The proxy type of the proxy created within the application. </p>', 'CreateApplicationResponse$ProxyType' => '<p>The proxy type of the proxy created within the application. </p>', 'GetApplicationResponse$ProxyType' => '<p>The proxy type of the proxy created within the application. </p>', ], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the application. </p>', 'CreateApplicationResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'CreateEnvironmentResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the environment.</p>', 'CreateRouteResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the route. The format for this ARN is <code>arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> </code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'CreateServiceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'DeleteApplicationResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the application.</p>', 'DeleteEnvironmentResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the environment.</p>', 'DeleteRouteResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the route.</p>', 'DeleteServiceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'EnvironmentSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the environment. </p>', 'GetApplicationResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the application.</p>', 'GetEnvironmentResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the environment.</p>', 'GetRouteResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the route.</p>', 'GetServiceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'PutResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which the policy is being attached. </p>', 'RouteSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the route. </p>', 'ServiceSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the service. </p>', ], ], 'ResourceIdentifier' => [ 'base' => NULL, 'refs' => [ 'ErrorResponse$ResourceIdentifier' => '<p>The ID of the resource. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request references a resource that does not exist. </p>', 'refs' => [], ], 'ResourcePolicyIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcePolicyRequest$Identifier' => '<p>Amazon Resource Name (ARN) of the resource associated with the policy. </p>', 'GetResourcePolicyRequest$Identifier' => '<p>The Amazon Resource Name (ARN) of the resource associated with the policy. </p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$RetryAfterSeconds' => '<p>The number of seconds to wait before retrying. </p>', ], ], 'RouteActivationState' => [ 'base' => NULL, 'refs' => [ 'UriPathRouteInput$ActivationState' => '<p>Indicates whether traffic is forwarded to this route’s service after the route is created. </p>', ], ], 'RouteId' => [ 'base' => NULL, 'refs' => [ 'CreateRouteResponse$RouteId' => '<p>The unique identifier of the route.</p>', 'DeleteRouteRequest$RouteIdentifier' => '<p>The ID of the route to delete.</p>', 'DeleteRouteResponse$RouteId' => '<p>The ID of the route to delete.</p>', 'GetRouteRequest$RouteIdentifier' => '<p>The ID of the route.</p>', 'GetRouteResponse$RouteId' => '<p>The unique identifier of the route.</p> <p> <b>DEFAULT</b>: All traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created.</p> <p> <b>URI_PATH</b>: A route that is based on a URI path.</p>', 'RouteSummary$RouteId' => '<p>The unique identifier of the route. </p>', ], ], 'RouteState' => [ 'base' => NULL, 'refs' => [ 'CreateRouteResponse$State' => '<p>The current state of the route. </p>', 'DeleteRouteResponse$State' => '<p>The current state of the route. </p>', 'GetRouteResponse$State' => '<p>The current state of the route. </p>', 'RouteSummary$State' => '<p>The current state of the route. </p>', ], ], 'RouteSummaries' => [ 'base' => NULL, 'refs' => [ 'ListRoutesResponse$RouteSummaryList' => '<p>The list of <code>RouteSummary</code> objects. </p>', ], ], 'RouteSummary' => [ 'base' => '<p>The summary information for the routes as a response to <code>ListRoutes</code>. </p>', 'refs' => [ 'RouteSummaries$member' => NULL, ], ], 'RouteType' => [ 'base' => NULL, 'refs' => [ 'CreateRouteRequest$RouteType' => '<p>The route type of the route. <code>DEFAULT</code> indicates that all traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created. <code>URI_PATH</code> indicates a route that is based on a URI path.</p>', 'CreateRouteResponse$RouteType' => '<p>The route type of the route.</p>', 'GetRouteResponse$RouteType' => '<p>The type of route.</p>', 'RouteSummary$RouteType' => '<p>The route type of the route. </p>', ], ], 'ServiceEndpointType' => [ 'base' => NULL, 'refs' => [ 'CreateServiceRequest$EndpointType' => '<p>The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.</p>', 'CreateServiceResponse$EndpointType' => '<p>The endpoint type of the service.</p>', 'GetServiceResponse$EndpointType' => '<p>The endpoint type of the service.</p>', 'ServiceSummary$EndpointType' => '<p>The endpoint type of the service. </p>', ], ], 'ServiceId' => [ 'base' => NULL, 'refs' => [ 'CreateRouteRequest$ServiceIdentifier' => '<p>The ID of the service in which the route is created. Traffic that matches this route is forwarded to this service.</p>', 'CreateRouteResponse$ServiceId' => '<p>The ID of service in which the route is created. Traffic that matches this route is forwarded to this service.</p>', 'CreateServiceResponse$ServiceId' => '<p>The unique identifier of the service.</p>', 'DeleteRouteResponse$ServiceId' => '<p>The ID of the service that the route belongs to.</p>', 'DeleteServiceRequest$ServiceIdentifier' => '<p>The ID of the service to delete.</p>', 'DeleteServiceResponse$ServiceId' => '<p>The unique identifier of the service.</p>', 'GetRouteResponse$ServiceId' => '<p>The unique identifier of the service.</p>', 'GetServiceRequest$ServiceIdentifier' => '<p>The ID of the service.</p>', 'GetServiceResponse$ServiceId' => '<p>The unique identifier of the service.</p>', 'RouteSummary$ServiceId' => '<p>The unique identifier of the service. </p>', 'ServiceSummary$ServiceId' => '<p>The unique identifier of the service. </p>', ], ], 'ServiceName' => [ 'base' => NULL, 'refs' => [ 'CreateServiceRequest$Name' => '<p>The name of the service.</p>', 'CreateServiceResponse$Name' => '<p>The name of the service.</p>', 'DeleteServiceResponse$Name' => '<p>The name of the service.</p>', 'GetServiceResponse$Name' => '<p>The name of the service.</p>', 'ServiceSummary$Name' => '<p>The name of the service. </p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a service quota to be exceeded. </p>', 'refs' => [], ], 'ServiceState' => [ 'base' => NULL, 'refs' => [ 'CreateServiceResponse$State' => '<p>The current state of the service. </p>', 'DeleteServiceResponse$State' => '<p>The current state of the service. </p>', 'GetServiceResponse$State' => '<p>The current state of the service. </p>', 'ServiceSummary$State' => '<p>The current state of the service. </p>', ], ], 'ServiceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListServicesResponse$ServiceSummaryList' => '<p> The list of <code>ServiceSummary</code> objects. </p>', ], ], 'ServiceSummary' => [ 'base' => '<p>A summary for the service as a response to <code>ListServices</code>. </p>', 'refs' => [ 'ServiceSummaries$member' => NULL, ], ], 'StageName' => [ 'base' => NULL, 'refs' => [ 'ApiGatewayProxyConfig$StageName' => '<p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>', 'ApiGatewayProxyInput$StageName' => '<p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>', 'ApiGatewayProxySummary$StageName' => '<p>The name of the API Gateway stage. The name defaults to <code>prod</code>. </p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'ConflictException$ResourceId' => '<p>The ID of the resource. </p>', 'ConflictException$ResourceType' => '<p>The type of resource. </p>', 'InternalServerException$Message' => NULL, 'InvalidResourcePolicyException$Message' => NULL, 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. </p>', 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>The ID of the resource. </p>', 'ResourceNotFoundException$ResourceType' => '<p>The type of resource. </p>', 'ServiceQuotaExceededException$Message' => NULL, 'ServiceQuotaExceededException$QuotaCode' => '<p>Service quota requirement to identify originating quota. Reached throttling quota exception. </p>', 'ServiceQuotaExceededException$ResourceId' => '<p>The ID of the resource. </p>', 'ServiceQuotaExceededException$ResourceType' => '<p>The type of resource. </p>', 'ServiceQuotaExceededException$ServiceCode' => '<p>Service quota requirement to identify originating service. Reached throttling quota exception service code. </p>', 'TagKeys$member' => NULL, 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource</p>', 'ThrottlingException$Message' => NULL, 'ThrottlingException$QuotaCode' => '<p>Service quota requirement to identify originating quota. Reached throttling quota exception. </p>', 'ThrottlingException$ServiceCode' => '<p>Service quota requirement to identify originating service. Reached throttling quota exception service code. </p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. </p>', 'ValidationException$Message' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of keys of the tags to be removed from the resource. </p>', ], ], 'TagMap' => [ 'base' => '<p>A collection of up to 50 unique tags</p>', 'refs' => [ 'ApplicationSummary$Tags' => '<p>The tags assigned to the application. </p>', 'CreateApplicationRequest$Tags' => '<p>The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>', 'CreateApplicationResponse$Tags' => '<p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>', 'CreateEnvironmentRequest$Tags' => '<p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.</p>', 'CreateEnvironmentResponse$Tags' => '<p>The tags assigned to the created environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair..</p>', 'CreateRouteRequest$Tags' => '<p>The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>', 'CreateRouteResponse$Tags' => '<p>The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>', 'CreateServiceRequest$Tags' => '<p>The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>', 'CreateServiceResponse$Tags' => '<p>The tags assigned to the created service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.. </p>', 'EnvironmentSummary$Tags' => '<p>The tags assigned to the environment. </p>', 'GetApplicationResponse$Tags' => '<p>The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>', 'GetEnvironmentResponse$Tags' => '<p>The tags to assign to the environment. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>', 'GetRouteResponse$Tags' => '<p>The tags assigned to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>', 'GetServiceResponse$Tags' => '<p>The tags assigned to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair. </p>', 'ListTagsForResourceResponse$Tags' => '<p>The list of tags assigned to the resource. </p>', 'RouteSummary$Tags' => '<p>The tags assigned to the route. </p>', 'ServiceSummary$Tags' => '<p>The tags assigned to the service. </p>', 'TagResourceRequest$Tags' => '<p>The new or modified tags for the resource. </p>', ], ], 'TagMapKeyString' => [ 'base' => NULL, 'refs' => [ 'TagMap$key' => NULL, ], ], 'TagMapValueString' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>Request was denied because the request was throttled. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$CreatedTime' => '<p>A timestamp that indicates when the application is created. </p>', 'ApplicationSummary$LastUpdatedTime' => '<p>A timestamp that indicates when the application was last updated. </p>', 'CreateApplicationResponse$CreatedTime' => '<p>A timestamp that indicates when the application is created.</p>', 'CreateApplicationResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the application was last updated. </p>', 'CreateEnvironmentResponse$CreatedTime' => '<p>A timestamp that indicates when the environment is created.</p>', 'CreateEnvironmentResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the environment was last updated. </p>', 'CreateRouteResponse$CreatedTime' => '<p>A timestamp that indicates when the route is created.</p>', 'CreateRouteResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the route was last updated. </p>', 'CreateServiceResponse$CreatedTime' => '<p>A timestamp that indicates when the service is created.</p>', 'CreateServiceResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the service was last updated. </p>', 'DeleteApplicationResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the environment was last updated. </p>', 'DeleteEnvironmentResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the environment was last updated. </p>', 'DeleteRouteResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the route was last updated. </p>', 'DeleteServiceResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the service was last updated. </p>', 'EnvironmentSummary$CreatedTime' => '<p>A timestamp that indicates when the environment is created. </p>', 'EnvironmentSummary$LastUpdatedTime' => '<p>A timestamp that indicates when the environment was last updated. </p>', 'EnvironmentVpc$CreatedTime' => '<p>A timestamp that indicates when the VPC is first added to the environment. </p>', 'EnvironmentVpc$LastUpdatedTime' => '<p>A timestamp that indicates when the VPC was last updated by the environment. </p>', 'GetApplicationResponse$CreatedTime' => '<p>A timestamp that indicates when the application is created. </p>', 'GetApplicationResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the application was last updated. </p>', 'GetEnvironmentResponse$CreatedTime' => '<p>A timestamp that indicates when the environment is created. </p>', 'GetEnvironmentResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the environment was last updated. </p>', 'GetRouteResponse$CreatedTime' => '<p>The timestamp of when the route is created. </p>', 'GetRouteResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the route was last updated. </p>', 'GetServiceResponse$CreatedTime' => '<p>The timestamp of when the service is created.</p>', 'GetServiceResponse$LastUpdatedTime' => '<p>A timestamp that indicates when the service was last updated. </p>', 'RouteSummary$CreatedTime' => '<p>A timestamp that indicates when the route is created. </p>', 'RouteSummary$LastUpdatedTime' => '<p>A timestamp that indicates when the route was last updated. </p>', 'ServiceSummary$CreatedTime' => '<p>A timestamp that indicates when the service is created. </p>', 'ServiceSummary$LastUpdatedTime' => '<p>A timestamp that indicates when the service was last updated. </p>', ], ], 'TransitGatewayId' => [ 'base' => NULL, 'refs' => [ 'EnvironmentSummary$TransitGatewayId' => '<p>The ID of the transit gateway set up by the environment. </p>', 'GetEnvironmentResponse$TransitGatewayId' => '<p>The ID of the transit gateway set up by the environment. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uri' => [ 'base' => NULL, 'refs' => [ 'ApiGatewayProxyConfig$ProxyUrl' => '<p>The endpoint URL of the API Gateway proxy. </p>', 'ApiGatewayProxySummary$ProxyUrl' => '<p>The endpoint URL of the API Gateway proxy. </p>', 'UrlEndpointConfig$HealthUrl' => '<p>The health check URL of the URL endpoint type. </p>', 'UrlEndpointConfig$Url' => '<p>The HTTP URL endpoint. </p>', 'UrlEndpointInput$HealthUrl' => '<p>The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL. </p>', 'UrlEndpointInput$Url' => '<p>The URL to route traffic to. The URL must be an <a href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>. </p>', 'UrlEndpointSummary$HealthUrl' => '<p>The health check URL of the URL endpoint type. If the URL is a public endpoint, the <code>HealthUrl</code> must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL.</p>', 'UrlEndpointSummary$Url' => '<p> The URL to route traffic to. The URL must be an <a href="https://datatracker.ietf.org/doc/html/rfc3986">rfc3986-formatted URL</a>. If the host is a domain name, the name must be resolvable over the public internet. If the scheme is <code>https</code>, the top level domain of the host must be listed in the <a href="https://www.iana.org/domains/root/db">IANA root zone database</a>. </p>', ], ], 'UriPath' => [ 'base' => NULL, 'refs' => [ 'GetRouteResponse$SourcePath' => '<p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application. </p>', 'RouteSummary$SourcePath' => '<p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application.</p>', 'UriPathRouteInput$SourcePath' => '<p>The path to use to match traffic. Paths must start with <code>/</code> and are relative to the base of the application.</p>', ], ], 'UriPathRouteInput' => [ 'base' => '<p>The configuration for the URI path route type. </p>', 'refs' => [ 'CreateRouteRequest$UriPathRoute' => '<p>The configuration for the URI path route type. </p>', 'CreateRouteResponse$UriPathRoute' => '<p>onfiguration for the URI path route type. </p>', ], ], 'UrlEndpointConfig' => [ 'base' => '<p>The configuration for the URL endpoint type. </p>', 'refs' => [ 'GetServiceResponse$UrlEndpoint' => '<p>The configuration for the URL endpoint type.</p> <p>The <b>Url</b> isthe URL of the endpoint type.</p> <p>The <b>HealthUrl</b> is the health check URL of the endpoint type. </p>', ], ], 'UrlEndpointInput' => [ 'base' => '<p>The configuration for the URL endpoint type. </p>', 'refs' => [ 'CreateServiceRequest$UrlEndpoint' => '<p>The configuration for the URL endpoint type.</p>', 'CreateServiceResponse$UrlEndpoint' => '<p>The configuration for the URL endpoint type. </p>', ], ], 'UrlEndpointSummary' => [ 'base' => '<p>The summary of the configuration for the URL endpoint type. </p>', 'refs' => [ 'ServiceSummary$UrlEndpoint' => '<p>The summary of the configuration for the URL endpoint type. </p>', ], ], 'ValidationException' => [ 'base' => '<p>The input does not satisfy the constraints specified by an Amazon Web Service. </p>', 'refs' => [], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$VpcId' => '<p>The ID of the virtual private cloud (VPC). </p>', 'CreateApplicationRequest$VpcId' => '<p>The ID of the virtual private cloud (VPC).</p>', 'CreateApplicationResponse$VpcId' => '<p>The ID of the Amazon VPC. </p>', 'CreateServiceRequest$VpcId' => '<p>The ID of the VPC.</p>', 'CreateServiceResponse$VpcId' => '<p>The ID of the VPC. </p>', 'EnvironmentVpc$VpcId' => '<p>The ID of the VPC. </p>', 'GetApplicationResponse$VpcId' => '<p>The ID of the virtual private cloud (VPC). </p>', 'GetServiceResponse$VpcId' => '<p>The ID of the virtual private cloud (VPC). </p>', 'ServiceSummary$VpcId' => '<p>The ID of the virtual private cloud (VPC). </p>', ], ], 'VpcLinkId' => [ 'base' => NULL, 'refs' => [ 'ApiGatewayProxyConfig$VpcLinkId' => '<p>The <code>VpcLink</code> ID of the API Gateway proxy. </p>', 'ApiGatewayProxySummary$VpcLinkId' => '<p>The <code>VpcLink</code> ID of the API Gateway proxy. </p>', ], ], ],];
