<?php
// This file was auto-generated from sdk-root/src/data/kafkaconnect/2021-09-14/docs-2.json
return [ 'version' => '2.0', 'service' => '<p/>', 'operations' => [ 'CreateConnector' => '<p>Creates a connector using the specified properties.</p>', 'CreateCustomPlugin' => '<p>Creates a custom plugin using the specified properties.</p>', 'CreateWorkerConfiguration' => '<p>Creates a worker configuration using the specified properties.</p>', 'DeleteConnector' => '<p>Deletes the specified connector.</p>', 'DeleteCustomPlugin' => '<p>Deletes a custom plugin.</p>', 'DescribeConnector' => '<p>Returns summary information about the connector.</p>', 'DescribeCustomPlugin' => '<p>A summary description of the custom plugin.</p>', 'DescribeWorkerConfiguration' => '<p>Returns information about a worker configuration.</p>', 'ListConnectors' => '<p>Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name starts with the specified prefix. The response also includes a description of each of the listed connectors.</p>', 'ListCustomPlugins' => '<p>Returns a list of all of the custom plugins in this account and Region.</p>', 'ListWorkerConfigurations' => '<p>Returns a list of all of the worker configurations in this account and Region.</p>', 'UpdateConnector' => '<p>Updates the specified connector.</p>', ], 'shapes' => [ 'ApacheKafkaCluster' => [ 'base' => '<p>The details of the Apache Kafka cluster to which the connector is connected.</p>', 'refs' => [ 'KafkaCluster$apacheKafkaCluster' => '<p>The Apache Kafka cluster to which the connector is connected.</p>', ], ], 'ApacheKafkaClusterDescription' => [ 'base' => '<p>The description of the Apache Kafka cluster to which the connector is connected.</p>', 'refs' => [ 'KafkaClusterDescription$apacheKafkaCluster' => '<p>The Apache Kafka cluster to which the connector is connected.</p>', ], ], 'AutoScaling' => [ 'base' => '<p>Specifies how the connector scales.</p>', 'refs' => [ 'Capacity$autoScaling' => '<p>Information about the auto scaling parameters for the connector.</p>', ], ], 'AutoScalingDescription' => [ 'base' => '<p>Information about the auto scaling parameters for the connector.</p>', 'refs' => [ 'CapacityDescription$autoScaling' => '<p>Describes the connector\'s auto scaling capacity.</p>', ], ], 'AutoScalingUpdate' => [ 'base' => '<p>The updates to the auto scaling parameters for the connector.</p>', 'refs' => [ 'CapacityUpdate$autoScaling' => '<p>The target auto scaling setting.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.</p>', 'refs' => [], ], 'Capacity' => [ 'base' => '<p>Information about the capacity of the connector, whether it is auto scaled or provisioned.</p>', 'refs' => [ 'CreateConnectorRequest$capacity' => '<p>Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.</p>', ], ], 'CapacityDescription' => [ 'base' => '<p>A description of the connector\'s capacity.</p>', 'refs' => [ 'ConnectorSummary$capacity' => '<p>The connector\'s compute capacity settings.</p>', 'DescribeConnectorResponse$capacity' => '<p>Information about the capacity of the connector, whether it is auto scaled or provisioned.</p>', ], ], 'CapacityUpdate' => [ 'base' => '<p>The target capacity for the connector. The capacity can be auto scaled or provisioned.</p>', 'refs' => [ 'UpdateConnectorRequest$capacity' => '<p>The target capacity.</p>', ], ], 'CloudWatchLogsLogDelivery' => [ 'base' => '<p>The settings for delivering connector logs to Amazon CloudWatch Logs.</p>', 'refs' => [ 'WorkerLogDelivery$cloudWatchLogs' => '<p>Details about delivering logs to Amazon CloudWatch Logs.</p>', ], ], 'CloudWatchLogsLogDeliveryDescription' => [ 'base' => '<p>A description of the log delivery settings.</p>', 'refs' => [ 'WorkerLogDeliveryDescription$cloudWatchLogs' => '<p>Details about delivering logs to Amazon CloudWatch Logs.</p>', ], ], 'ConflictException' => [ 'base' => '<p>HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another name.</p>', 'refs' => [], ], 'ConnectorState' => [ 'base' => NULL, 'refs' => [ 'ConnectorSummary$connectorState' => '<p>The state of the connector.</p>', 'CreateConnectorResponse$connectorState' => '<p>The state of the connector.</p>', 'DeleteConnectorResponse$connectorState' => '<p>The state of the connector that you requested to delete.</p>', 'DescribeConnectorResponse$connectorState' => '<p>The state of the connector.</p>', 'UpdateConnectorResponse$connectorState' => '<p>The state of the connector.</p>', ], ], 'ConnectorSummary' => [ 'base' => '<p>Summary of a connector.</p>', 'refs' => [ '__listOfConnectorSummary$member' => NULL, ], ], 'CreateConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomPluginRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomPluginResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkerConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkerConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomPlugin' => [ 'base' => '<p>A plugin is an AWS resource that contains the code that defines a connector\'s logic.</p>', 'refs' => [ 'Plugin$customPlugin' => '<p>Details about a custom plugin.</p>', ], ], 'CustomPluginContentType' => [ 'base' => NULL, 'refs' => [ 'CreateCustomPluginRequest$contentType' => '<p>The type of the plugin file.</p>', 'CustomPluginRevisionSummary$contentType' => '<p>The format of the plugin file.</p>', ], ], 'CustomPluginDescription' => [ 'base' => '<p>Details about a custom plugin.</p>', 'refs' => [ 'PluginDescription$customPlugin' => '<p>Details about a custom plugin.</p>', ], ], 'CustomPluginFileDescription' => [ 'base' => '<p>Details about a custom plugin file.</p>', 'refs' => [ 'CustomPluginRevisionSummary$fileDescription' => '<p>Details about the custom plugin file.</p>', ], ], 'CustomPluginLocation' => [ 'base' => '<p>Information about the location of a custom plugin.</p>', 'refs' => [ 'CreateCustomPluginRequest$location' => '<p>Information about the location of a custom plugin.</p>', ], ], 'CustomPluginLocationDescription' => [ 'base' => '<p>Information about the location of a custom plugin.</p>', 'refs' => [ 'CustomPluginRevisionSummary$location' => '<p>Information about the location of the custom plugin.</p>', ], ], 'CustomPluginRevisionSummary' => [ 'base' => '<p>Details about the revision of a custom plugin.</p>', 'refs' => [ 'CustomPluginSummary$latestRevision' => '<p>The latest revision of the custom plugin.</p>', 'DescribeCustomPluginResponse$latestRevision' => '<p>The latest successfully created revision of the custom plugin. If there are no successfully created revisions, this field will be absent.</p>', ], ], 'CustomPluginState' => [ 'base' => NULL, 'refs' => [ 'CreateCustomPluginResponse$customPluginState' => '<p>The state of the custom plugin.</p>', 'CustomPluginSummary$customPluginState' => '<p>The state of the custom plugin.</p>', 'DeleteCustomPluginResponse$customPluginState' => '<p>The state of the custom plugin.</p>', 'DescribeCustomPluginResponse$customPluginState' => '<p>The state of the custom plugin.</p>', ], ], 'CustomPluginSummary' => [ 'base' => '<p>A summary of the custom plugin.</p>', 'refs' => [ '__listOfCustomPluginSummary$member' => NULL, ], ], 'DeleteConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomPluginRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomPluginResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomPluginRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomPluginResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkerConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkerConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'FirehoseLogDelivery' => [ 'base' => '<p>The settings for delivering logs to Amazon Kinesis Data Firehose.</p>', 'refs' => [ 'WorkerLogDelivery$firehose' => '<p>Details about delivering logs to Amazon Kinesis Data Firehose.</p>', ], ], 'FirehoseLogDeliveryDescription' => [ 'base' => '<p>A description of the settings for delivering logs to Amazon Kinesis Data Firehose.</p>', 'refs' => [ 'WorkerLogDeliveryDescription$firehose' => '<p>Details about delivering logs to Amazon Kinesis Data Firehose.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.</p>', 'refs' => [], ], 'InternalServerErrorException' => [ 'base' => '<p>HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.</p>', 'refs' => [], ], 'KafkaCluster' => [ 'base' => '<p>The details of the Apache Kafka cluster to which the connector is connected.</p>', 'refs' => [ 'CreateConnectorRequest$kafkaCluster' => '<p>Specifies which Apache Kafka cluster to connect to.</p>', ], ], 'KafkaClusterClientAuthentication' => [ 'base' => '<p>The client authentication information used in order to authenticate with the Apache Kafka cluster.</p>', 'refs' => [ 'CreateConnectorRequest$kafkaClusterClientAuthentication' => '<p>Details of the client authentication used by the Apache Kafka cluster.</p>', ], ], 'KafkaClusterClientAuthenticationDescription' => [ 'base' => '<p>The client authentication information used in order to authenticate with the Apache Kafka cluster.</p>', 'refs' => [ 'ConnectorSummary$kafkaClusterClientAuthentication' => '<p>The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.</p>', 'DescribeConnectorResponse$kafkaClusterClientAuthentication' => '<p>The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.</p>', ], ], 'KafkaClusterClientAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'KafkaClusterClientAuthentication$authenticationType' => '<p>The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client authentication is used.</p>', 'KafkaClusterClientAuthenticationDescription$authenticationType' => '<p>The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client authentication is used.</p>', ], ], 'KafkaClusterDescription' => [ 'base' => '<p>Details of how to connect to the Apache Kafka cluster.</p>', 'refs' => [ 'ConnectorSummary$kafkaCluster' => '<p>The details of the Apache Kafka cluster to which the connector is connected.</p>', 'DescribeConnectorResponse$kafkaCluster' => '<p>The Apache Kafka cluster that the connector is connected to.</p>', ], ], 'KafkaClusterEncryptionInTransit' => [ 'base' => '<p>Details of encryption in transit to the Apache Kafka cluster.</p>', 'refs' => [ 'CreateConnectorRequest$kafkaClusterEncryptionInTransit' => '<p>Details of encryption in transit to the Apache Kafka cluster.</p>', ], ], 'KafkaClusterEncryptionInTransitDescription' => [ 'base' => '<p>The description of the encryption in transit to the Apache Kafka cluster.</p>', 'refs' => [ 'ConnectorSummary$kafkaClusterEncryptionInTransit' => '<p>Details of encryption in transit to the Apache Kafka cluster.</p>', 'DescribeConnectorResponse$kafkaClusterEncryptionInTransit' => '<p>Details of encryption in transit to the Apache Kafka cluster.</p>', ], ], 'KafkaClusterEncryptionInTransitType' => [ 'base' => NULL, 'refs' => [ 'KafkaClusterEncryptionInTransit$encryptionType' => '<p>The type of encryption in transit to the Apache Kafka cluster.</p>', 'KafkaClusterEncryptionInTransitDescription$encryptionType' => '<p>The type of encryption in transit to the Apache Kafka cluster.</p>', ], ], 'ListConnectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConnectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomPluginsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomPluginsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkerConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkerConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogDelivery' => [ 'base' => '<p>Details about log delivery.</p>', 'refs' => [ 'CreateConnectorRequest$logDelivery' => '<p>Details about log delivery.</p>', ], ], 'LogDeliveryDescription' => [ 'base' => '<p>The description of the log delivery settings.</p>', 'refs' => [ 'ConnectorSummary$logDelivery' => '<p>The settings for delivering connector logs to Amazon CloudWatch Logs.</p>', 'DescribeConnectorResponse$logDelivery' => '<p>Details about delivering logs to Amazon CloudWatch Logs.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListConnectorsRequest$maxResults' => '<p>The maximum number of connectors to list in one response.</p>', 'ListCustomPluginsRequest$maxResults' => '<p>The maximum number of custom plugins to list in one response.</p>', 'ListWorkerConfigurationsRequest$maxResults' => '<p>The maximum number of worker configurations to list in one response.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.</p>', 'refs' => [], ], 'Plugin' => [ 'base' => '<p>A plugin is an AWS resource that contains the code that defines your connector logic. </p>', 'refs' => [ '__listOfPlugin$member' => NULL, ], ], 'PluginDescription' => [ 'base' => '<p>The description of the plugin.</p>', 'refs' => [ '__listOfPluginDescription$member' => NULL, ], ], 'ProvisionedCapacity' => [ 'base' => '<p>Details about a connector\'s provisioned capacity.</p>', 'refs' => [ 'Capacity$provisionedCapacity' => '<p>Details about a fixed capacity allocated to a connector.</p>', ], ], 'ProvisionedCapacityDescription' => [ 'base' => '<p>The description of a connector\'s provisioned capacity.</p>', 'refs' => [ 'CapacityDescription$provisionedCapacity' => '<p>Describes a connector\'s provisioned capacity.</p>', ], ], 'ProvisionedCapacityUpdate' => [ 'base' => '<p>An update to a connector\'s fixed capacity.</p>', 'refs' => [ 'CapacityUpdate$provisionedCapacity' => '<p>The target settings for provisioned capacity.</p>', ], ], 'S3Location' => [ 'base' => '<p>The location of an object in Amazon S3.</p>', 'refs' => [ 'CustomPluginLocation$s3Location' => '<p>The S3 bucket Amazon Resource Name (ARN), file key, and object version of the plugin file stored in Amazon S3.</p>', ], ], 'S3LocationDescription' => [ 'base' => '<p>The description of the location of an object in Amazon S3.</p>', 'refs' => [ 'CustomPluginLocationDescription$s3Location' => '<p>The S3 bucket Amazon Resource Name (ARN), file key, and object version of the plugin file stored in Amazon S3.</p>', ], ], 'S3LogDelivery' => [ 'base' => '<p>Details about delivering logs to Amazon S3.</p>', 'refs' => [ 'WorkerLogDelivery$s3' => '<p>Details about delivering logs to Amazon S3.</p>', ], ], 'S3LogDeliveryDescription' => [ 'base' => '<p>The description of the details about delivering logs to Amazon S3.</p>', 'refs' => [ 'WorkerLogDeliveryDescription$s3' => '<p>Details about delivering logs to Amazon S3.</p>', ], ], 'ScaleInPolicy' => [ 'base' => '<p>The scale-in policy for the connector.</p>', 'refs' => [ 'AutoScaling$scaleInPolicy' => '<p>The sacle-in policy for the connector.</p>', ], ], 'ScaleInPolicyDescription' => [ 'base' => '<p>The description of the scale-in policy for the connector.</p>', 'refs' => [ 'AutoScalingDescription$scaleInPolicy' => '<p>The sacle-in policy for the connector.</p>', ], ], 'ScaleInPolicyUpdate' => [ 'base' => '<p>An update to the connector\'s scale-in policy.</p>', 'refs' => [ 'AutoScalingUpdate$scaleInPolicy' => '<p>The target sacle-in policy for the connector.</p>', ], ], 'ScaleOutPolicy' => [ 'base' => '<p>The scale-out policy for the connector.</p>', 'refs' => [ 'AutoScaling$scaleOutPolicy' => '<p>The sacle-out policy for the connector.</p>', ], ], 'ScaleOutPolicyDescription' => [ 'base' => '<p>The description of the scale-out policy for the connector.</p>', 'refs' => [ 'AutoScalingDescription$scaleOutPolicy' => '<p>The sacle-out policy for the connector.&gt;</p>', ], ], 'ScaleOutPolicyUpdate' => [ 'base' => '<p>An update to the connector\'s scale-out policy.</p>', 'refs' => [ 'AutoScalingUpdate$scaleOutPolicy' => '<p>The target sacle-out policy for the connector.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.</p>', 'refs' => [], ], 'StateDescription' => [ 'base' => '<p>Details about the state of a resource.</p>', 'refs' => [ 'DescribeConnectorResponse$stateDescription' => '<p>Details about the state of a connector.</p>', 'DescribeCustomPluginResponse$stateDescription' => '<p>Details about the state of a custom plugin.</p>', ], ], 'SyntheticCreateConnectorRequest__mapOf__string' => [ 'base' => NULL, 'refs' => [ 'CreateConnectorRequest$connectorConfiguration' => '<p>A map of keys to values that represent the configuration for the connector.</p>', ], ], 'SyntheticCreateWorkerConfigurationRequest__string' => [ 'base' => NULL, 'refs' => [ 'CreateWorkerConfigurationRequest$propertiesFileContent' => '<p>Base64 encoded contents of connect-distributed.properties file.</p>', ], ], 'SyntheticDescribeConnectorResponse__mapOf__string' => [ 'base' => NULL, 'refs' => [ 'DescribeConnectorResponse$connectorConfiguration' => '<p>A map of keys to values that represent the configuration for the connector.</p>', ], ], 'SyntheticWorkerConfigurationRevisionDescription__string' => [ 'base' => NULL, 'refs' => [ 'WorkerConfigurationRevisionDescription$propertiesFileContent' => '<p>Base64 encoded contents of the connect-distributed.properties file.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>HTTP Status Code 429: Limit exceeded. Resource limit reached.</p>', 'refs' => [], ], 'UnauthorizedException' => [ 'base' => '<p>HTTP Status Code 401: Unauthorized request. The provided credentials couldn\'t be validated.</p>', 'refs' => [], ], 'UpdateConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'Vpc' => [ 'base' => '<p>Information about the VPC in which the connector resides.</p>', 'refs' => [ 'ApacheKafkaCluster$vpc' => '<p>Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.</p>', ], ], 'VpcDescription' => [ 'base' => '<p>The description of the VPC in which the connector resides.</p>', 'refs' => [ 'ApacheKafkaClusterDescription$vpc' => '<p>Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.</p>', ], ], 'WorkerConfiguration' => [ 'base' => '<p>The configuration of the workers, which are the processes that run the connector logic.</p>', 'refs' => [ 'CreateConnectorRequest$workerConfiguration' => '<p>Specifies which worker configuration to use with the connector.</p>', ], ], 'WorkerConfigurationDescription' => [ 'base' => '<p>The description of the worker configuration.</p>', 'refs' => [ 'ConnectorSummary$workerConfiguration' => '<p>The worker configurations that are in use with the connector.</p>', 'DescribeConnectorResponse$workerConfiguration' => '<p>Specifies which worker configuration was used for the connector.</p>', ], ], 'WorkerConfigurationRevisionDescription' => [ 'base' => '<p>The description of the worker configuration revision.</p>', 'refs' => [ 'DescribeWorkerConfigurationResponse$latestRevision' => '<p>The latest revision of the custom configuration.</p>', ], ], 'WorkerConfigurationRevisionSummary' => [ 'base' => '<p>The summary of a worker configuration revision.</p>', 'refs' => [ 'CreateWorkerConfigurationResponse$latestRevision' => '<p>The latest revision of the worker configuration.</p>', 'WorkerConfigurationSummary$latestRevision' => '<p>The latest revision of a worker configuration.</p>', ], ], 'WorkerConfigurationSummary' => [ 'base' => '<p>The summary of a worker configuration.</p>', 'refs' => [ '__listOfWorkerConfigurationSummary$member' => NULL, ], ], 'WorkerLogDelivery' => [ 'base' => '<p>Workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>', 'refs' => [ 'LogDelivery$workerLogDelivery' => '<p>The workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>', ], ], 'WorkerLogDeliveryDescription' => [ 'base' => '<p>Workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>', 'refs' => [ 'LogDeliveryDescription$workerLogDelivery' => '<p>The workers can send worker logs to different destination types. This configuration specifies the details of these destinations.</p>', ], ], '__boolean' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogsLogDelivery$enabled' => '<p>Whether log delivery to Amazon CloudWatch Logs is enabled.</p>', 'CloudWatchLogsLogDeliveryDescription$enabled' => '<p>Whether log delivery to Amazon CloudWatch Logs is enabled.</p>', 'FirehoseLogDelivery$enabled' => '<p>Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.</p>', 'FirehoseLogDeliveryDescription$enabled' => '<p>Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.</p>', 'S3LogDelivery$enabled' => '<p>Specifies whether connector logs get sent to the specified Amazon S3 destination.</p>', 'S3LogDeliveryDescription$enabled' => '<p>Specifies whether connector logs get sent to the specified Amazon S3 destination.</p>', ], ], '__integer' => [ 'base' => NULL, 'refs' => [ 'AutoScalingDescription$maxWorkerCount' => '<p>The maximum number of workers allocated to the connector.</p>', 'AutoScalingDescription$mcuCount' => '<p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>', 'AutoScalingDescription$minWorkerCount' => '<p>The minimum number of workers allocated to the connector.</p>', 'ProvisionedCapacityDescription$mcuCount' => '<p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>', 'ProvisionedCapacityDescription$workerCount' => '<p>The number of workers that are allocated to the connector.</p>', 'ScaleInPolicyDescription$cpuUtilizationPercentage' => '<p>Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>', 'ScaleOutPolicyDescription$cpuUtilizationPercentage' => '<p>The CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>', ], ], '__integerMin1Max10' => [ 'base' => NULL, 'refs' => [ 'AutoScaling$maxWorkerCount' => '<p>The maximum number of workers allocated to the connector.</p>', 'AutoScaling$minWorkerCount' => '<p>The minimum number of workers allocated to the connector.</p>', 'AutoScalingUpdate$maxWorkerCount' => '<p>The target maximum number of workers allocated to the connector.</p>', 'AutoScalingUpdate$minWorkerCount' => '<p>The target minimum number of workers allocated to the connector.</p>', 'ProvisionedCapacity$workerCount' => '<p>The number of workers that are allocated to the connector.</p>', 'ProvisionedCapacityUpdate$workerCount' => '<p>The number of workers that are allocated to the connector.</p>', ], ], '__integerMin1Max100' => [ 'base' => NULL, 'refs' => [ 'ScaleInPolicy$cpuUtilizationPercentage' => '<p>Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>', 'ScaleInPolicyUpdate$cpuUtilizationPercentage' => '<p>The target CPU utilization percentage threshold at which you want connector scale in to be triggered.</p>', 'ScaleOutPolicy$cpuUtilizationPercentage' => '<p>The CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>', 'ScaleOutPolicyUpdate$cpuUtilizationPercentage' => '<p>The target CPU utilization percentage threshold at which you want connector scale out to be triggered.</p>', ], ], '__integerMin1Max8' => [ 'base' => NULL, 'refs' => [ 'AutoScaling$mcuCount' => '<p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>', 'AutoScalingUpdate$mcuCount' => '<p>The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>', 'ProvisionedCapacity$mcuCount' => '<p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>', 'ProvisionedCapacityUpdate$mcuCount' => '<p>The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.</p>', ], ], '__listOfConnectorSummary' => [ 'base' => NULL, 'refs' => [ 'ListConnectorsResponse$connectors' => '<p>An array of connector descriptions.</p>', ], ], '__listOfCustomPluginSummary' => [ 'base' => NULL, 'refs' => [ 'ListCustomPluginsResponse$customPlugins' => '<p>An array of custom plugin descriptions.</p>', ], ], '__listOfPlugin' => [ 'base' => NULL, 'refs' => [ 'CreateConnectorRequest$plugins' => '<p>Specifies which plugins to use for the connector.</p>', ], ], '__listOfPluginDescription' => [ 'base' => NULL, 'refs' => [ 'ConnectorSummary$plugins' => '<p>Specifies which plugins were used for this connector.</p>', 'DescribeConnectorResponse$plugins' => '<p>Specifies which plugins were used for this connector.</p>', ], ], '__listOfWorkerConfigurationSummary' => [ 'base' => NULL, 'refs' => [ 'ListWorkerConfigurationsResponse$workerConfigurations' => '<p>An array of worker configuration descriptions.</p>', ], ], '__listOf__string' => [ 'base' => NULL, 'refs' => [ 'Vpc$securityGroups' => '<p>The security groups for the connector.</p>', 'Vpc$subnets' => '<p>The subnets for the connector.</p>', 'VpcDescription$securityGroups' => '<p>The security groups for the connector.</p>', 'VpcDescription$subnets' => '<p>The subnets for the connector.</p>', ], ], '__long' => [ 'base' => NULL, 'refs' => [ 'CreateCustomPluginResponse$revision' => '<p>The revision of the custom plugin.</p>', 'CustomPluginDescription$revision' => '<p>The revision of the custom plugin.</p>', 'CustomPluginFileDescription$fileSize' => '<p>The size in bytes of the custom plugin file. You can use it to validate the file.</p>', 'CustomPluginRevisionSummary$revision' => '<p>The revision of the custom plugin.</p>', 'WorkerConfigurationDescription$revision' => '<p>The revision of the worker configuration.</p>', 'WorkerConfigurationRevisionDescription$revision' => '<p>The description of a revision of the worker configuration.</p>', 'WorkerConfigurationRevisionSummary$revision' => '<p>The revision of a worker configuration.</p>', ], ], '__longMin1' => [ 'base' => NULL, 'refs' => [ 'CustomPlugin$revision' => '<p>The revision of the custom plugin.</p>', 'WorkerConfiguration$revision' => '<p>The revision of the worker configuration.</p>', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'ApacheKafkaCluster$bootstrapServers' => '<p>The bootstrap servers of the cluster.</p>', 'ApacheKafkaClusterDescription$bootstrapServers' => '<p>The bootstrap servers of the cluster.</p>', 'BadRequestException$message' => NULL, 'CloudWatchLogsLogDelivery$logGroup' => '<p>The name of the CloudWatch log group that is the destination for log delivery.</p>', 'CloudWatchLogsLogDeliveryDescription$logGroup' => '<p>The name of the CloudWatch log group that is the destination for log delivery.</p>', 'ConflictException$message' => NULL, 'ConnectorSummary$connectorArn' => '<p>The Amazon Resource Name (ARN) of the connector.</p>', 'ConnectorSummary$connectorDescription' => '<p>The description of the connector.</p>', 'ConnectorSummary$connectorName' => '<p>The name of the connector.</p>', 'ConnectorSummary$currentVersion' => '<p>The current version of the connector.</p>', 'ConnectorSummary$kafkaConnectVersion' => '<p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster\'s version and the plugins.</p>', 'ConnectorSummary$serviceExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.</p>', 'CreateConnectorRequest$kafkaConnectVersion' => '<p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster\'s version and the plugins.</p>', 'CreateConnectorRequest$serviceExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.</p>', 'CreateConnectorResponse$connectorArn' => '<p>The Amazon Resource Name (ARN) that Amazon assigned to the connector.</p>', 'CreateConnectorResponse$connectorName' => '<p>The name of the connector.</p>', 'CreateCustomPluginResponse$customPluginArn' => '<p>The Amazon Resource Name (ARN) that Amazon assigned to the custom plugin.</p>', 'CreateCustomPluginResponse$name' => '<p>The name of the custom plugin.</p>', 'CreateWorkerConfigurationResponse$name' => '<p>The name of the worker configuration.</p>', 'CreateWorkerConfigurationResponse$workerConfigurationArn' => '<p>The Amazon Resource Name (ARN) that Amazon assigned to the worker configuration.</p>', 'CustomPlugin$customPluginArn' => '<p>The Amazon Resource Name (ARN) of the custom plugin.</p>', 'CustomPluginDescription$customPluginArn' => '<p>The Amazon Resource Name (ARN) of the custom plugin.</p>', 'CustomPluginFileDescription$fileMd5' => '<p>The hex-encoded MD5 checksum of the custom plugin file. You can use it to validate the file.</p>', 'CustomPluginRevisionSummary$description' => '<p>The description of the custom plugin.</p>', 'CustomPluginSummary$customPluginArn' => '<p>The Amazon Resource Name (ARN) of the custom plugin.</p>', 'CustomPluginSummary$description' => '<p>A description of the custom plugin.</p>', 'CustomPluginSummary$name' => '<p>The name of the custom plugin.</p>', 'DeleteConnectorRequest$connectorArn' => '<p>The Amazon Resource Name (ARN) of the connector that you want to delete.</p>', 'DeleteConnectorRequest$currentVersion' => '<p>The current version of the connector that you want to delete.</p>', 'DeleteConnectorResponse$connectorArn' => '<p>The Amazon Resource Name (ARN) of the connector that you requested to delete.</p>', 'DeleteCustomPluginRequest$customPluginArn' => '<p>The Amazon Resource Name (ARN) of the custom plugin that you want to delete.</p>', 'DeleteCustomPluginResponse$customPluginArn' => '<p>The Amazon Resource Name (ARN) of the custom plugin that you requested to delete.</p>', 'DescribeConnectorRequest$connectorArn' => '<p>The Amazon Resource Name (ARN) of the connector that you want to describe.</p>', 'DescribeConnectorResponse$connectorArn' => '<p>The Amazon Resource Name (ARN) of the connector.</p>', 'DescribeConnectorResponse$connectorDescription' => '<p>A summary description of the connector.</p>', 'DescribeConnectorResponse$connectorName' => '<p>The name of the connector.</p>', 'DescribeConnectorResponse$currentVersion' => '<p>The current version of the connector.</p>', 'DescribeConnectorResponse$kafkaConnectVersion' => '<p>The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster\'s version and the plugins.</p>', 'DescribeConnectorResponse$serviceExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.</p>', 'DescribeCustomPluginRequest$customPluginArn' => '<p>Returns information about a custom plugin.</p>', 'DescribeCustomPluginResponse$customPluginArn' => '<p>The Amazon Resource Name (ARN) of the custom plugin.</p>', 'DescribeCustomPluginResponse$description' => '<p>The description of the custom plugin.</p>', 'DescribeCustomPluginResponse$name' => '<p>The name of the custom plugin.</p>', 'DescribeWorkerConfigurationRequest$workerConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the worker configuration that you want to get information about.</p>', 'DescribeWorkerConfigurationResponse$description' => '<p>The description of the worker configuration.</p>', 'DescribeWorkerConfigurationResponse$name' => '<p>The name of the worker configuration.</p>', 'DescribeWorkerConfigurationResponse$workerConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the custom configuration.</p>', 'FirehoseLogDelivery$deliveryStream' => '<p>The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.</p>', 'FirehoseLogDeliveryDescription$deliveryStream' => '<p>The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.</p>', 'ForbiddenException$message' => NULL, 'InternalServerErrorException$message' => NULL, 'ListConnectorsRequest$connectorNamePrefix' => '<p>The name prefix that you want to use to search for and list connectors.</p>', 'ListConnectorsRequest$nextToken' => '<p>If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>', 'ListConnectorsResponse$nextToken' => '<p>If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where it left off.</p>', 'ListCustomPluginsRequest$nextToken' => '<p>If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>', 'ListCustomPluginsResponse$nextToken' => '<p>If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>', 'ListWorkerConfigurationsRequest$nextToken' => '<p>If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>', 'ListWorkerConfigurationsResponse$nextToken' => '<p>If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this NextToken in a subsequent request to continue listing from where the previous operation left off.</p>', 'NotFoundException$message' => NULL, 'S3Location$bucketArn' => '<p>The Amazon Resource Name (ARN) of an S3 bucket.</p>', 'S3Location$fileKey' => '<p>The file key for an object in an S3 bucket.</p>', 'S3Location$objectVersion' => '<p>The version of an object in an S3 bucket.</p>', 'S3LocationDescription$bucketArn' => '<p>The Amazon Resource Name (ARN) of an S3 bucket.</p>', 'S3LocationDescription$fileKey' => '<p>The file key for an object in an S3 bucket.</p>', 'S3LocationDescription$objectVersion' => '<p>The version of an object in an S3 bucket.</p>', 'S3LogDelivery$bucket' => '<p>The name of the S3 bucket that is the destination for log delivery.</p>', 'S3LogDelivery$prefix' => '<p>The S3 prefix that is the destination for log delivery.</p>', 'S3LogDeliveryDescription$bucket' => '<p>The name of the S3 bucket that is the destination for log delivery.</p>', 'S3LogDeliveryDescription$prefix' => '<p>The S3 prefix that is the destination for log delivery.</p>', 'ServiceUnavailableException$message' => NULL, 'StateDescription$code' => '<p>A code that describes the state of a resource.</p>', 'StateDescription$message' => '<p>A message that describes the state of a resource.</p>', 'SyntheticCreateConnectorRequest__mapOf__string$key' => NULL, 'SyntheticCreateConnectorRequest__mapOf__string$value' => NULL, 'SyntheticDescribeConnectorResponse__mapOf__string$key' => NULL, 'SyntheticDescribeConnectorResponse__mapOf__string$value' => NULL, 'TooManyRequestsException$message' => NULL, 'UnauthorizedException$message' => NULL, 'UpdateConnectorRequest$connectorArn' => '<p>The Amazon Resource Name (ARN) of the connector that you want to update.</p>', 'UpdateConnectorRequest$currentVersion' => '<p>The current version of the connector that you want to update.</p>', 'UpdateConnectorResponse$connectorArn' => '<p>The Amazon Resource Name (ARN) of the connector.</p>', 'WorkerConfiguration$workerConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the worker configuration.</p>', 'WorkerConfigurationDescription$workerConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the worker configuration.</p>', 'WorkerConfigurationRevisionDescription$description' => '<p>The description of the worker configuration revision.</p>', 'WorkerConfigurationRevisionSummary$description' => '<p>The description of a worker configuration revision.</p>', 'WorkerConfigurationSummary$description' => '<p>The description of a worker configuration.</p>', 'WorkerConfigurationSummary$name' => '<p>The name of the worker configuration.</p>', 'WorkerConfigurationSummary$workerConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the worker configuration.</p>', '__listOf__string$member' => NULL, ], ], '__stringMax1024' => [ 'base' => NULL, 'refs' => [ 'CreateConnectorRequest$connectorDescription' => '<p>A summary description of the connector.</p>', 'CreateCustomPluginRequest$description' => '<p>A summary description of the custom plugin.</p>', 'CreateWorkerConfigurationRequest$description' => '<p>A summary description of the worker configuration.</p>', ], ], '__stringMin1Max128' => [ 'base' => NULL, 'refs' => [ 'CreateConnectorRequest$connectorName' => '<p>The name of the connector.</p>', 'CreateCustomPluginRequest$name' => '<p>The name of the custom plugin.</p>', 'CreateWorkerConfigurationRequest$name' => '<p>The name of the worker configuration.</p>', ], ], '__timestampIso8601' => [ 'base' => NULL, 'refs' => [ 'ConnectorSummary$creationTime' => '<p>The time that the connector was created.</p>', 'CreateWorkerConfigurationResponse$creationTime' => '<p>The time that the worker configuration was created.</p>', 'CustomPluginRevisionSummary$creationTime' => '<p>The time that the custom plugin was created.</p>', 'CustomPluginSummary$creationTime' => '<p>The time that the custom plugin was created.</p>', 'DescribeConnectorResponse$creationTime' => '<p>The time the connector was created.</p>', 'DescribeCustomPluginResponse$creationTime' => '<p>The time that the custom plugin was created.</p>', 'DescribeWorkerConfigurationResponse$creationTime' => '<p>The time that the worker configuration was created.</p>', 'WorkerConfigurationRevisionDescription$creationTime' => '<p>The time that the worker configuration was created.</p>', 'WorkerConfigurationRevisionSummary$creationTime' => '<p>The time that a worker configuration revision was created.</p>', 'WorkerConfigurationSummary$creationTime' => '<p>The time that a worker configuration was created.</p>', ], ], ],];
