<?php
// This file was auto-generated from sdk-root/src/data/billingconductor/2021-07-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services Billing Conductor is a fully managed service that you can use to customize a <a href="https://docs.aws.amazon.com/enterprisebilling/6b7c01c5-b592-467e-9769-90052eaf359c/userguide/understanding-eb.html#eb-other-definitions">pro forma</a> version of your billing data each month, to accurately show or chargeback your end customers. Amazon Web Services Billing Conductor doesn\'t change the way you\'re billed by Amazon Web Services each month by design. Instead, it provides you with a mechanism to configure, generate, and display rates to certain customers over a given billing period. You can also analyze the difference between the rates you apply to your accounting groupings relative to your actual rates from Amazon Web Services. As a result of your Amazon Web Services Billing Conductor configuration, the payer account can also see the custom rate applied on the billing details page of the <a href="https://console.aws.amazon.com/billing">Amazon Web Services Billing console</a>, or configure a cost and usage report per billing group.</p> <p>This documentation shows how you can configure Amazon Web Services Billing Conductor using its API. For more information about using the <a href="https://console.aws.amazon.com/enterprisebilling/">Amazon Web Services Billing Conductor</a> user interface, see the <a href="https://docs.aws.amazon.com/enterprisebilling/6b7c01c5-b592-467e-9769-90052eaf359c/userguide/what-is-enterprisebilling.html"> Amazon Web Services Enterprise Billing Console User Guide</a>.</p>', 'operations' => [ 'AssociateAccounts' => '<p>Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs must be a part of the consolidated billing family during the current month, and not already associated with another billing group. The maximum number of accounts that can be associated in one call is 30. </p>', 'AssociatePricingRules' => '<p>Connects an array of <code>PricingRuleArns</code> to a defined <code>PricingPlan</code>. The maximum number <code>PricingRuleArn</code> that can be associated in one call is 30. </p>', 'BatchAssociateResourcesToCustomLineItem' => '<p> Associates a batch of resources to a percentage custom line item. </p>', 'BatchDisassociateResourcesFromCustomLineItem' => '<p> Disassociates a batch of resources from a percentage custom line item. </p>', 'CreateBillingGroup' => '<p> Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off of the predefined pricing plan computation. </p>', 'CreateCustomLineItem' => '<p> Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount. </p>', 'CreatePricingPlan' => '<p>Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups. </p>', 'CreatePricingRule' => '<p> Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans. </p>', 'DeleteBillingGroup' => '<p> Deletes a billing group. </p>', 'DeleteCustomLineItem' => '<p> Deletes the custom line item identified by the given ARN in the current, or previous billing period. </p>', 'DeletePricingPlan' => '<p>Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.</p>', 'DeletePricingRule' => '<p> Deletes the pricing rule identified by the input Amazon Resource Name (ARN). </p>', 'DisassociateAccounts' => '<p>Removes the specified list of account IDs from the given billing group. </p>', 'DisassociatePricingRules' => '<p> Disassociates a list of pricing rules from a pricing plan. </p>', 'ListAccountAssociations' => '<p> <i> <b>Amazon Web Services Billing Conductor is in beta release and is subject to change. Your use of Amazon Web Services Billing Conductor is subject to the Beta Service Participation terms of the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i> </p> <p> This is a paginated call to list linked accounts that are linked to the payer account for the specified time period. If no information is provided, the current billing period is used. The response will optionally include the billing group associated with the linked account.</p>', 'ListBillingGroupCostReports' => '<p>A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web Services charges based on the associated pricing plan of a billing group.</p>', 'ListBillingGroups' => '<p>A paginated call to retrieve a list of billing groups for the given billing period. If you don\'t provide a billing group, the current billing period is used.</p>', 'ListCustomLineItems' => '<p> A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don\'t provide a billing period, the current billing period is used. </p>', 'ListPricingPlans' => '<p>A paginated call to get pricing plans for the given billing period. If you don\'t provide a billing period, the current billing period is used. </p>', 'ListPricingPlansAssociatedWithPricingRule' => '<p> A list of the pricing plans associated with a pricing rule. </p>', 'ListPricingRules' => '<p> Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans. </p>', 'ListPricingRulesAssociatedToPricingPlan' => '<p> Lists the pricing rules associated with a pricing plan. </p>', 'ListResourcesAssociatedToCustomLineItem' => '<p> List the resources associated to a custom line item. </p>', 'ListTagsForResource' => '<p> A list the tags for a resource. </p>', 'TagResource' => '<p> Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource are not specified in the request parameters, they are not changed. </p>', 'UntagResource' => '<p> Deletes specified tags from a resource. </p>', 'UpdateBillingGroup' => '<p>This updates an existing billing group. </p>', 'UpdateCustomLineItem' => '<p> Update an existing custom line item in the current or previous billing period. </p>', 'UpdatePricingPlan' => '<p>This updates an existing pricing plan. </p>', 'UpdatePricingRule' => '<p> Updates an existing pricing rule. </p>', ], 'shapes' => [ 'AWSCost' => [ 'base' => NULL, 'refs' => [ 'BillingGroupCostReportElement$AWSCost' => '<p>The actual Amazon Web Services charges for the billing group. </p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action. </p>', 'refs' => [], ], 'AccountAssociationsList' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssociationsOutput$LinkedAccounts' => '<p> The list of linked accounts in the payer account. </p>', ], ], 'AccountAssociationsListElement' => [ 'base' => '<p> <i> <b>Amazon Web Services Billing Conductor is in beta release and is subject to change. Your use of Amazon Web Services Billing Conductor is subject to the Beta Service Participation terms of the <a href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i> </p> <p> A representation of a linked account. </p>', 'refs' => [ 'AccountAssociationsList$member' => NULL, ], ], 'AccountEmail' => [ 'base' => NULL, 'refs' => [ 'AccountAssociationsListElement$AccountEmail' => '<p> The Amazon Web Services account email. </p>', ], ], 'AccountGrouping' => [ 'base' => '<p> The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family. </p>', 'refs' => [ 'CreateBillingGroupInput$AccountGrouping' => '<p> The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family. </p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountAssociationsListElement$AccountId' => '<p> The associating array of account IDs. </p>', 'AccountIdList$member' => NULL, 'BillingGroupListElement$PrimaryAccountId' => '<p>The account ID that serves as the main account in a billing group. </p>', 'CreateBillingGroupInput$PrimaryAccountId' => '<p> The account ID that serves as the main account in a billing group. </p>', 'ListAccountAssociationsFilter$AccountId' => '<p> The Amazon Web Services account ID to filter on. </p>', 'UpdateBillingGroupOutput$PrimaryAccountId' => '<p> The account ID that serves as the main account in a billing group. </p>', ], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'AccountGrouping$LinkedAccountIds' => '<p> The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing family, and not associated with another billing group. </p>', 'AssociateAccountsInput$AccountIds' => '<p> The associating array of account IDs. </p>', 'DisassociateAccountsInput$AccountIds' => '<p>The array of account IDs to disassociate. </p>', ], ], 'AccountName' => [ 'base' => NULL, 'refs' => [ 'AccountAssociationsListElement$AccountName' => '<p> The Amazon Web Services account name. </p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) that identifies the resource to list the tags. </p>', 'TagResourceRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the resource to which to add tags. </p>', 'UntagResourceRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the resource to which to delete tags. </p>', ], ], 'AssociateAccountsInput' => [ 'base' => NULL, 'refs' => [], ], 'AssociateAccountsOutput' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePricingRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePricingRulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResourceError' => [ 'base' => '<p> A representation of a resource association error. </p>', 'refs' => [ 'AssociateResourceResponseElement$Error' => '<p> An <code>AssociateResourceError</code> that will populate if the resource association fails. </p>', 'DisassociateResourceResponseElement$Error' => '<p> An <code>AssociateResourceError</code> shown if the resource disassociation fails. </p>', ], ], 'AssociateResourceErrorReason' => [ 'base' => NULL, 'refs' => [ 'AssociateResourceError$Reason' => '<p> A static error code that used to classify the type of failure. </p>', ], ], 'AssociateResourceResponseElement' => [ 'base' => '<p> A resource association result for a percentage custom line item. </p>', 'refs' => [ 'AssociateResourcesResponseList$member' => NULL, ], ], 'AssociateResourcesResponseList' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateResourcesToCustomLineItemOutput$SuccessfullyAssociatedResources' => '<p> A list of <code>AssociateResourceResponseElement</code> for each resource that\'s been associated to a percentage custom line item successfully. </p>', 'BatchAssociateResourcesToCustomLineItemOutput$FailedAssociatedResources' => '<p> A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a percentage custom line item. </p>', ], ], 'Association' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssociationsFilter$Association' => '<p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p> <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p> <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn. </p>', ], ], 'BatchAssociateResourcesToCustomLineItemInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchAssociateResourcesToCustomLineItemOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateResourcesFromCustomLineItemInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateResourcesFromCustomLineItemOutput' => [ 'base' => NULL, 'refs' => [], ], 'BillingGroupArn' => [ 'base' => NULL, 'refs' => [ 'AccountAssociationsListElement$BillingGroupArn' => '<p> The Billing Group Arn that the linked account is associated to. </p>', 'AssociateAccountsInput$Arn' => '<p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>', 'AssociateAccountsOutput$Arn' => '<p> The Amazon Resource Name (ARN) of the billing group that associates the array of account IDs. </p>', 'BillingGroupArnList$member' => NULL, 'BillingGroupCostReportElement$Arn' => '<p>The Amazon Resource Name (ARN) of a billing group. </p>', 'BillingGroupListElement$Arn' => '<p>The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group. </p>', 'CreateBillingGroupOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the created billing group. </p>', 'CreateCustomLineItemInput$BillingGroupArn' => '<p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>', 'CustomLineItemListElement$BillingGroupArn' => '<p> The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. </p>', 'DeleteBillingGroupInput$Arn' => '<p>The Amazon Resource Name (ARN) of the billing group you\'re deleting.</p>', 'DeleteBillingGroupOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the deleted billing group.</p>', 'DisassociateAccountsInput$Arn' => '<p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs will disassociate from. </p>', 'DisassociateAccountsOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the billing group that the array of account IDs is disassociated from. </p>', 'UpdateBillingGroupInput$Arn' => '<p>The Amazon Resource Name (ARN) of the billing group being updated. </p>', 'UpdateBillingGroupOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the billing group that was updated. </p>', ], ], 'BillingGroupArnList' => [ 'base' => NULL, 'refs' => [ 'ListBillingGroupCostReportsFilter$BillingGroupArns' => '<p>The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports. </p>', 'ListBillingGroupsFilter$Arns' => '<p>The list of billing group Amazon Resource Names (ARNs) to retrieve information. </p>', 'ListCustomLineItemsFilter$BillingGroups' => '<p> The billing group Amazon Resource Names (ARNs) to retrieve information. </p>', ], ], 'BillingGroupCostReportElement' => [ 'base' => '<p>A summary report of actual Amazon Web Services charges and calculated Amazon Web Services charges, based on the associated pricing plan of a billing group. </p>', 'refs' => [ 'BillingGroupCostReportList$member' => NULL, ], ], 'BillingGroupCostReportList' => [ 'base' => NULL, 'refs' => [ 'ListBillingGroupCostReportsOutput$BillingGroupCostReports' => '<p>A list of <code>BillingGroupCostReportElement</code> retrieved. </p>', ], ], 'BillingGroupDescription' => [ 'base' => NULL, 'refs' => [ 'BillingGroupListElement$Description' => '<p>The billing group description. </p>', 'CreateBillingGroupInput$Description' => '<p>The billing group description. </p>', 'UpdateBillingGroupInput$Description' => '<p>A description of the billing group. </p>', 'UpdateBillingGroupOutput$Description' => '<p> A description of the billing group. </p>', ], ], 'BillingGroupFullArn' => [ 'base' => NULL, 'refs' => [ 'UpdateCustomLineItemOutput$BillingGroupArn' => '<p> The ARN of the billing group that the custom line item is applied to. </p>', ], ], 'BillingGroupList' => [ 'base' => NULL, 'refs' => [ 'ListBillingGroupsOutput$BillingGroups' => '<p>A list of <code>BillingGroupListElement</code> retrieved. </p>', ], ], 'BillingGroupListElement' => [ 'base' => '<p>A representation of a billing group. </p>', 'refs' => [ 'BillingGroupList$member' => NULL, ], ], 'BillingGroupName' => [ 'base' => NULL, 'refs' => [ 'BillingGroupListElement$Name' => '<p>The billing group\'s name. </p>', 'CreateBillingGroupInput$Name' => '<p> The billing group name. The names must be unique. </p>', 'UpdateBillingGroupInput$Name' => '<p>The name of the billing group. The names must be unique to each billing group. </p>', 'UpdateBillingGroupOutput$Name' => '<p> The name of the billing group. The names must be unique to each billing group. </p>', 'UpdateCustomLineItemInput$Name' => '<p> The new name for the custom line item. </p>', ], ], 'BillingGroupStatus' => [ 'base' => NULL, 'refs' => [ 'BillingGroupListElement$Status' => '<p>The billing group status. Only one of the valid values can be used. </p>', 'UpdateBillingGroupInput$Status' => '<p>The status of the billing group. Only one of the valid values can be used. </p>', 'UpdateBillingGroupOutput$Status' => '<p> The status of the billing group. Only one of the valid values can be used. </p>', ], ], 'BillingGroupStatusReason' => [ 'base' => NULL, 'refs' => [ 'BillingGroupListElement$StatusReason' => '<p>The reason why the billing group is in its current status. </p>', 'UpdateBillingGroupOutput$StatusReason' => '<p> The reason why the billing group is in its current status. </p>', ], ], 'BillingPeriod' => [ 'base' => NULL, 'refs' => [ 'CustomLineItemBillingPeriodRange$InclusiveStartBillingPeriod' => '<p> The inclusive start billing period that defines a billing period range where a custom line is applied. </p>', 'CustomLineItemBillingPeriodRange$ExclusiveEndBillingPeriod' => '<p> The inclusive end billing period that defines a billing period range where a custom line is applied. </p>', 'ListAccountAssociationsInput$BillingPeriod' => '<p> The preferred billing period to get account associations. </p>', 'ListBillingGroupCostReportsInput$BillingPeriod' => '<p>The preferred billing period for your report. </p>', 'ListBillingGroupsInput$BillingPeriod' => '<p>The preferred billing period to get billing groups. </p>', 'ListCustomLineItemsInput$BillingPeriod' => '<p> The preferred billing period to get custom line items (FFLIs). </p>', 'ListPricingPlansAssociatedWithPricingRuleInput$BillingPeriod' => '<p> The pricing plan billing period for which associations will be listed. </p>', 'ListPricingPlansAssociatedWithPricingRuleOutput$BillingPeriod' => '<p> The pricing plan billing period for which associations will be listed. </p>', 'ListPricingPlansInput$BillingPeriod' => '<p>The preferred billing period to get pricing plan. </p>', 'ListPricingPlansOutput$BillingPeriod' => '<p> The billing period for which the described pricing plans are applicable. </p>', 'ListPricingRulesAssociatedToPricingPlanInput$BillingPeriod' => '<p> The billing period for which the pricing rule associations are to be listed. </p>', 'ListPricingRulesAssociatedToPricingPlanOutput$BillingPeriod' => '<p> The billing period for which the pricing rule associations are listed. </p>', 'ListPricingRulesInput$BillingPeriod' => '<p> The preferred billing period to get the pricing plan. </p>', 'ListPricingRulesOutput$BillingPeriod' => '<p> The billing period for which the described pricing rules are applicable. </p>', 'ListResourcesAssociatedToCustomLineItemInput$BillingPeriod' => '<p> The billing period for which the resource associations will be listed. </p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateBillingGroupInput$ClientToken' => '<p> The token that is needed to support idempotency. Idempotency isn\'t currently supported, but will be implemented in a future update. </p>', 'CreateCustomLineItemInput$ClientToken' => '<p> The token that is needed to support idempotency. Idempotency isn\'t currently supported, but will be implemented in a future update. </p>', 'CreatePricingPlanInput$ClientToken' => '<p> The token that is needed to support idempotency. Idempotency isn\'t currently supported, but will be implemented in a future update. </p>', 'CreatePricingRuleInput$ClientToken' => '<p> The token that is needed to support idempotency. Idempotency isn\'t currently supported, but will be implemented in a future update. </p>', ], ], 'ComputationPreference' => [ 'base' => '<p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>', 'refs' => [ 'BillingGroupListElement$ComputationPreference' => NULL, 'CreateBillingGroupInput$ComputationPreference' => '<p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>', 'UpdateBillingGroupInput$ComputationPreference' => '<p> The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group. </p>', ], ], 'ConflictException' => [ 'base' => '<p>You can cause an inconsistent state by updating or deleting a resource. </p>', 'refs' => [], ], 'CreateBillingGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBillingGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomLineItemInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomLineItemOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePricingPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePricingPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePricingRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePricingRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'Currency' => [ 'base' => NULL, 'refs' => [ 'BillingGroupCostReportElement$Currency' => '<p>The displayed currency. </p>', ], ], 'CurrencyCode' => [ 'base' => NULL, 'refs' => [ 'CustomLineItemListElement$CurrencyCode' => '<p> The custom line item\'s charge value currency. Only one of the valid values can be used. </p>', ], ], 'CustomLineItemArn' => [ 'base' => NULL, 'refs' => [ 'AssociateResourceResponseElement$Arn' => '<p> The resource ARN that was associated to the custom line item. </p>', 'BatchAssociateResourcesToCustomLineItemInput$TargetArn' => '<p> A percentage custom line item ARN to associate the resources to. </p>', 'BatchDisassociateResourcesFromCustomLineItemInput$TargetArn' => '<p> A percentage custom line item ARN to disassociate the resources from. </p>', 'CreateCustomLineItemOutput$Arn' => '<p> The Amazon Resource Name (ARN) of the created custom line item. </p>', 'CustomLineItemArns$member' => NULL, 'CustomLineItemListElement$Arn' => '<p> The Amazon Resource Names (ARNs) for custom line items. </p>', 'DeleteCustomLineItemInput$Arn' => '<p> The ARN of the custom line item to be deleted. </p>', 'DeleteCustomLineItemOutput$Arn' => '<p> Then ARN of the deleted custom line item. </p>', 'DisassociateResourceResponseElement$Arn' => '<p> The resource ARN that was disassociated from the custom line item. </p>', 'ListResourcesAssociatedToCustomLineItemInput$Arn' => '<p> The ARN of the custom line item for which the resource associations will be listed. </p>', 'ListResourcesAssociatedToCustomLineItemOutput$Arn' => '<p> The custom line item ARN for which the resource associations are listed. </p>', 'UpdateCustomLineItemInput$Arn' => '<p> The ARN of the custom line item to be updated. </p>', 'UpdateCustomLineItemOutput$Arn' => '<p> The ARN of the successfully updated custom line item. </p>', ], ], 'CustomLineItemArns' => [ 'base' => NULL, 'refs' => [ 'ListCustomLineItemsFilter$Arns' => '<p> A list of custom line item ARNs to retrieve information. </p>', ], ], 'CustomLineItemAssociationElement' => [ 'base' => NULL, 'refs' => [ 'CustomLineItemAssociationsList$member' => NULL, 'CustomLineItemBatchAssociationsList$member' => NULL, 'CustomLineItemBatchDisassociationsList$member' => NULL, 'ListResourcesAssociatedToCustomLineItemResponseElement$Arn' => '<p> The ARN of the associated resource. </p>', ], ], 'CustomLineItemAssociationsList' => [ 'base' => NULL, 'refs' => [ 'CustomLineItemPercentageChargeDetails$AssociatedValues' => '<p> A list of resource ARNs to associate to the percentage custom line item. </p>', ], ], 'CustomLineItemBatchAssociationsList' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateResourcesToCustomLineItemInput$ResourceArns' => '<p> A list containing the ARNs of the resources to be associated. </p>', ], ], 'CustomLineItemBatchDisassociationsList' => [ 'base' => NULL, 'refs' => [ 'BatchDisassociateResourcesFromCustomLineItemInput$ResourceArns' => '<p> A list containing the ARNs of resources to be disassociated. </p>', ], ], 'CustomLineItemBillingPeriodRange' => [ 'base' => '<p> The billing period range in which the custom line item request will be applied. </p>', 'refs' => [ 'BatchAssociateResourcesToCustomLineItemInput$BillingPeriodRange' => NULL, 'BatchDisassociateResourcesFromCustomLineItemInput$BillingPeriodRange' => NULL, 'CreateCustomLineItemInput$BillingPeriodRange' => '<p> A time range for which the custom line item is effective. </p>', 'DeleteCustomLineItemInput$BillingPeriodRange' => NULL, 'UpdateCustomLineItemInput$BillingPeriodRange' => NULL, ], ], 'CustomLineItemChargeDetails' => [ 'base' => '<p> The charge details of a custom line item. It should contain only one of <code>Flat</code> or <code>Percentage</code>. </p>', 'refs' => [ 'CreateCustomLineItemInput$ChargeDetails' => '<p> A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item. </p>', ], ], 'CustomLineItemChargeValue' => [ 'base' => NULL, 'refs' => [ 'CustomLineItemFlatChargeDetails$ChargeValue' => '<p> The custom line item\'s fixed charge value in USD. </p>', 'ListCustomLineItemFlatChargeDetails$ChargeValue' => '<p> The custom line item\'s fixed charge value in USD. </p>', 'UpdateCustomLineItemFlatChargeDetails$ChargeValue' => '<p> The custom line item\'s new fixed charge value in USD. </p>', ], ], 'CustomLineItemDescription' => [ 'base' => NULL, 'refs' => [ 'CreateCustomLineItemInput$Description' => '<p> The description of the custom line item. This is shown on the Bills page in association with the charge value. </p>', 'CustomLineItemListElement$Description' => '<p> The custom line item\'s description. This is shown on the Bills page in association with the charge value. </p>', 'UpdateCustomLineItemInput$Description' => '<p> The new line item description of the custom line item. </p>', 'UpdateCustomLineItemOutput$Description' => '<p> The description of the successfully updated custom line item. </p>', ], ], 'CustomLineItemFlatChargeDetails' => [ 'base' => '<p> A representation of the charge details associated with a flat custom line item. </p>', 'refs' => [ 'CustomLineItemChargeDetails$Flat' => '<p> A <code>CustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item. </p>', ], ], 'CustomLineItemList' => [ 'base' => NULL, 'refs' => [ 'ListCustomLineItemsOutput$CustomLineItems' => '<p> A list of <code>FreeFormLineItemListElements</code> received. </p>', ], ], 'CustomLineItemListElement' => [ 'base' => '<p> A representation of a custom line item. </p>', 'refs' => [ 'CustomLineItemList$member' => NULL, ], ], 'CustomLineItemName' => [ 'base' => NULL, 'refs' => [ 'CreateCustomLineItemInput$Name' => '<p> The name of the custom line item. </p>', 'CustomLineItemListElement$Name' => '<p> The custom line item\'s name. </p>', 'CustomLineItemNameList$member' => NULL, 'UpdateCustomLineItemOutput$Name' => '<p> The name of the successfully updated custom line item. </p>', ], ], 'CustomLineItemNameList' => [ 'base' => NULL, 'refs' => [ 'ListCustomLineItemsFilter$Names' => '<p> A list of custom line items to retrieve information. </p>', ], ], 'CustomLineItemPercentageChargeDetails' => [ 'base' => '<p> A representation of the charge details associated with a percentage custom line item. </p>', 'refs' => [ 'CustomLineItemChargeDetails$Percentage' => '<p> A <code>CustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom line item. </p>', ], ], 'CustomLineItemPercentageChargeValue' => [ 'base' => NULL, 'refs' => [ 'CustomLineItemPercentageChargeDetails$PercentageValue' => '<p> The custom line item\'s percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>', 'ListCustomLineItemPercentageChargeDetails$PercentageValue' => '<p> The custom line item\'s percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>', 'UpdateCustomLineItemPercentageChargeDetails$PercentageValue' => '<p> The custom line item\'s new percentage value. This will be multiplied against the combined value of its associated resources to determine its charge value. </p>', ], ], 'CustomLineItemProductCode' => [ 'base' => NULL, 'refs' => [ 'CustomLineItemListElement$ProductCode' => '<p> The product code associated with the custom line item. </p>', ], ], 'CustomLineItemRelationship' => [ 'base' => NULL, 'refs' => [ 'ListResourcesAssociatedToCustomLineItemFilter$Relationship' => '<p> The type of relationship between the custom line item and the associated resource. </p>', 'ListResourcesAssociatedToCustomLineItemResponseElement$Relationship' => '<p> The type of relationship between the custom line item and the associated resource. </p>', ], ], 'CustomLineItemType' => [ 'base' => NULL, 'refs' => [ 'CustomLineItemChargeDetails$Type' => '<p> The type of the custom line item that indicates whether the charge is a fee or credit. </p>', 'ListCustomLineItemChargeDetails$Type' => '<p> The type of the custom line item that indicates whether the charge is a <code>fee</code> or <code>credit</code>. </p>', ], ], 'DeleteBillingGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBillingGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomLineItemInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomLineItemOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePricingPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePricingPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePricingRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePricingRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAccountsInput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAccountsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePricingRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePricingRulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResourceResponseElement' => [ 'base' => '<p> A resource disassociation result for a percentage custom line item. </p>', 'refs' => [ 'DisassociateResourcesResponseList$member' => NULL, ], ], 'DisassociateResourcesResponseList' => [ 'base' => NULL, 'refs' => [ 'BatchDisassociateResourcesFromCustomLineItemOutput$SuccessfullyDisassociatedResources' => '<p> A list of <code>DisassociateResourceResponseElement</code> for each resource that\'s been disassociated from a percentage custom line item successfully. </p>', 'BatchDisassociateResourcesFromCustomLineItemOutput$FailedDisassociatedResources' => '<p> A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation from a percentage custom line item. </p>', ], ], 'Instant' => [ 'base' => NULL, 'refs' => [ 'BillingGroupListElement$CreationTime' => '<p> The time the billing group was created. </p>', 'BillingGroupListElement$LastModifiedTime' => '<p> The most recent time the billing group was modified. </p>', 'CustomLineItemListElement$CreationTime' => '<p> The time created. </p>', 'CustomLineItemListElement$LastModifiedTime' => '<p> The most recent time the custom line item was modified. </p>', 'PricingPlanListElement$CreationTime' => '<p> The time the pricing plan was created. </p>', 'PricingPlanListElement$LastModifiedTime' => '<p> The most recent time the pricing plan was modified. </p>', 'PricingRuleListElement$CreationTime' => '<p> The time the pricing rule was created. </p>', 'PricingRuleListElement$LastModifiedTime' => '<p> The most recent time the pricing rule was modified. </p>', 'UpdateBillingGroupOutput$LastModifiedTime' => '<p> The most recent time the billing group was modified. </p>', 'UpdateCustomLineItemOutput$LastModifiedTime' => '<p> The most recent time the custom line item was modified. </p>', 'UpdatePricingPlanOutput$LastModifiedTime' => '<p> The most recent time the pricing plan was modified. </p>', 'UpdatePricingRuleOutput$LastModifiedTime' => '<p> The most recent time the pricing rule was modified. </p>', ], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error occurred while processing a request. </p>', 'refs' => [], ], 'ListAccountAssociationsFilter' => [ 'base' => '<p>The filter on the account ID of the linked account, or any of the following:</p> <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p> <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p> <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided Billing Group Arn. </p>', 'refs' => [ 'ListAccountAssociationsInput$Filters' => '<p>The filter on the account ID of the linked account, or any of the following:</p> <p> <code>MONITORED</code>: linked accounts that are associated to billing groups.</p> <p> <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.</p> <p> <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn. </p>', ], ], 'ListAccountAssociationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssociationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBillingGroupCostReportsFilter' => [ 'base' => '<p>The filter used to retrieve specific <code>BillingGroupCostReportElements</code>. </p>', 'refs' => [ 'ListBillingGroupCostReportsInput$Filters' => '<p>A <code>ListBillingGroupCostReportsFilter</code> to specify billing groups to retrieve reports from. </p>', ], ], 'ListBillingGroupCostReportsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBillingGroupCostReportsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBillingGroupsFilter' => [ 'base' => '<p>The filter that specifies the billing groups and pricing plans to retrieve billing group information. </p>', 'refs' => [ 'ListBillingGroupsInput$Filters' => '<p>A <code>ListBillingGroupsFilter</code> that specifies the billing group and pricing plan to retrieve billing group information. </p>', ], ], 'ListBillingGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBillingGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomLineItemChargeDetails' => [ 'base' => '<p> A representation of the charge details of a custom line item. </p>', 'refs' => [ 'CustomLineItemListElement$ChargeDetails' => '<p> A <code>ListCustomLineItemChargeDetails</code> that describes the charge details of a custom line item. </p>', 'UpdateCustomLineItemOutput$ChargeDetails' => '<p> A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully updated custom line item. </p>', ], ], 'ListCustomLineItemFlatChargeDetails' => [ 'base' => '<p> A representation of the charge details associated with a flat custom line item. </p>', 'refs' => [ 'ListCustomLineItemChargeDetails$Flat' => '<p> A <code>ListCustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item. </p>', ], ], 'ListCustomLineItemPercentageChargeDetails' => [ 'base' => '<p> A representation of the charge details associated with a percentage custom line item. </p>', 'refs' => [ 'ListCustomLineItemChargeDetails$Percentage' => '<p> A <code>ListCustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom line item. </p>', ], ], 'ListCustomLineItemsFilter' => [ 'base' => '<p> A filter that specifies the custom line items and billing groups to retrieve FFLI information. </p>', 'refs' => [ 'ListCustomLineItemsInput$Filters' => '<p>A <code>ListCustomLineItemsFilter</code> that specifies the custom line item names and/or billing group Amazon Resource Names (ARNs) to retrieve FFLI information.</p>', ], ], 'ListCustomLineItemsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomLineItemsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPricingPlansAssociatedWithPricingRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPricingPlansAssociatedWithPricingRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPricingPlansFilter' => [ 'base' => '<p>The filter that specifies the Amazon Resource Names (ARNs) of pricing plans, to retrieve pricing plan information. </p>', 'refs' => [ 'ListPricingPlansInput$Filters' => '<p>A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to retrieve pricing plans information.</p>', ], ], 'ListPricingPlansInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPricingPlansOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPricingRulesAssociatedToPricingPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPricingRulesAssociatedToPricingPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPricingRulesFilter' => [ 'base' => '<p> The filter that specifies criteria that the pricing rules returned by the <code>ListPricingRules</code> API will adhere to. </p>', 'refs' => [ 'ListPricingRulesInput$Filters' => '<p> A <code>DescribePricingRuleFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing rules to retrieve pricing rules information. </p>', ], ], 'ListPricingRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPricingRulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesAssociatedToCustomLineItemFilter' => [ 'base' => '<p> A filter that specifies the type of resource associations that should be retrieved for a custom line item. </p>', 'refs' => [ 'ListResourcesAssociatedToCustomLineItemInput$Filters' => '<p> (Optional) A <code>ListResourcesAssociatedToCustomLineItemFilter</code> that can specify the types of resources that should be retrieved. </p>', ], ], 'ListResourcesAssociatedToCustomLineItemInput' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesAssociatedToCustomLineItemOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesAssociatedToCustomLineItemResponseElement' => [ 'base' => '<p> A representation of a resource association for a custom line item. </p>', 'refs' => [ 'ListResourcesAssociatedToCustomLineItemResponseList$member' => NULL, ], ], 'ListResourcesAssociatedToCustomLineItemResponseList' => [ 'base' => NULL, 'refs' => [ 'ListResourcesAssociatedToCustomLineItemOutput$AssociatedResources' => '<p> A list of <code>ListResourcesAssociatedToCustomLineItemResponseElement</code> for each resource association retrieved. </p>', ], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Margin' => [ 'base' => NULL, 'refs' => [ 'BillingGroupCostReportElement$Margin' => '<p> The billing group margin. </p>', ], ], 'MarginPercentage' => [ 'base' => NULL, 'refs' => [ 'BillingGroupCostReportElement$MarginPercentage' => '<p> The percentage of billing group margin. </p>', ], ], 'MaxBillingGroupResults' => [ 'base' => NULL, 'refs' => [ 'ListBillingGroupCostReportsInput$MaxResults' => '<p>The maximum number of reports to retrieve. </p>', 'ListBillingGroupsInput$MaxResults' => '<p>The maximum number of billing groups to retrieve. </p>', 'ListCustomLineItemsInput$MaxResults' => '<p> The maximum number of billing groups to retrieve. </p>', ], ], 'MaxCustomLineItemResults' => [ 'base' => NULL, 'refs' => [ 'ListResourcesAssociatedToCustomLineItemInput$MaxResults' => '<p> (Optional) The maximum number of resource associations to be retrieved. </p>', ], ], 'MaxPricingPlanResults' => [ 'base' => NULL, 'refs' => [ 'ListPricingPlansInput$MaxResults' => '<p>The maximum number of pricing plans to retrieve.</p>', 'ListPricingRulesAssociatedToPricingPlanInput$MaxResults' => '<p>The optional maximum number of pricing rule associations to retrieve.</p>', ], ], 'MaxPricingRuleResults' => [ 'base' => NULL, 'refs' => [ 'ListPricingPlansAssociatedWithPricingRuleInput$MaxResults' => '<p> The optional maximum number of pricing rule associations to retrieve. </p>', 'ListPricingRulesInput$MaxResults' => '<p> The maximum number of pricing rules to retrieve. </p>', ], ], 'ModifierPercentage' => [ 'base' => NULL, 'refs' => [ 'CreatePricingRuleInput$ModifierPercentage' => '<p> A percentage modifier applied on the public pricing rates. </p>', 'PricingRuleListElement$ModifierPercentage' => '<p> A percentage modifier applied on the public pricing rates. </p>', 'UpdatePricingRuleInput$ModifierPercentage' => '<p> The new modifier to show pricing plan rates as a percentage. </p>', 'UpdatePricingRuleOutput$ModifierPercentage' => '<p> The new modifier to show pricing plan rates as a percentage. </p>', ], ], 'NumberOfAccounts' => [ 'base' => NULL, 'refs' => [ 'BillingGroupListElement$Size' => '<p>The number of accounts in the particular billing group. </p>', 'UpdateBillingGroupOutput$Size' => '<p> The number of accounts in the particular billing group. </p>', ], ], 'NumberOfAssociatedPricingRules' => [ 'base' => NULL, 'refs' => [ 'PricingPlanListElement$Size' => '<p> The pricing rules count currently associated with this pricing plan list element. </p>', 'UpdatePricingPlanOutput$Size' => '<p> The pricing rules count currently associated with this pricing plan list. </p>', ], ], 'NumberOfAssociations' => [ 'base' => NULL, 'refs' => [ 'CustomLineItemListElement$AssociationSize' => '<p> The number of resources that are associated to the custom line item. </p>', 'UpdateCustomLineItemOutput$AssociationSize' => '<p> The number of resources that are associated to the custom line item. </p>', ], ], 'NumberOfPricingPlansAssociatedWith' => [ 'base' => NULL, 'refs' => [ 'PricingRuleListElement$AssociatedPricingPlanCount' => '<p> The pricing plans count that this pricing rule is associated with. </p>', 'UpdatePricingRuleOutput$AssociatedPricingPlanCount' => '<p> The pricing plans count that this pricing rule is associated with. </p>', ], ], 'PricingPlanArn' => [ 'base' => NULL, 'refs' => [ 'AssociatePricingRulesInput$Arn' => '<p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>', 'AssociatePricingRulesOutput$Arn' => '<p> The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with. </p>', 'CreatePricingPlanOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the created pricing plan.</p>', 'DeletePricingPlanInput$Arn' => '<p>The Amazon Resource Name (ARN) of the pricing plan you\'re deleting. </p>', 'DeletePricingPlanOutput$Arn' => '<p> The Amazon Resource Name (ARN) of the deleted pricing plan. </p>', 'DisassociatePricingRulesInput$Arn' => '<p> The pricing plan Amazon Resource Name (ARN) to disassociate pricing rules from. </p>', 'DisassociatePricingRulesOutput$Arn' => '<p> The Amazon Resource Name (ARN) of the pricing plan that the pricing rules successfully disassociated from. </p>', 'ListPricingRulesAssociatedToPricingPlanInput$PricingPlanArn' => '<p> The Amazon Resource Name (ARN) of the pricing plan for which associations are to be listed.</p>', 'ListPricingRulesAssociatedToPricingPlanOutput$PricingPlanArn' => '<p> The Amazon Resource Name (ARN) of the pricing plan for which associations are listed.</p>', 'PricingPlanArns$member' => NULL, 'PricingPlanListElement$Arn' => '<p>The pricing plan Amazon Resource Names (ARN). This can be used to uniquely identify a pricing plan. </p>', 'UpdateBillingGroupOutput$PricingPlanArn' => '<p> The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web Services charges for the billing group. </p>', 'UpdatePricingPlanInput$Arn' => '<p>The Amazon Resource Name (ARN) of the pricing plan you\'re updating. </p>', 'UpdatePricingPlanOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the updated pricing plan. </p>', ], ], 'PricingPlanArns' => [ 'base' => NULL, 'refs' => [ 'ListPricingPlansAssociatedWithPricingRuleOutput$PricingPlanArns' => '<p> The list containing pricing plans associated with the requested pricing rule. </p>', 'ListPricingPlansFilter$Arns' => '<p>A list of pricing plan Amazon Resource Names (ARNs) to retrieve information. </p>', ], ], 'PricingPlanDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePricingPlanInput$Description' => '<p>The pricing plan description. </p>', 'PricingPlanListElement$Description' => '<p>The pricing plan description. </p>', 'UpdatePricingPlanInput$Description' => '<p>The pricing plan description. </p>', 'UpdatePricingPlanOutput$Description' => '<p> The new description for the pricing rule. </p>', ], ], 'PricingPlanFullArn' => [ 'base' => NULL, 'refs' => [ 'ComputationPreference$PricingPlanArn' => '<p> The Amazon Resource Name (ARN) of the pricing plan used to compute the Amazon Web Services charges for a billing group. </p>', 'ListBillingGroupsFilter$PricingPlan' => '<p>The pricing plan Amazon Resource Names (ARNs) to retrieve information. </p>', ], ], 'PricingPlanList' => [ 'base' => NULL, 'refs' => [ 'ListPricingPlansOutput$PricingPlans' => '<p>A list of <code>PricingPlanListElement</code> retrieved. </p>', ], ], 'PricingPlanListElement' => [ 'base' => '<p>A representation of a pricing plan. </p>', 'refs' => [ 'PricingPlanList$member' => NULL, ], ], 'PricingPlanName' => [ 'base' => NULL, 'refs' => [ 'CreatePricingPlanInput$Name' => '<p>The pricing plan name. The names must be unique to each pricing plan. </p>', 'PricingPlanListElement$Name' => '<p>The name of a pricing plan. </p>', 'UpdatePricingPlanInput$Name' => '<p>The name of the pricing plan. The name must be unique to each pricing plan. </p>', 'UpdatePricingPlanOutput$Name' => '<p> The name of the pricing plan. The name must be unique to each pricing plan. </p>', ], ], 'PricingRuleArn' => [ 'base' => NULL, 'refs' => [ 'CreatePricingRuleOutput$Arn' => '<p> The Amazon Resource Name (ARN) of the created pricing rule. </p>', 'DeletePricingRuleInput$Arn' => '<p> The Amazon Resource Name (ARN) of the pricing rule you are deleting. </p>', 'DeletePricingRuleOutput$Arn' => '<p> The Amazon Resource Name (ARN) of the deleted pricing rule. </p>', 'ListPricingPlansAssociatedWithPricingRuleInput$PricingRuleArn' => '<p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>', 'ListPricingPlansAssociatedWithPricingRuleOutput$PricingRuleArn' => '<p> The pricing rule Amazon Resource Name (ARN) for which associations will be listed. </p>', 'PricingRuleArns$member' => NULL, 'PricingRuleArnsInput$member' => NULL, 'PricingRuleArnsNonEmptyInput$member' => NULL, 'PricingRuleListElement$Arn' => '<p> The Amazon Resource Name (ARN) used to uniquely identify a pricing rule. </p>', 'UpdatePricingRuleInput$Arn' => '<p> The Amazon Resource Name (ARN) of the pricing rule to update. </p>', 'UpdatePricingRuleOutput$Arn' => '<p> The Amazon Resource Name (ARN) of the successfully updated pricing rule. </p>', ], ], 'PricingRuleArns' => [ 'base' => NULL, 'refs' => [ 'ListPricingRulesAssociatedToPricingPlanOutput$PricingRuleArns' => '<p> A list containing pricing rules associated with the requested pricing plan. </p>', 'ListPricingRulesFilter$Arns' => '<p> A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response. </p>', ], ], 'PricingRuleArnsInput' => [ 'base' => NULL, 'refs' => [ 'CreatePricingPlanInput$PricingRuleArns' => '<p> A list of Amazon Resource Names (ARNs) that define the pricing plan parameters. </p>', ], ], 'PricingRuleArnsNonEmptyInput' => [ 'base' => NULL, 'refs' => [ 'AssociatePricingRulesInput$PricingRuleArns' => '<p> The <code>PricingRuleArns</code> that are associated with the Pricing Plan. </p>', 'DisassociatePricingRulesInput$PricingRuleArns' => '<p> A list containing the Amazon Resource Name (ARN) of the pricing rules that will be disassociated. </p>', ], ], 'PricingRuleDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePricingRuleInput$Description' => '<p> The pricing rule description. </p>', 'PricingRuleListElement$Description' => '<p> The pricing rule description. </p>', 'UpdatePricingRuleInput$Description' => '<p> The new description for the pricing rule. </p>', 'UpdatePricingRuleOutput$Description' => '<p> The new description for the pricing rule. </p>', ], ], 'PricingRuleList' => [ 'base' => NULL, 'refs' => [ 'ListPricingRulesOutput$PricingRules' => '<p> A list containing the described pricing rules. </p>', ], ], 'PricingRuleListElement' => [ 'base' => '<p> A representation of a pricing rule. </p>', 'refs' => [ 'PricingRuleList$member' => NULL, ], ], 'PricingRuleName' => [ 'base' => NULL, 'refs' => [ 'CreatePricingRuleInput$Name' => '<p> The pricing rule name. The names must be unique to each pricing rule. </p>', 'PricingRuleListElement$Name' => '<p> The name of a pricing rule. </p>', 'UpdatePricingRuleInput$Name' => '<p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>', 'UpdatePricingRuleOutput$Name' => '<p> The new name of the pricing rule. The name must be unique to each pricing rule. </p>', ], ], 'PricingRuleScope' => [ 'base' => NULL, 'refs' => [ 'CreatePricingRuleInput$Scope' => '<p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>', 'PricingRuleListElement$Scope' => '<p> The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific. </p>', 'UpdatePricingRuleOutput$Scope' => '<p> The scope of pricing rule that indicates if it is globally applicable, or is service-specific. </p>', ], ], 'PricingRuleType' => [ 'base' => NULL, 'refs' => [ 'CreatePricingRuleInput$Type' => '<p> The type of pricing rule. </p>', 'PricingRuleListElement$Type' => '<p> The type of pricing rule. </p>', 'UpdatePricingRuleInput$Type' => '<p> The new pricing rule type. </p>', 'UpdatePricingRuleOutput$Type' => '<p> The new pricing rule type. </p>', ], ], 'ProformaCost' => [ 'base' => NULL, 'refs' => [ 'BillingGroupCostReportElement$ProformaCost' => '<p>The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request references a resource that doesn\'t exist. </p>', 'refs' => [], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$RetryAfterSeconds' => '<p>Number of seconds you can retry after the call. </p>', 'ThrottlingException$RetryAfterSeconds' => '<p>Number of seconds you can safely retry after the call. </p>', ], ], 'Service' => [ 'base' => NULL, 'refs' => [ 'CreatePricingRuleInput$Service' => '<p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>', 'PricingRuleListElement$Service' => '<p> If the <code>Scope</code> attribute is <code>SERVICE</code>, this attribute indicates which service the <code>PricingRule</code> is applicable for. </p>', 'UpdatePricingRuleOutput$Service' => '<p> If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the <code>PricingRule</code> is applicable for. </p>', ], ], 'ServiceLimitExceededException' => [ 'base' => '<p>The request would cause a service limit to exceed. </p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AssociateResourceError$Message' => '<p> The reason the resource association failed. </p>', 'ConflictException$Message' => NULL, 'ConflictException$ResourceId' => '<p>Identifier of the resource in use. </p>', 'ConflictException$ResourceType' => '<p>Type of the resource in use. </p>', 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>Resource identifier that was not found. </p>', 'ResourceNotFoundException$ResourceType' => '<p>Resource type that was not found. </p>', 'ServiceLimitExceededException$Message' => NULL, 'ServiceLimitExceededException$ResourceId' => '<p>Identifier of the resource affected. </p>', 'ServiceLimitExceededException$ResourceType' => '<p>Type of the resource affected. </p>', 'ServiceLimitExceededException$LimitCode' => '<p>The unique code identifier of the service limit that is being exceeded. </p>', 'ServiceLimitExceededException$ServiceCode' => '<p>The unique code for the service of the limit that is being exceeded. </p>', 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, 'ValidationExceptionField$Name' => '<p>The field name. </p>', 'ValidationExceptionField$Message' => '<p>The message describing why the field failed validation. </p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p> The tags to delete from the resource as a list of key-value pairs. </p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateBillingGroupInput$Tags' => '<p> A map that contains tag keys and tag values that are attached to a billing group. This feature isn\'t available during the beta. </p>', 'CreateCustomLineItemInput$Tags' => '<p> A map that contains tag keys and tag values that are attached to a custom line item. </p>', 'CreatePricingPlanInput$Tags' => '<p> A map that contains tag keys and tag values that are attached to a pricing plan. </p>', 'CreatePricingRuleInput$Tags' => '<p> A map that contains tag keys and tag values that are attached to a pricing rule. </p>', 'ListTagsForResourceResponse$Tags' => '<p> The tags for the resource. </p>', 'TagResourceRequest$Tags' => '<p> The tags to add to the resource as a list of key-value pairs. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling. </p>', 'refs' => [], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssociationsInput$NextToken' => '<p> The pagination token used on subsequent calls to retrieve accounts. </p>', 'ListAccountAssociationsOutput$NextToken' => '<p> The pagination token used on subsequent calls to get accounts. </p>', 'ListBillingGroupCostReportsInput$NextToken' => '<p>The pagination token used on subsequent calls to get reports. </p>', 'ListBillingGroupCostReportsOutput$NextToken' => '<p>The pagination token used on subsequent calls to get reports. </p>', 'ListBillingGroupsInput$NextToken' => '<p>The pagination token used on subsequent calls to get billing groups. </p>', 'ListBillingGroupsOutput$NextToken' => '<p>The pagination token used on subsequent calls to get billing groups. </p>', 'ListCustomLineItemsInput$NextToken' => '<p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>', 'ListCustomLineItemsOutput$NextToken' => '<p> The pagination token used on subsequent calls to get custom line items (FFLIs). </p>', 'ListPricingPlansAssociatedWithPricingRuleInput$NextToken' => '<p> The optional pagination token returned by a previous call. </p>', 'ListPricingPlansAssociatedWithPricingRuleOutput$NextToken' => '<p> The pagination token to be used on subsequent calls. </p>', 'ListPricingPlansInput$NextToken' => '<p>The pagination token used on subsequent call to get pricing plans. </p>', 'ListPricingPlansOutput$NextToken' => '<p>The pagination token used on subsequent calls to get pricing plans. </p>', 'ListPricingRulesAssociatedToPricingPlanInput$NextToken' => '<p> The optional pagination token returned by a previous call. </p>', 'ListPricingRulesAssociatedToPricingPlanOutput$NextToken' => '<p> The pagination token to be used on subsequent calls. </p>', 'ListPricingRulesInput$NextToken' => '<p> The pagination token used on subsequent call to get pricing rules. </p>', 'ListPricingRulesOutput$NextToken' => '<p> The pagination token used on subsequent calls to get pricing rules. </p>', 'ListResourcesAssociatedToCustomLineItemInput$NextToken' => '<p> (Optional) The pagination token returned by a previous request. </p>', 'ListResourcesAssociatedToCustomLineItemOutput$NextToken' => '<p> The pagination token to be used in subsequent requests to retrieve additional results. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBillingGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBillingGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomLineItemChargeDetails' => [ 'base' => '<p> A representation of the new charge details of a custom line item. This should contain only one of <code>Flat</code> or <code>Percentage</code>. </p>', 'refs' => [ 'UpdateCustomLineItemInput$ChargeDetails' => '<p> A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item. </p>', ], ], 'UpdateCustomLineItemFlatChargeDetails' => [ 'base' => '<p> A representation of the new charge details associated with a flat custom line item. </p>', 'refs' => [ 'UpdateCustomLineItemChargeDetails$Flat' => '<p> An <code>UpdateCustomLineItemFlatChargeDetails</code> that describes the new charge details of a flat custom line item. </p>', ], ], 'UpdateCustomLineItemInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomLineItemOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomLineItemPercentageChargeDetails' => [ 'base' => '<p> A representation of the new charge details associated with a percentage custom line item. </p>', 'refs' => [ 'UpdateCustomLineItemChargeDetails$Percentage' => '<p> An <code>UpdateCustomLineItemPercentageChargeDetails</code> that describes the new charge details of a percentage custom line item. </p>', ], ], 'UpdatePricingPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePricingPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePricingRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePricingRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input doesn\'t match with the constraints specified by Amazon Web Services services.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>The field\'s information of a request that resulted in an exception. </p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Fields' => '<p>The fields that caused the error, if applicable. </p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p>The reason the request\'s validation failed. </p>', ], ], ],];
