<?php
// This file was auto-generated from sdk-root/src/data/ssm/2014-11-06/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services Systems Manager is a collection of capabilities that helps you automate management tasks such as collecting system inventory, applying operating system (OS) patches, automating the creation of Amazon Machine Images (AMIs), and configuring operating systems (OSs) and applications at scale. Systems Manager lets you remotely and securely manage the configuration of your managed nodes. A <i>managed node</i> is any Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, or on-premises server or virtual machine (VM) that has been configured for Systems Manager. </p> <note> <p>With support for IoT Greengrass core devices, the phrase <i>managed instance</i> has been changed to <i>managed node</i> in most of the Systems Manager documentation. The Systems Manager console, API calls, error messages, and SSM documents still use the term <i>instance</i>.</p> </note> <p>This reference is intended to be used with the <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/">Amazon Web Services Systems Manager User Guide</a>.</p> <p>To get started, verify prerequisites and configure managed nodes. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-setting-up.html">Setting up Amazon Web Services Systems Manager</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <p class="title"> <b>Related resources</b> </p> <ul> <li> <p>For information about how to use a Query API, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/making-api-requests.html">Making API requests</a>. </p> </li> <li> <p>For information about other API operations you can perform on EC2 instances, see the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/">Amazon EC2 API Reference</a>.</p> </li> <li> <p>For information about AppConfig, a capability of Systems Manager, see the <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/">AppConfig User Guide</a> and the <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/">AppConfig API Reference</a>.</p> </li> <li> <p>For information about Incident Manager, a capability of Systems Manager, see the <a href="https://docs.aws.amazon.com/incident-manager/latest/userguide/">Incident Manager User Guide</a> and the <a href="https://docs.aws.amazon.com/incident-manager/latest/APIReference/">Incident Manager API Reference</a>.</p> </li> </ul>', 'operations' => [ 'AddTagsToResource' => '<p>Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your documents, managed nodes, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. For example, you could define a set of tags for your account\'s managed nodes that helps you track each node\'s owner and stack level. For example:</p> <ul> <li> <p> <code>Key=Owner,Value=DbAdmin</code> </p> </li> <li> <p> <code>Key=Owner,Value=SysAdmin</code> </p> </li> <li> <p> <code>Key=Owner,Value=Dev</code> </p> </li> <li> <p> <code>Key=Stack,Value=Production</code> </p> </li> <li> <p> <code>Key=Stack,Value=Pre-Production</code> </p> </li> <li> <p> <code>Key=Stack,Value=Test</code> </p> </li> </ul> <p>Each resource can have a maximum of 50 tags.</p> <p>We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based on the tags you add. Tags don\'t have any semantic meaning to and are interpreted strictly as a string of characters. </p> <p>For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'AssociateOpsItemRelatedItem' => '<p>Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an Incident Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are capabilities of Amazon Web Services Systems Manager.</p>', 'CancelCommand' => '<p>Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be terminated and the underlying process stopped.</p>', 'CancelMaintenanceWindowExecution' => '<p>Stops a maintenance window execution that is already in progress and cancels any tasks in the window that haven\'t already starting running. Tasks already in progress will continue to completion.</p>', 'CreateActivation' => '<p>Generates an activation code and activation ID you can use to register your on-premises servers, edge devices, or virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using Systems Manager capabilities. You use the activation code and ID when installing SSM Agent on machines in your hybrid environment. For more information about requirements for managing on-premises machines using Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting up Amazon Web Services Systems Manager for hybrid environments</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p> <note> <p>Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices, and on-premises servers and VMs that are configured for Systems Manager are all called <i>managed nodes</i>.</p> </note>', 'CreateAssociation' => '<p>A State Manager association defines the state that you want to maintain on your managed nodes. For example, an association can specify that anti-virus software must be installed and running on your managed nodes, or that certain ports must be closed. For static targets, the association specifies a schedule for when the configuration is reapplied. For dynamic targets, such as an Amazon Web Services resource group or an Amazon Web Services autoscaling group, State Manager, a capability of Amazon Web Services Systems Manager applies the configuration when new managed nodes are added to the group. The association also specifies actions to take when applying the configuration. For example, an association for anti-virus software might run once a day. If the software isn\'t installed, then State Manager installs it. If the software is installed, but the service isn\'t running, then the association might instruct State Manager to start the service. </p>', 'CreateAssociationBatch' => '<p>Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed nodes or targets.</p> <p>When you associate a document with one or more managed nodes using IDs or tags, Amazon Web Services Systems Manager Agent (SSM Agent) running on the managed node processes the document and configures the node as specified.</p> <p>If you associate a document with a managed node that already has an associated document, the system returns the AssociationAlreadyExists exception.</p>', 'CreateDocument' => '<p>Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems Manager performs on your managed nodes. For more information about SSM documents, including information about supported schemas, features, and syntax, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">Amazon Web Services Systems Manager Documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'CreateMaintenanceWindow' => '<p>Creates a new maintenance window.</p> <note> <p>The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window tasks can start after 5 PM.</p> </note>', 'CreateOpsItem' => '<p>Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">Amazon Web Services Systems Manager OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>', 'CreateOpsMetadata' => '<p>If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API operation to specify information about the new application, including the application type.</p>', 'CreatePatchBaseline' => '<p>Creates a patch baseline.</p> <note> <p>For information about valid key-value pairs in <code>PatchFilters</code> for each supported operating system type, see <a>PatchFilter</a>.</p> </note>', 'CreateResourceDataSync' => '<p>A resource data sync helps you view data from multiple sources in a single location. Amazon Web Services Systems Manager offers two types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code>.</p> <p>You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize Inventory data from multiple Amazon Web Services Regions to a single Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring resource data sync for Inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <p>You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational work items (OpsItems) and operational data (OpsData) from multiple Amazon Web Services Regions to a single Amazon S3 bucket. This type can synchronize OpsItems and OpsData from multiple Amazon Web Services accounts and Amazon Web Services Regions or <code>EntireOrganization</code> by using Organizations. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up Systems Manager Explorer to display data from multiple accounts and Regions</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <p>A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is completed, the system continuously syncs data. To check the status of a sync, use the <a>ListResourceDataSync</a>.</p> <note> <p>By default, data isn\'t encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a restrictive bucket policy. </p> </note>', 'DeleteActivation' => '<p>Deletes an activation. You aren\'t required to delete an activation. If you delete an activation, you can no longer use it to register additional managed nodes. Deleting an activation doesn\'t de-register managed nodes. You must manually de-register managed nodes.</p>', 'DeleteAssociation' => '<p>Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified managed node. If you created the association by using the <code>Targets</code> parameter, then you must delete the association by using the association ID.</p> <p>When you disassociate a document from a managed node, it doesn\'t change the configuration of the node. To change the configuration state of a managed node after you disassociate a document, you must create a new document with the desired configuration and associate it with the node.</p>', 'DeleteDocument' => '<p>Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the document.</p> <p>Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all managed nodes that are associated with the document.</p>', 'DeleteInventory' => '<p>Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory type is also referred to as deleting a custom inventory schema.</p>', 'DeleteMaintenanceWindow' => '<p>Deletes a maintenance window.</p>', 'DeleteOpsMetadata' => '<p>Delete OpsMetadata related to an application.</p>', 'DeleteParameter' => '<p>Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.</p>', 'DeleteParameters' => '<p>Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.</p>', 'DeletePatchBaseline' => '<p>Deletes a patch baseline.</p>', 'DeleteResourceDataSync' => '<p>Deletes a resource data sync configuration. After the configuration is deleted, changes to data on managed nodes are no longer synced to or from the target. Deleting a sync configuration doesn\'t delete data.</p>', 'DeregisterManagedInstance' => '<p>Removes the server or virtual machine from the list of registered servers. You can reregister the node again at any time. If you don\'t plan to use Run Command on the server, we suggest uninstalling SSM Agent first.</p>', 'DeregisterPatchBaselineForPatchGroup' => '<p>Removes a patch group from a patch baseline.</p>', 'DeregisterTargetFromMaintenanceWindow' => '<p>Removes a target from a maintenance window.</p>', 'DeregisterTaskFromMaintenanceWindow' => '<p>Removes a task from a maintenance window.</p>', 'DescribeActivations' => '<p>Describes details about the activation, such as the date and time the activation was created, its expiration date, the Identity and Access Management (IAM) role assigned to the managed nodes in the activation, and the number of nodes registered by using this activation.</p>', 'DescribeAssociation' => '<p>Describes the association for the specified target or managed node. If you created the association by using the <code>Targets</code> parameter, then you must retrieve the association by using the association ID.</p>', 'DescribeAssociationExecutionTargets' => '<p>Views information about a specific execution of a specific association.</p>', 'DescribeAssociationExecutions' => '<p>Views all executions for a specific association ID. </p>', 'DescribeAutomationExecutions' => '<p>Provides details about all active and terminated Automation executions.</p>', 'DescribeAutomationStepExecutions' => '<p>Information about all active and terminated step executions in an Automation workflow.</p>', 'DescribeAvailablePatches' => '<p>Lists all patches eligible to be included in a patch baseline.</p>', 'DescribeDocument' => '<p>Describes the specified Amazon Web Services Systems Manager document (SSM document).</p>', 'DescribeDocumentPermission' => '<p>Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the document, you are the owner. If a document is shared, it can either be shared privately (by specifying a user\'s Amazon Web Services account ID) or publicly (<i>All</i>). </p>', 'DescribeEffectiveInstanceAssociations' => '<p>All associations for the managed node(s).</p>', 'DescribeEffectivePatchesForPatchBaseline' => '<p>Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Applies to patch baselines for Windows only.</p>', 'DescribeInstanceAssociationsStatus' => '<p>The status of the associations for the managed node(s).</p>', 'DescribeInstanceInformation' => '<p>Describes one or more of your managed nodes, including information about the operating system platform, the version of SSM Agent installed on the managed node, node status, and so on.</p> <p>If you specify one or more managed node IDs, it returns information for those managed nodes. If you don\'t specify node IDs, it returns information for all your managed nodes. If you specify a node ID that isn\'t valid or a node that you don\'t own, you receive an error.</p> <note> <p>The <code>IamRole</code> field for this API operation is the Identity and Access Management (IAM) role assigned to on-premises managed nodes. This call doesn\'t return the IAM role for EC2 instances.</p> </note>', 'DescribeInstancePatchStates' => '<p>Retrieves the high-level patch state of one or more managed nodes.</p>', 'DescribeInstancePatchStatesForPatchGroup' => '<p>Retrieves the high-level patch state for the managed nodes in the specified patch group.</p>', 'DescribeInstancePatches' => '<p>Retrieves information about the patches on the specified managed node and their state relative to the patch baseline being used for the node.</p>', 'DescribeInventoryDeletions' => '<p>Describes a specific delete inventory operation.</p>', 'DescribeMaintenanceWindowExecutionTaskInvocations' => '<p>Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance window execution.</p>', 'DescribeMaintenanceWindowExecutionTasks' => '<p>For a given maintenance window execution, lists the tasks that were run.</p>', 'DescribeMaintenanceWindowExecutions' => '<p>Lists the executions of a maintenance window. This includes information about when the maintenance window was scheduled to be active, and information about tasks registered and run with the maintenance window.</p>', 'DescribeMaintenanceWindowSchedule' => '<p>Retrieves information about upcoming executions of a maintenance window.</p>', 'DescribeMaintenanceWindowTargets' => '<p>Lists the targets registered with the maintenance window.</p>', 'DescribeMaintenanceWindowTasks' => '<p>Lists the tasks in a maintenance window.</p> <note> <p>For maintenance window tasks without a specified target, you can\'t supply values for <code>--max-errors</code> and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. These values don\'t affect the running of your task and can be ignored.</p> </note>', 'DescribeMaintenanceWindows' => '<p>Retrieves the maintenance windows in an Amazon Web Services account.</p>', 'DescribeMaintenanceWindowsForTarget' => '<p>Retrieves information about the maintenance window targets or tasks that a managed node is associated with.</p>', 'DescribeOpsItems' => '<p>Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of OpsItems. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>', 'DescribeParameters' => '<p>Get information about a parameter.</p> <p>Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>. You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.</p> <important> <p>If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key alias the parameter uses to reference KMS. Otherwise, <code>DescribeParameters</code> retrieves whatever the original key alias was referencing.</p> </important>', 'DescribePatchBaselines' => '<p>Lists the patch baselines in your Amazon Web Services account.</p>', 'DescribePatchGroupState' => '<p>Returns high-level aggregated patch compliance state information for a patch group.</p>', 'DescribePatchGroups' => '<p>Lists all patch groups that have been registered with patch baselines.</p>', 'DescribePatchProperties' => '<p>Lists the properties of available patches organized by product, product family, classification, severity, and other properties of available patches. You can use the reported properties in the filters you specify in requests for operations such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and <a>DescribePatchBaselines</a>.</p> <p>The following section lists the properties that can be used in filters for each major operating system type:</p> <dl> <dt>AMAZON_LINUX</dt> <dd> <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p> </dd> <dt>AMAZON_LINUX_2</dt> <dd> <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p> </dd> <dt>CENTOS</dt> <dd> <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p> </dd> <dt>DEBIAN</dt> <dd> <p>Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code> </p> </dd> <dt>MACOS</dt> <dd> <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> </p> </dd> <dt>ORACLE_LINUX</dt> <dd> <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p> </dd> <dt>REDHAT_ENTERPRISE_LINUX</dt> <dd> <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p> </dd> <dt>SUSE</dt> <dd> <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p> </dd> <dt>UBUNTU</dt> <dd> <p>Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code> </p> </dd> <dt>WINDOWS</dt> <dd> <p>Valid properties: <code>PRODUCT</code> | <code>PRODUCT_FAMILY</code> | <code>CLASSIFICATION</code> | <code>MSRC_SEVERITY</code> </p> </dd> </dl>', 'DescribeSessions' => '<p>Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30 days.</p>', 'DisassociateOpsItemRelatedItem' => '<p>Deletes the association between an OpsItem and a related item. For example, this API operation can delete an Incident Manager incident from an OpsItem. Incident Manager is a capability of Amazon Web Services Systems Manager.</p>', 'GetAutomationExecution' => '<p>Get detailed information about a particular Automation execution.</p>', 'GetCalendarState' => '<p>Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time. If you specify a time, <code>GetCalendarState</code> returns the state of the calendar at that specific time, and returns the next time that the change calendar state will transition. If you don\'t specify a time, <code>GetCalendarState</code> uses the current time. Change Calendar entries have two possible states: <code>OPEN</code> or <code>CLOSED</code>.</p> <p>If you specify more than one calendar in a request, the command returns the status of <code>OPEN</code> only if all calendars in the request are open. If one or more calendars in the request are closed, the status returned is <code>CLOSED</code>.</p> <p>For more information about Change Calendar, a capability of Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">Amazon Web Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'GetCommandInvocation' => '<p>Returns detailed information about command execution for an invocation or plugin.</p> <p> <code>GetCommandInvocation</code> only gives the execution status of a plugin in a document. To get the command execution status on a specific managed node, use <a>ListCommandInvocations</a>. To get the command execution status across managed nodes, use <a>ListCommands</a>.</p>', 'GetConnectionStatus' => '<p>Retrieves the Session Manager connection status for a managed node to determine whether it is running and ready to receive Session Manager connections.</p>', 'GetDefaultPatchBaseline' => '<p>Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.</p> <p>If you don\'t specify an operating system value, the default patch baseline for Windows is returned.</p>', 'GetDeployablePatchSnapshotForInstance' => '<p>Retrieves the current snapshot for the patch baseline the managed node uses. This API is primarily used by the <code>AWS-RunPatchBaseline</code> Systems Manager document (SSM document).</p> <note> <p>If you run the command locally, such as with the Command Line Interface (CLI), the system attempts to use your local Amazon Web Services credentials and the operation fails. To avoid this, you can run the command in the Amazon Web Services Systems Manager console. Use Run Command, a capability of Amazon Web Services Systems Manager, with an SSM document that enables you to target a managed node with a script or command. For example, run the command using the <code>AWS-RunShellScript</code> document or the <code>AWS-RunPowerShellScript</code> document.</p> </note>', 'GetDocument' => '<p>Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).</p>', 'GetInventory' => '<p>Query inventory information. This includes managed node status, such as <code>Stopped</code> or <code>Terminated</code>.</p>', 'GetInventorySchema' => '<p>Return a list of inventory type names for the account, or return a list of attribute names for a specific Inventory item type.</p>', 'GetMaintenanceWindow' => '<p>Retrieves a maintenance window.</p>', 'GetMaintenanceWindowExecution' => '<p>Retrieves details about a specific a maintenance window execution.</p>', 'GetMaintenanceWindowExecutionTask' => '<p>Retrieves the details about a specific task run as part of a maintenance window execution.</p>', 'GetMaintenanceWindowExecutionTaskInvocation' => '<p>Retrieves information about a specific task running on a specific target.</p>', 'GetMaintenanceWindowTask' => '<p>Lists the tasks in a maintenance window.</p> <note> <p>For maintenance window tasks without a specified target, you can\'t supply values for <code>--max-errors</code> and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. These values don\'t affect the running of your task and can be ignored.</p> </note>', 'GetOpsItem' => '<p>Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management (IAM) to view information about an OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>', 'GetOpsMetadata' => '<p>View operational metadata related to an application in Application Manager.</p>', 'GetOpsSummary' => '<p>View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services Systems Manager Explorer. </p>', 'GetParameter' => '<p>Get information about a single parameter by specifying the parameter name.</p> <note> <p>To get information about more than one parameter at a time, use the <a>GetParameters</a> operation.</p> </note>', 'GetParameterHistory' => '<p>Retrieves the history of all changes to a parameter.</p> <important> <p>If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key alias the parameter uses to reference KMS. Otherwise, <code>GetParameterHistory</code> retrieves whatever the original key alias was referencing.</p> </important>', 'GetParameters' => '<p>Get information about one or more parameters by specifying multiple parameter names.</p> <note> <p>To get information about a single parameter, you can use the <a>GetParameter</a> operation instead.</p> </note>', 'GetParametersByPath' => '<p>Retrieve information about one or more parameters in a specific hierarchy. </p> <p>Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>. You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.</p>', 'GetPatchBaseline' => '<p>Retrieves information about a patch baseline.</p>', 'GetPatchBaselineForPatchGroup' => '<p>Retrieves the patch baseline that should be used for the specified patch group.</p>', 'GetServiceSetting' => '<p> <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of <code>false</code>. This means the user can\'t use this feature unless they change the setting to <code>true</code> and intentionally opt in for a paid feature.</p> <p>Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the default value for a <code>SettingId</code>. You can\'t create a new <code>SettingId</code>, but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the <a>UpdateServiceSetting</a> API operation to change the default setting. Or use the <a>ResetServiceSetting</a> to change the value back to the original value defined by the Amazon Web Services service team.</p> <p>Query the current service setting for the Amazon Web Services account. </p>', 'LabelParameterVersion' => '<p>A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically saves a new version and increments the version number by one. A label can help you remember the purpose of a parameter when there are multiple versions. </p> <p>Parameter labels have the following requirements and restrictions.</p> <ul> <li> <p>A version of a parameter can have a maximum of 10 labels.</p> </li> <li> <p>You can\'t attach the same label to different versions of the same parameter. For example, if version 1 has the label Production, then you can\'t attach Production to version 2.</p> </li> <li> <p>You can move a label from one version of a parameter to another.</p> </li> <li> <p>You can\'t create a label when you create a new parameter. You must attach a label to a specific version of a parameter.</p> </li> <li> <p>If you no longer want to use a parameter label, then you can either delete it or move it to a different version of a parameter.</p> </li> <li> <p>A label can have a maximum of 100 characters.</p> </li> <li> <p>Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).</p> </li> <li> <p>Labels can\'t begin with a number, "<code>aws</code>" or "<code>ssm</code>" (not case sensitive). If a label fails to meet these requirements, then the label isn\'t associated with a parameter and the system displays it in the list of InvalidLabels.</p> </li> </ul>', 'ListAssociationVersions' => '<p>Retrieves all versions of an association for a specific association ID.</p>', 'ListAssociations' => '<p>Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region. You can limit the results to a specific State Manager association document or managed node by specifying a filter. State Manager is a capability of Amazon Web Services Systems Manager.</p>', 'ListCommandInvocations' => '<p>An invocation is copy of a command sent to a specific managed node. A command can apply to one or more managed nodes. A command invocation applies to one managed node. For example, if a user runs <code>SendCommand</code> against three managed nodes, then a command invocation is created for each requested managed node ID. <code>ListCommandInvocations</code> provide status about command execution.</p>', 'ListCommands' => '<p>Lists the commands requested by users of the Amazon Web Services account.</p>', 'ListComplianceItems' => '<p>For a specified resource ID, this API operation returns a list of compliance statuses for different resource types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the filter.</p>', 'ListComplianceSummaries' => '<p>Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call can return State Manager associations, patches, or custom compliance types according to the filter criteria that you specify.</p>', 'ListDocumentMetadataHistory' => '<p>Information about approval reviews for a version of a change template in Change Manager.</p>', 'ListDocumentVersions' => '<p>List all versions for a document.</p>', 'ListDocuments' => '<p>Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services Region. You can limit the results of this request by using a filter.</p>', 'ListInventoryEntries' => '<p>A list of inventory items returned by the request.</p>', 'ListOpsItemEvents' => '<p>Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account. You can limit the results to events associated with specific OpsItems by specifying a filter.</p>', 'ListOpsItemRelatedItems' => '<p>Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a capability of Amazon Web Services Systems Manager.</p>', 'ListOpsMetadata' => '<p>Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata objects or blobs.</p>', 'ListResourceComplianceSummaries' => '<p>Returns a resource-level summary count. The summary includes information about compliant and non-compliant statuses and detailed compliance-item severity counts, according to the filter criteria you specify.</p>', 'ListResourceDataSync' => '<p>Lists your resource data sync configurations. Includes information about the last time a sync attempted to start, the last sync status, and the last time a sync successfully completed.</p> <p>The number of sync configurations might be too large to return using a single call to <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call. </p>', 'ListTagsForResource' => '<p>Returns a list of the tags assigned to the specified resource.</p> <p>For information about the ID format for each supported resource type, see <a>AddTagsToResource</a>.</p>', 'ModifyDocumentPermission' => '<p>Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a document privately, you must specify the Amazon Web Services user account IDs for those people who can use the document. If you share a document publicly, you must specify <i>All</i> as the account ID.</p>', 'PutComplianceItems' => '<p>Registers a compliance type and other compliance details on a designated resource. This operation lets you register custom compliance details with a resource. This call overwrites existing compliance information on the resource, so you must provide a full list of compliance items each time that you send the request.</p> <p>ComplianceType can be one of the following:</p> <ul> <li> <p>ExecutionId: The execution ID when the patch, association, or custom compliance item was applied.</p> </li> <li> <p>ExecutionType: Specify patch, association, or Custom:<code>string</code>.</p> </li> <li> <p>ExecutionTime. The time the patch, association, or custom compliance item was applied to the managed node.</p> </li> <li> <p>Id: The patch, association, or custom compliance ID.</p> </li> <li> <p>Title: A title.</p> </li> <li> <p>Status: The status of the compliance item. For example, <code>approved</code> for patches, or <code>Failed</code> for associations.</p> </li> <li> <p>Severity: A patch severity. For example, <code>critical</code>.</p> </li> <li> <p>DocumentName: An SSM document name. For example, <code>AWS-RunPatchBaseline</code>.</p> </li> <li> <p>DocumentVersion: An SSM document version number. For example, 4.</p> </li> <li> <p>Classification: A patch classification. For example, <code>security updates</code>.</p> </li> <li> <p>PatchBaselineId: A patch baseline ID.</p> </li> <li> <p>PatchSeverity: A patch severity. For example, <code>Critical</code>.</p> </li> <li> <p>PatchState: A patch state. For example, <code>InstancesWithFailedPatches</code>.</p> </li> <li> <p>PatchGroup: The name of a patch group.</p> </li> <li> <p>InstalledTime: The time the association, patch, or custom compliance item was applied to the resource. Specify the time by using the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'</p> </li> </ul>', 'PutInventory' => '<p>Bulk update custom inventory items on one or more managed nodes. The request adds an inventory item, if it doesn\'t already exist, or updates an inventory item, if it does exist.</p>', 'PutParameter' => '<p>Add a parameter to the system.</p>', 'RegisterDefaultPatchBaseline' => '<p>Defines the default patch baseline for the relevant operating system.</p> <p>To reset the Amazon Web Services-predefined patch baseline as the default, specify the full patch baseline Amazon Resource Name (ARN) as the baseline ID value. For example, for CentOS, specify <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed</code> instead of <code>pb-0574b43a65ea646ed</code>.</p>', 'RegisterPatchBaselineForPatchGroup' => '<p>Registers a patch baseline for a patch group.</p>', 'RegisterTargetWithMaintenanceWindow' => '<p>Registers a target with a maintenance window.</p>', 'RegisterTaskWithMaintenanceWindow' => '<p>Adds a new task to a maintenance window.</p>', 'RemoveTagsFromResource' => '<p>Removes tag keys from the specified resource.</p>', 'ResetServiceSetting' => '<p> <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can\'t use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.</p> <p>Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the default value for a <code>SettingId</code>. You can\'t create a new <code>SettingId</code>, but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the <a>GetServiceSetting</a> API operation to view the current value. Use the <a>UpdateServiceSetting</a> API operation to change the default setting. </p> <p>Reset the service setting for the account to the default value as provisioned by the Amazon Web Services service team. </p>', 'ResumeSession' => '<p>Reconnects a session to a managed node after it has been disconnected. Connections can be resumed for disconnected sessions, but not terminated sessions.</p> <note> <p>This command is primarily for use by client machines to automatically reconnect during intermittent network issues. It isn\'t intended for any other use.</p> </note>', 'SendAutomationSignal' => '<p>Sends a signal to an Automation execution to change the current behavior or status of the execution. </p>', 'SendCommand' => '<p>Runs commands on one or more managed nodes.</p>', 'StartAssociationsOnce' => '<p>Runs an association immediately and only one time. This operation can be helpful when troubleshooting associations.</p>', 'StartAutomationExecution' => '<p>Initiates execution of an Automation runbook.</p>', 'StartChangeRequestExecution' => '<p>Creates a change request for Change Manager. The Automation runbooks specified in the change request run only after all required approvals for the change request have been received.</p>', 'StartSession' => '<p>Initiates a connection to a target (for example, a managed node) for a Session Manager session. Returns a URL and token that can be used to open a WebSocket connection for sending input and receiving outputs.</p> <note> <p>Amazon Web Services CLI usage: <code>start-session</code> is an interactive command that requires the Session Manager plugin to be installed on the client machine making the call. For information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html">Install the Session Manager plugin for the Amazon Web Services CLI</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <p>Amazon Web Services Tools for PowerShell usage: Start-SSMSession isn\'t currently supported by Amazon Web Services Tools for PowerShell on Windows local machines.</p> </note>', 'StopAutomationExecution' => '<p>Stop an Automation that is currently running.</p>', 'TerminateSession' => '<p>Permanently ends a session and closes the data connection between the Session Manager client and SSM Agent on the managed node. A terminated session can\'t be resumed.</p>', 'UnlabelParameterVersion' => '<p>Remove a label or labels from a parameter.</p>', 'UpdateAssociation' => '<p>Updates an association. You can update the association name and version, the document version, schedule, parameters, and Amazon Simple Storage Service (Amazon S3) output. When you call <code>UpdateAssociation</code>, the system removes all optional parameters from the request and overwrites the association with null values for those parameters. This is by design. You must specify all optional parameters in the call, even if you are not changing the parameters. This includes the <code>Name</code> parameter. Before calling this API action, we recommend that you call the <a>DescribeAssociation</a> API operation and make a note of all optional parameters required for your <code>UpdateAssociation</code> call.</p> <p>In order to call this API operation, your Identity and Access Management (IAM) user account, group, or role must be configured with permission to call the <a>DescribeAssociation</a> API operation. If you don\'t have permission to call <code>DescribeAssociation</code>, then you receive the following error: <code>An error occurred (AccessDeniedException) when calling the UpdateAssociation operation: User: &lt;user_arn&gt; isn\'t authorized to perform: ssm:DescribeAssociation on resource: &lt;resource_arn&gt;</code> </p> <important> <p>When you update an association, the association immediately runs against the specified targets. You can add the <code>ApplyOnlyAtCronInterval</code> parameter to run the association during the next schedule run.</p> </important>', 'UpdateAssociationStatus' => '<p>Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the specified managed node.</p> <p> <code>UpdateAssociationStatus</code> is primarily used by the Amazon Web Services Systems Manager Agent (SSM Agent) to report status updates about your associations and is only used for associations created with the <code>InstanceId</code> legacy parameter.</p>', 'UpdateDocument' => '<p>Updates one or more values for an SSM document.</p>', 'UpdateDocumentDefaultVersion' => '<p>Set the default version of a document. </p>', 'UpdateDocumentMetadata' => '<p>Updates information related to approval reviews for a specific version of a change template in Change Manager.</p>', 'UpdateMaintenanceWindow' => '<p>Updates an existing maintenance window. Only specified parameters are modified.</p> <note> <p>The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window tasks can start after 5 PM.</p> </note>', 'UpdateMaintenanceWindowTarget' => '<p>Modifies the target of an existing maintenance window. You can change the following:</p> <ul> <li> <p>Name</p> </li> <li> <p>Description</p> </li> <li> <p>Owner</p> </li> <li> <p>IDs for an ID target</p> </li> <li> <p>Tags for a Tag target</p> </li> <li> <p>From any supported tag type to another. The three supported tag types are ID target, Tag target, and resource group. For more information, see <a>Target</a>.</p> </li> </ul> <note> <p>If a parameter is null, then the corresponding field isn\'t modified.</p> </note>', 'UpdateMaintenanceWindowTask' => '<p>Modifies a task assigned to a maintenance window. You can\'t change the task type, but you can change the following values:</p> <ul> <li> <p> <code>TaskARN</code>. For example, you can change a <code>RUN_COMMAND</code> task from <code>AWS-RunPowerShellScript</code> to <code>AWS-RunShellScript</code>.</p> </li> <li> <p> <code>ServiceRoleArn</code> </p> </li> <li> <p> <code>TaskInvocationParameters</code> </p> </li> <li> <p> <code>Priority</code> </p> </li> <li> <p> <code>MaxConcurrency</code> </p> </li> <li> <p> <code>MaxErrors</code> </p> </li> </ul> <note> <p>One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don\'t specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> </note> <p>If the value for a parameter in <code>UpdateMaintenanceWindowTask</code> is null, then the corresponding field isn\'t modified. If you set <code>Replace</code> to true, then all fields required by the <a>RegisterTaskWithMaintenanceWindow</a> operation are required for this request. Optional fields that aren\'t specified are set to null.</p> <important> <p>When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code>, you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values you don\'t specify again are removed. For example, suppose that when you registered a Run Command task, you specified <code>TaskInvocationParameters</code> values for <code>Comment</code>, <code>NotificationConfig</code>, and <code>OutputS3BucketName</code>. If you update the maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code> are removed.</p> </important>', 'UpdateManagedInstanceRole' => '<p>Changes the Identity and Access Management (IAM) role that is assigned to the on-premises server, edge device, or virtual machines (VM). IAM roles are first assigned to these hybrid nodes during the activation process. For more information, see <a>CreateActivation</a>.</p>', 'UpdateOpsItem' => '<p>Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM) to update an OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>', 'UpdateOpsMetadata' => '<p>Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager.</p>', 'UpdatePatchBaseline' => '<p>Modifies an existing patch baseline. Fields not specified in the request are left unchanged.</p> <note> <p>For information about valid key-value pairs in <code>PatchFilters</code> for each supported operating system type, see <a>PatchFilter</a>.</p> </note>', 'UpdateResourceDataSync' => '<p>Update a resource data sync. After you create a resource data sync for a Region, you can\'t change the account options for that sync. For example, if you create a sync in the us-east-2 (Ohio) Region and you choose the <code>Include only the current account</code> option, you can\'t edit that sync later and choose the <code>Include all accounts from my Organizations configuration</code> option. Instead, you must delete the first resource data sync, and create a new one.</p> <note> <p>This API operation only supports a resource data sync that was created with a SyncFromSource <code>SyncType</code>.</p> </note>', 'UpdateServiceSetting' => '<p> <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can\'t use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.</p> <p>Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the default value for a <code>SettingId</code>. You can\'t create a new <code>SettingId</code>, but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the <a>GetServiceSetting</a> API operation to view the current value. Or, use the <a>ResetServiceSetting</a> to change the value back to the original value defined by the Amazon Web Services service team.</p> <p>Update the service setting for the account. </p>', ], 'shapes' => [ 'Account' => [ 'base' => NULL, 'refs' => [ 'Accounts$member' => NULL, ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountIdList$member' => NULL, 'AccountSharingInfo$AccountId' => '<p>The Amazon Web Services account ID where the current document is shared.</p>', ], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeDocumentPermissionResponse$AccountIds' => '<p>The account IDs that have permission to use this document. The ID can be either an Amazon Web Services account or <i>All</i>.</p>', 'ModifyDocumentPermissionRequest$AccountIdsToAdd' => '<p>The Amazon Web Services user accounts that should have access to the document. The account IDs can either be a group of account IDs or <i>All</i>.</p>', 'ModifyDocumentPermissionRequest$AccountIdsToRemove' => '<p>The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services user account can either be a group of account IDs or <i>All</i>. This action has a higher priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove, the system removes access to the document.</p>', ], ], 'AccountSharingInfo' => [ 'base' => '<p>Information includes the Amazon Web Services account ID where the current document is shared and the version shared with that account.</p>', 'refs' => [ 'AccountSharingInfoList$member' => NULL, ], ], 'AccountSharingInfoList' => [ 'base' => '<p>A list of Amazon Web Services accounts where the current document is shared and the version shared with each account.</p>', 'refs' => [ 'DescribeDocumentPermissionResponse$AccountSharingInfoList' => '<p>A list of Amazon Web Services accounts where the current document is shared and the version shared with each account.</p>', ], ], 'Accounts' => [ 'base' => NULL, 'refs' => [ 'TargetLocation$Accounts' => '<p>The Amazon Web Services accounts targeted by the current Automation execution.</p>', ], ], 'Activation' => [ 'base' => '<p>An activation registers one or more on-premises servers or virtual machines (VMs) with Amazon Web Services so that you can configure those servers or VMs using Run Command. A server or VM that has been registered with Amazon Web Services Systems Manager is called a managed node.</p>', 'refs' => [ 'ActivationList$member' => NULL, ], ], 'ActivationCode' => [ 'base' => NULL, 'refs' => [ 'CreateActivationResult$ActivationCode' => '<p>The code the system generates when it processes the activation. The activation code functions like a password to validate the activation ID. </p>', ], ], 'ActivationDescription' => [ 'base' => NULL, 'refs' => [ 'Activation$Description' => '<p>A user defined description of the activation.</p>', 'CreateActivationRequest$Description' => '<p>A user-defined description of the resource that you want to register with Systems Manager. </p> <important> <p>Don\'t enter personally identifiable information in this field.</p> </important>', ], ], 'ActivationId' => [ 'base' => NULL, 'refs' => [ 'Activation$ActivationId' => '<p>The ID created by Systems Manager when you submitted the activation.</p>', 'CreateActivationResult$ActivationId' => '<p>The ID number generated by the system when it processed the activation. The activation ID functions like a user name.</p>', 'DeleteActivationRequest$ActivationId' => '<p>The ID of the activation that you want to delete.</p>', 'InstanceInformation$ActivationId' => '<p>The activation ID created by Amazon Web Services Systems Manager when the server or virtual machine (VM) was registered.</p>', ], ], 'ActivationList' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsResult$ActivationList' => '<p>A list of activations for your Amazon Web Services account.</p>', ], ], 'AddTagsToResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsToResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'AgentErrorCode' => [ 'base' => NULL, 'refs' => [ 'InstanceAssociationStatusInfo$ErrorCode' => '<p>An error code returned by the request to create the association.</p>', ], ], 'AggregatorSchemaOnly' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$Aggregator' => '<p>Returns inventory schemas that support aggregation. For example, this call returns the <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.</p>', ], ], 'AllowedPattern' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$AllowedPattern' => '<p>Parameter names can include the following letters and symbols.</p> <p>a-zA-Z0-9_.-</p>', 'ParameterMetadata$AllowedPattern' => '<p>A parameter name can include only the following letters and symbols.</p> <p>a-zA-Z0-9_.-</p>', 'PutParameterRequest$AllowedPattern' => '<p>A regular expression used to validate the parameter value. For example, for String types with values restricted to numbers, you can specify the following: AllowedPattern=^\\d+$ </p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>Error returned if an attempt is made to register a patch group with a patch baseline that is already registered with a different patch baseline.</p>', 'refs' => [], ], 'ApplyOnlyAtCronInterval' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$ApplyOnlyAtCronInterval' => '<p>By default, when you create a new associations, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don\'t want an association to run immediately after you create it. This parameter isn\'t supported for rate expressions.</p>', 'AssociationVersionInfo$ApplyOnlyAtCronInterval' => '<p>By default, when you create a new associations, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don\'t want an association to run immediately after you create it. This parameter isn\'t supported for rate expressions.</p>', 'CreateAssociationBatchRequestEntry$ApplyOnlyAtCronInterval' => '<p>By default, when you create a new associations, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don\'t want an association to run immediately after you create it. This parameter isn\'t supported for rate expressions.</p>', 'CreateAssociationRequest$ApplyOnlyAtCronInterval' => '<p>By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don\'t want an association to run immediately after you create it. This parameter isn\'t supported for rate expressions.</p>', 'UpdateAssociationRequest$ApplyOnlyAtCronInterval' => '<p>By default, when you update an association, the system runs it immediately after it is updated and then according to the schedule you specified. Specify this option if you don\'t want an association to run immediately after you update it. This parameter isn\'t supported for rate expressions.</p> <p>Also, if you specified this option when you created the association, you can reset it. To do so, specify the <code>no-apply-only-at-cron-interval</code> parameter when you update the association from the command line. This parameter forces the association to run immediately after updating it and according to the interval specified.</p>', ], ], 'ApproveAfterDays' => [ 'base' => NULL, 'refs' => [ 'PatchRule$ApproveAfterDays' => '<p>The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline. For example, a value of <code>7</code> means that patches are approved seven days after they are released. Not supported on Debian Server or Ubuntu Server.</p>', ], ], 'AssociateOpsItemRelatedItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateOpsItemRelatedItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedInstances' => [ 'base' => '<p>You must disassociate a document from all managed nodes before you can delete it.</p>', 'refs' => [], ], 'Association' => [ 'base' => '<p>Describes an association of a Amazon Web Services Systems Manager document (SSM document) and a managed node.</p>', 'refs' => [ 'AssociationList$member' => NULL, ], ], 'AssociationAlreadyExists' => [ 'base' => '<p>The specified association already exists.</p>', 'refs' => [], ], 'AssociationComplianceSeverity' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$ComplianceSeverity' => '<p>The severity level that is assigned to the association.</p>', 'AssociationVersionInfo$ComplianceSeverity' => '<p>The severity level that is assigned to the association.</p>', 'CreateAssociationBatchRequestEntry$ComplianceSeverity' => '<p>The severity level to assign to the association.</p>', 'CreateAssociationRequest$ComplianceSeverity' => '<p>The severity level to assign to the association.</p>', 'UpdateAssociationRequest$ComplianceSeverity' => '<p>The severity level to assign to the association.</p>', ], ], 'AssociationDescription' => [ 'base' => '<p>Describes the parameters for a document.</p>', 'refs' => [ 'AssociationDescriptionList$member' => NULL, 'CreateAssociationResult$AssociationDescription' => '<p>Information about the association.</p>', 'DescribeAssociationResult$AssociationDescription' => '<p>Information about the association.</p>', 'UpdateAssociationResult$AssociationDescription' => '<p>The description of the association that was updated.</p>', 'UpdateAssociationStatusResult$AssociationDescription' => '<p>Information about the association.</p>', ], ], 'AssociationDescriptionList' => [ 'base' => NULL, 'refs' => [ 'CreateAssociationBatchResult$Successful' => '<p>Information about the associations that succeeded.</p>', ], ], 'AssociationDoesNotExist' => [ 'base' => '<p>The specified association doesn\'t exist.</p>', 'refs' => [], ], 'AssociationExecution' => [ 'base' => '<p>Includes information about the specified association.</p>', 'refs' => [ 'AssociationExecutionsList$member' => NULL, ], ], 'AssociationExecutionDoesNotExist' => [ 'base' => '<p>The specified execution ID doesn\'t exist. Verify the ID number and try again.</p>', 'refs' => [], ], 'AssociationExecutionFilter' => [ 'base' => '<p>Filters used in the request.</p>', 'refs' => [ 'AssociationExecutionFilterList$member' => NULL, ], ], 'AssociationExecutionFilterKey' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionFilter$Key' => '<p>The key value used in the request.</p>', ], ], 'AssociationExecutionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssociationExecutionsRequest$Filters' => '<p>Filters for the request. You can specify the following filters and values.</p> <p>ExecutionId (EQUAL)</p> <p>Status (EQUAL)</p> <p>CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)</p>', ], ], 'AssociationExecutionFilterValue' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionFilter$Value' => '<p>The value specified for the key.</p>', ], ], 'AssociationExecutionId' => [ 'base' => NULL, 'refs' => [ 'AssociationExecution$ExecutionId' => '<p>The execution ID for the association.</p>', 'AssociationExecutionTarget$ExecutionId' => '<p>The execution ID.</p>', 'DescribeAssociationExecutionTargetsRequest$ExecutionId' => '<p>The execution ID for which you want to view details.</p>', ], ], 'AssociationExecutionTarget' => [ 'base' => '<p>Includes information about the specified association execution.</p>', 'refs' => [ 'AssociationExecutionTargetsList$member' => NULL, ], ], 'AssociationExecutionTargetsFilter' => [ 'base' => '<p>Filters for the association execution.</p>', 'refs' => [ 'AssociationExecutionTargetsFilterList$member' => NULL, ], ], 'AssociationExecutionTargetsFilterKey' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionTargetsFilter$Key' => '<p>The key value used in the request.</p>', ], ], 'AssociationExecutionTargetsFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssociationExecutionTargetsRequest$Filters' => '<p>Filters for the request. You can specify the following filters and values.</p> <p>Status (EQUAL)</p> <p>ResourceId (EQUAL)</p> <p>ResourceType (EQUAL)</p>', ], ], 'AssociationExecutionTargetsFilterValue' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionTargetsFilter$Value' => '<p>The value specified for the key.</p>', ], ], 'AssociationExecutionTargetsList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssociationExecutionTargetsResult$AssociationExecutionTargets' => '<p>Information about the execution.</p>', ], ], 'AssociationExecutionsList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssociationExecutionsResult$AssociationExecutions' => '<p>A list of the executions for the specified association ID.</p>', ], ], 'AssociationFilter' => [ 'base' => '<p>Describes a filter.</p>', 'refs' => [ 'AssociationFilterList$member' => NULL, ], ], 'AssociationFilterKey' => [ 'base' => NULL, 'refs' => [ 'AssociationFilter$key' => '<p>The name of the filter.</p> <note> <p> <code>InstanceId</code> has been deprecated.</p> </note>', ], ], 'AssociationFilterList' => [ 'base' => NULL, 'refs' => [ 'ListAssociationsRequest$AssociationFilterList' => '<p>One or more filters. Use a filter to return a more specific list of results.</p> <note> <p>Filtering associations using the <code>InstanceID</code> attribute only returns legacy associations created using the <code>InstanceID</code> attribute. Associations targeting the managed node that are part of the Target Attributes <code>ResourceGroup</code> or <code>Tags</code> aren\'t returned.</p> </note>', ], ], 'AssociationFilterOperatorType' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionFilter$Type' => '<p>The filter type specified in the request.</p>', ], ], 'AssociationFilterValue' => [ 'base' => NULL, 'refs' => [ 'AssociationFilter$value' => '<p>The filter value.</p>', ], ], 'AssociationId' => [ 'base' => NULL, 'refs' => [ 'Association$AssociationId' => '<p>The ID created by the system when you create an association. An association is a binding between a document and a set of targets with a schedule.</p>', 'AssociationDescription$AssociationId' => '<p>The association ID.</p>', 'AssociationExecution$AssociationId' => '<p>The association ID.</p>', 'AssociationExecutionTarget$AssociationId' => '<p>The association ID.</p>', 'AssociationIdList$member' => NULL, 'AssociationVersionInfo$AssociationId' => '<p>The ID created by the system when the association was created.</p>', 'DeleteAssociationRequest$AssociationId' => '<p>The association ID that you want to delete.</p>', 'DescribeAssociationExecutionTargetsRequest$AssociationId' => '<p>The association ID that includes the execution for which you want to view details.</p>', 'DescribeAssociationExecutionsRequest$AssociationId' => '<p>The association ID for which you want to view execution history details.</p>', 'DescribeAssociationRequest$AssociationId' => '<p>The association ID for which you want information.</p>', 'InstanceAssociation$AssociationId' => '<p>The association ID.</p>', 'InstanceAssociationStatusInfo$AssociationId' => '<p>The association ID.</p>', 'ListAssociationVersionsRequest$AssociationId' => '<p>The association ID for which you want to view all versions.</p>', 'UpdateAssociationRequest$AssociationId' => '<p>The ID of the association you want to update. </p>', ], ], 'AssociationIdList' => [ 'base' => NULL, 'refs' => [ 'StartAssociationsOnceRequest$AssociationIds' => '<p>The association IDs that you want to run immediately and only one time.</p>', ], ], 'AssociationLimitExceeded' => [ 'base' => '<p>You can have at most 2,000 active associations.</p>', 'refs' => [], ], 'AssociationList' => [ 'base' => NULL, 'refs' => [ 'ListAssociationsResult$Associations' => '<p>The associations.</p>', ], ], 'AssociationName' => [ 'base' => NULL, 'refs' => [ 'Association$AssociationName' => '<p>The association name.</p>', 'AssociationDescription$AssociationName' => '<p>The association name.</p>', 'AssociationVersionInfo$AssociationName' => '<p>The name specified for the association version when the association version was created.</p>', 'CreateAssociationBatchRequestEntry$AssociationName' => '<p>Specify a descriptive name for the association.</p>', 'CreateAssociationRequest$AssociationName' => '<p>Specify a descriptive name for the association.</p>', 'InstanceAssociationStatusInfo$AssociationName' => '<p>The name of the association applied to the managed node.</p>', 'UpdateAssociationRequest$AssociationName' => '<p>The name of the association that you want to update.</p>', ], ], 'AssociationOverview' => [ 'base' => '<p>Information about the association.</p>', 'refs' => [ 'Association$Overview' => '<p>Information about the association.</p>', 'AssociationDescription$Overview' => '<p>Information about the association.</p>', ], ], 'AssociationResourceId' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionTarget$ResourceId' => '<p>The resource ID, for example, the managed node ID where the association ran.</p>', ], ], 'AssociationResourceType' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionTarget$ResourceType' => '<p>The resource type, for example, EC2.</p>', ], ], 'AssociationStatus' => [ 'base' => '<p>Describes an association status.</p>', 'refs' => [ 'AssociationDescription$Status' => '<p>The association status.</p>', 'UpdateAssociationStatusRequest$AssociationStatus' => '<p>The association status.</p>', ], ], 'AssociationStatusAggregatedCount' => [ 'base' => NULL, 'refs' => [ 'AssociationOverview$AssociationStatusAggregatedCount' => '<p>Returns the number of targets for the association status. For example, if you created an association with two managed nodes, and one of them was successful, this would return the count of managed nodes by status.</p>', ], ], 'AssociationStatusName' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$Name' => '<p>The status.</p>', ], ], 'AssociationSyncCompliance' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$SyncCompliance' => '<p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn\'t run successfully, the association is <code>NON-COMPLIANT</code>.</p> <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn\'t managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API operation.</p> <p>By default, all associations use <code>AUTO</code> mode.</p>', 'AssociationVersionInfo$SyncCompliance' => '<p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn\'t run successfully, the association is <code>NON-COMPLIANT</code>.</p> <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn\'t managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API operation.</p> <p>By default, all associations use <code>AUTO</code> mode.</p>', 'CreateAssociationBatchRequestEntry$SyncCompliance' => '<p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn\'t run successfully, the association is <code>NON-COMPLIANT</code>. </p> <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn\'t managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API operation.</p> <p>By default, all associations use <code>AUTO</code> mode.</p>', 'CreateAssociationRequest$SyncCompliance' => '<p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn\'t run successfully, the association is <code>NON-COMPLIANT</code>.</p> <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn\'t managed by State Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API operation.</p> <p>By default, all associations use <code>AUTO</code> mode.</p>', 'UpdateAssociationRequest$SyncCompliance' => '<p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn\'t run successfully, the association is <code>NON-COMPLIANT</code>.</p> <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn\'t managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API operation.</p> <p>By default, all associations use <code>AUTO</code> mode.</p>', ], ], 'AssociationVersion' => [ 'base' => NULL, 'refs' => [ 'Association$AssociationVersion' => '<p>The association version.</p>', 'AssociationDescription$AssociationVersion' => '<p>The association version.</p>', 'AssociationExecution$AssociationVersion' => '<p>The association version.</p>', 'AssociationExecutionTarget$AssociationVersion' => '<p>The association version.</p>', 'AssociationVersionInfo$AssociationVersion' => '<p>The association version.</p>', 'DescribeAssociationRequest$AssociationVersion' => '<p>Specify the association version to retrieve. To view the latest version, either specify <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all associations for a managed node, use <a>ListAssociations</a>. To get a list of versions for a specific association, use <a>ListAssociationVersions</a>. </p>', 'InstanceAssociation$AssociationVersion' => '<p>Version information for the association on the managed node.</p>', 'InstanceAssociationStatusInfo$AssociationVersion' => '<p>The version of the association applied to the managed node.</p>', 'UpdateAssociationRequest$AssociationVersion' => '<p>This parameter is provided for concurrency control purposes. You must specify the latest association version in the service. If you want to ensure that this request succeeds, either specify <code>$LATEST</code>, or omit this parameter.</p>', ], ], 'AssociationVersionInfo' => [ 'base' => '<p>Information about the association version.</p>', 'refs' => [ 'AssociationVersionList$member' => NULL, ], ], 'AssociationVersionLimitExceeded' => [ 'base' => '<p>You have reached the maximum number versions allowed for an association. Each association has a limit of 1,000 versions. </p>', 'refs' => [], ], 'AssociationVersionList' => [ 'base' => NULL, 'refs' => [ 'ListAssociationVersionsResult$AssociationVersions' => '<p>Information about all versions of the association for the specified association ID.</p>', ], ], 'AttachmentContent' => [ 'base' => '<p>A structure that includes attributes that describe a document attachment.</p>', 'refs' => [ 'AttachmentContentList$member' => NULL, ], ], 'AttachmentContentList' => [ 'base' => NULL, 'refs' => [ 'GetDocumentResult$AttachmentsContent' => '<p>A description of the document attachments, including names, locations, sizes, and so on.</p>', ], ], 'AttachmentHash' => [ 'base' => NULL, 'refs' => [ 'AttachmentContent$Hash' => '<p>The cryptographic hash value of the document content.</p>', ], ], 'AttachmentHashType' => [ 'base' => NULL, 'refs' => [ 'AttachmentContent$HashType' => '<p>The hash algorithm used to calculate the hash value.</p>', ], ], 'AttachmentIdentifier' => [ 'base' => NULL, 'refs' => [ 'AttachmentsSource$Name' => '<p>The name of the document attachment file.</p>', ], ], 'AttachmentInformation' => [ 'base' => '<p>An attribute of an attachment, such as the attachment name.</p>', 'refs' => [ 'AttachmentInformationList$member' => NULL, ], ], 'AttachmentInformationList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$AttachmentsInformation' => '<p>Details about the document attachments, including names, locations, sizes, and so on.</p>', ], ], 'AttachmentName' => [ 'base' => NULL, 'refs' => [ 'AttachmentContent$Name' => '<p>The name of an attachment.</p>', 'AttachmentInformation$Name' => '<p>The name of the attachment.</p>', ], ], 'AttachmentUrl' => [ 'base' => NULL, 'refs' => [ 'AttachmentContent$Url' => '<p>The URL location of the attachment content.</p>', ], ], 'AttachmentsSource' => [ 'base' => '<p>Identifying information about a document attachment, including the file name and a key-value pair that identifies the location of an attachment to a document.</p>', 'refs' => [ 'AttachmentsSourceList$member' => NULL, ], ], 'AttachmentsSourceKey' => [ 'base' => NULL, 'refs' => [ 'AttachmentsSource$Key' => '<p>The key of a key-value pair that identifies the location of an attachment to a document.</p>', ], ], 'AttachmentsSourceList' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$Attachments' => '<p>A list of key-value pairs that describe attachments to a version of a document.</p>', 'UpdateDocumentRequest$Attachments' => '<p>A list of key-value pairs that describe attachments to a version of a document.</p>', ], ], 'AttachmentsSourceValue' => [ 'base' => NULL, 'refs' => [ 'AttachmentsSourceValues$member' => NULL, ], ], 'AttachmentsSourceValues' => [ 'base' => NULL, 'refs' => [ 'AttachmentsSource$Values' => '<p>The value of a key-value pair that identifies the location of an attachment to a document. The format for <b>Value</b> depends on the type of key you specify.</p> <ul> <li> <p>For the key <i>SourceUrl</i>, the value is an S3 bucket location. For example:</p> <p> <code>"Values": [ "s3://doc-example-bucket/my-folder" ]</code> </p> </li> <li> <p>For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For example:</p> <p> <code>"Values": [ "s3://doc-example-bucket/my-folder/my-file.py" ]</code> </p> </li> <li> <p>For the key <i>AttachmentReference</i>, the value is constructed from the name of another SSM document in your account, a version number of that document, and a file attached to that document version that you want to reuse. For example:</p> <p> <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code> </p> <p>However, if the SSM document is shared with you from another account, the full SSM document ARN must be specified instead of the document name only. For example:</p> <p> <code>"Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py" ]</code> </p> </li> </ul>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'ComplianceItemDetails$key' => NULL, 'InventoryItemContentContext$key' => NULL, 'InventoryItemEntry$key' => NULL, 'OpsEntityItemEntry$key' => NULL, 'PatchPropertyEntry$key' => NULL, ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'ComplianceItemDetails$value' => NULL, 'InventoryItemContentContext$value' => NULL, 'InventoryItemEntry$value' => NULL, 'OpsEntityItemEntry$value' => NULL, 'PatchPropertyEntry$value' => NULL, ], ], 'AutomationActionName' => [ 'base' => NULL, 'refs' => [ 'StepExecution$Action' => '<p>The action this step performs. The action determines the behavior of the step.</p>', ], ], 'AutomationDefinitionNotApprovedException' => [ 'base' => '<p>Indicates that the Change Manager change template used in the change request was rejected or is still in a pending state.</p>', 'refs' => [], ], 'AutomationDefinitionNotFoundException' => [ 'base' => '<p>An Automation runbook with the specified name couldn\'t be found.</p>', 'refs' => [], ], 'AutomationDefinitionVersionNotFoundException' => [ 'base' => '<p>An Automation runbook with the specified name and version couldn\'t be found.</p>', 'refs' => [], ], 'AutomationExecution' => [ 'base' => '<p>Detailed information about the current state of an individual Automation execution.</p>', 'refs' => [ 'GetAutomationExecutionResult$AutomationExecution' => '<p>Detailed information about the current state of an automation execution.</p>', ], ], 'AutomationExecutionFilter' => [ 'base' => '<p>A filter used to match specific automation executions. This is used to limit the scope of Automation execution information returned.</p>', 'refs' => [ 'AutomationExecutionFilterList$member' => NULL, ], ], 'AutomationExecutionFilterKey' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionFilter$Key' => '<p>One or more keys to limit the results.</p>', ], ], 'AutomationExecutionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAutomationExecutionsRequest$Filters' => '<p>Filters used to limit the scope of executions that are requested.</p>', ], ], 'AutomationExecutionFilterValue' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionFilterValueList$member' => NULL, ], ], 'AutomationExecutionFilterValueList' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionFilter$Values' => '<p>The values used to limit the execution information associated with the filter\'s key.</p>', ], ], 'AutomationExecutionId' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$AutomationExecutionId' => '<p>The execution ID.</p>', 'AutomationExecution$ParentAutomationExecutionId' => '<p>The AutomationExecutionId of the parent automation.</p>', 'AutomationExecutionMetadata$AutomationExecutionId' => '<p>The execution ID.</p>', 'AutomationExecutionMetadata$ParentAutomationExecutionId' => '<p>The execution ID of the parent automation.</p>', 'DescribeAutomationStepExecutionsRequest$AutomationExecutionId' => '<p>The Automation execution ID for which you want step execution descriptions.</p>', 'GetAutomationExecutionRequest$AutomationExecutionId' => '<p>The unique identifier for an existing automation execution to examine. The execution ID is returned by StartAutomationExecution when the execution of an Automation runbook is initiated.</p>', 'SendAutomationSignalRequest$AutomationExecutionId' => '<p>The unique identifier for an existing Automation execution that you want to send the signal to.</p>', 'StartAutomationExecutionResult$AutomationExecutionId' => '<p>The unique ID of a newly scheduled automation execution.</p>', 'StartChangeRequestExecutionResult$AutomationExecutionId' => '<p>The unique ID of a runbook workflow operation. (A runbook workflow is a type of Automation operation.) </p>', 'StopAutomationExecutionRequest$AutomationExecutionId' => '<p>The execution ID of the Automation to stop.</p>', ], ], 'AutomationExecutionLimitExceededException' => [ 'base' => '<p>The number of simultaneously running Automation executions exceeded the allowable limit.</p>', 'refs' => [], ], 'AutomationExecutionMetadata' => [ 'base' => '<p>Details about a specific Automation execution.</p>', 'refs' => [ 'AutomationExecutionMetadataList$member' => NULL, ], ], 'AutomationExecutionMetadataList' => [ 'base' => NULL, 'refs' => [ 'DescribeAutomationExecutionsResult$AutomationExecutionMetadataList' => '<p>The list of details about each automation execution which has occurred which matches the filter specification, if any.</p>', ], ], 'AutomationExecutionNotFoundException' => [ 'base' => '<p>There is no automation execution information for the requested automation execution ID.</p>', 'refs' => [], ], 'AutomationExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$AutomationExecutionStatus' => '<p>The execution status of the Automation.</p>', 'AutomationExecutionMetadata$AutomationExecutionStatus' => '<p>The status of the execution.</p>', 'StepExecution$StepStatus' => '<p>The execution status for this step.</p>', ], ], 'AutomationParameterKey' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$TargetParameterName' => '<p>The parameter name.</p>', 'AutomationExecutionMetadata$TargetParameterName' => '<p>The list of execution outputs as defined in the Automation runbook.</p>', 'AutomationParameterMap$key' => NULL, 'Runbook$TargetParameterName' => '<p>The name of the parameter used as the target resource for the rate-controlled runbook workflow. Required if you specify <code>Targets</code>. </p>', 'StartAutomationExecutionRequest$TargetParameterName' => '<p>The name of the parameter used as the target resource for the rate-controlled execution. Required if you specify targets.</p>', ], ], 'AutomationParameterMap' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$Parameters' => '<p>The key-value map of execution parameters, which were supplied when calling <a>StartAutomationExecution</a>.</p>', 'AutomationExecution$Outputs' => '<p>The list of execution outputs as defined in the Automation runbook.</p>', 'AutomationExecutionMetadata$Outputs' => '<p>The list of execution outputs as defined in the Automation runbook.</p>', 'FailureDetails$Details' => '<p>Detailed information about the Automation step failure.</p>', 'MaintenanceWindowAutomationParameters$Parameters' => '<p>The parameters for the <code>AUTOMATION</code> task.</p> <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p>For <code>AUTOMATION</code> task types, Amazon Web Services Systems Manager ignores any values specified for these parameters.</p> </note>', 'Runbook$Parameters' => '<p>The key-value map of execution parameters, which were supplied when calling <code>StartChangeRequestExecution</code>.</p>', 'SendAutomationSignalRequest$Payload' => '<p>The data sent with the signal. The data schema depends on the type of signal used in the request.</p> <p>For <code>Approve</code> and <code>Reject</code> signal types, the payload is an optional comment that you can send with the signal type. For example:</p> <p> <code>Comment="Looks good"</code> </p> <p>For <code>StartStep</code> and <code>Resume</code> signal types, you must send the name of the Automation step to start or resume as the payload. For example:</p> <p> <code>StepName="step1"</code> </p> <p>For the <code>StopStep</code> signal type, you must send the step execution ID as the payload. For example:</p> <p> <code>StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"</code> </p>', 'StartAutomationExecutionRequest$Parameters' => '<p>A key-value map of execution parameters, which match the declared parameters in the Automation runbook.</p>', 'StartChangeRequestExecutionRequest$Parameters' => '<p>A key-value map of parameters that match the declared parameters in the change template document.</p>', 'StepExecution$Outputs' => '<p>Returned values from the execution of the step.</p>', 'StepExecution$OverriddenParameters' => '<p>A user-specified list of parameters to override when running a step.</p>', ], ], 'AutomationParameterValue' => [ 'base' => NULL, 'refs' => [ 'AutomationParameterValueList$member' => NULL, ], ], 'AutomationParameterValueList' => [ 'base' => NULL, 'refs' => [ 'AutomationParameterMap$value' => NULL, ], ], 'AutomationStepNotFoundException' => [ 'base' => '<p>The specified step name and execution ID don\'t exist. Verify the information and try again.</p>', 'refs' => [], ], 'AutomationSubtype' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$AutomationSubtype' => '<p>The subtype of the Automation operation. Currently, the only supported value is <code>ChangeRequest</code>.</p>', 'AutomationExecutionMetadata$AutomationSubtype' => '<p>The subtype of the Automation operation. Currently, the only supported value is <code>ChangeRequest</code>.</p>', ], ], 'AutomationTargetParameterName' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$AutomationTargetParameterName' => '<p>Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of Amazon Web Services Systems Manager.</p>', 'CreateAssociationBatchRequestEntry$AutomationTargetParameterName' => '<p>Specify the target for the association. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of Amazon Web Services Systems Manager.</p>', 'CreateAssociationRequest$AutomationTargetParameterName' => '<p>Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of Amazon Web Services Systems Manager.</p>', 'UpdateAssociationRequest$AutomationTargetParameterName' => '<p>Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of Amazon Web Services Systems Manager.</p>', ], ], 'AutomationType' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionMetadata$AutomationType' => '<p>Use this filter with <a>DescribeAutomationExecutions</a>. Specify either Local or CrossAccount. CrossAccount is an Automation that runs in multiple Amazon Web Services Regions and Amazon Web Services accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple Amazon Web Services Regions and accounts</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>', ], ], 'BaselineDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$Description' => '<p>A description of the patch baseline.</p>', 'GetPatchBaselineResult$Description' => '<p>A description of the patch baseline.</p>', 'PatchBaselineIdentity$BaselineDescription' => '<p>The description of the patch baseline.</p>', 'UpdatePatchBaselineRequest$Description' => '<p>A description of the patch baseline.</p>', 'UpdatePatchBaselineResult$Description' => '<p>A description of the patch baseline.</p>', ], ], 'BaselineId' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineResult$BaselineId' => '<p>The ID of the created patch baseline.</p>', 'DeletePatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to delete.</p>', 'DeletePatchBaselineResult$BaselineId' => '<p>The ID of the deleted patch baseline.</p>', 'DeregisterPatchBaselineForPatchGroupRequest$BaselineId' => '<p>The ID of the patch baseline to deregister the patch group from.</p>', 'DeregisterPatchBaselineForPatchGroupResult$BaselineId' => '<p>The ID of the patch baseline the patch group was deregistered from.</p>', 'DescribeEffectivePatchesForPatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to retrieve the effective patches for.</p>', 'GetDefaultPatchBaselineResult$BaselineId' => '<p>The ID of the default patch baseline.</p>', 'GetPatchBaselineForPatchGroupResult$BaselineId' => '<p>The ID of the patch baseline that should be used for the patch group.</p>', 'GetPatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to retrieve.</p> <note> <p>To retrieve information about an Amazon Web Services managed patch baseline, specify the full Amazon Resource Name (ARN) of the baseline. For example, for the baseline <code>AWS-AmazonLinuxDefaultPatchBaseline</code>, specify <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0e392de35e7c563b7</code> instead of <code>pb-0e392de35e7c563b7</code>.</p> </note>', 'GetPatchBaselineResult$BaselineId' => '<p>The ID of the retrieved patch baseline.</p>', 'InstancePatchState$BaselineId' => '<p>The ID of the patch baseline used to patch the managed node.</p>', 'PatchBaselineIdentity$BaselineId' => '<p>The ID of the patch baseline.</p>', 'RegisterDefaultPatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline that should be the default patch baseline.</p>', 'RegisterDefaultPatchBaselineResult$BaselineId' => '<p>The ID of the default patch baseline.</p>', 'RegisterPatchBaselineForPatchGroupRequest$BaselineId' => '<p>The ID of the patch baseline to register with the patch group.</p>', 'RegisterPatchBaselineForPatchGroupResult$BaselineId' => '<p>The ID of the patch baseline the patch group was registered with.</p>', 'UpdatePatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to update.</p>', 'UpdatePatchBaselineResult$BaselineId' => '<p>The ID of the deleted patch baseline.</p>', ], ], 'BaselineName' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$Name' => '<p>The name of the patch baseline.</p>', 'GetPatchBaselineResult$Name' => '<p>The name of the patch baseline.</p>', 'PatchBaselineIdentity$BaselineName' => '<p>The name of the patch baseline.</p>', 'UpdatePatchBaselineRequest$Name' => '<p>The name of the patch baseline.</p>', 'UpdatePatchBaselineResult$Name' => '<p>The name of the patch baseline.</p>', ], ], 'BaselineOverride' => [ 'base' => '<p>Defines the basic information about a patch baseline override.</p>', 'refs' => [ 'GetDeployablePatchSnapshotForInstanceRequest$BaselineOverride' => '<p>Defines the basic information about a patch baseline override.</p>', ], ], 'BatchErrorMessage' => [ 'base' => NULL, 'refs' => [ 'FailedCreateAssociation$Message' => '<p>A description of the failure.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Activation$Expired' => '<p>Whether or not the activation is expired.</p>', 'AutomationExecution$StepExecutionsTruncated' => '<p>A boolean value that indicates if the response contains the full list of the Automation step executions. If true, use the DescribeAutomationStepExecutions API operation to get the full list of step executions.</p>', 'BaselineOverride$ApprovedPatchesEnableNonSecurity' => '<p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>', 'CreatePatchBaselineRequest$ApprovedPatchesEnableNonSecurity' => '<p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>', 'DeleteDocumentRequest$Force' => '<p>Some SSM document types require that you specify a <code>Force</code> flag before you can delete the document. For example, you must specify a <code>Force</code> flag to delete a document of type <code>ApplicationConfigurationSchema</code>. You can restrict access to the <code>Force</code> flag in an Identity and Access Management (IAM) policy.</p>', 'DeregisterTargetFromMaintenanceWindowRequest$Safe' => '<p>The system checks if the target is being referenced by a task. If the target is being referenced, the system returns an error and doesn\'t deregister the target from the maintenance window.</p>', 'DescribeAutomationStepExecutionsRequest$ReverseOrder' => '<p>Indicates whether to list step executions in reverse order by start time. The default value is \'false\'.</p>', 'DocumentVersionInfo$IsDefaultVersion' => '<p>An identifier for the default version of the document.</p>', 'GetParameterHistoryRequest$WithDecryption' => '<p>Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>', 'GetParameterRequest$WithDecryption' => '<p>Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>', 'GetParametersByPathRequest$Recursive' => '<p>Retrieve all parameters within a hierarchy.</p> <important> <p>If a user has access to a path, then the user can access all levels of that path. For example, if a user has permission to access path <code>/a</code>, then the user can also access <code>/a/b</code>. Even if a user has explicitly been denied access in IAM for parameter <code>/a/b</code>, they can still call the GetParametersByPath API operation recursively for <code>/a</code> and view <code>/a/b</code>.</p> </important>', 'GetParametersByPathRequest$WithDecryption' => '<p>Retrieve all parameters in a hierarchy with their value decrypted.</p>', 'GetParametersRequest$WithDecryption' => '<p>Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>', 'GetPatchBaselineResult$ApprovedPatchesEnableNonSecurity' => '<p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>', 'InstanceInformation$IsLatestVersion' => '<p>Indicates whether the latest version of SSM Agent is running on your Linux managed node. This field doesn\'t indicate whether or not the latest version is installed on Windows managed nodes, because some older versions of Windows Server use the EC2Config service to process Systems Manager requests.</p>', 'ListCommandInvocationsRequest$Details' => '<p>(Optional) If set this returns the response of the command executions and any command output. The default value is <code>false</code>. </p>', 'PatchRule$EnableNonSecurity' => '<p>For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>', 'PutParameterRequest$Overwrite' => '<p>Overwrite an existing parameter. The default value is <code>false</code>.</p>', 'ResolvedTargets$Truncated' => '<p>A boolean value indicating whether the resolved target list is truncated.</p>', 'StartChangeRequestExecutionRequest$AutoApprove' => '<p>Indicates whether the change request can be approved automatically without the need for manual approvals.</p> <p>If <code>AutoApprovable</code> is enabled in a change template, then setting <code>AutoApprove</code> to <code>true</code> in <code>StartChangeRequestExecution</code> creates a change request that bypasses approver review.</p> <note> <p>Change Calendar restrictions are not bypassed in this scenario. If the state of an associated calendar is <code>CLOSED</code>, change freeze approvers must still grant permission for this change request to run. If they don\'t, the change won\'t be processed until the calendar state is again <code>OPEN</code>. </p> </note>', 'StepExecution$IsEnd' => '<p>The flag which can be used to end automation no matter whether the step succeeds or fails.</p>', 'StepExecution$IsCritical' => '<p>The flag which can be used to help decide whether the failure of current step leads to the Automation failure.</p>', 'UpdateMaintenanceWindowRequest$Replace' => '<p>If <code>True</code>, then all fields that are required by the <a>CreateMaintenanceWindow</a> operation are also required for this API request. Optional fields that aren\'t specified are set to null. </p>', 'UpdateMaintenanceWindowTargetRequest$Replace' => '<p>If <code>True</code>, then all fields that are required by the <a>RegisterTargetWithMaintenanceWindow</a> operation are also required for this API request. Optional fields that aren\'t specified are set to null.</p>', 'UpdateMaintenanceWindowTaskRequest$Replace' => '<p>If True, then all fields that are required by the <a>RegisterTaskWithMaintenanceWindow</a> operation are also required for this API request. Optional fields that aren\'t specified are set to null.</p>', 'UpdatePatchBaselineRequest$ApprovedPatchesEnableNonSecurity' => '<p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>', 'UpdatePatchBaselineRequest$Replace' => '<p>If True, then all fields that are required by the <a>CreatePatchBaseline</a> operation are also required for this API request. Optional fields that aren\'t specified are set to null.</p>', 'UpdatePatchBaselineResult$ApprovedPatchesEnableNonSecurity' => '<p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>', ], ], 'CalendarNameOrARN' => [ 'base' => NULL, 'refs' => [ 'CalendarNameOrARNList$member' => NULL, ], ], 'CalendarNameOrARNList' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$CalendarNames' => '<p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. The associations only run when that change calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change Calendar</a>.</p>', 'AssociationVersionInfo$CalendarNames' => '<p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. The associations for this version only run when that Change Calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change Calendar</a>.</p>', 'CreateAssociationBatchRequestEntry$CalendarNames' => '<p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. The associations only run when that Change Calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change Calendar</a>.</p>', 'CreateAssociationRequest$CalendarNames' => '<p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to gate your associations under. The associations only run when that change calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change Calendar</a>.</p>', 'GetCalendarStateRequest$CalendarNames' => '<p>The names or Amazon Resource Names (ARNs) of the Systems Manager documents (SSM documents) that represent the calendar entries for which you want to get the state.</p>', 'UpdateAssociationRequest$CalendarNames' => '<p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to gate your associations under. The associations only run when that change calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change Calendar</a>.</p>', ], ], 'CalendarState' => [ 'base' => NULL, 'refs' => [ 'GetCalendarStateResponse$State' => '<p>The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates that actions aren\'t allowed to proceed.</p>', ], ], 'CancelCommandRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'CancelCommandResult' => [ 'base' => '<p>Whether or not the command was successfully canceled. There is no guarantee that a request can be canceled.</p>', 'refs' => [], ], 'CancelMaintenanceWindowExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelMaintenanceWindowExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'Category' => [ 'base' => NULL, 'refs' => [ 'CategoryEnumList$member' => NULL, 'CategoryList$member' => NULL, ], ], 'CategoryEnumList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$CategoryEnum' => '<p>The value that identifies a document\'s category.</p>', ], ], 'CategoryList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Category' => '<p>The classification of a document to help you identify and categorize its use.</p>', ], ], 'ChangeDetailsValue' => [ 'base' => NULL, 'refs' => [ 'StartChangeRequestExecutionRequest$ChangeDetails' => '<p>User-provided details about the change. If no details are provided, content specified in the <b>Template information</b> section of the associated change template is added.</p>', ], ], 'ChangeRequestName' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$ChangeRequestName' => '<p>The name of the Change Manager change request.</p>', 'AutomationExecutionMetadata$ChangeRequestName' => '<p>The name of the Change Manager change request.</p>', 'StartChangeRequestExecutionRequest$ChangeRequestName' => '<p>The name of the change request associated with the runbook workflow to be run.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'CreatePatchBaselineRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'RegisterTargetWithMaintenanceWindowRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'RegisterTaskWithMaintenanceWindowRequest$ClientToken' => '<p>User-provided idempotency token.</p>', ], ], 'CloudWatchLogGroupName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchOutputConfig$CloudWatchLogGroupName' => '<p>The name of the CloudWatch Logs log group where you want to send command output. If you don\'t specify a group name, Amazon Web Services Systems Manager automatically creates a log group for you. The log group uses the following naming format:</p> <p> <code>aws/ssm/<i>SystemsManagerDocumentName</i> </code> </p>', ], ], 'CloudWatchOutputConfig' => [ 'base' => '<p>Configuration options for sending command output to Amazon CloudWatch Logs.</p>', 'refs' => [ 'Command$CloudWatchOutputConfig' => '<p>Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command output.</p>', 'CommandInvocation$CloudWatchOutputConfig' => '<p>Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command output.</p>', 'GetCommandInvocationResult$CloudWatchOutputConfig' => '<p>Amazon CloudWatch Logs information where Systems Manager sent the command output.</p>', 'MaintenanceWindowRunCommandParameters$CloudWatchOutputConfig' => NULL, 'SendCommandRequest$CloudWatchOutputConfig' => '<p>Enables Amazon Web Services Systems Manager to send Run Command output to Amazon CloudWatch Logs. Run Command is a capability of Amazon Web Services Systems Manager.</p>', ], ], 'CloudWatchOutputEnabled' => [ 'base' => NULL, 'refs' => [ 'CloudWatchOutputConfig$CloudWatchOutputEnabled' => '<p>Enables Systems Manager to send command output to CloudWatch Logs.</p>', ], ], 'Command' => [ 'base' => '<p>Describes a command request.</p>', 'refs' => [ 'CommandList$member' => NULL, 'SendCommandResult$Command' => '<p>The request as it was received by Systems Manager. Also provides the command ID which can be used future references to this request.</p>', ], ], 'CommandFilter' => [ 'base' => '<p>Describes a command filter.</p> <note> <p>A managed node ID can\'t be specified when a command status is <code>Pending</code> because the command hasn\'t run on the node yet.</p> </note>', 'refs' => [ 'CommandFilterList$member' => NULL, ], ], 'CommandFilterKey' => [ 'base' => NULL, 'refs' => [ 'CommandFilter$key' => '<p>The name of the filter.</p> <note> <p>The <code>ExecutionStage</code> filter can\'t be used with the <code>ListCommandInvocations</code> operation, only with <code>ListCommands</code>.</p> </note>', ], ], 'CommandFilterList' => [ 'base' => NULL, 'refs' => [ 'ListCommandInvocationsRequest$Filters' => '<p>(Optional) One or more filters. Use a filter to return a more specific list of results.</p>', 'ListCommandsRequest$Filters' => '<p>(Optional) One or more filters. Use a filter to return a more specific list of results. </p>', ], ], 'CommandFilterValue' => [ 'base' => NULL, 'refs' => [ 'CommandFilter$value' => '<p>The filter value. Valid values for each filter key are as follows:</p> <ul> <li> <p> <b>InvokedAfter</b>: Specify a timestamp to limit your results. For example, specify <code>2021-07-07T00:00:00Z</code> to see a list of command executions occurring July 7, 2021, and later.</p> </li> <li> <p> <b>InvokedBefore</b>: Specify a timestamp to limit your results. For example, specify <code>2021-07-07T00:00:00Z</code> to see a list of command executions from before July 7, 2021.</p> </li> <li> <p> <b>Status</b>: Specify a valid command status to see a list of all command executions with that status. The status choices depend on the API you call.</p> <p>The status values you can specify for <code>ListCommands</code> are:</p> <ul> <li> <p> <code>Pending</code> </p> </li> <li> <p> <code>InProgress</code> </p> </li> <li> <p> <code>Success</code> </p> </li> <li> <p> <code>Cancelled</code> </p> </li> <li> <p> <code>Failed</code> </p> </li> <li> <p> <code>TimedOut</code> (this includes both Delivery and Execution time outs) </p> </li> <li> <p> <code>AccessDenied</code> </p> </li> <li> <p> <code>DeliveryTimedOut</code> </p> </li> <li> <p> <code>ExecutionTimedOut</code> </p> </li> <li> <p> <code>Incomplete</code> </p> </li> <li> <p> <code>NoInstancesInTag</code> </p> </li> <li> <p> <code>LimitExceeded</code> </p> </li> </ul> <p>The status values you can specify for <code>ListCommandInvocations</code> are:</p> <ul> <li> <p> <code>Pending</code> </p> </li> <li> <p> <code>InProgress</code> </p> </li> <li> <p> <code>Delayed</code> </p> </li> <li> <p> <code>Success</code> </p> </li> <li> <p> <code>Cancelled</code> </p> </li> <li> <p> <code>Failed</code> </p> </li> <li> <p> <code>TimedOut</code> (this includes both Delivery and Execution time outs) </p> </li> <li> <p> <code>AccessDenied</code> </p> </li> <li> <p> <code>DeliveryTimedOut</code> </p> </li> <li> <p> <code>ExecutionTimedOut</code> </p> </li> <li> <p> <code>Undeliverable</code> </p> </li> <li> <p> <code>InvalidPlatform</code> </p> </li> <li> <p> <code>Terminated</code> </p> </li> </ul> </li> <li> <p> <b>DocumentName</b>: Specify name of the Amazon Web Services Systems Manager document (SSM document) for which you want to see command execution results. For example, specify <code>AWS-RunPatchBaseline</code> to see command executions that used this SSM document to perform security patching operations on managed nodes. </p> </li> <li> <p> <b>ExecutionStage</b>: Specify one of the following values (<code>ListCommands</code> operations only):</p> <ul> <li> <p> <code>Executing</code>: Returns a list of command executions that are currently still running.</p> </li> <li> <p> <code>Complete</code>: Returns a list of command executions that have already completed. </p> </li> </ul> </li> </ul>', ], ], 'CommandId' => [ 'base' => NULL, 'refs' => [ 'CancelCommandRequest$CommandId' => '<p>The ID of the command you want to cancel.</p>', 'Command$CommandId' => '<p>A unique identifier for this command.</p>', 'CommandInvocation$CommandId' => '<p>The command against which this invocation was requested.</p>', 'GetCommandInvocationRequest$CommandId' => '<p>(Required) The parent command ID of the invocation plugin.</p>', 'GetCommandInvocationResult$CommandId' => '<p>The parent command ID of the invocation plugin.</p>', 'ListCommandInvocationsRequest$CommandId' => '<p>(Optional) The invocations for a specific command ID.</p>', 'ListCommandsRequest$CommandId' => '<p>(Optional) If provided, lists only the specified command.</p>', ], ], 'CommandInvocation' => [ 'base' => '<p>An invocation is a copy of a command sent to a specific managed node. A command can apply to one or more managed nodes. A command invocation applies to one managed node. For example, if a user runs <code>SendCommand</code> against three managed nodes, then a command invocation is created for each requested managed node ID. A command invocation returns status and detail information about a command you ran. </p>', 'refs' => [ 'CommandInvocationList$member' => NULL, ], ], 'CommandInvocationList' => [ 'base' => NULL, 'refs' => [ 'ListCommandInvocationsResult$CommandInvocations' => '<p>(Optional) A list of all invocations. </p>', ], ], 'CommandInvocationStatus' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$Status' => '<p>Whether or not the invocation succeeded, failed, or is pending.</p>', 'GetCommandInvocationResult$Status' => '<p>The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.</p>', ], ], 'CommandList' => [ 'base' => NULL, 'refs' => [ 'ListCommandsResult$Commands' => '<p>(Optional) The list of commands requested by the user. </p>', ], ], 'CommandMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCommandInvocationsRequest$MaxResults' => '<p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListCommandsRequest$MaxResults' => '<p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'CommandPlugin' => [ 'base' => '<p>Describes plugin details.</p>', 'refs' => [ 'CommandPluginList$member' => NULL, ], ], 'CommandPluginList' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$CommandPlugins' => '<p>Plugins processed by the command.</p>', ], ], 'CommandPluginName' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$Name' => '<p>The name of the plugin. Must be one of the following: <code>aws:updateAgent</code>, <code>aws:domainjoin</code>, <code>aws:applications</code>, <code>aws:runPowerShellScript</code>, <code>aws:psmodule</code>, <code>aws:cloudWatch</code>, <code>aws:runShellScript</code>, or <code>aws:updateSSMAgent</code>. </p>', 'GetCommandInvocationRequest$PluginName' => '<p>The name of the plugin for which you want detailed results. If the document contains only one plugin, you can omit the name and details for that plugin. If the document contains more than one plugin, you must specify the name of the plugin for which you want to view details.</p> <p>Plugin names are also referred to as <i>step names</i> in Systems Manager documents (SSM documents). For example, <code>aws:RunShellScript</code> is a plugin.</p> <p>To find the <code>PluginName</code>, check the document content and find the name of the plugin. Alternatively, use <a>ListCommandInvocations</a> with the <code>CommandId</code> and <code>Details</code> parameters. The <code>PluginName</code> is the <code>Name</code> attribute of the <code>CommandPlugin</code> object in the <code>CommandPlugins</code> list.</p>', 'GetCommandInvocationResult$PluginName' => '<p>The name of the plugin, or <i>step name</i>, for which details are reported. For example, <code>aws:RunShellScript</code> is a plugin.</p>', ], ], 'CommandPluginOutput' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$Output' => '<p>Output of the plugin execution.</p>', ], ], 'CommandPluginStatus' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$Status' => '<p>The status of this plugin. You can run a document with multiple plugins.</p>', ], ], 'CommandStatus' => [ 'base' => NULL, 'refs' => [ 'Command$Status' => '<p>The status of the command.</p>', ], ], 'Comment' => [ 'base' => NULL, 'refs' => [ 'Command$Comment' => '<p>User-specified information about the command, such as a brief description of what the command should do.</p>', 'CommandInvocation$Comment' => '<p>User-specified information about the command, such as a brief description of what the command should do.</p>', 'GetCommandInvocationResult$Comment' => '<p>The comment text for the command.</p>', 'MaintenanceWindowRunCommandParameters$Comment' => '<p>Information about the commands to run.</p>', 'SendCommandRequest$Comment' => '<p>User-specified information about the command, such as a brief description of what the command should do.</p>', ], ], 'CompletedCount' => [ 'base' => NULL, 'refs' => [ 'Command$CompletedCount' => '<p>The number of targets for which the command invocation reached a terminal state. Terminal states include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Cancelled, Terminated, or Undeliverable.</p>', ], ], 'ComplianceExecutionId' => [ 'base' => NULL, 'refs' => [ 'ComplianceExecutionSummary$ExecutionId' => '<p>An ID created by the system when <code>PutComplianceItems</code> was called. For example, <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.</p>', ], ], 'ComplianceExecutionSummary' => [ 'base' => '<p>A summary of the call execution that includes an execution ID, the type of execution (for example, <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'.</p>', 'refs' => [ 'ComplianceItem$ExecutionSummary' => '<p>A summary for the compliance item. The summary includes an execution ID, the execution type (for example, command), and the execution time.</p>', 'PutComplianceItemsRequest$ExecutionSummary' => '<p>A summary of the call execution that includes an execution ID, the type of execution (for example, <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'.</p>', 'ResourceComplianceSummaryItem$ExecutionSummary' => '<p>Information about the execution.</p>', ], ], 'ComplianceExecutionType' => [ 'base' => NULL, 'refs' => [ 'ComplianceExecutionSummary$ExecutionType' => '<p>The type of execution. For example, <code>Command</code> is a valid execution type.</p>', ], ], 'ComplianceFilterValue' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilterValueList$member' => NULL, ], ], 'ComplianceItem' => [ 'base' => '<p>Information about the compliance as defined by the resource type. For example, for a patch resource type, <code>Items</code> includes information about the PatchSeverity, Classification, and so on.</p>', 'refs' => [ 'ComplianceItemList$member' => NULL, ], ], 'ComplianceItemContentHash' => [ 'base' => NULL, 'refs' => [ 'PutComplianceItemsRequest$ItemContentHash' => '<p>MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be overwritten or ignored. If the content hashes match, the request to put compliance information is ignored.</p>', ], ], 'ComplianceItemDetails' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Details' => '<p>A "Key": "Value" tag combination for the compliance item.</p>', 'ComplianceItemEntry$Details' => '<p>A "Key": "Value" tag combination for the compliance item.</p>', ], ], 'ComplianceItemEntry' => [ 'base' => '<p>Information about a compliance item.</p>', 'refs' => [ 'ComplianceItemEntryList$member' => NULL, ], ], 'ComplianceItemEntryList' => [ 'base' => NULL, 'refs' => [ 'PutComplianceItemsRequest$Items' => '<p>Information about the compliance as defined by the resource type. For example, for a patch compliance type, <code>Items</code> includes information about the PatchSeverity, Classification, and so on.</p>', ], ], 'ComplianceItemId' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Id' => '<p>An ID for the compliance item. For example, if the compliance item is a Windows patch, the ID could be the number of the KB article; for example: KB4010320.</p>', 'ComplianceItemEntry$Id' => '<p>The compliance item ID. For example, if the compliance item is a Windows patch, the ID could be the number of the KB article.</p>', ], ], 'ComplianceItemList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsResult$ComplianceItems' => '<p>A list of compliance information for the specified resource ID. </p>', ], ], 'ComplianceItemTitle' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Title' => '<p>A title for the compliance item. For example, if the compliance item is a Windows patch, the title could be the title of the KB article for the patch; for example: Security Update for Active Directory Federation Services.</p>', 'ComplianceItemEntry$Title' => '<p>The title of the compliance item. For example, if the compliance item is a Windows patch, the title could be the title of the KB article for the patch; for example: Security Update for Active Directory Federation Services. </p>', ], ], 'ComplianceQueryOperatorType' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilter$Type' => '<p>The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan, or GreaterThan.</p>', ], ], 'ComplianceResourceId' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$ResourceId' => '<p>An ID for the resource. For a managed node, this is the node ID.</p>', 'ComplianceResourceIdList$member' => NULL, 'PutComplianceItemsRequest$ResourceId' => '<p>Specify an ID for this resource. For a managed node, this is the node ID.</p>', 'ResourceComplianceSummaryItem$ResourceId' => '<p>The resource ID.</p>', ], ], 'ComplianceResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsRequest$ResourceIds' => '<p>The ID for the resources from which to get compliance information. Currently, you can only specify one resource ID.</p>', ], ], 'ComplianceResourceType' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$ResourceType' => '<p>The type of resource. <code>ManagedInstance</code> is currently the only supported resource type.</p>', 'ComplianceResourceTypeList$member' => NULL, 'PutComplianceItemsRequest$ResourceType' => '<p>Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.</p>', 'ResourceComplianceSummaryItem$ResourceType' => '<p>The resource type.</p>', ], ], 'ComplianceResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsRequest$ResourceTypes' => '<p>The type of resource from which to get compliance information. Currently, the only supported resource type is <code>ManagedInstance</code>.</p>', ], ], 'ComplianceSeverity' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Severity' => '<p>The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low, Informational, Unspecified.</p>', 'ComplianceItemEntry$Severity' => '<p>The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low, Informational, Unspecified.</p>', 'ResourceComplianceSummaryItem$OverallSeverity' => '<p>The highest severity item found for the resource. The resource is compliant for this item.</p>', ], ], 'ComplianceStatus' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Status' => '<p>The status of the compliance item. An item is either COMPLIANT, NON_COMPLIANT, or an empty string (for Windows patches that aren\'t applicable).</p>', 'ComplianceItemEntry$Status' => '<p>The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.</p>', 'ResourceComplianceSummaryItem$Status' => '<p>The compliance status for the resource.</p>', ], ], 'ComplianceStringFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'refs' => [ 'ComplianceStringFilterList$member' => NULL, ], ], 'ComplianceStringFilterKey' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilter$Key' => '<p>The name of the filter.</p>', ], ], 'ComplianceStringFilterList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsRequest$Filters' => '<p>One or more compliance filters. Use a filter to return a more specific list of results.</p>', 'ListComplianceSummariesRequest$Filters' => '<p>One or more compliance or inventory filters. Use a filter to return a more specific list of results.</p>', 'ListResourceComplianceSummariesRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'ComplianceStringFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilter$Values' => '<p>The value for which to search.</p>', ], ], 'ComplianceSummaryCount' => [ 'base' => NULL, 'refs' => [ 'CompliantSummary$CompliantCount' => '<p>The total number of resources that are compliant.</p>', 'NonCompliantSummary$NonCompliantCount' => '<p>The total number of compliance items that aren\'t compliant.</p>', 'SeveritySummary$CriticalCount' => '<p>The total number of resources or compliance items that have a severity level of critical. Critical severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$HighCount' => '<p>The total number of resources or compliance items that have a severity level of high. High severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$MediumCount' => '<p>The total number of resources or compliance items that have a severity level of medium. Medium severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$LowCount' => '<p>The total number of resources or compliance items that have a severity level of low. Low severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$InformationalCount' => '<p>The total number of resources or compliance items that have a severity level of informational. Informational severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$UnspecifiedCount' => '<p>The total number of resources or compliance items that have a severity level of unspecified. Unspecified severity is determined by the organization that published the compliance items.</p>', ], ], 'ComplianceSummaryItem' => [ 'base' => '<p>A summary of compliance information by compliance type.</p>', 'refs' => [ 'ComplianceSummaryItemList$member' => NULL, ], ], 'ComplianceSummaryItemList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceSummariesResult$ComplianceSummaryItems' => '<p>A list of compliant and non-compliant summary counts based on compliance types. For example, this call returns State Manager associations, patches, or custom compliance types according to the filter criteria that you specified.</p>', ], ], 'ComplianceTypeCountLimitExceededException' => [ 'base' => '<p>You specified too many custom compliance types. You can specify a maximum of 10 different types. </p>', 'refs' => [], ], 'ComplianceTypeName' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$ComplianceType' => '<p>The compliance type. For example, Association (for a State Manager association), Patch, or Custom:<code>string</code> are all valid compliance types.</p>', 'ComplianceSummaryItem$ComplianceType' => '<p>The type of compliance item. For example, the compliance type can be Association, Patch, or Custom:string.</p>', 'PutComplianceItemsRequest$ComplianceType' => '<p>Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or Custom:<code>string</code>.</p>', 'ResourceComplianceSummaryItem$ComplianceType' => '<p>The compliance type.</p>', ], ], 'ComplianceUploadType' => [ 'base' => NULL, 'refs' => [ 'PutComplianceItemsRequest$UploadType' => '<p>The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>. In <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the resource. You must provide a full list of compliance items each time you send the request.</p> <p>In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association. The association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By default, all requests use <code>COMPLETE</code> mode.</p> <note> <p>This attribute is only valid for association compliance.</p> </note>', ], ], 'CompliantSummary' => [ 'base' => '<p>A summary of resources that are compliant. The summary is organized according to the resource count for each compliance type.</p>', 'refs' => [ 'ComplianceSummaryItem$CompliantSummary' => '<p>A list of COMPLIANT items for the specified compliance type.</p>', 'ResourceComplianceSummaryItem$CompliantSummary' => '<p>A list of items that are compliant for the resource.</p>', ], ], 'ComputerName' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$ComputerName' => '<p>The fully qualified host name of the managed node.</p>', ], ], 'ConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'GetConnectionStatusResponse$Status' => '<p>The status of the connection to the managed node. For example, \'Connected\' or \'Not Connected\'.</p>', ], ], 'ContentLength' => [ 'base' => NULL, 'refs' => [ 'AttachmentContent$Size' => '<p>The size of an attachment in bytes.</p>', ], ], 'CreateActivationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateActivationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationBatchRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationBatchRequestEntries' => [ 'base' => NULL, 'refs' => [ 'CreateAssociationBatchRequest$Entries' => '<p>One or more associations.</p>', ], ], 'CreateAssociationBatchRequestEntry' => [ 'base' => '<p>Describes the association of a Amazon Web Services Systems Manager document (SSM document) and a managed node.</p>', 'refs' => [ 'CreateAssociationBatchRequestEntries$member' => NULL, 'FailedCreateAssociation$Entry' => '<p>The association.</p>', ], ], 'CreateAssociationBatchResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateOpsItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOpsItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateOpsMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOpsMetadataResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatePatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatedDate' => [ 'base' => NULL, 'refs' => [ 'Activation$CreatedDate' => '<p>The date the activation was created.</p>', ], ], 'CustomSchemaCountLimitExceededException' => [ 'base' => '<p>You have exceeded the limit for custom schemas. Delete one or more custom schemas and try again.</p>', 'refs' => [], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'Association$LastExecutionDate' => '<p>The date on which the association was last run.</p>', 'AssociationDescription$Date' => '<p>The date when the association was made.</p>', 'AssociationDescription$LastUpdateAssociationDate' => '<p>The date when the association was last updated.</p>', 'AssociationDescription$LastExecutionDate' => '<p>The date on which the association was last run.</p>', 'AssociationDescription$LastSuccessfulExecutionDate' => '<p>The last date on which the association was successfully run.</p>', 'AssociationExecution$CreatedTime' => '<p>The time the execution started.</p>', 'AssociationExecution$LastExecutionDate' => '<p>The date of the last execution.</p>', 'AssociationExecutionTarget$LastExecutionDate' => '<p>The date of the last execution.</p>', 'AssociationStatus$Date' => '<p>The date when the status changed.</p>', 'AssociationVersionInfo$CreatedDate' => '<p>The date the association version was created.</p>', 'AutomationExecution$ExecutionStartTime' => '<p>The time the execution started.</p>', 'AutomationExecution$ExecutionEndTime' => '<p>The time the execution finished.</p>', 'AutomationExecution$ScheduledTime' => '<p>The date and time the Automation operation is scheduled to start.</p>', 'AutomationExecutionMetadata$ExecutionStartTime' => '<p>The time the execution started.</p>', 'AutomationExecutionMetadata$ExecutionEndTime' => '<p>The time the execution finished. This isn\'t populated if the execution is still in progress.</p>', 'AutomationExecutionMetadata$ScheduledTime' => '<p>The date and time the Automation operation is scheduled to start.</p>', 'Command$ExpiresAfter' => '<p>If this time is reached and the command hasn\'t already started running, it won\'t run. Calculated based on the <code>ExpiresAfter</code> user input provided as part of the <code>SendCommand</code> API operation.</p>', 'Command$RequestedDateTime' => '<p>The date and time the command was requested.</p>', 'CommandInvocation$RequestedDateTime' => '<p>The time and date the request was sent to this managed node.</p>', 'CommandPlugin$ResponseStartDateTime' => '<p>The time the plugin started running. </p>', 'CommandPlugin$ResponseFinishDateTime' => '<p>The time the plugin stopped running. Could stop prematurely if, for example, a cancel command was sent. </p>', 'ComplianceExecutionSummary$ExecutionTime' => '<p>The time the execution ran as a datetime object that is saved in the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'.</p>', 'CreateOpsItemRequest$ActualStartTime' => '<p>The time a runbook workflow started. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'CreateOpsItemRequest$ActualEndTime' => '<p>The time a runbook workflow ended. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'CreateOpsItemRequest$PlannedStartTime' => '<p>The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'CreateOpsItemRequest$PlannedEndTime' => '<p>The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'DocumentDescription$CreatedDate' => '<p>The date when the document was created.</p>', 'DocumentIdentifier$CreatedDate' => '<p>The date the SSM document was created.</p>', 'DocumentReviewerResponseSource$CreateTime' => '<p>The date and time that a reviewer entered a response to a document review request.</p>', 'DocumentReviewerResponseSource$UpdatedTime' => '<p>The date and time that a reviewer last updated a response to a document review request.</p>', 'DocumentVersionInfo$CreatedDate' => '<p>The date the document was created.</p>', 'GetDocumentResult$CreatedDate' => '<p>The date the SSM document was created.</p>', 'GetMaintenanceWindowExecutionResult$StartTime' => '<p>The time the maintenance window started running.</p>', 'GetMaintenanceWindowExecutionResult$EndTime' => '<p>The time the maintenance window finished running.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$StartTime' => '<p>The time that the task started running on the target.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$EndTime' => '<p>The time that the task finished running on the target.</p>', 'GetMaintenanceWindowExecutionTaskResult$StartTime' => '<p>The time the task execution started.</p>', 'GetMaintenanceWindowExecutionTaskResult$EndTime' => '<p>The time the task execution completed.</p>', 'GetMaintenanceWindowResult$CreatedDate' => '<p>The date the maintenance window was created.</p>', 'GetMaintenanceWindowResult$ModifiedDate' => '<p>The date the maintenance window was last modified.</p>', 'GetPatchBaselineResult$CreatedDate' => '<p>The date the patch baseline was created.</p>', 'GetPatchBaselineResult$ModifiedDate' => '<p>The date the patch baseline was last modified.</p>', 'InstanceAssociationStatusInfo$ExecutionDate' => '<p>The date the association ran. </p>', 'InstanceInformation$LastPingDateTime' => '<p>The date and time when the agent last pinged the Systems Manager service. </p>', 'InstanceInformation$RegistrationDate' => '<p>The date the server or VM was registered with Amazon Web Services as a managed node.</p>', 'InstanceInformation$LastAssociationExecutionDate' => '<p>The date the association was last run.</p>', 'InstanceInformation$LastSuccessfulAssociationExecutionDate' => '<p>The last date the association was successfully run.</p>', 'InstancePatchState$OperationStartTime' => '<p>The time the most recent patching operation was started on the managed node.</p>', 'InstancePatchState$OperationEndTime' => '<p>The time the most recent patching operation completed on the managed node.</p>', 'InstancePatchState$LastNoRebootInstallOperationTime' => '<p>The time of the last attempt to patch the managed node with <code>NoReboot</code> specified as the reboot option.</p>', 'MaintenanceWindowExecution$StartTime' => '<p>The time the execution started.</p>', 'MaintenanceWindowExecution$EndTime' => '<p>The time the execution finished.</p>', 'MaintenanceWindowExecutionTaskIdentity$StartTime' => '<p>The time the task execution started.</p>', 'MaintenanceWindowExecutionTaskIdentity$EndTime' => '<p>The time the task execution finished.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$StartTime' => '<p>The time the invocation started.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$EndTime' => '<p>The time the invocation finished.</p>', 'OpsItem$CreatedTime' => '<p>The date and time the OpsItem was created.</p>', 'OpsItem$LastModifiedTime' => '<p>The date and time the OpsItem was last updated.</p>', 'OpsItem$ActualStartTime' => '<p>The time a runbook workflow started. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'OpsItem$ActualEndTime' => '<p>The time a runbook workflow ended. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'OpsItem$PlannedStartTime' => '<p>The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'OpsItem$PlannedEndTime' => '<p>The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'OpsItemEventSummary$CreatedTime' => '<p>The date and time the OpsItem event was created.</p>', 'OpsItemRelatedItemSummary$CreatedTime' => '<p>The time the related-item association was created.</p>', 'OpsItemRelatedItemSummary$LastModifiedTime' => '<p>The time the related-item association was last updated.</p>', 'OpsItemSummary$CreatedTime' => '<p>The date and time the OpsItem was created.</p>', 'OpsItemSummary$LastModifiedTime' => '<p>The date and time the OpsItem was last updated.</p>', 'OpsItemSummary$ActualStartTime' => '<p>The time a runbook workflow started. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'OpsItemSummary$ActualEndTime' => '<p>The time a runbook workflow ended. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'OpsItemSummary$PlannedStartTime' => '<p>The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'OpsItemSummary$PlannedEndTime' => '<p>The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'OpsMetadata$LastModifiedDate' => '<p>The date the OpsMetadata object was last updated.</p>', 'OpsMetadata$CreationDate' => '<p>The date the OpsMetadata objects was created.</p>', 'Parameter$LastModifiedDate' => '<p>Date the parameter was last changed or updated and the parameter version was created.</p>', 'ParameterHistory$LastModifiedDate' => '<p>Date the parameter was last changed or updated.</p>', 'ParameterMetadata$LastModifiedDate' => '<p>Date the parameter was last changed or updated.</p>', 'Patch$ReleaseDate' => '<p>The date the patch was released.</p>', 'PatchComplianceData$InstalledTime' => '<p>The date/time the patch was installed on the managed node. Not all operating systems provide this level of information.</p>', 'PatchStatus$ApprovalDate' => '<p>The date the patch was approved (or will be approved if the status is <code>PENDING_APPROVAL</code>).</p>', 'ReviewInformation$ReviewedTime' => '<p>The time that the reviewer took action on the document review request.</p>', 'ServiceSetting$LastModifiedDate' => '<p>The last time the service setting was modified.</p>', 'Session$StartDate' => '<p>The date and time, in ISO-8601 Extended format, when the session began.</p>', 'Session$EndDate' => '<p>The date and time, in ISO-8601 Extended format, when the session was terminated.</p>', 'StartChangeRequestExecutionRequest$ScheduledTime' => '<p>The date and time specified in the change request to run the Automation runbooks.</p> <note> <p>The Automation runbooks specified for the runbook workflow can\'t run until all required approvals for the change request have been received.</p> </note>', 'StartChangeRequestExecutionRequest$ScheduledEndTime' => '<p>The time that the requester expects the runbook workflow related to the change request to complete. The time is an estimate only that the requester provides for reviewers.</p>', 'StepExecution$ExecutionStartTime' => '<p>If a step has begun execution, this contains the time the step started. If the step is in Pending status, this field isn\'t populated.</p>', 'StepExecution$ExecutionEndTime' => '<p>If a step has finished execution, this contains the time the execution ended. If the step hasn\'t yet concluded, this field isn\'t populated.</p>', 'UpdateOpsItemRequest$ActualStartTime' => '<p>The time a runbook workflow started. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'UpdateOpsItemRequest$ActualEndTime' => '<p>The time a runbook workflow ended. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'UpdateOpsItemRequest$PlannedStartTime' => '<p>The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'UpdateOpsItemRequest$PlannedEndTime' => '<p>The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>', 'UpdatePatchBaselineResult$CreatedDate' => '<p>The date when the patch baseline was created.</p>', 'UpdatePatchBaselineResult$ModifiedDate' => '<p>The date when the patch baseline was last modified.</p>', ], ], 'DefaultBaseline' => [ 'base' => NULL, 'refs' => [ 'PatchBaselineIdentity$DefaultBaseline' => '<p>Whether this is the default baseline. Amazon Web Services Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.</p>', ], ], 'DefaultInstanceName' => [ 'base' => NULL, 'refs' => [ 'Activation$DefaultInstanceName' => '<p>A name for the managed node when it is created.</p>', 'CreateActivationRequest$DefaultInstanceName' => '<p>The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or when you use the Amazon Web Services command line tools to list Systems Manager resources.</p> <important> <p>Don\'t enter personally identifiable information in this field.</p> </important>', ], ], 'DeleteActivationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActivationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInventoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInventoryResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOpsMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOpsMetadataResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParameterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DeletePatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'DeliveryTimedOutCount' => [ 'base' => NULL, 'refs' => [ 'Command$DeliveryTimedOutCount' => '<p>The number of targets for which the status is Delivery Timed Out.</p>', ], ], 'DeregisterManagedInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterManagedInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterPatchBaselineForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterPatchBaselineForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetFromMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetFromMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTaskFromMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTaskFromMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivationsFilter' => [ 'base' => '<p>Filter for the DescribeActivation API.</p>', 'refs' => [ 'DescribeActivationsFilterList$member' => NULL, ], ], 'DescribeActivationsFilterKeys' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsFilter$FilterKey' => '<p>The name of the filter.</p>', ], ], 'DescribeActivationsFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsRequest$Filters' => '<p>A filter to view information about your activations.</p>', ], ], 'DescribeActivationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationExecutionTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationExecutionTargetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationExecutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutomationExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutomationExecutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutomationStepExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutomationStepExecutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailablePatchesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailablePatchesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectiveInstanceAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectiveInstanceAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectivePatchesForPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectivePatchesForPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAssociationsStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAssociationsStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceInformationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceInformationResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInventoryDeletionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInventoryDeletionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTaskInvocationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowScheduleResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTargetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowsForTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowsForTargetResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOpsItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOpsItemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchBaselinesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchBaselinesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupStateResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchPropertiesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionInDocument' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Description' => '<p>A description of the document. </p>', ], ], 'DisassociateOpsItemRelatedItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateOpsItemRelatedItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'DocumentARN' => [ 'base' => NULL, 'refs' => [ 'Association$Name' => '<p>The name of the SSM document.</p>', 'AssociationDescription$Name' => '<p>The name of the SSM document.</p>', 'AssociationVersionInfo$Name' => '<p>The name specified when the association was created.</p>', 'CreateAssociationBatchRequestEntry$Name' => '<p>The name of the SSM document that contains the configuration information for the managed node. You can specify Command or Automation runbooks.</p> <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another account.</p> <p>For SSM documents that are shared with you from other Amazon Web Services accounts, you must specify the complete SSM document ARN, in the following format:</p> <p> <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code> </p> <p>For example:</p> <p> <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code> </p> <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.</p>', 'CreateAssociationRequest$Name' => '<p>The name of the SSM Command document or Automation runbook that contains the configuration information for the managed node.</p> <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another account.</p> <p>For Systems Manager documents (SSM documents) that are shared with you from other Amazon Web Services accounts, you must specify the complete SSM document ARN, in the following format:</p> <p> <code>arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code> </p> <p>For example:</p> <p> <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code> </p> <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.</p>', 'DeleteAssociationRequest$Name' => '<p>The name of the SSM document.</p>', 'DescribeAssociationRequest$Name' => '<p>The name of the SSM document.</p>', 'DescribeDocumentRequest$Name' => '<p>The name of the SSM document.</p>', 'DocumentDescription$Name' => '<p>The name of the SSM document.</p>', 'DocumentIdentifier$Name' => '<p>The name of the SSM document.</p>', 'DocumentRequires$Name' => '<p>The name of the required SSM document. The name can be an Amazon Resource Name (ARN).</p>', 'GetDocumentRequest$Name' => '<p>The name of the SSM document.</p>', 'GetDocumentResult$Name' => '<p>The name of the SSM document.</p>', 'InstanceAssociationStatusInfo$Name' => '<p>The name of the association.</p>', 'ListDocumentVersionsRequest$Name' => '<p>The name of the document. You can specify an Amazon Resource Name (ARN).</p>', 'Runbook$DocumentName' => '<p>The name of the Automation runbook used in a runbook workflow.</p>', 'SendCommandRequest$DocumentName' => '<p>The name of the Amazon Web Services Systems Manager document (SSM document) to run. This can be a public document or a custom document. To run a shared document belonging to another account, specify the document Amazon Resource Name (ARN). For more information about how to use shared documents, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared SSM documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <note> <p>If you specify a document name or ARN that hasn\'t been shared with your account, you receive an <code>InvalidDocument</code> error. </p> </note>', 'StartAutomationExecutionRequest$DocumentName' => '<p>The name of the SSM document to run. This can be a public document or a custom document. To run a shared document belonging to another account, specify the document ARN. For more information about how to use shared documents, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared SSM documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'StartChangeRequestExecutionRequest$DocumentName' => '<p>The name of the change template document to run during the runbook workflow.</p>', 'StartSessionRequest$DocumentName' => '<p>The name of the SSM document to define the parameters and plugin settings for the session. For example, <code>SSM-SessionManagerRunShell</code>. You can call the <a>GetDocument</a> API to verify the document exists before attempting to start a session. If no document name is provided, a shell to the managed node is launched by default.</p>', 'UpdateAssociationRequest$Name' => '<p>The name of the SSM Command document or Automation runbook that contains the configuration information for the managed node.</p> <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another account.</p> <p>For Systems Manager document (SSM document) that are shared with you from other Amazon Web Services accounts, you must specify the complete SSM document ARN, in the following format:</p> <p> <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code> </p> <p>For example:</p> <p> <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code> </p> <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.</p>', 'UpdateAssociationStatusRequest$Name' => '<p>The name of the SSM document.</p>', ], ], 'DocumentAlreadyExists' => [ 'base' => '<p>The specified document already exists.</p>', 'refs' => [], ], 'DocumentAuthor' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Author' => '<p>The user in your organization who created the document.</p>', 'DocumentIdentifier$Author' => '<p>The user in your organization who created the document.</p>', 'ListDocumentMetadataHistoryResponse$Author' => '<p>The user ID of the person in the organization who requested the review of the change template.</p>', ], ], 'DocumentContent' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$Content' => '<p>The content for the new SSM document in JSON or YAML format. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.</p> <p>For examples, see the following topics in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (Amazon Web Services API)</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (Amazon Web Services CLI)</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)</a> </p> </li> </ul>', 'GetDocumentResult$Content' => '<p>The contents of the SSM document.</p>', 'InstanceAssociation$Content' => '<p>The content of the association document for the managed node(s).</p>', 'UpdateDocumentRequest$Content' => '<p>A valid JSON or YAML string.</p>', ], ], 'DocumentDefaultVersionDescription' => [ 'base' => '<p>A default version of a document.</p>', 'refs' => [ 'UpdateDocumentDefaultVersionResult$Description' => '<p>The description of a custom document that you want to set as the default version.</p>', ], ], 'DocumentDescription' => [ 'base' => '<p>Describes an Amazon Web Services Systems Manager document (SSM document). </p>', 'refs' => [ 'CreateDocumentResult$DocumentDescription' => '<p>Information about the SSM document.</p>', 'DescribeDocumentResult$Document' => '<p>Information about the SSM document.</p>', 'UpdateDocumentResult$DocumentDescription' => '<p>A description of the document that was updated.</p>', ], ], 'DocumentDisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$DisplayName' => '<p>An optional field where you can specify a friendly name for the SSM document. This value can differ for each version of the document. You can update this value at a later time using the <a>UpdateDocument</a> operation.</p>', 'DocumentDescription$DisplayName' => '<p>The friendly name of the SSM document. This value can differ for each version of the document. If you want to update this value, see <a>UpdateDocument</a>.</p>', 'DocumentIdentifier$DisplayName' => '<p>An optional field where you can specify a friendly name for the SSM document. This value can differ for each version of the document. If you want to update this value, see <a>UpdateDocument</a>.</p>', 'DocumentVersionInfo$DisplayName' => '<p>The friendly name of the SSM document. This value can differ for each version of the document. If you want to update this value, see <a>UpdateDocument</a>.</p>', 'GetDocumentResult$DisplayName' => '<p>The friendly name of the SSM document. This value can differ for each version of the document. If you want to update this value, see <a>UpdateDocument</a>.</p>', 'UpdateDocumentRequest$DisplayName' => '<p>The friendly name of the SSM document that you want to update. This value can differ for each version of the document. If you don\'t specify a value for this parameter in your request, the existing value is applied to the new document version.</p>', ], ], 'DocumentFilter' => [ 'base' => '<p>This data type is deprecated. Instead, use <a>DocumentKeyValuesFilter</a>.</p>', 'refs' => [ 'DocumentFilterList$member' => NULL, ], ], 'DocumentFilterKey' => [ 'base' => NULL, 'refs' => [ 'DocumentFilter$key' => '<p>The name of the filter.</p>', ], ], 'DocumentFilterList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentsRequest$DocumentFilterList' => '<p>This data type is deprecated. Instead, use <code>Filters</code>.</p>', ], ], 'DocumentFilterValue' => [ 'base' => NULL, 'refs' => [ 'DocumentFilter$value' => '<p>The value of the filter.</p>', ], ], 'DocumentFormat' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$DocumentFormat' => '<p>Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the default format.</p>', 'DocumentDescription$DocumentFormat' => '<p>The document format, either JSON or YAML.</p>', 'DocumentIdentifier$DocumentFormat' => '<p>The document format, either JSON or YAML.</p>', 'DocumentVersionInfo$DocumentFormat' => '<p>The document format, either JSON or YAML.</p>', 'GetDocumentRequest$DocumentFormat' => '<p>Returns the document in the specified format. The document format can be either JSON or YAML. JSON is the default format.</p>', 'GetDocumentResult$DocumentFormat' => '<p>The document format, either JSON or YAML.</p>', 'UpdateDocumentRequest$DocumentFormat' => '<p>Specify the document format for the new document version. Systems Manager supports JSON and YAML documents. JSON is the default format.</p>', ], ], 'DocumentHash' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Hash' => '<p>The Sha256 or Sha1 hash created by the system when the document was created. </p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', 'MaintenanceWindowRunCommandParameters$DocumentHash' => '<p>The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.</p>', 'SendCommandRequest$DocumentHash' => '<p>The Sha256 or Sha1 hash created by the system when the document was created. </p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', ], ], 'DocumentHashType' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$HashType' => '<p>The hash type of the document. Valid values include <code>Sha256</code> or <code>Sha1</code>.</p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', 'MaintenanceWindowRunCommandParameters$DocumentHashType' => '<p>SHA-256 or SHA-1. SHA-1 hashes have been deprecated.</p>', 'SendCommandRequest$DocumentHashType' => '<p>Sha256 or Sha1.</p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', ], ], 'DocumentIdentifier' => [ 'base' => '<p>Describes the name of a SSM document.</p>', 'refs' => [ 'DocumentIdentifierList$member' => NULL, ], ], 'DocumentIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentsResult$DocumentIdentifiers' => '<p>The names of the SSM documents.</p>', ], ], 'DocumentKeyValuesFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of documents.</p> <p>For keys, you can specify one or more tags that have been applied to a document. </p> <p>You can also use Amazon Web Services-provided keys, some of which have specific allowed values. These keys and their associated values are as follows:</p> <dl> <dt>DocumentType</dt> <dd> <ul> <li> <p> <code>ApplicationConfiguration</code> </p> </li> <li> <p> <code>ApplicationConfigurationSchema</code> </p> </li> <li> <p> <code>Automation</code> </p> </li> <li> <p> <code>ChangeCalendar</code> </p> </li> <li> <p> <code>Command</code> </p> </li> <li> <p> <code>Package</code> </p> </li> <li> <p> <code>Policy</code> </p> </li> <li> <p> <code>Session</code> </p> </li> </ul> </dd> <dt>Owner</dt> <dd> <p>Note that only one <code>Owner</code> can be specified in a request. For example: <code>Key=Owner,Values=Self</code>.</p> <ul> <li> <p> <code>Amazon</code> </p> </li> <li> <p> <code>Private</code> </p> </li> <li> <p> <code>Public</code> </p> </li> <li> <p> <code>Self</code> </p> </li> <li> <p> <code>ThirdParty</code> </p> </li> </ul> </dd> <dt>PlatformTypes</dt> <dd> <ul> <li> <p> <code>Linux</code> </p> </li> <li> <p> <code>Windows</code> </p> </li> </ul> </dd> </dl> <p> <code>Name</code> is another Amazon Web Services-provided key. If you use <code>Name</code> as a key, you can use a name prefix to return a list of documents. For example, in the Amazon Web Services CLI, to return a list of all documents that begin with <code>Te</code>, run the following command:</p> <p> <code>aws ssm list-documents --filters Key=Name,Values=Te</code> </p> <p>You can also use the <code>TargetType</code> Amazon Web Services-provided key. For a list of valid resource type values that can be used with this key, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>.</p> <p>If you specify more than two keys, only documents that are identified by all the tags are returned in the results. If you specify more than two values for a key, documents that are identified by any of the values are returned in the results.</p> <p>To specify a custom key-value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p> <p>For example, if you created a key called region and are using the Amazon Web Services CLI to call the <code>list-documents</code> command: </p> <p> <code>aws ssm list-documents --filters Key=tag:region,Values=east,west Key=Owner,Values=Self</code> </p>', 'refs' => [ 'DocumentKeyValuesFilterList$member' => NULL, ], ], 'DocumentKeyValuesFilterKey' => [ 'base' => NULL, 'refs' => [ 'DocumentKeyValuesFilter$Key' => '<p>The name of the filter key.</p>', ], ], 'DocumentKeyValuesFilterList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentsRequest$Filters' => '<p>One or more <code>DocumentKeyValuesFilter</code> objects. Use a filter to return a more specific list of results. For keys, you can specify one or more key-value pair tags that have been applied to a document. Other valid keys include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>, and <code>TargetType</code>. For example, to return documents you own use <code>Key=Owner,Values=Self</code>. To specify a custom key-value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p> <note> <p>This API operation only supports filtering documents by using a single tag key and one or more tag values. For example: <code>Key=tag:tagName,Values=valueName1,valueName2</code> </p> </note>', ], ], 'DocumentKeyValuesFilterValue' => [ 'base' => NULL, 'refs' => [ 'DocumentKeyValuesFilterValues$member' => NULL, ], ], 'DocumentKeyValuesFilterValues' => [ 'base' => NULL, 'refs' => [ 'DocumentKeyValuesFilter$Values' => '<p>The value for the filter key.</p>', ], ], 'DocumentLimitExceeded' => [ 'base' => '<p>You can have at most 500 active SSM documents.</p>', 'refs' => [], ], 'DocumentMetadataEnum' => [ 'base' => NULL, 'refs' => [ 'ListDocumentMetadataHistoryRequest$Metadata' => '<p>The type of data for which details are being requested. Currently, the only supported value is <code>DocumentReviews</code>.</p>', ], ], 'DocumentMetadataResponseInfo' => [ 'base' => '<p>Details about the response to a document review request.</p>', 'refs' => [ 'ListDocumentMetadataHistoryResponse$Metadata' => '<p>Information about the response to the change template approval request.</p>', ], ], 'DocumentName' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$DocumentName' => '<p>The name of the Automation runbook used during the execution.</p>', 'AutomationExecutionMetadata$DocumentName' => '<p>The name of the Automation runbook used during execution.</p>', 'Command$DocumentName' => '<p>The name of the document requested for execution.</p>', 'CommandInvocation$DocumentName' => '<p>The document name that was requested for execution.</p>', 'CreateDocumentRequest$Name' => '<p>A name for the SSM document.</p> <important> <p>You can\'t use the following strings as document name prefixes. These are reserved by Amazon Web Services for use as document name prefixes:</p> <ul> <li> <p> <code>aws-</code> </p> </li> <li> <p> <code>amazon</code> </p> </li> <li> <p> <code>amzn</code> </p> </li> </ul> </important>', 'DeleteDocumentRequest$Name' => '<p>The name of the document.</p>', 'DescribeDocumentPermissionRequest$Name' => '<p>The name of the document for which you are the owner.</p>', 'DocumentDefaultVersionDescription$Name' => '<p>The name of the document.</p>', 'DocumentVersionInfo$Name' => '<p>The document name.</p>', 'GetCommandInvocationResult$DocumentName' => '<p>The name of the document that was run. For example, <code>AWS-RunShellScript</code>.</p>', 'ListDocumentMetadataHistoryRequest$Name' => '<p>The name of the change template.</p>', 'ListDocumentMetadataHistoryResponse$Name' => '<p>The name of the change template.</p>', 'ModifyDocumentPermissionRequest$Name' => '<p>The name of the document that you want to share.</p>', 'Session$DocumentName' => '<p>The name of the Session Manager SSM document used to define the parameters and plugin settings for the session. For example, <code>SSM-SessionManagerRunShell</code>.</p>', 'UpdateDocumentDefaultVersionRequest$Name' => '<p>The name of a custom document that you want to set as the default version.</p>', 'UpdateDocumentMetadataRequest$Name' => '<p>The name of the change template for which a version\'s metadata is to be updated.</p>', 'UpdateDocumentRequest$Name' => '<p>The name of the SSM document that you want to update.</p>', ], ], 'DocumentOwner' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Owner' => '<p>The Amazon Web Services user account that created the document.</p>', 'DocumentIdentifier$Owner' => '<p>The Amazon Web Services user account that created the document.</p>', ], ], 'DocumentParameter' => [ 'base' => '<p>Parameters specified in a System Manager document that run on the server when the command is run. </p>', 'refs' => [ 'DocumentParameterList$member' => NULL, ], ], 'DocumentParameterDefaultValue' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$DefaultValue' => '<p>If specified, the default values for the parameters. Parameters without a default value are required. Parameters with a default value are optional.</p>', ], ], 'DocumentParameterDescrption' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$Description' => '<p>A description of what the parameter does, how to use it, the default value, and whether or not the parameter is optional.</p>', ], ], 'DocumentParameterList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Parameters' => '<p>A description of the parameters for a document.</p>', ], ], 'DocumentParameterName' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$Name' => '<p>The name of the parameter.</p>', ], ], 'DocumentParameterType' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$Type' => '<p>The type of parameter. The type can be either String or StringList.</p>', ], ], 'DocumentPermissionLimit' => [ 'base' => '<p>The document can\'t be shared with more Amazon Web Services user accounts. You can share a document with a maximum of 20 accounts. You can publicly share up to five documents. If you need to increase this limit, contact Amazon Web Services Support.</p>', 'refs' => [], ], 'DocumentPermissionMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeDocumentPermissionRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'DocumentPermissionType' => [ 'base' => NULL, 'refs' => [ 'DescribeDocumentPermissionRequest$PermissionType' => '<p>The permission type for the document. The permission type can be <i>Share</i>.</p>', 'ModifyDocumentPermissionRequest$PermissionType' => '<p>The permission type for the document. The permission type can be <i>Share</i>.</p>', ], ], 'DocumentRequires' => [ 'base' => '<p>An SSM document required by the current document.</p>', 'refs' => [ 'DocumentRequiresList$member' => NULL, ], ], 'DocumentRequiresList' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$Requires' => '<p>A list of SSM documents required by a document. This parameter is used exclusively by AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AppConfig?</a> in the <i>AppConfig User Guide</i>.</p>', 'DocumentDescription$Requires' => '<p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>', 'DocumentIdentifier$Requires' => '<p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>', 'GetDocumentResult$Requires' => '<p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>', ], ], 'DocumentReviewAction' => [ 'base' => NULL, 'refs' => [ 'DocumentReviews$Action' => '<p>The action to take on a document approval review request.</p>', ], ], 'DocumentReviewComment' => [ 'base' => NULL, 'refs' => [ 'DocumentReviewCommentSource$Content' => '<p>The content of a comment entered by a user who requests a review of a new document version, or who reviews the new version.</p>', ], ], 'DocumentReviewCommentList' => [ 'base' => NULL, 'refs' => [ 'DocumentReviewerResponseSource$Comment' => '<p>The comment entered by a reviewer as part of their document review response.</p>', 'DocumentReviews$Comment' => '<p>A comment entered by a user in your organization about the document review request.</p>', ], ], 'DocumentReviewCommentSource' => [ 'base' => '<p>Information about comments added to a document review request.</p>', 'refs' => [ 'DocumentReviewCommentList$member' => NULL, ], ], 'DocumentReviewCommentType' => [ 'base' => NULL, 'refs' => [ 'DocumentReviewCommentSource$Type' => '<p>The type of information added to a review request. Currently, only the value <code>Comment</code> is supported.</p>', ], ], 'DocumentReviewerResponseList' => [ 'base' => NULL, 'refs' => [ 'DocumentMetadataResponseInfo$ReviewerResponse' => '<p>Details about a reviewer\'s response to a document review request.</p>', ], ], 'DocumentReviewerResponseSource' => [ 'base' => '<p>Information about a reviewer\'s response to a document review request.</p>', 'refs' => [ 'DocumentReviewerResponseList$member' => NULL, ], ], 'DocumentReviews' => [ 'base' => '<p>Information about a document approval review.</p>', 'refs' => [ 'UpdateDocumentMetadataRequest$DocumentReviews' => '<p>The change template review details to update.</p>', ], ], 'DocumentSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$SchemaVersion' => '<p>The schema version.</p>', 'DocumentIdentifier$SchemaVersion' => '<p>The schema version.</p>', ], ], 'DocumentSha1' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Sha1' => '<p>The SHA1 hash of the document, which you can use for verification.</p>', ], ], 'DocumentStatus' => [ 'base' => '<p>The status of a document.</p>', 'refs' => [ 'DocumentDescription$Status' => '<p>The status of the SSM document.</p>', 'DocumentVersionInfo$Status' => '<p>The status of the SSM document, such as <code>Creating</code>, <code>Active</code>, <code>Failed</code>, and <code>Deleting</code>.</p>', 'GetDocumentResult$Status' => '<p>The status of the SSM document, such as <code>Creating</code>, <code>Active</code>, <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.</p>', ], ], 'DocumentStatusInformation' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$StatusInformation' => '<p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket doesn\'t exist. Verify that the URL of the S3 bucket is correct."</p>', 'DocumentVersionInfo$StatusInformation' => '<p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket doesn\'t exist. Verify that the URL of the S3 bucket is correct."</p>', 'GetDocumentResult$StatusInformation' => '<p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket doesn\'t exist. Verify that the URL of the S3 bucket is correct."</p>', ], ], 'DocumentType' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$DocumentType' => '<p>The type of document to create.</p> <note> <p>The <code>DeploymentStrategy</code> document type is an internal-use-only document type reserved for AppConfig.</p> </note>', 'DocumentDescription$DocumentType' => '<p>The type of document.</p>', 'DocumentIdentifier$DocumentType' => '<p>The document type.</p>', 'GetDocumentResult$DocumentType' => '<p>The document type.</p>', ], ], 'DocumentVersion' => [ 'base' => NULL, 'refs' => [ 'Association$DocumentVersion' => '<p>The version of the document used in the association.</p> <important> <p>State Manager doesn\'t support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the <code>default</code> version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to <code>default</code>.</p> </important>', 'AssociationDescription$DocumentVersion' => '<p>The document version.</p>', 'AssociationVersionInfo$DocumentVersion' => '<p>The version of an Amazon Web Services Systems Manager document (SSM document) used when the association version was created.</p>', 'AutomationExecution$DocumentVersion' => '<p>The version of the document to use during execution.</p>', 'AutomationExecutionMetadata$DocumentVersion' => '<p>The document version used during the execution.</p>', 'Command$DocumentVersion' => '<p>The Systems Manager document (SSM document) version.</p>', 'CommandInvocation$DocumentVersion' => '<p>The Systems Manager document (SSM document) version.</p>', 'CreateAssociationBatchRequestEntry$DocumentVersion' => '<p>The document version.</p>', 'CreateAssociationRequest$DocumentVersion' => '<p>The document version you want to associate with the target(s). Can be a specific version or the default version.</p> <important> <p>State Manager doesn\'t support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the <code>default</code> version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to <code>default</code>.</p> </important>', 'DeleteDocumentRequest$DocumentVersion' => '<p>The version of the document that you want to delete. If not provided, all versions of the document are deleted.</p>', 'DescribeDocumentRequest$DocumentVersion' => '<p>The document version for which you want information. Can be a specific version or the default version.</p>', 'DocumentDefaultVersionDescription$DefaultVersion' => '<p>The default version of the document.</p>', 'DocumentDescription$DocumentVersion' => '<p>The document version.</p>', 'DocumentDescription$LatestVersion' => '<p>The latest version of the document.</p>', 'DocumentDescription$DefaultVersion' => '<p>The default version.</p>', 'DocumentDescription$ApprovedVersion' => '<p>The version of the document currently approved for use in the organization.</p>', 'DocumentDescription$PendingReviewVersion' => '<p>The version of the document that is currently under review.</p>', 'DocumentIdentifier$DocumentVersion' => '<p>The document version.</p>', 'DocumentRequires$Version' => '<p>The document version required by the current document.</p>', 'DocumentVersionInfo$DocumentVersion' => '<p>The document version.</p>', 'GetCommandInvocationResult$DocumentVersion' => '<p>The Systems Manager document (SSM document) version used in the request.</p>', 'GetDocumentRequest$DocumentVersion' => '<p>The document version for which you want information.</p>', 'GetDocumentResult$DocumentVersion' => '<p>The document version.</p>', 'InstanceAssociationStatusInfo$DocumentVersion' => '<p>The association document versions.</p>', 'ListDocumentMetadataHistoryRequest$DocumentVersion' => '<p>The version of the change template.</p>', 'ListDocumentMetadataHistoryResponse$DocumentVersion' => '<p>The version of the change template.</p>', 'MaintenanceWindowAutomationParameters$DocumentVersion' => '<p>The version of an Automation runbook to use during task execution.</p>', 'MaintenanceWindowRunCommandParameters$DocumentVersion' => '<p>The Amazon Web Services Systems Manager document (SSM document) version to use in the request. You can specify <code>$DEFAULT</code>, <code>$LATEST</code>, or a specific version number. If you run commands by using the Amazon Web Services CLI, then you must escape the first two options by using a backslash. If you specify a version number, then you don\'t need to use the backslash. For example:</p> <p> <code>--document-version "\\$DEFAULT"</code> </p> <p> <code>--document-version "\\$LATEST"</code> </p> <p> <code>--document-version "3"</code> </p>', 'Runbook$DocumentVersion' => '<p>The version of the Automation runbook used in a runbook workflow.</p>', 'SendCommandRequest$DocumentVersion' => '<p>The SSM document version to use in the request. You can specify $DEFAULT, $LATEST, or a specific version number. If you run commands by using the Command Line Interface (Amazon Web Services CLI), then you must escape the first two options by using a backslash. If you specify a version number, then you don\'t need to use the backslash. For example:</p> <p>--document-version "\\$DEFAULT"</p> <p>--document-version "\\$LATEST"</p> <p>--document-version "3"</p>', 'StartAutomationExecutionRequest$DocumentVersion' => '<p>The version of the Automation runbook to use for this execution.</p>', 'StartChangeRequestExecutionRequest$DocumentVersion' => '<p>The version of the change template document to run during the runbook workflow.</p>', 'UpdateAssociationRequest$DocumentVersion' => '<p>The document version you want update for the association. </p> <important> <p>State Manager doesn\'t support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the <code>default</code> version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to <code>default</code>.</p> </important>', 'UpdateDocumentMetadataRequest$DocumentVersion' => '<p>The version of a change template in which to update approval metadata.</p>', 'UpdateDocumentRequest$DocumentVersion' => '<p>The version of the document that you want to update. Currently, Systems Manager supports updating only the latest version of the document. You can specify the version number of the latest version or use the <code>$LATEST</code> variable.</p>', ], ], 'DocumentVersionInfo' => [ 'base' => '<p>Version information about the document.</p>', 'refs' => [ 'DocumentVersionList$member' => NULL, ], ], 'DocumentVersionLimitExceeded' => [ 'base' => '<p>The document has too many versions. Delete one or more document versions and try again.</p>', 'refs' => [], ], 'DocumentVersionList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentVersionsResult$DocumentVersions' => '<p>The document versions.</p>', ], ], 'DocumentVersionName' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$VersionName' => '<p>An optional field specifying the version of the artifact you are creating with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can\'t be changed.</p>', 'DeleteDocumentRequest$VersionName' => '<p>The version name of the document that you want to delete. If not provided, all versions of the document are deleted.</p>', 'DescribeDocumentRequest$VersionName' => '<p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can\'t be changed.</p>', 'DocumentDefaultVersionDescription$DefaultVersionName' => '<p>The default version of the artifact associated with the document.</p>', 'DocumentDescription$VersionName' => '<p>The version of the artifact associated with the document.</p>', 'DocumentIdentifier$VersionName' => '<p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can\'t be changed.</p>', 'DocumentVersionInfo$VersionName' => '<p>The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can\'t be changed.</p>', 'GetDocumentRequest$VersionName' => '<p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document and can\'t be changed.</p>', 'GetDocumentResult$VersionName' => '<p>The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can\'t be changed.</p>', 'UpdateDocumentRequest$VersionName' => '<p>An optional field specifying the version of the artifact you are updating with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can\'t be changed.</p>', ], ], 'DocumentVersionNumber' => [ 'base' => NULL, 'refs' => [ 'UpdateDocumentDefaultVersionRequest$DocumentVersion' => '<p>The version of a custom document that you want to set as the default version.</p>', ], ], 'DoesNotExistException' => [ 'base' => '<p>Error returned when the ID specified for a resource, such as a maintenance window or patch baseline, doesn\'t exist.</p> <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'refs' => [], ], 'DryRun' => [ 'base' => NULL, 'refs' => [ 'DeleteInventoryRequest$DryRun' => '<p>Use this option to view a summary of the deletion request without deleting any data or the data type. This option is useful when you only want to understand what will be deleted. Once you validate that the data to be deleted is what you intend to delete, you can run the same command without specifying the <code>DryRun</code> option.</p>', ], ], 'DuplicateDocumentContent' => [ 'base' => '<p>The content of the association document matches another document. Change the content of the document and try again.</p>', 'refs' => [], ], 'DuplicateDocumentVersionName' => [ 'base' => '<p>The version name has already been used in this document. Specify a different version name, and then try again.</p>', 'refs' => [], ], 'DuplicateInstanceId' => [ 'base' => '<p>You can\'t specify a managed node ID in more than one association.</p>', 'refs' => [], ], 'EffectiveInstanceAssociationMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeEffectiveInstanceAssociationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'EffectivePatch' => [ 'base' => '<p>The <code>EffectivePatch</code> structure defines metadata about a patch along with the approval state of the patch in a particular patch baseline. The approval state includes information about whether the patch is currently approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch was or will be approved.</p>', 'refs' => [ 'EffectivePatchList$member' => NULL, ], ], 'EffectivePatchList' => [ 'base' => NULL, 'refs' => [ 'DescribeEffectivePatchesForPatchBaselineResult$EffectivePatches' => '<p>An array of patches and patch status.</p>', ], ], 'ErrorCount' => [ 'base' => NULL, 'refs' => [ 'Command$ErrorCount' => '<p>The number of targets for which the status is Failed or Execution Timed Out.</p>', ], ], 'ExecutionMode' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$Mode' => '<p>The automation execution mode.</p>', 'AutomationExecutionMetadata$Mode' => '<p>The Automation execution mode.</p>', 'StartAutomationExecutionRequest$Mode' => '<p>The execution mode of the automation. Valid modes include the following: Auto and Interactive. The default mode is Auto.</p>', ], ], 'ExecutionRoleName' => [ 'base' => NULL, 'refs' => [ 'TargetLocation$ExecutionRoleName' => '<p>The Automation execution role used by the currently running Automation. If not specified, the default value is <code>AWS-SystemsManager-AutomationExecutionRole</code>.</p>', ], ], 'ExpirationDate' => [ 'base' => NULL, 'refs' => [ 'Activation$ExpirationDate' => '<p>The date when this activation can no longer be used to register managed nodes.</p>', 'CreateActivationRequest$ExpirationDate' => '<p>The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don\'t provide an expiration date, the activation code expires in 24 hours.</p>', ], ], 'FailedCreateAssociation' => [ 'base' => '<p>Describes a failed association.</p>', 'refs' => [ 'FailedCreateAssociationList$member' => NULL, ], ], 'FailedCreateAssociationList' => [ 'base' => NULL, 'refs' => [ 'CreateAssociationBatchResult$Failed' => '<p>Information about the associations that failed.</p>', ], ], 'FailureDetails' => [ 'base' => '<p>Information about an Automation failure.</p>', 'refs' => [ 'StepExecution$FailureDetails' => '<p>Information about the Automation failure.</p>', ], ], 'Fault' => [ 'base' => NULL, 'refs' => [ 'FailedCreateAssociation$Fault' => '<p>The source of the failure.</p>', ], ], 'FeatureNotAvailableException' => [ 'base' => '<p>You attempted to register a <code>LAMBDA</code> or <code>STEP_FUNCTIONS</code> task in a region where the corresponding service isn\'t available. </p>', 'refs' => [], ], 'GetAutomationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAutomationExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetCalendarStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCalendarStateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCommandInvocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCommandInvocationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDeployablePatchSnapshotForInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeployablePatchSnapshotForInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInventoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInventoryResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInventorySchemaMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'GetInventorySchemaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInventorySchemaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskInvocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskInvocationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'GetOpsItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOpsItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetOpsMetadataMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetOpsMetadataRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'GetOpsMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOpsMetadataResult' => [ 'base' => NULL, 'refs' => [], ], 'GetOpsSummaryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOpsSummaryResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterHistoryResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersByPathMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetParametersByPathRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'GetParametersByPathRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersByPathResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceSettingRequest' => [ 'base' => '<p>The request body of the GetServiceSetting API operation.</p>', 'refs' => [], ], 'GetServiceSettingResult' => [ 'base' => '<p>The query result body of the GetServiceSetting API operation.</p>', 'refs' => [], ], 'HierarchyLevelLimitExceededException' => [ 'base' => '<p>A hierarchy can have a maximum of 15 levels. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">Requirements and constraints for parameter names</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>', 'refs' => [], ], 'HierarchyTypeMismatchException' => [ 'base' => '<p>Parameter Store doesn\'t support changing a parameter type in a hierarchy. For example, you can\'t change a parameter from a <code>String</code> type to a <code>SecureString</code> type. You must create a new, unique parameter.</p>', 'refs' => [], ], 'IPAddress' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$IPAddress' => '<p>The IP address of the managed node.</p>', ], ], 'ISO8601String' => [ 'base' => NULL, 'refs' => [ 'GetCalendarStateRequest$AtTime' => '<p>(Optional) The specific time for which you want to get calendar state information, in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you don\'t specify a value or <code>AtTime</code>, the current time is used.</p>', 'GetCalendarStateResponse$AtTime' => '<p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you specified in your command. If you don\'t specify a time, <code>GetCalendarState</code> uses the current time.</p>', 'GetCalendarStateResponse$NextTransitionTime' => '<p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the calendar state will change. If the current calendar state is <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar state changes to <code>CLOSED</code>, and vice-versa.</p>', ], ], 'IamRole' => [ 'base' => NULL, 'refs' => [ 'Activation$IamRole' => '<p>The Identity and Access Management (IAM) role to assign to the managed node.</p>', 'CreateActivationRequest$IamRole' => '<p>The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal <code>ssm.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM service role for a hybrid environment</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'InstanceInformation$IamRole' => '<p>The Identity and Access Management (IAM) role assigned to the on-premises Systems Manager managed node. This call doesn\'t return the IAM role for Amazon Elastic Compute Cloud (Amazon EC2) instances. To retrieve the IAM role for an EC2 instance, use the Amazon EC2 <code>DescribeInstances</code> operation. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> in the <i>Amazon EC2 API Reference</i> or <a href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances</a> in the <i>Amazon Web Services CLI Command Reference</i>.</p>', 'UpdateManagedInstanceRoleRequest$IamRole' => '<p>The IAM role you want to assign or change.</p>', ], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'StartAutomationExecutionRequest$ClientToken' => '<p>User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and can\'t be reused.</p>', 'StartChangeRequestExecutionRequest$ClientToken' => '<p>The user-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and can\'t be reused.</p>', ], ], 'IdempotentParameterMismatch' => [ 'base' => '<p>Error returned when an idempotent operation is retried and the parameters don\'t match the original call to the API with the same idempotency token. </p>', 'refs' => [], ], 'IncompatiblePolicyException' => [ 'base' => '<p>There is a conflict in the policies specified for this parameter. You can\'t, for example, specify two Expiration policies for a parameter. Review your policies, and try again.</p>', 'refs' => [], ], 'InstallOverrideList' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstallOverrideList' => '<p>An https URL or an Amazon Simple Storage Service (Amazon S3) path-style URL to a list of patches to be installed. This patch installation list, which you maintain in an S3 bucket in YAML format and specify in the SSM document <code>AWS-RunPatchBaseline</code>, overrides the patches specified by the default patch baseline.</p> <p>For more information about the <code>InstallOverrideList</code> parameter, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-about-aws-runpatchbaseline.html">About the <code>AWS-RunPatchBaseline</code> </a> SSM document in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', ], ], 'InstanceAggregatedAssociationOverview' => [ 'base' => '<p>Status information about the aggregated associations.</p>', 'refs' => [ 'InstanceInformation$AssociationOverview' => '<p>Information about the association.</p>', ], ], 'InstanceAssociation' => [ 'base' => '<p>One or more association documents on the managed node. </p>', 'refs' => [ 'InstanceAssociationList$member' => NULL, ], ], 'InstanceAssociationExecutionSummary' => [ 'base' => NULL, 'refs' => [ 'InstanceAssociationStatusInfo$ExecutionSummary' => '<p>Summary information about association execution.</p>', ], ], 'InstanceAssociationList' => [ 'base' => NULL, 'refs' => [ 'DescribeEffectiveInstanceAssociationsResult$Associations' => '<p>The associations for the requested managed node.</p>', ], ], 'InstanceAssociationOutputLocation' => [ 'base' => '<p>An S3 bucket where you want to store the results of this request.</p> <p>For the minimal permissions required to enable Amazon S3 output for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-state-assoc.html">Creating associations</a> in the <i>Systems Manager User Guide</i>. </p>', 'refs' => [ 'AssociationDescription$OutputLocation' => '<p>An S3 bucket where you want to store the output details of the request.</p>', 'AssociationVersionInfo$OutputLocation' => '<p>The location in Amazon S3 specified for the association when the association version was created.</p>', 'CreateAssociationBatchRequestEntry$OutputLocation' => '<p>An S3 bucket where you want to store the results of this request.</p>', 'CreateAssociationRequest$OutputLocation' => '<p>An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.</p>', 'UpdateAssociationRequest$OutputLocation' => '<p>An S3 bucket where you want to store the results of this request.</p>', ], ], 'InstanceAssociationOutputUrl' => [ 'base' => '<p>The URL of S3 bucket where you want to store the results of this request.</p>', 'refs' => [ 'InstanceAssociationStatusInfo$OutputUrl' => '<p>A URL for an S3 bucket where you want to store the results of this request.</p>', ], ], 'InstanceAssociationStatusAggregatedCount' => [ 'base' => NULL, 'refs' => [ 'InstanceAggregatedAssociationOverview$InstanceAssociationStatusAggregatedCount' => '<p>The number of associations for the managed node(s).</p>', ], ], 'InstanceAssociationStatusInfo' => [ 'base' => '<p>Status information about the association.</p>', 'refs' => [ 'InstanceAssociationStatusInfos$member' => NULL, ], ], 'InstanceAssociationStatusInfos' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceAssociationsStatusResult$InstanceAssociationStatusInfos' => '<p>Status information about the association.</p>', ], ], 'InstanceCount' => [ 'base' => NULL, 'refs' => [ 'AssociationStatusAggregatedCount$value' => NULL, 'InstanceAssociationStatusAggregatedCount$value' => NULL, ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'Association$InstanceId' => '<p>The managed node ID.</p>', 'AssociationDescription$InstanceId' => '<p>The managed node ID.</p>', 'CommandInvocation$InstanceId' => '<p>The managed node ID in which this invocation was requested.</p>', 'CreateAssociationBatchRequestEntry$InstanceId' => '<p>The managed node ID.</p> <note> <p> <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter <code>InstanceId</code>, you can\'t use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.</p> </note>', 'CreateAssociationRequest$InstanceId' => '<p>The managed node ID.</p> <note> <p> <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter <code>InstanceId</code>, you can\'t use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.</p> </note>', 'DeleteAssociationRequest$InstanceId' => '<p>The managed node ID.</p> <note> <p> <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter <code>InstanceId</code>, you can\'t use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.</p> </note>', 'DescribeAssociationRequest$InstanceId' => '<p>The managed node ID.</p>', 'DescribeEffectiveInstanceAssociationsRequest$InstanceId' => '<p>The managed node ID for which you want to view all associations.</p>', 'DescribeInstanceAssociationsStatusRequest$InstanceId' => '<p>The managed node IDs for which you want association status information.</p>', 'DescribeInstancePatchesRequest$InstanceId' => '<p>The ID of the managed node whose patch state information should be retrieved.</p>', 'GetCommandInvocationRequest$InstanceId' => '<p>(Required) The ID of the managed node targeted by the command. A <i>managed node</i> can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, and on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>', 'GetCommandInvocationResult$InstanceId' => '<p>The ID of the managed node targeted by the command. A <i>managed node</i> can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, or on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>', 'GetDeployablePatchSnapshotForInstanceRequest$InstanceId' => '<p>The ID of the managed node for which the appropriate patch snapshot should be retrieved.</p>', 'GetDeployablePatchSnapshotForInstanceResult$InstanceId' => '<p>The managed node ID.</p>', 'InstanceAssociation$InstanceId' => '<p>The managed node ID.</p>', 'InstanceAssociationStatusInfo$InstanceId' => '<p>The managed node ID where the association was created.</p>', 'InstanceIdList$member' => NULL, 'InstanceInformation$InstanceId' => '<p>The managed node ID. </p>', 'InstancePatchState$InstanceId' => '<p>The ID of the managed node the high-level patch compliance information was collected for.</p>', 'ListCommandInvocationsRequest$InstanceId' => '<p>(Optional) The command execution details for a specific managed node ID.</p>', 'ListCommandsRequest$InstanceId' => '<p>(Optional) Lists commands issued against this managed node ID.</p> <note> <p>You can\'t specify a managed node ID in the same command that you specify <code>Status</code> = <code>Pending</code>. This is because the command hasn\'t reached the managed node yet.</p> </note>', 'ListInventoryEntriesRequest$InstanceId' => '<p>The managed node ID for which you want inventory information.</p>', 'ListInventoryEntriesResult$InstanceId' => '<p>The managed node ID targeted by the request to query inventory information.</p>', 'PutInventoryRequest$InstanceId' => '<p>An managed node ID where you want to add or update inventory items.</p>', 'UpdateAssociationStatusRequest$InstanceId' => '<p>The managed node ID.</p>', ], ], 'InstanceIdList' => [ 'base' => NULL, 'refs' => [ 'CancelCommandRequest$InstanceIds' => '<p>(Optional) A list of managed node IDs on which you want to cancel the command. If not provided, the command is canceled on every node on which it was requested.</p>', 'Command$InstanceIds' => '<p>The managed node IDs against which this command was requested.</p>', 'DescribeInstancePatchStatesRequest$InstanceIds' => '<p>The ID of the managed node for which patch state information should be retrieved.</p>', 'SendCommandRequest$InstanceIds' => '<p>The IDs of the managed nodes where the command should run. Specifying managed node IDs is most useful when you are targeting a limited number of managed nodes, though you can specify up to 50 IDs.</p> <p>To target a larger number of managed nodes, or if you prefer not to list individual node IDs, we recommend using the <code>Targets</code> option instead. Using <code>Targets</code>, which accepts tag key-value pairs to identify the managed nodes to send commands to, you can a send command to tens, hundreds, or thousands of nodes at once.</p> <p>For more information about how to use targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Using targets and rate controls to send commands to a fleet</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', ], ], 'InstanceInformation' => [ 'base' => '<p>Describes a filter for a specific list of managed nodes. </p>', 'refs' => [ 'InstanceInformationList$member' => NULL, ], ], 'InstanceInformationFilter' => [ 'base' => '<p>Describes a filter for a specific list of managed nodes. You can filter node information by using tags. You specify tags by using a key-value mapping.</p> <p>Use this operation instead of the <a>DescribeInstanceInformationRequest$InstanceInformationFilterList</a> method. The <code>InstanceInformationFilterList</code> method is a legacy method and doesn\'t support tags. </p>', 'refs' => [ 'InstanceInformationFilterList$member' => NULL, ], ], 'InstanceInformationFilterKey' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationFilter$key' => '<p>The name of the filter. </p>', ], ], 'InstanceInformationFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationRequest$InstanceInformationFilterList' => '<p>This is a legacy method. We recommend that you don\'t use this method. Instead, use the <code>Filters</code> data type. <code>Filters</code> enables you to return node information by filtering based on tags applied to managed nodes.</p> <note> <p>Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an exception error. </p> </note>', ], ], 'InstanceInformationFilterValue' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationFilterValueSet$member' => NULL, ], ], 'InstanceInformationFilterValueSet' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationFilter$valueSet' => '<p>The filter values.</p>', 'InstanceInformationStringFilter$Values' => '<p>The filter values.</p>', ], ], 'InstanceInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationResult$InstanceInformationList' => '<p>The managed node information list.</p>', ], ], 'InstanceInformationStringFilter' => [ 'base' => '<p>The filters to describe or get information about your managed nodes.</p>', 'refs' => [ 'InstanceInformationStringFilterList$member' => NULL, ], ], 'InstanceInformationStringFilterKey' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationStringFilter$Key' => '<p>The filter key name to describe your managed nodes. For example:</p> <p>"InstanceIds"|"AgentVersion"|"PingStatus"|"PlatformTypes"|"ActivationIds"|"IamRole"|"ResourceType"|"AssociationStatus"|"Tag Key"</p> <important> <p> <code>Tag key</code> isn\'t a valid filter. You must specify either <code>tag-key</code> or <code>tag:keyname</code> and a string. Here are some valid examples: tag-key, tag:123, tag:al!, tag:Windows. Here are some <i>invalid</i> examples: tag-keys, Tag Key, tag:, tagKey, abc:keyname.</p> </important>', ], ], 'InstanceInformationStringFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of managed nodes. You can filter based on tags applied to EC2 instances. Use this <code>Filters</code> data type instead of <code>InstanceInformationFilterList</code>, which is deprecated.</p>', ], ], 'InstancePatchState' => [ 'base' => '<p>Defines the high-level patch compliance state for a managed node, providing information about the number of installed, missing, not applicable, and failed patches along with metadata about the operation when this information was gathered for the managed node.</p>', 'refs' => [ 'InstancePatchStateList$member' => NULL, 'InstancePatchStatesList$member' => NULL, ], ], 'InstancePatchStateFilter' => [ 'base' => '<p>Defines a filter used in <a>DescribeInstancePatchStatesForPatchGroup</a> to scope down the information returned by the API.</p> <p> <b>Example</b>: To filter for all managed nodes in a patch group having more than three patches with a <code>FailedCount</code> status, use the following for the filter:</p> <ul> <li> <p>Value for <code>Key</code>: <code>FailedCount</code> </p> </li> <li> <p>Value for <code>Type</code>: <code>GreaterThan</code> </p> </li> <li> <p>Value for <code>Values</code>: <code>3</code> </p> </li> </ul>', 'refs' => [ 'InstancePatchStateFilterList$member' => NULL, ], ], 'InstancePatchStateFilterKey' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilter$Key' => '<p>The key for the filter. Supported values include the following:</p> <ul> <li> <p> <code>InstalledCount</code> </p> </li> <li> <p> <code>InstalledOtherCount</code> </p> </li> <li> <p> <code>InstalledPendingRebootCount</code> </p> </li> <li> <p> <code>InstalledRejectedCount</code> </p> </li> <li> <p> <code>MissingCount</code> </p> </li> <li> <p> <code>FailedCount</code> </p> </li> <li> <p> <code>UnreportedNotApplicableCount</code> </p> </li> <li> <p> <code>NotApplicableCount</code> </p> </li> </ul>', ], ], 'InstancePatchStateFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesForPatchGroupRequest$Filters' => '<p>Each entry in the array is a structure containing:</p> <ul> <li> <p>Key (string between 1 and 200 characters)</p> </li> <li> <p>Values (array containing a single string)</p> </li> <li> <p>Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")</p> </li> </ul>', ], ], 'InstancePatchStateFilterValue' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilterValues$member' => NULL, ], ], 'InstancePatchStateFilterValues' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilter$Values' => '<p>The value for the filter. Must be an integer greater than or equal to 0.</p>', ], ], 'InstancePatchStateList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesResult$InstancePatchStates' => '<p>The high-level patch state for the requested managed nodes.</p>', ], ], 'InstancePatchStateOperatorType' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilter$Type' => '<p>The type of comparison that should be performed for the value.</p>', ], ], 'InstancePatchStatesList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesForPatchGroupResult$InstancePatchStates' => '<p>The high-level patch state for the requested managed nodes. </p>', ], ], 'InstanceTagName' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$InstanceName' => '<p>The fully qualified host name of the managed node.</p>', ], ], 'InstancesCount' => [ 'base' => NULL, 'refs' => [ 'DescribePatchGroupStateResult$InstancesWithInstalledPendingRebootPatches' => '<p>The number of managed nodes with patches installed by Patch Manager that haven\'t been rebooted after the patch installation. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>', 'DescribePatchGroupStateResult$InstancesWithInstalledRejectedPatches' => '<p>The number of managed nodes with patches installed that are specified in a <code>RejectedPatches</code> list. Patches with a status of <code>INSTALLED_REJECTED</code> were typically installed before they were added to a <code>RejectedPatches</code> list.</p> <note> <p>If <code>ALLOW_AS_DEPENDENCY</code> is the specified option for <code>RejectedPatchesAction</code>, the value of <code>InstancesWithInstalledRejectedPatches</code> will always be <code>0</code> (zero).</p> </note>', 'DescribePatchGroupStateResult$InstancesWithCriticalNonCompliantPatches' => '<p>The number of managed nodes where patches that are specified as <code>Critical</code> for compliance reporting in the patch baseline aren\'t installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>', 'DescribePatchGroupStateResult$InstancesWithSecurityNonCompliantPatches' => '<p>The number of managed nodes where patches that are specified as <code>Security</code> in a patch advisory aren\'t installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>', 'DescribePatchGroupStateResult$InstancesWithOtherNonCompliantPatches' => '<p>The number of managed nodes with patches installed that are specified as other than <code>Critical</code> or <code>Security</code> but aren\'t compliant with the patch baseline. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DescribePatchGroupStateResult$Instances' => '<p>The number of managed nodes in the patch group.</p>', 'DescribePatchGroupStateResult$InstancesWithInstalledPatches' => '<p>The number of managed nodes with installed patches.</p>', 'DescribePatchGroupStateResult$InstancesWithInstalledOtherPatches' => '<p>The number of managed nodes with patches installed that aren\'t defined in the patch baseline.</p>', 'DescribePatchGroupStateResult$InstancesWithMissingPatches' => '<p>The number of managed nodes with missing patches from the patch baseline.</p>', 'DescribePatchGroupStateResult$InstancesWithFailedPatches' => '<p>The number of managed nodes with patches from the patch baseline that failed to install.</p>', 'DescribePatchGroupStateResult$InstancesWithNotApplicablePatches' => '<p>The number of managed nodes with patches that aren\'t applicable.</p>', 'DescribePatchGroupStateResult$InstancesWithUnreportedNotApplicablePatches' => '<p>The number of managed nodes with <code>NotApplicable</code> patches beyond the supported limit, which aren\'t reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.</p>', 'OpsItemLimitExceededException$Limit' => NULL, 'ProgressCounters$TotalSteps' => '<p>The total number of steps run in all specified Amazon Web Services Regions and Amazon Web Services accounts for the current Automation execution.</p>', 'ProgressCounters$SuccessSteps' => '<p>The total number of steps that successfully completed in all specified Amazon Web Services Regions and Amazon Web Services accounts for the current Automation execution.</p>', 'ProgressCounters$FailedSteps' => '<p>The total number of steps that failed to run in all specified Amazon Web Services Regions and Amazon Web Services accounts for the current Automation execution.</p>', 'ProgressCounters$CancelledSteps' => '<p>The total number of steps that the system cancelled in all specified Amazon Web Services Regions and Amazon Web Services accounts for the current Automation execution.</p>', 'ProgressCounters$TimedOutSteps' => '<p>The total number of steps that timed out in all specified Amazon Web Services Regions and Amazon Web Services accounts for the current Automation execution.</p>', 'StepExecution$MaxAttempts' => '<p>The maximum number of tries to run the action of the step. The default value is <code>1</code>.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>An error occurred on the server side.</p>', 'refs' => [], ], 'InvalidActivation' => [ 'base' => '<p>The activation isn\'t valid. The activation might have been deleted, or the ActivationId and the ActivationCode don\'t match.</p>', 'refs' => [], ], 'InvalidActivationId' => [ 'base' => '<p>The activation ID isn\'t valid. Verify the you entered the correct ActivationId or ActivationCode and try again.</p>', 'refs' => [], ], 'InvalidAggregatorException' => [ 'base' => '<p>The specified aggregator isn\'t valid for inventory groups. Verify that the aggregator uses a valid inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.</p>', 'refs' => [], ], 'InvalidAllowedPatternException' => [ 'base' => '<p>The request doesn\'t meet the regular expression requirement.</p>', 'refs' => [], ], 'InvalidAssociation' => [ 'base' => '<p>The association isn\'t valid or doesn\'t exist. </p>', 'refs' => [], ], 'InvalidAssociationVersion' => [ 'base' => '<p>The version you specified isn\'t valid. Use ListAssociationVersions to view all versions of an association according to the association ID. Or, use the <code>$LATEST</code> parameter to view the latest version of the association.</p>', 'refs' => [], ], 'InvalidAutomationExecutionParametersException' => [ 'base' => '<p>The supplied parameters for invoking the specified Automation runbook are incorrect. For example, they may not match the set of parameters permitted for the specified Automation document.</p>', 'refs' => [], ], 'InvalidAutomationSignalException' => [ 'base' => '<p>The signal isn\'t valid for the current Automation execution.</p>', 'refs' => [], ], 'InvalidAutomationStatusUpdateException' => [ 'base' => '<p>The specified update status operation isn\'t valid.</p>', 'refs' => [], ], 'InvalidCommandId' => [ 'base' => '<p>The specified command ID isn\'t valid. Verify the ID and try again.</p>', 'refs' => [], ], 'InvalidDeleteInventoryParametersException' => [ 'base' => '<p>One or more of the parameters specified for the delete operation isn\'t valid. Verify all parameters and try again.</p>', 'refs' => [], ], 'InvalidDeletionIdException' => [ 'base' => '<p>The ID specified for the delete operation doesn\'t exist or isn\'t valid. Verify the ID and try again.</p>', 'refs' => [], ], 'InvalidDocument' => [ 'base' => '<p>The specified SSM document doesn\'t exist.</p>', 'refs' => [], ], 'InvalidDocumentContent' => [ 'base' => '<p>The content for the document isn\'t valid.</p>', 'refs' => [], ], 'InvalidDocumentOperation' => [ 'base' => '<p>You attempted to delete a document while it is still shared. You must stop sharing the document before you can delete it.</p>', 'refs' => [], ], 'InvalidDocumentSchemaVersion' => [ 'base' => '<p>The version of the document schema isn\'t supported.</p>', 'refs' => [], ], 'InvalidDocumentType' => [ 'base' => '<p>The SSM document type isn\'t valid. Valid document types are described in the <code>DocumentType</code> property.</p>', 'refs' => [], ], 'InvalidDocumentVersion' => [ 'base' => '<p>The document version isn\'t valid or doesn\'t exist.</p>', 'refs' => [], ], 'InvalidFilter' => [ 'base' => '<p>The filter name isn\'t valid. Verify the you entered the correct name and try again.</p>', 'refs' => [], ], 'InvalidFilterKey' => [ 'base' => '<p>The specified key isn\'t valid.</p>', 'refs' => [], ], 'InvalidFilterOption' => [ 'base' => '<p>The specified filter option isn\'t valid. Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.</p>', 'refs' => [], ], 'InvalidFilterValue' => [ 'base' => '<p>The filter value isn\'t valid. Verify the value and try again.</p>', 'refs' => [], ], 'InvalidInstanceId' => [ 'base' => '<p>The following problems can cause this exception:</p> <ul> <li> <p>You don\'t have permission to access the managed node.</p> </li> <li> <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn\'t running. Verify that SSM Agent is running.</p> </li> <li> <p>SSM Agent isn\'t registered with the SSM endpoint. Try reinstalling SSM Agent.</p> </li> <li> <p>The managed node isn\'t in valid state. Valid states are: <code>Running</code>, <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and <code>Terminated</code>.</p> </li> </ul>', 'refs' => [], ], 'InvalidInstanceInformationFilterValue' => [ 'base' => '<p>The specified filter value isn\'t valid.</p>', 'refs' => [], ], 'InvalidInventoryGroupException' => [ 'base' => '<p>The specified inventory group isn\'t valid.</p>', 'refs' => [], ], 'InvalidInventoryItemContextException' => [ 'base' => '<p>You specified invalid keys or values in the <code>Context</code> attribute for <code>InventoryItem</code>. Verify the keys and values, and try again.</p>', 'refs' => [], ], 'InvalidInventoryRequestException' => [ 'base' => '<p>The request isn\'t valid.</p>', 'refs' => [], ], 'InvalidItemContentException' => [ 'base' => '<p>One or more content items isn\'t valid.</p>', 'refs' => [], ], 'InvalidKeyId' => [ 'base' => '<p>The query key ID isn\'t valid.</p>', 'refs' => [], ], 'InvalidNextToken' => [ 'base' => '<p>The specified token isn\'t valid.</p>', 'refs' => [], ], 'InvalidNotificationConfig' => [ 'base' => '<p>One or more configuration items isn\'t valid. Verify that a valid Amazon Resource Name (ARN) was provided for an Amazon Simple Notification Service topic.</p>', 'refs' => [], ], 'InvalidOptionException' => [ 'base' => '<p>The delete inventory option specified isn\'t valid. Verify the option and try again.</p>', 'refs' => [], ], 'InvalidOutputFolder' => [ 'base' => '<p>The S3 bucket doesn\'t exist.</p>', 'refs' => [], ], 'InvalidOutputLocation' => [ 'base' => '<p>The output location isn\'t valid or doesn\'t exist.</p>', 'refs' => [], ], 'InvalidParameters' => [ 'base' => '<p>You must specify values for all required parameters in the Amazon Web Services Systems Manager document (SSM document). You can only supply values to parameters defined in the SSM document.</p>', 'refs' => [], ], 'InvalidPermissionType' => [ 'base' => '<p>The permission type isn\'t supported. <i>Share</i> is the only supported permission type.</p>', 'refs' => [], ], 'InvalidPluginName' => [ 'base' => '<p>The plugin name isn\'t valid.</p>', 'refs' => [], ], 'InvalidPolicyAttributeException' => [ 'base' => '<p>A policy attribute or its value is invalid. </p>', 'refs' => [], ], 'InvalidPolicyTypeException' => [ 'base' => '<p>The policy type isn\'t supported. Parameter Store supports the following policy types: Expiration, ExpirationNotification, and NoChangeNotification.</p>', 'refs' => [], ], 'InvalidResourceId' => [ 'base' => '<p>The resource ID isn\'t valid. Verify that you entered the correct ID and try again.</p>', 'refs' => [], ], 'InvalidResourceType' => [ 'base' => '<p>The resource type isn\'t valid. For example, if you are attempting to tag an EC2 instance, the instance must be a registered managed node.</p>', 'refs' => [], ], 'InvalidResultAttributeException' => [ 'base' => '<p>The specified inventory item result attribute isn\'t valid.</p>', 'refs' => [], ], 'InvalidRole' => [ 'base' => '<p>The role name can\'t contain invalid characters. Also verify that you specified an IAM role for notifications that includes the required trust policy. For information about configuring the IAM role for Run Command notifications, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring Amazon SNS Notifications for Run Command</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'refs' => [], ], 'InvalidSchedule' => [ 'base' => '<p>The schedule is invalid. Verify your cron or rate expression and try again.</p>', 'refs' => [], ], 'InvalidTarget' => [ 'base' => '<p>The target isn\'t valid or doesn\'t exist. It might not be configured for Systems Manager or you might not have permission to perform the operation.</p>', 'refs' => [], ], 'InvalidTypeNameException' => [ 'base' => '<p>The parameter type name isn\'t valid.</p>', 'refs' => [], ], 'InvalidUpdate' => [ 'base' => '<p>The update isn\'t valid.</p>', 'refs' => [], ], 'InventoryAggregator' => [ 'base' => '<p>Specifies the inventory type and attribute for the aggregation execution.</p>', 'refs' => [ 'InventoryAggregatorList$member' => NULL, ], ], 'InventoryAggregatorExpression' => [ 'base' => NULL, 'refs' => [ 'InventoryAggregator$Expression' => '<p>The inventory type and attribute name for aggregation.</p>', ], ], 'InventoryAggregatorList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryRequest$Aggregators' => '<p>Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how many Windows and Linux managed nodes exist in your inventoried fleet.</p>', 'InventoryAggregator$Aggregators' => '<p>Nested aggregators to further refine aggregation for an inventory type.</p>', ], ], 'InventoryAttributeDataType' => [ 'base' => NULL, 'refs' => [ 'InventoryItemAttribute$DataType' => '<p>The data type of the inventory item attribute. </p>', ], ], 'InventoryDeletionLastStatusMessage' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionStatusItem$LastStatusMessage' => '<p>Information about the status.</p>', ], ], 'InventoryDeletionLastStatusUpdateTime' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionStatusItem$LastStatusUpdateTime' => '<p>The UTC timestamp of when the last status report.</p>', ], ], 'InventoryDeletionStartTime' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionStatusItem$DeletionStartTime' => '<p>The UTC timestamp when the delete operation started.</p>', ], ], 'InventoryDeletionStatus' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionStatusItem$LastStatus' => '<p>The status of the operation. Possible values are InProgress and Complete.</p>', ], ], 'InventoryDeletionStatusItem' => [ 'base' => '<p>Status information returned by the <code>DeleteInventory</code> operation.</p>', 'refs' => [ 'InventoryDeletionsList$member' => NULL, ], ], 'InventoryDeletionSummary' => [ 'base' => '<p>Information about the delete operation.</p>', 'refs' => [ 'DeleteInventoryResult$DeletionSummary' => '<p>A summary of the delete operation. For more information about this summary, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary">Deleting custom inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'InventoryDeletionStatusItem$DeletionSummary' => '<p>Information about the delete operation. For more information about this summary, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete">Understanding the delete inventory summary</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', ], ], 'InventoryDeletionSummaryItem' => [ 'base' => '<p>Either a count, remaining count, or a version number in a delete inventory summary.</p>', 'refs' => [ 'InventoryDeletionSummaryItems$member' => NULL, ], ], 'InventoryDeletionSummaryItems' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionSummary$SummaryItems' => '<p>A list of counts and versions for deleted items.</p>', ], ], 'InventoryDeletionsList' => [ 'base' => NULL, 'refs' => [ 'DescribeInventoryDeletionsResult$InventoryDeletions' => '<p>A list of status items for deleted inventory.</p>', ], ], 'InventoryFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'refs' => [ 'InventoryFilterList$member' => NULL, ], ], 'InventoryFilterKey' => [ 'base' => NULL, 'refs' => [ 'InventoryFilter$Key' => '<p>The name of the filter key.</p>', ], ], 'InventoryFilterList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'InventoryGroup$Filters' => '<p>Filters define the criteria for the group. The <code>matchingCount</code> field displays the number of resources that match the criteria. The <code>notMatchingCount</code> field displays the number of resources that don\'t match the criteria. </p>', 'ListInventoryEntriesRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'InventoryFilterValue' => [ 'base' => NULL, 'refs' => [ 'InventoryFilterValueList$member' => NULL, ], ], 'InventoryFilterValueList' => [ 'base' => NULL, 'refs' => [ 'InventoryFilter$Values' => '<p>Inventory filter values. Example: inventory filter where managed node IDs are specified as values <code>Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal</code>. </p>', ], ], 'InventoryGroup' => [ 'base' => '<p>A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count of resources that match and don\'t match the specified criteria.</p>', 'refs' => [ 'InventoryGroupList$member' => NULL, ], ], 'InventoryGroupList' => [ 'base' => NULL, 'refs' => [ 'InventoryAggregator$Groups' => '<p>A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count of resources that match and don\'t match the specified criteria.</p>', ], ], 'InventoryGroupName' => [ 'base' => NULL, 'refs' => [ 'InventoryGroup$Name' => '<p>The name of the group.</p>', ], ], 'InventoryItem' => [ 'base' => '<p>Information collected from managed nodes based on your inventory policy document</p>', 'refs' => [ 'InventoryItemList$member' => NULL, ], ], 'InventoryItemAttribute' => [ 'base' => '<p>Attributes are the entries within the inventory item content. It contains name and value.</p>', 'refs' => [ 'InventoryItemAttributeList$member' => NULL, ], ], 'InventoryItemAttributeList' => [ 'base' => NULL, 'refs' => [ 'InventoryItemSchema$Attributes' => '<p>The schema attributes for inventory. This contains data type and attribute name.</p>', ], ], 'InventoryItemAttributeName' => [ 'base' => NULL, 'refs' => [ 'InventoryItemAttribute$Name' => '<p>Name of the inventory item attribute.</p>', ], ], 'InventoryItemCaptureTime' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$CaptureTime' => '<p>The time the inventory information was collected.</p>', 'InventoryResultItem$CaptureTime' => '<p>The time inventory item data was captured.</p>', 'ListInventoryEntriesResult$CaptureTime' => '<p>The time that inventory information was collected for the managed node(s).</p>', ], ], 'InventoryItemContentContext' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$Context' => '<p>A map of associated properties for a specified inventory type. For example, with this attribute, you can specify the <code>ExecutionId</code>, <code>ExecutionType</code>, <code>ComplianceType</code> properties of the <code>AWS:ComplianceItem</code> type.</p>', ], ], 'InventoryItemContentHash' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$ContentHash' => '<p>MD5 hash of the inventory item type contents. The content hash is used to determine whether to update inventory information. The PutInventory API doesn\'t update the inventory item type contents if the MD5 hash hasn\'t changed since last update. </p>', 'InventoryResultItem$ContentHash' => '<p>MD5 hash of the inventory item type contents. The content hash is used to determine whether to update inventory information. The PutInventory API doesn\'t update the inventory item type contents if the MD5 hash hasn\'t changed since last update. </p>', ], ], 'InventoryItemEntry' => [ 'base' => NULL, 'refs' => [ 'InventoryItemEntryList$member' => NULL, ], ], 'InventoryItemEntryList' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$Content' => '<p>The inventory data of the inventory type.</p>', 'InventoryResultItem$Content' => '<p>Contains all the inventory data of the item type. Results include attribute names and values. </p>', 'ListInventoryEntriesResult$Entries' => '<p>A list of inventory items on the managed node(s).</p>', ], ], 'InventoryItemList' => [ 'base' => NULL, 'refs' => [ 'PutInventoryRequest$Items' => '<p>The inventory items that you want to add or update on managed nodes.</p>', ], ], 'InventoryItemSchema' => [ 'base' => '<p>The inventory item schema definition. Users can use this to compose inventory query filters.</p>', 'refs' => [ 'InventoryItemSchemaResultList$member' => NULL, ], ], 'InventoryItemSchemaResultList' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaResult$Schemas' => '<p>Inventory schemas returned by the request.</p>', ], ], 'InventoryItemSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionSummaryItem$Version' => '<p>The inventory type version.</p>', 'InventoryItem$SchemaVersion' => '<p>The schema version for the inventory item.</p>', 'InventoryItemSchema$Version' => '<p>The schema version for the inventory item.</p>', 'InventoryResultItem$SchemaVersion' => '<p>The schema version for the inventory result item/</p>', 'ListInventoryEntriesResult$SchemaVersion' => '<p>The inventory schema version used by the managed node(s).</p>', ], ], 'InventoryItemTypeName' => [ 'base' => NULL, 'refs' => [ 'DeleteInventoryRequest$TypeName' => '<p>The name of the custom inventory type for which you want to delete either all previously collected data or the inventory type itself. </p>', 'DeleteInventoryResult$TypeName' => '<p>The name of the inventory data type specified in the request.</p>', 'InvalidItemContentException$TypeName' => NULL, 'InventoryDeletionStatusItem$TypeName' => '<p>The name of the inventory data type.</p>', 'InventoryItem$TypeName' => '<p>The name of the inventory type. Default inventory item type names start with <code>AWS</code>. Custom inventory type names will start with Custom. Default inventory item types include the following: <code>AWS:AWSComponent</code>, <code>AWS:Application</code>, <code>AWS:InstanceInformation</code>, <code>AWS:Network</code>, and <code>AWS:WindowsUpdate</code>.</p>', 'InventoryItemSchema$TypeName' => '<p>The name of the inventory type. Default inventory item type names start with Amazon Web Services. Custom inventory type names will start with Custom. Default inventory item types include the following: <code>AWS:AWSComponent</code>, <code>AWS:Application</code>, <code>AWS:InstanceInformation</code>, <code>AWS:Network</code>, and <code>AWS:WindowsUpdate</code>.</p>', 'InventoryResultItem$TypeName' => '<p>The name of the inventory result item type.</p>', 'ItemContentMismatchException$TypeName' => NULL, 'ItemSizeLimitExceededException$TypeName' => NULL, 'ListInventoryEntriesRequest$TypeName' => '<p>The type of inventory item for which you want information.</p>', 'ListInventoryEntriesResult$TypeName' => '<p>The type of inventory item returned by the request.</p>', 'ResultAttribute$TypeName' => '<p>Name of the inventory item type. Valid value: <code>AWS:InstanceInformation</code>. Default Value: <code>AWS:InstanceInformation</code>.</p>', 'UnsupportedInventoryItemContextException$TypeName' => NULL, ], ], 'InventoryItemTypeNameFilter' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$TypeName' => '<p>The type of inventory item to return.</p>', ], ], 'InventoryQueryOperatorType' => [ 'base' => NULL, 'refs' => [ 'InventoryFilter$Type' => '<p>The type of filter.</p> <note> <p>The <code>Exists</code> filter must be used with aggregators. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-aggregate.html">Aggregating inventory data</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> </note>', ], ], 'InventoryResultEntity' => [ 'base' => '<p>Inventory query results.</p>', 'refs' => [ 'InventoryResultEntityList$member' => NULL, ], ], 'InventoryResultEntityId' => [ 'base' => NULL, 'refs' => [ 'InventoryResultEntity$Id' => '<p>ID of the inventory result entity. For example, for managed node inventory the result will be the managed node ID. For EC2 instance inventory, the result will be the instance ID. </p>', ], ], 'InventoryResultEntityList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryResult$Entities' => '<p>Collection of inventory entities such as a collection of managed node inventory. </p>', ], ], 'InventoryResultItem' => [ 'base' => '<p>The inventory result item.</p>', 'refs' => [ 'InventoryResultItemMap$value' => NULL, ], ], 'InventoryResultItemKey' => [ 'base' => NULL, 'refs' => [ 'InventoryResultItemMap$key' => NULL, ], ], 'InventoryResultItemMap' => [ 'base' => NULL, 'refs' => [ 'InventoryResultEntity$Data' => '<p>The data section in the inventory result entity JSON.</p>', ], ], 'InventorySchemaDeleteOption' => [ 'base' => NULL, 'refs' => [ 'DeleteInventoryRequest$SchemaDeleteOption' => '<p>Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don\'t choose this option, the system only deletes existing inventory data associated with the custom inventory type. Choose one of the following options:</p> <p>DisableSchema: If you choose this option, the system ignores all inventory data for the specified version, and any earlier versions. To enable this schema again, you must call the <code>PutInventory</code> operation for a version greater than the disabled version.</p> <p>DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate the schema later, if you want.</p>', ], ], 'InventoryTypeDisplayName' => [ 'base' => NULL, 'refs' => [ 'InventoryItemSchema$DisplayName' => '<p>The alias name of the inventory type. The alias name is used for display purposes.</p>', ], ], 'InvocationDoesNotExist' => [ 'base' => '<p>The command ID and managed node ID you specified didn\'t match any invocations. Verify the command ID and the managed node ID and try again. </p>', 'refs' => [], ], 'InvocationTraceOutput' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$TraceOutput' => '<p> Gets the trace output sent by the agent. </p>', ], ], 'IsSubTypeSchema' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$SubType' => '<p>Returns the sub-type schema for a specified inventory type.</p>', ], ], 'ItemContentMismatchException' => [ 'base' => '<p>The inventory item has invalid content. </p>', 'refs' => [], ], 'ItemSizeLimitExceededException' => [ 'base' => '<p>The inventory item size has exceeded the size limit.</p>', 'refs' => [], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceRequest$TagKeys' => '<p>Tag keys that you want to remove from the specified resource.</p>', ], ], 'LabelParameterVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'LabelParameterVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'LastResourceDataSyncMessage' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastSyncStatusMessage' => '<p>The status message details reported by the last sync.</p>', ], ], 'LastResourceDataSyncStatus' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastStatus' => '<p>The status reported by the last sync.</p>', ], ], 'LastResourceDataSyncTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastSyncTime' => '<p>The last time the configuration attempted to sync (UTC).</p>', ], ], 'LastSuccessfulResourceDataSyncTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastSuccessfulSyncTime' => '<p>The last time the sync operations returned a status of <code>SUCCESSFUL</code> (UTC).</p>', ], ], 'ListAssociationVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandInvocationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandInvocationsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceItemsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceSummariesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentMetadataHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentMetadataHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListInventoryEntriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInventoryEntriesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListOpsItemEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOpsItemEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOpsItemRelatedItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOpsItemRelatedItemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOpsMetadataMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListOpsMetadataRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'ListOpsMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOpsMetadataResult' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceComplianceSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceComplianceSummariesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'LoggingInfo' => [ 'base' => '<p>Information about an Amazon Simple Storage Service (Amazon S3) bucket to write managed node-level logs to.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'refs' => [ 'GetMaintenanceWindowTaskResult$LoggingInfo' => '<p>The location in Amazon Simple Storage Service (Amazon S3) where the task results are logged.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'MaintenanceWindowTask$LoggingInfo' => '<p>Information about an S3 bucket to write task-level logs to.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'RegisterTaskWithMaintenanceWindowRequest$LoggingInfo' => '<p>A structure containing information about an Amazon Simple Storage Service (Amazon S3) bucket to write managed node-level logs to. </p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'UpdateMaintenanceWindowTaskRequest$LoggingInfo' => '<p>The new logging location in Amazon S3 to specify.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'UpdateMaintenanceWindowTaskResult$LoggingInfo' => '<p>The updated logging information in Amazon S3.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'StepExecution$TimeoutSeconds' => '<p>The timeout seconds of the step.</p>', ], ], 'MaintenanceWindowAllowUnassociatedTargets' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$AllowUnassociatedTargets' => '<p>Enables a maintenance window task to run on managed nodes, even if you haven\'t registered those nodes as targets. If enabled, then you must specify the unregistered managed nodes (by node ID) when you register a task with the maintenance window.</p> <p>If you don\'t enable this option, then you must specify previously-registered targets when you register a task with the maintenance window.</p>', 'GetMaintenanceWindowResult$AllowUnassociatedTargets' => '<p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>', 'UpdateMaintenanceWindowRequest$AllowUnassociatedTargets' => '<p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>', 'UpdateMaintenanceWindowResult$AllowUnassociatedTargets' => '<p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>', ], ], 'MaintenanceWindowAutomationParameters' => [ 'base' => '<p>The parameters for an <code>AUTOMATION</code> task type.</p>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$Automation' => '<p>The parameters for an <code>AUTOMATION</code> task type.</p>', ], ], 'MaintenanceWindowCutoff' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Cutoff' => '<p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>', 'GetMaintenanceWindowResult$Cutoff' => '<p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>', 'MaintenanceWindowIdentity$Cutoff' => '<p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>', 'UpdateMaintenanceWindowRequest$Cutoff' => '<p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>', 'UpdateMaintenanceWindowResult$Cutoff' => '<p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>', ], ], 'MaintenanceWindowDescription' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Description' => '<p>An optional description for the maintenance window. We recommend specifying a description to help you organize your maintenance windows. </p>', 'GetMaintenanceWindowResult$Description' => '<p>The description of the maintenance window.</p>', 'GetMaintenanceWindowTaskResult$Description' => '<p>The retrieved task description.</p>', 'MaintenanceWindowIdentity$Description' => '<p>A description of the maintenance window.</p>', 'MaintenanceWindowTarget$Description' => '<p>A description for the target.</p>', 'MaintenanceWindowTask$Description' => '<p>A description of the task.</p>', 'RegisterTargetWithMaintenanceWindowRequest$Description' => '<p>An optional description for the target.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Description' => '<p>An optional description for the task.</p>', 'UpdateMaintenanceWindowRequest$Description' => '<p>An optional description for the update request.</p>', 'UpdateMaintenanceWindowResult$Description' => '<p>An optional description of the update.</p>', 'UpdateMaintenanceWindowTargetRequest$Description' => '<p>An optional description for the update.</p>', 'UpdateMaintenanceWindowTargetResult$Description' => '<p>The updated description.</p>', 'UpdateMaintenanceWindowTaskRequest$Description' => '<p>The new task description to specify.</p>', 'UpdateMaintenanceWindowTaskResult$Description' => '<p>The updated task description.</p>', ], ], 'MaintenanceWindowDurationHours' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Duration' => '<p>The duration of the maintenance window in hours.</p>', 'GetMaintenanceWindowResult$Duration' => '<p>The duration of the maintenance window in hours.</p>', 'MaintenanceWindowIdentity$Duration' => '<p>The duration of the maintenance window in hours.</p>', 'UpdateMaintenanceWindowRequest$Duration' => '<p>The duration of the maintenance window in hours.</p>', 'UpdateMaintenanceWindowResult$Duration' => '<p>The duration of the maintenance window in hours.</p>', ], ], 'MaintenanceWindowEnabled' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowResult$Enabled' => '<p>Indicates whether the maintenance window is enabled.</p>', 'MaintenanceWindowIdentity$Enabled' => '<p>Indicates whether the maintenance window is enabled.</p>', 'UpdateMaintenanceWindowRequest$Enabled' => '<p>Whether the maintenance window is enabled.</p>', 'UpdateMaintenanceWindowResult$Enabled' => '<p>Whether the maintenance window is enabled.</p>', ], ], 'MaintenanceWindowExecution' => [ 'base' => '<p>Describes the information about an execution of a maintenance window. </p>', 'refs' => [ 'MaintenanceWindowExecutionList$member' => NULL, ], ], 'MaintenanceWindowExecutionId' => [ 'base' => NULL, 'refs' => [ 'CancelMaintenanceWindowExecutionRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution to stop.</p>', 'CancelMaintenanceWindowExecutionResult$WindowExecutionId' => '<p>The ID of the maintenance window execution that has been stopped.</p>', 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution the task is part of.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution whose task executions should be retrieved.</p>', 'GetMaintenanceWindowExecutionRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution that includes the task.</p>', 'GetMaintenanceWindowExecutionResult$WindowExecutionId' => '<p>The ID of the maintenance window execution.</p>', 'GetMaintenanceWindowExecutionTaskInvocationRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution for which the task is a part.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$WindowExecutionId' => '<p>The maintenance window execution ID.</p>', 'GetMaintenanceWindowExecutionTaskRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution that includes the task.</p>', 'GetMaintenanceWindowExecutionTaskResult$WindowExecutionId' => '<p>The ID of the maintenance window execution that includes the task.</p>', 'MaintenanceWindowExecution$WindowExecutionId' => '<p>The ID of the maintenance window execution.</p>', 'MaintenanceWindowExecutionTaskIdentity$WindowExecutionId' => '<p>The ID of the maintenance window execution that ran the task.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$WindowExecutionId' => '<p>The ID of the maintenance window execution that ran the task.</p>', ], ], 'MaintenanceWindowExecutionList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionsResult$WindowExecutions' => '<p>Information about the maintenance window executions.</p>', ], ], 'MaintenanceWindowExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionResult$Status' => '<p>The status of the maintenance window execution.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$Status' => '<p>The task status for an invocation.</p>', 'GetMaintenanceWindowExecutionTaskResult$Status' => '<p>The status of the task.</p>', 'MaintenanceWindowExecution$Status' => '<p>The status of the execution.</p>', 'MaintenanceWindowExecutionTaskIdentity$Status' => '<p>The status of the task execution.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$Status' => '<p>The status of the task invocation.</p>', ], ], 'MaintenanceWindowExecutionStatusDetails' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionResult$StatusDetails' => '<p>The details explaining the status. Not available for all status values.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$StatusDetails' => '<p>The details explaining the status. Details are only available for certain status values.</p>', 'GetMaintenanceWindowExecutionTaskResult$StatusDetails' => '<p>The details explaining the status. Not available for all status values.</p>', 'MaintenanceWindowExecution$StatusDetails' => '<p>The details explaining the status. Not available for all status values.</p>', 'MaintenanceWindowExecutionTaskIdentity$StatusDetails' => '<p>The details explaining the status of the task execution. Not available for all status values.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$StatusDetails' => '<p>The details explaining the status of the task invocation. Not available for all status values. </p>', ], ], 'MaintenanceWindowExecutionTaskExecutionId' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$ExecutionId' => '<p>The execution ID.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$ExecutionId' => '<p>The ID of the action performed in the service that actually handled the task invocation. If the task type is <code>RUN_COMMAND</code>, this value is the command ID.</p>', ], ], 'MaintenanceWindowExecutionTaskId' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$TaskId' => '<p>The ID of the specific task in the maintenance window task that should be retrieved.</p>', 'GetMaintenanceWindowExecutionTaskInvocationRequest$TaskId' => '<p>The ID of the specific task in the maintenance window task that should be retrieved. </p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$TaskExecutionId' => '<p>The task execution ID.</p>', 'GetMaintenanceWindowExecutionTaskRequest$TaskId' => '<p>The ID of the specific task execution in the maintenance window task that should be retrieved.</p>', 'GetMaintenanceWindowExecutionTaskResult$TaskExecutionId' => '<p>The ID of the specific task execution in the maintenance window task that was retrieved.</p>', 'MaintenanceWindowExecutionTaskIdList$member' => NULL, 'MaintenanceWindowExecutionTaskIdentity$TaskExecutionId' => '<p>The ID of the specific task execution in the maintenance window execution.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$TaskExecutionId' => '<p>The ID of the specific task execution in the maintenance window execution.</p>', ], ], 'MaintenanceWindowExecutionTaskIdList' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionResult$TaskIds' => '<p>The ID of the task executions from the maintenance window execution.</p>', ], ], 'MaintenanceWindowExecutionTaskIdentity' => [ 'base' => '<p>Information about a task execution performed as part of a maintenance window execution.</p>', 'refs' => [ 'MaintenanceWindowExecutionTaskIdentityList$member' => NULL, ], ], 'MaintenanceWindowExecutionTaskIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTasksResult$WindowExecutionTaskIdentities' => '<p>Information about the task executions.</p>', ], ], 'MaintenanceWindowExecutionTaskInvocationId' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationRequest$InvocationId' => '<p>The invocation ID to retrieve.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$InvocationId' => '<p>The invocation ID.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$InvocationId' => '<p>The ID of the task invocation.</p>', ], ], 'MaintenanceWindowExecutionTaskInvocationIdentity' => [ 'base' => '<p>Describes the information about a task invocation for a particular target as part of a task execution performed as part of a maintenance window execution.</p>', 'refs' => [ 'MaintenanceWindowExecutionTaskInvocationIdentityList$member' => NULL, ], ], 'MaintenanceWindowExecutionTaskInvocationIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsResult$WindowExecutionTaskInvocationIdentities' => '<p>Information about the task invocation results per invocation.</p>', ], ], 'MaintenanceWindowExecutionTaskInvocationParameters' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$Parameters' => '<p>The parameters used at the time that the task ran.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$Parameters' => '<p>The parameters that were provided for the invocation when it was run.</p>', ], ], 'MaintenanceWindowFilter' => [ 'base' => '<p>Filter used in the request. Supported filter keys depend on the API operation that includes the filter. API operations that use <code>MaintenanceWindowFilter&gt;</code> include the following:</p> <ul> <li> <p> <a>DescribeMaintenanceWindowExecutions</a> </p> </li> <li> <p> <a>DescribeMaintenanceWindowExecutionTaskInvocations</a> </p> </li> <li> <p> <a>DescribeMaintenanceWindowExecutionTasks</a> </p> </li> <li> <p> <a>DescribeMaintenanceWindows</a> </p> </li> <li> <p> <a>DescribeMaintenanceWindowTargets</a> </p> </li> <li> <p> <a>DescribeMaintenanceWindowTasks</a> </p> </li> </ul>', 'refs' => [ 'MaintenanceWindowFilterList$member' => NULL, ], ], 'MaintenanceWindowFilterKey' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowFilter$Key' => '<p>The name of the filter.</p>', ], ], 'MaintenanceWindowFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$Filters' => '<p>Optional filters used to scope down the returned task invocations. The supported filter key is <code>STATUS</code> with the corresponding values <code>PENDING</code>, <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$Filters' => '<p>Optional filters used to scope down the returned tasks. The supported filter key is <code>STATUS</code> with the corresponding values <code>PENDING</code>, <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>', 'DescribeMaintenanceWindowExecutionsRequest$Filters' => '<p>Each entry in the array is a structure containing:</p> <ul> <li> <p>Key. A string between 1 and 128 characters. Supported keys include <code>ExecutedBefore</code> and <code>ExecutedAfter</code>.</p> </li> <li> <p>Values. An array of strings, each between 1 and 256 characters. Supported values are date/time strings in a valid ISO 8601 date/time format, such as <code>2021-11-04T05:00:00Z</code>.</p> </li> </ul>', 'DescribeMaintenanceWindowTargetsRequest$Filters' => '<p>Optional filters that can be used to narrow down the scope of the returned window targets. The supported filter keys are <code>Type</code>, <code>WindowTargetId</code>, and <code>OwnerInformation</code>.</p>', 'DescribeMaintenanceWindowTasksRequest$Filters' => '<p>Optional filters used to narrow down the scope of the returned tasks. The supported filter keys are <code>WindowTaskId</code>, <code>TaskArn</code>, <code>Priority</code>, and <code>TaskType</code>.</p>', 'DescribeMaintenanceWindowsRequest$Filters' => '<p>Optional filters used to narrow down the scope of the returned maintenance windows. Supported filter keys are <code>Name</code> and <code>Enabled</code>. For example, <code>Name=MyMaintenanceWindow</code> and <code>Enabled=True</code>.</p>', ], ], 'MaintenanceWindowFilterValue' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowFilterValues$member' => NULL, ], ], 'MaintenanceWindowFilterValues' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowFilter$Values' => '<p>The filter values.</p>', ], ], 'MaintenanceWindowId' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowResult$WindowId' => '<p>The ID of the created maintenance window.</p>', 'DeleteMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window to delete.</p>', 'DeleteMaintenanceWindowResult$WindowId' => '<p>The ID of the deleted maintenance window.</p>', 'DeregisterTargetFromMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window the target should be removed from.</p>', 'DeregisterTargetFromMaintenanceWindowResult$WindowId' => '<p>The ID of the maintenance window the target was removed from.</p>', 'DeregisterTaskFromMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window the task should be removed from.</p>', 'DeregisterTaskFromMaintenanceWindowResult$WindowId' => '<p>The ID of the maintenance window the task was removed from.</p>', 'DescribeMaintenanceWindowExecutionsRequest$WindowId' => '<p>The ID of the maintenance window whose executions should be retrieved.</p>', 'DescribeMaintenanceWindowScheduleRequest$WindowId' => '<p>The ID of the maintenance window to retrieve information about.</p>', 'DescribeMaintenanceWindowTargetsRequest$WindowId' => '<p>The ID of the maintenance window whose targets should be retrieved.</p>', 'DescribeMaintenanceWindowTasksRequest$WindowId' => '<p>The ID of the maintenance window whose tasks should be retrieved.</p>', 'GetMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window for which you want to retrieve information.</p>', 'GetMaintenanceWindowResult$WindowId' => '<p>The ID of the created maintenance window.</p>', 'GetMaintenanceWindowTaskRequest$WindowId' => '<p>The maintenance window ID that includes the task to retrieve.</p>', 'GetMaintenanceWindowTaskResult$WindowId' => '<p>The retrieved maintenance window ID.</p>', 'MaintenanceWindowExecution$WindowId' => '<p>The ID of the maintenance window.</p>', 'MaintenanceWindowIdentity$WindowId' => '<p>The ID of the maintenance window.</p>', 'MaintenanceWindowIdentityForTarget$WindowId' => '<p>The ID of the maintenance window.</p>', 'MaintenanceWindowTarget$WindowId' => '<p>The ID of the maintenance window to register the target with.</p>', 'MaintenanceWindowTask$WindowId' => '<p>The ID of the maintenance window where the task is registered.</p>', 'RegisterTargetWithMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window the target should be registered with.</p>', 'RegisterTaskWithMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window the task should be added to.</p>', 'ScheduledWindowExecution$WindowId' => '<p>The ID of the maintenance window to be run.</p>', 'UpdateMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window to update.</p>', 'UpdateMaintenanceWindowResult$WindowId' => '<p>The ID of the created maintenance window.</p>', 'UpdateMaintenanceWindowTargetRequest$WindowId' => '<p>The maintenance window ID with which to modify the target.</p>', 'UpdateMaintenanceWindowTargetResult$WindowId' => '<p>The maintenance window ID specified in the update request.</p>', 'UpdateMaintenanceWindowTaskRequest$WindowId' => '<p>The maintenance window ID that contains the task to modify.</p>', 'UpdateMaintenanceWindowTaskResult$WindowId' => '<p>The ID of the maintenance window that was updated.</p>', ], ], 'MaintenanceWindowIdentity' => [ 'base' => '<p>Information about the maintenance window.</p>', 'refs' => [ 'MaintenanceWindowIdentityList$member' => NULL, ], ], 'MaintenanceWindowIdentityForTarget' => [ 'base' => '<p>The maintenance window to which the specified target belongs.</p>', 'refs' => [ 'MaintenanceWindowsForTargetList$member' => NULL, ], ], 'MaintenanceWindowIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowsResult$WindowIdentities' => '<p>Information about the maintenance windows.</p>', ], ], 'MaintenanceWindowLambdaClientContext' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowLambdaParameters$ClientContext' => '<p>Pass client-specific information to the Lambda function that you are invoking. You can then process the client information in your Lambda function as you choose through the context variable.</p>', ], ], 'MaintenanceWindowLambdaParameters' => [ 'base' => '<p>The parameters for a <code>LAMBDA</code> task type.</p> <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p>For Lambda tasks, Systems Manager ignores any values specified for TaskParameters and LoggingInfo.</p> </note>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$Lambda' => '<p>The parameters for a <code>LAMBDA</code> task type.</p>', ], ], 'MaintenanceWindowLambdaPayload' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowLambdaParameters$Payload' => '<p>JSON to provide to your Lambda function as input.</p>', ], ], 'MaintenanceWindowLambdaQualifier' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowLambdaParameters$Qualifier' => '<p>(Optional) Specify an Lambda function version or alias name. If you specify a function version, the operation uses the qualified function Amazon Resource Name (ARN) to invoke a specific Lambda function. If you specify an alias name, the operation uses the alias ARN to invoke the Lambda function version to which the alias points.</p>', ], ], 'MaintenanceWindowMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowExecutionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowTargetsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowTasksRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'MaintenanceWindowName' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Name' => '<p>The name of the maintenance window.</p>', 'GetMaintenanceWindowResult$Name' => '<p>The name of the maintenance window.</p>', 'GetMaintenanceWindowTaskResult$Name' => '<p>The retrieved task name.</p>', 'MaintenanceWindowIdentity$Name' => '<p>The name of the maintenance window.</p>', 'MaintenanceWindowIdentityForTarget$Name' => '<p>The name of the maintenance window.</p>', 'MaintenanceWindowTarget$Name' => '<p>The name for the maintenance window target.</p>', 'MaintenanceWindowTask$Name' => '<p>The task name.</p>', 'RegisterTargetWithMaintenanceWindowRequest$Name' => '<p>An optional name for the target.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Name' => '<p>An optional name for the task.</p>', 'ScheduledWindowExecution$Name' => '<p>The name of the maintenance window to be run.</p>', 'UpdateMaintenanceWindowRequest$Name' => '<p>The name of the maintenance window.</p>', 'UpdateMaintenanceWindowResult$Name' => '<p>The name of the maintenance window.</p>', 'UpdateMaintenanceWindowTargetRequest$Name' => '<p>A name for the update.</p>', 'UpdateMaintenanceWindowTargetResult$Name' => '<p>The updated name.</p>', 'UpdateMaintenanceWindowTaskRequest$Name' => '<p>The new task name to specify.</p>', 'UpdateMaintenanceWindowTaskResult$Name' => '<p>The updated task name.</p>', ], ], 'MaintenanceWindowOffset' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$ScheduleOffset' => '<p>The number of days to wait after the date and time specified by a cron expression before running the maintenance window.</p> <p>For example, the following cron expression schedules a maintenance window to run on the third Tuesday of every month at 11:30 PM.</p> <p> <code>cron(30 23 ? * TUE#3 *)</code> </p> <p>If the schedule offset is <code>2</code>, the maintenance window won\'t run until two days later.</p>', 'GetMaintenanceWindowResult$ScheduleOffset' => '<p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>', 'MaintenanceWindowIdentity$ScheduleOffset' => '<p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>', 'UpdateMaintenanceWindowRequest$ScheduleOffset' => '<p>The number of days to wait after the date and time specified by a cron expression before running the maintenance window.</p> <p>For example, the following cron expression schedules a maintenance window to run the third Tuesday of every month at 11:30 PM.</p> <p> <code>cron(30 23 ? * TUE#3 *)</code> </p> <p>If the schedule offset is <code>2</code>, the maintenance window won\'t run until two days later.</p>', 'UpdateMaintenanceWindowResult$ScheduleOffset' => '<p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>', ], ], 'MaintenanceWindowResourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowScheduleRequest$ResourceType' => '<p>The type of resource you want to retrieve information about. For example, <code>INSTANCE</code>.</p>', 'DescribeMaintenanceWindowsForTargetRequest$ResourceType' => '<p>The type of resource you want to retrieve information about. For example, <code>INSTANCE</code>.</p>', 'MaintenanceWindowTarget$ResourceType' => '<p>The type of target that is being registered with the maintenance window.</p>', 'RegisterTargetWithMaintenanceWindowRequest$ResourceType' => '<p>The type of target being registered with the maintenance window.</p>', ], ], 'MaintenanceWindowRunCommandParameters' => [ 'base' => '<p>The parameters for a <code>RUN_COMMAND</code> task type.</p> <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p>For <code>RUN_COMMAND</code> tasks, Systems Manager uses specified values for <code>TaskParameters</code> and <code>LoggingInfo</code> only if no values are specified for <code>TaskInvocationParameters</code>. </p> </note>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$RunCommand' => '<p>The parameters for a <code>RUN_COMMAND</code> task type.</p>', ], ], 'MaintenanceWindowSchedule' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Schedule' => '<p>The schedule of the maintenance window in the form of a cron or rate expression.</p>', 'GetMaintenanceWindowResult$Schedule' => '<p>The schedule of the maintenance window in the form of a cron or rate expression.</p>', 'MaintenanceWindowIdentity$Schedule' => '<p>The schedule of the maintenance window in the form of a cron or rate expression.</p>', 'UpdateMaintenanceWindowRequest$Schedule' => '<p>The schedule of the maintenance window in the form of a cron or rate expression.</p>', 'UpdateMaintenanceWindowResult$Schedule' => '<p>The schedule of the maintenance window in the form of a cron or rate expression.</p>', ], ], 'MaintenanceWindowSearchMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowScheduleRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowsForTargetRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'MaintenanceWindowStepFunctionsInput' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowStepFunctionsParameters$Input' => '<p>The inputs for the <code>STEP_FUNCTIONS</code> task.</p>', ], ], 'MaintenanceWindowStepFunctionsName' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowStepFunctionsParameters$Name' => '<p>The name of the <code>STEP_FUNCTIONS</code> task.</p>', ], ], 'MaintenanceWindowStepFunctionsParameters' => [ 'base' => '<p>The parameters for a <code>STEP_FUNCTIONS</code> task.</p> <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p>For Step Functions tasks, Systems Manager ignores any values specified for <code>TaskParameters</code> and <code>LoggingInfo</code>.</p> </note>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$StepFunctions' => '<p>The parameters for a <code>STEP_FUNCTIONS</code> task type.</p>', ], ], 'MaintenanceWindowStringDateTime' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$StartDate' => '<p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active. <code>StartDate</code> allows you to delay activation of the maintenance window until the specified future date.</p>', 'CreateMaintenanceWindowRequest$EndDate' => '<p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. <code>EndDate</code> allows you to set a date and time in the future when the maintenance window will no longer run.</p>', 'GetMaintenanceWindowResult$StartDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won\'t run before this specified time.</p>', 'GetMaintenanceWindowResult$EndDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won\'t run after this specified time.</p>', 'GetMaintenanceWindowResult$NextExecutionTime' => '<p>The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.</p>', 'MaintenanceWindowIdentity$EndDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive.</p>', 'MaintenanceWindowIdentity$StartDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active.</p>', 'MaintenanceWindowIdentity$NextExecutionTime' => '<p>The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.</p>', 'ScheduledWindowExecution$ExecutionTime' => '<p>The time, in ISO-8601 Extended format, that the maintenance window is scheduled to be run.</p>', 'UpdateMaintenanceWindowRequest$StartDate' => '<p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active. <code>StartDate</code> allows you to delay activation of the maintenance window until the specified future date.</p>', 'UpdateMaintenanceWindowRequest$EndDate' => '<p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. <code>EndDate</code> allows you to set a date and time in the future when the maintenance window will no longer run.</p>', 'UpdateMaintenanceWindowResult$StartDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won\'t run before this specified time.</p>', 'UpdateMaintenanceWindowResult$EndDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won\'t run after this specified time.</p>', ], ], 'MaintenanceWindowTarget' => [ 'base' => '<p>The target registered with the maintenance window.</p>', 'refs' => [ 'MaintenanceWindowTargetList$member' => NULL, ], ], 'MaintenanceWindowTargetId' => [ 'base' => NULL, 'refs' => [ 'DeregisterTargetFromMaintenanceWindowRequest$WindowTargetId' => '<p>The ID of the target definition to remove.</p>', 'DeregisterTargetFromMaintenanceWindowResult$WindowTargetId' => '<p>The ID of the removed target definition.</p>', 'MaintenanceWindowTarget$WindowTargetId' => '<p>The ID of the target.</p>', 'RegisterTargetWithMaintenanceWindowResult$WindowTargetId' => '<p>The ID of the target definition in this maintenance window.</p>', 'UpdateMaintenanceWindowTargetRequest$WindowTargetId' => '<p>The target ID to modify.</p>', 'UpdateMaintenanceWindowTargetResult$WindowTargetId' => '<p>The target ID specified in the update request.</p>', ], ], 'MaintenanceWindowTargetList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowTargetsResult$Targets' => '<p>Information about the targets in the maintenance window.</p>', ], ], 'MaintenanceWindowTask' => [ 'base' => '<p>Information about a task defined for a maintenance window.</p>', 'refs' => [ 'MaintenanceWindowTaskList$member' => NULL, ], ], 'MaintenanceWindowTaskArn' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskResult$TaskArn' => '<p>The Amazon Resource Name (ARN) of the task that ran.</p>', 'GetMaintenanceWindowTaskResult$TaskArn' => '<p>The resource that the task used during execution. For <code>RUN_COMMAND</code> and <code>AUTOMATION</code> task types, the value of <code>TaskArn</code> is the SSM document name/ARN. For <code>LAMBDA</code> tasks, the value is the function name/ARN. For <code>STEP_FUNCTIONS</code> tasks, the value is the state machine ARN.</p>', 'MaintenanceWindowExecutionTaskIdentity$TaskArn' => '<p>The Amazon Resource Name (ARN) of the task that ran.</p>', 'MaintenanceWindowTask$TaskArn' => '<p>The resource that the task uses during execution. For <code>RUN_COMMAND</code> and <code>AUTOMATION</code> task types, <code>TaskArn</code> is the Amazon Web Services Systems Manager (SSM document) name or ARN. For <code>LAMBDA</code> tasks, it\'s the function name or ARN. For <code>STEP_FUNCTIONS</code> tasks, it\'s the state machine ARN.</p>', 'RegisterTaskWithMaintenanceWindowRequest$TaskArn' => '<p>The ARN of the task to run.</p>', 'UpdateMaintenanceWindowTaskRequest$TaskArn' => '<p>The task ARN to modify.</p>', 'UpdateMaintenanceWindowTaskResult$TaskArn' => '<p>The updated task ARN value.</p>', ], ], 'MaintenanceWindowTaskCutoffBehavior' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowTaskResult$CutoffBehavior' => '<p>The action to take on tasks when the maintenance window cutoff time is reached. <code>CONTINUE_TASK</code> means that tasks continue to run. For Automation, Lambda, Step Functions tasks, <code>CANCEL_TASK</code> means that currently running task invocations continue, but no new task invocations are started. For Run Command tasks, <code>CANCEL_TASK</code> means the system attempts to stop the task by sending a <code>CancelCommand</code> operation.</p>', 'MaintenanceWindowTask$CutoffBehavior' => '<p>The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p>', 'RegisterTaskWithMaintenanceWindowRequest$CutoffBehavior' => '<p>Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p> <ul> <li> <p> <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The default value.</p> </li> <li> <p> <code>CANCEL_TASK</code>:</p> <ul> <li> <p>For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that are already running continue, but no new task invocations are started.</p> </li> <li> <p>For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation that attempts to cancel the command associated with the task. However, there is no guarantee that the command will be terminated and the underlying process stopped.</p> </li> </ul> <p>The status for tasks that are not completed is <code>TIMED_OUT</code>.</p> </li> </ul>', 'UpdateMaintenanceWindowTaskRequest$CutoffBehavior' => '<p>Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p> <ul> <li> <p> <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The default value.</p> </li> <li> <p> <code>CANCEL_TASK</code>:</p> <ul> <li> <p>For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that are already running continue, but no new task invocations are started.</p> </li> <li> <p>For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation that attempts to cancel the command associated with the task. However, there is no guarantee that the command will be terminated and the underlying process stopped.</p> </li> </ul> <p>The status for tasks that are not completed is <code>TIMED_OUT</code>.</p> </li> </ul>', 'UpdateMaintenanceWindowTaskResult$CutoffBehavior' => '<p>The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p>', ], ], 'MaintenanceWindowTaskId' => [ 'base' => NULL, 'refs' => [ 'DeregisterTaskFromMaintenanceWindowRequest$WindowTaskId' => '<p>The ID of the task to remove from the maintenance window.</p>', 'DeregisterTaskFromMaintenanceWindowResult$WindowTaskId' => '<p>The ID of the task removed from the maintenance window.</p>', 'GetMaintenanceWindowTaskRequest$WindowTaskId' => '<p>The maintenance window task ID to retrieve.</p>', 'GetMaintenanceWindowTaskResult$WindowTaskId' => '<p>The retrieved maintenance window task ID.</p>', 'MaintenanceWindowTask$WindowTaskId' => '<p>The task ID.</p>', 'RegisterTaskWithMaintenanceWindowResult$WindowTaskId' => '<p>The ID of the task in the maintenance window.</p>', 'UpdateMaintenanceWindowTaskRequest$WindowTaskId' => '<p>The task ID to modify.</p>', 'UpdateMaintenanceWindowTaskResult$WindowTaskId' => '<p>The task ID of the maintenance window that was updated.</p>', ], ], 'MaintenanceWindowTaskInvocationParameters' => [ 'base' => '<p>The parameters for task execution.</p>', 'refs' => [ 'GetMaintenanceWindowTaskResult$TaskInvocationParameters' => '<p>The parameters to pass to the task when it runs.</p>', 'RegisterTaskWithMaintenanceWindowRequest$TaskInvocationParameters' => '<p>The parameters that the task should use during execution. Populate only the fields that match the task type. All other fields should be empty. </p>', 'UpdateMaintenanceWindowTaskRequest$TaskInvocationParameters' => '<p>The parameters that the task should use during execution. Populate only the fields that match the task type. All other fields should be empty.</p> <important> <p>When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code>, you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values you don\'t specify again are removed. For example, suppose that when you registered a Run Command task, you specified <code>TaskInvocationParameters</code> values for <code>Comment</code>, <code>NotificationConfig</code>, and <code>OutputS3BucketName</code>. If you update the maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code> are removed.</p> </important>', 'UpdateMaintenanceWindowTaskResult$TaskInvocationParameters' => '<p>The updated parameter values.</p>', ], ], 'MaintenanceWindowTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowTasksResult$Tasks' => '<p>Information about the tasks in the maintenance window.</p>', ], ], 'MaintenanceWindowTaskParameterName' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowTaskParameters$key' => NULL, ], ], 'MaintenanceWindowTaskParameterValue' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowTaskParameterValueList$member' => NULL, ], ], 'MaintenanceWindowTaskParameterValueExpression' => [ 'base' => '<p>Defines the values for a task parameter.</p>', 'refs' => [ 'MaintenanceWindowTaskParameters$value' => NULL, ], ], 'MaintenanceWindowTaskParameterValueList' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowTaskParameterValueExpression$Values' => '<p>This field contains an array of 0 or more strings, each 1 to 255 characters in length.</p>', ], ], 'MaintenanceWindowTaskParameters' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowTaskResult$TaskParameters' => '<p>The parameters to pass to the task when it runs.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'MaintenanceWindowTask$TaskParameters' => '<p>The parameters that should be passed to the task when it is run.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'MaintenanceWindowTaskParametersList$member' => NULL, 'RegisterTaskWithMaintenanceWindowRequest$TaskParameters' => '<p>The parameters that should be passed to the task when it is run.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'UpdateMaintenanceWindowTaskRequest$TaskParameters' => '<p>The parameters to modify.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note> <p>The map has the following format:</p> <p>Key: string, between 1 and 255 characters</p> <p>Value: an array of strings, each string is between 1 and 255 characters</p>', 'UpdateMaintenanceWindowTaskResult$TaskParameters' => '<p>The updated parameter values.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', ], ], 'MaintenanceWindowTaskParametersList' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskResult$TaskParameters' => '<p>The parameters passed to the task when it was run.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note> <p>The map has the following format:</p> <ul> <li> <p> <code>Key</code>: string, between 1 and 255 characters</p> </li> <li> <p> <code>Value</code>: an array of strings, each between 1 and 255 characters</p> </li> </ul>', ], ], 'MaintenanceWindowTaskPriority' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskResult$Priority' => '<p>The priority of the task.</p>', 'GetMaintenanceWindowTaskResult$Priority' => '<p>The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>', 'MaintenanceWindowTask$Priority' => '<p>The priority of the task in the maintenance window. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Priority' => '<p>The priority of the task in the maintenance window, the lower the number the higher the priority. Tasks in a maintenance window are scheduled in priority order with tasks that have the same priority scheduled in parallel.</p>', 'UpdateMaintenanceWindowTaskRequest$Priority' => '<p>The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>', 'UpdateMaintenanceWindowTaskResult$Priority' => '<p>The updated priority value.</p>', ], ], 'MaintenanceWindowTaskTargetId' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$WindowTargetId' => '<p>The maintenance window target ID.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$WindowTargetId' => '<p>The ID of the target definition in this maintenance window the invocation was performed for.</p>', ], ], 'MaintenanceWindowTaskType' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$TaskType' => '<p>Retrieves the task type for a maintenance window.</p>', 'GetMaintenanceWindowExecutionTaskResult$Type' => '<p>The type of task that was run.</p>', 'GetMaintenanceWindowTaskResult$TaskType' => '<p>The type of task to run.</p>', 'MaintenanceWindowExecutionTaskIdentity$TaskType' => '<p>The type of task that ran.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$TaskType' => '<p>The task type.</p>', 'MaintenanceWindowTask$Type' => '<p>The type of task.</p>', 'RegisterTaskWithMaintenanceWindowRequest$TaskType' => '<p>The type of task being registered.</p>', ], ], 'MaintenanceWindowTimezone' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$ScheduleTimezone' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>', 'GetMaintenanceWindowResult$ScheduleTimezone' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>', 'MaintenanceWindowIdentity$ScheduleTimezone' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format.</p>', 'UpdateMaintenanceWindowRequest$ScheduleTimezone' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>', 'UpdateMaintenanceWindowResult$ScheduleTimezone' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>', ], ], 'MaintenanceWindowsForTargetList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowsForTargetResult$WindowIdentities' => '<p>Information about the maintenance window targets and tasks a managed node is associated with.</p>', ], ], 'ManagedInstanceId' => [ 'base' => NULL, 'refs' => [ 'DeregisterManagedInstanceRequest$InstanceId' => '<p>The ID assigned to the managed node when you registered it using the activation process. </p>', 'UpdateManagedInstanceRoleRequest$InstanceId' => '<p>The ID of the managed node where you want to update the role.</p>', ], ], 'MaxConcurrency' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$MaxConcurrency' => '<p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p> <p>If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code>.</p>', 'AssociationVersionInfo$MaxConcurrency' => '<p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p> <p>If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code>.</p>', 'AutomationExecution$MaxConcurrency' => '<p>The <code>MaxConcurrency</code> value specified by the user when the execution started.</p>', 'AutomationExecutionMetadata$MaxConcurrency' => '<p>The <code>MaxConcurrency</code> value specified by the user when starting the automation.</p>', 'Command$MaxConcurrency' => '<p>The maximum number of managed nodes that are allowed to run the command at the same time. You can specify a number of managed nodes, such as 10, or a percentage of nodes, such as 10%. The default value is 50. For more information about how to use <code>MaxConcurrency</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using Systems Manager Run Command</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'CreateAssociationBatchRequestEntry$MaxConcurrency' => '<p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p> <p>If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code>.</p>', 'CreateAssociationRequest$MaxConcurrency' => '<p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p> <p>If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code>.</p>', 'GetMaintenanceWindowExecutionTaskResult$MaxConcurrency' => '<p>The defined maximum number of task executions that could be run in parallel.</p>', 'GetMaintenanceWindowTaskResult$MaxConcurrency' => '<p>The maximum number of targets allowed to run this task in parallel.</p> <note> <p>For maintenance window tasks without a target specified, you can\'t supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn\'t affect the running of your task and can be ignored.</p> </note>', 'MaintenanceWindowTask$MaxConcurrency' => '<p>The maximum number of targets this task can be run for, in parallel.</p> <note> <p>Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.</p> <p>For maintenance window tasks without a target specified, you can\'t supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn\'t affect the running of your task.</p> </note>', 'RegisterTaskWithMaintenanceWindowRequest$MaxConcurrency' => '<p>The maximum number of targets this task can be run for, in parallel.</p> <note> <p>Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.</p> <p>For maintenance window tasks without a target specified, you can\'t supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn\'t affect the running of your task.</p> </note>', 'Runbook$MaxConcurrency' => '<p>The <code>MaxConcurrency</code> value specified by the user when the operation started, indicating the maximum number of resources that the runbook operation can run on at the same time.</p>', 'SendCommandRequest$MaxConcurrency' => '<p>(Optional) The maximum number of managed nodes that are allowed to run the command at the same time. You can specify a number such as 10 or a percentage such as 10%. The default value is <code>50</code>. For more information about how to use <code>MaxConcurrency</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity">Using concurrency controls</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'StartAutomationExecutionRequest$MaxConcurrency' => '<p>The maximum number of targets allowed to run this task in parallel. You can specify a number, such as 10, or a percentage, such as 10%. The default value is <code>10</code>.</p>', 'TargetLocation$TargetLocationMaxConcurrency' => '<p>The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation concurrently.</p>', 'UpdateAssociationRequest$MaxConcurrency' => '<p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p> <p>If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code>.</p>', 'UpdateMaintenanceWindowTaskRequest$MaxConcurrency' => '<p>The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the number of targets that are allowed to run this task, in parallel.</p> <note> <p>Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.</p> <p>For maintenance window tasks without a target specified, you can\'t supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn\'t affect the running of your task.</p> </note>', 'UpdateMaintenanceWindowTaskResult$MaxConcurrency' => '<p>The updated <code>MaxConcurrency</code> value.</p>', ], ], 'MaxDocumentSizeExceeded' => [ 'base' => '<p>The size limit of a document is 64 KB.</p>', 'refs' => [], ], 'MaxErrors' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$MaxErrors' => '<p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.</p> <p>Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.</p>', 'AssociationVersionInfo$MaxErrors' => '<p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.</p> <p>Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.</p>', 'AutomationExecution$MaxErrors' => '<p>The MaxErrors value specified by the user when the execution started.</p>', 'AutomationExecutionMetadata$MaxErrors' => '<p>The <code>MaxErrors</code> value specified by the user when starting the automation.</p>', 'Command$MaxErrors' => '<p>The maximum number of errors allowed before the system stops sending the command to additional targets. You can specify a number of errors, such as 10, or a percentage or errors, such as 10%. The default value is <code>0</code>. For more information about how to use <code>MaxErrors</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using Systems Manager Run Command</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'CreateAssociationBatchRequestEntry$MaxErrors' => '<p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.</p> <p>Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.</p>', 'CreateAssociationRequest$MaxErrors' => '<p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.</p> <p>Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.</p>', 'GetMaintenanceWindowExecutionTaskResult$MaxErrors' => '<p>The defined maximum number of task execution errors allowed before scheduling of the task execution would have been stopped.</p>', 'GetMaintenanceWindowTaskResult$MaxErrors' => '<p>The maximum number of errors allowed before the task stops being scheduled.</p> <note> <p>For maintenance window tasks without a target specified, you can\'t supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn\'t affect the running of your task and can be ignored.</p> </note>', 'MaintenanceWindowTask$MaxErrors' => '<p>The maximum number of errors allowed before this task stops being scheduled.</p> <note> <p>Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.</p> <p>For maintenance window tasks without a target specified, you can\'t supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn\'t affect the running of your task.</p> </note>', 'RegisterTaskWithMaintenanceWindowRequest$MaxErrors' => '<p>The maximum number of errors allowed before this task stops being scheduled.</p> <note> <p>Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.</p> <p>For maintenance window tasks without a target specified, you can\'t supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn\'t affect the running of your task.</p> </note>', 'Runbook$MaxErrors' => '<p>The <code>MaxErrors</code> value specified by the user when the execution started, indicating the maximum number of errors that can occur during the operation before the updates are stopped or rolled back.</p>', 'SendCommandRequest$MaxErrors' => '<p>The maximum number of errors allowed without the command failing. When the command fails one more time beyond the value of <code>MaxErrors</code>, the systems stops sending the command to additional targets. You can specify a number like 10 or a percentage like 10%. The default value is <code>0</code>. For more information about how to use <code>MaxErrors</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors">Using error controls</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'StartAutomationExecutionRequest$MaxErrors' => '<p>The number of errors that are allowed before the system stops running the automation on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops running the automation when the fourth error is received. If you specify 0, then the system stops running the automation on additional targets after the first error result is returned. If you run an automation on 50 resources and set max-errors to 10%, then the system stops running the automation on additional targets when the sixth error is received.</p> <p>Executions that are already running an automation when max-errors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set max-concurrency to 1 so the executions proceed one at a time.</p>', 'TargetLocation$TargetLocationMaxErrors' => '<p>The maximum number of errors allowed before the system stops queueing additional Automation executions for the currently running Automation.</p>', 'UpdateAssociationRequest$MaxErrors' => '<p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.</p> <p>Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.</p>', 'UpdateMaintenanceWindowTaskRequest$MaxErrors' => '<p>The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of errors that are allowed before the task stops being scheduled.</p> <note> <p>Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.</p> <p>For maintenance window tasks without a target specified, you can\'t supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn\'t affect the running of your task.</p> </note>', 'UpdateMaintenanceWindowTaskResult$MaxErrors' => '<p>The updated <code>MaxErrors</code> value.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeAssociationExecutionTargetsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeAssociationExecutionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeAutomationExecutionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeAutomationStepExecutionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeInstanceAssociationsStatusRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeInventoryDeletionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeParametersRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribePatchPropertiesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'GetInventoryRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'GetOpsSummaryRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'GetParameterHistoryRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListAssociationVersionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListAssociationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListComplianceItemsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListComplianceSummariesRequest$MaxResults' => '<p>The maximum number of items to return for this call. Currently, you can specify null or 50. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListDocumentMetadataHistoryRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListDocumentVersionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListDocumentsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListInventoryEntriesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListResourceComplianceSummariesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListResourceDataSyncRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'MaxResultsEC2Compatible' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. </p>', ], ], 'MaxSessionDuration' => [ 'base' => NULL, 'refs' => [ 'Session$MaxSessionDuration' => '<p>The maximum duration of a session before it terminates.</p>', ], ], 'MetadataKey' => [ 'base' => NULL, 'refs' => [ 'MetadataKeysToDeleteList$member' => NULL, 'MetadataMap$key' => NULL, ], ], 'MetadataKeysToDeleteList' => [ 'base' => NULL, 'refs' => [ 'UpdateOpsMetadataRequest$KeysToDelete' => '<p>The metadata keys to delete from the OpsMetadata object. </p>', ], ], 'MetadataMap' => [ 'base' => NULL, 'refs' => [ 'CreateOpsMetadataRequest$Metadata' => '<p>Metadata for a new Application Manager application. </p>', 'GetOpsMetadataResult$Metadata' => '<p>OpsMetadata for an Application Manager application.</p>', 'UpdateOpsMetadataRequest$MetadataToUpdate' => '<p>Metadata to add to an OpsMetadata object.</p>', ], ], 'MetadataValue' => [ 'base' => '<p>Metadata to assign to an Application Manager application.</p>', 'refs' => [ 'MetadataMap$value' => NULL, ], ], 'MetadataValueString' => [ 'base' => NULL, 'refs' => [ 'MetadataValue$Value' => '<p>Metadata value to assign to an Application Manager application.</p>', ], ], 'ModifyDocumentPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDocumentPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'DescribeActivationsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results. </p>', 'DescribeAssociationExecutionTargetsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'DescribeAssociationExecutionTargetsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'DescribeAssociationExecutionsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'DescribeAssociationExecutionsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'DescribeAutomationExecutionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeAutomationExecutionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeAutomationStepExecutionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeAutomationStepExecutionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeAvailablePatchesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeAvailablePatchesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeDocumentPermissionRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeDocumentPermissionResponse$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'DescribeEffectiveInstanceAssociationsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeEffectiveInstanceAssociationsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeEffectivePatchesForPatchBaselineRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeEffectivePatchesForPatchBaselineResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstanceAssociationsStatusRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstanceAssociationsStatusResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstanceInformationRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstanceInformationResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty. </p>', 'DescribeInstancePatchStatesForPatchGroupRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstancePatchStatesForPatchGroupResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstancePatchStatesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstancePatchStatesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstancePatchesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstancePatchesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInventoryDeletionsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'DescribeInventoryDeletionsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowExecutionTaskInvocationsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowExecutionTasksResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowExecutionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowExecutionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowScheduleRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowScheduleResult$NextToken' => '<p>The token for the next set of items to return. (You use this token in the next call.)</p>', 'DescribeMaintenanceWindowTargetsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowTargetsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowTasksRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowTasksResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowsForTargetRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowsForTargetResult$NextToken' => '<p>The token for the next set of items to return. (You use this token in the next call.)</p>', 'DescribeMaintenanceWindowsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeParametersRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeParametersResult$NextToken' => '<p>The token to use when requesting the next set of items.</p>', 'DescribePatchBaselinesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribePatchBaselinesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribePatchGroupsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribePatchGroupsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribePatchPropertiesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribePatchPropertiesResult$NextToken' => '<p>The token for the next set of items to return. (You use this token in the next call.)</p>', 'DescribeSessionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeSessionsResponse$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetInventoryRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetInventoryResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'GetInventorySchemaRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetInventorySchemaResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'GetOpsMetadataRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'GetOpsMetadataResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'GetOpsSummaryRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'GetOpsSummaryResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'GetParameterHistoryRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetParameterHistoryResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'GetParametersByPathRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'GetParametersByPathResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListAssociationVersionsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListAssociationVersionsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListAssociationsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListAssociationsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListCommandInvocationsRequest$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListCommandInvocationsResult$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListCommandsRequest$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListCommandsResult$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListComplianceItemsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListComplianceItemsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListComplianceSummariesRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListComplianceSummariesResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListDocumentMetadataHistoryRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListDocumentMetadataHistoryResponse$NextToken' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListDocumentVersionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListDocumentVersionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListDocumentsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListDocumentsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListInventoryEntriesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListInventoryEntriesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListOpsMetadataRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'ListOpsMetadataResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListResourceComplianceSummariesRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListResourceComplianceSummariesResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListResourceDataSyncRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListResourceDataSyncResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', ], ], 'NonCompliantSummary' => [ 'base' => '<p>A summary of resources that aren\'t compliant. The summary is organized according to resource type.</p>', 'refs' => [ 'ComplianceSummaryItem$NonCompliantSummary' => '<p>A list of NON_COMPLIANT items for the specified compliance type.</p>', 'ResourceComplianceSummaryItem$NonCompliantSummary' => '<p>A list of items that aren\'t compliant for the resource.</p>', ], ], 'NormalStringMap' => [ 'base' => NULL, 'refs' => [ 'StepExecution$Inputs' => '<p>Fully-resolved values passed into the step before execution.</p>', ], ], 'NotificationArn' => [ 'base' => NULL, 'refs' => [ 'NotificationConfig$NotificationArn' => '<p>An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run Command pushes notifications about command status changes to this topic.</p>', ], ], 'NotificationConfig' => [ 'base' => '<p>Configurations for sending notifications.</p>', 'refs' => [ 'Command$NotificationConfig' => '<p>Configurations for sending notifications about command status changes. </p>', 'CommandInvocation$NotificationConfig' => '<p>Configurations for sending notifications about command status changes on a per managed node basis.</p>', 'MaintenanceWindowRunCommandParameters$NotificationConfig' => '<p>Configurations for sending notifications about command status changes on a per-managed node basis.</p>', 'SendCommandRequest$NotificationConfig' => '<p>Configurations for sending notifications.</p>', ], ], 'NotificationEvent' => [ 'base' => NULL, 'refs' => [ 'NotificationEventList$member' => NULL, ], ], 'NotificationEventList' => [ 'base' => NULL, 'refs' => [ 'NotificationConfig$NotificationEvents' => '<p>The different events for which you can receive notifications. To learn more about these events, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', ], ], 'NotificationType' => [ 'base' => NULL, 'refs' => [ 'NotificationConfig$NotificationType' => '<p>The type of notification.</p> <ul> <li> <p> <code>Command</code>: Receive notification when the status of a command changes.</p> </li> <li> <p> <code>Invocation</code>: For commands sent to multiple managed nodes, receive notification on a per-node basis when the status of a command changes. </p> </li> </ul>', ], ], 'OperatingSystem' => [ 'base' => NULL, 'refs' => [ 'BaselineOverride$OperatingSystem' => '<p>The operating system rule used by the patch baseline override.</p>', 'CreatePatchBaselineRequest$OperatingSystem' => '<p>Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.</p>', 'DescribePatchPropertiesRequest$OperatingSystem' => '<p>The operating system type for which to list patches.</p>', 'GetDefaultPatchBaselineRequest$OperatingSystem' => '<p>Returns the default patch baseline for the specified operating system.</p>', 'GetDefaultPatchBaselineResult$OperatingSystem' => '<p>The operating system for the returned patch baseline. </p>', 'GetPatchBaselineForPatchGroupRequest$OperatingSystem' => '<p>Returns he operating system rule specified for patch groups using the patch baseline.</p>', 'GetPatchBaselineForPatchGroupResult$OperatingSystem' => '<p>The operating system rule specified for patch groups using the patch baseline.</p>', 'GetPatchBaselineResult$OperatingSystem' => '<p>Returns the operating system specified for the patch baseline.</p>', 'PatchBaselineIdentity$OperatingSystem' => '<p>Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>. </p>', 'UpdatePatchBaselineResult$OperatingSystem' => '<p>The operating system rule used by the updated patch baseline.</p>', ], ], 'OpsAggregator' => [ 'base' => '<p>One or more aggregators for viewing counts of OpsData using different dimensions such as <code>Source</code>, <code>CreatedTime</code>, or <code>Source and CreatedTime</code>, to name a few.</p>', 'refs' => [ 'OpsAggregatorList$member' => NULL, ], ], 'OpsAggregatorList' => [ 'base' => NULL, 'refs' => [ 'GetOpsSummaryRequest$Aggregators' => '<p>Optional aggregators that return counts of OpsData based on one or more expressions.</p>', 'OpsAggregator$Aggregators' => '<p>A nested aggregator for viewing counts of OpsData.</p>', ], ], 'OpsAggregatorType' => [ 'base' => NULL, 'refs' => [ 'OpsAggregator$AggregatorType' => '<p>Either a <code>Range</code> or <code>Count</code> aggregator for limiting an OpsData summary.</p>', ], ], 'OpsAggregatorValue' => [ 'base' => NULL, 'refs' => [ 'OpsAggregatorValueMap$value' => NULL, ], ], 'OpsAggregatorValueKey' => [ 'base' => NULL, 'refs' => [ 'OpsAggregatorValueMap$key' => NULL, ], ], 'OpsAggregatorValueMap' => [ 'base' => NULL, 'refs' => [ 'OpsAggregator$Values' => '<p>The aggregator value.</p>', ], ], 'OpsDataAttributeName' => [ 'base' => NULL, 'refs' => [ 'OpsAggregator$AttributeName' => '<p>The name of an OpsData attribute on which to limit the count of OpsData.</p>', ], ], 'OpsDataTypeName' => [ 'base' => NULL, 'refs' => [ 'OpsAggregator$TypeName' => '<p>The data type name to use for viewing counts of OpsData.</p>', 'OpsResultAttribute$TypeName' => '<p>Name of the data type. Valid value: <code>AWS:OpsItem</code>, <code>AWS:EC2InstanceInformation</code>, <code>AWS:OpsItemTrendline</code>, or <code>AWS:ComplianceSummary</code>.</p>', ], ], 'OpsEntity' => [ 'base' => '<p>The result of the query.</p>', 'refs' => [ 'OpsEntityList$member' => NULL, ], ], 'OpsEntityId' => [ 'base' => NULL, 'refs' => [ 'OpsEntity$Id' => '<p>The query ID.</p>', ], ], 'OpsEntityItem' => [ 'base' => '<p>The OpsData summary.</p>', 'refs' => [ 'OpsEntityItemMap$value' => NULL, ], ], 'OpsEntityItemCaptureTime' => [ 'base' => NULL, 'refs' => [ 'OpsEntityItem$CaptureTime' => '<p>The time the OpsData was captured.</p>', ], ], 'OpsEntityItemEntry' => [ 'base' => NULL, 'refs' => [ 'OpsEntityItemEntryList$member' => NULL, ], ], 'OpsEntityItemEntryList' => [ 'base' => NULL, 'refs' => [ 'OpsEntityItem$Content' => '<p>The details of an OpsData summary.</p>', ], ], 'OpsEntityItemKey' => [ 'base' => NULL, 'refs' => [ 'OpsEntityItemMap$key' => NULL, ], ], 'OpsEntityItemMap' => [ 'base' => NULL, 'refs' => [ 'OpsEntity$Data' => '<p>The data returned by the query.</p>', ], ], 'OpsEntityList' => [ 'base' => NULL, 'refs' => [ 'GetOpsSummaryResult$Entities' => '<p>The list of aggregated details and filtered OpsData.</p>', ], ], 'OpsFilter' => [ 'base' => '<p>A filter for viewing OpsData summaries.</p>', 'refs' => [ 'OpsFilterList$member' => NULL, ], ], 'OpsFilterKey' => [ 'base' => NULL, 'refs' => [ 'OpsFilter$Key' => '<p>The name of the filter.</p>', ], ], 'OpsFilterList' => [ 'base' => NULL, 'refs' => [ 'GetOpsSummaryRequest$Filters' => '<p>Optional filters used to scope down the returned OpsData. </p>', 'OpsAggregator$Filters' => '<p>The aggregator filters.</p>', ], ], 'OpsFilterOperatorType' => [ 'base' => NULL, 'refs' => [ 'OpsFilter$Type' => '<p>The type of filter.</p>', ], ], 'OpsFilterValue' => [ 'base' => NULL, 'refs' => [ 'OpsFilterValueList$member' => NULL, ], ], 'OpsFilterValueList' => [ 'base' => NULL, 'refs' => [ 'OpsFilter$Values' => '<p>The filter value.</p>', ], ], 'OpsItem' => [ 'base' => '<p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational work items (OpsItems) impacting the performance and health of their Amazon Web Services resources. OpsCenter is integrated with Amazon EventBridge and Amazon CloudWatch. This means you can configure these services to automatically create an OpsItem in OpsCenter when a CloudWatch alarm enters the ALARM state or when EventBridge processes an event from any Amazon Web Services service that publishes events. Configuring Amazon CloudWatch alarms and EventBridge events to automatically create OpsItems allows you to quickly diagnose and remediate issues with Amazon Web Services resources from a single console.</p> <p>To help you diagnose issues, each OpsItem includes contextually relevant information such as the name and ID of the Amazon Web Services resource that generated the OpsItem, alarm or event details, alarm history, and an alarm timeline graph. For the Amazon Web Services resource, OpsCenter aggregates information from Config, CloudTrail logs, and EventBridge, so you don\'t have to navigate across multiple console pages during your investigation. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>', 'refs' => [ 'GetOpsItemResponse$OpsItem' => '<p>The OpsItem.</p>', ], ], 'OpsItemAlreadyExistsException' => [ 'base' => '<p>The OpsItem already exists.</p>', 'refs' => [], ], 'OpsItemCategory' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Category' => '<p>Specify a category to assign to an OpsItem. </p>', 'OpsItem$Category' => '<p>An OpsItem category. Category options include: Availability, Cost, Performance, Recovery, Security.</p>', 'OpsItemSummary$Category' => '<p>A list of OpsItems by category.</p>', 'UpdateOpsItemRequest$Category' => '<p>Specify a new category for an OpsItem.</p>', ], ], 'OpsItemDataKey' => [ 'base' => NULL, 'refs' => [ 'OpsItemOperationalData$key' => NULL, ], ], 'OpsItemDataType' => [ 'base' => NULL, 'refs' => [ 'OpsItemDataValue$Type' => '<p>The type of key-value pair. Valid types include <code>SearchableString</code> and <code>String</code>.</p>', ], ], 'OpsItemDataValue' => [ 'base' => '<p>An object that defines the value of the key and its type in the OperationalData map.</p>', 'refs' => [ 'OpsItemOperationalData$value' => NULL, ], ], 'OpsItemDataValueString' => [ 'base' => NULL, 'refs' => [ 'OpsItemDataValue$Value' => '<p>The value of the OperationalData key.</p>', ], ], 'OpsItemDescription' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Description' => '<p>Information about the OpsItem. </p>', 'OpsItem$Description' => '<p>The OpsItem description.</p>', 'UpdateOpsItemRequest$Description' => '<p>Update the information about the OpsItem. Provide enough information so that users reading this OpsItem for the first time understand the issue. </p>', ], ], 'OpsItemEventFilter' => [ 'base' => '<p>Describes a filter for a specific list of OpsItem events. You can filter event information by using tags. You specify tags by using a key-value pair mapping. </p>', 'refs' => [ 'OpsItemEventFilters$member' => NULL, ], ], 'OpsItemEventFilterKey' => [ 'base' => NULL, 'refs' => [ 'OpsItemEventFilter$Key' => '<p>The name of the filter key. Currently, the only supported value is <code>OpsItemId</code>.</p>', ], ], 'OpsItemEventFilterOperator' => [ 'base' => NULL, 'refs' => [ 'OpsItemEventFilter$Operator' => '<p>The operator used by the filter call. Currently, the only supported value is <code>Equal</code>.</p>', ], ], 'OpsItemEventFilterValue' => [ 'base' => NULL, 'refs' => [ 'OpsItemEventFilterValues$member' => NULL, ], ], 'OpsItemEventFilterValues' => [ 'base' => NULL, 'refs' => [ 'OpsItemEventFilter$Values' => '<p>The values for the filter, consisting of one or more OpsItem IDs.</p>', ], ], 'OpsItemEventFilters' => [ 'base' => NULL, 'refs' => [ 'ListOpsItemEventsRequest$Filters' => '<p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>', ], ], 'OpsItemEventMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListOpsItemEventsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. </p>', ], ], 'OpsItemEventSummaries' => [ 'base' => NULL, 'refs' => [ 'ListOpsItemEventsResponse$Summaries' => '<p>A list of event information for the specified OpsItems.</p>', ], ], 'OpsItemEventSummary' => [ 'base' => '<p>Summary information about an OpsItem event or that associated an OpsItem with a related item.</p>', 'refs' => [ 'OpsItemEventSummaries$member' => NULL, ], ], 'OpsItemFilter' => [ 'base' => '<p>Describes an OpsItem filter.</p>', 'refs' => [ 'OpsItemFilters$member' => NULL, ], ], 'OpsItemFilterKey' => [ 'base' => NULL, 'refs' => [ 'OpsItemFilter$Key' => '<p>The name of the filter.</p>', ], ], 'OpsItemFilterOperator' => [ 'base' => NULL, 'refs' => [ 'OpsItemFilter$Operator' => '<p>The operator used by the filter call.</p>', ], ], 'OpsItemFilterValue' => [ 'base' => NULL, 'refs' => [ 'OpsItemFilterValues$member' => NULL, ], ], 'OpsItemFilterValues' => [ 'base' => NULL, 'refs' => [ 'OpsItemFilter$Values' => '<p>The filter value.</p>', ], ], 'OpsItemFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeOpsItemsRequest$OpsItemFilters' => '<p>One or more filters to limit the response.</p> <ul> <li> <p>Key: CreatedTime</p> <p>Operations: GreaterThan, LessThan</p> </li> <li> <p>Key: LastModifiedBy</p> <p>Operations: Contains, Equals</p> </li> <li> <p>Key: LastModifiedTime</p> <p>Operations: GreaterThan, LessThan</p> </li> <li> <p>Key: Priority</p> <p>Operations: Equals</p> </li> <li> <p>Key: Source</p> <p>Operations: Contains, Equals</p> </li> <li> <p>Key: Status</p> <p>Operations: Equals</p> </li> <li> <p>Key: Title*</p> <p>Operations: Equals,Contains</p> </li> <li> <p>Key: OperationalData**</p> <p>Operations: Equals</p> </li> <li> <p>Key: OperationalDataKey</p> <p>Operations: Equals</p> </li> <li> <p>Key: OperationalDataValue</p> <p>Operations: Equals, Contains</p> </li> <li> <p>Key: OpsItemId</p> <p>Operations: Equals</p> </li> <li> <p>Key: ResourceId</p> <p>Operations: Contains</p> </li> <li> <p>Key: AutomationId</p> <p>Operations: Equals</p> </li> </ul> <p>*The Equals operator for Title matches the first 100 characters. If you specify more than 100 characters, they system returns an error that the filter value exceeds the length limit.</p> <p>**If you filter the response by using the OperationalData operator, specify a key-value pair by using the following JSON format: {"key":"key_name","value":"a_value"}</p>', ], ], 'OpsItemId' => [ 'base' => NULL, 'refs' => [ 'AssociateOpsItemRelatedItemRequest$OpsItemId' => '<p>The ID of the OpsItem to which you want to associate a resource as a related item.</p>', 'DisassociateOpsItemRelatedItemRequest$OpsItemId' => '<p>The ID of the OpsItem for which you want to delete an association between the OpsItem and a related item.</p>', 'GetOpsItemRequest$OpsItemId' => '<p>The ID of the OpsItem that you want to get.</p>', 'ListOpsItemRelatedItemsRequest$OpsItemId' => '<p>The ID of the OpsItem for which you want to list all related-item resources.</p>', 'OpsItem$OpsItemId' => '<p>The ID of the OpsItem.</p>', 'OpsItemRelatedItemAlreadyExistsException$OpsItemId' => NULL, 'OpsItemRelatedItemSummary$OpsItemId' => '<p>The OpsItem ID.</p>', 'OpsItemSummary$OpsItemId' => '<p>The ID of the OpsItem.</p>', 'UpdateOpsItemRequest$OpsItemId' => '<p>The ID of the OpsItem.</p>', ], ], 'OpsItemIdentity' => [ 'base' => '<p>Information about the user or resource that created an OpsItem event.</p>', 'refs' => [ 'OpsItemEventSummary$CreatedBy' => '<p>Information about the user or resource that created the OpsItem event.</p>', 'OpsItemRelatedItemSummary$CreatedBy' => NULL, 'OpsItemRelatedItemSummary$LastModifiedBy' => NULL, ], ], 'OpsItemInvalidParameterException' => [ 'base' => '<p>A specified parameter argument isn\'t valid. Verify the available arguments and try again.</p>', 'refs' => [], ], 'OpsItemLimitExceededException' => [ 'base' => '<p>The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits">What are the resource limits for OpsCenter?</a>.</p>', 'refs' => [], ], 'OpsItemMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeOpsItemsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'OpsItemNotFoundException' => [ 'base' => '<p>The specified OpsItem ID doesn\'t exist. Verify the ID and try again.</p>', 'refs' => [], ], 'OpsItemNotification' => [ 'base' => '<p>A notification about the OpsItem.</p>', 'refs' => [ 'OpsItemNotifications$member' => NULL, ], ], 'OpsItemNotifications' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Notifications' => '<p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed.</p>', 'OpsItem$Notifications' => '<p>The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where notifications are sent when this OpsItem is edited or changed.</p>', 'UpdateOpsItemRequest$Notifications' => '<p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed.</p>', ], ], 'OpsItemOperationalData' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$OperationalData' => '<p>Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.</p> <important> <p>Operational data keys <i>can\'t</i> begin with the following: <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>, <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p> </important> <p>You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the <a>DescribeOpsItems</a> API operation) can view and search on the specified data. Operational data that isn\'t searchable is only viewable by users who have access to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p> <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in the request. Use the <code>/aws/automations</code> key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'OpsItem$OperationalData' => '<p>Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.</p> <important> <p>Operational data keys <i>can\'t</i> begin with the following: <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>, <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p> </important> <p>You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the <a>DescribeOpsItems</a> API operation) can view and search on the specified data. Operational data that isn\'t searchable is only viewable by users who have access to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p> <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in the request. Use the <code>/aws/automations</code> key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'OpsItemSummary$OperationalData' => '<p>Operational data is custom data that provides useful reference details about the OpsItem. </p>', 'UpdateOpsItemRequest$OperationalData' => '<p>Add new keys or edit existing key-value pairs of the OperationalData map in the OpsItem object.</p> <p>Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.</p> <important> <p>Operational data keys <i>can\'t</i> begin with the following: <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>, <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p> </important> <p>You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the <a>DescribeOpsItems</a> API operation) can view and search on the specified data. Operational data that isn\'t searchable is only viewable by users who have access to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p> <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in the request. Use the <code>/aws/automations</code> key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', ], ], 'OpsItemOpsDataKeysList' => [ 'base' => NULL, 'refs' => [ 'UpdateOpsItemRequest$OperationalDataToDelete' => '<p>Keys that you want to remove from the OperationalData map.</p>', ], ], 'OpsItemParameterNamesList' => [ 'base' => NULL, 'refs' => [ 'OpsItemInvalidParameterException$ParameterNames' => NULL, 'OpsItemLimitExceededException$ResourceTypes' => NULL, ], ], 'OpsItemPriority' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Priority' => '<p>The importance of this OpsItem in relation to other OpsItems in the system.</p>', 'OpsItem$Priority' => '<p>The importance of this OpsItem in relation to other OpsItems in the system.</p>', 'OpsItemSummary$Priority' => '<p>The importance of this OpsItem in relation to other OpsItems in the system.</p>', 'UpdateOpsItemRequest$Priority' => '<p>The importance of this OpsItem in relation to other OpsItems in the system.</p>', ], ], 'OpsItemRelatedItemAlreadyExistsException' => [ 'base' => '<p>The Amazon Resource Name (ARN) is already associated with the OpsItem.</p>', 'refs' => [], ], 'OpsItemRelatedItemAssociationId' => [ 'base' => NULL, 'refs' => [ 'AssociateOpsItemRelatedItemResponse$AssociationId' => '<p>The association ID.</p>', 'DisassociateOpsItemRelatedItemRequest$AssociationId' => '<p>The ID of the association for which you want to delete an association between the OpsItem and a related item.</p>', 'OpsItemRelatedItemSummary$AssociationId' => '<p>The association ID.</p>', ], ], 'OpsItemRelatedItemAssociationNotFoundException' => [ 'base' => '<p>The association wasn\'t found using the parameters you specified in the call. Verify the information and try again.</p>', 'refs' => [], ], 'OpsItemRelatedItemAssociationResourceType' => [ 'base' => NULL, 'refs' => [ 'AssociateOpsItemRelatedItemRequest$ResourceType' => '<p>The type of resource that you want to associate with an OpsItem. OpsCenter supports the following types:</p> <p> <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. </p> <p> <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.</p>', 'OpsItemRelatedItemSummary$ResourceType' => '<p>The resource type.</p>', ], ], 'OpsItemRelatedItemAssociationResourceUri' => [ 'base' => NULL, 'refs' => [ 'AssociateOpsItemRelatedItemRequest$ResourceUri' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services resource that you want to associate with the OpsItem.</p>', 'OpsItemRelatedItemAlreadyExistsException$ResourceUri' => NULL, 'OpsItemRelatedItemSummary$ResourceUri' => '<p>The Amazon Resource Name (ARN) of the related-item resource.</p>', ], ], 'OpsItemRelatedItemAssociationType' => [ 'base' => NULL, 'refs' => [ 'AssociateOpsItemRelatedItemRequest$AssociationType' => '<p>The type of association that you want to create between an OpsItem and a resource. OpsCenter supports <code>IsParentOf</code> and <code>RelatesTo</code> association types.</p>', 'OpsItemRelatedItemSummary$AssociationType' => '<p>The association type.</p>', ], ], 'OpsItemRelatedItemSummaries' => [ 'base' => NULL, 'refs' => [ 'ListOpsItemRelatedItemsResponse$Summaries' => '<p>A list of related-item resources for the specified OpsItem.</p>', ], ], 'OpsItemRelatedItemSummary' => [ 'base' => '<p>Summary information about related-item resources for an OpsItem.</p>', 'refs' => [ 'OpsItemRelatedItemSummaries$member' => NULL, ], ], 'OpsItemRelatedItemsFilter' => [ 'base' => '<p>Describes a filter for a specific list of related-item resources. </p>', 'refs' => [ 'OpsItemRelatedItemsFilters$member' => NULL, ], ], 'OpsItemRelatedItemsFilterKey' => [ 'base' => NULL, 'refs' => [ 'OpsItemRelatedItemsFilter$Key' => '<p>The name of the filter key. Supported values include <code>ResourceUri</code>, <code>ResourceType</code>, or <code>AssociationId</code>.</p>', ], ], 'OpsItemRelatedItemsFilterOperator' => [ 'base' => NULL, 'refs' => [ 'OpsItemRelatedItemsFilter$Operator' => '<p>The operator used by the filter call. The only supported operator is <code>EQUAL</code>.</p>', ], ], 'OpsItemRelatedItemsFilterValue' => [ 'base' => NULL, 'refs' => [ 'OpsItemRelatedItemsFilterValues$member' => NULL, ], ], 'OpsItemRelatedItemsFilterValues' => [ 'base' => NULL, 'refs' => [ 'OpsItemRelatedItemsFilter$Values' => '<p>The values for the filter.</p>', ], ], 'OpsItemRelatedItemsFilters' => [ 'base' => NULL, 'refs' => [ 'ListOpsItemRelatedItemsRequest$Filters' => '<p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>', ], ], 'OpsItemRelatedItemsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListOpsItemRelatedItemsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'OpsItemSeverity' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Severity' => '<p>Specify a severity to assign to an OpsItem.</p>', 'OpsItem$Severity' => '<p>The severity of the OpsItem. Severity options range from 1 to 4.</p>', 'OpsItemSummary$Severity' => '<p>A list of OpsItems by severity.</p>', 'UpdateOpsItemRequest$Severity' => '<p>Specify a new severity for an OpsItem.</p>', ], ], 'OpsItemSource' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Source' => '<p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager.</p> <note> <p>The source name can\'t contain the following strings: <code>aws</code>, <code>amazon</code>, and <code>amzn</code>. </p> </note>', 'OpsItem$Source' => '<p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager. The impacted resource is a subset of source.</p>', 'OpsItemSummary$Source' => '<p>The impacted Amazon Web Services resource.</p>', ], ], 'OpsItemStatus' => [ 'base' => NULL, 'refs' => [ 'OpsItem$Status' => '<p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html">Editing OpsItem details</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'OpsItemSummary$Status' => '<p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>.</p>', 'UpdateOpsItemRequest$Status' => '<p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems.html#OpsCenter-working-with-OpsItems-editing-details">Editing OpsItem details</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', ], ], 'OpsItemSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeOpsItemsResponse$OpsItemSummaries' => '<p>A list of OpsItems.</p>', ], ], 'OpsItemSummary' => [ 'base' => '<p>A count of OpsItems.</p>', 'refs' => [ 'OpsItemSummaries$member' => NULL, ], ], 'OpsItemTitle' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Title' => '<p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>', 'OpsItem$Title' => '<p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>', 'OpsItemSummary$Title' => '<p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>', 'UpdateOpsItemRequest$Title' => '<p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>', ], ], 'OpsItemType' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$OpsItemType' => '<p>The type of OpsItem to create. Currently, the only valid values are <code>/aws/changerequest</code> and <code>/aws/issue</code>.</p>', 'OpsItem$OpsItemType' => '<p>The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code> and <code>/aws/issue</code>.</p>', 'OpsItemSummary$OpsItemType' => '<p>The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code> and <code>/aws/issue</code>.</p>', ], ], 'OpsMetadata' => [ 'base' => '<p>Operational metadata for an application in Application Manager.</p>', 'refs' => [ 'OpsMetadataList$member' => NULL, ], ], 'OpsMetadataAlreadyExistsException' => [ 'base' => '<p>An OpsMetadata object already exists for the selected resource.</p>', 'refs' => [], ], 'OpsMetadataArn' => [ 'base' => NULL, 'refs' => [ 'CreateOpsMetadataResult$OpsMetadataArn' => '<p>The Amazon Resource Name (ARN) of the OpsMetadata Object or blob created by the call.</p>', 'DeleteOpsMetadataRequest$OpsMetadataArn' => '<p>The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.</p>', 'GetOpsMetadataRequest$OpsMetadataArn' => '<p>The Amazon Resource Name (ARN) of an OpsMetadata Object to view.</p>', 'OpsMetadata$OpsMetadataArn' => '<p>The Amazon Resource Name (ARN) of the OpsMetadata Object or blob.</p>', 'UpdateOpsMetadataRequest$OpsMetadataArn' => '<p>The Amazon Resource Name (ARN) of the OpsMetadata Object to update.</p>', 'UpdateOpsMetadataResult$OpsMetadataArn' => '<p>The Amazon Resource Name (ARN) of the OpsMetadata Object that was updated.</p>', ], ], 'OpsMetadataFilter' => [ 'base' => '<p>A filter to limit the number of OpsMetadata objects displayed.</p>', 'refs' => [ 'OpsMetadataFilterList$member' => NULL, ], ], 'OpsMetadataFilterKey' => [ 'base' => NULL, 'refs' => [ 'OpsMetadataFilter$Key' => '<p>A filter key.</p>', ], ], 'OpsMetadataFilterList' => [ 'base' => NULL, 'refs' => [ 'ListOpsMetadataRequest$Filters' => '<p>One or more filters to limit the number of OpsMetadata objects returned by the call.</p>', ], ], 'OpsMetadataFilterValue' => [ 'base' => NULL, 'refs' => [ 'OpsMetadataFilterValueList$member' => NULL, ], ], 'OpsMetadataFilterValueList' => [ 'base' => NULL, 'refs' => [ 'OpsMetadataFilter$Values' => '<p>A filter value.</p>', ], ], 'OpsMetadataInvalidArgumentException' => [ 'base' => '<p>One of the arguments passed is invalid. </p>', 'refs' => [], ], 'OpsMetadataKeyLimitExceededException' => [ 'base' => '<p>The OpsMetadata object exceeds the maximum number of OpsMetadata keys that you can assign to an application in Application Manager.</p>', 'refs' => [], ], 'OpsMetadataLimitExceededException' => [ 'base' => '<p>Your account reached the maximum number of OpsMetadata objects allowed by Application Manager. The maximum is 200 OpsMetadata objects. Delete one or more OpsMetadata object and try again.</p>', 'refs' => [], ], 'OpsMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListOpsMetadataResult$OpsMetadataList' => '<p>Returns a list of OpsMetadata objects.</p>', ], ], 'OpsMetadataNotFoundException' => [ 'base' => '<p>The OpsMetadata object doesn\'t exist. </p>', 'refs' => [], ], 'OpsMetadataResourceId' => [ 'base' => NULL, 'refs' => [ 'CreateOpsMetadataRequest$ResourceId' => '<p>A resource ID for a new Application Manager application.</p>', 'GetOpsMetadataResult$ResourceId' => '<p>The resource ID of the Application Manager application.</p>', 'OpsMetadata$ResourceId' => '<p>The ID of the Application Manager application.</p>', ], ], 'OpsMetadataTooManyUpdatesException' => [ 'base' => '<p>The system is processing too many concurrent updates. Wait a few moments and try again.</p>', 'refs' => [], ], 'OpsResultAttribute' => [ 'base' => '<p>The OpsItem data type to return.</p>', 'refs' => [ 'OpsResultAttributeList$member' => NULL, ], ], 'OpsResultAttributeList' => [ 'base' => NULL, 'refs' => [ 'GetOpsSummaryRequest$ResultAttributes' => '<p>The OpsData data type to return.</p>', ], ], 'OutputSource' => [ 'base' => '<p>Information about the source where the association execution details are stored.</p>', 'refs' => [ 'AssociationExecutionTarget$OutputSource' => '<p>The location where the association details are saved.</p>', ], ], 'OutputSourceId' => [ 'base' => NULL, 'refs' => [ 'OutputSource$OutputSourceId' => '<p>The ID of the output source, for example the URL of an S3 bucket.</p>', ], ], 'OutputSourceType' => [ 'base' => NULL, 'refs' => [ 'OutputSource$OutputSourceType' => '<p>The type of source where the association execution details are stored, for example, Amazon S3.</p>', ], ], 'OwnerInformation' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$OwnerInformation' => '<p>User-provided value to be included in any Amazon CloudWatch Events or Amazon EventBridge events raised while running tasks for these targets in this maintenance window.</p>', 'InstancePatchState$OwnerInformation' => '<p>Placeholder information. This field will always be empty in the current release of the service.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$OwnerInformation' => '<p>User-provided value that was specified when the target was registered with the maintenance window. This was also included in any Amazon CloudWatch Events events raised during the task invocation.</p>', 'MaintenanceWindowTarget$OwnerInformation' => '<p>A user-provided value that will be included in any Amazon CloudWatch Events events that are raised while running tasks for these targets in this maintenance window.</p>', 'RegisterTargetWithMaintenanceWindowRequest$OwnerInformation' => '<p>User-provided value that will be included in any Amazon CloudWatch Events events raised while running tasks for these targets in this maintenance window.</p>', 'UpdateMaintenanceWindowTargetRequest$OwnerInformation' => '<p>User-provided value that will be included in any Amazon CloudWatch Events events raised while running tasks for these targets in this maintenance window.</p>', 'UpdateMaintenanceWindowTargetResult$OwnerInformation' => '<p>The updated owner.</p>', ], ], 'PSParameterName' => [ 'base' => NULL, 'refs' => [ 'DeleteParameterRequest$Name' => '<p>The name of the parameter to delete.</p>', 'GetParameterHistoryRequest$Name' => '<p>The name of the parameter for which you want to review history.</p>', 'GetParameterRequest$Name' => '<p>The name of the parameter you want to query.</p> <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter version, use <code>"Name": "name:version"</code>.</p>', 'GetParametersByPathRequest$Path' => '<p>The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierarchy is the parameter name except the last part of the parameter. For the API call to succeed, the last part of the parameter name can\'t be in the path. A parameter name hierarchy can have a maximum of 15 levels. Here is an example of a hierarchy: <code>/Finance/Prod/IAD/WinServ2016/license33 </code> </p>', 'LabelParameterVersionRequest$Name' => '<p>The parameter name on which you want to attach one or more labels.</p>', 'Parameter$Name' => '<p>The name of the parameter.</p>', 'ParameterHistory$Name' => '<p>The name of the parameter.</p>', 'ParameterMetadata$Name' => '<p>The parameter name.</p>', 'ParameterNameList$member' => NULL, 'PutParameterRequest$Name' => '<p>The fully qualified name of the parameter that you want to add to the system. The fully qualified name includes the complete hierarchy of the parameter path and name. For parameters in a hierarchy, you must include a leading forward slash character (/) when you create or reference a parameter. For example: <code>/Dev/DBServer/MySQL/db-string13</code> </p> <p>Naming Constraints:</p> <ul> <li> <p>Parameter names are case sensitive.</p> </li> <li> <p>A parameter name must be unique within an Amazon Web Services Region</p> </li> <li> <p>A parameter name can\'t be prefixed with "<code>aws</code>" or "<code>ssm</code>" (case-insensitive).</p> </li> <li> <p>Parameter names can include only the following symbols and letters: <code>a-zA-Z0-9_.-</code> </p> <p>In addition, the slash character ( / ) is used to delineate hierarchies in parameter names. For example: <code>/Dev/Production/East/Project-ABC/MyParameter</code> </p> </li> <li> <p>A parameter name can\'t include spaces.</p> </li> <li> <p>Parameter hierarchies are limited to a maximum depth of fifteen levels.</p> </li> </ul> <p>For additional information about valid values for parameter names, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html">Creating Systems Manager parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <note> <p>The maximum length constraint listed below includes capacity for additional system attributes that aren\'t part of the name. The maximum length for a parameter name, including the full length of the parameter ARN, is 1011 characters. For example, the length of the following parameter name is 65 characters, not 20 characters:</p> <p> <code>arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName</code> </p> </note>', 'UnlabelParameterVersionRequest$Name' => '<p>The name of the parameter from which you want to delete one or more labels.</p>', ], ], 'PSParameterSelector' => [ 'base' => NULL, 'refs' => [ 'Parameter$Selector' => '<p>Either the version number or the label used to retrieve the parameter value. Specify selectors by using one of the following formats:</p> <p>parameter_name:version</p> <p>parameter_name:label</p>', ], ], 'PSParameterValue' => [ 'base' => NULL, 'refs' => [ 'Parameter$Value' => '<p>The parameter value.</p> <note> <p>If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between commas in the <code>Value</code> field.</p> </note>', 'ParameterHistory$Value' => '<p>The parameter value.</p>', 'PutParameterRequest$Value' => '<p>The parameter value that you want to add to the system. Standard parameters have a value limit of 4 KB. Advanced parameters have a value limit of 8 KB.</p> <note> <p>Parameters can\'t be referenced or nested in the values of other parameters. You can\'t include <code>{{}}</code> or <code>{{ssm:<i>parameter-name</i>}}</code> in a parameter value.</p> </note>', ], ], 'PSParameterVersion' => [ 'base' => NULL, 'refs' => [ 'LabelParameterVersionRequest$ParameterVersion' => '<p>The specific version of the parameter on which you want to attach one or more labels. If no version is specified, the system attaches the label to the latest version.</p>', 'LabelParameterVersionResult$ParameterVersion' => '<p>The version of the parameter that has been labeled.</p>', 'Parameter$Version' => '<p>The parameter version.</p>', 'ParameterHistory$Version' => '<p>The parameter version.</p>', 'ParameterMetadata$Version' => '<p>The parameter version.</p>', 'PutParameterResult$Version' => '<p>The new version number of a parameter. If you edit a parameter value, Parameter Store automatically creates a new version and assigns this new version a unique ID. You can reference a parameter version ID in API operations or in Systems Manager documents (SSM documents). By default, if you don\'t specify a specific version, the system returns the latest parameter value when a parameter is called.</p>', 'UnlabelParameterVersionRequest$ParameterVersion' => '<p>The specific version of the parameter which you want to delete one or more labels from. If it isn\'t present, the call will fail.</p>', ], ], 'Parameter' => [ 'base' => '<p>An Amazon Web Services Systems Manager parameter in Parameter Store.</p>', 'refs' => [ 'GetParameterResult$Parameter' => '<p>Information about a parameter.</p>', 'ParameterList$member' => NULL, ], ], 'ParameterAlreadyExists' => [ 'base' => '<p>The parameter already exists. You can\'t create duplicate parameters.</p>', 'refs' => [], ], 'ParameterDataType' => [ 'base' => NULL, 'refs' => [ 'Parameter$DataType' => '<p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The default is <code>text</code>.</p>', 'ParameterHistory$DataType' => '<p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The default is <code>text</code>.</p>', 'ParameterMetadata$DataType' => '<p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The default is <code>text</code>.</p>', 'PutParameterRequest$DataType' => '<p>The data type for a <code>String</code> parameter. Supported data types include plain text and Amazon Machine Image (AMI) IDs.</p> <p> <b>The following data type values are supported.</b> </p> <ul> <li> <p> <code>text</code> </p> </li> <li> <p> <code>aws:ec2:image</code> </p> </li> <li> <p> <code>aws:ssm:integration</code> </p> </li> </ul> <p>When you create a <code>String</code> parameter and specify <code>aws:ec2:image</code>, Amazon Web Services Systems Manager validates the parameter value is in the required format, such as <code>ami-12345abcdeEXAMPLE</code>, and that the specified AMI is available in your Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html">Native parameter support for Amazon Machine Image (AMI) IDs</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', ], ], 'ParameterDescription' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$Description' => '<p>Information about the parameter.</p>', 'ParameterMetadata$Description' => '<p>Description of the parameter actions.</p>', 'PutParameterRequest$Description' => '<p>Information about the parameter that you want to add to the system. Optional but recommended.</p> <important> <p>Don\'t enter personally identifiable information in this field.</p> </important>', ], ], 'ParameterHistory' => [ 'base' => '<p>Information about parameter usage.</p>', 'refs' => [ 'ParameterHistoryList$member' => NULL, ], ], 'ParameterHistoryList' => [ 'base' => NULL, 'refs' => [ 'GetParameterHistoryResult$Parameters' => '<p>A list of parameters returned by the request.</p>', ], ], 'ParameterInlinePolicy' => [ 'base' => '<p>One or more policies assigned to a parameter.</p>', 'refs' => [ 'ParameterPolicyList$member' => NULL, ], ], 'ParameterKeyId' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$KeyId' => '<p>The ID of the query key used for this parameter.</p>', 'ParameterMetadata$KeyId' => '<p>The ID of the query key used for this parameter.</p>', 'PutParameterRequest$KeyId' => '<p>The Key Management Service (KMS) ID that you want to use to encrypt a parameter. Either the default KMS key automatically assigned to your Amazon Web Services account or a custom key. Required for parameters that use the <code>SecureString</code> data type.</p> <p>If you don\'t specify a key ID, the system uses the default key associated with your Amazon Web Services account.</p> <ul> <li> <p>To use your default KMS key, choose the <code>SecureString</code> data type, and do <i>not</i> specify the <code>Key ID</code> when you create the parameter. The system automatically populates <code>Key ID</code> with your default KMS key.</p> </li> <li> <p>To use a custom KMS key, choose the <code>SecureString</code> data type with the <code>Key ID</code> parameter.</p> </li> </ul>', ], ], 'ParameterLabel' => [ 'base' => NULL, 'refs' => [ 'ParameterLabelList$member' => NULL, ], ], 'ParameterLabelList' => [ 'base' => NULL, 'refs' => [ 'LabelParameterVersionRequest$Labels' => '<p>One or more labels to attach to the specified parameter version.</p>', 'LabelParameterVersionResult$InvalidLabels' => '<p>The label doesn\'t meet the requirements. For information about parameter label requirements, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'ParameterHistory$Labels' => '<p>Labels assigned to the parameter version.</p>', 'UnlabelParameterVersionRequest$Labels' => '<p>One or more labels to delete from the specified parameter version.</p>', 'UnlabelParameterVersionResult$RemovedLabels' => '<p>A list of all labels deleted from the parameter.</p>', 'UnlabelParameterVersionResult$InvalidLabels' => '<p>The labels that aren\'t attached to the given parameter version.</p>', ], ], 'ParameterLimitExceeded' => [ 'base' => '<p>You have exceeded the number of parameters for this Amazon Web Services account. Delete one or more parameters and try again.</p>', 'refs' => [], ], 'ParameterList' => [ 'base' => NULL, 'refs' => [ 'GetParametersByPathResult$Parameters' => '<p>A list of parameters found in the specified hierarchy.</p>', 'GetParametersResult$Parameters' => '<p>A list of details for a parameter.</p>', ], ], 'ParameterMaxVersionLimitExceeded' => [ 'base' => '<p>Parameter Store retains the 100 most recently created versions of a parameter. After this number of versions has been created, Parameter Store deletes the oldest version when a new one is created. However, if the oldest version has a <i>label</i> attached to it, Parameter Store won\'t delete the version and instead presents this error message:</p> <p> <code>An error occurred (ParameterMaxVersionLimitExceeded) when calling the PutParameter operation: You attempted to create a new version of <i>parameter-name</i> by calling the PutParameter API with the overwrite flag. Version <i>version-number</i>, the oldest version, can\'t be deleted because it has a label associated with it. Move the label to another version of the parameter, and try again.</code> </p> <p>This safeguard is to prevent parameter versions with mission critical labels assigned to them from being deleted. To continue creating new parameters, first move the label from the oldest version of the parameter to a newer one for use in your operations. For information about moving parameter labels, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-console-move">Move a parameter label (console)</a> or <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-cli-move">Move a parameter label (CLI)</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>', 'refs' => [], ], 'ParameterMetadata' => [ 'base' => '<p>Metadata includes information like the ARN of the last user and the date/time the parameter was last used.</p>', 'refs' => [ 'ParameterMetadataList$member' => NULL, ], ], 'ParameterMetadataList' => [ 'base' => NULL, 'refs' => [ 'DescribeParametersResult$Parameters' => '<p>Parameters returned by the request.</p>', ], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'Parameters$key' => NULL, ], ], 'ParameterNameList' => [ 'base' => NULL, 'refs' => [ 'DeleteParametersRequest$Names' => '<p>The names of the parameters to delete. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.</p>', 'DeleteParametersResult$DeletedParameters' => '<p>The names of the deleted parameters.</p>', 'DeleteParametersResult$InvalidParameters' => '<p>The names of parameters that weren\'t deleted because the parameters aren\'t valid.</p>', 'GetParametersRequest$Names' => '<p>Names of the parameters for which you want to query information.</p> <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter version, use <code>"Name": "name:version"</code>.</p>', 'GetParametersResult$InvalidParameters' => '<p>A list of parameters that aren\'t formatted correctly or don\'t run during an execution.</p>', ], ], 'ParameterNotFound' => [ 'base' => '<p>The parameter couldn\'t be found. Verify the name and try again.</p>', 'refs' => [], ], 'ParameterPatternMismatchException' => [ 'base' => '<p>The parameter name isn\'t valid.</p>', 'refs' => [], ], 'ParameterPolicies' => [ 'base' => NULL, 'refs' => [ 'PutParameterRequest$Policies' => '<p>One or more policies to apply to a parameter. This operation takes a JSON array. Parameter Store, a capability of Amazon Web Services Systems Manager supports the following policy types:</p> <p>Expiration: This policy deletes the parameter after it expires. When you create the policy, you specify the expiration date. You can update the expiration date and time by updating the policy. Updating the <i>parameter</i> doesn\'t affect the expiration date and time. When the expiration time is reached, Parameter Store deletes the parameter.</p> <p>ExpirationNotification: This policy initiates an event in Amazon CloudWatch Events that notifies you about the expiration. By using this policy, you can receive notification before or after the expiration time is reached, in units of days or hours.</p> <p>NoChangeNotification: This policy initiates a CloudWatch Events event if a parameter hasn\'t been modified for a specified period of time. This policy type is useful when, for example, a secret needs to be changed within a period of time, but it hasn\'t been changed.</p> <p>All existing policies are preserved until you send new policies or an empty policy. For more information about parameter policies, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter policies</a>. </p>', ], ], 'ParameterPolicyList' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$Policies' => '<p>Information about the policies assigned to a parameter.</p> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter policies</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'ParameterMetadata$Policies' => '<p>A list of policies associated with a parameter.</p>', ], ], 'ParameterStringFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'refs' => [ 'ParameterStringFilterList$member' => NULL, ], ], 'ParameterStringFilterKey' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilter$Key' => '<p>The name of the filter.</p> <p>The <code>ParameterStringFilter</code> object is used by the <a>DescribeParameters</a> and <a>GetParametersByPath</a> API operations. However, not all of the pattern values listed for <code>Key</code> can be used with both operations.</p> <p>For <code>DescribeParameters</code>, all of the listed patterns are valid except <code>Label</code>.</p> <p>For <code>GetParametersByPath</code>, the following patterns listed for <code>Key</code> aren\'t valid: <code>tag</code>, <code>DataType</code>, <code>Name</code>, <code>Path</code>, and <code>Tier</code>.</p> <p>For examples of Amazon Web Services CLI commands demonstrating valid parameter filter constructions, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-search.html">Searching for Systems Manager parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', ], ], 'ParameterStringFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeParametersRequest$ParameterFilters' => '<p>Filters to limit the request results.</p>', 'GetParametersByPathRequest$ParameterFilters' => '<p>Filters to limit the request results.</p> <note> <p>The following <code>Key</code> values are supported for <code>GetParametersByPath</code>: <code>Type</code>, <code>KeyId</code>, and <code>Label</code>.</p> <p>The following <code>Key</code> values aren\'t supported for <code>GetParametersByPath</code>: <code>tag</code>, <code>DataType</code>, <code>Name</code>, <code>Path</code>, and <code>Tier</code>.</p> </note>', ], ], 'ParameterStringFilterValue' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilterValueList$member' => NULL, ], ], 'ParameterStringFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilter$Values' => '<p>The value you want to search for.</p>', ], ], 'ParameterStringQueryOption' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilter$Option' => '<p>For all filters used with <a>DescribeParameters</a>, valid options include <code>Equals</code> and <code>BeginsWith</code>. The <code>Name</code> filter additionally supports the <code>Contains</code> option. (Exception: For filters using the key <code>Path</code>, valid options include <code>Recursive</code> and <code>OneLevel</code>.)</p> <p>For filters used with <a>GetParametersByPath</a>, valid options include <code>Equals</code> and <code>BeginsWith</code>. (Exception: For filters using <code>Label</code> as the Key name, the only valid option is <code>Equals</code>.)</p>', ], ], 'ParameterTier' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$Tier' => '<p>The parameter tier.</p>', 'ParameterMetadata$Tier' => '<p>The parameter tier.</p>', 'PutParameterRequest$Tier' => '<p>The parameter tier to assign to a parameter.</p> <p>Parameter Store offers a standard tier and an advanced tier for parameters. Standard parameters have a content size limit of 4 KB and can\'t be configured to use parameter policies. You can create a maximum of 10,000 standard parameters for each Region in an Amazon Web Services account. Standard parameters are offered at no additional cost. </p> <p>Advanced parameters have a content size limit of 8 KB and can be configured to use parameter policies. You can create a maximum of 100,000 advanced parameters for each Region in an Amazon Web Services account. Advanced parameters incur a charge. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html">Standard and advanced parameter tiers</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <p>You can change a standard parameter to an advanced parameter any time. But you can\'t revert an advanced parameter to a standard parameter. Reverting an advanced parameter to a standard parameter would result in data loss because the system would truncate the size of the parameter from 8 KB to 4 KB. Reverting would also remove any policies attached to the parameter. Lastly, advanced parameters use a different form of encryption than standard parameters. </p> <p>If you no longer need an advanced parameter, or if you no longer want to incur charges for an advanced parameter, you must delete it and recreate it as a new standard parameter. </p> <p> <b>Using the Default Tier Configuration</b> </p> <p>In <code>PutParameter</code> requests, you can specify the tier to create the parameter in. Whenever you specify a tier in the request, Parameter Store creates or updates the parameter according to that request. However, if you don\'t specify a tier in a request, Parameter Store assigns the tier based on the current Parameter Store default tier configuration.</p> <p>The default tier when you begin using Parameter Store is the standard-parameter tier. If you use the advanced-parameter tier, you can specify one of the following as the default:</p> <ul> <li> <p> <b>Advanced</b>: With this option, Parameter Store evaluates all requests as advanced parameters. </p> </li> <li> <p> <b>Intelligent-Tiering</b>: With this option, Parameter Store evaluates each request to determine if the parameter is standard or advanced. </p> <p>If the request doesn\'t include any options that require an advanced parameter, the parameter is created in the standard-parameter tier. If one or more options requiring an advanced parameter are included in the request, Parameter Store create a parameter in the advanced-parameter tier.</p> <p>This approach helps control your parameter-related costs by always creating standard parameters unless an advanced parameter is necessary. </p> </li> </ul> <p>Options that require an advanced parameter include the following:</p> <ul> <li> <p>The content size of the parameter is more than 4 KB.</p> </li> <li> <p>The parameter uses a parameter policy.</p> </li> <li> <p>More than 10,000 parameters already exist in your Amazon Web Services account in the current Amazon Web Services Region.</p> </li> </ul> <p>For more information about configuring the default tier option, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ps-default-tier.html">Specifying a default parameter tier</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'PutParameterResult$Tier' => '<p>The tier assigned to the parameter.</p>', ], ], 'ParameterType' => [ 'base' => NULL, 'refs' => [ 'Parameter$Type' => '<p>The type of parameter. Valid values include the following: <code>String</code>, <code>StringList</code>, and <code>SecureString</code>.</p> <note> <p>If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between commas in the <code>Value</code> field.</p> </note>', 'ParameterHistory$Type' => '<p>The type of parameter used.</p>', 'ParameterMetadata$Type' => '<p>The type of parameter. Valid parameter types include the following: <code>String</code>, <code>StringList</code>, and <code>SecureString</code>.</p>', 'PutParameterRequest$Type' => '<p>The type of parameter that you want to add to the system.</p> <note> <p> <code>SecureString</code> isn\'t currently supported for CloudFormation templates.</p> </note> <p>Items in a <code>StringList</code> must be separated by a comma (,). You can\'t use other punctuation or special character to escape items in the list. If you have a parameter value that requires a comma, then use the <code>String</code> data type.</p> <important> <p>Specifying a parameter type isn\'t required when updating a parameter. You must specify a parameter type when creating a parameter.</p> </important>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ParameterValueList$member' => NULL, 'TargetParameterList$member' => NULL, ], ], 'ParameterValueList' => [ 'base' => NULL, 'refs' => [ 'Parameters$value' => NULL, ], ], 'ParameterVersionLabelLimitExceeded' => [ 'base' => '<p>A parameter version can have a maximum of ten labels.</p>', 'refs' => [], ], 'ParameterVersionNotFound' => [ 'base' => '<p>The specified parameter version wasn\'t found. Verify the parameter name and version, and try again.</p>', 'refs' => [], ], 'Parameters' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$Parameters' => '<p>A description of the parameters for a document. </p>', 'AssociationVersionInfo$Parameters' => '<p>Parameters specified when the association version was created.</p>', 'Command$Parameters' => '<p>The parameter values to be inserted in the document when running the command.</p>', 'CreateAssociationBatchRequestEntry$Parameters' => '<p>A description of the parameters for a document. </p>', 'CreateAssociationRequest$Parameters' => '<p>The parameters for the runtime configuration of the document.</p>', 'MaintenanceWindowRunCommandParameters$Parameters' => '<p>The parameters for the <code>RUN_COMMAND</code> task execution.</p>', 'SendCommandRequest$Parameters' => '<p>The required and optional parameters specified in the document being run.</p>', 'UpdateAssociationRequest$Parameters' => '<p>The parameters you want to update for the association. If you create a parameter using Parameter Store, a capability of Amazon Web Services Systems Manager, you can reference the parameter using <code>{{ssm:parameter-name}}</code>.</p>', ], ], 'ParametersFilter' => [ 'base' => '<p>This data type is deprecated. Instead, use <a>ParameterStringFilter</a>.</p>', 'refs' => [ 'ParametersFilterList$member' => NULL, ], ], 'ParametersFilterKey' => [ 'base' => NULL, 'refs' => [ 'ParametersFilter$Key' => '<p>The name of the filter.</p>', ], ], 'ParametersFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeParametersRequest$Filters' => '<p>This data type is deprecated. Instead, use <code>ParameterFilters</code>.</p>', ], ], 'ParametersFilterValue' => [ 'base' => NULL, 'refs' => [ 'ParametersFilterValueList$member' => NULL, ], ], 'ParametersFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ParametersFilter$Values' => '<p>The filter values.</p>', ], ], 'Patch' => [ 'base' => '<p>Represents metadata about a patch.</p>', 'refs' => [ 'EffectivePatch$Patch' => '<p>Provides metadata for a patch, including information such as the KB ID, severity, classification and a URL for where more information can be obtained about the patch.</p>', 'PatchList$member' => NULL, ], ], 'PatchAction' => [ 'base' => NULL, 'refs' => [ 'BaselineOverride$RejectedPatchesAction' => '<p>The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>', 'CreatePatchBaselineRequest$RejectedPatchesAction' => '<p>The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.</p> <ul> <li> <p> <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as <code>InstalledOther</code>. This is the default action if no option is specified.</p> </li> <li> <p> <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include them as dependencies, aren\'t installed under any circumstances. If a package was installed before it was added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its status is reported as <code>InstalledRejected</code>.</p> </li> </ul>', 'GetPatchBaselineResult$RejectedPatchesAction' => '<p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>', 'UpdatePatchBaselineRequest$RejectedPatchesAction' => '<p>The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.</p> <ul> <li> <p> <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as <code>InstalledOther</code>. This is the default action if no option is specified.</p> </li> <li> <p> <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include them as dependencies, aren\'t installed under any circumstances. If a package was installed before it was added to the <code>Rejected</code> patches list, it is considered non-compliant with the patch baseline, and its status is reported as <code>InstalledRejected</code>.</p> </li> </ul>', 'UpdatePatchBaselineResult$RejectedPatchesAction' => '<p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>', ], ], 'PatchAdvisoryId' => [ 'base' => NULL, 'refs' => [ 'PatchAdvisoryIdList$member' => NULL, ], ], 'PatchAdvisoryIdList' => [ 'base' => NULL, 'refs' => [ 'Patch$AdvisoryIds' => '<p>The Advisory ID of the patch. For example, <code>RHSA-2020:3779</code>. Applies to Linux-based managed nodes only.</p>', ], ], 'PatchArch' => [ 'base' => NULL, 'refs' => [ 'Patch$Arch' => '<p>The architecture of the patch. For example, in <code>example-pkg-0.710.10-2.7.abcd.x86_64</code>, the architecture is indicated by <code>x86_64</code>. Applies to Linux-based managed nodes only.</p>', ], ], 'PatchBaselineIdentity' => [ 'base' => '<p>Defines the basic information about a patch baseline.</p>', 'refs' => [ 'PatchBaselineIdentityList$member' => NULL, 'PatchGroupPatchBaselineMapping$BaselineIdentity' => '<p>The patch baseline the patch group is registered with.</p>', ], ], 'PatchBaselineIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribePatchBaselinesResult$BaselineIdentities' => '<p>An array of <code>PatchBaselineIdentity</code> elements.</p>', ], ], 'PatchBaselineMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailablePatchesRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', 'DescribeEffectivePatchesForPatchBaselineRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', 'DescribePatchBaselinesRequest$MaxResults' => '<p>The maximum number of patch baselines to return (per page).</p>', 'DescribePatchGroupsRequest$MaxResults' => '<p>The maximum number of patch groups to return (per page).</p>', ], ], 'PatchBugzillaId' => [ 'base' => NULL, 'refs' => [ 'PatchBugzillaIdList$member' => NULL, ], ], 'PatchBugzillaIdList' => [ 'base' => NULL, 'refs' => [ 'Patch$BugzillaIds' => '<p>The Bugzilla ID of the patch. For example, <code>1600646</code>. Applies to Linux-based managed nodes only.</p>', ], ], 'PatchCVEId' => [ 'base' => NULL, 'refs' => [ 'PatchCVEIdList$member' => NULL, ], ], 'PatchCVEIdList' => [ 'base' => NULL, 'refs' => [ 'Patch$CVEIds' => '<p>The Common Vulnerabilities and Exposures (CVE) ID of the patch. For example, <code>CVE-2011-3192</code>. Applies to Linux-based managed nodes only.</p>', ], ], 'PatchCVEIds' => [ 'base' => NULL, 'refs' => [ 'PatchComplianceData$CVEIds' => '<p>The IDs of one or more Common Vulnerabilities and Exposure (CVE) issues that are resolved by the patch.</p>', ], ], 'PatchClassification' => [ 'base' => NULL, 'refs' => [ 'Patch$Classification' => '<p>The classification of the patch. For example, <code>SecurityUpdates</code>, <code>Updates</code>, or <code>CriticalUpdates</code>.</p>', 'PatchComplianceData$Classification' => '<p>The classification of the patch, such as <code>SecurityUpdates</code>, <code>Updates</code>, and <code>CriticalUpdates</code>.</p>', ], ], 'PatchComplianceData' => [ 'base' => '<p>Information about the state of a patch on a particular managed node as it relates to the patch baseline used to patch the node.</p>', 'refs' => [ 'PatchComplianceDataList$member' => NULL, ], ], 'PatchComplianceDataList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchesResult$Patches' => '<p>Each entry in the array is a structure containing:</p> <ul> <li> <p>Title (string)</p> </li> <li> <p>KBId (string)</p> </li> <li> <p>Classification (string)</p> </li> <li> <p>Severity (string)</p> </li> <li> <p>State (string, such as "INSTALLED" or "FAILED")</p> </li> <li> <p>InstalledTime (DateTime)</p> </li> <li> <p>InstalledBy (string)</p> </li> </ul>', ], ], 'PatchComplianceDataState' => [ 'base' => NULL, 'refs' => [ 'PatchComplianceData$State' => '<p>The state of the patch on the managed node, such as INSTALLED or FAILED.</p> <p>For descriptions of each patch state, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-compliance-about.html#sysman-compliance-monitor-patch">About patch compliance</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', ], ], 'PatchComplianceLevel' => [ 'base' => NULL, 'refs' => [ 'BaselineOverride$ApprovedPatchesComplianceLevel' => '<p>Defines the compliance level for approved patches. When an approved patch is reported as missing, this value describes the severity of the compliance violation.</p>', 'CreatePatchBaselineRequest$ApprovedPatchesComplianceLevel' => '<p>Defines the compliance level for approved patches. When an approved patch is reported as missing, this value describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code>.</p>', 'GetPatchBaselineResult$ApprovedPatchesComplianceLevel' => '<p>Returns the specified compliance severity level for approved patches in the patch baseline.</p>', 'PatchRule$ComplianceLevel' => '<p>A compliance severity level for all approved patches in a patch baseline.</p>', 'PatchStatus$ComplianceLevel' => '<p>The compliance severity level for a patch.</p>', 'UpdatePatchBaselineRequest$ApprovedPatchesComplianceLevel' => '<p>Assigns a new compliance severity level to an existing patch baseline.</p>', 'UpdatePatchBaselineResult$ApprovedPatchesComplianceLevel' => '<p>The compliance severity level assigned to the patch baseline after the update completed.</p>', ], ], 'PatchComplianceMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesForPatchGroupRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', 'DescribeInstancePatchStatesRequest$MaxResults' => '<p>The maximum number of managed nodes to return (per page).</p>', 'DescribeInstancePatchesRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', ], ], 'PatchContentUrl' => [ 'base' => NULL, 'refs' => [ 'Patch$ContentUrl' => '<p>The URL where more information can be obtained about the patch.</p>', ], ], 'PatchCriticalNonCompliantCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$CriticalNonCompliantCount' => '<p>The number of managed nodes where patches that are specified as <code>Critical</code> for compliance reporting in the patch baseline aren\'t installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>', ], ], 'PatchDeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'PatchStatus$DeploymentStatus' => '<p>The approval status of a patch.</p>', ], ], 'PatchDescription' => [ 'base' => NULL, 'refs' => [ 'Patch$Description' => '<p>The description of the patch.</p>', ], ], 'PatchEpoch' => [ 'base' => NULL, 'refs' => [ 'Patch$Epoch' => '<p>The epoch of the patch. For example in <code>pkg-example-EE-20180914-2.2.amzn1.noarch</code>, the epoch value is <code>20180914-2</code>. Applies to Linux-based managed nodes only.</p>', ], ], 'PatchFailedCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$FailedCount' => '<p>The number of patches from the patch baseline that were attempted to be installed during the last patching operation, but failed to install.</p>', ], ], 'PatchFilter' => [ 'base' => '<p> Defines which patches should be included in a patch baseline.</p> <p>A patch filter consists of a key and a set of values. The filter key is a patch property. For example, the available filter keys for <code>WINDOWS</code> are <code>PATCH_SET</code>, <code>PRODUCT</code>, <code>PRODUCT_FAMILY</code>, <code>CLASSIFICATION</code>, and <code>MSRC_SEVERITY</code>.</p> <p>The filter values define a matching criterion for the patch property indicated by the key. For example, if the filter key is <code>PRODUCT</code> and the filter values are <code>["Office 2013", "Office 2016"]</code>, then the filter accepts all patches where product name is either "Office 2013" or "Office 2016". The filter values can be exact values for the patch property given as a key, or a wildcard (*), which matches all values.</p> <p>You can view lists of valid values for the patch properties by running the <code>DescribePatchProperties</code> command. For information about which patch properties can be used with each major operating system, see <a>DescribePatchProperties</a>.</p>', 'refs' => [ 'PatchFilterList$member' => NULL, ], ], 'PatchFilterGroup' => [ 'base' => '<p>A set of patch filters, typically used for approval rules.</p>', 'refs' => [ 'BaselineOverride$GlobalFilters' => NULL, 'CreatePatchBaselineRequest$GlobalFilters' => '<p>A set of global filters used to include patches in the baseline.</p>', 'GetPatchBaselineResult$GlobalFilters' => '<p>A set of global filters used to exclude patches from the baseline.</p>', 'PatchRule$PatchFilterGroup' => '<p>The patch filter group that defines the criteria for the rule.</p>', 'UpdatePatchBaselineRequest$GlobalFilters' => '<p>A set of global filters used to include patches in the baseline.</p>', 'UpdatePatchBaselineResult$GlobalFilters' => '<p>A set of global filters used to exclude patches from the baseline.</p>', ], ], 'PatchFilterKey' => [ 'base' => NULL, 'refs' => [ 'PatchFilter$Key' => '<p>The key for the filter.</p> <p>Run the <a>DescribePatchProperties</a> command to view lists of valid keys for each operating system type.</p>', ], ], 'PatchFilterList' => [ 'base' => NULL, 'refs' => [ 'PatchFilterGroup$PatchFilters' => '<p>The set of patch filters that make up the group.</p>', ], ], 'PatchFilterValue' => [ 'base' => NULL, 'refs' => [ 'PatchFilterValueList$member' => NULL, ], ], 'PatchFilterValueList' => [ 'base' => NULL, 'refs' => [ 'PatchFilter$Values' => '<p>The value for the filter key.</p> <p>Run the <a>DescribePatchProperties</a> command to view lists of valid values for each key based on operating system type.</p>', ], ], 'PatchGroup' => [ 'base' => NULL, 'refs' => [ 'DeregisterPatchBaselineForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group that should be deregistered from the patch baseline.</p>', 'DeregisterPatchBaselineForPatchGroupResult$PatchGroup' => '<p>The name of the patch group deregistered from the patch baseline.</p>', 'DescribeInstancePatchStatesForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group for which the patch state information should be retrieved.</p>', 'DescribePatchGroupStateRequest$PatchGroup' => '<p>The name of the patch group whose patch snapshot should be retrieved.</p>', 'GetPatchBaselineForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group whose patch baseline should be retrieved.</p>', 'GetPatchBaselineForPatchGroupResult$PatchGroup' => '<p>The name of the patch group.</p>', 'InstancePatchState$PatchGroup' => '<p>The name of the patch group the managed node belongs to.</p>', 'PatchGroupList$member' => NULL, 'PatchGroupPatchBaselineMapping$PatchGroup' => '<p>The name of the patch group registered with the patch baseline.</p>', 'RegisterPatchBaselineForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group to be registered with the patch baseline.</p>', 'RegisterPatchBaselineForPatchGroupResult$PatchGroup' => '<p>The name of the patch group registered with the patch baseline.</p>', ], ], 'PatchGroupList' => [ 'base' => NULL, 'refs' => [ 'GetPatchBaselineResult$PatchGroups' => '<p>Patch groups included in the patch baseline.</p>', ], ], 'PatchGroupPatchBaselineMapping' => [ 'base' => '<p>The mapping between a patch group and the patch baseline the patch group is registered with.</p>', 'refs' => [ 'PatchGroupPatchBaselineMappingList$member' => NULL, ], ], 'PatchGroupPatchBaselineMappingList' => [ 'base' => NULL, 'refs' => [ 'DescribePatchGroupsResult$Mappings' => '<p>Each entry in the array contains:</p> <ul> <li> <p> <code>PatchGroup</code>: string (between 1 and 256 characters. Regex: <code>^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$)</code> </p> </li> <li> <p> <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.</p> </li> </ul>', ], ], 'PatchId' => [ 'base' => NULL, 'refs' => [ 'Patch$Id' => '<p>The ID of the patch. Applies to Windows patches only.</p> <note> <p>This ID isn\'t the same as the Microsoft Knowledge Base ID.</p> </note>', 'PatchIdList$member' => NULL, ], ], 'PatchIdList' => [ 'base' => NULL, 'refs' => [ 'BaselineOverride$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p> <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'BaselineOverride$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p> <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'CreatePatchBaselineRequest$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p> <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'CreatePatchBaselineRequest$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p> <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'GetPatchBaselineResult$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p>', 'GetPatchBaselineResult$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p>', 'UpdatePatchBaselineRequest$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p> <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'UpdatePatchBaselineRequest$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p> <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'UpdatePatchBaselineResult$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p>', 'UpdatePatchBaselineResult$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p>', ], ], 'PatchInstalledCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstalledCount' => '<p>The number of patches from the patch baseline that are installed on the managed node.</p>', ], ], 'PatchInstalledOtherCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstalledOtherCount' => '<p>The number of patches not specified in the patch baseline that are installed on the managed node.</p>', ], ], 'PatchInstalledPendingRebootCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstalledPendingRebootCount' => '<p>The number of patches installed by Patch Manager since the last time the managed node was rebooted.</p>', ], ], 'PatchInstalledRejectedCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstalledRejectedCount' => '<p>The number of patches installed on a managed node that are specified in a <code>RejectedPatches</code> list. Patches with a status of <code>InstalledRejected</code> were typically installed before they were added to a <code>RejectedPatches</code> list.</p> <note> <p>If <code>ALLOW_AS_DEPENDENCY</code> is the specified option for <code>RejectedPatchesAction</code>, the value of <code>InstalledRejectedCount</code> will always be <code>0</code> (zero).</p> </note>', ], ], 'PatchKbNumber' => [ 'base' => NULL, 'refs' => [ 'Patch$KbNumber' => '<p>The Microsoft Knowledge Base ID of the patch. Applies to Windows patches only.</p>', 'PatchComplianceData$KBId' => '<p>The operating system-specific ID of the patch.</p>', ], ], 'PatchLanguage' => [ 'base' => NULL, 'refs' => [ 'Patch$Language' => '<p>The language of the patch if it\'s language-specific.</p>', ], ], 'PatchList' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailablePatchesResult$Patches' => '<p>An array of patches. Each entry in the array is a patch structure.</p>', ], ], 'PatchMissingCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$MissingCount' => '<p>The number of patches from the patch baseline that are applicable for the managed node but aren\'t currently installed.</p>', ], ], 'PatchMsrcNumber' => [ 'base' => NULL, 'refs' => [ 'Patch$MsrcNumber' => '<p>The ID of the Microsoft Security Response Center (MSRC) bulletin the patch is related to. For example, <code>MS14-045</code>. Applies to Windows patches only.</p>', ], ], 'PatchMsrcSeverity' => [ 'base' => NULL, 'refs' => [ 'Patch$MsrcSeverity' => '<p>The severity of the patch, such as <code>Critical</code>, <code>Important</code>, or <code>Moderate</code>. Applies to Windows patches only.</p>', ], ], 'PatchName' => [ 'base' => NULL, 'refs' => [ 'Patch$Name' => '<p>The name of the patch. Applies to Linux-based managed nodes only.</p>', ], ], 'PatchNotApplicableCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$NotApplicableCount' => '<p>The number of patches from the patch baseline that aren\'t applicable for the managed node and therefore aren\'t installed on the node. This number may be truncated if the list of patch names is very large. The number of patches beyond this limit are reported in <code>UnreportedNotApplicableCount</code>.</p>', ], ], 'PatchOperationType' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$Operation' => '<p>The type of patching operation that was performed: or </p> <ul> <li> <p> <code>SCAN</code> assesses the patch compliance state.</p> </li> <li> <p> <code>INSTALL</code> installs missing patches.</p> </li> </ul>', ], ], 'PatchOrchestratorFilter' => [ 'base' => '<p>Defines a filter used in Patch Manager APIs. Supported filter keys depend on the API operation that includes the filter. Patch Manager API operations that use <code>PatchOrchestratorFilter</code> include the following:</p> <ul> <li> <p> <a>DescribeAvailablePatches</a> </p> </li> <li> <p> <a>DescribeInstancePatches</a> </p> </li> <li> <p> <a>DescribePatchBaselines</a> </p> </li> <li> <p> <a>DescribePatchGroups</a> </p> </li> </ul>', 'refs' => [ 'PatchOrchestratorFilterList$member' => NULL, ], ], 'PatchOrchestratorFilterKey' => [ 'base' => NULL, 'refs' => [ 'PatchOrchestratorFilter$Key' => '<p>The key for the filter.</p>', ], ], 'PatchOrchestratorFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailablePatchesRequest$Filters' => '<p>Each element in the array is a structure containing a key-value pair.</p> <p> <b>Windows Server</b> </p> <p>Supported keys for Windows Server managed node patches include the following:</p> <ul> <li> <p> <b> <code>PATCH_SET</code> </b> </p> <p>Sample values: <code>OS</code> | <code>APPLICATION</code> </p> </li> <li> <p> <b> <code>PRODUCT</code> </b> </p> <p>Sample values: <code>WindowsServer2012</code> | <code>Office 2010</code> | <code>MicrosoftDefenderAntivirus</code> </p> </li> <li> <p> <b> <code>PRODUCT_FAMILY</code> </b> </p> <p>Sample values: <code>Windows</code> | <code>Office</code> </p> </li> <li> <p> <b> <code>MSRC_SEVERITY</code> </b> </p> <p>Sample values: <code>ServicePacks</code> | <code>Important</code> | <code>Moderate</code> </p> </li> <li> <p> <b> <code>CLASSIFICATION</code> </b> </p> <p>Sample values: <code>ServicePacks</code> | <code>SecurityUpdates</code> | <code>DefinitionUpdates</code> </p> </li> <li> <p> <b> <code>PATCH_ID</code> </b> </p> <p>Sample values: <code>KB123456</code> | <code>KB4516046</code> </p> </li> </ul> <p> <b>Linux</b> </p> <important> <p>When specifying filters for Linux patches, you must specify a key-pair for <code>PRODUCT</code>. For example, using the Command Line Interface (CLI), the following command fails:</p> <p> <code>aws ssm describe-available-patches --filters Key=CVE_ID,Values=CVE-2018-3615</code> </p> <p>However, the following command succeeds:</p> <p> <code>aws ssm describe-available-patches --filters Key=PRODUCT,Values=AmazonLinux2018.03 Key=CVE_ID,Values=CVE-2018-3615</code> </p> </important> <p>Supported keys for Linux managed node patches include the following:</p> <ul> <li> <p> <b> <code>PRODUCT</code> </b> </p> <p>Sample values: <code>AmazonLinux2018.03</code> | <code>AmazonLinux2.0</code> </p> </li> <li> <p> <b> <code>NAME</code> </b> </p> <p>Sample values: <code>kernel-headers</code> | <code>samba-python</code> | <code>php</code> </p> </li> <li> <p> <b> <code>SEVERITY</code> </b> </p> <p>Sample values: <code>Critical</code> | <code>Important</code> | <code>Medium</code> | <code>Low</code> </p> </li> <li> <p> <b> <code>EPOCH</code> </b> </p> <p>Sample values: <code>0</code> | <code>1</code> </p> </li> <li> <p> <b> <code>VERSION</code> </b> </p> <p>Sample values: <code>78.6.1</code> | <code>4.10.16</code> </p> </li> <li> <p> <b> <code>RELEASE</code> </b> </p> <p>Sample values: <code>9.56.amzn1</code> | <code>1.amzn2</code> </p> </li> <li> <p> <b> <code>ARCH</code> </b> </p> <p>Sample values: <code>i686</code> | <code>x86_64</code> </p> </li> <li> <p> <b> <code>REPOSITORY</code> </b> </p> <p>Sample values: <code>Core</code> | <code>Updates</code> </p> </li> <li> <p> <b> <code>ADVISORY_ID</code> </b> </p> <p>Sample values: <code>ALAS-2018-1058</code> | <code>ALAS2-2021-1594</code> </p> </li> <li> <p> <b> <code>CVE_ID</code> </b> </p> <p>Sample values: <code>CVE-2018-3615</code> | <code>CVE-2020-1472</code> </p> </li> <li> <p> <b> <code>BUGZILLA_ID</code> </b> </p> <p>Sample values: <code>1463241</code> </p> </li> </ul>', 'DescribeInstancePatchesRequest$Filters' => '<p>Each element in the array is a structure containing a key-value pair.</p> <p>Supported keys for <code>DescribeInstancePatches</code>include the following:</p> <ul> <li> <p> <b> <code>Classification</code> </b> </p> <p>Sample values: <code>Security</code> | <code>SecurityUpdates</code> </p> </li> <li> <p> <b> <code>KBId</code> </b> </p> <p>Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code> </p> </li> <li> <p> <b> <code>Severity</code> </b> </p> <p>Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code> </p> </li> <li> <p> <b> <code>State</code> </b> </p> <p>Sample values: <code>Installed</code> | <code>InstalledOther</code> | <code>InstalledPendingReboot</code> </p> </li> </ul>', 'DescribeMaintenanceWindowScheduleRequest$Filters' => '<p>Filters used to limit the range of results. For example, you can limit maintenance window executions to only those scheduled before or after a certain date and time.</p>', 'DescribePatchBaselinesRequest$Filters' => '<p>Each element in the array is a structure containing a key-value pair.</p> <p>Supported keys for <code>DescribePatchBaselines</code> include the following:</p> <ul> <li> <p> <b> <code>NAME_PREFIX</code> </b> </p> <p>Sample values: <code>AWS-</code> | <code>My-</code> </p> </li> <li> <p> <b> <code>OWNER</code> </b> </p> <p>Sample values: <code>AWS</code> | <code>Self</code> </p> </li> <li> <p> <b> <code>OPERATING_SYSTEM</code> </b> </p> <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code> </p> </li> </ul>', 'DescribePatchGroupsRequest$Filters' => '<p>Each element in the array is a structure containing a key-value pair.</p> <p>Supported keys for <code>DescribePatchGroups</code> include the following:</p> <ul> <li> <p> <b> <code>NAME_PREFIX</code> </b> </p> <p>Sample values: <code>AWS-</code> | <code>My-</code>.</p> </li> <li> <p> <b> <code>OPERATING_SYSTEM</code> </b> </p> <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code> </p> </li> </ul>', ], ], 'PatchOrchestratorFilterValue' => [ 'base' => NULL, 'refs' => [ 'PatchOrchestratorFilterValues$member' => NULL, ], ], 'PatchOrchestratorFilterValues' => [ 'base' => NULL, 'refs' => [ 'PatchOrchestratorFilter$Values' => '<p>The value for the filter.</p>', ], ], 'PatchOtherNonCompliantCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$OtherNonCompliantCount' => '<p>The number of managed nodes with patches installed that are specified as other than <code>Critical</code> or <code>Security</code> but aren\'t compliant with the patch baseline. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>', ], ], 'PatchProduct' => [ 'base' => NULL, 'refs' => [ 'Patch$Product' => '<p>The specific product the patch is applicable for. For example, <code>WindowsServer2016</code> or <code>AmazonLinux2018.03</code>.</p>', ], ], 'PatchProductFamily' => [ 'base' => NULL, 'refs' => [ 'Patch$ProductFamily' => '<p>The product family the patch is applicable for. For example, <code>Windows</code> or <code>Amazon Linux 2</code>.</p>', ], ], 'PatchPropertiesList' => [ 'base' => NULL, 'refs' => [ 'DescribePatchPropertiesResult$Properties' => '<p>A list of the properties for patches matching the filter request parameters.</p>', ], ], 'PatchProperty' => [ 'base' => NULL, 'refs' => [ 'DescribePatchPropertiesRequest$Property' => '<p>The patch property for which you want to view patch details. </p>', ], ], 'PatchPropertyEntry' => [ 'base' => NULL, 'refs' => [ 'PatchPropertiesList$member' => NULL, ], ], 'PatchRelease' => [ 'base' => NULL, 'refs' => [ 'Patch$Release' => '<p>The particular release of a patch. For example, in <code>pkg-example-EE-20180914-2.2.amzn1.noarch</code>, the release is <code>2.amaz1</code>. Applies to Linux-based managed nodes only.</p>', ], ], 'PatchRepository' => [ 'base' => NULL, 'refs' => [ 'Patch$Repository' => '<p>The source patch repository for the operating system and version, such as <code>trusty-security</code> for Ubuntu Server 14.04 LTE and <code>focal-security</code> for Ubuntu Server 20.04 LTE. Applies to Linux-based managed nodes only.</p>', ], ], 'PatchRule' => [ 'base' => '<p>Defines an approval rule for a patch baseline.</p>', 'refs' => [ 'PatchRuleList$member' => NULL, ], ], 'PatchRuleGroup' => [ 'base' => '<p>A set of rules defining the approval rules for a patch baseline.</p>', 'refs' => [ 'BaselineOverride$ApprovalRules' => NULL, 'CreatePatchBaselineRequest$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', 'GetPatchBaselineResult$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', 'UpdatePatchBaselineRequest$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', 'UpdatePatchBaselineResult$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', ], ], 'PatchRuleList' => [ 'base' => NULL, 'refs' => [ 'PatchRuleGroup$PatchRules' => '<p>The rules that make up the rule group.</p>', ], ], 'PatchSecurityNonCompliantCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$SecurityNonCompliantCount' => '<p>The number of managed nodes where patches that are specified as <code>Security</code> in a patch advisory aren\'t installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>', ], ], 'PatchSet' => [ 'base' => NULL, 'refs' => [ 'DescribePatchPropertiesRequest$PatchSet' => '<p>Indicates whether to list patches for the Windows operating system or for applications released by Microsoft. Not applicable for the Linux or macOS operating systems.</p>', ], ], 'PatchSeverity' => [ 'base' => NULL, 'refs' => [ 'Patch$Severity' => '<p>The severity level of the patch. For example, <code>CRITICAL</code> or <code>MODERATE</code>.</p>', 'PatchComplianceData$Severity' => '<p>The severity of the patch such as <code>Critical</code>, <code>Important</code>, and <code>Moderate</code>.</p>', ], ], 'PatchSource' => [ 'base' => '<p>Information about the patches to use to update the managed nodes, including target operating systems and source repository. Applies to Linux managed nodes only.</p>', 'refs' => [ 'PatchSourceList$member' => NULL, ], ], 'PatchSourceConfiguration' => [ 'base' => NULL, 'refs' => [ 'PatchSource$Configuration' => '<p>The value of the yum repo configuration. For example:</p> <p> <code>[main]</code> </p> <p> <code>name=MyCustomRepository</code> </p> <p> <code>baseurl=https://my-custom-repository</code> </p> <p> <code>enabled=1</code> </p> <note> <p>For information about other options available for your yum repository configuration, see <a href="https://man7.org/linux/man-pages/man5/dnf.conf.5.html">dnf.conf(5)</a>.</p> </note>', ], ], 'PatchSourceList' => [ 'base' => NULL, 'refs' => [ 'BaselineOverride$Sources' => '<p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>', 'CreatePatchBaselineRequest$Sources' => '<p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>', 'GetPatchBaselineResult$Sources' => '<p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>', 'UpdatePatchBaselineRequest$Sources' => '<p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>', 'UpdatePatchBaselineResult$Sources' => '<p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>', ], ], 'PatchSourceName' => [ 'base' => NULL, 'refs' => [ 'PatchSource$Name' => '<p>The name specified to identify the patch source.</p>', ], ], 'PatchSourceProduct' => [ 'base' => NULL, 'refs' => [ 'PatchSourceProductList$member' => NULL, ], ], 'PatchSourceProductList' => [ 'base' => NULL, 'refs' => [ 'PatchSource$Products' => '<p>The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "AmazonLinux2016.09", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see <a>PatchFilter</a>.</p>', ], ], 'PatchStatus' => [ 'base' => '<p>Information about the approval status of a patch.</p>', 'refs' => [ 'EffectivePatch$PatchStatus' => '<p>The status of the patch in a patch baseline. This includes information about whether the patch is currently approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch was or will be approved.</p>', ], ], 'PatchStringDateTime' => [ 'base' => NULL, 'refs' => [ 'PatchRule$ApproveUntilDate' => '<p>The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically. Not supported on Debian Server or Ubuntu Server.</p> <p>Enter dates in the format <code>YYYY-MM-DD</code>. For example, <code>2021-12-31</code>.</p>', ], ], 'PatchTitle' => [ 'base' => NULL, 'refs' => [ 'Patch$Title' => '<p>The title of the patch.</p>', 'PatchComplianceData$Title' => '<p>The title of the patch.</p>', ], ], 'PatchUnreportedNotApplicableCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$UnreportedNotApplicableCount' => '<p>The number of patches beyond the supported limit of <code>NotApplicableCount</code> that aren\'t reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.</p>', ], ], 'PatchVendor' => [ 'base' => NULL, 'refs' => [ 'Patch$Vendor' => '<p>The name of the vendor providing the patch.</p>', ], ], 'PatchVersion' => [ 'base' => NULL, 'refs' => [ 'Patch$Version' => '<p>The version number of the patch. For example, in <code>example-pkg-1.710.10-2.7.abcd.x86_64</code>, the version number is indicated by <code>-1</code>. Applies to Linux-based managed nodes only.</p>', ], ], 'PingStatus' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$PingStatus' => '<p>Connection status of SSM Agent. </p> <note> <p>The status <code>Inactive</code> has been deprecated and is no longer in use.</p> </note>', ], ], 'PlatformType' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$PlatformType' => '<p>The operating system platform type. </p>', 'PlatformTypeList$member' => NULL, ], ], 'PlatformTypeList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$PlatformTypes' => '<p>The list of operating system (OS) platforms compatible with this SSM document. </p>', 'DocumentIdentifier$PlatformTypes' => '<p>The operating system platform. </p>', ], ], 'PoliciesLimitExceededException' => [ 'base' => '<p>You specified more than the maximum number of allowed policies for the parameter. The maximum is 10.</p>', 'refs' => [], ], 'Product' => [ 'base' => NULL, 'refs' => [ 'GetDeployablePatchSnapshotForInstanceResult$Product' => '<p>Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the managed node for the specified patch snapshot.</p>', ], ], 'ProgressCounters' => [ 'base' => '<p>An aggregate of step execution statuses displayed in the Amazon Web Services Systems Manager console for a multi-Region and multi-account Automation execution.</p>', 'refs' => [ 'AutomationExecution$ProgressCounters' => '<p>An aggregate of step execution statuses displayed in the Amazon Web Services Systems Manager console for a multi-Region and multi-account Automation execution.</p>', ], ], 'PutComplianceItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutComplianceItemsResult' => [ 'base' => NULL, 'refs' => [], ], 'PutInventoryMessage' => [ 'base' => NULL, 'refs' => [ 'PutInventoryResult$Message' => '<p>Information about the request.</p>', ], ], 'PutInventoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInventoryResult' => [ 'base' => NULL, 'refs' => [], ], 'PutParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutParameterResult' => [ 'base' => NULL, 'refs' => [], ], 'RebootOption' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$RebootOption' => '<p>Indicates the reboot option specified in the patch baseline.</p> <note> <p>Reboot options apply to <code>Install</code> operations only. Reboots aren\'t attempted for Patch Manager <code>Scan</code> operations.</p> </note> <ul> <li> <p> <code>RebootIfNeeded</code>: Patch Manager tries to reboot the managed node if it installed any patches, or if any patches are detected with a status of <code>InstalledPendingReboot</code>.</p> </li> <li> <p> <code>NoReboot</code>: Patch Manager attempts to install missing packages without trying to reboot the system. Patches installed with this option are assigned a status of <code>InstalledPendingReboot</code>. These patches might not be in effect until a reboot is performed.</p> </li> </ul>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'Regions$member' => NULL, ], ], 'Regions' => [ 'base' => NULL, 'refs' => [ 'TargetLocation$Regions' => '<p>The Amazon Web Services Regions targeted by the current Automation execution.</p>', ], ], 'RegisterDefaultPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterDefaultPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterPatchBaselineForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterPatchBaselineForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTargetWithMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTargetWithMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTaskWithMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTaskWithMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationLimit' => [ 'base' => NULL, 'refs' => [ 'Activation$RegistrationLimit' => '<p>The maximum number of managed nodes that can be registered using this activation.</p>', 'CreateActivationRequest$RegistrationLimit' => '<p>Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.</p>', ], ], 'RegistrationMetadataItem' => [ 'base' => '<p>Reserved for internal use.</p>', 'refs' => [ 'RegistrationMetadataList$member' => NULL, ], ], 'RegistrationMetadataKey' => [ 'base' => NULL, 'refs' => [ 'RegistrationMetadataItem$Key' => '<p>Reserved for internal use.</p>', ], ], 'RegistrationMetadataList' => [ 'base' => NULL, 'refs' => [ 'CreateActivationRequest$RegistrationMetadata' => '<p>Reserved for internal use.</p>', ], ], 'RegistrationMetadataValue' => [ 'base' => NULL, 'refs' => [ 'RegistrationMetadataItem$Value' => '<p>Reserved for internal use.</p>', ], ], 'RegistrationsCount' => [ 'base' => NULL, 'refs' => [ 'Activation$RegistrationsCount' => '<p>The number of managed nodes already registered with this activation.</p>', ], ], 'RelatedOpsItem' => [ 'base' => '<p>An OpsItems that shares something in common with the current OpsItem. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>', 'refs' => [ 'RelatedOpsItems$member' => NULL, ], ], 'RelatedOpsItems' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$RelatedOpsItems' => '<p>One or more OpsItems that share something in common with the current OpsItems. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>', 'OpsItem$RelatedOpsItems' => '<p>One or more OpsItems that share something in common with the current OpsItem. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>', 'UpdateOpsItemRequest$RelatedOpsItems' => '<p>One or more OpsItems that share something in common with the current OpsItems. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>', ], ], 'RemainingCount' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionSummary$RemainingCount' => '<p>Remaining number of items to delete.</p>', 'InventoryDeletionSummaryItem$RemainingCount' => '<p>The remaining number of items to delete.</p>', ], ], 'RemoveTagsFromResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsFromResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'ResetServiceSettingRequest' => [ 'base' => '<p>The request body of the ResetServiceSetting API operation.</p>', 'refs' => [], ], 'ResetServiceSettingResult' => [ 'base' => '<p>The result body of the ResetServiceSetting API operation.</p>', 'refs' => [], ], 'ResolvedTargets' => [ 'base' => '<p>Information about targets that resolved during the Automation execution.</p>', 'refs' => [ 'AutomationExecution$ResolvedTargets' => '<p>A list of resolved targets in the rate control execution.</p>', 'AutomationExecutionMetadata$ResolvedTargets' => '<p>A list of targets that resolved during the execution.</p>', ], ], 'ResourceComplianceSummaryItem' => [ 'base' => '<p>Compliance summary information for a specific resource. </p>', 'refs' => [ 'ResourceComplianceSummaryItemList$member' => NULL, ], ], 'ResourceComplianceSummaryItemList' => [ 'base' => NULL, 'refs' => [ 'ListResourceComplianceSummariesResult$ResourceComplianceSummaryItems' => '<p>A summary count for specified or targeted managed nodes. Summary count includes information about compliant and non-compliant State Manager associations, patch status, or custom items according to the filter criteria that you specify. </p>', ], ], 'ResourceCount' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionSummaryItem$Count' => '<p>A count of the number of deleted items.</p>', ], ], 'ResourceCountByStatus' => [ 'base' => NULL, 'refs' => [ 'AssociationExecution$ResourceCountByStatus' => '<p>An aggregate status of the resources in the execution based on the status type.</p>', ], ], 'ResourceDataSyncAWSKMSKeyARN' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$AWSKMSKeyARN' => '<p>The ARN of an encryption key for a destination in Amazon S3. Must belong to the same Region as the destination S3 bucket.</p>', ], ], 'ResourceDataSyncAlreadyExistsException' => [ 'base' => '<p>A sync configuration with the same name already exists.</p>', 'refs' => [], ], 'ResourceDataSyncAwsOrganizationsSource' => [ 'base' => '<p>Information about the <code>AwsOrganizationsSource</code> resource data sync source. A sync source of this type can synchronize data from Organizations or, if an Amazon Web Services organization isn\'t present, from multiple Amazon Web Services Regions.</p>', 'refs' => [ 'ResourceDataSyncSource$AwsOrganizationsSource' => '<p>Information about the <code>AwsOrganizationsSource</code> resource data sync source. A sync source of this type can synchronize data from Organizations.</p>', 'ResourceDataSyncSourceWithState$AwsOrganizationsSource' => '<p>The field name in <code>SyncSource</code> for the <code>ResourceDataSyncAwsOrganizationsSource</code> type.</p>', ], ], 'ResourceDataSyncConflictException' => [ 'base' => '<p>Another <code>UpdateResourceDataSync</code> request is being processed. Wait a few minutes and try again.</p>', 'refs' => [], ], 'ResourceDataSyncCountExceededException' => [ 'base' => '<p>You have exceeded the allowed maximum sync configurations.</p>', 'refs' => [], ], 'ResourceDataSyncCreatedTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$SyncCreatedTime' => '<p>The date and time the configuration was created (UTC).</p>', ], ], 'ResourceDataSyncDestinationDataSharing' => [ 'base' => '<p>Synchronize Amazon Web Services Systems Manager Inventory data from multiple Amazon Web Services accounts defined in Organizations to a centralized Amazon S3 bucket. Data is synchronized to individual key prefixes in the central bucket. Each key prefix represents a different Amazon Web Services account ID.</p>', 'refs' => [ 'ResourceDataSyncS3Destination$DestinationDataSharing' => '<p>Enables destination data sharing. By default, this field is <code>null</code>.</p>', ], ], 'ResourceDataSyncDestinationDataSharingType' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncDestinationDataSharing$DestinationDataSharingType' => '<p>The sharing data type. Only <code>Organization</code> is supported.</p>', ], ], 'ResourceDataSyncEnableAllOpsDataSources' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSource$EnableAllOpsDataSources' => '<p>When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in your organization (or in the selected organization units). For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resouce-data-sync-multiple-accounts-and-regions.html">About multiple account and Region resource data syncs</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'ResourceDataSyncSourceWithState$EnableAllOpsDataSources' => '<p>When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in your organization (or in the selected organization units). For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resouce-data-sync-multiple-accounts-and-regions.html">About multiple account and Region resource data syncs</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', ], ], 'ResourceDataSyncIncludeFutureRegions' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSource$IncludeFutureRegions' => '<p>Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those Regions come online.</p>', 'ResourceDataSyncSourceWithState$IncludeFutureRegions' => '<p>Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those Regions come online.</p>', ], ], 'ResourceDataSyncInvalidConfigurationException' => [ 'base' => '<p>The specified sync configuration is invalid.</p>', 'refs' => [], ], 'ResourceDataSyncItem' => [ 'base' => '<p>Information about a resource data sync configuration, including its current status and last successful sync.</p>', 'refs' => [ 'ResourceDataSyncItemList$member' => NULL, ], ], 'ResourceDataSyncItemList' => [ 'base' => NULL, 'refs' => [ 'ListResourceDataSyncResult$ResourceDataSyncItems' => '<p>A list of your current resource data sync configurations and their statuses.</p>', ], ], 'ResourceDataSyncLastModifiedTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$SyncLastModifiedTime' => '<p>The date and time the resource data sync was changed. </p>', ], ], 'ResourceDataSyncName' => [ 'base' => NULL, 'refs' => [ 'CreateResourceDataSyncRequest$SyncName' => '<p>A name for the configuration.</p>', 'DeleteResourceDataSyncRequest$SyncName' => '<p>The name of the configuration to delete.</p>', 'GetOpsSummaryRequest$SyncName' => '<p>Specify the name of a resource data sync to get.</p>', 'ResourceDataSyncAlreadyExistsException$SyncName' => NULL, 'ResourceDataSyncItem$SyncName' => '<p>The name of the resource data sync.</p>', 'ResourceDataSyncNotFoundException$SyncName' => NULL, 'UpdateResourceDataSyncRequest$SyncName' => '<p>The name of the resource data sync you want to update.</p>', ], ], 'ResourceDataSyncNotFoundException' => [ 'base' => '<p>The specified sync name wasn\'t found.</p>', 'refs' => [], ], 'ResourceDataSyncOrganizationSourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncAwsOrganizationsSource$OrganizationSourceType' => '<p>If an Amazon Web Services organization is present, this is either <code>OrganizationalUnits</code> or <code>EntireOrganization</code>. For <code>OrganizationalUnits</code>, the data is aggregated from a set of organization units. For <code>EntireOrganization</code>, the data is aggregated from the entire Amazon Web Services organization.</p>', ], ], 'ResourceDataSyncOrganizationalUnit' => [ 'base' => '<p>The Organizations organizational unit data source for the sync.</p>', 'refs' => [ 'ResourceDataSyncOrganizationalUnitList$member' => NULL, ], ], 'ResourceDataSyncOrganizationalUnitId' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncOrganizationalUnit$OrganizationalUnitId' => '<p>The Organizations unit ID data source for the sync.</p>', ], ], 'ResourceDataSyncOrganizationalUnitList' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncAwsOrganizationsSource$OrganizationalUnits' => '<p>The Organizations organization units included in the sync.</p>', ], ], 'ResourceDataSyncS3BucketName' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$BucketName' => '<p>The name of the S3 bucket where the aggregated data is stored.</p>', ], ], 'ResourceDataSyncS3Destination' => [ 'base' => '<p>Information about the target S3 bucket for the resource data sync.</p>', 'refs' => [ 'CreateResourceDataSyncRequest$S3Destination' => '<p>Amazon S3 configuration details for the sync. This parameter is required if the <code>SyncType</code> value is SyncToDestination.</p>', 'ResourceDataSyncItem$S3Destination' => '<p>Configuration information for the target S3 bucket.</p>', ], ], 'ResourceDataSyncS3Format' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$SyncFormat' => '<p>A supported sync format. The following format is currently supported: JsonSerDe</p>', ], ], 'ResourceDataSyncS3Prefix' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$Prefix' => '<p>An Amazon S3 prefix for the bucket.</p>', ], ], 'ResourceDataSyncS3Region' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$Region' => '<p>The Amazon Web Services Region with the S3 bucket targeted by the resource data sync.</p>', ], ], 'ResourceDataSyncSource' => [ 'base' => '<p>Information about the source of the data included in the resource data sync.</p>', 'refs' => [ 'CreateResourceDataSyncRequest$SyncSource' => '<p>Specify information about the data sources to synchronize. This parameter is required if the <code>SyncType</code> value is SyncFromSource.</p>', 'UpdateResourceDataSyncRequest$SyncSource' => '<p>Specify information about the data sources to synchronize.</p>', ], ], 'ResourceDataSyncSourceRegion' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSourceRegionList$member' => NULL, ], ], 'ResourceDataSyncSourceRegionList' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSource$SourceRegions' => '<p>The <code>SyncSource</code> Amazon Web Services Regions included in the resource data sync.</p>', 'ResourceDataSyncSourceWithState$SourceRegions' => '<p>The <code>SyncSource</code> Amazon Web Services Regions included in the resource data sync.</p>', ], ], 'ResourceDataSyncSourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSource$SourceType' => '<p>The type of data source for the resource data sync. <code>SourceType</code> is either <code>AwsOrganizations</code> (if an organization is present in Organizations) or <code>SingleAccountMultiRegions</code>.</p>', 'ResourceDataSyncSourceWithState$SourceType' => '<p>The type of data source for the resource data sync. <code>SourceType</code> is either <code>AwsOrganizations</code> (if an organization is present in Organizations) or <code>singleAccountMultiRegions</code>.</p>', ], ], 'ResourceDataSyncSourceWithState' => [ 'base' => '<p>The data type name for including resource data sync state. There are four sync states:</p> <p> <code>OrganizationNotExists</code> (Your organization doesn\'t exist)</p> <p> <code>NoPermissions</code> (The system can\'t locate the service-linked role. This role is automatically created when a user creates a resource data sync in Amazon Web Services Systems Manager Explorer.)</p> <p> <code>InvalidOrganizationalUnit</code> (You specified or selected an invalid unit in the resource data sync configuration.)</p> <p> <code>TrustedAccessDisabled</code> (You disabled Systems Manager access in the organization in Organizations.)</p>', 'refs' => [ 'ResourceDataSyncItem$SyncSource' => '<p>Information about the source where the data was synchronized. </p>', ], ], 'ResourceDataSyncState' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSourceWithState$State' => '<p>The data type name for including resource data sync state. There are four sync states:</p> <p> <code>OrganizationNotExists</code>: Your organization doesn\'t exist.</p> <p> <code>NoPermissions</code>: The system can\'t locate the service-linked role. This role is automatically created when a user creates a resource data sync in Explorer.</p> <p> <code>InvalidOrganizationalUnit</code>: You specified or selected an invalid unit in the resource data sync configuration.</p> <p> <code>TrustedAccessDisabled</code>: You disabled Systems Manager access in the organization in Organizations.</p>', ], ], 'ResourceDataSyncType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceDataSyncRequest$SyncType' => '<p>Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data to an S3 bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a value for <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data from a single account and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services Regions, as listed in Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a value for <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.</p>', 'DeleteResourceDataSyncRequest$SyncType' => '<p>Specify the type of resource data sync to delete.</p>', 'ListResourceDataSyncRequest$SyncType' => '<p>View a list of resource data syncs according to the sync type. Specify <code>SyncToDestination</code> to view resource data syncs that synchronize data to an Amazon S3 bucket. Specify <code>SyncFromSource</code> to view resource data syncs from Organizations or from multiple Amazon Web Services Regions.</p>', 'ResourceDataSyncItem$SyncType' => '<p>The type of resource data sync. If <code>SyncType</code> is <code>SyncToDestination</code>, then the resource data sync synchronizes data to an S3 bucket. If the <code>SyncType</code> is <code>SyncFromSource</code> then the resource data sync synchronizes data from Organizations or from multiple Amazon Web Services Regions.</p>', 'ResourceDataSyncNotFoundException$SyncType' => NULL, 'UpdateResourceDataSyncRequest$SyncType' => '<p>The type of resource data sync. The supported <code>SyncType</code> is SyncFromSource.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceRequest$ResourceId' => '<p>The resource ID you want to tag.</p> <p>Use the ID of the resource. Here are some examples:</p> <p> <code>MaintenanceWindow</code>: <code>mw-012345abcde</code> </p> <p> <code>PatchBaseline</code>: <code>pb-012345abcde</code> </p> <p> <code>OpsMetadata</code> object: <code>ResourceID</code> for tagging is created from the Amazon Resource Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from the strings that come after the word <code>opsmetadata</code> in the ARN. For example, an OpsMetadata object with an ARN of <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code> has a <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or <code>/aws/ssm/MyGroup/appmanager</code>.</p> <p>For the <code>Document</code> and <code>Parameter</code> values, use the name of the resource.</p> <p> <code>ManagedInstance</code>: <code>mi-012345abcde</code> </p> <note> <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises managed nodes. You must specify the name of the managed node in the following format: <code>mi-<i>ID_number</i> </code>. For example, <code>mi-1a2b3c4d5e6f</code>.</p> </note>', 'ListTagsForResourceRequest$ResourceId' => '<p>The resource ID for which you want to see a list of tags.</p>', 'RemoveTagsFromResourceRequest$ResourceId' => '<p>The ID of the resource from which you want to remove tags. For example:</p> <p>ManagedInstance: mi-012345abcde</p> <p>MaintenanceWindow: mw-012345abcde</p> <p>PatchBaseline: pb-012345abcde</p> <p>OpsMetadata object: <code>ResourceID</code> for tagging is created from the Amazon Resource Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from the strings that come after the word <code>opsmetadata</code> in the ARN. For example, an OpsMetadata object with an ARN of <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code> has a <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or <code>/aws/ssm/MyGroup/appmanager</code>.</p> <p>For the Document and Parameter values, use the name of the resource.</p> <note> <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises managed nodes. Specify the name of the managed node in the following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.</p> </note>', ], ], 'ResourceInUseException' => [ 'base' => '<p>Error returned if an attempt is made to delete a patch baseline that is registered for a patch group.</p>', 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>Error returned when the caller has exceeded the default resource quotas. For example, too many maintenance windows or patch baselines have been created.</p> <p>For information about resource quotas in Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$ResourceType' => '<p>The type of instance. Instances are either EC2 instances or managed instances. </p>', ], ], 'ResourceTypeForTagging' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceRequest$ResourceType' => '<p>Specifies the type of resource you are tagging.</p> <note> <p>The <code>ManagedInstance</code> type for this API operation is for on-premises managed nodes. You must specify the name of the managed node in the following format: <code>mi-<i>ID_number</i> </code>. For example, <code>mi-1a2b3c4d5e6f</code>.</p> </note>', 'ListTagsForResourceRequest$ResourceType' => '<p>Returns a list of tags for a specific resource type.</p>', 'RemoveTagsFromResourceRequest$ResourceType' => '<p>The type of resource from which you want to remove a tag.</p> <note> <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises managed nodes. Specify the name of the managed node in the following format: <code>mi-<i>ID_number</i> </code>. For example, <code>mi-1a2b3c4d5e6f</code>.</p> </note>', ], ], 'ResponseCode' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$ResponseCode' => '<p>A numeric response code generated after running the plugin. </p>', 'GetCommandInvocationResult$ResponseCode' => '<p>The error level response code for the plugin script. If the response code is <code>-1</code>, then the command hasn\'t started running on the managed node, or it wasn\'t received by the node.</p>', ], ], 'ResultAttribute' => [ 'base' => '<p>The inventory item result attribute.</p>', 'refs' => [ 'ResultAttributeList$member' => NULL, ], ], 'ResultAttributeList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryRequest$ResultAttributes' => '<p>The list of inventory item types to return.</p>', ], ], 'ResumeSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResumeSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReviewInformation' => [ 'base' => '<p>Information about the result of a document review request.</p>', 'refs' => [ 'ReviewInformationList$member' => NULL, ], ], 'ReviewInformationList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$ReviewInformation' => '<p>Details about the review of a document.</p>', ], ], 'ReviewStatus' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$ReviewStatus' => '<p>The current status of the review.</p>', 'DocumentIdentifier$ReviewStatus' => '<p>The current status of a document review.</p>', 'DocumentReviewerResponseSource$ReviewStatus' => '<p>The current review status of a new custom SSM document created by a member of your organization, or of the latest version of an existing SSM document.</p> <p>Only one version of a document can be in the APPROVED state at a time. When a new version is approved, the status of the previous version changes to REJECTED.</p> <p>Only one version of a document can be in review, or PENDING, at a time.</p>', 'DocumentVersionInfo$ReviewStatus' => '<p>The current status of the approval review for the latest version of the document.</p>', 'GetDocumentResult$ReviewStatus' => '<p>The current review status of a new custom Systems Manager document (SSM document) created by a member of your organization, or of the latest version of an existing SSM document.</p> <p>Only one version of an SSM document can be in the APPROVED state at a time. When a new version is approved, the status of the previous version changes to REJECTED.</p> <p>Only one version of an SSM document can be in review, or PENDING, at a time.</p>', 'ReviewInformation$Status' => '<p>The current status of the document review request.</p>', ], ], 'Reviewer' => [ 'base' => NULL, 'refs' => [ 'DocumentReviewerResponseSource$Reviewer' => '<p>The user in your organization assigned to review a document request.</p>', 'ReviewInformation$Reviewer' => '<p>The reviewer assigned to take action on the document review request.</p>', ], ], 'Runbook' => [ 'base' => '<p>Information about an Automation runbook used in a runbook workflow in Change Manager.</p> <note> <p>The Automation runbooks specified for the runbook workflow can\'t run until all required approvals for the change request have been received.</p> </note>', 'refs' => [ 'Runbooks$member' => NULL, ], ], 'Runbooks' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$Runbooks' => '<p>Information about the Automation runbooks that are run as part of a runbook workflow.</p> <note> <p>The Automation runbooks specified for the runbook workflow can\'t run until all required approvals for the change request have been received.</p> </note>', 'AutomationExecutionMetadata$Runbooks' => '<p>Information about the Automation runbooks that are run during a runbook workflow in Change Manager.</p> <note> <p>The Automation runbooks specified for the runbook workflow can\'t run until all required approvals for the change request have been received.</p> </note>', 'StartChangeRequestExecutionRequest$Runbooks' => '<p>Information about the Automation runbooks that are run during the runbook workflow.</p> <note> <p>The Automation runbooks specified for the runbook workflow can\'t run until all required approvals for the change request have been received.</p> </note>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'Command$OutputS3BucketName' => '<p>The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the command.</p>', 'CommandPlugin$OutputS3BucketName' => '<p>The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the command. For example, in the following response:</p> <p> <code>doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript</code> </p> <p> <code>doc-example-bucket</code> is the name of the S3 bucket;</p> <p> <code>ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix</code> is the name of the S3 prefix;</p> <p> <code>i-02573cafcfEXAMPLE</code> is the managed node ID;</p> <p> <code>awsrunShellScript</code> is the name of the plugin.</p>', 'LoggingInfo$S3BucketName' => '<p>The name of an S3 bucket where execution logs are stored .</p>', 'MaintenanceWindowRunCommandParameters$OutputS3BucketName' => '<p>The name of the Amazon Simple Storage Service (Amazon S3) bucket.</p>', 'S3OutputLocation$OutputS3BucketName' => '<p>The name of the S3 bucket.</p>', 'SendCommandRequest$OutputS3BucketName' => '<p>The name of the S3 bucket where command execution responses should be stored.</p>', ], ], 'S3KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'Command$OutputS3KeyPrefix' => '<p>The S3 directory path inside the bucket where the responses to the command executions should be stored. This was requested when issuing the command.</p>', 'CommandPlugin$OutputS3KeyPrefix' => '<p>The S3 directory path inside the bucket where the responses to the command executions should be stored. This was requested when issuing the command. For example, in the following response:</p> <p> <code>doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript</code> </p> <p> <code>doc-example-bucket</code> is the name of the S3 bucket;</p> <p> <code>ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix</code> is the name of the S3 prefix;</p> <p> <code>i-02573cafcfEXAMPLE</code> is the managed node ID;</p> <p> <code>awsrunShellScript</code> is the name of the plugin.</p>', 'LoggingInfo$S3KeyPrefix' => '<p>(Optional) The S3 bucket subfolder. </p>', 'MaintenanceWindowRunCommandParameters$OutputS3KeyPrefix' => '<p>The S3 bucket subfolder.</p>', 'S3OutputLocation$OutputS3KeyPrefix' => '<p>The S3 bucket subfolder.</p>', 'SendCommandRequest$OutputS3KeyPrefix' => '<p>The directory structure within the S3 bucket where the responses should be stored.</p>', ], ], 'S3OutputLocation' => [ 'base' => '<p>An S3 bucket where you want to store the results of this request.</p>', 'refs' => [ 'InstanceAssociationOutputLocation$S3Location' => '<p>An S3 bucket where you want to store the results of this request.</p>', ], ], 'S3OutputUrl' => [ 'base' => '<p>A URL for the Amazon Web Services Systems Manager (Systems Manager) bucket where you want to store the results of this request.</p>', 'refs' => [ 'InstanceAssociationOutputUrl$S3OutputUrl' => '<p>The URL of S3 bucket where you want to store the results of this request.</p>', ], ], 'S3Region' => [ 'base' => NULL, 'refs' => [ 'Command$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon Web Services Region of the S3 bucket.</p>', 'CommandPlugin$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Amazon Web Services Systems Manager automatically determines the S3 bucket region.</p>', 'LoggingInfo$S3Region' => '<p>The Amazon Web Services Region where the S3 bucket is located.</p>', 'S3OutputLocation$OutputS3Region' => '<p>The Amazon Web Services Region of the S3 bucket.</p>', 'SendCommandRequest$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon Web Services Region of the S3 bucket.</p>', ], ], 'ScheduleExpression' => [ 'base' => NULL, 'refs' => [ 'Association$ScheduleExpression' => '<p>A cron expression that specifies a schedule when the association runs. The schedule runs in Coordinated Universal Time (UTC).</p>', 'AssociationDescription$ScheduleExpression' => '<p>A cron expression that specifies a schedule when the association runs.</p>', 'AssociationVersionInfo$ScheduleExpression' => '<p>The cron or rate schedule specified for the association when the association version was created.</p>', 'CreateAssociationBatchRequestEntry$ScheduleExpression' => '<p>A cron expression that specifies a schedule when the association runs.</p>', 'CreateAssociationRequest$ScheduleExpression' => '<p>A cron expression when the association will be applied to the target(s).</p>', 'UpdateAssociationRequest$ScheduleExpression' => '<p>The cron expression used to schedule the association that you want to update.</p>', ], ], 'ScheduledWindowExecution' => [ 'base' => '<p>Information about a scheduled execution for a maintenance window.</p>', 'refs' => [ 'ScheduledWindowExecutionList$member' => NULL, ], ], 'ScheduledWindowExecutionList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowScheduleResult$ScheduledWindowExecutions' => '<p>Information about maintenance window executions scheduled for the specified time range.</p>', ], ], 'SendAutomationSignalRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendAutomationSignalResult' => [ 'base' => NULL, 'refs' => [], ], 'SendCommandRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendCommandResult' => [ 'base' => NULL, 'refs' => [], ], 'ServiceRole' => [ 'base' => NULL, 'refs' => [ 'Command$ServiceRole' => '<p>The Identity and Access Management (IAM) service role that Run Command, a capability of Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes. </p>', 'CommandInvocation$ServiceRole' => '<p>The Identity and Access Management (IAM) service role that Run Command, a capability of Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes on a per managed node basis.</p>', 'GetMaintenanceWindowExecutionTaskResult$ServiceRole' => '<p>The role that was assumed when running the task.</p>', 'GetMaintenanceWindowTaskResult$ServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>', 'MaintenanceWindowRunCommandParameters$ServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>', 'MaintenanceWindowTask$ServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>', 'RegisterTaskWithMaintenanceWindowRequest$ServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account\'s service-linked role. If no service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code>.</p> <p>For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions">Using service-linked roles for Systems Manager</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role">Should I use a service-linked role or a custom service role to run maintenance window tasks? </a> </p> </li> </ul>', 'SendCommandRequest$ServiceRoleArn' => '<p>The ARN of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for Run Command commands.</p>', 'UpdateMaintenanceWindowTaskRequest$ServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account\'s service-linked role. If no service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code>.</p> <p>For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions">Using service-linked roles for Systems Manager</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role">Should I use a service-linked role or a custom service role to run maintenance window tasks? </a> </p> </li> </ul>', 'UpdateMaintenanceWindowTaskResult$ServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>', ], ], 'ServiceSetting' => [ 'base' => '<p>The service setting data structure.</p> <p> <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can\'t use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.</p> <p>Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the default value for a <code>SettingId</code>. You can\'t create a new <code>SettingId</code>, but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the <a>UpdateServiceSetting</a> API operation to change the default setting. Or, use the <a>ResetServiceSetting</a> to change the value back to the original value defined by the Amazon Web Services service team.</p>', 'refs' => [ 'GetServiceSettingResult$ServiceSetting' => '<p>The query result of the current service setting.</p>', 'ResetServiceSettingResult$ServiceSetting' => '<p>The current, effective service setting after calling the ResetServiceSetting API operation.</p>', ], ], 'ServiceSettingId' => [ 'base' => NULL, 'refs' => [ 'GetServiceSettingRequest$SettingId' => '<p>The ID of the service setting to get. The setting ID can be one of the following.</p> <ul> <li> <p> <code>/ssm/automation/customer-script-log-destination</code> </p> </li> <li> <p> <code>/ssm/automation/customer-script-log-group-name</code> </p> </li> <li> <p> <code>/ssm/documents/console/public-sharing-permission</code> </p> </li> <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code> </p> </li> <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code> </p> </li> <li> <p> <code>/ssm/managed-instance/activation-tier</code> </p> </li> </ul>', 'ResetServiceSettingRequest$SettingId' => '<p>The Amazon Resource Name (ARN) of the service setting to reset. The setting ID can be one of the following.</p> <ul> <li> <p> <code>/ssm/automation/customer-script-log-destination</code> </p> </li> <li> <p> <code>/ssm/automation/customer-script-log-group-name</code> </p> </li> <li> <p> <code>/ssm/documents/console/public-sharing-permission</code> </p> </li> <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code> </p> </li> <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code> </p> </li> <li> <p> <code>/ssm/managed-instance/activation-tier</code> </p> </li> </ul>', 'ServiceSetting$SettingId' => '<p>The ID of the service setting.</p>', 'UpdateServiceSettingRequest$SettingId' => '<p>The Amazon Resource Name (ARN) of the service setting to reset. For example, <code>arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled</code>. The setting ID can be one of the following.</p> <ul> <li> <p> <code>/ssm/automation/customer-script-log-destination</code> </p> </li> <li> <p> <code>/ssm/automation/customer-script-log-group-name</code> </p> </li> <li> <p> <code>/ssm/documents/console/public-sharing-permission</code> </p> </li> <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code> </p> </li> <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code> </p> </li> <li> <p> <code>/ssm/managed-instance/activation-tier</code> </p> </li> </ul>', ], ], 'ServiceSettingNotFound' => [ 'base' => '<p>The specified service setting wasn\'t found. Either the service name or the setting hasn\'t been provisioned by the Amazon Web Services service team.</p>', 'refs' => [], ], 'ServiceSettingValue' => [ 'base' => NULL, 'refs' => [ 'ServiceSetting$SettingValue' => '<p>The value of the service setting.</p>', 'UpdateServiceSettingRequest$SettingValue' => '<p>The new value to specify for the service setting. The following list specifies the available values for each setting.</p> <ul> <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code>: <code>Standard</code>, <code>Advanced</code>, <code>Intelligent-Tiering</code> </p> </li> <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code>: <code>true</code> or <code>false</code> </p> </li> <li> <p> <code>/ssm/managed-instance/activation-tier</code>: <code>true</code> or <code>false</code> </p> </li> <li> <p> <code>/ssm/automation/customer-script-log-destination</code>: <code>CloudWatch</code> </p> </li> <li> <p> <code>/ssm/automation/customer-script-log-group-name</code>: the name of an Amazon CloudWatch Logs log group</p> </li> <li> <p> <code>/ssm/documents/console/public-sharing-permission</code>: <code>Enable</code> or <code>Disable</code> </p> </li> <li> <p> <code>/ssm/managed-instance/activation-tier</code>: <code>standard</code> or <code>advanced</code> </p> </li> </ul>', ], ], 'Session' => [ 'base' => '<p>Information about a Session Manager connection to a managed node.</p>', 'refs' => [ 'SessionList$member' => NULL, ], ], 'SessionDetails' => [ 'base' => NULL, 'refs' => [ 'Session$Details' => '<p>Reserved for future use.</p>', ], ], 'SessionFilter' => [ 'base' => '<p>Describes a filter for Session Manager information.</p>', 'refs' => [ 'SessionFilterList$member' => NULL, ], ], 'SessionFilterKey' => [ 'base' => NULL, 'refs' => [ 'SessionFilter$key' => '<p>The name of the filter.</p>', ], ], 'SessionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsRequest$Filters' => '<p>One or more filters to limit the type of sessions returned by the request.</p>', ], ], 'SessionFilterValue' => [ 'base' => NULL, 'refs' => [ 'SessionFilter$value' => '<p>The filter value. Valid values for each filter key are as follows:</p> <ul> <li> <p>InvokedAfter: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see sessions that started August 29, 2018, and later.</p> </li> <li> <p>InvokedBefore: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see sessions that started before August 29, 2018.</p> </li> <li> <p>Target: Specify a managed node to which session connections have been made.</p> </li> <li> <p>Owner: Specify an Amazon Web Services user account to see a list of sessions started by that user.</p> </li> <li> <p>Status: Specify a valid session status to see a list of all sessions with that status. Status values you can specify include:</p> <ul> <li> <p>Connected</p> </li> <li> <p>Connecting</p> </li> <li> <p>Disconnected</p> </li> <li> <p>Terminated</p> </li> <li> <p>Terminating</p> </li> <li> <p>Failed</p> </li> </ul> </li> <li> <p>SessionId: Specify a session ID to return details about the session.</p> </li> </ul>', ], ], 'SessionId' => [ 'base' => NULL, 'refs' => [ 'ResumeSessionRequest$SessionId' => '<p>The ID of the disconnected session to resume.</p>', 'ResumeSessionResponse$SessionId' => '<p>The ID of the session.</p>', 'Session$SessionId' => '<p>The ID of the session.</p>', 'StartSessionResponse$SessionId' => '<p>The ID of the session.</p>', 'TerminateSessionRequest$SessionId' => '<p>The ID of the session to terminate.</p>', 'TerminateSessionResponse$SessionId' => '<p>The ID of the session that has been terminated.</p>', ], ], 'SessionList' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsResponse$Sessions' => '<p>A list of sessions meeting the request parameters.</p>', ], ], 'SessionManagerCloudWatchOutputUrl' => [ 'base' => NULL, 'refs' => [ 'SessionManagerOutputUrl$CloudWatchOutputUrl' => '<p>Reserved for future use.</p>', ], ], 'SessionManagerOutputUrl' => [ 'base' => '<p>Reserved for future use.</p>', 'refs' => [ 'Session$OutputUrl' => '<p>Reserved for future use.</p>', ], ], 'SessionManagerParameterName' => [ 'base' => NULL, 'refs' => [ 'SessionManagerParameters$key' => NULL, ], ], 'SessionManagerParameterValue' => [ 'base' => NULL, 'refs' => [ 'SessionManagerParameterValueList$member' => NULL, ], ], 'SessionManagerParameterValueList' => [ 'base' => NULL, 'refs' => [ 'SessionManagerParameters$value' => NULL, ], ], 'SessionManagerParameters' => [ 'base' => NULL, 'refs' => [ 'StartSessionRequest$Parameters' => '<p>Reserved for future use.</p>', ], ], 'SessionManagerS3OutputUrl' => [ 'base' => NULL, 'refs' => [ 'SessionManagerOutputUrl$S3OutputUrl' => '<p>Reserved for future use.</p>', ], ], 'SessionMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'SessionOwner' => [ 'base' => NULL, 'refs' => [ 'Session$Owner' => '<p>The ID of the Amazon Web Services user account that started the session.</p>', ], ], 'SessionReason' => [ 'base' => NULL, 'refs' => [ 'Session$Reason' => '<p>The reason for connecting to the instance.</p>', 'StartSessionRequest$Reason' => '<p>The reason for connecting to the instance. This value is included in the details for the Amazon CloudWatch Events event created when you start the session.</p>', ], ], 'SessionState' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsRequest$State' => '<p>The session status to retrieve a list of sessions for. For example, "Active".</p>', ], ], 'SessionStatus' => [ 'base' => NULL, 'refs' => [ 'Session$Status' => '<p>The status of the session. For example, "Connected" or "Terminated".</p>', ], ], 'SessionTarget' => [ 'base' => NULL, 'refs' => [ 'GetConnectionStatusRequest$Target' => '<p>The managed node ID.</p>', 'GetConnectionStatusResponse$Target' => '<p>The ID of the managed node to check connection status. </p>', 'Session$Target' => '<p>The managed node that the Session Manager session connected to.</p>', 'StartSessionRequest$Target' => '<p>The managed node to connect to for the session.</p>', ], ], 'SeveritySummary' => [ 'base' => '<p>The number of managed nodes found for each patch severity level defined in the request filter.</p>', 'refs' => [ 'CompliantSummary$SeveritySummary' => '<p>A summary of the compliance severity by compliance type.</p>', 'NonCompliantSummary$SeveritySummary' => '<p>A summary of the non-compliance severity by compliance type</p>', ], ], 'SharedDocumentVersion' => [ 'base' => '<p>The document version shared with other accounts. You can share <code>Latest</code>, <code>Default</code> or <code>All versions</code>.</p>', 'refs' => [ 'AccountSharingInfo$SharedDocumentVersion' => '<p>The version of the current document shared with the account.</p>', 'ModifyDocumentPermissionRequest$SharedDocumentVersion' => '<p>(Optional) The version of the document to share. If it isn\'t specified, the system choose the <code>Default</code> version to share.</p>', ], ], 'SignalType' => [ 'base' => NULL, 'refs' => [ 'SendAutomationSignalRequest$SignalType' => '<p>The type of signal to send to an Automation execution. </p>', ], ], 'SnapshotDownloadUrl' => [ 'base' => NULL, 'refs' => [ 'GetDeployablePatchSnapshotForInstanceResult$SnapshotDownloadUrl' => '<p>A pre-signed Amazon Simple Storage Service (Amazon S3) URL that can be used to download the patch snapshot.</p>', ], ], 'SnapshotId' => [ 'base' => NULL, 'refs' => [ 'GetDeployablePatchSnapshotForInstanceRequest$SnapshotId' => '<p>The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.</p>', 'GetDeployablePatchSnapshotForInstanceResult$SnapshotId' => '<p>The user-defined snapshot ID.</p>', 'InstancePatchState$SnapshotId' => '<p>The ID of the patch baseline snapshot used during the patching operation when this compliance data was collected.</p>', ], ], 'SourceId' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$SourceId' => '<p>The ID of the source resource. For IoT Greengrass devices, <code>SourceId</code> is the Thing name. </p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$SourceType' => '<p>The type of the source resource. For IoT Greengrass devices, <code>SourceType</code> is <code>AWS::IoT::Thing</code>. </p>', ], ], 'StandardErrorContent' => [ 'base' => NULL, 'refs' => [ 'GetCommandInvocationResult$StandardErrorContent' => '<p>The first 8,000 characters written by the plugin to <code>stderr</code>. If the command hasn\'t finished running, then this string is empty.</p>', ], ], 'StandardOutputContent' => [ 'base' => NULL, 'refs' => [ 'GetCommandInvocationResult$StandardOutputContent' => '<p>The first 24,000 characters written by the plugin to <code>stdout</code>. If the command hasn\'t finished running, if <code>ExecutionStatus</code> is neither Succeeded nor Failed, then this string is empty.</p>', ], ], 'StartAssociationsOnceRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAssociationsOnceResult' => [ 'base' => NULL, 'refs' => [], ], 'StartAutomationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAutomationExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'StartChangeRequestExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartChangeRequestExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'StartSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatusAdditionalInfo' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$AdditionalInfo' => '<p>A user-defined string.</p>', ], ], 'StatusDetails' => [ 'base' => NULL, 'refs' => [ 'Command$StatusDetails' => '<p>A detailed status of the command execution. <code>StatusDetails</code> includes more information than <code>Status</code> because it includes states resulting from error and concurrency control parameters. <code>StatusDetails</code> can show different results than Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command hasn\'t been sent to any managed nodes.</p> </li> <li> <p>In Progress: The command has been sent to at least one managed node but hasn\'t reached a final state on all managed nodes.</p> </li> <li> <p>Success: The command successfully ran on all invocations. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of Delivery Timed Out. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: The value of MaxErrors or more command invocations shows a status of Execution Timed Out. This is a terminal state.</p> </li> <li> <p>Failed: The value of MaxErrors or more command invocations shows a status of Failed. This is a terminal state.</p> </li> <li> <p>Incomplete: The command was attempted on all managed nodes and one or more invocations doesn\'t have a value of Success but not enough invocations failed for the status to be Failed. This is a terminal state.</p> </li> <li> <p>Cancelled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Rate Exceeded: The number of managed nodes targeted by the command exceeded the account limit for pending invocations. The system has canceled the command before running it on any managed node. This is a terminal state.</p> </li> </ul>', 'CommandInvocation$StatusDetails' => '<p>A detailed status of the command execution for each invocation (each managed node targeted by the command). StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command hasn\'t been sent to the managed node.</p> </li> <li> <p>In Progress: The command has been sent to the managed node but hasn\'t reached a terminal state.</p> </li> <li> <p>Success: The execution of the command or plugin was successfully completed. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The command wasn\'t delivered to the managed node before the delivery timeout expired. Delivery timeouts don\'t count against the parent command\'s <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: Command execution started on the managed node, but the execution wasn\'t complete before the execution timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li> <li> <p>Failed: The command wasn\'t successful on the managed node. For a plugin, this indicates that the result code wasn\'t zero. For a command invocation, this indicates that the result code for one or more plugins wasn\'t zero. Invocation failures count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li> <li> <p>Cancelled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Undeliverable: The command can\'t be delivered to the managed node. The managed node might not exist or might not be responding. Undeliverable invocations don\'t count against the parent command\'s MaxErrors limit and don\'t contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li> </ul>', 'CommandPlugin$StatusDetails' => '<p>A detailed status of the plugin execution. <code>StatusDetails</code> includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command hasn\'t been sent to the managed node.</p> </li> <li> <p>In Progress: The command has been sent to the managed node but hasn\'t reached a terminal state.</p> </li> <li> <p>Success: The execution of the command or plugin was successfully completed. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The command wasn\'t delivered to the managed node before the delivery timeout expired. Delivery timeouts don\'t count against the parent command\'s <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: Command execution started on the managed node, but the execution wasn\'t complete before the execution timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li> <li> <p>Failed: The command wasn\'t successful on the managed node. For a plugin, this indicates that the result code wasn\'t zero. For a command invocation, this indicates that the result code for one or more plugins wasn\'t zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Cancelled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Undeliverable: The command can\'t be delivered to the managed node. The managed node might not exist, or it might not be responding. Undeliverable invocations don\'t count against the parent command\'s MaxErrors limit, and they don\'t contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li> </ul>', 'GetCommandInvocationResult$StatusDetails' => '<p>A detailed status of the command execution for an invocation. <code>StatusDetails</code> includes more information than <code>Status</code> because it includes states resulting from error and concurrency control parameters. <code>StatusDetails</code> can show different results than <code>Status</code>. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. <code>StatusDetails</code> can be one of the following values:</p> <ul> <li> <p>Pending: The command hasn\'t been sent to the managed node.</p> </li> <li> <p>In Progress: The command has been sent to the managed node but hasn\'t reached a terminal state.</p> </li> <li> <p>Delayed: The system attempted to send the command to the target, but the target wasn\'t available. The managed node might not be available because of network issues, because the node was stopped, or for similar reasons. The system will try to send the command again.</p> </li> <li> <p>Success: The command or plugin ran successfully. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The command wasn\'t delivered to the managed node before the delivery timeout expired. Delivery timeouts don\'t count against the parent command\'s <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: The command started to run on the managed node, but the execution wasn\'t complete before the timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li> <li> <p>Failed: The command wasn\'t run successfully on the managed node. For a plugin, this indicates that the result code wasn\'t zero. For a command invocation, this indicates that the result code for one or more plugins wasn\'t zero. Invocation failures count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li> <li> <p>Cancelled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Undeliverable: The command can\'t be delivered to the managed node. The node might not exist or might not be responding. Undeliverable invocations don\'t count against the parent command\'s <code>MaxErrors</code> limit and don\'t contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Terminated: The parent command exceeded its <code>MaxErrors</code> limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li> </ul>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$Message' => '<p>The reason for the status.</p>', ], ], 'StatusName' => [ 'base' => NULL, 'refs' => [ 'AssociationExecution$Status' => '<p>The status of the association execution.</p>', 'AssociationExecution$DetailedStatus' => '<p>Detailed status information about the execution.</p>', 'AssociationExecutionTarget$Status' => '<p>The association execution status.</p>', 'AssociationExecutionTarget$DetailedStatus' => '<p>Detailed information about the execution status.</p>', 'AssociationOverview$Status' => '<p>The status of the association. Status can be: Pending, Success, or Failed.</p>', 'AssociationOverview$DetailedStatus' => '<p>A detailed status of the association.</p>', 'AssociationStatusAggregatedCount$key' => NULL, 'InstanceAggregatedAssociationOverview$DetailedStatus' => '<p>Detailed status information about the aggregated associations.</p>', 'InstanceAssociationStatusAggregatedCount$key' => NULL, 'InstanceAssociationStatusInfo$Status' => '<p>Status information about the association.</p>', 'InstanceAssociationStatusInfo$DetailedStatus' => '<p>Detailed status information about the association.</p>', 'InstanceInformation$AssociationStatus' => '<p>The status of the association.</p>', ], ], 'StatusUnchanged' => [ 'base' => '<p>The updated status is the same as the current status.</p>', 'refs' => [], ], 'StepExecution' => [ 'base' => '<p>Detailed information about an the execution state of an Automation step.</p>', 'refs' => [ 'StepExecutionList$member' => NULL, ], ], 'StepExecutionFilter' => [ 'base' => '<p>A filter to limit the amount of step execution information returned by the call.</p>', 'refs' => [ 'StepExecutionFilterList$member' => NULL, ], ], 'StepExecutionFilterKey' => [ 'base' => NULL, 'refs' => [ 'StepExecutionFilter$Key' => '<p>One or more keys to limit the results. Valid filter keys include the following: StepName, Action, StepExecutionId, StepExecutionStatus, StartTimeBefore, StartTimeAfter.</p>', ], ], 'StepExecutionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAutomationStepExecutionsRequest$Filters' => '<p>One or more filters to limit the number of step executions returned by the request.</p>', ], ], 'StepExecutionFilterValue' => [ 'base' => NULL, 'refs' => [ 'StepExecutionFilterValueList$member' => NULL, ], ], 'StepExecutionFilterValueList' => [ 'base' => NULL, 'refs' => [ 'StepExecutionFilter$Values' => '<p>The values of the filter key.</p>', ], ], 'StepExecutionList' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$StepExecutions' => '<p>A list of details about the current state of all steps that comprise an execution. An Automation runbook contains a list of steps that are run in order.</p>', 'DescribeAutomationStepExecutionsResult$StepExecutions' => '<p>A list of details about the current state of all steps that make up an execution.</p>', ], ], 'StopAutomationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopAutomationExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'StopType' => [ 'base' => NULL, 'refs' => [ 'StopAutomationExecutionRequest$Type' => '<p>The stop request type. Valid types include the following: Cancel and Complete. The default type is Cancel.</p>', ], ], 'StreamUrl' => [ 'base' => NULL, 'refs' => [ 'ResumeSessionResponse$StreamUrl' => '<p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the managed node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>.</p> <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p> <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>', 'StartSessionResponse$StreamUrl' => '<p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code> </p> <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p> <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AlreadyExistsException$Message' => NULL, 'AssociationDoesNotExist$Message' => NULL, 'AssociationExecutionDoesNotExist$Message' => NULL, 'AssociationVersionLimitExceeded$Message' => NULL, 'AutomationDefinitionNotApprovedException$Message' => NULL, 'AutomationDefinitionNotFoundException$Message' => NULL, 'AutomationDefinitionVersionNotFoundException$Message' => NULL, 'AutomationExecution$FailureMessage' => '<p>A message describing why an execution has failed, if the status is set to Failed.</p>', 'AutomationExecution$ExecutedBy' => '<p>The Amazon Resource Name (ARN) of the user who ran the automation.</p>', 'AutomationExecution$CurrentStepName' => '<p>The name of the step that is currently running.</p>', 'AutomationExecution$CurrentAction' => '<p>The action of the step that is currently running.</p>', 'AutomationExecution$Target' => '<p>The target of the execution.</p>', 'AutomationExecution$OpsItemId' => '<p>The ID of an OpsItem that is created to represent a Change Manager change request.</p>', 'AutomationExecution$AssociationId' => '<p>The ID of a State Manager association used in the Automation operation.</p>', 'AutomationExecutionLimitExceededException$Message' => NULL, 'AutomationExecutionMetadata$ExecutedBy' => '<p>The IAM role ARN of the user who ran the automation.</p>', 'AutomationExecutionMetadata$LogFile' => '<p>An S3 bucket where execution information is stored.</p>', 'AutomationExecutionMetadata$CurrentStepName' => '<p>The name of the step that is currently running.</p>', 'AutomationExecutionMetadata$CurrentAction' => '<p>The action of the step that is currently running.</p>', 'AutomationExecutionMetadata$FailureMessage' => '<p>The list of execution outputs as defined in the Automation runbook.</p>', 'AutomationExecutionMetadata$Target' => '<p>The list of execution outputs as defined in the Automation runbook.</p>', 'AutomationExecutionMetadata$OpsItemId' => '<p>The ID of an OpsItem that is created to represent a Change Manager change request.</p>', 'AutomationExecutionMetadata$AssociationId' => '<p>The ID of a State Manager association used in the Automation operation.</p>', 'AutomationExecutionNotFoundException$Message' => NULL, 'AutomationStepNotFoundException$Message' => NULL, 'ComplianceTypeCountLimitExceededException$Message' => NULL, 'CreateOpsItemResponse$OpsItemId' => '<p>The ID of the OpsItem.</p>', 'CustomSchemaCountLimitExceededException$Message' => NULL, 'DescribeOpsItemsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'DescribeOpsItemsResponse$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'DocumentAlreadyExists$Message' => NULL, 'DocumentLimitExceeded$Message' => NULL, 'DocumentPermissionLimit$Message' => NULL, 'DocumentVersionLimitExceeded$Message' => NULL, 'DoesNotExistException$Message' => NULL, 'DuplicateDocumentContent$Message' => NULL, 'DuplicateDocumentVersionName$Message' => NULL, 'FailureDetails$FailureStage' => '<p>The stage of the Automation execution when the failure occurred. The stages include the following: InputValidation, PreVerification, Invocation, PostVerification.</p>', 'FailureDetails$FailureType' => '<p>The type of Automation failure. Failure types include the following: Action, Permission, Throttling, Verification, Internal.</p>', 'FeatureNotAvailableException$Message' => NULL, 'HierarchyLevelLimitExceededException$message' => '<p>A hierarchy can have a maximum of 15 levels. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">Requirements and constraints for parameter names</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>', 'HierarchyTypeMismatchException$message' => '<p>Parameter Store doesn\'t support changing a parameter type in a hierarchy. For example, you can\'t change a parameter from a <code>String</code> type to a <code>SecureString</code> type. You must create a new, unique parameter.</p>', 'IdempotentParameterMismatch$Message' => NULL, 'IncompatiblePolicyException$message' => NULL, 'InstanceInformation$PlatformName' => '<p>The name of the operating system platform running on your managed node. </p>', 'InstanceInformation$PlatformVersion' => '<p>The version of the OS platform running on your managed node. </p>', 'InstanceInformation$Name' => '<p>The name assigned to an on-premises server, edge device, or virtual machine (VM) when it is activated as a Systems Manager managed node. The name is specified as the <code>DefaultInstanceName</code> property using the <a>CreateActivation</a> command. It is applied to the managed node by specifying the Activation Code and Activation ID when you install SSM Agent on the node, as explained in <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-linux.html">Install SSM Agent for a hybrid environment (Linux)</a> and <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-win.html">Install SSM Agent for a hybrid environment (Windows)</a>. To retrieve the <code>Name</code> tag of an EC2 instance, use the Amazon EC2 <code>DescribeInstances</code> operation. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> in the <i>Amazon EC2 API Reference</i> or <a href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances</a> in the <i>Amazon Web Services CLI Command Reference</i>.</p>', 'InternalServerError$Message' => NULL, 'InvalidActivation$Message' => NULL, 'InvalidActivationId$Message' => NULL, 'InvalidAggregatorException$Message' => NULL, 'InvalidAllowedPatternException$message' => '<p>The request doesn\'t meet the regular expression requirement.</p>', 'InvalidAssociation$Message' => NULL, 'InvalidAssociationVersion$Message' => NULL, 'InvalidAutomationExecutionParametersException$Message' => NULL, 'InvalidAutomationSignalException$Message' => NULL, 'InvalidAutomationStatusUpdateException$Message' => NULL, 'InvalidDeleteInventoryParametersException$Message' => NULL, 'InvalidDeletionIdException$Message' => NULL, 'InvalidDocument$Message' => '<p>The SSM document doesn\'t exist or the document isn\'t available to the user. This exception can be issued by various API operations. </p>', 'InvalidDocumentContent$Message' => '<p>A description of the validation error.</p>', 'InvalidDocumentOperation$Message' => NULL, 'InvalidDocumentSchemaVersion$Message' => NULL, 'InvalidDocumentType$Message' => NULL, 'InvalidDocumentVersion$Message' => NULL, 'InvalidFilter$Message' => NULL, 'InvalidFilterOption$message' => '<p>The specified filter option isn\'t valid. Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.</p>', 'InvalidFilterValue$Message' => NULL, 'InvalidInstanceId$Message' => NULL, 'InvalidInstanceInformationFilterValue$message' => NULL, 'InvalidInventoryGroupException$Message' => NULL, 'InvalidInventoryItemContextException$Message' => NULL, 'InvalidInventoryRequestException$Message' => NULL, 'InvalidItemContentException$Message' => NULL, 'InvalidKeyId$message' => NULL, 'InvalidNextToken$Message' => NULL, 'InvalidNotificationConfig$Message' => NULL, 'InvalidOptionException$Message' => NULL, 'InvalidParameters$Message' => NULL, 'InvalidPermissionType$Message' => NULL, 'InvalidPolicyAttributeException$message' => NULL, 'InvalidPolicyTypeException$message' => NULL, 'InvalidResultAttributeException$Message' => NULL, 'InvalidRole$Message' => NULL, 'InvalidSchedule$Message' => NULL, 'InvalidTarget$Message' => NULL, 'InvalidTypeNameException$Message' => NULL, 'InvalidUpdate$Message' => NULL, 'ItemContentMismatchException$Message' => NULL, 'ItemSizeLimitExceededException$Message' => NULL, 'ListOpsItemEventsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListOpsItemEventsResponse$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results. </p>', 'ListOpsItemRelatedItemsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListOpsItemRelatedItemsResponse$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'MaxDocumentSizeExceeded$Message' => NULL, 'NormalStringMap$key' => NULL, 'NormalStringMap$value' => NULL, 'OpsItem$CreatedBy' => '<p>The ARN of the Amazon Web Services account that created the OpsItem.</p>', 'OpsItem$LastModifiedBy' => '<p>The ARN of the Amazon Web Services account that last updated the OpsItem.</p>', 'OpsItem$Version' => '<p>The version of this OpsItem. Each time the OpsItem is edited the version number increments by one.</p>', 'OpsItemAlreadyExistsException$Message' => NULL, 'OpsItemAlreadyExistsException$OpsItemId' => NULL, 'OpsItemEventSummary$OpsItemId' => '<p>The ID of the OpsItem.</p>', 'OpsItemEventSummary$EventId' => '<p>The ID of the OpsItem event.</p>', 'OpsItemEventSummary$Source' => '<p>The source of the OpsItem event.</p>', 'OpsItemEventSummary$DetailType' => '<p>The type of information provided as a detail.</p>', 'OpsItemEventSummary$Detail' => '<p>Specific information about the OpsItem event.</p>', 'OpsItemIdentity$Arn' => '<p>The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem event.</p>', 'OpsItemInvalidParameterException$Message' => NULL, 'OpsItemLimitExceededException$LimitType' => NULL, 'OpsItemLimitExceededException$Message' => NULL, 'OpsItemNotFoundException$Message' => NULL, 'OpsItemNotification$Arn' => '<p>The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where notifications are sent when this OpsItem is edited or changed.</p>', 'OpsItemOpsDataKeysList$member' => NULL, 'OpsItemParameterNamesList$member' => NULL, 'OpsItemRelatedItemAlreadyExistsException$Message' => NULL, 'OpsItemRelatedItemAssociationNotFoundException$Message' => NULL, 'OpsItemSummary$CreatedBy' => '<p>The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.</p>', 'OpsItemSummary$LastModifiedBy' => '<p>The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.</p>', 'OpsMetadata$LastModifiedUser' => '<p>The user name who last updated the OpsMetadata object.</p>', 'OpsMetadataAlreadyExistsException$message' => NULL, 'OpsMetadataInvalidArgumentException$message' => NULL, 'OpsMetadataKeyLimitExceededException$message' => NULL, 'OpsMetadataLimitExceededException$message' => NULL, 'OpsMetadataNotFoundException$message' => NULL, 'OpsMetadataTooManyUpdatesException$message' => NULL, 'Parameter$SourceResult' => '<p>Applies to parameters that reference information in other Amazon Web Services services. <code>SourceResult</code> is the raw result or response from the source.</p>', 'Parameter$ARN' => '<p>The Amazon Resource Name (ARN) of the parameter.</p>', 'ParameterAlreadyExists$message' => NULL, 'ParameterHistory$LastModifiedUser' => '<p>Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.</p>', 'ParameterInlinePolicy$PolicyText' => '<p>The JSON text of the policy.</p>', 'ParameterInlinePolicy$PolicyType' => '<p>The type of policy. Parameter Store, a capability of Amazon Web Services Systems Manager, supports the following policy types: Expiration, ExpirationNotification, and NoChangeNotification. </p>', 'ParameterInlinePolicy$PolicyStatus' => '<p>The status of the policy. Policies report the following statuses: Pending (the policy hasn\'t been enforced or applied yet), Finished (the policy was applied), Failed (the policy wasn\'t applied), or InProgress (the policy is being applied now). </p>', 'ParameterLimitExceeded$message' => NULL, 'ParameterMaxVersionLimitExceeded$message' => NULL, 'ParameterMetadata$LastModifiedUser' => '<p>Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.</p>', 'ParameterNotFound$message' => NULL, 'ParameterPatternMismatchException$message' => '<p>The parameter name isn\'t valid.</p>', 'ParameterVersionLabelLimitExceeded$message' => NULL, 'ParameterVersionNotFound$message' => NULL, 'PoliciesLimitExceededException$message' => NULL, 'RelatedOpsItem$OpsItemId' => '<p>The ID of an OpsItem related to the current OpsItem.</p>', 'ResourceDataSyncConflictException$Message' => NULL, 'ResourceDataSyncCountExceededException$Message' => NULL, 'ResourceDataSyncInvalidConfigurationException$Message' => NULL, 'ResourceDataSyncNotFoundException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceLimitExceededException$Message' => NULL, 'ServiceSetting$LastModifiedUser' => '<p>The ARN of the last modified user. This field is populated only if the setting value was overwritten.</p>', 'ServiceSetting$ARN' => '<p>The ARN of the service setting.</p>', 'ServiceSetting$Status' => '<p>The status of the service setting. The value can be Default, Customized or PendingUpdate.</p> <ul> <li> <p>Default: The current setting uses a default value provisioned by the Amazon Web Services service team.</p> </li> <li> <p>Customized: The current setting use a custom value specified by the customer.</p> </li> <li> <p>PendingUpdate: The current setting uses a default or custom value, but a setting change request is pending approval.</p> </li> </ul>', 'ServiceSettingNotFound$Message' => NULL, 'StepExecution$StepName' => '<p>The name of this execution step.</p>', 'StepExecution$OnFailure' => '<p>The action to take if the step fails. The default value is <code>Abort</code>.</p>', 'StepExecution$ResponseCode' => '<p>The response code returned by the execution of the step.</p>', 'StepExecution$Response' => '<p>A message associated with the response code for an execution.</p>', 'StepExecution$FailureMessage' => '<p>If a step failed, this message explains why the execution failed.</p>', 'StepExecution$StepExecutionId' => '<p>The unique ID of a step execution.</p>', 'StepExecution$NextStep' => '<p>The next step after the step succeeds.</p>', 'StringList$member' => NULL, 'SubTypeCountLimitExceededException$Message' => NULL, 'TargetInUseException$Message' => NULL, 'TargetNotConnected$Message' => NULL, 'TooManyUpdates$Message' => NULL, 'TotalSizeLimitExceededException$Message' => NULL, 'UnsupportedCalendarException$Message' => NULL, 'UnsupportedFeatureRequiredException$Message' => NULL, 'UnsupportedInventoryItemContextException$Message' => NULL, 'UnsupportedInventorySchemaVersionException$Message' => NULL, 'UnsupportedOperatingSystem$Message' => NULL, 'UnsupportedParameterType$message' => NULL, 'UnsupportedPlatformType$Message' => NULL, ], ], 'StringDateTime' => [ 'base' => NULL, 'refs' => [ 'GetCommandInvocationResult$ExecutionStartDateTime' => '<p>The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedBefore</code> filter.</p> <p> <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code> </p> <p>If the plugin hasn\'t started to run, the string is empty.</p>', 'GetCommandInvocationResult$ExecutionElapsedTime' => '<p>Duration since <code>ExecutionStartDateTime</code>.</p>', 'GetCommandInvocationResult$ExecutionEndDateTime' => '<p>The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedAfter</code> filter.</p> <p> <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code> </p> <p>If the plugin hasn\'t started to run, the string is empty.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsFilter$FilterValues' => '<p>The filter values.</p>', ], ], 'SubTypeCountLimitExceededException' => [ 'base' => '<p>The sub-type count exceeded the limit for the inventory type.</p>', 'refs' => [], ], 'Tag' => [ 'base' => '<p>Metadata that you assign to your Amazon Web Services resources. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. In Amazon Web Services Systems Manager, you can apply tags to Systems Manager documents (SSM documents), managed nodes, maintenance windows, parameters, patch baselines, OpsItems, and OpsMetadata.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'KeyList$member' => NULL, 'Tag$Key' => '<p>The name of the tag.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'Activation$Tags' => '<p>Tags assigned to the activation.</p>', 'AddTagsToResourceRequest$Tags' => '<p>One or more tags. The value parameter is required.</p> <important> <p>Don\'t enter personally identifiable information in this field.</p> </important>', 'CreateActivationRequest$Tags' => '<p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify the following key-value pairs:</p> <ul> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> <li> <p> <code>Key=Environment,Value=Production</code> </p> </li> </ul> <important> <p>When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises servers or VMs.</p> </important> <p>You can\'t add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For information about how to remove tags from your managed nodes, see <a>RemoveTagsFromResource</a>.</p>', 'CreateDocumentRequest$Tags' => '<p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the types of targets or the environment where it will run. In this case, you could specify the following key-value pairs:</p> <ul> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> <li> <p> <code>Key=Environment,Value=Production</code> </p> </li> </ul> <note> <p>To add tags to an existing SSM document, use the <a>AddTagsToResource</a> operation.</p> </note>', 'CreateMaintenanceWindowRequest$Tags' => '<p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a maintenance window to identify the type of tasks it will run, the types of targets, and the environment it will run in. In this case, you could specify the following key-value pairs:</p> <ul> <li> <p> <code>Key=TaskType,Value=AgentUpdate</code> </p> </li> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> <li> <p> <code>Key=Environment,Value=Production</code> </p> </li> </ul> <note> <p>To add tags to an existing maintenance window, use the <a>AddTagsToResource</a> operation.</p> </note>', 'CreateOpsItemRequest$Tags' => '<p>Optional metadata that you assign to a resource. You can restrict access to OpsItems by using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <p>Tags use a key-value pair. For example:</p> <p> <code>Key=Department,Value=Finance</code> </p> <important> <p>To add tags to a new OpsItem, a user must have IAM permissions for both the <code>ssm:CreateOpsItems</code> operation and the <code>ssm:AddTagsToResource</code> operation. To add tags to an existing OpsItem, use the <a>AddTagsToResource</a> operation.</p> </important>', 'CreateOpsMetadataRequest$Tags' => '<p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for an OpsMetadata object. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an OpsMetadata object to identify an environment or target Amazon Web Services Region. In this case, you could specify the following key-value pairs:</p> <ul> <li> <p> <code>Key=Environment,Value=Production</code> </p> </li> <li> <p> <code>Key=Region,Value=us-east-2</code> </p> </li> </ul>', 'CreatePatchBaselineRequest$Tags' => '<p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify the severity level of patches it specifies and the operating system family it applies to. In this case, you could specify the following key-value pairs:</p> <ul> <li> <p> <code>Key=PatchSeverity,Value=Critical</code> </p> </li> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> </ul> <note> <p>To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> operation.</p> </note>', 'DocumentDescription$Tags' => '<p>The tags, or metadata, that have been applied to the document.</p>', 'DocumentIdentifier$Tags' => '<p>The tags, or metadata, that have been applied to the document.</p>', 'ListTagsForResourceResult$TagList' => '<p>A list of tags.</p>', 'PutParameterRequest$Tags' => '<p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a Systems Manager parameter to identify the type of resource to which it applies, the environment, or the type of configuration data referenced by the parameter. In this case, you could specify the following key-value pairs:</p> <ul> <li> <p> <code>Key=Resource,Value=S3bucket</code> </p> </li> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> <li> <p> <code>Key=ParameterType,Value=LicenseKey</code> </p> </li> </ul> <note> <p>To add tags to an existing Systems Manager parameter, use the <a>AddTagsToResource</a> operation.</p> </note>', 'StartAutomationExecutionRequest$Tags' => '<p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for an automation. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an automation to identify an environment or operating system. In this case, you could specify the following key-value pairs:</p> <ul> <li> <p> <code>Key=environment,Value=test</code> </p> </li> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> </ul> <note> <p>To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> operation.</p> </note>', 'StartChangeRequestExecutionRequest$Tags' => '<p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change request. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a change request to identify an environment or target Amazon Web Services Region. In this case, you could specify the following key-value pairs:</p> <ul> <li> <p> <code>Key=Environment,Value=Production</code> </p> </li> <li> <p> <code>Key=Region,Value=us-east-2</code> </p> </li> </ul>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'Target' => [ 'base' => '<p>An array of search criteria that targets managed nodes using a key-value pair that you specify.</p> <note> <p> One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don\'t specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> </note> <p>Supported formats include the following.</p> <ul> <li> <p> <code>Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;,&lt;instance-id-3&gt;</code> </p> </li> <li> <p> <code>Key=tag:&lt;my-tag-key&gt;,Values=&lt;my-tag-value-1&gt;,&lt;my-tag-value-2&gt;</code> </p> </li> <li> <p> <code>Key=tag-key,Values=&lt;my-tag-key-1&gt;,&lt;my-tag-key-2&gt;</code> </p> </li> <li> <p> <b>Run Command and Maintenance window targets only</b>: <code>Key=resource-groups:Name,Values=&lt;resource-group-name&gt;</code> </p> </li> <li> <p> <b>Maintenance window targets only</b>: <code>Key=resource-groups:ResourceTypeFilters,Values=&lt;resource-type-1&gt;,&lt;resource-type-2&gt;</code> </p> </li> <li> <p> <b>Automation targets only</b>: <code>Key=ResourceGroup;Values=&lt;resource-group-name&gt;</code> </p> </li> </ul> <p>For example:</p> <ul> <li> <p> <code>Key=InstanceIds,Values=i-02573cafcfEXAMPLE,i-0471e04240EXAMPLE,i-07782c72faEXAMPLE</code> </p> </li> <li> <p> <code>Key=tag:CostCenter,Values=CostCenter1,CostCenter2,CostCenter3</code> </p> </li> <li> <p> <code>Key=tag-key,Values=Name,Instance-Type,CostCenter</code> </p> </li> <li> <p> <b>Run Command and Maintenance window targets only</b>: <code>Key=resource-groups:Name,Values=ProductionResourceGroup</code> </p> <p>This example demonstrates how to target all resources in the resource group <b>ProductionResourceGroup</b> in your maintenance window.</p> </li> <li> <p> <b>Maintenance window targets only</b>: <code>Key=resource-groups:ResourceTypeFilters,Values=AWS::EC2::INSTANCE,AWS::EC2::VPC</code> </p> <p>This example demonstrates how to target only Amazon Elastic Compute Cloud (Amazon EC2) instances and VPCs in your maintenance window.</p> </li> <li> <p> <b>Automation targets only</b>: <code>Key=ResourceGroup,Values=MyResourceGroup</code> </p> </li> <li> <p> <b>State Manager association targets only</b>: <code>Key=InstanceIds,Values=*</code> </p> <p>This example demonstrates how to target all managed instances in the Amazon Web Services Region where the association was created.</p> </li> </ul> <p>For more information about how to send commands that target managed nodes using <code>Key,Value</code> parameters, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-targeting">Targeting multiple instances</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'refs' => [ 'Targets$member' => NULL, ], ], 'TargetCount' => [ 'base' => NULL, 'refs' => [ 'Command$TargetCount' => '<p>The number of targets for the command.</p>', ], ], 'TargetInUseException' => [ 'base' => '<p>You specified the <code>Safe</code> option for the DeregisterTargetFromMaintenanceWindow operation, but the target is still referenced in a task.</p>', 'refs' => [], ], 'TargetKey' => [ 'base' => NULL, 'refs' => [ 'Target$Key' => '<p>User-defined criteria for sending commands that target managed nodes that meet the criteria.</p>', ], ], 'TargetLocation' => [ 'base' => '<p>The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation execution.</p>', 'refs' => [ 'StepExecution$TargetLocation' => '<p>The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation execution.</p>', 'TargetLocations$member' => NULL, ], ], 'TargetLocations' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$TargetLocations' => '<p>The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the association.</p>', 'AssociationVersionInfo$TargetLocations' => '<p>The combination of Amazon Web Services Regions and Amazon Web Services accounts where you wanted to run the association when this association version was created.</p>', 'AutomationExecution$TargetLocations' => '<p>The combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the Automation.</p>', 'CreateAssociationBatchRequestEntry$TargetLocations' => '<p>Use this action to create an association in multiple Regions and multiple accounts.</p>', 'CreateAssociationRequest$TargetLocations' => '<p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the association. Use this action to create an association in multiple Regions and multiple accounts.</p>', 'Runbook$TargetLocations' => '<p>Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Runbook operation.</p>', 'StartAutomationExecutionRequest$TargetLocations' => '<p>A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the automation. Use this operation to start an automation in multiple Amazon Web Services Regions and multiple Amazon Web Services accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>', 'UpdateAssociationRequest$TargetLocations' => '<p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the association. Use this action to update an association in multiple Regions and multiple accounts.</p>', ], ], 'TargetMap' => [ 'base' => NULL, 'refs' => [ 'TargetMaps$member' => NULL, ], ], 'TargetMapKey' => [ 'base' => NULL, 'refs' => [ 'TargetMap$key' => NULL, ], ], 'TargetMapValue' => [ 'base' => NULL, 'refs' => [ 'TargetMapValueList$member' => NULL, ], ], 'TargetMapValueList' => [ 'base' => NULL, 'refs' => [ 'TargetMap$value' => NULL, ], ], 'TargetMaps' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$TargetMaps' => '<p>The specified key-value mapping of document parameters to target resources.</p>', 'AutomationExecutionMetadata$TargetMaps' => '<p>The specified key-value mapping of document parameters to target resources.</p>', 'StartAutomationExecutionRequest$TargetMaps' => '<p>A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can\'t be specified together.</p>', ], ], 'TargetNotConnected' => [ 'base' => '<p>The specified target managed node for the session isn\'t fully configured for use with Session Manager. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-getting-started.html">Getting started with Session Manager</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. This error is also returned if you attempt to start a session on a managed node that is located in a different account or Region</p>', 'refs' => [], ], 'TargetParameterList' => [ 'base' => NULL, 'refs' => [ 'ResolvedTargets$ParameterValues' => '<p>A list of parameter values sent to targets that resolved during the Automation execution.</p>', ], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$TargetType' => '<p>Specify a target type to define the kinds of resources the document can run on. For example, to run a document on EC2 instances, specify the following value: <code>/AWS::EC2::Instance</code>. If you specify a value of \'/\' the document can run on all types of resources. If you don\'t specify a value, the document can\'t run on any resources. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>. </p>', 'DocumentDescription$TargetType' => '<p>The target type which defines the kinds of resources the document can run on. For example, <code>/AWS::EC2::Instance</code>. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>. </p>', 'DocumentIdentifier$TargetType' => '<p>The target type which defines the kinds of resources the document can run on. For example, <code>/AWS::EC2::Instance</code>. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>. </p>', 'UpdateDocumentRequest$TargetType' => '<p>Specify a new target type for the document.</p>', ], ], 'TargetValue' => [ 'base' => NULL, 'refs' => [ 'TargetValues$member' => NULL, ], ], 'TargetValues' => [ 'base' => NULL, 'refs' => [ 'Target$Values' => '<p>User-defined criteria that maps to <code>Key</code>. For example, if you specified <code>tag:ServerRole</code>, you could specify <code>value:WebServer</code> to run a command on instances that include EC2 tags of <code>ServerRole,WebServer</code>. </p> <p>Depending on the type of target, the maximum number of values for a key might be lower than the global maximum of 50.</p>', ], ], 'Targets' => [ 'base' => NULL, 'refs' => [ 'Association$Targets' => '<p>The managed nodes targeted by the request to create an association. You can target all managed nodes in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of <code>*</code>.</p>', 'AssociationDescription$Targets' => '<p>The managed nodes targeted by the request. </p>', 'AssociationVersionInfo$Targets' => '<p>The targets specified for the association when the association version was created. </p>', 'AutomationExecution$Targets' => '<p>The specified targets.</p>', 'AutomationExecutionMetadata$Targets' => '<p>The targets defined by the user when starting the automation.</p>', 'Command$Targets' => '<p>An array of search criteria that targets managed nodes using a Key,Value combination that you specify. Targets is required if you don\'t provide one or more managed node IDs in the call.</p>', 'CreateAssociationBatchRequestEntry$Targets' => '<p>The managed nodes targeted by the request.</p>', 'CreateAssociationRequest$Targets' => '<p>The targets for the association. You can target managed nodes by using tags, Amazon Web Services resource groups, all managed nodes in an Amazon Web Services account, or individual managed node IDs. You can target all managed nodes in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of <code>*</code>. For more information about choosing targets for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html">Using targets and rate controls with State Manager associations</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'DescribeMaintenanceWindowScheduleRequest$Targets' => '<p>The managed node ID or key-value pair to retrieve information about.</p>', 'DescribeMaintenanceWindowsForTargetRequest$Targets' => '<p>The managed node ID or key-value pair to retrieve information about.</p>', 'GetMaintenanceWindowTaskResult$Targets' => '<p>The targets where the task should run.</p>', 'MaintenanceWindowTarget$Targets' => '<p>The targets, either managed nodes or tags.</p> <p>Specify managed nodes using the following format:</p> <p> <code>Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;</code> </p> <p>Tags are specified using the following format:</p> <p> <code>Key=&lt;tag name&gt;,Values=&lt;tag value&gt;</code>.</p>', 'MaintenanceWindowTask$Targets' => '<p>The targets (either managed nodes or tags). Managed nodes are specified using <code>Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;</code>. Tags are specified using <code>Key=&lt;tag name&gt;,Values=&lt;tag value&gt;</code>.</p>', 'RegisterTargetWithMaintenanceWindowRequest$Targets' => '<p>The targets to register with the maintenance window. In other words, the managed nodes to run commands on when the maintenance window runs.</p> <note> <p>If a single maintenance window task is registered with multiple targets, its task invocations occur sequentially and not in parallel. If your task must run on multiple targets at the same time, register a task for each target individually and assign each task the same priority level.</p> </note> <p>You can specify targets using managed node IDs, resource group names, or tags that have been applied to managed nodes.</p> <p> <b>Example 1</b>: Specify managed node IDs</p> <p> <code>Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;,&lt;instance-id-3&gt;</code> </p> <p> <b>Example 2</b>: Use tag key-pairs applied to managed nodes</p> <p> <code>Key=tag:&lt;my-tag-key&gt;,Values=&lt;my-tag-value-1&gt;,&lt;my-tag-value-2&gt;</code> </p> <p> <b>Example 3</b>: Use tag-keys applied to managed nodes</p> <p> <code>Key=tag-key,Values=&lt;my-tag-key-1&gt;,&lt;my-tag-key-2&gt;</code> </p> <p> <b>Example 4</b>: Use resource group names</p> <p> <code>Key=resource-groups:Name,Values=&lt;resource-group-name&gt;</code> </p> <p> <b>Example 5</b>: Use filters for resource group types</p> <p> <code>Key=resource-groups:ResourceTypeFilters,Values=&lt;resource-type-1&gt;,&lt;resource-type-2&gt;</code> </p> <note> <p>For <code>Key=resource-groups:ResourceTypeFilters</code>, specify resource types in the following format</p> <p> <code>Key=resource-groups:ResourceTypeFilters,Values=AWS::EC2::INSTANCE,AWS::EC2::VPC</code> </p> </note> <p>For more information about these examples formats, including the best use case for each one, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html">Examples: Register targets with a maintenance window</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Targets' => '<p>The targets (either managed nodes or maintenance window targets).</p> <note> <p>One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don\'t specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> </note> <p>Specify managed nodes using the following format: </p> <p> <code>Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;</code> </p> <p>Specify maintenance window targets using the following format:</p> <p> <code>Key=WindowTargetIds,Values=&lt;window-target-id-1&gt;,&lt;window-target-id-2&gt;</code> </p>', 'Runbook$Targets' => '<p>A key-value mapping to target resources that the runbook operation performs tasks on. Required if you specify <code>TargetParameterName</code>.</p>', 'SendCommandRequest$Targets' => '<p>An array of search criteria that targets managed nodes using a <code>Key,Value</code> combination that you specify. Specifying targets is most useful when you want to send a command to a large number of managed nodes at once. Using <code>Targets</code>, which accepts tag key-value pairs to identify managed nodes, you can send a command to tens, hundreds, or thousands of nodes at once.</p> <p>To send a command to a smaller number of managed nodes, you can use the <code>InstanceIds</code> option instead.</p> <p>For more information about how to use targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending commands to a fleet</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'StartAutomationExecutionRequest$Targets' => '<p>A key-value mapping to target resources. Required if you specify TargetParameterName.</p>', 'StepExecution$Targets' => '<p>The targets for the step execution.</p>', 'UpdateAssociationRequest$Targets' => '<p>The targets of the association.</p>', 'UpdateMaintenanceWindowTargetRequest$Targets' => '<p>The targets to add or replace.</p>', 'UpdateMaintenanceWindowTargetResult$Targets' => '<p>The updated targets.</p>', 'UpdateMaintenanceWindowTaskRequest$Targets' => '<p>The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the format <code> Key=tag_name,Values=tag_value</code>. </p> <note> <p>One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don\'t specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> </note>', 'UpdateMaintenanceWindowTaskResult$Targets' => '<p>The updated target values.</p>', ], ], 'TerminateSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'TimeoutSeconds' => [ 'base' => NULL, 'refs' => [ 'Command$TimeoutSeconds' => '<p>The <code>TimeoutSeconds</code> value specified for a command.</p>', 'MaintenanceWindowRunCommandParameters$TimeoutSeconds' => '<p>If this time is reached and the command hasn\'t already started running, it doesn\'t run.</p>', 'SendCommandRequest$TimeoutSeconds' => '<p>If this time is reached and the command hasn\'t already started running, it won\'t run.</p>', ], ], 'TokenValue' => [ 'base' => NULL, 'refs' => [ 'ResumeSessionResponse$TokenValue' => '<p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>', 'StartSessionResponse$TokenValue' => '<p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>', ], ], 'TooManyTagsError' => [ 'base' => '<p>The <code>Targets</code> parameter includes too many tags. Remove one or more tags and try the command again.</p>', 'refs' => [], ], 'TooManyUpdates' => [ 'base' => '<p>There are concurrent updates for a resource that supports one update at a time.</p>', 'refs' => [], ], 'TotalCount' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionSummary$TotalCount' => '<p>The total number of items to delete. This count doesn\'t change during the delete operation.</p>', ], ], 'TotalSizeLimitExceededException' => [ 'base' => '<p>The size of inventory data has exceeded the total size limit for the resource.</p>', 'refs' => [], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'DeleteInventoryRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'DeleteInventoryResult$DeletionId' => '<p>Every <code>DeleteInventory</code> operation is assigned a unique ID. This option returns a unique ID. You can use this ID to query the status of a delete operation. This option is useful for ensuring that a delete operation has completed before you begin other operations. </p>', 'DescribeInventoryDeletionsRequest$DeletionId' => '<p>Specify the delete inventory ID for which you want information. This ID was returned by the <code>DeleteInventory</code> operation.</p>', 'InventoryDeletionStatusItem$DeletionId' => '<p>The deletion ID returned by the <code>DeleteInventory</code> operation.</p>', ], ], 'UnlabelParameterVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UnlabelParameterVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'UnsupportedCalendarException' => [ 'base' => '<p>The calendar entry contained in the specified SSM document isn\'t supported.</p>', 'refs' => [], ], 'UnsupportedFeatureRequiredException' => [ 'base' => '<p>Patching for applications released by Microsoft is only available on EC2 instances and advanced instances. To patch applications released by Microsoft on on-premises servers and VMs, you must enable advanced instances. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html">Enabling the advanced-instances tier</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>', 'refs' => [], ], 'UnsupportedInventoryItemContextException' => [ 'base' => '<p>The <code>Context</code> attribute that you specified for the <code>InventoryItem</code> isn\'t allowed for this inventory type. You can only use the <code>Context</code> attribute with inventory types like <code>AWS:ComplianceItem</code>.</p>', 'refs' => [], ], 'UnsupportedInventorySchemaVersionException' => [ 'base' => '<p>Inventory item type schema version has to match supported versions in the service. Check output of GetInventorySchema to see the available schema version for each type.</p>', 'refs' => [], ], 'UnsupportedOperatingSystem' => [ 'base' => '<p>The operating systems you specified isn\'t supported, or the operation isn\'t supported for the operating system.</p>', 'refs' => [], ], 'UnsupportedParameterType' => [ 'base' => '<p>The parameter type isn\'t supported.</p>', 'refs' => [], ], 'UnsupportedPlatformType' => [ 'base' => '<p>The document doesn\'t support the platform type of the given managed node ID(s). For example, you sent an document for a Windows managed node to a Linux node.</p>', 'refs' => [], ], 'UpdateAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssociationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssociationStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentDefaultVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentDefaultVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTargetResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateManagedInstanceRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateManagedInstanceRoleResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOpsItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOpsItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOpsMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOpsMetadataResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceSettingRequest' => [ 'base' => '<p>The request body of the UpdateServiceSetting API operation.</p>', 'refs' => [], ], 'UpdateServiceSettingResult' => [ 'base' => '<p>The result body of the UpdateServiceSetting API operation.</p>', 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$StandardOutputUrl' => '<p>The URL to the plugin\'s StdOut file in Amazon Simple Storage Service (Amazon S3), if the S3 bucket was defined for the parent command. For an invocation, <code>StandardOutputUrl</code> is populated if there is just one plugin defined for the command, and the S3 bucket was defined for the command.</p>', 'CommandInvocation$StandardErrorUrl' => '<p>The URL to the plugin\'s StdErr file in Amazon Simple Storage Service (Amazon S3), if the S3 bucket was defined for the parent command. For an invocation, <code>StandardErrorUrl</code> is populated if there is just one plugin defined for the command, and the S3 bucket was defined for the command.</p>', 'CommandPlugin$StandardOutputUrl' => '<p>The URL for the complete text written by the plugin to stdout in Amazon S3. If the S3 bucket for the command wasn\'t specified, then this string is empty.</p>', 'CommandPlugin$StandardErrorUrl' => '<p>The URL for the complete text written by the plugin to stderr. If execution isn\'t yet complete, then this string is empty.</p>', 'GetCommandInvocationResult$StandardOutputUrl' => '<p>The URL for the complete text written by the plugin to <code>stdout</code> in Amazon Simple Storage Service (Amazon S3). If an S3 bucket wasn\'t specified, then this string is empty.</p>', 'GetCommandInvocationResult$StandardErrorUrl' => '<p>The URL for the complete text written by the plugin to <code>stderr</code>. If the command hasn\'t finished running, then this string is empty.</p>', 'S3OutputUrl$OutputUrl' => '<p>A URL for an S3 bucket where you want to store the results of this request.</p>', ], ], 'ValidNextStep' => [ 'base' => NULL, 'refs' => [ 'ValidNextStepList$member' => NULL, ], ], 'ValidNextStepList' => [ 'base' => NULL, 'refs' => [ 'StepExecution$ValidNextSteps' => '<p>Strategies used when step fails, we support Continue and Abort. Abort will fail the automation when the step fails. Continue will ignore the failure of current step and allow automation to run the next step. With conditional branching, we add step:stepName to support the automation to go to another specific step.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$AgentVersion' => '<p>The version of SSM Agent running on your Linux managed node. </p>', ], ], ],];
