<?php
// This file was auto-generated from sdk-root/src/data/mgn/2020-02-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Application Migration Service service.</p>', 'operations' => [ 'ChangeServerLifeCycleState' => '<p>Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already launchable (dataReplicationInfo.lagDuration is not null.)</p>', 'CreateReplicationConfigurationTemplate' => '<p>Creates a new ReplicationConfigurationTemplate.</p>', 'DeleteJob' => '<p>Deletes a single Job by ID.</p>', 'DeleteReplicationConfigurationTemplate' => '<p>Deletes a single Replication Configuration Template by ID</p>', 'DeleteSourceServer' => '<p>Deletes a single source server by ID.</p>', 'DeleteVcenterClient' => '<p>Deletes a given vCenter client by ID.</p>', 'DescribeJobLogItems' => '<p>Retrieves detailed job log items with paging.</p>', 'DescribeJobs' => '<p>Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest, StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant support tickets.</p>', 'DescribeReplicationConfigurationTemplates' => '<p>Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.</p>', 'DescribeSourceServers' => '<p>Retrieves all SourceServers or multiple SourceServers by ID.</p>', 'DescribeVcenterClients' => '<p>Returns a list of the installed vCenter clients.</p>', 'DisconnectFromService' => '<p>Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately. All AWS resources created by Application Migration Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the agent on the source server has not been prevented from communicating with the Application Migration Service service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>', 'FinalizeCutover' => '<p>Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>', 'GetLaunchConfiguration' => '<p>Lists all LaunchConfigurations available, filtered by Source Server IDs.</p>', 'GetReplicationConfiguration' => '<p>Lists all ReplicationConfigurations, filtered by Source Server ID.</p>', 'InitializeService' => '<p>Initialize Application Migration Service.</p>', 'ListTagsForResource' => '<p>List all tags for your Application Migration Service resources.</p>', 'MarkAsArchived' => '<p>Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified SourceServers by ID. This command only works for SourceServers with a lifecycle. state which equals DISCONNECTED or CUTOVER.</p>', 'RetryDataReplication' => '<p>Causes the data replication initiation sequence to begin immediately upon next Handshake for specified SourceServer IDs, regardless of when the previous initiation started. This command will not work if the SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.</p>', 'StartCutover' => '<p>Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.</p>', 'StartReplication' => '<p>Starts replication for SNAPSHOT_SHIPPING agents.</p>', 'StartTest' => '<p>Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.</p>', 'TagResource' => '<p>Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value.</p>', 'TerminateTargetInstances' => '<p>Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.</p>', 'UntagResource' => '<p>Deletes the specified set of tags from the specified set of Application Migration Service resources.</p>', 'UpdateLaunchConfiguration' => '<p>Updates multiple LaunchConfigurations by Source Server ID.</p>', 'UpdateReplicationConfiguration' => '<p>Allows you to update multiple ReplicationConfigurations by Source Server ID.</p>', 'UpdateReplicationConfigurationTemplate' => '<p>Updates multiple ReplicationConfigurationTemplates by ID.</p>', 'UpdateSourceServerReplicationType' => '<p>Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING replication type.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$ebsEncryptionKeyArn' => '<p>Request to configure an EBS encryption key during Replication Settings template creation.</p>', 'Job$arn' => '<p>the ARN of the specific Job.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>List tags for resource request by ARN.</p>', 'ReplicationConfiguration$ebsEncryptionKeyArn' => '<p>Replication Configuration EBS encryption key ARN.</p>', 'ReplicationConfigurationTemplate$arn' => '<p>Replication Configuration template ARN.</p>', 'ReplicationConfigurationTemplate$ebsEncryptionKeyArn' => '<p>Replication Configuration template EBS encryption key ARN.</p>', 'SourceServer$arn' => '<p>Source server ARN.</p>', 'TagResourceRequest$resourceArn' => '<p>Tag resource by ARN.</p>', 'UntagResourceRequest$resourceArn' => '<p>Untag resource by ARN.</p>', 'UpdateReplicationConfigurationRequest$ebsEncryptionKeyArn' => '<p>Update replication configuration EBS encryption key ARN request.</p>', 'UpdateReplicationConfigurationTemplateRequest$arn' => '<p>Update replication configuration template ARN request.</p>', 'UpdateReplicationConfigurationTemplateRequest$ebsEncryptionKeyArn' => '<p>Update replication configuration template EBS encryption key ARN request.</p>', 'VcenterClient$arn' => '<p>Arn of vCenter client.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>Operating denied due to a file permission or access check error.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$associateDefaultSecurityGroup' => '<p>Request to associate the default Application Migration Service Security group with the Replication Settings template.</p>', 'CreateReplicationConfigurationTemplateRequest$createPublicIP' => '<p>Request to create Public IP during Replication Settings template creation.</p>', 'CreateReplicationConfigurationTemplateRequest$useDedicatedReplicationServer' => '<p>Request to use Dedicated Replication Servers during Replication Settings template creation.</p>', 'DescribeSourceServersRequestFilters$isArchived' => '<p>Request to filter Source Servers list by archived.</p>', 'LaunchConfiguration$copyPrivateIp' => '<p>Copy Private IP during Launch Configuration.</p>', 'LaunchConfiguration$copyTags' => '<p>Copy Tags during Launch Configuration.</p>', 'Licensing$osByol' => '<p>Configure BYOL OS licensing.</p>', 'NetworkInterface$isPrimary' => '<p>Network interface primary IP.</p>', 'ReplicationConfiguration$associateDefaultSecurityGroup' => '<p>Replication Configuration associate default Application Migration Service Security Group.</p>', 'ReplicationConfiguration$createPublicIP' => '<p>Replication Configuration create Public IP.</p>', 'ReplicationConfiguration$useDedicatedReplicationServer' => '<p>Replication Configuration use Dedicated Replication Server.</p>', 'ReplicationConfigurationReplicatedDisk$isBootDisk' => '<p>Replication Configuration replicated disk boot disk.</p>', 'ReplicationConfigurationTemplate$associateDefaultSecurityGroup' => '<p>Replication Configuration template associate default Application Migration Service Security group.</p>', 'ReplicationConfigurationTemplate$createPublicIP' => '<p>Replication Configuration template create Public IP.</p>', 'ReplicationConfigurationTemplate$useDedicatedReplicationServer' => '<p>Replication Configuration template use Dedicated Replication Server.</p>', 'SourceServer$isArchived' => '<p>Source server archived status.</p>', 'UpdateLaunchConfigurationRequest$copyPrivateIp' => '<p>Update Launch configuration copy Private IP request.</p>', 'UpdateLaunchConfigurationRequest$copyTags' => '<p>Update Launch configuration copy Tags request.</p>', 'UpdateReplicationConfigurationRequest$associateDefaultSecurityGroup' => '<p>Update replication configuration associate default Application Migration Service Security group request.</p>', 'UpdateReplicationConfigurationRequest$createPublicIP' => '<p>Update replication configuration create Public IP request.</p>', 'UpdateReplicationConfigurationRequest$useDedicatedReplicationServer' => '<p>Update replication configuration use dedicated Replication Server request.</p>', 'UpdateReplicationConfigurationTemplateRequest$associateDefaultSecurityGroup' => '<p>Update replication configuration template associate default Application Migration Service Security group request.</p>', 'UpdateReplicationConfigurationTemplateRequest$createPublicIP' => '<p>Update replication configuration template create Public IP request.</p>', 'UpdateReplicationConfigurationTemplateRequest$useDedicatedReplicationServer' => '<p>Update replication configuration template use dedicated Replication Server request.</p>', ], ], 'BootMode' => [ 'base' => NULL, 'refs' => [ 'LaunchConfiguration$bootMode' => '<p>Launch configuration boot mode.</p>', 'UpdateLaunchConfigurationRequest$bootMode' => '<p>Update Launch configuration boot mode request.</p>', ], ], 'BoundedString' => [ 'base' => NULL, 'refs' => [ 'CPU$modelName' => '<p>The source server\'s CPU model name.</p>', 'DataReplicationInfoReplicatedDisk$deviceName' => '<p>Request to query device name.</p>', 'Disk$deviceName' => '<p>The disk or device name.</p>', 'IPsList$member' => NULL, 'IdentificationHints$fqdn' => '<p>FQDN address identification hint.</p>', 'IdentificationHints$hostname' => '<p>Hostname identification hint.</p>', 'IdentificationHints$vmPath' => '<p>vCenter VM path identification hint.</p>', 'IdentificationHints$vmWareUuid' => '<p>vmWare UUID identification hint.</p>', 'LaunchConfiguration$ec2LaunchTemplateID' => '<p>Launch configuration EC2 Launch template ID.</p>', 'NetworkInterface$macAddress' => '<p>Network interface Mac address.</p>', 'OS$fullString' => '<p>OS full string.</p>', 'ReplicationConfigurationReplicatedDisk$deviceName' => '<p>Replication Configuration replicated disk device name.</p>', 'VcenterClient$datacenterName' => '<p>Datacenter name of vCenter client.</p>', 'VcenterClient$hostname' => '<p>Hostname of vCenter client .</p>', 'VcenterClient$vcenterUUID' => '<p>Vcenter UUID of vCenter client.</p>', ], ], 'CPU' => [ 'base' => '<p>Source server CPU information.</p>', 'refs' => [ 'Cpus$member' => NULL, ], ], 'ChangeServerLifeCycleStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ChangeServerLifeCycleStateSourceServerLifecycle' => [ 'base' => '<p>The request to change the source server migration lifecycle state.</p>', 'refs' => [ 'ChangeServerLifeCycleStateRequest$lifeCycle' => '<p>The request to change the source server migration lifecycle state.</p>', ], ], 'ChangeServerLifeCycleStateSourceServerLifecycleState' => [ 'base' => NULL, 'refs' => [ 'ChangeServerLifeCycleStateSourceServerLifecycle$state' => '<p>The request to change the source server migration lifecycle state.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be completed due to a conflict with the current state of the target resource.</p>', 'refs' => [], ], 'Cpus' => [ 'base' => NULL, 'refs' => [ 'SourceProperties$cpus' => '<p>Source Server CPUs.</p>', ], ], 'CreateReplicationConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DataReplicationError' => [ 'base' => '<p>Error in data replication.</p>', 'refs' => [ 'DataReplicationInfo$dataReplicationError' => '<p>Error in obtaining data replication info.</p>', ], ], 'DataReplicationErrorString' => [ 'base' => NULL, 'refs' => [ 'DataReplicationError$error' => '<p>Error in data replication.</p>', ], ], 'DataReplicationInfo' => [ 'base' => '<p>Request data replication info.</p>', 'refs' => [ 'SourceServer$dataReplicationInfo' => '<p>Source server data replication info.</p>', ], ], 'DataReplicationInfoReplicatedDisk' => [ 'base' => '<p>Request to query disks replicated.</p>', 'refs' => [ 'DataReplicationInfoReplicatedDisks$member' => NULL, ], ], 'DataReplicationInfoReplicatedDisks' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInfo$replicatedDisks' => '<p>Request to query disks replicated.</p>', ], ], 'DataReplicationInitiation' => [ 'base' => '<p>Data replication initiation.</p>', 'refs' => [ 'DataReplicationInfo$dataReplicationInitiation' => '<p>Request to query whether data replication has been initiated.</p>', ], ], 'DataReplicationInitiationStep' => [ 'base' => '<p>Data replication initiation step.</p>', 'refs' => [ 'DataReplicationInitiationSteps$member' => NULL, ], ], 'DataReplicationInitiationStepName' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInitiationStep$name' => '<p>Request to query data initiation step name.</p>', ], ], 'DataReplicationInitiationStepStatus' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInitiationStep$status' => '<p>Request to query data initiation status.</p>', ], ], 'DataReplicationInitiationSteps' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInitiation$steps' => '<p>Request to query data initiation steps.</p>', ], ], 'DataReplicationState' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInfo$dataReplicationState' => '<p>Request to query the data replication state.</p>', ], ], 'DeleteJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationConfigurationTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVcenterClientRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobLogItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobLogItemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobsRequestFilters' => [ 'base' => '<p>Request to describe Job log filters.</p>', 'refs' => [ 'DescribeJobsRequest$filters' => '<p>Request to describe Job log filters.</p>', ], ], 'DescribeJobsRequestFiltersJobIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeJobsRequestFilters$jobIDs' => '<p>Request to describe Job log filters by job ID.</p>', ], ], 'DescribeJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplicationConfigurationTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplicationConfigurationTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSourceServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSourceServersRequestFilters' => [ 'base' => '<p>Request to filter Source Servers list.</p>', 'refs' => [ 'DescribeSourceServersRequest$filters' => '<p>Request to filter Source Servers list.</p>', ], ], 'DescribeSourceServersRequestFiltersIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersRequestFilters$sourceServerIDs' => '<p>Request to filter Source Servers list by Source Server ID.</p>', ], ], 'DescribeSourceServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVcenterClientsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVcenterClientsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectFromServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'Disk' => [ 'base' => '<p>The disk identifier.</p>', 'refs' => [ 'Disks$member' => NULL, ], ], 'Disks' => [ 'base' => NULL, 'refs' => [ 'SourceProperties$disks' => '<p>Source Server disks.</p>', ], ], 'EC2InstanceID' => [ 'base' => NULL, 'refs' => [ 'IdentificationHints$awsInstanceID' => '<p>AWS Instance ID identification hint.</p>', 'JobLogEventData$conversionServerID' => '<p>Job Event conversion Server ID.</p>', 'JobLogEventData$targetInstanceID' => '<p>Job Event Target instance ID.</p>', 'LaunchedInstance$ec2InstanceID' => '<p>Launched instance EC2 ID.</p>', ], ], 'EC2InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$replicationServerInstanceType' => '<p>Request to configure the Replication Server instance type during Replication Settings template creation.</p>', 'ReplicationConfiguration$replicationServerInstanceType' => '<p>Replication Configuration Replication Server instance type.</p>', 'ReplicationConfigurationTemplate$replicationServerInstanceType' => '<p>Replication Configuration template server instance type.</p>', 'SourceProperties$recommendedInstanceType' => '<p>Source server recommended instance type.</p>', 'UpdateReplicationConfigurationRequest$replicationServerInstanceType' => '<p>Update replication configuration Replication Server instance type request.</p>', 'UpdateReplicationConfigurationTemplateRequest$replicationServerInstanceType' => '<p>Update replication configuration template Replication Server instance type request.</p>', ], ], 'FinalizeCutoverRequest' => [ 'base' => NULL, 'refs' => [], ], 'FirstBoot' => [ 'base' => NULL, 'refs' => [ 'LaunchedInstance$firstBoot' => '<p>Launched instance first boot.</p>', ], ], 'GetLaunchConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'IPsList' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$ips' => '<p>Network interface IPs.</p>', ], ], 'ISO8601DatetimeString' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInfo$etaDateTime' => '<p>Request to query the time when data replication will be complete.</p>', 'DataReplicationInfo$lagDuration' => '<p>Request to query data replication lag duration.</p>', 'DataReplicationInfo$lastSnapshotDateTime' => '<p>Request to query data replication last snapshot time.</p>', 'DataReplicationInitiation$nextAttemptDateTime' => '<p>Request to query next data initiation date and time.</p>', 'DataReplicationInitiation$startDateTime' => '<p>Request to query data initiation start date and time.</p>', 'DescribeJobsRequestFilters$fromDate' => '<p>Request to describe Job log filters by date.</p>', 'DescribeJobsRequestFilters$toDate' => '<p>Request to describe job log items by last date.</p>', 'Job$creationDateTime' => '<p>Job creation time.</p>', 'Job$endDateTime' => '<p>Job end time.</p>', 'JobLog$logDateTime' => '<p>Job log event date and time.</p>', 'LifeCycle$addedToServiceDateTime' => '<p>Lifecycle added to service data and time.</p>', 'LifeCycle$elapsedReplicationDuration' => '<p>Lifecycle elapsed time and duration.</p>', 'LifeCycle$firstByteDateTime' => '<p>Lifecycle replication initiation date and time.</p>', 'LifeCycle$lastSeenByServiceDateTime' => '<p>Lifecycle last seen date and time.</p>', 'LifeCycleLastCutoverFinalized$apiCallDateTime' => '<p>Lifecycle Cutover finalized date and time.</p>', 'LifeCycleLastCutoverInitiated$apiCallDateTime' => '<p/>', 'LifeCycleLastCutoverReverted$apiCallDateTime' => '<p>Lifecycle last Cutover reverted API call date time.</p>', 'LifeCycleLastTestFinalized$apiCallDateTime' => '<p>Lifecycle Test failed API call date and time.</p>', 'LifeCycleLastTestInitiated$apiCallDateTime' => '<p>Lifecycle last Test initiated API call date and time.</p>', 'LifeCycleLastTestReverted$apiCallDateTime' => '<p>Lifecycle last Test reverted API call date and time.</p>', 'SourceProperties$lastUpdatedDateTime' => '<p>Source server last update date and time.</p>', 'VcenterClient$lastSeenDatetime' => '<p>Last seen time of vCenter client.</p>', ], ], 'IdentificationHints' => [ 'base' => '<p>Identification hints.</p>', 'refs' => [ 'SourceProperties$identificationHints' => '<p>Source server identification hints.</p>', ], ], 'InitializeServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'InitializeServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'InitiatedBy' => [ 'base' => NULL, 'refs' => [ 'Job$initiatedBy' => '<p>Job initiated by field.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The server encountered an unexpected condition that prevented it from fulfilling the request.</p>', 'refs' => [], ], 'Job' => [ 'base' => '<p>Job.</p>', 'refs' => [ 'JobsList$member' => NULL, 'StartCutoverResponse$job' => '<p>Start Cutover Job response.</p>', 'StartTestResponse$job' => '<p>Start Test Job response.</p>', 'TerminateTargetInstancesResponse$job' => '<p>Terminate Target instance Job response.</p>', ], ], 'JobID' => [ 'base' => NULL, 'refs' => [ 'DeleteJobRequest$jobID' => '<p>Request to delete Job from service by Job ID.</p>', 'DescribeJobLogItemsRequest$jobID' => '<p>Request to describe Job log job ID.</p>', 'DescribeJobsRequestFiltersJobIDs$member' => NULL, 'Job$jobID' => '<p>Job ID.</p>', 'LaunchedInstance$jobID' => '<p>Launched instance Job ID.</p>', 'LifeCycleLastCutoverInitiated$jobID' => '<p>Lifecycle last Cutover initiated by Job ID.</p>', 'LifeCycleLastTestInitiated$jobID' => '<p>Lifecycle last Test initiated Job ID.</p>', ], ], 'JobLog' => [ 'base' => '<p>Job log.</p>', 'refs' => [ 'JobLogs$member' => NULL, ], ], 'JobLogEvent' => [ 'base' => NULL, 'refs' => [ 'JobLog$event' => '<p>Job log event.</p>', ], ], 'JobLogEventData' => [ 'base' => '<p>Job log data</p>', 'refs' => [ 'JobLog$eventData' => '<p>Job event data</p>', ], ], 'JobLogs' => [ 'base' => NULL, 'refs' => [ 'DescribeJobLogItemsResponse$items' => '<p>Request to describe Job log response items.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'Job$status' => '<p>Job status.</p>', ], ], 'JobType' => [ 'base' => NULL, 'refs' => [ 'Job$type' => '<p>Job type.</p>', ], ], 'JobsList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobsResponse$items' => '<p>Request to describe Job log items.</p>', ], ], 'LargeBoundedString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$code' => NULL, 'AccessDeniedException$message' => NULL, 'ConflictException$code' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>A conflict occurred when prompting for the Resource ID.</p>', 'ConflictException$resourceType' => '<p>A conflict occurred when prompting for resource type.</p>', 'DataReplicationError$rawError' => '<p>Error in data replication.</p>', 'InternalServerException$message' => NULL, 'JobLogEventData$rawError' => '<p>Job error.</p>', 'ResourceNotFoundException$code' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>Resource ID not found error.</p>', 'ResourceNotFoundException$resourceType' => '<p>Resource type not found error.</p>', 'ServiceQuotaExceededException$code' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$quotaCode' => '<p>Exceeded the service quota code.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>Exceeded the service quota resource ID.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>Exceeded the service quota resource type.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>Exceeded the service quota service code.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>Reached throttling quota exception.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>Reached throttling quota exception will retry after x seconds.</p>', 'ThrottlingException$serviceCode' => '<p>Reached throttling quota exception service code.</p>', 'UninitializedAccountException$code' => NULL, 'UninitializedAccountException$message' => NULL, 'ValidationException$code' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>Validate exception field message.</p>', 'ValidationExceptionField$name' => '<p>Validate exception field name.</p>', ], ], 'LaunchConfiguration' => [ 'base' => NULL, 'refs' => [], ], 'LaunchDisposition' => [ 'base' => NULL, 'refs' => [ 'LaunchConfiguration$launchDisposition' => '<p>Launch disposition for launch configuration.</p>', 'UpdateLaunchConfigurationRequest$launchDisposition' => '<p>Update Launch configuration launch disposition request.</p>', ], ], 'LaunchStatus' => [ 'base' => NULL, 'refs' => [ 'ParticipatingServer$launchStatus' => '<p>Participating server launch status.</p>', ], ], 'LaunchedInstance' => [ 'base' => '<p>Launched instance.</p>', 'refs' => [ 'SourceServer$launchedInstance' => '<p>Source server launched instance.</p>', ], ], 'Licensing' => [ 'base' => '<p>Configure Licensing.</p>', 'refs' => [ 'LaunchConfiguration$licensing' => '<p>Launch configuration OS licensing.</p>', 'UpdateLaunchConfigurationRequest$licensing' => '<p>Update Launch configuration licensing request.</p>', ], ], 'LifeCycle' => [ 'base' => '<p>Lifecycle.</p>', 'refs' => [ 'SourceServer$lifeCycle' => '<p>Source server lifecycle state.</p>', ], ], 'LifeCycleLastCutover' => [ 'base' => '<p>Lifecycle last Cutover .</p>', 'refs' => [ 'LifeCycle$lastCutover' => '<p>Lifecycle last Cutover.</p>', ], ], 'LifeCycleLastCutoverFinalized' => [ 'base' => '<p>Lifecycle Cutover finalized</p>', 'refs' => [ 'LifeCycleLastCutover$finalized' => '<p>Lifecycle Cutover finalized date and time.</p>', ], ], 'LifeCycleLastCutoverInitiated' => [ 'base' => '<p>Lifecycle last Cutover initiated.</p>', 'refs' => [ 'LifeCycleLastCutover$initiated' => '<p>Lifecycle last Cutover initiated.</p>', ], ], 'LifeCycleLastCutoverReverted' => [ 'base' => '<p>Lifecycle last Cutover reverted.</p>', 'refs' => [ 'LifeCycleLastCutover$reverted' => '<p>Lifecycle last Cutover reverted.</p>', ], ], 'LifeCycleLastTest' => [ 'base' => '<p>Lifecycle last Test.</p>', 'refs' => [ 'LifeCycle$lastTest' => '<p>Lifecycle last Test.</p>', ], ], 'LifeCycleLastTestFinalized' => [ 'base' => '<p>Lifecycle last Test finalized.</p>', 'refs' => [ 'LifeCycleLastTest$finalized' => '<p>Lifecycle last Test finalized.</p>', ], ], 'LifeCycleLastTestInitiated' => [ 'base' => '<p>Lifecycle last Test initiated.</p>', 'refs' => [ 'LifeCycleLastTest$initiated' => '<p>Lifecycle last Test initiated.</p>', ], ], 'LifeCycleLastTestReverted' => [ 'base' => '<p>Lifecycle last Test reverted.</p>', 'refs' => [ 'LifeCycleLastTest$reverted' => '<p>Lifecycle last Test reverted.</p>', ], ], 'LifeCycleState' => [ 'base' => NULL, 'refs' => [ 'LifeCycle$state' => '<p>Lifecycle state.</p>', 'LifeCycleStates$member' => NULL, ], ], 'LifeCycleStates' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersRequestFilters$lifeCycleStates' => '<p>Request to filter Source Servers list by life cycle states.</p>', ], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MarkAsArchivedRequest' => [ 'base' => NULL, 'refs' => [], ], 'NetworkInterface' => [ 'base' => '<p>Network interface.</p>', 'refs' => [ 'NetworkInterfaces$member' => NULL, ], ], 'NetworkInterfaces' => [ 'base' => NULL, 'refs' => [ 'SourceProperties$networkInterfaces' => '<p>Source server network interfaces.</p>', ], ], 'OS' => [ 'base' => '<p>Operating System.</p>', 'refs' => [ 'SourceProperties$os' => '<p>Source server OS.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'DescribeJobLogItemsRequest$nextToken' => '<p>Request to describe Job log next token.</p>', 'DescribeJobLogItemsResponse$nextToken' => '<p>Request to describe Job log response next token.</p>', 'DescribeJobsRequest$nextToken' => '<p>Request to describe job log items by next token.</p>', 'DescribeJobsResponse$nextToken' => '<p>Request to describe Job response by next token.</p>', 'DescribeReplicationConfigurationTemplatesRequest$nextToken' => '<p>Request to describe Replication Configuration template by next token.</p>', 'DescribeReplicationConfigurationTemplatesResponse$nextToken' => '<p>Request to describe Replication Configuration template by next token.</p>', 'DescribeSourceServersRequest$nextToken' => '<p>Request to filter Source Servers list by next token.</p>', 'DescribeSourceServersResponse$nextToken' => '<p>Request to filter Source Servers next token.</p>', 'DescribeVcenterClientsRequest$nextToken' => '<p>Next pagination token to be provided for DescribeVcenterClients.</p>', 'DescribeVcenterClientsResponse$nextToken' => '<p>Next pagination token returned from DescribeVcenterClients.</p>', ], ], 'ParticipatingServer' => [ 'base' => '<p>Server participating in Job.</p>', 'refs' => [ 'ParticipatingServers$member' => NULL, ], ], 'ParticipatingServers' => [ 'base' => NULL, 'refs' => [ 'Job$participatingServers' => '<p>Servers participating in a specific Job.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'CPU$cores' => '<p>The number of CPU cores on the source server.</p>', 'CreateReplicationConfigurationTemplateRequest$bandwidthThrottling' => '<p>Request to configure bandwidth throttling during Replication Settings template creation.</p>', 'DataReplicationInfoReplicatedDisk$backloggedStorageBytes' => '<p>Request to query data replication backlog size in bytes.</p>', 'DataReplicationInfoReplicatedDisk$replicatedStorageBytes' => '<p>Request to query amount of data replicated in bytes.</p>', 'DataReplicationInfoReplicatedDisk$rescannedStorageBytes' => '<p>Request to query amount of data rescanned in bytes.</p>', 'DataReplicationInfoReplicatedDisk$totalStorageBytes' => '<p>Request to query total amount of data replicated in bytes.</p>', 'Disk$bytes' => '<p>The amount of storage on the disk in bytes.</p>', 'InternalServerException$retryAfterSeconds' => '<p>The server encountered an unexpected condition that prevented it from fulfilling the request. The request will be retried again after x seconds.</p>', 'ReplicationConfiguration$bandwidthThrottling' => '<p>Replication Configuration set bandwidth throttling.</p>', 'ReplicationConfigurationReplicatedDisk$iops' => '<p>Replication Configuration replicated disk IOPs.</p>', 'ReplicationConfigurationReplicatedDisk$throughput' => '<p>Replication Configuration replicated disk throughput.</p>', 'ReplicationConfigurationTemplate$bandwidthThrottling' => '<p>Replication Configuration template bandwidth throttling.</p>', 'SourceProperties$ramBytes' => '<p>Source server RAM in bytes.</p>', 'UpdateReplicationConfigurationRequest$bandwidthThrottling' => '<p>Update replication configuration bandwidth throttling request.</p>', 'UpdateReplicationConfigurationTemplateRequest$bandwidthThrottling' => '<p>Update replication configuration template bandwidth throttling request.</p>', ], ], 'ReplicationConfiguration' => [ 'base' => NULL, 'refs' => [], ], 'ReplicationConfigurationDataPlaneRouting' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$dataPlaneRouting' => '<p>Request to configure data plane routing during Replication Settings template creation.</p>', 'ReplicationConfiguration$dataPlaneRouting' => '<p>Replication Configuration data plane routing.</p>', 'ReplicationConfigurationTemplate$dataPlaneRouting' => '<p>Replication Configuration template data plane routing.</p>', 'UpdateReplicationConfigurationRequest$dataPlaneRouting' => '<p>Update replication configuration data plane routing request.</p>', 'UpdateReplicationConfigurationTemplateRequest$dataPlaneRouting' => '<p>Update replication configuration template data plane routing request.</p>', ], ], 'ReplicationConfigurationDefaultLargeStagingDiskType' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$defaultLargeStagingDiskType' => '<p>Request to configure the default large staging disk EBS volume type during Replication Settings template creation.</p>', 'ReplicationConfiguration$defaultLargeStagingDiskType' => '<p>Replication Configuration use default large Staging Disks.</p>', 'ReplicationConfigurationTemplate$defaultLargeStagingDiskType' => '<p>Replication Configuration template use default large Staging Disk type.</p>', 'UpdateReplicationConfigurationRequest$defaultLargeStagingDiskType' => '<p>Update replication configuration use default large Staging Disk type request.</p>', 'UpdateReplicationConfigurationTemplateRequest$defaultLargeStagingDiskType' => '<p>Update replication configuration template use default large Staging Disk type request.</p>', ], ], 'ReplicationConfigurationEbsEncryption' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$ebsEncryption' => '<p>Request to configure EBS encryption during Replication Settings template creation.</p>', 'ReplicationConfiguration$ebsEncryption' => '<p>Replication Configuration EBS encryption.</p>', 'ReplicationConfigurationTemplate$ebsEncryption' => '<p>Replication Configuration template EBS encryption.</p>', 'UpdateReplicationConfigurationRequest$ebsEncryption' => '<p>Update replication configuration EBS encryption request.</p>', 'UpdateReplicationConfigurationTemplateRequest$ebsEncryption' => '<p>Update replication configuration template EBS encryption request.</p>', ], ], 'ReplicationConfigurationReplicatedDisk' => [ 'base' => '<p>Replication Configuration replicated disk.</p>', 'refs' => [ 'ReplicationConfigurationReplicatedDisks$member' => NULL, ], ], 'ReplicationConfigurationReplicatedDiskStagingDiskType' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfigurationReplicatedDisk$stagingDiskType' => '<p>Replication Configuration replicated disk staging disk type.</p>', ], ], 'ReplicationConfigurationReplicatedDisks' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfiguration$replicatedDisks' => '<p>Replication Configuration replicated disks.</p>', 'UpdateReplicationConfigurationRequest$replicatedDisks' => '<p>Update replication configuration replicated disks request.</p>', ], ], 'ReplicationConfigurationTemplate' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfigurationTemplates$member' => NULL, ], ], 'ReplicationConfigurationTemplateID' => [ 'base' => NULL, 'refs' => [ 'DeleteReplicationConfigurationTemplateRequest$replicationConfigurationTemplateID' => '<p>Request to delete Replication Configuration Template from service by Replication Configuration Template ID.</p>', 'ReplicationConfigurationTemplate$replicationConfigurationTemplateID' => '<p>Replication Configuration template ID.</p>', 'ReplicationConfigurationTemplateIDs$member' => NULL, 'UpdateReplicationConfigurationTemplateRequest$replicationConfigurationTemplateID' => '<p>Update replication configuration template template ID request.</p>', ], ], 'ReplicationConfigurationTemplateIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationConfigurationTemplatesRequest$replicationConfigurationTemplateIDs' => '<p>Request to describe Replication Configuration template by template IDs.</p>', ], ], 'ReplicationConfigurationTemplates' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationConfigurationTemplatesResponse$items' => '<p>Request to describe Replication Configuration template by items.</p>', ], ], 'ReplicationServersSecurityGroupsIDs' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$replicationServersSecurityGroupsIDs' => '<p>Request to configure the Replication Server Security group ID during Replication Settings template creation.</p>', 'ReplicationConfiguration$replicationServersSecurityGroupsIDs' => '<p>Replication Configuration Replication Server Security Group IDs.</p>', 'ReplicationConfigurationTemplate$replicationServersSecurityGroupsIDs' => '<p>Replication Configuration template server Security Groups IDs.</p>', 'UpdateReplicationConfigurationRequest$replicationServersSecurityGroupsIDs' => '<p>Update replication configuration Replication Server Security Groups IDs request.</p>', 'UpdateReplicationConfigurationTemplateRequest$replicationServersSecurityGroupsIDs' => '<p>Update replication configuration template Replication Server Security groups IDs request.</p>', ], ], 'ReplicationType' => [ 'base' => NULL, 'refs' => [ 'ReplicationTypes$member' => NULL, 'SourceServer$replicationType' => '<p>Source server replication type.</p>', 'UpdateSourceServerReplicationTypeRequest$replicationType' => '<p>Replication type to which to update source server.</p>', ], ], 'ReplicationTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersRequestFilters$replicationTypes' => '<p>Request to filter Source Servers list by replication type.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Resource not found exception.</p>', 'refs' => [], ], 'RetryDataReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SecurityGroupID' => [ 'base' => NULL, 'refs' => [ 'ReplicationServersSecurityGroupsIDs$member' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request could not be completed because its exceeded the service quota.</p>', 'refs' => [], ], 'SmallBoundedString' => [ 'base' => NULL, 'refs' => [ 'LaunchConfiguration$name' => '<p>Launch configuration name.</p>', 'ReplicationConfiguration$name' => '<p>Replication Configuration name.</p>', 'UpdateLaunchConfigurationRequest$name' => '<p>Update Launch configuration name request.</p>', 'UpdateReplicationConfigurationRequest$name' => '<p>Update replication configuration name request.</p>', ], ], 'SourceProperties' => [ 'base' => '<p>Source server properties.</p>', 'refs' => [ 'SourceServer$sourceProperties' => '<p>Source server properties.</p>', ], ], 'SourceServer' => [ 'base' => NULL, 'refs' => [ 'SourceServersList$member' => NULL, ], ], 'SourceServerID' => [ 'base' => NULL, 'refs' => [ 'ChangeServerLifeCycleStateRequest$sourceServerID' => '<p>The request to change the source server migration lifecycle state by source server ID.</p>', 'DeleteSourceServerRequest$sourceServerID' => '<p>Request to delete Source Server from service by Server ID.</p>', 'DescribeSourceServersRequestFiltersIDs$member' => NULL, 'DisconnectFromServiceRequest$sourceServerID' => '<p>Request to disconnect Source Server from service by Server ID.</p>', 'FinalizeCutoverRequest$sourceServerID' => '<p>Request to finalize Cutover by Source Server ID.</p>', 'GetLaunchConfigurationRequest$sourceServerID' => '<p>Request to get Launch Configuration information by Source Server ID.</p>', 'GetReplicationConfigurationRequest$sourceServerID' => '<p>Request to get Replication Configuration by Source Server ID.</p>', 'JobLogEventData$sourceServerID' => '<p>Job Event Source Server ID.</p>', 'LaunchConfiguration$sourceServerID' => '<p>Launch configuration Source Server ID.</p>', 'MarkAsArchivedRequest$sourceServerID' => '<p>Mark as archived by Source Server ID.</p>', 'ParticipatingServer$sourceServerID' => '<p>Participating server Source Server ID.</p>', 'ReplicationConfiguration$sourceServerID' => '<p>Replication Configuration Source Server ID.</p>', 'RetryDataReplicationRequest$sourceServerID' => '<p>Retry data replication for Source Server ID.</p>', 'SourceServer$sourceServerID' => '<p>Source server ID.</p>', 'StartCutoverRequestSourceServerIDs$member' => NULL, 'StartReplicationRequest$sourceServerID' => '<p>ID of source server on which to start replication.</p>', 'StartTestRequestSourceServerIDs$member' => NULL, 'TerminateTargetInstancesRequestSourceServerIDs$member' => NULL, 'UpdateLaunchConfigurationRequest$sourceServerID' => '<p>Update Launch configuration by Source Server ID request.</p>', 'UpdateReplicationConfigurationRequest$sourceServerID' => '<p>Update replication configuration Source Server ID request.</p>', 'UpdateSourceServerReplicationTypeRequest$sourceServerID' => '<p>ID of source server on which to update replication type.</p>', ], ], 'SourceServersList' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersResponse$items' => '<p>Request to filter Source Servers list by item.</p>', ], ], 'StartCutoverRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCutoverRequestSourceServerIDs' => [ 'base' => NULL, 'refs' => [ 'StartCutoverRequest$sourceServerIDs' => '<p>Start Cutover by Source Server IDs.</p>', ], ], 'StartCutoverResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTestRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTestRequestSourceServerIDs' => [ 'base' => NULL, 'refs' => [ 'StartTestRequest$sourceServerIDs' => '<p>Start Test for Source Server IDs.</p>', ], ], 'StartTestResponse' => [ 'base' => NULL, 'refs' => [], ], 'StrictlyPositiveInteger' => [ 'base' => NULL, 'refs' => [ 'DescribeJobLogItemsRequest$maxResults' => '<p>Request to describe Job log item maximum results.</p>', 'DescribeJobsRequest$maxResults' => '<p>Request to describe job log items by max results.</p>', 'DescribeReplicationConfigurationTemplatesRequest$maxResults' => '<p>Request to describe Replication Configuration template by max results.</p>', 'DescribeSourceServersRequest$maxResults' => '<p>Request to filter Source Servers list by maximum results.</p>', 'DescribeVcenterClientsRequest$maxResults' => '<p>Maximum results to be returned in DescribeVcenterClients.</p>', ], ], 'SubnetID' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$stagingAreaSubnetId' => '<p>Request to configure the Staging Area subnet ID during Replication Settings template creation.</p>', 'ReplicationConfiguration$stagingAreaSubnetId' => '<p>Replication Configuration Staging Area subnet ID.</p>', 'ReplicationConfigurationTemplate$stagingAreaSubnetId' => '<p>Replication Configuration template Staging Area subnet ID.</p>', 'UpdateReplicationConfigurationRequest$stagingAreaSubnetId' => '<p>Update replication configuration Staging Area subnet request.</p>', 'UpdateReplicationConfigurationTemplateRequest$stagingAreaSubnetId' => '<p>Update replication configuration template Staging Area subnet ID request.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'TagsMap$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Untag resource by Keys.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagsMap$value' => NULL, ], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$stagingAreaTags' => '<p>Request to configure Staging Area tags during Replication Settings template creation.</p>', 'CreateReplicationConfigurationTemplateRequest$tags' => '<p>Request to configure tags during Replication Settings template creation.</p>', 'Job$tags' => '<p>Tags associated with specific Job.</p>', 'ListTagsForResourceResponse$tags' => '<p>List tags for resource response.</p>', 'ReplicationConfiguration$stagingAreaTags' => '<p>Replication Configuration Staging Area tags.</p>', 'ReplicationConfigurationTemplate$stagingAreaTags' => '<p>Replication Configuration template Staging Area Tags.</p>', 'ReplicationConfigurationTemplate$tags' => '<p>Replication Configuration template Tags.</p>', 'SourceServer$tags' => '<p>Source server Tags.</p>', 'StartCutoverRequest$tags' => '<p>Start Cutover by Tags.</p>', 'StartTestRequest$tags' => '<p>Start Test by Tags.</p>', 'TagResourceRequest$tags' => '<p>Tag resource by Tags.</p>', 'TerminateTargetInstancesRequest$tags' => '<p>Terminate Target instance by Tags.</p>', 'UpdateReplicationConfigurationRequest$stagingAreaTags' => '<p>Update replication configuration Staging Area Tags request.</p>', 'UpdateReplicationConfigurationTemplateRequest$stagingAreaTags' => '<p>Update replication configuration template Staging Area Tags request.</p>', 'VcenterClient$sourceServerTags' => '<p>Tags for Source Server of vCenter client.</p>', 'VcenterClient$tags' => '<p>Tags for vCenter client.</p>', ], ], 'TargetInstanceTypeRightSizingMethod' => [ 'base' => NULL, 'refs' => [ 'LaunchConfiguration$targetInstanceTypeRightSizingMethod' => '<p>Launch configuration Target instance type right sizing method.</p>', 'UpdateLaunchConfigurationRequest$targetInstanceTypeRightSizingMethod' => '<p>Update Launch configuration Target instance right sizing request.</p>', ], ], 'TerminateTargetInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateTargetInstancesRequestSourceServerIDs' => [ 'base' => NULL, 'refs' => [ 'TerminateTargetInstancesRequest$sourceServerIDs' => '<p>Terminate Target instance by Source Server IDs.</p>', ], ], 'TerminateTargetInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>Reached throttling quota exception.</p>', 'refs' => [], ], 'UninitializedAccountException' => [ 'base' => '<p>Uninitialized account exception.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSourceServerReplicationTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Validate exception.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Validate exception field.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>Validate exception field list.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>Validate exception reason.</p>', ], ], 'VcenterClient' => [ 'base' => '<p>vCenter client.</p>', 'refs' => [ 'VcenterClientList$member' => NULL, ], ], 'VcenterClientID' => [ 'base' => NULL, 'refs' => [ 'DeleteVcenterClientRequest$vcenterClientID' => '<p>ID of resource to be deleted.</p>', 'SourceServer$vcenterClientID' => '<p>Source server vCenter client id.</p>', 'VcenterClient$vcenterClientID' => '<p>ID of vCenter client.</p>', ], ], 'VcenterClientList' => [ 'base' => NULL, 'refs' => [ 'DescribeVcenterClientsResponse$items' => '<p>List of items returned by DescribeVcenterClients.</p>', ], ], ],];
