<?php
// This file was auto-generated from sdk-root/src/data/cognito-idp/2016-04-18/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Using the Amazon Cognito user pools API, you can create a user pool to manage directories and users. You can authenticate a user to obtain tokens related to user identity and access policies.</p> <p>This API reference provides information about user pools in Amazon Cognito user pools.</p> <p>For more information, see the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/what-is-amazon-cognito.html">Amazon Cognito Documentation</a>.</p>', 'operations' => [ 'AddCustomAttributes' => '<p>Adds additional user attributes to the user pool schema.</p>', 'AdminAddUserToGroup' => '<p>Adds the specified user to the specified group.</p> <p>Calling this action requires developer credentials.</p>', 'AdminConfirmSignUp' => '<p>Confirms user registration as an admin without using a confirmation code. Works on any user.</p> <p>Calling this action requires developer credentials.</p>', 'AdminCreateUser' => '<p>Creates a new user in the specified user pool.</p> <p>If <code>MessageAction</code> isn\'t set, the default is to send a welcome message via email or phone (SMS).</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <p>This message is based on a template that you configured in your call to create or update a user pool. This template includes your custom sign-up instructions and placeholders for user name and temporary password.</p> <p>Alternatively, you can call <code>AdminCreateUser</code> with <code>SUPPRESS</code> for the <code>MessageAction</code> parameter, and Amazon Cognito won\'t send any email. </p> <p>In either case, the user will be in the <code>FORCE_CHANGE_PASSWORD</code> state until they sign in and change their password.</p> <p> <code>AdminCreateUser</code> requires developer credentials.</p>', 'AdminDeleteUser' => '<p>Deletes a user as an administrator. Works on any user.</p> <p>Calling this action requires developer credentials.</p>', 'AdminDeleteUserAttributes' => '<p>Deletes the user attributes in a user pool as an administrator. Works on any user.</p> <p>Calling this action requires developer credentials.</p>', 'AdminDisableProviderForUser' => '<p>Disables the user from signing in with the specified external (SAML or social) identity provider. If the user to disable is a Amazon Cognito User Pools native username + password user, they aren\'t permitted to use their password to sign in. If the user to deactivate is a linked external identity provider (IdP) user, any link between that user and an existing user is removed. The next time the external user (no longer attached to the previously linked <code>DestinationUser</code>) signs in, they must create a new user account. See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html">AdminLinkProviderForUser</a>.</p> <p>This action is enabled only for admin access and requires developer credentials.</p> <p>The <code>ProviderName</code> must match the value specified when creating an IdP for the pool. </p> <p>To deactivate a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code> and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>. The <code>ProviderAttributeValue</code> must be the name that is used in the user pool for the user.</p> <p>The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social identity providers. The <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was originally linked as a source user.</p> <p>For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in, the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were used for the <code>SourceUser</code> when the identities were originally linked using <code> AdminLinkProviderForUser</code> call. (If the linking was done with <code>ProviderAttributeName</code> set to <code>Cognito_Subject</code>, the same applies here). However, if the user has already signed in, the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code> must be the subject of the SAML assertion.</p>', 'AdminDisableUser' => '<p>Disables the specified user.</p> <p>Calling this action requires developer credentials.</p>', 'AdminEnableUser' => '<p>Enables the specified user as an administrator. Works on any user.</p> <p>Calling this action requires developer credentials.</p>', 'AdminForgetDevice' => '<p>Forgets the device, as an administrator.</p> <p>Calling this action requires developer credentials.</p>', 'AdminGetDevice' => '<p>Gets the device, as an administrator.</p> <p>Calling this action requires developer credentials.</p>', 'AdminGetUser' => '<p>Gets the specified user by user name in a user pool as an administrator. Works on any user.</p> <p>Calling this action requires developer credentials.</p>', 'AdminInitiateAuth' => '<p>Initiates the authentication flow, as an administrator.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <p>Calling this action requires developer credentials.</p>', 'AdminLinkProviderForUser' => '<p>Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external identity provider (<code>SourceUser</code>) based on a specified attribute name and value from the external identity provider. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in. You can then use the federated user identity to sign in as the existing user account. </p> <p> For example, if there is an existing user with a username and password, this API links that user to a federated user identity. When the user signs in with a federated user identity, they sign in as the existing user account.</p> <note> <p>The maximum number of federated identities linked to a user is 5.</p> </note> <important> <p>Because this API allows a user with an external federated identity to sign in as an existing user in the user pool, it is critical that it only be used with external identity providers and provider attributes that have been trusted by the application owner.</p> </important> <p>This action is administrative and requires developer credentials.</p>', 'AdminListDevices' => '<p>Lists devices, as an administrator.</p> <p>Calling this action requires developer credentials.</p>', 'AdminListGroupsForUser' => '<p>Lists the groups that the user belongs to.</p> <p>Calling this action requires developer credentials.</p>', 'AdminListUserAuthEvents' => '<p>A history of user activity and any risks detected as part of Amazon Cognito advanced security.</p>', 'AdminRemoveUserFromGroup' => '<p>Removes the specified user from the specified group.</p> <p>Calling this action requires developer credentials.</p>', 'AdminResetUserPassword' => '<p>Resets the specified user\'s password in a user pool as an administrator. Works on any user.</p> <p>When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition, if the user pool has phone verification selected and a verified phone number exists for the user, or if email verification is selected and a verified email exists for the user, calling this API will also result in sending a message to the end user with the code to change their password.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <p>Calling this action requires developer credentials.</p>', 'AdminRespondToAuthChallenge' => '<p>Responds to an authentication challenge, as an administrator.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <p>Calling this action requires developer credentials.</p>', 'AdminSetUserMFAPreference' => '<p>The user\'s multi-factor authentication (MFA) preference, including which MFA options are activated, and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in.</p>', 'AdminSetUserPassword' => '<p>Sets the specified user\'s password in a user pool as an administrator. Works on any user. </p> <p>The password can be temporary or permanent. If it is temporary, the user status enters the <code>FORCE_CHANGE_PASSWORD</code> state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth response will contain the <code>NEW_PASSWORD_REQUIRED</code> challenge. If the user doesn\'t sign in before it expires, the user won\'t be able to sign in, and an administrator must reset their password. </p> <p>Once the user has set a new password, or the password is permanent, the user status is set to <code>Confirmed</code>.</p>', 'AdminSetUserSettings' => '<p> <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can\'t use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html">AdminSetUserMFAPreference</a> instead.</p>', 'AdminUpdateAuthEventFeedback' => '<p>Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.</p>', 'AdminUpdateDeviceStatus' => '<p>Updates the device status as an administrator.</p> <p>Calling this action requires developer credentials.</p>', 'AdminUpdateUserAttributes' => '<p>Updates the specified user\'s attributes, including developer attributes, as an administrator. Works on any user.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p> <p>In addition to updating user attributes, this API can also be used to mark phone and email as verified.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note> <p>Calling this action requires developer credentials.</p>', 'AdminUserGlobalSignOut' => '<p>Signs out users from all devices, as an administrator. It also invalidates all refresh tokens issued to a user. The user\'s current access and Id tokens remain valid until their expiry. Access and Id tokens expire one hour after they\'re issued.</p> <p>Calling this action requires developer credentials.</p>', 'AssociateSoftwareToken' => '<p>Returns a unique generated shared secret key code for the user account. The request takes an access token or a session string, but not both.</p> <note> <p>Calling AssociateSoftwareToken immediately disassociates the existing software token from the user account. If the user doesn\'t subsequently verify the software token, their account is set up to authenticate without MFA. If MFA config is set to Optional at the user pool level, the user can then log in without MFA. However, if MFA is set to Required for the user pool, the user is asked to set up a new software token MFA during sign-in.</p> </note>', 'ChangePassword' => '<p>Changes the password for a specified user in a user pool.</p>', 'ConfirmDevice' => '<p>Confirms tracking of the device. This API call is the call that begins device tracking.</p>', 'ConfirmForgotPassword' => '<p>Allows a user to enter a confirmation code to reset a forgotten password.</p>', 'ConfirmSignUp' => '<p>Confirms registration of a user and handles the existing alias from a previous user.</p>', 'CreateGroup' => '<p>Creates a new group in the specified user pool.</p> <p>Calling this action requires developer credentials.</p>', 'CreateIdentityProvider' => '<p>Creates an identity provider for a user pool.</p>', 'CreateResourceServer' => '<p>Creates a new OAuth2.0 resource server and defines custom scopes within it.</p>', 'CreateUserImportJob' => '<p>Creates the user import job.</p>', 'CreateUserPool' => '<p>Creates a new Amazon Cognito user pool and sets the password policy for the pool.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'CreateUserPoolClient' => '<p>Creates the user pool client.</p> <p>When you create a new user pool client, token revocation is automatically activated. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>', 'CreateUserPoolDomain' => '<p>Creates a new domain for a user pool.</p>', 'DeleteGroup' => '<p>Deletes a group.</p> <p>Calling this action requires developer credentials.</p>', 'DeleteIdentityProvider' => '<p>Deletes an identity provider for a user pool.</p>', 'DeleteResourceServer' => '<p>Deletes a resource server.</p>', 'DeleteUser' => '<p>Allows a user to delete himself or herself.</p>', 'DeleteUserAttributes' => '<p>Deletes the attributes for a user.</p>', 'DeleteUserPool' => '<p>Deletes the specified Amazon Cognito user pool.</p>', 'DeleteUserPoolClient' => '<p>Allows the developer to delete the user pool client.</p>', 'DeleteUserPoolDomain' => '<p>Deletes a domain for a user pool.</p>', 'DescribeIdentityProvider' => '<p>Gets information about a specific identity provider.</p>', 'DescribeResourceServer' => '<p>Describes a resource server.</p>', 'DescribeRiskConfiguration' => '<p>Describes the risk configuration.</p>', 'DescribeUserImportJob' => '<p>Describes the user import job.</p>', 'DescribeUserPool' => '<p>Returns the configuration information and metadata of the specified user pool.</p>', 'DescribeUserPoolClient' => '<p>Client method for returning the configuration information and metadata of the specified user pool app client.</p>', 'DescribeUserPoolDomain' => '<p>Gets information about a domain.</p>', 'ForgetDevice' => '<p>Forgets the specified device.</p>', 'ForgotPassword' => '<p>Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user\'s password. For the <code>Username</code> parameter, you can use the username or user alias. The method used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html">Recovering User Accounts</a> in the <i>Amazon Cognito Developer Guide</i>. If neither a verified phone number nor a verified email exists, an <code>InvalidParameterException</code> is thrown. To use the confirmation code for resetting the password, call <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html">ConfirmForgotPassword</a>. </p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'GetCSVHeader' => '<p>Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.</p>', 'GetDevice' => '<p>Gets the device.</p>', 'GetGroup' => '<p>Gets a group.</p> <p>Calling this action requires developer credentials.</p>', 'GetIdentityProviderByIdentifier' => '<p>Gets the specified identity provider.</p>', 'GetSigningCertificate' => '<p>This method takes a user pool ID, and returns the signing certificate.</p>', 'GetUICustomization' => '<p>Gets the user interface (UI) Customization information for a particular app client\'s app UI, if any such information exists for the client. If nothing is set for the particular client, but there is an existing pool level customization (the app <code>clientId</code> is <code>ALL</code>), then that information is returned. If nothing is present, then an empty shape is returned.</p>', 'GetUser' => '<p>Gets the user attributes and metadata for a user.</p>', 'GetUserAttributeVerificationCode' => '<p>Gets the user attribute verification code for the specified attribute name.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'GetUserPoolMfaConfig' => '<p>Gets the user pool multi-factor authentication (MFA) configuration.</p>', 'GlobalSignOut' => '<p>Signs out users from all devices. It also invalidates all refresh tokens issued to a user. The user\'s current access and ID tokens remain valid until their expiry. Access and Id tokens expire one hour after they\'re issued.</p>', 'InitiateAuth' => '<p>Initiates the authentication flow.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'ListDevices' => '<p>Lists the devices.</p>', 'ListGroups' => '<p>Lists the groups associated with a user pool.</p> <p>Calling this action requires developer credentials.</p>', 'ListIdentityProviders' => '<p>Lists information about all identity providers for a user pool.</p>', 'ListResourceServers' => '<p>Lists the resource servers for a user pool.</p>', 'ListTagsForResource' => '<p>Lists the tags that are assigned to an Amazon Cognito user pool.</p> <p>A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p> <p>You can use this action up to 10 times per second, per account.</p>', 'ListUserImportJobs' => '<p>Lists the user import jobs.</p>', 'ListUserPoolClients' => '<p>Lists the clients that have been created for the specified user pool.</p>', 'ListUserPools' => '<p>Lists the user pools associated with an Amazon Web Services account.</p>', 'ListUsers' => '<p>Lists the users in the Amazon Cognito user pool.</p>', 'ListUsersInGroup' => '<p>Lists the users in the specified group.</p> <p>Calling this action requires developer credentials.</p>', 'ResendConfirmationCode' => '<p>Resends the confirmation (for confirmation of registration) to a specific user in the user pool.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'RespondToAuthChallenge' => '<p>Responds to the authentication challenge.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'RevokeToken' => '<p>Revokes all of the access tokens generated by the specified refresh token. After the token is revoked, you can\'t use the revoked token to access Amazon Cognito authenticated APIs.</p>', 'SetRiskConfiguration' => '<p>Configures actions on detected risks. To delete the risk configuration for <code>UserPoolId</code> or <code>ClientId</code>, pass null values for all four configuration types.</p> <p>To activate Amazon Cognito advanced security features, update the user pool to include the <code>UserPoolAddOns</code> key<code>AdvancedSecurityMode</code>.</p>', 'SetUICustomization' => '<p>Sets the user interface (UI) customization information for a user pool\'s built-in app UI.</p> <p>You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the default configuration is used for every client that has no previously set UI customization. If you specify UI customization settings for a particular client, it will no longer return to the <code>ALL</code> configuration.</p> <note> <p>To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the app\'s pages, and the service will throw an error.</p> </note>', 'SetUserMFAPreference' => '<p>Set the user\'s multi-factor authentication (MFA) method preference, including which MFA factors are activated and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.</p>', 'SetUserPoolMfaConfig' => '<p>Sets the user pool multi-factor authentication (MFA) configuration.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'SetUserSettings' => '<p> <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can\'t use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html">SetUserMFAPreference</a> instead.</p>', 'SignUp' => '<p>Registers the user in the specified user pool and creates a user name, password, and user attributes.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'StartUserImportJob' => '<p>Starts the user import.</p>', 'StopUserImportJob' => '<p>Stops the user import job.</p>', 'TagResource' => '<p>Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p> <p>Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of a user pool, one for testing and another for production, you might assign an <code>Environment</code> tag key to both user pools. The value of this key might be <code>Test</code> for one user pool, and <code>Production</code> for the other.</p> <p>Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your user pools. In an Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag values.</p> <p>You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.</p>', 'UntagResource' => '<p>Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second, per account.</p>', 'UpdateAuthEventFeedback' => '<p>Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.</p>', 'UpdateDeviceStatus' => '<p>Updates the device status.</p>', 'UpdateGroup' => '<p>Updates the specified group with the specified attributes.</p> <p>Calling this action requires developer credentials.</p>', 'UpdateIdentityProvider' => '<p>Updates identity provider information for a user pool.</p>', 'UpdateResourceServer' => '<p>Updates the name and scopes of resource server. All other fields are read-only.</p> <important> <p>If you don\'t provide a value for an attribute, it is set to the default value.</p> </important>', 'UpdateUserAttributes' => '<p>Allows a user to update a specific attribute (one at a time).</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'UpdateUserPool' => '<p>Updates the specified user pool with the specified attributes. You can get a list of the current user pool settings using <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html">DescribeUserPool</a>. If you don\'t provide a value for an attribute, it will be set to the default value.</p> <note> <p>This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with <a href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito will use the registered number automatically. Otherwise, Amazon Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in.</p> <p>If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in SMS sandbox. In <i> <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you will have limitations, such as sending messages only to verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"> SMS message settings for Amazon Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </note>', 'UpdateUserPoolClient' => '<p>Updates the specified user pool app client with the specified attributes. You can get a list of the current user pool app client settings using <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html">DescribeUserPoolClient</a>.</p> <important> <p>If you don\'t provide a value for an attribute, it will be set to the default value.</p> </important> <p>You can also use this operation to enable token revocation for user pool clients. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>', 'UpdateUserPoolDomain' => '<p>Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.</p> <p>You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You can\'t use it to change the domain for a user pool.</p> <p>A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom domain.</p> <p>Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new certificate automatically.</p> <p>However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.</p> <p>When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web Services Region.</p> <p>After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your custom domain.</p> <p>For more information about adding a custom domain to your user pool, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using Your Own Domain for the Hosted UI</a>.</p>', 'VerifySoftwareToken' => '<p>Use this API to register a user\'s entered time-based one-time password (TOTP) code and mark the user\'s software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.</p>', 'VerifyUserAttribute' => '<p>Verifies the specified user attributes in the user pool.</p>', ], 'shapes' => [ 'AWSAccountIdType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$AWSAccountId' => '<p>The Amazon Web Services ID for the user pool owner.</p>', ], ], 'AccessTokenValidityType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$AccessTokenValidity' => '<p>The time limit, between 5 minutes and 1 day, after which the access token is no longer valid and can\'t be used. If you supply a TokenValidityUnits value, you will override the default time unit.</p>', 'UpdateUserPoolClientRequest$AccessTokenValidity' => '<p>The time limit after which the access token is no longer valid and can\'t be used.</p>', 'UserPoolClientType$AccessTokenValidity' => '<p>The time limit, specified by tokenValidityUnits, defaulting to hours, after which the access token is no longer valid and can\'t be used.</p>', ], ], 'AccountRecoverySettingType' => [ 'base' => '<p>The data type for <code>AccountRecoverySetting</code>.</p>', 'refs' => [ 'CreateUserPoolRequest$AccountRecoverySetting' => '<p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn\'t qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>', 'UpdateUserPoolRequest$AccountRecoverySetting' => '<p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn\'t qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>', 'UserPoolType$AccountRecoverySetting' => '<p>The available verified method a user can use to recover their password when they call <code>ForgotPassword</code>. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn\'t qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.</p>', ], ], 'AccountTakeoverActionNotifyType' => [ 'base' => NULL, 'refs' => [ 'AccountTakeoverActionType$Notify' => '<p>Flag specifying whether to send a notification.</p>', ], ], 'AccountTakeoverActionType' => [ 'base' => '<p>Account takeover action type.</p>', 'refs' => [ 'AccountTakeoverActionsType$LowAction' => '<p>Action to take for a low risk.</p>', 'AccountTakeoverActionsType$MediumAction' => '<p>Action to take for a medium risk.</p>', 'AccountTakeoverActionsType$HighAction' => '<p>Action to take for a high risk.</p>', ], ], 'AccountTakeoverActionsType' => [ 'base' => '<p>Account takeover actions type.</p>', 'refs' => [ 'AccountTakeoverRiskConfigurationType$Actions' => '<p>Account takeover risk configuration actions.</p>', ], ], 'AccountTakeoverEventActionType' => [ 'base' => NULL, 'refs' => [ 'AccountTakeoverActionType$EventAction' => '<p>The event action.</p> <ul> <li> <p> <code>BLOCK</code> Choosing this action will block the request.</p> </li> <li> <p> <code>MFA_IF_CONFIGURED</code> Present an MFA challenge if user has configured it, else allow the request.</p> </li> <li> <p> <code>MFA_REQUIRED</code> Present an MFA challenge if user has configured it, else block the request.</p> </li> <li> <p> <code>NO_ACTION</code> Allow the user to sign in.</p> </li> </ul>', ], ], 'AccountTakeoverRiskConfigurationType' => [ 'base' => '<p>Configuration for mitigation actions and notification for different levels of risk detected for a potential account takeover.</p>', 'refs' => [ 'RiskConfigurationType$AccountTakeoverRiskConfiguration' => '<p>The account takeover risk configuration object, including the <code>NotifyConfiguration</code> object and <code>Actions</code> to take if there is an account takeover.</p>', 'SetRiskConfigurationRequest$AccountTakeoverRiskConfiguration' => '<p>The account takeover risk configuration.</p>', ], ], 'AddCustomAttributesRequest' => [ 'base' => '<p>Represents the request to add custom attributes.</p>', 'refs' => [], ], 'AddCustomAttributesResponse' => [ 'base' => '<p>Represents the response from the server for the request to add custom attributes.</p>', 'refs' => [], ], 'AdminAddUserToGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminConfirmSignUpRequest' => [ 'base' => '<p>Represents the request to confirm user registration.</p>', 'refs' => [], ], 'AdminConfirmSignUpResponse' => [ 'base' => '<p>Represents the response from the server for the request to confirm registration.</p>', 'refs' => [], ], 'AdminCreateUserConfigType' => [ 'base' => '<p>The configuration for creating a new user profile.</p>', 'refs' => [ 'CreateUserPoolRequest$AdminCreateUserConfig' => '<p>The configuration for <code>AdminCreateUser</code> requests.</p>', 'UpdateUserPoolRequest$AdminCreateUserConfig' => '<p>The configuration for <code>AdminCreateUser</code> requests.</p>', 'UserPoolType$AdminCreateUserConfig' => '<p>The configuration for <code>AdminCreateUser</code> requests.</p>', ], ], 'AdminCreateUserRequest' => [ 'base' => '<p>Represents the request to create a user in the specified user pool.</p>', 'refs' => [], ], 'AdminCreateUserResponse' => [ 'base' => '<p>Represents the response from the server to the request to create the user.</p>', 'refs' => [], ], 'AdminCreateUserUnusedAccountValidityDaysType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserConfigType$UnusedAccountValidityDays' => '<p>The user account expiration limit, in days, after which the account is no longer usable. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter is 7. </p> <note> <p>If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code>, that value will be used, and <code>UnusedAccountValidityDays</code> will be no longer be an available parameter for that user pool.</p> </note>', ], ], 'AdminDeleteUserAttributesRequest' => [ 'base' => '<p>Represents the request to delete user attributes as an administrator.</p>', 'refs' => [], ], 'AdminDeleteUserAttributesResponse' => [ 'base' => '<p>Represents the response received from the server for a request to delete user attributes.</p>', 'refs' => [], ], 'AdminDeleteUserRequest' => [ 'base' => '<p>Represents the request to delete a user as an administrator.</p>', 'refs' => [], ], 'AdminDisableProviderForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminDisableProviderForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminDisableUserRequest' => [ 'base' => '<p>Represents the request to disable the user as an administrator.</p>', 'refs' => [], ], 'AdminDisableUserResponse' => [ 'base' => '<p>Represents the response received from the server to disable the user as an administrator.</p>', 'refs' => [], ], 'AdminEnableUserRequest' => [ 'base' => '<p>Represents the request that enables the user as an administrator.</p>', 'refs' => [], ], 'AdminEnableUserResponse' => [ 'base' => '<p>Represents the response from the server for the request to enable a user as an administrator.</p>', 'refs' => [], ], 'AdminForgetDeviceRequest' => [ 'base' => '<p>Sends the forgot device request, as an administrator.</p>', 'refs' => [], ], 'AdminGetDeviceRequest' => [ 'base' => '<p>Represents the request to get the device, as an administrator.</p>', 'refs' => [], ], 'AdminGetDeviceResponse' => [ 'base' => '<p>Gets the device response, as an administrator.</p>', 'refs' => [], ], 'AdminGetUserRequest' => [ 'base' => '<p>Represents the request to get the specified user as an administrator.</p>', 'refs' => [], ], 'AdminGetUserResponse' => [ 'base' => '<p>Represents the response from the server from the request to get the specified user as an administrator.</p>', 'refs' => [], ], 'AdminInitiateAuthRequest' => [ 'base' => '<p>Initiates the authorization request, as an administrator.</p>', 'refs' => [], ], 'AdminInitiateAuthResponse' => [ 'base' => '<p>Initiates the authentication response, as an administrator.</p>', 'refs' => [], ], 'AdminLinkProviderForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminLinkProviderForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminListDevicesRequest' => [ 'base' => '<p>Represents the request to list devices, as an administrator.</p>', 'refs' => [], ], 'AdminListDevicesResponse' => [ 'base' => '<p>Lists the device\'s response, as an administrator.</p>', 'refs' => [], ], 'AdminListGroupsForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminListGroupsForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminListUserAuthEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminListUserAuthEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminRemoveUserFromGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminResetUserPasswordRequest' => [ 'base' => '<p>Represents the request to reset a user\'s password as an administrator.</p>', 'refs' => [], ], 'AdminResetUserPasswordResponse' => [ 'base' => '<p>Represents the response from the server to reset a user password as an administrator.</p>', 'refs' => [], ], 'AdminRespondToAuthChallengeRequest' => [ 'base' => '<p>The request to respond to the authentication challenge, as an administrator.</p>', 'refs' => [], ], 'AdminRespondToAuthChallengeResponse' => [ 'base' => '<p>Responds to the authentication challenge, as an administrator.</p>', 'refs' => [], ], 'AdminSetUserMFAPreferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminSetUserMFAPreferenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminSetUserPasswordRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminSetUserPasswordResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminSetUserSettingsRequest' => [ 'base' => '<p>You can use this parameter to set an MFA configuration that uses the SMS delivery medium.</p>', 'refs' => [], ], 'AdminSetUserSettingsResponse' => [ 'base' => '<p>Represents the response from the server to set user settings as an administrator.</p>', 'refs' => [], ], 'AdminUpdateAuthEventFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdminUpdateAuthEventFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdminUpdateDeviceStatusRequest' => [ 'base' => '<p>The request to update the device status, as an administrator.</p>', 'refs' => [], ], 'AdminUpdateDeviceStatusResponse' => [ 'base' => '<p>The status response to the request to update the device, as an administrator.</p>', 'refs' => [], ], 'AdminUpdateUserAttributesRequest' => [ 'base' => '<p>Represents the request to update the user\'s attributes as an administrator.</p>', 'refs' => [], ], 'AdminUpdateUserAttributesResponse' => [ 'base' => '<p>Represents the response from the server for the request to update user attributes as an administrator.</p>', 'refs' => [], ], 'AdminUserGlobalSignOutRequest' => [ 'base' => '<p>The request to sign out of all devices, as an administrator.</p>', 'refs' => [], ], 'AdminUserGlobalSignOutResponse' => [ 'base' => '<p>The global sign-out response, as an administrator.</p>', 'refs' => [], ], 'AdvancedSecurityModeType' => [ 'base' => NULL, 'refs' => [ 'UserPoolAddOnsType$AdvancedSecurityMode' => '<p>The advanced security mode.</p>', ], ], 'AliasAttributeType' => [ 'base' => NULL, 'refs' => [ 'AliasAttributesListType$member' => NULL, ], ], 'AliasAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$AliasAttributes' => '<p>Attributes supported as an alias for this user pool. Possible values: <b>phone_number</b>, <b>email</b>, or <b>preferred_username</b>.</p>', 'UserPoolType$AliasAttributes' => '<p>The attributes that are aliased in a user pool.</p>', ], ], 'AliasExistsException' => [ 'base' => '<p>This exception is thrown when a user tries to confirm the account with an email or phone number that has already been supplied as an alias from a different account. This exception tells user that an account with this email or phone already exists.</p>', 'refs' => [], ], 'AnalyticsConfigurationType' => [ 'base' => '<p>The Amazon Pinpoint analytics configuration for collecting metrics for a user pool.</p> <note> <p>In Regions where Pinpoint isn\'t available, User Pools only supports sending events to Amazon Pinpoint projects in us-east-1. In Regions where Pinpoint is available, User Pools will support sending events to Amazon Pinpoint projects within that same Region. </p> </note>', 'refs' => [ 'CreateUserPoolClientRequest$AnalyticsConfiguration' => '<p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note> <p>In Amazon Web Services Regions where isn\'t available, User Pools only supports sending events to Amazon Pinpoint projects in Amazon Web Services Region us-east-1. In Regions where is available, User Pools will support sending events to Amazon Pinpoint projects within that same Region. </p> </note>', 'UpdateUserPoolClientRequest$AnalyticsConfiguration' => '<p>The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.</p> <note> <p>In Amazon Web Services Regions where isn\'t available, User Pools only supports sending events to Amazon Pinpoint projects in us-east-1. In Regions where Pinpoint is available, User Pools will support sending events to Amazon Pinpoint projects within that same Region. </p> </note>', 'UserPoolClientType$AnalyticsConfiguration' => '<p>The Amazon Pinpoint analytics configuration for the user pool client.</p> <note> <p>Amazon Cognito User Pools only supports sending events to Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region, regardless of the Region in which the user pool resides.</p> </note>', ], ], 'AnalyticsMetadataType' => [ 'base' => '<p>An Amazon Pinpoint analytics endpoint.</p> <p>An endpoint uniquely identifies a mobile device, email address, or phone number that can receive messages from Amazon Pinpoint analytics.</p> <note> <p>Amazon Cognito User Pools only supports sending events to Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region, regardless of the Region in which the user pool resides.</p> </note>', 'refs' => [ 'AdminInitiateAuthRequest$AnalyticsMetadata' => '<p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminInitiateAuth</code> calls.</p>', 'AdminRespondToAuthChallengeRequest$AnalyticsMetadata' => '<p>The analytics metadata for collecting Amazon Pinpoint metrics for <code>AdminRespondToAuthChallenge</code> calls.</p>', 'ConfirmForgotPasswordRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmForgotPassword</code> calls.</p>', 'ConfirmSignUpRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ConfirmSignUp</code> calls.</p>', 'ForgotPasswordRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ForgotPassword</code> calls.</p>', 'InitiateAuthRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>InitiateAuth</code> calls.</p>', 'ResendConfirmationCodeRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>ResendConfirmationCode</code> calls.</p>', 'RespondToAuthChallengeRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>RespondToAuthChallenge</code> calls.</p>', 'SignUpRequest$AnalyticsMetadata' => '<p>The Amazon Pinpoint analytics metadata for collecting metrics for <code>SignUp</code> calls.</p>', ], ], 'ArnType' => [ 'base' => NULL, 'refs' => [ 'AnalyticsConfigurationType$ApplicationArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project for integration with the chosen User Pool Client. Amazon Cognito publishes events to the Amazon Pinpointproject declared by the app ARN.</p>', 'AnalyticsConfigurationType$RoleArn' => '<p>The ARN of an Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.</p>', 'CreateGroupRequest$RoleArn' => '<p>The role Amazon Resource Name (ARN) for the group.</p>', 'CreateUserImportJobRequest$CloudWatchLogsRoleArn' => '<p>The role ARN for the Amazon CloudWatch Logs Logging role for the user import job.</p>', 'CustomDomainConfigType$CertificateArn' => '<p>The Amazon Resource Name (ARN) of an Certificate Manager SSL certificate. You use this certificate for the subdomain of your custom domain.</p>', 'CustomEmailLambdaVersionConfigType$LambdaArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito activates to send email notifications to users.</p>', 'CustomSMSLambdaVersionConfigType$LambdaArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito activates to send SMS notifications to users.</p>', 'EmailConfigurationType$SourceArn' => '<p>The ARN of a verified email address in Amazon SES. Amazon Cognito uses this email address in one of the following ways, depending on the value that you specify for the <code>EmailSendingAccount</code> parameter:</p> <ul> <li> <p>If you specify <code>COGNITO_DEFAULT</code>, Amazon Cognito uses this address as the custom FROM address when it emails your users using its built-in email account.</p> </li> <li> <p>If you specify <code>DEVELOPER</code>, Amazon Cognito emails your users with this address by calling Amazon SES on your behalf.</p> </li> </ul>', 'GroupType$RoleArn' => '<p>The role Amazon Resource Name (ARN) for the group.</p>', 'LambdaConfigType$PreSignUp' => '<p>A pre-registration Lambda trigger.</p>', 'LambdaConfigType$CustomMessage' => '<p>A custom Message Lambda trigger.</p>', 'LambdaConfigType$PostConfirmation' => '<p>A post-confirmation Lambda trigger.</p>', 'LambdaConfigType$PreAuthentication' => '<p>A pre-authentication Lambda trigger.</p>', 'LambdaConfigType$PostAuthentication' => '<p>A post-authentication Lambda trigger.</p>', 'LambdaConfigType$DefineAuthChallenge' => '<p>Defines the authentication challenge.</p>', 'LambdaConfigType$CreateAuthChallenge' => '<p>Creates an authentication challenge.</p>', 'LambdaConfigType$VerifyAuthChallengeResponse' => '<p>Verifies the authentication challenge response.</p>', 'LambdaConfigType$PreTokenGeneration' => '<p>A Lambda trigger that is invoked before token generation.</p>', 'LambdaConfigType$UserMigration' => '<p>The user migration Lambda config type.</p>', 'LambdaConfigType$KMSKeyID' => '<p>The Amazon Resource Name (ARN) of an <a href="/kms/latest/developerguide/concepts.html#master_keys">KMS key</a>. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to <code>CustomEmailSender</code> and <code>CustomSMSSender</code>.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>', 'NotifyConfigurationType$SourceArn' => '<p>The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the <code>From</code> parameter.</p>', 'SmsConfigurationType$SnsCallerArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon Web Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html">spending limit</a>. </p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the user pool to assign the tags to.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the user pool that the tags are assigned to.</p>', 'UpdateGroupRequest$RoleArn' => '<p>The new role Amazon Resource Name (ARN) for the group. This is used for setting the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims in the token.</p>', 'UserImportJobType$CloudWatchLogsRoleArn' => '<p>The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for the user import job. For more information, see "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.</p>', 'UserPoolType$Arn' => '<p>The Amazon Resource Name (ARN) for the user pool.</p>', ], ], 'AssociateSoftwareTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSoftwareTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttributeDataType' => [ 'base' => NULL, 'refs' => [ 'SchemaAttributeType$AttributeDataType' => '<p>The attribute data type.</p>', ], ], 'AttributeListType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$UserAttributes' => '<p>An array of name-value pairs that contain user attributes and attribute values to be set for the user to be created. You can create a user without specifying any attributes other than <code>Username</code>. However, any attributes that you specify as required (when creating a user pool or in the <b>Attributes</b> tab of the console) either you should supply (in your call to <code>AdminCreateUser</code>) or the user should supply (when they sign up in response to your welcome message).</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p> <p>To send a message inviting the user to sign up, you must specify the user\'s email address or phone number. You can do this in your call to AdminCreateUser or in the <b>Users</b> tab of the Amazon Cognito console for managing your user pools.</p> <p>In your call to <code>AdminCreateUser</code>, you can set the <code>email_verified</code> attribute to <code>True</code>, and you can set the <code>phone_number_verified</code> attribute to <code>True</code>. You can also do this by calling <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a>.</p> <ul> <li> <p> <b>email</b>: The email address of the user to whom the message that contains the code and username will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code>, or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li> <li> <p> <b>phone_number</b>: The phone number of the user to whom the message that contains the code and username will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code>, or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</p> </li> </ul>', 'AdminCreateUserRequest$ValidationData' => '<p>The user\'s validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user\'s domain.</p> <p>To configure custom validation, you must create a Pre Sign-up Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.</p> <p>The user\'s validation data isn\'t persisted.</p>', 'AdminGetUserResponse$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p>', 'AdminUpdateUserAttributesRequest$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'DeviceType$DeviceAttributes' => '<p>The device attributes.</p>', 'GetUserResponse$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'SignUpRequest$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'SignUpRequest$ValidationData' => '<p>The validation data in the request to register a user.</p>', 'UpdateUserAttributesRequest$UserAttributes' => '<p>An array of name-value pairs representing user attributes.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'UserType$Attributes' => '<p>A container with information about the user type attributes.</p>', ], ], 'AttributeMappingKeyType' => [ 'base' => NULL, 'refs' => [ 'AttributeMappingType$key' => NULL, ], ], 'AttributeMappingType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$AttributeMapping' => '<p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>', 'IdentityProviderType$AttributeMapping' => '<p>A mapping of identity provider attributes to standard and custom user pool attributes.</p>', 'UpdateIdentityProviderRequest$AttributeMapping' => '<p>The identity provider attribute mapping to be changed.</p>', ], ], 'AttributeNameListType' => [ 'base' => NULL, 'refs' => [ 'AdminDeleteUserAttributesRequest$UserAttributeNames' => '<p>An array of strings representing the user attribute names you want to delete.</p> <p>For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.</p>', 'DeleteUserAttributesRequest$UserAttributeNames' => '<p>An array of strings representing the user attribute names you want to delete.</p> <p>For custom attributes, you must prependattach the <code>custom:</code> prefix to the front of the attribute name.</p>', ], ], 'AttributeNameType' => [ 'base' => NULL, 'refs' => [ 'AttributeNameListType$member' => NULL, 'AttributeType$Name' => '<p>The name of the attribute.</p>', 'CodeDeliveryDetailsType$AttributeName' => '<p>The attribute name.</p>', 'GetUserAttributeVerificationCodeRequest$AttributeName' => '<p>The attribute name returned by the server response to get the user attribute verification code.</p>', 'MFAOptionType$AttributeName' => '<p>The attribute name of the MFA option type. The only valid value is <code>phone_number</code>.</p>', 'SearchedAttributeNamesListType$member' => NULL, 'VerifyUserAttributeRequest$AttributeName' => '<p>The attribute name in the request to verify user attributes.</p>', ], ], 'AttributeType' => [ 'base' => '<p>Specifies whether the attribute is standard or custom.</p>', 'refs' => [ 'AttributeListType$member' => NULL, ], ], 'AttributeValueType' => [ 'base' => NULL, 'refs' => [ 'AttributeType$Value' => '<p>The value of the attribute.</p>', ], ], 'AuthEventType' => [ 'base' => '<p>The authentication event type.</p>', 'refs' => [ 'AuthEventsType$member' => NULL, ], ], 'AuthEventsType' => [ 'base' => NULL, 'refs' => [ 'AdminListUserAuthEventsResponse$AuthEvents' => '<p>The response object. It includes the <code>EventID</code>, <code>EventType</code>, <code>CreationDate</code>, <code>EventRisk</code>, and <code>EventResponse</code>.</p>', ], ], 'AuthFlowType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthRequest$AuthFlow' => '<p>The authentication flow for this call to run. The API action will depend on this value. For example:</p> <ul> <li> <p> <code>REFRESH_TOKEN_AUTH</code> will take in a valid refresh token and return new tokens.</p> </li> <li> <p> <code>USER_SRP_AUTH</code> will take in <code>USERNAME</code> and <code>SRP_A</code> and return the Secure Remote Password (SRP) protocol variables to be used for next challenge execution.</p> </li> <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code> will take in <code>USERNAME</code> and <code>PASSWORD</code> and return the next challenge or tokens.</p> </li> </ul> <p>Valid values include:</p> <ul> <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li> <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li> <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li> <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: Non-SRP authentication flow; you can pass in the USERNAME and PASSWORD directly if the flow is enabled for calling the app client.</p> </li> <li> <p> <code>ADMIN_USER_PASSWORD_AUTH</code>: Admin-based user password authentication. This replaces the <code>ADMIN_NO_SRP_AUTH</code> authentication flow. In this flow, Amazon Cognito receives the password in the request instead of using the SRP process to verify passwords.</p> </li> </ul>', 'InitiateAuthRequest$AuthFlow' => '<p>The authentication flow for this call to run. The API action will depend on this value. For example:</p> <ul> <li> <p> <code>REFRESH_TOKEN_AUTH</code> takes in a valid refresh token and returns new tokens.</p> </li> <li> <p> <code>USER_SRP_AUTH</code> takes in <code>USERNAME</code> and <code>SRP_A</code> and returns the SRP variables to be used for next challenge execution.</p> </li> <li> <p> <code>USER_PASSWORD_AUTH</code> takes in <code>USERNAME</code> and <code>PASSWORD</code> and returns the next challenge or tokens.</p> </li> </ul> <p>Valid values include:</p> <ul> <li> <p> <code>USER_SRP_AUTH</code>: Authentication flow for the Secure Remote Password (SRP) protocol.</p> </li> <li> <p> <code>REFRESH_TOKEN_AUTH</code>/<code>REFRESH_TOKEN</code>: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.</p> </li> <li> <p> <code>CUSTOM_AUTH</code>: Custom authentication flow.</p> </li> <li> <p> <code>USER_PASSWORD_AUTH</code>: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if it doesn\'t find the USERNAME in the user pool. </p> </li> </ul> <p> <code>ADMIN_NO_SRP_AUTH</code> isn\'t a valid value.</p>', ], ], 'AuthParametersType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthRequest$AuthParameters' => '<p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you\'re invoking. The required values depend on the value of <code>AuthFlow</code>:</p> <ul> <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>ADMIN_NO_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>PASSWORD</code> (required), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li> </ul>', 'InitiateAuthRequest$AuthParameters' => '<p>The authentication parameters. These are inputs corresponding to the <code>AuthFlow</code> that you\'re invoking. The required values depend on the value of <code>AuthFlow</code>:</p> <ul> <li> <p>For <code>USER_SRP_AUTH</code>: <code>USERNAME</code> (required), <code>SRP_A</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>REFRESH_TOKEN_AUTH/REFRESH_TOKEN</code>: <code>REFRESH_TOKEN</code> (required), <code>SECRET_HASH</code> (required if the app client is configured with a client secret), <code>DEVICE_KEY</code>.</p> </li> <li> <p>For <code>CUSTOM_AUTH</code>: <code>USERNAME</code> (required), <code>SECRET_HASH</code> (if app client is configured with client secret), <code>DEVICE_KEY</code>. To start the authentication flow with password verification, include <code>ChallengeName: SRP_A</code> and <code>SRP_A: (The SRP_A Value)</code>.</p> </li> </ul>', ], ], 'AuthenticationResultType' => [ 'base' => '<p>The authentication result.</p>', 'refs' => [ 'AdminInitiateAuthResponse$AuthenticationResult' => '<p>The result of the authentication response. This is only returned if the caller doesn\'t need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>', 'AdminRespondToAuthChallengeResponse$AuthenticationResult' => '<p>The result returned by the server in response to the authentication request.</p>', 'InitiateAuthResponse$AuthenticationResult' => '<p>The result of the authentication response. This result is only returned if the caller doesn\'t need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, <code>ChallengeName</code>, <code>ChallengeParameters</code>, and <code>Session</code> are returned.</p>', 'RespondToAuthChallengeResponse$AuthenticationResult' => '<p>The result returned by the server in response to the request to respond to the authentication challenge.</p>', ], ], 'BlockedIPRangeListType' => [ 'base' => NULL, 'refs' => [ 'RiskExceptionConfigurationType$BlockedIPRangeList' => '<p>Overrides the risk decision to always block the pre-authentication requests. The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.</p>', ], ], 'BooleanType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserConfigType$AllowAdminCreateUserOnly' => '<p>Set to <code>True</code> if only the administrator is allowed to create user profiles. Set to <code>False</code> if users can sign themselves up via an app.</p>', 'AdminGetUserResponse$Enabled' => '<p>Indicates that the status is <code>enabled</code>.</p>', 'AdminSetUserPasswordRequest$Permanent' => '<p> <code>True</code> if the password is permanent, <code>False</code> if it is temporary.</p>', 'AnalyticsConfigurationType$UserDataShared' => '<p>If <code>UserDataShared</code> is <code>true</code>, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.</p>', 'ConfirmDeviceResponse$UserConfirmationNecessary' => '<p>Indicates whether the user confirmation must confirm the device response.</p>', 'CreateUserPoolClientRequest$AllowedOAuthFlowsUserPoolClient' => '<p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>', 'DeviceConfigurationType$ChallengeRequiredOnNewDevice' => '<p>When true, device authentication can replace SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).</p> <note> <p>Users that sign in with devices that have not been confirmed or remembered will still have to provide a second factor, whether or not ChallengeRequiredOnNewDevice is true, when your user pool requires MFA.</p> </note>', 'DeviceConfigurationType$DeviceOnlyRememberedOnUserPrompt' => '<p>When true, users can opt in to remembering their device. Your app code must use callback functions to return the user\'s choice.</p>', 'PasswordPolicyType$RequireUppercase' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.</p>', 'PasswordPolicyType$RequireLowercase' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.</p>', 'PasswordPolicyType$RequireNumbers' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one number in their password.</p>', 'PasswordPolicyType$RequireSymbols' => '<p>In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.</p>', 'SMSMfaSettingsType$Enabled' => '<p>Specifies whether SMS text message MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>', 'SMSMfaSettingsType$PreferredMfa' => '<p>Specifies whether SMS is the preferred MFA method.</p>', 'SchemaAttributeType$DeveloperOnlyAttribute' => '<note> <p>You should use <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes">WriteAttributes</a> in the user pool client to control how attributes can be mutated for new use cases instead of using <code>DeveloperOnlyAttribute</code>.</p> </note> <p>Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users won\'t be able to modify this attribute using their access token. For example, <code>DeveloperOnlyAttribute</code> can be modified using AdminUpdateUserAttributes but can\'t be updated using UpdateUserAttributes.</p>', 'SchemaAttributeType$Mutable' => '<p>Specifies whether the value of the attribute can be changed.</p> <p>For any user pool attribute that is mapped to an identity provider attribute, you must set this parameter to <code>true</code>. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>', 'SchemaAttributeType$Required' => '<p>Specifies whether a user pool attribute is required. If the attribute is required and the user doesn\'t provide a value, registration or sign-in will fail.</p>', 'SignUpResponse$UserConfirmed' => '<p>A response from the server indicating that a user registration has been confirmed.</p>', 'SoftwareTokenMfaConfigType$Enabled' => '<p>Specifies whether software token MFA is activated.</p>', 'SoftwareTokenMfaSettingsType$Enabled' => '<p>Specifies whether software token MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.</p>', 'SoftwareTokenMfaSettingsType$PreferredMfa' => '<p>Specifies whether software token MFA is the preferred MFA method.</p>', 'UpdateUserPoolClientRequest$AllowedOAuthFlowsUserPoolClient' => '<p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>', 'UserPoolClientType$AllowedOAuthFlowsUserPoolClient' => '<p>Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.</p>', 'UserType$Enabled' => '<p>Specifies whether the user is enabled.</p>', ], ], 'CSSType' => [ 'base' => NULL, 'refs' => [ 'SetUICustomizationRequest$CSS' => '<p>The CSS values in the UI customization.</p>', 'UICustomizationType$CSS' => '<p>The CSS values in the UI customization.</p>', ], ], 'CSSVersionType' => [ 'base' => NULL, 'refs' => [ 'UICustomizationType$CSSVersion' => '<p>The CSS version number.</p>', ], ], 'CallbackURLsListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$CallbackURLs' => '<p>A list of allowed redirect (callback) URLs for the identity providers.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p> <p>App callback URLs such as myapp://example are also supported.</p>', 'UpdateUserPoolClientRequest$CallbackURLs' => '<p>A list of allowed redirect (callback) URLs for the identity providers.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p> <p>App callback URLs such as <code>myapp://example</code> are also supported.</p>', 'UserPoolClientType$CallbackURLs' => '<p>A list of allowed redirect (callback) URLs for the identity providers.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p> <p>App callback URLs such as myapp://example are also supported.</p>', ], ], 'ChallengeName' => [ 'base' => NULL, 'refs' => [ 'ChallengeResponseType$ChallengeName' => '<p>The challenge name.</p>', ], ], 'ChallengeNameType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthResponse$ChallengeName' => '<p>The name of the challenge that you\'re responding to with this call. This is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p> <ul> <li> <p> <code>MFA_SETUP</code>: If MFA is required, users who don\'t have at least one of the MFA methods set up are presented with an <code>MFA_SETUP</code> challenge. The user must set up at least one MFA type to continue to authenticate.</p> </li> <li> <p> <code>SELECT_MFA_TYPE</code>: Selects the MFA type. Valid MFA options are <code>SMS_MFA</code> for text SMS MFA, and <code>SOFTWARE_TOKEN_MFA</code> for time-based one-time password (TOTP) software token MFA.</p> </li> <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li> <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li> <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li> <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated in your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li> <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li> <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: This is returned if you must authenticate with <code>USERNAME</code> and <code>PASSWORD</code> directly. An app client must be enabled to use this flow.</p> </li> <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li> <li> <p> <code>MFA_SETUP</code>: For users who are required to set up an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>, and use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, users will need help from an administrator to add a phone number to their account and then call <code>InitiateAuth</code> again to restart sign-in.</p> </li> </ul>', 'AdminRespondToAuthChallengeRequest$ChallengeName' => '<p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>', 'AdminRespondToAuthChallengeResponse$ChallengeName' => '<p>The name of the challenge. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>', 'InitiateAuthResponse$ChallengeName' => '<p>The name of the challenge that you\'re responding to with this call. This name is returned in the <code>AdminInitiateAuth</code> response if you must pass another challenge.</p> <p>Valid values include the following. Note that all of these challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable) in the parameters.</p> <ul> <li> <p> <code>SMS_MFA</code>: Next challenge is to supply an <code>SMS_MFA_CODE</code>, delivered via SMS.</p> </li> <li> <p> <code>PASSWORD_VERIFIER</code>: Next challenge is to supply <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, and <code>TIMESTAMP</code> after the client-side SRP calculations.</p> </li> <li> <p> <code>CUSTOM_CHALLENGE</code>: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.</p> </li> <li> <p> <code>DEVICE_SRP_AUTH</code>: If device tracking was activated on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.</p> </li> <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code>: Similar to <code>PASSWORD_VERIFIER</code>, but for devices only.</p> </li> <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: For users who are required to change their passwords after successful first login. This challenge should be passed with <code>NEW_PASSWORD</code> and any other required attributes.</p> </li> <li> <p> <code>MFA_SETUP</code>: For users who are required to setup an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters <code>MFA_CAN_SETUP</code> value. </p> <p> To set up software token MFA, use the session returned here from <code>InitiateAuth</code> as an input to <code>AssociateSoftwareToken</code>. Use the session returned by <code>VerifySoftwareToken</code> as an input to <code>RespondToAuthChallenge</code> with challenge name <code>MFA_SETUP</code> to complete sign-in. To set up SMS MFA, an administrator should help the user to add a phone number to their account, and then the user should call <code>InitiateAuth</code> again to restart sign-in.</p> </li> </ul>', 'RespondToAuthChallengeRequest$ChallengeName' => '<p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p> <p> <code>ADMIN_NO_SRP_AUTH</code> isn\'t a valid value.</p>', 'RespondToAuthChallengeResponse$ChallengeName' => '<p>The challenge name. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>', ], ], 'ChallengeParametersType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthResponse$ChallengeParameters' => '<p>The challenge parameters. These are returned to you in the <code>AdminInitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>AdminRespondToAuthChallenge</code>).</p> <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p> <p>The value of the <code>USER_ID_FOR_SRP</code> attribute is the user\'s actual username, not an alias (such as email address or phone number), even if you specified an alias in your call to <code>AdminInitiateAuth</code>. This happens because, in the <code>AdminRespondToAuthChallenge</code> API <code>ChallengeResponses</code>, the <code>USERNAME</code> attribute can\'t be an alias.</p>', 'AdminRespondToAuthChallengeResponse$ChallengeParameters' => '<p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html">AdminInitiateAuth</a>.</p>', 'InitiateAuthResponse$ChallengeParameters' => '<p>The challenge parameters. These are returned in the <code>InitiateAuth</code> response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (<code>RespondToAuthChallenge</code>). </p> <p>All challenges require <code>USERNAME</code> and <code>SECRET_HASH</code> (if applicable).</p>', 'RespondToAuthChallengeResponse$ChallengeParameters' => '<p>The challenge parameters. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a>.</p>', ], ], 'ChallengeResponse' => [ 'base' => NULL, 'refs' => [ 'ChallengeResponseType$ChallengeResponse' => '<p>The challenge response.</p>', ], ], 'ChallengeResponseListType' => [ 'base' => NULL, 'refs' => [ 'AuthEventType$ChallengeResponses' => '<p>The challenge responses.</p>', ], ], 'ChallengeResponseType' => [ 'base' => '<p>The challenge response type.</p>', 'refs' => [ 'ChallengeResponseListType$member' => NULL, ], ], 'ChallengeResponsesType' => [ 'base' => NULL, 'refs' => [ 'AdminRespondToAuthChallengeRequest$ChallengeResponses' => '<p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p> <ul> <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> </li> <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret).</p> <note> <p> <code>PASSWORD_VERIFIER</code> requires <code>DEVICE_KEY</code> when signing in with a remembered device.</p> </note> </li> <li> <p> <code>ADMIN_NO_SRP_AUTH</code>: <code>PASSWORD</code>, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li> <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>, <code>SECRET_HASH</code> (if app client is configured with client secret). </p> </li> <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you must use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li> </ul> <p>The value of the <code>USERNAME</code> attribute must be the user\'s actual username, not an alias (such as an email address or phone number). To make this simpler, the <code>AdminInitiateAuth</code> response includes the actual username value in the <code>USERNAMEUSER_ID_FOR_SRP</code> attribute. This happens even if you specified an alias in your call to <code>AdminInitiateAuth</code>.</p>', 'RespondToAuthChallengeRequest$ChallengeResponses' => '<p>The challenge responses. These are inputs corresponding to the value of <code>ChallengeName</code>, for example:</p> <note> <p> <code>SECRET_HASH</code> (if app client is configured with client secret) applies to all of the inputs that follow (including <code>SOFTWARE_TOKEN_MFA</code>).</p> </note> <ul> <li> <p> <code>SMS_MFA</code>: <code>SMS_MFA_CODE</code>, <code>USERNAME</code>.</p> </li> <li> <p> <code>PASSWORD_VERIFIER</code>: <code>PASSWORD_CLAIM_SIGNATURE</code>, <code>PASSWORD_CLAIM_SECRET_BLOCK</code>, <code>TIMESTAMP</code>, <code>USERNAME</code>.</p> <note> <p> <code>PASSWORD_VERIFIER</code> requires <code>DEVICE_KEY</code> when signing in with a remembered device.</p> </note> </li> <li> <p> <code>NEW_PASSWORD_REQUIRED</code>: <code>NEW_PASSWORD</code>, any other required attributes, <code>USERNAME</code>. </p> </li> <li> <p> <code>SOFTWARE_TOKEN_MFA</code>: <code>USERNAME</code> and <code>SOFTWARE_TOKEN_MFA_CODE</code> are required attributes.</p> </li> <li> <p> <code>DEVICE_SRP_AUTH</code> requires <code>USERNAME</code>, <code>DEVICE_KEY</code>, <code>SRP_A</code> (and <code>SECRET_HASH</code>).</p> </li> <li> <p> <code>DEVICE_PASSWORD_VERIFIER</code> requires everything that <code>PASSWORD_VERIFIER</code> requires, plus <code>DEVICE_KEY</code>.</p> </li> <li> <p> <code>MFA_SETUP</code> requires <code>USERNAME</code>, plus you must use the session value returned by <code>VerifySoftwareToken</code> in the <code>Session</code> parameter.</p> </li> </ul>', ], ], 'ChangePasswordRequest' => [ 'base' => '<p>Represents the request to change a user password.</p>', 'refs' => [], ], 'ChangePasswordResponse' => [ 'base' => '<p>The response from the server to the change password request.</p>', 'refs' => [], ], 'ClientIdType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthRequest$ClientId' => '<p>The app client ID.</p>', 'AdminRespondToAuthChallengeRequest$ClientId' => '<p>The app client ID.</p>', 'ConfirmForgotPasswordRequest$ClientId' => '<p>The app client ID of the app associated with the user pool.</p>', 'ConfirmSignUpRequest$ClientId' => '<p>The ID of the app client associated with the user pool.</p>', 'DeleteUserPoolClientRequest$ClientId' => '<p>The app client ID of the app associated with the user pool.</p>', 'DescribeRiskConfigurationRequest$ClientId' => '<p>The app client ID.</p>', 'DescribeUserPoolClientRequest$ClientId' => '<p>The app client ID of the app associated with the user pool.</p>', 'ForgotPasswordRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'GetUICustomizationRequest$ClientId' => '<p>The client ID for the client app.</p>', 'InitiateAuthRequest$ClientId' => '<p>The app client ID.</p>', 'ResendConfirmationCodeRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'RespondToAuthChallengeRequest$ClientId' => '<p>The app client ID.</p>', 'RevokeTokenRequest$ClientId' => '<p>The client ID for the token that you want to revoke.</p>', 'RiskConfigurationType$ClientId' => '<p>The app client ID.</p>', 'SetRiskConfigurationRequest$ClientId' => '<p>The app client ID. If <code>ClientId</code> is null, then the risk configuration is mapped to <code>userPoolId</code>. When the client ID is null, the same risk configuration is applied to all the clients in the userPool.</p> <p>Otherwise, <code>ClientId</code> is mapped to the client. When the client ID isn\'t null, the user pool configuration is overridden and the risk configuration for the client is used instead.</p>', 'SetUICustomizationRequest$ClientId' => '<p>The client ID for the client app.</p>', 'SignUpRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'UICustomizationType$ClientId' => '<p>The client ID for the client app.</p>', 'UpdateUserPoolClientRequest$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'UserPoolClientDescription$ClientId' => '<p>The ID of the client associated with the user pool.</p>', 'UserPoolClientType$ClientId' => '<p>The ID of the client associated with the user pool.</p>', ], ], 'ClientMetadataType' => [ 'base' => NULL, 'refs' => [ 'AdminConfirmSignUpRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>If your user pool configuration includes triggers, the AdminConfirmSignUp API action invokes the Lambda function that is specified for the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. In this payload, the <code>clientMetadata</code> attribute provides the data that you assigned to the ClientMetadata parameter in your AdminConfirmSignUp request. In your function code in Lambda, you can process the ClientMetadata value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'AdminCreateUserRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminCreateUser API action, Amazon Cognito invokes the function that is assigned to the <i>pre sign-up</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminCreateUser request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'AdminInitiateAuthRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminInitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p> <ul> <li> <p>Pre signup</p> </li> <li> <p>Pre authentication</p> </li> <li> <p>User migration</p> </li> </ul> <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminInitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p> <p>When you use the AdminInitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it doesn\'t provide the ClientMetadata value as input:</p> <ul> <li> <p>Post authentication</p> </li> <li> <p>Custom message</p> </li> <li> <p>Pre token generation</p> </li> <li> <p>Create auth challenge</p> </li> <li> <p>Define auth challenge</p> </li> <li> <p>Verify auth challenge</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'AdminResetUserPasswordRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminResetUserPassword API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminResetUserPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'AdminRespondToAuthChallengeRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminRespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, <i>post authentication</i>, <i>user migration</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge response</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminRespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'AdminUpdateUserAttributesRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminUpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your AdminUpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'ConfirmForgotPasswordRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmForgotPassword API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'ConfirmSignUpRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes the function that is assigned to the <i>post confirmation</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmSignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'ForgotPasswordRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ForgotPassword API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>user migration</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ForgotPassword request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'GetUserAttributeVerificationCodeRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the GetUserAttributeVerificationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your GetUserAttributeVerificationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'InitiateAuthRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the InitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:</p> <ul> <li> <p>Pre signup</p> </li> <li> <p>Pre authentication</p> </li> <li> <p>User migration</p> </li> </ul> <p>When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a <code>validationData</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your InitiateAuth request. In your function code in Lambda, you can process the <code>validationData</code> value to enhance your workflow for your specific needs.</p> <p>When you use the InitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it doesn\'t provide the ClientMetadata value as input:</p> <ul> <li> <p>Post authentication</p> </li> <li> <p>Custom message</p> </li> <li> <p>Pre token generation</p> </li> <li> <p>Create auth challenge</p> </li> <li> <p>Define auth challenge</p> </li> <li> <p>Verify auth challenge</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'ResendConfirmationCodeRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ResendConfirmationCode API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your ResendConfirmationCode request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'RespondToAuthChallengeRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the RespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>post authentication</i>, <i>pre token generation</i>, <i>define auth challenge</i>, <i>create auth challenge</i>, and <i>verify auth challenge</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your RespondToAuthChallenge request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'SignUpRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.</p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the SignUp API action, Amazon Cognito invokes any functions that are assigned to the following triggers: <i>pre sign-up</i>, <i>custom message</i>, and <i>post confirmation</i>. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your SignUp request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', 'UpdateUserAttributesRequest$ClientMetadata' => '<p>A map of custom key-value pairs that you can provide as input for any custom workflows that this action initiates. </p> <p>You create custom workflows by assigning Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the <i>custom message</i> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your function code in Lambda, you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <i>Amazon Cognito Developer Guide</i>.</p> <note> <p>When you use the ClientMetadata parameter, remember that Amazon Cognito won\'t do the following:</p> <ul> <li> <p>Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn\'t include triggers, the ClientMetadata parameter serves no purpose.</p> </li> <li> <p>Validate the ClientMetadata value.</p> </li> <li> <p>Encrypt the ClientMetadata value. Don\'t use Amazon Cognito to provide sensitive information.</p> </li> </ul> </note>', ], ], 'ClientNameType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$ClientName' => '<p>The client name for the user pool client you would like to create.</p>', 'UpdateUserPoolClientRequest$ClientName' => '<p>The client name from the update user pool client request.</p>', 'UserPoolClientDescription$ClientName' => '<p>The client name from the user pool client description.</p>', 'UserPoolClientType$ClientName' => '<p>The client name from the user pool request of the client type.</p>', ], ], 'ClientPermissionListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$ReadAttributes' => '<p>The read attributes.</p>', 'CreateUserPoolClientRequest$WriteAttributes' => '<p>The user pool attributes that the app client can write to.</p> <p>If your app client allows users to sign in through an identity provider, this array must include all attributes that are mapped to identity provider attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If your app client lacks write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a>.</p>', 'UpdateUserPoolClientRequest$ReadAttributes' => '<p>The read-only attributes of the user pool.</p>', 'UpdateUserPoolClientRequest$WriteAttributes' => '<p>The writeable attributes of the user pool.</p>', 'UserPoolClientType$ReadAttributes' => '<p>The Read-only attributes.</p>', 'UserPoolClientType$WriteAttributes' => '<p>The writeable attributes.</p>', ], ], 'ClientPermissionType' => [ 'base' => NULL, 'refs' => [ 'ClientPermissionListType$member' => NULL, ], ], 'ClientSecretType' => [ 'base' => NULL, 'refs' => [ 'RevokeTokenRequest$ClientSecret' => '<p>The secret for the client ID. This is required only if the client ID has a secret.</p>', 'UserPoolClientType$ClientSecret' => '<p>The client secret from the user pool request of the client type.</p>', ], ], 'CodeDeliveryDetailsListType' => [ 'base' => NULL, 'refs' => [ 'UpdateUserAttributesResponse$CodeDeliveryDetailsList' => '<p>The code delivery details list from the server for the request to update user attributes.</p>', ], ], 'CodeDeliveryDetailsType' => [ 'base' => '<p>The code delivery details being returned from the server.</p>', 'refs' => [ 'CodeDeliveryDetailsListType$member' => NULL, 'ForgotPasswordResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server in response to the request to reset a password.</p>', 'GetUserAttributeVerificationCodeResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server in response to the request to get the user attribute verification code.</p>', 'ResendConfirmationCodeResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server in response to the request to resend the confirmation code.</p>', 'SignUpResponse$CodeDeliveryDetails' => '<p>The code delivery details returned by the server response to the user registration request.</p>', ], ], 'CodeDeliveryFailureException' => [ 'base' => '<p>This exception is thrown when a verification code fails to deliver successfully.</p>', 'refs' => [], ], 'CodeMismatchException' => [ 'base' => '<p>This exception is thrown if the provided code doesn\'t match what the server was expecting.</p>', 'refs' => [], ], 'CompletionMessageType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$CompletionMessage' => '<p>The message returned when the user import job is completed.</p>', ], ], 'CompromisedCredentialsActionsType' => [ 'base' => '<p>The compromised credentials actions type.</p>', 'refs' => [ 'CompromisedCredentialsRiskConfigurationType$Actions' => '<p>The compromised credentials risk configuration actions.</p>', ], ], 'CompromisedCredentialsEventActionType' => [ 'base' => NULL, 'refs' => [ 'CompromisedCredentialsActionsType$EventAction' => '<p>The event action.</p>', ], ], 'CompromisedCredentialsRiskConfigurationType' => [ 'base' => '<p>The compromised credentials risk configuration type.</p>', 'refs' => [ 'RiskConfigurationType$CompromisedCredentialsRiskConfiguration' => '<p>The compromised credentials risk configuration object, including the <code>EventFilter</code> and the <code>EventAction</code>.</p>', 'SetRiskConfigurationRequest$CompromisedCredentialsRiskConfiguration' => '<p>The compromised credentials risk configuration.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>This exception is thrown if two or more modifications are happening concurrently.</p>', 'refs' => [], ], 'ConfirmDeviceRequest' => [ 'base' => '<p>Confirms the device request.</p>', 'refs' => [], ], 'ConfirmDeviceResponse' => [ 'base' => '<p>Confirms the device response.</p>', 'refs' => [], ], 'ConfirmForgotPasswordRequest' => [ 'base' => '<p>The request representing the confirmation for a password reset.</p>', 'refs' => [], ], 'ConfirmForgotPasswordResponse' => [ 'base' => '<p>The response from the server that results from a user\'s request to retrieve a forgotten password.</p>', 'refs' => [], ], 'ConfirmSignUpRequest' => [ 'base' => '<p>Represents the request to confirm registration of a user.</p>', 'refs' => [], ], 'ConfirmSignUpResponse' => [ 'base' => '<p>Represents the response from the server for the registration confirmation.</p>', 'refs' => [], ], 'ConfirmationCodeType' => [ 'base' => NULL, 'refs' => [ 'ConfirmForgotPasswordRequest$ConfirmationCode' => '<p>The confirmation code sent by a user\'s request to retrieve a forgotten password. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html">ForgotPassword</a>.</p>', 'ConfirmSignUpRequest$ConfirmationCode' => '<p>The confirmation code sent by a user\'s request to confirm registration.</p>', 'VerifyUserAttributeRequest$Code' => '<p>The verification code in the request to verify user attributes.</p>', ], ], 'ContextDataType' => [ 'base' => '<p>Contextual user data type used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'refs' => [ 'AdminInitiateAuthRequest$ContextData' => '<p>Contextual data such as the user\'s device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'AdminRespondToAuthChallengeRequest$ContextData' => '<p>Contextual data such as the user\'s device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', ], ], 'CreateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserImportJobRequest' => [ 'base' => '<p>Represents the request to create the user import job.</p>', 'refs' => [], ], 'CreateUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to create the user import job.</p>', 'refs' => [], ], 'CreateUserPoolClientRequest' => [ 'base' => '<p>Represents the request to create a user pool client.</p>', 'refs' => [], ], 'CreateUserPoolClientResponse' => [ 'base' => '<p>Represents the response from the server to create a user pool client.</p>', 'refs' => [], ], 'CreateUserPoolDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserPoolDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserPoolRequest' => [ 'base' => '<p>Represents the request to create a user pool.</p>', 'refs' => [], ], 'CreateUserPoolResponse' => [ 'base' => '<p>Represents the response from the server for the request to create a user pool.</p>', 'refs' => [], ], 'CustomAttributeNameType' => [ 'base' => NULL, 'refs' => [ 'SchemaAttributeType$Name' => '<p>A schema attribute of the name type.</p>', ], ], 'CustomAttributesListType' => [ 'base' => NULL, 'refs' => [ 'AddCustomAttributesRequest$CustomAttributes' => '<p>An array of custom attributes, such as Mutable and Name.</p>', ], ], 'CustomDomainConfigType' => [ 'base' => '<p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>', 'refs' => [ 'CreateUserPoolDomainRequest$CustomDomainConfig' => '<p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p> <p>Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.</p> <p>For more information about the hosted domain and custom domains, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html">Configuring a User Pool Domain</a>.</p>', 'DomainDescriptionType$CustomDomainConfig' => '<p>The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.</p>', 'UpdateUserPoolDomainRequest$CustomDomainConfig' => '<p>The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use this object to specify an SSL certificate that is managed by ACM.</p>', ], ], 'CustomEmailLambdaVersionConfigType' => [ 'base' => '<p>A custom email sender Lambda configuration type.</p>', 'refs' => [ 'LambdaConfigType$CustomEmailSender' => '<p>A custom email sender Lambda trigger.</p>', ], ], 'CustomEmailSenderLambdaVersionType' => [ 'base' => NULL, 'refs' => [ 'CustomEmailLambdaVersionConfigType$LambdaVersion' => '<p>Signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is <code>V1_0</code>.</p>', ], ], 'CustomSMSLambdaVersionConfigType' => [ 'base' => '<p>A custom SMS sender Lambda configuration type.</p>', 'refs' => [ 'LambdaConfigType$CustomSMSSender' => '<p>A custom SMS sender Lambda trigger.</p>', ], ], 'CustomSMSSenderLambdaVersionType' => [ 'base' => NULL, 'refs' => [ 'CustomSMSLambdaVersionConfigType$LambdaVersion' => '<p>Signature of the "request" attribute in the "event" information that Amazon Cognito passes to your custom SMS Lambda function. The only supported value is <code>V1_0</code>.</p>', ], ], 'DateType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$UserCreateDate' => '<p>The date the user was created.</p>', 'AdminGetUserResponse$UserLastModifiedDate' => '<p>The date the user was last modified.</p>', 'AuthEventType$CreationDate' => '<p>The creation date</p>', 'DeviceType$DeviceCreateDate' => '<p>The creation date of the device.</p>', 'DeviceType$DeviceLastModifiedDate' => '<p>The last modified date of the device.</p>', 'DeviceType$DeviceLastAuthenticatedDate' => '<p>The date when the device was last authenticated.</p>', 'EventFeedbackType$FeedbackDate' => '<p>The event feedback date.</p>', 'GroupType$LastModifiedDate' => '<p>The date the group was last modified.</p>', 'GroupType$CreationDate' => '<p>The date the group was created.</p>', 'IdentityProviderType$LastModifiedDate' => '<p>The date the identity provider was last modified.</p>', 'IdentityProviderType$CreationDate' => '<p>The date the identity provider was created.</p>', 'ProviderDescription$LastModifiedDate' => '<p>The date the provider was last modified.</p>', 'ProviderDescription$CreationDate' => '<p>The date the provider was added to the user pool.</p>', 'RiskConfigurationType$LastModifiedDate' => '<p>The last modified date.</p>', 'UICustomizationType$LastModifiedDate' => '<p>The last-modified date for the UI customization.</p>', 'UICustomizationType$CreationDate' => '<p>The creation date for the UI customization.</p>', 'UserImportJobType$CreationDate' => '<p>The date the user import job was created.</p>', 'UserImportJobType$StartDate' => '<p>The date when the user import job was started.</p>', 'UserImportJobType$CompletionDate' => '<p>The date when the user import job was completed.</p>', 'UserPoolClientType$LastModifiedDate' => '<p>The date the user pool client was last modified.</p>', 'UserPoolClientType$CreationDate' => '<p>The date the user pool client was created.</p>', 'UserPoolDescriptionType$LastModifiedDate' => '<p>The date the user pool description was last modified.</p>', 'UserPoolDescriptionType$CreationDate' => '<p>The date the user pool description was created.</p>', 'UserPoolType$LastModifiedDate' => '<p>The date the user pool was last modified.</p>', 'UserPoolType$CreationDate' => '<p>The date the user pool was created.</p>', 'UserType$UserCreateDate' => '<p>The creation date of the user.</p>', 'UserType$UserLastModifiedDate' => '<p>The last modified date of the user.</p>', ], ], 'DefaultEmailOptionType' => [ 'base' => NULL, 'refs' => [ 'VerificationMessageTemplateType$DefaultEmailOption' => '<p>The default email option.</p>', ], ], 'DeleteGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserAttributesRequest' => [ 'base' => '<p>Represents the request to delete user attributes.</p>', 'refs' => [], ], 'DeleteUserAttributesResponse' => [ 'base' => '<p>Represents the response from the server to delete user attributes.</p>', 'refs' => [], ], 'DeleteUserPoolClientRequest' => [ 'base' => '<p>Represents the request to delete a user pool client.</p>', 'refs' => [], ], 'DeleteUserPoolDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserPoolDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserPoolRequest' => [ 'base' => '<p>Represents the request to delete a user pool.</p>', 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => '<p>Represents the request to delete a user.</p>', 'refs' => [], ], 'DeliveryMediumListType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$DesiredDeliveryMediums' => '<p>Specify <code>"EMAIL"</code> if email will be used to send the welcome message. Specify <code>"SMS"</code> if the phone number will be used. The default value is <code>"SMS"</code>. You can specify more than one value.</p>', ], ], 'DeliveryMediumType' => [ 'base' => NULL, 'refs' => [ 'CodeDeliveryDetailsType$DeliveryMedium' => '<p>The delivery medium (email message or phone number).</p>', 'DeliveryMediumListType$member' => NULL, 'MFAOptionType$DeliveryMedium' => '<p>The delivery medium to send the MFA code. You can use this parameter to set only the <code>SMS</code> delivery medium value.</p>', ], ], 'DescribeIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRiskConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRiskConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserImportJobRequest' => [ 'base' => '<p>Represents the request to describe the user import job.</p>', 'refs' => [], ], 'DescribeUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to describe the user import job.</p>', 'refs' => [], ], 'DescribeUserPoolClientRequest' => [ 'base' => '<p>Represents the request to describe a user pool client.</p>', 'refs' => [], ], 'DescribeUserPoolClientResponse' => [ 'base' => '<p>Represents the response from the server from a request to describe the user pool client.</p>', 'refs' => [], ], 'DescribeUserPoolDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserPoolDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserPoolRequest' => [ 'base' => '<p>Represents the request to describe the user pool.</p>', 'refs' => [], ], 'DescribeUserPoolResponse' => [ 'base' => '<p>Represents the response to describe the user pool.</p>', 'refs' => [], ], 'DescriptionType' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Description' => '<p>A string containing the description of the group.</p>', 'GroupType$Description' => '<p>A string containing the description of the group.</p>', 'UpdateGroupRequest$Description' => '<p>A string containing the new description of the group.</p>', ], ], 'DeviceConfigurationType' => [ 'base' => '<p>The device tracking configuration for a user pool. A user pool with device tracking deactivated returns a null value.</p> <note> <p>When you provide values for any DeviceConfiguration field, you activate device tracking.</p> </note>', 'refs' => [ 'CreateUserPoolRequest$DeviceConfiguration' => '<p>The device configuration.</p>', 'UpdateUserPoolRequest$DeviceConfiguration' => '<p>Device configuration.</p>', 'UserPoolType$DeviceConfiguration' => '<p>The device configuration.</p>', ], ], 'DeviceKeyType' => [ 'base' => NULL, 'refs' => [ 'AdminForgetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'AdminGetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'AdminUpdateDeviceStatusRequest$DeviceKey' => '<p>The device key.</p>', 'ConfirmDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'DeviceType$DeviceKey' => '<p>The device key.</p>', 'ForgetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'GetDeviceRequest$DeviceKey' => '<p>The device key.</p>', 'NewDeviceMetadataType$DeviceKey' => '<p>The device key.</p>', 'UpdateDeviceStatusRequest$DeviceKey' => '<p>The device key.</p>', ], ], 'DeviceListType' => [ 'base' => NULL, 'refs' => [ 'AdminListDevicesResponse$Devices' => '<p>The devices in the list of devices response.</p>', 'ListDevicesResponse$Devices' => '<p>The devices returned in the list devices response.</p>', ], ], 'DeviceNameType' => [ 'base' => NULL, 'refs' => [ 'ConfirmDeviceRequest$DeviceName' => '<p>The device name.</p>', ], ], 'DeviceRememberedStatusType' => [ 'base' => NULL, 'refs' => [ 'AdminUpdateDeviceStatusRequest$DeviceRememberedStatus' => '<p>The status indicating whether a device has been remembered or not.</p>', 'UpdateDeviceStatusRequest$DeviceRememberedStatus' => '<p>The status of whether a device is remembered.</p>', ], ], 'DeviceSecretVerifierConfigType' => [ 'base' => '<p>The device verifier against which it is authenticated.</p>', 'refs' => [ 'ConfirmDeviceRequest$DeviceSecretVerifierConfig' => '<p>The configuration of the device secret verifier.</p>', ], ], 'DeviceType' => [ 'base' => '<p>The device type.</p>', 'refs' => [ 'AdminGetDeviceResponse$Device' => '<p>The device.</p>', 'DeviceListType$member' => NULL, 'GetDeviceResponse$Device' => '<p>The device.</p>', ], ], 'DomainDescriptionType' => [ 'base' => '<p>A container for information about a domain.</p>', 'refs' => [ 'DescribeUserPoolDomainResponse$DomainDescription' => '<p>A domain description object containing information about the domain.</p>', ], ], 'DomainStatusType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$Status' => '<p>The domain status.</p>', ], ], 'DomainType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolDomainRequest$Domain' => '<p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>', 'CreateUserPoolDomainResponse$CloudFrontDomain' => '<p>The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name Service (DNS) provider.</p>', 'DeleteUserPoolDomainRequest$Domain' => '<p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>', 'DescribeUserPoolDomainRequest$Domain' => '<p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>', 'DomainDescriptionType$Domain' => '<p>The domain string. For custom domains, this is the fully-qualified domain name, such as <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as <code>auth</code>.</p>', 'UpdateUserPoolDomainRequest$Domain' => '<p>The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. One example might be <code>auth.example.com</code>. </p> <p>This string can include only lowercase letters, numbers, and hyphens. Don\'t use a hyphen for the first or last character. Use periods to separate subdomain names.</p>', 'UpdateUserPoolDomainResponse$CloudFrontDomain' => '<p>The Amazon CloudFront endpoint that Amazon Cognito set up when you added the custom domain to your user pool.</p>', 'UserPoolType$Domain' => '<p>The domain prefix, if the user pool has a domain associated with it.</p>', 'UserPoolType$CustomDomain' => '<p>A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. An example of a custom domain name might be <code>auth.example.com</code>.</p> <p>For more information about adding a custom domain to your user pool, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using Your Own Domain for the Hosted UI</a>.</p>', ], ], 'DomainVersionType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$Version' => '<p>The app version.</p>', ], ], 'DuplicateProviderException' => [ 'base' => '<p>This exception is thrown when the provider is already supported by the user pool.</p>', 'refs' => [], ], 'EmailAddressType' => [ 'base' => NULL, 'refs' => [ 'EmailConfigurationType$ReplyToEmailAddress' => '<p>The destination to which the receiver of the email should reply.</p>', ], ], 'EmailConfigurationType' => [ 'base' => '<p>The email configuration type.</p> <note> <p>Amazon Cognito has specific Regions for use with Amazon Simple Email Service. For more information on the supported Regions, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html">Email settings for Amazon Cognito user pools</a>.</p> </note>', 'refs' => [ 'CreateUserPoolRequest$EmailConfiguration' => '<p>The email configuration.</p>', 'UpdateUserPoolRequest$EmailConfiguration' => '<p>Email configuration.</p>', 'UserPoolType$EmailConfiguration' => '<p>The email configuration.</p>', ], ], 'EmailNotificationBodyType' => [ 'base' => NULL, 'refs' => [ 'NotifyEmailType$HtmlBody' => '<p>The email HTML body.</p>', 'NotifyEmailType$TextBody' => '<p>The email text body.</p>', ], ], 'EmailNotificationSubjectType' => [ 'base' => NULL, 'refs' => [ 'NotifyEmailType$Subject' => '<p>The email subject.</p>', ], ], 'EmailSendingAccountType' => [ 'base' => NULL, 'refs' => [ 'EmailConfigurationType$EmailSendingAccount' => '<p>Specifies whether Amazon Cognito emails your users by using its built-in email functionality or your Amazon Simple Email Service email configuration. Specify one of the following values:</p> <dl> <dt>COGNITO_DEFAULT</dt> <dd> <p>When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production environments, the default email limit is less than the required delivery volume. To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.</p> <p>To look up the email delivery limit for the default option, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits in </a> in the <i> Developer Guide</i>.</p> <p>The default FROM address is <code>no-reply@verificationemail.com</code>. To customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p> <p> If EmailSendingAccount is COGNITO_DEFAULT, you can\'t use the following parameters:</p> <ul> <li> <p>EmailVerificationMessage</p> </li> <li> <p>EmailVerificationSubject</p> </li> <li> <p>InviteMessageTemplate.EmailMessage</p> </li> <li> <p>InviteMessageTemplate.EmailSubject</p> </li> <li> <p>VerificationMessageTemplate.EmailMessage</p> </li> <li> <p>VerificationMessageTemplate.EmailMessageByLink</p> </li> <li> <p>VerificationMessageTemplate.EmailSubject,</p> </li> <li> <p>VerificationMessageTemplate.EmailSubjectByLink</p> </li> </ul> <note> <p>DEVELOPER EmailSendingAccount is required.</p> </note> </dd> <dt>DEVELOPER</dt> <dd> <p>When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email from your verified email address. When you use this option, the email delivery limits are the same limits that apply to your Amazon SES verified email address in your Amazon Web Services account.</p> <p>If you use this option, you must provide the ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.</p> <p>Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf. When you update your user pool with this option, Amazon Cognito creates a <i>service-linked role</i>, which is a type of role, in your Amazon Web Services account. This role contains the permissions that allow to access Amazon SES and send email messages with your address. For more information about the service-linked role that Amazon Cognito creates, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using Service-Linked Roles for Amazon Cognito</a> in the <i>Amazon Cognito Developer Guide</i>.</p> </dd> </dl>', ], ], 'EmailVerificationMessageByLinkType' => [ 'base' => NULL, 'refs' => [ 'VerificationMessageTemplateType$EmailMessageByLink' => '<p>The email message template for sending a confirmation link to the user. EmailMessageByLink is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER.</p>', ], ], 'EmailVerificationMessageType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$EmailVerificationMessage' => '<p>A string representing the email verification message. EmailVerificationMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>', 'MessageTemplateType$EmailMessage' => '<p>The message template for email messages. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>', 'UpdateUserPoolRequest$EmailVerificationMessage' => '<p>The contents of the email verification message.</p>', 'UserPoolType$EmailVerificationMessage' => '<p>The contents of the email verification message.</p>', 'VerificationMessageTemplateType$EmailMessage' => '<p>The email message template. EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER. </p>', ], ], 'EmailVerificationSubjectByLinkType' => [ 'base' => NULL, 'refs' => [ 'VerificationMessageTemplateType$EmailSubjectByLink' => '<p>The subject line for the email message template for sending a confirmation link to the user. EmailSubjectByLink is allowed only <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"> EmailSendingAccount</a> is DEVELOPER.</p>', ], ], 'EmailVerificationSubjectType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$EmailVerificationSubject' => '<p>A string representing the email verification subject. EmailVerificationSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>', 'MessageTemplateType$EmailSubject' => '<p>The subject line for email messages. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>', 'UpdateUserPoolRequest$EmailVerificationSubject' => '<p>The subject of the email verification message.</p>', 'UserPoolType$EmailVerificationSubject' => '<p>The subject of the email verification message.</p>', 'VerificationMessageTemplateType$EmailSubject' => '<p>The subject line for the email message template. EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER. </p>', ], ], 'EnableSoftwareTokenMFAException' => [ 'base' => '<p>This exception is thrown when there is a code mismatch and the service fails to configure the software token TOTP multi-factor authentication (MFA).</p>', 'refs' => [], ], 'EventContextDataType' => [ 'base' => '<p>Specifies the user context data captured at the time of an event request.</p>', 'refs' => [ 'AuthEventType$EventContextData' => '<p>The user context data captured at the time of an event request. This value provides additional information about the client from which event the request is received.</p>', ], ], 'EventFeedbackType' => [ 'base' => '<p>Specifies the event feedback type.</p>', 'refs' => [ 'AuthEventType$EventFeedback' => '<p>A flag specifying the user feedback captured at the time of an event request is good or bad. </p>', ], ], 'EventFilterType' => [ 'base' => NULL, 'refs' => [ 'EventFiltersType$member' => NULL, ], ], 'EventFiltersType' => [ 'base' => NULL, 'refs' => [ 'CompromisedCredentialsRiskConfigurationType$EventFilter' => '<p>Perform the action for these events. The default is to perform all events if no event filter is specified.</p>', ], ], 'EventIdType' => [ 'base' => NULL, 'refs' => [ 'AdminUpdateAuthEventFeedbackRequest$EventId' => '<p>The authentication event ID.</p>', 'UpdateAuthEventFeedbackRequest$EventId' => '<p>The event ID.</p>', ], ], 'EventResponseType' => [ 'base' => NULL, 'refs' => [ 'AuthEventType$EventResponse' => '<p>The event response.</p>', ], ], 'EventRiskType' => [ 'base' => '<p>The event risk type.</p>', 'refs' => [ 'AuthEventType$EventRisk' => '<p>The event risk.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'AuthEventType$EventType' => '<p>The event type.</p>', ], ], 'ExpiredCodeException' => [ 'base' => '<p>This exception is thrown if a code has expired.</p>', 'refs' => [], ], 'ExplicitAuthFlowsListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$ExplicitAuthFlows' => '<p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported, in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with the <code>ALLOW_</code> prefix.</p> <p>Valid values include:</p> <ul> <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li> <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li> <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li> <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li> <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li> </ul>', 'UpdateUserPoolClientRequest$ExplicitAuthFlows' => '<p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with values with the <code>ALLOW_</code> prefix.</p> <p>Valid values include:</p> <ul> <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li> <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li> <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li> <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li> <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li> </ul>', 'UserPoolClientType$ExplicitAuthFlows' => '<p>The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code> prefix are no longer supported in favor of new names with the <code>ALLOW_</code> prefix. Note that values with <code>ALLOW_</code> prefix must be used only along with values including the <code>ALLOW_</code> prefix.</p> <p>Valid values include:</p> <ul> <li> <p> <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</p> </li> <li> <p> <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.</p> </li> <li> <p> <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</p> </li> <li> <p> <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP-based authentication.</p> </li> <li> <p> <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.</p> </li> </ul>', ], ], 'ExplicitAuthFlowsType' => [ 'base' => NULL, 'refs' => [ 'ExplicitAuthFlowsListType$member' => NULL, ], ], 'FeedbackValueType' => [ 'base' => NULL, 'refs' => [ 'AdminUpdateAuthEventFeedbackRequest$FeedbackValue' => '<p>The authentication event feedback value.</p>', 'EventFeedbackType$FeedbackValue' => '<p>The event feedback value.</p>', 'UpdateAuthEventFeedbackRequest$FeedbackValue' => '<p>The authentication event feedback value.</p>', ], ], 'ForceAliasCreation' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$ForceAliasCreation' => '<p>This parameter is used only if the <code>phone_number_verified</code> or <code>email_verified</code> attribute is set to <code>True</code>. Otherwise, it is ignored.</p> <p>If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.</p> <p>If this parameter is set to <code>False</code>, the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code>.</p>', 'ConfirmSignUpRequest$ForceAliasCreation' => '<p>Boolean to be specified to force user confirmation irrespective of existing alias. By default set to <code>False</code>. If this parameter is set to <code>True</code> and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to <code>False</code>, the API will throw an <b>AliasExistsException</b> error.</p>', ], ], 'ForgetDeviceRequest' => [ 'base' => '<p>Represents the request to forget the device.</p>', 'refs' => [], ], 'ForgotPasswordRequest' => [ 'base' => '<p>Represents the request to reset a user\'s password.</p>', 'refs' => [], ], 'ForgotPasswordResponse' => [ 'base' => '<p>Respresents the response from the server regarding the request to reset a password.</p>', 'refs' => [], ], 'GenerateSecret' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$GenerateSecret' => '<p>Boolean to specify whether you want to generate a secret for the user pool client being created.</p>', ], ], 'GetCSVHeaderRequest' => [ 'base' => '<p>Represents the request to get the header information of the CSV file for the user import job.</p>', 'refs' => [], ], 'GetCSVHeaderResponse' => [ 'base' => '<p>Represents the response from the server to the request to get the header information of the CSV file for the user import job.</p>', 'refs' => [], ], 'GetDeviceRequest' => [ 'base' => '<p>Represents the request to get the device.</p>', 'refs' => [], ], 'GetDeviceResponse' => [ 'base' => '<p>Gets the device response.</p>', 'refs' => [], ], 'GetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIdentityProviderByIdentifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIdentityProviderByIdentifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSigningCertificateRequest' => [ 'base' => '<p>Request to get a signing certificate from Amazon Cognito.</p>', 'refs' => [], ], 'GetSigningCertificateResponse' => [ 'base' => '<p>Response from Amazon Cognito for a signing certificate request.</p>', 'refs' => [], ], 'GetUICustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUICustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserAttributeVerificationCodeRequest' => [ 'base' => '<p>Represents the request to get user attribute verification.</p>', 'refs' => [], ], 'GetUserAttributeVerificationCodeResponse' => [ 'base' => '<p>The verification code response returned by the server response to get the user attribute verification code.</p>', 'refs' => [], ], 'GetUserPoolMfaConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserPoolMfaConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserRequest' => [ 'base' => '<p>Represents the request to get information about the user.</p>', 'refs' => [], ], 'GetUserResponse' => [ 'base' => '<p>Represents the response from the server from the request to get information about the user.</p>', 'refs' => [], ], 'GlobalSignOutRequest' => [ 'base' => '<p>Represents the request to sign out all devices.</p>', 'refs' => [], ], 'GlobalSignOutResponse' => [ 'base' => '<p>The response to the request to sign out all devices.</p>', 'refs' => [], ], 'GroupExistsException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters a group that already exists in the user pool.</p>', 'refs' => [], ], 'GroupListType' => [ 'base' => NULL, 'refs' => [ 'AdminListGroupsForUserResponse$Groups' => '<p>The groups that the user belongs to.</p>', 'ListGroupsResponse$Groups' => '<p>The group objects for the groups.</p>', ], ], 'GroupNameType' => [ 'base' => NULL, 'refs' => [ 'AdminAddUserToGroupRequest$GroupName' => '<p>The group name.</p>', 'AdminRemoveUserFromGroupRequest$GroupName' => '<p>The group name.</p>', 'CreateGroupRequest$GroupName' => '<p>The name of the group. Must be unique.</p>', 'DeleteGroupRequest$GroupName' => '<p>The name of the group.</p>', 'GetGroupRequest$GroupName' => '<p>The name of the group.</p>', 'GroupType$GroupName' => '<p>The name of the group.</p>', 'ListUsersInGroupRequest$GroupName' => '<p>The name of the group.</p>', 'UpdateGroupRequest$GroupName' => '<p>The name of the group.</p>', ], ], 'GroupType' => [ 'base' => '<p>The group type.</p>', 'refs' => [ 'CreateGroupResponse$Group' => '<p>The group object for the group.</p>', 'GetGroupResponse$Group' => '<p>The group object for the group.</p>', 'GroupListType$member' => NULL, 'UpdateGroupResponse$Group' => '<p>The group object for the group.</p>', ], ], 'HexStringType' => [ 'base' => NULL, 'refs' => [ 'AnalyticsConfigurationType$ApplicationId' => '<p>The application ID for an Amazon Pinpoint application.</p>', ], ], 'HttpHeader' => [ 'base' => '<p>The HTTP header.</p>', 'refs' => [ 'HttpHeaderList$member' => NULL, ], ], 'HttpHeaderList' => [ 'base' => NULL, 'refs' => [ 'ContextDataType$HttpHeaders' => '<p>HttpHeaders received on your server in same order.</p>', ], ], 'IdTokenValidityType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$IdTokenValidity' => '<p>The time limit, between 5 minutes and 1 day, after which the access token is no longer valid and can\'t be used. If you supply a TokenValidityUnits value, you will override the default time unit.</p>', 'UpdateUserPoolClientRequest$IdTokenValidity' => '<p>The time limit after which the ID token is no longer valid and can\'t be used.</p>', 'UserPoolClientType$IdTokenValidity' => '<p>The time limit specified by tokenValidityUnits, defaulting to hours, after which the refresh token is no longer valid and can\'t be used.</p>', ], ], 'IdentityProviderType' => [ 'base' => '<p>A container for information about an identity provider.</p>', 'refs' => [ 'CreateIdentityProviderResponse$IdentityProvider' => '<p>The newly created identity provider object.</p>', 'DescribeIdentityProviderResponse$IdentityProvider' => '<p>The identity provider that was deleted.</p>', 'GetIdentityProviderByIdentifierResponse$IdentityProvider' => '<p>The identity provider object.</p>', 'UpdateIdentityProviderResponse$IdentityProvider' => '<p>The identity provider object.</p>', ], ], 'IdentityProviderTypeType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$ProviderType' => '<p>The identity provider type.</p>', 'IdentityProviderType$ProviderType' => '<p>The identity provider type.</p>', 'ProviderDescription$ProviderType' => '<p>The identity provider type.</p>', ], ], 'IdpIdentifierType' => [ 'base' => NULL, 'refs' => [ 'GetIdentityProviderByIdentifierRequest$IdpIdentifier' => '<p>The identity provider ID.</p>', 'IdpIdentifiersListType$member' => NULL, ], ], 'IdpIdentifiersListType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$IdpIdentifiers' => '<p>A list of identity provider identifiers.</p>', 'IdentityProviderType$IdpIdentifiers' => '<p>A list of identity provider identifiers.</p>', 'UpdateIdentityProviderRequest$IdpIdentifiers' => '<p>A list of identity provider identifiers.</p>', ], ], 'ImageFileType' => [ 'base' => NULL, 'refs' => [ 'SetUICustomizationRequest$ImageFile' => '<p>The uploaded logo image for the UI customization.</p>', ], ], 'ImageUrlType' => [ 'base' => NULL, 'refs' => [ 'UICustomizationType$ImageUrl' => '<p>The logo image for the UI customization.</p>', ], ], 'InitiateAuthRequest' => [ 'base' => '<p>Initiates the authentication request.</p>', 'refs' => [], ], 'InitiateAuthResponse' => [ 'base' => '<p>Initiates the authentication response.</p>', 'refs' => [], ], 'IntegerType' => [ 'base' => NULL, 'refs' => [ 'AuthenticationResultType$ExpiresIn' => '<p>The expiration period of the authentication result in seconds.</p>', 'UserPoolType$EstimatedNumberOfUsers' => '<p>A number estimating the size of the user pool.</p>', ], ], 'InternalErrorException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters an internal error.</p>', 'refs' => [], ], 'InvalidEmailRoleAccessPolicyException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito isn\'t allowed to use your email identity. HTTP status code: 400.</p>', 'refs' => [], ], 'InvalidLambdaResponseException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters an invalid Lambda response.</p>', 'refs' => [], ], 'InvalidOAuthFlowException' => [ 'base' => '<p>This exception is thrown when the specified OAuth flow is not valid.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service encounters an invalid parameter.</p>', 'refs' => [], ], 'InvalidPasswordException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters an invalid password.</p>', 'refs' => [], ], 'InvalidSmsRoleAccessPolicyException' => [ 'base' => '<p>This exception is returned when the role provided for SMS configuration doesn\'t have permission to publish using Amazon SNS.</p>', 'refs' => [], ], 'InvalidSmsRoleTrustRelationshipException' => [ 'base' => '<p>This exception is thrown when the trust relationship is not valid for the role provided for SMS configuration. This can happen if you don\'t trust <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is provided in the SMS configuration for the user pool.</p>', 'refs' => [], ], 'InvalidUserPoolConfigurationException' => [ 'base' => '<p>This exception is thrown when the user pool configuration is not valid.</p>', 'refs' => [], ], 'LambdaConfigType' => [ 'base' => '<p>Specifies the configuration for Lambda triggers.</p>', 'refs' => [ 'CreateUserPoolRequest$LambdaConfig' => '<p>The Lambda trigger configuration information for the new user pool.</p> <note> <p>In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.</p> <p/> <p>For more information on using the Lambda API to add permission, see<a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html"> AddPermission </a>. </p> <p>For adding permission using the CLI, see<a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html"> add-permission </a>.</p> </note>', 'UpdateUserPoolRequest$LambdaConfig' => '<p>The Lambda configuration information from the request to update the user pool.</p>', 'UserPoolDescriptionType$LambdaConfig' => '<p>The Lambda configuration information in a user pool description.</p>', 'UserPoolType$LambdaConfig' => '<p>The Lambda triggers associated with the user pool.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>This exception is thrown when a user exceeds the limit for a requested Amazon Web Services resource.</p>', 'refs' => [], ], 'ListDevicesRequest' => [ 'base' => '<p>Represents the request to list the devices.</p>', 'refs' => [], ], 'ListDevicesResponse' => [ 'base' => '<p>Represents the response to list devices.</p>', 'refs' => [], ], 'ListGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityProvidersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityProvidersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOfStringTypes' => [ 'base' => NULL, 'refs' => [ 'GetCSVHeaderResponse$CSVHeader' => '<p>The header information of the CSV file for the user import job.</p>', ], ], 'ListProvidersLimitType' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProvidersRequest$MaxResults' => '<p>The maximum number of identity providers to return.</p>', ], ], 'ListResourceServersLimitType' => [ 'base' => NULL, 'refs' => [ 'ListResourceServersRequest$MaxResults' => '<p>The maximum number of resource servers to return.</p>', ], ], 'ListResourceServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserImportJobsRequest' => [ 'base' => '<p>Represents the request to list the user import jobs.</p>', 'refs' => [], ], 'ListUserImportJobsResponse' => [ 'base' => '<p>Represents the response from the server to the request to list the user import jobs.</p>', 'refs' => [], ], 'ListUserPoolClientsRequest' => [ 'base' => '<p>Represents the request to list the user pool clients.</p>', 'refs' => [], ], 'ListUserPoolClientsResponse' => [ 'base' => '<p>Represents the response from the server that lists user pool clients.</p>', 'refs' => [], ], 'ListUserPoolsRequest' => [ 'base' => '<p>Represents the request to list user pools.</p>', 'refs' => [], ], 'ListUserPoolsResponse' => [ 'base' => '<p>Represents the response to list user pools.</p>', 'refs' => [], ], 'ListUsersInGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersInGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => '<p>Represents the request to list users.</p>', 'refs' => [], ], 'ListUsersResponse' => [ 'base' => '<p>The response from the request to list users.</p>', 'refs' => [], ], 'LogoutURLsListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$LogoutURLs' => '<p>A list of allowed logout URLs for the identity providers.</p>', 'UpdateUserPoolClientRequest$LogoutURLs' => '<p>A list of allowed logout URLs for the identity providers.</p>', 'UserPoolClientType$LogoutURLs' => '<p>A list of allowed logout URLs for the identity providers.</p>', ], ], 'LongType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$ImportedUsers' => '<p>The number of users that were successfully imported.</p>', 'UserImportJobType$SkippedUsers' => '<p>The number of users that were skipped.</p>', 'UserImportJobType$FailedUsers' => '<p>The number of users that couldn\'t be imported.</p>', ], ], 'MFAMethodNotFoundException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito can\'t find a multi-factor authentication (MFA) method.</p>', 'refs' => [], ], 'MFAOptionListType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$MFAOptions' => '<p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn\'t provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>', 'AdminSetUserSettingsRequest$MFAOptions' => '<p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>', 'GetUserResponse$MFAOptions' => '<p> <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations. It doesn\'t provide information about time-based one-time password (TOTP) software token MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList instead.</p>', 'SetUserSettingsRequest$MFAOptions' => '<p>You can use this parameter only to set an SMS configuration that uses SMS for delivery.</p>', 'UserType$MFAOptions' => '<p>The MFA options for the user.</p>', ], ], 'MFAOptionType' => [ 'base' => '<p> <i>This data type is no longer supported.</i> You can use it only for SMS multi-factor authentication (MFA) configurations. You can\'t use it for time-based one-time password (TOTP) software token MFA configurations.</p>', 'refs' => [ 'MFAOptionListType$member' => NULL, ], ], 'MessageActionType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$MessageAction' => '<p>Set to <code>RESEND</code> to resend the invitation message to a user that already exists and reset the expiration limit on the user\'s account. Set to <code>SUPPRESS</code> to suppress sending the message. You can specify only one value.</p>', ], ], 'MessageTemplateType' => [ 'base' => '<p>The message template structure.</p>', 'refs' => [ 'AdminCreateUserConfigType$InviteMessageTemplate' => '<p>The message template to be used for the welcome message to new users.</p> <p>See also <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization">Customizing User Invitation Messages</a>.</p>', ], ], 'MessageType' => [ 'base' => NULL, 'refs' => [ 'AliasExistsException$message' => '<p>The message sent to the user when an alias exists.</p>', 'CodeDeliveryFailureException$message' => '<p>The message sent when a verification code fails to deliver successfully.</p>', 'CodeMismatchException$message' => '<p>The message provided when the code mismatch exception is thrown.</p>', 'ConcurrentModificationException$message' => '<p>The message provided when the concurrent exception is thrown.</p>', 'DuplicateProviderException$message' => NULL, 'EnableSoftwareTokenMFAException$message' => NULL, 'ExpiredCodeException$message' => '<p>The message returned when the expired code exception is thrown.</p>', 'GroupExistsException$message' => NULL, 'InternalErrorException$message' => '<p>The message returned when Amazon Cognito throws an internal error exception.</p>', 'InvalidEmailRoleAccessPolicyException$message' => '<p>The message returned when you have an unverified email address or the identity policy isn\'t set on an email address that Amazon Cognito can access.</p>', 'InvalidLambdaResponseException$message' => '<p>The message returned when Amazon Cognito hrows an invalid Lambda response exception.</p>', 'InvalidOAuthFlowException$message' => NULL, 'InvalidParameterException$message' => '<p>The message returned when the Amazon Cognito service throws an invalid parameter exception.</p>', 'InvalidPasswordException$message' => '<p>The message returned when Amazon Cognito throws an invalid user password exception.</p>', 'InvalidSmsRoleAccessPolicyException$message' => '<p>The message returned when the invalid SMS role access policy exception is thrown.</p>', 'InvalidSmsRoleTrustRelationshipException$message' => '<p>The message returned when the role trust relationship for the SMS message is not valid.</p>', 'InvalidUserPoolConfigurationException$message' => '<p>The message returned when the user pool configuration is not valid.</p>', 'LimitExceededException$message' => '<p>The message returned when Amazon Cognito throws a limit exceeded exception.</p>', 'MFAMethodNotFoundException$message' => '<p>The message returned when Amazon Cognito throws an MFA method not found exception.</p>', 'NotAuthorizedException$message' => '<p>The message returned when the Amazon Cognito service returns a not authorized exception.</p>', 'PasswordResetRequiredException$message' => '<p>The message returned when a password reset is required.</p>', 'PreconditionNotMetException$message' => '<p>The message returned when a precondition is not met.</p>', 'ResourceNotFoundException$message' => '<p>The message returned when the Amazon Cognito service returns a resource not found exception.</p>', 'ScopeDoesNotExistException$message' => NULL, 'SoftwareTokenMFANotFoundException$message' => NULL, 'TooManyFailedAttemptsException$message' => '<p>The message returned when Amazon Cognito returns a <code>TooManyFailedAttempts</code> exception.</p>', 'TooManyRequestsException$message' => '<p>The message returned when the Amazon Cognito service returns a too many requests exception.</p>', 'UnauthorizedException$message' => NULL, 'UnexpectedLambdaException$message' => '<p>The message returned when Amazon Cognito returns an unexpected Lambda exception.</p>', 'UnsupportedIdentityProviderException$message' => NULL, 'UnsupportedOperationException$message' => NULL, 'UnsupportedTokenTypeException$message' => NULL, 'UnsupportedUserStateException$message' => '<p>The message returned when the user is in an unsupported state.</p>', 'UserImportInProgressException$message' => '<p>The message returned when the user pool has an import job running.</p>', 'UserLambdaValidationException$message' => '<p>The message returned when the Amazon Cognito service returns a user validation exception with the Lambda service.</p>', 'UserNotConfirmedException$message' => '<p>The message returned when a user isn\'t confirmed successfully.</p>', 'UserNotFoundException$message' => '<p>The message returned when a user isn\'t found.</p>', 'UserPoolAddOnNotEnabledException$message' => NULL, 'UserPoolTaggingException$message' => NULL, 'UsernameExistsException$message' => '<p>The message returned when Amazon Cognito throws a user name exists exception.</p>', ], ], 'NewDeviceMetadataType' => [ 'base' => '<p>The new device metadata type.</p>', 'refs' => [ 'AuthenticationResultType$NewDeviceMetadata' => '<p>The new device metadata from an authentication result.</p>', ], ], 'NotAuthorizedException' => [ 'base' => '<p>This exception is thrown when a user isn\'t authorized.</p>', 'refs' => [], ], 'NotifyConfigurationType' => [ 'base' => '<p>The notify configuration type.</p>', 'refs' => [ 'AccountTakeoverRiskConfigurationType$NotifyConfiguration' => '<p>The notify configuration used to construct email notifications.</p>', ], ], 'NotifyEmailType' => [ 'base' => '<p>The notify email type.</p>', 'refs' => [ 'NotifyConfigurationType$BlockEmail' => '<p>Email template used when a detected risk event is blocked.</p>', 'NotifyConfigurationType$NoActionEmail' => '<p>The email template used when a detected risk event is allowed.</p>', 'NotifyConfigurationType$MfaEmail' => '<p>The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk.</p>', ], ], 'NumberAttributeConstraintsType' => [ 'base' => '<p>The minimum and maximum values of an attribute that is of the number data type.</p>', 'refs' => [ 'SchemaAttributeType$NumberAttributeConstraints' => '<p>Specifies the constraints for an attribute of the number type.</p>', ], ], 'OAuthFlowType' => [ 'base' => NULL, 'refs' => [ 'OAuthFlowsType$member' => NULL, ], ], 'OAuthFlowsType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$AllowedOAuthFlows' => '<p>The allowed OAuth flows.</p> <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p> <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p> <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>', 'UpdateUserPoolClientRequest$AllowedOAuthFlows' => '<p>The allowed OAuth flows.</p> <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p> <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p> <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>', 'UserPoolClientType$AllowedOAuthFlows' => '<p>The allowed OAuth flows.</p> <p>Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.</p> <p>Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.</p> <p>Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.</p>', ], ], 'PaginationKey' => [ 'base' => NULL, 'refs' => [ 'AdminListGroupsForUserRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'AdminListGroupsForUserResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'AdminListUserAuthEventsRequest$NextToken' => '<p>A pagination token.</p>', 'AdminListUserAuthEventsResponse$NextToken' => '<p>A pagination token.</p>', 'ListGroupsRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListGroupsResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUserPoolClientsRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUserPoolClientsResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUsersInGroupRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUsersInGroupResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', ], ], 'PaginationKeyType' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProvidersRequest$NextToken' => '<p>A pagination token.</p>', 'ListIdentityProvidersResponse$NextToken' => '<p>A pagination token.</p>', 'ListResourceServersRequest$NextToken' => '<p>A pagination token.</p>', 'ListResourceServersResponse$NextToken' => '<p>A pagination token.</p>', 'ListUserImportJobsRequest$PaginationToken' => '<p>An identifier that was returned from the previous call to <code>ListUserImportJobs</code>, which can be used to return the next set of import jobs in the list.</p>', 'ListUserImportJobsResponse$PaginationToken' => '<p>An identifier that can be used to return the next set of user import jobs in the list.</p>', 'ListUserPoolsRequest$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUserPoolsResponse$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', ], ], 'PasswordPolicyMinLengthType' => [ 'base' => NULL, 'refs' => [ 'PasswordPolicyType$MinimumLength' => '<p>The minimum length of the password in the policy that you have set. This value can\'t be less than 6.</p>', ], ], 'PasswordPolicyType' => [ 'base' => '<p>The password policy type.</p>', 'refs' => [ 'UserPoolPolicyType$PasswordPolicy' => '<p>The password policy.</p>', ], ], 'PasswordResetRequiredException' => [ 'base' => '<p>This exception is thrown when a password reset is required.</p>', 'refs' => [], ], 'PasswordType' => [ 'base' => NULL, 'refs' => [ 'AdminCreateUserRequest$TemporaryPassword' => '<p>The user\'s temporary password. This password must conform to the password policy that you specified when you created the user pool.</p> <p>The temporary password is valid only once. To complete the Admin Create User flow, the user must enter the temporary password in the sign-in page, along with a new password to be used in all future sign-ins.</p> <p>This parameter isn\'t required. If you don\'t specify a value, Amazon Cognito generates one for you.</p> <p>The temporary password can only be used until the user account expiration limit that you specified when you created the user pool. To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter.</p>', 'AdminSetUserPasswordRequest$Password' => '<p>The password for the user.</p>', 'ChangePasswordRequest$PreviousPassword' => '<p>The old password.</p>', 'ChangePasswordRequest$ProposedPassword' => '<p>The new password.</p>', 'ConfirmForgotPasswordRequest$Password' => '<p>The password sent by a user\'s request to retrieve a forgotten password.</p>', 'SignUpRequest$Password' => '<p>The password of the user you want to register.</p>', ], ], 'PoolQueryLimitType' => [ 'base' => NULL, 'refs' => [ 'ListUserImportJobsRequest$MaxResults' => '<p>The maximum number of import jobs you want the request to return.</p>', 'ListUserPoolsRequest$MaxResults' => '<p>The maximum number of results you want the request to return when listing the user pools.</p>', ], ], 'PreSignedUrlType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$PreSignedUrl' => '<p>The pre-signed URL to be used to upload the <code>.csv</code> file.</p>', ], ], 'PrecedenceType' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Precedence' => '<p>A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher ornull <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user\'s tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.</p> <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn\'t set in users\' tokens.</p> <p>The default <code>Precedence</code> value is null.</p>', 'GroupType$Precedence' => '<p>A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower <code>Precedence</code> values take precedence over groups with higher ornull <code>Precedence</code> values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user\'s tokens for the <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims.</p> <p>Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim isn\'t set in users\' tokens.</p> <p>The default <code>Precedence</code> value is null.</p>', 'UpdateGroupRequest$Precedence' => '<p>The new precedence value for the group. For more information about this parameter, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html">CreateGroup</a>.</p>', ], ], 'PreconditionNotMetException' => [ 'base' => '<p>This exception is thrown when a precondition is not met.</p>', 'refs' => [], ], 'PreventUserExistenceErrorTypes' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$PreventUserExistenceErrors' => '<p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn\'t exist in the user pool. When set to <code>ENABLED</code> and the user doesn\'t exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn\'t exist in the user pool.</p> <p>Valid values include:</p> <ul> <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li> <li> <p> <code>LEGACY</code> - This represents the early behavior of Amazon Cognito where user existence related errors aren\'t prevented.</p> </li> </ul>', 'UpdateUserPoolClientRequest$PreventUserExistenceErrors' => '<p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn\'t exist in the user pool. When set to <code>ENABLED</code> and the user doesn\'t exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn\'t exist in the user pool.</p> <p>Valid values include:</p> <ul> <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li> <li> <p> <code>LEGACY</code> - This represents the early behavior of Amazon Cognito where user existence related errors aren\'t prevented.</p> </li> </ul>', 'UserPoolClientType$PreventUserExistenceErrors' => '<p>Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn\'t exist in the user pool. When set to <code>ENABLED</code> and the user doesn\'t exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs return a <code>UserNotFoundException</code> exception if the user doesn\'t exist in the user pool.</p> <p>Valid values include:</p> <ul> <li> <p> <code>ENABLED</code> - This prevents user existence-related errors.</p> </li> <li> <p> <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors aren\'t prevented.</p> </li> </ul>', ], ], 'PriorityType' => [ 'base' => NULL, 'refs' => [ 'RecoveryOptionType$Priority' => '<p>A positive integer specifying priority of a method with 1 being the highest priority.</p>', ], ], 'ProviderDescription' => [ 'base' => '<p>A container for identity provider details.</p>', 'refs' => [ 'ProvidersListType$member' => NULL, ], ], 'ProviderDetailsType' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$ProviderDetails' => '<p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p> <ul> <li> <p>For Google and Login with Amazon:</p> <ul> <li> <p>client_id</p> </li> <li> <p>client_secret</p> </li> <li> <p>authorize_scopes</p> </li> </ul> </li> <li> <p>For Facebook:</p> <ul> <li> <p>client_id</p> </li> <li> <p>client_secret</p> </li> <li> <p>authorize_scopes</p> </li> <li> <p>api_version</p> </li> </ul> </li> <li> <p>For Sign in with Apple:</p> <ul> <li> <p>client_id</p> </li> <li> <p>team_id</p> </li> <li> <p>key_id</p> </li> <li> <p>private_key</p> </li> <li> <p>authorize_scopes</p> </li> </ul> </li> <li> <p>For OpenID Connect (OIDC) providers:</p> <ul> <li> <p>client_id</p> </li> <li> <p>client_secret</p> </li> <li> <p>attributes_request_method</p> </li> <li> <p>oidc_issuer</p> </li> <li> <p>authorize_scopes</p> </li> <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p>attributes_url_add_attributes <i>a read-only property that is set automatically</i> </p> </li> </ul> </li> <li> <p>For SAML providers:</p> <ul> <li> <p>MetadataFile OR MetadataURL</p> </li> <li> <p>IDPSignout (optional)</p> </li> </ul> </li> </ul>', 'IdentityProviderType$ProviderDetails' => '<p>The identity provider details. The following list describes the provider detail keys for each identity provider type.</p> <ul> <li> <p>For Google and Login with Amazon:</p> <ul> <li> <p>client_id</p> </li> <li> <p>client_secret</p> </li> <li> <p>authorize_scopes</p> </li> </ul> </li> <li> <p>For Facebook:</p> <ul> <li> <p>client_id</p> </li> <li> <p>client_secret</p> </li> <li> <p>authorize_scopes</p> </li> <li> <p>api_version</p> </li> </ul> </li> <li> <p>For Sign in with Apple:</p> <ul> <li> <p>client_id</p> </li> <li> <p>team_id</p> </li> <li> <p>key_id</p> </li> <li> <p>private_key</p> </li> <li> <p>authorize_scopes</p> </li> </ul> </li> <li> <p>For OIDC providers:</p> <ul> <li> <p>client_id</p> </li> <li> <p>client_secret</p> </li> <li> <p>attributes_request_method</p> </li> <li> <p>oidc_issuer</p> </li> <li> <p>authorize_scopes</p> </li> <li> <p>authorize_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p>token_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p>attributes_url <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p>jwks_uri <i>if not available from discovery URL specified by oidc_issuer key</i> </p> </li> <li> <p>attributes_url_add_attributes <i>a read-only property that is set automatically</i> </p> </li> </ul> </li> <li> <p>For SAML providers:</p> <ul> <li> <p>MetadataFile or MetadataURL</p> </li> <li> <p>IDPSignOut <i>optional</i> </p> </li> </ul> </li> </ul>', 'UpdateIdentityProviderRequest$ProviderDetails' => '<p>The identity provider details to be updated, such as <code>MetadataURL</code> and <code>MetadataFile</code>.</p>', ], ], 'ProviderNameType' => [ 'base' => NULL, 'refs' => [ 'DeleteIdentityProviderRequest$ProviderName' => '<p>The identity provider name.</p>', 'DescribeIdentityProviderRequest$ProviderName' => '<p>The identity provider name.</p>', 'IdentityProviderType$ProviderName' => '<p>The identity provider name.</p>', 'ProviderDescription$ProviderName' => '<p>The identity provider name.</p>', 'ProviderUserIdentifierType$ProviderName' => '<p>The name of the provider, such as Facebook, Google, or Login with Amazon.</p>', 'SupportedIdentityProvidersListType$member' => NULL, 'UpdateIdentityProviderRequest$ProviderName' => '<p>The identity provider name.</p>', ], ], 'ProviderNameTypeV1' => [ 'base' => NULL, 'refs' => [ 'CreateIdentityProviderRequest$ProviderName' => '<p>The identity provider name.</p>', ], ], 'ProviderUserIdentifierType' => [ 'base' => '<p>A container for information about an identity provider for a user pool.</p>', 'refs' => [ 'AdminDisableProviderForUserRequest$User' => '<p>The user to be disabled.</p>', 'AdminLinkProviderForUserRequest$DestinationUser' => '<p>The existing user in the user pool to be linked to the external identity provider user account. Can be a native (Username + Password) Amazon Cognito User Pools user or a federated user (for example, a SAML or Facebook user). If the user doesn\'t exist, an exception is thrown. This is the user that is returned when the new user (with the linked identity provider attribute) signs in.</p> <p>For a native username + password user, the <code>ProviderAttributeValue</code> for the <code>DestinationUser</code> should be the username in the user pool. For a federated user, it should be the provider-specific <code>user_id</code>.</p> <p>The <code>ProviderAttributeName</code> of the <code>DestinationUser</code> is ignored.</p> <p>The <code>ProviderName</code> should be set to <code>Cognito</code> for users in Cognito user pools.</p> <important> <p>All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable custom attributes, the operation won\'t succeed.</p> </important>', 'AdminLinkProviderForUserRequest$SourceUser' => '<p>An external identity provider account for a user who doesn\'t exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.</p> <p>If the <code>SourceUser</code> is using a federated social identity provider, such as Facebook, Google, or Login with Amazon, you must set the <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>. For social identity providers, the <code>ProviderName</code> will be <code>Facebook</code>, <code>Google</code>, or <code>LoginWithAmazon</code>, and Amazon Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for <code>id</code>, <code>sub</code>, and <code>user_id</code>, respectively. The <code>ProviderAttributeValue</code> for the user must be the same value as the <code>id</code>, <code>sub</code>, or <code>user_id</code> value found in the social identity provider token.</p> <p/> <p>For SAML, the <code>ProviderAttributeName</code> can be any value that matches a claim in the SAML assertion. If you want to link SAML users based on the subject of the SAML assertion, you should map the subject to a claim through the SAML identity provider and submit that claim name as the <code>ProviderAttributeName</code>. If you set <code>ProviderAttributeName</code> to <code>Cognito_Subject</code>, Amazon Cognito will automatically parse the default unique identifier found in the subject from the SAML token.</p>', ], ], 'ProvidersListType' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProvidersResponse$Providers' => '<p>A list of identity provider objects.</p>', ], ], 'QueryLimit' => [ 'base' => NULL, 'refs' => [ 'ListUserPoolClientsRequest$MaxResults' => '<p>The maximum number of results you want the request to return when listing the user pool clients.</p>', ], ], 'QueryLimitType' => [ 'base' => NULL, 'refs' => [ 'AdminListDevicesRequest$Limit' => '<p>The limit of the devices request.</p>', 'AdminListGroupsForUserRequest$Limit' => '<p>The limit of the request to list groups.</p>', 'AdminListUserAuthEventsRequest$MaxResults' => '<p>The maximum number of authentication events to return.</p>', 'ListDevicesRequest$Limit' => '<p>The limit of the device request.</p>', 'ListGroupsRequest$Limit' => '<p>The limit of the request to list groups.</p>', 'ListUsersInGroupRequest$Limit' => '<p>The limit of the request to list users.</p>', 'ListUsersRequest$Limit' => '<p>Maximum number of users to be returned.</p>', ], ], 'RecoveryMechanismsType' => [ 'base' => NULL, 'refs' => [ 'AccountRecoverySettingType$RecoveryMechanisms' => '<p>The list of <code>RecoveryOptionTypes</code>.</p>', ], ], 'RecoveryOptionNameType' => [ 'base' => NULL, 'refs' => [ 'RecoveryOptionType$Name' => '<p>The recovery method for a user.</p>', ], ], 'RecoveryOptionType' => [ 'base' => '<p>A map containing a priority as a key, and recovery method name as a value.</p>', 'refs' => [ 'RecoveryMechanismsType$member' => NULL, ], ], 'RedirectUrlType' => [ 'base' => NULL, 'refs' => [ 'CallbackURLsListType$member' => NULL, 'CreateUserPoolClientRequest$DefaultRedirectURI' => '<p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p> <p>App callback URLs such as myapp://example are also supported.</p>', 'LogoutURLsListType$member' => NULL, 'UpdateUserPoolClientRequest$DefaultRedirectURI' => '<p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for <code>http://localhost</code> for testing purposes only.</p> <p>App callback URLs such as <code>myapp://example</code> are also supported.</p>', 'UserPoolClientType$DefaultRedirectURI' => '<p>The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p> <p>A redirect URI must:</p> <ul> <li> <p>Be an absolute URI.</p> </li> <li> <p>Be registered with the authorization server.</p> </li> <li> <p>Not include a fragment component.</p> </li> </ul> <p>See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.</p> <p>Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.</p> <p>App callback URLs such as myapp://example are also supported.</p>', ], ], 'RefreshTokenValidityType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$RefreshTokenValidity' => '<p>The time limit, in days, after which the refresh token is no longer valid and can\'t be used.</p>', 'UpdateUserPoolClientRequest$RefreshTokenValidity' => '<p>The time limit, in days, after which the refresh token is no longer valid and can\'t be used.</p>', 'UserPoolClientType$RefreshTokenValidity' => '<p>The time limit, in days, after which the refresh token is no longer valid and can\'t be used.</p>', ], ], 'ResendConfirmationCodeRequest' => [ 'base' => '<p>Represents the request to resend the confirmation code.</p>', 'refs' => [], ], 'ResendConfirmationCodeResponse' => [ 'base' => '<p>The response from the server when Amazon Cognito makes the request to resend a confirmation code.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service can\'t find the requested resource.</p>', 'refs' => [], ], 'ResourceServerIdentifierType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceServerRequest$Identifier' => '<p>A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the resource server is located, such as <code>https://my-weather-api.example.com</code>.</p>', 'DeleteResourceServerRequest$Identifier' => '<p>The identifier for the resource server.</p>', 'DescribeResourceServerRequest$Identifier' => '<p>The identifier for the resource server</p>', 'ResourceServerType$Identifier' => '<p>The identifier for the resource server.</p>', 'UpdateResourceServerRequest$Identifier' => '<p>The identifier for the resource server.</p>', ], ], 'ResourceServerNameType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceServerRequest$Name' => '<p>A friendly name for the resource server.</p>', 'ResourceServerType$Name' => '<p>The name of the resource server.</p>', 'UpdateResourceServerRequest$Name' => '<p>The name of the resource server.</p>', ], ], 'ResourceServerScopeDescriptionType' => [ 'base' => NULL, 'refs' => [ 'ResourceServerScopeType$ScopeDescription' => '<p>A description of the scope.</p>', ], ], 'ResourceServerScopeListType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceServerRequest$Scopes' => '<p>A list of scopes. Each scope is a key-value map with the keys <code>name</code> and <code>description</code>.</p>', 'ResourceServerType$Scopes' => '<p>A list of scopes that are defined for the resource server.</p>', 'UpdateResourceServerRequest$Scopes' => '<p>The scope values to be set for the resource server.</p>', ], ], 'ResourceServerScopeNameType' => [ 'base' => NULL, 'refs' => [ 'ResourceServerScopeType$ScopeName' => '<p>The name of the scope.</p>', ], ], 'ResourceServerScopeType' => [ 'base' => '<p>A resource server scope.</p>', 'refs' => [ 'ResourceServerScopeListType$member' => NULL, ], ], 'ResourceServerType' => [ 'base' => '<p>A container for information about a resource server for a user pool.</p>', 'refs' => [ 'CreateResourceServerResponse$ResourceServer' => '<p>The newly created resource server.</p>', 'DescribeResourceServerResponse$ResourceServer' => '<p>The resource server.</p>', 'ResourceServersListType$member' => NULL, 'UpdateResourceServerResponse$ResourceServer' => '<p>The resource server.</p>', ], ], 'ResourceServersListType' => [ 'base' => NULL, 'refs' => [ 'ListResourceServersResponse$ResourceServers' => '<p>The resource servers.</p>', ], ], 'RespondToAuthChallengeRequest' => [ 'base' => '<p>The request to respond to an authentication challenge.</p>', 'refs' => [], ], 'RespondToAuthChallengeResponse' => [ 'base' => '<p>The response to respond to the authentication challenge.</p>', 'refs' => [], ], 'RevokeTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokeTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'RiskConfigurationType' => [ 'base' => '<p>The risk configuration type.</p>', 'refs' => [ 'DescribeRiskConfigurationResponse$RiskConfiguration' => '<p>The risk configuration.</p>', 'SetRiskConfigurationResponse$RiskConfiguration' => '<p>The risk configuration.</p>', ], ], 'RiskDecisionType' => [ 'base' => NULL, 'refs' => [ 'EventRiskType$RiskDecision' => '<p>The risk decision.</p>', ], ], 'RiskExceptionConfigurationType' => [ 'base' => '<p>The type of the configuration to override the risk decision.</p>', 'refs' => [ 'RiskConfigurationType$RiskExceptionConfiguration' => '<p>The configuration to override the risk decision.</p>', 'SetRiskConfigurationRequest$RiskExceptionConfiguration' => '<p>The configuration to override the risk decision.</p>', ], ], 'RiskLevelType' => [ 'base' => NULL, 'refs' => [ 'EventRiskType$RiskLevel' => '<p>The risk level.</p>', ], ], 'S3BucketType' => [ 'base' => NULL, 'refs' => [ 'DomainDescriptionType$S3Bucket' => '<p>The Amazon S3 bucket where the static files for this domain are stored.</p>', ], ], 'SESConfigurationSet' => [ 'base' => NULL, 'refs' => [ 'EmailConfigurationType$ConfigurationSet' => '<p>The set of configuration rules that can be applied to emails sent using Amazon Simple Email Service. A configuration set is applied to an email by including a reference to the configuration set in the headers of the email. Once applied, all of the rules in that configuration set are applied to the email. Configuration sets can be used to apply the following types of rules to emails: </p> <ul> <li> <p>Event publishing – Amazon Simple Email Service can track the number of send, delivery, open, click, bounce, and complaint events for each email sent. Use event publishing to send information about these events to other Amazon Web Services services such as and Amazon CloudWatch.</p> </li> <li> <p>IP pool management – When leasing dedicated IP addresses with Amazon Simple Email Service, you can create groups of IP addresses, called dedicated IP pools. You can then associate the dedicated IP pools with configuration sets.</p> </li> </ul>', ], ], 'SMSMfaSettingsType' => [ 'base' => '<p>The type used for enabling SMS multi-factor authentication (MFA) at the user level. Phone numbers don\'t need to be verified to be used for SMS MFA. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted. If you would like MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.</p>', 'refs' => [ 'AdminSetUserMFAPreferenceRequest$SMSMfaSettings' => '<p>The SMS text message MFA settings.</p>', 'SetUserMFAPreferenceRequest$SMSMfaSettings' => '<p>The SMS text message multi-factor authentication (MFA) settings.</p>', ], ], 'SchemaAttributeType' => [ 'base' => '<p>Contains information about the schema attribute.</p>', 'refs' => [ 'CustomAttributesListType$member' => NULL, 'SchemaAttributesListType$member' => NULL, ], ], 'SchemaAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$Schema' => '<p>An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.</p>', 'UserPoolType$SchemaAttributes' => '<p>A container with the schema attributes of a user pool.</p>', ], ], 'ScopeDoesNotExistException' => [ 'base' => '<p>This exception is thrown when the specified scope doesn\'t exist.</p>', 'refs' => [], ], 'ScopeListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$AllowedOAuthScopes' => '<p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>', 'UpdateUserPoolClientRequest$AllowedOAuthScopes' => '<p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>', 'UserPoolClientType$AllowedOAuthScopes' => '<p>The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by Amazon Web Services are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.</p>', ], ], 'ScopeType' => [ 'base' => NULL, 'refs' => [ 'ScopeListType$member' => NULL, ], ], 'SearchPaginationTokenType' => [ 'base' => NULL, 'refs' => [ 'AdminListDevicesRequest$PaginationToken' => '<p>The pagination token.</p>', 'AdminListDevicesResponse$PaginationToken' => '<p>The pagination token.</p>', 'ListDevicesRequest$PaginationToken' => '<p>The pagination token for the list request.</p>', 'ListDevicesResponse$PaginationToken' => '<p>The pagination token for the list device response.</p>', 'ListUsersRequest$PaginationToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListUsersResponse$PaginationToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', ], ], 'SearchedAttributeNamesListType' => [ 'base' => NULL, 'refs' => [ 'ListUsersRequest$AttributesToGet' => '<p>An array of strings, where each string is the name of a user attribute to be returned for each user in the search results. If the array is null, all attributes are returned.</p>', ], ], 'SecretCodeType' => [ 'base' => NULL, 'refs' => [ 'AssociateSoftwareTokenResponse$SecretCode' => '<p>A unique generated shared secret code that is used in the time-based one-time password (TOTP) algorithm to generate a one-time code.</p>', ], ], 'SecretHashType' => [ 'base' => NULL, 'refs' => [ 'ConfirmForgotPasswordRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'ConfirmSignUpRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'ForgotPasswordRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'ResendConfirmationCodeRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', 'SignUpRequest$SecretHash' => '<p>A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.</p>', ], ], 'SessionType' => [ 'base' => NULL, 'refs' => [ 'AdminInitiateAuthResponse$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. If <code>AdminInitiateAuth</code> or <code>AdminRespondToAuthChallenge</code> API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>AdminRespondToAuthChallenge</code> API call.</p>', 'AdminRespondToAuthChallengeRequest$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. If an <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller must pass another challenge, it returns a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'AdminRespondToAuthChallengeResponse$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'AssociateSoftwareTokenRequest$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>', 'AssociateSoftwareTokenResponse$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process.</p>', 'InitiateAuthResponse$Session' => '<p>The session that should pass both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'RespondToAuthChallengeRequest$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. If <code>InitiateAuth</code> or <code>RespondToAuthChallenge</code> API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'RespondToAuthChallengeResponse$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.</p>', 'VerifySoftwareTokenRequest$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service.</p>', 'VerifySoftwareTokenResponse$Session' => '<p>The session that should be passed both ways in challenge-response calls to the service.</p>', ], ], 'SetRiskConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetRiskConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetUICustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetUICustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetUserMFAPreferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetUserMFAPreferenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetUserPoolMfaConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetUserPoolMfaConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetUserSettingsRequest' => [ 'base' => '<p>Represents the request to set user settings.</p>', 'refs' => [], ], 'SetUserSettingsResponse' => [ 'base' => '<p>The response from the server for a set user settings request.</p>', 'refs' => [], ], 'SignUpRequest' => [ 'base' => '<p>Represents the request to register a user.</p>', 'refs' => [], ], 'SignUpResponse' => [ 'base' => '<p>The response from the server for a registration request.</p>', 'refs' => [], ], 'SkippedIPRangeListType' => [ 'base' => NULL, 'refs' => [ 'RiskExceptionConfigurationType$SkippedIPRangeList' => '<p>Risk detection isn\'t performed on the IP addresses in this range list. The IP range is in CIDR notation.</p>', ], ], 'SmsConfigurationType' => [ 'base' => '<p>The SMS configuration type that includes the settings the Amazon Cognito User Pool must call for the Amazon Simple Notification Service service to send an SMS message from your Amazon Web Services account. The Amazon Cognito User Pool makes the request to the Amazon SNS Service by using an Identity and Access Management role that you provide for your Amazon Web Services account.</p>', 'refs' => [ 'CreateUserPoolRequest$SmsConfiguration' => '<p>The SMS configuration.</p>', 'SmsMfaConfigType$SmsConfiguration' => '<p>The SMS configuration.</p>', 'UpdateUserPoolRequest$SmsConfiguration' => '<p>SMS configuration.</p>', 'UserPoolType$SmsConfiguration' => '<p>The SMS configuration.</p>', ], ], 'SmsMfaConfigType' => [ 'base' => '<p>The SMS text message multi-factor authentication (MFA) configuration type.</p>', 'refs' => [ 'GetUserPoolMfaConfigResponse$SmsMfaConfiguration' => '<p>The SMS text message multi-factor (MFA) configuration.</p>', 'SetUserPoolMfaConfigRequest$SmsMfaConfiguration' => '<p>The SMS text message MFA configuration.</p>', 'SetUserPoolMfaConfigResponse$SmsMfaConfiguration' => '<p>The SMS text message MFA configuration.</p>', ], ], 'SmsVerificationMessageType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$SmsVerificationMessage' => '<p>A string representing the SMS verification message.</p>', 'CreateUserPoolRequest$SmsAuthenticationMessage' => '<p>A string representing the SMS authentication message.</p>', 'MessageTemplateType$SMSMessage' => '<p>The message template for SMS messages.</p>', 'SmsMfaConfigType$SmsAuthenticationMessage' => '<p>The SMS authentication message that will be sent to users with the code they must sign in. The message must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn\'t included, and default message will be used.</p>', 'UpdateUserPoolRequest$SmsVerificationMessage' => '<p>A container with information about the SMS verification message.</p>', 'UpdateUserPoolRequest$SmsAuthenticationMessage' => '<p>The contents of the SMS authentication message.</p>', 'UserPoolType$SmsVerificationMessage' => '<p>The contents of the SMS verification message.</p>', 'UserPoolType$SmsAuthenticationMessage' => '<p>The contents of the SMS authentication message.</p>', 'VerificationMessageTemplateType$SmsMessage' => '<p>The SMS message template.</p>', ], ], 'SoftwareTokenMFANotFoundException' => [ 'base' => '<p>This exception is thrown when the software token time-based one-time password (TOTP) multi-factor authentication (MFA) isn\'t activated for the user pool.</p>', 'refs' => [], ], 'SoftwareTokenMFAUserCodeType' => [ 'base' => NULL, 'refs' => [ 'VerifySoftwareTokenRequest$UserCode' => '<p>The one- time password computed using the secret code returned by <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html">AssociateSoftwareToken</a>.</p>', ], ], 'SoftwareTokenMfaConfigType' => [ 'base' => '<p>The type used for enabling software token MFA at the user pool level.</p>', 'refs' => [ 'GetUserPoolMfaConfigResponse$SoftwareTokenMfaConfiguration' => '<p>The software token multi-factor (MFA) configuration.</p>', 'SetUserPoolMfaConfigRequest$SoftwareTokenMfaConfiguration' => '<p>The software token MFA configuration.</p>', 'SetUserPoolMfaConfigResponse$SoftwareTokenMfaConfiguration' => '<p>The software token MFA configuration.</p>', ], ], 'SoftwareTokenMfaSettingsType' => [ 'base' => '<p>The type used for enabling software token MFA at the user level. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.</p>', 'refs' => [ 'AdminSetUserMFAPreferenceRequest$SoftwareTokenMfaSettings' => '<p>The time-based one-time password software token MFA settings.</p>', 'SetUserMFAPreferenceRequest$SoftwareTokenMfaSettings' => '<p>The time-based one-time password software token MFA settings.</p>', ], ], 'StartUserImportJobRequest' => [ 'base' => '<p>Represents the request to start the user import job.</p>', 'refs' => [], ], 'StartUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to start the user import job.</p>', 'refs' => [], ], 'StatusType' => [ 'base' => NULL, 'refs' => [ 'UserPoolDescriptionType$Status' => '<p>The user pool status in a user pool description.</p>', 'UserPoolType$Status' => '<p>The status of a user pool.</p>', ], ], 'StopUserImportJobRequest' => [ 'base' => '<p>Represents the request to stop the user import job.</p>', 'refs' => [], ], 'StopUserImportJobResponse' => [ 'base' => '<p>Represents the response from the server to the request to stop the user import job.</p>', 'refs' => [], ], 'StringAttributeConstraintsType' => [ 'base' => '<p>The constraints associated with a string attribute.</p>', 'refs' => [ 'SchemaAttributeType$StringAttributeConstraints' => '<p>Specifies the constraints for an attribute of the string type.</p>', ], ], 'StringType' => [ 'base' => NULL, 'refs' => [ 'AdminDisableProviderForUserRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminGetUserResponse$PreferredMfaSetting' => '<p>The user\'s preferred MFA setting.</p>', 'AdminLinkProviderForUserRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AnalyticsConfigurationType$ExternalId' => '<p>The external ID.</p>', 'AnalyticsMetadataType$AnalyticsEndpointId' => '<p>The endpoint ID.</p>', 'AttributeMappingType$value' => NULL, 'AuthEventType$EventId' => '<p>The event ID.</p>', 'AuthParametersType$key' => NULL, 'AuthParametersType$value' => NULL, 'AuthenticationResultType$TokenType' => '<p>The token type.</p>', 'BlockedIPRangeListType$member' => NULL, 'ChallengeParametersType$key' => NULL, 'ChallengeParametersType$value' => NULL, 'ChallengeResponsesType$key' => NULL, 'ChallengeResponsesType$value' => NULL, 'ClientMetadataType$key' => NULL, 'ClientMetadataType$value' => NULL, 'CodeDeliveryDetailsType$Destination' => '<p>The destination for the code delivery details.</p>', 'ContextDataType$IpAddress' => '<p>Source IP address of your user.</p>', 'ContextDataType$ServerName' => '<p>Your server endpoint where this API is invoked.</p>', 'ContextDataType$ServerPath' => '<p>Your server path where this API is invoked.</p>', 'ContextDataType$EncodedData' => '<p>Encoded data containing device fingerprinting details collected using the Amazon Cognito context data collection library.</p>', 'DeviceSecretVerifierConfigType$PasswordVerifier' => '<p>The password verifier.</p>', 'DeviceSecretVerifierConfigType$Salt' => '<p>The salt.</p>', 'DomainDescriptionType$CloudFrontDistribution' => '<p>The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.</p>', 'EmailConfigurationType$From' => '<p>Either the sender’s email address or the sender’s name with their email address. For example, <code>testuser@example.com</code> or <code>Test User &lt;testuser@example.com&gt;</code>. This address appears before the body of the email.</p>', 'EventContextDataType$IpAddress' => '<p>The user\'s IP address.</p>', 'EventContextDataType$DeviceName' => '<p>The user\'s device name.</p>', 'EventContextDataType$Timezone' => '<p>The user\'s time zone.</p>', 'EventContextDataType$City' => '<p>The user\'s city.</p>', 'EventContextDataType$Country' => '<p>The user\'s country.</p>', 'EventFeedbackType$Provider' => '<p>The provider.</p>', 'GetSigningCertificateResponse$Certificate' => '<p>The signing certificate.</p>', 'GetUserResponse$PreferredMfaSetting' => '<p>The user\'s preferred MFA setting.</p>', 'HttpHeader$headerName' => '<p>The header name.</p>', 'HttpHeader$headerValue' => '<p>The header value.</p>', 'ListOfStringTypes$member' => NULL, 'NewDeviceMetadataType$DeviceGroupKey' => '<p>The device group key.</p>', 'NotifyConfigurationType$From' => '<p>The email address that is sending the email. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.</p>', 'NotifyConfigurationType$ReplyTo' => '<p>The destination to which the receiver of an email should reply to.</p>', 'NumberAttributeConstraintsType$MinValue' => '<p>The minimum value of an attribute that is of the number data type.</p>', 'NumberAttributeConstraintsType$MaxValue' => '<p>The maximum value of an attribute that is of the number data type.</p>', 'ProviderDetailsType$key' => NULL, 'ProviderDetailsType$value' => NULL, 'ProviderUserIdentifierType$ProviderAttributeName' => '<p>The name of the provider attribute to link to, such as <code>NameID</code>.</p>', 'ProviderUserIdentifierType$ProviderAttributeValue' => '<p>The value of the provider attribute to link to, such as <code>xxxxx_account</code>.</p>', 'SignUpResponse$UserSub' => '<p>The UUID of the authenticated user. This isn\'t the same as <code>username</code>.</p>', 'SkippedIPRangeListType$member' => NULL, 'SmsConfigurationType$ExternalId' => '<p>The external ID is a value that you should use to add security to your IAM role that is used to call Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code>, the Amazon Cognito User Pool will include it when attempting to assume your IAM role so that you can set your roles trust policy to require the <code>ExternalID</code>. If you use the Amazon Cognito Management Console to create a role for SMS multi-factor authentication (MFA), Amazon Cognito will create a role with the required permissions and a trust policy that demonstrates use of the <code>ExternalId</code>.</p> <p>For more information about the <code>ExternalId</code> of a role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to use an external ID when granting access to your Amazon Web Services resources to a third party</a> </p>', 'StringAttributeConstraintsType$MinLength' => '<p>The minimum length.</p>', 'StringAttributeConstraintsType$MaxLength' => '<p>The maximum length.</p>', 'UserContextDataType$EncodedData' => '<p>Contextual data, such as the user\'s device fingerprint, IP address, or location, used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'UserMFASettingListType$member' => NULL, 'UserPoolType$SmsConfigurationFailure' => '<p>The reason why the SMS configuration can\'t send the messages to your users.</p> <p>This message might include comma-separated values to describe why your SMS configuration can\'t send messages to user pool end users.</p> <ul> <li> <p>InvalidSmsRoleAccessPolicyException - The Identity and Access Management role that Amazon Cognito uses to send SMS messages isn\'t properly configured. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html">SmsConfigurationType</a>.</p> </li> <li> <p>SNSSandbox - The Amazon Web Services account is in SNS Sandbox and messages will only reach verified end users. This parameter won’t get populated with SNSSandbox if the IAM user creating the user pool doesn’t have SNS permissions. To learn how to move your Amazon Web Services account out of the sandbox, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html">Moving out of the SMS sandbox</a>.</p> </li> </ul>', 'UserPoolType$EmailConfigurationFailure' => '<p>The reason why the email configuration can\'t send the messages to your users.</p>', 'VerifySoftwareTokenRequest$FriendlyDeviceName' => '<p>The friendly device name.</p>', ], ], 'SupportedIdentityProvidersListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$SupportedIdentityProviders' => '<p>A list of provider names for the identity providers that are supported on this client. The following are supported: <code>COGNITO</code>, <code>Facebook</code>, <code>Google</code> and <code>LoginWithAmazon</code>.</p>', 'UpdateUserPoolClientRequest$SupportedIdentityProviders' => '<p>A list of provider names for the identity providers that are supported on this client.</p>', 'UserPoolClientType$SupportedIdentityProviders' => '<p>A list of provider names for the identity providers that are supported on this client.</p>', ], ], 'TagKeysType' => [ 'base' => NULL, 'refs' => [ 'UserPoolTagsListType$member' => NULL, 'UserPoolTagsType$key' => NULL, ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValueType' => [ 'base' => NULL, 'refs' => [ 'UserPoolTagsType$value' => NULL, ], ], 'TemporaryPasswordValidityDaysType' => [ 'base' => NULL, 'refs' => [ 'PasswordPolicyType$TemporaryPasswordValidityDays' => '<p>The number of days a temporary password is valid in the password policy. If the user doesn\'t sign in during this time, an administrator must reset their password.</p> <note> <p>When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set the deprecated <code>UnusedAccountValidityDays</code> value for that user pool.</p> </note>', ], ], 'TimeUnitsType' => [ 'base' => NULL, 'refs' => [ 'TokenValidityUnitsType$AccessToken' => '<p> A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in AccessTokenValidity, defaulting to hours.</p>', 'TokenValidityUnitsType$IdToken' => '<p>A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in IdTokenValidity, defaulting to hours.</p>', 'TokenValidityUnitsType$RefreshToken' => '<p>A time unit in “seconds”, “minutes”, “hours”, or “days” for the value in RefreshTokenValidity, defaulting to days.</p>', ], ], 'TokenModelType' => [ 'base' => NULL, 'refs' => [ 'AssociateSoftwareTokenRequest$AccessToken' => '<p>The access token.</p>', 'AuthenticationResultType$AccessToken' => '<p>The access token.</p>', 'AuthenticationResultType$RefreshToken' => '<p>The refresh token.</p>', 'AuthenticationResultType$IdToken' => '<p>The ID token.</p>', 'ChangePasswordRequest$AccessToken' => '<p>The access token.</p>', 'ConfirmDeviceRequest$AccessToken' => '<p>The access token.</p>', 'DeleteUserAttributesRequest$AccessToken' => '<p>The access token used in the request to delete user attributes.</p>', 'DeleteUserRequest$AccessToken' => '<p>The access token from a request to delete a user.</p>', 'ForgetDeviceRequest$AccessToken' => '<p>The access token for the forgotten device request.</p>', 'GetDeviceRequest$AccessToken' => '<p>The access token.</p>', 'GetUserAttributeVerificationCodeRequest$AccessToken' => '<p>The access token returned by the server response to get the user attribute verification code.</p>', 'GetUserRequest$AccessToken' => '<p>The access token returned by the server response to get information about the user.</p>', 'GlobalSignOutRequest$AccessToken' => '<p>The access token.</p>', 'ListDevicesRequest$AccessToken' => '<p>The access tokens for the request to list devices.</p>', 'RevokeTokenRequest$Token' => '<p>The refresh token that you want to revoke.</p>', 'SetUserMFAPreferenceRequest$AccessToken' => '<p>The access token for the user.</p>', 'SetUserSettingsRequest$AccessToken' => '<p>The access token for the set user settings request.</p>', 'UpdateAuthEventFeedbackRequest$FeedbackToken' => '<p>The feedback token.</p>', 'UpdateDeviceStatusRequest$AccessToken' => '<p>The access token.</p>', 'UpdateUserAttributesRequest$AccessToken' => '<p>The access token for the request to update user attributes.</p>', 'VerifySoftwareTokenRequest$AccessToken' => '<p>The access token.</p>', 'VerifyUserAttributeRequest$AccessToken' => '<p>The access token of the request to verify user attributes.</p>', ], ], 'TokenValidityUnitsType' => [ 'base' => '<p>The data type for TokenValidityUnits that specifics the time measurements for token validity.</p>', 'refs' => [ 'CreateUserPoolClientRequest$TokenValidityUnits' => '<p>The units in which the validity times are represented. Default for RefreshToken is days, and default for ID and access tokens are hours.</p>', 'UpdateUserPoolClientRequest$TokenValidityUnits' => '<p>The units in which the validity times are represented. Default for RefreshToken is days, and default for ID and access tokens is hours.</p>', 'UserPoolClientType$TokenValidityUnits' => '<p>The time units used to specify the token validity times of their respective token.</p>', ], ], 'TooManyFailedAttemptsException' => [ 'base' => '<p>This exception is thrown when the user has made too many failed attempts for a given action, such as sign-in.</p>', 'refs' => [], ], 'TooManyRequestsException' => [ 'base' => '<p>This exception is thrown when the user has made too many requests for a given operation.</p>', 'refs' => [], ], 'UICustomizationType' => [ 'base' => '<p>A container for the UI customization information for a user pool\'s built-in app UI.</p>', 'refs' => [ 'GetUICustomizationResponse$UICustomization' => '<p>The UI customization information.</p>', 'SetUICustomizationResponse$UICustomization' => '<p>The UI customization information.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>Exception that is thrown when the request isn\'t authorized. This can happen due to an invalid access token in the request.</p>', 'refs' => [], ], 'UnexpectedLambdaException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters an unexpected exception with Lambda.</p>', 'refs' => [], ], 'UnsupportedIdentityProviderException' => [ 'base' => '<p>This exception is thrown when the specified identifier isn\'t supported.</p>', 'refs' => [], ], 'UnsupportedOperationException' => [ 'base' => '<p>Exception that is thrown when you attempt to perform an operation that isn\'t enabled for the user pool client.</p>', 'refs' => [], ], 'UnsupportedTokenTypeException' => [ 'base' => '<p>Exception that is thrown when an unsupported token is passed to an operation.</p>', 'refs' => [], ], 'UnsupportedUserStateException' => [ 'base' => '<p>The request failed because the user is in an unsupported state.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAuthEventFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAuthEventFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeviceStatusRequest' => [ 'base' => '<p>Represents the request to update the device status.</p>', 'refs' => [], ], 'UpdateDeviceStatusResponse' => [ 'base' => '<p>The response to the request to update the device status.</p>', 'refs' => [], ], 'UpdateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentityProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdentityProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserAttributesRequest' => [ 'base' => '<p>Represents the request to update user attributes.</p>', 'refs' => [], ], 'UpdateUserAttributesResponse' => [ 'base' => '<p>Represents the response from the server for the request to update user attributes.</p>', 'refs' => [], ], 'UpdateUserPoolClientRequest' => [ 'base' => '<p>Represents the request to update the user pool client.</p>', 'refs' => [], ], 'UpdateUserPoolClientResponse' => [ 'base' => '<p>Represents the response from the server to the request to update the user pool client.</p>', 'refs' => [], ], 'UpdateUserPoolDomainRequest' => [ 'base' => '<p>The UpdateUserPoolDomain request input.</p>', 'refs' => [], ], 'UpdateUserPoolDomainResponse' => [ 'base' => '<p>The UpdateUserPoolDomain response output.</p>', 'refs' => [], ], 'UpdateUserPoolRequest' => [ 'base' => '<p>Represents the request to update the user pool.</p>', 'refs' => [], ], 'UpdateUserPoolResponse' => [ 'base' => '<p>Represents the response from the server when you make a request to update the user pool.</p>', 'refs' => [], ], 'UserContextDataType' => [ 'base' => '<p>Contextual data, such as the user\'s device fingerprint, IP address, or location, used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'refs' => [ 'ConfirmForgotPasswordRequest$UserContextData' => '<p>Contextual data such as the user\'s device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'ConfirmSignUpRequest$UserContextData' => '<p>Contextual data such as the user\'s device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'ForgotPasswordRequest$UserContextData' => '<p>Contextual data such as the user\'s device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'InitiateAuthRequest$UserContextData' => '<p>Contextual data such as the user\'s device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'ResendConfirmationCodeRequest$UserContextData' => '<p>Contextual data such as the user\'s device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'RespondToAuthChallengeRequest$UserContextData' => '<p>Contextual data such as the user\'s device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', 'SignUpRequest$UserContextData' => '<p>Contextual data such as the user\'s device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.</p>', ], ], 'UserFilterType' => [ 'base' => NULL, 'refs' => [ 'ListUsersRequest$Filter' => '<p>A filter string of the form "<i>AttributeName</i> <i>Filter-Type</i> "<i>AttributeValue</i>"". Quotation marks within the filter string must be escaped using the backslash (\\) character. For example, "<code>family_name</code> = \\"Reddy\\"".</p> <ul> <li> <p> <i>AttributeName</i>: The name of the attribute to search for. You can only search for one attribute at a time.</p> </li> <li> <p> <i>Filter-Type</i>: For an exact match, use =, for example, "<code>given_name</code> = \\"Jon\\"". For a prefix ("starts with") match, use ^=, for example, "<code>given_name</code> ^= \\"Jon\\"". </p> </li> <li> <p> <i>AttributeValue</i>: The attribute value that must be matched for each user.</p> </li> </ul> <p>If the filter string is empty, <code>ListUsers</code> returns all users in the user pool.</p> <p>You can only search for the following standard attributes:</p> <ul> <li> <p> <code>username</code> (case-sensitive)</p> </li> <li> <p> <code>email</code> </p> </li> <li> <p> <code>phone_number</code> </p> </li> <li> <p> <code>name</code> </p> </li> <li> <p> <code>given_name</code> </p> </li> <li> <p> <code>family_name</code> </p> </li> <li> <p> <code>preferred_username</code> </p> </li> <li> <p> <code>cognito:user_status</code> (called <b>Status</b> in the Console) (case-insensitive)</p> </li> <li> <p> <code>status (called <b>Enabled</b> in the Console) (case-sensitive)</code> </p> </li> <li> <p> <code>sub</code> </p> </li> </ul> <p>Custom attributes aren\'t searchable.</p> <note> <p>You can also list users with a client-side filter. The server-side filter matches no more than 1 attribute. For an advanced search, use a client-side filter with the <code>--query</code> parameter of the <code>list-users</code> action in the CLI. When you use a client-side filter, ListUsers returns a paginated list of zero or more users. You can receive multiple pages in a row with zero results. Repeat the query with each pagination token that is returned until you receive a null pagination token value, and then review the combined result. </p> <p>For more information about server-side and client-side filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">FilteringCLI output</a> in the <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Command Line Interface User Guide</a>. </p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api">Searching for Users Using the ListUsers API</a> and <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples">Examples of Using the ListUsers API</a> in the <i>Amazon Cognito Developer Guide</i>.</p>', ], ], 'UserImportInProgressException' => [ 'base' => '<p>This exception is thrown when you\'re trying to modify a user pool while a user import job is in progress for that pool.</p>', 'refs' => [], ], 'UserImportJobIdType' => [ 'base' => NULL, 'refs' => [ 'DescribeUserImportJobRequest$JobId' => '<p>The job ID for the user import job.</p>', 'StartUserImportJobRequest$JobId' => '<p>The job ID for the user import job.</p>', 'StopUserImportJobRequest$JobId' => '<p>The job ID for the user import job.</p>', 'UserImportJobType$JobId' => '<p>The job ID for the user import job.</p>', ], ], 'UserImportJobNameType' => [ 'base' => NULL, 'refs' => [ 'CreateUserImportJobRequest$JobName' => '<p>The job name for the user import job.</p>', 'UserImportJobType$JobName' => '<p>The job name for the user import job.</p>', ], ], 'UserImportJobStatusType' => [ 'base' => NULL, 'refs' => [ 'UserImportJobType$Status' => '<p>The status of the user import job. One of the following:</p> <ul> <li> <p> <code>Created</code> - The job was created but not started.</p> </li> <li> <p> <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users yet.</p> </li> <li> <p> <code>InProgress</code> - The job has started, and users are being imported.</p> </li> <li> <p> <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.</p> </li> <li> <p> <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.</p> </li> <li> <p> <code>Succeeded</code> - The job has completed successfully.</p> </li> <li> <p> <code>Failed</code> - The job has stopped due to an error.</p> </li> <li> <p> <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated with the job was deleted, and the job can\'t be started.</p> </li> </ul>', ], ], 'UserImportJobType' => [ 'base' => '<p>The user import job type.</p>', 'refs' => [ 'CreateUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'DescribeUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'StartUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'StopUserImportJobResponse$UserImportJob' => '<p>The job object that represents the user import job.</p>', 'UserImportJobsListType$member' => NULL, ], ], 'UserImportJobsListType' => [ 'base' => NULL, 'refs' => [ 'ListUserImportJobsResponse$UserImportJobs' => '<p>The user import jobs.</p>', ], ], 'UserLambdaValidationException' => [ 'base' => '<p>This exception is thrown when the Amazon Cognito service encounters a user validation exception with the Lambda service.</p>', 'refs' => [], ], 'UserMFASettingListType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$UserMFASettingList' => '<p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>', 'GetUserResponse$UserMFASettingList' => '<p>The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.</p>', ], ], 'UserNotConfirmedException' => [ 'base' => '<p>This exception is thrown when a user isn\'t confirmed successfully.</p>', 'refs' => [], ], 'UserNotFoundException' => [ 'base' => '<p>This exception is thrown when a user isn\'t found.</p>', 'refs' => [], ], 'UserPoolAddOnNotEnabledException' => [ 'base' => '<p>This exception is thrown when user pool add-ons aren\'t enabled.</p>', 'refs' => [], ], 'UserPoolAddOnsType' => [ 'base' => '<p>The user pool add-ons type.</p>', 'refs' => [ 'CreateUserPoolRequest$UserPoolAddOns' => '<p>Enables advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>', 'UpdateUserPoolRequest$UserPoolAddOns' => '<p>Enables advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".</p>', 'UserPoolType$UserPoolAddOns' => '<p>The user pool add-ons.</p>', ], ], 'UserPoolClientDescription' => [ 'base' => '<p>The description of the user pool client.</p>', 'refs' => [ 'UserPoolClientListType$member' => NULL, ], ], 'UserPoolClientListType' => [ 'base' => NULL, 'refs' => [ 'ListUserPoolClientsResponse$UserPoolClients' => '<p>The user pool clients in the response that lists user pool clients.</p>', ], ], 'UserPoolClientType' => [ 'base' => '<p>Contains information about a user pool client.</p>', 'refs' => [ 'CreateUserPoolClientResponse$UserPoolClient' => '<p>The user pool client that was just created.</p>', 'DescribeUserPoolClientResponse$UserPoolClient' => '<p>The user pool client from a server response to describe the user pool client.</p>', 'UpdateUserPoolClientResponse$UserPoolClient' => '<p>The user pool client value from the response from the server when you request to update the user pool client.</p>', ], ], 'UserPoolDescriptionType' => [ 'base' => '<p>A user pool description.</p>', 'refs' => [ 'UserPoolListType$member' => NULL, ], ], 'UserPoolIdType' => [ 'base' => NULL, 'refs' => [ 'AddCustomAttributesRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to add custom attributes.</p>', 'AdminAddUserToGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminConfirmSignUpRequest$UserPoolId' => '<p>The user pool ID for which you want to confirm user registration.</p>', 'AdminCreateUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where the user will be created.</p>', 'AdminDeleteUserAttributesRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to delete user attributes.</p>', 'AdminDeleteUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to delete the user.</p>', 'AdminDisableUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to disable the user.</p>', 'AdminEnableUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to enable the user.</p>', 'AdminForgetDeviceRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminGetDeviceRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminGetUserRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to get information about the user.</p>', 'AdminInitiateAuthRequest$UserPoolId' => '<p>The ID of the Amazon Cognito user pool.</p>', 'AdminListDevicesRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminListGroupsForUserRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminListUserAuthEventsRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminRemoveUserFromGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'AdminResetUserPasswordRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to reset the user\'s password.</p>', 'AdminRespondToAuthChallengeRequest$UserPoolId' => '<p>The ID of the Amazon Cognito user pool.</p>', 'AdminSetUserMFAPreferenceRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminSetUserPasswordRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to set the user\'s password.</p>', 'AdminSetUserSettingsRequest$UserPoolId' => '<p>The ID of the user pool that contains the user whose options you\'re setting.</p>', 'AdminUpdateAuthEventFeedbackRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminUpdateDeviceStatusRequest$UserPoolId' => '<p>The user pool ID.</p>', 'AdminUpdateUserAttributesRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to update user attributes.</p>', 'AdminUserGlobalSignOutRequest$UserPoolId' => '<p>The user pool ID.</p>', 'CreateGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'CreateIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'CreateResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'CreateUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'CreateUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to create a user pool client.</p>', 'CreateUserPoolDomainRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DeleteGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'DeleteIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DeleteResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool that hosts the resource server.</p>', 'DeleteUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to delete the client.</p>', 'DeleteUserPoolDomainRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DeleteUserPoolRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to delete.</p>', 'DescribeIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DescribeResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool that hosts the resource server.</p>', 'DescribeRiskConfigurationRequest$UserPoolId' => '<p>The user pool ID.</p>', 'DescribeUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'DescribeUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to describe.</p>', 'DescribeUserPoolRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to describe.</p>', 'DomainDescriptionType$UserPoolId' => '<p>The user pool ID.</p>', 'GetCSVHeaderRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are to be imported into.</p>', 'GetCSVHeaderResponse$UserPoolId' => '<p>The user pool ID for the user pool that the users are to be imported into.</p>', 'GetGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'GetIdentityProviderByIdentifierRequest$UserPoolId' => '<p>The user pool ID.</p>', 'GetSigningCertificateRequest$UserPoolId' => '<p>The user pool ID.</p>', 'GetUICustomizationRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'GetUserPoolMfaConfigRequest$UserPoolId' => '<p>The user pool ID.</p>', 'GroupType$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'IdentityProviderType$UserPoolId' => '<p>The user pool ID.</p>', 'ListGroupsRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'ListIdentityProvidersRequest$UserPoolId' => '<p>The user pool ID.</p>', 'ListResourceServersRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'ListUserImportJobsRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'ListUserPoolClientsRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to list user pool clients.</p>', 'ListUsersInGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'ListUsersRequest$UserPoolId' => '<p>The user pool ID for the user pool on which the search should be performed.</p>', 'ResourceServerType$UserPoolId' => '<p>The user pool ID for the user pool that hosts the resource server.</p>', 'RiskConfigurationType$UserPoolId' => '<p>The user pool ID.</p>', 'SetRiskConfigurationRequest$UserPoolId' => '<p>The user pool ID. </p>', 'SetUICustomizationRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'SetUserPoolMfaConfigRequest$UserPoolId' => '<p>The user pool ID.</p>', 'StartUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'StopUserImportJobRequest$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'UICustomizationType$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'UpdateAuthEventFeedbackRequest$UserPoolId' => '<p>The user pool ID.</p>', 'UpdateGroupRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'UpdateIdentityProviderRequest$UserPoolId' => '<p>The user pool ID.</p>', 'UpdateResourceServerRequest$UserPoolId' => '<p>The user pool ID for the user pool.</p>', 'UpdateUserPoolClientRequest$UserPoolId' => '<p>The user pool ID for the user pool where you want to update the user pool client.</p>', 'UpdateUserPoolDomainRequest$UserPoolId' => '<p>The ID of the user pool that is associated with the custom domain whose certificate you\'re updating.</p>', 'UpdateUserPoolRequest$UserPoolId' => '<p>The user pool ID for the user pool you want to update.</p>', 'UserImportJobType$UserPoolId' => '<p>The user pool ID for the user pool that the users are being imported into.</p>', 'UserPoolClientDescription$UserPoolId' => '<p>The user pool ID for the user pool where you want to describe the user pool client.</p>', 'UserPoolClientType$UserPoolId' => '<p>The user pool ID for the user pool client.</p>', 'UserPoolDescriptionType$Id' => '<p>The ID in a user pool description.</p>', 'UserPoolType$Id' => '<p>The ID of the user pool.</p>', ], ], 'UserPoolListType' => [ 'base' => NULL, 'refs' => [ 'ListUserPoolsResponse$UserPools' => '<p>The user pools from the response to list users.</p>', ], ], 'UserPoolMfaType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$MfaConfiguration' => '<p>Specifies MFA configuration details.</p>', 'GetUserPoolMfaConfigResponse$MfaConfiguration' => '<p>The multi-factor (MFA) configuration. Valid values include:</p> <ul> <li> <p> <code>OFF</code> MFA won\'t be used for any users.</p> </li> <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li> <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</p> </li> </ul>', 'SetUserPoolMfaConfigRequest$MfaConfiguration' => '<p>The MFA configuration. If you set the MfaConfiguration value to ‘ON’, only users with an MFA factor set up can sign in. To learn more, see <a href="cognito/latest/developerguide/user-pool-settings-mfa.html">Adding Multi-Factor Authentication (MFA) to a User Pool</a>. Valid values include:</p> <ul> <li> <p> <code>OFF</code> MFA won\'t be used for any users.</p> </li> <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li> <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</p> </li> </ul>', 'SetUserPoolMfaConfigResponse$MfaConfiguration' => '<p>The MFA configuration. Valid values include:</p> <ul> <li> <p> <code>OFF</code> MFA won\'t be used for any users.</p> </li> <li> <p> <code>ON</code> MFA is required for all users to sign in.</p> </li> <li> <p> <code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor enabled.</p> </li> </ul>', 'UpdateUserPoolRequest$MfaConfiguration' => '<p>Can be one of the following values:</p> <ul> <li> <p> <code>OFF</code> - MFA tokens aren\'t required and can\'t be specified during user registration.</p> </li> <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify ON when you\'re initially creating a user pool. You can use the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html">SetUserPoolMfaConfig</a> API operation to turn MFA "ON" for existing user pools. </p> </li> <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li> </ul>', 'UserPoolType$MfaConfiguration' => '<p>Can be one of the following values:</p> <ul> <li> <p> <code>OFF</code> - MFA tokens aren\'t required and can\'t be specified during user registration.</p> </li> <li> <p> <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you\'re initially creating a user pool.</p> </li> <li> <p> <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.</p> </li> </ul>', ], ], 'UserPoolNameType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$PoolName' => '<p>A string used to name the user pool.</p>', 'UserPoolDescriptionType$Name' => '<p>The name in a user pool description.</p>', 'UserPoolType$Name' => '<p>The name of the user pool.</p>', ], ], 'UserPoolPolicyType' => [ 'base' => '<p>The policy associated with a user pool.</p>', 'refs' => [ 'CreateUserPoolRequest$Policies' => '<p>The policies associated with the new user pool.</p>', 'UpdateUserPoolRequest$Policies' => '<p>A container with the policies you want to update in a user pool.</p>', 'UserPoolType$Policies' => '<p>The policies associated with the user pool.</p>', ], ], 'UserPoolTaggingException' => [ 'base' => '<p>This exception is thrown when a user pool tag can\'t be set or updated.</p>', 'refs' => [], ], 'UserPoolTagsListType' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of the tags to remove from the user pool.</p>', ], ], 'UserPoolTagsType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$UserPoolTags' => '<p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags that are assigned to the user pool.</p>', 'TagResourceRequest$Tags' => '<p>The tags to assign to the user pool.</p>', 'UpdateUserPoolRequest$UserPoolTags' => '<p>The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.</p>', 'UserPoolType$UserPoolTags' => '<p>The tags that are assigned to the user pool. A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.</p>', ], ], 'UserPoolType' => [ 'base' => '<p>A container for information about the user pool.</p>', 'refs' => [ 'CreateUserPoolResponse$UserPool' => '<p>A container for the user pool details.</p>', 'DescribeUserPoolResponse$UserPool' => '<p>The container of metadata returned by the server to describe the pool.</p>', ], ], 'UserStatusType' => [ 'base' => NULL, 'refs' => [ 'AdminGetUserResponse$UserStatus' => '<p>The user status. Can be one of the following:</p> <ul> <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li> <li> <p>CONFIRMED - User has been confirmed.</p> </li> <li> <p>ARCHIVED - User is no longer active.</p> </li> <li> <p>COMPROMISED - User is disabled due to a potential security threat.</p> </li> <li> <p>UNKNOWN - User status isn\'t known.</p> </li> <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li> <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li> </ul>', 'UserType$UserStatus' => '<p>The user status. This can be one of the following:</p> <ul> <li> <p>UNCONFIRMED - User has been created but not confirmed.</p> </li> <li> <p>CONFIRMED - User has been confirmed.</p> </li> <li> <p>ARCHIVED - User is no longer active.</p> </li> <li> <p>COMPROMISED - User is disabled due to a potential security threat.</p> </li> <li> <p>UNKNOWN - User status isn\'t known.</p> </li> <li> <p>RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.</p> </li> <li> <p>FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else. </p> </li> </ul>', ], ], 'UserType' => [ 'base' => '<p>The user type.</p>', 'refs' => [ 'AdminCreateUserResponse$User' => '<p>The newly created user.</p>', 'UsersListType$member' => NULL, ], ], 'UsernameAttributeType' => [ 'base' => NULL, 'refs' => [ 'UsernameAttributesListType$member' => NULL, ], ], 'UsernameAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$UsernameAttributes' => '<p>Specifies whether a user can use an email address or phone number as a username when they sign up.</p>', 'UserPoolType$UsernameAttributes' => '<p>Specifies whether a user can use an email address or phone number as a username when they sign up.</p>', ], ], 'UsernameConfigurationType' => [ 'base' => '<p>The username configuration type. </p>', 'refs' => [ 'CreateUserPoolRequest$UsernameConfiguration' => '<p>Case sensitivity on the username input for the selected sign-in option. For example, when case sensitivity is set to <code>False</code>, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>', 'UserPoolType$UsernameConfiguration' => '<p>Case sensitivity of the username input for the selected sign-in option. For example, when case sensitivity is set to <code>False</code>, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html">UsernameConfigurationType</a>.</p>', ], ], 'UsernameExistsException' => [ 'base' => '<p>This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.</p>', 'refs' => [], ], 'UsernameType' => [ 'base' => NULL, 'refs' => [ 'AdminAddUserToGroupRequest$Username' => '<p>The username for the user.</p>', 'AdminConfirmSignUpRequest$Username' => '<p>The user name for which you want to confirm user registration.</p>', 'AdminCreateUserRequest$Username' => '<p>The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username can\'t be changed.</p>', 'AdminDeleteUserAttributesRequest$Username' => '<p>The user name of the user from which you would like to delete attributes.</p>', 'AdminDeleteUserRequest$Username' => '<p>The user name of the user you want to delete.</p>', 'AdminDisableUserRequest$Username' => '<p>The user name of the user you want to disable.</p>', 'AdminEnableUserRequest$Username' => '<p>The user name of the user you want to enable.</p>', 'AdminForgetDeviceRequest$Username' => '<p>The user name.</p>', 'AdminGetDeviceRequest$Username' => '<p>The user name.</p>', 'AdminGetUserRequest$Username' => '<p>The user name of the user you want to retrieve.</p>', 'AdminGetUserResponse$Username' => '<p>The user name of the user about whom you\'re receiving information.</p>', 'AdminListDevicesRequest$Username' => '<p>The user name.</p>', 'AdminListGroupsForUserRequest$Username' => '<p>The username for the user.</p>', 'AdminListUserAuthEventsRequest$Username' => '<p>The user pool username or an alias.</p>', 'AdminRemoveUserFromGroupRequest$Username' => '<p>The username for the user.</p>', 'AdminResetUserPasswordRequest$Username' => '<p>The user name of the user whose password you want to reset.</p>', 'AdminSetUserMFAPreferenceRequest$Username' => '<p>The user pool username or alias.</p>', 'AdminSetUserPasswordRequest$Username' => '<p>The user name of the user whose password you want to set.</p>', 'AdminSetUserSettingsRequest$Username' => '<p>The user name of the user whose options you\'re setting.</p>', 'AdminUpdateAuthEventFeedbackRequest$Username' => '<p>The user pool username.</p>', 'AdminUpdateDeviceStatusRequest$Username' => '<p>The user name.</p>', 'AdminUpdateUserAttributesRequest$Username' => '<p>The user name of the user for whom you want to update user attributes.</p>', 'AdminUserGlobalSignOutRequest$Username' => '<p>The user name.</p>', 'ConfirmForgotPasswordRequest$Username' => '<p>The user name of the user for whom you want to enter a code to retrieve a forgotten password.</p>', 'ConfirmSignUpRequest$Username' => '<p>The user name of the user whose registration you want to confirm.</p>', 'ForgotPasswordRequest$Username' => '<p>The user name of the user for whom you want to enter a code to reset a forgotten password.</p>', 'GetUserResponse$Username' => '<p>The user name of the user you want to retrieve from the get user request.</p>', 'ResendConfirmationCodeRequest$Username' => '<p>The <code>username</code> attribute of the user to whom you want to resend a confirmation code.</p>', 'SignUpRequest$Username' => '<p>The user name of the user you want to register.</p>', 'UpdateAuthEventFeedbackRequest$Username' => '<p>The user pool username.</p>', 'UserType$Username' => '<p>The user name of the user you want to describe.</p>', ], ], 'UsersListType' => [ 'base' => NULL, 'refs' => [ 'ListUsersInGroupResponse$Users' => '<p>The users returned in the request to list users.</p>', 'ListUsersResponse$Users' => '<p>The users returned in the request to list users.</p>', ], ], 'VerificationMessageTemplateType' => [ 'base' => '<p>The template for verification messages.</p>', 'refs' => [ 'CreateUserPoolRequest$VerificationMessageTemplate' => '<p>The template for the verification message that the user sees when the app requests permission to access the user\'s information.</p>', 'UpdateUserPoolRequest$VerificationMessageTemplate' => '<p>The template for verification messages.</p>', 'UserPoolType$VerificationMessageTemplate' => '<p>The template for verification messages.</p>', ], ], 'VerifiedAttributeType' => [ 'base' => NULL, 'refs' => [ 'VerifiedAttributesListType$member' => NULL, ], ], 'VerifiedAttributesListType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolRequest$AutoVerifiedAttributes' => '<p>The attributes to be auto-verified. Possible values: <b>email</b>, <b>phone_number</b>.</p>', 'UpdateUserPoolRequest$AutoVerifiedAttributes' => '<p>The attributes that are automatically verified when Amazon Cognito requests to update user pools.</p>', 'UserPoolType$AutoVerifiedAttributes' => '<p>The attributes that are auto-verified in a user pool.</p>', ], ], 'VerifySoftwareTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'VerifySoftwareTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'VerifySoftwareTokenResponseType' => [ 'base' => NULL, 'refs' => [ 'VerifySoftwareTokenResponse$Status' => '<p>The status of the verify software token.</p>', ], ], 'VerifyUserAttributeRequest' => [ 'base' => '<p>Represents the request to verify user attributes.</p>', 'refs' => [], ], 'VerifyUserAttributeResponse' => [ 'base' => '<p>A container representing the response from the server from the request to verify user attributes.</p>', 'refs' => [], ], 'WrappedBooleanType' => [ 'base' => NULL, 'refs' => [ 'CreateUserPoolClientRequest$EnableTokenRevocation' => '<p>Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p> <p>If you don\'t include this parameter, token revocation is automatically activated for the new user pool client.</p>', 'EventRiskType$CompromisedCredentialsDetected' => '<p>Indicates whether compromised credentials were detected during an authentication event.</p>', 'UpdateUserPoolClientRequest$EnableTokenRevocation' => '<p>Activates or deactivates token revocation. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>', 'UserPoolClientType$EnableTokenRevocation' => '<p>Indicates whether token revocation is activated for the user pool client. When you create a new user pool client, token revocation is activated by default. For more information about revoking tokens, see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html">RevokeToken</a>.</p>', 'UsernameConfigurationType$CaseSensitive' => '<p>Specifies whether username case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs.</p> <p>Valid values include:</p> <ul> <li> <p> <b> <code>True</code> </b>: Enables case sensitivity for all username input. When this option is set to <code>True</code>, users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.</p> </li> <li> <p> <b> <code>False</code> </b>: Enables case insensitivity for all username input. For example, when this option is set to <code>False</code>, users can sign in using either "username" or "Username". This option also enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.</p> </li> </ul>', ], ], ],];
