<?php
// This file was auto-generated from sdk-root/src/data/kinesisanalytics/2015-08-14/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Kinesis Analytics</fullname> <p> <b>Overview</b> </p> <note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>This is the <i>Amazon Kinesis Analytics v1 API Reference</i>. The Amazon Kinesis Analytics Developer Guide provides additional information. </p>', 'operations' => [ 'AddApplicationCloudWatchLoggingOption' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Adds a CloudWatch log stream to monitor application configuration errors. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon CloudWatch Logs</a>.</p>', 'AddApplicationInput' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p> Adds a streaming source to your Amazon Kinesis application. For conceptual information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. </p> <p>You can add a streaming source either when you create an application or you can use this operation to add a streaming source after you create an application. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_CreateApplication.html">CreateApplication</a>.</p> <p>Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to find the current application version. </p> <p>This operation requires permissions to perform the <code>kinesisanalytics:AddApplicationInput</code> action.</p>', 'AddApplicationInputProcessingConfiguration' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Adds an <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to an application. An input processor preprocesses records on the input stream before the application\'s SQL code executes. Currently, the only input processor available is <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a>.</p>', 'AddApplicationOutput' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Adds an external destination to your Amazon Kinesis Analytics application.</p> <p>If you want Amazon Kinesis Analytics to deliver data from an in-application stream within your application to an external destination (such as an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), you add the relevant configuration to your application using this operation. You can configure one or more outputs for your application. Each output configuration maps an in-application stream and an external destination.</p> <p> You can use one of the output configurations to deliver data from your in-application error stream to an external destination so that you can analyze the errors. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Understanding Application Output (Destination)</a>. </p> <p> Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to find the current application version.</p> <p>For the limits on the number of application inputs and outputs you can configure, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>.</p> <p>This operation requires permissions to perform the <code>kinesisanalytics:AddApplicationOutput</code> action.</p>', 'AddApplicationReferenceDataSource' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Adds a reference data source to an existing application.</p> <p>Amazon Kinesis Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table within your application. In the request, you provide the source (S3 bucket name and object key name), name of the in-application table to create, and the necessary mapping information that describes how data in Amazon S3 object maps to columns in the resulting in-application table.</p> <p> For conceptual information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. For the limits on data sources you can add to your application, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>. </p> <p> This operation requires permissions to perform the <code>kinesisanalytics:AddApplicationOutput</code> action. </p>', 'CreateApplication' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p> Creates an Amazon Kinesis Analytics application. You can configure each application with one streaming source as input, application code to process the input, and up to three destinations where you want Amazon Kinesis Analytics to write the output data from your application. For an overview, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works.html">How it Works</a>. </p> <p>In the input configuration, you map the streaming source to an in-application stream, which you can think of as a constantly updating table. In the mapping, you must provide a schema for the in-application stream and map each data column in the in-application stream to a data element in the streaming source.</p> <p>Your application code is one or more SQL statements that read input data, transform it, and generate output. Your application code can create one or more SQL artifacts like SQL streams or pumps.</p> <p>In the output configuration, you can configure the application to write data from in-application streams created in your applications to up to three destinations.</p> <p> To read data from your source stream or write data to destination streams, Amazon Kinesis Analytics needs your permissions. You grant these permissions by creating IAM roles. This operation requires permissions to perform the <code>kinesisanalytics:CreateApplication</code> action. </p> <p> For introductory exercises to create an Amazon Kinesis Analytics application, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/getting-started.html">Getting Started</a>. </p>', 'DeleteApplication' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Deletes the specified application. Amazon Kinesis Analytics halts application execution and deletes the application, including any application artifacts (such as in-application streams, reference table, and application code).</p> <p>This operation requires permissions to perform the <code>kinesisanalytics:DeleteApplication</code> action.</p>', 'DeleteApplicationCloudWatchLoggingOption' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Deletes a CloudWatch log stream from an application. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon CloudWatch Logs</a>.</p>', 'DeleteApplicationInputProcessingConfiguration' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Deletes an <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> from an input.</p>', 'DeleteApplicationOutput' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Deletes output destination configuration from your application configuration. Amazon Kinesis Analytics will no longer write data from the corresponding in-application stream to the external output destination.</p> <p>This operation requires permissions to perform the <code>kinesisanalytics:DeleteApplicationOutput</code> action.</p>', 'DeleteApplicationReferenceDataSource' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Deletes a reference data source configuration from the specified application configuration.</p> <p>If the application is running, Amazon Kinesis Analytics immediately removes the in-application table that you created using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a> operation. </p> <p>This operation requires permissions to perform the <code>kinesisanalytics.DeleteApplicationReferenceDataSource</code> action.</p>', 'DescribeApplication' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Returns information about a specific Amazon Kinesis Analytics application.</p> <p>If you want to retrieve a list of all applications in your account, use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_ListApplications.html">ListApplications</a> operation.</p> <p>This operation requires permissions to perform the <code>kinesisanalytics:DescribeApplication</code> action. You can use <code>DescribeApplication</code> to get the current application versionId, which you need to call other operations such as <code>Update</code>. </p>', 'DiscoverInputSchema' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Infers a schema by evaluating sample records on the specified streaming source (Amazon Kinesis stream or Amazon Kinesis Firehose delivery stream) or S3 object. In the response, the operation returns the inferred schema and also the sample records that the operation used to infer the schema.</p> <p> You can use the inferred schema when configuring a streaming source for your application. For conceptual information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. Note that when you create an application using the Amazon Kinesis Analytics console, the console uses this operation to infer a schema and show it in the console user interface. </p> <p> This operation requires permissions to perform the <code>kinesisanalytics:DiscoverInputSchema</code> action. </p>', 'ListApplications' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Returns a list of Amazon Kinesis Analytics applications in your account. For each application, the response includes the application name, Amazon Resource Name (ARN), and status. If the response returns the <code>HasMoreApplications</code> value as true, you can send another request by adding the <code>ExclusiveStartApplicationName</code> in the request body, and set the value of this to the last application name from the previous response. </p> <p>If you want detailed information about a specific application, use <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a>.</p> <p>This operation requires permissions to perform the <code>kinesisanalytics:ListApplications</code> action.</p>', 'ListTagsForResource' => '<p>Retrieves the list of key-value tags assigned to the application. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>', 'StartApplication' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Starts the specified Amazon Kinesis Analytics application. After creating an application, you must exclusively call this operation to start your application.</p> <p>After the application starts, it begins consuming the input data, processes it, and writes the output to the configured destination.</p> <p> The application status must be <code>READY</code> for you to start an application. You can get the application status in the console or using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p> <p>After you start the application, you can stop the application from processing the input by calling the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_StopApplication.html">StopApplication</a> operation.</p> <p>This operation requires permissions to perform the <code>kinesisanalytics:StartApplication</code> action.</p>', 'StopApplication' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Stops the application from processing input data. You can stop an application only if it is in the running state. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to find the application state. After the application is stopped, Amazon Kinesis Analytics stops reading data from the input, the application stops processing data, and there is no output written to the destination. </p> <p>This operation requires permissions to perform the <code>kinesisanalytics:StopApplication</code> action.</p>', 'TagResource' => '<p>Adds one or more key-value tags to a Kinesis Analytics application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>', 'UntagResource' => '<p>Removes one or more tags from a Kinesis Analytics application. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>', 'UpdateApplication' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Updates an existing Amazon Kinesis Analytics application. Using this API, you can update application code, input configuration, and output configuration. </p> <p>Note that Amazon Kinesis Analytics updates the <code>CurrentApplicationVersionId</code> each time you update your application. </p> <p>This operation requires permission for the <code>kinesisanalytics:UpdateApplication</code> action.</p>', ], 'shapes' => [ 'AddApplicationCloudWatchLoggingOptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddApplicationCloudWatchLoggingOptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'AddApplicationInputProcessingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddApplicationInputProcessingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'AddApplicationInputRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'AddApplicationInputResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'AddApplicationOutputRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'AddApplicationOutputResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'AddApplicationReferenceDataSourceRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'AddApplicationReferenceDataSourceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ApplicationCode' => [ 'base' => NULL, 'refs' => [ 'ApplicationDetail$ApplicationCode' => '<p>Returns the application code that you provided to perform data analysis on any of the in-application streams in your application.</p>', 'ApplicationUpdate$ApplicationCodeUpdate' => '<p>Describes application code updates.</p>', 'CreateApplicationRequest$ApplicationCode' => '<p>One or more SQL statements that read input data, transform it, and generate output. For example, you can write a SQL statement that reads data from one in-application stream, generates a running average of the number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more information about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application Code</a>. </p> <p>You can provide such series of SQL statements, where output of one statement can be used as the input for the next statement. You store intermediate results by creating in-application streams and pumps.</p> <p>Note that the application code must create the streams with names specified in the <code>Outputs</code>. For example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>, then your application code must create these streams. </p>', ], ], 'ApplicationDescription' => [ 'base' => NULL, 'refs' => [ 'ApplicationDetail$ApplicationDescription' => '<p>Description of the application.</p>', 'CreateApplicationRequest$ApplicationDescription' => '<p>Summary description of the application.</p>', ], ], 'ApplicationDetail' => [ 'base' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Provides a description of the application, including the application Amazon Resource Name (ARN), status, latest version, and input and output configuration.</p>', 'refs' => [ 'DescribeApplicationResponse$ApplicationDetail' => '<p>Provides a description of the application, such as the application Amazon Resource Name (ARN), status, latest version, and input and output configuration details.</p>', ], ], 'ApplicationName' => [ 'base' => NULL, 'refs' => [ 'AddApplicationCloudWatchLoggingOptionRequest$ApplicationName' => '<p>The Kinesis Analytics application name.</p>', 'AddApplicationInputProcessingConfigurationRequest$ApplicationName' => '<p>Name of the application to which you want to add the input processing configuration.</p>', 'AddApplicationInputRequest$ApplicationName' => '<p>Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.</p>', 'AddApplicationOutputRequest$ApplicationName' => '<p>Name of the application to which you want to add the output configuration.</p>', 'AddApplicationReferenceDataSourceRequest$ApplicationName' => '<p>Name of an existing application.</p>', 'ApplicationDetail$ApplicationName' => '<p>Name of the application.</p>', 'ApplicationSummary$ApplicationName' => '<p>Name of the application.</p>', 'CreateApplicationRequest$ApplicationName' => '<p>Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).</p>', 'DeleteApplicationCloudWatchLoggingOptionRequest$ApplicationName' => '<p>The Kinesis Analytics application name.</p>', 'DeleteApplicationInputProcessingConfigurationRequest$ApplicationName' => '<p>The Kinesis Analytics application name.</p>', 'DeleteApplicationOutputRequest$ApplicationName' => '<p>Amazon Kinesis Analytics application name.</p>', 'DeleteApplicationReferenceDataSourceRequest$ApplicationName' => '<p>Name of an existing application.</p>', 'DeleteApplicationRequest$ApplicationName' => '<p>Name of the Amazon Kinesis Analytics application to delete.</p>', 'DescribeApplicationRequest$ApplicationName' => '<p>Name of the application.</p>', 'ListApplicationsRequest$ExclusiveStartApplicationName' => '<p>Name of the application to start the list with. When using pagination to retrieve the list, you don\'t need to specify this parameter in the first request. However, in subsequent requests, you add the last application name from the previous response to get the next page of applications.</p>', 'StartApplicationRequest$ApplicationName' => '<p>Name of the application.</p>', 'StopApplicationRequest$ApplicationName' => '<p>Name of the running application to stop.</p>', 'UpdateApplicationRequest$ApplicationName' => '<p>Name of the Amazon Kinesis Analytics application to update.</p>', ], ], 'ApplicationStatus' => [ 'base' => NULL, 'refs' => [ 'ApplicationDetail$ApplicationStatus' => '<p>Status of the application.</p>', 'ApplicationSummary$ApplicationStatus' => '<p>Status of the application.</p>', ], ], 'ApplicationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsResponse$ApplicationSummaries' => '<p>List of <code>ApplicationSummary</code> objects. </p>', ], ], 'ApplicationSummary' => [ 'base' => '<note> <p>This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.</p> </note> <p>Provides application summary information, including the application Amazon Resource Name (ARN), name, and status.</p>', 'refs' => [ 'ApplicationSummaries$member' => NULL, 'CreateApplicationResponse$ApplicationSummary' => '<p>In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response with a summary of the application it created, including the application Amazon Resource Name (ARN), name, and status.</p>', ], ], 'ApplicationUpdate' => [ 'base' => '<p>Describes updates to apply to an existing Amazon Kinesis Analytics application.</p>', 'refs' => [ 'UpdateApplicationRequest$ApplicationUpdate' => '<p>Describes application updates.</p>', ], ], 'ApplicationVersionId' => [ 'base' => NULL, 'refs' => [ 'AddApplicationCloudWatchLoggingOptionRequest$CurrentApplicationVersionId' => '<p>The version ID of the Kinesis Analytics application.</p>', 'AddApplicationInputProcessingConfigurationRequest$CurrentApplicationVersionId' => '<p>Version of the application to which you want to add the input processing configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>', 'AddApplicationInputRequest$CurrentApplicationVersionId' => '<p>Current version of your Amazon Kinesis Analytics application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to find the current application version.</p>', 'AddApplicationOutputRequest$CurrentApplicationVersionId' => '<p>Version of the application to which you want to add the output configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned. </p>', 'AddApplicationReferenceDataSourceRequest$CurrentApplicationVersionId' => '<p>Version of the application for which you are adding the reference data source. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>', 'ApplicationDetail$ApplicationVersionId' => '<p>Provides the current application version.</p>', 'DeleteApplicationCloudWatchLoggingOptionRequest$CurrentApplicationVersionId' => '<p>The version ID of the Kinesis Analytics application.</p>', 'DeleteApplicationInputProcessingConfigurationRequest$CurrentApplicationVersionId' => '<p>The version ID of the Kinesis Analytics application.</p>', 'DeleteApplicationOutputRequest$CurrentApplicationVersionId' => '<p>Amazon Kinesis Analytics application version. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned. </p>', 'DeleteApplicationReferenceDataSourceRequest$CurrentApplicationVersionId' => '<p>Version of the application. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the current application version. If the version specified is not the current version, the <code>ConcurrentModificationException</code> is returned.</p>', 'UpdateApplicationRequest$CurrentApplicationVersionId' => '<p>The current application version ID. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>', ], ], 'BooleanObject' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsResponse$HasMoreApplications' => '<p>Returns true if there are more applications to retrieve.</p>', ], ], 'BucketARN' => [ 'base' => NULL, 'refs' => [ 'S3Configuration$BucketARN' => '<p>ARN of the S3 bucket that contains the data.</p>', 'S3ReferenceDataSource$BucketARN' => '<p>Amazon Resource Name (ARN) of the S3 bucket.</p>', 'S3ReferenceDataSourceDescription$BucketARN' => '<p>Amazon Resource Name (ARN) of the S3 bucket.</p>', 'S3ReferenceDataSourceUpdate$BucketARNUpdate' => '<p>Amazon Resource Name (ARN) of the S3 bucket.</p>', ], ], 'CSVMappingParameters' => [ 'base' => '<p>Provides additional mapping information when the record format uses delimiters, such as CSV. For example, the following sample records use CSV format, where the records use the <i>\'\\n\'</i> as the row delimiter and a comma (",") as the column delimiter: </p> <p> <code>"name1", "address1"</code> </p> <p> <code>"name2", "address2"</code> </p>', 'refs' => [ 'MappingParameters$CSVMappingParameters' => '<p>Provides additional mapping information when the record format uses delimiters (for example, CSV).</p>', ], ], 'CloudWatchLoggingOption' => [ 'base' => '<p>Provides a description of CloudWatch logging options, including the log stream Amazon Resource Name (ARN) and the role ARN.</p>', 'refs' => [ 'AddApplicationCloudWatchLoggingOptionRequest$CloudWatchLoggingOption' => '<p>Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy action enabled.</p>', 'CloudWatchLoggingOptions$member' => NULL, ], ], 'CloudWatchLoggingOptionDescription' => [ 'base' => '<p>Description of the CloudWatch logging option.</p>', 'refs' => [ 'CloudWatchLoggingOptionDescriptions$member' => NULL, ], ], 'CloudWatchLoggingOptionDescriptions' => [ 'base' => NULL, 'refs' => [ 'ApplicationDetail$CloudWatchLoggingOptionDescriptions' => '<p>Describes the CloudWatch log streams that are configured to receive application messages. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon CloudWatch Logs</a>. </p>', ], ], 'CloudWatchLoggingOptionUpdate' => [ 'base' => '<p>Describes CloudWatch logging option updates.</p>', 'refs' => [ 'CloudWatchLoggingOptionUpdates$member' => NULL, ], ], 'CloudWatchLoggingOptionUpdates' => [ 'base' => NULL, 'refs' => [ 'ApplicationUpdate$CloudWatchLoggingOptionUpdates' => '<p>Describes application CloudWatch logging option updates.</p>', ], ], 'CloudWatchLoggingOptions' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$CloudWatchLoggingOptions' => '<p>Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon CloudWatch Logs</a>.</p>', ], ], 'CodeValidationException' => [ 'base' => '<p>User-provided application code (query) is invalid. This can be a simple syntax error.</p>', 'refs' => [], ], 'ConcurrentModificationException' => [ 'base' => '<p>Exception thrown as a result of concurrent modification to an application. For example, two individuals attempting to edit the same application at the same time.</p>', 'refs' => [], ], 'CreateApplicationRequest' => [ 'base' => '<p>TBD</p>', 'refs' => [], ], 'CreateApplicationResponse' => [ 'base' => '<p>TBD</p>', 'refs' => [], ], 'DeleteApplicationCloudWatchLoggingOptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationCloudWatchLoggingOptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationInputProcessingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationInputProcessingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationOutputRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteApplicationOutputResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteApplicationReferenceDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationReferenceDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteApplicationResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeApplicationRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeApplicationResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DestinationSchema' => [ 'base' => '<p>Describes the data format when records are written to the destination. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>. </p>', 'refs' => [ 'Output$DestinationSchema' => '<p>Describes the data format when records are written to the destination. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.</p>', 'OutputDescription$DestinationSchema' => '<p>Data format used for writing data to the destination.</p>', 'OutputUpdate$DestinationSchemaUpdate' => '<p>Describes the data format when records are written to the destination. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>.</p>', ], ], 'DiscoverInputSchemaRequest' => [ 'base' => NULL, 'refs' => [], ], 'DiscoverInputSchemaResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'CodeValidationException$message' => '<p>Test</p>', 'ConcurrentModificationException$message' => '<p/>', 'InvalidApplicationConfigurationException$message' => '<p>test</p>', 'InvalidArgumentException$message' => '<p/>', 'LimitExceededException$message' => '<p/>', 'ResourceInUseException$message' => '<p/>', 'ResourceNotFoundException$message' => '<p/>', 'ResourceProvisionedThroughputExceededException$message' => NULL, 'ServiceUnavailableException$message' => NULL, 'TooManyTagsException$message' => NULL, 'UnableToDetectSchemaException$message' => NULL, 'UnsupportedOperationException$message' => NULL, ], ], 'FileKey' => [ 'base' => NULL, 'refs' => [ 'S3Configuration$FileKey' => '<p>The name of the object that contains the data.</p>', 'S3ReferenceDataSource$FileKey' => '<p>Object key name containing reference data.</p>', 'S3ReferenceDataSourceDescription$FileKey' => '<p>Amazon S3 object key name.</p>', 'S3ReferenceDataSourceUpdate$FileKeyUpdate' => '<p>Object key name.</p>', ], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'AddApplicationInputProcessingConfigurationRequest$InputId' => '<p>The ID of the input configuration to add the input processing configuration to. You can get a list of the input IDs for an application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>', 'CloudWatchLoggingOptionDescription$CloudWatchLoggingOptionId' => '<p>ID of the CloudWatch logging option description.</p>', 'CloudWatchLoggingOptionUpdate$CloudWatchLoggingOptionId' => '<p>ID of the CloudWatch logging option to update</p>', 'DeleteApplicationCloudWatchLoggingOptionRequest$CloudWatchLoggingOptionId' => '<p>The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can get the <code>CloudWatchLoggingOptionId</code> by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation. </p>', 'DeleteApplicationInputProcessingConfigurationRequest$InputId' => '<p>The ID of the input configuration from which to delete the input processing configuration. You can get a list of the input IDs for an application by using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>', 'DeleteApplicationOutputRequest$OutputId' => '<p>The ID of the configuration to delete. Each output configuration that is added to the application, either when the application is created or later using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationOutput.html">AddApplicationOutput</a> operation, has a unique ID. You need to provide the ID to uniquely identify the output configuration that you want to delete from the application configuration. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the specific <code>OutputId</code>. </p>', 'DeleteApplicationReferenceDataSourceRequest$ReferenceId' => '<p>ID of the reference data source. When you add a reference data source to your application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a>, Amazon Kinesis Analytics assigns an ID. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get the reference ID. </p>', 'InputConfiguration$Id' => '<p>Input source ID. You can get this ID by calling the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation.</p>', 'InputDescription$InputId' => '<p>Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns to each input configuration you add to your application. </p>', 'InputUpdate$InputId' => '<p>Input ID of the application input to be updated.</p>', 'OutputDescription$OutputId' => '<p>A unique identifier for the output configuration.</p>', 'OutputUpdate$OutputId' => '<p>Identifies the specific output configuration that you want to update.</p>', 'ReferenceDataSourceDescription$ReferenceId' => '<p>ID of the reference data source. This is the ID that Amazon Kinesis Analytics assigns when you add the reference data source to your application using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html">AddApplicationReferenceDataSource</a> operation.</p>', 'ReferenceDataSourceUpdate$ReferenceId' => '<p>ID of the reference data source being updated. You can use the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication</a> operation to get this value.</p>', ], ], 'InAppStreamName' => [ 'base' => NULL, 'refs' => [ 'InAppStreamNames$member' => NULL, 'Input$NamePrefix' => '<p>Name prefix to use when creating an in-application stream. Suppose that you specify a prefix "MyInApplicationStream." Amazon Kinesis Analytics then creates one or more (as per the <code>InputParallelism</code> count you specified) in-application streams with names "MyInApplicationStream_001," "MyInApplicationStream_002," and so on. </p>', 'InputDescription$NamePrefix' => '<p>In-application name prefix.</p>', 'InputUpdate$NamePrefixUpdate' => '<p>Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific streaming source.</p>', 'Output$Name' => '<p>Name of the in-application stream.</p>', 'OutputDescription$Name' => '<p>Name of the in-application stream configured as output.</p>', 'OutputUpdate$NameUpdate' => '<p>If you want to specify a different in-application stream for this output configuration, use this field to specify the new in-application stream name.</p>', ], ], 'InAppStreamNames' => [ 'base' => NULL, 'refs' => [ 'InputDescription$InAppStreamNames' => '<p>Returns the in-application stream names that are mapped to the stream source.</p>', ], ], 'InAppTableName' => [ 'base' => NULL, 'refs' => [ 'ReferenceDataSource$TableName' => '<p>Name of the in-application table to create.</p>', 'ReferenceDataSourceDescription$TableName' => '<p>The in-application table name created by the specific reference data source configuration.</p>', 'ReferenceDataSourceUpdate$TableNameUpdate' => '<p>In-application table name that is created by this update.</p>', ], ], 'Input' => [ 'base' => '<p>When you configure the application input, you specify the streaming source, the in-application stream name that is created, and the mapping between the two. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. </p>', 'refs' => [ 'AddApplicationInputRequest$Input' => '<p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_Input.html">Input</a> to add.</p>', 'Inputs$member' => NULL, ], ], 'InputConfiguration' => [ 'base' => '<p>When you start your application, you provide this configuration, which identifies the input source and the point in the input source at which you want the application to start processing records.</p>', 'refs' => [ 'InputConfigurations$member' => NULL, ], ], 'InputConfigurations' => [ 'base' => NULL, 'refs' => [ 'StartApplicationRequest$InputConfigurations' => '<p>Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts reading the streaming source associated with the input. You can also specify where in the streaming source you want Amazon Kinesis Analytics to start reading.</p>', ], ], 'InputDescription' => [ 'base' => '<p>Describes the application input configuration. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. </p>', 'refs' => [ 'InputDescriptions$member' => NULL, ], ], 'InputDescriptions' => [ 'base' => NULL, 'refs' => [ 'ApplicationDetail$InputDescriptions' => '<p>Describes the application input configuration. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. </p>', ], ], 'InputLambdaProcessor' => [ 'base' => '<p>An object that contains the Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that is used to preprocess records in the stream, and the ARN of the IAM role that is used to access the AWS Lambda function. </p>', 'refs' => [ 'InputProcessingConfiguration$InputLambdaProcessor' => '<p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a> that is used to preprocess the records in the stream before being processed by your application code.</p>', ], ], 'InputLambdaProcessorDescription' => [ 'base' => '<p>An object that contains the Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that is used to preprocess records in the stream, and the ARN of the IAM role that is used to access the AWS Lambda expression.</p>', 'refs' => [ 'InputProcessingConfigurationDescription$InputLambdaProcessorDescription' => '<p>Provides configuration information about the associated <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html">InputLambdaProcessorDescription</a>.</p>', ], ], 'InputLambdaProcessorUpdate' => [ 'base' => '<p>Represents an update to the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a> that is used to preprocess the records in the stream.</p>', 'refs' => [ 'InputProcessingConfigurationUpdate$InputLambdaProcessorUpdate' => '<p>Provides update information for an <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a>.</p>', ], ], 'InputParallelism' => [ 'base' => '<p>Describes the number of in-application streams to create for a given streaming source. For information about parallelism, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. </p>', 'refs' => [ 'Input$InputParallelism' => '<p>Describes the number of in-application streams to create. </p> <p>Data from your source is routed to these in-application input streams.</p> <p> (see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>.</p>', 'InputDescription$InputParallelism' => '<p>Describes the configured parallelism (number of in-application streams mapped to the streaming source).</p>', ], ], 'InputParallelismCount' => [ 'base' => NULL, 'refs' => [ 'InputParallelism$Count' => '<p>Number of in-application streams to create. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>. </p>', 'InputParallelismUpdate$CountUpdate' => '<p>Number of in-application streams to create for the specified streaming source.</p>', ], ], 'InputParallelismUpdate' => [ 'base' => '<p>Provides updates to the parallelism count.</p>', 'refs' => [ 'InputUpdate$InputParallelismUpdate' => '<p>Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for the specific streaming source).</p>', ], ], 'InputProcessingConfiguration' => [ 'base' => '<p>Provides a description of a processor that is used to preprocess the records in the stream before being processed by your application code. Currently, the only input processor available is <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a>.</p>', 'refs' => [ 'AddApplicationInputProcessingConfigurationRequest$InputProcessingConfiguration' => '<p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to add to the application.</p>', 'DiscoverInputSchemaRequest$InputProcessingConfiguration' => '<p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the records.</p>', 'Input$InputProcessingConfiguration' => '<p>The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a> for the input. An input processor transforms records as they are received from the stream, before the application\'s SQL code executes. Currently, the only input processing configuration available is <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html">InputLambdaProcessor</a>.</p>', ], ], 'InputProcessingConfigurationDescription' => [ 'base' => '<p>Provides configuration information about an input processor. Currently, the only input processor available is <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a>.</p>', 'refs' => [ 'InputDescription$InputProcessingConfigurationDescription' => '<p>The description of the preprocessor that executes on records in this input before the application\'s code is run.</p>', ], ], 'InputProcessingConfigurationUpdate' => [ 'base' => '<p>Describes updates to an <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">InputProcessingConfiguration</a>. </p>', 'refs' => [ 'InputUpdate$InputProcessingConfigurationUpdate' => '<p>Describes updates for an input processing configuration.</p>', ], ], 'InputSchemaUpdate' => [ 'base' => '<p>Describes updates for the application\'s input schema.</p>', 'refs' => [ 'InputUpdate$InputSchemaUpdate' => '<p>Describes the data format on the streaming source, and how record elements on the streaming source map to columns of the in-application stream that is created.</p>', ], ], 'InputStartingPosition' => [ 'base' => NULL, 'refs' => [ 'InputStartingPositionConfiguration$InputStartingPosition' => '<p>The starting position on the stream.</p> <ul> <li> <p> <code>NOW</code> - Start reading just after the most recent record in the stream, start at the request time stamp that the customer issued.</p> </li> <li> <p> <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest record available in the stream. This option is not available for an Amazon Kinesis Firehose delivery stream.</p> </li> <li> <p> <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.</p> </li> </ul>', ], ], 'InputStartingPositionConfiguration' => [ 'base' => '<p>Describes the point at which the application reads from the streaming source.</p>', 'refs' => [ 'DiscoverInputSchemaRequest$InputStartingPositionConfiguration' => '<p>Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source discovery purposes.</p>', 'InputConfiguration$InputStartingPositionConfiguration' => '<p>Point at which you want the application to start processing records from the streaming source.</p>', 'InputDescription$InputStartingPositionConfiguration' => '<p>Point at which the application is configured to read from the input stream.</p>', ], ], 'InputUpdate' => [ 'base' => '<p>Describes updates to a specific input configuration (identified by the <code>InputId</code> of an application). </p>', 'refs' => [ 'InputUpdates$member' => NULL, ], ], 'InputUpdates' => [ 'base' => NULL, 'refs' => [ 'ApplicationUpdate$InputUpdates' => '<p>Describes application input configuration updates.</p>', ], ], 'Inputs' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$Inputs' => '<p>Use this parameter to configure the application input.</p> <p>You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).</p> <p>For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this stream on your behalf.</p> <p>To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.</p>', ], ], 'InvalidApplicationConfigurationException' => [ 'base' => '<p>User-provided application configuration is not valid.</p>', 'refs' => [], ], 'InvalidArgumentException' => [ 'base' => '<p>Specified input parameter value is invalid.</p>', 'refs' => [], ], 'JSONMappingParameters' => [ 'base' => '<p>Provides additional mapping information when JSON is the record format on the streaming source.</p>', 'refs' => [ 'MappingParameters$JSONMappingParameters' => '<p>Provides additional mapping information when JSON is the record format on the streaming source.</p>', ], ], 'KinesisAnalyticsARN' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>The ARN of the application for which to retrieve tags.</p>', 'TagResourceRequest$ResourceARN' => '<p>The ARN of the application to assign the tags.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The ARN of the Kinesis Analytics application from which to remove the tags.</p>', ], ], 'KinesisFirehoseInput' => [ 'base' => '<p> Identifies an Amazon Kinesis Firehose delivery stream as the streaming source. You provide the delivery stream\'s Amazon Resource Name (ARN) and an IAM role ARN that enables Amazon Kinesis Analytics to access the stream on your behalf.</p>', 'refs' => [ 'Input$KinesisFirehoseInput' => '<p>If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies the delivery stream\'s ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.</p> <p>Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.</p>', ], ], 'KinesisFirehoseInputDescription' => [ 'base' => '<p> Describes the Amazon Kinesis Firehose delivery stream that is configured as the streaming source in the application input configuration. </p>', 'refs' => [ 'InputDescription$KinesisFirehoseInputDescription' => '<p>If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the delivery stream\'s ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.</p>', ], ], 'KinesisFirehoseInputUpdate' => [ 'base' => '<p>When updating application input configuration, provides information about an Amazon Kinesis Firehose delivery stream as the streaming source.</p>', 'refs' => [ 'InputUpdate$KinesisFirehoseInputUpdate' => '<p>If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated stream ARN and IAM role ARN.</p>', ], ], 'KinesisFirehoseOutput' => [ 'base' => '<p>When configuring application output, identifies an Amazon Kinesis Firehose delivery stream as the destination. You provide the stream Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to write to the stream on your behalf.</p>', 'refs' => [ 'Output$KinesisFirehoseOutput' => '<p>Identifies an Amazon Kinesis Firehose delivery stream as the destination.</p>', ], ], 'KinesisFirehoseOutputDescription' => [ 'base' => '<p> For an application output, describes the Amazon Kinesis Firehose delivery stream configured as its destination. </p>', 'refs' => [ 'OutputDescription$KinesisFirehoseOutputDescription' => '<p>Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is written.</p>', ], ], 'KinesisFirehoseOutputUpdate' => [ 'base' => '<p> When updating an output configuration using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html">UpdateApplication</a> operation, provides information about an Amazon Kinesis Firehose delivery stream configured as the destination. </p>', 'refs' => [ 'OutputUpdate$KinesisFirehoseOutputUpdate' => '<p>Describes an Amazon Kinesis Firehose delivery stream as the destination for the output.</p>', ], ], 'KinesisStreamsInput' => [ 'base' => '<p> Identifies an Amazon Kinesis stream as the streaming source. You provide the stream\'s Amazon Resource Name (ARN) and an IAM role ARN that enables Amazon Kinesis Analytics to access the stream on your behalf.</p>', 'refs' => [ 'Input$KinesisStreamsInput' => '<p>If the streaming source is an Amazon Kinesis stream, identifies the stream\'s Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.</p> <p>Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.</p>', ], ], 'KinesisStreamsInputDescription' => [ 'base' => '<p> Describes the Amazon Kinesis stream that is configured as the streaming source in the application input configuration. </p>', 'refs' => [ 'InputDescription$KinesisStreamsInputDescription' => '<p>If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream\'s Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.</p>', ], ], 'KinesisStreamsInputUpdate' => [ 'base' => '<p>When updating application input configuration, provides information about an Amazon Kinesis stream as the streaming source.</p>', 'refs' => [ 'InputUpdate$KinesisStreamsInputUpdate' => '<p>If an Amazon Kinesis stream is the streaming source to be updated, provides an updated stream Amazon Resource Name (ARN) and IAM role ARN.</p>', ], ], 'KinesisStreamsOutput' => [ 'base' => '<p>When configuring application output, identifies an Amazon Kinesis stream as the destination. You provide the stream Amazon Resource Name (ARN) and also an IAM role ARN that Amazon Kinesis Analytics can use to write to the stream on your behalf.</p>', 'refs' => [ 'Output$KinesisStreamsOutput' => '<p>Identifies an Amazon Kinesis stream as the destination.</p>', ], ], 'KinesisStreamsOutputDescription' => [ 'base' => '<p> For an application output, describes the Amazon Kinesis stream configured as its destination. </p>', 'refs' => [ 'OutputDescription$KinesisStreamsOutputDescription' => '<p>Describes Amazon Kinesis stream configured as the destination where output is written.</p>', ], ], 'KinesisStreamsOutputUpdate' => [ 'base' => '<p> When updating an output configuration using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html">UpdateApplication</a> operation, provides information about an Amazon Kinesis stream configured as the destination. </p>', 'refs' => [ 'OutputUpdate$KinesisStreamsOutputUpdate' => '<p>Describes an Amazon Kinesis stream as the destination for the output.</p>', ], ], 'LambdaOutput' => [ 'base' => '<p>When configuring application output, identifies an AWS Lambda function as the destination. You provide the function Amazon Resource Name (ARN) and also an IAM role ARN that Amazon Kinesis Analytics can use to write to the function on your behalf. </p>', 'refs' => [ 'Output$LambdaOutput' => '<p>Identifies an AWS Lambda function as the destination.</p>', ], ], 'LambdaOutputDescription' => [ 'base' => '<p>For an application output, describes the AWS Lambda function configured as its destination. </p>', 'refs' => [ 'OutputDescription$LambdaOutputDescription' => '<p>Describes the AWS Lambda function configured as the destination where output is written.</p>', ], ], 'LambdaOutputUpdate' => [ 'base' => '<p>When updating an output configuration using the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html">UpdateApplication</a> operation, provides information about an AWS Lambda function configured as the destination.</p>', 'refs' => [ 'OutputUpdate$LambdaOutputUpdate' => '<p>Describes an AWS Lambda function as the destination for the output.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>Exceeded the number of applications allowed.</p>', 'refs' => [], ], 'ListApplicationsInputLimit' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequest$Limit' => '<p>Maximum number of applications to list.</p>', ], ], 'ListApplicationsRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListApplicationsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogStreamARN' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLoggingOption$LogStreamARN' => '<p>ARN of the CloudWatch log to receive application messages.</p>', 'CloudWatchLoggingOptionDescription$LogStreamARN' => '<p>ARN of the CloudWatch log to receive application messages.</p>', 'CloudWatchLoggingOptionUpdate$LogStreamARNUpdate' => '<p>ARN of the CloudWatch log to receive application messages.</p>', ], ], 'MappingParameters' => [ 'base' => '<p>When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.</p>', 'refs' => [ 'RecordFormat$MappingParameters' => '<p>When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.</p>', ], ], 'Output' => [ 'base' => '<p> Describes application output configuration in which you identify an in-application stream and a destination where you want the in-application stream data to be written. The destination can be an Amazon Kinesis stream or an Amazon Kinesis Firehose delivery stream. </p> <p/> <p>For limits on how many destinations an application can write and other limitations, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>. </p>', 'refs' => [ 'AddApplicationOutputRequest$Output' => '<p>An array of objects, each describing one output configuration. In the output configuration, you specify the name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the destination.</p>', 'Outputs$member' => NULL, ], ], 'OutputDescription' => [ 'base' => '<p>Describes the application output configuration, which includes the in-application stream name and the destination where the stream data is written. The destination can be an Amazon Kinesis stream or an Amazon Kinesis Firehose delivery stream. </p>', 'refs' => [ 'OutputDescriptions$member' => NULL, ], ], 'OutputDescriptions' => [ 'base' => NULL, 'refs' => [ 'ApplicationDetail$OutputDescriptions' => '<p>Describes the application output configuration. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application Output</a>. </p>', ], ], 'OutputUpdate' => [ 'base' => '<p> Describes updates to the output configuration identified by the <code>OutputId</code>. </p>', 'refs' => [ 'OutputUpdates$member' => NULL, ], ], 'OutputUpdates' => [ 'base' => NULL, 'refs' => [ 'ApplicationUpdate$OutputUpdates' => '<p>Describes application output configuration updates.</p>', ], ], 'Outputs' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$Outputs' => '<p>You can configure application output to write data from any of the in-application streams to up to three destinations.</p> <p>These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda destinations, or any combination of the three.</p> <p>In the configuration, you specify the in-application stream name, the destination stream or Lambda function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics can assume to write to the destination stream or Lambda function on your behalf.</p> <p>In the output configuration, you also provide the output stream or Lambda function ARN. For stream destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.</p>', ], ], 'ParsedInputRecord' => [ 'base' => NULL, 'refs' => [ 'ParsedInputRecords$member' => NULL, ], ], 'ParsedInputRecordField' => [ 'base' => NULL, 'refs' => [ 'ParsedInputRecord$member' => NULL, ], ], 'ParsedInputRecords' => [ 'base' => NULL, 'refs' => [ 'DiscoverInputSchemaResponse$ParsedInputRecords' => '<p>An array of elements, where each element corresponds to a row in a stream record (a stream record can have more than one row).</p>', ], ], 'ProcessedInputRecord' => [ 'base' => NULL, 'refs' => [ 'ProcessedInputRecords$member' => NULL, ], ], 'ProcessedInputRecords' => [ 'base' => NULL, 'refs' => [ 'DiscoverInputSchemaResponse$ProcessedInputRecords' => '<p>Stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code> parameter.</p>', 'UnableToDetectSchemaException$ProcessedInputRecords' => NULL, ], ], 'RawInputRecord' => [ 'base' => NULL, 'refs' => [ 'RawInputRecords$member' => NULL, ], ], 'RawInputRecords' => [ 'base' => NULL, 'refs' => [ 'DiscoverInputSchemaResponse$RawInputRecords' => '<p>Raw stream data that was sampled to infer the schema.</p>', 'UnableToDetectSchemaException$RawInputRecords' => NULL, ], ], 'RecordColumn' => [ 'base' => '<p>Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.</p> <p>Also used to describe the format of the reference data source.</p>', 'refs' => [ 'RecordColumns$member' => NULL, ], ], 'RecordColumnDelimiter' => [ 'base' => NULL, 'refs' => [ 'CSVMappingParameters$RecordColumnDelimiter' => '<p>Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.</p>', ], ], 'RecordColumnMapping' => [ 'base' => NULL, 'refs' => [ 'RecordColumn$Mapping' => '<p>Reference to the data element in the streaming input or the reference data source. This element is required if the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel">RecordFormatType</a> is <code>JSON</code>.</p>', ], ], 'RecordColumnName' => [ 'base' => NULL, 'refs' => [ 'RecordColumn$Name' => '<p>Name of the column created in the in-application input stream or reference table.</p>', ], ], 'RecordColumnSqlType' => [ 'base' => NULL, 'refs' => [ 'RecordColumn$SqlType' => '<p>Type of column created in the in-application input stream or reference table.</p>', ], ], 'RecordColumns' => [ 'base' => NULL, 'refs' => [ 'InputSchemaUpdate$RecordColumnUpdates' => '<p>A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source element to the corresponding column in the in-application stream. </p>', 'SourceSchema$RecordColumns' => '<p>A list of <code>RecordColumn</code> objects.</p>', ], ], 'RecordEncoding' => [ 'base' => NULL, 'refs' => [ 'InputSchemaUpdate$RecordEncodingUpdate' => '<p>Specifies the encoding of the records in the streaming source. For example, UTF-8.</p>', 'SourceSchema$RecordEncoding' => '<p>Specifies the encoding of the records in the streaming source. For example, UTF-8.</p>', ], ], 'RecordFormat' => [ 'base' => '<p> Describes the record format and relevant mapping information that should be applied to schematize the records on the stream. </p>', 'refs' => [ 'InputSchemaUpdate$RecordFormatUpdate' => '<p>Specifies the format of the records on the streaming source.</p>', 'SourceSchema$RecordFormat' => '<p>Specifies the format of the records on the streaming source.</p>', ], ], 'RecordFormatType' => [ 'base' => NULL, 'refs' => [ 'DestinationSchema$RecordFormatType' => '<p>Specifies the format of the records on the output stream.</p>', 'RecordFormat$RecordFormatType' => '<p>The type of record format.</p>', ], ], 'RecordRowDelimiter' => [ 'base' => NULL, 'refs' => [ 'CSVMappingParameters$RecordRowDelimiter' => '<p>Row delimiter. For example, in a CSV format, <i>\'\\n\'</i> is the typical row delimiter.</p>', ], ], 'RecordRowPath' => [ 'base' => NULL, 'refs' => [ 'JSONMappingParameters$RecordRowPath' => '<p>Path to the top-level parent that contains the records.</p>', ], ], 'ReferenceDataSource' => [ 'base' => '<p>Describes the reference data source by providing the source information (S3 bucket name and object key name), the resulting in-application table name that is created, and the necessary schema to map the data elements in the Amazon S3 object to the in-application table.</p>', 'refs' => [ 'AddApplicationReferenceDataSourceRequest$ReferenceDataSource' => '<p>The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the object and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and the resulting in-application table that is created. You must also provide an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.</p>', ], ], 'ReferenceDataSourceDescription' => [ 'base' => '<p>Describes the reference data source configured for an application.</p>', 'refs' => [ 'ReferenceDataSourceDescriptions$member' => NULL, ], ], 'ReferenceDataSourceDescriptions' => [ 'base' => NULL, 'refs' => [ 'ApplicationDetail$ReferenceDataSourceDescriptions' => '<p>Describes reference data sources configured for the application. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a>. </p>', ], ], 'ReferenceDataSourceUpdate' => [ 'base' => '<p>When you update a reference data source configuration for an application, this object provides all the updated values (such as the source bucket name and object key name), the in-application table name that is created, and updated mapping information that maps the data in the Amazon S3 object to the in-application reference table that is created.</p>', 'refs' => [ 'ReferenceDataSourceUpdates$member' => NULL, ], ], 'ReferenceDataSourceUpdates' => [ 'base' => NULL, 'refs' => [ 'ApplicationUpdate$ReferenceDataSourceUpdates' => '<p>Describes application reference data source updates.</p>', ], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'ApplicationDetail$ApplicationARN' => '<p>ARN of the application.</p>', 'ApplicationSummary$ApplicationARN' => '<p>ARN of the application.</p>', 'DiscoverInputSchemaRequest$ResourceARN' => '<p>Amazon Resource Name (ARN) of the streaming source.</p>', 'InputLambdaProcessor$ResourceARN' => '<p>The ARN of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that operates on records in the stream.</p> <note> <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a> </p> </note>', 'InputLambdaProcessorDescription$ResourceARN' => '<p>The ARN of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that is used to preprocess the records in the stream.</p>', 'InputLambdaProcessorUpdate$ResourceARNUpdate' => '<p>The Amazon Resource Name (ARN) of the new <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that is used to preprocess the records in the stream.</p> <note> <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a> </p> </note>', 'KinesisFirehoseInput$ResourceARN' => '<p>ARN of the input delivery stream.</p>', 'KinesisFirehoseInputDescription$ResourceARN' => '<p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.</p>', 'KinesisFirehoseInputUpdate$ResourceARNUpdate' => '<p>Amazon Resource Name (ARN) of the input Amazon Kinesis Firehose delivery stream to read.</p>', 'KinesisFirehoseOutput$ResourceARN' => '<p>ARN of the destination Amazon Kinesis Firehose delivery stream to write to.</p>', 'KinesisFirehoseOutputDescription$ResourceARN' => '<p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.</p>', 'KinesisFirehoseOutputUpdate$ResourceARNUpdate' => '<p>Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream to write to.</p>', 'KinesisStreamsInput$ResourceARN' => '<p>ARN of the input Amazon Kinesis stream to read.</p>', 'KinesisStreamsInputDescription$ResourceARN' => '<p>Amazon Resource Name (ARN) of the Amazon Kinesis stream.</p>', 'KinesisStreamsInputUpdate$ResourceARNUpdate' => '<p>Amazon Resource Name (ARN) of the input Amazon Kinesis stream to read.</p>', 'KinesisStreamsOutput$ResourceARN' => '<p>ARN of the destination Amazon Kinesis stream to write to.</p>', 'KinesisStreamsOutputDescription$ResourceARN' => '<p>Amazon Resource Name (ARN) of the Amazon Kinesis stream.</p>', 'KinesisStreamsOutputUpdate$ResourceARNUpdate' => '<p>Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to write the output.</p>', 'LambdaOutput$ResourceARN' => '<p>Amazon Resource Name (ARN) of the destination Lambda function to write to.</p> <note> <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a> </p> </note>', 'LambdaOutputDescription$ResourceARN' => '<p>Amazon Resource Name (ARN) of the destination Lambda function.</p>', 'LambdaOutputUpdate$ResourceARNUpdate' => '<p>Amazon Resource Name (ARN) of the destination Lambda function.</p> <note> <p>To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a> </p> </note>', ], ], 'ResourceInUseException' => [ 'base' => '<p>Application is not available for this operation.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Specified application can\'t be found.</p>', 'refs' => [], ], 'ResourceProvisionedThroughputExceededException' => [ 'base' => '<p>Discovery failed to get a record from the streaming source because of the Amazon Kinesis Streams ProvisionedThroughputExceededException. For more information, see <a href="https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetRecords.html">GetRecords</a> in the Amazon Kinesis Streams API Reference.</p>', 'refs' => [], ], 'RoleARN' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLoggingOption$RoleARN' => '<p>IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy action enabled.</p>', 'CloudWatchLoggingOptionDescription$RoleARN' => '<p>IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.</p>', 'CloudWatchLoggingOptionUpdate$RoleARNUpdate' => '<p>IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.</p>', 'DiscoverInputSchemaRequest$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.</p>', 'InputLambdaProcessor$RoleARN' => '<p>The ARN of the IAM role that is used to access the AWS Lambda function.</p>', 'InputLambdaProcessorDescription$RoleARN' => '<p>The ARN of the IAM role that is used to access the AWS Lambda function.</p>', 'InputLambdaProcessorUpdate$RoleARNUpdate' => '<p>The ARN of the new IAM role that is used to access the AWS Lambda function.</p>', 'KinesisFirehoseInput$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to make sure that the role has the necessary permissions to access the stream.</p>', 'KinesisFirehoseInputDescription$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics assumes to access the stream.</p>', 'KinesisFirehoseInputUpdate$RoleARNUpdate' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>', 'KinesisFirehoseOutput$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your behalf. You need to grant the necessary permissions to this role.</p>', 'KinesisFirehoseOutputDescription$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>', 'KinesisFirehoseOutputUpdate$RoleARNUpdate' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>', 'KinesisStreamsInput$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>', 'KinesisStreamsInputDescription$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>', 'KinesisStreamsInputUpdate$RoleARNUpdate' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>', 'KinesisStreamsOutput$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your behalf. You need to grant the necessary permissions to this role.</p>', 'KinesisStreamsOutputDescription$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream.</p>', 'KinesisStreamsOutputUpdate$RoleARNUpdate' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.</p>', 'LambdaOutput$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function on your behalf. You need to grant the necessary permissions to this role. </p>', 'LambdaOutputDescription$RoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function.</p>', 'LambdaOutputUpdate$RoleARNUpdate' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function on your behalf. You need to grant the necessary permissions to this role. </p>', 'S3Configuration$RoleARN' => '<p>IAM ARN of the role used to access the data.</p>', 'S3ReferenceDataSource$ReferenceRoleARN' => '<p>ARN of the IAM role that the service can assume to read data on your behalf. This role must have permission for the <code>s3:GetObject</code> action on the object and trust policy that allows Amazon Kinesis Analytics service principal to assume this role.</p>', 'S3ReferenceDataSourceDescription$ReferenceRoleARN' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf to populate the in-application reference table.</p>', 'S3ReferenceDataSourceUpdate$ReferenceRoleARNUpdate' => '<p>ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the in-application.</p>', ], ], 'S3Configuration' => [ 'base' => '<p>Provides a description of an Amazon S3 data source, including the Amazon Resource Name (ARN) of the S3 bucket, the ARN of the IAM role that is used to access the bucket, and the name of the Amazon S3 object that contains the data.</p>', 'refs' => [ 'DiscoverInputSchemaRequest$S3Configuration' => '<p>Specify this parameter to discover a schema from data in an Amazon S3 object.</p>', ], ], 'S3ReferenceDataSource' => [ 'base' => '<p>Identifies the S3 bucket and object that contains the reference data. Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf.</p> <p>An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html">UpdateApplication</a> operation to trigger reloading of data into your application.</p>', 'refs' => [ 'ReferenceDataSource$S3ReferenceDataSource' => '<p>Identifies the S3 bucket and object that contains the reference data. Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf. An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the <code>UpdateApplication</code> operation to trigger reloading of data into your application. </p>', ], ], 'S3ReferenceDataSourceDescription' => [ 'base' => '<p>Provides the bucket name and object key name that stores the reference data.</p>', 'refs' => [ 'ReferenceDataSourceDescription$S3ReferenceDataSourceDescription' => '<p>Provides the S3 bucket name, the object key name that contains the reference data. It also provides the Amazon Resource Name (ARN) of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the in-application reference table.</p>', ], ], 'S3ReferenceDataSourceUpdate' => [ 'base' => '<p>Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf and populate the in-application reference table.</p>', 'refs' => [ 'ReferenceDataSourceUpdate$S3ReferenceDataSourceUpdate' => '<p>Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf and populate the in-application reference table.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is unavailable. Back off and retry the operation. </p>', 'refs' => [], ], 'SourceSchema' => [ 'base' => '<p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.</p>', 'refs' => [ 'DiscoverInputSchemaResponse$InputSchema' => '<p>Schema inferred from the streaming source. It identifies the format of the data in the streaming source and how each data element maps to corresponding columns in the in-application stream that you can create.</p>', 'Input$InputSchema' => '<p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.</p> <p>Also used to describe the format of the reference data source.</p>', 'InputDescription$InputSchema' => '<p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created. </p>', 'ReferenceDataSource$ReferenceSchema' => '<p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.</p>', 'ReferenceDataSourceDescription$ReferenceSchema' => '<p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.</p>', 'ReferenceDataSourceUpdate$ReferenceSchemaUpdate' => '<p>Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream. </p>', ], ], 'StartApplicationRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'StartApplicationResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'StopApplicationRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'StopApplicationResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'Tag' => [ 'base' => '<p>A key-value pair (the value is optional) that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the key-value tag.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of keys of tags to remove from the specified application.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the key-value tag. The value is optional.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$Tags' => '<p>A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The key-value tags assigned to the application.</p>', 'TagResourceRequest$Tags' => '<p>The key-value tags to assign to the application.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ApplicationDetail$CreateTimestamp' => '<p>Time stamp when the application version was created.</p>', 'ApplicationDetail$LastUpdateTimestamp' => '<p>Time stamp when the application was last updated.</p>', 'DeleteApplicationRequest$CreateTimestamp' => '<p> You can use the <code>DescribeApplication</code> operation to get this value. </p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>Application created with too many tags, or too many tags added to an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50.</p>', 'refs' => [], ], 'UnableToDetectSchemaException' => [ 'base' => '<p>Data format is not valid. Amazon Kinesis Analytics is not able to detect schema for the given streaming source.</p>', 'refs' => [], ], 'UnsupportedOperationException' => [ 'base' => '<p>The request was rejected because a specified parameter is not supported or a specified resource is not valid for this operation. </p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
